package kms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AdvanceEncrypt invokes the kms.AdvanceEncrypt API synchronously
func (client *Client) AdvanceEncrypt(request *AdvanceEncryptRequest) (response *AdvanceEncryptResponse, err error) {
	response = CreateAdvanceEncryptResponse()
	err = client.DoAction(request, response)
	return
}

// AdvanceEncryptWithChan invokes the kms.AdvanceEncrypt API asynchronously
func (client *Client) AdvanceEncryptWithChan(request *AdvanceEncryptRequest) (<-chan *AdvanceEncryptResponse, <-chan error) {
	responseChan := make(chan *AdvanceEncryptResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AdvanceEncrypt(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AdvanceEncryptWithCallback invokes the kms.AdvanceEncrypt API asynchronously
func (client *Client) AdvanceEncryptWithCallback(request *AdvanceEncryptRequest, callback func(response *AdvanceEncryptResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AdvanceEncryptResponse
		var err error
		defer close(result)
		response, err = client.AdvanceEncrypt(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AdvanceEncryptRequest is the request struct for api AdvanceEncrypt
type AdvanceEncryptRequest struct {
	*requests.RpcRequest
	PaddingMode string `position:"Query" name:"PaddingMode"`
	Aad         string `position:"Query" name:"Aad"`
	KeyId       string `position:"Query" name:"KeyId"`
	Plaintext   string `position:"Query" name:"Plaintext"`
	Iv          string `position:"Query" name:"Iv"`
	Algorithm   string `position:"Query" name:"Algorithm"`
}

// AdvanceEncryptResponse is the response struct for api AdvanceEncrypt
type AdvanceEncryptResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	CiphertextBlob string `json:"CiphertextBlob" xml:"CiphertextBlob"`
	Algorithm      string `json:"Algorithm" xml:"Algorithm"`
	KeyId          string `json:"KeyId" xml:"KeyId"`
	KeyVersionId   string `json:"KeyVersionId" xml:"KeyVersionId"`
	Iv             string `json:"Iv" xml:"Iv"`
	PaddingMode    string `json:"PaddingMode" xml:"PaddingMode"`
}

// CreateAdvanceEncryptRequest creates a request to invoke AdvanceEncrypt API
func CreateAdvanceEncryptRequest() (request *AdvanceEncryptRequest) {
	request = &AdvanceEncryptRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Kms", "2016-01-20", "AdvanceEncrypt", "kms", "openAPI")
	request.Method = requests.POST
	return
}

// CreateAdvanceEncryptResponse creates a response to parse from AdvanceEncrypt response
func CreateAdvanceEncryptResponse() (response *AdvanceEncryptResponse) {
	response = &AdvanceEncryptResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
