package cfclient

// Code generated by go generate. DO NOT EDIT.
// This file was generated by robots at
// 2022-01-11 09:36:11.804559 +1030 ACDT m=+0.186550187

import (
	stderrors "errors"

	pkgerrors "github.com/pkg/errors"
)

// NewInvalidAuthTokenError returns a new CloudFoundryError
// that IsInvalidAuthTokenError will return true for
func NewInvalidAuthTokenError() CloudFoundryError {
	return CloudFoundryError{
		Code:        1000,
		ErrorCode:   "CF-InvalidAuthToken",
		Description: "Invalid Auth Token",
	}
}

// IsInvalidAuthTokenError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 1000
// - HTTP code: 401
// - message: "Invalid Auth Token"
func IsInvalidAuthTokenError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 1000
}

// NewMessageParseError returns a new CloudFoundryError
// that IsMessageParseError will return true for
func NewMessageParseError() CloudFoundryError {
	return CloudFoundryError{
		Code:        1001,
		ErrorCode:   "CF-MessageParseError",
		Description: "Request invalid due to parse error: %s",
	}
}

// IsMessageParseError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 1001
// - HTTP code: 400
// - message: "Request invalid due to parse error: %s"
func IsMessageParseError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 1001
}

// NewInvalidRelationError returns a new CloudFoundryError
// that IsInvalidRelationError will return true for
func NewInvalidRelationError() CloudFoundryError {
	return CloudFoundryError{
		Code:        1002,
		ErrorCode:   "CF-InvalidRelation",
		Description: "%s",
	}
}

// IsInvalidRelationError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 1002
// - HTTP code: 400
// - message: "%s"
func IsInvalidRelationError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 1002
}

// NewInvalidContentTypeError returns a new CloudFoundryError
// that IsInvalidContentTypeError will return true for
func NewInvalidContentTypeError() CloudFoundryError {
	return CloudFoundryError{
		Code:        1003,
		ErrorCode:   "CF-InvalidContentType",
		Description: "Invalid content type, expected: %s",
	}
}

// IsInvalidContentTypeError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 1003
// - HTTP code: 400
// - message: "Invalid content type, expected: %s"
func IsInvalidContentTypeError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 1003
}

// NewBadRequestError returns a new CloudFoundryError
// that IsBadRequestError will return true for
func NewBadRequestError() CloudFoundryError {
	return CloudFoundryError{
		Code:        1004,
		ErrorCode:   "CF-BadRequest",
		Description: "Bad request: %s",
	}
}

// IsBadRequestError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 1004
// - HTTP code: 400
// - message: "Bad request: %s"
func IsBadRequestError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 1004
}

// NewNotFoundError returns a new CloudFoundryError
// that IsNotFoundError will return true for
func NewNotFoundError() CloudFoundryError {
	return CloudFoundryError{
		Code:        10000,
		ErrorCode:   "CF-NotFound",
		Description: "Unknown request",
	}
}

// IsNotFoundError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 10000
// - HTTP code: 404
// - message: "Unknown request"
func IsNotFoundError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 10000
}

// NewServerError returns a new CloudFoundryError
// that IsServerError will return true for
func NewServerError() CloudFoundryError {
	return CloudFoundryError{
		Code:        10001,
		ErrorCode:   "CF-ServerError",
		Description: "Server error",
	}
}

// IsServerError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 10001
// - HTTP code: 500
// - message: "Server error"
func IsServerError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 10001
}

// NewNotAuthenticatedError returns a new CloudFoundryError
// that IsNotAuthenticatedError will return true for
func NewNotAuthenticatedError() CloudFoundryError {
	return CloudFoundryError{
		Code:        10002,
		ErrorCode:   "CF-NotAuthenticated",
		Description: "Authentication error",
	}
}

// IsNotAuthenticatedError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 10002
// - HTTP code: 401
// - message: "Authentication error"
func IsNotAuthenticatedError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 10002
}

// NewNotAuthorizedError returns a new CloudFoundryError
// that IsNotAuthorizedError will return true for
func NewNotAuthorizedError() CloudFoundryError {
	return CloudFoundryError{
		Code:        10003,
		ErrorCode:   "CF-NotAuthorized",
		Description: "You are not authorized to perform the requested action",
	}
}

// IsNotAuthorizedError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 10003
// - HTTP code: 403
// - message: "You are not authorized to perform the requested action"
func IsNotAuthorizedError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 10003
}

// NewInvalidRequestError returns a new CloudFoundryError
// that IsInvalidRequestError will return true for
func NewInvalidRequestError() CloudFoundryError {
	return CloudFoundryError{
		Code:        10004,
		ErrorCode:   "CF-InvalidRequest",
		Description: "The request is invalid",
	}
}

// IsInvalidRequestError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 10004
// - HTTP code: 400
// - message: "The request is invalid"
func IsInvalidRequestError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 10004
}

// NewBadQueryParameterError returns a new CloudFoundryError
// that IsBadQueryParameterError will return true for
func NewBadQueryParameterError() CloudFoundryError {
	return CloudFoundryError{
		Code:        10005,
		ErrorCode:   "CF-BadQueryParameter",
		Description: "The query parameter is invalid: %s",
	}
}

// IsBadQueryParameterError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 10005
// - HTTP code: 400
// - message: "The query parameter is invalid: %s"
func IsBadQueryParameterError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 10005
}

// NewAssociationNotEmptyError returns a new CloudFoundryError
// that IsAssociationNotEmptyError will return true for
func NewAssociationNotEmptyError() CloudFoundryError {
	return CloudFoundryError{
		Code:        10006,
		ErrorCode:   "CF-AssociationNotEmpty",
		Description: "Please delete the %s associations for your %s.",
	}
}

// IsAssociationNotEmptyError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 10006
// - HTTP code: 400
// - message: "Please delete the %s associations for your %s."
func IsAssociationNotEmptyError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 10006
}

// NewInsufficientScopeError returns a new CloudFoundryError
// that IsInsufficientScopeError will return true for
func NewInsufficientScopeError() CloudFoundryError {
	return CloudFoundryError{
		Code:        10007,
		ErrorCode:   "CF-InsufficientScope",
		Description: "Your token lacks the necessary scopes to access this resource.",
	}
}

// IsInsufficientScopeError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 10007
// - HTTP code: 403
// - message: "Your token lacks the necessary scopes to access this resource."
func IsInsufficientScopeError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 10007
}

// NewUnprocessableEntityError returns a new CloudFoundryError
// that IsUnprocessableEntityError will return true for
func NewUnprocessableEntityError() CloudFoundryError {
	return CloudFoundryError{
		Code:        10008,
		ErrorCode:   "CF-UnprocessableEntity",
		Description: "%s",
	}
}

// IsUnprocessableEntityError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 10008
// - HTTP code: 422
// - message: "%s"
func IsUnprocessableEntityError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 10008
}

// NewUnableToPerformError returns a new CloudFoundryError
// that IsUnableToPerformError will return true for
func NewUnableToPerformError() CloudFoundryError {
	return CloudFoundryError{
		Code:        10009,
		ErrorCode:   "CF-UnableToPerform",
		Description: "%s could not be completed: %s",
	}
}

// IsUnableToPerformError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 10009
// - HTTP code: 400
// - message: "%s could not be completed: %s"
func IsUnableToPerformError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 10009
}

// NewResourceNotFoundError returns a new CloudFoundryError
// that IsResourceNotFoundError will return true for
func NewResourceNotFoundError() CloudFoundryError {
	return CloudFoundryError{
		Code:        10010,
		ErrorCode:   "CF-ResourceNotFound",
		Description: "%s",
	}
}

// IsResourceNotFoundError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 10010
// - HTTP code: 404
// - message: "%s"
func IsResourceNotFoundError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 10010
}

// NewDatabaseError returns a new CloudFoundryError
// that IsDatabaseError will return true for
func NewDatabaseError() CloudFoundryError {
	return CloudFoundryError{
		Code:        10011,
		ErrorCode:   "CF-DatabaseError",
		Description: "Database error",
	}
}

// IsDatabaseError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 10011
// - HTTP code: 500
// - message: "Database error"
func IsDatabaseError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 10011
}

// NewOrderByParameterInvalidError returns a new CloudFoundryError
// that IsOrderByParameterInvalidError will return true for
func NewOrderByParameterInvalidError() CloudFoundryError {
	return CloudFoundryError{
		Code:        10012,
		ErrorCode:   "CF-OrderByParameterInvalid",
		Description: "Cannot order by: %s",
	}
}

// IsOrderByParameterInvalidError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 10012
// - HTTP code: 500
// - message: "Cannot order by: %s"
func IsOrderByParameterInvalidError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 10012
}

// NewRateLimitExceededError returns a new CloudFoundryError
// that IsRateLimitExceededError will return true for
func NewRateLimitExceededError() CloudFoundryError {
	return CloudFoundryError{
		Code:        10013,
		ErrorCode:   "CF-RateLimitExceeded",
		Description: "Rate Limit Exceeded",
	}
}

// IsRateLimitExceededError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 10013
// - HTTP code: 429
// - message: "Rate Limit Exceeded"
func IsRateLimitExceededError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 10013
}

// NewIPBasedRateLimitExceededError returns a new CloudFoundryError
// that IsIPBasedRateLimitExceededError will return true for
func NewIPBasedRateLimitExceededError() CloudFoundryError {
	return CloudFoundryError{
		Code:        10014,
		ErrorCode:   "CF-IPBasedRateLimitExceeded",
		Description: "Rate Limit Exceeded: Unauthenticated requests from this IP address have exceeded the limit. Please log in.",
	}
}

// IsIPBasedRateLimitExceededError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 10014
// - HTTP code: 429
// - message: "Rate Limit Exceeded: Unauthenticated requests from this IP address have exceeded the limit. Please log in."
func IsIPBasedRateLimitExceededError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 10014
}

// NewServiceUnavailableError returns a new CloudFoundryError
// that IsServiceUnavailableError will return true for
func NewServiceUnavailableError() CloudFoundryError {
	return CloudFoundryError{
		Code:        10015,
		ErrorCode:   "CF-ServiceUnavailable",
		Description: "%s",
	}
}

// IsServiceUnavailableError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 10015
// - HTTP code: 503
// - message: "%s"
func IsServiceUnavailableError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 10015
}

// NewServiceBrokerRateLimitExceededError returns a new CloudFoundryError
// that IsServiceBrokerRateLimitExceededError will return true for
func NewServiceBrokerRateLimitExceededError() CloudFoundryError {
	return CloudFoundryError{
		Code:        10016,
		ErrorCode:   "CF-ServiceBrokerRateLimitExceeded",
		Description: "Service broker concurrent request limit exceeded",
	}
}

// IsServiceBrokerRateLimitExceededError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 10016
// - HTTP code: 429
// - message: "Service broker concurrent request limit exceeded"
func IsServiceBrokerRateLimitExceededError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 10016
}

// NewUserInvalidError returns a new CloudFoundryError
// that IsUserInvalidError will return true for
func NewUserInvalidError() CloudFoundryError {
	return CloudFoundryError{
		Code:        20001,
		ErrorCode:   "CF-UserInvalid",
		Description: "The user info is invalid: %s",
	}
}

// IsUserInvalidError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 20001
// - HTTP code: 400
// - message: "The user info is invalid: %s"
func IsUserInvalidError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 20001
}

// NewUaaIdTakenError returns a new CloudFoundryError
// that IsUaaIdTakenError will return true for
func NewUaaIdTakenError() CloudFoundryError {
	return CloudFoundryError{
		Code:        20002,
		ErrorCode:   "CF-UaaIdTaken",
		Description: "The UAA ID is taken: %s",
	}
}

// IsUaaIdTakenError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 20002
// - HTTP code: 400
// - message: "The UAA ID is taken: %s"
func IsUaaIdTakenError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 20002
}

// NewUserNotFoundError returns a new CloudFoundryError
// that IsUserNotFoundError will return true for
func NewUserNotFoundError() CloudFoundryError {
	return CloudFoundryError{
		Code:        20003,
		ErrorCode:   "CF-UserNotFound",
		Description: "The user could not be found: %s",
	}
}

// IsUserNotFoundError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 20003
// - HTTP code: 404
// - message: "The user could not be found: %s"
func IsUserNotFoundError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 20003
}

// NewUaaUnavailableError returns a new CloudFoundryError
// that IsUaaUnavailableError will return true for
func NewUaaUnavailableError() CloudFoundryError {
	return CloudFoundryError{
		Code:        20004,
		ErrorCode:   "CF-UaaUnavailable",
		Description: "The UAA service is currently unavailable",
	}
}

// IsUaaUnavailableError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 20004
// - HTTP code: 503
// - message: "The UAA service is currently unavailable"
func IsUaaUnavailableError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 20004
}

// NewUaaEndpointDisabledError returns a new CloudFoundryError
// that IsUaaEndpointDisabledError will return true for
func NewUaaEndpointDisabledError() CloudFoundryError {
	return CloudFoundryError{
		Code:        20005,
		ErrorCode:   "CF-UaaEndpointDisabled",
		Description: "The UAA endpoint needed is disabled",
	}
}

// IsUaaEndpointDisabledError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 20005
// - HTTP code: 501
// - message: "The UAA endpoint needed is disabled"
func IsUaaEndpointDisabledError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 20005
}

// NewUserIsInMultipleOriginsError returns a new CloudFoundryError
// that IsUserIsInMultipleOriginsError will return true for
func NewUserIsInMultipleOriginsError() CloudFoundryError {
	return CloudFoundryError{
		Code:        20006,
		ErrorCode:   "CF-UserIsInMultipleOrigins",
		Description: "The user exists in multiple origins. Specify an origin for the requested user from: %s",
	}
}

// IsUserIsInMultipleOriginsError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 20006
// - HTTP code: 400
// - message: "The user exists in multiple origins. Specify an origin for the requested user from: %s"
func IsUserIsInMultipleOriginsError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 20006
}

// NewUserWithOriginNotFoundError returns a new CloudFoundryError
// that IsUserWithOriginNotFoundError will return true for
func NewUserWithOriginNotFoundError() CloudFoundryError {
	return CloudFoundryError{
		Code:        20007,
		ErrorCode:   "CF-UserWithOriginNotFound",
		Description: "The user could not be found, %s",
	}
}

// IsUserWithOriginNotFoundError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 20007
// - HTTP code: 404
// - message: "The user could not be found, %s"
func IsUserWithOriginNotFoundError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 20007
}

// NewOutOfRouterGroupPortsError returns a new CloudFoundryError
// that IsOutOfRouterGroupPortsError will return true for
func NewOutOfRouterGroupPortsError() CloudFoundryError {
	return CloudFoundryError{
		Code:        21008,
		ErrorCode:   "CF-OutOfRouterGroupPorts",
		Description: "There are no more ports available for router group: %s. Please contact your administrator for more information.",
	}
}

// IsOutOfRouterGroupPortsError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 21008
// - HTTP code: 403
// - message: "There are no more ports available for router group: %s. Please contact your administrator for more information."
func IsOutOfRouterGroupPortsError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 21008
}

// NewOrganizationInvalidError returns a new CloudFoundryError
// that IsOrganizationInvalidError will return true for
func NewOrganizationInvalidError() CloudFoundryError {
	return CloudFoundryError{
		Code:        30001,
		ErrorCode:   "CF-OrganizationInvalid",
		Description: "The organization info is invalid: %s",
	}
}

// IsOrganizationInvalidError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 30001
// - HTTP code: 400
// - message: "The organization info is invalid: %s"
func IsOrganizationInvalidError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 30001
}

// NewOrganizationNameTakenError returns a new CloudFoundryError
// that IsOrganizationNameTakenError will return true for
func NewOrganizationNameTakenError() CloudFoundryError {
	return CloudFoundryError{
		Code:        30002,
		ErrorCode:   "CF-OrganizationNameTaken",
		Description: "The organization name is taken: %s",
	}
}

// IsOrganizationNameTakenError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 30002
// - HTTP code: 400
// - message: "The organization name is taken: %s"
func IsOrganizationNameTakenError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 30002
}

// NewOrganizationNotFoundError returns a new CloudFoundryError
// that IsOrganizationNotFoundError will return true for
func NewOrganizationNotFoundError() CloudFoundryError {
	return CloudFoundryError{
		Code:        30003,
		ErrorCode:   "CF-OrganizationNotFound",
		Description: "The organization could not be found: %s",
	}
}

// IsOrganizationNotFoundError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 30003
// - HTTP code: 404
// - message: "The organization could not be found: %s"
func IsOrganizationNotFoundError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 30003
}

// NewLastManagerInOrgError returns a new CloudFoundryError
// that IsLastManagerInOrgError will return true for
func NewLastManagerInOrgError() CloudFoundryError {
	return CloudFoundryError{
		Code:        30004,
		ErrorCode:   "CF-LastManagerInOrg",
		Description: "Cannot remove last Org Manager in org",
	}
}

// IsLastManagerInOrgError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 30004
// - HTTP code: 403
// - message: "Cannot remove last Org Manager in org"
func IsLastManagerInOrgError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 30004
}

// NewLastBillingManagerInOrgError returns a new CloudFoundryError
// that IsLastBillingManagerInOrgError will return true for
func NewLastBillingManagerInOrgError() CloudFoundryError {
	return CloudFoundryError{
		Code:        30005,
		ErrorCode:   "CF-LastBillingManagerInOrg",
		Description: "Cannot remove last Billing Manager in org",
	}
}

// IsLastBillingManagerInOrgError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 30005
// - HTTP code: 403
// - message: "Cannot remove last Billing Manager in org"
func IsLastBillingManagerInOrgError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 30005
}

// NewLastUserInOrgError returns a new CloudFoundryError
// that IsLastUserInOrgError will return true for
func NewLastUserInOrgError() CloudFoundryError {
	return CloudFoundryError{
		Code:        30006,
		ErrorCode:   "CF-LastUserInOrg",
		Description: "Cannot remove last User in org",
	}
}

// IsLastUserInOrgError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 30006
// - HTTP code: 403
// - message: "Cannot remove last User in org"
func IsLastUserInOrgError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 30006
}

// NewOrganizationAlreadySetError returns a new CloudFoundryError
// that IsOrganizationAlreadySetError will return true for
func NewOrganizationAlreadySetError() CloudFoundryError {
	return CloudFoundryError{
		Code:        30007,
		ErrorCode:   "CF-OrganizationAlreadySet",
		Description: "Cannot change organization",
	}
}

// IsOrganizationAlreadySetError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 30007
// - HTTP code: 400
// - message: "Cannot change organization"
func IsOrganizationAlreadySetError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 30007
}

// NewSpaceInvalidError returns a new CloudFoundryError
// that IsSpaceInvalidError will return true for
func NewSpaceInvalidError() CloudFoundryError {
	return CloudFoundryError{
		Code:        40001,
		ErrorCode:   "CF-SpaceInvalid",
		Description: "The app space info is invalid: %s",
	}
}

// IsSpaceInvalidError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 40001
// - HTTP code: 400
// - message: "The app space info is invalid: %s"
func IsSpaceInvalidError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 40001
}

// NewSpaceNameTakenError returns a new CloudFoundryError
// that IsSpaceNameTakenError will return true for
func NewSpaceNameTakenError() CloudFoundryError {
	return CloudFoundryError{
		Code:        40002,
		ErrorCode:   "CF-SpaceNameTaken",
		Description: "The app space name is taken: %s",
	}
}

// IsSpaceNameTakenError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 40002
// - HTTP code: 400
// - message: "The app space name is taken: %s"
func IsSpaceNameTakenError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 40002
}

// NewSpaceUserNotInOrgError returns a new CloudFoundryError
// that IsSpaceUserNotInOrgError will return true for
func NewSpaceUserNotInOrgError() CloudFoundryError {
	return CloudFoundryError{
		Code:        40003,
		ErrorCode:   "CF-SpaceUserNotInOrg",
		Description: "The app space and the user are not in the same org: %s",
	}
}

// IsSpaceUserNotInOrgError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 40003
// - HTTP code: 400
// - message: "The app space and the user are not in the same org: %s"
func IsSpaceUserNotInOrgError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 40003
}

// NewSpaceNotFoundError returns a new CloudFoundryError
// that IsSpaceNotFoundError will return true for
func NewSpaceNotFoundError() CloudFoundryError {
	return CloudFoundryError{
		Code:        40004,
		ErrorCode:   "CF-SpaceNotFound",
		Description: "The app space could not be found: %s",
	}
}

// IsSpaceNotFoundError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 40004
// - HTTP code: 404
// - message: "The app space could not be found: %s"
func IsSpaceNotFoundError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 40004
}

// NewServiceInstanceNameEmptyError returns a new CloudFoundryError
// that IsServiceInstanceNameEmptyError will return true for
func NewServiceInstanceNameEmptyError() CloudFoundryError {
	return CloudFoundryError{
		Code:        60001,
		ErrorCode:   "CF-ServiceInstanceNameEmpty",
		Description: "Service instance name is required.",
	}
}

// IsServiceInstanceNameEmptyError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 60001
// - HTTP code: 400
// - message: "Service instance name is required."
func IsServiceInstanceNameEmptyError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 60001
}

// NewServiceInstanceNameTakenError returns a new CloudFoundryError
// that IsServiceInstanceNameTakenError will return true for
func NewServiceInstanceNameTakenError() CloudFoundryError {
	return CloudFoundryError{
		Code:        60002,
		ErrorCode:   "CF-ServiceInstanceNameTaken",
		Description: "The service instance name is taken: %s",
	}
}

// IsServiceInstanceNameTakenError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 60002
// - HTTP code: 400
// - message: "The service instance name is taken: %s"
func IsServiceInstanceNameTakenError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 60002
}

// NewServiceInstanceInvalidError returns a new CloudFoundryError
// that IsServiceInstanceInvalidError will return true for
func NewServiceInstanceInvalidError() CloudFoundryError {
	return CloudFoundryError{
		Code:        60003,
		ErrorCode:   "CF-ServiceInstanceInvalid",
		Description: "The service instance is invalid: %s",
	}
}

// IsServiceInstanceInvalidError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 60003
// - HTTP code: 400
// - message: "The service instance is invalid: %s"
func IsServiceInstanceInvalidError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 60003
}

// NewServiceInstanceNotFoundError returns a new CloudFoundryError
// that IsServiceInstanceNotFoundError will return true for
func NewServiceInstanceNotFoundError() CloudFoundryError {
	return CloudFoundryError{
		Code:        60004,
		ErrorCode:   "CF-ServiceInstanceNotFound",
		Description: "The service instance could not be found: %s",
	}
}

// IsServiceInstanceNotFoundError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 60004
// - HTTP code: 404
// - message: "The service instance could not be found: %s"
func IsServiceInstanceNotFoundError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 60004
}

// NewServiceInstanceQuotaExceededError returns a new CloudFoundryError
// that IsServiceInstanceQuotaExceededError will return true for
func NewServiceInstanceQuotaExceededError() CloudFoundryError {
	return CloudFoundryError{
		Code:        60005,
		ErrorCode:   "CF-ServiceInstanceQuotaExceeded",
		Description: "You have exceeded your organization's services limit.",
	}
}

// IsServiceInstanceQuotaExceededError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 60005
// - HTTP code: 400
// - message: "You have exceeded your organization's services limit."
func IsServiceInstanceQuotaExceededError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 60005
}

// NewPreviouslyUsedAs_ServiceInstancePaidQuotaExceededError returns a new CloudFoundryError
// that IsPreviouslyUsedAs_ServiceInstancePaidQuotaExceededError will return true for
func NewPreviouslyUsedAs_ServiceInstancePaidQuotaExceededError() CloudFoundryError {
	return CloudFoundryError{
		Code:        60006,
		ErrorCode:   "CF-PreviouslyUsedAs_ServiceInstancePaidQuotaExceeded",
		Description: "You have exceeded your organization's services limit.",
	}
}

// IsPreviouslyUsedAs_ServiceInstancePaidQuotaExceededError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 60006
// - HTTP code: 400
// - message: "You have exceeded your organization's services limit."
func IsPreviouslyUsedAs_ServiceInstancePaidQuotaExceededError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 60006
}

// NewServiceInstanceServicePlanNotAllowedError returns a new CloudFoundryError
// that IsServiceInstanceServicePlanNotAllowedError will return true for
func NewServiceInstanceServicePlanNotAllowedError() CloudFoundryError {
	return CloudFoundryError{
		Code:        60007,
		ErrorCode:   "CF-ServiceInstanceServicePlanNotAllowed",
		Description: "The service instance cannot be created because paid service plans are not allowed.",
	}
}

// IsServiceInstanceServicePlanNotAllowedError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 60007
// - HTTP code: 400
// - message: "The service instance cannot be created because paid service plans are not allowed."
func IsServiceInstanceServicePlanNotAllowedError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 60007
}

// NewServiceInstanceDuplicateNotAllowedError returns a new CloudFoundryError
// that IsServiceInstanceDuplicateNotAllowedError will return true for
func NewServiceInstanceDuplicateNotAllowedError() CloudFoundryError {
	return CloudFoundryError{
		Code:        60008,
		ErrorCode:   "CF-ServiceInstanceDuplicateNotAllowed",
		Description: "An instance of this service is already present in this space. Some services only support one instance per space.",
	}
}

// IsServiceInstanceDuplicateNotAllowedError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 60008
// - HTTP code: 400
// - message: "An instance of this service is already present in this space. Some services only support one instance per space."
func IsServiceInstanceDuplicateNotAllowedError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 60008
}

// NewServiceInstanceNameTooLongError returns a new CloudFoundryError
// that IsServiceInstanceNameTooLongError will return true for
func NewServiceInstanceNameTooLongError() CloudFoundryError {
	return CloudFoundryError{
		Code:        60009,
		ErrorCode:   "CF-ServiceInstanceNameTooLong",
		Description: "You have requested an invalid service instance name. Names are limited to 255 characters.",
	}
}

// IsServiceInstanceNameTooLongError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 60009
// - HTTP code: 400
// - message: "You have requested an invalid service instance name. Names are limited to 255 characters."
func IsServiceInstanceNameTooLongError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 60009
}

// NewServiceInstanceOrganizationNotAuthorizedError returns a new CloudFoundryError
// that IsServiceInstanceOrganizationNotAuthorizedError will return true for
func NewServiceInstanceOrganizationNotAuthorizedError() CloudFoundryError {
	return CloudFoundryError{
		Code:        60010,
		ErrorCode:   "CF-ServiceInstanceOrganizationNotAuthorized",
		Description: "A service instance for the selected plan cannot be created in this organization. The plan is visible because another organization you belong to has access to it.",
	}
}

// IsServiceInstanceOrganizationNotAuthorizedError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 60010
// - HTTP code: 403
// - message: "A service instance for the selected plan cannot be created in this organization. The plan is visible because another organization you belong to has access to it."
func IsServiceInstanceOrganizationNotAuthorizedError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 60010
}

// NewServiceInstanceDeprovisionFailedError returns a new CloudFoundryError
// that IsServiceInstanceDeprovisionFailedError will return true for
func NewServiceInstanceDeprovisionFailedError() CloudFoundryError {
	return CloudFoundryError{
		Code:        60011,
		ErrorCode:   "CF-ServiceInstanceDeprovisionFailed",
		Description: "The service broker reported an error during deprovisioning: %s",
	}
}

// IsServiceInstanceDeprovisionFailedError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 60011
// - HTTP code: 409
// - message: "The service broker reported an error during deprovisioning: %s"
func IsServiceInstanceDeprovisionFailedError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 60011
}

// NewServiceInstanceSpaceQuotaExceededError returns a new CloudFoundryError
// that IsServiceInstanceSpaceQuotaExceededError will return true for
func NewServiceInstanceSpaceQuotaExceededError() CloudFoundryError {
	return CloudFoundryError{
		Code:        60012,
		ErrorCode:   "CF-ServiceInstanceSpaceQuotaExceeded",
		Description: "You have exceeded your space's services limit.",
	}
}

// IsServiceInstanceSpaceQuotaExceededError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 60012
// - HTTP code: 400
// - message: "You have exceeded your space's services limit."
func IsServiceInstanceSpaceQuotaExceededError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 60012
}

// NewServiceInstanceServicePlanNotAllowedBySpaceQuotaError returns a new CloudFoundryError
// that IsServiceInstanceServicePlanNotAllowedBySpaceQuotaError will return true for
func NewServiceInstanceServicePlanNotAllowedBySpaceQuotaError() CloudFoundryError {
	return CloudFoundryError{
		Code:        60013,
		ErrorCode:   "CF-ServiceInstanceServicePlanNotAllowedBySpaceQuota",
		Description: "The service instance cannot be created because paid service plans are not allowed for your space.",
	}
}

// IsServiceInstanceServicePlanNotAllowedBySpaceQuotaError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 60013
// - HTTP code: 400
// - message: "The service instance cannot be created because paid service plans are not allowed for your space."
func IsServiceInstanceServicePlanNotAllowedBySpaceQuotaError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 60013
}

// NewServiceInstanceSpaceChangeNotAllowedError returns a new CloudFoundryError
// that IsServiceInstanceSpaceChangeNotAllowedError will return true for
func NewServiceInstanceSpaceChangeNotAllowedError() CloudFoundryError {
	return CloudFoundryError{
		Code:        60014,
		ErrorCode:   "CF-ServiceInstanceSpaceChangeNotAllowed",
		Description: "Cannot update space for service instance.",
	}
}

// IsServiceInstanceSpaceChangeNotAllowedError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 60014
// - HTTP code: 400
// - message: "Cannot update space for service instance."
func IsServiceInstanceSpaceChangeNotAllowedError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 60014
}

// NewServiceInstanceTagsTooLongError returns a new CloudFoundryError
// that IsServiceInstanceTagsTooLongError will return true for
func NewServiceInstanceTagsTooLongError() CloudFoundryError {
	return CloudFoundryError{
		Code:        60015,
		ErrorCode:   "CF-ServiceInstanceTagsTooLong",
		Description: "Combined length of tags for service %s must be 2048 characters or less.",
	}
}

// IsServiceInstanceTagsTooLongError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 60015
// - HTTP code: 400
// - message: "Combined length of tags for service %s must be 2048 characters or less."
func IsServiceInstanceTagsTooLongError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 60015
}

// NewAsyncServiceInstanceOperationInProgressError returns a new CloudFoundryError
// that IsAsyncServiceInstanceOperationInProgressError will return true for
func NewAsyncServiceInstanceOperationInProgressError() CloudFoundryError {
	return CloudFoundryError{
		Code:        60016,
		ErrorCode:   "CF-AsyncServiceInstanceOperationInProgress",
		Description: "An operation for service instance %s is in progress.",
	}
}

// IsAsyncServiceInstanceOperationInProgressError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 60016
// - HTTP code: 409
// - message: "An operation for service instance %s is in progress."
func IsAsyncServiceInstanceOperationInProgressError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 60016
}

// NewServiceInstanceRouteBindingSpaceMismatchError returns a new CloudFoundryError
// that IsServiceInstanceRouteBindingSpaceMismatchError will return true for
func NewServiceInstanceRouteBindingSpaceMismatchError() CloudFoundryError {
	return CloudFoundryError{
		Code:        60017,
		ErrorCode:   "CF-ServiceInstanceRouteBindingSpaceMismatch",
		Description: "The service instance and the route are in different spaces.",
	}
}

// IsServiceInstanceRouteBindingSpaceMismatchError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 60017
// - HTTP code: 400
// - message: "The service instance and the route are in different spaces."
func IsServiceInstanceRouteBindingSpaceMismatchError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 60017
}

// NewServiceInstanceSpaceNotAuthorizedError returns a new CloudFoundryError
// that IsServiceInstanceSpaceNotAuthorizedError will return true for
func NewServiceInstanceSpaceNotAuthorizedError() CloudFoundryError {
	return CloudFoundryError{
		Code:        60018,
		ErrorCode:   "CF-ServiceInstanceSpaceNotAuthorized",
		Description: "A service instance for the selected plan cannot be created in this space.",
	}
}

// IsServiceInstanceSpaceNotAuthorizedError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 60018
// - HTTP code: 403
// - message: "A service instance for the selected plan cannot be created in this space."
func IsServiceInstanceSpaceNotAuthorizedError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 60018
}

// NewServiceInstanceRouteServiceURLInvalidError returns a new CloudFoundryError
// that IsServiceInstanceRouteServiceURLInvalidError will return true for
func NewServiceInstanceRouteServiceURLInvalidError() CloudFoundryError {
	return CloudFoundryError{
		Code:        60019,
		ErrorCode:   "CF-ServiceInstanceRouteServiceURLInvalid",
		Description: "The route service URL is invalid: %s",
	}
}

// IsServiceInstanceRouteServiceURLInvalidError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 60019
// - HTTP code: 400
// - message: "The route service URL is invalid: %s"
func IsServiceInstanceRouteServiceURLInvalidError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 60019
}

// NewServiceInstanceRouteServiceRequiresDiegoError returns a new CloudFoundryError
// that IsServiceInstanceRouteServiceRequiresDiegoError will return true for
func NewServiceInstanceRouteServiceRequiresDiegoError() CloudFoundryError {
	return CloudFoundryError{
		Code:        60020,
		ErrorCode:   "CF-ServiceInstanceRouteServiceRequiresDiego",
		Description: "Route services are only supported for apps on Diego. Unbind the service instance from the route or enable Diego for the app.",
	}
}

// IsServiceInstanceRouteServiceRequiresDiegoError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 60020
// - HTTP code: 400
// - message: "Route services are only supported for apps on Diego. Unbind the service instance from the route or enable Diego for the app."
func IsServiceInstanceRouteServiceRequiresDiegoError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 60020
}

// NewServiceInstanceRouteServiceDisabledError returns a new CloudFoundryError
// that IsServiceInstanceRouteServiceDisabledError will return true for
func NewServiceInstanceRouteServiceDisabledError() CloudFoundryError {
	return CloudFoundryError{
		Code:        60021,
		ErrorCode:   "CF-ServiceInstanceRouteServiceDisabled",
		Description: "Support for route services is disabled",
	}
}

// IsServiceInstanceRouteServiceDisabledError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 60021
// - HTTP code: 403
// - message: "Support for route services is disabled"
func IsServiceInstanceRouteServiceDisabledError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 60021
}

// NewAppPortMappingRequiresDiegoError returns a new CloudFoundryError
// that IsAppPortMappingRequiresDiegoError will return true for
func NewAppPortMappingRequiresDiegoError() CloudFoundryError {
	return CloudFoundryError{
		Code:        60022,
		ErrorCode:   "CF-AppPortMappingRequiresDiego",
		Description: "App ports are supported for Diego apps only.",
	}
}

// IsAppPortMappingRequiresDiegoError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 60022
// - HTTP code: 400
// - message: "App ports are supported for Diego apps only."
func IsAppPortMappingRequiresDiegoError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 60022
}

// NewRoutePortNotEnabledOnAppError returns a new CloudFoundryError
// that IsRoutePortNotEnabledOnAppError will return true for
func NewRoutePortNotEnabledOnAppError() CloudFoundryError {
	return CloudFoundryError{
		Code:        60023,
		ErrorCode:   "CF-RoutePortNotEnabledOnApp",
		Description: "Routes can only be mapped to ports already enabled for the application.",
	}
}

// IsRoutePortNotEnabledOnAppError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 60023
// - HTTP code: 400
// - message: "Routes can only be mapped to ports already enabled for the application."
func IsRoutePortNotEnabledOnAppError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 60023
}

// NewMultipleAppPortsMappedDiegoToDeaError returns a new CloudFoundryError
// that IsMultipleAppPortsMappedDiegoToDeaError will return true for
func NewMultipleAppPortsMappedDiegoToDeaError() CloudFoundryError {
	return CloudFoundryError{
		Code:        60024,
		ErrorCode:   "CF-MultipleAppPortsMappedDiegoToDea",
		Description: "The app has routes mapped to multiple ports. Multiple ports are supported for Diego only. Please unmap routes from all but one app port. Multiple routes can be mapped to the same port if desired.",
	}
}

// IsMultipleAppPortsMappedDiegoToDeaError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 60024
// - HTTP code: 400
// - message: "The app has routes mapped to multiple ports. Multiple ports are supported for Diego only. Please unmap routes from all but one app port. Multiple routes can be mapped to the same port if desired."
func IsMultipleAppPortsMappedDiegoToDeaError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 60024
}

// NewVolumeMountServiceDisabledError returns a new CloudFoundryError
// that IsVolumeMountServiceDisabledError will return true for
func NewVolumeMountServiceDisabledError() CloudFoundryError {
	return CloudFoundryError{
		Code:        60025,
		ErrorCode:   "CF-VolumeMountServiceDisabled",
		Description: "Support for volume mount services is disabled",
	}
}

// IsVolumeMountServiceDisabledError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 60025
// - HTTP code: 403
// - message: "Support for volume mount services is disabled"
func IsVolumeMountServiceDisabledError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 60025
}

// NewDockerAppToDeaError returns a new CloudFoundryError
// that IsDockerAppToDeaError will return true for
func NewDockerAppToDeaError() CloudFoundryError {
	return CloudFoundryError{
		Code:        60026,
		ErrorCode:   "CF-DockerAppToDea",
		Description: "Docker apps cannot run on DEAs",
	}
}

// IsDockerAppToDeaError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 60026
// - HTTP code: 400
// - message: "Docker apps cannot run on DEAs"
func IsDockerAppToDeaError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 60026
}

// NewServiceInstanceRecursiveDeleteFailedError returns a new CloudFoundryError
// that IsServiceInstanceRecursiveDeleteFailedError will return true for
func NewServiceInstanceRecursiveDeleteFailedError() CloudFoundryError {
	return CloudFoundryError{
		Code:        60027,
		ErrorCode:   "CF-ServiceInstanceRecursiveDeleteFailed",
		Description: "Deletion of service instance %s failed because one or more associated resources could not be deleted.%s",
	}
}

// IsServiceInstanceRecursiveDeleteFailedError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 60027
// - HTTP code: 502
// - message: "Deletion of service instance %s failed because one or more associated resources could not be deleted.\n\n%s"
func IsServiceInstanceRecursiveDeleteFailedError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 60027
}

// NewManagedServiceInstanceNotFoundError returns a new CloudFoundryError
// that IsManagedServiceInstanceNotFoundError will return true for
func NewManagedServiceInstanceNotFoundError() CloudFoundryError {
	return CloudFoundryError{
		Code:        60028,
		ErrorCode:   "CF-ManagedServiceInstanceNotFound",
		Description: "The service instance could not be found: %s",
	}
}

// IsManagedServiceInstanceNotFoundError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 60028
// - HTTP code: 404
// - message: "The service instance could not be found: %s"
func IsManagedServiceInstanceNotFoundError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 60028
}

// NewServiceInstanceWithInaccessiblePlanNotUpdateableError returns a new CloudFoundryError
// that IsServiceInstanceWithInaccessiblePlanNotUpdateableError will return true for
func NewServiceInstanceWithInaccessiblePlanNotUpdateableError() CloudFoundryError {
	return CloudFoundryError{
		Code:        60029,
		ErrorCode:   "CF-ServiceInstanceWithInaccessiblePlanNotUpdateable",
		Description: "Cannot update %s of a service instance that belongs to inaccessible plan",
	}
}

// IsServiceInstanceWithInaccessiblePlanNotUpdateableError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 60029
// - HTTP code: 403
// - message: "Cannot update %s of a service instance that belongs to inaccessible plan"
func IsServiceInstanceWithInaccessiblePlanNotUpdateableError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 60029
}

// NewServiceInstanceProvisionFailedError returns a new CloudFoundryError
// that IsServiceInstanceProvisionFailedError will return true for
func NewServiceInstanceProvisionFailedError() CloudFoundryError {
	return CloudFoundryError{
		Code:        60030,
		ErrorCode:   "CF-ServiceInstanceProvisionFailed",
		Description: "The service broker reported an error during provisioning: %s",
	}
}

// IsServiceInstanceProvisionFailedError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 60030
// - HTTP code: 400
// - message: "The service broker reported an error during provisioning: %s"
func IsServiceInstanceProvisionFailedError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 60030
}

// NewRuntimeInvalidError returns a new CloudFoundryError
// that IsRuntimeInvalidError will return true for
func NewRuntimeInvalidError() CloudFoundryError {
	return CloudFoundryError{
		Code:        70001,
		ErrorCode:   "CF-RuntimeInvalid",
		Description: "The runtime is invalid: %s",
	}
}

// IsRuntimeInvalidError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 70001
// - HTTP code: 400
// - message: "The runtime is invalid: %s"
func IsRuntimeInvalidError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 70001
}

// NewRuntimeNameTakenError returns a new CloudFoundryError
// that IsRuntimeNameTakenError will return true for
func NewRuntimeNameTakenError() CloudFoundryError {
	return CloudFoundryError{
		Code:        70002,
		ErrorCode:   "CF-RuntimeNameTaken",
		Description: "The runtime name is taken: %s",
	}
}

// IsRuntimeNameTakenError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 70002
// - HTTP code: 400
// - message: "The runtime name is taken: %s"
func IsRuntimeNameTakenError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 70002
}

// NewRuntimeNotFoundError returns a new CloudFoundryError
// that IsRuntimeNotFoundError will return true for
func NewRuntimeNotFoundError() CloudFoundryError {
	return CloudFoundryError{
		Code:        70003,
		ErrorCode:   "CF-RuntimeNotFound",
		Description: "The runtime could not be found: %s",
	}
}

// IsRuntimeNotFoundError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 70003
// - HTTP code: 404
// - message: "The runtime could not be found: %s"
func IsRuntimeNotFoundError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 70003
}

// NewFrameworkInvalidError returns a new CloudFoundryError
// that IsFrameworkInvalidError will return true for
func NewFrameworkInvalidError() CloudFoundryError {
	return CloudFoundryError{
		Code:        80001,
		ErrorCode:   "CF-FrameworkInvalid",
		Description: "The framework is invalid: %s",
	}
}

// IsFrameworkInvalidError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 80001
// - HTTP code: 400
// - message: "The framework is invalid: %s"
func IsFrameworkInvalidError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 80001
}

// NewFrameworkNameTakenError returns a new CloudFoundryError
// that IsFrameworkNameTakenError will return true for
func NewFrameworkNameTakenError() CloudFoundryError {
	return CloudFoundryError{
		Code:        80002,
		ErrorCode:   "CF-FrameworkNameTaken",
		Description: "The framework name is taken: %s",
	}
}

// IsFrameworkNameTakenError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 80002
// - HTTP code: 400
// - message: "The framework name is taken: %s"
func IsFrameworkNameTakenError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 80002
}

// NewFrameworkNotFoundError returns a new CloudFoundryError
// that IsFrameworkNotFoundError will return true for
func NewFrameworkNotFoundError() CloudFoundryError {
	return CloudFoundryError{
		Code:        80003,
		ErrorCode:   "CF-FrameworkNotFound",
		Description: "The framework could not be found: %s",
	}
}

// IsFrameworkNotFoundError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 80003
// - HTTP code: 404
// - message: "The framework could not be found: %s"
func IsFrameworkNotFoundError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 80003
}

// NewServiceBindingInvalidError returns a new CloudFoundryError
// that IsServiceBindingInvalidError will return true for
func NewServiceBindingInvalidError() CloudFoundryError {
	return CloudFoundryError{
		Code:        90001,
		ErrorCode:   "CF-ServiceBindingInvalid",
		Description: "The service binding is invalid: %s",
	}
}

// IsServiceBindingInvalidError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 90001
// - HTTP code: 400
// - message: "The service binding is invalid: %s"
func IsServiceBindingInvalidError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 90001
}

// NewServiceBindingDifferentSpacesError returns a new CloudFoundryError
// that IsServiceBindingDifferentSpacesError will return true for
func NewServiceBindingDifferentSpacesError() CloudFoundryError {
	return CloudFoundryError{
		Code:        90002,
		ErrorCode:   "CF-ServiceBindingDifferentSpaces",
		Description: "The app and the service are not in the same app space: %s",
	}
}

// IsServiceBindingDifferentSpacesError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 90002
// - HTTP code: 400
// - message: "The app and the service are not in the same app space: %s"
func IsServiceBindingDifferentSpacesError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 90002
}

// NewServiceBindingAppServiceTakenError returns a new CloudFoundryError
// that IsServiceBindingAppServiceTakenError will return true for
func NewServiceBindingAppServiceTakenError() CloudFoundryError {
	return CloudFoundryError{
		Code:        90003,
		ErrorCode:   "CF-ServiceBindingAppServiceTaken",
		Description: "%s",
	}
}

// IsServiceBindingAppServiceTakenError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 90003
// - HTTP code: 400
// - message: "%s"
func IsServiceBindingAppServiceTakenError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 90003
}

// NewServiceBindingNotFoundError returns a new CloudFoundryError
// that IsServiceBindingNotFoundError will return true for
func NewServiceBindingNotFoundError() CloudFoundryError {
	return CloudFoundryError{
		Code:        90004,
		ErrorCode:   "CF-ServiceBindingNotFound",
		Description: "The service binding could not be found: %s",
	}
}

// IsServiceBindingNotFoundError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 90004
// - HTTP code: 404
// - message: "The service binding could not be found: %s"
func IsServiceBindingNotFoundError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 90004
}

// NewUnbindableServiceError returns a new CloudFoundryError
// that IsUnbindableServiceError will return true for
func NewUnbindableServiceError() CloudFoundryError {
	return CloudFoundryError{
		Code:        90005,
		ErrorCode:   "CF-UnbindableService",
		Description: "The service instance doesn't support binding.",
	}
}

// IsUnbindableServiceError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 90005
// - HTTP code: 400
// - message: "The service instance doesn't support binding."
func IsUnbindableServiceError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 90005
}

// NewInvalidLoggingServiceBindingError returns a new CloudFoundryError
// that IsInvalidLoggingServiceBindingError will return true for
func NewInvalidLoggingServiceBindingError() CloudFoundryError {
	return CloudFoundryError{
		Code:        90006,
		ErrorCode:   "CF-InvalidLoggingServiceBinding",
		Description: "The service is attempting to stream logs from your application, but is not registered as a logging service. Please contact the service provider.",
	}
}

// IsInvalidLoggingServiceBindingError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 90006
// - HTTP code: 502
// - message: "The service is attempting to stream logs from your application, but is not registered as a logging service. Please contact the service provider."
func IsInvalidLoggingServiceBindingError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 90006
}

// NewServiceFetchBindingParametersNotSupportedError returns a new CloudFoundryError
// that IsServiceFetchBindingParametersNotSupportedError will return true for
func NewServiceFetchBindingParametersNotSupportedError() CloudFoundryError {
	return CloudFoundryError{
		Code:        90007,
		ErrorCode:   "CF-ServiceFetchBindingParametersNotSupported",
		Description: "This service does not support fetching service binding parameters.",
	}
}

// IsServiceFetchBindingParametersNotSupportedError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 90007
// - HTTP code: 400
// - message: "This service does not support fetching service binding parameters."
func IsServiceFetchBindingParametersNotSupportedError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 90007
}

// NewAsyncServiceBindingOperationInProgressError returns a new CloudFoundryError
// that IsAsyncServiceBindingOperationInProgressError will return true for
func NewAsyncServiceBindingOperationInProgressError() CloudFoundryError {
	return CloudFoundryError{
		Code:        90008,
		ErrorCode:   "CF-AsyncServiceBindingOperationInProgress",
		Description: "An operation for the service binding between app %s and service instance %s is in progress.",
	}
}

// IsAsyncServiceBindingOperationInProgressError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 90008
// - HTTP code: 409
// - message: "An operation for the service binding between app %s and service instance %s is in progress."
func IsAsyncServiceBindingOperationInProgressError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 90008
}

// NewAppInvalidError returns a new CloudFoundryError
// that IsAppInvalidError will return true for
func NewAppInvalidError() CloudFoundryError {
	return CloudFoundryError{
		Code:        100001,
		ErrorCode:   "CF-AppInvalid",
		Description: "The app is invalid: %s",
	}
}

// IsAppInvalidError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 100001
// - HTTP code: 400
// - message: "The app is invalid: %s"
func IsAppInvalidError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 100001
}

// NewAppNameTakenError returns a new CloudFoundryError
// that IsAppNameTakenError will return true for
func NewAppNameTakenError() CloudFoundryError {
	return CloudFoundryError{
		Code:        100002,
		ErrorCode:   "CF-AppNameTaken",
		Description: "The app name is taken: %s",
	}
}

// IsAppNameTakenError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 100002
// - HTTP code: 400
// - message: "The app name is taken: %s"
func IsAppNameTakenError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 100002
}

// NewAppNotFoundError returns a new CloudFoundryError
// that IsAppNotFoundError will return true for
func NewAppNotFoundError() CloudFoundryError {
	return CloudFoundryError{
		Code:        100004,
		ErrorCode:   "CF-AppNotFound",
		Description: "The app could not be found: %s",
	}
}

// IsAppNotFoundError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 100004
// - HTTP code: 404
// - message: "The app could not be found: %s"
func IsAppNotFoundError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 100004
}

// NewAppMemoryQuotaExceededError returns a new CloudFoundryError
// that IsAppMemoryQuotaExceededError will return true for
func NewAppMemoryQuotaExceededError() CloudFoundryError {
	return CloudFoundryError{
		Code:        100005,
		ErrorCode:   "CF-AppMemoryQuotaExceeded",
		Description: "You have exceeded your organization's memory limit: %s",
	}
}

// IsAppMemoryQuotaExceededError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 100005
// - HTTP code: 400
// - message: "You have exceeded your organization's memory limit: %s"
func IsAppMemoryQuotaExceededError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 100005
}

// NewAppMemoryInvalidError returns a new CloudFoundryError
// that IsAppMemoryInvalidError will return true for
func NewAppMemoryInvalidError() CloudFoundryError {
	return CloudFoundryError{
		Code:        100006,
		ErrorCode:   "CF-AppMemoryInvalid",
		Description: "You have specified an invalid amount of memory for your application.",
	}
}

// IsAppMemoryInvalidError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 100006
// - HTTP code: 400
// - message: "You have specified an invalid amount of memory for your application."
func IsAppMemoryInvalidError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 100006
}

// NewQuotaInstanceMemoryLimitExceededError returns a new CloudFoundryError
// that IsQuotaInstanceMemoryLimitExceededError will return true for
func NewQuotaInstanceMemoryLimitExceededError() CloudFoundryError {
	return CloudFoundryError{
		Code:        100007,
		ErrorCode:   "CF-QuotaInstanceMemoryLimitExceeded",
		Description: "You have exceeded the instance memory limit for your organization's quota.",
	}
}

// IsQuotaInstanceMemoryLimitExceededError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 100007
// - HTTP code: 400
// - message: "You have exceeded the instance memory limit for your organization's quota."
func IsQuotaInstanceMemoryLimitExceededError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 100007
}

// NewQuotaInstanceLimitExceededError returns a new CloudFoundryError
// that IsQuotaInstanceLimitExceededError will return true for
func NewQuotaInstanceLimitExceededError() CloudFoundryError {
	return CloudFoundryError{
		Code:        100008,
		ErrorCode:   "CF-QuotaInstanceLimitExceeded",
		Description: "You have exceeded the instance limit for your organization's quota.",
	}
}

// IsQuotaInstanceLimitExceededError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 100008
// - HTTP code: 400
// - message: "You have exceeded the instance limit for your organization's quota."
func IsQuotaInstanceLimitExceededError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 100008
}

// NewAppMemoryInsufficientForSidecarsError returns a new CloudFoundryError
// that IsAppMemoryInsufficientForSidecarsError will return true for
func NewAppMemoryInsufficientForSidecarsError() CloudFoundryError {
	return CloudFoundryError{
		Code:        100009,
		ErrorCode:   "CF-AppMemoryInsufficientForSidecars",
		Description: "The requested memory allocation is not large enough to run all of your sidecar processes.",
	}
}

// IsAppMemoryInsufficientForSidecarsError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 100009
// - HTTP code: 400
// - message: "The requested memory allocation is not large enough to run all of your sidecar processes."
func IsAppMemoryInsufficientForSidecarsError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 100009
}

// NewServicePlanInvalidError returns a new CloudFoundryError
// that IsServicePlanInvalidError will return true for
func NewServicePlanInvalidError() CloudFoundryError {
	return CloudFoundryError{
		Code:        110001,
		ErrorCode:   "CF-ServicePlanInvalid",
		Description: "The service plan is invalid: %s",
	}
}

// IsServicePlanInvalidError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 110001
// - HTTP code: 400
// - message: "The service plan is invalid: %s"
func IsServicePlanInvalidError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 110001
}

// NewServicePlanNameTakenError returns a new CloudFoundryError
// that IsServicePlanNameTakenError will return true for
func NewServicePlanNameTakenError() CloudFoundryError {
	return CloudFoundryError{
		Code:        110002,
		ErrorCode:   "CF-ServicePlanNameTaken",
		Description: "The service plan name is taken: %s",
	}
}

// IsServicePlanNameTakenError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 110002
// - HTTP code: 400
// - message: "The service plan name is taken: %s"
func IsServicePlanNameTakenError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 110002
}

// NewServicePlanNotFoundError returns a new CloudFoundryError
// that IsServicePlanNotFoundError will return true for
func NewServicePlanNotFoundError() CloudFoundryError {
	return CloudFoundryError{
		Code:        110003,
		ErrorCode:   "CF-ServicePlanNotFound",
		Description: "The service plan could not be found: %s",
	}
}

// IsServicePlanNotFoundError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 110003
// - HTTP code: 404
// - message: "The service plan could not be found: %s"
func IsServicePlanNotFoundError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 110003
}

// NewServicePlanNotUpdateableError returns a new CloudFoundryError
// that IsServicePlanNotUpdateableError will return true for
func NewServicePlanNotUpdateableError() CloudFoundryError {
	return CloudFoundryError{
		Code:        110004,
		ErrorCode:   "CF-ServicePlanNotUpdateable",
		Description: "The service does not support changing plans.",
	}
}

// IsServicePlanNotUpdateableError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 110004
// - HTTP code: 400
// - message: "The service does not support changing plans."
func IsServicePlanNotUpdateableError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 110004
}

// NewServiceInvalidError returns a new CloudFoundryError
// that IsServiceInvalidError will return true for
func NewServiceInvalidError() CloudFoundryError {
	return CloudFoundryError{
		Code:        120001,
		ErrorCode:   "CF-ServiceInvalid",
		Description: "The service is invalid: %s",
	}
}

// IsServiceInvalidError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 120001
// - HTTP code: 400
// - message: "The service is invalid: %s"
func IsServiceInvalidError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 120001
}

// NewServiceLabelTakenError returns a new CloudFoundryError
// that IsServiceLabelTakenError will return true for
func NewServiceLabelTakenError() CloudFoundryError {
	return CloudFoundryError{
		Code:        120002,
		ErrorCode:   "CF-ServiceLabelTaken",
		Description: "The service label is taken: %s",
	}
}

// IsServiceLabelTakenError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 120002
// - HTTP code: 400
// - message: "The service label is taken: %s"
func IsServiceLabelTakenError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 120002
}

// NewServiceNotFoundError returns a new CloudFoundryError
// that IsServiceNotFoundError will return true for
func NewServiceNotFoundError() CloudFoundryError {
	return CloudFoundryError{
		Code:        120003,
		ErrorCode:   "CF-ServiceNotFound",
		Description: "The service could not be found: %s",
	}
}

// IsServiceNotFoundError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 120003
// - HTTP code: 404
// - message: "The service could not be found: %s"
func IsServiceNotFoundError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 120003
}

// NewServiceFetchInstanceParametersNotSupportedError returns a new CloudFoundryError
// that IsServiceFetchInstanceParametersNotSupportedError will return true for
func NewServiceFetchInstanceParametersNotSupportedError() CloudFoundryError {
	return CloudFoundryError{
		Code:        120004,
		ErrorCode:   "CF-ServiceFetchInstanceParametersNotSupported",
		Description: "This service does not support fetching service instance parameters.",
	}
}

// IsServiceFetchInstanceParametersNotSupportedError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 120004
// - HTTP code: 400
// - message: "This service does not support fetching service instance parameters."
func IsServiceFetchInstanceParametersNotSupportedError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 120004
}

// NewDomainInvalidError returns a new CloudFoundryError
// that IsDomainInvalidError will return true for
func NewDomainInvalidError() CloudFoundryError {
	return CloudFoundryError{
		Code:        130001,
		ErrorCode:   "CF-DomainInvalid",
		Description: "The domain is invalid: %s",
	}
}

// IsDomainInvalidError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 130001
// - HTTP code: 400
// - message: "The domain is invalid: %s"
func IsDomainInvalidError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 130001
}

// NewDomainNotFoundError returns a new CloudFoundryError
// that IsDomainNotFoundError will return true for
func NewDomainNotFoundError() CloudFoundryError {
	return CloudFoundryError{
		Code:        130002,
		ErrorCode:   "CF-DomainNotFound",
		Description: "The domain could not be found: %s",
	}
}

// IsDomainNotFoundError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 130002
// - HTTP code: 404
// - message: "The domain could not be found: %s"
func IsDomainNotFoundError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 130002
}

// NewDomainNameTakenError returns a new CloudFoundryError
// that IsDomainNameTakenError will return true for
func NewDomainNameTakenError() CloudFoundryError {
	return CloudFoundryError{
		Code:        130003,
		ErrorCode:   "CF-DomainNameTaken",
		Description: "The domain name is taken: %s",
	}
}

// IsDomainNameTakenError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 130003
// - HTTP code: 400
// - message: "The domain name is taken: %s"
func IsDomainNameTakenError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 130003
}

// NewPathInvalidError returns a new CloudFoundryError
// that IsPathInvalidError will return true for
func NewPathInvalidError() CloudFoundryError {
	return CloudFoundryError{
		Code:        130004,
		ErrorCode:   "CF-PathInvalid",
		Description: "The path is invalid: %s",
	}
}

// IsPathInvalidError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 130004
// - HTTP code: 400
// - message: "The path is invalid: %s"
func IsPathInvalidError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 130004
}

// NewTotalPrivateDomainsExceededError returns a new CloudFoundryError
// that IsTotalPrivateDomainsExceededError will return true for
func NewTotalPrivateDomainsExceededError() CloudFoundryError {
	return CloudFoundryError{
		Code:        130005,
		ErrorCode:   "CF-TotalPrivateDomainsExceeded",
		Description: "The number of private domains exceeds the quota for organization: %s",
	}
}

// IsTotalPrivateDomainsExceededError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 130005
// - HTTP code: 400
// - message: "The number of private domains exceeds the quota for organization: %s"
func IsTotalPrivateDomainsExceededError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 130005
}

// NewServiceDoesNotSupportRoutesError returns a new CloudFoundryError
// that IsServiceDoesNotSupportRoutesError will return true for
func NewServiceDoesNotSupportRoutesError() CloudFoundryError {
	return CloudFoundryError{
		Code:        130006,
		ErrorCode:   "CF-ServiceDoesNotSupportRoutes",
		Description: "This service does not support route binding.",
	}
}

// IsServiceDoesNotSupportRoutesError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 130006
// - HTTP code: 400
// - message: "This service does not support route binding."
func IsServiceDoesNotSupportRoutesError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 130006
}

// NewRouteAlreadyBoundToServiceInstanceError returns a new CloudFoundryError
// that IsRouteAlreadyBoundToServiceInstanceError will return true for
func NewRouteAlreadyBoundToServiceInstanceError() CloudFoundryError {
	return CloudFoundryError{
		Code:        130007,
		ErrorCode:   "CF-RouteAlreadyBoundToServiceInstance",
		Description: "A route may only be bound to a single service instance",
	}
}

// IsRouteAlreadyBoundToServiceInstanceError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 130007
// - HTTP code: 400
// - message: "A route may only be bound to a single service instance"
func IsRouteAlreadyBoundToServiceInstanceError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 130007
}

// NewServiceInstanceAlreadyBoundToSameRouteError returns a new CloudFoundryError
// that IsServiceInstanceAlreadyBoundToSameRouteError will return true for
func NewServiceInstanceAlreadyBoundToSameRouteError() CloudFoundryError {
	return CloudFoundryError{
		Code:        130008,
		ErrorCode:   "CF-ServiceInstanceAlreadyBoundToSameRoute",
		Description: "The route and service instance are already bound.",
	}
}

// IsServiceInstanceAlreadyBoundToSameRouteError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 130008
// - HTTP code: 400
// - message: "The route and service instance are already bound."
func IsServiceInstanceAlreadyBoundToSameRouteError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 130008
}

// NewInternalDomainCannotBeDeletedError returns a new CloudFoundryError
// that IsInternalDomainCannotBeDeletedError will return true for
func NewInternalDomainCannotBeDeletedError() CloudFoundryError {
	return CloudFoundryError{
		Code:        130009,
		ErrorCode:   "CF-InternalDomainCannotBeDeleted",
		Description: "The domain '%s' cannot be deleted. It is reserved by the platform.",
	}
}

// IsInternalDomainCannotBeDeletedError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 130009
// - HTTP code: 422
// - message: "The domain '%s' cannot be deleted. It is reserved by the platform."
func IsInternalDomainCannotBeDeletedError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 130009
}

// NewRouteServiceCannotBeBoundToInternalRouteError returns a new CloudFoundryError
// that IsRouteServiceCannotBeBoundToInternalRouteError will return true for
func NewRouteServiceCannotBeBoundToInternalRouteError() CloudFoundryError {
	return CloudFoundryError{
		Code:        130010,
		ErrorCode:   "CF-RouteServiceCannotBeBoundToInternalRoute",
		Description: "Route services cannot be bound to internal routes.",
	}
}

// IsRouteServiceCannotBeBoundToInternalRouteError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 130010
// - HTTP code: 400
// - message: "Route services cannot be bound to internal routes."
func IsRouteServiceCannotBeBoundToInternalRouteError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 130010
}

// NewLegacyApiWithoutDefaultSpaceError returns a new CloudFoundryError
// that IsLegacyApiWithoutDefaultSpaceError will return true for
func NewLegacyApiWithoutDefaultSpaceError() CloudFoundryError {
	return CloudFoundryError{
		Code:        140001,
		ErrorCode:   "CF-LegacyApiWithoutDefaultSpace",
		Description: "A legacy api call requiring a default app space was called, but no default app space is set for the user.",
	}
}

// IsLegacyApiWithoutDefaultSpaceError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 140001
// - HTTP code: 400
// - message: "A legacy api call requiring a default app space was called, but no default app space is set for the user."
func IsLegacyApiWithoutDefaultSpaceError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 140001
}

// NewAppPackageInvalidError returns a new CloudFoundryError
// that IsAppPackageInvalidError will return true for
func NewAppPackageInvalidError() CloudFoundryError {
	return CloudFoundryError{
		Code:        150001,
		ErrorCode:   "CF-AppPackageInvalid",
		Description: "The app package is invalid: %s",
	}
}

// IsAppPackageInvalidError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 150001
// - HTTP code: 400
// - message: "The app package is invalid: %s"
func IsAppPackageInvalidError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 150001
}

// NewAppPackageNotFoundError returns a new CloudFoundryError
// that IsAppPackageNotFoundError will return true for
func NewAppPackageNotFoundError() CloudFoundryError {
	return CloudFoundryError{
		Code:        150002,
		ErrorCode:   "CF-AppPackageNotFound",
		Description: "The app package could not be found: %s",
	}
}

// IsAppPackageNotFoundError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 150002
// - HTTP code: 404
// - message: "The app package could not be found: %s"
func IsAppPackageNotFoundError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 150002
}

// NewInsufficientRunningResourcesAvailableError returns a new CloudFoundryError
// that IsInsufficientRunningResourcesAvailableError will return true for
func NewInsufficientRunningResourcesAvailableError() CloudFoundryError {
	return CloudFoundryError{
		Code:        150003,
		ErrorCode:   "CF-InsufficientRunningResourcesAvailable",
		Description: "One or more instances could not be started because of insufficient running resources.",
	}
}

// IsInsufficientRunningResourcesAvailableError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 150003
// - HTTP code: 503
// - message: "One or more instances could not be started because of insufficient running resources."
func IsInsufficientRunningResourcesAvailableError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 150003
}

// NewPackageBitsAlreadyUploadedError returns a new CloudFoundryError
// that IsPackageBitsAlreadyUploadedError will return true for
func NewPackageBitsAlreadyUploadedError() CloudFoundryError {
	return CloudFoundryError{
		Code:        150004,
		ErrorCode:   "CF-PackageBitsAlreadyUploaded",
		Description: "Bits may be uploaded only once. Create a new package to upload different bits.",
	}
}

// IsPackageBitsAlreadyUploadedError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 150004
// - HTTP code: 400
// - message: "Bits may be uploaded only once. Create a new package to upload different bits."
func IsPackageBitsAlreadyUploadedError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 150004
}

// NewBlobstoreNotLocalError returns a new CloudFoundryError
// that IsBlobstoreNotLocalError will return true for
func NewBlobstoreNotLocalError() CloudFoundryError {
	return CloudFoundryError{
		Code:        150005,
		ErrorCode:   "CF-BlobstoreNotLocal",
		Description: "Downloading blobs can only be done directly to the blobstore.",
	}
}

// IsBlobstoreNotLocalError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 150005
// - HTTP code: 400
// - message: "Downloading blobs can only be done directly to the blobstore."
func IsBlobstoreNotLocalError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 150005
}

// NewBlobstoreUnavailableError returns a new CloudFoundryError
// that IsBlobstoreUnavailableError will return true for
func NewBlobstoreUnavailableError() CloudFoundryError {
	return CloudFoundryError{
		Code:        150006,
		ErrorCode:   "CF-BlobstoreUnavailable",
		Description: "Failed to perform operation due to blobstore unavailability.",
	}
}

// IsBlobstoreUnavailableError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 150006
// - HTTP code: 502
// - message: "Failed to perform operation due to blobstore unavailability."
func IsBlobstoreUnavailableError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 150006
}

// NewBlobstoreError returns a new CloudFoundryError
// that IsBlobstoreError will return true for
func NewBlobstoreError() CloudFoundryError {
	return CloudFoundryError{
		Code:        150007,
		ErrorCode:   "CF-BlobstoreError",
		Description: "Failed to perform blobstore operation after three retries.",
	}
}

// IsBlobstoreError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 150007
// - HTTP code: 500
// - message: "Failed to perform blobstore operation after three retries."
func IsBlobstoreError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 150007
}

// NewDockerImageMissingError returns a new CloudFoundryError
// that IsDockerImageMissingError will return true for
func NewDockerImageMissingError() CloudFoundryError {
	return CloudFoundryError{
		Code:        150008,
		ErrorCode:   "CF-DockerImageMissing",
		Description: "Docker credentials can only be supplied for apps with a 'docker_image'",
	}
}

// IsDockerImageMissingError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 150008
// - HTTP code: 400
// - message: "Docker credentials can only be supplied for apps with a 'docker_image'"
func IsDockerImageMissingError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 150008
}

// NewAppRecursiveDeleteFailedError returns a new CloudFoundryError
// that IsAppRecursiveDeleteFailedError will return true for
func NewAppRecursiveDeleteFailedError() CloudFoundryError {
	return CloudFoundryError{
		Code:        150009,
		ErrorCode:   "CF-AppRecursiveDeleteFailed",
		Description: "Deletion of app %s failed because one or more associated resources could not be deleted.%s",
	}
}

// IsAppRecursiveDeleteFailedError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 150009
// - HTTP code: 502
// - message: "Deletion of app %s failed because one or more associated resources could not be deleted.\n\n%s"
func IsAppRecursiveDeleteFailedError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 150009
}

// NewAppBitsUploadInvalidError returns a new CloudFoundryError
// that IsAppBitsUploadInvalidError will return true for
func NewAppBitsUploadInvalidError() CloudFoundryError {
	return CloudFoundryError{
		Code:        160001,
		ErrorCode:   "CF-AppBitsUploadInvalid",
		Description: "The app upload is invalid: %s",
	}
}

// IsAppBitsUploadInvalidError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 160001
// - HTTP code: 400
// - message: "The app upload is invalid: %s"
func IsAppBitsUploadInvalidError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 160001
}

// NewAppBitsCopyInvalidError returns a new CloudFoundryError
// that IsAppBitsCopyInvalidError will return true for
func NewAppBitsCopyInvalidError() CloudFoundryError {
	return CloudFoundryError{
		Code:        160002,
		ErrorCode:   "CF-AppBitsCopyInvalid",
		Description: "The app copy is invalid: %s",
	}
}

// IsAppBitsCopyInvalidError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 160002
// - HTTP code: 400
// - message: "The app copy is invalid: %s"
func IsAppBitsCopyInvalidError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 160002
}

// NewAppResourcesFileModeInvalidError returns a new CloudFoundryError
// that IsAppResourcesFileModeInvalidError will return true for
func NewAppResourcesFileModeInvalidError() CloudFoundryError {
	return CloudFoundryError{
		Code:        160003,
		ErrorCode:   "CF-AppResourcesFileModeInvalid",
		Description: "The resource file mode is invalid: %s",
	}
}

// IsAppResourcesFileModeInvalidError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 160003
// - HTTP code: 400
// - message: "The resource file mode is invalid: %s"
func IsAppResourcesFileModeInvalidError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 160003
}

// NewAppResourcesFilePathInvalidError returns a new CloudFoundryError
// that IsAppResourcesFilePathInvalidError will return true for
func NewAppResourcesFilePathInvalidError() CloudFoundryError {
	return CloudFoundryError{
		Code:        160004,
		ErrorCode:   "CF-AppResourcesFilePathInvalid",
		Description: "The resource file path is invalid: %s",
	}
}

// IsAppResourcesFilePathInvalidError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 160004
// - HTTP code: 400
// - message: "The resource file path is invalid: %s"
func IsAppResourcesFilePathInvalidError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 160004
}

// NewStagingError returns a new CloudFoundryError
// that IsStagingError will return true for
func NewStagingError() CloudFoundryError {
	return CloudFoundryError{
		Code:        170001,
		ErrorCode:   "CF-StagingError",
		Description: "Staging error: %s",
	}
}

// IsStagingError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 170001
// - HTTP code: 400
// - message: "Staging error: %s"
func IsStagingError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 170001
}

// NewNotStagedError returns a new CloudFoundryError
// that IsNotStagedError will return true for
func NewNotStagedError() CloudFoundryError {
	return CloudFoundryError{
		Code:        170002,
		ErrorCode:   "CF-NotStaged",
		Description: "App has not finished staging",
	}
}

// IsNotStagedError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 170002
// - HTTP code: 400
// - message: "App has not finished staging"
func IsNotStagedError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 170002
}

// NewNoAppDetectedError returns a new CloudFoundryError
// that IsNoAppDetectedError will return true for
func NewNoAppDetectedError() CloudFoundryError {
	return CloudFoundryError{
		Code:        170003,
		ErrorCode:   "CF-NoAppDetectedError",
		Description: "An app was not successfully detected by any available buildpack",
	}
}

// IsNoAppDetectedError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 170003
// - HTTP code: 400
// - message: "An app was not successfully detected by any available buildpack"
func IsNoAppDetectedError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 170003
}

// NewBuildpackCompileFailedError returns a new CloudFoundryError
// that IsBuildpackCompileFailedError will return true for
func NewBuildpackCompileFailedError() CloudFoundryError {
	return CloudFoundryError{
		Code:        170004,
		ErrorCode:   "CF-BuildpackCompileFailed",
		Description: "App staging failed in the buildpack compile phase",
	}
}

// IsBuildpackCompileFailedError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 170004
// - HTTP code: 400
// - message: "App staging failed in the buildpack compile phase"
func IsBuildpackCompileFailedError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 170004
}

// NewBuildpackReleaseFailedError returns a new CloudFoundryError
// that IsBuildpackReleaseFailedError will return true for
func NewBuildpackReleaseFailedError() CloudFoundryError {
	return CloudFoundryError{
		Code:        170005,
		ErrorCode:   "CF-BuildpackReleaseFailed",
		Description: "App staging failed in the buildpack release phase",
	}
}

// IsBuildpackReleaseFailedError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 170005
// - HTTP code: 400
// - message: "App staging failed in the buildpack release phase"
func IsBuildpackReleaseFailedError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 170005
}

// NewNoBuildpacksFoundError returns a new CloudFoundryError
// that IsNoBuildpacksFoundError will return true for
func NewNoBuildpacksFoundError() CloudFoundryError {
	return CloudFoundryError{
		Code:        170006,
		ErrorCode:   "CF-NoBuildpacksFound",
		Description: "There are no buildpacks available",
	}
}

// IsNoBuildpacksFoundError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 170006
// - HTTP code: 400
// - message: "There are no buildpacks available"
func IsNoBuildpacksFoundError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 170006
}

// NewStagingTimeExpiredError returns a new CloudFoundryError
// that IsStagingTimeExpiredError will return true for
func NewStagingTimeExpiredError() CloudFoundryError {
	return CloudFoundryError{
		Code:        170007,
		ErrorCode:   "CF-StagingTimeExpired",
		Description: "Staging time expired: %s",
	}
}

// IsStagingTimeExpiredError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 170007
// - HTTP code: 504
// - message: "Staging time expired: %s"
func IsStagingTimeExpiredError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 170007
}

// NewInsufficientResourcesError returns a new CloudFoundryError
// that IsInsufficientResourcesError will return true for
func NewInsufficientResourcesError() CloudFoundryError {
	return CloudFoundryError{
		Code:        170008,
		ErrorCode:   "CF-InsufficientResources",
		Description: "Insufficient resources",
	}
}

// IsInsufficientResourcesError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 170008
// - HTTP code: 400
// - message: "Insufficient resources"
func IsInsufficientResourcesError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 170008
}

// NewNoCompatibleCellError returns a new CloudFoundryError
// that IsNoCompatibleCellError will return true for
func NewNoCompatibleCellError() CloudFoundryError {
	return CloudFoundryError{
		Code:        170009,
		ErrorCode:   "CF-NoCompatibleCell",
		Description: "Found no compatible cell",
	}
}

// IsNoCompatibleCellError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 170009
// - HTTP code: 400
// - message: "Found no compatible cell"
func IsNoCompatibleCellError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 170009
}

// NewStagerUnavailableError returns a new CloudFoundryError
// that IsStagerUnavailableError will return true for
func NewStagerUnavailableError() CloudFoundryError {
	return CloudFoundryError{
		Code:        170010,
		ErrorCode:   "CF-StagerUnavailable",
		Description: "Stager is unavailable: %s",
	}
}

// IsStagerUnavailableError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 170010
// - HTTP code: 503
// - message: "Stager is unavailable: %s"
func IsStagerUnavailableError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 170010
}

// NewStagerError returns a new CloudFoundryError
// that IsStagerError will return true for
func NewStagerError() CloudFoundryError {
	return CloudFoundryError{
		Code:        170011,
		ErrorCode:   "CF-StagerError",
		Description: "Stager error: %s",
	}
}

// IsStagerError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 170011
// - HTTP code: 500
// - message: "Stager error: %s"
func IsStagerError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 170011
}

// NewRunnerInvalidRequestError returns a new CloudFoundryError
// that IsRunnerInvalidRequestError will return true for
func NewRunnerInvalidRequestError() CloudFoundryError {
	return CloudFoundryError{
		Code:        170014,
		ErrorCode:   "CF-RunnerInvalidRequest",
		Description: "Runner invalid request: %s",
	}
}

// IsRunnerInvalidRequestError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 170014
// - HTTP code: 500
// - message: "Runner invalid request: %s"
func IsRunnerInvalidRequestError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 170014
}

// NewRunnerUnavailableError returns a new CloudFoundryError
// that IsRunnerUnavailableError will return true for
func NewRunnerUnavailableError() CloudFoundryError {
	return CloudFoundryError{
		Code:        170015,
		ErrorCode:   "CF-RunnerUnavailable",
		Description: "Runner is unavailable: %s",
	}
}

// IsRunnerUnavailableError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 170015
// - HTTP code: 503
// - message: "Runner is unavailable: %s"
func IsRunnerUnavailableError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 170015
}

// NewRunnerError returns a new CloudFoundryError
// that IsRunnerError will return true for
func NewRunnerError() CloudFoundryError {
	return CloudFoundryError{
		Code:        170016,
		ErrorCode:   "CF-RunnerError",
		Description: "Runner error: %s",
	}
}

// IsRunnerError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 170016
// - HTTP code: 500
// - message: "Runner error: %s"
func IsRunnerError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 170016
}

// NewStagingInProgressError returns a new CloudFoundryError
// that IsStagingInProgressError will return true for
func NewStagingInProgressError() CloudFoundryError {
	return CloudFoundryError{
		Code:        170017,
		ErrorCode:   "CF-StagingInProgress",
		Description: "Only one build can be STAGING at a time per application.",
	}
}

// IsStagingInProgressError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 170017
// - HTTP code: 422
// - message: "Only one build can be STAGING at a time per application."
func IsStagingInProgressError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 170017
}

// NewInvalidTaskAddressError returns a new CloudFoundryError
// that IsInvalidTaskAddressError will return true for
func NewInvalidTaskAddressError() CloudFoundryError {
	return CloudFoundryError{
		Code:        170018,
		ErrorCode:   "CF-InvalidTaskAddress",
		Description: "Invalid config: %s",
	}
}

// IsInvalidTaskAddressError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 170018
// - HTTP code: 500
// - message: "Invalid config: %s"
func IsInvalidTaskAddressError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 170018
}

// NewTaskError returns a new CloudFoundryError
// that IsTaskError will return true for
func NewTaskError() CloudFoundryError {
	return CloudFoundryError{
		Code:        170019,
		ErrorCode:   "CF-TaskError",
		Description: "Task failed: %s",
	}
}

// IsTaskError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 170019
// - HTTP code: 500
// - message: "Task failed: %s"
func IsTaskError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 170019
}

// NewTaskWorkersUnavailableError returns a new CloudFoundryError
// that IsTaskWorkersUnavailableError will return true for
func NewTaskWorkersUnavailableError() CloudFoundryError {
	return CloudFoundryError{
		Code:        170020,
		ErrorCode:   "CF-TaskWorkersUnavailable",
		Description: "Task workers are unavailable: %s",
	}
}

// IsTaskWorkersUnavailableError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 170020
// - HTTP code: 503
// - message: "Task workers are unavailable: %s"
func IsTaskWorkersUnavailableError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 170020
}

// NewInvalidTaskRequestError returns a new CloudFoundryError
// that IsInvalidTaskRequestError will return true for
func NewInvalidTaskRequestError() CloudFoundryError {
	return CloudFoundryError{
		Code:        170021,
		ErrorCode:   "CF-InvalidTaskRequest",
		Description: "The task request is invalid: %s",
	}
}

// IsInvalidTaskRequestError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 170021
// - HTTP code: 422
// - message: "The task request is invalid: %s"
func IsInvalidTaskRequestError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 170021
}

// NewServiceGatewayError returns a new CloudFoundryError
// that IsServiceGatewayError will return true for
func NewServiceGatewayError() CloudFoundryError {
	return CloudFoundryError{
		Code:        180002,
		ErrorCode:   "CF-ServiceGatewayError",
		Description: "Service gateway internal error: %s",
	}
}

// IsServiceGatewayError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 180002
// - HTTP code: 503
// - message: "Service gateway internal error: %s"
func IsServiceGatewayError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 180002
}

// NewServiceNotImplementedError returns a new CloudFoundryError
// that IsServiceNotImplementedError will return true for
func NewServiceNotImplementedError() CloudFoundryError {
	return CloudFoundryError{
		Code:        180003,
		ErrorCode:   "CF-ServiceNotImplemented",
		Description: "Operation not supported for service",
	}
}

// IsServiceNotImplementedError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 180003
// - HTTP code: 501
// - message: "Operation not supported for service"
func IsServiceNotImplementedError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 180003
}

// NewSDSNotAvailableError returns a new CloudFoundryError
// that IsSDSNotAvailableError will return true for
func NewSDSNotAvailableError() CloudFoundryError {
	return CloudFoundryError{
		Code:        180004,
		ErrorCode:   "CF-SDSNotAvailable",
		Description: "No serialization service backends available",
	}
}

// IsSDSNotAvailableError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 180004
// - HTTP code: 501
// - message: "No serialization service backends available"
func IsSDSNotAvailableError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 180004
}

// NewFileError returns a new CloudFoundryError
// that IsFileError will return true for
func NewFileError() CloudFoundryError {
	return CloudFoundryError{
		Code:        190001,
		ErrorCode:   "CF-FileError",
		Description: "File error: %s",
	}
}

// IsFileError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 190001
// - HTTP code: 400
// - message: "File error: %s"
func IsFileError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 190001
}

// NewStatsError returns a new CloudFoundryError
// that IsStatsError will return true for
func NewStatsError() CloudFoundryError {
	return CloudFoundryError{
		Code:        200001,
		ErrorCode:   "CF-StatsError",
		Description: "Stats error: %s",
	}
}

// IsStatsError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 200001
// - HTTP code: 400
// - message: "Stats error: %s"
func IsStatsError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 200001
}

// NewStatsUnavailableError returns a new CloudFoundryError
// that IsStatsUnavailableError will return true for
func NewStatsUnavailableError() CloudFoundryError {
	return CloudFoundryError{
		Code:        200002,
		ErrorCode:   "CF-StatsUnavailable",
		Description: "Stats unavailable: %s",
	}
}

// IsStatsUnavailableError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 200002
// - HTTP code: 503
// - message: "Stats unavailable: %s"
func IsStatsUnavailableError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 200002
}

// NewAppStoppedStatsError returns a new CloudFoundryError
// that IsAppStoppedStatsError will return true for
func NewAppStoppedStatsError() CloudFoundryError {
	return CloudFoundryError{
		Code:        200003,
		ErrorCode:   "CF-AppStoppedStatsError",
		Description: "Could not fetch stats for stopped app: %s",
	}
}

// IsAppStoppedStatsError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 200003
// - HTTP code: 400
// - message: "Could not fetch stats for stopped app: %s"
func IsAppStoppedStatsError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 200003
}

// NewRouteInvalidError returns a new CloudFoundryError
// that IsRouteInvalidError will return true for
func NewRouteInvalidError() CloudFoundryError {
	return CloudFoundryError{
		Code:        210001,
		ErrorCode:   "CF-RouteInvalid",
		Description: "The route is invalid: %s",
	}
}

// IsRouteInvalidError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 210001
// - HTTP code: 400
// - message: "The route is invalid: %s"
func IsRouteInvalidError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 210001
}

// NewRouteNotFoundError returns a new CloudFoundryError
// that IsRouteNotFoundError will return true for
func NewRouteNotFoundError() CloudFoundryError {
	return CloudFoundryError{
		Code:        210002,
		ErrorCode:   "CF-RouteNotFound",
		Description: "The route could not be found: %s",
	}
}

// IsRouteNotFoundError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 210002
// - HTTP code: 404
// - message: "The route could not be found: %s"
func IsRouteNotFoundError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 210002
}

// NewRouteHostTakenError returns a new CloudFoundryError
// that IsRouteHostTakenError will return true for
func NewRouteHostTakenError() CloudFoundryError {
	return CloudFoundryError{
		Code:        210003,
		ErrorCode:   "CF-RouteHostTaken",
		Description: "The host is taken: %s",
	}
}

// IsRouteHostTakenError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 210003
// - HTTP code: 400
// - message: "The host is taken: %s"
func IsRouteHostTakenError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 210003
}

// NewRoutePathTakenError returns a new CloudFoundryError
// that IsRoutePathTakenError will return true for
func NewRoutePathTakenError() CloudFoundryError {
	return CloudFoundryError{
		Code:        210004,
		ErrorCode:   "CF-RoutePathTaken",
		Description: "The path is taken: %s",
	}
}

// IsRoutePathTakenError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 210004
// - HTTP code: 400
// - message: "The path is taken: %s"
func IsRoutePathTakenError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 210004
}

// NewRoutePortTakenError returns a new CloudFoundryError
// that IsRoutePortTakenError will return true for
func NewRoutePortTakenError() CloudFoundryError {
	return CloudFoundryError{
		Code:        210005,
		ErrorCode:   "CF-RoutePortTaken",
		Description: "The port is taken: %s",
	}
}

// IsRoutePortTakenError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 210005
// - HTTP code: 400
// - message: "The port is taken: %s"
func IsRoutePortTakenError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 210005
}

// NewRouteMappingTakenError returns a new CloudFoundryError
// that IsRouteMappingTakenError will return true for
func NewRouteMappingTakenError() CloudFoundryError {
	return CloudFoundryError{
		Code:        210006,
		ErrorCode:   "CF-RouteMappingTaken",
		Description: "The route mapping is taken: %s",
	}
}

// IsRouteMappingTakenError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 210006
// - HTTP code: 400
// - message: "The route mapping is taken: %s"
func IsRouteMappingTakenError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 210006
}

// NewRouteMappingNotFoundError returns a new CloudFoundryError
// that IsRouteMappingNotFoundError will return true for
func NewRouteMappingNotFoundError() CloudFoundryError {
	return CloudFoundryError{
		Code:        210007,
		ErrorCode:   "CF-RouteMappingNotFound",
		Description: "The route mapping could not be found: %s",
	}
}

// IsRouteMappingNotFoundError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 210007
// - HTTP code: 404
// - message: "The route mapping could not be found: %s"
func IsRouteMappingNotFoundError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 210007
}

// NewRouterGroupNotFoundError returns a new CloudFoundryError
// that IsRouterGroupNotFoundError will return true for
func NewRouterGroupNotFoundError() CloudFoundryError {
	return CloudFoundryError{
		Code:        210009,
		ErrorCode:   "CF-RouterGroupNotFound",
		Description: "The router group could not be found: %s",
	}
}

// IsRouterGroupNotFoundError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 210009
// - HTTP code: 404
// - message: "The router group could not be found: %s"
func IsRouterGroupNotFoundError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 210009
}

// NewInstancesError returns a new CloudFoundryError
// that IsInstancesError will return true for
func NewInstancesError() CloudFoundryError {
	return CloudFoundryError{
		Code:        220001,
		ErrorCode:   "CF-InstancesError",
		Description: "Instances error: %s",
	}
}

// IsInstancesError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 220001
// - HTTP code: 400
// - message: "Instances error: %s"
func IsInstancesError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 220001
}

// NewInstancesUnavailableError returns a new CloudFoundryError
// that IsInstancesUnavailableError will return true for
func NewInstancesUnavailableError() CloudFoundryError {
	return CloudFoundryError{
		Code:        220002,
		ErrorCode:   "CF-InstancesUnavailable",
		Description: "Instances information unavailable: %s",
	}
}

// IsInstancesUnavailableError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 220002
// - HTTP code: 503
// - message: "Instances information unavailable: %s"
func IsInstancesUnavailableError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 220002
}

// NewEventNotFoundError returns a new CloudFoundryError
// that IsEventNotFoundError will return true for
func NewEventNotFoundError() CloudFoundryError {
	return CloudFoundryError{
		Code:        230002,
		ErrorCode:   "CF-EventNotFound",
		Description: "Event could not be found: %s",
	}
}

// IsEventNotFoundError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 230002
// - HTTP code: 404
// - message: "Event could not be found: %s"
func IsEventNotFoundError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 230002
}

// NewQuotaDefinitionNotFoundError returns a new CloudFoundryError
// that IsQuotaDefinitionNotFoundError will return true for
func NewQuotaDefinitionNotFoundError() CloudFoundryError {
	return CloudFoundryError{
		Code:        240001,
		ErrorCode:   "CF-QuotaDefinitionNotFound",
		Description: "Quota Definition could not be found: %s",
	}
}

// IsQuotaDefinitionNotFoundError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 240001
// - HTTP code: 404
// - message: "Quota Definition could not be found: %s"
func IsQuotaDefinitionNotFoundError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 240001
}

// NewQuotaDefinitionNameTakenError returns a new CloudFoundryError
// that IsQuotaDefinitionNameTakenError will return true for
func NewQuotaDefinitionNameTakenError() CloudFoundryError {
	return CloudFoundryError{
		Code:        240002,
		ErrorCode:   "CF-QuotaDefinitionNameTaken",
		Description: "Quota Definition is taken: %s",
	}
}

// IsQuotaDefinitionNameTakenError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 240002
// - HTTP code: 400
// - message: "Quota Definition is taken: %s"
func IsQuotaDefinitionNameTakenError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 240002
}

// NewQuotaDefinitionInvalidError returns a new CloudFoundryError
// that IsQuotaDefinitionInvalidError will return true for
func NewQuotaDefinitionInvalidError() CloudFoundryError {
	return CloudFoundryError{
		Code:        240003,
		ErrorCode:   "CF-QuotaDefinitionInvalid",
		Description: "Quota Definition is invalid: %s",
	}
}

// IsQuotaDefinitionInvalidError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 240003
// - HTTP code: 400
// - message: "Quota Definition is invalid: %s"
func IsQuotaDefinitionInvalidError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 240003
}

// NewQuotaDefinitionMemoryLimitInvalidError returns a new CloudFoundryError
// that IsQuotaDefinitionMemoryLimitInvalidError will return true for
func NewQuotaDefinitionMemoryLimitInvalidError() CloudFoundryError {
	return CloudFoundryError{
		Code:        240004,
		ErrorCode:   "CF-QuotaDefinitionMemoryLimitInvalid",
		Description: "Quota Definition memory limit cannot be less than -1",
	}
}

// IsQuotaDefinitionMemoryLimitInvalidError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 240004
// - HTTP code: 400
// - message: "Quota Definition memory limit cannot be less than -1"
func IsQuotaDefinitionMemoryLimitInvalidError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 240004
}

// NewStackInvalidError returns a new CloudFoundryError
// that IsStackInvalidError will return true for
func NewStackInvalidError() CloudFoundryError {
	return CloudFoundryError{
		Code:        250001,
		ErrorCode:   "CF-StackInvalid",
		Description: "The stack is invalid: %s",
	}
}

// IsStackInvalidError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 250001
// - HTTP code: 400
// - message: "The stack is invalid: %s"
func IsStackInvalidError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 250001
}

// NewStackNameTakenError returns a new CloudFoundryError
// that IsStackNameTakenError will return true for
func NewStackNameTakenError() CloudFoundryError {
	return CloudFoundryError{
		Code:        250002,
		ErrorCode:   "CF-StackNameTaken",
		Description: "The stack name is taken: %s",
	}
}

// IsStackNameTakenError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 250002
// - HTTP code: 400
// - message: "The stack name is taken: %s"
func IsStackNameTakenError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 250002
}

// NewStackNotFoundError returns a new CloudFoundryError
// that IsStackNotFoundError will return true for
func NewStackNotFoundError() CloudFoundryError {
	return CloudFoundryError{
		Code:        250003,
		ErrorCode:   "CF-StackNotFound",
		Description: "The stack could not be found: %s",
	}
}

// IsStackNotFoundError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 250003
// - HTTP code: 404
// - message: "The stack could not be found: %s"
func IsStackNotFoundError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 250003
}

// NewServicePlanVisibilityInvalidError returns a new CloudFoundryError
// that IsServicePlanVisibilityInvalidError will return true for
func NewServicePlanVisibilityInvalidError() CloudFoundryError {
	return CloudFoundryError{
		Code:        260001,
		ErrorCode:   "CF-ServicePlanVisibilityInvalid",
		Description: "Service Plan Visibility is invalid: %s",
	}
}

// IsServicePlanVisibilityInvalidError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 260001
// - HTTP code: 400
// - message: "Service Plan Visibility is invalid: %s"
func IsServicePlanVisibilityInvalidError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 260001
}

// NewServicePlanVisibilityAlreadyExistsError returns a new CloudFoundryError
// that IsServicePlanVisibilityAlreadyExistsError will return true for
func NewServicePlanVisibilityAlreadyExistsError() CloudFoundryError {
	return CloudFoundryError{
		Code:        260002,
		ErrorCode:   "CF-ServicePlanVisibilityAlreadyExists",
		Description: "This combination of ServicePlan and Organization is already taken: %s",
	}
}

// IsServicePlanVisibilityAlreadyExistsError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 260002
// - HTTP code: 400
// - message: "This combination of ServicePlan and Organization is already taken: %s"
func IsServicePlanVisibilityAlreadyExistsError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 260002
}

// NewServicePlanVisibilityNotFoundError returns a new CloudFoundryError
// that IsServicePlanVisibilityNotFoundError will return true for
func NewServicePlanVisibilityNotFoundError() CloudFoundryError {
	return CloudFoundryError{
		Code:        260003,
		ErrorCode:   "CF-ServicePlanVisibilityNotFound",
		Description: "The service plan visibility could not be found: %s",
	}
}

// IsServicePlanVisibilityNotFoundError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 260003
// - HTTP code: 404
// - message: "The service plan visibility could not be found: %s"
func IsServicePlanVisibilityNotFoundError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 260003
}

// NewServiceBrokerInvalidError returns a new CloudFoundryError
// that IsServiceBrokerInvalidError will return true for
func NewServiceBrokerInvalidError() CloudFoundryError {
	return CloudFoundryError{
		Code:        270001,
		ErrorCode:   "CF-ServiceBrokerInvalid",
		Description: "Service broker is invalid: %s",
	}
}

// IsServiceBrokerInvalidError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 270001
// - HTTP code: 400
// - message: "Service broker is invalid: %s"
func IsServiceBrokerInvalidError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 270001
}

// NewServiceBrokerNameTakenError returns a new CloudFoundryError
// that IsServiceBrokerNameTakenError will return true for
func NewServiceBrokerNameTakenError() CloudFoundryError {
	return CloudFoundryError{
		Code:        270002,
		ErrorCode:   "CF-ServiceBrokerNameTaken",
		Description: "The service broker name is taken",
	}
}

// IsServiceBrokerNameTakenError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 270002
// - HTTP code: 400
// - message: "The service broker name is taken"
func IsServiceBrokerNameTakenError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 270002
}

// NewServiceBrokerUrlTakenError returns a new CloudFoundryError
// that IsServiceBrokerUrlTakenError will return true for
func NewServiceBrokerUrlTakenError() CloudFoundryError {
	return CloudFoundryError{
		Code:        270003,
		ErrorCode:   "CF-ServiceBrokerUrlTaken",
		Description: "The service broker url is taken: %s",
	}
}

// IsServiceBrokerUrlTakenError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 270003
// - HTTP code: 400
// - message: "The service broker url is taken: %s"
func IsServiceBrokerUrlTakenError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 270003
}

// NewServiceBrokerNotFoundError returns a new CloudFoundryError
// that IsServiceBrokerNotFoundError will return true for
func NewServiceBrokerNotFoundError() CloudFoundryError {
	return CloudFoundryError{
		Code:        270004,
		ErrorCode:   "CF-ServiceBrokerNotFound",
		Description: "The service broker was not found: %s",
	}
}

// IsServiceBrokerNotFoundError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 270004
// - HTTP code: 404
// - message: "The service broker was not found: %s"
func IsServiceBrokerNotFoundError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 270004
}

// NewServiceBrokerNotRemovableError returns a new CloudFoundryError
// that IsServiceBrokerNotRemovableError will return true for
func NewServiceBrokerNotRemovableError() CloudFoundryError {
	return CloudFoundryError{
		Code:        270010,
		ErrorCode:   "CF-ServiceBrokerNotRemovable",
		Description: "Can not remove brokers that have associated service instances: %s",
	}
}

// IsServiceBrokerNotRemovableError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 270010
// - HTTP code: 400
// - message: "Can not remove brokers that have associated service instances: %s"
func IsServiceBrokerNotRemovableError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 270010
}

// NewServiceBrokerUrlInvalidError returns a new CloudFoundryError
// that IsServiceBrokerUrlInvalidError will return true for
func NewServiceBrokerUrlInvalidError() CloudFoundryError {
	return CloudFoundryError{
		Code:        270011,
		ErrorCode:   "CF-ServiceBrokerUrlInvalid",
		Description: "%s is not a valid URL",
	}
}

// IsServiceBrokerUrlInvalidError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 270011
// - HTTP code: 400
// - message: "%s is not a valid URL"
func IsServiceBrokerUrlInvalidError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 270011
}

// NewServiceBrokerCatalogInvalidError returns a new CloudFoundryError
// that IsServiceBrokerCatalogInvalidError will return true for
func NewServiceBrokerCatalogInvalidError() CloudFoundryError {
	return CloudFoundryError{
		Code:        270012,
		ErrorCode:   "CF-ServiceBrokerCatalogInvalid",
		Description: "Service broker catalog is invalid: %s",
	}
}

// IsServiceBrokerCatalogInvalidError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 270012
// - HTTP code: 502
// - message: "Service broker catalog is invalid: %s"
func IsServiceBrokerCatalogInvalidError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 270012
}

// NewServiceBrokerDashboardClientFailureError returns a new CloudFoundryError
// that IsServiceBrokerDashboardClientFailureError will return true for
func NewServiceBrokerDashboardClientFailureError() CloudFoundryError {
	return CloudFoundryError{
		Code:        270013,
		ErrorCode:   "CF-ServiceBrokerDashboardClientFailure",
		Description: "Service broker dashboard clients could not be modified: %s",
	}
}

// IsServiceBrokerDashboardClientFailureError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 270013
// - HTTP code: 502
// - message: "Service broker dashboard clients could not be modified: %s"
func IsServiceBrokerDashboardClientFailureError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 270013
}

// NewServiceBrokerAsyncRequiredError returns a new CloudFoundryError
// that IsServiceBrokerAsyncRequiredError will return true for
func NewServiceBrokerAsyncRequiredError() CloudFoundryError {
	return CloudFoundryError{
		Code:        270014,
		ErrorCode:   "CF-ServiceBrokerAsyncRequired",
		Description: "This service plan requires client support for asynchronous service operations.",
	}
}

// IsServiceBrokerAsyncRequiredError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 270014
// - HTTP code: 400
// - message: "This service plan requires client support for asynchronous service operations."
func IsServiceBrokerAsyncRequiredError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 270014
}

// NewServiceDashboardClientMissingUrlError returns a new CloudFoundryError
// that IsServiceDashboardClientMissingUrlError will return true for
func NewServiceDashboardClientMissingUrlError() CloudFoundryError {
	return CloudFoundryError{
		Code:        270015,
		ErrorCode:   "CF-ServiceDashboardClientMissingUrl",
		Description: "Service broker returned dashboard client configuration without a dashboard URL",
	}
}

// IsServiceDashboardClientMissingUrlError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 270015
// - HTTP code: 502
// - message: "Service broker returned dashboard client configuration without a dashboard URL"
func IsServiceDashboardClientMissingUrlError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 270015
}

// NewServiceBrokerUrlBasicAuthNotSupportedError returns a new CloudFoundryError
// that IsServiceBrokerUrlBasicAuthNotSupportedError will return true for
func NewServiceBrokerUrlBasicAuthNotSupportedError() CloudFoundryError {
	return CloudFoundryError{
		Code:        270016,
		ErrorCode:   "CF-ServiceBrokerUrlBasicAuthNotSupported",
		Description: "User name and password fields in the broker URI are not supported",
	}
}

// IsServiceBrokerUrlBasicAuthNotSupportedError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 270016
// - HTTP code: 400
// - message: "User name and password fields in the broker URI are not supported"
func IsServiceBrokerUrlBasicAuthNotSupportedError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 270016
}

// NewServiceBrokerRespondedAsyncWhenNotAllowedError returns a new CloudFoundryError
// that IsServiceBrokerRespondedAsyncWhenNotAllowedError will return true for
func NewServiceBrokerRespondedAsyncWhenNotAllowedError() CloudFoundryError {
	return CloudFoundryError{
		Code:        270017,
		ErrorCode:   "CF-ServiceBrokerRespondedAsyncWhenNotAllowed",
		Description: "The service broker responded asynchronously to a request, but the accepts_incomplete query parameter was false or not given.",
	}
}

// IsServiceBrokerRespondedAsyncWhenNotAllowedError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 270017
// - HTTP code: 502
// - message: "The service broker responded asynchronously to a request, but the accepts_incomplete query parameter was false or not given."
func IsServiceBrokerRespondedAsyncWhenNotAllowedError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 270017
}

// NewServiceBrokerConcurrencyError returns a new CloudFoundryError
// that IsServiceBrokerConcurrencyError will return true for
func NewServiceBrokerConcurrencyError() CloudFoundryError {
	return CloudFoundryError{
		Code:        270018,
		ErrorCode:   "CF-ServiceBrokerConcurrencyError",
		Description: "The service broker could not perform this operation in parallel with other running operations",
	}
}

// IsServiceBrokerConcurrencyError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 270018
// - HTTP code: 422
// - message: "The service broker could not perform this operation in parallel with other running operations"
func IsServiceBrokerConcurrencyError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 270018
}

// NewServiceBrokerCatalogIncompatibleError returns a new CloudFoundryError
// that IsServiceBrokerCatalogIncompatibleError will return true for
func NewServiceBrokerCatalogIncompatibleError() CloudFoundryError {
	return CloudFoundryError{
		Code:        270019,
		ErrorCode:   "CF-ServiceBrokerCatalogIncompatible",
		Description: "Service broker catalog is incompatible: %s",
	}
}

// IsServiceBrokerCatalogIncompatibleError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 270019
// - HTTP code: 502
// - message: "Service broker catalog is incompatible: %s"
func IsServiceBrokerCatalogIncompatibleError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 270019
}

// NewServiceBrokerRequestRejectedError returns a new CloudFoundryError
// that IsServiceBrokerRequestRejectedError will return true for
func NewServiceBrokerRequestRejectedError() CloudFoundryError {
	return CloudFoundryError{
		Code:        270020,
		ErrorCode:   "CF-ServiceBrokerRequestRejected",
		Description: "The service broker rejected the request. Status Code: %s. Please check that the URL points to a valid service broker.",
	}
}

// IsServiceBrokerRequestRejectedError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 270020
// - HTTP code: 502
// - message: "The service broker rejected the request. Status Code: %s. Please check that the URL points to a valid service broker."
func IsServiceBrokerRequestRejectedError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 270020
}

// NewServiceBrokerRequestMalformedError returns a new CloudFoundryError
// that IsServiceBrokerRequestMalformedError will return true for
func NewServiceBrokerRequestMalformedError() CloudFoundryError {
	return CloudFoundryError{
		Code:        270021,
		ErrorCode:   "CF-ServiceBrokerRequestMalformed",
		Description: "The service broker returned an invalid response: expected valid JSON object in body. Please check that the URL points to a valid service broker.",
	}
}

// IsServiceBrokerRequestMalformedError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 270021
// - HTTP code: 502
// - message: "The service broker returned an invalid response: expected valid JSON object in body. Please check that the URL points to a valid service broker."
func IsServiceBrokerRequestMalformedError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 270021
}

// NewBuildpackNameStackTakenError returns a new CloudFoundryError
// that IsBuildpackNameStackTakenError will return true for
func NewBuildpackNameStackTakenError() CloudFoundryError {
	return CloudFoundryError{
		Code:        290000,
		ErrorCode:   "CF-BuildpackNameStackTaken",
		Description: "The buildpack name %s is already in use for the stack %s",
	}
}

// IsBuildpackNameStackTakenError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 290000
// - HTTP code: 422
// - message: "The buildpack name %s is already in use for the stack %s"
func IsBuildpackNameStackTakenError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 290000
}

// NewBuildpackNameTakenError returns a new CloudFoundryError
// that IsBuildpackNameTakenError will return true for
func NewBuildpackNameTakenError() CloudFoundryError {
	return CloudFoundryError{
		Code:        290001,
		ErrorCode:   "CF-BuildpackNameTaken",
		Description: "The buildpack name is already in use: %s",
	}
}

// IsBuildpackNameTakenError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 290001
// - HTTP code: 400
// - message: "The buildpack name is already in use: %s"
func IsBuildpackNameTakenError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 290001
}

// NewBuildpackBitsUploadInvalidError returns a new CloudFoundryError
// that IsBuildpackBitsUploadInvalidError will return true for
func NewBuildpackBitsUploadInvalidError() CloudFoundryError {
	return CloudFoundryError{
		Code:        290002,
		ErrorCode:   "CF-BuildpackBitsUploadInvalid",
		Description: "The buildpack upload is invalid: %s",
	}
}

// IsBuildpackBitsUploadInvalidError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 290002
// - HTTP code: 400
// - message: "The buildpack upload is invalid: %s"
func IsBuildpackBitsUploadInvalidError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 290002
}

// NewBuildpackInvalidError returns a new CloudFoundryError
// that IsBuildpackInvalidError will return true for
func NewBuildpackInvalidError() CloudFoundryError {
	return CloudFoundryError{
		Code:        290003,
		ErrorCode:   "CF-BuildpackInvalid",
		Description: "Buildpack is invalid: %s",
	}
}

// IsBuildpackInvalidError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 290003
// - HTTP code: 400
// - message: "Buildpack is invalid: %s"
func IsBuildpackInvalidError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 290003
}

// NewCustomBuildpacksDisabledError returns a new CloudFoundryError
// that IsCustomBuildpacksDisabledError will return true for
func NewCustomBuildpacksDisabledError() CloudFoundryError {
	return CloudFoundryError{
		Code:        290004,
		ErrorCode:   "CF-CustomBuildpacksDisabled",
		Description: "Custom buildpacks are disabled",
	}
}

// IsCustomBuildpacksDisabledError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 290004
// - HTTP code: 400
// - message: "Custom buildpacks are disabled"
func IsCustomBuildpacksDisabledError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 290004
}

// NewBuildpackLockedError returns a new CloudFoundryError
// that IsBuildpackLockedError will return true for
func NewBuildpackLockedError() CloudFoundryError {
	return CloudFoundryError{
		Code:        290005,
		ErrorCode:   "CF-BuildpackLocked",
		Description: "The buildpack is locked",
	}
}

// IsBuildpackLockedError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 290005
// - HTTP code: 409
// - message: "The buildpack is locked"
func IsBuildpackLockedError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 290005
}

// NewJobTimeoutError returns a new CloudFoundryError
// that IsJobTimeoutError will return true for
func NewJobTimeoutError() CloudFoundryError {
	return CloudFoundryError{
		Code:        290006,
		ErrorCode:   "CF-JobTimeout",
		Description: "The job execution has timed out.",
	}
}

// IsJobTimeoutError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 290006
// - HTTP code: 524
// - message: "The job execution has timed out."
func IsJobTimeoutError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 290006
}

// NewSpaceDeleteTimeoutError returns a new CloudFoundryError
// that IsSpaceDeleteTimeoutError will return true for
func NewSpaceDeleteTimeoutError() CloudFoundryError {
	return CloudFoundryError{
		Code:        290007,
		ErrorCode:   "CF-SpaceDeleteTimeout",
		Description: "Deletion of space %s timed out before all resources within could be deleted",
	}
}

// IsSpaceDeleteTimeoutError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 290007
// - HTTP code: 524
// - message: "Deletion of space %s timed out before all resources within could be deleted"
func IsSpaceDeleteTimeoutError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 290007
}

// NewSpaceDeletionFailedError returns a new CloudFoundryError
// that IsSpaceDeletionFailedError will return true for
func NewSpaceDeletionFailedError() CloudFoundryError {
	return CloudFoundryError{
		Code:        290008,
		ErrorCode:   "CF-SpaceDeletionFailed",
		Description: "Deletion of space %s failed because one or more resources within could not be deleted.%s",
	}
}

// IsSpaceDeletionFailedError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 290008
// - HTTP code: 502
// - message: "Deletion of space %s failed because one or more resources within could not be deleted.\n\n%s"
func IsSpaceDeletionFailedError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 290008
}

// NewOrganizationDeleteTimeoutError returns a new CloudFoundryError
// that IsOrganizationDeleteTimeoutError will return true for
func NewOrganizationDeleteTimeoutError() CloudFoundryError {
	return CloudFoundryError{
		Code:        290009,
		ErrorCode:   "CF-OrganizationDeleteTimeout",
		Description: "Delete of organization %s timed out before all resources within could be deleted",
	}
}

// IsOrganizationDeleteTimeoutError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 290009
// - HTTP code: 524
// - message: "Delete of organization %s timed out before all resources within could be deleted"
func IsOrganizationDeleteTimeoutError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 290009
}

// NewOrganizationDeletionFailedError returns a new CloudFoundryError
// that IsOrganizationDeletionFailedError will return true for
func NewOrganizationDeletionFailedError() CloudFoundryError {
	return CloudFoundryError{
		Code:        290010,
		ErrorCode:   "CF-OrganizationDeletionFailed",
		Description: "Deletion of organization %s failed because one or more resources within could not be deleted.%s",
	}
}

// IsOrganizationDeletionFailedError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 290010
// - HTTP code: 502
// - message: "Deletion of organization %s failed because one or more resources within could not be deleted.\n\n%s"
func IsOrganizationDeletionFailedError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 290010
}

// NewNonrecursiveSpaceDeletionFailedError returns a new CloudFoundryError
// that IsNonrecursiveSpaceDeletionFailedError will return true for
func NewNonrecursiveSpaceDeletionFailedError() CloudFoundryError {
	return CloudFoundryError{
		Code:        290011,
		ErrorCode:   "CF-NonrecursiveSpaceDeletionFailed",
		Description: "Resource inside space %s must first be deleted, or specify recursive delete.",
	}
}

// IsNonrecursiveSpaceDeletionFailedError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 290011
// - HTTP code: 400
// - message: "Resource inside space %s must first be deleted, or specify recursive delete."
func IsNonrecursiveSpaceDeletionFailedError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 290011
}

// NewBitsServiceError returns a new CloudFoundryError
// that IsBitsServiceError will return true for
func NewBitsServiceError() CloudFoundryError {
	return CloudFoundryError{
		Code:        290012,
		ErrorCode:   "CF-BitsServiceError",
		Description: "The bits service returned an error: %s",
	}
}

// IsBitsServiceError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 290012
// - HTTP code: 500
// - message: "The bits service returned an error: %s"
func IsBitsServiceError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 290012
}

// NewSpaceRolesDeletionTimeoutError returns a new CloudFoundryError
// that IsSpaceRolesDeletionTimeoutError will return true for
func NewSpaceRolesDeletionTimeoutError() CloudFoundryError {
	return CloudFoundryError{
		Code:        290013,
		ErrorCode:   "CF-SpaceRolesDeletionTimeout",
		Description: "Deletion of roles for space %s timed out before all roles could be deleted",
	}
}

// IsSpaceRolesDeletionTimeoutError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 290013
// - HTTP code: 524
// - message: "Deletion of roles for space %s timed out before all roles could be deleted"
func IsSpaceRolesDeletionTimeoutError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 290013
}

// NewOrganizationRolesDeletionFailedError returns a new CloudFoundryError
// that IsOrganizationRolesDeletionFailedError will return true for
func NewOrganizationRolesDeletionFailedError() CloudFoundryError {
	return CloudFoundryError{
		Code:        290014,
		ErrorCode:   "CF-OrganizationRolesDeletionFailed",
		Description: "Failed to delete one or more roles for organization %s",
	}
}

// IsOrganizationRolesDeletionFailedError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 290014
// - HTTP code: 502
// - message: "Failed to delete one or more roles for organization %s"
func IsOrganizationRolesDeletionFailedError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 290014
}

// NewSpaceRolesDeletionFailedError returns a new CloudFoundryError
// that IsSpaceRolesDeletionFailedError will return true for
func NewSpaceRolesDeletionFailedError() CloudFoundryError {
	return CloudFoundryError{
		Code:        290016,
		ErrorCode:   "CF-SpaceRolesDeletionFailed",
		Description: "Failed to delete one or more roles for space %s",
	}
}

// IsSpaceRolesDeletionFailedError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 290016
// - HTTP code: 502
// - message: "Failed to delete one or more roles for space %s"
func IsSpaceRolesDeletionFailedError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 290016
}

// NewSecurityGroupInvalidError returns a new CloudFoundryError
// that IsSecurityGroupInvalidError will return true for
func NewSecurityGroupInvalidError() CloudFoundryError {
	return CloudFoundryError{
		Code:        300001,
		ErrorCode:   "CF-SecurityGroupInvalid",
		Description: "The security group is invalid: %s",
	}
}

// IsSecurityGroupInvalidError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 300001
// - HTTP code: 400
// - message: "The security group is invalid: %s"
func IsSecurityGroupInvalidError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 300001
}

// NewSecurityGroupNotFoundError returns a new CloudFoundryError
// that IsSecurityGroupNotFoundError will return true for
func NewSecurityGroupNotFoundError() CloudFoundryError {
	return CloudFoundryError{
		Code:        300002,
		ErrorCode:   "CF-SecurityGroupNotFound",
		Description: "The security group could not be found: %s",
	}
}

// IsSecurityGroupNotFoundError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 300002
// - HTTP code: 404
// - message: "The security group could not be found: %s"
func IsSecurityGroupNotFoundError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 300002
}

// NewSecurityGroupStagingDefaultInvalidError returns a new CloudFoundryError
// that IsSecurityGroupStagingDefaultInvalidError will return true for
func NewSecurityGroupStagingDefaultInvalidError() CloudFoundryError {
	return CloudFoundryError{
		Code:        300003,
		ErrorCode:   "CF-SecurityGroupStagingDefaultInvalid",
		Description: "The security group could not be found: %s",
	}
}

// IsSecurityGroupStagingDefaultInvalidError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 300003
// - HTTP code: 400
// - message: "The security group could not be found: %s"
func IsSecurityGroupStagingDefaultInvalidError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 300003
}

// NewSecurityGroupRunningDefaultInvalidError returns a new CloudFoundryError
// that IsSecurityGroupRunningDefaultInvalidError will return true for
func NewSecurityGroupRunningDefaultInvalidError() CloudFoundryError {
	return CloudFoundryError{
		Code:        300004,
		ErrorCode:   "CF-SecurityGroupRunningDefaultInvalid",
		Description: "The security group could not be found: %s",
	}
}

// IsSecurityGroupRunningDefaultInvalidError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 300004
// - HTTP code: 400
// - message: "The security group could not be found: %s"
func IsSecurityGroupRunningDefaultInvalidError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 300004
}

// NewSecurityGroupNameTakenError returns a new CloudFoundryError
// that IsSecurityGroupNameTakenError will return true for
func NewSecurityGroupNameTakenError() CloudFoundryError {
	return CloudFoundryError{
		Code:        300005,
		ErrorCode:   "CF-SecurityGroupNameTaken",
		Description: "The security group name is taken: %s",
	}
}

// IsSecurityGroupNameTakenError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 300005
// - HTTP code: 400
// - message: "The security group name is taken: %s"
func IsSecurityGroupNameTakenError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 300005
}

// NewSpaceQuotaDefinitionInvalidError returns a new CloudFoundryError
// that IsSpaceQuotaDefinitionInvalidError will return true for
func NewSpaceQuotaDefinitionInvalidError() CloudFoundryError {
	return CloudFoundryError{
		Code:        310001,
		ErrorCode:   "CF-SpaceQuotaDefinitionInvalid",
		Description: "Space Quota Definition is invalid: %s",
	}
}

// IsSpaceQuotaDefinitionInvalidError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 310001
// - HTTP code: 400
// - message: "Space Quota Definition is invalid: %s"
func IsSpaceQuotaDefinitionInvalidError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 310001
}

// NewSpaceQuotaDefinitionNameTakenError returns a new CloudFoundryError
// that IsSpaceQuotaDefinitionNameTakenError will return true for
func NewSpaceQuotaDefinitionNameTakenError() CloudFoundryError {
	return CloudFoundryError{
		Code:        310002,
		ErrorCode:   "CF-SpaceQuotaDefinitionNameTaken",
		Description: "The space quota definition name is taken: %s",
	}
}

// IsSpaceQuotaDefinitionNameTakenError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 310002
// - HTTP code: 400
// - message: "The space quota definition name is taken: %s"
func IsSpaceQuotaDefinitionNameTakenError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 310002
}

// NewSpaceQuotaMemoryLimitExceededError returns a new CloudFoundryError
// that IsSpaceQuotaMemoryLimitExceededError will return true for
func NewSpaceQuotaMemoryLimitExceededError() CloudFoundryError {
	return CloudFoundryError{
		Code:        310003,
		ErrorCode:   "CF-SpaceQuotaMemoryLimitExceeded",
		Description: "You have exceeded your space's memory limit: %s",
	}
}

// IsSpaceQuotaMemoryLimitExceededError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 310003
// - HTTP code: 400
// - message: "You have exceeded your space's memory limit: %s"
func IsSpaceQuotaMemoryLimitExceededError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 310003
}

// NewSpaceQuotaInstanceMemoryLimitExceededError returns a new CloudFoundryError
// that IsSpaceQuotaInstanceMemoryLimitExceededError will return true for
func NewSpaceQuotaInstanceMemoryLimitExceededError() CloudFoundryError {
	return CloudFoundryError{
		Code:        310004,
		ErrorCode:   "CF-SpaceQuotaInstanceMemoryLimitExceeded",
		Description: "You have exceeded the instance memory limit for your space's quota.",
	}
}

// IsSpaceQuotaInstanceMemoryLimitExceededError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 310004
// - HTTP code: 400
// - message: "You have exceeded the instance memory limit for your space's quota."
func IsSpaceQuotaInstanceMemoryLimitExceededError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 310004
}

// NewSpaceQuotaTotalRoutesExceededError returns a new CloudFoundryError
// that IsSpaceQuotaTotalRoutesExceededError will return true for
func NewSpaceQuotaTotalRoutesExceededError() CloudFoundryError {
	return CloudFoundryError{
		Code:        310005,
		ErrorCode:   "CF-SpaceQuotaTotalRoutesExceeded",
		Description: "You have exceeded the total routes for your space's quota.",
	}
}

// IsSpaceQuotaTotalRoutesExceededError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 310005
// - HTTP code: 400
// - message: "You have exceeded the total routes for your space's quota."
func IsSpaceQuotaTotalRoutesExceededError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 310005
}

// NewOrgQuotaTotalRoutesExceededError returns a new CloudFoundryError
// that IsOrgQuotaTotalRoutesExceededError will return true for
func NewOrgQuotaTotalRoutesExceededError() CloudFoundryError {
	return CloudFoundryError{
		Code:        310006,
		ErrorCode:   "CF-OrgQuotaTotalRoutesExceeded",
		Description: "You have exceeded the total routes for your organization's quota.",
	}
}

// IsOrgQuotaTotalRoutesExceededError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 310006
// - HTTP code: 400
// - message: "You have exceeded the total routes for your organization's quota."
func IsOrgQuotaTotalRoutesExceededError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 310006
}

// NewSpaceQuotaDefinitionNotFoundError returns a new CloudFoundryError
// that IsSpaceQuotaDefinitionNotFoundError will return true for
func NewSpaceQuotaDefinitionNotFoundError() CloudFoundryError {
	return CloudFoundryError{
		Code:        310007,
		ErrorCode:   "CF-SpaceQuotaDefinitionNotFound",
		Description: "Space Quota Definition could not be found: %s",
	}
}

// IsSpaceQuotaDefinitionNotFoundError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 310007
// - HTTP code: 404
// - message: "Space Quota Definition could not be found: %s"
func IsSpaceQuotaDefinitionNotFoundError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 310007
}

// NewSpaceQuotaInstanceLimitExceededError returns a new CloudFoundryError
// that IsSpaceQuotaInstanceLimitExceededError will return true for
func NewSpaceQuotaInstanceLimitExceededError() CloudFoundryError {
	return CloudFoundryError{
		Code:        310008,
		ErrorCode:   "CF-SpaceQuotaInstanceLimitExceeded",
		Description: "You have exceeded the instance limit for your space's quota.",
	}
}

// IsSpaceQuotaInstanceLimitExceededError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 310008
// - HTTP code: 400
// - message: "You have exceeded the instance limit for your space's quota."
func IsSpaceQuotaInstanceLimitExceededError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 310008
}

// NewOrgQuotaTotalReservedRoutePortsExceededError returns a new CloudFoundryError
// that IsOrgQuotaTotalReservedRoutePortsExceededError will return true for
func NewOrgQuotaTotalReservedRoutePortsExceededError() CloudFoundryError {
	return CloudFoundryError{
		Code:        310009,
		ErrorCode:   "CF-OrgQuotaTotalReservedRoutePortsExceeded",
		Description: "You have exceeded the total reserved route ports for your organization's quota.",
	}
}

// IsOrgQuotaTotalReservedRoutePortsExceededError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 310009
// - HTTP code: 400
// - message: "You have exceeded the total reserved route ports for your organization's quota."
func IsOrgQuotaTotalReservedRoutePortsExceededError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 310009
}

// NewSpaceQuotaTotalReservedRoutePortsExceededError returns a new CloudFoundryError
// that IsSpaceQuotaTotalReservedRoutePortsExceededError will return true for
func NewSpaceQuotaTotalReservedRoutePortsExceededError() CloudFoundryError {
	return CloudFoundryError{
		Code:        310010,
		ErrorCode:   "CF-SpaceQuotaTotalReservedRoutePortsExceeded",
		Description: "You have exceeded the total reserved route ports for your space's quota.",
	}
}

// IsSpaceQuotaTotalReservedRoutePortsExceededError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 310010
// - HTTP code: 400
// - message: "You have exceeded the total reserved route ports for your space's quota."
func IsSpaceQuotaTotalReservedRoutePortsExceededError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 310010
}

// NewDiegoDisabledError returns a new CloudFoundryError
// that IsDiegoDisabledError will return true for
func NewDiegoDisabledError() CloudFoundryError {
	return CloudFoundryError{
		Code:        320001,
		ErrorCode:   "CF-DiegoDisabled",
		Description: "Diego has not been enabled.",
	}
}

// IsDiegoDisabledError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 320001
// - HTTP code: 400
// - message: "Diego has not been enabled."
func IsDiegoDisabledError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 320001
}

// NewDiegoDockerBuildpackConflictError returns a new CloudFoundryError
// that IsDiegoDockerBuildpackConflictError will return true for
func NewDiegoDockerBuildpackConflictError() CloudFoundryError {
	return CloudFoundryError{
		Code:        320002,
		ErrorCode:   "CF-DiegoDockerBuildpackConflict",
		Description: "You cannot specify a custom buildpack and a docker image at the same time.",
	}
}

// IsDiegoDockerBuildpackConflictError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 320002
// - HTTP code: 400
// - message: "You cannot specify a custom buildpack and a docker image at the same time."
func IsDiegoDockerBuildpackConflictError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 320002
}

// NewDockerDisabledError returns a new CloudFoundryError
// that IsDockerDisabledError will return true for
func NewDockerDisabledError() CloudFoundryError {
	return CloudFoundryError{
		Code:        320003,
		ErrorCode:   "CF-DockerDisabled",
		Description: "Docker support has not been enabled.",
	}
}

// IsDockerDisabledError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 320003
// - HTTP code: 400
// - message: "Docker support has not been enabled."
func IsDockerDisabledError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 320003
}

// NewStagingBackendInvalidError returns a new CloudFoundryError
// that IsStagingBackendInvalidError will return true for
func NewStagingBackendInvalidError() CloudFoundryError {
	return CloudFoundryError{
		Code:        320004,
		ErrorCode:   "CF-StagingBackendInvalid",
		Description: "The request staging completion endpoint only handles apps desired to stage on the Diego backend.",
	}
}

// IsStagingBackendInvalidError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 320004
// - HTTP code: 403
// - message: "The request staging completion endpoint only handles apps desired to stage on the Diego backend."
func IsStagingBackendInvalidError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 320004
}

// NewBackendSelectionNotAuthorizedError returns a new CloudFoundryError
// that IsBackendSelectionNotAuthorizedError will return true for
func NewBackendSelectionNotAuthorizedError() CloudFoundryError {
	return CloudFoundryError{
		Code:        320005,
		ErrorCode:   "CF-BackendSelectionNotAuthorized",
		Description: "You cannot select the backend on which to run this application",
	}
}

// IsBackendSelectionNotAuthorizedError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 320005
// - HTTP code: 403
// - message: "You cannot select the backend on which to run this application"
func IsBackendSelectionNotAuthorizedError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 320005
}

// NewRevisionsEnabledError returns a new CloudFoundryError
// that IsRevisionsEnabledError will return true for
func NewRevisionsEnabledError() CloudFoundryError {
	return CloudFoundryError{
		Code:        320006,
		ErrorCode:   "CF-RevisionsEnabled",
		Description: "V2 restaging is disabled when your app has revisions enabled",
	}
}

// IsRevisionsEnabledError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 320006
// - HTTP code: 400
// - message: "V2 restaging is disabled when your app has revisions enabled"
func IsRevisionsEnabledError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 320006
}

// NewFeatureFlagNotFoundError returns a new CloudFoundryError
// that IsFeatureFlagNotFoundError will return true for
func NewFeatureFlagNotFoundError() CloudFoundryError {
	return CloudFoundryError{
		Code:        330000,
		ErrorCode:   "CF-FeatureFlagNotFound",
		Description: "The feature flag could not be found: %s",
	}
}

// IsFeatureFlagNotFoundError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 330000
// - HTTP code: 404
// - message: "The feature flag could not be found: %s"
func IsFeatureFlagNotFoundError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 330000
}

// NewFeatureFlagInvalidError returns a new CloudFoundryError
// that IsFeatureFlagInvalidError will return true for
func NewFeatureFlagInvalidError() CloudFoundryError {
	return CloudFoundryError{
		Code:        330001,
		ErrorCode:   "CF-FeatureFlagInvalid",
		Description: "The feature flag is invalid: %s",
	}
}

// IsFeatureFlagInvalidError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 330001
// - HTTP code: 400
// - message: "The feature flag is invalid: %s"
func IsFeatureFlagInvalidError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 330001
}

// NewFeatureDisabledError returns a new CloudFoundryError
// that IsFeatureDisabledError will return true for
func NewFeatureDisabledError() CloudFoundryError {
	return CloudFoundryError{
		Code:        330002,
		ErrorCode:   "CF-FeatureDisabled",
		Description: "Feature Disabled: %s",
	}
}

// IsFeatureDisabledError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 330002
// - HTTP code: 403
// - message: "Feature Disabled: %s"
func IsFeatureDisabledError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 330002
}

// NewUserProvidedServiceInstanceNotFoundError returns a new CloudFoundryError
// that IsUserProvidedServiceInstanceNotFoundError will return true for
func NewUserProvidedServiceInstanceNotFoundError() CloudFoundryError {
	return CloudFoundryError{
		Code:        340001,
		ErrorCode:   "CF-UserProvidedServiceInstanceNotFound",
		Description: "The service instance could not be found: %s",
	}
}

// IsUserProvidedServiceInstanceNotFoundError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 340001
// - HTTP code: 404
// - message: "The service instance could not be found: %s"
func IsUserProvidedServiceInstanceNotFoundError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 340001
}

// NewUserProvidedServiceInstanceHandlerNeededError returns a new CloudFoundryError
// that IsUserProvidedServiceInstanceHandlerNeededError will return true for
func NewUserProvidedServiceInstanceHandlerNeededError() CloudFoundryError {
	return CloudFoundryError{
		Code:        340002,
		ErrorCode:   "CF-UserProvidedServiceInstanceHandlerNeeded",
		Description: "Please use the User Provided Services API to manage this resource.",
	}
}

// IsUserProvidedServiceInstanceHandlerNeededError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 340002
// - HTTP code: 400
// - message: "Please use the User Provided Services API to manage this resource."
func IsUserProvidedServiceInstanceHandlerNeededError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 340002
}

// NewProcessInvalidError returns a new CloudFoundryError
// that IsProcessInvalidError will return true for
func NewProcessInvalidError() CloudFoundryError {
	return CloudFoundryError{
		Code:        350001,
		ErrorCode:   "CF-ProcessInvalid",
		Description: "The process is invalid: %s",
	}
}

// IsProcessInvalidError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 350001
// - HTTP code: 400
// - message: "The process is invalid: %s"
func IsProcessInvalidError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 350001
}

// NewUnableToDeleteError returns a new CloudFoundryError
// that IsUnableToDeleteError will return true for
func NewUnableToDeleteError() CloudFoundryError {
	return CloudFoundryError{
		Code:        350002,
		ErrorCode:   "CF-UnableToDelete",
		Description: "Unable to perform delete action: %s",
	}
}

// IsUnableToDeleteError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 350002
// - HTTP code: 400
// - message: "Unable to perform delete action: %s"
func IsUnableToDeleteError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 350002
}

// NewProcessNotFoundError returns a new CloudFoundryError
// that IsProcessNotFoundError will return true for
func NewProcessNotFoundError() CloudFoundryError {
	return CloudFoundryError{
		Code:        350003,
		ErrorCode:   "CF-ProcessNotFound",
		Description: "The process could not be found: %s",
	}
}

// IsProcessNotFoundError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 350003
// - HTTP code: 404
// - message: "The process could not be found: %s"
func IsProcessNotFoundError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 350003
}

// NewServiceKeyNameTakenError returns a new CloudFoundryError
// that IsServiceKeyNameTakenError will return true for
func NewServiceKeyNameTakenError() CloudFoundryError {
	return CloudFoundryError{
		Code:        360001,
		ErrorCode:   "CF-ServiceKeyNameTaken",
		Description: "The service key name is taken: %s",
	}
}

// IsServiceKeyNameTakenError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 360001
// - HTTP code: 400
// - message: "The service key name is taken: %s"
func IsServiceKeyNameTakenError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 360001
}

// NewServiceKeyInvalidError returns a new CloudFoundryError
// that IsServiceKeyInvalidError will return true for
func NewServiceKeyInvalidError() CloudFoundryError {
	return CloudFoundryError{
		Code:        360002,
		ErrorCode:   "CF-ServiceKeyInvalid",
		Description: "The service key is invalid: %s",
	}
}

// IsServiceKeyInvalidError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 360002
// - HTTP code: 400
// - message: "The service key is invalid: %s"
func IsServiceKeyInvalidError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 360002
}

// NewServiceKeyNotFoundError returns a new CloudFoundryError
// that IsServiceKeyNotFoundError will return true for
func NewServiceKeyNotFoundError() CloudFoundryError {
	return CloudFoundryError{
		Code:        360003,
		ErrorCode:   "CF-ServiceKeyNotFound",
		Description: "The service key could not be found: %s",
	}
}

// IsServiceKeyNotFoundError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 360003
// - HTTP code: 404
// - message: "The service key could not be found: %s"
func IsServiceKeyNotFoundError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 360003
}

// NewServiceKeyNotSupportedError returns a new CloudFoundryError
// that IsServiceKeyNotSupportedError will return true for
func NewServiceKeyNotSupportedError() CloudFoundryError {
	return CloudFoundryError{
		Code:        360004,
		ErrorCode:   "CF-ServiceKeyNotSupported",
		Description: "%s",
	}
}

// IsServiceKeyNotSupportedError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 360004
// - HTTP code: 400
// - message: "%s"
func IsServiceKeyNotSupportedError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 360004
}

// NewServiceKeyCredentialStoreUnavailableError returns a new CloudFoundryError
// that IsServiceKeyCredentialStoreUnavailableError will return true for
func NewServiceKeyCredentialStoreUnavailableError() CloudFoundryError {
	return CloudFoundryError{
		Code:        360005,
		ErrorCode:   "CF-ServiceKeyCredentialStoreUnavailable",
		Description: "Credential store is unavailable",
	}
}

// IsServiceKeyCredentialStoreUnavailableError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 360005
// - HTTP code: 503
// - message: "Credential store is unavailable"
func IsServiceKeyCredentialStoreUnavailableError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 360005
}

// NewRoutingApiUnavailableError returns a new CloudFoundryError
// that IsRoutingApiUnavailableError will return true for
func NewRoutingApiUnavailableError() CloudFoundryError {
	return CloudFoundryError{
		Code:        370001,
		ErrorCode:   "CF-RoutingApiUnavailable",
		Description: "The Routing API is currently unavailable",
	}
}

// IsRoutingApiUnavailableError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 370001
// - HTTP code: 503
// - message: "The Routing API is currently unavailable"
func IsRoutingApiUnavailableError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 370001
}

// NewRoutingApiDisabledError returns a new CloudFoundryError
// that IsRoutingApiDisabledError will return true for
func NewRoutingApiDisabledError() CloudFoundryError {
	return CloudFoundryError{
		Code:        370003,
		ErrorCode:   "CF-RoutingApiDisabled",
		Description: "Routing API is disabled",
	}
}

// IsRoutingApiDisabledError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 370003
// - HTTP code: 403
// - message: "Routing API is disabled"
func IsRoutingApiDisabledError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 370003
}

// NewEnvironmentVariableGroupInvalidError returns a new CloudFoundryError
// that IsEnvironmentVariableGroupInvalidError will return true for
func NewEnvironmentVariableGroupInvalidError() CloudFoundryError {
	return CloudFoundryError{
		Code:        380001,
		ErrorCode:   "CF-EnvironmentVariableGroupInvalid",
		Description: "The Environment Variable Group is invalid: %s",
	}
}

// IsEnvironmentVariableGroupInvalidError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 380001
// - HTTP code: 400
// - message: "The Environment Variable Group is invalid: %s"
func IsEnvironmentVariableGroupInvalidError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 380001
}

// NewDropletUploadInvalidError returns a new CloudFoundryError
// that IsDropletUploadInvalidError will return true for
func NewDropletUploadInvalidError() CloudFoundryError {
	return CloudFoundryError{
		Code:        380002,
		ErrorCode:   "CF-DropletUploadInvalid",
		Description: "The droplet upload is invalid: %s",
	}
}

// IsDropletUploadInvalidError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 380002
// - HTTP code: 400
// - message: "The droplet upload is invalid: %s"
func IsDropletUploadInvalidError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 380002
}

// NewServiceInstanceUnshareFailedError returns a new CloudFoundryError
// that IsServiceInstanceUnshareFailedError will return true for
func NewServiceInstanceUnshareFailedError() CloudFoundryError {
	return CloudFoundryError{
		Code:        390001,
		ErrorCode:   "CF-ServiceInstanceUnshareFailed",
		Description: "Unshare of service instance failed: %s",
	}
}

// IsServiceInstanceUnshareFailedError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 390001
// - HTTP code: 502
// - message: "Unshare of service instance failed: \n\n%s"
func IsServiceInstanceUnshareFailedError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 390001
}

// NewServiceInstanceDeletionSharesExistsError returns a new CloudFoundryError
// that IsServiceInstanceDeletionSharesExistsError will return true for
func NewServiceInstanceDeletionSharesExistsError() CloudFoundryError {
	return CloudFoundryError{
		Code:        390002,
		ErrorCode:   "CF-ServiceInstanceDeletionSharesExists",
		Description: "Service instances must be unshared before they can be deleted. Unsharing %s will automatically delete any bindings that have been made to applications in other spaces.",
	}
}

// IsServiceInstanceDeletionSharesExistsError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 390002
// - HTTP code: 422
// - message: "Service instances must be unshared before they can be deleted. Unsharing %s will automatically delete any bindings that have been made to applications in other spaces."
func IsServiceInstanceDeletionSharesExistsError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 390002
}

// NewSharedServiceInstanceCannotBeRenamedError returns a new CloudFoundryError
// that IsSharedServiceInstanceCannotBeRenamedError will return true for
func NewSharedServiceInstanceCannotBeRenamedError() CloudFoundryError {
	return CloudFoundryError{
		Code:        390003,
		ErrorCode:   "CF-SharedServiceInstanceCannotBeRenamed",
		Description: "Service instances that have been shared cannot be renamed",
	}
}

// IsSharedServiceInstanceCannotBeRenamedError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 390003
// - HTTP code: 422
// - message: "Service instances that have been shared cannot be renamed"
func IsSharedServiceInstanceCannotBeRenamedError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 390003
}

// NewSharedServiceInstanceNotUpdatableInTargetSpaceError returns a new CloudFoundryError
// that IsSharedServiceInstanceNotUpdatableInTargetSpaceError will return true for
func NewSharedServiceInstanceNotUpdatableInTargetSpaceError() CloudFoundryError {
	return CloudFoundryError{
		Code:        390004,
		ErrorCode:   "CF-SharedServiceInstanceNotUpdatableInTargetSpace",
		Description: "You cannot update service instances that have been shared with you",
	}
}

// IsSharedServiceInstanceNotUpdatableInTargetSpaceError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 390004
// - HTTP code: 403
// - message: "You cannot update service instances that have been shared with you"
func IsSharedServiceInstanceNotUpdatableInTargetSpaceError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 390004
}

// NewSharedServiceInstanceNotDeletableInTargetSpaceError returns a new CloudFoundryError
// that IsSharedServiceInstanceNotDeletableInTargetSpaceError will return true for
func NewSharedServiceInstanceNotDeletableInTargetSpaceError() CloudFoundryError {
	return CloudFoundryError{
		Code:        390005,
		ErrorCode:   "CF-SharedServiceInstanceNotDeletableInTargetSpace",
		Description: "You cannot delete service instances that have been shared with you",
	}
}

// IsSharedServiceInstanceNotDeletableInTargetSpaceError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 390005
// - HTTP code: 403
// - message: "You cannot delete service instances that have been shared with you"
func IsSharedServiceInstanceNotDeletableInTargetSpaceError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 390005
}

// NewMaintenanceInfoNotSupportedError returns a new CloudFoundryError
// that IsMaintenanceInfoNotSupportedError will return true for
func NewMaintenanceInfoNotSupportedError() CloudFoundryError {
	return CloudFoundryError{
		Code:        390006,
		ErrorCode:   "CF-MaintenanceInfoNotSupported",
		Description: "The service broker does not support upgrades for service instances created from this plan.",
	}
}

// IsMaintenanceInfoNotSupportedError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 390006
// - HTTP code: 422
// - message: "The service broker does not support upgrades for service instances created from this plan."
func IsMaintenanceInfoNotSupportedError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 390006
}

// NewMaintenanceInfoNotSemverError returns a new CloudFoundryError
// that IsMaintenanceInfoNotSemverError will return true for
func NewMaintenanceInfoNotSemverError() CloudFoundryError {
	return CloudFoundryError{
		Code:        390007,
		ErrorCode:   "CF-MaintenanceInfoNotSemver",
		Description: "maintenance_info.version should be a semantic version.",
	}
}

// IsMaintenanceInfoNotSemverError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 390007
// - HTTP code: 422
// - message: "maintenance_info.version should be a semantic version."
func IsMaintenanceInfoNotSemverError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 390007
}

// NewMaintenanceInfoNotUpdatableWhenChangingPlanError returns a new CloudFoundryError
// that IsMaintenanceInfoNotUpdatableWhenChangingPlanError will return true for
func NewMaintenanceInfoNotUpdatableWhenChangingPlanError() CloudFoundryError {
	return CloudFoundryError{
		Code:        390008,
		ErrorCode:   "CF-MaintenanceInfoNotUpdatableWhenChangingPlan",
		Description: "maintenance_info should not be changed when switching to different plan.",
	}
}

// IsMaintenanceInfoNotUpdatableWhenChangingPlanError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 390008
// - HTTP code: 422
// - message: "maintenance_info should not be changed when switching to different plan."
func IsMaintenanceInfoNotUpdatableWhenChangingPlanError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 390008
}

// NewMaintenanceInfoConflictError returns a new CloudFoundryError
// that IsMaintenanceInfoConflictError will return true for
func NewMaintenanceInfoConflictError() CloudFoundryError {
	return CloudFoundryError{
		Code:        390009,
		ErrorCode:   "CF-MaintenanceInfoConflict",
		Description: "maintenance_info.version requested is invalid. Please ensure the catalog is up to date and you are providing a version supported by this service plan.",
	}
}

// IsMaintenanceInfoConflictError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 390009
// - HTTP code: 422
// - message: "maintenance_info.version requested is invalid. Please ensure the catalog is up to date and you are providing a version supported by this service plan."
func IsMaintenanceInfoConflictError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 390009
}

// NewBuildpackStacksDontMatchError returns a new CloudFoundryError
// that IsBuildpackStacksDontMatchError will return true for
func NewBuildpackStacksDontMatchError() CloudFoundryError {
	return CloudFoundryError{
		Code:        390011,
		ErrorCode:   "CF-BuildpackStacksDontMatch",
		Description: "Uploaded buildpack stack (%s) does not match %s",
	}
}

// IsBuildpackStacksDontMatchError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 390011
// - HTTP code: 422
// - message: "Uploaded buildpack stack (%s) does not match %s"
func IsBuildpackStacksDontMatchError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 390011
}

// NewBuildpackStackDoesNotExistError returns a new CloudFoundryError
// that IsBuildpackStackDoesNotExistError will return true for
func NewBuildpackStackDoesNotExistError() CloudFoundryError {
	return CloudFoundryError{
		Code:        390012,
		ErrorCode:   "CF-BuildpackStackDoesNotExist",
		Description: "Uploaded buildpack stack (%s) does not exist",
	}
}

// IsBuildpackStackDoesNotExistError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 390012
// - HTTP code: 422
// - message: "Uploaded buildpack stack (%s) does not exist"
func IsBuildpackStackDoesNotExistError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 390012
}

// NewBuildpackZipError returns a new CloudFoundryError
// that IsBuildpackZipError will return true for
func NewBuildpackZipError() CloudFoundryError {
	return CloudFoundryError{
		Code:        390013,
		ErrorCode:   "CF-BuildpackZipError",
		Description: "Buildpack zip error: %s",
	}
}

// IsBuildpackZipError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 390013
// - HTTP code: 422
// - message: "Buildpack zip error: %s"
func IsBuildpackZipError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 390013
}

// NewDeploymentsDisabledError returns a new CloudFoundryError
// that IsDeploymentsDisabledError will return true for
func NewDeploymentsDisabledError() CloudFoundryError {
	return CloudFoundryError{
		Code:        390014,
		ErrorCode:   "CF-DeploymentsDisabled",
		Description: "Deployments cannot be created due to manifest property 'temporary_disable_deployments'",
	}
}

// IsDeploymentsDisabledError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 390014
// - HTTP code: 403
// - message: "Deployments cannot be created due to manifest property 'temporary_disable_deployments'"
func IsDeploymentsDisabledError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 390014
}

// NewNoCurrentEncryptionKeyError returns a new CloudFoundryError
// that IsNoCurrentEncryptionKeyError will return true for
func NewNoCurrentEncryptionKeyError() CloudFoundryError {
	return CloudFoundryError{
		Code:        390015,
		ErrorCode:   "CF-NoCurrentEncryptionKey",
		Description: "Please set the desired encryption key in the manifest at ‘cc.database_encryption.current_key_label’",
	}
}

// IsNoCurrentEncryptionKeyError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 390015
// - HTTP code: 422
// - message: "Please set the desired encryption key in the manifest at ‘cc.database_encryption.current_key_label’"
func IsNoCurrentEncryptionKeyError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 390015
}

// NewScaleDisabledDuringDeploymentError returns a new CloudFoundryError
// that IsScaleDisabledDuringDeploymentError will return true for
func NewScaleDisabledDuringDeploymentError() CloudFoundryError {
	return CloudFoundryError{
		Code:        390016,
		ErrorCode:   "CF-ScaleDisabledDuringDeployment",
		Description: "Cannot scale this process while a deployment is in flight.",
	}
}

// IsScaleDisabledDuringDeploymentError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 390016
// - HTTP code: 422
// - message: "Cannot scale this process while a deployment is in flight."
func IsScaleDisabledDuringDeploymentError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 390016
}

// NewProcessUpdateDisabledDuringDeploymentError returns a new CloudFoundryError
// that IsProcessUpdateDisabledDuringDeploymentError will return true for
func NewProcessUpdateDisabledDuringDeploymentError() CloudFoundryError {
	return CloudFoundryError{
		Code:        390017,
		ErrorCode:   "CF-ProcessUpdateDisabledDuringDeployment",
		Description: "Cannot update this process while a deployment is in flight.",
	}
}

// IsProcessUpdateDisabledDuringDeploymentError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 390017
// - HTTP code: 422
// - message: "Cannot update this process while a deployment is in flight."
func IsProcessUpdateDisabledDuringDeploymentError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 390017
}

// NewLabelLimitExceededError returns a new CloudFoundryError
// that IsLabelLimitExceededError will return true for
func NewLabelLimitExceededError() CloudFoundryError {
	return CloudFoundryError{
		Code:        390020,
		ErrorCode:   "CF-LabelLimitExceeded",
		Description: "Failed to add %d labels because it would exceed maximum of %d",
	}
}

// IsLabelLimitExceededError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 390020
// - HTTP code: 422
// - message: "Failed to add %d labels because it would exceed maximum of %d"
func IsLabelLimitExceededError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 390020
}

// NewAnnotationLimitExceededError returns a new CloudFoundryError
// that IsAnnotationLimitExceededError will return true for
func NewAnnotationLimitExceededError() CloudFoundryError {
	return CloudFoundryError{
		Code:        390023,
		ErrorCode:   "CF-AnnotationLimitExceeded",
		Description: "Failed to add %d annotations because it would exceed maximum of %d",
	}
}

// IsAnnotationLimitExceededError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 390023
// - HTTP code: 422
// - message: "Failed to add %d annotations because it would exceed maximum of %d"
func IsAnnotationLimitExceededError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 390023
}

// NewStopDisabledDuringDeploymentError returns a new CloudFoundryError
// that IsStopDisabledDuringDeploymentError will return true for
func NewStopDisabledDuringDeploymentError() CloudFoundryError {
	return CloudFoundryError{
		Code:        390024,
		ErrorCode:   "CF-StopDisabledDuringDeployment",
		Description: "Cannot stop the app while it is deploying, please cancel the deployment before stopping the app.",
	}
}

// IsStopDisabledDuringDeploymentError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 390024
// - HTTP code: 422
// - message: "Cannot stop the app while it is deploying, please cancel the deployment before stopping the app."
func IsStopDisabledDuringDeploymentError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 390024
}

// NewKubernetesRouteResourceError returns a new CloudFoundryError
// that IsKubernetesRouteResourceError will return true for
func NewKubernetesRouteResourceError() CloudFoundryError {
	return CloudFoundryError{
		Code:        400001,
		ErrorCode:   "CF-KubernetesRouteResourceError",
		Description: "Failed to create/update/delete Route resource with guid '%s' on Kubernetes",
	}
}

// IsKubernetesRouteResourceError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 400001
// - HTTP code: 422
// - message: "Failed to create/update/delete Route resource with guid '%s' on Kubernetes"
func IsKubernetesRouteResourceError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 400001
}

// NewKpackImageError returns a new CloudFoundryError
// that IsKpackImageError will return true for
func NewKpackImageError() CloudFoundryError {
	return CloudFoundryError{
		Code:        400002,
		ErrorCode:   "CF-KpackImageError",
		Description: "Failed to %s Image resource for staging: '%s'",
	}
}

// IsKpackImageError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 400002
// - HTTP code: 422
// - message: "Failed to %s Image resource for staging: '%s'"
func IsKpackImageError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 400002
}

// NewKpackBuilderError returns a new CloudFoundryError
// that IsKpackBuilderError will return true for
func NewKpackBuilderError() CloudFoundryError {
	return CloudFoundryError{
		Code:        400003,
		ErrorCode:   "CF-KpackBuilderError",
		Description: "Failed to %s Builder resource: '%s'",
	}
}

// IsKpackBuilderError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 400003
// - HTTP code: 422
// - message: "Failed to %s Builder resource: '%s'"
func IsKpackBuilderError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 400003
}

// NewEiriniLRPError returns a new CloudFoundryError
// that IsEiriniLRPError will return true for
func NewEiriniLRPError() CloudFoundryError {
	return CloudFoundryError{
		Code:        410001,
		ErrorCode:   "CF-EiriniLRPError",
		Description: "Failed to %s LRP resource: '%s'",
	}
}

// IsEiriniLRPError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 410001
// - HTTP code: 422
// - message: "Failed to %s LRP resource: '%s'"
func IsEiriniLRPError(err error) bool {
	cferr, ok := cloudFoundryError(err)
	if !ok {
		return false
	}
	return cferr.Code == 410001
}

func cloudFoundryError(err error) (cferr CloudFoundryError, ok bool) {
	type causer interface {
		Cause() error
	}
	if _, isCauser := err.(causer); isCauser {
		cause := pkgerrors.Cause(err)
		cferr, ok = cause.(CloudFoundryError)
	} else {
		ok = stderrors.As(err, &cferr)
	}
	return cferr, ok
}
