/** @file
 * VirtualBox API class wrapper code for IEmulatedUSB.
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl
 * Generator: src/VBox/Main/idl/apiwrap-server.xsl
 */

/*
 * Copyright (C) 2010-2025 Oracle and/or its affiliates.
 *
 * This file is part of VirtualBox base platform packages, as
 * available from https://www.virtualbox.org.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation, in version 3 of the
 * License.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <https://www.gnu.org/licenses>.
 *
 * SPDX-License-Identifier: GPL-3.0-only
 */

#define LOG_GROUP LOG_GROUP_MAIN_EMULATEDUSB

#include "EmulatedUSBWrap.h"
#include "LoggingNew.h"
#ifdef VBOX_WITH_DTRACE_R3_MAIN
# include "dtrace/VBoxAPI.h"
#endif

DEFINE_EMPTY_CTOR_DTOR(EmulatedUSBWrap)

//
// IEmulatedUSB properties
//

STDMETHODIMP EmulatedUSBWrap::COMGETTER(Webcams)(ComSafeArrayOut(BSTR, aWebcams))
{
    LogRelFlow(("{%p} %s: enter aWebcams=%p\n", this, "EmulatedUSB::getWebcams", aWebcams));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aWebcams);
        ArrayBSTROutConverter TmpWebcams(ComSafeArrayOutArg(aWebcams));
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EMULATEDUSB_GET_WEBCAMS_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getWebcams(TmpWebcams.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EMULATEDUSB_GET_WEBCAMS_RETURN(this, hrc, 0 /*normal*/,(uint32_t)TmpWebcams.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EMULATEDUSB_GET_WEBCAMS_RETURN(this, hrc, 1 /*hrc exception*/,0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EMULATEDUSB_GET_WEBCAMS_RETURN(this, hrc, 9 /*unhandled exception*/,0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aWebcams=%zu hrc=%Rhrc\n", this, "EmulatedUSB::getWebcams", ComSafeArraySize(*aWebcams), hrc));
    return hrc;
}

STDMETHODIMP EmulatedUSBWrap::COMGETTER(InternalAndReservedAttribute1IEmulatedUSB)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP EmulatedUSBWrap::COMGETTER(InternalAndReservedAttribute2IEmulatedUSB)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP EmulatedUSBWrap::COMGETTER(InternalAndReservedAttribute3IEmulatedUSB)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP EmulatedUSBWrap::COMGETTER(InternalAndReservedAttribute4IEmulatedUSB)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}


//
// IEmulatedUSB methods
//

STDMETHODIMP EmulatedUSBWrap::WebcamAttach(IN_BSTR aPath,
                                           IN_BSTR aSettings)
{
    LogRelFlow(("{%p} %s: enter aPath=%ls aSettings=%ls\n", this, "EmulatedUSB::webcamAttach", aPath, aSettings));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        BSTRInConverter TmpPath(aPath);
        BSTRInConverter TmpSettings(aSettings);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EMULATEDUSB_WEBCAMATTACH_ENTER(this, TmpPath.str().c_str(), TmpSettings.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = webcamAttach(TmpPath.str(),
                               TmpSettings.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EMULATEDUSB_WEBCAMATTACH_RETURN(this, hrc, 0 /*normal*/, TmpPath.str().c_str(), TmpSettings.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EMULATEDUSB_WEBCAMATTACH_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EMULATEDUSB_WEBCAMATTACH_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "EmulatedUSB::webcamAttach", hrc));
    return hrc;
}

STDMETHODIMP EmulatedUSBWrap::WebcamDetach(IN_BSTR aPath)
{
    LogRelFlow(("{%p} %s: enter aPath=%ls\n", this, "EmulatedUSB::webcamDetach", aPath));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        BSTRInConverter TmpPath(aPath);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EMULATEDUSB_WEBCAMDETACH_ENTER(this, TmpPath.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = webcamDetach(TmpPath.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EMULATEDUSB_WEBCAMDETACH_RETURN(this, hrc, 0 /*normal*/, TmpPath.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EMULATEDUSB_WEBCAMDETACH_RETURN(this, hrc, 1 /*hrc exception*/, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EMULATEDUSB_WEBCAMDETACH_RETURN(this, hrc, 9 /*unhandled exception*/, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "EmulatedUSB::webcamDetach", hrc));
    return hrc;
}

STDMETHODIMP EmulatedUSBWrap::InternalAndReservedMethod1IEmulatedUSB()
{
    return E_NOTIMPL;
}

STDMETHODIMP EmulatedUSBWrap::InternalAndReservedMethod2IEmulatedUSB()
{
    return E_NOTIMPL;
}

STDMETHODIMP EmulatedUSBWrap::InternalAndReservedMethod3IEmulatedUSB()
{
    return E_NOTIMPL;
}

STDMETHODIMP EmulatedUSBWrap::InternalAndReservedMethod4IEmulatedUSB()
{
    return E_NOTIMPL;
}

#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(EmulatedUSBWrap)
NS_IMPL_THREADSAFE_ISUPPORTS1_CI(EmulatedUSBWrap, IEmulatedUSB)
#endif // VBOX_WITH_XPCOM
