/** @file
 * VirtualBox API class wrapper code for IGraphicsAdapter.
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl
 * Generator: src/VBox/Main/idl/apiwrap-server.xsl
 */

/*
 * Copyright (C) 2010-2025 Oracle and/or its affiliates.
 *
 * This file is part of VirtualBox base platform packages, as
 * available from https://www.virtualbox.org.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation, in version 3 of the
 * License.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <https://www.gnu.org/licenses>.
 *
 * SPDX-License-Identifier: GPL-3.0-only
 */

#define LOG_GROUP LOG_GROUP_MAIN_GRAPHICSADAPTER

#include "GraphicsAdapterWrap.h"
#include "LoggingNew.h"
#ifdef VBOX_WITH_DTRACE_R3_MAIN
# include "dtrace/VBoxAPI.h"
#endif

DEFINE_EMPTY_CTOR_DTOR(GraphicsAdapterWrap)

//
// IGraphicsAdapter properties
//

STDMETHODIMP GraphicsAdapterWrap::COMGETTER(GraphicsControllerType)(GraphicsControllerType_T *aGraphicsControllerType)
{
    LogRelFlow(("{%p} %s: enter aGraphicsControllerType=%p\n", this, "GraphicsAdapter::getGraphicsControllerType", aGraphicsControllerType));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aGraphicsControllerType);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GRAPHICSADAPTER_GET_GRAPHICSCONTROLLERTYPE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getGraphicsControllerType(aGraphicsControllerType);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GRAPHICSADAPTER_GET_GRAPHICSCONTROLLERTYPE_RETURN(this, hrc, 0 /*normal*/,*aGraphicsControllerType);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GRAPHICSADAPTER_GET_GRAPHICSCONTROLLERTYPE_RETURN(this, hrc, 1 /*hrc exception*/,*aGraphicsControllerType);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GRAPHICSADAPTER_GET_GRAPHICSCONTROLLERTYPE_RETURN(this, hrc, 9 /*unhandled exception*/,*aGraphicsControllerType);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aGraphicsControllerType=%RU32 hrc=%Rhrc\n", this, "GraphicsAdapter::getGraphicsControllerType", *aGraphicsControllerType, hrc));
    return hrc;
}

STDMETHODIMP GraphicsAdapterWrap::COMSETTER(GraphicsControllerType)(GraphicsControllerType_T aGraphicsControllerType)
{
    LogRelFlow(("{%p} %s: enter aGraphicsControllerType=%RU32\n", this, "GraphicsAdapter::setGraphicsControllerType", aGraphicsControllerType));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GRAPHICSADAPTER_SET_GRAPHICSCONTROLLERTYPE_ENTER(this, aGraphicsControllerType);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setGraphicsControllerType(aGraphicsControllerType);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GRAPHICSADAPTER_SET_GRAPHICSCONTROLLERTYPE_RETURN(this, hrc, 0 /*normal*/,aGraphicsControllerType);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GRAPHICSADAPTER_SET_GRAPHICSCONTROLLERTYPE_RETURN(this, hrc, 1 /*hrc exception*/,aGraphicsControllerType);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GRAPHICSADAPTER_SET_GRAPHICSCONTROLLERTYPE_RETURN(this, hrc, 9 /*unhandled exception*/,aGraphicsControllerType);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "GraphicsAdapter::setGraphicsControllerType", hrc));
    return hrc;
}

STDMETHODIMP GraphicsAdapterWrap::COMGETTER(VRAMSize)(ULONG *aVRAMSize)
{
    LogRelFlow(("{%p} %s: enter aVRAMSize=%p\n", this, "GraphicsAdapter::getVRAMSize", aVRAMSize));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aVRAMSize);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GRAPHICSADAPTER_GET_VRAMSIZE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getVRAMSize(aVRAMSize);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GRAPHICSADAPTER_GET_VRAMSIZE_RETURN(this, hrc, 0 /*normal*/,*aVRAMSize);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GRAPHICSADAPTER_GET_VRAMSIZE_RETURN(this, hrc, 1 /*hrc exception*/,*aVRAMSize);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GRAPHICSADAPTER_GET_VRAMSIZE_RETURN(this, hrc, 9 /*unhandled exception*/,*aVRAMSize);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aVRAMSize=%RU32 hrc=%Rhrc\n", this, "GraphicsAdapter::getVRAMSize", *aVRAMSize, hrc));
    return hrc;
}

STDMETHODIMP GraphicsAdapterWrap::COMSETTER(VRAMSize)(ULONG aVRAMSize)
{
    LogRelFlow(("{%p} %s: enter aVRAMSize=%RU32\n", this, "GraphicsAdapter::setVRAMSize", aVRAMSize));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GRAPHICSADAPTER_SET_VRAMSIZE_ENTER(this, aVRAMSize);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setVRAMSize(aVRAMSize);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GRAPHICSADAPTER_SET_VRAMSIZE_RETURN(this, hrc, 0 /*normal*/,aVRAMSize);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GRAPHICSADAPTER_SET_VRAMSIZE_RETURN(this, hrc, 1 /*hrc exception*/,aVRAMSize);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GRAPHICSADAPTER_SET_VRAMSIZE_RETURN(this, hrc, 9 /*unhandled exception*/,aVRAMSize);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "GraphicsAdapter::setVRAMSize", hrc));
    return hrc;
}

STDMETHODIMP GraphicsAdapterWrap::COMGETTER(MonitorCount)(ULONG *aMonitorCount)
{
    LogRelFlow(("{%p} %s: enter aMonitorCount=%p\n", this, "GraphicsAdapter::getMonitorCount", aMonitorCount));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aMonitorCount);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GRAPHICSADAPTER_GET_MONITORCOUNT_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getMonitorCount(aMonitorCount);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GRAPHICSADAPTER_GET_MONITORCOUNT_RETURN(this, hrc, 0 /*normal*/,*aMonitorCount);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GRAPHICSADAPTER_GET_MONITORCOUNT_RETURN(this, hrc, 1 /*hrc exception*/,*aMonitorCount);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GRAPHICSADAPTER_GET_MONITORCOUNT_RETURN(this, hrc, 9 /*unhandled exception*/,*aMonitorCount);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aMonitorCount=%RU32 hrc=%Rhrc\n", this, "GraphicsAdapter::getMonitorCount", *aMonitorCount, hrc));
    return hrc;
}

STDMETHODIMP GraphicsAdapterWrap::COMSETTER(MonitorCount)(ULONG aMonitorCount)
{
    LogRelFlow(("{%p} %s: enter aMonitorCount=%RU32\n", this, "GraphicsAdapter::setMonitorCount", aMonitorCount));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GRAPHICSADAPTER_SET_MONITORCOUNT_ENTER(this, aMonitorCount);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setMonitorCount(aMonitorCount);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GRAPHICSADAPTER_SET_MONITORCOUNT_RETURN(this, hrc, 0 /*normal*/,aMonitorCount);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GRAPHICSADAPTER_SET_MONITORCOUNT_RETURN(this, hrc, 1 /*hrc exception*/,aMonitorCount);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GRAPHICSADAPTER_SET_MONITORCOUNT_RETURN(this, hrc, 9 /*unhandled exception*/,aMonitorCount);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "GraphicsAdapter::setMonitorCount", hrc));
    return hrc;
}

STDMETHODIMP GraphicsAdapterWrap::COMGETTER(InternalAndReservedAttribute1IGraphicsAdapter)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP GraphicsAdapterWrap::COMGETTER(InternalAndReservedAttribute2IGraphicsAdapter)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP GraphicsAdapterWrap::COMGETTER(InternalAndReservedAttribute3IGraphicsAdapter)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP GraphicsAdapterWrap::COMGETTER(InternalAndReservedAttribute4IGraphicsAdapter)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP GraphicsAdapterWrap::COMGETTER(InternalAndReservedAttribute5IGraphicsAdapter)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP GraphicsAdapterWrap::COMGETTER(InternalAndReservedAttribute6IGraphicsAdapter)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP GraphicsAdapterWrap::COMGETTER(InternalAndReservedAttribute7IGraphicsAdapter)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP GraphicsAdapterWrap::COMGETTER(InternalAndReservedAttribute8IGraphicsAdapter)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}


//
// IGraphicsAdapter methods
//

STDMETHODIMP GraphicsAdapterWrap::SetFeature(GraphicsFeature_T aFeature,
                                             BOOL aEnabled)
{
    LogRelFlow(("{%p} %s: enter aFeature=%RU32 aEnabled=%RTbool\n", this, "GraphicsAdapter::setFeature", aFeature, aEnabled));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GRAPHICSADAPTER_SETFEATURE_ENTER(this, aFeature, aEnabled != FALSE);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setFeature(aFeature,
                             aEnabled != FALSE);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GRAPHICSADAPTER_SETFEATURE_RETURN(this, hrc, 0 /*normal*/, aFeature, aEnabled != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GRAPHICSADAPTER_SETFEATURE_RETURN(this, hrc, 1 /*hrc exception*/, aFeature, aEnabled != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GRAPHICSADAPTER_SETFEATURE_RETURN(this, hrc, 9 /*unhandled exception*/, aFeature, aEnabled != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "GraphicsAdapter::setFeature", hrc));
    return hrc;
}

STDMETHODIMP GraphicsAdapterWrap::IsFeatureEnabled(GraphicsFeature_T aFeature,
                                                   BOOL *aEnabled)
{
    LogRelFlow(("{%p} %s: enter aFeature=%RU32 aEnabled=%p\n", this, "GraphicsAdapter::isFeatureEnabled", aFeature, aEnabled));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aEnabled);


        
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GRAPHICSADAPTER_ISFEATUREENABLED_ENTER(this, aFeature);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = isFeatureEnabled(aFeature,
                                   aEnabled);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GRAPHICSADAPTER_ISFEATUREENABLED_RETURN(this, hrc, 0 /*normal*/, aFeature, *aEnabled != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GRAPHICSADAPTER_ISFEATUREENABLED_RETURN(this, hrc, 1 /*hrc exception*/, aFeature, *aEnabled != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GRAPHICSADAPTER_ISFEATUREENABLED_RETURN(this, hrc, 9 /*unhandled exception*/, aFeature, *aEnabled != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave aEnabled=%RTbool hrc=%Rhrc\n", this, "GraphicsAdapter::isFeatureEnabled", *aEnabled, hrc));
    return hrc;
}

STDMETHODIMP GraphicsAdapterWrap::InternalAndReservedMethod1IGraphicsAdapter()
{
    return E_NOTIMPL;
}

STDMETHODIMP GraphicsAdapterWrap::InternalAndReservedMethod2IGraphicsAdapter()
{
    return E_NOTIMPL;
}

STDMETHODIMP GraphicsAdapterWrap::InternalAndReservedMethod3IGraphicsAdapter()
{
    return E_NOTIMPL;
}

STDMETHODIMP GraphicsAdapterWrap::InternalAndReservedMethod4IGraphicsAdapter()
{
    return E_NOTIMPL;
}

#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(GraphicsAdapterWrap)
NS_IMPL_THREADSAFE_ISUPPORTS1_CI(GraphicsAdapterWrap, IGraphicsAdapter)
#endif // VBOX_WITH_XPCOM
