/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSGPUDevice.h"

#include "ActiveDOMObject.h"
#include "ContextDestructionObserverInlines.h"
#include "DOMPromiseProxy.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "IDLTypes.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertBase.h"
#include "JSDOMConvertDictionary.h"
#include "JSDOMConvertEnumeration.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertPromise.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMConvertUnion.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMOperation.h"
#include "JSDOMOperationReturningPromise.h"
#include "JSDOMWrapperCache.h"
#include "JSGPUBindGroup.h"
#include "JSGPUBindGroupDescriptor.h"
#include "JSGPUBindGroupLayout.h"
#include "JSGPUBindGroupLayoutDescriptor.h"
#include "JSGPUBuffer.h"
#include "JSGPUBufferDescriptor.h"
#include "JSGPUCommandEncoder.h"
#include "JSGPUCommandEncoderDescriptor.h"
#include "JSGPUComputePipeline.h"
#include "JSGPUComputePipelineDescriptor.h"
#include "JSGPUDeviceLostInfo.h"
#include "JSGPUErrorFilter.h"
#include "JSGPUExternalTexture.h"
#include "JSGPUExternalTextureDescriptor.h"
#include "JSGPUInternalError.h"
#include "JSGPUOutOfMemoryError.h"
#include "JSGPUPipelineLayout.h"
#include "JSGPUPipelineLayoutDescriptor.h"
#include "JSGPUQuerySet.h"
#include "JSGPUQuerySetDescriptor.h"
#include "JSGPUQueue.h"
#include "JSGPURenderBundleEncoder.h"
#include "JSGPURenderBundleEncoderDescriptor.h"
#include "JSGPURenderPipeline.h"
#include "JSGPURenderPipelineDescriptor.h"
#include "JSGPUSampler.h"
#include "JSGPUSamplerDescriptor.h"
#include "JSGPUShaderModule.h"
#include "JSGPUShaderModuleDescriptor.h"
#include "JSGPUSupportedFeatures.h"
#include "JSGPUSupportedLimits.h"
#include "JSGPUTexture.h"
#include "JSGPUTextureDescriptor.h"
#include "JSGPUValidationError.h"
#include "ScriptExecutionContext.h"
#include "Settings.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/Variant.h>
#include <wtf/text/MakeString.h>

namespace WebCore {
using namespace JSC;

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsGPUDevicePrototypeFunction_destroy);
static JSC_DECLARE_HOST_FUNCTION(jsGPUDevicePrototypeFunction_createBuffer);
static JSC_DECLARE_HOST_FUNCTION(jsGPUDevicePrototypeFunction_createTexture);
static JSC_DECLARE_HOST_FUNCTION(jsGPUDevicePrototypeFunction_createSampler);
static JSC_DECLARE_HOST_FUNCTION(jsGPUDevicePrototypeFunction_importExternalTexture);
static JSC_DECLARE_HOST_FUNCTION(jsGPUDevicePrototypeFunction_createBindGroupLayout);
static JSC_DECLARE_HOST_FUNCTION(jsGPUDevicePrototypeFunction_createPipelineLayout);
static JSC_DECLARE_HOST_FUNCTION(jsGPUDevicePrototypeFunction_createBindGroup);
static JSC_DECLARE_HOST_FUNCTION(jsGPUDevicePrototypeFunction_createShaderModule);
static JSC_DECLARE_HOST_FUNCTION(jsGPUDevicePrototypeFunction_createComputePipeline);
static JSC_DECLARE_HOST_FUNCTION(jsGPUDevicePrototypeFunction_createRenderPipeline);
static JSC_DECLARE_HOST_FUNCTION(jsGPUDevicePrototypeFunction_createComputePipelineAsync);
static JSC_DECLARE_HOST_FUNCTION(jsGPUDevicePrototypeFunction_createRenderPipelineAsync);
static JSC_DECLARE_HOST_FUNCTION(jsGPUDevicePrototypeFunction_createCommandEncoder);
static JSC_DECLARE_HOST_FUNCTION(jsGPUDevicePrototypeFunction_createRenderBundleEncoder);
static JSC_DECLARE_HOST_FUNCTION(jsGPUDevicePrototypeFunction_createQuerySet);
static JSC_DECLARE_HOST_FUNCTION(jsGPUDevicePrototypeFunction_pushErrorScope);
static JSC_DECLARE_HOST_FUNCTION(jsGPUDevicePrototypeFunction_popErrorScope);

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsGPUDeviceConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsGPUDevice_features);
static JSC_DECLARE_CUSTOM_GETTER(jsGPUDevice_limits);
static JSC_DECLARE_CUSTOM_GETTER(jsGPUDevice_queue);
static JSC_DECLARE_CUSTOM_GETTER(jsGPUDevice_lost);
static JSC_DECLARE_CUSTOM_GETTER(jsGPUDevice_label);
static JSC_DECLARE_CUSTOM_SETTER(setJSGPUDevice_label);

class JSGPUDevicePrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSGPUDevicePrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSGPUDevicePrototype* ptr = new (NotNull, JSC::allocateCell<JSGPUDevicePrototype>(vm)) JSGPUDevicePrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSGPUDevicePrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSGPUDevicePrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSGPUDevicePrototype, JSGPUDevicePrototype::Base);

using JSGPUDeviceDOMConstructor = JSDOMConstructorNotConstructable<JSGPUDevice>;

template<> const ClassInfo JSGPUDeviceDOMConstructor::s_info = { "GPUDevice"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSGPUDeviceDOMConstructor) };

template<> JSValue JSGPUDeviceDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSEventTarget::getConstructor(vm, &globalObject);
}

template<> void JSGPUDeviceDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "GPUDevice"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSGPUDevice::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const std::array<HashTableValue, 24> JSGPUDevicePrototypeTableValues {
    HashTableValue { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsGPUDeviceConstructor, 0 } },
    HashTableValue { "features"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsGPUDevice_features, 0 } },
    HashTableValue { "limits"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsGPUDevice_limits, 0 } },
    HashTableValue { "queue"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsGPUDevice_queue, 0 } },
    HashTableValue { "lost"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor, NoIntrinsic, { HashTableValue::GetterSetterType, jsGPUDevice_lost, 0 } },
    HashTableValue { "label"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsGPUDevice_label, setJSGPUDevice_label } },
    HashTableValue { "destroy"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsGPUDevicePrototypeFunction_destroy, 0 } },
    HashTableValue { "createBuffer"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsGPUDevicePrototypeFunction_createBuffer, 1 } },
    HashTableValue { "createTexture"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsGPUDevicePrototypeFunction_createTexture, 1 } },
    HashTableValue { "createSampler"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsGPUDevicePrototypeFunction_createSampler, 0 } },
    HashTableValue { "importExternalTexture"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsGPUDevicePrototypeFunction_importExternalTexture, 1 } },
    HashTableValue { "createBindGroupLayout"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsGPUDevicePrototypeFunction_createBindGroupLayout, 1 } },
    HashTableValue { "createPipelineLayout"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsGPUDevicePrototypeFunction_createPipelineLayout, 1 } },
    HashTableValue { "createBindGroup"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsGPUDevicePrototypeFunction_createBindGroup, 1 } },
    HashTableValue { "createShaderModule"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsGPUDevicePrototypeFunction_createShaderModule, 1 } },
    HashTableValue { "createComputePipeline"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsGPUDevicePrototypeFunction_createComputePipeline, 1 } },
    HashTableValue { "createRenderPipeline"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsGPUDevicePrototypeFunction_createRenderPipeline, 1 } },
    HashTableValue { "createComputePipelineAsync"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsGPUDevicePrototypeFunction_createComputePipelineAsync, 1 } },
    HashTableValue { "createRenderPipelineAsync"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsGPUDevicePrototypeFunction_createRenderPipelineAsync, 1 } },
    HashTableValue { "createCommandEncoder"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsGPUDevicePrototypeFunction_createCommandEncoder, 0 } },
    HashTableValue { "createRenderBundleEncoder"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsGPUDevicePrototypeFunction_createRenderBundleEncoder, 1 } },
    HashTableValue { "createQuerySet"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsGPUDevicePrototypeFunction_createQuerySet, 1 } },
    HashTableValue { "pushErrorScope"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsGPUDevicePrototypeFunction_pushErrorScope, 1 } },
    HashTableValue { "popErrorScope"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsGPUDevicePrototypeFunction_popErrorScope, 0 } },
};

const ClassInfo JSGPUDevicePrototype::s_info = { "GPUDevice"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSGPUDevicePrototype) };

void JSGPUDevicePrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSGPUDevice::info(), JSGPUDevicePrototypeTableValues, *this);
    bool hasDisabledRuntimeProperties = false;
    if (!jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().webGPUEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "label"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (hasDisabledRuntimeProperties && structure()->isDictionary())
        flattenDictionaryObject(vm);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSGPUDevice::s_info = { "GPUDevice"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSGPUDevice) };

JSGPUDevice::JSGPUDevice(Structure* structure, JSDOMGlobalObject& globalObject, Ref<GPUDevice>&& impl)
    : JSEventTarget(structure, globalObject, WTFMove(impl))
{
}

Ref<GPUDevice> JSGPUDevice::protectedWrapped() const
{
    return wrapped();
}

static_assert(std::is_base_of<ActiveDOMObject, GPUDevice>::value, "Interface is marked as [ActiveDOMObject] but implementation class does not subclass ActiveDOMObject.");

JSObject* JSGPUDevice::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSGPUDevicePrototype::createStructure(vm, &globalObject, JSEventTarget::prototype(vm, globalObject));
    structure->setMayBePrototype(true);
    return JSGPUDevicePrototype::create(vm, &globalObject, structure);
}

JSObject* JSGPUDevice::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSGPUDevice>(vm, globalObject);
}

JSValue JSGPUDevice::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSGPUDeviceDOMConstructor, DOMConstructorID::GPUDevice>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsGPUDeviceConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSGPUDevicePrototype*>(JSValue::decode(thisValue));
    if (!prototype) [[unlikely]]
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSGPUDevice::getConstructor(vm, prototype->globalObject()));
}

static inline JSValue jsGPUDevice_featuresGetter(JSGlobalObject& lexicalGlobalObject, JSGPUDevice& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<GPUSupportedFeatures>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.features())));
}

JSC_DEFINE_CUSTOM_GETTER(jsGPUDevice_features, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSGPUDevice>::get<jsGPUDevice_featuresGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsGPUDevice_limitsGetter(JSGlobalObject& lexicalGlobalObject, JSGPUDevice& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<GPUSupportedLimits>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.limits())));
}

JSC_DEFINE_CUSTOM_GETTER(jsGPUDevice_limits, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSGPUDevice>::get<jsGPUDevice_limitsGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsGPUDevice_queueGetter(JSGlobalObject& lexicalGlobalObject, JSGPUDevice& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<GPUQueue>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.queue())));
}

JSC_DEFINE_CUSTOM_GETTER(jsGPUDevice_queue, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSGPUDevice>::get<jsGPUDevice_queueGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsGPUDevice_lostGetter(JSGlobalObject& lexicalGlobalObject, JSGPUDevice& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLPromise<IDLInterface<GPUDeviceLostInfo>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, [&]() -> decltype(auto) { return impl.lost(); })));
}

JSC_DEFINE_CUSTOM_GETTER(jsGPUDevice_lost, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSGPUDevice>::get<jsGPUDevice_lostGetter, CastedThisErrorBehavior::RejectPromise>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsGPUDevice_labelGetter(JSGlobalObject& lexicalGlobalObject, JSGPUDevice& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUSVString>(lexicalGlobalObject, throwScope, impl.label())));
}

JSC_DEFINE_CUSTOM_GETTER(jsGPUDevice_label, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSGPUDevice>::get<jsGPUDevice_labelGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSGPUDevice_labelSetter(JSGlobalObject& lexicalGlobalObject, JSGPUDevice& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLUSVString>(lexicalGlobalObject, value);
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setLabel(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSGPUDevice_label, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSGPUDevice>::set<setJSGPUDevice_labelSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSC::EncodedJSValue jsGPUDevicePrototypeFunction_destroyBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSGPUDevice>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    auto* context = jsCast<JSDOMGlobalObject*>(lexicalGlobalObject)->scriptExecutionContext();
    if (!context) [[unlikely]]
        return JSValue::encode(jsUndefined());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.destroy(*context); })));
}

JSC_DEFINE_HOST_FUNCTION(jsGPUDevicePrototypeFunction_destroy, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSGPUDevice>::call<jsGPUDevicePrototypeFunction_destroyBody>(*lexicalGlobalObject, *callFrame, "destroy");
}

static inline JSC::EncodedJSValue jsGPUDevicePrototypeFunction_createBufferBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSGPUDevice>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto descriptorConversionResult = convert<IDLDictionary<GPUBufferDescriptor>>(*lexicalGlobalObject, argument0.value());
    if (descriptorConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<GPUBuffer>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.createBuffer(descriptorConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsGPUDevicePrototypeFunction_createBuffer, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSGPUDevice>::call<jsGPUDevicePrototypeFunction_createBufferBody>(*lexicalGlobalObject, *callFrame, "createBuffer");
}

static inline JSC::EncodedJSValue jsGPUDevicePrototypeFunction_createTextureBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSGPUDevice>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto descriptorConversionResult = convert<IDLDictionary<GPUTextureDescriptor>>(*lexicalGlobalObject, argument0.value());
    if (descriptorConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<GPUTexture>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.createTexture(descriptorConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsGPUDevicePrototypeFunction_createTexture, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSGPUDevice>::call<jsGPUDevicePrototypeFunction_createTextureBody>(*lexicalGlobalObject, *callFrame, "createTexture");
}

static inline JSC::EncodedJSValue jsGPUDevicePrototypeFunction_createSamplerBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSGPUDevice>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->argument(0);
    auto descriptorConversionResult = convert<IDLDictionary<GPUSamplerDescriptor>>(*lexicalGlobalObject, argument0.value());
    if (descriptorConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<GPUSampler>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.createSampler(descriptorConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsGPUDevicePrototypeFunction_createSampler, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSGPUDevice>::call<jsGPUDevicePrototypeFunction_createSamplerBody>(*lexicalGlobalObject, *callFrame, "createSampler");
}

static inline JSC::EncodedJSValue jsGPUDevicePrototypeFunction_importExternalTextureBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSGPUDevice>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto descriptorConversionResult = convert<IDLDictionary<GPUExternalTextureDescriptor>>(*lexicalGlobalObject, argument0.value());
    if (descriptorConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<GPUExternalTexture>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.importExternalTexture(descriptorConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsGPUDevicePrototypeFunction_importExternalTexture, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSGPUDevice>::call<jsGPUDevicePrototypeFunction_importExternalTextureBody>(*lexicalGlobalObject, *callFrame, "importExternalTexture");
}

static inline JSC::EncodedJSValue jsGPUDevicePrototypeFunction_createBindGroupLayoutBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSGPUDevice>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto descriptorConversionResult = convert<IDLDictionary<GPUBindGroupLayoutDescriptor>>(*lexicalGlobalObject, argument0.value());
    if (descriptorConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<GPUBindGroupLayout>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.createBindGroupLayout(descriptorConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsGPUDevicePrototypeFunction_createBindGroupLayout, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSGPUDevice>::call<jsGPUDevicePrototypeFunction_createBindGroupLayoutBody>(*lexicalGlobalObject, *callFrame, "createBindGroupLayout");
}

static inline JSC::EncodedJSValue jsGPUDevicePrototypeFunction_createPipelineLayoutBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSGPUDevice>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto descriptorConversionResult = convert<IDLDictionary<GPUPipelineLayoutDescriptor>>(*lexicalGlobalObject, argument0.value());
    if (descriptorConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<GPUPipelineLayout>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.createPipelineLayout(descriptorConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsGPUDevicePrototypeFunction_createPipelineLayout, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSGPUDevice>::call<jsGPUDevicePrototypeFunction_createPipelineLayoutBody>(*lexicalGlobalObject, *callFrame, "createPipelineLayout");
}

static inline JSC::EncodedJSValue jsGPUDevicePrototypeFunction_createBindGroupBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSGPUDevice>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto descriptorConversionResult = convert<IDLDictionary<GPUBindGroupDescriptor>>(*lexicalGlobalObject, argument0.value());
    if (descriptorConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<GPUBindGroup>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.createBindGroup(descriptorConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsGPUDevicePrototypeFunction_createBindGroup, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSGPUDevice>::call<jsGPUDevicePrototypeFunction_createBindGroupBody>(*lexicalGlobalObject, *callFrame, "createBindGroup");
}

static inline JSC::EncodedJSValue jsGPUDevicePrototypeFunction_createShaderModuleBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSGPUDevice>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto descriptorConversionResult = convert<IDLDictionary<GPUShaderModuleDescriptor>>(*lexicalGlobalObject, argument0.value());
    if (descriptorConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<GPUShaderModule>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.createShaderModule(descriptorConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsGPUDevicePrototypeFunction_createShaderModule, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSGPUDevice>::call<jsGPUDevicePrototypeFunction_createShaderModuleBody>(*lexicalGlobalObject, *callFrame, "createShaderModule");
}

static inline JSC::EncodedJSValue jsGPUDevicePrototypeFunction_createComputePipelineBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSGPUDevice>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto descriptorConversionResult = convert<IDLDictionary<GPUComputePipelineDescriptor>>(*lexicalGlobalObject, argument0.value());
    if (descriptorConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<GPUComputePipeline>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.createComputePipeline(descriptorConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsGPUDevicePrototypeFunction_createComputePipeline, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSGPUDevice>::call<jsGPUDevicePrototypeFunction_createComputePipelineBody>(*lexicalGlobalObject, *callFrame, "createComputePipeline");
}

static inline JSC::EncodedJSValue jsGPUDevicePrototypeFunction_createRenderPipelineBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSGPUDevice>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto descriptorConversionResult = convert<IDLDictionary<GPURenderPipelineDescriptor>>(*lexicalGlobalObject, argument0.value());
    if (descriptorConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<GPURenderPipeline>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.createRenderPipeline(descriptorConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsGPUDevicePrototypeFunction_createRenderPipeline, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSGPUDevice>::call<jsGPUDevicePrototypeFunction_createRenderPipelineBody>(*lexicalGlobalObject, *callFrame, "createRenderPipeline");
}

static inline JSC::EncodedJSValue jsGPUDevicePrototypeFunction_createComputePipelineAsyncBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSGPUDevice>::ClassParameter castedThis, Ref<DeferredPromise>&& promise)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto descriptorConversionResult = convert<IDLDictionary<GPUComputePipelineDescriptor>>(*lexicalGlobalObject, argument0.value());
    if (descriptorConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLPromise<IDLInterface<GPUComputePipeline>>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, [&]() -> decltype(auto) { return impl.createComputePipelineAsync(descriptorConversionResult.releaseReturnValue(), WTFMove(promise)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsGPUDevicePrototypeFunction_createComputePipelineAsync, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperationReturningPromise<JSGPUDevice>::call<jsGPUDevicePrototypeFunction_createComputePipelineAsyncBody>(*lexicalGlobalObject, *callFrame, "createComputePipelineAsync");
}

static inline JSC::EncodedJSValue jsGPUDevicePrototypeFunction_createRenderPipelineAsyncBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSGPUDevice>::ClassParameter castedThis, Ref<DeferredPromise>&& promise)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto descriptorConversionResult = convert<IDLDictionary<GPURenderPipelineDescriptor>>(*lexicalGlobalObject, argument0.value());
    if (descriptorConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLPromise<IDLInterface<GPURenderPipeline>>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, [&]() -> decltype(auto) { return impl.createRenderPipelineAsync(descriptorConversionResult.releaseReturnValue(), WTFMove(promise)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsGPUDevicePrototypeFunction_createRenderPipelineAsync, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperationReturningPromise<JSGPUDevice>::call<jsGPUDevicePrototypeFunction_createRenderPipelineAsyncBody>(*lexicalGlobalObject, *callFrame, "createRenderPipelineAsync");
}

static inline JSC::EncodedJSValue jsGPUDevicePrototypeFunction_createCommandEncoderBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSGPUDevice>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->argument(0);
    auto descriptorConversionResult = convert<IDLDictionary<GPUCommandEncoderDescriptor>>(*lexicalGlobalObject, argument0.value());
    if (descriptorConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<GPUCommandEncoder>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.createCommandEncoder(descriptorConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsGPUDevicePrototypeFunction_createCommandEncoder, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSGPUDevice>::call<jsGPUDevicePrototypeFunction_createCommandEncoderBody>(*lexicalGlobalObject, *callFrame, "createCommandEncoder");
}

static inline JSC::EncodedJSValue jsGPUDevicePrototypeFunction_createRenderBundleEncoderBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSGPUDevice>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto descriptorConversionResult = convert<IDLDictionary<GPURenderBundleEncoderDescriptor>>(*lexicalGlobalObject, argument0.value());
    if (descriptorConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<GPURenderBundleEncoder>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.createRenderBundleEncoder(descriptorConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsGPUDevicePrototypeFunction_createRenderBundleEncoder, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSGPUDevice>::call<jsGPUDevicePrototypeFunction_createRenderBundleEncoderBody>(*lexicalGlobalObject, *callFrame, "createRenderBundleEncoder");
}

static inline JSC::EncodedJSValue jsGPUDevicePrototypeFunction_createQuerySetBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSGPUDevice>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto descriptorConversionResult = convert<IDLDictionary<GPUQuerySetDescriptor>>(*lexicalGlobalObject, argument0.value());
    if (descriptorConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<GPUQuerySet>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.createQuerySet(descriptorConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsGPUDevicePrototypeFunction_createQuerySet, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSGPUDevice>::call<jsGPUDevicePrototypeFunction_createQuerySetBody>(*lexicalGlobalObject, *callFrame, "createQuerySet");
}

static inline JSC::EncodedJSValue jsGPUDevicePrototypeFunction_pushErrorScopeBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSGPUDevice>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto filterConversionResult = convert<IDLEnumeration<GPUErrorFilter>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentMustBeEnumError(lexicalGlobalObject, scope, 0, "filter"_s, "GPUDevice"_s, "pushErrorScope"_s, expectedEnumerationValues<GPUErrorFilter>()); });
    if (filterConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.pushErrorScope(filterConversionResult.releaseReturnValue()); })));
}

JSC_DEFINE_HOST_FUNCTION(jsGPUDevicePrototypeFunction_pushErrorScope, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSGPUDevice>::call<jsGPUDevicePrototypeFunction_pushErrorScopeBody>(*lexicalGlobalObject, *callFrame, "pushErrorScope");
}

static inline JSC::EncodedJSValue jsGPUDevicePrototypeFunction_popErrorScopeBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSGPUDevice>::ClassParameter castedThis, Ref<DeferredPromise>&& promise)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLPromise<IDLNullable<IDLUnion<IDLInterface<GPUOutOfMemoryError>, IDLInterface<GPUValidationError>, IDLInterface<GPUInternalError>>>>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, [&]() -> decltype(auto) { return impl.popErrorScope(WTFMove(promise)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsGPUDevicePrototypeFunction_popErrorScope, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperationReturningPromise<JSGPUDevice>::call<jsGPUDevicePrototypeFunction_popErrorScopeBody>(*lexicalGlobalObject, *callFrame, "popErrorScope");
}

JSC::GCClient::IsoSubspace* JSGPUDevice::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSGPUDevice, UseCustomHeapCellType::No>(vm, "JSGPUDevice"_s,
        [] (auto& spaces) { return spaces.m_clientSubspaceForGPUDevice.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForGPUDevice = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForGPUDevice.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForGPUDevice = std::forward<decltype(space)>(space); }
    );
}

void JSGPUDevice::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSGPUDevice*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (RefPtr context = thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, context->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

bool JSGPUDeviceOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, ASCIILiteral* reason)
{
    SUPPRESS_UNCOUNTED_LOCAL auto* jsGPUDevice = jsCast<JSGPUDevice*>(handle.slot()->asCell());
    SUPPRESS_UNCOUNTED_LOCAL auto& wrapped = jsGPUDevice->wrapped();
    if (!wrapped.isContextStopped() && wrapped.hasPendingActivity()) {
        if (reason) [[unlikely]]
            *reason = "ActiveDOMObject with pending activity"_s;
        return true;
     }
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSGPUDeviceOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsGPUDevice = static_cast<JSGPUDevice*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsGPUDevice->protectedWrapped().ptr(), jsGPUDevice);
}

WTF_ALLOW_UNSAFE_BUFFER_USAGE_BEGIN
#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7GPUDevice@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore9GPUDeviceE[]; }
#endif
template<std::same_as<GPUDevice> T>
static inline void verifyVTable(GPUDevice* ptr) 
{
    if constexpr (std::is_polymorphic_v<T>) {
        const void* actualVTablePointer = getVTablePointer<T>(ptr);
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7GPUDevice@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore9GPUDeviceE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // GPUDevice has subclasses. If GPUDevice has subclasses that get passed
        // to toJS() we currently require GPUDevice you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
    }
}
#endif
WTF_ALLOW_UNSAFE_BUFFER_USAGE_END

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<GPUDevice>&& impl)
{
#if ENABLE(BINDING_INTEGRITY)
    verifyVTable<GPUDevice>(impl.ptr());
#endif
    return createWrapper<GPUDevice>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, GPUDevice& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

GPUDevice* JSGPUDevice::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSGPUDevice*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
