/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(SPEECH_SYNTHESIS)

#include "JSSpeechSynthesisErrorCode.h"

#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSString.h>
#include <wtf/NeverDestroyed.h>
#include <wtf/SortedArrayMap.h>



namespace WebCore {
using namespace JSC;

String convertEnumerationToString(SpeechSynthesisErrorCode enumerationValue)
{
    static const std::array<NeverDestroyed<String>, 12> values {
        MAKE_STATIC_STRING_IMPL("canceled"),
        MAKE_STATIC_STRING_IMPL("interrupted"),
        MAKE_STATIC_STRING_IMPL("audio-busy"),
        MAKE_STATIC_STRING_IMPL("audio-hardware"),
        MAKE_STATIC_STRING_IMPL("network"),
        MAKE_STATIC_STRING_IMPL("synthesis-unavailable"),
        MAKE_STATIC_STRING_IMPL("synthesis-failed"),
        MAKE_STATIC_STRING_IMPL("language-unavailable"),
        MAKE_STATIC_STRING_IMPL("voice-unavailable"),
        MAKE_STATIC_STRING_IMPL("text-too-long"),
        MAKE_STATIC_STRING_IMPL("invalid-argument"),
        MAKE_STATIC_STRING_IMPL("not-allowed"),
    };
    static_assert(static_cast<size_t>(SpeechSynthesisErrorCode::Canceled) == 0, "SpeechSynthesisErrorCode::Canceled is not 0 as expected");
    static_assert(static_cast<size_t>(SpeechSynthesisErrorCode::Interrupted) == 1, "SpeechSynthesisErrorCode::Interrupted is not 1 as expected");
    static_assert(static_cast<size_t>(SpeechSynthesisErrorCode::AudioBusy) == 2, "SpeechSynthesisErrorCode::AudioBusy is not 2 as expected");
    static_assert(static_cast<size_t>(SpeechSynthesisErrorCode::AudioHardware) == 3, "SpeechSynthesisErrorCode::AudioHardware is not 3 as expected");
    static_assert(static_cast<size_t>(SpeechSynthesisErrorCode::Network) == 4, "SpeechSynthesisErrorCode::Network is not 4 as expected");
    static_assert(static_cast<size_t>(SpeechSynthesisErrorCode::SynthesisUnavailable) == 5, "SpeechSynthesisErrorCode::SynthesisUnavailable is not 5 as expected");
    static_assert(static_cast<size_t>(SpeechSynthesisErrorCode::SynthesisFailed) == 6, "SpeechSynthesisErrorCode::SynthesisFailed is not 6 as expected");
    static_assert(static_cast<size_t>(SpeechSynthesisErrorCode::LanguageUnavailable) == 7, "SpeechSynthesisErrorCode::LanguageUnavailable is not 7 as expected");
    static_assert(static_cast<size_t>(SpeechSynthesisErrorCode::VoiceUnavailable) == 8, "SpeechSynthesisErrorCode::VoiceUnavailable is not 8 as expected");
    static_assert(static_cast<size_t>(SpeechSynthesisErrorCode::TextTooLong) == 9, "SpeechSynthesisErrorCode::TextTooLong is not 9 as expected");
    static_assert(static_cast<size_t>(SpeechSynthesisErrorCode::InvalidArgument) == 10, "SpeechSynthesisErrorCode::InvalidArgument is not 10 as expected");
    static_assert(static_cast<size_t>(SpeechSynthesisErrorCode::NotAllowed) == 11, "SpeechSynthesisErrorCode::NotAllowed is not 11 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < std::size(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(VM& vm, SpeechSynthesisErrorCode enumerationValue)
{
    return jsStringWithCache(vm, convertEnumerationToString(enumerationValue));
}

template<> std::optional<SpeechSynthesisErrorCode> parseEnumerationFromString<SpeechSynthesisErrorCode>(const String& stringValue)
{
    static constexpr std::array<std::pair<ComparableASCIILiteral, SpeechSynthesisErrorCode>, 12> mappings {
        std::pair<ComparableASCIILiteral, SpeechSynthesisErrorCode> { "audio-busy"_s, SpeechSynthesisErrorCode::AudioBusy },
        std::pair<ComparableASCIILiteral, SpeechSynthesisErrorCode> { "audio-hardware"_s, SpeechSynthesisErrorCode::AudioHardware },
        std::pair<ComparableASCIILiteral, SpeechSynthesisErrorCode> { "canceled"_s, SpeechSynthesisErrorCode::Canceled },
        std::pair<ComparableASCIILiteral, SpeechSynthesisErrorCode> { "interrupted"_s, SpeechSynthesisErrorCode::Interrupted },
        std::pair<ComparableASCIILiteral, SpeechSynthesisErrorCode> { "invalid-argument"_s, SpeechSynthesisErrorCode::InvalidArgument },
        std::pair<ComparableASCIILiteral, SpeechSynthesisErrorCode> { "language-unavailable"_s, SpeechSynthesisErrorCode::LanguageUnavailable },
        std::pair<ComparableASCIILiteral, SpeechSynthesisErrorCode> { "network"_s, SpeechSynthesisErrorCode::Network },
        std::pair<ComparableASCIILiteral, SpeechSynthesisErrorCode> { "not-allowed"_s, SpeechSynthesisErrorCode::NotAllowed },
        std::pair<ComparableASCIILiteral, SpeechSynthesisErrorCode> { "synthesis-failed"_s, SpeechSynthesisErrorCode::SynthesisFailed },
        std::pair<ComparableASCIILiteral, SpeechSynthesisErrorCode> { "synthesis-unavailable"_s, SpeechSynthesisErrorCode::SynthesisUnavailable },
        std::pair<ComparableASCIILiteral, SpeechSynthesisErrorCode> { "text-too-long"_s, SpeechSynthesisErrorCode::TextTooLong },
        std::pair<ComparableASCIILiteral, SpeechSynthesisErrorCode> { "voice-unavailable"_s, SpeechSynthesisErrorCode::VoiceUnavailable },
    };
    static constexpr SortedArrayMap enumerationMapping { mappings };
    if (auto* enumerationValue = enumerationMapping.tryGet(stringValue); enumerationValue) [[likely]]
        return *enumerationValue;
    return std::nullopt;
}

template<> std::optional<SpeechSynthesisErrorCode> parseEnumeration<SpeechSynthesisErrorCode>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    return parseEnumerationFromString<SpeechSynthesisErrorCode>(value.toWTFString(&lexicalGlobalObject));
}

template<> ASCIILiteral expectedEnumerationValues<SpeechSynthesisErrorCode>()
{
    return "\"canceled\", \"interrupted\", \"audio-busy\", \"audio-hardware\", \"network\", \"synthesis-unavailable\", \"synthesis-failed\", \"language-unavailable\", \"voice-unavailable\", \"text-too-long\", \"invalid-argument\", \"not-allowed\""_s;
}

} // namespace WebCore


#endif // ENABLE(SPEECH_SYNTHESIS)
