/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEBXR_LAYERS)

#include "JSXRLayerInit.h"

#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertEnumeration.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertOptional.h"
#include "JSWebXRSpace.h"
#include "JSXRLayerLayout.h"
#include <JavaScriptCore/JSCInlines.h>



namespace WebCore {
using namespace JSC;

#if ENABLE(WEBXR_LAYERS)

template<> ConversionResult<IDLDictionary<XRLayerInit>> convertDictionary<XRLayerInit>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (!isNullOrUndefined && !object) [[unlikely]] {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return ConversionResultException { };
    }
    XRLayerInit result;
    JSValue clearOnAccessValue;
    if (isNullOrUndefined)
        clearOnAccessValue = jsUndefined();
    else {
        clearOnAccessValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "clearOnAccess"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto clearOnAccessConversionResult = convertOptionalWithDefault<IDLBoolean>(lexicalGlobalObject, clearOnAccessValue, [&]() -> ConversionResult<IDLBoolean> { return Converter<IDLBoolean>::ReturnType { true }; });
    if (clearOnAccessConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.clearOnAccess = clearOnAccessConversionResult.releaseReturnValue();
    JSValue colorFormatValue;
    if (isNullOrUndefined)
        colorFormatValue = jsUndefined();
    else {
        colorFormatValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "colorFormat"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto colorFormatConversionResult = convertOptionalWithDefault<IDLUnsignedLong>(lexicalGlobalObject, colorFormatValue, [&]() -> ConversionResult<IDLUnsignedLong> { return Converter<IDLUnsignedLong>::ReturnType { 0x1908 }; });
    if (colorFormatConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.colorFormat = colorFormatConversionResult.releaseReturnValue();
    JSValue depthFormatValue;
    if (isNullOrUndefined)
        depthFormatValue = jsUndefined();
    else {
        depthFormatValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "depthFormat"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!depthFormatValue.isUndefined()) {
        auto depthFormatConversionResult = convert<IDLNullable<IDLUnsignedLong>>(lexicalGlobalObject, depthFormatValue);
        if (depthFormatConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.depthFormat = depthFormatConversionResult.releaseReturnValue();
    }
    JSValue isStaticValue;
    if (isNullOrUndefined)
        isStaticValue = jsUndefined();
    else {
        isStaticValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "isStatic"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto isStaticConversionResult = convertOptionalWithDefault<IDLBoolean>(lexicalGlobalObject, isStaticValue, [&]() -> ConversionResult<IDLBoolean> { return Converter<IDLBoolean>::ReturnType { false }; });
    if (isStaticConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.isStatic = isStaticConversionResult.releaseReturnValue();
    JSValue layoutValue;
    if (isNullOrUndefined)
        layoutValue = jsUndefined();
    else {
        layoutValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "layout"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto layoutConversionResult = convertOptionalWithDefault<IDLEnumeration<XRLayerLayout>>(lexicalGlobalObject, layoutValue, [&]() -> ConversionResult<IDLEnumeration<XRLayerLayout>> { return Converter<IDLEnumeration<XRLayerLayout>>::ReturnType { XRLayerLayout::Mono }; });
    if (layoutConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.layout = layoutConversionResult.releaseReturnValue();
    JSValue mipLevelsValue;
    if (isNullOrUndefined)
        mipLevelsValue = jsUndefined();
    else {
        mipLevelsValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "mipLevels"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto mipLevelsConversionResult = convertOptionalWithDefault<IDLUnsignedLong>(lexicalGlobalObject, mipLevelsValue, [&]() -> ConversionResult<IDLUnsignedLong> { return Converter<IDLUnsignedLong>::ReturnType { 1 }; });
    if (mipLevelsConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.mipLevels = mipLevelsConversionResult.releaseReturnValue();
    JSValue spaceValue;
    if (isNullOrUndefined)
        spaceValue = jsUndefined();
    else {
        spaceValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "space"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (spaceValue.isUndefined()) {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "space"_s, "XRLayerInit"_s, "WebXRSpace"_s);
        return ConversionResultException { };
    }
    auto spaceConversionResult = convert<IDLInterface<WebXRSpace>>(lexicalGlobalObject, spaceValue);
    if (spaceConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.space = spaceConversionResult.releaseReturnValue();
    JSValue viewPixelHeightValue;
    if (isNullOrUndefined)
        viewPixelHeightValue = jsUndefined();
    else {
        viewPixelHeightValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "viewPixelHeight"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (viewPixelHeightValue.isUndefined()) {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "viewPixelHeight"_s, "XRLayerInit"_s, "unsigned long"_s);
        return ConversionResultException { };
    }
    auto viewPixelHeightConversionResult = convert<IDLUnsignedLong>(lexicalGlobalObject, viewPixelHeightValue);
    if (viewPixelHeightConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.viewPixelHeight = viewPixelHeightConversionResult.releaseReturnValue();
    JSValue viewPixelWidthValue;
    if (isNullOrUndefined)
        viewPixelWidthValue = jsUndefined();
    else {
        viewPixelWidthValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "viewPixelWidth"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (viewPixelWidthValue.isUndefined()) {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "viewPixelWidth"_s, "XRLayerInit"_s, "unsigned long"_s);
        return ConversionResultException { };
    }
    auto viewPixelWidthConversionResult = convert<IDLUnsignedLong>(lexicalGlobalObject, viewPixelWidthValue);
    if (viewPixelWidthConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.viewPixelWidth = viewPixelWidthConversionResult.releaseReturnValue();
    return result;
}

#endif

} // namespace WebCore


#endif // ENABLE(WEBXR_LAYERS)
