/*
 * Copyright (C) 2021-2023 Apple Inc. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1.  Redistributions of source code must retain the above copyright
 *     notice, this list of conditions and the following disclaimer.
 * 2.  Redistributions in binary form must reproduce the above copyright
 *     notice, this list of conditions and the following disclaimer in the
 *     documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. AND ITS CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL APPLE INC. OR ITS CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include "config.h"
#include "MessageArgumentDescriptions.h"

#include "JSIPCBinding.h"
#include "MessageNames.h"

#if ENABLE(IPC_TESTING_API) || !LOG_DISABLED

namespace IPC {

#if ENABLE(IPC_TESTING_API)

std::optional<JSC::JSValue> jsValueForArguments(JSC::JSGlobalObject* globalObject, MessageName name, Decoder& decoder)
{
    switch (name) {
#if ENABLE(GPU_PROCESS)
    case MessageName::GPUConnectionToWebProcess_CreateRenderingBackend:
        return jsValueForDecodedMessage<MessageName::GPUConnectionToWebProcess_CreateRenderingBackend>(globalObject, decoder);
    case MessageName::GPUConnectionToWebProcess_ReleaseRenderingBackend:
        return jsValueForDecodedMessage<MessageName::GPUConnectionToWebProcess_ReleaseRenderingBackend>(globalObject, decoder);
#if ENABLE(WEBGL)
    case MessageName::GPUConnectionToWebProcess_CreateGraphicsContextGL:
        return jsValueForDecodedMessage<MessageName::GPUConnectionToWebProcess_CreateGraphicsContextGL>(globalObject, decoder);
    case MessageName::GPUConnectionToWebProcess_ReleaseGraphicsContextGL:
        return jsValueForDecodedMessage<MessageName::GPUConnectionToWebProcess_ReleaseGraphicsContextGL>(globalObject, decoder);
#endif
    case MessageName::GPUConnectionToWebProcess_CreateGPU:
        return jsValueForDecodedMessage<MessageName::GPUConnectionToWebProcess_CreateGPU>(globalObject, decoder);
    case MessageName::GPUConnectionToWebProcess_ReleaseGPU:
        return jsValueForDecodedMessage<MessageName::GPUConnectionToWebProcess_ReleaseGPU>(globalObject, decoder);
    case MessageName::GPUConnectionToWebProcess_ClearNowPlayingInfo:
        return jsValueForDecodedMessage<MessageName::GPUConnectionToWebProcess_ClearNowPlayingInfo>(globalObject, decoder);
    case MessageName::GPUConnectionToWebProcess_SetNowPlayingInfo:
        return jsValueForDecodedMessage<MessageName::GPUConnectionToWebProcess_SetNowPlayingInfo>(globalObject, decoder);
#if USE(AUDIO_SESSION)
    case MessageName::GPUConnectionToWebProcess_EnsureAudioSession:
        return jsValueForDecodedMessage<MessageName::GPUConnectionToWebProcess_EnsureAudioSession>(globalObject, decoder);
#endif
#if PLATFORM(IOS_FAMILY)
    case MessageName::GPUConnectionToWebProcess_EnsureMediaSessionHelper:
        return jsValueForDecodedMessage<MessageName::GPUConnectionToWebProcess_EnsureMediaSessionHelper>(globalObject, decoder);
#endif
#if HAVE(VISIBILITY_PROPAGATION_VIEW)
    case MessageName::GPUConnectionToWebProcess_CreateVisibilityPropagationContextForPage:
        return jsValueForDecodedMessage<MessageName::GPUConnectionToWebProcess_CreateVisibilityPropagationContextForPage>(globalObject, decoder);
    case MessageName::GPUConnectionToWebProcess_DestroyVisibilityPropagationContextForPage:
        return jsValueForDecodedMessage<MessageName::GPUConnectionToWebProcess_DestroyVisibilityPropagationContextForPage>(globalObject, decoder);
#endif
    case MessageName::GPUConnectionToWebProcess_SetMediaOverridesForTesting:
        return jsValueForDecodedMessage<MessageName::GPUConnectionToWebProcess_SetMediaOverridesForTesting>(globalObject, decoder);
    case MessageName::GPUConnectionToWebProcess_CreateAudioHardwareListener:
        return jsValueForDecodedMessage<MessageName::GPUConnectionToWebProcess_CreateAudioHardwareListener>(globalObject, decoder);
    case MessageName::GPUConnectionToWebProcess_ReleaseAudioHardwareListener:
        return jsValueForDecodedMessage<MessageName::GPUConnectionToWebProcess_ReleaseAudioHardwareListener>(globalObject, decoder);
    case MessageName::GPUConnectionToWebProcess_CreateRemoteCommandListener:
        return jsValueForDecodedMessage<MessageName::GPUConnectionToWebProcess_CreateRemoteCommandListener>(globalObject, decoder);
    case MessageName::GPUConnectionToWebProcess_ReleaseRemoteCommandListener:
        return jsValueForDecodedMessage<MessageName::GPUConnectionToWebProcess_ReleaseRemoteCommandListener>(globalObject, decoder);
    case MessageName::GPUConnectionToWebProcess_ConfigureLoggingChannel:
        return jsValueForDecodedMessage<MessageName::GPUConnectionToWebProcess_ConfigureLoggingChannel>(globalObject, decoder);
#if USE(GRAPHICS_LAYER_WC)
    case MessageName::GPUConnectionToWebProcess_CreateWCLayerTreeHost:
        return jsValueForDecodedMessage<MessageName::GPUConnectionToWebProcess_CreateWCLayerTreeHost>(globalObject, decoder);
    case MessageName::GPUConnectionToWebProcess_ReleaseWCLayerTreeHost:
        return jsValueForDecodedMessage<MessageName::GPUConnectionToWebProcess_ReleaseWCLayerTreeHost>(globalObject, decoder);
#endif
#if ENABLE(MEDIA_SOURCE)
    case MessageName::GPUConnectionToWebProcess_EnableMockMediaSource:
        return jsValueForDecodedMessage<MessageName::GPUConnectionToWebProcess_EnableMockMediaSource>(globalObject, decoder);
#endif
#if PLATFORM(COCOA) && ENABLE(MEDIA_STREAM)
    case MessageName::GPUConnectionToWebProcess_UpdateSampleBufferDisplayLayerBoundsAndPosition:
        return jsValueForDecodedMessage<MessageName::GPUConnectionToWebProcess_UpdateSampleBufferDisplayLayerBoundsAndPosition>(globalObject, decoder);
#endif
#if ENABLE(EXTENSION_CAPABILITIES)
    case MessageName::GPUConnectionToWebProcess_SetMediaEnvironment:
        return jsValueForDecodedMessage<MessageName::GPUConnectionToWebProcess_SetMediaEnvironment>(globalObject, decoder);
#endif
#endif
#if ENABLE(GPU_PROCESS)
    case MessageName::GPUProcess_InitializeGPUProcess:
        return jsValueForDecodedMessage<MessageName::GPUProcess_InitializeGPUProcess>(globalObject, decoder);
    case MessageName::GPUProcess_CreateGPUConnectionToWebProcess:
        return jsValueForDecodedMessage<MessageName::GPUProcess_CreateGPUConnectionToWebProcess>(globalObject, decoder);
    case MessageName::GPUProcess_SharedPreferencesForWebProcessDidChange:
        return jsValueForDecodedMessage<MessageName::GPUProcess_SharedPreferencesForWebProcessDidChange>(globalObject, decoder);
    case MessageName::GPUProcess_UpdateGPUProcessPreferences:
        return jsValueForDecodedMessage<MessageName::GPUProcess_UpdateGPUProcessPreferences>(globalObject, decoder);
    case MessageName::GPUProcess_UpdateSandboxAccess:
        return jsValueForDecodedMessage<MessageName::GPUProcess_UpdateSandboxAccess>(globalObject, decoder);
    case MessageName::GPUProcess_PrepareToSuspend:
        return jsValueForDecodedMessage<MessageName::GPUProcess_PrepareToSuspend>(globalObject, decoder);
    case MessageName::GPUProcess_ProcessDidResume:
        return jsValueForDecodedMessage<MessageName::GPUProcess_ProcessDidResume>(globalObject, decoder);
    case MessageName::GPUProcess_AddSession:
        return jsValueForDecodedMessage<MessageName::GPUProcess_AddSession>(globalObject, decoder);
    case MessageName::GPUProcess_RemoveSession:
        return jsValueForDecodedMessage<MessageName::GPUProcess_RemoveSession>(globalObject, decoder);
#if ENABLE(MEDIA_STREAM)
    case MessageName::GPUProcess_SetMockCaptureDevicesEnabled:
        return jsValueForDecodedMessage<MessageName::GPUProcess_SetMockCaptureDevicesEnabled>(globalObject, decoder);
    case MessageName::GPUProcess_SetOrientationForMediaCapture:
        return jsValueForDecodedMessage<MessageName::GPUProcess_SetOrientationForMediaCapture>(globalObject, decoder);
    case MessageName::GPUProcess_RotationAngleForCaptureDeviceChanged:
        return jsValueForDecodedMessage<MessageName::GPUProcess_RotationAngleForCaptureDeviceChanged>(globalObject, decoder);
    case MessageName::GPUProcess_UpdateCaptureAccess:
        return jsValueForDecodedMessage<MessageName::GPUProcess_UpdateCaptureAccess>(globalObject, decoder);
    case MessageName::GPUProcess_UpdateCaptureOrigin:
        return jsValueForDecodedMessage<MessageName::GPUProcess_UpdateCaptureOrigin>(globalObject, decoder);
    case MessageName::GPUProcess_AddMockMediaDevice:
        return jsValueForDecodedMessage<MessageName::GPUProcess_AddMockMediaDevice>(globalObject, decoder);
    case MessageName::GPUProcess_ClearMockMediaDevices:
        return jsValueForDecodedMessage<MessageName::GPUProcess_ClearMockMediaDevices>(globalObject, decoder);
    case MessageName::GPUProcess_RemoveMockMediaDevice:
        return jsValueForDecodedMessage<MessageName::GPUProcess_RemoveMockMediaDevice>(globalObject, decoder);
    case MessageName::GPUProcess_SetMockMediaDeviceIsEphemeral:
        return jsValueForDecodedMessage<MessageName::GPUProcess_SetMockMediaDeviceIsEphemeral>(globalObject, decoder);
    case MessageName::GPUProcess_ResetMockMediaDevices:
        return jsValueForDecodedMessage<MessageName::GPUProcess_ResetMockMediaDevices>(globalObject, decoder);
    case MessageName::GPUProcess_SetMockCaptureDevicesInterrupted:
        return jsValueForDecodedMessage<MessageName::GPUProcess_SetMockCaptureDevicesInterrupted>(globalObject, decoder);
    case MessageName::GPUProcess_TriggerMockCaptureConfigurationChange:
        return jsValueForDecodedMessage<MessageName::GPUProcess_TriggerMockCaptureConfigurationChange>(globalObject, decoder);
    case MessageName::GPUProcess_SetShouldListenToVoiceActivity:
        return jsValueForDecodedMessage<MessageName::GPUProcess_SetShouldListenToVoiceActivity>(globalObject, decoder);
    case MessageName::GPUProcess_EnableMicrophoneMuteStatusAPI:
        return jsValueForDecodedMessage<MessageName::GPUProcess_EnableMicrophoneMuteStatusAPI>(globalObject, decoder);
#endif
#if PLATFORM(MAC)
    case MessageName::GPUProcess_SetScreenProperties:
        return jsValueForDecodedMessage<MessageName::GPUProcess_SetScreenProperties>(globalObject, decoder);
#endif
#if HAVE(SCREEN_CAPTURE_KIT)
    case MessageName::GPUProcess_PromptForGetDisplayMedia:
        return jsValueForDecodedMessage<MessageName::GPUProcess_PromptForGetDisplayMedia>(globalObject, decoder);
    case MessageName::GPUProcess_CancelGetDisplayMediaPrompt:
        return jsValueForDecodedMessage<MessageName::GPUProcess_CancelGetDisplayMediaPrompt>(globalObject, decoder);
#endif
#if ENABLE(VIDEO)
    case MessageName::GPUProcess_RequestBitmapImageForCurrentTime:
        return jsValueForDecodedMessage<MessageName::GPUProcess_RequestBitmapImageForCurrentTime>(globalObject, decoder);
#endif
#if PLATFORM(MAC)
    case MessageName::GPUProcess_OpenDirectoryCacheInvalidated:
        return jsValueForDecodedMessage<MessageName::GPUProcess_OpenDirectoryCacheInvalidated>(globalObject, decoder);
#endif
#if HAVE(AUDIO_COMPONENT_SERVER_REGISTRATIONS)
    case MessageName::GPUProcess_ConsumeAudioComponentRegistrations:
        return jsValueForDecodedMessage<MessageName::GPUProcess_ConsumeAudioComponentRegistrations>(globalObject, decoder);
#endif
#if HAVE(POWERLOG_TASK_MODE_QUERY)
    case MessageName::GPUProcess_EnablePowerLogging:
        return jsValueForDecodedMessage<MessageName::GPUProcess_EnablePowerLogging>(globalObject, decoder);
#endif
    case MessageName::GPUProcess_UserPreferredLanguagesChanged:
        return jsValueForDecodedMessage<MessageName::GPUProcess_UserPreferredLanguagesChanged>(globalObject, decoder);
    case MessageName::GPUProcess_WebProcessConnectionCountForTesting:
        return jsValueForDecodedMessage<MessageName::GPUProcess_WebProcessConnectionCountForTesting>(globalObject, decoder);
#if USE(EXTENSIONKIT)
    case MessageName::GPUProcess_ResolveBookmarkDataForCacheDirectory:
        return jsValueForDecodedMessage<MessageName::GPUProcess_ResolveBookmarkDataForCacheDirectory>(globalObject, decoder);
#endif
#if ENABLE(WEBXR)
    case MessageName::GPUProcess_WebXRPromptAccepted:
        return jsValueForDecodedMessage<MessageName::GPUProcess_WebXRPromptAccepted>(globalObject, decoder);
#endif
#if HAVE(AUDIT_TOKEN)
    case MessageName::GPUProcess_SetPresentingApplicationAuditToken:
        return jsValueForDecodedMessage<MessageName::GPUProcess_SetPresentingApplicationAuditToken>(globalObject, decoder);
#endif
#if PLATFORM(VISION) && ENABLE(MODEL_PROCESS)
    case MessageName::GPUProcess_RequestSharedSimulationConnection:
        return jsValueForDecodedMessage<MessageName::GPUProcess_RequestSharedSimulationConnection>(globalObject, decoder);
#endif
#if ((PLATFORM(VISION) && ENABLE(MODEL_PROCESS)) && HAVE(TASK_IDENTITY_TOKEN))
    case MessageName::GPUProcess_CreateMemoryAttributionIDForTask:
        return jsValueForDecodedMessage<MessageName::GPUProcess_CreateMemoryAttributionIDForTask>(globalObject, decoder);
    case MessageName::GPUProcess_UnregisterMemoryAttributionID:
        return jsValueForDecodedMessage<MessageName::GPUProcess_UnregisterMemoryAttributionID>(globalObject, decoder);
#endif
#if PLATFORM(COCOA)
    case MessageName::GPUProcess_PostWillTakeSnapshotNotification:
        return jsValueForDecodedMessage<MessageName::GPUProcess_PostWillTakeSnapshotNotification>(globalObject, decoder);
    case MessageName::GPUProcess_RegisterFonts:
        return jsValueForDecodedMessage<MessageName::GPUProcess_RegisterFonts>(globalObject, decoder);
#endif
#endif
#if ENABLE(GPU_PROCESS)
    case MessageName::RemoteSharedResourceCache_ReleaseSerializedImageBuffer:
        return jsValueForDecodedMessage<MessageName::RemoteSharedResourceCache_ReleaseSerializedImageBuffer>(globalObject, decoder);
#endif
#if ENABLE(GPU_PROCESS)
    case MessageName::RemoteBarcodeDetector_Detect:
        return jsValueForDecodedMessage<MessageName::RemoteBarcodeDetector_Detect>(globalObject, decoder);
#endif
#if ENABLE(GPU_PROCESS)
    case MessageName::RemoteFaceDetector_Detect:
        return jsValueForDecodedMessage<MessageName::RemoteFaceDetector_Detect>(globalObject, decoder);
#endif
#if ENABLE(GPU_PROCESS)
    case MessageName::RemoteTextDetector_Detect:
        return jsValueForDecodedMessage<MessageName::RemoteTextDetector_Detect>(globalObject, decoder);
#endif
#if ENABLE(GPU_PROCESS)
    case MessageName::RemoteDisplayListRecorder_Save:
        return jsValueForDecodedMessage<MessageName::RemoteDisplayListRecorder_Save>(globalObject, decoder);
    case MessageName::RemoteDisplayListRecorder_Restore:
        return jsValueForDecodedMessage<MessageName::RemoteDisplayListRecorder_Restore>(globalObject, decoder);
    case MessageName::RemoteDisplayListRecorder_Translate:
        return jsValueForDecodedMessage<MessageName::RemoteDisplayListRecorder_Translate>(globalObject, decoder);
    case MessageName::RemoteDisplayListRecorder_Rotate:
        return jsValueForDecodedMessage<MessageName::RemoteDisplayListRecorder_Rotate>(globalObject, decoder);
    case MessageName::RemoteDisplayListRecorder_Scale:
        return jsValueForDecodedMessage<MessageName::RemoteDisplayListRecorder_Scale>(globalObject, decoder);
    case MessageName::RemoteDisplayListRecorder_SetCTM:
        return jsValueForDecodedMessage<MessageName::RemoteDisplayListRecorder_SetCTM>(globalObject, decoder);
    case MessageName::RemoteDisplayListRecorder_ConcatCTM:
        return jsValueForDecodedMessage<MessageName::RemoteDisplayListRecorder_ConcatCTM>(globalObject, decoder);
    case MessageName::RemoteDisplayListRecorder_SetFillPackedColor:
        return jsValueForDecodedMessage<MessageName::RemoteDisplayListRecorder_SetFillPackedColor>(globalObject, decoder);
    case MessageName::RemoteDisplayListRecorder_SetFillColor:
        return jsValueForDecodedMessage<MessageName::RemoteDisplayListRecorder_SetFillColor>(globalObject, decoder);
    case MessageName::RemoteDisplayListRecorder_SetFillCachedGradient:
        return jsValueForDecodedMessage<MessageName::RemoteDisplayListRecorder_SetFillCachedGradient>(globalObject, decoder);
    case MessageName::RemoteDisplayListRecorder_SetFillGradient:
        return jsValueForDecodedMessage<MessageName::RemoteDisplayListRecorder_SetFillGradient>(globalObject, decoder);
    case MessageName::RemoteDisplayListRecorder_SetFillPattern:
        return jsValueForDecodedMessage<MessageName::RemoteDisplayListRecorder_SetFillPattern>(globalObject, decoder);
    case MessageName::RemoteDisplayListRecorder_SetFillRule:
        return jsValueForDecodedMessage<MessageName::RemoteDisplayListRecorder_SetFillRule>(globalObject, decoder);
    case MessageName::RemoteDisplayListRecorder_SetStrokePackedColor:
        return jsValueForDecodedMessage<MessageName::RemoteDisplayListRecorder_SetStrokePackedColor>(globalObject, decoder);
    case MessageName::RemoteDisplayListRecorder_SetStrokeColor:
        return jsValueForDecodedMessage<MessageName::RemoteDisplayListRecorder_SetStrokeColor>(globalObject, decoder);
    case MessageName::RemoteDisplayListRecorder_SetStrokeCachedGradient:
        return jsValueForDecodedMessage<MessageName::RemoteDisplayListRecorder_SetStrokeCachedGradient>(globalObject, decoder);
    case MessageName::RemoteDisplayListRecorder_SetStrokeGradient:
        return jsValueForDecodedMessage<MessageName::RemoteDisplayListRecorder_SetStrokeGradient>(globalObject, decoder);
    case MessageName::RemoteDisplayListRecorder_SetStrokePattern:
        return jsValueForDecodedMessage<MessageName::RemoteDisplayListRecorder_SetStrokePattern>(globalObject, decoder);
    case MessageName::RemoteDisplayListRecorder_SetStrokePackedColorAndThickness:
        return jsValueForDecodedMessage<MessageName::RemoteDisplayListRecorder_SetStrokePackedColorAndThickness>(globalObject, decoder);
    case MessageName::RemoteDisplayListRecorder_SetStrokeThickness:
        return jsValueForDecodedMessage<MessageName::RemoteDisplayListRecorder_SetStrokeThickness>(globalObject, decoder);
    case MessageName::RemoteDisplayListRecorder_SetStrokeStyle:
        return jsValueForDecodedMessage<MessageName::RemoteDisplayListRecorder_SetStrokeStyle>(globalObject, decoder);
    case MessageName::RemoteDisplayListRecorder_SetCompositeMode:
        return jsValueForDecodedMessage<MessageName::RemoteDisplayListRecorder_SetCompositeMode>(globalObject, decoder);
    case MessageName::RemoteDisplayListRecorder_SetDropShadow:
        return jsValueForDecodedMessage<MessageName::RemoteDisplayListRecorder_SetDropShadow>(globalObject, decoder);
    case MessageName::RemoteDisplayListRecorder_SetStyle:
        return jsValueForDecodedMessage<MessageName::RemoteDisplayListRecorder_SetStyle>(globalObject, decoder);
    case MessageName::RemoteDisplayListRecorder_SetAlpha:
        return jsValueForDecodedMessage<MessageName::RemoteDisplayListRecorder_SetAlpha>(globalObject, decoder);
    case MessageName::RemoteDisplayListRecorder_SetTextDrawingMode:
        return jsValueForDecodedMessage<MessageName::RemoteDisplayListRecorder_SetTextDrawingMode>(globalObject, decoder);
    case MessageName::RemoteDisplayListRecorder_SetImageInterpolationQuality:
        return jsValueForDecodedMessage<MessageName::RemoteDisplayListRecorder_SetImageInterpolationQuality>(globalObject, decoder);
    case MessageName::RemoteDisplayListRecorder_SetShouldAntialias:
        return jsValueForDecodedMessage<MessageName::RemoteDisplayListRecorder_SetShouldAntialias>(globalObject, decoder);
    case MessageName::RemoteDisplayListRecorder_SetShouldSmoothFonts:
        return jsValueForDecodedMessage<MessageName::RemoteDisplayListRecorder_SetShouldSmoothFonts>(globalObject, decoder);
    case MessageName::RemoteDisplayListRecorder_SetShouldSubpixelQuantizeFonts:
        return jsValueForDecodedMessage<MessageName::RemoteDisplayListRecorder_SetShouldSubpixelQuantizeFonts>(globalObject, decoder);
    case MessageName::RemoteDisplayListRecorder_SetShadowsIgnoreTransforms:
        return jsValueForDecodedMessage<MessageName::RemoteDisplayListRecorder_SetShadowsIgnoreTransforms>(globalObject, decoder);
    case MessageName::RemoteDisplayListRecorder_SetDrawLuminanceMask:
        return jsValueForDecodedMessage<MessageName::RemoteDisplayListRecorder_SetDrawLuminanceMask>(globalObject, decoder);
    case MessageName::RemoteDisplayListRecorder_SetLineCap:
        return jsValueForDecodedMessage<MessageName::RemoteDisplayListRecorder_SetLineCap>(globalObject, decoder);
    case MessageName::RemoteDisplayListRecorder_SetLineDash:
        return jsValueForDecodedMessage<MessageName::RemoteDisplayListRecorder_SetLineDash>(globalObject, decoder);
    case MessageName::RemoteDisplayListRecorder_SetLineJoin:
        return jsValueForDecodedMessage<MessageName::RemoteDisplayListRecorder_SetLineJoin>(globalObject, decoder);
    case MessageName::RemoteDisplayListRecorder_SetMiterLimit:
        return jsValueForDecodedMessage<MessageName::RemoteDisplayListRecorder_SetMiterLimit>(globalObject, decoder);
    case MessageName::RemoteDisplayListRecorder_Clip:
        return jsValueForDecodedMessage<MessageName::RemoteDisplayListRecorder_Clip>(globalObject, decoder);
    case MessageName::RemoteDisplayListRecorder_ClipRoundedRect:
        return jsValueForDecodedMessage<MessageName::RemoteDisplayListRecorder_ClipRoundedRect>(globalObject, decoder);
    case MessageName::RemoteDisplayListRecorder_ClipOut:
        return jsValueForDecodedMessage<MessageName::RemoteDisplayListRecorder_ClipOut>(globalObject, decoder);
    case MessageName::RemoteDisplayListRecorder_ClipOutRoundedRect:
        return jsValueForDecodedMessage<MessageName::RemoteDisplayListRecorder_ClipOutRoundedRect>(globalObject, decoder);
    case MessageName::RemoteDisplayListRecorder_ClipToImageBuffer:
        return jsValueForDecodedMessage<MessageName::RemoteDisplayListRecorder_ClipToImageBuffer>(globalObject, decoder);
    case MessageName::RemoteDisplayListRecorder_ClipOutToPath:
        return jsValueForDecodedMessage<MessageName::RemoteDisplayListRecorder_ClipOutToPath>(globalObject, decoder);
    case MessageName::RemoteDisplayListRecorder_ClipPath:
        return jsValueForDecodedMessage<MessageName::RemoteDisplayListRecorder_ClipPath>(globalObject, decoder);
    case MessageName::RemoteDisplayListRecorder_ResetClip:
        return jsValueForDecodedMessage<MessageName::RemoteDisplayListRecorder_ResetClip>(globalObject, decoder);
    case MessageName::RemoteDisplayListRecorder_DrawGlyphs:
        return jsValueForDecodedMessage<MessageName::RemoteDisplayListRecorder_DrawGlyphs>(globalObject, decoder);
    case MessageName::RemoteDisplayListRecorder_DrawDecomposedGlyphs:
        return jsValueForDecodedMessage<MessageName::RemoteDisplayListRecorder_DrawDecomposedGlyphs>(globalObject, decoder);
    case MessageName::RemoteDisplayListRecorder_DrawFilteredImageBuffer:
        return jsValueForDecodedMessage<MessageName::RemoteDisplayListRecorder_DrawFilteredImageBuffer>(globalObject, decoder);
    case MessageName::RemoteDisplayListRecorder_DrawImageBuffer:
        return jsValueForDecodedMessage<MessageName::RemoteDisplayListRecorder_DrawImageBuffer>(globalObject, decoder);
    case MessageName::RemoteDisplayListRecorder_DrawNativeImage:
        return jsValueForDecodedMessage<MessageName::RemoteDisplayListRecorder_DrawNativeImage>(globalObject, decoder);
    case MessageName::RemoteDisplayListRecorder_DrawSystemImage:
        return jsValueForDecodedMessage<MessageName::RemoteDisplayListRecorder_DrawSystemImage>(globalObject, decoder);
    case MessageName::RemoteDisplayListRecorder_DrawPatternNativeImage:
        return jsValueForDecodedMessage<MessageName::RemoteDisplayListRecorder_DrawPatternNativeImage>(globalObject, decoder);
    case MessageName::RemoteDisplayListRecorder_DrawPatternImageBuffer:
        return jsValueForDecodedMessage<MessageName::RemoteDisplayListRecorder_DrawPatternImageBuffer>(globalObject, decoder);
    case MessageName::RemoteDisplayListRecorder_BeginTransparencyLayer:
        return jsValueForDecodedMessage<MessageName::RemoteDisplayListRecorder_BeginTransparencyLayer>(globalObject, decoder);
    case MessageName::RemoteDisplayListRecorder_BeginTransparencyLayerWithCompositeMode:
        return jsValueForDecodedMessage<MessageName::RemoteDisplayListRecorder_BeginTransparencyLayerWithCompositeMode>(globalObject, decoder);
    case MessageName::RemoteDisplayListRecorder_EndTransparencyLayer:
        return jsValueForDecodedMessage<MessageName::RemoteDisplayListRecorder_EndTransparencyLayer>(globalObject, decoder);
    case MessageName::RemoteDisplayListRecorder_DrawRect:
        return jsValueForDecodedMessage<MessageName::RemoteDisplayListRecorder_DrawRect>(globalObject, decoder);
    case MessageName::RemoteDisplayListRecorder_DrawLine:
        return jsValueForDecodedMessage<MessageName::RemoteDisplayListRecorder_DrawLine>(globalObject, decoder);
    case MessageName::RemoteDisplayListRecorder_DrawLinesForText:
        return jsValueForDecodedMessage<MessageName::RemoteDisplayListRecorder_DrawLinesForText>(globalObject, decoder);
    case MessageName::RemoteDisplayListRecorder_DrawDotsForDocumentMarker:
        return jsValueForDecodedMessage<MessageName::RemoteDisplayListRecorder_DrawDotsForDocumentMarker>(globalObject, decoder);
    case MessageName::RemoteDisplayListRecorder_DrawEllipse:
        return jsValueForDecodedMessage<MessageName::RemoteDisplayListRecorder_DrawEllipse>(globalObject, decoder);
    case MessageName::RemoteDisplayListRecorder_DrawPath:
        return jsValueForDecodedMessage<MessageName::RemoteDisplayListRecorder_DrawPath>(globalObject, decoder);
    case MessageName::RemoteDisplayListRecorder_DrawFocusRingPath:
        return jsValueForDecodedMessage<MessageName::RemoteDisplayListRecorder_DrawFocusRingPath>(globalObject, decoder);
    case MessageName::RemoteDisplayListRecorder_DrawFocusRingRects:
        return jsValueForDecodedMessage<MessageName::RemoteDisplayListRecorder_DrawFocusRingRects>(globalObject, decoder);
    case MessageName::RemoteDisplayListRecorder_FillRect:
        return jsValueForDecodedMessage<MessageName::RemoteDisplayListRecorder_FillRect>(globalObject, decoder);
    case MessageName::RemoteDisplayListRecorder_FillRectWithColor:
        return jsValueForDecodedMessage<MessageName::RemoteDisplayListRecorder_FillRectWithColor>(globalObject, decoder);
    case MessageName::RemoteDisplayListRecorder_FillRectWithGradient:
        return jsValueForDecodedMessage<MessageName::RemoteDisplayListRecorder_FillRectWithGradient>(globalObject, decoder);
    case MessageName::RemoteDisplayListRecorder_FillRectWithGradientAndSpaceTransform:
        return jsValueForDecodedMessage<MessageName::RemoteDisplayListRecorder_FillRectWithGradientAndSpaceTransform>(globalObject, decoder);
    case MessageName::RemoteDisplayListRecorder_FillCompositedRect:
        return jsValueForDecodedMessage<MessageName::RemoteDisplayListRecorder_FillCompositedRect>(globalObject, decoder);
    case MessageName::RemoteDisplayListRecorder_FillRoundedRect:
        return jsValueForDecodedMessage<MessageName::RemoteDisplayListRecorder_FillRoundedRect>(globalObject, decoder);
    case MessageName::RemoteDisplayListRecorder_FillRectWithRoundedHole:
        return jsValueForDecodedMessage<MessageName::RemoteDisplayListRecorder_FillRectWithRoundedHole>(globalObject, decoder);
#if ENABLE(INLINE_PATH_DATA)
    case MessageName::RemoteDisplayListRecorder_FillLine:
        return jsValueForDecodedMessage<MessageName::RemoteDisplayListRecorder_FillLine>(globalObject, decoder);
    case MessageName::RemoteDisplayListRecorder_FillArc:
        return jsValueForDecodedMessage<MessageName::RemoteDisplayListRecorder_FillArc>(globalObject, decoder);
    case MessageName::RemoteDisplayListRecorder_FillClosedArc:
        return jsValueForDecodedMessage<MessageName::RemoteDisplayListRecorder_FillClosedArc>(globalObject, decoder);
    case MessageName::RemoteDisplayListRecorder_FillQuadCurve:
        return jsValueForDecodedMessage<MessageName::RemoteDisplayListRecorder_FillQuadCurve>(globalObject, decoder);
    case MessageName::RemoteDisplayListRecorder_FillBezierCurve:
        return jsValueForDecodedMessage<MessageName::RemoteDisplayListRecorder_FillBezierCurve>(globalObject, decoder);
#endif
    case MessageName::RemoteDisplayListRecorder_FillPathSegment:
        return jsValueForDecodedMessage<MessageName::RemoteDisplayListRecorder_FillPathSegment>(globalObject, decoder);
    case MessageName::RemoteDisplayListRecorder_FillPath:
        return jsValueForDecodedMessage<MessageName::RemoteDisplayListRecorder_FillPath>(globalObject, decoder);
    case MessageName::RemoteDisplayListRecorder_FillEllipse:
        return jsValueForDecodedMessage<MessageName::RemoteDisplayListRecorder_FillEllipse>(globalObject, decoder);
    case MessageName::RemoteDisplayListRecorder_StrokeRect:
        return jsValueForDecodedMessage<MessageName::RemoteDisplayListRecorder_StrokeRect>(globalObject, decoder);
#if ENABLE(INLINE_PATH_DATA)
    case MessageName::RemoteDisplayListRecorder_StrokeLine:
        return jsValueForDecodedMessage<MessageName::RemoteDisplayListRecorder_StrokeLine>(globalObject, decoder);
    case MessageName::RemoteDisplayListRecorder_StrokeLineWithColorAndThickness:
        return jsValueForDecodedMessage<MessageName::RemoteDisplayListRecorder_StrokeLineWithColorAndThickness>(globalObject, decoder);
    case MessageName::RemoteDisplayListRecorder_StrokeArc:
        return jsValueForDecodedMessage<MessageName::RemoteDisplayListRecorder_StrokeArc>(globalObject, decoder);
    case MessageName::RemoteDisplayListRecorder_StrokeClosedArc:
        return jsValueForDecodedMessage<MessageName::RemoteDisplayListRecorder_StrokeClosedArc>(globalObject, decoder);
    case MessageName::RemoteDisplayListRecorder_StrokeQuadCurve:
        return jsValueForDecodedMessage<MessageName::RemoteDisplayListRecorder_StrokeQuadCurve>(globalObject, decoder);
    case MessageName::RemoteDisplayListRecorder_StrokeBezierCurve:
        return jsValueForDecodedMessage<MessageName::RemoteDisplayListRecorder_StrokeBezierCurve>(globalObject, decoder);
#endif
    case MessageName::RemoteDisplayListRecorder_StrokePathSegment:
        return jsValueForDecodedMessage<MessageName::RemoteDisplayListRecorder_StrokePathSegment>(globalObject, decoder);
    case MessageName::RemoteDisplayListRecorder_StrokePath:
        return jsValueForDecodedMessage<MessageName::RemoteDisplayListRecorder_StrokePath>(globalObject, decoder);
    case MessageName::RemoteDisplayListRecorder_StrokeEllipse:
        return jsValueForDecodedMessage<MessageName::RemoteDisplayListRecorder_StrokeEllipse>(globalObject, decoder);
    case MessageName::RemoteDisplayListRecorder_ClearRect:
        return jsValueForDecodedMessage<MessageName::RemoteDisplayListRecorder_ClearRect>(globalObject, decoder);
    case MessageName::RemoteDisplayListRecorder_DrawControlPart:
        return jsValueForDecodedMessage<MessageName::RemoteDisplayListRecorder_DrawControlPart>(globalObject, decoder);
#if USE(CG)
    case MessageName::RemoteDisplayListRecorder_ApplyStrokePattern:
        return jsValueForDecodedMessage<MessageName::RemoteDisplayListRecorder_ApplyStrokePattern>(globalObject, decoder);
    case MessageName::RemoteDisplayListRecorder_ApplyFillPattern:
        return jsValueForDecodedMessage<MessageName::RemoteDisplayListRecorder_ApplyFillPattern>(globalObject, decoder);
#endif
    case MessageName::RemoteDisplayListRecorder_ApplyDeviceScaleFactor:
        return jsValueForDecodedMessage<MessageName::RemoteDisplayListRecorder_ApplyDeviceScaleFactor>(globalObject, decoder);
    case MessageName::RemoteDisplayListRecorder_BeginPage:
        return jsValueForDecodedMessage<MessageName::RemoteDisplayListRecorder_BeginPage>(globalObject, decoder);
    case MessageName::RemoteDisplayListRecorder_EndPage:
        return jsValueForDecodedMessage<MessageName::RemoteDisplayListRecorder_EndPage>(globalObject, decoder);
    case MessageName::RemoteDisplayListRecorder_SetURLForRect:
        return jsValueForDecodedMessage<MessageName::RemoteDisplayListRecorder_SetURLForRect>(globalObject, decoder);
#if PLATFORM(COCOA) && ENABLE(VIDEO)
    case MessageName::RemoteDisplayListRecorder_DrawVideoFrame:
        return jsValueForDecodedMessage<MessageName::RemoteDisplayListRecorder_DrawVideoFrame>(globalObject, decoder);
    case MessageName::RemoteDisplayListRecorder_SetSharedVideoFrameSemaphore:
        return jsValueForDecodedMessage<MessageName::RemoteDisplayListRecorder_SetSharedVideoFrameSemaphore>(globalObject, decoder);
    case MessageName::RemoteDisplayListRecorder_SetSharedVideoFrameMemory:
        return jsValueForDecodedMessage<MessageName::RemoteDisplayListRecorder_SetSharedVideoFrameMemory>(globalObject, decoder);
#endif
#endif
#if ENABLE(GPU_PROCESS) && ENABLE(WEBGL)
    case MessageName::RemoteGraphicsContextGL_Reshape:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_Reshape>(globalObject, decoder);
#if PLATFORM(COCOA)
    case MessageName::RemoteGraphicsContextGL_PrepareForDisplay:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_PrepareForDisplay>(globalObject, decoder);
#endif
#if USE(GRAPHICS_LAYER_WC)
    case MessageName::RemoteGraphicsContextGL_PrepareForDisplay:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_PrepareForDisplay>(globalObject, decoder);
#endif
#if USE(GBM)
    case MessageName::RemoteGraphicsContextGL_PrepareForDisplay:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_PrepareForDisplay>(globalObject, decoder);
#endif
#if !PLATFORM(COCOA) && !USE(GRAPHICS_LAYER_WC) && !USE(GBM)
    case MessageName::RemoteGraphicsContextGL_PrepareForDisplay:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_PrepareForDisplay>(globalObject, decoder);
#endif
    case MessageName::RemoteGraphicsContextGL_EnsureExtensionEnabled:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_EnsureExtensionEnabled>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_GetErrors:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_GetErrors>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_DrawSurfaceBufferToImageBuffer:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_DrawSurfaceBufferToImageBuffer>(globalObject, decoder);
#if ENABLE(MEDIA_STREAM) || ENABLE(WEB_CODECS)
    case MessageName::RemoteGraphicsContextGL_SurfaceBufferToVideoFrame:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_SurfaceBufferToVideoFrame>(globalObject, decoder);
#endif
#if ENABLE(VIDEO) && PLATFORM(COCOA)
    case MessageName::RemoteGraphicsContextGL_CopyTextureFromVideoFrame:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_CopyTextureFromVideoFrame>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_SetSharedVideoFrameSemaphore:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_SetSharedVideoFrameSemaphore>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_SetSharedVideoFrameMemory:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_SetSharedVideoFrameMemory>(globalObject, decoder);
#endif
    case MessageName::RemoteGraphicsContextGL_SimulateEventForTesting:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_SimulateEventForTesting>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_GetBufferSubDataInline:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_GetBufferSubDataInline>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_GetBufferSubDataSharedMemory:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_GetBufferSubDataSharedMemory>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_ReadPixelsInline:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_ReadPixelsInline>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_ReadPixelsSharedMemory:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_ReadPixelsSharedMemory>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_MultiDrawArraysANGLE:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_MultiDrawArraysANGLE>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_MultiDrawArraysInstancedANGLE:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_MultiDrawArraysInstancedANGLE>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_MultiDrawElementsANGLE:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_MultiDrawElementsANGLE>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_MultiDrawElementsInstancedANGLE:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_MultiDrawElementsInstancedANGLE>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_MultiDrawArraysInstancedBaseInstanceANGLE:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_MultiDrawArraysInstancedBaseInstanceANGLE>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_MultiDrawElementsInstancedBaseVertexBaseInstanceANGLE:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_MultiDrawElementsInstancedBaseVertexBaseInstanceANGLE>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_DrawBuffers:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_DrawBuffers>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_DrawBuffersEXT:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_DrawBuffersEXT>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_InvalidateFramebuffer:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_InvalidateFramebuffer>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_InvalidateSubFramebuffer:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_InvalidateSubFramebuffer>(globalObject, decoder);
#if ENABLE(WEBXR)
    case MessageName::RemoteGraphicsContextGL_FramebufferDiscard:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_FramebufferDiscard>(globalObject, decoder);
#endif
    case MessageName::RemoteGraphicsContextGL_ActiveTexture:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_ActiveTexture>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_AttachShader:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_AttachShader>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_BindAttribLocation:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_BindAttribLocation>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_BindBuffer:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_BindBuffer>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_BindFramebuffer:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_BindFramebuffer>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_BindRenderbuffer:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_BindRenderbuffer>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_BindTexture:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_BindTexture>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_BlendColor:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_BlendColor>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_BlendEquation:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_BlendEquation>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_BlendEquationSeparate:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_BlendEquationSeparate>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_BlendFunc:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_BlendFunc>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_BlendFuncSeparate:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_BlendFuncSeparate>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_CheckFramebufferStatus:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_CheckFramebufferStatus>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_Clear:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_Clear>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_ClearColor:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_ClearColor>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_ClearDepth:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_ClearDepth>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_ClearStencil:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_ClearStencil>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_ColorMask:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_ColorMask>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_CompileShader:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_CompileShader>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_CopyTexImage2D:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_CopyTexImage2D>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_CopyTexSubImage2D:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_CopyTexSubImage2D>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_CreateBuffer:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_CreateBuffer>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_CreateFramebuffer:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_CreateFramebuffer>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_CreateProgram:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_CreateProgram>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_CreateRenderbuffer:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_CreateRenderbuffer>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_CreateShader:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_CreateShader>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_CreateTexture:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_CreateTexture>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_CullFace:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_CullFace>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_DeleteBuffer:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_DeleteBuffer>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_DeleteFramebuffer:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_DeleteFramebuffer>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_DeleteProgram:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_DeleteProgram>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_DeleteRenderbuffer:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_DeleteRenderbuffer>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_DeleteShader:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_DeleteShader>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_DeleteTexture:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_DeleteTexture>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_DepthFunc:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_DepthFunc>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_DepthMask:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_DepthMask>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_DepthRange:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_DepthRange>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_DetachShader:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_DetachShader>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_Disable:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_Disable>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_DisableVertexAttribArray:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_DisableVertexAttribArray>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_DrawArrays:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_DrawArrays>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_DrawElements:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_DrawElements>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_Enable:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_Enable>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_EnableVertexAttribArray:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_EnableVertexAttribArray>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_Finish:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_Finish>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_Flush:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_Flush>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_FramebufferRenderbuffer:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_FramebufferRenderbuffer>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_FramebufferTexture2D:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_FramebufferTexture2D>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_FrontFace:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_FrontFace>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_GenerateMipmap:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_GenerateMipmap>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_GetActiveAttrib:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_GetActiveAttrib>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_GetActiveUniform:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_GetActiveUniform>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_GetAttribLocation:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_GetAttribLocation>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_GetBufferParameteri:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_GetBufferParameteri>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_GetString:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_GetString>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_GetFloatv:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_GetFloatv>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_GetIntegerv:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_GetIntegerv>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_GetIntegeri_v:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_GetIntegeri_v>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_GetInteger64:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_GetInteger64>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_GetInteger64i:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_GetInteger64i>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_GetProgrami:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_GetProgrami>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_GetBooleanv:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_GetBooleanv>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_GetFramebufferAttachmentParameteri:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_GetFramebufferAttachmentParameteri>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_GetProgramInfoLog:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_GetProgramInfoLog>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_GetRenderbufferParameteri:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_GetRenderbufferParameteri>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_GetShaderi:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_GetShaderi>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_GetShaderInfoLog:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_GetShaderInfoLog>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_GetShaderPrecisionFormat:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_GetShaderPrecisionFormat>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_GetShaderSource:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_GetShaderSource>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_GetTexParameterf:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_GetTexParameterf>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_GetTexParameteri:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_GetTexParameteri>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_GetUniformfv:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_GetUniformfv>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_GetUniformiv:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_GetUniformiv>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_GetUniformuiv:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_GetUniformuiv>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_GetUniformLocation:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_GetUniformLocation>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_GetVertexAttribOffset:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_GetVertexAttribOffset>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_Hint:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_Hint>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_IsBuffer:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_IsBuffer>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_IsEnabled:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_IsEnabled>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_IsFramebuffer:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_IsFramebuffer>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_IsProgram:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_IsProgram>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_IsRenderbuffer:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_IsRenderbuffer>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_IsShader:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_IsShader>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_IsTexture:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_IsTexture>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_LineWidth:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_LineWidth>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_LinkProgram:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_LinkProgram>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_PixelStorei:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_PixelStorei>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_PolygonOffset:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_PolygonOffset>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_RenderbufferStorage:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_RenderbufferStorage>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_SampleCoverage:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_SampleCoverage>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_Scissor:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_Scissor>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_ShaderSource:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_ShaderSource>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_StencilFunc:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_StencilFunc>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_StencilFuncSeparate:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_StencilFuncSeparate>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_StencilMask:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_StencilMask>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_StencilMaskSeparate:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_StencilMaskSeparate>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_StencilOp:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_StencilOp>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_StencilOpSeparate:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_StencilOpSeparate>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_TexParameterf:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_TexParameterf>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_TexParameteri:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_TexParameteri>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_Uniform1f:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_Uniform1f>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_Uniform1fv:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_Uniform1fv>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_Uniform1i:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_Uniform1i>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_Uniform1iv:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_Uniform1iv>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_Uniform2f:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_Uniform2f>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_Uniform2fv:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_Uniform2fv>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_Uniform2i:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_Uniform2i>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_Uniform2iv:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_Uniform2iv>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_Uniform3f:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_Uniform3f>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_Uniform3fv:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_Uniform3fv>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_Uniform3i:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_Uniform3i>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_Uniform3iv:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_Uniform3iv>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_Uniform4f:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_Uniform4f>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_Uniform4fv:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_Uniform4fv>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_Uniform4i:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_Uniform4i>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_Uniform4iv:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_Uniform4iv>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_UniformMatrix2fv:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_UniformMatrix2fv>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_UniformMatrix3fv:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_UniformMatrix3fv>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_UniformMatrix4fv:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_UniformMatrix4fv>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_UseProgram:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_UseProgram>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_ValidateProgram:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_ValidateProgram>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_VertexAttrib1f:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_VertexAttrib1f>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_VertexAttrib1fv:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_VertexAttrib1fv>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_VertexAttrib2f:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_VertexAttrib2f>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_VertexAttrib2fv:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_VertexAttrib2fv>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_VertexAttrib3f:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_VertexAttrib3f>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_VertexAttrib3fv:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_VertexAttrib3fv>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_VertexAttrib4f:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_VertexAttrib4f>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_VertexAttrib4fv:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_VertexAttrib4fv>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_VertexAttribPointer:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_VertexAttribPointer>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_Viewport:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_Viewport>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_BufferData0:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_BufferData0>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_BufferData1:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_BufferData1>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_BufferSubData:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_BufferSubData>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_ReadPixelsBufferObject:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_ReadPixelsBufferObject>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_TexImage2D0:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_TexImage2D0>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_TexImage2D1:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_TexImage2D1>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_TexSubImage2D0:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_TexSubImage2D0>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_TexSubImage2D1:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_TexSubImage2D1>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_CompressedTexImage2D0:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_CompressedTexImage2D0>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_CompressedTexImage2D1:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_CompressedTexImage2D1>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_CompressedTexSubImage2D0:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_CompressedTexSubImage2D0>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_CompressedTexSubImage2D1:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_CompressedTexSubImage2D1>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_DrawArraysInstanced:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_DrawArraysInstanced>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_DrawElementsInstanced:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_DrawElementsInstanced>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_VertexAttribDivisor:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_VertexAttribDivisor>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_CreateVertexArray:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_CreateVertexArray>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_DeleteVertexArray:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_DeleteVertexArray>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_IsVertexArray:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_IsVertexArray>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_BindVertexArray:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_BindVertexArray>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_CopyBufferSubData:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_CopyBufferSubData>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_BlitFramebuffer:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_BlitFramebuffer>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_FramebufferTextureLayer:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_FramebufferTextureLayer>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_ReadBuffer:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_ReadBuffer>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_RenderbufferStorageMultisample:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_RenderbufferStorageMultisample>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_TexStorage2D:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_TexStorage2D>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_TexStorage3D:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_TexStorage3D>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_TexImage3D0:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_TexImage3D0>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_TexImage3D1:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_TexImage3D1>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_TexSubImage3D0:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_TexSubImage3D0>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_TexSubImage3D1:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_TexSubImage3D1>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_CopyTexSubImage3D:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_CopyTexSubImage3D>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_CompressedTexImage3D0:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_CompressedTexImage3D0>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_CompressedTexImage3D1:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_CompressedTexImage3D1>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_CompressedTexSubImage3D0:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_CompressedTexSubImage3D0>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_CompressedTexSubImage3D1:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_CompressedTexSubImage3D1>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_GetFragDataLocation:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_GetFragDataLocation>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_Uniform1ui:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_Uniform1ui>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_Uniform2ui:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_Uniform2ui>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_Uniform3ui:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_Uniform3ui>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_Uniform4ui:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_Uniform4ui>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_Uniform1uiv:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_Uniform1uiv>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_Uniform2uiv:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_Uniform2uiv>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_Uniform3uiv:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_Uniform3uiv>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_Uniform4uiv:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_Uniform4uiv>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_UniformMatrix2x3fv:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_UniformMatrix2x3fv>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_UniformMatrix3x2fv:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_UniformMatrix3x2fv>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_UniformMatrix2x4fv:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_UniformMatrix2x4fv>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_UniformMatrix4x2fv:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_UniformMatrix4x2fv>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_UniformMatrix3x4fv:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_UniformMatrix3x4fv>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_UniformMatrix4x3fv:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_UniformMatrix4x3fv>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_VertexAttribI4i:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_VertexAttribI4i>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_VertexAttribI4iv:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_VertexAttribI4iv>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_VertexAttribI4ui:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_VertexAttribI4ui>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_VertexAttribI4uiv:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_VertexAttribI4uiv>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_VertexAttribIPointer:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_VertexAttribIPointer>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_DrawRangeElements:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_DrawRangeElements>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_ClearBufferiv:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_ClearBufferiv>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_ClearBufferuiv:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_ClearBufferuiv>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_ClearBufferfv:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_ClearBufferfv>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_ClearBufferfi:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_ClearBufferfi>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_CreateQuery:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_CreateQuery>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_DeleteQuery:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_DeleteQuery>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_IsQuery:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_IsQuery>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_BeginQuery:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_BeginQuery>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_EndQuery:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_EndQuery>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_GetQuery:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_GetQuery>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_GetQueryObjectui:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_GetQueryObjectui>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_CreateSampler:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_CreateSampler>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_DeleteSampler:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_DeleteSampler>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_IsSampler:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_IsSampler>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_BindSampler:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_BindSampler>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_SamplerParameteri:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_SamplerParameteri>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_SamplerParameterf:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_SamplerParameterf>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_GetSamplerParameterf:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_GetSamplerParameterf>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_GetSamplerParameteri:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_GetSamplerParameteri>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_FenceSync:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_FenceSync>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_IsSync:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_IsSync>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_DeleteSync:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_DeleteSync>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_ClientWaitSync:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_ClientWaitSync>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_WaitSync:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_WaitSync>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_GetSynci:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_GetSynci>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_CreateTransformFeedback:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_CreateTransformFeedback>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_DeleteTransformFeedback:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_DeleteTransformFeedback>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_IsTransformFeedback:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_IsTransformFeedback>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_BindTransformFeedback:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_BindTransformFeedback>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_BeginTransformFeedback:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_BeginTransformFeedback>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_EndTransformFeedback:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_EndTransformFeedback>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_TransformFeedbackVaryings:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_TransformFeedbackVaryings>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_GetTransformFeedbackVarying:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_GetTransformFeedbackVarying>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_PauseTransformFeedback:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_PauseTransformFeedback>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_ResumeTransformFeedback:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_ResumeTransformFeedback>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_BindBufferBase:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_BindBufferBase>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_BindBufferRange:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_BindBufferRange>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_GetUniformIndices:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_GetUniformIndices>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_GetActiveUniforms:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_GetActiveUniforms>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_GetUniformBlockIndex:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_GetUniformBlockIndex>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_GetActiveUniformBlockName:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_GetActiveUniformBlockName>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_UniformBlockBinding:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_UniformBlockBinding>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_GetActiveUniformBlockiv:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_GetActiveUniformBlockiv>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_GetTranslatedShaderSourceANGLE:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_GetTranslatedShaderSourceANGLE>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_CreateQueryEXT:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_CreateQueryEXT>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_DeleteQueryEXT:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_DeleteQueryEXT>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_IsQueryEXT:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_IsQueryEXT>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_BeginQueryEXT:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_BeginQueryEXT>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_EndQueryEXT:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_EndQueryEXT>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_QueryCounterEXT:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_QueryCounterEXT>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_GetQueryiEXT:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_GetQueryiEXT>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_GetQueryObjectiEXT:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_GetQueryObjectiEXT>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_GetQueryObjectui64EXT:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_GetQueryObjectui64EXT>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_GetInteger64EXT:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_GetInteger64EXT>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_EnableiOES:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_EnableiOES>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_DisableiOES:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_DisableiOES>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_BlendEquationiOES:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_BlendEquationiOES>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_BlendEquationSeparateiOES:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_BlendEquationSeparateiOES>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_BlendFunciOES:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_BlendFunciOES>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_BlendFuncSeparateiOES:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_BlendFuncSeparateiOES>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_ColorMaskiOES:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_ColorMaskiOES>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_DrawArraysInstancedBaseInstanceANGLE:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_DrawArraysInstancedBaseInstanceANGLE>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_DrawElementsInstancedBaseVertexBaseInstanceANGLE:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_DrawElementsInstancedBaseVertexBaseInstanceANGLE>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_ClipControlEXT:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_ClipControlEXT>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_ProvokingVertexANGLE:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_ProvokingVertexANGLE>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_PolygonModeANGLE:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_PolygonModeANGLE>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_PolygonOffsetClampEXT:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_PolygonOffsetClampEXT>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_RenderbufferStorageMultisampleANGLE:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_RenderbufferStorageMultisampleANGLE>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_GetInternalformativ:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_GetInternalformativ>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_SetDrawingBufferColorSpace:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_SetDrawingBufferColorSpace>(globalObject, decoder);
#if ENABLE(WEBXR)
    case MessageName::RemoteGraphicsContextGL_CreateExternalImage:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_CreateExternalImage>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_DeleteExternalImage:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_DeleteExternalImage>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_BindExternalImage:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_BindExternalImage>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_CreateExternalSync:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_CreateExternalSync>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_DeleteExternalSync:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_DeleteExternalSync>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_EnableRequiredWebXRExtensions:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_EnableRequiredWebXRExtensions>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_AddFoveation:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_AddFoveation>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_EnableFoveation:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_EnableFoveation>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_DisableFoveation:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_DisableFoveation>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_FramebufferResolveRenderbuffer:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGL_FramebufferResolveRenderbuffer>(globalObject, decoder);
#endif
#endif
#if ENABLE(GPU_PROCESS)
    case MessageName::RemoteImageBuffer_GetPixelBuffer:
        return jsValueForDecodedMessage<MessageName::RemoteImageBuffer_GetPixelBuffer>(globalObject, decoder);
    case MessageName::RemoteImageBuffer_GetPixelBufferWithNewMemory:
        return jsValueForDecodedMessage<MessageName::RemoteImageBuffer_GetPixelBufferWithNewMemory>(globalObject, decoder);
    case MessageName::RemoteImageBuffer_PutPixelBuffer:
        return jsValueForDecodedMessage<MessageName::RemoteImageBuffer_PutPixelBuffer>(globalObject, decoder);
    case MessageName::RemoteImageBuffer_GetShareableBitmap:
        return jsValueForDecodedMessage<MessageName::RemoteImageBuffer_GetShareableBitmap>(globalObject, decoder);
    case MessageName::RemoteImageBuffer_FilteredNativeImage:
        return jsValueForDecodedMessage<MessageName::RemoteImageBuffer_FilteredNativeImage>(globalObject, decoder);
    case MessageName::RemoteImageBuffer_ConvertToLuminanceMask:
        return jsValueForDecodedMessage<MessageName::RemoteImageBuffer_ConvertToLuminanceMask>(globalObject, decoder);
    case MessageName::RemoteImageBuffer_TransformToColorSpace:
        return jsValueForDecodedMessage<MessageName::RemoteImageBuffer_TransformToColorSpace>(globalObject, decoder);
    case MessageName::RemoteImageBuffer_FlushContext:
        return jsValueForDecodedMessage<MessageName::RemoteImageBuffer_FlushContext>(globalObject, decoder);
    case MessageName::RemoteImageBuffer_FlushContextSync:
        return jsValueForDecodedMessage<MessageName::RemoteImageBuffer_FlushContextSync>(globalObject, decoder);
#if ENABLE(RE_DYNAMIC_CONTENT_SCALING)
    case MessageName::RemoteImageBuffer_DynamicContentScalingDisplayList:
        return jsValueForDecodedMessage<MessageName::RemoteImageBuffer_DynamicContentScalingDisplayList>(globalObject, decoder);
#endif
#endif
#if ENABLE(GPU_PROCESS)
    case MessageName::RemoteImageBufferSet_UpdateConfiguration:
        return jsValueForDecodedMessage<MessageName::RemoteImageBufferSet_UpdateConfiguration>(globalObject, decoder);
    case MessageName::RemoteImageBufferSet_EndPrepareForDisplay:
        return jsValueForDecodedMessage<MessageName::RemoteImageBufferSet_EndPrepareForDisplay>(globalObject, decoder);
#if ENABLE(RE_DYNAMIC_CONTENT_SCALING)
    case MessageName::RemoteImageBufferSet_DynamicContentScalingDisplayList:
        return jsValueForDecodedMessage<MessageName::RemoteImageBufferSet_DynamicContentScalingDisplayList>(globalObject, decoder);
#endif
#endif
#if ENABLE(GPU_PROCESS)
    case MessageName::RemoteRenderingBackend_CreateImageBuffer:
        return jsValueForDecodedMessage<MessageName::RemoteRenderingBackend_CreateImageBuffer>(globalObject, decoder);
    case MessageName::RemoteRenderingBackend_ReleaseImageBuffer:
        return jsValueForDecodedMessage<MessageName::RemoteRenderingBackend_ReleaseImageBuffer>(globalObject, decoder);
    case MessageName::RemoteRenderingBackend_GetImageBufferResourceLimitsForTesting:
        return jsValueForDecodedMessage<MessageName::RemoteRenderingBackend_GetImageBufferResourceLimitsForTesting>(globalObject, decoder);
    case MessageName::RemoteRenderingBackend_DestroyGetPixelBufferSharedMemory:
        return jsValueForDecodedMessage<MessageName::RemoteRenderingBackend_DestroyGetPixelBufferSharedMemory>(globalObject, decoder);
    case MessageName::RemoteRenderingBackend_CacheNativeImage:
        return jsValueForDecodedMessage<MessageName::RemoteRenderingBackend_CacheNativeImage>(globalObject, decoder);
    case MessageName::RemoteRenderingBackend_ReleaseNativeImage:
        return jsValueForDecodedMessage<MessageName::RemoteRenderingBackend_ReleaseNativeImage>(globalObject, decoder);
    case MessageName::RemoteRenderingBackend_CacheFont:
        return jsValueForDecodedMessage<MessageName::RemoteRenderingBackend_CacheFont>(globalObject, decoder);
    case MessageName::RemoteRenderingBackend_ReleaseFont:
        return jsValueForDecodedMessage<MessageName::RemoteRenderingBackend_ReleaseFont>(globalObject, decoder);
    case MessageName::RemoteRenderingBackend_CacheFontCustomPlatformData:
        return jsValueForDecodedMessage<MessageName::RemoteRenderingBackend_CacheFontCustomPlatformData>(globalObject, decoder);
    case MessageName::RemoteRenderingBackend_ReleaseFontCustomPlatformData:
        return jsValueForDecodedMessage<MessageName::RemoteRenderingBackend_ReleaseFontCustomPlatformData>(globalObject, decoder);
    case MessageName::RemoteRenderingBackend_CacheDecomposedGlyphs:
        return jsValueForDecodedMessage<MessageName::RemoteRenderingBackend_CacheDecomposedGlyphs>(globalObject, decoder);
    case MessageName::RemoteRenderingBackend_ReleaseDecomposedGlyphs:
        return jsValueForDecodedMessage<MessageName::RemoteRenderingBackend_ReleaseDecomposedGlyphs>(globalObject, decoder);
    case MessageName::RemoteRenderingBackend_CacheGradient:
        return jsValueForDecodedMessage<MessageName::RemoteRenderingBackend_CacheGradient>(globalObject, decoder);
    case MessageName::RemoteRenderingBackend_ReleaseGradient:
        return jsValueForDecodedMessage<MessageName::RemoteRenderingBackend_ReleaseGradient>(globalObject, decoder);
    case MessageName::RemoteRenderingBackend_CacheFilter:
        return jsValueForDecodedMessage<MessageName::RemoteRenderingBackend_CacheFilter>(globalObject, decoder);
    case MessageName::RemoteRenderingBackend_ReleaseFilter:
        return jsValueForDecodedMessage<MessageName::RemoteRenderingBackend_ReleaseFilter>(globalObject, decoder);
    case MessageName::RemoteRenderingBackend_ReleaseMemory:
        return jsValueForDecodedMessage<MessageName::RemoteRenderingBackend_ReleaseMemory>(globalObject, decoder);
    case MessageName::RemoteRenderingBackend_ReleaseNativeImages:
        return jsValueForDecodedMessage<MessageName::RemoteRenderingBackend_ReleaseNativeImages>(globalObject, decoder);
    case MessageName::RemoteRenderingBackend_CreateImageBufferSet:
        return jsValueForDecodedMessage<MessageName::RemoteRenderingBackend_CreateImageBufferSet>(globalObject, decoder);
    case MessageName::RemoteRenderingBackend_ReleaseImageBufferSet:
        return jsValueForDecodedMessage<MessageName::RemoteRenderingBackend_ReleaseImageBufferSet>(globalObject, decoder);
#if PLATFORM(COCOA)
    case MessageName::RemoteRenderingBackend_PrepareImageBufferSetsForDisplay:
        return jsValueForDecodedMessage<MessageName::RemoteRenderingBackend_PrepareImageBufferSetsForDisplay>(globalObject, decoder);
    case MessageName::RemoteRenderingBackend_PrepareImageBufferSetsForDisplaySync:
        return jsValueForDecodedMessage<MessageName::RemoteRenderingBackend_PrepareImageBufferSetsForDisplaySync>(globalObject, decoder);
#endif
    case MessageName::RemoteRenderingBackend_MarkSurfacesVolatile:
        return jsValueForDecodedMessage<MessageName::RemoteRenderingBackend_MarkSurfacesVolatile>(globalObject, decoder);
    case MessageName::RemoteRenderingBackend_FinalizeRenderingUpdate:
        return jsValueForDecodedMessage<MessageName::RemoteRenderingBackend_FinalizeRenderingUpdate>(globalObject, decoder);
#if USE(GRAPHICS_LAYER_WC)
    case MessageName::RemoteRenderingBackend_Flush:
        return jsValueForDecodedMessage<MessageName::RemoteRenderingBackend_Flush>(globalObject, decoder);
#endif
    case MessageName::RemoteRenderingBackend_MoveToSerializedBuffer:
        return jsValueForDecodedMessage<MessageName::RemoteRenderingBackend_MoveToSerializedBuffer>(globalObject, decoder);
    case MessageName::RemoteRenderingBackend_MoveToImageBuffer:
        return jsValueForDecodedMessage<MessageName::RemoteRenderingBackend_MoveToImageBuffer>(globalObject, decoder);
#if PLATFORM(COCOA)
    case MessageName::RemoteRenderingBackend_DidDrawRemoteToPDF:
        return jsValueForDecodedMessage<MessageName::RemoteRenderingBackend_DidDrawRemoteToPDF>(globalObject, decoder);
#endif
    case MessageName::RemoteRenderingBackend_CreateRemoteBarcodeDetector:
        return jsValueForDecodedMessage<MessageName::RemoteRenderingBackend_CreateRemoteBarcodeDetector>(globalObject, decoder);
    case MessageName::RemoteRenderingBackend_ReleaseRemoteBarcodeDetector:
        return jsValueForDecodedMessage<MessageName::RemoteRenderingBackend_ReleaseRemoteBarcodeDetector>(globalObject, decoder);
    case MessageName::RemoteRenderingBackend_GetRemoteBarcodeDetectorSupportedFormats:
        return jsValueForDecodedMessage<MessageName::RemoteRenderingBackend_GetRemoteBarcodeDetectorSupportedFormats>(globalObject, decoder);
    case MessageName::RemoteRenderingBackend_CreateRemoteFaceDetector:
        return jsValueForDecodedMessage<MessageName::RemoteRenderingBackend_CreateRemoteFaceDetector>(globalObject, decoder);
    case MessageName::RemoteRenderingBackend_ReleaseRemoteFaceDetector:
        return jsValueForDecodedMessage<MessageName::RemoteRenderingBackend_ReleaseRemoteFaceDetector>(globalObject, decoder);
    case MessageName::RemoteRenderingBackend_CreateRemoteTextDetector:
        return jsValueForDecodedMessage<MessageName::RemoteRenderingBackend_CreateRemoteTextDetector>(globalObject, decoder);
    case MessageName::RemoteRenderingBackend_ReleaseRemoteTextDetector:
        return jsValueForDecodedMessage<MessageName::RemoteRenderingBackend_ReleaseRemoteTextDetector>(globalObject, decoder);
#endif
#if ENABLE(GPU_PROCESS)
    case MessageName::RemoteAdapter_Destruct:
        return jsValueForDecodedMessage<MessageName::RemoteAdapter_Destruct>(globalObject, decoder);
    case MessageName::RemoteAdapter_RequestDevice:
        return jsValueForDecodedMessage<MessageName::RemoteAdapter_RequestDevice>(globalObject, decoder);
#endif
#if ENABLE(GPU_PROCESS)
    case MessageName::RemoteBindGroup_Destruct:
        return jsValueForDecodedMessage<MessageName::RemoteBindGroup_Destruct>(globalObject, decoder);
    case MessageName::RemoteBindGroup_SetLabel:
        return jsValueForDecodedMessage<MessageName::RemoteBindGroup_SetLabel>(globalObject, decoder);
    case MessageName::RemoteBindGroup_UpdateExternalTextures:
        return jsValueForDecodedMessage<MessageName::RemoteBindGroup_UpdateExternalTextures>(globalObject, decoder);
#endif
#if ENABLE(GPU_PROCESS)
    case MessageName::RemoteBindGroupLayout_Destruct:
        return jsValueForDecodedMessage<MessageName::RemoteBindGroupLayout_Destruct>(globalObject, decoder);
    case MessageName::RemoteBindGroupLayout_SetLabel:
        return jsValueForDecodedMessage<MessageName::RemoteBindGroupLayout_SetLabel>(globalObject, decoder);
#endif
#if ENABLE(GPU_PROCESS)
    case MessageName::RemoteBuffer_GetMappedRange:
        return jsValueForDecodedMessage<MessageName::RemoteBuffer_GetMappedRange>(globalObject, decoder);
    case MessageName::RemoteBuffer_MapAsync:
        return jsValueForDecodedMessage<MessageName::RemoteBuffer_MapAsync>(globalObject, decoder);
    case MessageName::RemoteBuffer_Copy:
        return jsValueForDecodedMessage<MessageName::RemoteBuffer_Copy>(globalObject, decoder);
    case MessageName::RemoteBuffer_CopyWithCopy:
        return jsValueForDecodedMessage<MessageName::RemoteBuffer_CopyWithCopy>(globalObject, decoder);
    case MessageName::RemoteBuffer_Unmap:
        return jsValueForDecodedMessage<MessageName::RemoteBuffer_Unmap>(globalObject, decoder);
    case MessageName::RemoteBuffer_Destroy:
        return jsValueForDecodedMessage<MessageName::RemoteBuffer_Destroy>(globalObject, decoder);
    case MessageName::RemoteBuffer_Destruct:
        return jsValueForDecodedMessage<MessageName::RemoteBuffer_Destruct>(globalObject, decoder);
    case MessageName::RemoteBuffer_SetLabel:
        return jsValueForDecodedMessage<MessageName::RemoteBuffer_SetLabel>(globalObject, decoder);
#endif
#if ENABLE(GPU_PROCESS)
    case MessageName::RemoteCommandBuffer_Destruct:
        return jsValueForDecodedMessage<MessageName::RemoteCommandBuffer_Destruct>(globalObject, decoder);
    case MessageName::RemoteCommandBuffer_SetLabel:
        return jsValueForDecodedMessage<MessageName::RemoteCommandBuffer_SetLabel>(globalObject, decoder);
#endif
#if ENABLE(GPU_PROCESS)
    case MessageName::RemoteCommandEncoder_BeginRenderPass:
        return jsValueForDecodedMessage<MessageName::RemoteCommandEncoder_BeginRenderPass>(globalObject, decoder);
    case MessageName::RemoteCommandEncoder_BeginComputePass:
        return jsValueForDecodedMessage<MessageName::RemoteCommandEncoder_BeginComputePass>(globalObject, decoder);
    case MessageName::RemoteCommandEncoder_CopyBufferToBuffer:
        return jsValueForDecodedMessage<MessageName::RemoteCommandEncoder_CopyBufferToBuffer>(globalObject, decoder);
    case MessageName::RemoteCommandEncoder_CopyBufferToTexture:
        return jsValueForDecodedMessage<MessageName::RemoteCommandEncoder_CopyBufferToTexture>(globalObject, decoder);
    case MessageName::RemoteCommandEncoder_CopyTextureToBuffer:
        return jsValueForDecodedMessage<MessageName::RemoteCommandEncoder_CopyTextureToBuffer>(globalObject, decoder);
    case MessageName::RemoteCommandEncoder_CopyTextureToTexture:
        return jsValueForDecodedMessage<MessageName::RemoteCommandEncoder_CopyTextureToTexture>(globalObject, decoder);
    case MessageName::RemoteCommandEncoder_ClearBuffer:
        return jsValueForDecodedMessage<MessageName::RemoteCommandEncoder_ClearBuffer>(globalObject, decoder);
    case MessageName::RemoteCommandEncoder_Destruct:
        return jsValueForDecodedMessage<MessageName::RemoteCommandEncoder_Destruct>(globalObject, decoder);
    case MessageName::RemoteCommandEncoder_PushDebugGroup:
        return jsValueForDecodedMessage<MessageName::RemoteCommandEncoder_PushDebugGroup>(globalObject, decoder);
    case MessageName::RemoteCommandEncoder_PopDebugGroup:
        return jsValueForDecodedMessage<MessageName::RemoteCommandEncoder_PopDebugGroup>(globalObject, decoder);
    case MessageName::RemoteCommandEncoder_InsertDebugMarker:
        return jsValueForDecodedMessage<MessageName::RemoteCommandEncoder_InsertDebugMarker>(globalObject, decoder);
    case MessageName::RemoteCommandEncoder_WriteTimestamp:
        return jsValueForDecodedMessage<MessageName::RemoteCommandEncoder_WriteTimestamp>(globalObject, decoder);
    case MessageName::RemoteCommandEncoder_ResolveQuerySet:
        return jsValueForDecodedMessage<MessageName::RemoteCommandEncoder_ResolveQuerySet>(globalObject, decoder);
    case MessageName::RemoteCommandEncoder_Finish:
        return jsValueForDecodedMessage<MessageName::RemoteCommandEncoder_Finish>(globalObject, decoder);
    case MessageName::RemoteCommandEncoder_SetLabel:
        return jsValueForDecodedMessage<MessageName::RemoteCommandEncoder_SetLabel>(globalObject, decoder);
#endif
#if ENABLE(GPU_PROCESS)
#if PLATFORM(COCOA)
    case MessageName::RemoteCompositorIntegration_RecreateRenderBuffers:
        return jsValueForDecodedMessage<MessageName::RemoteCompositorIntegration_RecreateRenderBuffers>(globalObject, decoder);
#endif
    case MessageName::RemoteCompositorIntegration_PrepareForDisplay:
        return jsValueForDecodedMessage<MessageName::RemoteCompositorIntegration_PrepareForDisplay>(globalObject, decoder);
    case MessageName::RemoteCompositorIntegration_PaintCompositedResultsToCanvas:
        return jsValueForDecodedMessage<MessageName::RemoteCompositorIntegration_PaintCompositedResultsToCanvas>(globalObject, decoder);
    case MessageName::RemoteCompositorIntegration_Destruct:
        return jsValueForDecodedMessage<MessageName::RemoteCompositorIntegration_Destruct>(globalObject, decoder);
    case MessageName::RemoteCompositorIntegration_UpdateContentsHeadroom:
        return jsValueForDecodedMessage<MessageName::RemoteCompositorIntegration_UpdateContentsHeadroom>(globalObject, decoder);
#endif
#if ENABLE(GPU_PROCESS)
    case MessageName::RemoteComputePassEncoder_Destruct:
        return jsValueForDecodedMessage<MessageName::RemoteComputePassEncoder_Destruct>(globalObject, decoder);
    case MessageName::RemoteComputePassEncoder_SetPipeline:
        return jsValueForDecodedMessage<MessageName::RemoteComputePassEncoder_SetPipeline>(globalObject, decoder);
    case MessageName::RemoteComputePassEncoder_Dispatch:
        return jsValueForDecodedMessage<MessageName::RemoteComputePassEncoder_Dispatch>(globalObject, decoder);
    case MessageName::RemoteComputePassEncoder_DispatchIndirect:
        return jsValueForDecodedMessage<MessageName::RemoteComputePassEncoder_DispatchIndirect>(globalObject, decoder);
    case MessageName::RemoteComputePassEncoder_End:
        return jsValueForDecodedMessage<MessageName::RemoteComputePassEncoder_End>(globalObject, decoder);
    case MessageName::RemoteComputePassEncoder_SetBindGroup:
        return jsValueForDecodedMessage<MessageName::RemoteComputePassEncoder_SetBindGroup>(globalObject, decoder);
    case MessageName::RemoteComputePassEncoder_PushDebugGroup:
        return jsValueForDecodedMessage<MessageName::RemoteComputePassEncoder_PushDebugGroup>(globalObject, decoder);
    case MessageName::RemoteComputePassEncoder_PopDebugGroup:
        return jsValueForDecodedMessage<MessageName::RemoteComputePassEncoder_PopDebugGroup>(globalObject, decoder);
    case MessageName::RemoteComputePassEncoder_InsertDebugMarker:
        return jsValueForDecodedMessage<MessageName::RemoteComputePassEncoder_InsertDebugMarker>(globalObject, decoder);
    case MessageName::RemoteComputePassEncoder_SetLabel:
        return jsValueForDecodedMessage<MessageName::RemoteComputePassEncoder_SetLabel>(globalObject, decoder);
#endif
#if ENABLE(GPU_PROCESS)
    case MessageName::RemoteComputePipeline_Destruct:
        return jsValueForDecodedMessage<MessageName::RemoteComputePipeline_Destruct>(globalObject, decoder);
    case MessageName::RemoteComputePipeline_GetBindGroupLayout:
        return jsValueForDecodedMessage<MessageName::RemoteComputePipeline_GetBindGroupLayout>(globalObject, decoder);
    case MessageName::RemoteComputePipeline_SetLabel:
        return jsValueForDecodedMessage<MessageName::RemoteComputePipeline_SetLabel>(globalObject, decoder);
#endif
#if ENABLE(GPU_PROCESS)
    case MessageName::RemoteDevice_Destroy:
        return jsValueForDecodedMessage<MessageName::RemoteDevice_Destroy>(globalObject, decoder);
    case MessageName::RemoteDevice_Destruct:
        return jsValueForDecodedMessage<MessageName::RemoteDevice_Destruct>(globalObject, decoder);
    case MessageName::RemoteDevice_CreateXRBinding:
        return jsValueForDecodedMessage<MessageName::RemoteDevice_CreateXRBinding>(globalObject, decoder);
    case MessageName::RemoteDevice_CreateBuffer:
        return jsValueForDecodedMessage<MessageName::RemoteDevice_CreateBuffer>(globalObject, decoder);
    case MessageName::RemoteDevice_CreateTexture:
        return jsValueForDecodedMessage<MessageName::RemoteDevice_CreateTexture>(globalObject, decoder);
    case MessageName::RemoteDevice_CreateSampler:
        return jsValueForDecodedMessage<MessageName::RemoteDevice_CreateSampler>(globalObject, decoder);
    case MessageName::RemoteDevice_CreateBindGroupLayout:
        return jsValueForDecodedMessage<MessageName::RemoteDevice_CreateBindGroupLayout>(globalObject, decoder);
    case MessageName::RemoteDevice_CreatePipelineLayout:
        return jsValueForDecodedMessage<MessageName::RemoteDevice_CreatePipelineLayout>(globalObject, decoder);
    case MessageName::RemoteDevice_CreateBindGroup:
        return jsValueForDecodedMessage<MessageName::RemoteDevice_CreateBindGroup>(globalObject, decoder);
    case MessageName::RemoteDevice_CreateShaderModule:
        return jsValueForDecodedMessage<MessageName::RemoteDevice_CreateShaderModule>(globalObject, decoder);
    case MessageName::RemoteDevice_CreateComputePipeline:
        return jsValueForDecodedMessage<MessageName::RemoteDevice_CreateComputePipeline>(globalObject, decoder);
    case MessageName::RemoteDevice_CreateRenderPipeline:
        return jsValueForDecodedMessage<MessageName::RemoteDevice_CreateRenderPipeline>(globalObject, decoder);
    case MessageName::RemoteDevice_CreateComputePipelineAsync:
        return jsValueForDecodedMessage<MessageName::RemoteDevice_CreateComputePipelineAsync>(globalObject, decoder);
    case MessageName::RemoteDevice_CreateRenderPipelineAsync:
        return jsValueForDecodedMessage<MessageName::RemoteDevice_CreateRenderPipelineAsync>(globalObject, decoder);
    case MessageName::RemoteDevice_CreateCommandEncoder:
        return jsValueForDecodedMessage<MessageName::RemoteDevice_CreateCommandEncoder>(globalObject, decoder);
    case MessageName::RemoteDevice_CreateRenderBundleEncoder:
        return jsValueForDecodedMessage<MessageName::RemoteDevice_CreateRenderBundleEncoder>(globalObject, decoder);
    case MessageName::RemoteDevice_CreateQuerySet:
        return jsValueForDecodedMessage<MessageName::RemoteDevice_CreateQuerySet>(globalObject, decoder);
    case MessageName::RemoteDevice_PushErrorScope:
        return jsValueForDecodedMessage<MessageName::RemoteDevice_PushErrorScope>(globalObject, decoder);
    case MessageName::RemoteDevice_PopErrorScope:
        return jsValueForDecodedMessage<MessageName::RemoteDevice_PopErrorScope>(globalObject, decoder);
    case MessageName::RemoteDevice_ResolveUncapturedErrorEvent:
        return jsValueForDecodedMessage<MessageName::RemoteDevice_ResolveUncapturedErrorEvent>(globalObject, decoder);
    case MessageName::RemoteDevice_ResolveDeviceLostPromise:
        return jsValueForDecodedMessage<MessageName::RemoteDevice_ResolveDeviceLostPromise>(globalObject, decoder);
    case MessageName::RemoteDevice_SetLabel:
        return jsValueForDecodedMessage<MessageName::RemoteDevice_SetLabel>(globalObject, decoder);
    case MessageName::RemoteDevice_PauseAllErrorReporting:
        return jsValueForDecodedMessage<MessageName::RemoteDevice_PauseAllErrorReporting>(globalObject, decoder);
#if PLATFORM(COCOA) && ENABLE(VIDEO)
    case MessageName::RemoteDevice_SetSharedVideoFrameSemaphore:
        return jsValueForDecodedMessage<MessageName::RemoteDevice_SetSharedVideoFrameSemaphore>(globalObject, decoder);
    case MessageName::RemoteDevice_SetSharedVideoFrameMemory:
        return jsValueForDecodedMessage<MessageName::RemoteDevice_SetSharedVideoFrameMemory>(globalObject, decoder);
    case MessageName::RemoteDevice_ImportExternalTextureFromVideoFrame:
        return jsValueForDecodedMessage<MessageName::RemoteDevice_ImportExternalTextureFromVideoFrame>(globalObject, decoder);
    case MessageName::RemoteDevice_UpdateExternalTexture:
        return jsValueForDecodedMessage<MessageName::RemoteDevice_UpdateExternalTexture>(globalObject, decoder);
#endif
#endif
#if ENABLE(GPU_PROCESS)
    case MessageName::RemoteExternalTexture_Destruct:
        return jsValueForDecodedMessage<MessageName::RemoteExternalTexture_Destruct>(globalObject, decoder);
    case MessageName::RemoteExternalTexture_SetLabel:
        return jsValueForDecodedMessage<MessageName::RemoteExternalTexture_SetLabel>(globalObject, decoder);
    case MessageName::RemoteExternalTexture_Destroy:
        return jsValueForDecodedMessage<MessageName::RemoteExternalTexture_Destroy>(globalObject, decoder);
    case MessageName::RemoteExternalTexture_Undestroy:
        return jsValueForDecodedMessage<MessageName::RemoteExternalTexture_Undestroy>(globalObject, decoder);
#endif
#if ENABLE(GPU_PROCESS)
    case MessageName::RemoteGPU_RequestAdapter:
        return jsValueForDecodedMessage<MessageName::RemoteGPU_RequestAdapter>(globalObject, decoder);
    case MessageName::RemoteGPU_CreatePresentationContext:
        return jsValueForDecodedMessage<MessageName::RemoteGPU_CreatePresentationContext>(globalObject, decoder);
    case MessageName::RemoteGPU_CreateCompositorIntegration:
        return jsValueForDecodedMessage<MessageName::RemoteGPU_CreateCompositorIntegration>(globalObject, decoder);
    case MessageName::RemoteGPU_IsValid:
        return jsValueForDecodedMessage<MessageName::RemoteGPU_IsValid>(globalObject, decoder);
#endif
#if ENABLE(GPU_PROCESS)
    case MessageName::RemotePipelineLayout_Destruct:
        return jsValueForDecodedMessage<MessageName::RemotePipelineLayout_Destruct>(globalObject, decoder);
    case MessageName::RemotePipelineLayout_SetLabel:
        return jsValueForDecodedMessage<MessageName::RemotePipelineLayout_SetLabel>(globalObject, decoder);
#endif
#if ENABLE(GPU_PROCESS)
    case MessageName::RemotePresentationContext_Configure:
        return jsValueForDecodedMessage<MessageName::RemotePresentationContext_Configure>(globalObject, decoder);
    case MessageName::RemotePresentationContext_Unconfigure:
        return jsValueForDecodedMessage<MessageName::RemotePresentationContext_Unconfigure>(globalObject, decoder);
    case MessageName::RemotePresentationContext_GetCurrentTexture:
        return jsValueForDecodedMessage<MessageName::RemotePresentationContext_GetCurrentTexture>(globalObject, decoder);
    case MessageName::RemotePresentationContext_Present:
        return jsValueForDecodedMessage<MessageName::RemotePresentationContext_Present>(globalObject, decoder);
#endif
#if ENABLE(GPU_PROCESS)
    case MessageName::RemoteQuerySet_Destroy:
        return jsValueForDecodedMessage<MessageName::RemoteQuerySet_Destroy>(globalObject, decoder);
    case MessageName::RemoteQuerySet_Destruct:
        return jsValueForDecodedMessage<MessageName::RemoteQuerySet_Destruct>(globalObject, decoder);
    case MessageName::RemoteQuerySet_SetLabel:
        return jsValueForDecodedMessage<MessageName::RemoteQuerySet_SetLabel>(globalObject, decoder);
#endif
#if ENABLE(GPU_PROCESS)
    case MessageName::RemoteQueue_Destruct:
        return jsValueForDecodedMessage<MessageName::RemoteQueue_Destruct>(globalObject, decoder);
    case MessageName::RemoteQueue_Submit:
        return jsValueForDecodedMessage<MessageName::RemoteQueue_Submit>(globalObject, decoder);
    case MessageName::RemoteQueue_OnSubmittedWorkDone:
        return jsValueForDecodedMessage<MessageName::RemoteQueue_OnSubmittedWorkDone>(globalObject, decoder);
    case MessageName::RemoteQueue_WriteBufferWithCopy:
        return jsValueForDecodedMessage<MessageName::RemoteQueue_WriteBufferWithCopy>(globalObject, decoder);
    case MessageName::RemoteQueue_WriteBuffer:
        return jsValueForDecodedMessage<MessageName::RemoteQueue_WriteBuffer>(globalObject, decoder);
    case MessageName::RemoteQueue_WriteTexture:
        return jsValueForDecodedMessage<MessageName::RemoteQueue_WriteTexture>(globalObject, decoder);
    case MessageName::RemoteQueue_WriteTextureWithCopy:
        return jsValueForDecodedMessage<MessageName::RemoteQueue_WriteTextureWithCopy>(globalObject, decoder);
    case MessageName::RemoteQueue_CopyExternalImageToTexture:
        return jsValueForDecodedMessage<MessageName::RemoteQueue_CopyExternalImageToTexture>(globalObject, decoder);
    case MessageName::RemoteQueue_SetLabel:
        return jsValueForDecodedMessage<MessageName::RemoteQueue_SetLabel>(globalObject, decoder);
#endif
#if ENABLE(GPU_PROCESS)
    case MessageName::RemoteRenderBundle_Destruct:
        return jsValueForDecodedMessage<MessageName::RemoteRenderBundle_Destruct>(globalObject, decoder);
    case MessageName::RemoteRenderBundle_SetLabel:
        return jsValueForDecodedMessage<MessageName::RemoteRenderBundle_SetLabel>(globalObject, decoder);
#endif
#if ENABLE(GPU_PROCESS)
    case MessageName::RemoteRenderBundleEncoder_Destruct:
        return jsValueForDecodedMessage<MessageName::RemoteRenderBundleEncoder_Destruct>(globalObject, decoder);
    case MessageName::RemoteRenderBundleEncoder_SetPipeline:
        return jsValueForDecodedMessage<MessageName::RemoteRenderBundleEncoder_SetPipeline>(globalObject, decoder);
    case MessageName::RemoteRenderBundleEncoder_SetIndexBuffer:
        return jsValueForDecodedMessage<MessageName::RemoteRenderBundleEncoder_SetIndexBuffer>(globalObject, decoder);
    case MessageName::RemoteRenderBundleEncoder_SetVertexBuffer:
        return jsValueForDecodedMessage<MessageName::RemoteRenderBundleEncoder_SetVertexBuffer>(globalObject, decoder);
    case MessageName::RemoteRenderBundleEncoder_UnsetVertexBuffer:
        return jsValueForDecodedMessage<MessageName::RemoteRenderBundleEncoder_UnsetVertexBuffer>(globalObject, decoder);
    case MessageName::RemoteRenderBundleEncoder_Draw:
        return jsValueForDecodedMessage<MessageName::RemoteRenderBundleEncoder_Draw>(globalObject, decoder);
    case MessageName::RemoteRenderBundleEncoder_DrawIndexed:
        return jsValueForDecodedMessage<MessageName::RemoteRenderBundleEncoder_DrawIndexed>(globalObject, decoder);
    case MessageName::RemoteRenderBundleEncoder_DrawIndirect:
        return jsValueForDecodedMessage<MessageName::RemoteRenderBundleEncoder_DrawIndirect>(globalObject, decoder);
    case MessageName::RemoteRenderBundleEncoder_DrawIndexedIndirect:
        return jsValueForDecodedMessage<MessageName::RemoteRenderBundleEncoder_DrawIndexedIndirect>(globalObject, decoder);
    case MessageName::RemoteRenderBundleEncoder_SetBindGroup:
        return jsValueForDecodedMessage<MessageName::RemoteRenderBundleEncoder_SetBindGroup>(globalObject, decoder);
    case MessageName::RemoteRenderBundleEncoder_PushDebugGroup:
        return jsValueForDecodedMessage<MessageName::RemoteRenderBundleEncoder_PushDebugGroup>(globalObject, decoder);
    case MessageName::RemoteRenderBundleEncoder_PopDebugGroup:
        return jsValueForDecodedMessage<MessageName::RemoteRenderBundleEncoder_PopDebugGroup>(globalObject, decoder);
    case MessageName::RemoteRenderBundleEncoder_InsertDebugMarker:
        return jsValueForDecodedMessage<MessageName::RemoteRenderBundleEncoder_InsertDebugMarker>(globalObject, decoder);
    case MessageName::RemoteRenderBundleEncoder_Finish:
        return jsValueForDecodedMessage<MessageName::RemoteRenderBundleEncoder_Finish>(globalObject, decoder);
    case MessageName::RemoteRenderBundleEncoder_SetLabel:
        return jsValueForDecodedMessage<MessageName::RemoteRenderBundleEncoder_SetLabel>(globalObject, decoder);
#endif
#if ENABLE(GPU_PROCESS)
    case MessageName::RemoteRenderPassEncoder_Destruct:
        return jsValueForDecodedMessage<MessageName::RemoteRenderPassEncoder_Destruct>(globalObject, decoder);
    case MessageName::RemoteRenderPassEncoder_SetPipeline:
        return jsValueForDecodedMessage<MessageName::RemoteRenderPassEncoder_SetPipeline>(globalObject, decoder);
    case MessageName::RemoteRenderPassEncoder_SetIndexBuffer:
        return jsValueForDecodedMessage<MessageName::RemoteRenderPassEncoder_SetIndexBuffer>(globalObject, decoder);
    case MessageName::RemoteRenderPassEncoder_SetVertexBuffer:
        return jsValueForDecodedMessage<MessageName::RemoteRenderPassEncoder_SetVertexBuffer>(globalObject, decoder);
    case MessageName::RemoteRenderPassEncoder_UnsetVertexBuffer:
        return jsValueForDecodedMessage<MessageName::RemoteRenderPassEncoder_UnsetVertexBuffer>(globalObject, decoder);
    case MessageName::RemoteRenderPassEncoder_Draw:
        return jsValueForDecodedMessage<MessageName::RemoteRenderPassEncoder_Draw>(globalObject, decoder);
    case MessageName::RemoteRenderPassEncoder_DrawIndexed:
        return jsValueForDecodedMessage<MessageName::RemoteRenderPassEncoder_DrawIndexed>(globalObject, decoder);
    case MessageName::RemoteRenderPassEncoder_DrawIndirect:
        return jsValueForDecodedMessage<MessageName::RemoteRenderPassEncoder_DrawIndirect>(globalObject, decoder);
    case MessageName::RemoteRenderPassEncoder_DrawIndexedIndirect:
        return jsValueForDecodedMessage<MessageName::RemoteRenderPassEncoder_DrawIndexedIndirect>(globalObject, decoder);
    case MessageName::RemoteRenderPassEncoder_SetBindGroup:
        return jsValueForDecodedMessage<MessageName::RemoteRenderPassEncoder_SetBindGroup>(globalObject, decoder);
    case MessageName::RemoteRenderPassEncoder_PushDebugGroup:
        return jsValueForDecodedMessage<MessageName::RemoteRenderPassEncoder_PushDebugGroup>(globalObject, decoder);
    case MessageName::RemoteRenderPassEncoder_PopDebugGroup:
        return jsValueForDecodedMessage<MessageName::RemoteRenderPassEncoder_PopDebugGroup>(globalObject, decoder);
    case MessageName::RemoteRenderPassEncoder_InsertDebugMarker:
        return jsValueForDecodedMessage<MessageName::RemoteRenderPassEncoder_InsertDebugMarker>(globalObject, decoder);
    case MessageName::RemoteRenderPassEncoder_SetViewport:
        return jsValueForDecodedMessage<MessageName::RemoteRenderPassEncoder_SetViewport>(globalObject, decoder);
    case MessageName::RemoteRenderPassEncoder_SetScissorRect:
        return jsValueForDecodedMessage<MessageName::RemoteRenderPassEncoder_SetScissorRect>(globalObject, decoder);
    case MessageName::RemoteRenderPassEncoder_SetBlendConstant:
        return jsValueForDecodedMessage<MessageName::RemoteRenderPassEncoder_SetBlendConstant>(globalObject, decoder);
    case MessageName::RemoteRenderPassEncoder_SetStencilReference:
        return jsValueForDecodedMessage<MessageName::RemoteRenderPassEncoder_SetStencilReference>(globalObject, decoder);
    case MessageName::RemoteRenderPassEncoder_BeginOcclusionQuery:
        return jsValueForDecodedMessage<MessageName::RemoteRenderPassEncoder_BeginOcclusionQuery>(globalObject, decoder);
    case MessageName::RemoteRenderPassEncoder_EndOcclusionQuery:
        return jsValueForDecodedMessage<MessageName::RemoteRenderPassEncoder_EndOcclusionQuery>(globalObject, decoder);
    case MessageName::RemoteRenderPassEncoder_ExecuteBundles:
        return jsValueForDecodedMessage<MessageName::RemoteRenderPassEncoder_ExecuteBundles>(globalObject, decoder);
    case MessageName::RemoteRenderPassEncoder_End:
        return jsValueForDecodedMessage<MessageName::RemoteRenderPassEncoder_End>(globalObject, decoder);
    case MessageName::RemoteRenderPassEncoder_SetLabel:
        return jsValueForDecodedMessage<MessageName::RemoteRenderPassEncoder_SetLabel>(globalObject, decoder);
#endif
#if ENABLE(GPU_PROCESS)
    case MessageName::RemoteRenderPipeline_Destruct:
        return jsValueForDecodedMessage<MessageName::RemoteRenderPipeline_Destruct>(globalObject, decoder);
    case MessageName::RemoteRenderPipeline_GetBindGroupLayout:
        return jsValueForDecodedMessage<MessageName::RemoteRenderPipeline_GetBindGroupLayout>(globalObject, decoder);
    case MessageName::RemoteRenderPipeline_SetLabel:
        return jsValueForDecodedMessage<MessageName::RemoteRenderPipeline_SetLabel>(globalObject, decoder);
#endif
#if ENABLE(GPU_PROCESS)
    case MessageName::RemoteSampler_Destruct:
        return jsValueForDecodedMessage<MessageName::RemoteSampler_Destruct>(globalObject, decoder);
    case MessageName::RemoteSampler_SetLabel:
        return jsValueForDecodedMessage<MessageName::RemoteSampler_SetLabel>(globalObject, decoder);
#endif
#if ENABLE(GPU_PROCESS)
    case MessageName::RemoteShaderModule_CompilationInfo:
        return jsValueForDecodedMessage<MessageName::RemoteShaderModule_CompilationInfo>(globalObject, decoder);
    case MessageName::RemoteShaderModule_SetLabel:
        return jsValueForDecodedMessage<MessageName::RemoteShaderModule_SetLabel>(globalObject, decoder);
    case MessageName::RemoteShaderModule_Destruct:
        return jsValueForDecodedMessage<MessageName::RemoteShaderModule_Destruct>(globalObject, decoder);
#endif
#if ENABLE(GPU_PROCESS)
    case MessageName::RemoteTexture_CreateView:
        return jsValueForDecodedMessage<MessageName::RemoteTexture_CreateView>(globalObject, decoder);
    case MessageName::RemoteTexture_Destroy:
        return jsValueForDecodedMessage<MessageName::RemoteTexture_Destroy>(globalObject, decoder);
    case MessageName::RemoteTexture_Undestroy:
        return jsValueForDecodedMessage<MessageName::RemoteTexture_Undestroy>(globalObject, decoder);
    case MessageName::RemoteTexture_Destruct:
        return jsValueForDecodedMessage<MessageName::RemoteTexture_Destruct>(globalObject, decoder);
    case MessageName::RemoteTexture_SetLabel:
        return jsValueForDecodedMessage<MessageName::RemoteTexture_SetLabel>(globalObject, decoder);
#endif
#if ENABLE(GPU_PROCESS)
    case MessageName::RemoteTextureView_Destruct:
        return jsValueForDecodedMessage<MessageName::RemoteTextureView_Destruct>(globalObject, decoder);
    case MessageName::RemoteTextureView_SetLabel:
        return jsValueForDecodedMessage<MessageName::RemoteTextureView_SetLabel>(globalObject, decoder);
#endif
#if ENABLE(GPU_PROCESS)
    case MessageName::RemoteXRBinding_Destruct:
        return jsValueForDecodedMessage<MessageName::RemoteXRBinding_Destruct>(globalObject, decoder);
    case MessageName::RemoteXRBinding_CreateProjectionLayer:
        return jsValueForDecodedMessage<MessageName::RemoteXRBinding_CreateProjectionLayer>(globalObject, decoder);
    case MessageName::RemoteXRBinding_GetViewSubImage:
        return jsValueForDecodedMessage<MessageName::RemoteXRBinding_GetViewSubImage>(globalObject, decoder);
#endif
#if ENABLE(GPU_PROCESS)
#if PLATFORM(COCOA)
    case MessageName::RemoteXRProjectionLayer_StartFrame:
        return jsValueForDecodedMessage<MessageName::RemoteXRProjectionLayer_StartFrame>(globalObject, decoder);
#endif
    case MessageName::RemoteXRProjectionLayer_EndFrame:
        return jsValueForDecodedMessage<MessageName::RemoteXRProjectionLayer_EndFrame>(globalObject, decoder);
    case MessageName::RemoteXRProjectionLayer_Destruct:
        return jsValueForDecodedMessage<MessageName::RemoteXRProjectionLayer_Destruct>(globalObject, decoder);
#endif
#if ENABLE(GPU_PROCESS)
    case MessageName::RemoteXRSubImage_Destruct:
        return jsValueForDecodedMessage<MessageName::RemoteXRSubImage_Destruct>(globalObject, decoder);
    case MessageName::RemoteXRSubImage_GetColorTexture:
        return jsValueForDecodedMessage<MessageName::RemoteXRSubImage_GetColorTexture>(globalObject, decoder);
    case MessageName::RemoteXRSubImage_GetDepthTexture:
        return jsValueForDecodedMessage<MessageName::RemoteXRSubImage_GetDepthTexture>(globalObject, decoder);
#endif
#if ENABLE(GPU_PROCESS)
    case MessageName::RemoteXRView_Destruct:
        return jsValueForDecodedMessage<MessageName::RemoteXRView_Destruct>(globalObject, decoder);
#endif
#if ENABLE(GPU_PROCESS) && ENABLE(WEB_AUDIO)
    case MessageName::RemoteAudioDestinationManager_CreateAudioDestination:
        return jsValueForDecodedMessage<MessageName::RemoteAudioDestinationManager_CreateAudioDestination>(globalObject, decoder);
    case MessageName::RemoteAudioDestinationManager_DeleteAudioDestination:
        return jsValueForDecodedMessage<MessageName::RemoteAudioDestinationManager_DeleteAudioDestination>(globalObject, decoder);
    case MessageName::RemoteAudioDestinationManager_StartAudioDestination:
        return jsValueForDecodedMessage<MessageName::RemoteAudioDestinationManager_StartAudioDestination>(globalObject, decoder);
    case MessageName::RemoteAudioDestinationManager_StopAudioDestination:
        return jsValueForDecodedMessage<MessageName::RemoteAudioDestinationManager_StopAudioDestination>(globalObject, decoder);
#if PLATFORM(COCOA)
    case MessageName::RemoteAudioDestinationManager_AudioSamplesStorageChanged:
        return jsValueForDecodedMessage<MessageName::RemoteAudioDestinationManager_AudioSamplesStorageChanged>(globalObject, decoder);
#endif
#if PLATFORM(IOS_FAMILY)
    case MessageName::RemoteAudioDestinationManager_SetSceneIdentifier:
        return jsValueForDecodedMessage<MessageName::RemoteAudioDestinationManager_SetSceneIdentifier>(globalObject, decoder);
#endif
#endif
#if ENABLE(GPU_PROCESS) && USE(AUDIO_SESSION)
    case MessageName::RemoteAudioSessionProxy_SetCategory:
        return jsValueForDecodedMessage<MessageName::RemoteAudioSessionProxy_SetCategory>(globalObject, decoder);
    case MessageName::RemoteAudioSessionProxy_SetPreferredBufferSize:
        return jsValueForDecodedMessage<MessageName::RemoteAudioSessionProxy_SetPreferredBufferSize>(globalObject, decoder);
    case MessageName::RemoteAudioSessionProxy_TryToSetActive:
        return jsValueForDecodedMessage<MessageName::RemoteAudioSessionProxy_TryToSetActive>(globalObject, decoder);
    case MessageName::RemoteAudioSessionProxy_SetIsPlayingToBluetoothOverride:
        return jsValueForDecodedMessage<MessageName::RemoteAudioSessionProxy_SetIsPlayingToBluetoothOverride>(globalObject, decoder);
    case MessageName::RemoteAudioSessionProxy_TriggerBeginInterruptionForTesting:
        return jsValueForDecodedMessage<MessageName::RemoteAudioSessionProxy_TriggerBeginInterruptionForTesting>(globalObject, decoder);
    case MessageName::RemoteAudioSessionProxy_TriggerEndInterruptionForTesting:
        return jsValueForDecodedMessage<MessageName::RemoteAudioSessionProxy_TriggerEndInterruptionForTesting>(globalObject, decoder);
    case MessageName::RemoteAudioSessionProxy_BeginInterruptionRemote:
        return jsValueForDecodedMessage<MessageName::RemoteAudioSessionProxy_BeginInterruptionRemote>(globalObject, decoder);
    case MessageName::RemoteAudioSessionProxy_EndInterruptionRemote:
        return jsValueForDecodedMessage<MessageName::RemoteAudioSessionProxy_EndInterruptionRemote>(globalObject, decoder);
    case MessageName::RemoteAudioSessionProxy_SetSceneIdentifier:
        return jsValueForDecodedMessage<MessageName::RemoteAudioSessionProxy_SetSceneIdentifier>(globalObject, decoder);
    case MessageName::RemoteAudioSessionProxy_SetSoundStageSize:
        return jsValueForDecodedMessage<MessageName::RemoteAudioSessionProxy_SetSoundStageSize>(globalObject, decoder);
#endif
#if ENABLE(GPU_PROCESS) && ENABLE(ENCRYPTED_MEDIA)
    case MessageName::RemoteCDMFactoryProxy_CreateCDM:
        return jsValueForDecodedMessage<MessageName::RemoteCDMFactoryProxy_CreateCDM>(globalObject, decoder);
    case MessageName::RemoteCDMFactoryProxy_SupportsKeySystem:
        return jsValueForDecodedMessage<MessageName::RemoteCDMFactoryProxy_SupportsKeySystem>(globalObject, decoder);
    case MessageName::RemoteCDMFactoryProxy_RemoveInstance:
        return jsValueForDecodedMessage<MessageName::RemoteCDMFactoryProxy_RemoveInstance>(globalObject, decoder);
    case MessageName::RemoteCDMFactoryProxy_RemoveSession:
        return jsValueForDecodedMessage<MessageName::RemoteCDMFactoryProxy_RemoveSession>(globalObject, decoder);
#endif
#if ENABLE(GPU_PROCESS) && ENABLE(ENCRYPTED_MEDIA)
    case MessageName::RemoteCDMInstanceProxy_CreateSession:
        return jsValueForDecodedMessage<MessageName::RemoteCDMInstanceProxy_CreateSession>(globalObject, decoder);
    case MessageName::RemoteCDMInstanceProxy_InitializeWithConfiguration:
        return jsValueForDecodedMessage<MessageName::RemoteCDMInstanceProxy_InitializeWithConfiguration>(globalObject, decoder);
    case MessageName::RemoteCDMInstanceProxy_SetServerCertificate:
        return jsValueForDecodedMessage<MessageName::RemoteCDMInstanceProxy_SetServerCertificate>(globalObject, decoder);
    case MessageName::RemoteCDMInstanceProxy_SetStorageDirectory:
        return jsValueForDecodedMessage<MessageName::RemoteCDMInstanceProxy_SetStorageDirectory>(globalObject, decoder);
#endif
#if ENABLE(GPU_PROCESS) && ENABLE(ENCRYPTED_MEDIA)
    case MessageName::RemoteCDMInstanceSessionProxy_SetLogIdentifier:
        return jsValueForDecodedMessage<MessageName::RemoteCDMInstanceSessionProxy_SetLogIdentifier>(globalObject, decoder);
    case MessageName::RemoteCDMInstanceSessionProxy_RequestLicense:
        return jsValueForDecodedMessage<MessageName::RemoteCDMInstanceSessionProxy_RequestLicense>(globalObject, decoder);
    case MessageName::RemoteCDMInstanceSessionProxy_UpdateLicense:
        return jsValueForDecodedMessage<MessageName::RemoteCDMInstanceSessionProxy_UpdateLicense>(globalObject, decoder);
    case MessageName::RemoteCDMInstanceSessionProxy_LoadSession:
        return jsValueForDecodedMessage<MessageName::RemoteCDMInstanceSessionProxy_LoadSession>(globalObject, decoder);
    case MessageName::RemoteCDMInstanceSessionProxy_CloseSession:
        return jsValueForDecodedMessage<MessageName::RemoteCDMInstanceSessionProxy_CloseSession>(globalObject, decoder);
    case MessageName::RemoteCDMInstanceSessionProxy_RemoveSessionData:
        return jsValueForDecodedMessage<MessageName::RemoteCDMInstanceSessionProxy_RemoveSessionData>(globalObject, decoder);
    case MessageName::RemoteCDMInstanceSessionProxy_StoreRecordOfKeyUsage:
        return jsValueForDecodedMessage<MessageName::RemoteCDMInstanceSessionProxy_StoreRecordOfKeyUsage>(globalObject, decoder);
#endif
#if ENABLE(GPU_PROCESS) && ENABLE(ENCRYPTED_MEDIA)
    case MessageName::RemoteCDMProxy_GetSupportedConfiguration:
        return jsValueForDecodedMessage<MessageName::RemoteCDMProxy_GetSupportedConfiguration>(globalObject, decoder);
    case MessageName::RemoteCDMProxy_CreateInstance:
        return jsValueForDecodedMessage<MessageName::RemoteCDMProxy_CreateInstance>(globalObject, decoder);
    case MessageName::RemoteCDMProxy_LoadAndInitialize:
        return jsValueForDecodedMessage<MessageName::RemoteCDMProxy_LoadAndInitialize>(globalObject, decoder);
    case MessageName::RemoteCDMProxy_SetLogIdentifier:
        return jsValueForDecodedMessage<MessageName::RemoteCDMProxy_SetLogIdentifier>(globalObject, decoder);
#endif
#if ENABLE(GPU_PROCESS) && ENABLE(LEGACY_ENCRYPTED_MEDIA)
    case MessageName::RemoteLegacyCDMFactoryProxy_CreateCDM:
        return jsValueForDecodedMessage<MessageName::RemoteLegacyCDMFactoryProxy_CreateCDM>(globalObject, decoder);
    case MessageName::RemoteLegacyCDMFactoryProxy_SupportsKeySystem:
        return jsValueForDecodedMessage<MessageName::RemoteLegacyCDMFactoryProxy_SupportsKeySystem>(globalObject, decoder);
    case MessageName::RemoteLegacyCDMFactoryProxy_RemoveSession:
        return jsValueForDecodedMessage<MessageName::RemoteLegacyCDMFactoryProxy_RemoveSession>(globalObject, decoder);
#endif
#if ENABLE(GPU_PROCESS) && ENABLE(LEGACY_ENCRYPTED_MEDIA)
    case MessageName::RemoteLegacyCDMProxy_SupportsMIMEType:
        return jsValueForDecodedMessage<MessageName::RemoteLegacyCDMProxy_SupportsMIMEType>(globalObject, decoder);
    case MessageName::RemoteLegacyCDMProxy_CreateSession:
        return jsValueForDecodedMessage<MessageName::RemoteLegacyCDMProxy_CreateSession>(globalObject, decoder);
    case MessageName::RemoteLegacyCDMProxy_SetPlayerId:
        return jsValueForDecodedMessage<MessageName::RemoteLegacyCDMProxy_SetPlayerId>(globalObject, decoder);
#endif
#if ENABLE(GPU_PROCESS) && ENABLE(LEGACY_ENCRYPTED_MEDIA)
    case MessageName::RemoteLegacyCDMSessionProxy_GenerateKeyRequest:
        return jsValueForDecodedMessage<MessageName::RemoteLegacyCDMSessionProxy_GenerateKeyRequest>(globalObject, decoder);
    case MessageName::RemoteLegacyCDMSessionProxy_ReleaseKeys:
        return jsValueForDecodedMessage<MessageName::RemoteLegacyCDMSessionProxy_ReleaseKeys>(globalObject, decoder);
    case MessageName::RemoteLegacyCDMSessionProxy_Update:
        return jsValueForDecodedMessage<MessageName::RemoteLegacyCDMSessionProxy_Update>(globalObject, decoder);
    case MessageName::RemoteLegacyCDMSessionProxy_CachedKeyForKeyID:
        return jsValueForDecodedMessage<MessageName::RemoteLegacyCDMSessionProxy_CachedKeyForKeyID>(globalObject, decoder);
#endif
#if ENABLE(GPU_PROCESS)
    case MessageName::RemoteMediaEngineConfigurationFactoryProxy_CreateDecodingConfiguration:
        return jsValueForDecodedMessage<MessageName::RemoteMediaEngineConfigurationFactoryProxy_CreateDecodingConfiguration>(globalObject, decoder);
    case MessageName::RemoteMediaEngineConfigurationFactoryProxy_CreateEncodingConfiguration:
        return jsValueForDecodedMessage<MessageName::RemoteMediaEngineConfigurationFactoryProxy_CreateEncodingConfiguration>(globalObject, decoder);
#endif
#if ENABLE(GPU_PROCESS) && ENABLE(VIDEO)
    case MessageName::RemoteMediaPlayerManagerProxy_CreateMediaPlayer:
        return jsValueForDecodedMessage<MessageName::RemoteMediaPlayerManagerProxy_CreateMediaPlayer>(globalObject, decoder);
    case MessageName::RemoteMediaPlayerManagerProxy_DeleteMediaPlayer:
        return jsValueForDecodedMessage<MessageName::RemoteMediaPlayerManagerProxy_DeleteMediaPlayer>(globalObject, decoder);
    case MessageName::RemoteMediaPlayerManagerProxy_GetSupportedTypes:
        return jsValueForDecodedMessage<MessageName::RemoteMediaPlayerManagerProxy_GetSupportedTypes>(globalObject, decoder);
    case MessageName::RemoteMediaPlayerManagerProxy_SupportsTypeAndCodecs:
        return jsValueForDecodedMessage<MessageName::RemoteMediaPlayerManagerProxy_SupportsTypeAndCodecs>(globalObject, decoder);
    case MessageName::RemoteMediaPlayerManagerProxy_SupportsKeySystem:
        return jsValueForDecodedMessage<MessageName::RemoteMediaPlayerManagerProxy_SupportsKeySystem>(globalObject, decoder);
#endif
#if ENABLE(GPU_PROCESS) && ENABLE(VIDEO)
    case MessageName::RemoteMediaPlayerProxy_PrepareForPlayback:
        return jsValueForDecodedMessage<MessageName::RemoteMediaPlayerProxy_PrepareForPlayback>(globalObject, decoder);
    case MessageName::RemoteMediaPlayerProxy_Load:
        return jsValueForDecodedMessage<MessageName::RemoteMediaPlayerProxy_Load>(globalObject, decoder);
#if ENABLE(MEDIA_SOURCE)
    case MessageName::RemoteMediaPlayerProxy_LoadMediaSource:
        return jsValueForDecodedMessage<MessageName::RemoteMediaPlayerProxy_LoadMediaSource>(globalObject, decoder);
#endif
    case MessageName::RemoteMediaPlayerProxy_CancelLoad:
        return jsValueForDecodedMessage<MessageName::RemoteMediaPlayerProxy_CancelLoad>(globalObject, decoder);
    case MessageName::RemoteMediaPlayerProxy_PrepareToPlay:
        return jsValueForDecodedMessage<MessageName::RemoteMediaPlayerProxy_PrepareToPlay>(globalObject, decoder);
    case MessageName::RemoteMediaPlayerProxy_Play:
        return jsValueForDecodedMessage<MessageName::RemoteMediaPlayerProxy_Play>(globalObject, decoder);
    case MessageName::RemoteMediaPlayerProxy_Pause:
        return jsValueForDecodedMessage<MessageName::RemoteMediaPlayerProxy_Pause>(globalObject, decoder);
    case MessageName::RemoteMediaPlayerProxy_SetVolumeLocked:
        return jsValueForDecodedMessage<MessageName::RemoteMediaPlayerProxy_SetVolumeLocked>(globalObject, decoder);
    case MessageName::RemoteMediaPlayerProxy_SetVolume:
        return jsValueForDecodedMessage<MessageName::RemoteMediaPlayerProxy_SetVolume>(globalObject, decoder);
    case MessageName::RemoteMediaPlayerProxy_SetMuted:
        return jsValueForDecodedMessage<MessageName::RemoteMediaPlayerProxy_SetMuted>(globalObject, decoder);
    case MessageName::RemoteMediaPlayerProxy_SeekToTarget:
        return jsValueForDecodedMessage<MessageName::RemoteMediaPlayerProxy_SeekToTarget>(globalObject, decoder);
    case MessageName::RemoteMediaPlayerProxy_SetPreload:
        return jsValueForDecodedMessage<MessageName::RemoteMediaPlayerProxy_SetPreload>(globalObject, decoder);
    case MessageName::RemoteMediaPlayerProxy_SetPrivateBrowsingMode:
        return jsValueForDecodedMessage<MessageName::RemoteMediaPlayerProxy_SetPrivateBrowsingMode>(globalObject, decoder);
    case MessageName::RemoteMediaPlayerProxy_SetPreservesPitch:
        return jsValueForDecodedMessage<MessageName::RemoteMediaPlayerProxy_SetPreservesPitch>(globalObject, decoder);
    case MessageName::RemoteMediaPlayerProxy_SetPitchCorrectionAlgorithm:
        return jsValueForDecodedMessage<MessageName::RemoteMediaPlayerProxy_SetPitchCorrectionAlgorithm>(globalObject, decoder);
    case MessageName::RemoteMediaPlayerProxy_PrepareForRendering:
        return jsValueForDecodedMessage<MessageName::RemoteMediaPlayerProxy_PrepareForRendering>(globalObject, decoder);
    case MessageName::RemoteMediaPlayerProxy_SetPageIsVisible:
        return jsValueForDecodedMessage<MessageName::RemoteMediaPlayerProxy_SetPageIsVisible>(globalObject, decoder);
    case MessageName::RemoteMediaPlayerProxy_SetShouldMaintainAspectRatio:
        return jsValueForDecodedMessage<MessageName::RemoteMediaPlayerProxy_SetShouldMaintainAspectRatio>(globalObject, decoder);
    case MessageName::RemoteMediaPlayerProxy_AcceleratedRenderingStateChanged:
        return jsValueForDecodedMessage<MessageName::RemoteMediaPlayerProxy_AcceleratedRenderingStateChanged>(globalObject, decoder);
    case MessageName::RemoteMediaPlayerProxy_SetShouldDisableSleep:
        return jsValueForDecodedMessage<MessageName::RemoteMediaPlayerProxy_SetShouldDisableSleep>(globalObject, decoder);
    case MessageName::RemoteMediaPlayerProxy_SetRate:
        return jsValueForDecodedMessage<MessageName::RemoteMediaPlayerProxy_SetRate>(globalObject, decoder);
    case MessageName::RemoteMediaPlayerProxy_DidLoadingProgress:
        return jsValueForDecodedMessage<MessageName::RemoteMediaPlayerProxy_DidLoadingProgress>(globalObject, decoder);
#if ENABLE(VIDEO_PRESENTATION_MODE)
    case MessageName::RemoteMediaPlayerProxy_UpdateVideoFullscreenInlineImage:
        return jsValueForDecodedMessage<MessageName::RemoteMediaPlayerProxy_UpdateVideoFullscreenInlineImage>(globalObject, decoder);
    case MessageName::RemoteMediaPlayerProxy_SetVideoFullscreenMode:
        return jsValueForDecodedMessage<MessageName::RemoteMediaPlayerProxy_SetVideoFullscreenMode>(globalObject, decoder);
    case MessageName::RemoteMediaPlayerProxy_SetVideoFullscreenGravity:
        return jsValueForDecodedMessage<MessageName::RemoteMediaPlayerProxy_SetVideoFullscreenGravity>(globalObject, decoder);
    case MessageName::RemoteMediaPlayerProxy_VideoFullscreenStandbyChanged:
        return jsValueForDecodedMessage<MessageName::RemoteMediaPlayerProxy_VideoFullscreenStandbyChanged>(globalObject, decoder);
#endif
    case MessageName::RemoteMediaPlayerProxy_SetBufferingPolicy:
        return jsValueForDecodedMessage<MessageName::RemoteMediaPlayerProxy_SetBufferingPolicy>(globalObject, decoder);
    case MessageName::RemoteMediaPlayerProxy_SetPresentationSize:
        return jsValueForDecodedMessage<MessageName::RemoteMediaPlayerProxy_SetPresentationSize>(globalObject, decoder);
#if PLATFORM(COCOA)
    case MessageName::RemoteMediaPlayerProxy_SetVideoLayerSizeFenced:
        return jsValueForDecodedMessage<MessageName::RemoteMediaPlayerProxy_SetVideoLayerSizeFenced>(globalObject, decoder);
#endif
#if ENABLE(WIRELESS_PLAYBACK_TARGET)
    case MessageName::RemoteMediaPlayerProxy_SetWirelessVideoPlaybackDisabled:
        return jsValueForDecodedMessage<MessageName::RemoteMediaPlayerProxy_SetWirelessVideoPlaybackDisabled>(globalObject, decoder);
    case MessageName::RemoteMediaPlayerProxy_SetWirelessPlaybackTarget:
        return jsValueForDecodedMessage<MessageName::RemoteMediaPlayerProxy_SetWirelessPlaybackTarget>(globalObject, decoder);
    case MessageName::RemoteMediaPlayerProxy_SetShouldPlayToPlaybackTarget:
        return jsValueForDecodedMessage<MessageName::RemoteMediaPlayerProxy_SetShouldPlayToPlaybackTarget>(globalObject, decoder);
#endif
#if ENABLE(LEGACY_ENCRYPTED_MEDIA)
    case MessageName::RemoteMediaPlayerProxy_SetLegacyCDMSession:
        return jsValueForDecodedMessage<MessageName::RemoteMediaPlayerProxy_SetLegacyCDMSession>(globalObject, decoder);
    case MessageName::RemoteMediaPlayerProxy_KeyAdded:
        return jsValueForDecodedMessage<MessageName::RemoteMediaPlayerProxy_KeyAdded>(globalObject, decoder);
#endif
#if ENABLE(ENCRYPTED_MEDIA)
    case MessageName::RemoteMediaPlayerProxy_CdmInstanceAttached:
        return jsValueForDecodedMessage<MessageName::RemoteMediaPlayerProxy_CdmInstanceAttached>(globalObject, decoder);
    case MessageName::RemoteMediaPlayerProxy_CdmInstanceDetached:
        return jsValueForDecodedMessage<MessageName::RemoteMediaPlayerProxy_CdmInstanceDetached>(globalObject, decoder);
    case MessageName::RemoteMediaPlayerProxy_AttemptToDecryptWithInstance:
        return jsValueForDecodedMessage<MessageName::RemoteMediaPlayerProxy_AttemptToDecryptWithInstance>(globalObject, decoder);
#endif
#if ENABLE(LEGACY_ENCRYPTED_MEDIA) && ENABLE(ENCRYPTED_MEDIA)
    case MessageName::RemoteMediaPlayerProxy_SetShouldContinueAfterKeyNeeded:
        return jsValueForDecodedMessage<MessageName::RemoteMediaPlayerProxy_SetShouldContinueAfterKeyNeeded>(globalObject, decoder);
#endif
    case MessageName::RemoteMediaPlayerProxy_BeginSimulatedHDCPError:
        return jsValueForDecodedMessage<MessageName::RemoteMediaPlayerProxy_BeginSimulatedHDCPError>(globalObject, decoder);
    case MessageName::RemoteMediaPlayerProxy_EndSimulatedHDCPError:
        return jsValueForDecodedMessage<MessageName::RemoteMediaPlayerProxy_EndSimulatedHDCPError>(globalObject, decoder);
    case MessageName::RemoteMediaPlayerProxy_NotifyActiveSourceBuffersChanged:
        return jsValueForDecodedMessage<MessageName::RemoteMediaPlayerProxy_NotifyActiveSourceBuffersChanged>(globalObject, decoder);
    case MessageName::RemoteMediaPlayerProxy_ApplicationWillResignActive:
        return jsValueForDecodedMessage<MessageName::RemoteMediaPlayerProxy_ApplicationWillResignActive>(globalObject, decoder);
    case MessageName::RemoteMediaPlayerProxy_ApplicationDidBecomeActive:
        return jsValueForDecodedMessage<MessageName::RemoteMediaPlayerProxy_ApplicationDidBecomeActive>(globalObject, decoder);
    case MessageName::RemoteMediaPlayerProxy_NotifyTrackModeChanged:
        return jsValueForDecodedMessage<MessageName::RemoteMediaPlayerProxy_NotifyTrackModeChanged>(globalObject, decoder);
    case MessageName::RemoteMediaPlayerProxy_TracksChanged:
        return jsValueForDecodedMessage<MessageName::RemoteMediaPlayerProxy_TracksChanged>(globalObject, decoder);
    case MessageName::RemoteMediaPlayerProxy_AudioTrackSetEnabled:
        return jsValueForDecodedMessage<MessageName::RemoteMediaPlayerProxy_AudioTrackSetEnabled>(globalObject, decoder);
    case MessageName::RemoteMediaPlayerProxy_VideoTrackSetSelected:
        return jsValueForDecodedMessage<MessageName::RemoteMediaPlayerProxy_VideoTrackSetSelected>(globalObject, decoder);
    case MessageName::RemoteMediaPlayerProxy_TextTrackSetMode:
        return jsValueForDecodedMessage<MessageName::RemoteMediaPlayerProxy_TextTrackSetMode>(globalObject, decoder);
    case MessageName::RemoteMediaPlayerProxy_PerformTaskAtTime:
        return jsValueForDecodedMessage<MessageName::RemoteMediaPlayerProxy_PerformTaskAtTime>(globalObject, decoder);
    case MessageName::RemoteMediaPlayerProxy_IsCrossOrigin:
        return jsValueForDecodedMessage<MessageName::RemoteMediaPlayerProxy_IsCrossOrigin>(globalObject, decoder);
    case MessageName::RemoteMediaPlayerProxy_SetVideoPlaybackMetricsUpdateInterval:
        return jsValueForDecodedMessage<MessageName::RemoteMediaPlayerProxy_SetVideoPlaybackMetricsUpdateInterval>(globalObject, decoder);
    case MessageName::RemoteMediaPlayerProxy_SetPreferredDynamicRangeMode:
        return jsValueForDecodedMessage<MessageName::RemoteMediaPlayerProxy_SetPreferredDynamicRangeMode>(globalObject, decoder);
    case MessageName::RemoteMediaPlayerProxy_SetPlatformDynamicRangeLimit:
        return jsValueForDecodedMessage<MessageName::RemoteMediaPlayerProxy_SetPlatformDynamicRangeLimit>(globalObject, decoder);
#if PLATFORM(IOS_FAMILY)
    case MessageName::RemoteMediaPlayerProxy_ErrorLog:
        return jsValueForDecodedMessage<MessageName::RemoteMediaPlayerProxy_ErrorLog>(globalObject, decoder);
    case MessageName::RemoteMediaPlayerProxy_AccessLog:
        return jsValueForDecodedMessage<MessageName::RemoteMediaPlayerProxy_AccessLog>(globalObject, decoder);
    case MessageName::RemoteMediaPlayerProxy_SetSceneIdentifier:
        return jsValueForDecodedMessage<MessageName::RemoteMediaPlayerProxy_SetSceneIdentifier>(globalObject, decoder);
#endif
#if ENABLE(WEB_AUDIO)
    case MessageName::RemoteMediaPlayerProxy_CreateAudioSourceProvider:
        return jsValueForDecodedMessage<MessageName::RemoteMediaPlayerProxy_CreateAudioSourceProvider>(globalObject, decoder);
    case MessageName::RemoteMediaPlayerProxy_SetShouldEnableAudioSourceProvider:
        return jsValueForDecodedMessage<MessageName::RemoteMediaPlayerProxy_SetShouldEnableAudioSourceProvider>(globalObject, decoder);
#endif
#if PLATFORM(COCOA)
    case MessageName::RemoteMediaPlayerProxy_NativeImageForCurrentTime:
        return jsValueForDecodedMessage<MessageName::RemoteMediaPlayerProxy_NativeImageForCurrentTime>(globalObject, decoder);
    case MessageName::RemoteMediaPlayerProxy_ColorSpace:
        return jsValueForDecodedMessage<MessageName::RemoteMediaPlayerProxy_ColorSpace>(globalObject, decoder);
#endif
    case MessageName::RemoteMediaPlayerProxy_VideoFrameForCurrentTimeIfChanged:
        return jsValueForDecodedMessage<MessageName::RemoteMediaPlayerProxy_VideoFrameForCurrentTimeIfChanged>(globalObject, decoder);
    case MessageName::RemoteMediaPlayerProxy_PlayAtHostTime:
        return jsValueForDecodedMessage<MessageName::RemoteMediaPlayerProxy_PlayAtHostTime>(globalObject, decoder);
    case MessageName::RemoteMediaPlayerProxy_PauseAtHostTime:
        return jsValueForDecodedMessage<MessageName::RemoteMediaPlayerProxy_PauseAtHostTime>(globalObject, decoder);
    case MessageName::RemoteMediaPlayerProxy_StartVideoFrameMetadataGathering:
        return jsValueForDecodedMessage<MessageName::RemoteMediaPlayerProxy_StartVideoFrameMetadataGathering>(globalObject, decoder);
    case MessageName::RemoteMediaPlayerProxy_StopVideoFrameMetadataGathering:
        return jsValueForDecodedMessage<MessageName::RemoteMediaPlayerProxy_StopVideoFrameMetadataGathering>(globalObject, decoder);
    case MessageName::RemoteMediaPlayerProxy_PlayerContentBoxRectChanged:
        return jsValueForDecodedMessage<MessageName::RemoteMediaPlayerProxy_PlayerContentBoxRectChanged>(globalObject, decoder);
    case MessageName::RemoteMediaPlayerProxy_SetShouldDisableHDR:
        return jsValueForDecodedMessage<MessageName::RemoteMediaPlayerProxy_SetShouldDisableHDR>(globalObject, decoder);
    case MessageName::RemoteMediaPlayerProxy_RequestHostingContext:
        return jsValueForDecodedMessage<MessageName::RemoteMediaPlayerProxy_RequestHostingContext>(globalObject, decoder);
    case MessageName::RemoteMediaPlayerProxy_SetShouldCheckHardwareSupport:
        return jsValueForDecodedMessage<MessageName::RemoteMediaPlayerProxy_SetShouldCheckHardwareSupport>(globalObject, decoder);
#if HAVE(SPATIAL_TRACKING_LABEL)
    case MessageName::RemoteMediaPlayerProxy_SetDefaultSpatialTrackingLabel:
        return jsValueForDecodedMessage<MessageName::RemoteMediaPlayerProxy_SetDefaultSpatialTrackingLabel>(globalObject, decoder);
    case MessageName::RemoteMediaPlayerProxy_SetSpatialTrackingLabel:
        return jsValueForDecodedMessage<MessageName::RemoteMediaPlayerProxy_SetSpatialTrackingLabel>(globalObject, decoder);
#endif
#if HAVE(SPATIAL_AUDIO_EXPERIENCE)
    case MessageName::RemoteMediaPlayerProxy_SetPrefersSpatialAudioExperience:
        return jsValueForDecodedMessage<MessageName::RemoteMediaPlayerProxy_SetPrefersSpatialAudioExperience>(globalObject, decoder);
#endif
    case MessageName::RemoteMediaPlayerProxy_AudioOutputDeviceChanged:
        return jsValueForDecodedMessage<MessageName::RemoteMediaPlayerProxy_AudioOutputDeviceChanged>(globalObject, decoder);
    case MessageName::RemoteMediaPlayerProxy_IsInFullscreenOrPictureInPictureChanged:
        return jsValueForDecodedMessage<MessageName::RemoteMediaPlayerProxy_IsInFullscreenOrPictureInPictureChanged>(globalObject, decoder);
    case MessageName::RemoteMediaPlayerProxy_SetSoundStageSize:
        return jsValueForDecodedMessage<MessageName::RemoteMediaPlayerProxy_SetSoundStageSize>(globalObject, decoder);
    case MessageName::RemoteMediaPlayerProxy_SetHasMessageClientForTesting:
        return jsValueForDecodedMessage<MessageName::RemoteMediaPlayerProxy_SetHasMessageClientForTesting>(globalObject, decoder);
#endif
#if ENABLE(GPU_PROCESS) && ENABLE(VIDEO)
    case MessageName::RemoteMediaResourceManager_ResponseReceived:
        return jsValueForDecodedMessage<MessageName::RemoteMediaResourceManager_ResponseReceived>(globalObject, decoder);
    case MessageName::RemoteMediaResourceManager_RedirectReceived:
        return jsValueForDecodedMessage<MessageName::RemoteMediaResourceManager_RedirectReceived>(globalObject, decoder);
    case MessageName::RemoteMediaResourceManager_DataSent:
        return jsValueForDecodedMessage<MessageName::RemoteMediaResourceManager_DataSent>(globalObject, decoder);
    case MessageName::RemoteMediaResourceManager_DataReceived:
        return jsValueForDecodedMessage<MessageName::RemoteMediaResourceManager_DataReceived>(globalObject, decoder);
    case MessageName::RemoteMediaResourceManager_AccessControlCheckFailed:
        return jsValueForDecodedMessage<MessageName::RemoteMediaResourceManager_AccessControlCheckFailed>(globalObject, decoder);
    case MessageName::RemoteMediaResourceManager_LoadFailed:
        return jsValueForDecodedMessage<MessageName::RemoteMediaResourceManager_LoadFailed>(globalObject, decoder);
    case MessageName::RemoteMediaResourceManager_LoadFinished:
        return jsValueForDecodedMessage<MessageName::RemoteMediaResourceManager_LoadFinished>(globalObject, decoder);
#endif
#if ENABLE(GPU_PROCESS) && ENABLE(MEDIA_SOURCE)
    case MessageName::RemoteMediaSourceProxy_AddSourceBuffer:
        return jsValueForDecodedMessage<MessageName::RemoteMediaSourceProxy_AddSourceBuffer>(globalObject, decoder);
    case MessageName::RemoteMediaSourceProxy_DurationChanged:
        return jsValueForDecodedMessage<MessageName::RemoteMediaSourceProxy_DurationChanged>(globalObject, decoder);
    case MessageName::RemoteMediaSourceProxy_BufferedChanged:
        return jsValueForDecodedMessage<MessageName::RemoteMediaSourceProxy_BufferedChanged>(globalObject, decoder);
    case MessageName::RemoteMediaSourceProxy_SetMediaPlayerReadyState:
        return jsValueForDecodedMessage<MessageName::RemoteMediaSourceProxy_SetMediaPlayerReadyState>(globalObject, decoder);
    case MessageName::RemoteMediaSourceProxy_SetTimeFudgeFactor:
        return jsValueForDecodedMessage<MessageName::RemoteMediaSourceProxy_SetTimeFudgeFactor>(globalObject, decoder);
    case MessageName::RemoteMediaSourceProxy_MarkEndOfStream:
        return jsValueForDecodedMessage<MessageName::RemoteMediaSourceProxy_MarkEndOfStream>(globalObject, decoder);
    case MessageName::RemoteMediaSourceProxy_UnmarkEndOfStream:
        return jsValueForDecodedMessage<MessageName::RemoteMediaSourceProxy_UnmarkEndOfStream>(globalObject, decoder);
    case MessageName::RemoteMediaSourceProxy_Shutdown:
        return jsValueForDecodedMessage<MessageName::RemoteMediaSourceProxy_Shutdown>(globalObject, decoder);
#endif
#if ENABLE(GPU_PROCESS)
    case MessageName::RemoteRemoteCommandListenerProxy_UpdateSupportedCommands:
        return jsValueForDecodedMessage<MessageName::RemoteRemoteCommandListenerProxy_UpdateSupportedCommands>(globalObject, decoder);
#endif
#if ENABLE(GPU_PROCESS) && ENABLE(MEDIA_SOURCE)
    case MessageName::RemoteSourceBufferProxy_SetActive:
        return jsValueForDecodedMessage<MessageName::RemoteSourceBufferProxy_SetActive>(globalObject, decoder);
    case MessageName::RemoteSourceBufferProxy_CanSwitchToType:
        return jsValueForDecodedMessage<MessageName::RemoteSourceBufferProxy_CanSwitchToType>(globalObject, decoder);
    case MessageName::RemoteSourceBufferProxy_SetMode:
        return jsValueForDecodedMessage<MessageName::RemoteSourceBufferProxy_SetMode>(globalObject, decoder);
    case MessageName::RemoteSourceBufferProxy_Append:
        return jsValueForDecodedMessage<MessageName::RemoteSourceBufferProxy_Append>(globalObject, decoder);
    case MessageName::RemoteSourceBufferProxy_Abort:
        return jsValueForDecodedMessage<MessageName::RemoteSourceBufferProxy_Abort>(globalObject, decoder);
    case MessageName::RemoteSourceBufferProxy_ResetParserState:
        return jsValueForDecodedMessage<MessageName::RemoteSourceBufferProxy_ResetParserState>(globalObject, decoder);
    case MessageName::RemoteSourceBufferProxy_RemovedFromMediaSource:
        return jsValueForDecodedMessage<MessageName::RemoteSourceBufferProxy_RemovedFromMediaSource>(globalObject, decoder);
    case MessageName::RemoteSourceBufferProxy_SetMediaSourceEnded:
        return jsValueForDecodedMessage<MessageName::RemoteSourceBufferProxy_SetMediaSourceEnded>(globalObject, decoder);
    case MessageName::RemoteSourceBufferProxy_StartChangingType:
        return jsValueForDecodedMessage<MessageName::RemoteSourceBufferProxy_StartChangingType>(globalObject, decoder);
    case MessageName::RemoteSourceBufferProxy_AddTrackBuffer:
        return jsValueForDecodedMessage<MessageName::RemoteSourceBufferProxy_AddTrackBuffer>(globalObject, decoder);
    case MessageName::RemoteSourceBufferProxy_ResetTrackBuffers:
        return jsValueForDecodedMessage<MessageName::RemoteSourceBufferProxy_ResetTrackBuffers>(globalObject, decoder);
    case MessageName::RemoteSourceBufferProxy_ClearTrackBuffers:
        return jsValueForDecodedMessage<MessageName::RemoteSourceBufferProxy_ClearTrackBuffers>(globalObject, decoder);
    case MessageName::RemoteSourceBufferProxy_SetAllTrackBuffersNeedRandomAccess:
        return jsValueForDecodedMessage<MessageName::RemoteSourceBufferProxy_SetAllTrackBuffersNeedRandomAccess>(globalObject, decoder);
    case MessageName::RemoteSourceBufferProxy_RemoveCodedFrames:
        return jsValueForDecodedMessage<MessageName::RemoteSourceBufferProxy_RemoveCodedFrames>(globalObject, decoder);
    case MessageName::RemoteSourceBufferProxy_EvictCodedFrames:
        return jsValueForDecodedMessage<MessageName::RemoteSourceBufferProxy_EvictCodedFrames>(globalObject, decoder);
    case MessageName::RemoteSourceBufferProxy_AsyncEvictCodedFrames:
        return jsValueForDecodedMessage<MessageName::RemoteSourceBufferProxy_AsyncEvictCodedFrames>(globalObject, decoder);
    case MessageName::RemoteSourceBufferProxy_ReenqueueMediaIfNeeded:
        return jsValueForDecodedMessage<MessageName::RemoteSourceBufferProxy_ReenqueueMediaIfNeeded>(globalObject, decoder);
    case MessageName::RemoteSourceBufferProxy_SetGroupStartTimestamp:
        return jsValueForDecodedMessage<MessageName::RemoteSourceBufferProxy_SetGroupStartTimestamp>(globalObject, decoder);
    case MessageName::RemoteSourceBufferProxy_SetGroupStartTimestampToEndTimestamp:
        return jsValueForDecodedMessage<MessageName::RemoteSourceBufferProxy_SetGroupStartTimestampToEndTimestamp>(globalObject, decoder);
    case MessageName::RemoteSourceBufferProxy_SetShouldGenerateTimestamps:
        return jsValueForDecodedMessage<MessageName::RemoteSourceBufferProxy_SetShouldGenerateTimestamps>(globalObject, decoder);
    case MessageName::RemoteSourceBufferProxy_ResetTimestampOffsetInTrackBuffers:
        return jsValueForDecodedMessage<MessageName::RemoteSourceBufferProxy_ResetTimestampOffsetInTrackBuffers>(globalObject, decoder);
    case MessageName::RemoteSourceBufferProxy_SetTimestampOffset:
        return jsValueForDecodedMessage<MessageName::RemoteSourceBufferProxy_SetTimestampOffset>(globalObject, decoder);
    case MessageName::RemoteSourceBufferProxy_SetAppendWindowStart:
        return jsValueForDecodedMessage<MessageName::RemoteSourceBufferProxy_SetAppendWindowStart>(globalObject, decoder);
    case MessageName::RemoteSourceBufferProxy_SetAppendWindowEnd:
        return jsValueForDecodedMessage<MessageName::RemoteSourceBufferProxy_SetAppendWindowEnd>(globalObject, decoder);
    case MessageName::RemoteSourceBufferProxy_SetMaximumBufferSize:
        return jsValueForDecodedMessage<MessageName::RemoteSourceBufferProxy_SetMaximumBufferSize>(globalObject, decoder);
    case MessageName::RemoteSourceBufferProxy_ComputeSeekTime:
        return jsValueForDecodedMessage<MessageName::RemoteSourceBufferProxy_ComputeSeekTime>(globalObject, decoder);
    case MessageName::RemoteSourceBufferProxy_SeekToTime:
        return jsValueForDecodedMessage<MessageName::RemoteSourceBufferProxy_SeekToTime>(globalObject, decoder);
    case MessageName::RemoteSourceBufferProxy_UpdateTrackIds:
        return jsValueForDecodedMessage<MessageName::RemoteSourceBufferProxy_UpdateTrackIds>(globalObject, decoder);
    case MessageName::RemoteSourceBufferProxy_BufferedSamplesForTrackId:
        return jsValueForDecodedMessage<MessageName::RemoteSourceBufferProxy_BufferedSamplesForTrackId>(globalObject, decoder);
    case MessageName::RemoteSourceBufferProxy_EnqueuedSamplesForTrackID:
        return jsValueForDecodedMessage<MessageName::RemoteSourceBufferProxy_EnqueuedSamplesForTrackID>(globalObject, decoder);
    case MessageName::RemoteSourceBufferProxy_MemoryPressure:
        return jsValueForDecodedMessage<MessageName::RemoteSourceBufferProxy_MemoryPressure>(globalObject, decoder);
    case MessageName::RemoteSourceBufferProxy_Detach:
        return jsValueForDecodedMessage<MessageName::RemoteSourceBufferProxy_Detach>(globalObject, decoder);
    case MessageName::RemoteSourceBufferProxy_Attach:
        return jsValueForDecodedMessage<MessageName::RemoteSourceBufferProxy_Attach>(globalObject, decoder);
    case MessageName::RemoteSourceBufferProxy_SetMaximumQueueDepthForTrackID:
        return jsValueForDecodedMessage<MessageName::RemoteSourceBufferProxy_SetMaximumQueueDepthForTrackID>(globalObject, decoder);
    case MessageName::RemoteSourceBufferProxy_MinimumUpcomingPresentationTimeForTrackID:
        return jsValueForDecodedMessage<MessageName::RemoteSourceBufferProxy_MinimumUpcomingPresentationTimeForTrackID>(globalObject, decoder);
#endif
#if ENABLE(GPU_PROCESS) && ENABLE(VIDEO)
#if PLATFORM(COCOA)
    case MessageName::RemoteVideoFrameObjectHeap_GetVideoFrameBuffer:
        return jsValueForDecodedMessage<MessageName::RemoteVideoFrameObjectHeap_GetVideoFrameBuffer>(globalObject, decoder);
    case MessageName::RemoteVideoFrameObjectHeap_PixelBuffer:
        return jsValueForDecodedMessage<MessageName::RemoteVideoFrameObjectHeap_PixelBuffer>(globalObject, decoder);
    case MessageName::RemoteVideoFrameObjectHeap_SetSharedVideoFrameSemaphore:
        return jsValueForDecodedMessage<MessageName::RemoteVideoFrameObjectHeap_SetSharedVideoFrameSemaphore>(globalObject, decoder);
    case MessageName::RemoteVideoFrameObjectHeap_SetSharedVideoFrameMemory:
        return jsValueForDecodedMessage<MessageName::RemoteVideoFrameObjectHeap_SetSharedVideoFrameMemory>(globalObject, decoder);
    case MessageName::RemoteVideoFrameObjectHeap_ConvertFrameBuffer:
        return jsValueForDecodedMessage<MessageName::RemoteVideoFrameObjectHeap_ConvertFrameBuffer>(globalObject, decoder);
#endif
    case MessageName::RemoteVideoFrameObjectHeap_ReleaseVideoFrame:
        return jsValueForDecodedMessage<MessageName::RemoteVideoFrameObjectHeap_ReleaseVideoFrame>(globalObject, decoder);
#endif
#if USE(LIBWEBRTC) && PLATFORM(COCOA) && ENABLE(GPU_PROCESS)
    case MessageName::LibWebRTCCodecsProxy_CreateDecoder:
        return jsValueForDecodedMessage<MessageName::LibWebRTCCodecsProxy_CreateDecoder>(globalObject, decoder);
    case MessageName::LibWebRTCCodecsProxy_ReleaseDecoder:
        return jsValueForDecodedMessage<MessageName::LibWebRTCCodecsProxy_ReleaseDecoder>(globalObject, decoder);
    case MessageName::LibWebRTCCodecsProxy_FlushDecoder:
        return jsValueForDecodedMessage<MessageName::LibWebRTCCodecsProxy_FlushDecoder>(globalObject, decoder);
    case MessageName::LibWebRTCCodecsProxy_SetDecoderFormatDescription:
        return jsValueForDecodedMessage<MessageName::LibWebRTCCodecsProxy_SetDecoderFormatDescription>(globalObject, decoder);
    case MessageName::LibWebRTCCodecsProxy_DecodeFrame:
        return jsValueForDecodedMessage<MessageName::LibWebRTCCodecsProxy_DecodeFrame>(globalObject, decoder);
    case MessageName::LibWebRTCCodecsProxy_SetFrameSize:
        return jsValueForDecodedMessage<MessageName::LibWebRTCCodecsProxy_SetFrameSize>(globalObject, decoder);
    case MessageName::LibWebRTCCodecsProxy_CreateEncoder:
        return jsValueForDecodedMessage<MessageName::LibWebRTCCodecsProxy_CreateEncoder>(globalObject, decoder);
    case MessageName::LibWebRTCCodecsProxy_ReleaseEncoder:
        return jsValueForDecodedMessage<MessageName::LibWebRTCCodecsProxy_ReleaseEncoder>(globalObject, decoder);
    case MessageName::LibWebRTCCodecsProxy_InitializeEncoder:
        return jsValueForDecodedMessage<MessageName::LibWebRTCCodecsProxy_InitializeEncoder>(globalObject, decoder);
    case MessageName::LibWebRTCCodecsProxy_EncodeFrame:
        return jsValueForDecodedMessage<MessageName::LibWebRTCCodecsProxy_EncodeFrame>(globalObject, decoder);
    case MessageName::LibWebRTCCodecsProxy_FlushEncoder:
        return jsValueForDecodedMessage<MessageName::LibWebRTCCodecsProxy_FlushEncoder>(globalObject, decoder);
    case MessageName::LibWebRTCCodecsProxy_SetEncodeRates:
        return jsValueForDecodedMessage<MessageName::LibWebRTCCodecsProxy_SetEncodeRates>(globalObject, decoder);
    case MessageName::LibWebRTCCodecsProxy_SetSharedVideoFrameSemaphore:
        return jsValueForDecodedMessage<MessageName::LibWebRTCCodecsProxy_SetSharedVideoFrameSemaphore>(globalObject, decoder);
    case MessageName::LibWebRTCCodecsProxy_SetSharedVideoFrameMemory:
        return jsValueForDecodedMessage<MessageName::LibWebRTCCodecsProxy_SetSharedVideoFrameMemory>(globalObject, decoder);
    case MessageName::LibWebRTCCodecsProxy_SetRTCLoggingLevel:
        return jsValueForDecodedMessage<MessageName::LibWebRTCCodecsProxy_SetRTCLoggingLevel>(globalObject, decoder);
#endif
#if ENABLE(GPU_PROCESS) && ENABLE(MEDIA_STREAM) && PLATFORM(COCOA)
    case MessageName::RemoteAudioMediaStreamTrackRendererInternalUnitManager_CreateUnit:
        return jsValueForDecodedMessage<MessageName::RemoteAudioMediaStreamTrackRendererInternalUnitManager_CreateUnit>(globalObject, decoder);
    case MessageName::RemoteAudioMediaStreamTrackRendererInternalUnitManager_DeleteUnit:
        return jsValueForDecodedMessage<MessageName::RemoteAudioMediaStreamTrackRendererInternalUnitManager_DeleteUnit>(globalObject, decoder);
    case MessageName::RemoteAudioMediaStreamTrackRendererInternalUnitManager_StartUnit:
        return jsValueForDecodedMessage<MessageName::RemoteAudioMediaStreamTrackRendererInternalUnitManager_StartUnit>(globalObject, decoder);
    case MessageName::RemoteAudioMediaStreamTrackRendererInternalUnitManager_StopUnit:
        return jsValueForDecodedMessage<MessageName::RemoteAudioMediaStreamTrackRendererInternalUnitManager_StopUnit>(globalObject, decoder);
    case MessageName::RemoteAudioMediaStreamTrackRendererInternalUnitManager_SetLastDeviceUsed:
        return jsValueForDecodedMessage<MessageName::RemoteAudioMediaStreamTrackRendererInternalUnitManager_SetLastDeviceUsed>(globalObject, decoder);
#endif
#if PLATFORM(COCOA) && ENABLE(GPU_PROCESS) && ENABLE(MEDIA_STREAM)
#if !RELEASE_LOG_DISABLED
    case MessageName::RemoteSampleBufferDisplayLayer_SetLogIdentifier:
        return jsValueForDecodedMessage<MessageName::RemoteSampleBufferDisplayLayer_SetLogIdentifier>(globalObject, decoder);
#endif
    case MessageName::RemoteSampleBufferDisplayLayer_UpdateDisplayMode:
        return jsValueForDecodedMessage<MessageName::RemoteSampleBufferDisplayLayer_UpdateDisplayMode>(globalObject, decoder);
    case MessageName::RemoteSampleBufferDisplayLayer_Flush:
        return jsValueForDecodedMessage<MessageName::RemoteSampleBufferDisplayLayer_Flush>(globalObject, decoder);
    case MessageName::RemoteSampleBufferDisplayLayer_FlushAndRemoveImage:
        return jsValueForDecodedMessage<MessageName::RemoteSampleBufferDisplayLayer_FlushAndRemoveImage>(globalObject, decoder);
    case MessageName::RemoteSampleBufferDisplayLayer_EnqueueVideoFrame:
        return jsValueForDecodedMessage<MessageName::RemoteSampleBufferDisplayLayer_EnqueueVideoFrame>(globalObject, decoder);
    case MessageName::RemoteSampleBufferDisplayLayer_ClearVideoFrames:
        return jsValueForDecodedMessage<MessageName::RemoteSampleBufferDisplayLayer_ClearVideoFrames>(globalObject, decoder);
    case MessageName::RemoteSampleBufferDisplayLayer_Play:
        return jsValueForDecodedMessage<MessageName::RemoteSampleBufferDisplayLayer_Play>(globalObject, decoder);
    case MessageName::RemoteSampleBufferDisplayLayer_Pause:
        return jsValueForDecodedMessage<MessageName::RemoteSampleBufferDisplayLayer_Pause>(globalObject, decoder);
    case MessageName::RemoteSampleBufferDisplayLayer_SetSharedVideoFrameSemaphore:
        return jsValueForDecodedMessage<MessageName::RemoteSampleBufferDisplayLayer_SetSharedVideoFrameSemaphore>(globalObject, decoder);
    case MessageName::RemoteSampleBufferDisplayLayer_SetSharedVideoFrameMemory:
        return jsValueForDecodedMessage<MessageName::RemoteSampleBufferDisplayLayer_SetSharedVideoFrameMemory>(globalObject, decoder);
    case MessageName::RemoteSampleBufferDisplayLayer_SetShouldMaintainAspectRatio:
        return jsValueForDecodedMessage<MessageName::RemoteSampleBufferDisplayLayer_SetShouldMaintainAspectRatio>(globalObject, decoder);
#endif
#if PLATFORM(COCOA) && ENABLE(GPU_PROCESS) && ENABLE(MEDIA_STREAM)
    case MessageName::RemoteSampleBufferDisplayLayerManager_CreateLayer:
        return jsValueForDecodedMessage<MessageName::RemoteSampleBufferDisplayLayerManager_CreateLayer>(globalObject, decoder);
    case MessageName::RemoteSampleBufferDisplayLayerManager_ReleaseLayer:
        return jsValueForDecodedMessage<MessageName::RemoteSampleBufferDisplayLayerManager_ReleaseLayer>(globalObject, decoder);
#endif
#if ENABLE(MODEL_PROCESS)
#if HAVE(VISIBILITY_PROPAGATION_VIEW)
    case MessageName::ModelConnectionToWebProcess_CreateVisibilityPropagationContextForPage:
        return jsValueForDecodedMessage<MessageName::ModelConnectionToWebProcess_CreateVisibilityPropagationContextForPage>(globalObject, decoder);
    case MessageName::ModelConnectionToWebProcess_DestroyVisibilityPropagationContextForPage:
        return jsValueForDecodedMessage<MessageName::ModelConnectionToWebProcess_DestroyVisibilityPropagationContextForPage>(globalObject, decoder);
#endif
    case MessageName::ModelConnectionToWebProcess_ConfigureLoggingChannel:
        return jsValueForDecodedMessage<MessageName::ModelConnectionToWebProcess_ConfigureLoggingChannel>(globalObject, decoder);
#endif
#if ENABLE(MODEL_PROCESS)
    case MessageName::ModelProcess_InitializeModelProcess:
        return jsValueForDecodedMessage<MessageName::ModelProcess_InitializeModelProcess>(globalObject, decoder);
    case MessageName::ModelProcess_CreateModelConnectionToWebProcess:
        return jsValueForDecodedMessage<MessageName::ModelProcess_CreateModelConnectionToWebProcess>(globalObject, decoder);
    case MessageName::ModelProcess_SharedPreferencesForWebProcessDidChange:
        return jsValueForDecodedMessage<MessageName::ModelProcess_SharedPreferencesForWebProcessDidChange>(globalObject, decoder);
    case MessageName::ModelProcess_PrepareToSuspend:
        return jsValueForDecodedMessage<MessageName::ModelProcess_PrepareToSuspend>(globalObject, decoder);
    case MessageName::ModelProcess_ProcessDidResume:
        return jsValueForDecodedMessage<MessageName::ModelProcess_ProcessDidResume>(globalObject, decoder);
    case MessageName::ModelProcess_AddSession:
        return jsValueForDecodedMessage<MessageName::ModelProcess_AddSession>(globalObject, decoder);
    case MessageName::ModelProcess_RemoveSession:
        return jsValueForDecodedMessage<MessageName::ModelProcess_RemoveSession>(globalObject, decoder);
    case MessageName::ModelProcess_WebProcessConnectionCountForTesting:
        return jsValueForDecodedMessage<MessageName::ModelProcess_WebProcessConnectionCountForTesting>(globalObject, decoder);
    case MessageName::ModelProcess_ModelPlayerCountForTesting:
        return jsValueForDecodedMessage<MessageName::ModelProcess_ModelPlayerCountForTesting>(globalObject, decoder);
#endif
#if ENABLE(MODEL_PROCESS)
    case MessageName::ModelProcessModelPlayerManagerProxy_CreateModelPlayer:
        return jsValueForDecodedMessage<MessageName::ModelProcessModelPlayerManagerProxy_CreateModelPlayer>(globalObject, decoder);
    case MessageName::ModelProcessModelPlayerManagerProxy_DeleteModelPlayer:
        return jsValueForDecodedMessage<MessageName::ModelProcessModelPlayerManagerProxy_DeleteModelPlayer>(globalObject, decoder);
#endif
    case MessageName::AuthenticationManager_CompleteAuthenticationChallenge:
        return jsValueForDecodedMessage<MessageName::AuthenticationManager_CompleteAuthenticationChallenge>(globalObject, decoder);
    case MessageName::WebCookieManager_GetHostnamesWithCookies:
        return jsValueForDecodedMessage<MessageName::WebCookieManager_GetHostnamesWithCookies>(globalObject, decoder);
    case MessageName::WebCookieManager_DeleteCookiesForHostnames:
        return jsValueForDecodedMessage<MessageName::WebCookieManager_DeleteCookiesForHostnames>(globalObject, decoder);
    case MessageName::WebCookieManager_DeleteAllCookies:
        return jsValueForDecodedMessage<MessageName::WebCookieManager_DeleteAllCookies>(globalObject, decoder);
    case MessageName::WebCookieManager_SetCookie:
        return jsValueForDecodedMessage<MessageName::WebCookieManager_SetCookie>(globalObject, decoder);
    case MessageName::WebCookieManager_SetCookies:
        return jsValueForDecodedMessage<MessageName::WebCookieManager_SetCookies>(globalObject, decoder);
    case MessageName::WebCookieManager_GetAllCookies:
        return jsValueForDecodedMessage<MessageName::WebCookieManager_GetAllCookies>(globalObject, decoder);
    case MessageName::WebCookieManager_GetCookies:
        return jsValueForDecodedMessage<MessageName::WebCookieManager_GetCookies>(globalObject, decoder);
    case MessageName::WebCookieManager_DeleteCookie:
        return jsValueForDecodedMessage<MessageName::WebCookieManager_DeleteCookie>(globalObject, decoder);
    case MessageName::WebCookieManager_DeleteAllCookiesModifiedSince:
        return jsValueForDecodedMessage<MessageName::WebCookieManager_DeleteAllCookiesModifiedSince>(globalObject, decoder);
    case MessageName::WebCookieManager_SetHTTPCookieAcceptPolicy:
        return jsValueForDecodedMessage<MessageName::WebCookieManager_SetHTTPCookieAcceptPolicy>(globalObject, decoder);
    case MessageName::WebCookieManager_GetHTTPCookieAcceptPolicy:
        return jsValueForDecodedMessage<MessageName::WebCookieManager_GetHTTPCookieAcceptPolicy>(globalObject, decoder);
    case MessageName::WebCookieManager_StartObservingCookieChanges:
        return jsValueForDecodedMessage<MessageName::WebCookieManager_StartObservingCookieChanges>(globalObject, decoder);
    case MessageName::WebCookieManager_StopObservingCookieChanges:
        return jsValueForDecodedMessage<MessageName::WebCookieManager_StopObservingCookieChanges>(globalObject, decoder);
#if USE(SOUP)
    case MessageName::WebCookieManager_ReplaceCookies:
        return jsValueForDecodedMessage<MessageName::WebCookieManager_ReplaceCookies>(globalObject, decoder);
    case MessageName::WebCookieManager_SetCookiePersistentStorage:
        return jsValueForDecodedMessage<MessageName::WebCookieManager_SetCookiePersistentStorage>(globalObject, decoder);
#endif
    case MessageName::NetworkBroadcastChannelRegistry_RegisterChannel:
        return jsValueForDecodedMessage<MessageName::NetworkBroadcastChannelRegistry_RegisterChannel>(globalObject, decoder);
    case MessageName::NetworkBroadcastChannelRegistry_UnregisterChannel:
        return jsValueForDecodedMessage<MessageName::NetworkBroadcastChannelRegistry_UnregisterChannel>(globalObject, decoder);
    case MessageName::NetworkBroadcastChannelRegistry_PostMessage:
        return jsValueForDecodedMessage<MessageName::NetworkBroadcastChannelRegistry_PostMessage>(globalObject, decoder);
    case MessageName::NetworkConnectionToWebProcess_ScheduleResourceLoad:
        return jsValueForDecodedMessage<MessageName::NetworkConnectionToWebProcess_ScheduleResourceLoad>(globalObject, decoder);
    case MessageName::NetworkConnectionToWebProcess_PerformSynchronousLoad:
        return jsValueForDecodedMessage<MessageName::NetworkConnectionToWebProcess_PerformSynchronousLoad>(globalObject, decoder);
    case MessageName::NetworkConnectionToWebProcess_TestProcessIncomingSyncMessagesWhenWaitingForSyncReply:
        return jsValueForDecodedMessage<MessageName::NetworkConnectionToWebProcess_TestProcessIncomingSyncMessagesWhenWaitingForSyncReply>(globalObject, decoder);
    case MessageName::NetworkConnectionToWebProcess_LoadPing:
        return jsValueForDecodedMessage<MessageName::NetworkConnectionToWebProcess_LoadPing>(globalObject, decoder);
    case MessageName::NetworkConnectionToWebProcess_RemoveLoadIdentifier:
        return jsValueForDecodedMessage<MessageName::NetworkConnectionToWebProcess_RemoveLoadIdentifier>(globalObject, decoder);
    case MessageName::NetworkConnectionToWebProcess_PageLoadCompleted:
        return jsValueForDecodedMessage<MessageName::NetworkConnectionToWebProcess_PageLoadCompleted>(globalObject, decoder);
    case MessageName::NetworkConnectionToWebProcess_BrowsingContextRemoved:
        return jsValueForDecodedMessage<MessageName::NetworkConnectionToWebProcess_BrowsingContextRemoved>(globalObject, decoder);
    case MessageName::NetworkConnectionToWebProcess_PrefetchDNS:
        return jsValueForDecodedMessage<MessageName::NetworkConnectionToWebProcess_PrefetchDNS>(globalObject, decoder);
    case MessageName::NetworkConnectionToWebProcess_SendH2Ping:
        return jsValueForDecodedMessage<MessageName::NetworkConnectionToWebProcess_SendH2Ping>(globalObject, decoder);
    case MessageName::NetworkConnectionToWebProcess_PreconnectTo:
        return jsValueForDecodedMessage<MessageName::NetworkConnectionToWebProcess_PreconnectTo>(globalObject, decoder);
    case MessageName::NetworkConnectionToWebProcess_IsResourceLoadFinished:
        return jsValueForDecodedMessage<MessageName::NetworkConnectionToWebProcess_IsResourceLoadFinished>(globalObject, decoder);
    case MessageName::NetworkConnectionToWebProcess_StartDownload:
        return jsValueForDecodedMessage<MessageName::NetworkConnectionToWebProcess_StartDownload>(globalObject, decoder);
    case MessageName::NetworkConnectionToWebProcess_ConvertMainResourceLoadToDownload:
        return jsValueForDecodedMessage<MessageName::NetworkConnectionToWebProcess_ConvertMainResourceLoadToDownload>(globalObject, decoder);
    case MessageName::NetworkConnectionToWebProcess_CookiesForDOM:
        return jsValueForDecodedMessage<MessageName::NetworkConnectionToWebProcess_CookiesForDOM>(globalObject, decoder);
    case MessageName::NetworkConnectionToWebProcess_SetCookiesFromDOM:
        return jsValueForDecodedMessage<MessageName::NetworkConnectionToWebProcess_SetCookiesFromDOM>(globalObject, decoder);
    case MessageName::NetworkConnectionToWebProcess_CookiesEnabledSync:
        return jsValueForDecodedMessage<MessageName::NetworkConnectionToWebProcess_CookiesEnabledSync>(globalObject, decoder);
    case MessageName::NetworkConnectionToWebProcess_CookiesEnabled:
        return jsValueForDecodedMessage<MessageName::NetworkConnectionToWebProcess_CookiesEnabled>(globalObject, decoder);
    case MessageName::NetworkConnectionToWebProcess_CookieRequestHeaderFieldValue:
        return jsValueForDecodedMessage<MessageName::NetworkConnectionToWebProcess_CookieRequestHeaderFieldValue>(globalObject, decoder);
    case MessageName::NetworkConnectionToWebProcess_SetRawCookie:
        return jsValueForDecodedMessage<MessageName::NetworkConnectionToWebProcess_SetRawCookie>(globalObject, decoder);
    case MessageName::NetworkConnectionToWebProcess_GetRawCookies:
        return jsValueForDecodedMessage<MessageName::NetworkConnectionToWebProcess_GetRawCookies>(globalObject, decoder);
    case MessageName::NetworkConnectionToWebProcess_DeleteCookie:
        return jsValueForDecodedMessage<MessageName::NetworkConnectionToWebProcess_DeleteCookie>(globalObject, decoder);
    case MessageName::NetworkConnectionToWebProcess_DomCookiesForHost:
        return jsValueForDecodedMessage<MessageName::NetworkConnectionToWebProcess_DomCookiesForHost>(globalObject, decoder);
    case MessageName::NetworkConnectionToWebProcess_CookiesForDOMAsync:
        return jsValueForDecodedMessage<MessageName::NetworkConnectionToWebProcess_CookiesForDOMAsync>(globalObject, decoder);
    case MessageName::NetworkConnectionToWebProcess_SetCookieFromDOMAsync:
        return jsValueForDecodedMessage<MessageName::NetworkConnectionToWebProcess_SetCookieFromDOMAsync>(globalObject, decoder);
#if HAVE(COOKIE_CHANGE_LISTENER_API)
    case MessageName::NetworkConnectionToWebProcess_SubscribeToCookieChangeNotifications:
        return jsValueForDecodedMessage<MessageName::NetworkConnectionToWebProcess_SubscribeToCookieChangeNotifications>(globalObject, decoder);
    case MessageName::NetworkConnectionToWebProcess_UnsubscribeFromCookieChangeNotifications:
        return jsValueForDecodedMessage<MessageName::NetworkConnectionToWebProcess_UnsubscribeFromCookieChangeNotifications>(globalObject, decoder);
#endif
    case MessageName::NetworkConnectionToWebProcess_RegisterInternalFileBlobURL:
        return jsValueForDecodedMessage<MessageName::NetworkConnectionToWebProcess_RegisterInternalFileBlobURL>(globalObject, decoder);
    case MessageName::NetworkConnectionToWebProcess_RegisterInternalBlobURL:
        return jsValueForDecodedMessage<MessageName::NetworkConnectionToWebProcess_RegisterInternalBlobURL>(globalObject, decoder);
    case MessageName::NetworkConnectionToWebProcess_RegisterBlobURL:
        return jsValueForDecodedMessage<MessageName::NetworkConnectionToWebProcess_RegisterBlobURL>(globalObject, decoder);
    case MessageName::NetworkConnectionToWebProcess_RegisterInternalBlobURLOptionallyFileBacked:
        return jsValueForDecodedMessage<MessageName::NetworkConnectionToWebProcess_RegisterInternalBlobURLOptionallyFileBacked>(globalObject, decoder);
    case MessageName::NetworkConnectionToWebProcess_RegisterInternalBlobURLForSlice:
        return jsValueForDecodedMessage<MessageName::NetworkConnectionToWebProcess_RegisterInternalBlobURLForSlice>(globalObject, decoder);
    case MessageName::NetworkConnectionToWebProcess_UnregisterBlobURL:
        return jsValueForDecodedMessage<MessageName::NetworkConnectionToWebProcess_UnregisterBlobURL>(globalObject, decoder);
    case MessageName::NetworkConnectionToWebProcess_BlobType:
        return jsValueForDecodedMessage<MessageName::NetworkConnectionToWebProcess_BlobType>(globalObject, decoder);
    case MessageName::NetworkConnectionToWebProcess_BlobSize:
        return jsValueForDecodedMessage<MessageName::NetworkConnectionToWebProcess_BlobSize>(globalObject, decoder);
    case MessageName::NetworkConnectionToWebProcess_WriteBlobsToTemporaryFilesForIndexedDB:
        return jsValueForDecodedMessage<MessageName::NetworkConnectionToWebProcess_WriteBlobsToTemporaryFilesForIndexedDB>(globalObject, decoder);
    case MessageName::NetworkConnectionToWebProcess_RegisterBlobURLHandle:
        return jsValueForDecodedMessage<MessageName::NetworkConnectionToWebProcess_RegisterBlobURLHandle>(globalObject, decoder);
    case MessageName::NetworkConnectionToWebProcess_UnregisterBlobURLHandle:
        return jsValueForDecodedMessage<MessageName::NetworkConnectionToWebProcess_UnregisterBlobURLHandle>(globalObject, decoder);
    case MessageName::NetworkConnectionToWebProcess_RegisterBlobPathForTesting:
        return jsValueForDecodedMessage<MessageName::NetworkConnectionToWebProcess_RegisterBlobPathForTesting>(globalObject, decoder);
    case MessageName::NetworkConnectionToWebProcess_SetCaptureExtraNetworkLoadMetricsEnabled:
        return jsValueForDecodedMessage<MessageName::NetworkConnectionToWebProcess_SetCaptureExtraNetworkLoadMetricsEnabled>(globalObject, decoder);
    case MessageName::NetworkConnectionToWebProcess_CreateSocketChannel:
        return jsValueForDecodedMessage<MessageName::NetworkConnectionToWebProcess_CreateSocketChannel>(globalObject, decoder);
    case MessageName::NetworkConnectionToWebProcess_ClearPageSpecificData:
        return jsValueForDecodedMessage<MessageName::NetworkConnectionToWebProcess_ClearPageSpecificData>(globalObject, decoder);
    case MessageName::NetworkConnectionToWebProcess_RemoveStorageAccessForFrame:
        return jsValueForDecodedMessage<MessageName::NetworkConnectionToWebProcess_RemoveStorageAccessForFrame>(globalObject, decoder);
    case MessageName::NetworkConnectionToWebProcess_LogUserInteraction:
        return jsValueForDecodedMessage<MessageName::NetworkConnectionToWebProcess_LogUserInteraction>(globalObject, decoder);
    case MessageName::NetworkConnectionToWebProcess_ResourceLoadStatisticsUpdated:
        return jsValueForDecodedMessage<MessageName::NetworkConnectionToWebProcess_ResourceLoadStatisticsUpdated>(globalObject, decoder);
    case MessageName::NetworkConnectionToWebProcess_HasStorageAccess:
        return jsValueForDecodedMessage<MessageName::NetworkConnectionToWebProcess_HasStorageAccess>(globalObject, decoder);
    case MessageName::NetworkConnectionToWebProcess_RequestStorageAccess:
        return jsValueForDecodedMessage<MessageName::NetworkConnectionToWebProcess_RequestStorageAccess>(globalObject, decoder);
    case MessageName::NetworkConnectionToWebProcess_StorageAccessQuirkForTopFrameDomain:
        return jsValueForDecodedMessage<MessageName::NetworkConnectionToWebProcess_StorageAccessQuirkForTopFrameDomain>(globalObject, decoder);
    case MessageName::NetworkConnectionToWebProcess_RequestStorageAccessUnderOpener:
        return jsValueForDecodedMessage<MessageName::NetworkConnectionToWebProcess_RequestStorageAccessUnderOpener>(globalObject, decoder);
    case MessageName::NetworkConnectionToWebProcess_AddOriginAccessAllowListEntry:
        return jsValueForDecodedMessage<MessageName::NetworkConnectionToWebProcess_AddOriginAccessAllowListEntry>(globalObject, decoder);
    case MessageName::NetworkConnectionToWebProcess_RemoveOriginAccessAllowListEntry:
        return jsValueForDecodedMessage<MessageName::NetworkConnectionToWebProcess_RemoveOriginAccessAllowListEntry>(globalObject, decoder);
    case MessageName::NetworkConnectionToWebProcess_ResetOriginAccessAllowLists:
        return jsValueForDecodedMessage<MessageName::NetworkConnectionToWebProcess_ResetOriginAccessAllowLists>(globalObject, decoder);
    case MessageName::NetworkConnectionToWebProcess_GetNetworkLoadInformationResponse:
        return jsValueForDecodedMessage<MessageName::NetworkConnectionToWebProcess_GetNetworkLoadInformationResponse>(globalObject, decoder);
    case MessageName::NetworkConnectionToWebProcess_GetNetworkLoadIntermediateInformation:
        return jsValueForDecodedMessage<MessageName::NetworkConnectionToWebProcess_GetNetworkLoadIntermediateInformation>(globalObject, decoder);
    case MessageName::NetworkConnectionToWebProcess_TakeNetworkLoadInformationMetrics:
        return jsValueForDecodedMessage<MessageName::NetworkConnectionToWebProcess_TakeNetworkLoadInformationMetrics>(globalObject, decoder);
    case MessageName::NetworkConnectionToWebProcess_EstablishSWContextConnection:
        return jsValueForDecodedMessage<MessageName::NetworkConnectionToWebProcess_EstablishSWContextConnection>(globalObject, decoder);
    case MessageName::NetworkConnectionToWebProcess_CloseSWContextConnection:
        return jsValueForDecodedMessage<MessageName::NetworkConnectionToWebProcess_CloseSWContextConnection>(globalObject, decoder);
    case MessageName::NetworkConnectionToWebProcess_PingPongForServiceWorkers:
        return jsValueForDecodedMessage<MessageName::NetworkConnectionToWebProcess_PingPongForServiceWorkers>(globalObject, decoder);
    case MessageName::NetworkConnectionToWebProcess_EstablishSharedWorkerContextConnection:
        return jsValueForDecodedMessage<MessageName::NetworkConnectionToWebProcess_EstablishSharedWorkerContextConnection>(globalObject, decoder);
    case MessageName::NetworkConnectionToWebProcess_CloseSharedWorkerContextConnection:
        return jsValueForDecodedMessage<MessageName::NetworkConnectionToWebProcess_CloseSharedWorkerContextConnection>(globalObject, decoder);
    case MessageName::NetworkConnectionToWebProcess_CreateRTCProvider:
        return jsValueForDecodedMessage<MessageName::NetworkConnectionToWebProcess_CreateRTCProvider>(globalObject, decoder);
#if ENABLE(WEB_RTC)
    case MessageName::NetworkConnectionToWebProcess_ConnectToRTCDataChannelRemoteSource:
        return jsValueForDecodedMessage<MessageName::NetworkConnectionToWebProcess_ConnectToRTCDataChannelRemoteSource>(globalObject, decoder);
#endif
    case MessageName::NetworkConnectionToWebProcess_CreateNewMessagePortChannel:
        return jsValueForDecodedMessage<MessageName::NetworkConnectionToWebProcess_CreateNewMessagePortChannel>(globalObject, decoder);
    case MessageName::NetworkConnectionToWebProcess_EntangleLocalPortInThisProcessToRemote:
        return jsValueForDecodedMessage<MessageName::NetworkConnectionToWebProcess_EntangleLocalPortInThisProcessToRemote>(globalObject, decoder);
    case MessageName::NetworkConnectionToWebProcess_MessagePortDisentangled:
        return jsValueForDecodedMessage<MessageName::NetworkConnectionToWebProcess_MessagePortDisentangled>(globalObject, decoder);
    case MessageName::NetworkConnectionToWebProcess_MessagePortClosed:
        return jsValueForDecodedMessage<MessageName::NetworkConnectionToWebProcess_MessagePortClosed>(globalObject, decoder);
    case MessageName::NetworkConnectionToWebProcess_TakeAllMessagesForPort:
        return jsValueForDecodedMessage<MessageName::NetworkConnectionToWebProcess_TakeAllMessagesForPort>(globalObject, decoder);
    case MessageName::NetworkConnectionToWebProcess_PostMessageToRemote:
        return jsValueForDecodedMessage<MessageName::NetworkConnectionToWebProcess_PostMessageToRemote>(globalObject, decoder);
    case MessageName::NetworkConnectionToWebProcess_DidDeliverMessagePortMessages:
        return jsValueForDecodedMessage<MessageName::NetworkConnectionToWebProcess_DidDeliverMessagePortMessages>(globalObject, decoder);
    case MessageName::NetworkConnectionToWebProcess_RegisterURLSchemesAsCORSEnabled:
        return jsValueForDecodedMessage<MessageName::NetworkConnectionToWebProcess_RegisterURLSchemesAsCORSEnabled>(globalObject, decoder);
    case MessageName::NetworkConnectionToWebProcess_SetCORSDisablingPatterns:
        return jsValueForDecodedMessage<MessageName::NetworkConnectionToWebProcess_SetCORSDisablingPatterns>(globalObject, decoder);
#if PLATFORM(MAC)
    case MessageName::NetworkConnectionToWebProcess_GetProcessDisplayName:
        return jsValueForDecodedMessage<MessageName::NetworkConnectionToWebProcess_GetProcessDisplayName>(globalObject, decoder);
    case MessageName::NetworkConnectionToWebProcess_UpdateActivePages:
        return jsValueForDecodedMessage<MessageName::NetworkConnectionToWebProcess_UpdateActivePages>(globalObject, decoder);
#endif
#if (PLATFORM(MAC) && ENABLE(LAUNCHSERVICES_SANDBOX_EXTENSION_BLOCKING))
    case MessageName::NetworkConnectionToWebProcess_CheckInWebProcess:
        return jsValueForDecodedMessage<MessageName::NetworkConnectionToWebProcess_CheckInWebProcess>(globalObject, decoder);
#endif
    case MessageName::NetworkConnectionToWebProcess_SetResourceLoadSchedulingMode:
        return jsValueForDecodedMessage<MessageName::NetworkConnectionToWebProcess_SetResourceLoadSchedulingMode>(globalObject, decoder);
    case MessageName::NetworkConnectionToWebProcess_PrioritizeResourceLoads:
        return jsValueForDecodedMessage<MessageName::NetworkConnectionToWebProcess_PrioritizeResourceLoads>(globalObject, decoder);
#if ENABLE(CONTENT_FILTERING)
    case MessageName::NetworkConnectionToWebProcess_InstallMockContentFilter:
        return jsValueForDecodedMessage<MessageName::NetworkConnectionToWebProcess_InstallMockContentFilter>(globalObject, decoder);
#endif
    case MessageName::NetworkConnectionToWebProcess_UseRedirectionForCurrentNavigation:
        return jsValueForDecodedMessage<MessageName::NetworkConnectionToWebProcess_UseRedirectionForCurrentNavigation>(globalObject, decoder);
#if ENABLE(DECLARATIVE_WEB_PUSH)
    case MessageName::NetworkConnectionToWebProcess_NavigatorSubscribeToPushService:
        return jsValueForDecodedMessage<MessageName::NetworkConnectionToWebProcess_NavigatorSubscribeToPushService>(globalObject, decoder);
    case MessageName::NetworkConnectionToWebProcess_NavigatorUnsubscribeFromPushService:
        return jsValueForDecodedMessage<MessageName::NetworkConnectionToWebProcess_NavigatorUnsubscribeFromPushService>(globalObject, decoder);
    case MessageName::NetworkConnectionToWebProcess_NavigatorGetPushSubscription:
        return jsValueForDecodedMessage<MessageName::NetworkConnectionToWebProcess_NavigatorGetPushSubscription>(globalObject, decoder);
    case MessageName::NetworkConnectionToWebProcess_NavigatorGetPushPermissionState:
        return jsValueForDecodedMessage<MessageName::NetworkConnectionToWebProcess_NavigatorGetPushPermissionState>(globalObject, decoder);
#endif
    case MessageName::NetworkConnectionToWebProcess_InitializeWebTransportSession:
        return jsValueForDecodedMessage<MessageName::NetworkConnectionToWebProcess_InitializeWebTransportSession>(globalObject, decoder);
    case MessageName::NetworkConnectionToWebProcess_DestroyWebTransportSession:
        return jsValueForDecodedMessage<MessageName::NetworkConnectionToWebProcess_DestroyWebTransportSession>(globalObject, decoder);
    case MessageName::NetworkConnectionToWebProcess_ClearFrameLoadRecordsForStorageAccess:
        return jsValueForDecodedMessage<MessageName::NetworkConnectionToWebProcess_ClearFrameLoadRecordsForStorageAccess>(globalObject, decoder);
    case MessageName::NetworkConnectionToWebProcess_LoadImageForDecoding:
        return jsValueForDecodedMessage<MessageName::NetworkConnectionToWebProcess_LoadImageForDecoding>(globalObject, decoder);
    case MessageName::NetworkConnectionToWebProcess_SetLoginStatus:
        return jsValueForDecodedMessage<MessageName::NetworkConnectionToWebProcess_SetLoginStatus>(globalObject, decoder);
    case MessageName::NetworkConnectionToWebProcess_IsLoggedIn:
        return jsValueForDecodedMessage<MessageName::NetworkConnectionToWebProcess_IsLoggedIn>(globalObject, decoder);
#if ENABLE(CONTENT_EXTENSIONS)
    case MessageName::NetworkConnectionToWebProcess_ShouldOffloadIFrameForHost:
        return jsValueForDecodedMessage<MessageName::NetworkConnectionToWebProcess_ShouldOffloadIFrameForHost>(globalObject, decoder);
#endif
#if ENABLE(CONTENT_EXTENSIONS)
    case MessageName::NetworkContentRuleListManager_Remove:
        return jsValueForDecodedMessage<MessageName::NetworkContentRuleListManager_Remove>(globalObject, decoder);
    case MessageName::NetworkContentRuleListManager_AddContentRuleLists:
        return jsValueForDecodedMessage<MessageName::NetworkContentRuleListManager_AddContentRuleLists>(globalObject, decoder);
    case MessageName::NetworkContentRuleListManager_RemoveContentRuleList:
        return jsValueForDecodedMessage<MessageName::NetworkContentRuleListManager_RemoveContentRuleList>(globalObject, decoder);
    case MessageName::NetworkContentRuleListManager_RemoveAllContentRuleLists:
        return jsValueForDecodedMessage<MessageName::NetworkContentRuleListManager_RemoveAllContentRuleLists>(globalObject, decoder);
#endif
    case MessageName::NetworkProcess_InitializeNetworkProcess:
        return jsValueForDecodedMessage<MessageName::NetworkProcess_InitializeNetworkProcess>(globalObject, decoder);
    case MessageName::NetworkProcess_CreateNetworkConnectionToWebProcess:
        return jsValueForDecodedMessage<MessageName::NetworkProcess_CreateNetworkConnectionToWebProcess>(globalObject, decoder);
    case MessageName::NetworkProcess_SharedPreferencesForWebProcessDidChange:
        return jsValueForDecodedMessage<MessageName::NetworkProcess_SharedPreferencesForWebProcessDidChange>(globalObject, decoder);
    case MessageName::NetworkProcess_AddAllowedFirstPartyForCookies:
        return jsValueForDecodedMessage<MessageName::NetworkProcess_AddAllowedFirstPartyForCookies>(globalObject, decoder);
#if USE(SOUP)
    case MessageName::NetworkProcess_SetIgnoreTLSErrors:
        return jsValueForDecodedMessage<MessageName::NetworkProcess_SetIgnoreTLSErrors>(globalObject, decoder);
    case MessageName::NetworkProcess_UserPreferredLanguagesChanged:
        return jsValueForDecodedMessage<MessageName::NetworkProcess_UserPreferredLanguagesChanged>(globalObject, decoder);
    case MessageName::NetworkProcess_SetNetworkProxySettings:
        return jsValueForDecodedMessage<MessageName::NetworkProcess_SetNetworkProxySettings>(globalObject, decoder);
    case MessageName::NetworkProcess_PrefetchDNS:
        return jsValueForDecodedMessage<MessageName::NetworkProcess_PrefetchDNS>(globalObject, decoder);
    case MessageName::NetworkProcess_SetPersistentCredentialStorageEnabled:
        return jsValueForDecodedMessage<MessageName::NetworkProcess_SetPersistentCredentialStorageEnabled>(globalObject, decoder);
#endif
#if USE(CURL)
    case MessageName::NetworkProcess_SetNetworkProxySettings:
        return jsValueForDecodedMessage<MessageName::NetworkProcess_SetNetworkProxySettings>(globalObject, decoder);
#endif
    case MessageName::NetworkProcess_AddWebsiteDataStore:
        return jsValueForDecodedMessage<MessageName::NetworkProcess_AddWebsiteDataStore>(globalObject, decoder);
    case MessageName::NetworkProcess_DestroySession:
        return jsValueForDecodedMessage<MessageName::NetworkProcess_DestroySession>(globalObject, decoder);
    case MessageName::NetworkProcess_EnsureSessionWithDataStoreIdentifierRemoved:
        return jsValueForDecodedMessage<MessageName::NetworkProcess_EnsureSessionWithDataStoreIdentifierRemoved>(globalObject, decoder);
    case MessageName::NetworkProcess_FetchWebsiteData:
        return jsValueForDecodedMessage<MessageName::NetworkProcess_FetchWebsiteData>(globalObject, decoder);
    case MessageName::NetworkProcess_DeleteWebsiteData:
        return jsValueForDecodedMessage<MessageName::NetworkProcess_DeleteWebsiteData>(globalObject, decoder);
    case MessageName::NetworkProcess_DeleteWebsiteDataForOrigins:
        return jsValueForDecodedMessage<MessageName::NetworkProcess_DeleteWebsiteDataForOrigins>(globalObject, decoder);
    case MessageName::NetworkProcess_RenameOriginInWebsiteData:
        return jsValueForDecodedMessage<MessageName::NetworkProcess_RenameOriginInWebsiteData>(globalObject, decoder);
    case MessageName::NetworkProcess_WebsiteDataOriginDirectoryForTesting:
        return jsValueForDecodedMessage<MessageName::NetworkProcess_WebsiteDataOriginDirectoryForTesting>(globalObject, decoder);
    case MessageName::NetworkProcess_DownloadRequest:
        return jsValueForDecodedMessage<MessageName::NetworkProcess_DownloadRequest>(globalObject, decoder);
    case MessageName::NetworkProcess_ResumeDownload:
        return jsValueForDecodedMessage<MessageName::NetworkProcess_ResumeDownload>(globalObject, decoder);
    case MessageName::NetworkProcess_CancelDownload:
        return jsValueForDecodedMessage<MessageName::NetworkProcess_CancelDownload>(globalObject, decoder);
#if (PLATFORM(COCOA) && HAVE(MODERN_DOWNLOADPROGRESS))
    case MessageName::NetworkProcess_PublishDownloadProgress:
        return jsValueForDecodedMessage<MessageName::NetworkProcess_PublishDownloadProgress>(globalObject, decoder);
#endif
#if (PLATFORM(COCOA) && !HAVE(MODERN_DOWNLOADPROGRESS))
    case MessageName::NetworkProcess_PublishDownloadProgress:
        return jsValueForDecodedMessage<MessageName::NetworkProcess_PublishDownloadProgress>(globalObject, decoder);
#endif
    case MessageName::NetworkProcess_DataTaskWithRequest:
        return jsValueForDecodedMessage<MessageName::NetworkProcess_DataTaskWithRequest>(globalObject, decoder);
    case MessageName::NetworkProcess_CancelDataTask:
        return jsValueForDecodedMessage<MessageName::NetworkProcess_CancelDataTask>(globalObject, decoder);
    case MessageName::NetworkProcess_ApplicationDidEnterBackground:
        return jsValueForDecodedMessage<MessageName::NetworkProcess_ApplicationDidEnterBackground>(globalObject, decoder);
    case MessageName::NetworkProcess_ApplicationWillEnterForeground:
        return jsValueForDecodedMessage<MessageName::NetworkProcess_ApplicationWillEnterForeground>(globalObject, decoder);
    case MessageName::NetworkProcess_FlushCookies:
        return jsValueForDecodedMessage<MessageName::NetworkProcess_FlushCookies>(globalObject, decoder);
#if !PLATFORM(COCOA)
    case MessageName::NetworkProcess_AllowSpecificHTTPSCertificateForHost:
        return jsValueForDecodedMessage<MessageName::NetworkProcess_AllowSpecificHTTPSCertificateForHost>(globalObject, decoder);
#endif
    case MessageName::NetworkProcess_AllowTLSCertificateChainForLocalPCMTesting:
        return jsValueForDecodedMessage<MessageName::NetworkProcess_AllowTLSCertificateChainForLocalPCMTesting>(globalObject, decoder);
    case MessageName::NetworkProcess_SetCacheModel:
        return jsValueForDecodedMessage<MessageName::NetworkProcess_SetCacheModel>(globalObject, decoder);
    case MessageName::NetworkProcess_SetCacheModelSynchronouslyForTesting:
        return jsValueForDecodedMessage<MessageName::NetworkProcess_SetCacheModelSynchronouslyForTesting>(globalObject, decoder);
    case MessageName::NetworkProcess_ProcessWillSuspendImminentlyForTestingSync:
        return jsValueForDecodedMessage<MessageName::NetworkProcess_ProcessWillSuspendImminentlyForTestingSync>(globalObject, decoder);
    case MessageName::NetworkProcess_PrepareToSuspend:
        return jsValueForDecodedMessage<MessageName::NetworkProcess_PrepareToSuspend>(globalObject, decoder);
    case MessageName::NetworkProcess_ProcessDidResume:
        return jsValueForDecodedMessage<MessageName::NetworkProcess_ProcessDidResume>(globalObject, decoder);
    case MessageName::NetworkProcess_NotifyMediaStreamingActivity:
        return jsValueForDecodedMessage<MessageName::NetworkProcess_NotifyMediaStreamingActivity>(globalObject, decoder);
    case MessageName::NetworkProcess_PreconnectTo:
        return jsValueForDecodedMessage<MessageName::NetworkProcess_PreconnectTo>(globalObject, decoder);
    case MessageName::NetworkProcess_SetInspectionForServiceWorkersAllowed:
        return jsValueForDecodedMessage<MessageName::NetworkProcess_SetInspectionForServiceWorkersAllowed>(globalObject, decoder);
    case MessageName::NetworkProcess_ClearPrevalentResource:
        return jsValueForDecodedMessage<MessageName::NetworkProcess_ClearPrevalentResource>(globalObject, decoder);
    case MessageName::NetworkProcess_ClearUserInteraction:
        return jsValueForDecodedMessage<MessageName::NetworkProcess_ClearUserInteraction>(globalObject, decoder);
    case MessageName::NetworkProcess_DumpResourceLoadStatistics:
        return jsValueForDecodedMessage<MessageName::NetworkProcess_DumpResourceLoadStatistics>(globalObject, decoder);
    case MessageName::NetworkProcess_SetTrackingPreventionEnabled:
        return jsValueForDecodedMessage<MessageName::NetworkProcess_SetTrackingPreventionEnabled>(globalObject, decoder);
    case MessageName::NetworkProcess_UpdateStorageAccessPromptQuirks:
        return jsValueForDecodedMessage<MessageName::NetworkProcess_UpdateStorageAccessPromptQuirks>(globalObject, decoder);
    case MessageName::NetworkProcess_SetResourceLoadStatisticsLogTestingEvent:
        return jsValueForDecodedMessage<MessageName::NetworkProcess_SetResourceLoadStatisticsLogTestingEvent>(globalObject, decoder);
    case MessageName::NetworkProcess_UpdatePrevalentDomainsToBlockCookiesFor:
        return jsValueForDecodedMessage<MessageName::NetworkProcess_UpdatePrevalentDomainsToBlockCookiesFor>(globalObject, decoder);
    case MessageName::NetworkProcess_IsGrandfathered:
        return jsValueForDecodedMessage<MessageName::NetworkProcess_IsGrandfathered>(globalObject, decoder);
    case MessageName::NetworkProcess_IsPrevalentResource:
        return jsValueForDecodedMessage<MessageName::NetworkProcess_IsPrevalentResource>(globalObject, decoder);
    case MessageName::NetworkProcess_IsVeryPrevalentResource:
        return jsValueForDecodedMessage<MessageName::NetworkProcess_IsVeryPrevalentResource>(globalObject, decoder);
    case MessageName::NetworkProcess_SetLastSeen:
        return jsValueForDecodedMessage<MessageName::NetworkProcess_SetLastSeen>(globalObject, decoder);
    case MessageName::NetworkProcess_MergeStatisticForTesting:
        return jsValueForDecodedMessage<MessageName::NetworkProcess_MergeStatisticForTesting>(globalObject, decoder);
    case MessageName::NetworkProcess_InsertExpiredStatisticForTesting:
        return jsValueForDecodedMessage<MessageName::NetworkProcess_InsertExpiredStatisticForTesting>(globalObject, decoder);
    case MessageName::NetworkProcess_SetPrevalentResource:
        return jsValueForDecodedMessage<MessageName::NetworkProcess_SetPrevalentResource>(globalObject, decoder);
    case MessageName::NetworkProcess_SetPrevalentResourceForDebugMode:
        return jsValueForDecodedMessage<MessageName::NetworkProcess_SetPrevalentResourceForDebugMode>(globalObject, decoder);
    case MessageName::NetworkProcess_IsResourceLoadStatisticsEphemeral:
        return jsValueForDecodedMessage<MessageName::NetworkProcess_IsResourceLoadStatisticsEphemeral>(globalObject, decoder);
    case MessageName::NetworkProcess_HadUserInteraction:
        return jsValueForDecodedMessage<MessageName::NetworkProcess_HadUserInteraction>(globalObject, decoder);
    case MessageName::NetworkProcess_IsRelationshipOnlyInDatabaseOnce:
        return jsValueForDecodedMessage<MessageName::NetworkProcess_IsRelationshipOnlyInDatabaseOnce>(globalObject, decoder);
    case MessageName::NetworkProcess_HasLocalStorage:
        return jsValueForDecodedMessage<MessageName::NetworkProcess_HasLocalStorage>(globalObject, decoder);
    case MessageName::NetworkProcess_GetAllStorageAccessEntries:
        return jsValueForDecodedMessage<MessageName::NetworkProcess_GetAllStorageAccessEntries>(globalObject, decoder);
    case MessageName::NetworkProcess_IsRegisteredAsRedirectingTo:
        return jsValueForDecodedMessage<MessageName::NetworkProcess_IsRegisteredAsRedirectingTo>(globalObject, decoder);
    case MessageName::NetworkProcess_IsRegisteredAsSubFrameUnder:
        return jsValueForDecodedMessage<MessageName::NetworkProcess_IsRegisteredAsSubFrameUnder>(globalObject, decoder);
    case MessageName::NetworkProcess_IsRegisteredAsSubresourceUnder:
        return jsValueForDecodedMessage<MessageName::NetworkProcess_IsRegisteredAsSubresourceUnder>(globalObject, decoder);
    case MessageName::NetworkProcess_DomainIDExistsInDatabase:
        return jsValueForDecodedMessage<MessageName::NetworkProcess_DomainIDExistsInDatabase>(globalObject, decoder);
    case MessageName::NetworkProcess_LogFrameNavigation:
        return jsValueForDecodedMessage<MessageName::NetworkProcess_LogFrameNavigation>(globalObject, decoder);
    case MessageName::NetworkProcess_LogUserInteraction:
        return jsValueForDecodedMessage<MessageName::NetworkProcess_LogUserInteraction>(globalObject, decoder);
    case MessageName::NetworkProcess_ResetParametersToDefaultValues:
        return jsValueForDecodedMessage<MessageName::NetworkProcess_ResetParametersToDefaultValues>(globalObject, decoder);
    case MessageName::NetworkProcess_ScheduleClearInMemoryAndPersistent:
        return jsValueForDecodedMessage<MessageName::NetworkProcess_ScheduleClearInMemoryAndPersistent>(globalObject, decoder);
    case MessageName::NetworkProcess_ScheduleCookieBlockingUpdate:
        return jsValueForDecodedMessage<MessageName::NetworkProcess_ScheduleCookieBlockingUpdate>(globalObject, decoder);
    case MessageName::NetworkProcess_ScheduleStatisticsAndDataRecordsProcessing:
        return jsValueForDecodedMessage<MessageName::NetworkProcess_ScheduleStatisticsAndDataRecordsProcessing>(globalObject, decoder);
    case MessageName::NetworkProcess_StatisticsDatabaseHasAllTables:
        return jsValueForDecodedMessage<MessageName::NetworkProcess_StatisticsDatabaseHasAllTables>(globalObject, decoder);
    case MessageName::NetworkProcess_SetCacheMaxAgeCapForPrevalentResources:
        return jsValueForDecodedMessage<MessageName::NetworkProcess_SetCacheMaxAgeCapForPrevalentResources>(globalObject, decoder);
    case MessageName::NetworkProcess_SetGrandfathered:
        return jsValueForDecodedMessage<MessageName::NetworkProcess_SetGrandfathered>(globalObject, decoder);
    case MessageName::NetworkProcess_GetResourceLoadStatisticsDataSummary:
        return jsValueForDecodedMessage<MessageName::NetworkProcess_GetResourceLoadStatisticsDataSummary>(globalObject, decoder);
    case MessageName::NetworkProcess_SetGrandfatheringTime:
        return jsValueForDecodedMessage<MessageName::NetworkProcess_SetGrandfatheringTime>(globalObject, decoder);
    case MessageName::NetworkProcess_SetMaxStatisticsEntries:
        return jsValueForDecodedMessage<MessageName::NetworkProcess_SetMaxStatisticsEntries>(globalObject, decoder);
    case MessageName::NetworkProcess_SetMinimumTimeBetweenDataRecordsRemoval:
        return jsValueForDecodedMessage<MessageName::NetworkProcess_SetMinimumTimeBetweenDataRecordsRemoval>(globalObject, decoder);
    case MessageName::NetworkProcess_SetPruneEntriesDownTo:
        return jsValueForDecodedMessage<MessageName::NetworkProcess_SetPruneEntriesDownTo>(globalObject, decoder);
    case MessageName::NetworkProcess_SetShouldClassifyResourcesBeforeDataRecordsRemoval:
        return jsValueForDecodedMessage<MessageName::NetworkProcess_SetShouldClassifyResourcesBeforeDataRecordsRemoval>(globalObject, decoder);
    case MessageName::NetworkProcess_SetResourceLoadStatisticsTimeAdvanceForTesting:
        return jsValueForDecodedMessage<MessageName::NetworkProcess_SetResourceLoadStatisticsTimeAdvanceForTesting>(globalObject, decoder);
    case MessageName::NetworkProcess_SetIsRunningResourceLoadStatisticsTest:
        return jsValueForDecodedMessage<MessageName::NetworkProcess_SetIsRunningResourceLoadStatisticsTest>(globalObject, decoder);
    case MessageName::NetworkProcess_SetResourceLoadStatisticsDebugMode:
        return jsValueForDecodedMessage<MessageName::NetworkProcess_SetResourceLoadStatisticsDebugMode>(globalObject, decoder);
    case MessageName::NetworkProcess_SetVeryPrevalentResource:
        return jsValueForDecodedMessage<MessageName::NetworkProcess_SetVeryPrevalentResource>(globalObject, decoder);
    case MessageName::NetworkProcess_SetSubframeUnderTopFrameDomain:
        return jsValueForDecodedMessage<MessageName::NetworkProcess_SetSubframeUnderTopFrameDomain>(globalObject, decoder);
    case MessageName::NetworkProcess_SetSubresourceUnderTopFrameDomain:
        return jsValueForDecodedMessage<MessageName::NetworkProcess_SetSubresourceUnderTopFrameDomain>(globalObject, decoder);
    case MessageName::NetworkProcess_SetSubresourceUniqueRedirectTo:
        return jsValueForDecodedMessage<MessageName::NetworkProcess_SetSubresourceUniqueRedirectTo>(globalObject, decoder);
    case MessageName::NetworkProcess_SetSubresourceUniqueRedirectFrom:
        return jsValueForDecodedMessage<MessageName::NetworkProcess_SetSubresourceUniqueRedirectFrom>(globalObject, decoder);
    case MessageName::NetworkProcess_SetTimeToLiveUserInteraction:
        return jsValueForDecodedMessage<MessageName::NetworkProcess_SetTimeToLiveUserInteraction>(globalObject, decoder);
    case MessageName::NetworkProcess_SetTopFrameUniqueRedirectTo:
        return jsValueForDecodedMessage<MessageName::NetworkProcess_SetTopFrameUniqueRedirectTo>(globalObject, decoder);
    case MessageName::NetworkProcess_SetTopFrameUniqueRedirectFrom:
        return jsValueForDecodedMessage<MessageName::NetworkProcess_SetTopFrameUniqueRedirectFrom>(globalObject, decoder);
    case MessageName::NetworkProcess_ResetCacheMaxAgeCapForPrevalentResources:
        return jsValueForDecodedMessage<MessageName::NetworkProcess_ResetCacheMaxAgeCapForPrevalentResources>(globalObject, decoder);
    case MessageName::NetworkProcess_DidCommitCrossSiteLoadWithDataTransfer:
        return jsValueForDecodedMessage<MessageName::NetworkProcess_DidCommitCrossSiteLoadWithDataTransfer>(globalObject, decoder);
    case MessageName::NetworkProcess_SetCrossSiteLoadWithLinkDecorationForTesting:
        return jsValueForDecodedMessage<MessageName::NetworkProcess_SetCrossSiteLoadWithLinkDecorationForTesting>(globalObject, decoder);
    case MessageName::NetworkProcess_ResetCrossSiteLoadsWithLinkDecorationForTesting:
        return jsValueForDecodedMessage<MessageName::NetworkProcess_ResetCrossSiteLoadsWithLinkDecorationForTesting>(globalObject, decoder);
    case MessageName::NetworkProcess_GrantStorageAccessForTesting:
        return jsValueForDecodedMessage<MessageName::NetworkProcess_GrantStorageAccessForTesting>(globalObject, decoder);
    case MessageName::NetworkProcess_SetStorageAccessPermissionForTesting:
        return jsValueForDecodedMessage<MessageName::NetworkProcess_SetStorageAccessPermissionForTesting>(globalObject, decoder);
    case MessageName::NetworkProcess_DeleteCookiesForTesting:
        return jsValueForDecodedMessage<MessageName::NetworkProcess_DeleteCookiesForTesting>(globalObject, decoder);
    case MessageName::NetworkProcess_HasIsolatedSession:
        return jsValueForDecodedMessage<MessageName::NetworkProcess_HasIsolatedSession>(globalObject, decoder);
    case MessageName::NetworkProcess_CloseITPDatabase:
        return jsValueForDecodedMessage<MessageName::NetworkProcess_CloseITPDatabase>(globalObject, decoder);
#if ENABLE(APP_BOUND_DOMAINS)
    case MessageName::NetworkProcess_SetAppBoundDomainsForResourceLoadStatistics:
        return jsValueForDecodedMessage<MessageName::NetworkProcess_SetAppBoundDomainsForResourceLoadStatistics>(globalObject, decoder);
#endif
#if ENABLE(MANAGED_DOMAINS)
    case MessageName::NetworkProcess_SetManagedDomainsForResourceLoadStatistics:
        return jsValueForDecodedMessage<MessageName::NetworkProcess_SetManagedDomainsForResourceLoadStatistics>(globalObject, decoder);
#endif
    case MessageName::NetworkProcess_SetShouldDowngradeReferrerForTesting:
        return jsValueForDecodedMessage<MessageName::NetworkProcess_SetShouldDowngradeReferrerForTesting>(globalObject, decoder);
    case MessageName::NetworkProcess_SetThirdPartyCookieBlockingMode:
        return jsValueForDecodedMessage<MessageName::NetworkProcess_SetThirdPartyCookieBlockingMode>(globalObject, decoder);
    case MessageName::NetworkProcess_SetShouldEnbleSameSiteStrictEnforcementForTesting:
        return jsValueForDecodedMessage<MessageName::NetworkProcess_SetShouldEnbleSameSiteStrictEnforcementForTesting>(globalObject, decoder);
    case MessageName::NetworkProcess_SetFirstPartyWebsiteDataRemovalModeForTesting:
        return jsValueForDecodedMessage<MessageName::NetworkProcess_SetFirstPartyWebsiteDataRemovalModeForTesting>(globalObject, decoder);
    case MessageName::NetworkProcess_SetToSameSiteStrictCookiesForTesting:
        return jsValueForDecodedMessage<MessageName::NetworkProcess_SetToSameSiteStrictCookiesForTesting>(globalObject, decoder);
    case MessageName::NetworkProcess_SetFirstPartyHostCNAMEDomainForTesting:
        return jsValueForDecodedMessage<MessageName::NetworkProcess_SetFirstPartyHostCNAMEDomainForTesting>(globalObject, decoder);
    case MessageName::NetworkProcess_SetThirdPartyCNAMEDomainForTesting:
        return jsValueForDecodedMessage<MessageName::NetworkProcess_SetThirdPartyCNAMEDomainForTesting>(globalObject, decoder);
    case MessageName::NetworkProcess_SetPrivateClickMeasurementDebugMode:
        return jsValueForDecodedMessage<MessageName::NetworkProcess_SetPrivateClickMeasurementDebugMode>(globalObject, decoder);
    case MessageName::NetworkProcess_SetShouldSendPrivateTokenIPCForTesting:
        return jsValueForDecodedMessage<MessageName::NetworkProcess_SetShouldSendPrivateTokenIPCForTesting>(globalObject, decoder);
#if HAVE(ALLOW_ONLY_PARTITIONED_COOKIES)
    case MessageName::NetworkProcess_SetOptInCookiePartitioningEnabled:
        return jsValueForDecodedMessage<MessageName::NetworkProcess_SetOptInCookiePartitioningEnabled>(globalObject, decoder);
#endif
    case MessageName::NetworkProcess_SetSessionIsControlledByAutomation:
        return jsValueForDecodedMessage<MessageName::NetworkProcess_SetSessionIsControlledByAutomation>(globalObject, decoder);
    case MessageName::NetworkProcess_RegisterURLSchemeAsSecure:
        return jsValueForDecodedMessage<MessageName::NetworkProcess_RegisterURLSchemeAsSecure>(globalObject, decoder);
    case MessageName::NetworkProcess_RegisterURLSchemeAsBypassingContentSecurityPolicy:
        return jsValueForDecodedMessage<MessageName::NetworkProcess_RegisterURLSchemeAsBypassingContentSecurityPolicy>(globalObject, decoder);
    case MessageName::NetworkProcess_RegisterURLSchemeAsLocal:
        return jsValueForDecodedMessage<MessageName::NetworkProcess_RegisterURLSchemeAsLocal>(globalObject, decoder);
#if ENABLE(ALL_LEGACY_REGISTERED_SPECIAL_URL_SCHEMES)
    case MessageName::NetworkProcess_RegisterURLSchemeAsNoAccess:
        return jsValueForDecodedMessage<MessageName::NetworkProcess_RegisterURLSchemeAsNoAccess>(globalObject, decoder);
#endif
    case MessageName::NetworkProcess_SyncLocalStorage:
        return jsValueForDecodedMessage<MessageName::NetworkProcess_SyncLocalStorage>(globalObject, decoder);
    case MessageName::NetworkProcess_StoreServiceWorkerRegistrations:
        return jsValueForDecodedMessage<MessageName::NetworkProcess_StoreServiceWorkerRegistrations>(globalObject, decoder);
    case MessageName::NetworkProcess_StorePrivateClickMeasurement:
        return jsValueForDecodedMessage<MessageName::NetworkProcess_StorePrivateClickMeasurement>(globalObject, decoder);
    case MessageName::NetworkProcess_DumpPrivateClickMeasurement:
        return jsValueForDecodedMessage<MessageName::NetworkProcess_DumpPrivateClickMeasurement>(globalObject, decoder);
    case MessageName::NetworkProcess_ClearPrivateClickMeasurement:
        return jsValueForDecodedMessage<MessageName::NetworkProcess_ClearPrivateClickMeasurement>(globalObject, decoder);
    case MessageName::NetworkProcess_SetPrivateClickMeasurementOverrideTimerForTesting:
        return jsValueForDecodedMessage<MessageName::NetworkProcess_SetPrivateClickMeasurementOverrideTimerForTesting>(globalObject, decoder);
    case MessageName::NetworkProcess_MarkAttributedPrivateClickMeasurementsAsExpiredForTesting:
        return jsValueForDecodedMessage<MessageName::NetworkProcess_MarkAttributedPrivateClickMeasurementsAsExpiredForTesting>(globalObject, decoder);
    case MessageName::NetworkProcess_SetPrivateClickMeasurementEphemeralMeasurementForTesting:
        return jsValueForDecodedMessage<MessageName::NetworkProcess_SetPrivateClickMeasurementEphemeralMeasurementForTesting>(globalObject, decoder);
    case MessageName::NetworkProcess_SimulatePrivateClickMeasurementSessionRestart:
        return jsValueForDecodedMessage<MessageName::NetworkProcess_SimulatePrivateClickMeasurementSessionRestart>(globalObject, decoder);
    case MessageName::NetworkProcess_SetPrivateClickMeasurementTokenPublicKeyURLForTesting:
        return jsValueForDecodedMessage<MessageName::NetworkProcess_SetPrivateClickMeasurementTokenPublicKeyURLForTesting>(globalObject, decoder);
    case MessageName::NetworkProcess_SetPrivateClickMeasurementTokenSignatureURLForTesting:
        return jsValueForDecodedMessage<MessageName::NetworkProcess_SetPrivateClickMeasurementTokenSignatureURLForTesting>(globalObject, decoder);
    case MessageName::NetworkProcess_SetPrivateClickMeasurementAttributionReportURLsForTesting:
        return jsValueForDecodedMessage<MessageName::NetworkProcess_SetPrivateClickMeasurementAttributionReportURLsForTesting>(globalObject, decoder);
    case MessageName::NetworkProcess_MarkPrivateClickMeasurementsAsExpiredForTesting:
        return jsValueForDecodedMessage<MessageName::NetworkProcess_MarkPrivateClickMeasurementsAsExpiredForTesting>(globalObject, decoder);
    case MessageName::NetworkProcess_SetPCMFraudPreventionValuesForTesting:
        return jsValueForDecodedMessage<MessageName::NetworkProcess_SetPCMFraudPreventionValuesForTesting>(globalObject, decoder);
    case MessageName::NetworkProcess_SetPrivateClickMeasurementAppBundleIDForTesting:
        return jsValueForDecodedMessage<MessageName::NetworkProcess_SetPrivateClickMeasurementAppBundleIDForTesting>(globalObject, decoder);
    case MessageName::NetworkProcess_ClosePCMDatabase:
        return jsValueForDecodedMessage<MessageName::NetworkProcess_ClosePCMDatabase>(globalObject, decoder);
    case MessageName::NetworkProcess_SetServiceWorkerFetchTimeoutForTesting:
        return jsValueForDecodedMessage<MessageName::NetworkProcess_SetServiceWorkerFetchTimeoutForTesting>(globalObject, decoder);
    case MessageName::NetworkProcess_ResetServiceWorkerFetchTimeoutForTesting:
        return jsValueForDecodedMessage<MessageName::NetworkProcess_ResetServiceWorkerFetchTimeoutForTesting>(globalObject, decoder);
    case MessageName::NetworkProcess_TerminateIdleServiceWorkers:
        return jsValueForDecodedMessage<MessageName::NetworkProcess_TerminateIdleServiceWorkers>(globalObject, decoder);
    case MessageName::NetworkProcess_ResetQuota:
        return jsValueForDecodedMessage<MessageName::NetworkProcess_ResetQuota>(globalObject, decoder);
    case MessageName::NetworkProcess_SetOriginQuotaRatioEnabledForTesting:
        return jsValueForDecodedMessage<MessageName::NetworkProcess_SetOriginQuotaRatioEnabledForTesting>(globalObject, decoder);
#if PLATFORM(IOS_FAMILY)
    case MessageName::NetworkProcess_SetBackupExclusionPeriodForTesting:
        return jsValueForDecodedMessage<MessageName::NetworkProcess_SetBackupExclusionPeriodForTesting>(globalObject, decoder);
#endif
    case MessageName::NetworkProcess_ResetStoragePersistedState:
        return jsValueForDecodedMessage<MessageName::NetworkProcess_ResetStoragePersistedState>(globalObject, decoder);
    case MessageName::NetworkProcess_CloneSessionStorageForWebPage:
        return jsValueForDecodedMessage<MessageName::NetworkProcess_CloneSessionStorageForWebPage>(globalObject, decoder);
    case MessageName::NetworkProcess_DidIncreaseQuota:
        return jsValueForDecodedMessage<MessageName::NetworkProcess_DidIncreaseQuota>(globalObject, decoder);
#if ENABLE(APP_BOUND_DOMAINS)
    case MessageName::NetworkProcess_HasAppBoundSession:
        return jsValueForDecodedMessage<MessageName::NetworkProcess_HasAppBoundSession>(globalObject, decoder);
    case MessageName::NetworkProcess_ClearAppBoundSession:
        return jsValueForDecodedMessage<MessageName::NetworkProcess_ClearAppBoundSession>(globalObject, decoder);
#endif
#if PLATFORM(IOS_FAMILY) && !PLATFORM(MACCATALYST)
    case MessageName::NetworkProcess_DisableServiceWorkerEntitlement:
        return jsValueForDecodedMessage<MessageName::NetworkProcess_DisableServiceWorkerEntitlement>(globalObject, decoder);
    case MessageName::NetworkProcess_ClearServiceWorkerEntitlementOverride:
        return jsValueForDecodedMessage<MessageName::NetworkProcess_ClearServiceWorkerEntitlementOverride>(globalObject, decoder);
#endif
    case MessageName::NetworkProcess_UpdateBundleIdentifier:
        return jsValueForDecodedMessage<MessageName::NetworkProcess_UpdateBundleIdentifier>(globalObject, decoder);
    case MessageName::NetworkProcess_ClearBundleIdentifier:
        return jsValueForDecodedMessage<MessageName::NetworkProcess_ClearBundleIdentifier>(globalObject, decoder);
#if PLATFORM(COCOA)
    case MessageName::NetworkProcess_AppPrivacyReportTestingData:
        return jsValueForDecodedMessage<MessageName::NetworkProcess_AppPrivacyReportTestingData>(globalObject, decoder);
    case MessageName::NetworkProcess_ClearAppPrivacyReportTestingData:
        return jsValueForDecodedMessage<MessageName::NetworkProcess_ClearAppPrivacyReportTestingData>(globalObject, decoder);
#endif
    case MessageName::NetworkProcess_AddWebPageNetworkParameters:
        return jsValueForDecodedMessage<MessageName::NetworkProcess_AddWebPageNetworkParameters>(globalObject, decoder);
    case MessageName::NetworkProcess_RemoveWebPageNetworkParameters:
        return jsValueForDecodedMessage<MessageName::NetworkProcess_RemoveWebPageNetworkParameters>(globalObject, decoder);
    case MessageName::NetworkProcess_CountNonDefaultSessionSets:
        return jsValueForDecodedMessage<MessageName::NetworkProcess_CountNonDefaultSessionSets>(globalObject, decoder);
    case MessageName::NetworkProcess_AllowFileAccessFromWebProcess:
        return jsValueForDecodedMessage<MessageName::NetworkProcess_AllowFileAccessFromWebProcess>(globalObject, decoder);
    case MessageName::NetworkProcess_AllowFilesAccessFromWebProcess:
        return jsValueForDecodedMessage<MessageName::NetworkProcess_AllowFilesAccessFromWebProcess>(globalObject, decoder);
    case MessageName::NetworkProcess_TerminateRemoteWorkerContextConnectionWhenPossible:
        return jsValueForDecodedMessage<MessageName::NetworkProcess_TerminateRemoteWorkerContextConnectionWhenPossible>(globalObject, decoder);
    case MessageName::NetworkProcess_RunningOrTerminatingServiceWorkerCountForTesting:
        return jsValueForDecodedMessage<MessageName::NetworkProcess_RunningOrTerminatingServiceWorkerCountForTesting>(globalObject, decoder);
    case MessageName::NetworkProcess_GetPendingPushMessage:
        return jsValueForDecodedMessage<MessageName::NetworkProcess_GetPendingPushMessage>(globalObject, decoder);
    case MessageName::NetworkProcess_GetPendingPushMessages:
        return jsValueForDecodedMessage<MessageName::NetworkProcess_GetPendingPushMessages>(globalObject, decoder);
    case MessageName::NetworkProcess_ProcessPushMessage:
        return jsValueForDecodedMessage<MessageName::NetworkProcess_ProcessPushMessage>(globalObject, decoder);
    case MessageName::NetworkProcess_ProcessNotificationEvent:
        return jsValueForDecodedMessage<MessageName::NetworkProcess_ProcessNotificationEvent>(globalObject, decoder);
    case MessageName::NetworkProcess_GetAllBackgroundFetchIdentifiers:
        return jsValueForDecodedMessage<MessageName::NetworkProcess_GetAllBackgroundFetchIdentifiers>(globalObject, decoder);
    case MessageName::NetworkProcess_GetBackgroundFetchState:
        return jsValueForDecodedMessage<MessageName::NetworkProcess_GetBackgroundFetchState>(globalObject, decoder);
    case MessageName::NetworkProcess_AbortBackgroundFetch:
        return jsValueForDecodedMessage<MessageName::NetworkProcess_AbortBackgroundFetch>(globalObject, decoder);
    case MessageName::NetworkProcess_PauseBackgroundFetch:
        return jsValueForDecodedMessage<MessageName::NetworkProcess_PauseBackgroundFetch>(globalObject, decoder);
    case MessageName::NetworkProcess_ResumeBackgroundFetch:
        return jsValueForDecodedMessage<MessageName::NetworkProcess_ResumeBackgroundFetch>(globalObject, decoder);
    case MessageName::NetworkProcess_ClickBackgroundFetch:
        return jsValueForDecodedMessage<MessageName::NetworkProcess_ClickBackgroundFetch>(globalObject, decoder);
    case MessageName::NetworkProcess_SetPushAndNotificationsEnabledForOrigin:
        return jsValueForDecodedMessage<MessageName::NetworkProcess_SetPushAndNotificationsEnabledForOrigin>(globalObject, decoder);
    case MessageName::NetworkProcess_RemovePushSubscriptionsForOrigin:
        return jsValueForDecodedMessage<MessageName::NetworkProcess_RemovePushSubscriptionsForOrigin>(globalObject, decoder);
    case MessageName::NetworkProcess_HasPushSubscriptionForTesting:
        return jsValueForDecodedMessage<MessageName::NetworkProcess_HasPushSubscriptionForTesting>(globalObject, decoder);
#if ENABLE(INSPECTOR_NETWORK_THROTTLING)
    case MessageName::NetworkProcess_SetEmulatedConditions:
        return jsValueForDecodedMessage<MessageName::NetworkProcess_SetEmulatedConditions>(globalObject, decoder);
#endif
#if HAVE(NW_PROXY_CONFIG)
    case MessageName::NetworkProcess_ClearProxyConfigData:
        return jsValueForDecodedMessage<MessageName::NetworkProcess_ClearProxyConfigData>(globalObject, decoder);
    case MessageName::NetworkProcess_SetProxyConfigData:
        return jsValueForDecodedMessage<MessageName::NetworkProcess_SetProxyConfigData>(globalObject, decoder);
#endif
    case MessageName::NetworkProcess_SetStorageSiteValidationEnabled:
        return jsValueForDecodedMessage<MessageName::NetworkProcess_SetStorageSiteValidationEnabled>(globalObject, decoder);
    case MessageName::NetworkProcess_SetPersistedDomains:
        return jsValueForDecodedMessage<MessageName::NetworkProcess_SetPersistedDomains>(globalObject, decoder);
    case MessageName::NetworkProcess_GetAppBadgeForTesting:
        return jsValueForDecodedMessage<MessageName::NetworkProcess_GetAppBadgeForTesting>(globalObject, decoder);
    case MessageName::NetworkProcess_FetchLocalStorage:
        return jsValueForDecodedMessage<MessageName::NetworkProcess_FetchLocalStorage>(globalObject, decoder);
    case MessageName::NetworkProcess_RestoreLocalStorage:
        return jsValueForDecodedMessage<MessageName::NetworkProcess_RestoreLocalStorage>(globalObject, decoder);
    case MessageName::NetworkProcess_FetchSessionStorage:
        return jsValueForDecodedMessage<MessageName::NetworkProcess_FetchSessionStorage>(globalObject, decoder);
    case MessageName::NetworkProcess_RestoreSessionStorage:
        return jsValueForDecodedMessage<MessageName::NetworkProcess_RestoreSessionStorage>(globalObject, decoder);
    case MessageName::NetworkProcess_SetShouldRelaxThirdPartyCookieBlockingForPage:
        return jsValueForDecodedMessage<MessageName::NetworkProcess_SetShouldRelaxThirdPartyCookieBlockingForPage>(globalObject, decoder);
#if ENABLE(CONTENT_EXTENSIONS)
    case MessageName::NetworkProcess_ResetResourceMonitorThrottlerForTesting:
        return jsValueForDecodedMessage<MessageName::NetworkProcess_ResetResourceMonitorThrottlerForTesting>(globalObject, decoder);
#endif
    case MessageName::NetworkProcess_SetDefaultRequestTimeoutInterval:
        return jsValueForDecodedMessage<MessageName::NetworkProcess_SetDefaultRequestTimeoutInterval>(globalObject, decoder);
    case MessageName::NetworkResourceLoader_ContinueDidReceiveResponse:
        return jsValueForDecodedMessage<MessageName::NetworkResourceLoader_ContinueDidReceiveResponse>(globalObject, decoder);
    case MessageName::NetworkSocketChannel_SendString:
        return jsValueForDecodedMessage<MessageName::NetworkSocketChannel_SendString>(globalObject, decoder);
    case MessageName::NetworkSocketChannel_SendData:
        return jsValueForDecodedMessage<MessageName::NetworkSocketChannel_SendData>(globalObject, decoder);
    case MessageName::NetworkSocketChannel_Close:
        return jsValueForDecodedMessage<MessageName::NetworkSocketChannel_Close>(globalObject, decoder);
    case MessageName::ServiceWorkerDownloadTask_DidFail:
        return jsValueForDecodedMessage<MessageName::ServiceWorkerDownloadTask_DidFail>(globalObject, decoder);
    case MessageName::ServiceWorkerDownloadTask_DidReceiveData:
        return jsValueForDecodedMessage<MessageName::ServiceWorkerDownloadTask_DidReceiveData>(globalObject, decoder);
    case MessageName::ServiceWorkerDownloadTask_DidReceiveFormData:
        return jsValueForDecodedMessage<MessageName::ServiceWorkerDownloadTask_DidReceiveFormData>(globalObject, decoder);
    case MessageName::ServiceWorkerDownloadTask_DidFinish:
        return jsValueForDecodedMessage<MessageName::ServiceWorkerDownloadTask_DidFinish>(globalObject, decoder);
    case MessageName::ServiceWorkerFetchTask_DidNotHandle:
        return jsValueForDecodedMessage<MessageName::ServiceWorkerFetchTask_DidNotHandle>(globalObject, decoder);
    case MessageName::ServiceWorkerFetchTask_DidFail:
        return jsValueForDecodedMessage<MessageName::ServiceWorkerFetchTask_DidFail>(globalObject, decoder);
    case MessageName::ServiceWorkerFetchTask_DidReceiveRedirectResponse:
        return jsValueForDecodedMessage<MessageName::ServiceWorkerFetchTask_DidReceiveRedirectResponse>(globalObject, decoder);
    case MessageName::ServiceWorkerFetchTask_DidReceiveResponse:
        return jsValueForDecodedMessage<MessageName::ServiceWorkerFetchTask_DidReceiveResponse>(globalObject, decoder);
    case MessageName::ServiceWorkerFetchTask_DidReceiveData:
        return jsValueForDecodedMessage<MessageName::ServiceWorkerFetchTask_DidReceiveData>(globalObject, decoder);
    case MessageName::ServiceWorkerFetchTask_DidReceiveFormData:
        return jsValueForDecodedMessage<MessageName::ServiceWorkerFetchTask_DidReceiveFormData>(globalObject, decoder);
    case MessageName::ServiceWorkerFetchTask_DidFinish:
        return jsValueForDecodedMessage<MessageName::ServiceWorkerFetchTask_DidFinish>(globalObject, decoder);
    case MessageName::ServiceWorkerFetchTask_UsePreload:
        return jsValueForDecodedMessage<MessageName::ServiceWorkerFetchTask_UsePreload>(globalObject, decoder);
    case MessageName::ServiceWorkerFetchTask_WorkerClosed:
        return jsValueForDecodedMessage<MessageName::ServiceWorkerFetchTask_WorkerClosed>(globalObject, decoder);
    case MessageName::WebSWServerConnection_ScheduleJobInServer:
        return jsValueForDecodedMessage<MessageName::WebSWServerConnection_ScheduleJobInServer>(globalObject, decoder);
    case MessageName::WebSWServerConnection_ScheduleUnregisterJobInServer:
        return jsValueForDecodedMessage<MessageName::WebSWServerConnection_ScheduleUnregisterJobInServer>(globalObject, decoder);
    case MessageName::WebSWServerConnection_FinishFetchingScriptInServer:
        return jsValueForDecodedMessage<MessageName::WebSWServerConnection_FinishFetchingScriptInServer>(globalObject, decoder);
    case MessageName::WebSWServerConnection_AddServiceWorkerRegistrationInServer:
        return jsValueForDecodedMessage<MessageName::WebSWServerConnection_AddServiceWorkerRegistrationInServer>(globalObject, decoder);
    case MessageName::WebSWServerConnection_RemoveServiceWorkerRegistrationInServer:
        return jsValueForDecodedMessage<MessageName::WebSWServerConnection_RemoveServiceWorkerRegistrationInServer>(globalObject, decoder);
    case MessageName::WebSWServerConnection_PostMessageToServiceWorker:
        return jsValueForDecodedMessage<MessageName::WebSWServerConnection_PostMessageToServiceWorker>(globalObject, decoder);
    case MessageName::WebSWServerConnection_DidResolveRegistrationPromise:
        return jsValueForDecodedMessage<MessageName::WebSWServerConnection_DidResolveRegistrationPromise>(globalObject, decoder);
    case MessageName::WebSWServerConnection_MatchRegistration:
        return jsValueForDecodedMessage<MessageName::WebSWServerConnection_MatchRegistration>(globalObject, decoder);
    case MessageName::WebSWServerConnection_WhenRegistrationReady:
        return jsValueForDecodedMessage<MessageName::WebSWServerConnection_WhenRegistrationReady>(globalObject, decoder);
    case MessageName::WebSWServerConnection_GetRegistrations:
        return jsValueForDecodedMessage<MessageName::WebSWServerConnection_GetRegistrations>(globalObject, decoder);
    case MessageName::WebSWServerConnection_RegisterServiceWorkerClient:
        return jsValueForDecodedMessage<MessageName::WebSWServerConnection_RegisterServiceWorkerClient>(globalObject, decoder);
    case MessageName::WebSWServerConnection_UnregisterServiceWorkerClient:
        return jsValueForDecodedMessage<MessageName::WebSWServerConnection_UnregisterServiceWorkerClient>(globalObject, decoder);
    case MessageName::WebSWServerConnection_TerminateWorkerFromClient:
        return jsValueForDecodedMessage<MessageName::WebSWServerConnection_TerminateWorkerFromClient>(globalObject, decoder);
    case MessageName::WebSWServerConnection_WhenServiceWorkerIsTerminatedForTesting:
        return jsValueForDecodedMessage<MessageName::WebSWServerConnection_WhenServiceWorkerIsTerminatedForTesting>(globalObject, decoder);
    case MessageName::WebSWServerConnection_SetThrottleState:
        return jsValueForDecodedMessage<MessageName::WebSWServerConnection_SetThrottleState>(globalObject, decoder);
    case MessageName::WebSWServerConnection_StoreRegistrationsOnDisk:
        return jsValueForDecodedMessage<MessageName::WebSWServerConnection_StoreRegistrationsOnDisk>(globalObject, decoder);
    case MessageName::WebSWServerConnection_SubscribeToPushService:
        return jsValueForDecodedMessage<MessageName::WebSWServerConnection_SubscribeToPushService>(globalObject, decoder);
    case MessageName::WebSWServerConnection_UnsubscribeFromPushService:
        return jsValueForDecodedMessage<MessageName::WebSWServerConnection_UnsubscribeFromPushService>(globalObject, decoder);
    case MessageName::WebSWServerConnection_GetPushSubscription:
        return jsValueForDecodedMessage<MessageName::WebSWServerConnection_GetPushSubscription>(globalObject, decoder);
    case MessageName::WebSWServerConnection_GetPushPermissionState:
        return jsValueForDecodedMessage<MessageName::WebSWServerConnection_GetPushPermissionState>(globalObject, decoder);
    case MessageName::WebSWServerConnection_EnableNavigationPreload:
        return jsValueForDecodedMessage<MessageName::WebSWServerConnection_EnableNavigationPreload>(globalObject, decoder);
    case MessageName::WebSWServerConnection_DisableNavigationPreload:
        return jsValueForDecodedMessage<MessageName::WebSWServerConnection_DisableNavigationPreload>(globalObject, decoder);
    case MessageName::WebSWServerConnection_SetNavigationPreloadHeaderValue:
        return jsValueForDecodedMessage<MessageName::WebSWServerConnection_SetNavigationPreloadHeaderValue>(globalObject, decoder);
    case MessageName::WebSWServerConnection_GetNavigationPreloadState:
        return jsValueForDecodedMessage<MessageName::WebSWServerConnection_GetNavigationPreloadState>(globalObject, decoder);
    case MessageName::WebSWServerConnection_StartBackgroundFetch:
        return jsValueForDecodedMessage<MessageName::WebSWServerConnection_StartBackgroundFetch>(globalObject, decoder);
    case MessageName::WebSWServerConnection_BackgroundFetchInformation:
        return jsValueForDecodedMessage<MessageName::WebSWServerConnection_BackgroundFetchInformation>(globalObject, decoder);
    case MessageName::WebSWServerConnection_BackgroundFetchIdentifiers:
        return jsValueForDecodedMessage<MessageName::WebSWServerConnection_BackgroundFetchIdentifiers>(globalObject, decoder);
    case MessageName::WebSWServerConnection_AbortBackgroundFetch:
        return jsValueForDecodedMessage<MessageName::WebSWServerConnection_AbortBackgroundFetch>(globalObject, decoder);
    case MessageName::WebSWServerConnection_MatchBackgroundFetch:
        return jsValueForDecodedMessage<MessageName::WebSWServerConnection_MatchBackgroundFetch>(globalObject, decoder);
    case MessageName::WebSWServerConnection_RetrieveRecordResponse:
        return jsValueForDecodedMessage<MessageName::WebSWServerConnection_RetrieveRecordResponse>(globalObject, decoder);
    case MessageName::WebSWServerConnection_RetrieveRecordResponseBody:
        return jsValueForDecodedMessage<MessageName::WebSWServerConnection_RetrieveRecordResponseBody>(globalObject, decoder);
    case MessageName::WebSWServerConnection_AddCookieChangeSubscriptions:
        return jsValueForDecodedMessage<MessageName::WebSWServerConnection_AddCookieChangeSubscriptions>(globalObject, decoder);
    case MessageName::WebSWServerConnection_RemoveCookieChangeSubscriptions:
        return jsValueForDecodedMessage<MessageName::WebSWServerConnection_RemoveCookieChangeSubscriptions>(globalObject, decoder);
    case MessageName::WebSWServerConnection_CookieChangeSubscriptions:
        return jsValueForDecodedMessage<MessageName::WebSWServerConnection_CookieChangeSubscriptions>(globalObject, decoder);
    case MessageName::WebSWServerConnection_AddRoutes:
        return jsValueForDecodedMessage<MessageName::WebSWServerConnection_AddRoutes>(globalObject, decoder);
#if ENABLE(WEB_PUSH_NOTIFICATIONS)
    case MessageName::WebSWServerConnection_GetNotifications:
        return jsValueForDecodedMessage<MessageName::WebSWServerConnection_GetNotifications>(globalObject, decoder);
#endif
    case MessageName::WebSWServerToContextConnection_ScriptContextFailedToStart:
        return jsValueForDecodedMessage<MessageName::WebSWServerToContextConnection_ScriptContextFailedToStart>(globalObject, decoder);
    case MessageName::WebSWServerToContextConnection_ScriptContextStarted:
        return jsValueForDecodedMessage<MessageName::WebSWServerToContextConnection_ScriptContextStarted>(globalObject, decoder);
    case MessageName::WebSWServerToContextConnection_DidFinishInstall:
        return jsValueForDecodedMessage<MessageName::WebSWServerToContextConnection_DidFinishInstall>(globalObject, decoder);
    case MessageName::WebSWServerToContextConnection_DidFinishActivation:
        return jsValueForDecodedMessage<MessageName::WebSWServerToContextConnection_DidFinishActivation>(globalObject, decoder);
    case MessageName::WebSWServerToContextConnection_SetServiceWorkerHasPendingEvents:
        return jsValueForDecodedMessage<MessageName::WebSWServerToContextConnection_SetServiceWorkerHasPendingEvents>(globalObject, decoder);
    case MessageName::WebSWServerToContextConnection_SkipWaiting:
        return jsValueForDecodedMessage<MessageName::WebSWServerToContextConnection_SkipWaiting>(globalObject, decoder);
    case MessageName::WebSWServerToContextConnection_WorkerTerminated:
        return jsValueForDecodedMessage<MessageName::WebSWServerToContextConnection_WorkerTerminated>(globalObject, decoder);
    case MessageName::WebSWServerToContextConnection_FindClientByVisibleIdentifier:
        return jsValueForDecodedMessage<MessageName::WebSWServerToContextConnection_FindClientByVisibleIdentifier>(globalObject, decoder);
    case MessageName::WebSWServerToContextConnection_MatchAll:
        return jsValueForDecodedMessage<MessageName::WebSWServerToContextConnection_MatchAll>(globalObject, decoder);
    case MessageName::WebSWServerToContextConnection_Claim:
        return jsValueForDecodedMessage<MessageName::WebSWServerToContextConnection_Claim>(globalObject, decoder);
    case MessageName::WebSWServerToContextConnection_Focus:
        return jsValueForDecodedMessage<MessageName::WebSWServerToContextConnection_Focus>(globalObject, decoder);
    case MessageName::WebSWServerToContextConnection_Navigate:
        return jsValueForDecodedMessage<MessageName::WebSWServerToContextConnection_Navigate>(globalObject, decoder);
    case MessageName::WebSWServerToContextConnection_SetScriptResource:
        return jsValueForDecodedMessage<MessageName::WebSWServerToContextConnection_SetScriptResource>(globalObject, decoder);
    case MessageName::WebSWServerToContextConnection_PostMessageToServiceWorkerClient:
        return jsValueForDecodedMessage<MessageName::WebSWServerToContextConnection_PostMessageToServiceWorkerClient>(globalObject, decoder);
    case MessageName::WebSWServerToContextConnection_DidFailHeartBeatCheck:
        return jsValueForDecodedMessage<MessageName::WebSWServerToContextConnection_DidFailHeartBeatCheck>(globalObject, decoder);
    case MessageName::WebSWServerToContextConnection_SetAsInspected:
        return jsValueForDecodedMessage<MessageName::WebSWServerToContextConnection_SetAsInspected>(globalObject, decoder);
    case MessageName::WebSWServerToContextConnection_OpenWindow:
        return jsValueForDecodedMessage<MessageName::WebSWServerToContextConnection_OpenWindow>(globalObject, decoder);
    case MessageName::WebSWServerToContextConnection_ReportConsoleMessage:
        return jsValueForDecodedMessage<MessageName::WebSWServerToContextConnection_ReportConsoleMessage>(globalObject, decoder);
    case MessageName::WebSharedWorkerServerConnection_RequestSharedWorker:
        return jsValueForDecodedMessage<MessageName::WebSharedWorkerServerConnection_RequestSharedWorker>(globalObject, decoder);
    case MessageName::WebSharedWorkerServerConnection_SharedWorkerObjectIsGoingAway:
        return jsValueForDecodedMessage<MessageName::WebSharedWorkerServerConnection_SharedWorkerObjectIsGoingAway>(globalObject, decoder);
    case MessageName::WebSharedWorkerServerConnection_SuspendForBackForwardCache:
        return jsValueForDecodedMessage<MessageName::WebSharedWorkerServerConnection_SuspendForBackForwardCache>(globalObject, decoder);
    case MessageName::WebSharedWorkerServerConnection_ResumeForBackForwardCache:
        return jsValueForDecodedMessage<MessageName::WebSharedWorkerServerConnection_ResumeForBackForwardCache>(globalObject, decoder);
    case MessageName::WebSharedWorkerServerToContextConnection_PostErrorToWorkerObject:
        return jsValueForDecodedMessage<MessageName::WebSharedWorkerServerToContextConnection_PostErrorToWorkerObject>(globalObject, decoder);
    case MessageName::WebSharedWorkerServerToContextConnection_SharedWorkerTerminated:
        return jsValueForDecodedMessage<MessageName::WebSharedWorkerServerToContextConnection_SharedWorkerTerminated>(globalObject, decoder);
    case MessageName::NetworkStorageManager_Persisted:
        return jsValueForDecodedMessage<MessageName::NetworkStorageManager_Persisted>(globalObject, decoder);
    case MessageName::NetworkStorageManager_Persist:
        return jsValueForDecodedMessage<MessageName::NetworkStorageManager_Persist>(globalObject, decoder);
    case MessageName::NetworkStorageManager_Estimate:
        return jsValueForDecodedMessage<MessageName::NetworkStorageManager_Estimate>(globalObject, decoder);
    case MessageName::NetworkStorageManager_FileSystemGetDirectory:
        return jsValueForDecodedMessage<MessageName::NetworkStorageManager_FileSystemGetDirectory>(globalObject, decoder);
    case MessageName::NetworkStorageManager_CloseHandle:
        return jsValueForDecodedMessage<MessageName::NetworkStorageManager_CloseHandle>(globalObject, decoder);
    case MessageName::NetworkStorageManager_IsSameEntry:
        return jsValueForDecodedMessage<MessageName::NetworkStorageManager_IsSameEntry>(globalObject, decoder);
    case MessageName::NetworkStorageManager_GetFileHandle:
        return jsValueForDecodedMessage<MessageName::NetworkStorageManager_GetFileHandle>(globalObject, decoder);
    case MessageName::NetworkStorageManager_GetDirectoryHandle:
        return jsValueForDecodedMessage<MessageName::NetworkStorageManager_GetDirectoryHandle>(globalObject, decoder);
    case MessageName::NetworkStorageManager_RemoveEntry:
        return jsValueForDecodedMessage<MessageName::NetworkStorageManager_RemoveEntry>(globalObject, decoder);
    case MessageName::NetworkStorageManager_Resolve:
        return jsValueForDecodedMessage<MessageName::NetworkStorageManager_Resolve>(globalObject, decoder);
    case MessageName::NetworkStorageManager_Move:
        return jsValueForDecodedMessage<MessageName::NetworkStorageManager_Move>(globalObject, decoder);
    case MessageName::NetworkStorageManager_GetFile:
        return jsValueForDecodedMessage<MessageName::NetworkStorageManager_GetFile>(globalObject, decoder);
    case MessageName::NetworkStorageManager_CreateSyncAccessHandle:
        return jsValueForDecodedMessage<MessageName::NetworkStorageManager_CreateSyncAccessHandle>(globalObject, decoder);
    case MessageName::NetworkStorageManager_CloseSyncAccessHandle:
        return jsValueForDecodedMessage<MessageName::NetworkStorageManager_CloseSyncAccessHandle>(globalObject, decoder);
    case MessageName::NetworkStorageManager_RequestNewCapacityForSyncAccessHandle:
        return jsValueForDecodedMessage<MessageName::NetworkStorageManager_RequestNewCapacityForSyncAccessHandle>(globalObject, decoder);
    case MessageName::NetworkStorageManager_CreateWritable:
        return jsValueForDecodedMessage<MessageName::NetworkStorageManager_CreateWritable>(globalObject, decoder);
    case MessageName::NetworkStorageManager_CloseWritable:
        return jsValueForDecodedMessage<MessageName::NetworkStorageManager_CloseWritable>(globalObject, decoder);
    case MessageName::NetworkStorageManager_ExecuteCommandForWritable:
        return jsValueForDecodedMessage<MessageName::NetworkStorageManager_ExecuteCommandForWritable>(globalObject, decoder);
    case MessageName::NetworkStorageManager_GetHandleNames:
        return jsValueForDecodedMessage<MessageName::NetworkStorageManager_GetHandleNames>(globalObject, decoder);
    case MessageName::NetworkStorageManager_GetHandle:
        return jsValueForDecodedMessage<MessageName::NetworkStorageManager_GetHandle>(globalObject, decoder);
    case MessageName::NetworkStorageManager_ConnectToStorageArea:
        return jsValueForDecodedMessage<MessageName::NetworkStorageManager_ConnectToStorageArea>(globalObject, decoder);
    case MessageName::NetworkStorageManager_ConnectToStorageAreaSync:
        return jsValueForDecodedMessage<MessageName::NetworkStorageManager_ConnectToStorageAreaSync>(globalObject, decoder);
    case MessageName::NetworkStorageManager_CancelConnectToStorageArea:
        return jsValueForDecodedMessage<MessageName::NetworkStorageManager_CancelConnectToStorageArea>(globalObject, decoder);
    case MessageName::NetworkStorageManager_DisconnectFromStorageArea:
        return jsValueForDecodedMessage<MessageName::NetworkStorageManager_DisconnectFromStorageArea>(globalObject, decoder);
    case MessageName::NetworkStorageManager_SetItem:
        return jsValueForDecodedMessage<MessageName::NetworkStorageManager_SetItem>(globalObject, decoder);
    case MessageName::NetworkStorageManager_RemoveItem:
        return jsValueForDecodedMessage<MessageName::NetworkStorageManager_RemoveItem>(globalObject, decoder);
    case MessageName::NetworkStorageManager_Clear:
        return jsValueForDecodedMessage<MessageName::NetworkStorageManager_Clear>(globalObject, decoder);
    case MessageName::NetworkStorageManager_OpenDatabase:
        return jsValueForDecodedMessage<MessageName::NetworkStorageManager_OpenDatabase>(globalObject, decoder);
    case MessageName::NetworkStorageManager_OpenDBRequestCancelled:
        return jsValueForDecodedMessage<MessageName::NetworkStorageManager_OpenDBRequestCancelled>(globalObject, decoder);
    case MessageName::NetworkStorageManager_DeleteDatabase:
        return jsValueForDecodedMessage<MessageName::NetworkStorageManager_DeleteDatabase>(globalObject, decoder);
    case MessageName::NetworkStorageManager_EstablishTransaction:
        return jsValueForDecodedMessage<MessageName::NetworkStorageManager_EstablishTransaction>(globalObject, decoder);
    case MessageName::NetworkStorageManager_DatabaseConnectionPendingClose:
        return jsValueForDecodedMessage<MessageName::NetworkStorageManager_DatabaseConnectionPendingClose>(globalObject, decoder);
    case MessageName::NetworkStorageManager_DatabaseConnectionClosed:
        return jsValueForDecodedMessage<MessageName::NetworkStorageManager_DatabaseConnectionClosed>(globalObject, decoder);
    case MessageName::NetworkStorageManager_AbortOpenAndUpgradeNeeded:
        return jsValueForDecodedMessage<MessageName::NetworkStorageManager_AbortOpenAndUpgradeNeeded>(globalObject, decoder);
    case MessageName::NetworkStorageManager_DidFireVersionChangeEvent:
        return jsValueForDecodedMessage<MessageName::NetworkStorageManager_DidFireVersionChangeEvent>(globalObject, decoder);
    case MessageName::NetworkStorageManager_DidGenerateIndexKeyForRecord:
        return jsValueForDecodedMessage<MessageName::NetworkStorageManager_DidGenerateIndexKeyForRecord>(globalObject, decoder);
    case MessageName::NetworkStorageManager_DidFinishHandlingVersionChangeTransaction:
        return jsValueForDecodedMessage<MessageName::NetworkStorageManager_DidFinishHandlingVersionChangeTransaction>(globalObject, decoder);
    case MessageName::NetworkStorageManager_AbortTransaction:
        return jsValueForDecodedMessage<MessageName::NetworkStorageManager_AbortTransaction>(globalObject, decoder);
    case MessageName::NetworkStorageManager_CommitTransaction:
        return jsValueForDecodedMessage<MessageName::NetworkStorageManager_CommitTransaction>(globalObject, decoder);
    case MessageName::NetworkStorageManager_CreateObjectStore:
        return jsValueForDecodedMessage<MessageName::NetworkStorageManager_CreateObjectStore>(globalObject, decoder);
    case MessageName::NetworkStorageManager_DeleteObjectStore:
        return jsValueForDecodedMessage<MessageName::NetworkStorageManager_DeleteObjectStore>(globalObject, decoder);
    case MessageName::NetworkStorageManager_RenameObjectStore:
        return jsValueForDecodedMessage<MessageName::NetworkStorageManager_RenameObjectStore>(globalObject, decoder);
    case MessageName::NetworkStorageManager_ClearObjectStore:
        return jsValueForDecodedMessage<MessageName::NetworkStorageManager_ClearObjectStore>(globalObject, decoder);
    case MessageName::NetworkStorageManager_CreateIndex:
        return jsValueForDecodedMessage<MessageName::NetworkStorageManager_CreateIndex>(globalObject, decoder);
    case MessageName::NetworkStorageManager_DeleteIndex:
        return jsValueForDecodedMessage<MessageName::NetworkStorageManager_DeleteIndex>(globalObject, decoder);
    case MessageName::NetworkStorageManager_RenameIndex:
        return jsValueForDecodedMessage<MessageName::NetworkStorageManager_RenameIndex>(globalObject, decoder);
    case MessageName::NetworkStorageManager_PutOrAdd:
        return jsValueForDecodedMessage<MessageName::NetworkStorageManager_PutOrAdd>(globalObject, decoder);
    case MessageName::NetworkStorageManager_GetRecord:
        return jsValueForDecodedMessage<MessageName::NetworkStorageManager_GetRecord>(globalObject, decoder);
    case MessageName::NetworkStorageManager_GetAllRecords:
        return jsValueForDecodedMessage<MessageName::NetworkStorageManager_GetAllRecords>(globalObject, decoder);
    case MessageName::NetworkStorageManager_GetCount:
        return jsValueForDecodedMessage<MessageName::NetworkStorageManager_GetCount>(globalObject, decoder);
    case MessageName::NetworkStorageManager_DeleteRecord:
        return jsValueForDecodedMessage<MessageName::NetworkStorageManager_DeleteRecord>(globalObject, decoder);
    case MessageName::NetworkStorageManager_OpenCursor:
        return jsValueForDecodedMessage<MessageName::NetworkStorageManager_OpenCursor>(globalObject, decoder);
    case MessageName::NetworkStorageManager_IterateCursor:
        return jsValueForDecodedMessage<MessageName::NetworkStorageManager_IterateCursor>(globalObject, decoder);
    case MessageName::NetworkStorageManager_GetAllDatabaseNamesAndVersions:
        return jsValueForDecodedMessage<MessageName::NetworkStorageManager_GetAllDatabaseNamesAndVersions>(globalObject, decoder);
    case MessageName::NetworkStorageManager_CacheStorageOpenCache:
        return jsValueForDecodedMessage<MessageName::NetworkStorageManager_CacheStorageOpenCache>(globalObject, decoder);
    case MessageName::NetworkStorageManager_CacheStorageRemoveCache:
        return jsValueForDecodedMessage<MessageName::NetworkStorageManager_CacheStorageRemoveCache>(globalObject, decoder);
    case MessageName::NetworkStorageManager_CacheStorageAllCaches:
        return jsValueForDecodedMessage<MessageName::NetworkStorageManager_CacheStorageAllCaches>(globalObject, decoder);
    case MessageName::NetworkStorageManager_CacheStorageReference:
        return jsValueForDecodedMessage<MessageName::NetworkStorageManager_CacheStorageReference>(globalObject, decoder);
    case MessageName::NetworkStorageManager_CacheStorageDereference:
        return jsValueForDecodedMessage<MessageName::NetworkStorageManager_CacheStorageDereference>(globalObject, decoder);
    case MessageName::NetworkStorageManager_LockCacheStorage:
        return jsValueForDecodedMessage<MessageName::NetworkStorageManager_LockCacheStorage>(globalObject, decoder);
    case MessageName::NetworkStorageManager_UnlockCacheStorage:
        return jsValueForDecodedMessage<MessageName::NetworkStorageManager_UnlockCacheStorage>(globalObject, decoder);
    case MessageName::NetworkStorageManager_CacheStorageRetrieveRecords:
        return jsValueForDecodedMessage<MessageName::NetworkStorageManager_CacheStorageRetrieveRecords>(globalObject, decoder);
    case MessageName::NetworkStorageManager_CacheStorageRemoveRecords:
        return jsValueForDecodedMessage<MessageName::NetworkStorageManager_CacheStorageRemoveRecords>(globalObject, decoder);
    case MessageName::NetworkStorageManager_CacheStoragePutRecords:
        return jsValueForDecodedMessage<MessageName::NetworkStorageManager_CacheStoragePutRecords>(globalObject, decoder);
    case MessageName::NetworkStorageManager_CacheStorageClearMemoryRepresentation:
        return jsValueForDecodedMessage<MessageName::NetworkStorageManager_CacheStorageClearMemoryRepresentation>(globalObject, decoder);
    case MessageName::NetworkStorageManager_CacheStorageRepresentation:
        return jsValueForDecodedMessage<MessageName::NetworkStorageManager_CacheStorageRepresentation>(globalObject, decoder);
    case MessageName::NetworkStorageManager_ResetQuotaUpdatedBasedOnUsageForTesting:
        return jsValueForDecodedMessage<MessageName::NetworkStorageManager_ResetQuotaUpdatedBasedOnUsageForTesting>(globalObject, decoder);
#if ENABLE(WEB_RTC)
    case MessageName::NetworkMDNSRegister_UnregisterMDNSNames:
        return jsValueForDecodedMessage<MessageName::NetworkMDNSRegister_UnregisterMDNSNames>(globalObject, decoder);
    case MessageName::NetworkMDNSRegister_RegisterMDNSName:
        return jsValueForDecodedMessage<MessageName::NetworkMDNSRegister_RegisterMDNSName>(globalObject, decoder);
#endif
#if USE(LIBWEBRTC)
    case MessageName::NetworkRTCMonitor_StartUpdatingIfNeeded:
        return jsValueForDecodedMessage<MessageName::NetworkRTCMonitor_StartUpdatingIfNeeded>(globalObject, decoder);
    case MessageName::NetworkRTCMonitor_StopUpdating:
        return jsValueForDecodedMessage<MessageName::NetworkRTCMonitor_StopUpdating>(globalObject, decoder);
#endif
#if USE(LIBWEBRTC)
    case MessageName::NetworkRTCProvider_CreateUDPSocket:
        return jsValueForDecodedMessage<MessageName::NetworkRTCProvider_CreateUDPSocket>(globalObject, decoder);
    case MessageName::NetworkRTCProvider_CreateClientTCPSocket:
        return jsValueForDecodedMessage<MessageName::NetworkRTCProvider_CreateClientTCPSocket>(globalObject, decoder);
    case MessageName::NetworkRTCProvider_CreateResolver:
        return jsValueForDecodedMessage<MessageName::NetworkRTCProvider_CreateResolver>(globalObject, decoder);
    case MessageName::NetworkRTCProvider_StopResolver:
        return jsValueForDecodedMessage<MessageName::NetworkRTCProvider_StopResolver>(globalObject, decoder);
#if PLATFORM(COCOA)
    case MessageName::NetworkRTCProvider_GetInterfaceName:
        return jsValueForDecodedMessage<MessageName::NetworkRTCProvider_GetInterfaceName>(globalObject, decoder);
#endif
    case MessageName::NetworkRTCProvider_SendToSocket:
        return jsValueForDecodedMessage<MessageName::NetworkRTCProvider_SendToSocket>(globalObject, decoder);
    case MessageName::NetworkRTCProvider_CloseSocket:
        return jsValueForDecodedMessage<MessageName::NetworkRTCProvider_CloseSocket>(globalObject, decoder);
    case MessageName::NetworkRTCProvider_SetSocketOption:
        return jsValueForDecodedMessage<MessageName::NetworkRTCProvider_SetSocketOption>(globalObject, decoder);
#endif
#if ENABLE(WEB_RTC)
    case MessageName::RTCDataChannelRemoteManagerProxy_SendData:
        return jsValueForDecodedMessage<MessageName::RTCDataChannelRemoteManagerProxy_SendData>(globalObject, decoder);
    case MessageName::RTCDataChannelRemoteManagerProxy_Close:
        return jsValueForDecodedMessage<MessageName::RTCDataChannelRemoteManagerProxy_Close>(globalObject, decoder);
    case MessageName::RTCDataChannelRemoteManagerProxy_ChangeReadyState:
        return jsValueForDecodedMessage<MessageName::RTCDataChannelRemoteManagerProxy_ChangeReadyState>(globalObject, decoder);
    case MessageName::RTCDataChannelRemoteManagerProxy_ReceiveData:
        return jsValueForDecodedMessage<MessageName::RTCDataChannelRemoteManagerProxy_ReceiveData>(globalObject, decoder);
    case MessageName::RTCDataChannelRemoteManagerProxy_DetectError:
        return jsValueForDecodedMessage<MessageName::RTCDataChannelRemoteManagerProxy_DetectError>(globalObject, decoder);
    case MessageName::RTCDataChannelRemoteManagerProxy_BufferedAmountIsDecreasing:
        return jsValueForDecodedMessage<MessageName::RTCDataChannelRemoteManagerProxy_BufferedAmountIsDecreasing>(globalObject, decoder);
#endif
    case MessageName::NetworkTransportSession_SendDatagram:
        return jsValueForDecodedMessage<MessageName::NetworkTransportSession_SendDatagram>(globalObject, decoder);
    case MessageName::NetworkTransportSession_CreateOutgoingUnidirectionalStream:
        return jsValueForDecodedMessage<MessageName::NetworkTransportSession_CreateOutgoingUnidirectionalStream>(globalObject, decoder);
    case MessageName::NetworkTransportSession_CreateBidirectionalStream:
        return jsValueForDecodedMessage<MessageName::NetworkTransportSession_CreateBidirectionalStream>(globalObject, decoder);
    case MessageName::NetworkTransportSession_StreamSendBytes:
        return jsValueForDecodedMessage<MessageName::NetworkTransportSession_StreamSendBytes>(globalObject, decoder);
    case MessageName::NetworkTransportSession_CancelReceiveStream:
        return jsValueForDecodedMessage<MessageName::NetworkTransportSession_CancelReceiveStream>(globalObject, decoder);
    case MessageName::NetworkTransportSession_CancelSendStream:
        return jsValueForDecodedMessage<MessageName::NetworkTransportSession_CancelSendStream>(globalObject, decoder);
    case MessageName::NetworkTransportSession_DestroyStream:
        return jsValueForDecodedMessage<MessageName::NetworkTransportSession_DestroyStream>(globalObject, decoder);
    case MessageName::NetworkTransportSession_Terminate:
        return jsValueForDecodedMessage<MessageName::NetworkTransportSession_Terminate>(globalObject, decoder);
    case MessageName::AuxiliaryProcess_ShutDown:
        return jsValueForDecodedMessage<MessageName::AuxiliaryProcess_ShutDown>(globalObject, decoder);
    case MessageName::AuxiliaryProcess_SetProcessSuppressionEnabled:
        return jsValueForDecodedMessage<MessageName::AuxiliaryProcess_SetProcessSuppressionEnabled>(globalObject, decoder);
    case MessageName::AuxiliaryProcess_MainThreadPing:
        return jsValueForDecodedMessage<MessageName::AuxiliaryProcess_MainThreadPing>(globalObject, decoder);
#if ENABLE(CFPREFS_DIRECT_MODE)
    case MessageName::AuxiliaryProcess_PreferenceDidUpdate:
        return jsValueForDecodedMessage<MessageName::AuxiliaryProcess_PreferenceDidUpdate>(globalObject, decoder);
#endif
#if OS(LINUX)
    case MessageName::AuxiliaryProcess_DidReceiveMemoryPressureEvent:
        return jsValueForDecodedMessage<MessageName::AuxiliaryProcess_DidReceiveMemoryPressureEvent>(globalObject, decoder);
#endif
#if ENABLE(IPC_TESTING_API)
    case MessageName::IPCConnectionTester_AsyncMessage:
        return jsValueForDecodedMessage<MessageName::IPCConnectionTester_AsyncMessage>(globalObject, decoder);
    case MessageName::IPCConnectionTester_SyncMessage:
        return jsValueForDecodedMessage<MessageName::IPCConnectionTester_SyncMessage>(globalObject, decoder);
#endif
#if ENABLE(IPC_TESTING_API)
    case MessageName::IPCStreamTester_SyncMessage:
        return jsValueForDecodedMessage<MessageName::IPCStreamTester_SyncMessage>(globalObject, decoder);
    case MessageName::IPCStreamTester_SyncMessageNotStreamEncodableReply:
        return jsValueForDecodedMessage<MessageName::IPCStreamTester_SyncMessageNotStreamEncodableReply>(globalObject, decoder);
    case MessageName::IPCStreamTester_SyncMessageNotStreamEncodableBoth:
        return jsValueForDecodedMessage<MessageName::IPCStreamTester_SyncMessageNotStreamEncodableBoth>(globalObject, decoder);
    case MessageName::IPCStreamTester_SyncMessageReturningSharedMemory1:
        return jsValueForDecodedMessage<MessageName::IPCStreamTester_SyncMessageReturningSharedMemory1>(globalObject, decoder);
    case MessageName::IPCStreamTester_SyncMessageEmptyReply:
        return jsValueForDecodedMessage<MessageName::IPCStreamTester_SyncMessageEmptyReply>(globalObject, decoder);
    case MessageName::IPCStreamTester_SyncCrashOnZero:
        return jsValueForDecodedMessage<MessageName::IPCStreamTester_SyncCrashOnZero>(globalObject, decoder);
    case MessageName::IPCStreamTester_CheckAutoreleasePool:
        return jsValueForDecodedMessage<MessageName::IPCStreamTester_CheckAutoreleasePool>(globalObject, decoder);
    case MessageName::IPCStreamTester_AsyncPing:
        return jsValueForDecodedMessage<MessageName::IPCStreamTester_AsyncPing>(globalObject, decoder);
    case MessageName::IPCStreamTester_EmptyMessage:
        return jsValueForDecodedMessage<MessageName::IPCStreamTester_EmptyMessage>(globalObject, decoder);
#endif
#if ENABLE(IPC_TESTING_API)
    case MessageName::IPCStreamTesterProxy_WasCreated:
        return jsValueForDecodedMessage<MessageName::IPCStreamTesterProxy_WasCreated>(globalObject, decoder);
#endif
#if ENABLE(IPC_TESTING_API)
    case MessageName::IPCTester_StartMessageTesting:
        return jsValueForDecodedMessage<MessageName::IPCTester_StartMessageTesting>(globalObject, decoder);
    case MessageName::IPCTester_StopMessageTesting:
        return jsValueForDecodedMessage<MessageName::IPCTester_StopMessageTesting>(globalObject, decoder);
    case MessageName::IPCTester_CreateStreamTester:
        return jsValueForDecodedMessage<MessageName::IPCTester_CreateStreamTester>(globalObject, decoder);
    case MessageName::IPCTester_ReleaseStreamTester:
        return jsValueForDecodedMessage<MessageName::IPCTester_ReleaseStreamTester>(globalObject, decoder);
    case MessageName::IPCTester_CreateConnectionTester:
        return jsValueForDecodedMessage<MessageName::IPCTester_CreateConnectionTester>(globalObject, decoder);
    case MessageName::IPCTester_CreateConnectionTesterAndSendAsyncMessages:
        return jsValueForDecodedMessage<MessageName::IPCTester_CreateConnectionTesterAndSendAsyncMessages>(globalObject, decoder);
    case MessageName::IPCTester_ReleaseConnectionTester:
        return jsValueForDecodedMessage<MessageName::IPCTester_ReleaseConnectionTester>(globalObject, decoder);
    case MessageName::IPCTester_SendSameSemaphoreBack:
        return jsValueForDecodedMessage<MessageName::IPCTester_SendSameSemaphoreBack>(globalObject, decoder);
    case MessageName::IPCTester_SendSemaphoreBackAndSignalProtocol:
        return jsValueForDecodedMessage<MessageName::IPCTester_SendSemaphoreBackAndSignalProtocol>(globalObject, decoder);
    case MessageName::IPCTester_AsyncPing:
        return jsValueForDecodedMessage<MessageName::IPCTester_AsyncPing>(globalObject, decoder);
    case MessageName::IPCTester_SyncPing:
        return jsValueForDecodedMessage<MessageName::IPCTester_SyncPing>(globalObject, decoder);
    case MessageName::IPCTester_SyncPingEmptyReply:
        return jsValueForDecodedMessage<MessageName::IPCTester_SyncPingEmptyReply>(globalObject, decoder);
    case MessageName::IPCTester_SendAsyncMessageToReceiver:
        return jsValueForDecodedMessage<MessageName::IPCTester_SendAsyncMessageToReceiver>(globalObject, decoder);
    case MessageName::IPCTester_AsyncOptionalExceptionData:
        return jsValueForDecodedMessage<MessageName::IPCTester_AsyncOptionalExceptionData>(globalObject, decoder);
#endif
#if ENABLE(IPC_TESTING_API)
    case MessageName::IPCTesterReceiver_AsyncMessage:
        return jsValueForDecodedMessage<MessageName::IPCTesterReceiver_AsyncMessage>(globalObject, decoder);
#endif
#if ENABLE(NOTIFICATIONS)
    case MessageName::NotificationManagerMessageHandler_ShowNotification:
        return jsValueForDecodedMessage<MessageName::NotificationManagerMessageHandler_ShowNotification>(globalObject, decoder);
    case MessageName::NotificationManagerMessageHandler_CancelNotification:
        return jsValueForDecodedMessage<MessageName::NotificationManagerMessageHandler_CancelNotification>(globalObject, decoder);
    case MessageName::NotificationManagerMessageHandler_ClearNotifications:
        return jsValueForDecodedMessage<MessageName::NotificationManagerMessageHandler_ClearNotifications>(globalObject, decoder);
    case MessageName::NotificationManagerMessageHandler_DidDestroyNotification:
        return jsValueForDecodedMessage<MessageName::NotificationManagerMessageHandler_DidDestroyNotification>(globalObject, decoder);
    case MessageName::NotificationManagerMessageHandler_PageWasNotifiedOfNotificationPermission:
        return jsValueForDecodedMessage<MessageName::NotificationManagerMessageHandler_PageWasNotifiedOfNotificationPermission>(globalObject, decoder);
    case MessageName::NotificationManagerMessageHandler_RequestPermission:
        return jsValueForDecodedMessage<MessageName::NotificationManagerMessageHandler_RequestPermission>(globalObject, decoder);
#endif
#if ENABLE(WEB_PUSH_NOTIFICATIONS)
    case MessageName::NotificationManagerMessageHandler_SetAppBadge:
        return jsValueForDecodedMessage<MessageName::NotificationManagerMessageHandler_SetAppBadge>(globalObject, decoder);
    case MessageName::NotificationManagerMessageHandler_GetPermissionState:
        return jsValueForDecodedMessage<MessageName::NotificationManagerMessageHandler_GetPermissionState>(globalObject, decoder);
    case MessageName::NotificationManagerMessageHandler_GetPermissionStateSync:
        return jsValueForDecodedMessage<MessageName::NotificationManagerMessageHandler_GetPermissionStateSync>(globalObject, decoder);
#endif
    case MessageName::DrawingAreaProxy_EnterAcceleratedCompositingMode:
        return jsValueForDecodedMessage<MessageName::DrawingAreaProxy_EnterAcceleratedCompositingMode>(globalObject, decoder);
    case MessageName::DrawingAreaProxy_UpdateAcceleratedCompositingMode:
        return jsValueForDecodedMessage<MessageName::DrawingAreaProxy_UpdateAcceleratedCompositingMode>(globalObject, decoder);
    case MessageName::DrawingAreaProxy_DidFirstLayerFlush:
        return jsValueForDecodedMessage<MessageName::DrawingAreaProxy_DidFirstLayerFlush>(globalObject, decoder);
    case MessageName::DrawingAreaProxy_DispatchPresentationCallbacksAfterFlushingLayers:
        return jsValueForDecodedMessage<MessageName::DrawingAreaProxy_DispatchPresentationCallbacksAfterFlushingLayers>(globalObject, decoder);
#if USE(COORDINATED_GRAPHICS) || USE(TEXTURE_MAPPER)
    case MessageName::DrawingAreaProxy_Update:
        return jsValueForDecodedMessage<MessageName::DrawingAreaProxy_Update>(globalObject, decoder);
    case MessageName::DrawingAreaProxy_ExitAcceleratedCompositingMode:
        return jsValueForDecodedMessage<MessageName::DrawingAreaProxy_ExitAcceleratedCompositingMode>(globalObject, decoder);
#endif
#if ENABLE(WK_WEB_EXTENSIONS)
    case MessageName::WebExtensionContext_ActionGetTitle:
        return jsValueForDecodedMessage<MessageName::WebExtensionContext_ActionGetTitle>(globalObject, decoder);
    case MessageName::WebExtensionContext_ActionSetTitle:
        return jsValueForDecodedMessage<MessageName::WebExtensionContext_ActionSetTitle>(globalObject, decoder);
    case MessageName::WebExtensionContext_ActionSetIcon:
        return jsValueForDecodedMessage<MessageName::WebExtensionContext_ActionSetIcon>(globalObject, decoder);
    case MessageName::WebExtensionContext_ActionGetPopup:
        return jsValueForDecodedMessage<MessageName::WebExtensionContext_ActionGetPopup>(globalObject, decoder);
    case MessageName::WebExtensionContext_ActionSetPopup:
        return jsValueForDecodedMessage<MessageName::WebExtensionContext_ActionSetPopup>(globalObject, decoder);
    case MessageName::WebExtensionContext_ActionOpenPopup:
        return jsValueForDecodedMessage<MessageName::WebExtensionContext_ActionOpenPopup>(globalObject, decoder);
    case MessageName::WebExtensionContext_ActionGetBadgeText:
        return jsValueForDecodedMessage<MessageName::WebExtensionContext_ActionGetBadgeText>(globalObject, decoder);
    case MessageName::WebExtensionContext_ActionSetBadgeText:
        return jsValueForDecodedMessage<MessageName::WebExtensionContext_ActionSetBadgeText>(globalObject, decoder);
    case MessageName::WebExtensionContext_ActionGetEnabled:
        return jsValueForDecodedMessage<MessageName::WebExtensionContext_ActionGetEnabled>(globalObject, decoder);
    case MessageName::WebExtensionContext_ActionSetEnabled:
        return jsValueForDecodedMessage<MessageName::WebExtensionContext_ActionSetEnabled>(globalObject, decoder);
    case MessageName::WebExtensionContext_AlarmsCreate:
        return jsValueForDecodedMessage<MessageName::WebExtensionContext_AlarmsCreate>(globalObject, decoder);
    case MessageName::WebExtensionContext_AlarmsGet:
        return jsValueForDecodedMessage<MessageName::WebExtensionContext_AlarmsGet>(globalObject, decoder);
    case MessageName::WebExtensionContext_AlarmsClear:
        return jsValueForDecodedMessage<MessageName::WebExtensionContext_AlarmsClear>(globalObject, decoder);
    case MessageName::WebExtensionContext_AlarmsGetAll:
        return jsValueForDecodedMessage<MessageName::WebExtensionContext_AlarmsGetAll>(globalObject, decoder);
    case MessageName::WebExtensionContext_AlarmsClearAll:
        return jsValueForDecodedMessage<MessageName::WebExtensionContext_AlarmsClearAll>(globalObject, decoder);
#if ENABLE(WK_WEB_EXTENSIONS_BOOKMARKS)
    case MessageName::WebExtensionContext_BookmarksCreate:
        return jsValueForDecodedMessage<MessageName::WebExtensionContext_BookmarksCreate>(globalObject, decoder);
    case MessageName::WebExtensionContext_BookmarksGetTree:
        return jsValueForDecodedMessage<MessageName::WebExtensionContext_BookmarksGetTree>(globalObject, decoder);
    case MessageName::WebExtensionContext_BookmarksGetSubTree:
        return jsValueForDecodedMessage<MessageName::WebExtensionContext_BookmarksGetSubTree>(globalObject, decoder);
    case MessageName::WebExtensionContext_BookmarksGet:
        return jsValueForDecodedMessage<MessageName::WebExtensionContext_BookmarksGet>(globalObject, decoder);
    case MessageName::WebExtensionContext_BookmarksGetChildren:
        return jsValueForDecodedMessage<MessageName::WebExtensionContext_BookmarksGetChildren>(globalObject, decoder);
    case MessageName::WebExtensionContext_BookmarksGetRecent:
        return jsValueForDecodedMessage<MessageName::WebExtensionContext_BookmarksGetRecent>(globalObject, decoder);
    case MessageName::WebExtensionContext_BookmarksSearch:
        return jsValueForDecodedMessage<MessageName::WebExtensionContext_BookmarksSearch>(globalObject, decoder);
    case MessageName::WebExtensionContext_BookmarksUpdate:
        return jsValueForDecodedMessage<MessageName::WebExtensionContext_BookmarksUpdate>(globalObject, decoder);
    case MessageName::WebExtensionContext_BookmarksMove:
        return jsValueForDecodedMessage<MessageName::WebExtensionContext_BookmarksMove>(globalObject, decoder);
    case MessageName::WebExtensionContext_BookmarksRemove:
        return jsValueForDecodedMessage<MessageName::WebExtensionContext_BookmarksRemove>(globalObject, decoder);
    case MessageName::WebExtensionContext_BookmarksRemoveTree:
        return jsValueForDecodedMessage<MessageName::WebExtensionContext_BookmarksRemoveTree>(globalObject, decoder);
#endif
    case MessageName::WebExtensionContext_CommandsGetAll:
        return jsValueForDecodedMessage<MessageName::WebExtensionContext_CommandsGetAll>(globalObject, decoder);
    case MessageName::WebExtensionContext_CookiesGet:
        return jsValueForDecodedMessage<MessageName::WebExtensionContext_CookiesGet>(globalObject, decoder);
    case MessageName::WebExtensionContext_CookiesGetAll:
        return jsValueForDecodedMessage<MessageName::WebExtensionContext_CookiesGetAll>(globalObject, decoder);
    case MessageName::WebExtensionContext_CookiesSet:
        return jsValueForDecodedMessage<MessageName::WebExtensionContext_CookiesSet>(globalObject, decoder);
    case MessageName::WebExtensionContext_CookiesRemove:
        return jsValueForDecodedMessage<MessageName::WebExtensionContext_CookiesRemove>(globalObject, decoder);
    case MessageName::WebExtensionContext_CookiesGetAllCookieStores:
        return jsValueForDecodedMessage<MessageName::WebExtensionContext_CookiesGetAllCookieStores>(globalObject, decoder);
    case MessageName::WebExtensionContext_DeclarativeNetRequestGetEnabledRulesets:
        return jsValueForDecodedMessage<MessageName::WebExtensionContext_DeclarativeNetRequestGetEnabledRulesets>(globalObject, decoder);
    case MessageName::WebExtensionContext_DeclarativeNetRequestUpdateEnabledRulesets:
        return jsValueForDecodedMessage<MessageName::WebExtensionContext_DeclarativeNetRequestUpdateEnabledRulesets>(globalObject, decoder);
    case MessageName::WebExtensionContext_DeclarativeNetRequestDisplayActionCountAsBadgeText:
        return jsValueForDecodedMessage<MessageName::WebExtensionContext_DeclarativeNetRequestDisplayActionCountAsBadgeText>(globalObject, decoder);
    case MessageName::WebExtensionContext_DeclarativeNetRequestIncrementActionCount:
        return jsValueForDecodedMessage<MessageName::WebExtensionContext_DeclarativeNetRequestIncrementActionCount>(globalObject, decoder);
    case MessageName::WebExtensionContext_DeclarativeNetRequestGetMatchedRules:
        return jsValueForDecodedMessage<MessageName::WebExtensionContext_DeclarativeNetRequestGetMatchedRules>(globalObject, decoder);
    case MessageName::WebExtensionContext_DeclarativeNetRequestGetDynamicRules:
        return jsValueForDecodedMessage<MessageName::WebExtensionContext_DeclarativeNetRequestGetDynamicRules>(globalObject, decoder);
    case MessageName::WebExtensionContext_DeclarativeNetRequestUpdateDynamicRules:
        return jsValueForDecodedMessage<MessageName::WebExtensionContext_DeclarativeNetRequestUpdateDynamicRules>(globalObject, decoder);
    case MessageName::WebExtensionContext_DeclarativeNetRequestGetSessionRules:
        return jsValueForDecodedMessage<MessageName::WebExtensionContext_DeclarativeNetRequestGetSessionRules>(globalObject, decoder);
    case MessageName::WebExtensionContext_DeclarativeNetRequestUpdateSessionRules:
        return jsValueForDecodedMessage<MessageName::WebExtensionContext_DeclarativeNetRequestUpdateSessionRules>(globalObject, decoder);
#if ENABLE(INSPECTOR_EXTENSIONS)
    case MessageName::WebExtensionContext_DevToolsPanelsCreate:
        return jsValueForDecodedMessage<MessageName::WebExtensionContext_DevToolsPanelsCreate>(globalObject, decoder);
    case MessageName::WebExtensionContext_DevToolsInspectedWindowEval:
        return jsValueForDecodedMessage<MessageName::WebExtensionContext_DevToolsInspectedWindowEval>(globalObject, decoder);
    case MessageName::WebExtensionContext_DevToolsInspectedWindowReload:
        return jsValueForDecodedMessage<MessageName::WebExtensionContext_DevToolsInspectedWindowReload>(globalObject, decoder);
#endif
    case MessageName::WebExtensionContext_AddListener:
        return jsValueForDecodedMessage<MessageName::WebExtensionContext_AddListener>(globalObject, decoder);
    case MessageName::WebExtensionContext_RemoveListener:
        return jsValueForDecodedMessage<MessageName::WebExtensionContext_RemoveListener>(globalObject, decoder);
    case MessageName::WebExtensionContext_ExtensionIsAllowedIncognitoAccess:
        return jsValueForDecodedMessage<MessageName::WebExtensionContext_ExtensionIsAllowedIncognitoAccess>(globalObject, decoder);
    case MessageName::WebExtensionContext_MenusCreate:
        return jsValueForDecodedMessage<MessageName::WebExtensionContext_MenusCreate>(globalObject, decoder);
    case MessageName::WebExtensionContext_MenusUpdate:
        return jsValueForDecodedMessage<MessageName::WebExtensionContext_MenusUpdate>(globalObject, decoder);
    case MessageName::WebExtensionContext_MenusRemove:
        return jsValueForDecodedMessage<MessageName::WebExtensionContext_MenusRemove>(globalObject, decoder);
    case MessageName::WebExtensionContext_MenusRemoveAll:
        return jsValueForDecodedMessage<MessageName::WebExtensionContext_MenusRemoveAll>(globalObject, decoder);
    case MessageName::WebExtensionContext_PermissionsGetAll:
        return jsValueForDecodedMessage<MessageName::WebExtensionContext_PermissionsGetAll>(globalObject, decoder);
    case MessageName::WebExtensionContext_PermissionsContains:
        return jsValueForDecodedMessage<MessageName::WebExtensionContext_PermissionsContains>(globalObject, decoder);
    case MessageName::WebExtensionContext_PermissionsRequest:
        return jsValueForDecodedMessage<MessageName::WebExtensionContext_PermissionsRequest>(globalObject, decoder);
    case MessageName::WebExtensionContext_PermissionsRemove:
        return jsValueForDecodedMessage<MessageName::WebExtensionContext_PermissionsRemove>(globalObject, decoder);
    case MessageName::WebExtensionContext_PortPostMessage:
        return jsValueForDecodedMessage<MessageName::WebExtensionContext_PortPostMessage>(globalObject, decoder);
    case MessageName::WebExtensionContext_PortRemoved:
        return jsValueForDecodedMessage<MessageName::WebExtensionContext_PortRemoved>(globalObject, decoder);
    case MessageName::WebExtensionContext_RuntimeGetBackgroundPage:
        return jsValueForDecodedMessage<MessageName::WebExtensionContext_RuntimeGetBackgroundPage>(globalObject, decoder);
    case MessageName::WebExtensionContext_RuntimeOpenOptionsPage:
        return jsValueForDecodedMessage<MessageName::WebExtensionContext_RuntimeOpenOptionsPage>(globalObject, decoder);
    case MessageName::WebExtensionContext_RuntimeReload:
        return jsValueForDecodedMessage<MessageName::WebExtensionContext_RuntimeReload>(globalObject, decoder);
    case MessageName::WebExtensionContext_RuntimeSendMessage:
        return jsValueForDecodedMessage<MessageName::WebExtensionContext_RuntimeSendMessage>(globalObject, decoder);
    case MessageName::WebExtensionContext_RuntimeConnect:
        return jsValueForDecodedMessage<MessageName::WebExtensionContext_RuntimeConnect>(globalObject, decoder);
    case MessageName::WebExtensionContext_RuntimeSendNativeMessage:
        return jsValueForDecodedMessage<MessageName::WebExtensionContext_RuntimeSendNativeMessage>(globalObject, decoder);
    case MessageName::WebExtensionContext_RuntimeConnectNative:
        return jsValueForDecodedMessage<MessageName::WebExtensionContext_RuntimeConnectNative>(globalObject, decoder);
    case MessageName::WebExtensionContext_RuntimeWebPageSendMessage:
        return jsValueForDecodedMessage<MessageName::WebExtensionContext_RuntimeWebPageSendMessage>(globalObject, decoder);
    case MessageName::WebExtensionContext_RuntimeWebPageConnect:
        return jsValueForDecodedMessage<MessageName::WebExtensionContext_RuntimeWebPageConnect>(globalObject, decoder);
    case MessageName::WebExtensionContext_ScriptingExecuteScript:
        return jsValueForDecodedMessage<MessageName::WebExtensionContext_ScriptingExecuteScript>(globalObject, decoder);
    case MessageName::WebExtensionContext_ScriptingInsertCSS:
        return jsValueForDecodedMessage<MessageName::WebExtensionContext_ScriptingInsertCSS>(globalObject, decoder);
    case MessageName::WebExtensionContext_ScriptingRemoveCSS:
        return jsValueForDecodedMessage<MessageName::WebExtensionContext_ScriptingRemoveCSS>(globalObject, decoder);
    case MessageName::WebExtensionContext_ScriptingRegisterContentScripts:
        return jsValueForDecodedMessage<MessageName::WebExtensionContext_ScriptingRegisterContentScripts>(globalObject, decoder);
    case MessageName::WebExtensionContext_ScriptingUpdateRegisteredScripts:
        return jsValueForDecodedMessage<MessageName::WebExtensionContext_ScriptingUpdateRegisteredScripts>(globalObject, decoder);
    case MessageName::WebExtensionContext_ScriptingGetRegisteredScripts:
        return jsValueForDecodedMessage<MessageName::WebExtensionContext_ScriptingGetRegisteredScripts>(globalObject, decoder);
    case MessageName::WebExtensionContext_ScriptingUnregisterContentScripts:
        return jsValueForDecodedMessage<MessageName::WebExtensionContext_ScriptingUnregisterContentScripts>(globalObject, decoder);
#if ENABLE(WK_WEB_EXTENSIONS_SIDEBAR)
    case MessageName::WebExtensionContext_SidebarOpen:
        return jsValueForDecodedMessage<MessageName::WebExtensionContext_SidebarOpen>(globalObject, decoder);
    case MessageName::WebExtensionContext_SidebarIsOpen:
        return jsValueForDecodedMessage<MessageName::WebExtensionContext_SidebarIsOpen>(globalObject, decoder);
    case MessageName::WebExtensionContext_SidebarClose:
        return jsValueForDecodedMessage<MessageName::WebExtensionContext_SidebarClose>(globalObject, decoder);
    case MessageName::WebExtensionContext_SidebarToggle:
        return jsValueForDecodedMessage<MessageName::WebExtensionContext_SidebarToggle>(globalObject, decoder);
    case MessageName::WebExtensionContext_SidebarGetOptions:
        return jsValueForDecodedMessage<MessageName::WebExtensionContext_SidebarGetOptions>(globalObject, decoder);
    case MessageName::WebExtensionContext_SidebarSetOptions:
        return jsValueForDecodedMessage<MessageName::WebExtensionContext_SidebarSetOptions>(globalObject, decoder);
    case MessageName::WebExtensionContext_SidebarGetTitle:
        return jsValueForDecodedMessage<MessageName::WebExtensionContext_SidebarGetTitle>(globalObject, decoder);
    case MessageName::WebExtensionContext_SidebarSetTitle:
        return jsValueForDecodedMessage<MessageName::WebExtensionContext_SidebarSetTitle>(globalObject, decoder);
    case MessageName::WebExtensionContext_SidebarSetIcon:
        return jsValueForDecodedMessage<MessageName::WebExtensionContext_SidebarSetIcon>(globalObject, decoder);
    case MessageName::WebExtensionContext_SidebarSetActionClickBehavior:
        return jsValueForDecodedMessage<MessageName::WebExtensionContext_SidebarSetActionClickBehavior>(globalObject, decoder);
    case MessageName::WebExtensionContext_SidebarGetActionClickBehavior:
        return jsValueForDecodedMessage<MessageName::WebExtensionContext_SidebarGetActionClickBehavior>(globalObject, decoder);
#endif
    case MessageName::WebExtensionContext_StorageGet:
        return jsValueForDecodedMessage<MessageName::WebExtensionContext_StorageGet>(globalObject, decoder);
    case MessageName::WebExtensionContext_StorageGetKeys:
        return jsValueForDecodedMessage<MessageName::WebExtensionContext_StorageGetKeys>(globalObject, decoder);
    case MessageName::WebExtensionContext_StorageGetBytesInUse:
        return jsValueForDecodedMessage<MessageName::WebExtensionContext_StorageGetBytesInUse>(globalObject, decoder);
    case MessageName::WebExtensionContext_StorageSet:
        return jsValueForDecodedMessage<MessageName::WebExtensionContext_StorageSet>(globalObject, decoder);
    case MessageName::WebExtensionContext_StorageRemove:
        return jsValueForDecodedMessage<MessageName::WebExtensionContext_StorageRemove>(globalObject, decoder);
    case MessageName::WebExtensionContext_StorageClear:
        return jsValueForDecodedMessage<MessageName::WebExtensionContext_StorageClear>(globalObject, decoder);
    case MessageName::WebExtensionContext_StorageSetAccessLevel:
        return jsValueForDecodedMessage<MessageName::WebExtensionContext_StorageSetAccessLevel>(globalObject, decoder);
    case MessageName::WebExtensionContext_TabsCreate:
        return jsValueForDecodedMessage<MessageName::WebExtensionContext_TabsCreate>(globalObject, decoder);
    case MessageName::WebExtensionContext_TabsUpdate:
        return jsValueForDecodedMessage<MessageName::WebExtensionContext_TabsUpdate>(globalObject, decoder);
    case MessageName::WebExtensionContext_TabsDuplicate:
        return jsValueForDecodedMessage<MessageName::WebExtensionContext_TabsDuplicate>(globalObject, decoder);
    case MessageName::WebExtensionContext_TabsGet:
        return jsValueForDecodedMessage<MessageName::WebExtensionContext_TabsGet>(globalObject, decoder);
    case MessageName::WebExtensionContext_TabsGetCurrent:
        return jsValueForDecodedMessage<MessageName::WebExtensionContext_TabsGetCurrent>(globalObject, decoder);
    case MessageName::WebExtensionContext_TabsQuery:
        return jsValueForDecodedMessage<MessageName::WebExtensionContext_TabsQuery>(globalObject, decoder);
    case MessageName::WebExtensionContext_TabsReload:
        return jsValueForDecodedMessage<MessageName::WebExtensionContext_TabsReload>(globalObject, decoder);
    case MessageName::WebExtensionContext_TabsGoBack:
        return jsValueForDecodedMessage<MessageName::WebExtensionContext_TabsGoBack>(globalObject, decoder);
    case MessageName::WebExtensionContext_TabsGoForward:
        return jsValueForDecodedMessage<MessageName::WebExtensionContext_TabsGoForward>(globalObject, decoder);
    case MessageName::WebExtensionContext_TabsDetectLanguage:
        return jsValueForDecodedMessage<MessageName::WebExtensionContext_TabsDetectLanguage>(globalObject, decoder);
    case MessageName::WebExtensionContext_TabsToggleReaderMode:
        return jsValueForDecodedMessage<MessageName::WebExtensionContext_TabsToggleReaderMode>(globalObject, decoder);
    case MessageName::WebExtensionContext_TabsCaptureVisibleTab:
        return jsValueForDecodedMessage<MessageName::WebExtensionContext_TabsCaptureVisibleTab>(globalObject, decoder);
    case MessageName::WebExtensionContext_TabsSendMessage:
        return jsValueForDecodedMessage<MessageName::WebExtensionContext_TabsSendMessage>(globalObject, decoder);
    case MessageName::WebExtensionContext_TabsConnect:
        return jsValueForDecodedMessage<MessageName::WebExtensionContext_TabsConnect>(globalObject, decoder);
    case MessageName::WebExtensionContext_TabsGetZoom:
        return jsValueForDecodedMessage<MessageName::WebExtensionContext_TabsGetZoom>(globalObject, decoder);
    case MessageName::WebExtensionContext_TabsSetZoom:
        return jsValueForDecodedMessage<MessageName::WebExtensionContext_TabsSetZoom>(globalObject, decoder);
    case MessageName::WebExtensionContext_TabsRemove:
        return jsValueForDecodedMessage<MessageName::WebExtensionContext_TabsRemove>(globalObject, decoder);
    case MessageName::WebExtensionContext_TabsExecuteScript:
        return jsValueForDecodedMessage<MessageName::WebExtensionContext_TabsExecuteScript>(globalObject, decoder);
    case MessageName::WebExtensionContext_TabsInsertCSS:
        return jsValueForDecodedMessage<MessageName::WebExtensionContext_TabsInsertCSS>(globalObject, decoder);
    case MessageName::WebExtensionContext_TabsRemoveCSS:
        return jsValueForDecodedMessage<MessageName::WebExtensionContext_TabsRemoveCSS>(globalObject, decoder);
    case MessageName::WebExtensionContext_WebNavigationGetAllFrames:
        return jsValueForDecodedMessage<MessageName::WebExtensionContext_WebNavigationGetAllFrames>(globalObject, decoder);
    case MessageName::WebExtensionContext_WebNavigationGetFrame:
        return jsValueForDecodedMessage<MessageName::WebExtensionContext_WebNavigationGetFrame>(globalObject, decoder);
    case MessageName::WebExtensionContext_WindowsCreate:
        return jsValueForDecodedMessage<MessageName::WebExtensionContext_WindowsCreate>(globalObject, decoder);
    case MessageName::WebExtensionContext_WindowsGet:
        return jsValueForDecodedMessage<MessageName::WebExtensionContext_WindowsGet>(globalObject, decoder);
    case MessageName::WebExtensionContext_WindowsGetLastFocused:
        return jsValueForDecodedMessage<MessageName::WebExtensionContext_WindowsGetLastFocused>(globalObject, decoder);
    case MessageName::WebExtensionContext_WindowsGetAll:
        return jsValueForDecodedMessage<MessageName::WebExtensionContext_WindowsGetAll>(globalObject, decoder);
    case MessageName::WebExtensionContext_WindowsUpdate:
        return jsValueForDecodedMessage<MessageName::WebExtensionContext_WindowsUpdate>(globalObject, decoder);
    case MessageName::WebExtensionContext_WindowsRemove:
        return jsValueForDecodedMessage<MessageName::WebExtensionContext_WindowsRemove>(globalObject, decoder);
#endif
#if ENABLE(WK_WEB_EXTENSIONS)
    case MessageName::WebExtensionController_DidStartProvisionalLoadForFrame:
        return jsValueForDecodedMessage<MessageName::WebExtensionController_DidStartProvisionalLoadForFrame>(globalObject, decoder);
    case MessageName::WebExtensionController_DidCommitLoadForFrame:
        return jsValueForDecodedMessage<MessageName::WebExtensionController_DidCommitLoadForFrame>(globalObject, decoder);
    case MessageName::WebExtensionController_DidFinishLoadForFrame:
        return jsValueForDecodedMessage<MessageName::WebExtensionController_DidFinishLoadForFrame>(globalObject, decoder);
    case MessageName::WebExtensionController_DidFailLoadForFrame:
        return jsValueForDecodedMessage<MessageName::WebExtensionController_DidFailLoadForFrame>(globalObject, decoder);
    case MessageName::WebExtensionController_TestResult:
        return jsValueForDecodedMessage<MessageName::WebExtensionController_TestResult>(globalObject, decoder);
    case MessageName::WebExtensionController_TestEqual:
        return jsValueForDecodedMessage<MessageName::WebExtensionController_TestEqual>(globalObject, decoder);
    case MessageName::WebExtensionController_TestLogMessage:
        return jsValueForDecodedMessage<MessageName::WebExtensionController_TestLogMessage>(globalObject, decoder);
    case MessageName::WebExtensionController_TestSentMessage:
        return jsValueForDecodedMessage<MessageName::WebExtensionController_TestSentMessage>(globalObject, decoder);
    case MessageName::WebExtensionController_TestAdded:
        return jsValueForDecodedMessage<MessageName::WebExtensionController_TestAdded>(globalObject, decoder);
    case MessageName::WebExtensionController_TestStarted:
        return jsValueForDecodedMessage<MessageName::WebExtensionController_TestStarted>(globalObject, decoder);
    case MessageName::WebExtensionController_TestFinished:
        return jsValueForDecodedMessage<MessageName::WebExtensionController_TestFinished>(globalObject, decoder);
#endif
#if ENABLE(MEDIA_SESSION_COORDINATOR)
    case MessageName::RemoteMediaSessionCoordinatorProxy_Join:
        return jsValueForDecodedMessage<MessageName::RemoteMediaSessionCoordinatorProxy_Join>(globalObject, decoder);
    case MessageName::RemoteMediaSessionCoordinatorProxy_Leave:
        return jsValueForDecodedMessage<MessageName::RemoteMediaSessionCoordinatorProxy_Leave>(globalObject, decoder);
    case MessageName::RemoteMediaSessionCoordinatorProxy_CoordinateSeekTo:
        return jsValueForDecodedMessage<MessageName::RemoteMediaSessionCoordinatorProxy_CoordinateSeekTo>(globalObject, decoder);
    case MessageName::RemoteMediaSessionCoordinatorProxy_CoordinatePlay:
        return jsValueForDecodedMessage<MessageName::RemoteMediaSessionCoordinatorProxy_CoordinatePlay>(globalObject, decoder);
    case MessageName::RemoteMediaSessionCoordinatorProxy_CoordinatePause:
        return jsValueForDecodedMessage<MessageName::RemoteMediaSessionCoordinatorProxy_CoordinatePause>(globalObject, decoder);
    case MessageName::RemoteMediaSessionCoordinatorProxy_CoordinateSetTrack:
        return jsValueForDecodedMessage<MessageName::RemoteMediaSessionCoordinatorProxy_CoordinateSetTrack>(globalObject, decoder);
    case MessageName::RemoteMediaSessionCoordinatorProxy_PositionStateChanged:
        return jsValueForDecodedMessage<MessageName::RemoteMediaSessionCoordinatorProxy_PositionStateChanged>(globalObject, decoder);
    case MessageName::RemoteMediaSessionCoordinatorProxy_ReadyStateChanged:
        return jsValueForDecodedMessage<MessageName::RemoteMediaSessionCoordinatorProxy_ReadyStateChanged>(globalObject, decoder);
    case MessageName::RemoteMediaSessionCoordinatorProxy_PlaybackStateChanged:
        return jsValueForDecodedMessage<MessageName::RemoteMediaSessionCoordinatorProxy_PlaybackStateChanged>(globalObject, decoder);
    case MessageName::RemoteMediaSessionCoordinatorProxy_TrackIdentifierChanged:
        return jsValueForDecodedMessage<MessageName::RemoteMediaSessionCoordinatorProxy_TrackIdentifierChanged>(globalObject, decoder);
#endif
#if ENABLE(MEDIA_STREAM)
    case MessageName::SpeechRecognitionRemoteRealtimeMediaSourceManager_RemoteAudioSamplesAvailable:
        return jsValueForDecodedMessage<MessageName::SpeechRecognitionRemoteRealtimeMediaSourceManager_RemoteAudioSamplesAvailable>(globalObject, decoder);
    case MessageName::SpeechRecognitionRemoteRealtimeMediaSourceManager_RemoteCaptureFailed:
        return jsValueForDecodedMessage<MessageName::SpeechRecognitionRemoteRealtimeMediaSourceManager_RemoteCaptureFailed>(globalObject, decoder);
    case MessageName::SpeechRecognitionRemoteRealtimeMediaSourceManager_RemoteSourceStopped:
        return jsValueForDecodedMessage<MessageName::SpeechRecognitionRemoteRealtimeMediaSourceManager_RemoteSourceStopped>(globalObject, decoder);
#if PLATFORM(COCOA)
    case MessageName::SpeechRecognitionRemoteRealtimeMediaSourceManager_SetStorage:
        return jsValueForDecodedMessage<MessageName::SpeechRecognitionRemoteRealtimeMediaSourceManager_SetStorage>(globalObject, decoder);
#endif
#endif
    case MessageName::SpeechRecognitionServer_Start:
        return jsValueForDecodedMessage<MessageName::SpeechRecognitionServer_Start>(globalObject, decoder);
    case MessageName::SpeechRecognitionServer_Stop:
        return jsValueForDecodedMessage<MessageName::SpeechRecognitionServer_Stop>(globalObject, decoder);
    case MessageName::SpeechRecognitionServer_Abort:
        return jsValueForDecodedMessage<MessageName::SpeechRecognitionServer_Abort>(globalObject, decoder);
    case MessageName::SpeechRecognitionServer_Invalidate:
        return jsValueForDecodedMessage<MessageName::SpeechRecognitionServer_Invalidate>(globalObject, decoder);
    case MessageName::VisitedLinkStore_AddVisitedLinkHashFromPage:
        return jsValueForDecodedMessage<MessageName::VisitedLinkStore_AddVisitedLinkHashFromPage>(globalObject, decoder);
    case MessageName::WebFrameProxy_UpdateRemoteFrameSize:
        return jsValueForDecodedMessage<MessageName::WebFrameProxy_UpdateRemoteFrameSize>(globalObject, decoder);
    case MessageName::WebFrameProxy_SetAppBadge:
        return jsValueForDecodedMessage<MessageName::WebFrameProxy_SetAppBadge>(globalObject, decoder);
    case MessageName::WebFrameProxy_FindFocusableElementDescendingIntoRemoteFrame:
        return jsValueForDecodedMessage<MessageName::WebFrameProxy_FindFocusableElementDescendingIntoRemoteFrame>(globalObject, decoder);
#if ENABLE(FULLSCREEN_API)
    case MessageName::WebFullScreenManagerProxy_EnterFullScreen:
        return jsValueForDecodedMessage<MessageName::WebFullScreenManagerProxy_EnterFullScreen>(globalObject, decoder);
#if ENABLE(QUICKLOOK_FULLSCREEN)
    case MessageName::WebFullScreenManagerProxy_UpdateImageSource:
        return jsValueForDecodedMessage<MessageName::WebFullScreenManagerProxy_UpdateImageSource>(globalObject, decoder);
#endif
    case MessageName::WebFullScreenManagerProxy_ExitFullScreen:
        return jsValueForDecodedMessage<MessageName::WebFullScreenManagerProxy_ExitFullScreen>(globalObject, decoder);
    case MessageName::WebFullScreenManagerProxy_BeganEnterFullScreen:
        return jsValueForDecodedMessage<MessageName::WebFullScreenManagerProxy_BeganEnterFullScreen>(globalObject, decoder);
    case MessageName::WebFullScreenManagerProxy_BeganExitFullScreen:
        return jsValueForDecodedMessage<MessageName::WebFullScreenManagerProxy_BeganExitFullScreen>(globalObject, decoder);
    case MessageName::WebFullScreenManagerProxy_Close:
        return jsValueForDecodedMessage<MessageName::WebFullScreenManagerProxy_Close>(globalObject, decoder);
#endif
    case MessageName::WebGeolocationManagerProxy_StartUpdating:
        return jsValueForDecodedMessage<MessageName::WebGeolocationManagerProxy_StartUpdating>(globalObject, decoder);
    case MessageName::WebGeolocationManagerProxy_StopUpdating:
        return jsValueForDecodedMessage<MessageName::WebGeolocationManagerProxy_StopUpdating>(globalObject, decoder);
    case MessageName::WebGeolocationManagerProxy_SetEnableHighAccuracy:
        return jsValueForDecodedMessage<MessageName::WebGeolocationManagerProxy_SetEnableHighAccuracy>(globalObject, decoder);
    case MessageName::WebLockRegistryProxy_RequestLock:
        return jsValueForDecodedMessage<MessageName::WebLockRegistryProxy_RequestLock>(globalObject, decoder);
    case MessageName::WebLockRegistryProxy_ReleaseLock:
        return jsValueForDecodedMessage<MessageName::WebLockRegistryProxy_ReleaseLock>(globalObject, decoder);
    case MessageName::WebLockRegistryProxy_AbortLockRequest:
        return jsValueForDecodedMessage<MessageName::WebLockRegistryProxy_AbortLockRequest>(globalObject, decoder);
    case MessageName::WebLockRegistryProxy_Snapshot:
        return jsValueForDecodedMessage<MessageName::WebLockRegistryProxy_Snapshot>(globalObject, decoder);
    case MessageName::WebLockRegistryProxy_ClientIsGoingAway:
        return jsValueForDecodedMessage<MessageName::WebLockRegistryProxy_ClientIsGoingAway>(globalObject, decoder);
    case MessageName::WebPageProxy_CreateNewPage:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_CreateNewPage>(globalObject, decoder);
    case MessageName::WebPageProxy_ShowPage:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_ShowPage>(globalObject, decoder);
    case MessageName::WebPageProxy_ClosePage:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_ClosePage>(globalObject, decoder);
    case MessageName::WebPageProxy_RunJavaScriptAlert:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_RunJavaScriptAlert>(globalObject, decoder);
    case MessageName::WebPageProxy_RunJavaScriptConfirm:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_RunJavaScriptConfirm>(globalObject, decoder);
    case MessageName::WebPageProxy_RunJavaScriptPrompt:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_RunJavaScriptPrompt>(globalObject, decoder);
    case MessageName::WebPageProxy_MouseDidMoveOverElement:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_MouseDidMoveOverElement>(globalObject, decoder);
    case MessageName::WebPageProxy_DidReceiveEventIPC:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_DidReceiveEventIPC>(globalObject, decoder);
    case MessageName::WebPageProxy_SetCursor:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_SetCursor>(globalObject, decoder);
    case MessageName::WebPageProxy_SetCursorHiddenUntilMouseMoves:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_SetCursorHiddenUntilMouseMoves>(globalObject, decoder);
    case MessageName::WebPageProxy_SetFocus:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_SetFocus>(globalObject, decoder);
    case MessageName::WebPageProxy_TakeFocus:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_TakeFocus>(globalObject, decoder);
    case MessageName::WebPageProxy_FocusFromServiceWorker:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_FocusFromServiceWorker>(globalObject, decoder);
    case MessageName::WebPageProxy_FocusedFrameChanged:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_FocusedFrameChanged>(globalObject, decoder);
    case MessageName::WebPageProxy_SetRenderTreeSize:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_SetRenderTreeSize>(globalObject, decoder);
    case MessageName::WebPageProxy_SetToolbarsAreVisible:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_SetToolbarsAreVisible>(globalObject, decoder);
    case MessageName::WebPageProxy_GetToolbarsAreVisible:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_GetToolbarsAreVisible>(globalObject, decoder);
    case MessageName::WebPageProxy_SetMenuBarIsVisible:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_SetMenuBarIsVisible>(globalObject, decoder);
    case MessageName::WebPageProxy_GetMenuBarIsVisible:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_GetMenuBarIsVisible>(globalObject, decoder);
    case MessageName::WebPageProxy_SetStatusBarIsVisible:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_SetStatusBarIsVisible>(globalObject, decoder);
    case MessageName::WebPageProxy_GetStatusBarIsVisible:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_GetStatusBarIsVisible>(globalObject, decoder);
    case MessageName::WebPageProxy_SetIsResizable:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_SetIsResizable>(globalObject, decoder);
    case MessageName::WebPageProxy_SetWindowFrame:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_SetWindowFrame>(globalObject, decoder);
    case MessageName::WebPageProxy_GetWindowFrame:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_GetWindowFrame>(globalObject, decoder);
    case MessageName::WebPageProxy_ScreenToRootView:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_ScreenToRootView>(globalObject, decoder);
    case MessageName::WebPageProxy_RootViewPointToScreen:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_RootViewPointToScreen>(globalObject, decoder);
    case MessageName::WebPageProxy_RootViewRectToScreen:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_RootViewRectToScreen>(globalObject, decoder);
    case MessageName::WebPageProxy_AccessibilityScreenToRootView:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_AccessibilityScreenToRootView>(globalObject, decoder);
    case MessageName::WebPageProxy_RootViewToAccessibilityScreen:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_RootViewToAccessibilityScreen>(globalObject, decoder);
#if PLATFORM(IOS_FAMILY)
    case MessageName::WebPageProxy_RelayAccessibilityNotification:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_RelayAccessibilityNotification>(globalObject, decoder);
#endif
    case MessageName::WebPageProxy_EnableAccessibilityForAllProcesses:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_EnableAccessibilityForAllProcesses>(globalObject, decoder);
#if PLATFORM(COCOA) || PLATFORM(GTK)
    case MessageName::WebPageProxy_ShowValidationMessage:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_ShowValidationMessage>(globalObject, decoder);
    case MessageName::WebPageProxy_HideValidationMessage:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_HideValidationMessage>(globalObject, decoder);
#endif
    case MessageName::WebPageProxy_RunBeforeUnloadConfirmPanel:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_RunBeforeUnloadConfirmPanel>(globalObject, decoder);
    case MessageName::WebPageProxy_PageDidScroll:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_PageDidScroll>(globalObject, decoder);
    case MessageName::WebPageProxy_SetHasActiveAnimatedScrolls:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_SetHasActiveAnimatedScrolls>(globalObject, decoder);
    case MessageName::WebPageProxy_RunOpenPanel:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_RunOpenPanel>(globalObject, decoder);
    case MessageName::WebPageProxy_ShowShareSheet:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_ShowShareSheet>(globalObject, decoder);
    case MessageName::WebPageProxy_ShowContactPicker:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_ShowContactPicker>(globalObject, decoder);
#if HAVE(DIGITAL_CREDENTIALS_UI)
    case MessageName::WebPageProxy_ShowDigitalCredentialsPicker:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_ShowDigitalCredentialsPicker>(globalObject, decoder);
    case MessageName::WebPageProxy_DismissDigitalCredentialsPicker:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_DismissDigitalCredentialsPicker>(globalObject, decoder);
#endif
    case MessageName::WebPageProxy_PrintFrame:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_PrintFrame>(globalObject, decoder);
    case MessageName::WebPageProxy_RunModal:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_RunModal>(globalObject, decoder);
    case MessageName::WebPageProxy_NotifyScrollerThumbIsVisibleInRect:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_NotifyScrollerThumbIsVisibleInRect>(globalObject, decoder);
    case MessageName::WebPageProxy_RecommendedScrollbarStyleDidChange:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_RecommendedScrollbarStyleDidChange>(globalObject, decoder);
    case MessageName::WebPageProxy_DidChangeScrollbarsForMainFrame:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_DidChangeScrollbarsForMainFrame>(globalObject, decoder);
    case MessageName::WebPageProxy_DidChangeScrollOffsetPinningForMainFrame:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_DidChangeScrollOffsetPinningForMainFrame>(globalObject, decoder);
    case MessageName::WebPageProxy_DidChangePageCount:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_DidChangePageCount>(globalObject, decoder);
#if PLATFORM(MAC) || PLATFORM(WPE) || PLATFORM(GTK)
    case MessageName::WebPageProxy_ThemeColorChanged:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_ThemeColorChanged>(globalObject, decoder);
#endif
#if ENABLE(WEB_PAGE_SPATIAL_BACKDROP)
    case MessageName::WebPageProxy_SpatialBackdropSourceChanged:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_SpatialBackdropSourceChanged>(globalObject, decoder);
#endif
    case MessageName::WebPageProxy_PageExtendedBackgroundColorDidChange:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_PageExtendedBackgroundColorDidChange>(globalObject, decoder);
    case MessageName::WebPageProxy_SampledPageTopColorChanged:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_SampledPageTopColorChanged>(globalObject, decoder);
    case MessageName::WebPageProxy_SetCanShortCircuitHorizontalWheelEvents:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_SetCanShortCircuitHorizontalWheelEvents>(globalObject, decoder);
    case MessageName::WebPageProxy_DidChangeContentSize:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_DidChangeContentSize>(globalObject, decoder);
    case MessageName::WebPageProxy_DidChangeIntrinsicContentSize:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_DidChangeIntrinsicContentSize>(globalObject, decoder);
    case MessageName::WebPageProxy_ShowColorPicker:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_ShowColorPicker>(globalObject, decoder);
    case MessageName::WebPageProxy_SetColorPickerColor:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_SetColorPickerColor>(globalObject, decoder);
    case MessageName::WebPageProxy_EndColorPicker:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_EndColorPicker>(globalObject, decoder);
    case MessageName::WebPageProxy_ShowDataListSuggestions:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_ShowDataListSuggestions>(globalObject, decoder);
    case MessageName::WebPageProxy_HandleKeydownInDataList:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_HandleKeydownInDataList>(globalObject, decoder);
    case MessageName::WebPageProxy_EndDataListSuggestions:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_EndDataListSuggestions>(globalObject, decoder);
    case MessageName::WebPageProxy_ShowDateTimePicker:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_ShowDateTimePicker>(globalObject, decoder);
    case MessageName::WebPageProxy_EndDateTimePicker:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_EndDateTimePicker>(globalObject, decoder);
    case MessageName::WebPageProxy_DecidePolicyForResponse:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_DecidePolicyForResponse>(globalObject, decoder);
    case MessageName::WebPageProxy_DecidePolicyForNavigationActionAsync:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_DecidePolicyForNavigationActionAsync>(globalObject, decoder);
    case MessageName::WebPageProxy_DecidePolicyForNavigationActionSync:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_DecidePolicyForNavigationActionSync>(globalObject, decoder);
    case MessageName::WebPageProxy_DecidePolicyForNewWindowAction:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_DecidePolicyForNewWindowAction>(globalObject, decoder);
    case MessageName::WebPageProxy_DidChangeProgress:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_DidChangeProgress>(globalObject, decoder);
    case MessageName::WebPageProxy_DidFinishProgress:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_DidFinishProgress>(globalObject, decoder);
    case MessageName::WebPageProxy_DidStartProgress:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_DidStartProgress>(globalObject, decoder);
    case MessageName::WebPageProxy_SetNetworkRequestsInProgress:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_SetNetworkRequestsInProgress>(globalObject, decoder);
    case MessageName::WebPageProxy_StartNetworkRequestsForPageLoadTiming:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_StartNetworkRequestsForPageLoadTiming>(globalObject, decoder);
    case MessageName::WebPageProxy_EndNetworkRequestsForPageLoadTiming:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_EndNetworkRequestsForPageLoadTiming>(globalObject, decoder);
    case MessageName::WebPageProxy_DidCreateSubframe:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_DidCreateSubframe>(globalObject, decoder);
    case MessageName::WebPageProxy_DidDestroyFrame:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_DidDestroyFrame>(globalObject, decoder);
    case MessageName::WebPageProxy_DidStartProvisionalLoadForFrame:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_DidStartProvisionalLoadForFrame>(globalObject, decoder);
    case MessageName::WebPageProxy_DidReceiveServerRedirectForProvisionalLoadForFrame:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_DidReceiveServerRedirectForProvisionalLoadForFrame>(globalObject, decoder);
    case MessageName::WebPageProxy_WillPerformClientRedirectForFrame:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_WillPerformClientRedirectForFrame>(globalObject, decoder);
    case MessageName::WebPageProxy_DidCancelClientRedirectForFrame:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_DidCancelClientRedirectForFrame>(globalObject, decoder);
    case MessageName::WebPageProxy_DidChangeProvisionalURLForFrame:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_DidChangeProvisionalURLForFrame>(globalObject, decoder);
    case MessageName::WebPageProxy_DidFailProvisionalLoadForFrame:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_DidFailProvisionalLoadForFrame>(globalObject, decoder);
    case MessageName::WebPageProxy_DidCommitLoadForFrame:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_DidCommitLoadForFrame>(globalObject, decoder);
    case MessageName::WebPageProxy_DidFailLoadForFrame:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_DidFailLoadForFrame>(globalObject, decoder);
    case MessageName::WebPageProxy_DidFinishDocumentLoadForFrame:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_DidFinishDocumentLoadForFrame>(globalObject, decoder);
    case MessageName::WebPageProxy_DidFinishLoadForFrame:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_DidFinishLoadForFrame>(globalObject, decoder);
    case MessageName::WebPageProxy_DidFirstLayoutForFrame:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_DidFirstLayoutForFrame>(globalObject, decoder);
    case MessageName::WebPageProxy_DidFirstVisuallyNonEmptyLayoutForFrame:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_DidFirstVisuallyNonEmptyLayoutForFrame>(globalObject, decoder);
    case MessageName::WebPageProxy_DidReachLayoutMilestone:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_DidReachLayoutMilestone>(globalObject, decoder);
    case MessageName::WebPageProxy_DidReceiveTitleForFrame:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_DidReceiveTitleForFrame>(globalObject, decoder);
    case MessageName::WebPageProxy_DidDisplayInsecureContentForFrame:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_DidDisplayInsecureContentForFrame>(globalObject, decoder);
    case MessageName::WebPageProxy_DidRunInsecureContentForFrame:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_DidRunInsecureContentForFrame>(globalObject, decoder);
    case MessageName::WebPageProxy_DidSameDocumentNavigationForFrame:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_DidSameDocumentNavigationForFrame>(globalObject, decoder);
    case MessageName::WebPageProxy_DidSameDocumentNavigationForFrameViaJS:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_DidSameDocumentNavigationForFrameViaJS>(globalObject, decoder);
    case MessageName::WebPageProxy_DidChangeMainDocument:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_DidChangeMainDocument>(globalObject, decoder);
    case MessageName::WebPageProxy_DidExplicitOpenForFrame:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_DidExplicitOpenForFrame>(globalObject, decoder);
    case MessageName::WebPageProxy_DidDestroyNavigation:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_DidDestroyNavigation>(globalObject, decoder);
    case MessageName::WebPageProxy_UpdateSandboxFlags:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_UpdateSandboxFlags>(globalObject, decoder);
    case MessageName::WebPageProxy_UpdateOpener:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_UpdateOpener>(globalObject, decoder);
    case MessageName::WebPageProxy_UpdateScrollingMode:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_UpdateScrollingMode>(globalObject, decoder);
    case MessageName::WebPageProxy_ResolveAccessibilityHitTestForTesting:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_ResolveAccessibilityHitTestForTesting>(globalObject, decoder);
    case MessageName::WebPageProxy_MainFramePluginHandlesPageScaleGestureDidChange:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_MainFramePluginHandlesPageScaleGestureDidChange>(globalObject, decoder);
#if PLATFORM(GTK) || PLATFORM(WPE)
    case MessageName::WebPageProxy_DidInitiateLoadForResource:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_DidInitiateLoadForResource>(globalObject, decoder);
    case MessageName::WebPageProxy_DidSendRequestForResource:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_DidSendRequestForResource>(globalObject, decoder);
    case MessageName::WebPageProxy_DidReceiveResponseForResource:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_DidReceiveResponseForResource>(globalObject, decoder);
    case MessageName::WebPageProxy_DidFinishLoadForResource:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_DidFinishLoadForResource>(globalObject, decoder);
#endif
    case MessageName::WebPageProxy_DidNavigateWithNavigationData:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_DidNavigateWithNavigationData>(globalObject, decoder);
    case MessageName::WebPageProxy_DidPerformClientRedirect:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_DidPerformClientRedirect>(globalObject, decoder);
    case MessageName::WebPageProxy_DidPerformServerRedirect:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_DidPerformServerRedirect>(globalObject, decoder);
    case MessageName::WebPageProxy_DidUpdateHistoryTitle:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_DidUpdateHistoryTitle>(globalObject, decoder);
    case MessageName::WebPageProxy_DidFinishLoadingDataForCustomContentProvider:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_DidFinishLoadingDataForCustomContentProvider>(globalObject, decoder);
    case MessageName::WebPageProxy_WillSubmitForm:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_WillSubmitForm>(globalObject, decoder);
#if PLATFORM(IOS_FAMILY)
    case MessageName::WebPageProxy_InterpretKeyEvent:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_InterpretKeyEvent>(globalObject, decoder);
    case MessageName::WebPageProxy_DidReceivePositionInformation:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_DidReceivePositionInformation>(globalObject, decoder);
    case MessageName::WebPageProxy_SaveImageToLibrary:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_SaveImageToLibrary>(globalObject, decoder);
    case MessageName::WebPageProxy_ShowPlaybackTargetPicker:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_ShowPlaybackTargetPicker>(globalObject, decoder);
    case MessageName::WebPageProxy_CommitPotentialTapFailed:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_CommitPotentialTapFailed>(globalObject, decoder);
    case MessageName::WebPageProxy_DidNotHandleTapAsClick:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_DidNotHandleTapAsClick>(globalObject, decoder);
    case MessageName::WebPageProxy_DidCompleteSyntheticClick:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_DidCompleteSyntheticClick>(globalObject, decoder);
    case MessageName::WebPageProxy_DidHandleTapAsHover:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_DidHandleTapAsHover>(globalObject, decoder);
    case MessageName::WebPageProxy_DisableDoubleTapGesturesDuringTapIfNecessary:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_DisableDoubleTapGesturesDuringTapIfNecessary>(globalObject, decoder);
    case MessageName::WebPageProxy_HandleSmartMagnificationInformationForPotentialTap:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_HandleSmartMagnificationInformationForPotentialTap>(globalObject, decoder);
    case MessageName::WebPageProxy_IsPotentialTapInProgress:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_IsPotentialTapInProgress>(globalObject, decoder);
#endif
#if ENABLE(DATA_DETECTION)
    case MessageName::WebPageProxy_SetDataDetectionResult:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_SetDataDetectionResult>(globalObject, decoder);
    case MessageName::WebPageProxy_HandleClickForDataDetectionResult:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_HandleClickForDataDetectionResult>(globalObject, decoder);
#endif
    case MessageName::WebPageProxy_PageScaleFactorDidChange:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_PageScaleFactorDidChange>(globalObject, decoder);
    case MessageName::WebPageProxy_ViewScaleFactorDidChange:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_ViewScaleFactorDidChange>(globalObject, decoder);
    case MessageName::WebPageProxy_PluginScaleFactorDidChange:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_PluginScaleFactorDidChange>(globalObject, decoder);
    case MessageName::WebPageProxy_PluginZoomFactorDidChange:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_PluginZoomFactorDidChange>(globalObject, decoder);
#if PLATFORM(GTK) || PLATFORM(WPE)
    case MessageName::WebPageProxy_BindAccessibilityTree:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_BindAccessibilityTree>(globalObject, decoder);
    case MessageName::WebPageProxy_SetInputMethodState:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_SetInputMethodState>(globalObject, decoder);
#endif
    case MessageName::WebPageProxy_BackForwardAddItem:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_BackForwardAddItem>(globalObject, decoder);
    case MessageName::WebPageProxy_BackForwardSetChildItem:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_BackForwardSetChildItem>(globalObject, decoder);
    case MessageName::WebPageProxy_BackForwardClearChildren:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_BackForwardClearChildren>(globalObject, decoder);
    case MessageName::WebPageProxy_BackForwardUpdateItem:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_BackForwardUpdateItem>(globalObject, decoder);
    case MessageName::WebPageProxy_BackForwardGoToItem:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_BackForwardGoToItem>(globalObject, decoder);
    case MessageName::WebPageProxy_BackForwardItemAtIndex:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_BackForwardItemAtIndex>(globalObject, decoder);
    case MessageName::WebPageProxy_BackForwardListContainsItem:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_BackForwardListContainsItem>(globalObject, decoder);
    case MessageName::WebPageProxy_BackForwardListCounts:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_BackForwardListCounts>(globalObject, decoder);
    case MessageName::WebPageProxy_ShouldGoToBackForwardListItem:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_ShouldGoToBackForwardListItem>(globalObject, decoder);
    case MessageName::WebPageProxy_ShouldGoToBackForwardListItemSync:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_ShouldGoToBackForwardListItemSync>(globalObject, decoder);
    case MessageName::WebPageProxy_RegisterEditCommandForUndo:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_RegisterEditCommandForUndo>(globalObject, decoder);
    case MessageName::WebPageProxy_ClearAllEditCommands:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_ClearAllEditCommands>(globalObject, decoder);
    case MessageName::WebPageProxy_RegisterInsertionUndoGrouping:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_RegisterInsertionUndoGrouping>(globalObject, decoder);
    case MessageName::WebPageProxy_CanUndoRedo:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_CanUndoRedo>(globalObject, decoder);
    case MessageName::WebPageProxy_ExecuteUndoRedo:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_ExecuteUndoRedo>(globalObject, decoder);
    case MessageName::WebPageProxy_LogDiagnosticMessageFromWebProcess:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_LogDiagnosticMessageFromWebProcess>(globalObject, decoder);
    case MessageName::WebPageProxy_LogDiagnosticMessageWithResultFromWebProcess:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_LogDiagnosticMessageWithResultFromWebProcess>(globalObject, decoder);
    case MessageName::WebPageProxy_LogDiagnosticMessageWithValueFromWebProcess:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_LogDiagnosticMessageWithValueFromWebProcess>(globalObject, decoder);
    case MessageName::WebPageProxy_LogDiagnosticMessageWithEnhancedPrivacyFromWebProcess:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_LogDiagnosticMessageWithEnhancedPrivacyFromWebProcess>(globalObject, decoder);
    case MessageName::WebPageProxy_LogDiagnosticMessageWithValueDictionaryFromWebProcess:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_LogDiagnosticMessageWithValueDictionaryFromWebProcess>(globalObject, decoder);
    case MessageName::WebPageProxy_LogDiagnosticMessageWithDomainFromWebProcess:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_LogDiagnosticMessageWithDomainFromWebProcess>(globalObject, decoder);
    case MessageName::WebPageProxy_LogScrollingEvent:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_LogScrollingEvent>(globalObject, decoder);
    case MessageName::WebPageProxy_EditorStateChanged:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_EditorStateChanged>(globalObject, decoder);
    case MessageName::WebPageProxy_CompositionWasCanceled:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_CompositionWasCanceled>(globalObject, decoder);
    case MessageName::WebPageProxy_SetHasFocusedElementWithUserInteraction:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_SetHasFocusedElementWithUserInteraction>(globalObject, decoder);
#if ENABLE(IMAGE_ANALYSIS)
    case MessageName::WebPageProxy_RequestTextRecognition:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_RequestTextRecognition>(globalObject, decoder);
#endif
#if HAVE(TRANSLATION_UI_SERVICES) && ENABLE(CONTEXT_MENUS)
    case MessageName::WebPageProxy_HandleContextMenuTranslation:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_HandleContextMenuTranslation>(globalObject, decoder);
#endif
#if ENABLE(WRITING_TOOLS)
    case MessageName::WebPageProxy_ProofreadingSessionShowDetailsForSuggestionWithIDRelativeToRect:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_ProofreadingSessionShowDetailsForSuggestionWithIDRelativeToRect>(globalObject, decoder);
    case MessageName::WebPageProxy_ProofreadingSessionUpdateStateForSuggestionWithID:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_ProofreadingSessionUpdateStateForSuggestionWithID>(globalObject, decoder);
    case MessageName::WebPageProxy_AddTextAnimationForAnimationID:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_AddTextAnimationForAnimationID>(globalObject, decoder);
    case MessageName::WebPageProxy_AddTextAnimationForAnimationIDWithCompletionHandler:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_AddTextAnimationForAnimationIDWithCompletionHandler>(globalObject, decoder);
    case MessageName::WebPageProxy_RemoveTextAnimationForAnimationID:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_RemoveTextAnimationForAnimationID>(globalObject, decoder);
    case MessageName::WebPageProxy_DidEndPartialIntelligenceTextAnimation:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_DidEndPartialIntelligenceTextAnimation>(globalObject, decoder);
#endif
#if ENABLE(MEDIA_CONTROLS_CONTEXT_MENUS) && USE(UICONTEXTMENU)
    case MessageName::WebPageProxy_ShowMediaControlsContextMenu:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_ShowMediaControlsContextMenu>(globalObject, decoder);
#endif
#if HAVE(TOUCH_BAR)
    case MessageName::WebPageProxy_SetIsTouchBarUpdateSuppressedForHiddenContentEditable:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_SetIsTouchBarUpdateSuppressedForHiddenContentEditable>(globalObject, decoder);
    case MessageName::WebPageProxy_SetIsNeverRichlyEditableForTouchBar:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_SetIsNeverRichlyEditableForTouchBar>(globalObject, decoder);
#endif
    case MessageName::WebPageProxy_RequestDOMPasteAccess:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_RequestDOMPasteAccess>(globalObject, decoder);
    case MessageName::WebPageProxy_SetTextIndicatorFromFrame:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_SetTextIndicatorFromFrame>(globalObject, decoder);
    case MessageName::WebPageProxy_UpdateTextIndicatorFromFrame:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_UpdateTextIndicatorFromFrame>(globalObject, decoder);
    case MessageName::WebPageProxy_ClearTextIndicator:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_ClearTextIndicator>(globalObject, decoder);
    case MessageName::WebPageProxy_DidGetImageForFindMatch:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_DidGetImageForFindMatch>(globalObject, decoder);
    case MessageName::WebPageProxy_ShowPopupMenuFromFrame:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_ShowPopupMenuFromFrame>(globalObject, decoder);
    case MessageName::WebPageProxy_HidePopupMenu:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_HidePopupMenu>(globalObject, decoder);
#if ENABLE(CONTEXT_MENUS)
    case MessageName::WebPageProxy_ShowContextMenuFromFrame:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_ShowContextMenuFromFrame>(globalObject, decoder);
#endif
    case MessageName::WebPageProxy_DidFinishServiceWorkerPageRegistration:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_DidFinishServiceWorkerPageRegistration>(globalObject, decoder);
    case MessageName::WebPageProxy_ExceededDatabaseQuota:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_ExceededDatabaseQuota>(globalObject, decoder);
    case MessageName::WebPageProxy_RequestGeolocationPermissionForFrame:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_RequestGeolocationPermissionForFrame>(globalObject, decoder);
    case MessageName::WebPageProxy_RevokeGeolocationAuthorizationToken:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_RevokeGeolocationAuthorizationToken>(globalObject, decoder);
#if ENABLE(MEDIA_STREAM)
    case MessageName::WebPageProxy_RequestUserMediaPermissionForFrame:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_RequestUserMediaPermissionForFrame>(globalObject, decoder);
    case MessageName::WebPageProxy_EnumerateMediaDevicesForFrame:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_EnumerateMediaDevicesForFrame>(globalObject, decoder);
    case MessageName::WebPageProxy_BeginMonitoringCaptureDevices:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_BeginMonitoringCaptureDevices>(globalObject, decoder);
    case MessageName::WebPageProxy_ValidateCaptureStateUpdate:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_ValidateCaptureStateUpdate>(globalObject, decoder);
    case MessageName::WebPageProxy_SetShouldListenToVoiceActivity:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_SetShouldListenToVoiceActivity>(globalObject, decoder);
#endif
#if ENABLE(ENCRYPTED_MEDIA)
    case MessageName::WebPageProxy_RequestMediaKeySystemPermissionForFrame:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_RequestMediaKeySystemPermissionForFrame>(globalObject, decoder);
#endif
    case MessageName::WebPageProxy_RequestNotificationPermission:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_RequestNotificationPermission>(globalObject, decoder);
#if USE(UNIFIED_TEXT_CHECKING)
    case MessageName::WebPageProxy_CheckTextOfParagraph:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_CheckTextOfParagraph>(globalObject, decoder);
#endif
    case MessageName::WebPageProxy_CheckSpellingOfString:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_CheckSpellingOfString>(globalObject, decoder);
    case MessageName::WebPageProxy_CheckGrammarOfString:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_CheckGrammarOfString>(globalObject, decoder);
    case MessageName::WebPageProxy_SpellingUIIsShowing:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_SpellingUIIsShowing>(globalObject, decoder);
    case MessageName::WebPageProxy_UpdateSpellingUIWithMisspelledWord:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_UpdateSpellingUIWithMisspelledWord>(globalObject, decoder);
    case MessageName::WebPageProxy_UpdateSpellingUIWithGrammarString:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_UpdateSpellingUIWithGrammarString>(globalObject, decoder);
    case MessageName::WebPageProxy_GetGuessesForWord:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_GetGuessesForWord>(globalObject, decoder);
    case MessageName::WebPageProxy_LearnWord:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_LearnWord>(globalObject, decoder);
    case MessageName::WebPageProxy_IgnoreWord:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_IgnoreWord>(globalObject, decoder);
    case MessageName::WebPageProxy_RequestCheckingOfString:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_RequestCheckingOfString>(globalObject, decoder);
#if PLATFORM(COCOA) && ENABLE(DRAG_SUPPORT)
    case MessageName::WebPageProxy_StartDrag:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_StartDrag>(globalObject, decoder);
    case MessageName::WebPageProxy_SetPromisedDataForImage:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_SetPromisedDataForImage>(globalObject, decoder);
#endif
#if (PLATFORM(GTK) || PLATFORM(WPE)) && ENABLE(DRAG_SUPPORT)
    case MessageName::WebPageProxy_StartDrag:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_StartDrag>(globalObject, decoder);
#endif
#if PLATFORM(IOS_FAMILY) && ENABLE(DRAG_SUPPORT)
    case MessageName::WebPageProxy_WillReceiveEditDragSnapshot:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_WillReceiveEditDragSnapshot>(globalObject, decoder);
    case MessageName::WebPageProxy_DidReceiveEditDragSnapshot:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_DidReceiveEditDragSnapshot>(globalObject, decoder);
#endif
#if ENABLE(MODEL_PROCESS)
    case MessageName::WebPageProxy_DidReceiveInteractiveModelElement:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_DidReceiveInteractiveModelElement>(globalObject, decoder);
#endif
#if PLATFORM(COCOA)
    case MessageName::WebPageProxy_DidPerformDictionaryLookup:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_DidPerformDictionaryLookup>(globalObject, decoder);
    case MessageName::WebPageProxy_ExecuteSavedCommandBySelector:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_ExecuteSavedCommandBySelector>(globalObject, decoder);
    case MessageName::WebPageProxy_RegisterWebProcessAccessibilityToken:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_RegisterWebProcessAccessibilityToken>(globalObject, decoder);
    case MessageName::WebPageProxy_GetIsSpeaking:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_GetIsSpeaking>(globalObject, decoder);
    case MessageName::WebPageProxy_MakeFirstResponder:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_MakeFirstResponder>(globalObject, decoder);
    case MessageName::WebPageProxy_AssistiveTechnologyMakeFirstResponder:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_AssistiveTechnologyMakeFirstResponder>(globalObject, decoder);
    case MessageName::WebPageProxy_SearchTheWeb:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_SearchTheWeb>(globalObject, decoder);
#endif
#if USE(APPKIT)
    case MessageName::WebPageProxy_SubstitutionsPanelIsShowing:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_SubstitutionsPanelIsShowing>(globalObject, decoder);
#endif
#if USE(AUTOMATIC_TEXT_REPLACEMENT)
    case MessageName::WebPageProxy_toggleSmartInsertDelete:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_toggleSmartInsertDelete>(globalObject, decoder);
    case MessageName::WebPageProxy_toggleAutomaticQuoteSubstitution:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_toggleAutomaticQuoteSubstitution>(globalObject, decoder);
    case MessageName::WebPageProxy_toggleAutomaticLinkDetection:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_toggleAutomaticLinkDetection>(globalObject, decoder);
    case MessageName::WebPageProxy_toggleAutomaticDashSubstitution:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_toggleAutomaticDashSubstitution>(globalObject, decoder);
    case MessageName::WebPageProxy_toggleAutomaticTextReplacement:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_toggleAutomaticTextReplacement>(globalObject, decoder);
#endif
#if PLATFORM(MAC)
    case MessageName::WebPageProxy_ShowCorrectionPanel:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_ShowCorrectionPanel>(globalObject, decoder);
    case MessageName::WebPageProxy_DismissCorrectionPanel:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_DismissCorrectionPanel>(globalObject, decoder);
    case MessageName::WebPageProxy_DismissCorrectionPanelSoon:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_DismissCorrectionPanelSoon>(globalObject, decoder);
    case MessageName::WebPageProxy_RecordAutocorrectionResponse:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_RecordAutocorrectionResponse>(globalObject, decoder);
    case MessageName::WebPageProxy_SetEditableElementIsFocused:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_SetEditableElementIsFocused>(globalObject, decoder);
    case MessageName::WebPageProxy_HandleAcceptsFirstMouse:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_HandleAcceptsFirstMouse>(globalObject, decoder);
#endif
    case MessageName::WebPageProxy_DidUpdateRenderingAfterCommittingLoad:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_DidUpdateRenderingAfterCommittingLoad>(globalObject, decoder);
#if USE(DICTATION_ALTERNATIVES)
    case MessageName::WebPageProxy_ShowDictationAlternativeUI:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_ShowDictationAlternativeUI>(globalObject, decoder);
    case MessageName::WebPageProxy_RemoveDictationAlternatives:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_RemoveDictationAlternatives>(globalObject, decoder);
    case MessageName::WebPageProxy_DictationAlternatives:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_DictationAlternatives>(globalObject, decoder);
#endif
#if ENABLE(IMAGE_ANALYSIS) && ENABLE(VIDEO)
    case MessageName::WebPageProxy_BeginTextRecognitionForVideoInElementFullScreen:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_BeginTextRecognitionForVideoInElementFullScreen>(globalObject, decoder);
    case MessageName::WebPageProxy_CancelTextRecognitionForVideoInElementFullScreen:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_CancelTextRecognitionForVideoInElementFullScreen>(globalObject, decoder);
#endif
#if PLATFORM(IOS_FAMILY)
    case MessageName::WebPageProxy_CouldNotRestorePageState:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_CouldNotRestorePageState>(globalObject, decoder);
    case MessageName::WebPageProxy_RestorePageState:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_RestorePageState>(globalObject, decoder);
    case MessageName::WebPageProxy_RestorePageCenterAndScale:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_RestorePageCenterAndScale>(globalObject, decoder);
    case MessageName::WebPageProxy_DidGetTapHighlightGeometries:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_DidGetTapHighlightGeometries>(globalObject, decoder);
    case MessageName::WebPageProxy_ElementDidFocus:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_ElementDidFocus>(globalObject, decoder);
    case MessageName::WebPageProxy_ElementDidBlur:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_ElementDidBlur>(globalObject, decoder);
    case MessageName::WebPageProxy_UpdateInputContextAfterBlurringAndRefocusingElement:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_UpdateInputContextAfterBlurringAndRefocusingElement>(globalObject, decoder);
    case MessageName::WebPageProxy_DidProgrammaticallyClearFocusedElement:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_DidProgrammaticallyClearFocusedElement>(globalObject, decoder);
    case MessageName::WebPageProxy_UpdateFocusedElementInformation:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_UpdateFocusedElementInformation>(globalObject, decoder);
    case MessageName::WebPageProxy_FocusedElementDidChangeInputMode:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_FocusedElementDidChangeInputMode>(globalObject, decoder);
    case MessageName::WebPageProxy_ScrollingNodeScrollWillStartScroll:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_ScrollingNodeScrollWillStartScroll>(globalObject, decoder);
    case MessageName::WebPageProxy_ScrollingNodeScrollDidEndScroll:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_ScrollingNodeScrollDidEndScroll>(globalObject, decoder);
    case MessageName::WebPageProxy_ShowInspectorHighlight:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_ShowInspectorHighlight>(globalObject, decoder);
    case MessageName::WebPageProxy_HideInspectorHighlight:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_HideInspectorHighlight>(globalObject, decoder);
    case MessageName::WebPageProxy_ShowInspectorIndication:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_ShowInspectorIndication>(globalObject, decoder);
    case MessageName::WebPageProxy_HideInspectorIndication:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_HideInspectorIndication>(globalObject, decoder);
    case MessageName::WebPageProxy_EnableInspectorNodeSearch:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_EnableInspectorNodeSearch>(globalObject, decoder);
    case MessageName::WebPageProxy_DisableInspectorNodeSearch:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_DisableInspectorNodeSearch>(globalObject, decoder);
    case MessageName::WebPageProxy_UpdateStringForFind:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_UpdateStringForFind>(globalObject, decoder);
    case MessageName::WebPageProxy_HandleAutocorrectionContext:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_HandleAutocorrectionContext>(globalObject, decoder);
    case MessageName::WebPageProxy_ShowDataDetectorsUIForPositionInformation:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_ShowDataDetectorsUIForPositionInformation>(globalObject, decoder);
#endif
    case MessageName::WebPageProxy_DidChangeInspectorFrontendCount:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_DidChangeInspectorFrontendCount>(globalObject, decoder);
    case MessageName::WebPageProxy_CreateInspectorTarget:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_CreateInspectorTarget>(globalObject, decoder);
    case MessageName::WebPageProxy_DestroyInspectorTarget:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_DestroyInspectorTarget>(globalObject, decoder);
    case MessageName::WebPageProxy_SendMessageToInspectorFrontend:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_SendMessageToInspectorFrontend>(globalObject, decoder);
    case MessageName::WebPageProxy_SaveRecentSearches:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_SaveRecentSearches>(globalObject, decoder);
    case MessageName::WebPageProxy_LoadRecentSearches:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_LoadRecentSearches>(globalObject, decoder);
    case MessageName::WebPageProxy_DidUpdateActivityState:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_DidUpdateActivityState>(globalObject, decoder);
    case MessageName::WebPageProxy_SerializeAndWrapCryptoKey:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_SerializeAndWrapCryptoKey>(globalObject, decoder);
    case MessageName::WebPageProxy_UnwrapCryptoKey:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_UnwrapCryptoKey>(globalObject, decoder);
#if (ENABLE(TELEPHONE_NUMBER_DETECTION) && PLATFORM(MAC))
    case MessageName::WebPageProxy_ShowTelephoneNumberMenu:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_ShowTelephoneNumberMenu>(globalObject, decoder);
#endif
#if USE(QUICK_LOOK)
    case MessageName::WebPageProxy_DidStartLoadForQuickLookDocumentInMainFrame:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_DidStartLoadForQuickLookDocumentInMainFrame>(globalObject, decoder);
    case MessageName::WebPageProxy_DidFinishLoadForQuickLookDocumentInMainFrame:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_DidFinishLoadForQuickLookDocumentInMainFrame>(globalObject, decoder);
    case MessageName::WebPageProxy_RequestPasswordForQuickLookDocumentInMainFrame:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_RequestPasswordForQuickLookDocumentInMainFrame>(globalObject, decoder);
#endif
#if ENABLE(CONTENT_FILTERING)
    case MessageName::WebPageProxy_ContentFilterDidBlockLoadForFrame:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_ContentFilterDidBlockLoadForFrame>(globalObject, decoder);
#endif
#if ENABLE(ACCESSIBILITY_ANIMATION_CONTROL)
    case MessageName::WebPageProxy_IsAnyAnimationAllowedToPlayDidChange:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_IsAnyAnimationAllowedToPlayDidChange>(globalObject, decoder);
#endif
    case MessageName::WebPageProxy_IsPlayingMediaDidChange:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_IsPlayingMediaDidChange>(globalObject, decoder);
    case MessageName::WebPageProxy_HandleAutoplayEvent:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_HandleAutoplayEvent>(globalObject, decoder);
#if PLATFORM(MAC)
    case MessageName::WebPageProxy_DidPerformImmediateActionHitTest:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_DidPerformImmediateActionHitTest>(globalObject, decoder);
#endif
    case MessageName::WebPageProxy_HandleMessage:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_HandleMessage>(globalObject, decoder);
    case MessageName::WebPageProxy_HandleMessageWithAsyncReply:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_HandleMessageWithAsyncReply>(globalObject, decoder);
    case MessageName::WebPageProxy_HandleSynchronousMessage:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_HandleSynchronousMessage>(globalObject, decoder);
    case MessageName::WebPageProxy_HandleAutoFillButtonClick:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_HandleAutoFillButtonClick>(globalObject, decoder);
    case MessageName::WebPageProxy_DidResignInputElementStrongPasswordAppearance:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_DidResignInputElementStrongPasswordAppearance>(globalObject, decoder);
    case MessageName::WebPageProxy_PerformSwitchHapticFeedback:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_PerformSwitchHapticFeedback>(globalObject, decoder);
#if ENABLE(CONTENT_EXTENSIONS)
    case MessageName::WebPageProxy_ContentRuleListNotification:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_ContentRuleListNotification>(globalObject, decoder);
#endif
#if ENABLE(WIRELESS_PLAYBACK_TARGET) && !PLATFORM(IOS_FAMILY)
    case MessageName::WebPageProxy_AddPlaybackTargetPickerClient:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_AddPlaybackTargetPickerClient>(globalObject, decoder);
    case MessageName::WebPageProxy_RemovePlaybackTargetPickerClient:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_RemovePlaybackTargetPickerClient>(globalObject, decoder);
    case MessageName::WebPageProxy_ShowPlaybackTargetPicker:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_ShowPlaybackTargetPicker>(globalObject, decoder);
    case MessageName::WebPageProxy_PlaybackTargetPickerClientStateDidChange:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_PlaybackTargetPickerClientStateDidChange>(globalObject, decoder);
    case MessageName::WebPageProxy_SetMockMediaPlaybackTargetPickerEnabled:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_SetMockMediaPlaybackTargetPickerEnabled>(globalObject, decoder);
    case MessageName::WebPageProxy_SetMockMediaPlaybackTargetPickerState:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_SetMockMediaPlaybackTargetPickerState>(globalObject, decoder);
    case MessageName::WebPageProxy_MockMediaPlaybackTargetPickerDismissPopup:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_MockMediaPlaybackTargetPickerDismissPopup>(globalObject, decoder);
#endif
#if ENABLE(VIDEO_PRESENTATION_MODE)
    case MessageName::WebPageProxy_SetMockVideoPresentationModeEnabled:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_SetMockVideoPresentationModeEnabled>(globalObject, decoder);
#endif
#if ENABLE(POINTER_LOCK)
    case MessageName::WebPageProxy_RequestPointerLock:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_RequestPointerLock>(globalObject, decoder);
    case MessageName::WebPageProxy_RequestPointerUnlock:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_RequestPointerUnlock>(globalObject, decoder);
#endif
    case MessageName::WebPageProxy_ImageOrMediaDocumentSizeChanged:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_ImageOrMediaDocumentSizeChanged>(globalObject, decoder);
    case MessageName::WebPageProxy_UseFixedLayoutDidChange:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_UseFixedLayoutDidChange>(globalObject, decoder);
    case MessageName::WebPageProxy_FixedLayoutSizeDidChange:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_FixedLayoutSizeDidChange>(globalObject, decoder);
    case MessageName::WebPageProxy_DidRestoreScrollPosition:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_DidRestoreScrollPosition>(globalObject, decoder);
    case MessageName::WebPageProxy_RequestScrollToRect:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_RequestScrollToRect>(globalObject, decoder);
    case MessageName::WebPageProxy_GetLoadDecisionForIcon:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_GetLoadDecisionForIcon>(globalObject, decoder);
    case MessageName::WebPageProxy_StartURLSchemeTask:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_StartURLSchemeTask>(globalObject, decoder);
    case MessageName::WebPageProxy_StopURLSchemeTask:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_StopURLSchemeTask>(globalObject, decoder);
    case MessageName::WebPageProxy_LoadSynchronousURLSchemeTask:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_LoadSynchronousURLSchemeTask>(globalObject, decoder);
#if ENABLE(DEVICE_ORIENTATION)
    case MessageName::WebPageProxy_ShouldAllowDeviceOrientationAndMotionAccess:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_ShouldAllowDeviceOrientationAndMotionAccess>(globalObject, decoder);
#endif
#if ENABLE(ATTACHMENT_ELEMENT)
    case MessageName::WebPageProxy_RegisterAttachmentIdentifierFromData:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_RegisterAttachmentIdentifierFromData>(globalObject, decoder);
    case MessageName::WebPageProxy_RegisterAttachmentIdentifierFromFilePath:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_RegisterAttachmentIdentifierFromFilePath>(globalObject, decoder);
    case MessageName::WebPageProxy_RegisterAttachmentIdentifier:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_RegisterAttachmentIdentifier>(globalObject, decoder);
    case MessageName::WebPageProxy_RegisterAttachmentsFromSerializedData:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_RegisterAttachmentsFromSerializedData>(globalObject, decoder);
    case MessageName::WebPageProxy_CloneAttachmentData:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_CloneAttachmentData>(globalObject, decoder);
    case MessageName::WebPageProxy_DidInsertAttachmentWithIdentifier:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_DidInsertAttachmentWithIdentifier>(globalObject, decoder);
    case MessageName::WebPageProxy_DidRemoveAttachmentWithIdentifier:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_DidRemoveAttachmentWithIdentifier>(globalObject, decoder);
    case MessageName::WebPageProxy_SerializedAttachmentDataForIdentifiers:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_SerializedAttachmentDataForIdentifiers>(globalObject, decoder);
#endif
#if (ENABLE(ATTACHMENT_ELEMENT) && PLATFORM(IOS_FAMILY))
    case MessageName::WebPageProxy_WritePromisedAttachmentToPasteboard:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_WritePromisedAttachmentToPasteboard>(globalObject, decoder);
#endif
#if ENABLE(ATTACHMENT_ELEMENT)
    case MessageName::WebPageProxy_RequestAttachmentIcon:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_RequestAttachmentIcon>(globalObject, decoder);
#endif
#if ENABLE(SPEECH_SYNTHESIS)
    case MessageName::WebPageProxy_SpeechSynthesisVoiceList:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_SpeechSynthesisVoiceList>(globalObject, decoder);
    case MessageName::WebPageProxy_SpeechSynthesisSpeak:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_SpeechSynthesisSpeak>(globalObject, decoder);
    case MessageName::WebPageProxy_SpeechSynthesisSetFinishedCallback:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_SpeechSynthesisSetFinishedCallback>(globalObject, decoder);
    case MessageName::WebPageProxy_SpeechSynthesisCancel:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_SpeechSynthesisCancel>(globalObject, decoder);
    case MessageName::WebPageProxy_SpeechSynthesisPause:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_SpeechSynthesisPause>(globalObject, decoder);
    case MessageName::WebPageProxy_SpeechSynthesisResume:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_SpeechSynthesisResume>(globalObject, decoder);
    case MessageName::WebPageProxy_SpeechSynthesisResetState:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_SpeechSynthesisResetState>(globalObject, decoder);
#endif
#if ENABLE(PDF_PLUGIN) && PLATFORM(MAC)
    case MessageName::WebPageProxy_ShowPDFContextMenu:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_ShowPDFContextMenu>(globalObject, decoder);
#endif
#if ENABLE(PDF_HUD)
    case MessageName::WebPageProxy_CreatePDFHUD:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_CreatePDFHUD>(globalObject, decoder);
    case MessageName::WebPageProxy_UpdatePDFHUDLocation:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_UpdatePDFHUDLocation>(globalObject, decoder);
    case MessageName::WebPageProxy_RemovePDFHUD:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_RemovePDFHUD>(globalObject, decoder);
#endif
#if ENABLE(PDF_PAGE_NUMBER_INDICATOR)
    case MessageName::WebPageProxy_CreatePDFPageNumberIndicator:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_CreatePDFPageNumberIndicator>(globalObject, decoder);
    case MessageName::WebPageProxy_UpdatePDFPageNumberIndicatorLocation:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_UpdatePDFPageNumberIndicatorLocation>(globalObject, decoder);
    case MessageName::WebPageProxy_UpdatePDFPageNumberIndicatorCurrentPage:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_UpdatePDFPageNumberIndicatorCurrentPage>(globalObject, decoder);
    case MessageName::WebPageProxy_RemovePDFPageNumberIndicator:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_RemovePDFPageNumberIndicator>(globalObject, decoder);
#endif
    case MessageName::WebPageProxy_ConfigureLoggingChannel:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_ConfigureLoggingChannel>(globalObject, decoder);
#if PLATFORM(GTK)
    case MessageName::WebPageProxy_ShowEmojiPicker:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_ShowEmojiPicker>(globalObject, decoder);
#endif
#if HAVE(VISIBILITY_PROPAGATION_VIEW)
    case MessageName::WebPageProxy_DidCreateContextInWebProcessForVisibilityPropagation:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_DidCreateContextInWebProcessForVisibilityPropagation>(globalObject, decoder);
#endif
#if ENABLE(WEB_AUTHN)
    case MessageName::WebPageProxy_SetMockWebAuthenticationConfiguration:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_SetMockWebAuthenticationConfiguration>(globalObject, decoder);
#endif
#if PLATFORM(GTK) || PLATFORM(WPE)
    case MessageName::WebPageProxy_SendMessageToWebView:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_SendMessageToWebView>(globalObject, decoder);
    case MessageName::WebPageProxy_SendMessageToWebViewWithReply:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_SendMessageToWebViewWithReply>(globalObject, decoder);
#endif
    case MessageName::WebPageProxy_DidFindTextManipulationItems:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_DidFindTextManipulationItems>(globalObject, decoder);
#if ENABLE(MEDIA_USAGE)
    case MessageName::WebPageProxy_AddMediaUsageManagerSession:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_AddMediaUsageManagerSession>(globalObject, decoder);
    case MessageName::WebPageProxy_UpdateMediaUsageManagerSessionState:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_UpdateMediaUsageManagerSessionState>(globalObject, decoder);
    case MessageName::WebPageProxy_RemoveMediaUsageManagerSession:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_RemoveMediaUsageManagerSession>(globalObject, decoder);
#endif
    case MessageName::WebPageProxy_SetHasExecutedAppBoundBehaviorBeforeNavigation:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_SetHasExecutedAppBoundBehaviorBeforeNavigation>(globalObject, decoder);
#if PLATFORM(MAC)
    case MessageName::WebPageProxy_ChangeUniversalAccessZoomFocus:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_ChangeUniversalAccessZoomFocus>(globalObject, decoder);
#endif
#if ENABLE(ARKIT_INLINE_PREVIEW_IOS)
    case MessageName::WebPageProxy_TakeModelElementFullscreen:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_TakeModelElementFullscreen>(globalObject, decoder);
    case MessageName::WebPageProxy_ModelElementSetInteractionEnabled:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_ModelElementSetInteractionEnabled>(globalObject, decoder);
#endif
#if ENABLE(ARKIT_INLINE_PREVIEW_MAC)
    case MessageName::WebPageProxy_ModelElementCreateRemotePreview:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_ModelElementCreateRemotePreview>(globalObject, decoder);
    case MessageName::WebPageProxy_ModelElementLoadRemotePreview:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_ModelElementLoadRemotePreview>(globalObject, decoder);
    case MessageName::WebPageProxy_ModelElementDestroyRemotePreview:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_ModelElementDestroyRemotePreview>(globalObject, decoder);
    case MessageName::WebPageProxy_ModelElementSizeDidChange:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_ModelElementSizeDidChange>(globalObject, decoder);
    case MessageName::WebPageProxy_HandleMouseDownForModelElement:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_HandleMouseDownForModelElement>(globalObject, decoder);
    case MessageName::WebPageProxy_HandleMouseMoveForModelElement:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_HandleMouseMoveForModelElement>(globalObject, decoder);
    case MessageName::WebPageProxy_HandleMouseUpForModelElement:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_HandleMouseUpForModelElement>(globalObject, decoder);
    case MessageName::WebPageProxy_ModelInlinePreviewUUIDs:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_ModelInlinePreviewUUIDs>(globalObject, decoder);
#endif
#if ENABLE(ARKIT_INLINE_PREVIEW)
    case MessageName::WebPageProxy_ModelElementGetCamera:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_ModelElementGetCamera>(globalObject, decoder);
    case MessageName::WebPageProxy_ModelElementSetCamera:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_ModelElementSetCamera>(globalObject, decoder);
    case MessageName::WebPageProxy_ModelElementIsPlayingAnimation:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_ModelElementIsPlayingAnimation>(globalObject, decoder);
    case MessageName::WebPageProxy_ModelElementSetAnimationIsPlaying:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_ModelElementSetAnimationIsPlaying>(globalObject, decoder);
    case MessageName::WebPageProxy_ModelElementIsLoopingAnimation:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_ModelElementIsLoopingAnimation>(globalObject, decoder);
    case MessageName::WebPageProxy_ModelElementSetIsLoopingAnimation:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_ModelElementSetIsLoopingAnimation>(globalObject, decoder);
    case MessageName::WebPageProxy_ModelElementAnimationDuration:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_ModelElementAnimationDuration>(globalObject, decoder);
    case MessageName::WebPageProxy_ModelElementAnimationCurrentTime:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_ModelElementAnimationCurrentTime>(globalObject, decoder);
    case MessageName::WebPageProxy_ModelElementSetAnimationCurrentTime:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_ModelElementSetAnimationCurrentTime>(globalObject, decoder);
    case MessageName::WebPageProxy_ModelElementHasAudio:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_ModelElementHasAudio>(globalObject, decoder);
    case MessageName::WebPageProxy_ModelElementIsMuted:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_ModelElementIsMuted>(globalObject, decoder);
    case MessageName::WebPageProxy_ModelElementSetIsMuted:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_ModelElementSetIsMuted>(globalObject, decoder);
#endif
#if ENABLE(APPLE_PAY_AMS_UI)
    case MessageName::WebPageProxy_StartApplePayAMSUISession:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_StartApplePayAMSUISession>(globalObject, decoder);
    case MessageName::WebPageProxy_AbortApplePayAMSUISession:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_AbortApplePayAMSUISession>(globalObject, decoder);
#endif
#if USE(SYSTEM_PREVIEW)
    case MessageName::WebPageProxy_BeginSystemPreview:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_BeginSystemPreview>(globalObject, decoder);
#endif
    case MessageName::WebPageProxy_DidCreateSleepDisabler:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_DidCreateSleepDisabler>(globalObject, decoder);
    case MessageName::WebPageProxy_DidDestroySleepDisabler:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_DidDestroySleepDisabler>(globalObject, decoder);
    case MessageName::WebPageProxy_RequestCookieConsent:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_RequestCookieConsent>(globalObject, decoder);
#if ENABLE(WINDOW_PROXY_PROPERTY_ACCESS_NOTIFICATION)
    case MessageName::WebPageProxy_DidAccessWindowProxyPropertyViaOpenerForFrame:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_DidAccessWindowProxyPropertyViaOpenerForFrame>(globalObject, decoder);
#endif
    case MessageName::WebPageProxy_DidApplyLinkDecorationFiltering:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_DidApplyLinkDecorationFiltering>(globalObject, decoder);
    case MessageName::WebPageProxy_BroadcastProcessSyncData:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_BroadcastProcessSyncData>(globalObject, decoder);
    case MessageName::WebPageProxy_BroadcastTopDocumentSyncData:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_BroadcastTopDocumentSyncData>(globalObject, decoder);
    case MessageName::WebPageProxy_DispatchLoadEventToFrameOwnerElement:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_DispatchLoadEventToFrameOwnerElement>(globalObject, decoder);
    case MessageName::WebPageProxy_FocusRemoteFrame:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_FocusRemoteFrame>(globalObject, decoder);
    case MessageName::WebPageProxy_PostMessageToRemote:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_PostMessageToRemote>(globalObject, decoder);
    case MessageName::WebPageProxy_RenderTreeAsTextForTesting:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_RenderTreeAsTextForTesting>(globalObject, decoder);
    case MessageName::WebPageProxy_FrameTextForTesting:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_FrameTextForTesting>(globalObject, decoder);
    case MessageName::WebPageProxy_LayerTreeAsTextForTesting:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_LayerTreeAsTextForTesting>(globalObject, decoder);
    case MessageName::WebPageProxy_AddMessageToConsoleForTesting:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_AddMessageToConsoleForTesting>(globalObject, decoder);
    case MessageName::WebPageProxy_BindRemoteAccessibilityFrames:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_BindRemoteAccessibilityFrames>(globalObject, decoder);
    case MessageName::WebPageProxy_UpdateRemoteFrameAccessibilityOffset:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_UpdateRemoteFrameAccessibilityOffset>(globalObject, decoder);
    case MessageName::WebPageProxy_DocumentURLForConsoleLog:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_DocumentURLForConsoleLog>(globalObject, decoder);
    case MessageName::WebPageProxy_NowPlayingMetadataChanged:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_NowPlayingMetadataChanged>(globalObject, decoder);
    case MessageName::WebPageProxy_DidAdjustVisibilityWithSelectors:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_DidAdjustVisibilityWithSelectors>(globalObject, decoder);
    case MessageName::WebPageProxy_FrameNameChanged:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_FrameNameChanged>(globalObject, decoder);
#if ENABLE(GAMEPAD)
    case MessageName::WebPageProxy_GamepadsRecentlyAccessed:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_GamepadsRecentlyAccessed>(globalObject, decoder);
#endif
    case MessageName::WebPageProxy_HasActiveNowPlayingSessionChanged:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_HasActiveNowPlayingSessionChanged>(globalObject, decoder);
    case MessageName::WebPageProxy_SetAllowsLayoutViewportHeightExpansion:
        return jsValueForDecodedMessage<MessageName::WebPageProxy_SetAllowsLayoutViewportHeightExpansion>(globalObject, decoder);
#if PLATFORM(IOS_FAMILY)
    case MessageName::WebPasteboardProxy_WriteURLToPasteboard:
        return jsValueForDecodedMessage<MessageName::WebPasteboardProxy_WriteURLToPasteboard>(globalObject, decoder);
    case MessageName::WebPasteboardProxy_WriteWebContentToPasteboard:
        return jsValueForDecodedMessage<MessageName::WebPasteboardProxy_WriteWebContentToPasteboard>(globalObject, decoder);
    case MessageName::WebPasteboardProxy_WriteImageToPasteboard:
        return jsValueForDecodedMessage<MessageName::WebPasteboardProxy_WriteImageToPasteboard>(globalObject, decoder);
    case MessageName::WebPasteboardProxy_WriteStringToPasteboard:
        return jsValueForDecodedMessage<MessageName::WebPasteboardProxy_WriteStringToPasteboard>(globalObject, decoder);
    case MessageName::WebPasteboardProxy_UpdateSupportedTypeIdentifiers:
        return jsValueForDecodedMessage<MessageName::WebPasteboardProxy_UpdateSupportedTypeIdentifiers>(globalObject, decoder);
#endif
    case MessageName::WebPasteboardProxy_WriteCustomData:
        return jsValueForDecodedMessage<MessageName::WebPasteboardProxy_WriteCustomData>(globalObject, decoder);
    case MessageName::WebPasteboardProxy_TypesSafeForDOMToReadAndWrite:
        return jsValueForDecodedMessage<MessageName::WebPasteboardProxy_TypesSafeForDOMToReadAndWrite>(globalObject, decoder);
    case MessageName::WebPasteboardProxy_AllPasteboardItemInfo:
        return jsValueForDecodedMessage<MessageName::WebPasteboardProxy_AllPasteboardItemInfo>(globalObject, decoder);
    case MessageName::WebPasteboardProxy_InformationForItemAtIndex:
        return jsValueForDecodedMessage<MessageName::WebPasteboardProxy_InformationForItemAtIndex>(globalObject, decoder);
    case MessageName::WebPasteboardProxy_GetPasteboardItemsCount:
        return jsValueForDecodedMessage<MessageName::WebPasteboardProxy_GetPasteboardItemsCount>(globalObject, decoder);
    case MessageName::WebPasteboardProxy_ReadStringFromPasteboard:
        return jsValueForDecodedMessage<MessageName::WebPasteboardProxy_ReadStringFromPasteboard>(globalObject, decoder);
    case MessageName::WebPasteboardProxy_ReadURLFromPasteboard:
        return jsValueForDecodedMessage<MessageName::WebPasteboardProxy_ReadURLFromPasteboard>(globalObject, decoder);
    case MessageName::WebPasteboardProxy_ReadBufferFromPasteboard:
        return jsValueForDecodedMessage<MessageName::WebPasteboardProxy_ReadBufferFromPasteboard>(globalObject, decoder);
    case MessageName::WebPasteboardProxy_ContainsStringSafeForDOMToReadForType:
        return jsValueForDecodedMessage<MessageName::WebPasteboardProxy_ContainsStringSafeForDOMToReadForType>(globalObject, decoder);
#if PLATFORM(COCOA)
    case MessageName::WebPasteboardProxy_GetNumberOfFiles:
        return jsValueForDecodedMessage<MessageName::WebPasteboardProxy_GetNumberOfFiles>(globalObject, decoder);
    case MessageName::WebPasteboardProxy_GetPasteboardTypes:
        return jsValueForDecodedMessage<MessageName::WebPasteboardProxy_GetPasteboardTypes>(globalObject, decoder);
    case MessageName::WebPasteboardProxy_GetPasteboardPathnamesForType:
        return jsValueForDecodedMessage<MessageName::WebPasteboardProxy_GetPasteboardPathnamesForType>(globalObject, decoder);
    case MessageName::WebPasteboardProxy_GetPasteboardStringForType:
        return jsValueForDecodedMessage<MessageName::WebPasteboardProxy_GetPasteboardStringForType>(globalObject, decoder);
    case MessageName::WebPasteboardProxy_GetPasteboardStringsForType:
        return jsValueForDecodedMessage<MessageName::WebPasteboardProxy_GetPasteboardStringsForType>(globalObject, decoder);
    case MessageName::WebPasteboardProxy_GetPasteboardBufferForType:
        return jsValueForDecodedMessage<MessageName::WebPasteboardProxy_GetPasteboardBufferForType>(globalObject, decoder);
    case MessageName::WebPasteboardProxy_GetPasteboardChangeCount:
        return jsValueForDecodedMessage<MessageName::WebPasteboardProxy_GetPasteboardChangeCount>(globalObject, decoder);
    case MessageName::WebPasteboardProxy_GetPasteboardColor:
        return jsValueForDecodedMessage<MessageName::WebPasteboardProxy_GetPasteboardColor>(globalObject, decoder);
    case MessageName::WebPasteboardProxy_GetPasteboardURL:
        return jsValueForDecodedMessage<MessageName::WebPasteboardProxy_GetPasteboardURL>(globalObject, decoder);
    case MessageName::WebPasteboardProxy_AddPasteboardTypes:
        return jsValueForDecodedMessage<MessageName::WebPasteboardProxy_AddPasteboardTypes>(globalObject, decoder);
    case MessageName::WebPasteboardProxy_SetPasteboardTypes:
        return jsValueForDecodedMessage<MessageName::WebPasteboardProxy_SetPasteboardTypes>(globalObject, decoder);
    case MessageName::WebPasteboardProxy_SetPasteboardURL:
        return jsValueForDecodedMessage<MessageName::WebPasteboardProxy_SetPasteboardURL>(globalObject, decoder);
    case MessageName::WebPasteboardProxy_SetPasteboardColor:
        return jsValueForDecodedMessage<MessageName::WebPasteboardProxy_SetPasteboardColor>(globalObject, decoder);
    case MessageName::WebPasteboardProxy_SetPasteboardStringForType:
        return jsValueForDecodedMessage<MessageName::WebPasteboardProxy_SetPasteboardStringForType>(globalObject, decoder);
    case MessageName::WebPasteboardProxy_SetPasteboardBufferForType:
        return jsValueForDecodedMessage<MessageName::WebPasteboardProxy_SetPasteboardBufferForType>(globalObject, decoder);
    case MessageName::WebPasteboardProxy_ContainsURLStringSuitableForLoading:
        return jsValueForDecodedMessage<MessageName::WebPasteboardProxy_ContainsURLStringSuitableForLoading>(globalObject, decoder);
    case MessageName::WebPasteboardProxy_URLStringSuitableForLoading:
        return jsValueForDecodedMessage<MessageName::WebPasteboardProxy_URLStringSuitableForLoading>(globalObject, decoder);
#endif
#if (PLATFORM(COCOA) && ENABLE(IPC_TESTING_API))
    case MessageName::WebPasteboardProxy_TestIPCSharedMemory:
        return jsValueForDecodedMessage<MessageName::WebPasteboardProxy_TestIPCSharedMemory>(globalObject, decoder);
#endif
#if PLATFORM(GTK) || PLATFORM(WPE)
    case MessageName::WebPasteboardProxy_GetTypes:
        return jsValueForDecodedMessage<MessageName::WebPasteboardProxy_GetTypes>(globalObject, decoder);
    case MessageName::WebPasteboardProxy_ReadText:
        return jsValueForDecodedMessage<MessageName::WebPasteboardProxy_ReadText>(globalObject, decoder);
    case MessageName::WebPasteboardProxy_ReadFilePaths:
        return jsValueForDecodedMessage<MessageName::WebPasteboardProxy_ReadFilePaths>(globalObject, decoder);
    case MessageName::WebPasteboardProxy_ReadBuffer:
        return jsValueForDecodedMessage<MessageName::WebPasteboardProxy_ReadBuffer>(globalObject, decoder);
    case MessageName::WebPasteboardProxy_WriteToClipboard:
        return jsValueForDecodedMessage<MessageName::WebPasteboardProxy_WriteToClipboard>(globalObject, decoder);
    case MessageName::WebPasteboardProxy_ClearClipboard:
        return jsValueForDecodedMessage<MessageName::WebPasteboardProxy_ClearClipboard>(globalObject, decoder);
    case MessageName::WebPasteboardProxy_GetPasteboardChangeCount:
        return jsValueForDecodedMessage<MessageName::WebPasteboardProxy_GetPasteboardChangeCount>(globalObject, decoder);
#endif
#if USE(LIBWPE) && !PLATFORM(WPE)
    case MessageName::WebPasteboardProxy_GetPasteboardTypes:
        return jsValueForDecodedMessage<MessageName::WebPasteboardProxy_GetPasteboardTypes>(globalObject, decoder);
    case MessageName::WebPasteboardProxy_WriteWebContentToPasteboard:
        return jsValueForDecodedMessage<MessageName::WebPasteboardProxy_WriteWebContentToPasteboard>(globalObject, decoder);
    case MessageName::WebPasteboardProxy_WriteStringToPasteboard:
        return jsValueForDecodedMessage<MessageName::WebPasteboardProxy_WriteStringToPasteboard>(globalObject, decoder);
#endif
    case MessageName::WebPermissionControllerProxy_Query:
        return jsValueForDecodedMessage<MessageName::WebPermissionControllerProxy_Query>(globalObject, decoder);
    case MessageName::WebProcessPool_HandleMessage:
        return jsValueForDecodedMessage<MessageName::WebProcessPool_HandleMessage>(globalObject, decoder);
    case MessageName::WebProcessPool_HandleSynchronousMessage:
        return jsValueForDecodedMessage<MessageName::WebProcessPool_HandleSynchronousMessage>(globalObject, decoder);
#if ENABLE(GAMEPAD)
    case MessageName::WebProcessPool_StartedUsingGamepads:
        return jsValueForDecodedMessage<MessageName::WebProcessPool_StartedUsingGamepads>(globalObject, decoder);
    case MessageName::WebProcessPool_StoppedUsingGamepads:
        return jsValueForDecodedMessage<MessageName::WebProcessPool_StoppedUsingGamepads>(globalObject, decoder);
    case MessageName::WebProcessPool_PlayGamepadEffect:
        return jsValueForDecodedMessage<MessageName::WebProcessPool_PlayGamepadEffect>(globalObject, decoder);
    case MessageName::WebProcessPool_StopGamepadEffects:
        return jsValueForDecodedMessage<MessageName::WebProcessPool_StopGamepadEffects>(globalObject, decoder);
#endif
#if ENABLE(MODEL_PROCESS)
    case MessageName::WebProcessPool_StartedPlayingModels:
        return jsValueForDecodedMessage<MessageName::WebProcessPool_StartedPlayingModels>(globalObject, decoder);
    case MessageName::WebProcessPool_StoppedPlayingModels:
        return jsValueForDecodedMessage<MessageName::WebProcessPool_StoppedPlayingModels>(globalObject, decoder);
#endif
    case MessageName::WebProcessPool_ReportWebContentCPUTime:
        return jsValueForDecodedMessage<MessageName::WebProcessPool_ReportWebContentCPUTime>(globalObject, decoder);
    case MessageName::WebProcessProxy_DidDestroyUserGestureToken:
        return jsValueForDecodedMessage<MessageName::WebProcessProxy_DidDestroyUserGestureToken>(globalObject, decoder);
    case MessageName::WebProcessProxy_ShouldTerminate:
        return jsValueForDecodedMessage<MessageName::WebProcessProxy_ShouldTerminate>(globalObject, decoder);
    case MessageName::WebProcessProxy_EnableSuddenTermination:
        return jsValueForDecodedMessage<MessageName::WebProcessProxy_EnableSuddenTermination>(globalObject, decoder);
    case MessageName::WebProcessProxy_DisableSuddenTermination:
        return jsValueForDecodedMessage<MessageName::WebProcessProxy_DisableSuddenTermination>(globalObject, decoder);
    case MessageName::WebProcessProxy_GetNetworkProcessConnection:
        return jsValueForDecodedMessage<MessageName::WebProcessProxy_GetNetworkProcessConnection>(globalObject, decoder);
    case MessageName::WebProcessProxy_WaitForSharedPreferencesForWebProcessToSync:
        return jsValueForDecodedMessage<MessageName::WebProcessProxy_WaitForSharedPreferencesForWebProcessToSync>(globalObject, decoder);
#if ENABLE(GPU_PROCESS)
    case MessageName::WebProcessProxy_CreateGPUProcessConnection:
        return jsValueForDecodedMessage<MessageName::WebProcessProxy_CreateGPUProcessConnection>(globalObject, decoder);
    case MessageName::WebProcessProxy_GPUProcessConnectionDidBecomeUnresponsive:
        return jsValueForDecodedMessage<MessageName::WebProcessProxy_GPUProcessConnectionDidBecomeUnresponsive>(globalObject, decoder);
#endif
#if ENABLE(MODEL_PROCESS)
    case MessageName::WebProcessProxy_CreateModelProcessConnection:
        return jsValueForDecodedMessage<MessageName::WebProcessProxy_CreateModelProcessConnection>(globalObject, decoder);
#endif
    case MessageName::WebProcessProxy_DidExceedActiveMemoryLimit:
        return jsValueForDecodedMessage<MessageName::WebProcessProxy_DidExceedActiveMemoryLimit>(globalObject, decoder);
    case MessageName::WebProcessProxy_DidExceedInactiveMemoryLimit:
        return jsValueForDecodedMessage<MessageName::WebProcessProxy_DidExceedInactiveMemoryLimit>(globalObject, decoder);
    case MessageName::WebProcessProxy_DidExceedMemoryFootprintThreshold:
        return jsValueForDecodedMessage<MessageName::WebProcessProxy_DidExceedMemoryFootprintThreshold>(globalObject, decoder);
    case MessageName::WebProcessProxy_DidExceedCPULimit:
        return jsValueForDecodedMessage<MessageName::WebProcessProxy_DidExceedCPULimit>(globalObject, decoder);
    case MessageName::WebProcessProxy_StopResponsivenessTimer:
        return jsValueForDecodedMessage<MessageName::WebProcessProxy_StopResponsivenessTimer>(globalObject, decoder);
    case MessageName::WebProcessProxy_DidReceiveBackgroundResponsivenessPing:
        return jsValueForDecodedMessage<MessageName::WebProcessProxy_DidReceiveBackgroundResponsivenessPing>(globalObject, decoder);
    case MessageName::WebProcessProxy_MemoryPressureStatusChanged:
        return jsValueForDecodedMessage<MessageName::WebProcessProxy_MemoryPressureStatusChanged>(globalObject, decoder);
    case MessageName::WebProcessProxy_DidCollectPrewarmInformation:
        return jsValueForDecodedMessage<MessageName::WebProcessProxy_DidCollectPrewarmInformation>(globalObject, decoder);
#if PLATFORM(COCOA)
    case MessageName::WebProcessProxy_CacheMediaMIMETypes:
        return jsValueForDecodedMessage<MessageName::WebProcessProxy_CacheMediaMIMETypes>(globalObject, decoder);
#endif
#if HAVE(DISPLAY_LINK)
    case MessageName::WebProcessProxy_StartDisplayLink:
        return jsValueForDecodedMessage<MessageName::WebProcessProxy_StartDisplayLink>(globalObject, decoder);
    case MessageName::WebProcessProxy_StopDisplayLink:
        return jsValueForDecodedMessage<MessageName::WebProcessProxy_StopDisplayLink>(globalObject, decoder);
    case MessageName::WebProcessProxy_SetDisplayLinkPreferredFramesPerSecond:
        return jsValueForDecodedMessage<MessageName::WebProcessProxy_SetDisplayLinkPreferredFramesPerSecond>(globalObject, decoder);
#endif
#if PLATFORM(GTK) || PLATFORM(WPE)
    case MessageName::WebProcessProxy_SendMessageToWebContext:
        return jsValueForDecodedMessage<MessageName::WebProcessProxy_SendMessageToWebContext>(globalObject, decoder);
    case MessageName::WebProcessProxy_SendMessageToWebContextWithReply:
        return jsValueForDecodedMessage<MessageName::WebProcessProxy_SendMessageToWebContextWithReply>(globalObject, decoder);
#endif
    case MessageName::WebProcessProxy_CreateSpeechRecognitionServer:
        return jsValueForDecodedMessage<MessageName::WebProcessProxy_CreateSpeechRecognitionServer>(globalObject, decoder);
    case MessageName::WebProcessProxy_DestroySpeechRecognitionServer:
        return jsValueForDecodedMessage<MessageName::WebProcessProxy_DestroySpeechRecognitionServer>(globalObject, decoder);
    case MessageName::WebProcessProxy_SystemBeep:
        return jsValueForDecodedMessage<MessageName::WebProcessProxy_SystemBeep>(globalObject, decoder);
#if PLATFORM(MAC) || PLATFORM(MACCATALYST)
    case MessageName::WebProcessProxy_IsAXAuthenticated:
        return jsValueForDecodedMessage<MessageName::WebProcessProxy_IsAXAuthenticated>(globalObject, decoder);
#endif
#if HAVE(MEDIA_ACCESSIBILITY_FRAMEWORK)
    case MessageName::WebProcessProxy_SetCaptionDisplayMode:
        return jsValueForDecodedMessage<MessageName::WebProcessProxy_SetCaptionDisplayMode>(globalObject, decoder);
    case MessageName::WebProcessProxy_SetCaptionLanguage:
        return jsValueForDecodedMessage<MessageName::WebProcessProxy_SetCaptionLanguage>(globalObject, decoder);
#endif
#if ENABLE(NOTIFICATION_EVENT)
    case MessageName::WebProcessProxy_GetNotifications:
        return jsValueForDecodedMessage<MessageName::WebProcessProxy_GetNotifications>(globalObject, decoder);
#endif
    case MessageName::WebProcessProxy_SetAppBadgeFromWorker:
        return jsValueForDecodedMessage<MessageName::WebProcessProxy_SetAppBadgeFromWorker>(globalObject, decoder);
    case MessageName::WebProcessProxy_SerializeAndWrapCryptoKey:
        return jsValueForDecodedMessage<MessageName::WebProcessProxy_SerializeAndWrapCryptoKey>(globalObject, decoder);
    case MessageName::WebProcessProxy_UnwrapCryptoKey:
        return jsValueForDecodedMessage<MessageName::WebProcessProxy_UnwrapCryptoKey>(globalObject, decoder);
#if (ENABLE(LOGD_BLOCKING_IN_WEBCONTENT) && ENABLE(STREAMING_IPC_IN_LOG_FORWARDING))
    case MessageName::WebProcessProxy_SetupLogStream:
        return jsValueForDecodedMessage<MessageName::WebProcessProxy_SetupLogStream>(globalObject, decoder);
#endif
#if (ENABLE(LOGD_BLOCKING_IN_WEBCONTENT) && !ENABLE(STREAMING_IPC_IN_LOG_FORWARDING))
    case MessageName::WebProcessProxy_SetupLogStream:
        return jsValueForDecodedMessage<MessageName::WebProcessProxy_SetupLogStream>(globalObject, decoder);
#endif
#if ENABLE(REMOTE_INSPECTOR) && PLATFORM(COCOA)
    case MessageName::WebProcessProxy_CreateServiceWorkerDebuggable:
        return jsValueForDecodedMessage<MessageName::WebProcessProxy_CreateServiceWorkerDebuggable>(globalObject, decoder);
    case MessageName::WebProcessProxy_DeleteServiceWorkerDebuggable:
        return jsValueForDecodedMessage<MessageName::WebProcessProxy_DeleteServiceWorkerDebuggable>(globalObject, decoder);
    case MessageName::WebProcessProxy_SendMessageToInspector:
        return jsValueForDecodedMessage<MessageName::WebProcessProxy_SendMessageToInspector>(globalObject, decoder);
#endif
    case MessageName::WebScreenOrientationManagerProxy_CurrentOrientation:
        return jsValueForDecodedMessage<MessageName::WebScreenOrientationManagerProxy_CurrentOrientation>(globalObject, decoder);
    case MessageName::WebScreenOrientationManagerProxy_Lock:
        return jsValueForDecodedMessage<MessageName::WebScreenOrientationManagerProxy_Lock>(globalObject, decoder);
    case MessageName::WebScreenOrientationManagerProxy_Unlock:
        return jsValueForDecodedMessage<MessageName::WebScreenOrientationManagerProxy_Unlock>(globalObject, decoder);
    case MessageName::WebScreenOrientationManagerProxy_SetShouldSendChangeNotification:
        return jsValueForDecodedMessage<MessageName::WebScreenOrientationManagerProxy_SetShouldSendChangeNotification>(globalObject, decoder);
    case MessageName::WebAutomationSession_LogEntryAdded:
        return jsValueForDecodedMessage<MessageName::WebAutomationSession_LogEntryAdded>(globalObject, decoder);
    case MessageName::DownloadProxy_DidStart:
        return jsValueForDecodedMessage<MessageName::DownloadProxy_DidStart>(globalObject, decoder);
    case MessageName::DownloadProxy_DidReceiveAuthenticationChallenge:
        return jsValueForDecodedMessage<MessageName::DownloadProxy_DidReceiveAuthenticationChallenge>(globalObject, decoder);
    case MessageName::DownloadProxy_WillSendRequest:
        return jsValueForDecodedMessage<MessageName::DownloadProxy_WillSendRequest>(globalObject, decoder);
    case MessageName::DownloadProxy_DecideDestinationWithSuggestedFilename:
        return jsValueForDecodedMessage<MessageName::DownloadProxy_DecideDestinationWithSuggestedFilename>(globalObject, decoder);
    case MessageName::DownloadProxy_DidReceiveData:
        return jsValueForDecodedMessage<MessageName::DownloadProxy_DidReceiveData>(globalObject, decoder);
    case MessageName::DownloadProxy_DidCreateDestination:
        return jsValueForDecodedMessage<MessageName::DownloadProxy_DidCreateDestination>(globalObject, decoder);
    case MessageName::DownloadProxy_DidFinish:
        return jsValueForDecodedMessage<MessageName::DownloadProxy_DidFinish>(globalObject, decoder);
    case MessageName::DownloadProxy_DidFail:
        return jsValueForDecodedMessage<MessageName::DownloadProxy_DidFail>(globalObject, decoder);
#if HAVE(MODERN_DOWNLOADPROGRESS)
    case MessageName::DownloadProxy_DidReceivePlaceholderURL:
        return jsValueForDecodedMessage<MessageName::DownloadProxy_DidReceivePlaceholderURL>(globalObject, decoder);
    case MessageName::DownloadProxy_DidReceiveFinalURL:
        return jsValueForDecodedMessage<MessageName::DownloadProxy_DidReceiveFinalURL>(globalObject, decoder);
    case MessageName::DownloadProxy_DidStartUpdatingProgress:
        return jsValueForDecodedMessage<MessageName::DownloadProxy_DidStartUpdatingProgress>(globalObject, decoder);
#endif
#if ENABLE(GPU_PROCESS)
#if HAVE(VISIBILITY_PROPAGATION_VIEW)
    case MessageName::GPUProcessProxy_DidCreateContextForVisibilityPropagation:
        return jsValueForDecodedMessage<MessageName::GPUProcessProxy_DidCreateContextForVisibilityPropagation>(globalObject, decoder);
#endif
#if ENABLE(VP9)
    case MessageName::GPUProcessProxy_SetHasVP9HardwareDecoder:
        return jsValueForDecodedMessage<MessageName::GPUProcessProxy_SetHasVP9HardwareDecoder>(globalObject, decoder);
#endif
#if ENABLE(AV1)
    case MessageName::GPUProcessProxy_SetHasAV1HardwareDecoder:
        return jsValueForDecodedMessage<MessageName::GPUProcessProxy_SetHasAV1HardwareDecoder>(globalObject, decoder);
#endif
#if ENABLE(MEDIA_STREAM)
    case MessageName::GPUProcessProxy_VoiceActivityDetected:
        return jsValueForDecodedMessage<MessageName::GPUProcessProxy_VoiceActivityDetected>(globalObject, decoder);
    case MessageName::GPUProcessProxy_StartMonitoringCaptureDeviceRotation:
        return jsValueForDecodedMessage<MessageName::GPUProcessProxy_StartMonitoringCaptureDeviceRotation>(globalObject, decoder);
    case MessageName::GPUProcessProxy_StopMonitoringCaptureDeviceRotation:
        return jsValueForDecodedMessage<MessageName::GPUProcessProxy_StopMonitoringCaptureDeviceRotation>(globalObject, decoder);
    case MessageName::GPUProcessProxy_MicrophoneMuteStatusChanged:
        return jsValueForDecodedMessage<MessageName::GPUProcessProxy_MicrophoneMuteStatusChanged>(globalObject, decoder);
#endif
#if (ENABLE(MEDIA_STREAM) && PLATFORM(IOS_FAMILY))
    case MessageName::GPUProcessProxy_StatusBarWasTapped:
        return jsValueForDecodedMessage<MessageName::GPUProcessProxy_StatusBarWasTapped>(globalObject, decoder);
#endif
    case MessageName::GPUProcessProxy_ProcessIsReadyToExit:
        return jsValueForDecodedMessage<MessageName::GPUProcessProxy_ProcessIsReadyToExit>(globalObject, decoder);
    case MessageName::GPUProcessProxy_TerminateWebProcess:
        return jsValueForDecodedMessage<MessageName::GPUProcessProxy_TerminateWebProcess>(globalObject, decoder);
#if PLATFORM(COCOA)
    case MessageName::GPUProcessProxy_DidDrawRemoteToPDF:
        return jsValueForDecodedMessage<MessageName::GPUProcessProxy_DidDrawRemoteToPDF>(globalObject, decoder);
#endif
#endif
#if ENABLE(MODEL_PROCESS)
    case MessageName::ModelProcessProxy_TerminateWebProcess:
        return jsValueForDecodedMessage<MessageName::ModelProcessProxy_TerminateWebProcess>(globalObject, decoder);
#if HAVE(VISIBILITY_PROPAGATION_VIEW)
    case MessageName::ModelProcessProxy_DidCreateContextForVisibilityPropagation:
        return jsValueForDecodedMessage<MessageName::ModelProcessProxy_DidCreateContextForVisibilityPropagation>(globalObject, decoder);
#endif
    case MessageName::ModelProcessProxy_ProcessIsReadyToExit:
        return jsValueForDecodedMessage<MessageName::ModelProcessProxy_ProcessIsReadyToExit>(globalObject, decoder);
#if PLATFORM(VISION) && ENABLE(GPU_PROCESS)
    case MessageName::ModelProcessProxy_RequestSharedSimulationConnection:
        return jsValueForDecodedMessage<MessageName::ModelProcessProxy_RequestSharedSimulationConnection>(globalObject, decoder);
#endif
#endif
    case MessageName::RemoteWebInspectorUIProxy_FrontendLoaded:
        return jsValueForDecodedMessage<MessageName::RemoteWebInspectorUIProxy_FrontendLoaded>(globalObject, decoder);
    case MessageName::RemoteWebInspectorUIProxy_FrontendDidClose:
        return jsValueForDecodedMessage<MessageName::RemoteWebInspectorUIProxy_FrontendDidClose>(globalObject, decoder);
    case MessageName::RemoteWebInspectorUIProxy_Reopen:
        return jsValueForDecodedMessage<MessageName::RemoteWebInspectorUIProxy_Reopen>(globalObject, decoder);
    case MessageName::RemoteWebInspectorUIProxy_ResetState:
        return jsValueForDecodedMessage<MessageName::RemoteWebInspectorUIProxy_ResetState>(globalObject, decoder);
    case MessageName::RemoteWebInspectorUIProxy_BringToFront:
        return jsValueForDecodedMessage<MessageName::RemoteWebInspectorUIProxy_BringToFront>(globalObject, decoder);
    case MessageName::RemoteWebInspectorUIProxy_Save:
        return jsValueForDecodedMessage<MessageName::RemoteWebInspectorUIProxy_Save>(globalObject, decoder);
    case MessageName::RemoteWebInspectorUIProxy_Load:
        return jsValueForDecodedMessage<MessageName::RemoteWebInspectorUIProxy_Load>(globalObject, decoder);
    case MessageName::RemoteWebInspectorUIProxy_PickColorFromScreen:
        return jsValueForDecodedMessage<MessageName::RemoteWebInspectorUIProxy_PickColorFromScreen>(globalObject, decoder);
    case MessageName::RemoteWebInspectorUIProxy_SetForcedAppearance:
        return jsValueForDecodedMessage<MessageName::RemoteWebInspectorUIProxy_SetForcedAppearance>(globalObject, decoder);
    case MessageName::RemoteWebInspectorUIProxy_SetSheetRect:
        return jsValueForDecodedMessage<MessageName::RemoteWebInspectorUIProxy_SetSheetRect>(globalObject, decoder);
    case MessageName::RemoteWebInspectorUIProxy_StartWindowDrag:
        return jsValueForDecodedMessage<MessageName::RemoteWebInspectorUIProxy_StartWindowDrag>(globalObject, decoder);
    case MessageName::RemoteWebInspectorUIProxy_OpenURLExternally:
        return jsValueForDecodedMessage<MessageName::RemoteWebInspectorUIProxy_OpenURLExternally>(globalObject, decoder);
    case MessageName::RemoteWebInspectorUIProxy_RevealFileExternally:
        return jsValueForDecodedMessage<MessageName::RemoteWebInspectorUIProxy_RevealFileExternally>(globalObject, decoder);
    case MessageName::RemoteWebInspectorUIProxy_ShowCertificate:
        return jsValueForDecodedMessage<MessageName::RemoteWebInspectorUIProxy_ShowCertificate>(globalObject, decoder);
    case MessageName::RemoteWebInspectorUIProxy_SendMessageToBackend:
        return jsValueForDecodedMessage<MessageName::RemoteWebInspectorUIProxy_SendMessageToBackend>(globalObject, decoder);
    case MessageName::RemoteWebInspectorUIProxy_SetInspectorPageDeveloperExtrasEnabled:
        return jsValueForDecodedMessage<MessageName::RemoteWebInspectorUIProxy_SetInspectorPageDeveloperExtrasEnabled>(globalObject, decoder);
    case MessageName::WebInspectorBackendProxy_RequestOpenLocalInspectorFrontend:
        return jsValueForDecodedMessage<MessageName::WebInspectorBackendProxy_RequestOpenLocalInspectorFrontend>(globalObject, decoder);
    case MessageName::WebInspectorBackendProxy_DidClose:
        return jsValueForDecodedMessage<MessageName::WebInspectorBackendProxy_DidClose>(globalObject, decoder);
    case MessageName::WebInspectorBackendProxy_BringToFront:
        return jsValueForDecodedMessage<MessageName::WebInspectorBackendProxy_BringToFront>(globalObject, decoder);
    case MessageName::WebInspectorBackendProxy_ElementSelectionChanged:
        return jsValueForDecodedMessage<MessageName::WebInspectorBackendProxy_ElementSelectionChanged>(globalObject, decoder);
    case MessageName::WebInspectorBackendProxy_TimelineRecordingChanged:
        return jsValueForDecodedMessage<MessageName::WebInspectorBackendProxy_TimelineRecordingChanged>(globalObject, decoder);
    case MessageName::WebInspectorBackendProxy_SetDeveloperPreferenceOverride:
        return jsValueForDecodedMessage<MessageName::WebInspectorBackendProxy_SetDeveloperPreferenceOverride>(globalObject, decoder);
#if ENABLE(INSPECTOR_NETWORK_THROTTLING)
    case MessageName::WebInspectorBackendProxy_SetEmulatedConditions:
        return jsValueForDecodedMessage<MessageName::WebInspectorBackendProxy_SetEmulatedConditions>(globalObject, decoder);
#endif
    case MessageName::WebInspectorBackendProxy_AttachAvailabilityChanged:
        return jsValueForDecodedMessage<MessageName::WebInspectorBackendProxy_AttachAvailabilityChanged>(globalObject, decoder);
    case MessageName::WebInspectorUIProxy_SetFrontendConnection:
        return jsValueForDecodedMessage<MessageName::WebInspectorUIProxy_SetFrontendConnection>(globalObject, decoder);
    case MessageName::WebInspectorUIProxy_SendMessageToBackend:
        return jsValueForDecodedMessage<MessageName::WebInspectorUIProxy_SendMessageToBackend>(globalObject, decoder);
    case MessageName::WebInspectorUIProxy_FrontendLoaded:
        return jsValueForDecodedMessage<MessageName::WebInspectorUIProxy_FrontendLoaded>(globalObject, decoder);
    case MessageName::WebInspectorUIProxy_DidClose:
        return jsValueForDecodedMessage<MessageName::WebInspectorUIProxy_DidClose>(globalObject, decoder);
    case MessageName::WebInspectorUIProxy_BringToFront:
        return jsValueForDecodedMessage<MessageName::WebInspectorUIProxy_BringToFront>(globalObject, decoder);
    case MessageName::WebInspectorUIProxy_Reopen:
        return jsValueForDecodedMessage<MessageName::WebInspectorUIProxy_Reopen>(globalObject, decoder);
    case MessageName::WebInspectorUIProxy_ResetState:
        return jsValueForDecodedMessage<MessageName::WebInspectorUIProxy_ResetState>(globalObject, decoder);
    case MessageName::WebInspectorUIProxy_SetForcedAppearance:
        return jsValueForDecodedMessage<MessageName::WebInspectorUIProxy_SetForcedAppearance>(globalObject, decoder);
    case MessageName::WebInspectorUIProxy_EffectiveAppearanceDidChange:
        return jsValueForDecodedMessage<MessageName::WebInspectorUIProxy_EffectiveAppearanceDidChange>(globalObject, decoder);
    case MessageName::WebInspectorUIProxy_OpenURLExternally:
        return jsValueForDecodedMessage<MessageName::WebInspectorUIProxy_OpenURLExternally>(globalObject, decoder);
    case MessageName::WebInspectorUIProxy_RevealFileExternally:
        return jsValueForDecodedMessage<MessageName::WebInspectorUIProxy_RevealFileExternally>(globalObject, decoder);
    case MessageName::WebInspectorUIProxy_InspectedURLChanged:
        return jsValueForDecodedMessage<MessageName::WebInspectorUIProxy_InspectedURLChanged>(globalObject, decoder);
    case MessageName::WebInspectorUIProxy_ShowCertificate:
        return jsValueForDecodedMessage<MessageName::WebInspectorUIProxy_ShowCertificate>(globalObject, decoder);
    case MessageName::WebInspectorUIProxy_Save:
        return jsValueForDecodedMessage<MessageName::WebInspectorUIProxy_Save>(globalObject, decoder);
    case MessageName::WebInspectorUIProxy_Load:
        return jsValueForDecodedMessage<MessageName::WebInspectorUIProxy_Load>(globalObject, decoder);
    case MessageName::WebInspectorUIProxy_PickColorFromScreen:
        return jsValueForDecodedMessage<MessageName::WebInspectorUIProxy_PickColorFromScreen>(globalObject, decoder);
    case MessageName::WebInspectorUIProxy_AttachBottom:
        return jsValueForDecodedMessage<MessageName::WebInspectorUIProxy_AttachBottom>(globalObject, decoder);
    case MessageName::WebInspectorUIProxy_AttachRight:
        return jsValueForDecodedMessage<MessageName::WebInspectorUIProxy_AttachRight>(globalObject, decoder);
    case MessageName::WebInspectorUIProxy_AttachLeft:
        return jsValueForDecodedMessage<MessageName::WebInspectorUIProxy_AttachLeft>(globalObject, decoder);
    case MessageName::WebInspectorUIProxy_Detach:
        return jsValueForDecodedMessage<MessageName::WebInspectorUIProxy_Detach>(globalObject, decoder);
    case MessageName::WebInspectorUIProxy_SetAttachedWindowHeight:
        return jsValueForDecodedMessage<MessageName::WebInspectorUIProxy_SetAttachedWindowHeight>(globalObject, decoder);
    case MessageName::WebInspectorUIProxy_SetAttachedWindowWidth:
        return jsValueForDecodedMessage<MessageName::WebInspectorUIProxy_SetAttachedWindowWidth>(globalObject, decoder);
    case MessageName::WebInspectorUIProxy_SetSheetRect:
        return jsValueForDecodedMessage<MessageName::WebInspectorUIProxy_SetSheetRect>(globalObject, decoder);
    case MessageName::WebInspectorUIProxy_StartWindowDrag:
        return jsValueForDecodedMessage<MessageName::WebInspectorUIProxy_StartWindowDrag>(globalObject, decoder);
    case MessageName::WebInspectorUIProxy_SetInspectorPageDeveloperExtrasEnabled:
        return jsValueForDecodedMessage<MessageName::WebInspectorUIProxy_SetInspectorPageDeveloperExtrasEnabled>(globalObject, decoder);
    case MessageName::NetworkProcessProxy_DidReceiveAuthenticationChallenge:
        return jsValueForDecodedMessage<MessageName::NetworkProcessProxy_DidReceiveAuthenticationChallenge>(globalObject, decoder);
    case MessageName::NetworkProcessProxy_NegotiatedLegacyTLS:
        return jsValueForDecodedMessage<MessageName::NetworkProcessProxy_NegotiatedLegacyTLS>(globalObject, decoder);
    case MessageName::NetworkProcessProxy_DidNegotiateModernTLS:
        return jsValueForDecodedMessage<MessageName::NetworkProcessProxy_DidNegotiateModernTLS>(globalObject, decoder);
    case MessageName::NetworkProcessProxy_DidBlockLoadToKnownTracker:
        return jsValueForDecodedMessage<MessageName::NetworkProcessProxy_DidBlockLoadToKnownTracker>(globalObject, decoder);
    case MessageName::NetworkProcessProxy_TestProcessIncomingSyncMessagesWhenWaitingForSyncReply:
        return jsValueForDecodedMessage<MessageName::NetworkProcessProxy_TestProcessIncomingSyncMessagesWhenWaitingForSyncReply>(globalObject, decoder);
    case MessageName::NetworkProcessProxy_ProcessHasUnresponseServiceWorker:
        return jsValueForDecodedMessage<MessageName::NetworkProcessProxy_ProcessHasUnresponseServiceWorker>(globalObject, decoder);
    case MessageName::NetworkProcessProxy_LogDiagnosticMessage:
        return jsValueForDecodedMessage<MessageName::NetworkProcessProxy_LogDiagnosticMessage>(globalObject, decoder);
    case MessageName::NetworkProcessProxy_LogDiagnosticMessageWithResult:
        return jsValueForDecodedMessage<MessageName::NetworkProcessProxy_LogDiagnosticMessageWithResult>(globalObject, decoder);
    case MessageName::NetworkProcessProxy_LogDiagnosticMessageWithValue:
        return jsValueForDecodedMessage<MessageName::NetworkProcessProxy_LogDiagnosticMessageWithValue>(globalObject, decoder);
    case MessageName::NetworkProcessProxy_LogTestingEvent:
        return jsValueForDecodedMessage<MessageName::NetworkProcessProxy_LogTestingEvent>(globalObject, decoder);
    case MessageName::NetworkProcessProxy_RequestStorageAccessConfirm:
        return jsValueForDecodedMessage<MessageName::NetworkProcessProxy_RequestStorageAccessConfirm>(globalObject, decoder);
    case MessageName::NetworkProcessProxy_DeleteWebsiteDataInUIProcessForRegistrableDomains:
        return jsValueForDecodedMessage<MessageName::NetworkProcessProxy_DeleteWebsiteDataInUIProcessForRegistrableDomains>(globalObject, decoder);
    case MessageName::NetworkProcessProxy_DidCommitCrossSiteLoadWithDataTransferFromPrevalentResource:
        return jsValueForDecodedMessage<MessageName::NetworkProcessProxy_DidCommitCrossSiteLoadWithDataTransferFromPrevalentResource>(globalObject, decoder);
    case MessageName::NetworkProcessProxy_SetDomainsWithUserInteraction:
        return jsValueForDecodedMessage<MessageName::NetworkProcessProxy_SetDomainsWithUserInteraction>(globalObject, decoder);
    case MessageName::NetworkProcessProxy_SetDomainsWithCrossPageStorageAccess:
        return jsValueForDecodedMessage<MessageName::NetworkProcessProxy_SetDomainsWithCrossPageStorageAccess>(globalObject, decoder);
#if ENABLE(CONTENT_EXTENSIONS)
    case MessageName::NetworkProcessProxy_ContentExtensionRules:
        return jsValueForDecodedMessage<MessageName::NetworkProcessProxy_ContentExtensionRules>(globalObject, decoder);
#endif
    case MessageName::NetworkProcessProxy_TerminateWebProcess:
        return jsValueForDecodedMessage<MessageName::NetworkProcessProxy_TerminateWebProcess>(globalObject, decoder);
    case MessageName::NetworkProcessProxy_StartServiceWorkerBackgroundProcessing:
        return jsValueForDecodedMessage<MessageName::NetworkProcessProxy_StartServiceWorkerBackgroundProcessing>(globalObject, decoder);
    case MessageName::NetworkProcessProxy_EndServiceWorkerBackgroundProcessing:
        return jsValueForDecodedMessage<MessageName::NetworkProcessProxy_EndServiceWorkerBackgroundProcessing>(globalObject, decoder);
    case MessageName::NetworkProcessProxy_RequestBackgroundFetchPermission:
        return jsValueForDecodedMessage<MessageName::NetworkProcessProxy_RequestBackgroundFetchPermission>(globalObject, decoder);
    case MessageName::NetworkProcessProxy_NotifyBackgroundFetchChange:
        return jsValueForDecodedMessage<MessageName::NetworkProcessProxy_NotifyBackgroundFetchChange>(globalObject, decoder);
    case MessageName::NetworkProcessProxy_EstablishRemoteWorkerContextConnectionToNetworkProcess:
        return jsValueForDecodedMessage<MessageName::NetworkProcessProxy_EstablishRemoteWorkerContextConnectionToNetworkProcess>(globalObject, decoder);
    case MessageName::NetworkProcessProxy_RemoteWorkerContextConnectionNoLongerNeeded:
        return jsValueForDecodedMessage<MessageName::NetworkProcessProxy_RemoteWorkerContextConnectionNoLongerNeeded>(globalObject, decoder);
    case MessageName::NetworkProcessProxy_RegisterRemoteWorkerClientProcess:
        return jsValueForDecodedMessage<MessageName::NetworkProcessProxy_RegisterRemoteWorkerClientProcess>(globalObject, decoder);
    case MessageName::NetworkProcessProxy_UnregisterRemoteWorkerClientProcess:
        return jsValueForDecodedMessage<MessageName::NetworkProcessProxy_UnregisterRemoteWorkerClientProcess>(globalObject, decoder);
    case MessageName::NetworkProcessProxy_SetWebProcessHasUploads:
        return jsValueForDecodedMessage<MessageName::NetworkProcessProxy_SetWebProcessHasUploads>(globalObject, decoder);
#if ENABLE(APP_BOUND_DOMAINS)
    case MessageName::NetworkProcessProxy_GetAppBoundDomains:
        return jsValueForDecodedMessage<MessageName::NetworkProcessProxy_GetAppBoundDomains>(globalObject, decoder);
#endif
    case MessageName::NetworkProcessProxy_IncreaseQuota:
        return jsValueForDecodedMessage<MessageName::NetworkProcessProxy_IncreaseQuota>(globalObject, decoder);
    case MessageName::NetworkProcessProxy_ResourceLoadDidSendRequest:
        return jsValueForDecodedMessage<MessageName::NetworkProcessProxy_ResourceLoadDidSendRequest>(globalObject, decoder);
    case MessageName::NetworkProcessProxy_ResourceLoadDidPerformHTTPRedirection:
        return jsValueForDecodedMessage<MessageName::NetworkProcessProxy_ResourceLoadDidPerformHTTPRedirection>(globalObject, decoder);
    case MessageName::NetworkProcessProxy_ResourceLoadDidReceiveChallenge:
        return jsValueForDecodedMessage<MessageName::NetworkProcessProxy_ResourceLoadDidReceiveChallenge>(globalObject, decoder);
    case MessageName::NetworkProcessProxy_ResourceLoadDidReceiveResponse:
        return jsValueForDecodedMessage<MessageName::NetworkProcessProxy_ResourceLoadDidReceiveResponse>(globalObject, decoder);
    case MessageName::NetworkProcessProxy_ResourceLoadDidCompleteWithError:
        return jsValueForDecodedMessage<MessageName::NetworkProcessProxy_ResourceLoadDidCompleteWithError>(globalObject, decoder);
    case MessageName::NetworkProcessProxy_DidAllowPrivateTokenUsageByThirdPartyForTesting:
        return jsValueForDecodedMessage<MessageName::NetworkProcessProxy_DidAllowPrivateTokenUsageByThirdPartyForTesting>(globalObject, decoder);
    case MessageName::NetworkProcessProxy_TriggerBrowsingContextGroupSwitchForNavigation:
        return jsValueForDecodedMessage<MessageName::NetworkProcessProxy_TriggerBrowsingContextGroupSwitchForNavigation>(globalObject, decoder);
#if USE(SOUP)
    case MessageName::NetworkProcessProxy_DidExceedMemoryLimit:
        return jsValueForDecodedMessage<MessageName::NetworkProcessProxy_DidExceedMemoryLimit>(globalObject, decoder);
#endif
#if ENABLE(APPLE_PAY_REMOTE_UI_USES_SCENE)
    case MessageName::NetworkProcessProxy_GetWindowSceneAndBundleIdentifierForPaymentPresentation:
        return jsValueForDecodedMessage<MessageName::NetworkProcessProxy_GetWindowSceneAndBundleIdentifierForPaymentPresentation>(globalObject, decoder);
#endif
#if ENABLE(APPLE_PAY_REMOTE_UI)
    case MessageName::NetworkProcessProxy_GetPaymentCoordinatorEmbeddingUserAgent:
        return jsValueForDecodedMessage<MessageName::NetworkProcessProxy_GetPaymentCoordinatorEmbeddingUserAgent>(globalObject, decoder);
#endif
    case MessageName::NetworkProcessProxy_DataTaskReceivedChallenge:
        return jsValueForDecodedMessage<MessageName::NetworkProcessProxy_DataTaskReceivedChallenge>(globalObject, decoder);
    case MessageName::NetworkProcessProxy_DataTaskWillPerformHTTPRedirection:
        return jsValueForDecodedMessage<MessageName::NetworkProcessProxy_DataTaskWillPerformHTTPRedirection>(globalObject, decoder);
    case MessageName::NetworkProcessProxy_DataTaskDidReceiveResponse:
        return jsValueForDecodedMessage<MessageName::NetworkProcessProxy_DataTaskDidReceiveResponse>(globalObject, decoder);
    case MessageName::NetworkProcessProxy_DataTaskDidReceiveData:
        return jsValueForDecodedMessage<MessageName::NetworkProcessProxy_DataTaskDidReceiveData>(globalObject, decoder);
    case MessageName::NetworkProcessProxy_DataTaskDidCompleteWithError:
        return jsValueForDecodedMessage<MessageName::NetworkProcessProxy_DataTaskDidCompleteWithError>(globalObject, decoder);
    case MessageName::NetworkProcessProxy_OpenWindowFromServiceWorker:
        return jsValueForDecodedMessage<MessageName::NetworkProcessProxy_OpenWindowFromServiceWorker>(globalObject, decoder);
    case MessageName::NetworkProcessProxy_NavigateServiceWorkerClient:
        return jsValueForDecodedMessage<MessageName::NetworkProcessProxy_NavigateServiceWorkerClient>(globalObject, decoder);
    case MessageName::NetworkProcessProxy_ReportConsoleMessage:
        return jsValueForDecodedMessage<MessageName::NetworkProcessProxy_ReportConsoleMessage>(globalObject, decoder);
    case MessageName::NetworkProcessProxy_CookiesDidChange:
        return jsValueForDecodedMessage<MessageName::NetworkProcessProxy_CookiesDidChange>(globalObject, decoder);
    case MessageName::NetworkProcessProxy_DeleteWebsiteDataInWebProcessesForOrigin:
        return jsValueForDecodedMessage<MessageName::NetworkProcessProxy_DeleteWebsiteDataInWebProcessesForOrigin>(globalObject, decoder);
    case MessageName::NetworkProcessProxy_ReloadExecutionContextsForOrigin:
        return jsValueForDecodedMessage<MessageName::NetworkProcessProxy_ReloadExecutionContextsForOrigin>(globalObject, decoder);
#if USE(RUNNINGBOARD)
    case MessageName::NetworkProcessProxy_WakeUpWebProcessForIPC:
        return jsValueForDecodedMessage<MessageName::NetworkProcessProxy_WakeUpWebProcessForIPC>(globalObject, decoder);
#endif
#if ENABLE(NETWORK_ISSUE_REPORTING)
    case MessageName::NetworkProcessProxy_ReportNetworkIssue:
        return jsValueForDecodedMessage<MessageName::NetworkProcessProxy_ReportNetworkIssue>(globalObject, decoder);
#endif
    case MessageName::WebUserContentControllerProxy_DidPostMessage:
        return jsValueForDecodedMessage<MessageName::WebUserContentControllerProxy_DidPostMessage>(globalObject, decoder);
#if ENABLE(WEBXR)
    case MessageName::PlatformXRSystem_EnumerateImmersiveXRDevices:
        return jsValueForDecodedMessage<MessageName::PlatformXRSystem_EnumerateImmersiveXRDevices>(globalObject, decoder);
    case MessageName::PlatformXRSystem_RequestPermissionOnSessionFeatures:
        return jsValueForDecodedMessage<MessageName::PlatformXRSystem_RequestPermissionOnSessionFeatures>(globalObject, decoder);
    case MessageName::PlatformXRSystem_InitializeTrackingAndRendering:
        return jsValueForDecodedMessage<MessageName::PlatformXRSystem_InitializeTrackingAndRendering>(globalObject, decoder);
    case MessageName::PlatformXRSystem_ShutDownTrackingAndRendering:
        return jsValueForDecodedMessage<MessageName::PlatformXRSystem_ShutDownTrackingAndRendering>(globalObject, decoder);
    case MessageName::PlatformXRSystem_RequestFrame:
        return jsValueForDecodedMessage<MessageName::PlatformXRSystem_RequestFrame>(globalObject, decoder);
#if USE(OPENXR)
    case MessageName::PlatformXRSystem_CreateLayerProjection:
        return jsValueForDecodedMessage<MessageName::PlatformXRSystem_CreateLayerProjection>(globalObject, decoder);
    case MessageName::PlatformXRSystem_SubmitFrame:
        return jsValueForDecodedMessage<MessageName::PlatformXRSystem_SubmitFrame>(globalObject, decoder);
#endif
#if !USE(OPENXR)
    case MessageName::PlatformXRSystem_SubmitFrame:
        return jsValueForDecodedMessage<MessageName::PlatformXRSystem_SubmitFrame>(globalObject, decoder);
#endif
    case MessageName::PlatformXRSystem_DidCompleteShutdownTriggeredBySystem:
        return jsValueForDecodedMessage<MessageName::PlatformXRSystem_DidCompleteShutdownTriggeredBySystem>(globalObject, decoder);
#endif
    case MessageName::WebProcess_InitializeWebProcess:
        return jsValueForDecodedMessage<MessageName::WebProcess_InitializeWebProcess>(globalObject, decoder);
    case MessageName::WebProcess_SetWebsiteDataStoreParameters:
        return jsValueForDecodedMessage<MessageName::WebProcess_SetWebsiteDataStoreParameters>(globalObject, decoder);
    case MessageName::WebProcess_CreateWebPage:
        return jsValueForDecodedMessage<MessageName::WebProcess_CreateWebPage>(globalObject, decoder);
    case MessageName::WebProcess_PrewarmWithDomainInformation:
        return jsValueForDecodedMessage<MessageName::WebProcess_PrewarmWithDomainInformation>(globalObject, decoder);
    case MessageName::WebProcess_SetCacheModel:
        return jsValueForDecodedMessage<MessageName::WebProcess_SetCacheModel>(globalObject, decoder);
    case MessageName::WebProcess_RegisterURLSchemeAsEmptyDocument:
        return jsValueForDecodedMessage<MessageName::WebProcess_RegisterURLSchemeAsEmptyDocument>(globalObject, decoder);
    case MessageName::WebProcess_RegisterURLSchemeAsSecure:
        return jsValueForDecodedMessage<MessageName::WebProcess_RegisterURLSchemeAsSecure>(globalObject, decoder);
    case MessageName::WebProcess_RegisterURLSchemeAsBypassingContentSecurityPolicy:
        return jsValueForDecodedMessage<MessageName::WebProcess_RegisterURLSchemeAsBypassingContentSecurityPolicy>(globalObject, decoder);
    case MessageName::WebProcess_SetDomainRelaxationForbiddenForURLScheme:
        return jsValueForDecodedMessage<MessageName::WebProcess_SetDomainRelaxationForbiddenForURLScheme>(globalObject, decoder);
    case MessageName::WebProcess_RegisterURLSchemeAsLocal:
        return jsValueForDecodedMessage<MessageName::WebProcess_RegisterURLSchemeAsLocal>(globalObject, decoder);
#if ENABLE(ALL_LEGACY_REGISTERED_SPECIAL_URL_SCHEMES)
    case MessageName::WebProcess_RegisterURLSchemeAsNoAccess:
        return jsValueForDecodedMessage<MessageName::WebProcess_RegisterURLSchemeAsNoAccess>(globalObject, decoder);
#endif
    case MessageName::WebProcess_RegisterURLSchemeAsDisplayIsolated:
        return jsValueForDecodedMessage<MessageName::WebProcess_RegisterURLSchemeAsDisplayIsolated>(globalObject, decoder);
    case MessageName::WebProcess_RegisterURLSchemeAsCORSEnabled:
        return jsValueForDecodedMessage<MessageName::WebProcess_RegisterURLSchemeAsCORSEnabled>(globalObject, decoder);
    case MessageName::WebProcess_RegisterURLSchemeAsCachePartitioned:
        return jsValueForDecodedMessage<MessageName::WebProcess_RegisterURLSchemeAsCachePartitioned>(globalObject, decoder);
    case MessageName::WebProcess_RegisterURLSchemeAsCanDisplayOnlyIfCanRequest:
        return jsValueForDecodedMessage<MessageName::WebProcess_RegisterURLSchemeAsCanDisplayOnlyIfCanRequest>(globalObject, decoder);
#if ENABLE(WK_WEB_EXTENSIONS)
    case MessageName::WebProcess_RegisterURLSchemeAsWebExtension:
        return jsValueForDecodedMessage<MessageName::WebProcess_RegisterURLSchemeAsWebExtension>(globalObject, decoder);
#endif
    case MessageName::WebProcess_SetDefaultRequestTimeoutInterval:
        return jsValueForDecodedMessage<MessageName::WebProcess_SetDefaultRequestTimeoutInterval>(globalObject, decoder);
    case MessageName::WebProcess_SetAlwaysUsesComplexTextCodePath:
        return jsValueForDecodedMessage<MessageName::WebProcess_SetAlwaysUsesComplexTextCodePath>(globalObject, decoder);
    case MessageName::WebProcess_SetDisableFontSubpixelAntialiasingForTesting:
        return jsValueForDecodedMessage<MessageName::WebProcess_SetDisableFontSubpixelAntialiasingForTesting>(globalObject, decoder);
    case MessageName::WebProcess_SetTrackingPreventionEnabled:
        return jsValueForDecodedMessage<MessageName::WebProcess_SetTrackingPreventionEnabled>(globalObject, decoder);
    case MessageName::WebProcess_ClearResourceLoadStatistics:
        return jsValueForDecodedMessage<MessageName::WebProcess_ClearResourceLoadStatistics>(globalObject, decoder);
    case MessageName::WebProcess_UserPreferredLanguagesChanged:
        return jsValueForDecodedMessage<MessageName::WebProcess_UserPreferredLanguagesChanged>(globalObject, decoder);
    case MessageName::WebProcess_FullKeyboardAccessModeChanged:
        return jsValueForDecodedMessage<MessageName::WebProcess_FullKeyboardAccessModeChanged>(globalObject, decoder);
    case MessageName::WebProcess_UpdateStorageAccessUserAgentStringQuirks:
        return jsValueForDecodedMessage<MessageName::WebProcess_UpdateStorageAccessUserAgentStringQuirks>(globalObject, decoder);
#if HAVE(ALLOW_ONLY_PARTITIONED_COOKIES)
    case MessageName::WebProcess_SetOptInCookiePartitioningEnabled:
        return jsValueForDecodedMessage<MessageName::WebProcess_SetOptInCookiePartitioningEnabled>(globalObject, decoder);
#endif
#if HAVE(MOUSE_DEVICE_OBSERVATION)
    case MessageName::WebProcess_SetHasMouseDevice:
        return jsValueForDecodedMessage<MessageName::WebProcess_SetHasMouseDevice>(globalObject, decoder);
#endif
#if HAVE(STYLUS_DEVICE_OBSERVATION)
    case MessageName::WebProcess_SetHasStylusDevice:
        return jsValueForDecodedMessage<MessageName::WebProcess_SetHasStylusDevice>(globalObject, decoder);
#endif
    case MessageName::WebProcess_StartMemorySampler:
        return jsValueForDecodedMessage<MessageName::WebProcess_StartMemorySampler>(globalObject, decoder);
    case MessageName::WebProcess_StopMemorySampler:
        return jsValueForDecodedMessage<MessageName::WebProcess_StopMemorySampler>(globalObject, decoder);
    case MessageName::WebProcess_SetTextCheckerState:
        return jsValueForDecodedMessage<MessageName::WebProcess_SetTextCheckerState>(globalObject, decoder);
    case MessageName::WebProcess_SetEnhancedAccessibility:
        return jsValueForDecodedMessage<MessageName::WebProcess_SetEnhancedAccessibility>(globalObject, decoder);
    case MessageName::WebProcess_BindAccessibilityFrameWithData:
        return jsValueForDecodedMessage<MessageName::WebProcess_BindAccessibilityFrameWithData>(globalObject, decoder);
    case MessageName::WebProcess_GarbageCollectJavaScriptObjects:
        return jsValueForDecodedMessage<MessageName::WebProcess_GarbageCollectJavaScriptObjects>(globalObject, decoder);
    case MessageName::WebProcess_SetJavaScriptGarbageCollectorTimerEnabled:
        return jsValueForDecodedMessage<MessageName::WebProcess_SetJavaScriptGarbageCollectorTimerEnabled>(globalObject, decoder);
    case MessageName::WebProcess_SetInjectedBundleParameter:
        return jsValueForDecodedMessage<MessageName::WebProcess_SetInjectedBundleParameter>(globalObject, decoder);
    case MessageName::WebProcess_SetInjectedBundleParameters:
        return jsValueForDecodedMessage<MessageName::WebProcess_SetInjectedBundleParameters>(globalObject, decoder);
    case MessageName::WebProcess_HandleInjectedBundleMessage:
        return jsValueForDecodedMessage<MessageName::WebProcess_HandleInjectedBundleMessage>(globalObject, decoder);
    case MessageName::WebProcess_FetchWebsiteData:
        return jsValueForDecodedMessage<MessageName::WebProcess_FetchWebsiteData>(globalObject, decoder);
    case MessageName::WebProcess_DeleteWebsiteData:
        return jsValueForDecodedMessage<MessageName::WebProcess_DeleteWebsiteData>(globalObject, decoder);
    case MessageName::WebProcess_DeleteWebsiteDataForOrigins:
        return jsValueForDecodedMessage<MessageName::WebProcess_DeleteWebsiteDataForOrigins>(globalObject, decoder);
    case MessageName::WebProcess_DeleteWebsiteDataForOrigin:
        return jsValueForDecodedMessage<MessageName::WebProcess_DeleteWebsiteDataForOrigin>(globalObject, decoder);
    case MessageName::WebProcess_ReloadExecutionContextsForOrigin:
        return jsValueForDecodedMessage<MessageName::WebProcess_ReloadExecutionContextsForOrigin>(globalObject, decoder);
    case MessageName::WebProcess_DeleteAllCookies:
        return jsValueForDecodedMessage<MessageName::WebProcess_DeleteAllCookies>(globalObject, decoder);
    case MessageName::WebProcess_SetHiddenPageDOMTimerThrottlingIncreaseLimit:
        return jsValueForDecodedMessage<MessageName::WebProcess_SetHiddenPageDOMTimerThrottlingIncreaseLimit>(globalObject, decoder);
    case MessageName::WebProcess_SetMemoryCacheDisabled:
        return jsValueForDecodedMessage<MessageName::WebProcess_SetMemoryCacheDisabled>(globalObject, decoder);
#if ENABLE(SERVICE_CONTROLS)
    case MessageName::WebProcess_SetEnabledServices:
        return jsValueForDecodedMessage<MessageName::WebProcess_SetEnabledServices>(globalObject, decoder);
#endif
    case MessageName::WebProcess_EnsureAutomationSessionProxy:
        return jsValueForDecodedMessage<MessageName::WebProcess_EnsureAutomationSessionProxy>(globalObject, decoder);
    case MessageName::WebProcess_DestroyAutomationSessionProxy:
        return jsValueForDecodedMessage<MessageName::WebProcess_DestroyAutomationSessionProxy>(globalObject, decoder);
    case MessageName::WebProcess_PrepareToSuspend:
        return jsValueForDecodedMessage<MessageName::WebProcess_PrepareToSuspend>(globalObject, decoder);
    case MessageName::WebProcess_ProcessDidResume:
        return jsValueForDecodedMessage<MessageName::WebProcess_ProcessDidResume>(globalObject, decoder);
    case MessageName::WebProcess_BackgroundResponsivenessPing:
        return jsValueForDecodedMessage<MessageName::WebProcess_BackgroundResponsivenessPing>(globalObject, decoder);
#if ENABLE(GAMEPAD)
    case MessageName::WebProcess_SetInitialGamepads:
        return jsValueForDecodedMessage<MessageName::WebProcess_SetInitialGamepads>(globalObject, decoder);
    case MessageName::WebProcess_GamepadConnected:
        return jsValueForDecodedMessage<MessageName::WebProcess_GamepadConnected>(globalObject, decoder);
    case MessageName::WebProcess_GamepadDisconnected:
        return jsValueForDecodedMessage<MessageName::WebProcess_GamepadDisconnected>(globalObject, decoder);
#endif
    case MessageName::WebProcess_EstablishRemoteWorkerContextConnectionToNetworkProcess:
        return jsValueForDecodedMessage<MessageName::WebProcess_EstablishRemoteWorkerContextConnectionToNetworkProcess>(globalObject, decoder);
    case MessageName::WebProcess_RegisterServiceWorkerClients:
        return jsValueForDecodedMessage<MessageName::WebProcess_RegisterServiceWorkerClients>(globalObject, decoder);
    case MessageName::WebProcess_SetHasSuspendedPageProxy:
        return jsValueForDecodedMessage<MessageName::WebProcess_SetHasSuspendedPageProxy>(globalObject, decoder);
    case MessageName::WebProcess_SetIsInProcessCache:
        return jsValueForDecodedMessage<MessageName::WebProcess_SetIsInProcessCache>(globalObject, decoder);
    case MessageName::WebProcess_MarkIsNoLongerPrewarmed:
        return jsValueForDecodedMessage<MessageName::WebProcess_MarkIsNoLongerPrewarmed>(globalObject, decoder);
    case MessageName::WebProcess_GetActivePagesOriginsForTesting:
        return jsValueForDecodedMessage<MessageName::WebProcess_GetActivePagesOriginsForTesting>(globalObject, decoder);
#if PLATFORM(COCOA) || PLATFORM(GTK) || PLATFORM(WPE)
    case MessageName::WebProcess_SetScreenProperties:
        return jsValueForDecodedMessage<MessageName::WebProcess_SetScreenProperties>(globalObject, decoder);
#endif
#if PLATFORM(MAC)
    case MessageName::WebProcess_ScrollerStylePreferenceChanged:
        return jsValueForDecodedMessage<MessageName::WebProcess_ScrollerStylePreferenceChanged>(globalObject, decoder);
#endif
#if PLATFORM(IOS_FAMILY)
    case MessageName::WebProcess_UserInterfaceIdiomDidChange:
        return jsValueForDecodedMessage<MessageName::WebProcess_UserInterfaceIdiomDidChange>(globalObject, decoder);
#endif
#if PLATFORM(IOS_FAMILY) && !PLATFORM(MACCATALYST)
    case MessageName::WebProcess_BacklightLevelDidChange:
        return jsValueForDecodedMessage<MessageName::WebProcess_BacklightLevelDidChange>(globalObject, decoder);
#endif
#if PLATFORM(MAC) || PLATFORM(MACCATALYST)
    case MessageName::WebProcess_ColorPreferencesDidChange:
        return jsValueForDecodedMessage<MessageName::WebProcess_ColorPreferencesDidChange>(globalObject, decoder);
#endif
    case MessageName::WebProcess_IsJITEnabled:
        return jsValueForDecodedMessage<MessageName::WebProcess_IsJITEnabled>(globalObject, decoder);
#if PLATFORM(COCOA)
    case MessageName::WebProcess_SetMediaMIMETypes:
        return jsValueForDecodedMessage<MessageName::WebProcess_SetMediaMIMETypes>(globalObject, decoder);
#endif
#if (PLATFORM(COCOA) && ENABLE(REMOTE_INSPECTOR))
    case MessageName::WebProcess_EnableRemoteWebInspector:
        return jsValueForDecodedMessage<MessageName::WebProcess_EnableRemoteWebInspector>(globalObject, decoder);
#endif
#if ENABLE(MEDIA_STREAM)
    case MessageName::WebProcess_AddMockMediaDevice:
        return jsValueForDecodedMessage<MessageName::WebProcess_AddMockMediaDevice>(globalObject, decoder);
    case MessageName::WebProcess_ClearMockMediaDevices:
        return jsValueForDecodedMessage<MessageName::WebProcess_ClearMockMediaDevices>(globalObject, decoder);
    case MessageName::WebProcess_RemoveMockMediaDevice:
        return jsValueForDecodedMessage<MessageName::WebProcess_RemoveMockMediaDevice>(globalObject, decoder);
    case MessageName::WebProcess_SetMockMediaDeviceIsEphemeral:
        return jsValueForDecodedMessage<MessageName::WebProcess_SetMockMediaDeviceIsEphemeral>(globalObject, decoder);
    case MessageName::WebProcess_ResetMockMediaDevices:
        return jsValueForDecodedMessage<MessageName::WebProcess_ResetMockMediaDevices>(globalObject, decoder);
#endif
#if (ENABLE(MEDIA_STREAM) && ENABLE(SANDBOX_EXTENSIONS))
    case MessageName::WebProcess_GrantUserMediaDeviceSandboxExtensions:
        return jsValueForDecodedMessage<MessageName::WebProcess_GrantUserMediaDeviceSandboxExtensions>(globalObject, decoder);
    case MessageName::WebProcess_RevokeUserMediaDeviceSandboxExtensions:
        return jsValueForDecodedMessage<MessageName::WebProcess_RevokeUserMediaDeviceSandboxExtensions>(globalObject, decoder);
#endif
    case MessageName::WebProcess_ClearCurrentModifierStateForTesting:
        return jsValueForDecodedMessage<MessageName::WebProcess_ClearCurrentModifierStateForTesting>(globalObject, decoder);
    case MessageName::WebProcess_SetBackForwardCacheCapacity:
        return jsValueForDecodedMessage<MessageName::WebProcess_SetBackForwardCacheCapacity>(globalObject, decoder);
    case MessageName::WebProcess_ClearCachedPage:
        return jsValueForDecodedMessage<MessageName::WebProcess_ClearCachedPage>(globalObject, decoder);
#if PLATFORM(GTK) || PLATFORM(WPE)
    case MessageName::WebProcess_SendMessageToWebProcessExtension:
        return jsValueForDecodedMessage<MessageName::WebProcess_SendMessageToWebProcessExtension>(globalObject, decoder);
    case MessageName::WebProcess_SetAvailableInputDevices:
        return jsValueForDecodedMessage<MessageName::WebProcess_SetAvailableInputDevices>(globalObject, decoder);
#endif
    case MessageName::WebProcess_SeedResourceLoadStatisticsForTesting:
        return jsValueForDecodedMessage<MessageName::WebProcess_SeedResourceLoadStatisticsForTesting>(globalObject, decoder);
    case MessageName::WebProcess_SetThirdPartyCookieBlockingMode:
        return jsValueForDecodedMessage<MessageName::WebProcess_SetThirdPartyCookieBlockingMode>(globalObject, decoder);
    case MessageName::WebProcess_SetDomainsWithUserInteraction:
        return jsValueForDecodedMessage<MessageName::WebProcess_SetDomainsWithUserInteraction>(globalObject, decoder);
    case MessageName::WebProcess_SetDomainsWithCrossPageStorageAccess:
        return jsValueForDecodedMessage<MessageName::WebProcess_SetDomainsWithCrossPageStorageAccess>(globalObject, decoder);
    case MessageName::WebProcess_SendResourceLoadStatisticsDataImmediately:
        return jsValueForDecodedMessage<MessageName::WebProcess_SendResourceLoadStatisticsDataImmediately>(globalObject, decoder);
    case MessageName::WebProcess_UpdateDomainsWithStorageAccessQuirks:
        return jsValueForDecodedMessage<MessageName::WebProcess_UpdateDomainsWithStorageAccessQuirks>(globalObject, decoder);
    case MessageName::WebProcess_UpdateScriptTrackingPrivacyFilter:
        return jsValueForDecodedMessage<MessageName::WebProcess_UpdateScriptTrackingPrivacyFilter>(globalObject, decoder);
    case MessageName::WebProcess_GrantAccessToAssetServices:
        return jsValueForDecodedMessage<MessageName::WebProcess_GrantAccessToAssetServices>(globalObject, decoder);
    case MessageName::WebProcess_RevokeAccessToAssetServices:
        return jsValueForDecodedMessage<MessageName::WebProcess_RevokeAccessToAssetServices>(globalObject, decoder);
    case MessageName::WebProcess_SwitchFromStaticFontRegistryToUserFontRegistry:
        return jsValueForDecodedMessage<MessageName::WebProcess_SwitchFromStaticFontRegistryToUserFontRegistry>(globalObject, decoder);
#if PLATFORM(COCOA)
    case MessageName::WebProcess_DisableURLSchemeCheckInDataDetectors:
        return jsValueForDecodedMessage<MessageName::WebProcess_DisableURLSchemeCheckInDataDetectors>(globalObject, decoder);
    case MessageName::WebProcess_UnblockServicesRequiredByAccessibility:
        return jsValueForDecodedMessage<MessageName::WebProcess_UnblockServicesRequiredByAccessibility>(globalObject, decoder);
    case MessageName::WebProcess_PowerSourceDidChange:
        return jsValueForDecodedMessage<MessageName::WebProcess_PowerSourceDidChange>(globalObject, decoder);
#endif
#if PLATFORM(GTK) && !USE(GTK4) && USE(CAIRO)
    case MessageName::WebProcess_SetUseSystemAppearanceForScrollbars:
        return jsValueForDecodedMessage<MessageName::WebProcess_SetUseSystemAppearanceForScrollbars>(globalObject, decoder);
#endif
#if PLATFORM(COCOA)
    case MessageName::WebProcess_DidWriteToPasteboardAsynchronously:
        return jsValueForDecodedMessage<MessageName::WebProcess_DidWriteToPasteboardAsynchronously>(globalObject, decoder);
#endif
#if HAVE(DISPLAY_LINK)
    case MessageName::WebProcess_DisplayDidRefresh:
        return jsValueForDecodedMessage<MessageName::WebProcess_DisplayDidRefresh>(globalObject, decoder);
#endif
#if PLATFORM(MAC)
    case MessageName::WebProcess_SystemWillPowerOn:
        return jsValueForDecodedMessage<MessageName::WebProcess_SystemWillPowerOn>(globalObject, decoder);
    case MessageName::WebProcess_SystemWillSleep:
        return jsValueForDecodedMessage<MessageName::WebProcess_SystemWillSleep>(globalObject, decoder);
    case MessageName::WebProcess_SystemDidWake:
        return jsValueForDecodedMessage<MessageName::WebProcess_SystemDidWake>(globalObject, decoder);
#endif
#if HAVE(AUDIO_COMPONENT_SERVER_REGISTRATIONS)
    case MessageName::WebProcess_ConsumeAudioComponentRegistrations:
        return jsValueForDecodedMessage<MessageName::WebProcess_ConsumeAudioComponentRegistrations>(globalObject, decoder);
#endif
#if PLATFORM(COCOA)
    case MessageName::WebProcess_AccessibilityPreferencesDidChange:
        return jsValueForDecodedMessage<MessageName::WebProcess_AccessibilityPreferencesDidChange>(globalObject, decoder);
#endif
#if HAVE(MEDIA_ACCESSIBILITY_FRAMEWORK)
    case MessageName::WebProcess_SetMediaAccessibilityPreferences:
        return jsValueForDecodedMessage<MessageName::WebProcess_SetMediaAccessibilityPreferences>(globalObject, decoder);
#endif
#if PLATFORM(MAC)
    case MessageName::WebProcess_OpenDirectoryCacheInvalidated:
        return jsValueForDecodedMessage<MessageName::WebProcess_OpenDirectoryCacheInvalidated>(globalObject, decoder);
#endif
    case MessageName::WebProcess_ReleaseMemory:
        return jsValueForDecodedMessage<MessageName::WebProcess_ReleaseMemory>(globalObject, decoder);
#if ENABLE(NOTIFY_BLOCKING)
    case MessageName::WebProcess_PostNotification:
        return jsValueForDecodedMessage<MessageName::WebProcess_PostNotification>(globalObject, decoder);
    case MessageName::WebProcess_PostObserverNotification:
        return jsValueForDecodedMessage<MessageName::WebProcess_PostObserverNotification>(globalObject, decoder);
    case MessageName::WebProcess_GetNotifyStateForTesting:
        return jsValueForDecodedMessage<MessageName::WebProcess_GetNotifyStateForTesting>(globalObject, decoder);
#endif
#if ENABLE(CONTENT_EXTENSIONS)
    case MessageName::WebProcess_SetResourceMonitorContentRuleList:
        return jsValueForDecodedMessage<MessageName::WebProcess_SetResourceMonitorContentRuleList>(globalObject, decoder);
    case MessageName::WebProcess_SetResourceMonitorContentRuleListAsync:
        return jsValueForDecodedMessage<MessageName::WebProcess_SetResourceMonitorContentRuleListAsync>(globalObject, decoder);
#endif
#if PLATFORM(COCOA)
    case MessageName::WebProcess_RegisterAdditionalFonts:
        return jsValueForDecodedMessage<MessageName::WebProcess_RegisterAdditionalFonts>(globalObject, decoder);
    case MessageName::WebProcess_RegisterFontMap:
        return jsValueForDecodedMessage<MessageName::WebProcess_RegisterFontMap>(globalObject, decoder);
#endif
#if ENABLE(INITIALIZE_ACCESSIBILITY_ON_DEMAND)
    case MessageName::WebProcess_InitializeAccessibility:
        return jsValueForDecodedMessage<MessageName::WebProcess_InitializeAccessibility>(globalObject, decoder);
#endif
    case MessageName::WebAutomationSessionProxy_EvaluateJavaScriptFunction:
        return jsValueForDecodedMessage<MessageName::WebAutomationSessionProxy_EvaluateJavaScriptFunction>(globalObject, decoder);
    case MessageName::WebAutomationSessionProxy_ResolveChildFrameWithOrdinal:
        return jsValueForDecodedMessage<MessageName::WebAutomationSessionProxy_ResolveChildFrameWithOrdinal>(globalObject, decoder);
    case MessageName::WebAutomationSessionProxy_ResolveChildFrameWithNodeHandle:
        return jsValueForDecodedMessage<MessageName::WebAutomationSessionProxy_ResolveChildFrameWithNodeHandle>(globalObject, decoder);
    case MessageName::WebAutomationSessionProxy_ResolveChildFrameWithName:
        return jsValueForDecodedMessage<MessageName::WebAutomationSessionProxy_ResolveChildFrameWithName>(globalObject, decoder);
    case MessageName::WebAutomationSessionProxy_ResolveParentFrame:
        return jsValueForDecodedMessage<MessageName::WebAutomationSessionProxy_ResolveParentFrame>(globalObject, decoder);
    case MessageName::WebAutomationSessionProxy_FocusFrame:
        return jsValueForDecodedMessage<MessageName::WebAutomationSessionProxy_FocusFrame>(globalObject, decoder);
    case MessageName::WebAutomationSessionProxy_ComputeElementLayout:
        return jsValueForDecodedMessage<MessageName::WebAutomationSessionProxy_ComputeElementLayout>(globalObject, decoder);
    case MessageName::WebAutomationSessionProxy_GetComputedRole:
        return jsValueForDecodedMessage<MessageName::WebAutomationSessionProxy_GetComputedRole>(globalObject, decoder);
    case MessageName::WebAutomationSessionProxy_GetComputedLabel:
        return jsValueForDecodedMessage<MessageName::WebAutomationSessionProxy_GetComputedLabel>(globalObject, decoder);
    case MessageName::WebAutomationSessionProxy_SelectOptionElement:
        return jsValueForDecodedMessage<MessageName::WebAutomationSessionProxy_SelectOptionElement>(globalObject, decoder);
    case MessageName::WebAutomationSessionProxy_SetFilesForInputFileUpload:
        return jsValueForDecodedMessage<MessageName::WebAutomationSessionProxy_SetFilesForInputFileUpload>(globalObject, decoder);
    case MessageName::WebAutomationSessionProxy_TakeScreenshot:
        return jsValueForDecodedMessage<MessageName::WebAutomationSessionProxy_TakeScreenshot>(globalObject, decoder);
    case MessageName::WebAutomationSessionProxy_SnapshotRectForScreenshot:
        return jsValueForDecodedMessage<MessageName::WebAutomationSessionProxy_SnapshotRectForScreenshot>(globalObject, decoder);
    case MessageName::WebAutomationSessionProxy_GetCookiesForFrame:
        return jsValueForDecodedMessage<MessageName::WebAutomationSessionProxy_GetCookiesForFrame>(globalObject, decoder);
    case MessageName::WebAutomationSessionProxy_DeleteCookie:
        return jsValueForDecodedMessage<MessageName::WebAutomationSessionProxy_DeleteCookie>(globalObject, decoder);
    case MessageName::WebIDBConnectionToServer_DidDeleteDatabase:
        return jsValueForDecodedMessage<MessageName::WebIDBConnectionToServer_DidDeleteDatabase>(globalObject, decoder);
    case MessageName::WebIDBConnectionToServer_DidOpenDatabase:
        return jsValueForDecodedMessage<MessageName::WebIDBConnectionToServer_DidOpenDatabase>(globalObject, decoder);
    case MessageName::WebIDBConnectionToServer_DidAbortTransaction:
        return jsValueForDecodedMessage<MessageName::WebIDBConnectionToServer_DidAbortTransaction>(globalObject, decoder);
    case MessageName::WebIDBConnectionToServer_DidCommitTransaction:
        return jsValueForDecodedMessage<MessageName::WebIDBConnectionToServer_DidCommitTransaction>(globalObject, decoder);
    case MessageName::WebIDBConnectionToServer_DidCreateObjectStore:
        return jsValueForDecodedMessage<MessageName::WebIDBConnectionToServer_DidCreateObjectStore>(globalObject, decoder);
    case MessageName::WebIDBConnectionToServer_DidDeleteObjectStore:
        return jsValueForDecodedMessage<MessageName::WebIDBConnectionToServer_DidDeleteObjectStore>(globalObject, decoder);
    case MessageName::WebIDBConnectionToServer_DidRenameObjectStore:
        return jsValueForDecodedMessage<MessageName::WebIDBConnectionToServer_DidRenameObjectStore>(globalObject, decoder);
    case MessageName::WebIDBConnectionToServer_DidClearObjectStore:
        return jsValueForDecodedMessage<MessageName::WebIDBConnectionToServer_DidClearObjectStore>(globalObject, decoder);
    case MessageName::WebIDBConnectionToServer_DidCreateIndex:
        return jsValueForDecodedMessage<MessageName::WebIDBConnectionToServer_DidCreateIndex>(globalObject, decoder);
    case MessageName::WebIDBConnectionToServer_DidDeleteIndex:
        return jsValueForDecodedMessage<MessageName::WebIDBConnectionToServer_DidDeleteIndex>(globalObject, decoder);
    case MessageName::WebIDBConnectionToServer_DidRenameIndex:
        return jsValueForDecodedMessage<MessageName::WebIDBConnectionToServer_DidRenameIndex>(globalObject, decoder);
    case MessageName::WebIDBConnectionToServer_DidPutOrAdd:
        return jsValueForDecodedMessage<MessageName::WebIDBConnectionToServer_DidPutOrAdd>(globalObject, decoder);
    case MessageName::WebIDBConnectionToServer_DidGetRecord:
        return jsValueForDecodedMessage<MessageName::WebIDBConnectionToServer_DidGetRecord>(globalObject, decoder);
    case MessageName::WebIDBConnectionToServer_DidGetAllRecords:
        return jsValueForDecodedMessage<MessageName::WebIDBConnectionToServer_DidGetAllRecords>(globalObject, decoder);
    case MessageName::WebIDBConnectionToServer_DidGetCount:
        return jsValueForDecodedMessage<MessageName::WebIDBConnectionToServer_DidGetCount>(globalObject, decoder);
    case MessageName::WebIDBConnectionToServer_DidDeleteRecord:
        return jsValueForDecodedMessage<MessageName::WebIDBConnectionToServer_DidDeleteRecord>(globalObject, decoder);
    case MessageName::WebIDBConnectionToServer_DidOpenCursor:
        return jsValueForDecodedMessage<MessageName::WebIDBConnectionToServer_DidOpenCursor>(globalObject, decoder);
    case MessageName::WebIDBConnectionToServer_DidIterateCursor:
        return jsValueForDecodedMessage<MessageName::WebIDBConnectionToServer_DidIterateCursor>(globalObject, decoder);
    case MessageName::WebIDBConnectionToServer_FireVersionChangeEvent:
        return jsValueForDecodedMessage<MessageName::WebIDBConnectionToServer_FireVersionChangeEvent>(globalObject, decoder);
    case MessageName::WebIDBConnectionToServer_GenerateIndexKeyForRecord:
        return jsValueForDecodedMessage<MessageName::WebIDBConnectionToServer_GenerateIndexKeyForRecord>(globalObject, decoder);
    case MessageName::WebIDBConnectionToServer_DidStartTransaction:
        return jsValueForDecodedMessage<MessageName::WebIDBConnectionToServer_DidStartTransaction>(globalObject, decoder);
    case MessageName::WebIDBConnectionToServer_DidCloseFromServer:
        return jsValueForDecodedMessage<MessageName::WebIDBConnectionToServer_DidCloseFromServer>(globalObject, decoder);
    case MessageName::WebIDBConnectionToServer_NotifyOpenDBRequestBlocked:
        return jsValueForDecodedMessage<MessageName::WebIDBConnectionToServer_NotifyOpenDBRequestBlocked>(globalObject, decoder);
    case MessageName::WebIDBConnectionToServer_DidGetAllDatabaseNamesAndVersions:
        return jsValueForDecodedMessage<MessageName::WebIDBConnectionToServer_DidGetAllDatabaseNamesAndVersions>(globalObject, decoder);
#if HAVE(DIGITAL_CREDENTIALS_UI)
    case MessageName::DigitalCredentialsCoordinator_ProvideRawDigitalCredentialRequests:
        return jsValueForDecodedMessage<MessageName::DigitalCredentialsCoordinator_ProvideRawDigitalCredentialRequests>(globalObject, decoder);
#endif
#if ENABLE(WK_WEB_EXTENSIONS)
    case MessageName::WebExtensionContextProxy_DispatchActionClickedEvent:
        return jsValueForDecodedMessage<MessageName::WebExtensionContextProxy_DispatchActionClickedEvent>(globalObject, decoder);
    case MessageName::WebExtensionContextProxy_DispatchAlarmsEvent:
        return jsValueForDecodedMessage<MessageName::WebExtensionContextProxy_DispatchAlarmsEvent>(globalObject, decoder);
    case MessageName::WebExtensionContextProxy_DispatchCommandsCommandEvent:
        return jsValueForDecodedMessage<MessageName::WebExtensionContextProxy_DispatchCommandsCommandEvent>(globalObject, decoder);
    case MessageName::WebExtensionContextProxy_DispatchCommandsChangedEvent:
        return jsValueForDecodedMessage<MessageName::WebExtensionContextProxy_DispatchCommandsChangedEvent>(globalObject, decoder);
    case MessageName::WebExtensionContextProxy_DispatchCookiesChangedEvent:
        return jsValueForDecodedMessage<MessageName::WebExtensionContextProxy_DispatchCookiesChangedEvent>(globalObject, decoder);
#if ENABLE(INSPECTOR_EXTENSIONS)
    case MessageName::WebExtensionContextProxy_AddInspectorPageIdentifier:
        return jsValueForDecodedMessage<MessageName::WebExtensionContextProxy_AddInspectorPageIdentifier>(globalObject, decoder);
    case MessageName::WebExtensionContextProxy_AddInspectorBackgroundPageIdentifier:
        return jsValueForDecodedMessage<MessageName::WebExtensionContextProxy_AddInspectorBackgroundPageIdentifier>(globalObject, decoder);
    case MessageName::WebExtensionContextProxy_DispatchDevToolsExtensionPanelShownEvent:
        return jsValueForDecodedMessage<MessageName::WebExtensionContextProxy_DispatchDevToolsExtensionPanelShownEvent>(globalObject, decoder);
    case MessageName::WebExtensionContextProxy_DispatchDevToolsExtensionPanelHiddenEvent:
        return jsValueForDecodedMessage<MessageName::WebExtensionContextProxy_DispatchDevToolsExtensionPanelHiddenEvent>(globalObject, decoder);
    case MessageName::WebExtensionContextProxy_DispatchDevToolsNetworkNavigatedEvent:
        return jsValueForDecodedMessage<MessageName::WebExtensionContextProxy_DispatchDevToolsNetworkNavigatedEvent>(globalObject, decoder);
    case MessageName::WebExtensionContextProxy_DispatchDevToolsPanelsThemeChangedEvent:
        return jsValueForDecodedMessage<MessageName::WebExtensionContextProxy_DispatchDevToolsPanelsThemeChangedEvent>(globalObject, decoder);
#endif
    case MessageName::WebExtensionContextProxy_SetBackgroundPageIdentifier:
        return jsValueForDecodedMessage<MessageName::WebExtensionContextProxy_SetBackgroundPageIdentifier>(globalObject, decoder);
    case MessageName::WebExtensionContextProxy_AddPopupPageIdentifier:
        return jsValueForDecodedMessage<MessageName::WebExtensionContextProxy_AddPopupPageIdentifier>(globalObject, decoder);
    case MessageName::WebExtensionContextProxy_AddTabPageIdentifier:
        return jsValueForDecodedMessage<MessageName::WebExtensionContextProxy_AddTabPageIdentifier>(globalObject, decoder);
    case MessageName::WebExtensionContextProxy_DispatchMenusClickedEvent:
        return jsValueForDecodedMessage<MessageName::WebExtensionContextProxy_DispatchMenusClickedEvent>(globalObject, decoder);
    case MessageName::WebExtensionContextProxy_UpdateGrantedPermissions:
        return jsValueForDecodedMessage<MessageName::WebExtensionContextProxy_UpdateGrantedPermissions>(globalObject, decoder);
    case MessageName::WebExtensionContextProxy_DispatchPermissionsEvent:
        return jsValueForDecodedMessage<MessageName::WebExtensionContextProxy_DispatchPermissionsEvent>(globalObject, decoder);
    case MessageName::WebExtensionContextProxy_DispatchPortMessageEvent:
        return jsValueForDecodedMessage<MessageName::WebExtensionContextProxy_DispatchPortMessageEvent>(globalObject, decoder);
    case MessageName::WebExtensionContextProxy_DispatchPortDisconnectEvent:
        return jsValueForDecodedMessage<MessageName::WebExtensionContextProxy_DispatchPortDisconnectEvent>(globalObject, decoder);
    case MessageName::WebExtensionContextProxy_DispatchRuntimeMessageEvent:
        return jsValueForDecodedMessage<MessageName::WebExtensionContextProxy_DispatchRuntimeMessageEvent>(globalObject, decoder);
    case MessageName::WebExtensionContextProxy_DispatchRuntimeConnectEvent:
        return jsValueForDecodedMessage<MessageName::WebExtensionContextProxy_DispatchRuntimeConnectEvent>(globalObject, decoder);
    case MessageName::WebExtensionContextProxy_DispatchRuntimeInstalledEvent:
        return jsValueForDecodedMessage<MessageName::WebExtensionContextProxy_DispatchRuntimeInstalledEvent>(globalObject, decoder);
    case MessageName::WebExtensionContextProxy_DispatchRuntimeStartupEvent:
        return jsValueForDecodedMessage<MessageName::WebExtensionContextProxy_DispatchRuntimeStartupEvent>(globalObject, decoder);
    case MessageName::WebExtensionContextProxy_SetStorageAccessLevel:
        return jsValueForDecodedMessage<MessageName::WebExtensionContextProxy_SetStorageAccessLevel>(globalObject, decoder);
    case MessageName::WebExtensionContextProxy_DispatchStorageChangedEvent:
        return jsValueForDecodedMessage<MessageName::WebExtensionContextProxy_DispatchStorageChangedEvent>(globalObject, decoder);
    case MessageName::WebExtensionContextProxy_DispatchTabsCreatedEvent:
        return jsValueForDecodedMessage<MessageName::WebExtensionContextProxy_DispatchTabsCreatedEvent>(globalObject, decoder);
    case MessageName::WebExtensionContextProxy_DispatchTabsUpdatedEvent:
        return jsValueForDecodedMessage<MessageName::WebExtensionContextProxy_DispatchTabsUpdatedEvent>(globalObject, decoder);
    case MessageName::WebExtensionContextProxy_DispatchTabsReplacedEvent:
        return jsValueForDecodedMessage<MessageName::WebExtensionContextProxy_DispatchTabsReplacedEvent>(globalObject, decoder);
    case MessageName::WebExtensionContextProxy_DispatchTabsDetachedEvent:
        return jsValueForDecodedMessage<MessageName::WebExtensionContextProxy_DispatchTabsDetachedEvent>(globalObject, decoder);
    case MessageName::WebExtensionContextProxy_DispatchTabsMovedEvent:
        return jsValueForDecodedMessage<MessageName::WebExtensionContextProxy_DispatchTabsMovedEvent>(globalObject, decoder);
    case MessageName::WebExtensionContextProxy_DispatchTabsAttachedEvent:
        return jsValueForDecodedMessage<MessageName::WebExtensionContextProxy_DispatchTabsAttachedEvent>(globalObject, decoder);
    case MessageName::WebExtensionContextProxy_DispatchTabsActivatedEvent:
        return jsValueForDecodedMessage<MessageName::WebExtensionContextProxy_DispatchTabsActivatedEvent>(globalObject, decoder);
    case MessageName::WebExtensionContextProxy_DispatchTabsHighlightedEvent:
        return jsValueForDecodedMessage<MessageName::WebExtensionContextProxy_DispatchTabsHighlightedEvent>(globalObject, decoder);
    case MessageName::WebExtensionContextProxy_DispatchTabsRemovedEvent:
        return jsValueForDecodedMessage<MessageName::WebExtensionContextProxy_DispatchTabsRemovedEvent>(globalObject, decoder);
    case MessageName::WebExtensionContextProxy_DispatchTestMessageEvent:
        return jsValueForDecodedMessage<MessageName::WebExtensionContextProxy_DispatchTestMessageEvent>(globalObject, decoder);
    case MessageName::WebExtensionContextProxy_DispatchTestStartedEvent:
        return jsValueForDecodedMessage<MessageName::WebExtensionContextProxy_DispatchTestStartedEvent>(globalObject, decoder);
    case MessageName::WebExtensionContextProxy_DispatchTestFinishedEvent:
        return jsValueForDecodedMessage<MessageName::WebExtensionContextProxy_DispatchTestFinishedEvent>(globalObject, decoder);
    case MessageName::WebExtensionContextProxy_DispatchWebNavigationEvent:
        return jsValueForDecodedMessage<MessageName::WebExtensionContextProxy_DispatchWebNavigationEvent>(globalObject, decoder);
    case MessageName::WebExtensionContextProxy_ResourceLoadDidSendRequest:
        return jsValueForDecodedMessage<MessageName::WebExtensionContextProxy_ResourceLoadDidSendRequest>(globalObject, decoder);
    case MessageName::WebExtensionContextProxy_ResourceLoadDidPerformHTTPRedirection:
        return jsValueForDecodedMessage<MessageName::WebExtensionContextProxy_ResourceLoadDidPerformHTTPRedirection>(globalObject, decoder);
    case MessageName::WebExtensionContextProxy_ResourceLoadDidReceiveChallenge:
        return jsValueForDecodedMessage<MessageName::WebExtensionContextProxy_ResourceLoadDidReceiveChallenge>(globalObject, decoder);
    case MessageName::WebExtensionContextProxy_ResourceLoadDidReceiveResponse:
        return jsValueForDecodedMessage<MessageName::WebExtensionContextProxy_ResourceLoadDidReceiveResponse>(globalObject, decoder);
    case MessageName::WebExtensionContextProxy_ResourceLoadDidCompleteWithError:
        return jsValueForDecodedMessage<MessageName::WebExtensionContextProxy_ResourceLoadDidCompleteWithError>(globalObject, decoder);
    case MessageName::WebExtensionContextProxy_DispatchWindowsEvent:
        return jsValueForDecodedMessage<MessageName::WebExtensionContextProxy_DispatchWindowsEvent>(globalObject, decoder);
#endif
#if ENABLE(WK_WEB_EXTENSIONS)
    case MessageName::WebExtensionControllerProxy_Load:
        return jsValueForDecodedMessage<MessageName::WebExtensionControllerProxy_Load>(globalObject, decoder);
    case MessageName::WebExtensionControllerProxy_Unload:
        return jsValueForDecodedMessage<MessageName::WebExtensionControllerProxy_Unload>(globalObject, decoder);
#endif
#if ENABLE(FULLSCREEN_API)
    case MessageName::WebFullScreenManager_RequestRestoreFullScreen:
        return jsValueForDecodedMessage<MessageName::WebFullScreenManager_RequestRestoreFullScreen>(globalObject, decoder);
    case MessageName::WebFullScreenManager_RequestExitFullScreen:
        return jsValueForDecodedMessage<MessageName::WebFullScreenManager_RequestExitFullScreen>(globalObject, decoder);
    case MessageName::WebFullScreenManager_SetAnimatingFullScreen:
        return jsValueForDecodedMessage<MessageName::WebFullScreenManager_SetAnimatingFullScreen>(globalObject, decoder);
    case MessageName::WebFullScreenManager_SetFullscreenInsets:
        return jsValueForDecodedMessage<MessageName::WebFullScreenManager_SetFullscreenInsets>(globalObject, decoder);
    case MessageName::WebFullScreenManager_SetFullscreenAutoHideDuration:
        return jsValueForDecodedMessage<MessageName::WebFullScreenManager_SetFullscreenAutoHideDuration>(globalObject, decoder);
    case MessageName::WebFullScreenManager_EnterFullScreenForOwnerElements:
        return jsValueForDecodedMessage<MessageName::WebFullScreenManager_EnterFullScreenForOwnerElements>(globalObject, decoder);
    case MessageName::WebFullScreenManager_ExitFullScreenInMainFrame:
        return jsValueForDecodedMessage<MessageName::WebFullScreenManager_ExitFullScreenInMainFrame>(globalObject, decoder);
#endif
#if ENABLE(GPU_PROCESS)
    case MessageName::GPUProcessConnection_DidInitialize:
        return jsValueForDecodedMessage<MessageName::GPUProcessConnection_DidInitialize>(globalObject, decoder);
    case MessageName::GPUProcessConnection_DidReceiveRemoteCommand:
        return jsValueForDecodedMessage<MessageName::GPUProcessConnection_DidReceiveRemoteCommand>(globalObject, decoder);
#if ENABLE(ROUTING_ARBITRATION)
    case MessageName::GPUProcessConnection_BeginRoutingArbitrationWithCategory:
        return jsValueForDecodedMessage<MessageName::GPUProcessConnection_BeginRoutingArbitrationWithCategory>(globalObject, decoder);
    case MessageName::GPUProcessConnection_EndRoutingArbitration:
        return jsValueForDecodedMessage<MessageName::GPUProcessConnection_EndRoutingArbitration>(globalObject, decoder);
#endif
#if ENABLE(MEDIA_STREAM) && PLATFORM(COCOA)
    case MessageName::GPUProcessConnection_ResetAudioMediaStreamTrackRendererInternalUnit:
        return jsValueForDecodedMessage<MessageName::GPUProcessConnection_ResetAudioMediaStreamTrackRendererInternalUnit>(globalObject, decoder);
#endif
#endif
#if ENABLE(GPU_PROCESS) && ENABLE(WEBGL)
    case MessageName::RemoteGraphicsContextGLProxy_WasCreated:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGLProxy_WasCreated>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGLProxy_WasLost:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGLProxy_WasLost>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGLProxy_addDebugMessage:
        return jsValueForDecodedMessage<MessageName::RemoteGraphicsContextGLProxy_addDebugMessage>(globalObject, decoder);
#endif
#if ENABLE(GPU_PROCESS)
    case MessageName::RemoteImageBufferProxy_DidCreateBackend:
        return jsValueForDecodedMessage<MessageName::RemoteImageBufferProxy_DidCreateBackend>(globalObject, decoder);
#endif
#if ENABLE(GPU_PROCESS)
#if PLATFORM(COCOA)
    case MessageName::RemoteImageBufferSetProxy_DidPrepareForDisplay:
        return jsValueForDecodedMessage<MessageName::RemoteImageBufferSetProxy_DidPrepareForDisplay>(globalObject, decoder);
#endif
#endif
#if ENABLE(GPU_PROCESS)
    case MessageName::RemoteRenderingBackendProxy_DidFinalizeRenderingUpdate:
        return jsValueForDecodedMessage<MessageName::RemoteRenderingBackendProxy_DidFinalizeRenderingUpdate>(globalObject, decoder);
    case MessageName::RemoteRenderingBackendProxy_DidInitialize:
        return jsValueForDecodedMessage<MessageName::RemoteRenderingBackendProxy_DidInitialize>(globalObject, decoder);
    case MessageName::RemoteRenderingBackendProxy_DidMarkLayersAsVolatile:
        return jsValueForDecodedMessage<MessageName::RemoteRenderingBackendProxy_DidMarkLayersAsVolatile>(globalObject, decoder);
#endif
#if ENABLE(GPU_PROCESS)
    case MessageName::RemoteGPUProxy_WasCreated:
        return jsValueForDecodedMessage<MessageName::RemoteGPUProxy_WasCreated>(globalObject, decoder);
#endif
#if ENABLE(GPU_PROCESS)
    case MessageName::RemoteAudioHardwareListener_AudioHardwareDidBecomeActive:
        return jsValueForDecodedMessage<MessageName::RemoteAudioHardwareListener_AudioHardwareDidBecomeActive>(globalObject, decoder);
    case MessageName::RemoteAudioHardwareListener_AudioHardwareDidBecomeInactive:
        return jsValueForDecodedMessage<MessageName::RemoteAudioHardwareListener_AudioHardwareDidBecomeInactive>(globalObject, decoder);
    case MessageName::RemoteAudioHardwareListener_AudioOutputDeviceChanged:
        return jsValueForDecodedMessage<MessageName::RemoteAudioHardwareListener_AudioOutputDeviceChanged>(globalObject, decoder);
#endif
#if ENABLE(GPU_PROCESS) && ENABLE(VIDEO)
    case MessageName::MediaPlayerPrivateRemote_NetworkStateChanged:
        return jsValueForDecodedMessage<MessageName::MediaPlayerPrivateRemote_NetworkStateChanged>(globalObject, decoder);
    case MessageName::MediaPlayerPrivateRemote_ReadyStateChanged:
        return jsValueForDecodedMessage<MessageName::MediaPlayerPrivateRemote_ReadyStateChanged>(globalObject, decoder);
    case MessageName::MediaPlayerPrivateRemote_FirstVideoFrameAvailable:
        return jsValueForDecodedMessage<MessageName::MediaPlayerPrivateRemote_FirstVideoFrameAvailable>(globalObject, decoder);
    case MessageName::MediaPlayerPrivateRemote_VolumeChanged:
        return jsValueForDecodedMessage<MessageName::MediaPlayerPrivateRemote_VolumeChanged>(globalObject, decoder);
    case MessageName::MediaPlayerPrivateRemote_MuteChanged:
        return jsValueForDecodedMessage<MessageName::MediaPlayerPrivateRemote_MuteChanged>(globalObject, decoder);
    case MessageName::MediaPlayerPrivateRemote_Seeked:
        return jsValueForDecodedMessage<MessageName::MediaPlayerPrivateRemote_Seeked>(globalObject, decoder);
    case MessageName::MediaPlayerPrivateRemote_TimeChanged:
        return jsValueForDecodedMessage<MessageName::MediaPlayerPrivateRemote_TimeChanged>(globalObject, decoder);
    case MessageName::MediaPlayerPrivateRemote_DurationChanged:
        return jsValueForDecodedMessage<MessageName::MediaPlayerPrivateRemote_DurationChanged>(globalObject, decoder);
    case MessageName::MediaPlayerPrivateRemote_RateChanged:
        return jsValueForDecodedMessage<MessageName::MediaPlayerPrivateRemote_RateChanged>(globalObject, decoder);
    case MessageName::MediaPlayerPrivateRemote_PlaybackStateChanged:
        return jsValueForDecodedMessage<MessageName::MediaPlayerPrivateRemote_PlaybackStateChanged>(globalObject, decoder);
    case MessageName::MediaPlayerPrivateRemote_EngineFailedToLoad:
        return jsValueForDecodedMessage<MessageName::MediaPlayerPrivateRemote_EngineFailedToLoad>(globalObject, decoder);
    case MessageName::MediaPlayerPrivateRemote_UpdateCachedState:
        return jsValueForDecodedMessage<MessageName::MediaPlayerPrivateRemote_UpdateCachedState>(globalObject, decoder);
    case MessageName::MediaPlayerPrivateRemote_UpdatePlaybackQualityMetrics:
        return jsValueForDecodedMessage<MessageName::MediaPlayerPrivateRemote_UpdatePlaybackQualityMetrics>(globalObject, decoder);
    case MessageName::MediaPlayerPrivateRemote_CharacteristicChanged:
        return jsValueForDecodedMessage<MessageName::MediaPlayerPrivateRemote_CharacteristicChanged>(globalObject, decoder);
    case MessageName::MediaPlayerPrivateRemote_SizeChanged:
        return jsValueForDecodedMessage<MessageName::MediaPlayerPrivateRemote_SizeChanged>(globalObject, decoder);
    case MessageName::MediaPlayerPrivateRemote_RenderingModeChanged:
        return jsValueForDecodedMessage<MessageName::MediaPlayerPrivateRemote_RenderingModeChanged>(globalObject, decoder);
    case MessageName::MediaPlayerPrivateRemote_CurrentTimeChanged:
        return jsValueForDecodedMessage<MessageName::MediaPlayerPrivateRemote_CurrentTimeChanged>(globalObject, decoder);
    case MessageName::MediaPlayerPrivateRemote_AddRemoteAudioTrack:
        return jsValueForDecodedMessage<MessageName::MediaPlayerPrivateRemote_AddRemoteAudioTrack>(globalObject, decoder);
    case MessageName::MediaPlayerPrivateRemote_RemoveRemoteAudioTrack:
        return jsValueForDecodedMessage<MessageName::MediaPlayerPrivateRemote_RemoveRemoteAudioTrack>(globalObject, decoder);
    case MessageName::MediaPlayerPrivateRemote_RemoteAudioTrackConfigurationChanged:
        return jsValueForDecodedMessage<MessageName::MediaPlayerPrivateRemote_RemoteAudioTrackConfigurationChanged>(globalObject, decoder);
    case MessageName::MediaPlayerPrivateRemote_AddRemoteVideoTrack:
        return jsValueForDecodedMessage<MessageName::MediaPlayerPrivateRemote_AddRemoteVideoTrack>(globalObject, decoder);
    case MessageName::MediaPlayerPrivateRemote_RemoveRemoteVideoTrack:
        return jsValueForDecodedMessage<MessageName::MediaPlayerPrivateRemote_RemoveRemoteVideoTrack>(globalObject, decoder);
    case MessageName::MediaPlayerPrivateRemote_RemoteVideoTrackConfigurationChanged:
        return jsValueForDecodedMessage<MessageName::MediaPlayerPrivateRemote_RemoteVideoTrackConfigurationChanged>(globalObject, decoder);
    case MessageName::MediaPlayerPrivateRemote_AddRemoteTextTrack:
        return jsValueForDecodedMessage<MessageName::MediaPlayerPrivateRemote_AddRemoteTextTrack>(globalObject, decoder);
    case MessageName::MediaPlayerPrivateRemote_RemoveRemoteTextTrack:
        return jsValueForDecodedMessage<MessageName::MediaPlayerPrivateRemote_RemoveRemoteTextTrack>(globalObject, decoder);
    case MessageName::MediaPlayerPrivateRemote_RemoteTextTrackConfigurationChanged:
        return jsValueForDecodedMessage<MessageName::MediaPlayerPrivateRemote_RemoteTextTrackConfigurationChanged>(globalObject, decoder);
    case MessageName::MediaPlayerPrivateRemote_ParseWebVTTFileHeader:
        return jsValueForDecodedMessage<MessageName::MediaPlayerPrivateRemote_ParseWebVTTFileHeader>(globalObject, decoder);
    case MessageName::MediaPlayerPrivateRemote_ParseWebVTTCueData:
        return jsValueForDecodedMessage<MessageName::MediaPlayerPrivateRemote_ParseWebVTTCueData>(globalObject, decoder);
    case MessageName::MediaPlayerPrivateRemote_ParseWebVTTCueDataStruct:
        return jsValueForDecodedMessage<MessageName::MediaPlayerPrivateRemote_ParseWebVTTCueDataStruct>(globalObject, decoder);
    case MessageName::MediaPlayerPrivateRemote_AddDataCue:
        return jsValueForDecodedMessage<MessageName::MediaPlayerPrivateRemote_AddDataCue>(globalObject, decoder);
#if ENABLE(DATACUE_VALUE)
    case MessageName::MediaPlayerPrivateRemote_AddDataCueWithType:
        return jsValueForDecodedMessage<MessageName::MediaPlayerPrivateRemote_AddDataCueWithType>(globalObject, decoder);
    case MessageName::MediaPlayerPrivateRemote_UpdateDataCue:
        return jsValueForDecodedMessage<MessageName::MediaPlayerPrivateRemote_UpdateDataCue>(globalObject, decoder);
    case MessageName::MediaPlayerPrivateRemote_RemoveDataCue:
        return jsValueForDecodedMessage<MessageName::MediaPlayerPrivateRemote_RemoveDataCue>(globalObject, decoder);
#endif
    case MessageName::MediaPlayerPrivateRemote_AddGenericCue:
        return jsValueForDecodedMessage<MessageName::MediaPlayerPrivateRemote_AddGenericCue>(globalObject, decoder);
    case MessageName::MediaPlayerPrivateRemote_UpdateGenericCue:
        return jsValueForDecodedMessage<MessageName::MediaPlayerPrivateRemote_UpdateGenericCue>(globalObject, decoder);
    case MessageName::MediaPlayerPrivateRemote_RemoveGenericCue:
        return jsValueForDecodedMessage<MessageName::MediaPlayerPrivateRemote_RemoveGenericCue>(globalObject, decoder);
    case MessageName::MediaPlayerPrivateRemote_RequestResource:
        return jsValueForDecodedMessage<MessageName::MediaPlayerPrivateRemote_RequestResource>(globalObject, decoder);
    case MessageName::MediaPlayerPrivateRemote_RemoveResource:
        return jsValueForDecodedMessage<MessageName::MediaPlayerPrivateRemote_RemoveResource>(globalObject, decoder);
    case MessageName::MediaPlayerPrivateRemote_SendH2Ping:
        return jsValueForDecodedMessage<MessageName::MediaPlayerPrivateRemote_SendH2Ping>(globalObject, decoder);
    case MessageName::MediaPlayerPrivateRemote_ResourceNotSupported:
        return jsValueForDecodedMessage<MessageName::MediaPlayerPrivateRemote_ResourceNotSupported>(globalObject, decoder);
    case MessageName::MediaPlayerPrivateRemote_ActiveSourceBuffersChanged:
        return jsValueForDecodedMessage<MessageName::MediaPlayerPrivateRemote_ActiveSourceBuffersChanged>(globalObject, decoder);
#if ENABLE(ENCRYPTED_MEDIA)
    case MessageName::MediaPlayerPrivateRemote_WaitingForKeyChanged:
        return jsValueForDecodedMessage<MessageName::MediaPlayerPrivateRemote_WaitingForKeyChanged>(globalObject, decoder);
    case MessageName::MediaPlayerPrivateRemote_InitializationDataEncountered:
        return jsValueForDecodedMessage<MessageName::MediaPlayerPrivateRemote_InitializationDataEncountered>(globalObject, decoder);
#endif
#if ENABLE(LEGACY_ENCRYPTED_MEDIA)
    case MessageName::MediaPlayerPrivateRemote_MediaPlayerKeyNeeded:
        return jsValueForDecodedMessage<MessageName::MediaPlayerPrivateRemote_MediaPlayerKeyNeeded>(globalObject, decoder);
#endif
#if ENABLE(WIRELESS_PLAYBACK_TARGET)
    case MessageName::MediaPlayerPrivateRemote_CurrentPlaybackTargetIsWirelessChanged:
        return jsValueForDecodedMessage<MessageName::MediaPlayerPrivateRemote_CurrentPlaybackTargetIsWirelessChanged>(globalObject, decoder);
#endif
#if PLATFORM(IOS_FAMILY)
    case MessageName::MediaPlayerPrivateRemote_GetRawCookies:
        return jsValueForDecodedMessage<MessageName::MediaPlayerPrivateRemote_GetRawCookies>(globalObject, decoder);
#endif
#if PLATFORM(COCOA)
    case MessageName::MediaPlayerPrivateRemote_PushVideoFrameMetadata:
        return jsValueForDecodedMessage<MessageName::MediaPlayerPrivateRemote_PushVideoFrameMetadata>(globalObject, decoder);
    case MessageName::MediaPlayerPrivateRemote_LayerHostingContextChanged:
        return jsValueForDecodedMessage<MessageName::MediaPlayerPrivateRemote_LayerHostingContextChanged>(globalObject, decoder);
#endif
    case MessageName::MediaPlayerPrivateRemote_CommitAllTransactions:
        return jsValueForDecodedMessage<MessageName::MediaPlayerPrivateRemote_CommitAllTransactions>(globalObject, decoder);
    case MessageName::MediaPlayerPrivateRemote_ReportGPUMemoryFootprint:
        return jsValueForDecodedMessage<MessageName::MediaPlayerPrivateRemote_ReportGPUMemoryFootprint>(globalObject, decoder);
    case MessageName::MediaPlayerPrivateRemote_SendInternalMessage:
        return jsValueForDecodedMessage<MessageName::MediaPlayerPrivateRemote_SendInternalMessage>(globalObject, decoder);
#endif
#if ENABLE(GPU_PROCESS) && ENABLE(MEDIA_SOURCE)
    case MessageName::MediaSourcePrivateRemoteMessageReceiver_ProxyWaitForTarget:
        return jsValueForDecodedMessage<MessageName::MediaSourcePrivateRemoteMessageReceiver_ProxyWaitForTarget>(globalObject, decoder);
    case MessageName::MediaSourcePrivateRemoteMessageReceiver_ProxySeekToTime:
        return jsValueForDecodedMessage<MessageName::MediaSourcePrivateRemoteMessageReceiver_ProxySeekToTime>(globalObject, decoder);
#endif
#if ENABLE(GPU_PROCESS) && USE(AUDIO_SESSION)
    case MessageName::RemoteAudioSession_ConfigurationChanged:
        return jsValueForDecodedMessage<MessageName::RemoteAudioSession_ConfigurationChanged>(globalObject, decoder);
    case MessageName::RemoteAudioSession_BeginInterruptionRemote:
        return jsValueForDecodedMessage<MessageName::RemoteAudioSession_BeginInterruptionRemote>(globalObject, decoder);
    case MessageName::RemoteAudioSession_EndInterruptionRemote:
        return jsValueForDecodedMessage<MessageName::RemoteAudioSession_EndInterruptionRemote>(globalObject, decoder);
#endif
#if PLATFORM(COCOA) && ENABLE(GPU_PROCESS)
    case MessageName::RemoteAudioSourceProviderManager_AudioStorageChanged:
        return jsValueForDecodedMessage<MessageName::RemoteAudioSourceProviderManager_AudioStorageChanged>(globalObject, decoder);
    case MessageName::RemoteAudioSourceProviderManager_AudioSamplesAvailable:
        return jsValueForDecodedMessage<MessageName::RemoteAudioSourceProviderManager_AudioSamplesAvailable>(globalObject, decoder);
#endif
#if ENABLE(GPU_PROCESS) && ENABLE(ENCRYPTED_MEDIA)
    case MessageName::RemoteCDMInstance_UnrequestedInitializationDataReceived:
        return jsValueForDecodedMessage<MessageName::RemoteCDMInstance_UnrequestedInitializationDataReceived>(globalObject, decoder);
#endif
#if ENABLE(GPU_PROCESS) && ENABLE(ENCRYPTED_MEDIA)
    case MessageName::RemoteCDMInstanceSession_UpdateKeyStatuses:
        return jsValueForDecodedMessage<MessageName::RemoteCDMInstanceSession_UpdateKeyStatuses>(globalObject, decoder);
    case MessageName::RemoteCDMInstanceSession_SendMessage:
        return jsValueForDecodedMessage<MessageName::RemoteCDMInstanceSession_SendMessage>(globalObject, decoder);
    case MessageName::RemoteCDMInstanceSession_SessionIdChanged:
        return jsValueForDecodedMessage<MessageName::RemoteCDMInstanceSession_SessionIdChanged>(globalObject, decoder);
#endif
#if ENABLE(GPU_PROCESS) && ENABLE(LEGACY_ENCRYPTED_MEDIA)
    case MessageName::RemoteLegacyCDMSession_SendMessage:
        return jsValueForDecodedMessage<MessageName::RemoteLegacyCDMSession_SendMessage>(globalObject, decoder);
    case MessageName::RemoteLegacyCDMSession_SendError:
        return jsValueForDecodedMessage<MessageName::RemoteLegacyCDMSession_SendError>(globalObject, decoder);
#endif
#if ENABLE(GPU_PROCESS)
    case MessageName::RemoteRemoteCommandListener_DidReceiveRemoteControlCommand:
        return jsValueForDecodedMessage<MessageName::RemoteRemoteCommandListener_DidReceiveRemoteControlCommand>(globalObject, decoder);
#endif
#if ENABLE(GPU_PROCESS) && ENABLE(MEDIA_SOURCE)
    case MessageName::SourceBufferPrivateRemoteMessageReceiver_SourceBufferPrivateDidReceiveInitializationSegment:
        return jsValueForDecodedMessage<MessageName::SourceBufferPrivateRemoteMessageReceiver_SourceBufferPrivateDidReceiveInitializationSegment>(globalObject, decoder);
    case MessageName::SourceBufferPrivateRemoteMessageReceiver_TakeOwnershipOfMemory:
        return jsValueForDecodedMessage<MessageName::SourceBufferPrivateRemoteMessageReceiver_TakeOwnershipOfMemory>(globalObject, decoder);
    case MessageName::SourceBufferPrivateRemoteMessageReceiver_SourceBufferPrivateHighestPresentationTimestampChanged:
        return jsValueForDecodedMessage<MessageName::SourceBufferPrivateRemoteMessageReceiver_SourceBufferPrivateHighestPresentationTimestampChanged>(globalObject, decoder);
    case MessageName::SourceBufferPrivateRemoteMessageReceiver_SourceBufferPrivateBufferedChanged:
        return jsValueForDecodedMessage<MessageName::SourceBufferPrivateRemoteMessageReceiver_SourceBufferPrivateBufferedChanged>(globalObject, decoder);
    case MessageName::SourceBufferPrivateRemoteMessageReceiver_SourceBufferPrivateDurationChanged:
        return jsValueForDecodedMessage<MessageName::SourceBufferPrivateRemoteMessageReceiver_SourceBufferPrivateDurationChanged>(globalObject, decoder);
    case MessageName::SourceBufferPrivateRemoteMessageReceiver_SourceBufferPrivateDidDropSample:
        return jsValueForDecodedMessage<MessageName::SourceBufferPrivateRemoteMessageReceiver_SourceBufferPrivateDidDropSample>(globalObject, decoder);
    case MessageName::SourceBufferPrivateRemoteMessageReceiver_SourceBufferPrivateDidReceiveRenderingError:
        return jsValueForDecodedMessage<MessageName::SourceBufferPrivateRemoteMessageReceiver_SourceBufferPrivateDidReceiveRenderingError>(globalObject, decoder);
    case MessageName::SourceBufferPrivateRemoteMessageReceiver_SourceBufferPrivateEvictionDataChanged:
        return jsValueForDecodedMessage<MessageName::SourceBufferPrivateRemoteMessageReceiver_SourceBufferPrivateEvictionDataChanged>(globalObject, decoder);
    case MessageName::SourceBufferPrivateRemoteMessageReceiver_SourceBufferPrivateDidAttach:
        return jsValueForDecodedMessage<MessageName::SourceBufferPrivateRemoteMessageReceiver_SourceBufferPrivateDidAttach>(globalObject, decoder);
#endif
#if USE(LIBWEBRTC) && PLATFORM(COCOA) && ENABLE(GPU_PROCESS)
    case MessageName::LibWebRTCCodecs_FailedDecoding:
        return jsValueForDecodedMessage<MessageName::LibWebRTCCodecs_FailedDecoding>(globalObject, decoder);
    case MessageName::LibWebRTCCodecs_CompletedDecoding:
        return jsValueForDecodedMessage<MessageName::LibWebRTCCodecs_CompletedDecoding>(globalObject, decoder);
    case MessageName::LibWebRTCCodecs_CompletedDecodingCV:
        return jsValueForDecodedMessage<MessageName::LibWebRTCCodecs_CompletedDecodingCV>(globalObject, decoder);
    case MessageName::LibWebRTCCodecs_CompletedEncoding:
        return jsValueForDecodedMessage<MessageName::LibWebRTCCodecs_CompletedEncoding>(globalObject, decoder);
    case MessageName::LibWebRTCCodecs_SetEncodingConfiguration:
        return jsValueForDecodedMessage<MessageName::LibWebRTCCodecs_SetEncodingConfiguration>(globalObject, decoder);
#endif
#if PLATFORM(COCOA) && ENABLE(GPU_PROCESS) && ENABLE(VIDEO)
    case MessageName::RemoteVideoFrameObjectHeapProxyProcessor_SetSharedVideoFrameSemaphore:
        return jsValueForDecodedMessage<MessageName::RemoteVideoFrameObjectHeapProxyProcessor_SetSharedVideoFrameSemaphore>(globalObject, decoder);
    case MessageName::RemoteVideoFrameObjectHeapProxyProcessor_SetSharedVideoFrameMemory:
        return jsValueForDecodedMessage<MessageName::RemoteVideoFrameObjectHeapProxyProcessor_SetSharedVideoFrameMemory>(globalObject, decoder);
    case MessageName::RemoteVideoFrameObjectHeapProxyProcessor_NewVideoFrameBuffer:
        return jsValueForDecodedMessage<MessageName::RemoteVideoFrameObjectHeapProxyProcessor_NewVideoFrameBuffer>(globalObject, decoder);
    case MessageName::RemoteVideoFrameObjectHeapProxyProcessor_NewConvertedVideoFrameBuffer:
        return jsValueForDecodedMessage<MessageName::RemoteVideoFrameObjectHeapProxyProcessor_NewConvertedVideoFrameBuffer>(globalObject, decoder);
#endif
#if PLATFORM(COCOA) && ENABLE(GPU_PROCESS) && ENABLE(MEDIA_STREAM)
    case MessageName::SampleBufferDisplayLayer_SetDidFail:
        return jsValueForDecodedMessage<MessageName::SampleBufferDisplayLayer_SetDidFail>(globalObject, decoder);
#endif
    case MessageName::WebGeolocationManager_DidChangePosition:
        return jsValueForDecodedMessage<MessageName::WebGeolocationManager_DidChangePosition>(globalObject, decoder);
    case MessageName::WebGeolocationManager_DidFailToDeterminePosition:
        return jsValueForDecodedMessage<MessageName::WebGeolocationManager_DidFailToDeterminePosition>(globalObject, decoder);
#if PLATFORM(IOS_FAMILY)
    case MessageName::WebGeolocationManager_ResetPermissions:
        return jsValueForDecodedMessage<MessageName::WebGeolocationManager_ResetPermissions>(globalObject, decoder);
#endif
    case MessageName::RemoteWebInspectorUI_Initialize:
        return jsValueForDecodedMessage<MessageName::RemoteWebInspectorUI_Initialize>(globalObject, decoder);
    case MessageName::RemoteWebInspectorUI_UpdateFindString:
        return jsValueForDecodedMessage<MessageName::RemoteWebInspectorUI_UpdateFindString>(globalObject, decoder);
#if ENABLE(INSPECTOR_TELEMETRY)
    case MessageName::RemoteWebInspectorUI_SetDiagnosticLoggingAvailable:
        return jsValueForDecodedMessage<MessageName::RemoteWebInspectorUI_SetDiagnosticLoggingAvailable>(globalObject, decoder);
#endif
    case MessageName::RemoteWebInspectorUI_ShowConsole:
        return jsValueForDecodedMessage<MessageName::RemoteWebInspectorUI_ShowConsole>(globalObject, decoder);
    case MessageName::RemoteWebInspectorUI_ShowResources:
        return jsValueForDecodedMessage<MessageName::RemoteWebInspectorUI_ShowResources>(globalObject, decoder);
    case MessageName::RemoteWebInspectorUI_SendMessageToFrontend:
        return jsValueForDecodedMessage<MessageName::RemoteWebInspectorUI_SendMessageToFrontend>(globalObject, decoder);
    case MessageName::WebInspector_Show:
        return jsValueForDecodedMessage<MessageName::WebInspector_Show>(globalObject, decoder);
    case MessageName::WebInspector_Close:
        return jsValueForDecodedMessage<MessageName::WebInspector_Close>(globalObject, decoder);
    case MessageName::WebInspector_SetAttached:
        return jsValueForDecodedMessage<MessageName::WebInspector_SetAttached>(globalObject, decoder);
    case MessageName::WebInspector_ShowConsole:
        return jsValueForDecodedMessage<MessageName::WebInspector_ShowConsole>(globalObject, decoder);
    case MessageName::WebInspector_ShowResources:
        return jsValueForDecodedMessage<MessageName::WebInspector_ShowResources>(globalObject, decoder);
    case MessageName::WebInspector_ShowMainResourceForFrame:
        return jsValueForDecodedMessage<MessageName::WebInspector_ShowMainResourceForFrame>(globalObject, decoder);
    case MessageName::WebInspector_StartPageProfiling:
        return jsValueForDecodedMessage<MessageName::WebInspector_StartPageProfiling>(globalObject, decoder);
    case MessageName::WebInspector_StopPageProfiling:
        return jsValueForDecodedMessage<MessageName::WebInspector_StopPageProfiling>(globalObject, decoder);
    case MessageName::WebInspector_StartElementSelection:
        return jsValueForDecodedMessage<MessageName::WebInspector_StartElementSelection>(globalObject, decoder);
    case MessageName::WebInspector_StopElementSelection:
        return jsValueForDecodedMessage<MessageName::WebInspector_StopElementSelection>(globalObject, decoder);
    case MessageName::WebInspector_SetFrontendConnection:
        return jsValueForDecodedMessage<MessageName::WebInspector_SetFrontendConnection>(globalObject, decoder);
    case MessageName::WebInspectorInterruptDispatcher_NotifyNeedDebuggerBreak:
        return jsValueForDecodedMessage<MessageName::WebInspectorInterruptDispatcher_NotifyNeedDebuggerBreak>(globalObject, decoder);
    case MessageName::WebInspectorUI_EstablishConnection:
        return jsValueForDecodedMessage<MessageName::WebInspectorUI_EstablishConnection>(globalObject, decoder);
    case MessageName::WebInspectorUI_UpdateConnection:
        return jsValueForDecodedMessage<MessageName::WebInspectorUI_UpdateConnection>(globalObject, decoder);
    case MessageName::WebInspectorUI_AttachedBottom:
        return jsValueForDecodedMessage<MessageName::WebInspectorUI_AttachedBottom>(globalObject, decoder);
    case MessageName::WebInspectorUI_AttachedRight:
        return jsValueForDecodedMessage<MessageName::WebInspectorUI_AttachedRight>(globalObject, decoder);
    case MessageName::WebInspectorUI_AttachedLeft:
        return jsValueForDecodedMessage<MessageName::WebInspectorUI_AttachedLeft>(globalObject, decoder);
    case MessageName::WebInspectorUI_Detached:
        return jsValueForDecodedMessage<MessageName::WebInspectorUI_Detached>(globalObject, decoder);
    case MessageName::WebInspectorUI_SetDockingUnavailable:
        return jsValueForDecodedMessage<MessageName::WebInspectorUI_SetDockingUnavailable>(globalObject, decoder);
    case MessageName::WebInspectorUI_SetIsVisible:
        return jsValueForDecodedMessage<MessageName::WebInspectorUI_SetIsVisible>(globalObject, decoder);
    case MessageName::WebInspectorUI_UpdateFindString:
        return jsValueForDecodedMessage<MessageName::WebInspectorUI_UpdateFindString>(globalObject, decoder);
#if ENABLE(INSPECTOR_TELEMETRY)
    case MessageName::WebInspectorUI_SetDiagnosticLoggingAvailable:
        return jsValueForDecodedMessage<MessageName::WebInspectorUI_SetDiagnosticLoggingAvailable>(globalObject, decoder);
#endif
    case MessageName::WebInspectorUI_ShowConsole:
        return jsValueForDecodedMessage<MessageName::WebInspectorUI_ShowConsole>(globalObject, decoder);
    case MessageName::WebInspectorUI_ShowResources:
        return jsValueForDecodedMessage<MessageName::WebInspectorUI_ShowResources>(globalObject, decoder);
    case MessageName::WebInspectorUI_ShowMainResourceForFrame:
        return jsValueForDecodedMessage<MessageName::WebInspectorUI_ShowMainResourceForFrame>(globalObject, decoder);
    case MessageName::WebInspectorUI_StartPageProfiling:
        return jsValueForDecodedMessage<MessageName::WebInspectorUI_StartPageProfiling>(globalObject, decoder);
    case MessageName::WebInspectorUI_StopPageProfiling:
        return jsValueForDecodedMessage<MessageName::WebInspectorUI_StopPageProfiling>(globalObject, decoder);
    case MessageName::WebInspectorUI_StartElementSelection:
        return jsValueForDecodedMessage<MessageName::WebInspectorUI_StartElementSelection>(globalObject, decoder);
    case MessageName::WebInspectorUI_StopElementSelection:
        return jsValueForDecodedMessage<MessageName::WebInspectorUI_StopElementSelection>(globalObject, decoder);
    case MessageName::WebInspectorUI_SendMessageToFrontend:
        return jsValueForDecodedMessage<MessageName::WebInspectorUI_SendMessageToFrontend>(globalObject, decoder);
    case MessageName::WebInspectorUI_EvaluateInFrontendForTesting:
        return jsValueForDecodedMessage<MessageName::WebInspectorUI_EvaluateInFrontendForTesting>(globalObject, decoder);
#if ENABLE(MEDIA_SESSION_COORDINATOR)
    case MessageName::RemoteMediaSessionCoordinator_SeekSessionToTime:
        return jsValueForDecodedMessage<MessageName::RemoteMediaSessionCoordinator_SeekSessionToTime>(globalObject, decoder);
    case MessageName::RemoteMediaSessionCoordinator_PlaySession:
        return jsValueForDecodedMessage<MessageName::RemoteMediaSessionCoordinator_PlaySession>(globalObject, decoder);
    case MessageName::RemoteMediaSessionCoordinator_PauseSession:
        return jsValueForDecodedMessage<MessageName::RemoteMediaSessionCoordinator_PauseSession>(globalObject, decoder);
    case MessageName::RemoteMediaSessionCoordinator_SetSessionTrack:
        return jsValueForDecodedMessage<MessageName::RemoteMediaSessionCoordinator_SetSessionTrack>(globalObject, decoder);
    case MessageName::RemoteMediaSessionCoordinator_CoordinatorStateChanged:
        return jsValueForDecodedMessage<MessageName::RemoteMediaSessionCoordinator_CoordinatorStateChanged>(globalObject, decoder);
#endif
#if ENABLE(MODEL_PROCESS)
    case MessageName::ModelProcessConnection_DidInitialize:
        return jsValueForDecodedMessage<MessageName::ModelProcessConnection_DidInitialize>(globalObject, decoder);
    case MessageName::ModelProcessConnection_DidUnloadModelPlayer:
        return jsValueForDecodedMessage<MessageName::ModelProcessConnection_DidUnloadModelPlayer>(globalObject, decoder);
#endif
#if ENABLE(MODEL_PROCESS)
    case MessageName::ModelProcessModelPlayer_DidCreateLayer:
        return jsValueForDecodedMessage<MessageName::ModelProcessModelPlayer_DidCreateLayer>(globalObject, decoder);
    case MessageName::ModelProcessModelPlayer_DidFinishLoading:
        return jsValueForDecodedMessage<MessageName::ModelProcessModelPlayer_DidFinishLoading>(globalObject, decoder);
    case MessageName::ModelProcessModelPlayer_DidFailLoading:
        return jsValueForDecodedMessage<MessageName::ModelProcessModelPlayer_DidFailLoading>(globalObject, decoder);
    case MessageName::ModelProcessModelPlayer_DidUpdateEntityTransform:
        return jsValueForDecodedMessage<MessageName::ModelProcessModelPlayer_DidUpdateEntityTransform>(globalObject, decoder);
    case MessageName::ModelProcessModelPlayer_DidUpdateAnimationPlaybackState:
        return jsValueForDecodedMessage<MessageName::ModelProcessModelPlayer_DidUpdateAnimationPlaybackState>(globalObject, decoder);
    case MessageName::ModelProcessModelPlayer_DidFinishEnvironmentMapLoading:
        return jsValueForDecodedMessage<MessageName::ModelProcessModelPlayer_DidFinishEnvironmentMapLoading>(globalObject, decoder);
    case MessageName::ModelProcessModelPlayer_DidUnload:
        return jsValueForDecodedMessage<MessageName::ModelProcessModelPlayer_DidUnload>(globalObject, decoder);
#endif
#if USE(LIBWEBRTC)
    case MessageName::LibWebRTCNetwork_SignalReadPacket:
        return jsValueForDecodedMessage<MessageName::LibWebRTCNetwork_SignalReadPacket>(globalObject, decoder);
    case MessageName::LibWebRTCNetwork_SignalSentPacket:
        return jsValueForDecodedMessage<MessageName::LibWebRTCNetwork_SignalSentPacket>(globalObject, decoder);
    case MessageName::LibWebRTCNetwork_SignalAddressReady:
        return jsValueForDecodedMessage<MessageName::LibWebRTCNetwork_SignalAddressReady>(globalObject, decoder);
    case MessageName::LibWebRTCNetwork_SignalConnect:
        return jsValueForDecodedMessage<MessageName::LibWebRTCNetwork_SignalConnect>(globalObject, decoder);
    case MessageName::LibWebRTCNetwork_SignalClose:
        return jsValueForDecodedMessage<MessageName::LibWebRTCNetwork_SignalClose>(globalObject, decoder);
    case MessageName::LibWebRTCNetwork_SignalUsedInterface:
        return jsValueForDecodedMessage<MessageName::LibWebRTCNetwork_SignalUsedInterface>(globalObject, decoder);
#endif
#if ENABLE(WEB_RTC)
    case MessageName::RTCDataChannelRemoteManager_SendData:
        return jsValueForDecodedMessage<MessageName::RTCDataChannelRemoteManager_SendData>(globalObject, decoder);
    case MessageName::RTCDataChannelRemoteManager_Close:
        return jsValueForDecodedMessage<MessageName::RTCDataChannelRemoteManager_Close>(globalObject, decoder);
    case MessageName::RTCDataChannelRemoteManager_ChangeReadyState:
        return jsValueForDecodedMessage<MessageName::RTCDataChannelRemoteManager_ChangeReadyState>(globalObject, decoder);
    case MessageName::RTCDataChannelRemoteManager_ReceiveData:
        return jsValueForDecodedMessage<MessageName::RTCDataChannelRemoteManager_ReceiveData>(globalObject, decoder);
    case MessageName::RTCDataChannelRemoteManager_DetectError:
        return jsValueForDecodedMessage<MessageName::RTCDataChannelRemoteManager_DetectError>(globalObject, decoder);
    case MessageName::RTCDataChannelRemoteManager_BufferedAmountIsDecreasing:
        return jsValueForDecodedMessage<MessageName::RTCDataChannelRemoteManager_BufferedAmountIsDecreasing>(globalObject, decoder);
#endif
#if USE(LIBWEBRTC)
    case MessageName::WebRTCMonitor_NetworksChanged:
        return jsValueForDecodedMessage<MessageName::WebRTCMonitor_NetworksChanged>(globalObject, decoder);
#endif
#if USE(LIBWEBRTC)
    case MessageName::WebRTCResolver_SetResolvedAddress:
        return jsValueForDecodedMessage<MessageName::WebRTCResolver_SetResolvedAddress>(globalObject, decoder);
    case MessageName::WebRTCResolver_ResolvedAddressError:
        return jsValueForDecodedMessage<MessageName::WebRTCResolver_ResolvedAddressError>(globalObject, decoder);
#endif
#if ENABLE(SHAREABLE_RESOURCE)
    case MessageName::NetworkProcessConnection_DidCacheResource:
        return jsValueForDecodedMessage<MessageName::NetworkProcessConnection_DidCacheResource>(globalObject, decoder);
#endif
    case MessageName::NetworkProcessConnection_DidFinishPingLoad:
        return jsValueForDecodedMessage<MessageName::NetworkProcessConnection_DidFinishPingLoad>(globalObject, decoder);
    case MessageName::NetworkProcessConnection_DidFinishPreconnection:
        return jsValueForDecodedMessage<MessageName::NetworkProcessConnection_DidFinishPreconnection>(globalObject, decoder);
    case MessageName::NetworkProcessConnection_SetOnLineState:
        return jsValueForDecodedMessage<MessageName::NetworkProcessConnection_SetOnLineState>(globalObject, decoder);
    case MessageName::NetworkProcessConnection_CookieAcceptPolicyChanged:
        return jsValueForDecodedMessage<MessageName::NetworkProcessConnection_CookieAcceptPolicyChanged>(globalObject, decoder);
    case MessageName::NetworkProcessConnection_UpdateCachedCookiesEnabled:
        return jsValueForDecodedMessage<MessageName::NetworkProcessConnection_UpdateCachedCookiesEnabled>(globalObject, decoder);
#if HAVE(COOKIE_CHANGE_LISTENER_API)
    case MessageName::NetworkProcessConnection_CookiesAdded:
        return jsValueForDecodedMessage<MessageName::NetworkProcessConnection_CookiesAdded>(globalObject, decoder);
    case MessageName::NetworkProcessConnection_CookiesDeleted:
        return jsValueForDecodedMessage<MessageName::NetworkProcessConnection_CookiesDeleted>(globalObject, decoder);
    case MessageName::NetworkProcessConnection_AllCookiesDeleted:
        return jsValueForDecodedMessage<MessageName::NetworkProcessConnection_AllCookiesDeleted>(globalObject, decoder);
#endif
#if ENABLE(WEB_RTC)
    case MessageName::NetworkProcessConnection_ConnectToRTCDataChannelRemoteSource:
        return jsValueForDecodedMessage<MessageName::NetworkProcessConnection_ConnectToRTCDataChannelRemoteSource>(globalObject, decoder);
#endif
    case MessageName::NetworkProcessConnection_MessagesAvailableForPort:
        return jsValueForDecodedMessage<MessageName::NetworkProcessConnection_MessagesAvailableForPort>(globalObject, decoder);
    case MessageName::NetworkProcessConnection_BroadcastConsoleMessage:
        return jsValueForDecodedMessage<MessageName::NetworkProcessConnection_BroadcastConsoleMessage>(globalObject, decoder);
    case MessageName::NetworkProcessConnection_LoadCancelledDownloadRedirectRequestInFrame:
        return jsValueForDecodedMessage<MessageName::NetworkProcessConnection_LoadCancelledDownloadRedirectRequestInFrame>(globalObject, decoder);
    case MessageName::WebResourceLoader_WillSendRequest:
        return jsValueForDecodedMessage<MessageName::WebResourceLoader_WillSendRequest>(globalObject, decoder);
    case MessageName::WebResourceLoader_SetWorkerStart:
        return jsValueForDecodedMessage<MessageName::WebResourceLoader_SetWorkerStart>(globalObject, decoder);
    case MessageName::WebResourceLoader_DidSendData:
        return jsValueForDecodedMessage<MessageName::WebResourceLoader_DidSendData>(globalObject, decoder);
    case MessageName::WebResourceLoader_DidReceiveResponse:
        return jsValueForDecodedMessage<MessageName::WebResourceLoader_DidReceiveResponse>(globalObject, decoder);
    case MessageName::WebResourceLoader_DidReceiveData:
        return jsValueForDecodedMessage<MessageName::WebResourceLoader_DidReceiveData>(globalObject, decoder);
    case MessageName::WebResourceLoader_DidFinishResourceLoad:
        return jsValueForDecodedMessage<MessageName::WebResourceLoader_DidFinishResourceLoad>(globalObject, decoder);
    case MessageName::WebResourceLoader_DidFailResourceLoad:
        return jsValueForDecodedMessage<MessageName::WebResourceLoader_DidFailResourceLoad>(globalObject, decoder);
    case MessageName::WebResourceLoader_DidFailServiceWorkerLoad:
        return jsValueForDecodedMessage<MessageName::WebResourceLoader_DidFailServiceWorkerLoad>(globalObject, decoder);
    case MessageName::WebResourceLoader_ServiceWorkerDidNotHandle:
        return jsValueForDecodedMessage<MessageName::WebResourceLoader_ServiceWorkerDidNotHandle>(globalObject, decoder);
    case MessageName::WebResourceLoader_UpdateResultingClientIdentifier:
        return jsValueForDecodedMessage<MessageName::WebResourceLoader_UpdateResultingClientIdentifier>(globalObject, decoder);
    case MessageName::WebResourceLoader_DidBlockAuthenticationChallenge:
        return jsValueForDecodedMessage<MessageName::WebResourceLoader_DidBlockAuthenticationChallenge>(globalObject, decoder);
    case MessageName::WebResourceLoader_StopLoadingAfterXFrameOptionsOrContentSecurityPolicyDenied:
        return jsValueForDecodedMessage<MessageName::WebResourceLoader_StopLoadingAfterXFrameOptionsOrContentSecurityPolicyDenied>(globalObject, decoder);
#if ENABLE(SHAREABLE_RESOURCE)
    case MessageName::WebResourceLoader_DidReceiveResource:
        return jsValueForDecodedMessage<MessageName::WebResourceLoader_DidReceiveResource>(globalObject, decoder);
#endif
#if ENABLE(CONTENT_FILTERING)
    case MessageName::WebResourceLoader_ContentFilterDidBlockLoad:
        return jsValueForDecodedMessage<MessageName::WebResourceLoader_ContentFilterDidBlockLoad>(globalObject, decoder);
#endif
    case MessageName::WebSocketChannel_DidConnect:
        return jsValueForDecodedMessage<MessageName::WebSocketChannel_DidConnect>(globalObject, decoder);
    case MessageName::WebSocketChannel_DidClose:
        return jsValueForDecodedMessage<MessageName::WebSocketChannel_DidClose>(globalObject, decoder);
    case MessageName::WebSocketChannel_DidReceiveText:
        return jsValueForDecodedMessage<MessageName::WebSocketChannel_DidReceiveText>(globalObject, decoder);
    case MessageName::WebSocketChannel_DidReceiveBinaryData:
        return jsValueForDecodedMessage<MessageName::WebSocketChannel_DidReceiveBinaryData>(globalObject, decoder);
    case MessageName::WebSocketChannel_DidReceiveMessageError:
        return jsValueForDecodedMessage<MessageName::WebSocketChannel_DidReceiveMessageError>(globalObject, decoder);
    case MessageName::WebSocketChannel_DidSendHandshakeRequest:
        return jsValueForDecodedMessage<MessageName::WebSocketChannel_DidSendHandshakeRequest>(globalObject, decoder);
    case MessageName::WebSocketChannel_DidReceiveHandshakeResponse:
        return jsValueForDecodedMessage<MessageName::WebSocketChannel_DidReceiveHandshakeResponse>(globalObject, decoder);
    case MessageName::WebTransportSession_ReceiveDatagram:
        return jsValueForDecodedMessage<MessageName::WebTransportSession_ReceiveDatagram>(globalObject, decoder);
    case MessageName::WebTransportSession_ReceiveIncomingUnidirectionalStream:
        return jsValueForDecodedMessage<MessageName::WebTransportSession_ReceiveIncomingUnidirectionalStream>(globalObject, decoder);
    case MessageName::WebTransportSession_ReceiveBidirectionalStream:
        return jsValueForDecodedMessage<MessageName::WebTransportSession_ReceiveBidirectionalStream>(globalObject, decoder);
    case MessageName::WebTransportSession_StreamReceiveBytes:
        return jsValueForDecodedMessage<MessageName::WebTransportSession_StreamReceiveBytes>(globalObject, decoder);
    case MessageName::WebNotificationManager_DidShowNotification:
        return jsValueForDecodedMessage<MessageName::WebNotificationManager_DidShowNotification>(globalObject, decoder);
    case MessageName::WebNotificationManager_DidClickNotification:
        return jsValueForDecodedMessage<MessageName::WebNotificationManager_DidClickNotification>(globalObject, decoder);
    case MessageName::WebNotificationManager_DidCloseNotifications:
        return jsValueForDecodedMessage<MessageName::WebNotificationManager_DidCloseNotifications>(globalObject, decoder);
    case MessageName::WebNotificationManager_DidUpdateNotificationDecision:
        return jsValueForDecodedMessage<MessageName::WebNotificationManager_DidUpdateNotificationDecision>(globalObject, decoder);
    case MessageName::WebNotificationManager_DidRemoveNotificationDecisions:
        return jsValueForDecodedMessage<MessageName::WebNotificationManager_DidRemoveNotificationDecisions>(globalObject, decoder);
#if ENABLE(MEDIA_STREAM)
    case MessageName::SpeechRecognitionRealtimeMediaSourceManager_CreateSource:
        return jsValueForDecodedMessage<MessageName::SpeechRecognitionRealtimeMediaSourceManager_CreateSource>(globalObject, decoder);
    case MessageName::SpeechRecognitionRealtimeMediaSourceManager_DeleteSource:
        return jsValueForDecodedMessage<MessageName::SpeechRecognitionRealtimeMediaSourceManager_DeleteSource>(globalObject, decoder);
    case MessageName::SpeechRecognitionRealtimeMediaSourceManager_Start:
        return jsValueForDecodedMessage<MessageName::SpeechRecognitionRealtimeMediaSourceManager_Start>(globalObject, decoder);
    case MessageName::SpeechRecognitionRealtimeMediaSourceManager_Stop:
        return jsValueForDecodedMessage<MessageName::SpeechRecognitionRealtimeMediaSourceManager_Stop>(globalObject, decoder);
#endif
    case MessageName::WebSharedWorkerContextManagerConnection_LaunchSharedWorker:
        return jsValueForDecodedMessage<MessageName::WebSharedWorkerContextManagerConnection_LaunchSharedWorker>(globalObject, decoder);
    case MessageName::WebSharedWorkerContextManagerConnection_PostConnectEvent:
        return jsValueForDecodedMessage<MessageName::WebSharedWorkerContextManagerConnection_PostConnectEvent>(globalObject, decoder);
    case MessageName::WebSharedWorkerContextManagerConnection_TerminateSharedWorker:
        return jsValueForDecodedMessage<MessageName::WebSharedWorkerContextManagerConnection_TerminateSharedWorker>(globalObject, decoder);
    case MessageName::WebSharedWorkerContextManagerConnection_UpdatePreferencesStore:
        return jsValueForDecodedMessage<MessageName::WebSharedWorkerContextManagerConnection_UpdatePreferencesStore>(globalObject, decoder);
    case MessageName::WebSharedWorkerContextManagerConnection_SetUserAgent:
        return jsValueForDecodedMessage<MessageName::WebSharedWorkerContextManagerConnection_SetUserAgent>(globalObject, decoder);
    case MessageName::WebSharedWorkerContextManagerConnection_Close:
        return jsValueForDecodedMessage<MessageName::WebSharedWorkerContextManagerConnection_Close>(globalObject, decoder);
    case MessageName::WebSharedWorkerContextManagerConnection_SuspendSharedWorker:
        return jsValueForDecodedMessage<MessageName::WebSharedWorkerContextManagerConnection_SuspendSharedWorker>(globalObject, decoder);
    case MessageName::WebSharedWorkerContextManagerConnection_ResumeSharedWorker:
        return jsValueForDecodedMessage<MessageName::WebSharedWorkerContextManagerConnection_ResumeSharedWorker>(globalObject, decoder);
    case MessageName::WebSharedWorkerObjectConnection_FetchScriptInClient:
        return jsValueForDecodedMessage<MessageName::WebSharedWorkerObjectConnection_FetchScriptInClient>(globalObject, decoder);
    case MessageName::WebSharedWorkerObjectConnection_NotifyWorkerObjectOfLoadCompletion:
        return jsValueForDecodedMessage<MessageName::WebSharedWorkerObjectConnection_NotifyWorkerObjectOfLoadCompletion>(globalObject, decoder);
    case MessageName::WebSharedWorkerObjectConnection_PostErrorToWorkerObject:
        return jsValueForDecodedMessage<MessageName::WebSharedWorkerObjectConnection_PostErrorToWorkerObject>(globalObject, decoder);
#if ENABLE(CONTENT_EXTENSIONS)
    case MessageName::WebSharedWorkerObjectConnection_ReportNetworkUsageToWorkerObject:
        return jsValueForDecodedMessage<MessageName::WebSharedWorkerObjectConnection_ReportNetworkUsageToWorkerObject>(globalObject, decoder);
#endif
    case MessageName::WebSWClientConnection_JobRejectedInServer:
        return jsValueForDecodedMessage<MessageName::WebSWClientConnection_JobRejectedInServer>(globalObject, decoder);
    case MessageName::WebSWClientConnection_RegistrationJobResolvedInServer:
        return jsValueForDecodedMessage<MessageName::WebSWClientConnection_RegistrationJobResolvedInServer>(globalObject, decoder);
    case MessageName::WebSWClientConnection_StartScriptFetchForServer:
        return jsValueForDecodedMessage<MessageName::WebSWClientConnection_StartScriptFetchForServer>(globalObject, decoder);
    case MessageName::WebSWClientConnection_UpdateRegistrationState:
        return jsValueForDecodedMessage<MessageName::WebSWClientConnection_UpdateRegistrationState>(globalObject, decoder);
    case MessageName::WebSWClientConnection_UpdateWorkerState:
        return jsValueForDecodedMessage<MessageName::WebSWClientConnection_UpdateWorkerState>(globalObject, decoder);
    case MessageName::WebSWClientConnection_FireUpdateFoundEvent:
        return jsValueForDecodedMessage<MessageName::WebSWClientConnection_FireUpdateFoundEvent>(globalObject, decoder);
    case MessageName::WebSWClientConnection_SetRegistrationLastUpdateTime:
        return jsValueForDecodedMessage<MessageName::WebSWClientConnection_SetRegistrationLastUpdateTime>(globalObject, decoder);
    case MessageName::WebSWClientConnection_SetRegistrationUpdateViaCache:
        return jsValueForDecodedMessage<MessageName::WebSWClientConnection_SetRegistrationUpdateViaCache>(globalObject, decoder);
    case MessageName::WebSWClientConnection_NotifyClientsOfControllerChange:
        return jsValueForDecodedMessage<MessageName::WebSWClientConnection_NotifyClientsOfControllerChange>(globalObject, decoder);
    case MessageName::WebSWClientConnection_UpdateBackgroundFetchRegistration:
        return jsValueForDecodedMessage<MessageName::WebSWClientConnection_UpdateBackgroundFetchRegistration>(globalObject, decoder);
    case MessageName::WebSWClientConnection_SetSWOriginTableIsImported:
        return jsValueForDecodedMessage<MessageName::WebSWClientConnection_SetSWOriginTableIsImported>(globalObject, decoder);
    case MessageName::WebSWClientConnection_SetSWOriginTableSharedMemory:
        return jsValueForDecodedMessage<MessageName::WebSWClientConnection_SetSWOriginTableSharedMemory>(globalObject, decoder);
    case MessageName::WebSWClientConnection_PostMessageToServiceWorkerClient:
        return jsValueForDecodedMessage<MessageName::WebSWClientConnection_PostMessageToServiceWorkerClient>(globalObject, decoder);
    case MessageName::WebSWClientConnection_SetServiceWorkerClientIsControlled:
        return jsValueForDecodedMessage<MessageName::WebSWClientConnection_SetServiceWorkerClientIsControlled>(globalObject, decoder);
    case MessageName::WebSWClientConnection_FocusServiceWorkerClient:
        return jsValueForDecodedMessage<MessageName::WebSWClientConnection_FocusServiceWorkerClient>(globalObject, decoder);
    case MessageName::WebSWClientConnection_NotifyRecordResponseBodyChunk:
        return jsValueForDecodedMessage<MessageName::WebSWClientConnection_NotifyRecordResponseBodyChunk>(globalObject, decoder);
    case MessageName::WebSWClientConnection_NotifyRecordResponseBodyEnd:
        return jsValueForDecodedMessage<MessageName::WebSWClientConnection_NotifyRecordResponseBodyEnd>(globalObject, decoder);
#if ENABLE(CONTENT_EXTENSIONS)
    case MessageName::WebSWClientConnection_ReportNetworkUsageToWorkerClient:
        return jsValueForDecodedMessage<MessageName::WebSWClientConnection_ReportNetworkUsageToWorkerClient>(globalObject, decoder);
#endif
    case MessageName::WebSWContextManagerConnection_InstallServiceWorker:
        return jsValueForDecodedMessage<MessageName::WebSWContextManagerConnection_InstallServiceWorker>(globalObject, decoder);
    case MessageName::WebSWContextManagerConnection_UpdateAppInitiatedValue:
        return jsValueForDecodedMessage<MessageName::WebSWContextManagerConnection_UpdateAppInitiatedValue>(globalObject, decoder);
    case MessageName::WebSWContextManagerConnection_StartFetch:
        return jsValueForDecodedMessage<MessageName::WebSWContextManagerConnection_StartFetch>(globalObject, decoder);
    case MessageName::WebSWContextManagerConnection_CancelFetch:
        return jsValueForDecodedMessage<MessageName::WebSWContextManagerConnection_CancelFetch>(globalObject, decoder);
    case MessageName::WebSWContextManagerConnection_ContinueDidReceiveFetchResponse:
        return jsValueForDecodedMessage<MessageName::WebSWContextManagerConnection_ContinueDidReceiveFetchResponse>(globalObject, decoder);
    case MessageName::WebSWContextManagerConnection_PostMessageToServiceWorker:
        return jsValueForDecodedMessage<MessageName::WebSWContextManagerConnection_PostMessageToServiceWorker>(globalObject, decoder);
    case MessageName::WebSWContextManagerConnection_FireInstallEvent:
        return jsValueForDecodedMessage<MessageName::WebSWContextManagerConnection_FireInstallEvent>(globalObject, decoder);
    case MessageName::WebSWContextManagerConnection_FireActivateEvent:
        return jsValueForDecodedMessage<MessageName::WebSWContextManagerConnection_FireActivateEvent>(globalObject, decoder);
    case MessageName::WebSWContextManagerConnection_FirePushEvent:
        return jsValueForDecodedMessage<MessageName::WebSWContextManagerConnection_FirePushEvent>(globalObject, decoder);
    case MessageName::WebSWContextManagerConnection_FireNotificationEvent:
        return jsValueForDecodedMessage<MessageName::WebSWContextManagerConnection_FireNotificationEvent>(globalObject, decoder);
    case MessageName::WebSWContextManagerConnection_FireBackgroundFetchEvent:
        return jsValueForDecodedMessage<MessageName::WebSWContextManagerConnection_FireBackgroundFetchEvent>(globalObject, decoder);
    case MessageName::WebSWContextManagerConnection_FireBackgroundFetchClickEvent:
        return jsValueForDecodedMessage<MessageName::WebSWContextManagerConnection_FireBackgroundFetchClickEvent>(globalObject, decoder);
    case MessageName::WebSWContextManagerConnection_TerminateWorker:
        return jsValueForDecodedMessage<MessageName::WebSWContextManagerConnection_TerminateWorker>(globalObject, decoder);
#if ENABLE(SHAREABLE_RESOURCE) && PLATFORM(COCOA)
    case MessageName::WebSWContextManagerConnection_DidSaveScriptsToDisk:
        return jsValueForDecodedMessage<MessageName::WebSWContextManagerConnection_DidSaveScriptsToDisk>(globalObject, decoder);
#endif
    case MessageName::WebSWContextManagerConnection_SetUserAgent:
        return jsValueForDecodedMessage<MessageName::WebSWContextManagerConnection_SetUserAgent>(globalObject, decoder);
    case MessageName::WebSWContextManagerConnection_UpdatePreferencesStore:
        return jsValueForDecodedMessage<MessageName::WebSWContextManagerConnection_UpdatePreferencesStore>(globalObject, decoder);
    case MessageName::WebSWContextManagerConnection_Close:
        return jsValueForDecodedMessage<MessageName::WebSWContextManagerConnection_Close>(globalObject, decoder);
    case MessageName::WebSWContextManagerConnection_SetThrottleState:
        return jsValueForDecodedMessage<MessageName::WebSWContextManagerConnection_SetThrottleState>(globalObject, decoder);
    case MessageName::WebSWContextManagerConnection_SetInspectable:
        return jsValueForDecodedMessage<MessageName::WebSWContextManagerConnection_SetInspectable>(globalObject, decoder);
    case MessageName::WebSWContextManagerConnection_ConvertFetchToDownload:
        return jsValueForDecodedMessage<MessageName::WebSWContextManagerConnection_ConvertFetchToDownload>(globalObject, decoder);
    case MessageName::WebSWContextManagerConnection_NavigationPreloadIsReady:
        return jsValueForDecodedMessage<MessageName::WebSWContextManagerConnection_NavigationPreloadIsReady>(globalObject, decoder);
    case MessageName::WebSWContextManagerConnection_NavigationPreloadFailed:
        return jsValueForDecodedMessage<MessageName::WebSWContextManagerConnection_NavigationPreloadFailed>(globalObject, decoder);
    case MessageName::WebSWContextManagerConnection_UpdateRegistrationState:
        return jsValueForDecodedMessage<MessageName::WebSWContextManagerConnection_UpdateRegistrationState>(globalObject, decoder);
    case MessageName::WebSWContextManagerConnection_UpdateWorkerState:
        return jsValueForDecodedMessage<MessageName::WebSWContextManagerConnection_UpdateWorkerState>(globalObject, decoder);
    case MessageName::WebSWContextManagerConnection_FireUpdateFoundEvent:
        return jsValueForDecodedMessage<MessageName::WebSWContextManagerConnection_FireUpdateFoundEvent>(globalObject, decoder);
    case MessageName::WebSWContextManagerConnection_SetRegistrationLastUpdateTime:
        return jsValueForDecodedMessage<MessageName::WebSWContextManagerConnection_SetRegistrationLastUpdateTime>(globalObject, decoder);
    case MessageName::WebSWContextManagerConnection_SetRegistrationUpdateViaCache:
        return jsValueForDecodedMessage<MessageName::WebSWContextManagerConnection_SetRegistrationUpdateViaCache>(globalObject, decoder);
#if ENABLE(REMOTE_INSPECTOR) && PLATFORM(COCOA)
    case MessageName::WebSWContextManagerConnection_ConnectToInspector:
        return jsValueForDecodedMessage<MessageName::WebSWContextManagerConnection_ConnectToInspector>(globalObject, decoder);
    case MessageName::WebSWContextManagerConnection_DisconnectFromInspector:
        return jsValueForDecodedMessage<MessageName::WebSWContextManagerConnection_DisconnectFromInspector>(globalObject, decoder);
    case MessageName::WebSWContextManagerConnection_DispatchMessageFromInspector:
        return jsValueForDecodedMessage<MessageName::WebSWContextManagerConnection_DispatchMessageFromInspector>(globalObject, decoder);
#endif
#if ((ENABLE(REMOTE_INSPECTOR) && PLATFORM(COCOA)) && ENABLE(REMOTE_INSPECTOR_SERVICE_WORKER_AUTO_INSPECTION))
    case MessageName::WebSWContextManagerConnection_UnpauseServiceWorkerForRejectedAutomaticInspection:
        return jsValueForDecodedMessage<MessageName::WebSWContextManagerConnection_UnpauseServiceWorkerForRejectedAutomaticInspection>(globalObject, decoder);
#endif
    case MessageName::WebUserContentController_AddContentWorlds:
        return jsValueForDecodedMessage<MessageName::WebUserContentController_AddContentWorlds>(globalObject, decoder);
    case MessageName::WebUserContentController_RemoveContentWorlds:
        return jsValueForDecodedMessage<MessageName::WebUserContentController_RemoveContentWorlds>(globalObject, decoder);
    case MessageName::WebUserContentController_AddUserScripts:
        return jsValueForDecodedMessage<MessageName::WebUserContentController_AddUserScripts>(globalObject, decoder);
    case MessageName::WebUserContentController_RemoveUserScript:
        return jsValueForDecodedMessage<MessageName::WebUserContentController_RemoveUserScript>(globalObject, decoder);
    case MessageName::WebUserContentController_RemoveAllUserScripts:
        return jsValueForDecodedMessage<MessageName::WebUserContentController_RemoveAllUserScripts>(globalObject, decoder);
    case MessageName::WebUserContentController_AddUserStyleSheets:
        return jsValueForDecodedMessage<MessageName::WebUserContentController_AddUserStyleSheets>(globalObject, decoder);
    case MessageName::WebUserContentController_RemoveUserStyleSheet:
        return jsValueForDecodedMessage<MessageName::WebUserContentController_RemoveUserStyleSheet>(globalObject, decoder);
    case MessageName::WebUserContentController_RemoveAllUserStyleSheets:
        return jsValueForDecodedMessage<MessageName::WebUserContentController_RemoveAllUserStyleSheets>(globalObject, decoder);
    case MessageName::WebUserContentController_AddUserScriptMessageHandlers:
        return jsValueForDecodedMessage<MessageName::WebUserContentController_AddUserScriptMessageHandlers>(globalObject, decoder);
    case MessageName::WebUserContentController_RemoveUserScriptMessageHandler:
        return jsValueForDecodedMessage<MessageName::WebUserContentController_RemoveUserScriptMessageHandler>(globalObject, decoder);
    case MessageName::WebUserContentController_RemoveAllUserScriptMessageHandlersForWorlds:
        return jsValueForDecodedMessage<MessageName::WebUserContentController_RemoveAllUserScriptMessageHandlersForWorlds>(globalObject, decoder);
    case MessageName::WebUserContentController_RemoveAllUserScriptMessageHandlers:
        return jsValueForDecodedMessage<MessageName::WebUserContentController_RemoveAllUserScriptMessageHandlers>(globalObject, decoder);
#if ENABLE(CONTENT_EXTENSIONS)
    case MessageName::WebUserContentController_AddContentRuleLists:
        return jsValueForDecodedMessage<MessageName::WebUserContentController_AddContentRuleLists>(globalObject, decoder);
    case MessageName::WebUserContentController_RemoveContentRuleList:
        return jsValueForDecodedMessage<MessageName::WebUserContentController_RemoveContentRuleList>(globalObject, decoder);
    case MessageName::WebUserContentController_RemoveAllContentRuleLists:
        return jsValueForDecodedMessage<MessageName::WebUserContentController_RemoveAllContentRuleLists>(globalObject, decoder);
#endif
    case MessageName::RemoteWebLockRegistry_DidCompleteLockRequest:
        return jsValueForDecodedMessage<MessageName::RemoteWebLockRegistry_DidCompleteLockRequest>(globalObject, decoder);
    case MessageName::RemoteWebLockRegistry_DidStealLock:
        return jsValueForDecodedMessage<MessageName::RemoteWebLockRegistry_DidStealLock>(globalObject, decoder);
    case MessageName::WebBroadcastChannelRegistry_PostMessageToRemote:
        return jsValueForDecodedMessage<MessageName::WebBroadcastChannelRegistry_PostMessageToRemote>(globalObject, decoder);
    case MessageName::WebFileSystemStorageConnection_InvalidateAccessHandle:
        return jsValueForDecodedMessage<MessageName::WebFileSystemStorageConnection_InvalidateAccessHandle>(globalObject, decoder);
    case MessageName::WebFileSystemStorageConnection_InvalidateWritable:
        return jsValueForDecodedMessage<MessageName::WebFileSystemStorageConnection_InvalidateWritable>(globalObject, decoder);
    case MessageName::WebPermissionController_permissionChanged:
        return jsValueForDecodedMessage<MessageName::WebPermissionController_permissionChanged>(globalObject, decoder);
    case MessageName::WebScreenOrientationManager_OrientationDidChange:
        return jsValueForDecodedMessage<MessageName::WebScreenOrientationManager_OrientationDidChange>(globalObject, decoder);
    case MessageName::WebSpeechRecognitionConnection_DidReceiveUpdate:
        return jsValueForDecodedMessage<MessageName::WebSpeechRecognitionConnection_DidReceiveUpdate>(globalObject, decoder);
#if USE(COORDINATED_GRAPHICS) || USE(TEXTURE_MAPPER)
    case MessageName::DrawingArea_UpdateGeometry:
        return jsValueForDecodedMessage<MessageName::DrawingArea_UpdateGeometry>(globalObject, decoder);
    case MessageName::DrawingArea_ForceUpdate:
        return jsValueForDecodedMessage<MessageName::DrawingArea_ForceUpdate>(globalObject, decoder);
    case MessageName::DrawingArea_DidDiscardBackingStore:
        return jsValueForDecodedMessage<MessageName::DrawingArea_DidDiscardBackingStore>(globalObject, decoder);
#endif
    case MessageName::DrawingArea_SetDeviceScaleFactor:
        return jsValueForDecodedMessage<MessageName::DrawingArea_SetDeviceScaleFactor>(globalObject, decoder);
    case MessageName::DrawingArea_DisplayDidRefresh:
        return jsValueForDecodedMessage<MessageName::DrawingArea_DisplayDidRefresh>(globalObject, decoder);
#if PLATFORM(COCOA)
    case MessageName::DrawingArea_UpdateGeometry:
        return jsValueForDecodedMessage<MessageName::DrawingArea_UpdateGeometry>(globalObject, decoder);
    case MessageName::DrawingArea_SetColorSpace:
        return jsValueForDecodedMessage<MessageName::DrawingArea_SetColorSpace>(globalObject, decoder);
    case MessageName::DrawingArea_SetViewExposedRect:
        return jsValueForDecodedMessage<MessageName::DrawingArea_SetViewExposedRect>(globalObject, decoder);
    case MessageName::DrawingArea_AcceleratedAnimationDidStart:
        return jsValueForDecodedMessage<MessageName::DrawingArea_AcceleratedAnimationDidStart>(globalObject, decoder);
    case MessageName::DrawingArea_AcceleratedAnimationDidEnd:
        return jsValueForDecodedMessage<MessageName::DrawingArea_AcceleratedAnimationDidEnd>(globalObject, decoder);
#endif
#if PLATFORM(COCOA) || PLATFORM(GTK) || PLATFORM(WPE)
    case MessageName::DrawingArea_DispatchAfterEnsuringDrawing:
        return jsValueForDecodedMessage<MessageName::DrawingArea_DispatchAfterEnsuringDrawing>(globalObject, decoder);
#endif
#if USE(GRAPHICS_LAYER_WC)
    case MessageName::DrawingArea_UpdateGeometryWC:
        return jsValueForDecodedMessage<MessageName::DrawingArea_UpdateGeometryWC>(globalObject, decoder);
#endif
#if PLATFORM(COCOA) || PLATFORM(GTK)
    case MessageName::DrawingArea_AdjustTransientZoom:
        return jsValueForDecodedMessage<MessageName::DrawingArea_AdjustTransientZoom>(globalObject, decoder);
    case MessageName::DrawingArea_CommitTransientZoom:
        return jsValueForDecodedMessage<MessageName::DrawingArea_CommitTransientZoom>(globalObject, decoder);
#endif
    case MessageName::EventDispatcher_WheelEvent:
        return jsValueForDecodedMessage<MessageName::EventDispatcher_WheelEvent>(globalObject, decoder);
#if ENABLE(IOS_TOUCH_EVENTS)
    case MessageName::EventDispatcher_TouchEvent:
        return jsValueForDecodedMessage<MessageName::EventDispatcher_TouchEvent>(globalObject, decoder);
#endif
#if ENABLE(MAC_GESTURE_EVENTS)
    case MessageName::EventDispatcher_GestureEvent:
        return jsValueForDecodedMessage<MessageName::EventDispatcher_GestureEvent>(globalObject, decoder);
#endif
#if HAVE(DISPLAY_LINK)
    case MessageName::EventDispatcher_DisplayDidRefresh:
        return jsValueForDecodedMessage<MessageName::EventDispatcher_DisplayDidRefresh>(globalObject, decoder);
#endif
#if ENABLE(MOMENTUM_EVENT_DISPATCHER)
    case MessageName::EventDispatcher_SetScrollingAccelerationCurve:
        return jsValueForDecodedMessage<MessageName::EventDispatcher_SetScrollingAccelerationCurve>(globalObject, decoder);
#endif
    case MessageName::EventDispatcher_PageScreenDidChange:
        return jsValueForDecodedMessage<MessageName::EventDispatcher_PageScreenDidChange>(globalObject, decoder);
    case MessageName::VisitedLinkTableController_SetVisitedLinkTable:
        return jsValueForDecodedMessage<MessageName::VisitedLinkTableController_SetVisitedLinkTable>(globalObject, decoder);
    case MessageName::VisitedLinkTableController_VisitedLinkStateChanged:
        return jsValueForDecodedMessage<MessageName::VisitedLinkTableController_VisitedLinkStateChanged>(globalObject, decoder);
    case MessageName::VisitedLinkTableController_AllVisitedLinkStateChanged:
        return jsValueForDecodedMessage<MessageName::VisitedLinkTableController_AllVisitedLinkStateChanged>(globalObject, decoder);
    case MessageName::VisitedLinkTableController_RemoveAllVisitedLinks:
        return jsValueForDecodedMessage<MessageName::VisitedLinkTableController_RemoveAllVisitedLinks>(globalObject, decoder);
    case MessageName::WebFrame_GetFrameInfo:
        return jsValueForDecodedMessage<MessageName::WebFrame_GetFrameInfo>(globalObject, decoder);
    case MessageName::WebFrame_UpdateFrameSize:
        return jsValueForDecodedMessage<MessageName::WebFrame_UpdateFrameSize>(globalObject, decoder);
    case MessageName::WebFrame_CreateProvisionalFrame:
        return jsValueForDecodedMessage<MessageName::WebFrame_CreateProvisionalFrame>(globalObject, decoder);
    case MessageName::WebFrame_DestroyProvisionalFrame:
        return jsValueForDecodedMessage<MessageName::WebFrame_DestroyProvisionalFrame>(globalObject, decoder);
    case MessageName::WebFrame_FindFocusableElementDescendingIntoRemoteFrame:
        return jsValueForDecodedMessage<MessageName::WebFrame_FindFocusableElementDescendingIntoRemoteFrame>(globalObject, decoder);
    case MessageName::WebPage_SetInitialFocus:
        return jsValueForDecodedMessage<MessageName::WebPage_SetInitialFocus>(globalObject, decoder);
    case MessageName::WebPage_SetActivityState:
        return jsValueForDecodedMessage<MessageName::WebPage_SetActivityState>(globalObject, decoder);
    case MessageName::WebPage_SetBackgroundColor:
        return jsValueForDecodedMessage<MessageName::WebPage_SetBackgroundColor>(globalObject, decoder);
    case MessageName::WebPage_AddConsoleMessage:
        return jsValueForDecodedMessage<MessageName::WebPage_AddConsoleMessage>(globalObject, decoder);
    case MessageName::WebPage_EnqueueSecurityPolicyViolationEvent:
        return jsValueForDecodedMessage<MessageName::WebPage_EnqueueSecurityPolicyViolationEvent>(globalObject, decoder);
    case MessageName::WebPage_SendReportToEndpoints:
        return jsValueForDecodedMessage<MessageName::WebPage_SendReportToEndpoints>(globalObject, decoder);
    case MessageName::WebPage_NotifyReportObservers:
        return jsValueForDecodedMessage<MessageName::WebPage_NotifyReportObservers>(globalObject, decoder);
    case MessageName::WebPage_TestProcessIncomingSyncMessagesWhenWaitingForSyncReply:
        return jsValueForDecodedMessage<MessageName::WebPage_TestProcessIncomingSyncMessagesWhenWaitingForSyncReply>(globalObject, decoder);
#if PLATFORM(COCOA)
    case MessageName::WebPage_SetObscuredContentInsetsFenced:
        return jsValueForDecodedMessage<MessageName::WebPage_SetObscuredContentInsetsFenced>(globalObject, decoder);
#endif
#if !PLATFORM(COCOA)
    case MessageName::WebPage_SetObscuredContentInsets:
        return jsValueForDecodedMessage<MessageName::WebPage_SetObscuredContentInsets>(globalObject, decoder);
#endif
    case MessageName::WebPage_SetShouldSuppressHDR:
        return jsValueForDecodedMessage<MessageName::WebPage_SetShouldSuppressHDR>(globalObject, decoder);
    case MessageName::WebPage_SetUnderlayColor:
        return jsValueForDecodedMessage<MessageName::WebPage_SetUnderlayColor>(globalObject, decoder);
    case MessageName::WebPage_SetUnderPageBackgroundColorOverride:
        return jsValueForDecodedMessage<MessageName::WebPage_SetUnderPageBackgroundColorOverride>(globalObject, decoder);
    case MessageName::WebPage_SetNeedsFixedContainerEdgesUpdate:
        return jsValueForDecodedMessage<MessageName::WebPage_SetNeedsFixedContainerEdgesUpdate>(globalObject, decoder);
    case MessageName::WebPage_ViewWillStartLiveResize:
        return jsValueForDecodedMessage<MessageName::WebPage_ViewWillStartLiveResize>(globalObject, decoder);
    case MessageName::WebPage_ViewWillEndLiveResize:
        return jsValueForDecodedMessage<MessageName::WebPage_ViewWillEndLiveResize>(globalObject, decoder);
    case MessageName::WebPage_ExecuteEditCommandWithCallback:
        return jsValueForDecodedMessage<MessageName::WebPage_ExecuteEditCommandWithCallback>(globalObject, decoder);
    case MessageName::WebPage_KeyEvent:
        return jsValueForDecodedMessage<MessageName::WebPage_KeyEvent>(globalObject, decoder);
    case MessageName::WebPage_MouseEvent:
        return jsValueForDecodedMessage<MessageName::WebPage_MouseEvent>(globalObject, decoder);
    case MessageName::WebPage_SetLastKnownMousePosition:
        return jsValueForDecodedMessage<MessageName::WebPage_SetLastKnownMousePosition>(globalObject, decoder);
#if PLATFORM(IOS_FAMILY)
    case MessageName::WebPage_SetSceneIdentifier:
        return jsValueForDecodedMessage<MessageName::WebPage_SetSceneIdentifier>(globalObject, decoder);
    case MessageName::WebPage_SetViewportConfigurationViewLayoutSize:
        return jsValueForDecodedMessage<MessageName::WebPage_SetViewportConfigurationViewLayoutSize>(globalObject, decoder);
    case MessageName::WebPage_SetDeviceOrientation:
        return jsValueForDecodedMessage<MessageName::WebPage_SetDeviceOrientation>(globalObject, decoder);
    case MessageName::WebPage_SetOverrideViewportArguments:
        return jsValueForDecodedMessage<MessageName::WebPage_SetOverrideViewportArguments>(globalObject, decoder);
    case MessageName::WebPage_DynamicViewportSizeUpdate:
        return jsValueForDecodedMessage<MessageName::WebPage_DynamicViewportSizeUpdate>(globalObject, decoder);
    case MessageName::WebPage_SetScreenIsBeingCaptured:
        return jsValueForDecodedMessage<MessageName::WebPage_SetScreenIsBeingCaptured>(globalObject, decoder);
    case MessageName::WebPage_SetInsertionPointColor:
        return jsValueForDecodedMessage<MessageName::WebPage_SetInsertionPointColor>(globalObject, decoder);
    case MessageName::WebPage_AttemptSyntheticClick:
        return jsValueForDecodedMessage<MessageName::WebPage_AttemptSyntheticClick>(globalObject, decoder);
    case MessageName::WebPage_PotentialTapAtPosition:
        return jsValueForDecodedMessage<MessageName::WebPage_PotentialTapAtPosition>(globalObject, decoder);
    case MessageName::WebPage_CommitPotentialTap:
        return jsValueForDecodedMessage<MessageName::WebPage_CommitPotentialTap>(globalObject, decoder);
    case MessageName::WebPage_CancelPotentialTap:
        return jsValueForDecodedMessage<MessageName::WebPage_CancelPotentialTap>(globalObject, decoder);
    case MessageName::WebPage_TapHighlightAtPosition:
        return jsValueForDecodedMessage<MessageName::WebPage_TapHighlightAtPosition>(globalObject, decoder);
    case MessageName::WebPage_DidRecognizeLongPress:
        return jsValueForDecodedMessage<MessageName::WebPage_DidRecognizeLongPress>(globalObject, decoder);
    case MessageName::WebPage_HandleDoubleTapForDoubleClickAtPoint:
        return jsValueForDecodedMessage<MessageName::WebPage_HandleDoubleTapForDoubleClickAtPoint>(globalObject, decoder);
    case MessageName::WebPage_InspectorNodeSearchMovedToPosition:
        return jsValueForDecodedMessage<MessageName::WebPage_InspectorNodeSearchMovedToPosition>(globalObject, decoder);
    case MessageName::WebPage_InspectorNodeSearchEndedAtPosition:
        return jsValueForDecodedMessage<MessageName::WebPage_InspectorNodeSearchEndedAtPosition>(globalObject, decoder);
    case MessageName::WebPage_BlurFocusedElement:
        return jsValueForDecodedMessage<MessageName::WebPage_BlurFocusedElement>(globalObject, decoder);
    case MessageName::WebPage_SelectWithGesture:
        return jsValueForDecodedMessage<MessageName::WebPage_SelectWithGesture>(globalObject, decoder);
    case MessageName::WebPage_UpdateSelectionWithTouches:
        return jsValueForDecodedMessage<MessageName::WebPage_UpdateSelectionWithTouches>(globalObject, decoder);
    case MessageName::WebPage_SelectWithTwoTouches:
        return jsValueForDecodedMessage<MessageName::WebPage_SelectWithTwoTouches>(globalObject, decoder);
    case MessageName::WebPage_ExtendSelection:
        return jsValueForDecodedMessage<MessageName::WebPage_ExtendSelection>(globalObject, decoder);
    case MessageName::WebPage_SelectWordBackward:
        return jsValueForDecodedMessage<MessageName::WebPage_SelectWordBackward>(globalObject, decoder);
    case MessageName::WebPage_ExtendSelectionForReplacement:
        return jsValueForDecodedMessage<MessageName::WebPage_ExtendSelectionForReplacement>(globalObject, decoder);
    case MessageName::WebPage_MoveSelectionByOffset:
        return jsValueForDecodedMessage<MessageName::WebPage_MoveSelectionByOffset>(globalObject, decoder);
    case MessageName::WebPage_SelectTextWithGranularityAtPoint:
        return jsValueForDecodedMessage<MessageName::WebPage_SelectTextWithGranularityAtPoint>(globalObject, decoder);
    case MessageName::WebPage_SelectPositionAtBoundaryWithDirection:
        return jsValueForDecodedMessage<MessageName::WebPage_SelectPositionAtBoundaryWithDirection>(globalObject, decoder);
    case MessageName::WebPage_MoveSelectionAtBoundaryWithDirection:
        return jsValueForDecodedMessage<MessageName::WebPage_MoveSelectionAtBoundaryWithDirection>(globalObject, decoder);
    case MessageName::WebPage_SelectPositionAtPoint:
        return jsValueForDecodedMessage<MessageName::WebPage_SelectPositionAtPoint>(globalObject, decoder);
    case MessageName::WebPage_BeginSelectionInDirection:
        return jsValueForDecodedMessage<MessageName::WebPage_BeginSelectionInDirection>(globalObject, decoder);
    case MessageName::WebPage_UpdateSelectionWithExtentPoint:
        return jsValueForDecodedMessage<MessageName::WebPage_UpdateSelectionWithExtentPoint>(globalObject, decoder);
    case MessageName::WebPage_UpdateSelectionWithExtentPointAndBoundary:
        return jsValueForDecodedMessage<MessageName::WebPage_UpdateSelectionWithExtentPointAndBoundary>(globalObject, decoder);
    case MessageName::WebPage_DidReleaseAllTouchPoints:
        return jsValueForDecodedMessage<MessageName::WebPage_DidReleaseAllTouchPoints>(globalObject, decoder);
    case MessageName::WebPage_ClearSelectionAfterTappingSelectionHighlightIfNeeded:
        return jsValueForDecodedMessage<MessageName::WebPage_ClearSelectionAfterTappingSelectionHighlightIfNeeded>(globalObject, decoder);
#endif
#if (PLATFORM(IOS_FAMILY) && ENABLE(REVEAL))
    case MessageName::WebPage_RequestRVItemInCurrentSelectedRange:
        return jsValueForDecodedMessage<MessageName::WebPage_RequestRVItemInCurrentSelectedRange>(globalObject, decoder);
    case MessageName::WebPage_PrepareSelectionForContextMenuWithLocationInView:
        return jsValueForDecodedMessage<MessageName::WebPage_PrepareSelectionForContextMenuWithLocationInView>(globalObject, decoder);
#endif
#if PLATFORM(IOS_FAMILY)
    case MessageName::WebPage_WillInsertFinalDictationResult:
        return jsValueForDecodedMessage<MessageName::WebPage_WillInsertFinalDictationResult>(globalObject, decoder);
    case MessageName::WebPage_DidInsertFinalDictationResult:
        return jsValueForDecodedMessage<MessageName::WebPage_DidInsertFinalDictationResult>(globalObject, decoder);
    case MessageName::WebPage_ReplaceDictatedText:
        return jsValueForDecodedMessage<MessageName::WebPage_ReplaceDictatedText>(globalObject, decoder);
    case MessageName::WebPage_ReplaceSelectedText:
        return jsValueForDecodedMessage<MessageName::WebPage_ReplaceSelectedText>(globalObject, decoder);
    case MessageName::WebPage_RequestAutocorrectionData:
        return jsValueForDecodedMessage<MessageName::WebPage_RequestAutocorrectionData>(globalObject, decoder);
    case MessageName::WebPage_ApplyAutocorrection:
        return jsValueForDecodedMessage<MessageName::WebPage_ApplyAutocorrection>(globalObject, decoder);
    case MessageName::WebPage_SyncApplyAutocorrection:
        return jsValueForDecodedMessage<MessageName::WebPage_SyncApplyAutocorrection>(globalObject, decoder);
    case MessageName::WebPage_HandleAutocorrectionContextRequest:
        return jsValueForDecodedMessage<MessageName::WebPage_HandleAutocorrectionContextRequest>(globalObject, decoder);
    case MessageName::WebPage_RequestEvasionRectsAboveSelection:
        return jsValueForDecodedMessage<MessageName::WebPage_RequestEvasionRectsAboveSelection>(globalObject, decoder);
    case MessageName::WebPage_RequestPositionInformation:
        return jsValueForDecodedMessage<MessageName::WebPage_RequestPositionInformation>(globalObject, decoder);
    case MessageName::WebPage_StartInteractionWithElementContextOrPosition:
        return jsValueForDecodedMessage<MessageName::WebPage_StartInteractionWithElementContextOrPosition>(globalObject, decoder);
    case MessageName::WebPage_StopInteraction:
        return jsValueForDecodedMessage<MessageName::WebPage_StopInteraction>(globalObject, decoder);
    case MessageName::WebPage_PerformActionOnElement:
        return jsValueForDecodedMessage<MessageName::WebPage_PerformActionOnElement>(globalObject, decoder);
    case MessageName::WebPage_PerformActionOnElements:
        return jsValueForDecodedMessage<MessageName::WebPage_PerformActionOnElements>(globalObject, decoder);
    case MessageName::WebPage_FocusNextFocusedElement:
        return jsValueForDecodedMessage<MessageName::WebPage_FocusNextFocusedElement>(globalObject, decoder);
    case MessageName::WebPage_AutofillLoginCredentials:
        return jsValueForDecodedMessage<MessageName::WebPage_AutofillLoginCredentials>(globalObject, decoder);
    case MessageName::WebPage_SetFocusedElementValue:
        return jsValueForDecodedMessage<MessageName::WebPage_SetFocusedElementValue>(globalObject, decoder);
    case MessageName::WebPage_SetFocusedElementSelectedIndex:
        return jsValueForDecodedMessage<MessageName::WebPage_SetFocusedElementSelectedIndex>(globalObject, decoder);
    case MessageName::WebPage_ApplicationWillResignActive:
        return jsValueForDecodedMessage<MessageName::WebPage_ApplicationWillResignActive>(globalObject, decoder);
    case MessageName::WebPage_ApplicationDidEnterBackground:
        return jsValueForDecodedMessage<MessageName::WebPage_ApplicationDidEnterBackground>(globalObject, decoder);
    case MessageName::WebPage_ApplicationDidFinishSnapshottingAfterEnteringBackground:
        return jsValueForDecodedMessage<MessageName::WebPage_ApplicationDidFinishSnapshottingAfterEnteringBackground>(globalObject, decoder);
    case MessageName::WebPage_ApplicationWillEnterForeground:
        return jsValueForDecodedMessage<MessageName::WebPage_ApplicationWillEnterForeground>(globalObject, decoder);
    case MessageName::WebPage_ApplicationDidBecomeActive:
        return jsValueForDecodedMessage<MessageName::WebPage_ApplicationDidBecomeActive>(globalObject, decoder);
    case MessageName::WebPage_ApplicationDidEnterBackgroundForMedia:
        return jsValueForDecodedMessage<MessageName::WebPage_ApplicationDidEnterBackgroundForMedia>(globalObject, decoder);
    case MessageName::WebPage_ApplicationWillEnterForegroundForMedia:
        return jsValueForDecodedMessage<MessageName::WebPage_ApplicationWillEnterForegroundForMedia>(globalObject, decoder);
    case MessageName::WebPage_ContentSizeCategoryDidChange:
        return jsValueForDecodedMessage<MessageName::WebPage_ContentSizeCategoryDidChange>(globalObject, decoder);
    case MessageName::WebPage_GetSelectionContext:
        return jsValueForDecodedMessage<MessageName::WebPage_GetSelectionContext>(globalObject, decoder);
    case MessageName::WebPage_SetAllowsMediaDocumentInlinePlayback:
        return jsValueForDecodedMessage<MessageName::WebPage_SetAllowsMediaDocumentInlinePlayback>(globalObject, decoder);
    case MessageName::WebPage_HandleTwoFingerTapAtPoint:
        return jsValueForDecodedMessage<MessageName::WebPage_HandleTwoFingerTapAtPoint>(globalObject, decoder);
    case MessageName::WebPage_SetForceAlwaysUserScalable:
        return jsValueForDecodedMessage<MessageName::WebPage_SetForceAlwaysUserScalable>(globalObject, decoder);
    case MessageName::WebPage_GetRectsForGranularityWithSelectionOffset:
        return jsValueForDecodedMessage<MessageName::WebPage_GetRectsForGranularityWithSelectionOffset>(globalObject, decoder);
    case MessageName::WebPage_GetRectsAtSelectionOffsetWithText:
        return jsValueForDecodedMessage<MessageName::WebPage_GetRectsAtSelectionOffsetWithText>(globalObject, decoder);
    case MessageName::WebPage_StoreSelectionForAccessibility:
        return jsValueForDecodedMessage<MessageName::WebPage_StoreSelectionForAccessibility>(globalObject, decoder);
    case MessageName::WebPage_StartAutoscrollAtPosition:
        return jsValueForDecodedMessage<MessageName::WebPage_StartAutoscrollAtPosition>(globalObject, decoder);
    case MessageName::WebPage_CancelAutoscroll:
        return jsValueForDecodedMessage<MessageName::WebPage_CancelAutoscroll>(globalObject, decoder);
    case MessageName::WebPage_RequestFocusedElementInformation:
        return jsValueForDecodedMessage<MessageName::WebPage_RequestFocusedElementInformation>(globalObject, decoder);
    case MessageName::WebPage_HardwareKeyboardAvailabilityChanged:
        return jsValueForDecodedMessage<MessageName::WebPage_HardwareKeyboardAvailabilityChanged>(globalObject, decoder);
    case MessageName::WebPage_SetIsShowingInputViewForFocusedElement:
        return jsValueForDecodedMessage<MessageName::WebPage_SetIsShowingInputViewForFocusedElement>(globalObject, decoder);
    case MessageName::WebPage_UpdateSelectionWithDelta:
        return jsValueForDecodedMessage<MessageName::WebPage_UpdateSelectionWithDelta>(globalObject, decoder);
    case MessageName::WebPage_RequestDocumentEditingContext:
        return jsValueForDecodedMessage<MessageName::WebPage_RequestDocumentEditingContext>(globalObject, decoder);
    case MessageName::WebPage_GenerateSyntheticEditingCommand:
        return jsValueForDecodedMessage<MessageName::WebPage_GenerateSyntheticEditingCommand>(globalObject, decoder);
    case MessageName::WebPage_SetShouldRevealCurrentSelectionAfterInsertion:
        return jsValueForDecodedMessage<MessageName::WebPage_SetShouldRevealCurrentSelectionAfterInsertion>(globalObject, decoder);
    case MessageName::WebPage_TextInputContextsInRect:
        return jsValueForDecodedMessage<MessageName::WebPage_TextInputContextsInRect>(globalObject, decoder);
    case MessageName::WebPage_FocusTextInputContextAndPlaceCaret:
        return jsValueForDecodedMessage<MessageName::WebPage_FocusTextInputContextAndPlaceCaret>(globalObject, decoder);
    case MessageName::WebPage_ClearServiceWorkerEntitlementOverride:
        return jsValueForDecodedMessage<MessageName::WebPage_ClearServiceWorkerEntitlementOverride>(globalObject, decoder);
#endif
    case MessageName::WebPage_ProcessWillSuspend:
        return jsValueForDecodedMessage<MessageName::WebPage_ProcessWillSuspend>(globalObject, decoder);
    case MessageName::WebPage_ProcessDidResume:
        return jsValueForDecodedMessage<MessageName::WebPage_ProcessDidResume>(globalObject, decoder);
    case MessageName::WebPage_RequestImageBitmap:
        return jsValueForDecodedMessage<MessageName::WebPage_RequestImageBitmap>(globalObject, decoder);
    case MessageName::WebPage_SetControlledByAutomation:
        return jsValueForDecodedMessage<MessageName::WebPage_SetControlledByAutomation>(globalObject, decoder);
    case MessageName::WebPage_ConnectInspector:
        return jsValueForDecodedMessage<MessageName::WebPage_ConnectInspector>(globalObject, decoder);
    case MessageName::WebPage_DisconnectInspector:
        return jsValueForDecodedMessage<MessageName::WebPage_DisconnectInspector>(globalObject, decoder);
    case MessageName::WebPage_SendMessageToTargetBackend:
        return jsValueForDecodedMessage<MessageName::WebPage_SendMessageToTargetBackend>(globalObject, decoder);
#if ENABLE(REMOTE_INSPECTOR)
    case MessageName::WebPage_SetIndicating:
        return jsValueForDecodedMessage<MessageName::WebPage_SetIndicating>(globalObject, decoder);
#endif
#if ENABLE(IOS_TOUCH_EVENTS)
    case MessageName::WebPage_DidBeginTouchPoint:
        return jsValueForDecodedMessage<MessageName::WebPage_DidBeginTouchPoint>(globalObject, decoder);
#endif
#if !ENABLE(IOS_TOUCH_EVENTS) && ENABLE(TOUCH_EVENTS)
    case MessageName::WebPage_TouchEvent:
        return jsValueForDecodedMessage<MessageName::WebPage_TouchEvent>(globalObject, decoder);
#endif
    case MessageName::WebPage_CancelPointer:
        return jsValueForDecodedMessage<MessageName::WebPage_CancelPointer>(globalObject, decoder);
    case MessageName::WebPage_TouchWithIdentifierWasRemoved:
        return jsValueForDecodedMessage<MessageName::WebPage_TouchWithIdentifierWasRemoved>(globalObject, decoder);
    case MessageName::WebPage_DidEndColorPicker:
        return jsValueForDecodedMessage<MessageName::WebPage_DidEndColorPicker>(globalObject, decoder);
    case MessageName::WebPage_DidChooseColor:
        return jsValueForDecodedMessage<MessageName::WebPage_DidChooseColor>(globalObject, decoder);
    case MessageName::WebPage_DidSelectDataListOption:
        return jsValueForDecodedMessage<MessageName::WebPage_DidSelectDataListOption>(globalObject, decoder);
    case MessageName::WebPage_DidCloseSuggestions:
        return jsValueForDecodedMessage<MessageName::WebPage_DidCloseSuggestions>(globalObject, decoder);
    case MessageName::WebPage_DidChooseDate:
        return jsValueForDecodedMessage<MessageName::WebPage_DidChooseDate>(globalObject, decoder);
    case MessageName::WebPage_DidEndDateTimePicker:
        return jsValueForDecodedMessage<MessageName::WebPage_DidEndDateTimePicker>(globalObject, decoder);
    case MessageName::WebPage_ScrollBy:
        return jsValueForDecodedMessage<MessageName::WebPage_ScrollBy>(globalObject, decoder);
    case MessageName::WebPage_CenterSelectionInVisibleArea:
        return jsValueForDecodedMessage<MessageName::WebPage_CenterSelectionInVisibleArea>(globalObject, decoder);
    case MessageName::WebPage_GoToBackForwardItem:
        return jsValueForDecodedMessage<MessageName::WebPage_GoToBackForwardItem>(globalObject, decoder);
    case MessageName::WebPage_GoToBackForwardItemWaitingForProcessLaunch:
        return jsValueForDecodedMessage<MessageName::WebPage_GoToBackForwardItemWaitingForProcessLaunch>(globalObject, decoder);
    case MessageName::WebPage_TryRestoreScrollPosition:
        return jsValueForDecodedMessage<MessageName::WebPage_TryRestoreScrollPosition>(globalObject, decoder);
    case MessageName::WebPage_LoadURLInFrame:
        return jsValueForDecodedMessage<MessageName::WebPage_LoadURLInFrame>(globalObject, decoder);
    case MessageName::WebPage_LoadDataInFrame:
        return jsValueForDecodedMessage<MessageName::WebPage_LoadDataInFrame>(globalObject, decoder);
    case MessageName::WebPage_LoadRequest:
        return jsValueForDecodedMessage<MessageName::WebPage_LoadRequest>(globalObject, decoder);
    case MessageName::WebPage_LoadDidCommitInAnotherProcess:
        return jsValueForDecodedMessage<MessageName::WebPage_LoadDidCommitInAnotherProcess>(globalObject, decoder);
    case MessageName::WebPage_LoadRequestWaitingForProcessLaunch:
        return jsValueForDecodedMessage<MessageName::WebPage_LoadRequestWaitingForProcessLaunch>(globalObject, decoder);
    case MessageName::WebPage_LoadData:
        return jsValueForDecodedMessage<MessageName::WebPage_LoadData>(globalObject, decoder);
    case MessageName::WebPage_LoadSimulatedRequestAndResponse:
        return jsValueForDecodedMessage<MessageName::WebPage_LoadSimulatedRequestAndResponse>(globalObject, decoder);
    case MessageName::WebPage_LoadAlternateHTML:
        return jsValueForDecodedMessage<MessageName::WebPage_LoadAlternateHTML>(globalObject, decoder);
    case MessageName::WebPage_CreateRemoteSubframe:
        return jsValueForDecodedMessage<MessageName::WebPage_CreateRemoteSubframe>(globalObject, decoder);
    case MessageName::WebPage_GetFrameTree:
        return jsValueForDecodedMessage<MessageName::WebPage_GetFrameTree>(globalObject, decoder);
    case MessageName::WebPage_DidFinishLoadInAnotherProcess:
        return jsValueForDecodedMessage<MessageName::WebPage_DidFinishLoadInAnotherProcess>(globalObject, decoder);
    case MessageName::WebPage_FrameWasRemovedInAnotherProcess:
        return jsValueForDecodedMessage<MessageName::WebPage_FrameWasRemovedInAnotherProcess>(globalObject, decoder);
    case MessageName::WebPage_UpdateFrameTreeSyncData:
        return jsValueForDecodedMessage<MessageName::WebPage_UpdateFrameTreeSyncData>(globalObject, decoder);
    case MessageName::WebPage_ProcessSyncDataChangedInAnotherProcess:
        return jsValueForDecodedMessage<MessageName::WebPage_ProcessSyncDataChangedInAnotherProcess>(globalObject, decoder);
    case MessageName::WebPage_TopDocumentSyncDataChangedInAnotherProcess:
        return jsValueForDecodedMessage<MessageName::WebPage_TopDocumentSyncDataChangedInAnotherProcess>(globalObject, decoder);
    case MessageName::WebPage_NavigateToPDFLinkWithSimulatedClick:
        return jsValueForDecodedMessage<MessageName::WebPage_NavigateToPDFLinkWithSimulatedClick>(globalObject, decoder);
    case MessageName::WebPage_GetPDFFirstPageSize:
        return jsValueForDecodedMessage<MessageName::WebPage_GetPDFFirstPageSize>(globalObject, decoder);
    case MessageName::WebPage_Reload:
        return jsValueForDecodedMessage<MessageName::WebPage_Reload>(globalObject, decoder);
    case MessageName::WebPage_StopLoading:
        return jsValueForDecodedMessage<MessageName::WebPage_StopLoading>(globalObject, decoder);
    case MessageName::WebPage_StopLoadingDueToProcessSwap:
        return jsValueForDecodedMessage<MessageName::WebPage_StopLoadingDueToProcessSwap>(globalObject, decoder);
    case MessageName::WebPage_SetCurrentHistoryItemForReattach:
        return jsValueForDecodedMessage<MessageName::WebPage_SetCurrentHistoryItemForReattach>(globalObject, decoder);
    case MessageName::WebPage_DidRemoveBackForwardItem:
        return jsValueForDecodedMessage<MessageName::WebPage_DidRemoveBackForwardItem>(globalObject, decoder);
    case MessageName::WebPage_UpdateWebsitePolicies:
        return jsValueForDecodedMessage<MessageName::WebPage_UpdateWebsitePolicies>(globalObject, decoder);
    case MessageName::WebPage_ClearSelection:
        return jsValueForDecodedMessage<MessageName::WebPage_ClearSelection>(globalObject, decoder);
    case MessageName::WebPage_RestoreSelectionInFocusedEditableElement:
        return jsValueForDecodedMessage<MessageName::WebPage_RestoreSelectionInFocusedEditableElement>(globalObject, decoder);
    case MessageName::WebPage_GetContentsAsString:
        return jsValueForDecodedMessage<MessageName::WebPage_GetContentsAsString>(globalObject, decoder);
#if PLATFORM(COCOA)
    case MessageName::WebPage_GetContentsAsAttributedString:
        return jsValueForDecodedMessage<MessageName::WebPage_GetContentsAsAttributedString>(globalObject, decoder);
#endif
#if ENABLE(MHTML)
    case MessageName::WebPage_GetContentsAsMHTMLData:
        return jsValueForDecodedMessage<MessageName::WebPage_GetContentsAsMHTMLData>(globalObject, decoder);
#endif
    case MessageName::WebPage_GetMainResourceDataOfFrame:
        return jsValueForDecodedMessage<MessageName::WebPage_GetMainResourceDataOfFrame>(globalObject, decoder);
    case MessageName::WebPage_GetResourceDataFromFrame:
        return jsValueForDecodedMessage<MessageName::WebPage_GetResourceDataFromFrame>(globalObject, decoder);
    case MessageName::WebPage_GetRenderTreeExternalRepresentation:
        return jsValueForDecodedMessage<MessageName::WebPage_GetRenderTreeExternalRepresentation>(globalObject, decoder);
    case MessageName::WebPage_GetSelectionOrContentsAsString:
        return jsValueForDecodedMessage<MessageName::WebPage_GetSelectionOrContentsAsString>(globalObject, decoder);
    case MessageName::WebPage_GetSelectionAsWebArchiveData:
        return jsValueForDecodedMessage<MessageName::WebPage_GetSelectionAsWebArchiveData>(globalObject, decoder);
    case MessageName::WebPage_GetSourceForFrame:
        return jsValueForDecodedMessage<MessageName::WebPage_GetSourceForFrame>(globalObject, decoder);
    case MessageName::WebPage_GetWebArchiveOfFrame:
        return jsValueForDecodedMessage<MessageName::WebPage_GetWebArchiveOfFrame>(globalObject, decoder);
    case MessageName::WebPage_GetWebArchiveOfFrameWithFileName:
        return jsValueForDecodedMessage<MessageName::WebPage_GetWebArchiveOfFrameWithFileName>(globalObject, decoder);
#if PLATFORM(COCOA)
    case MessageName::WebPage_GetWebArchives:
        return jsValueForDecodedMessage<MessageName::WebPage_GetWebArchives>(globalObject, decoder);
#endif
    case MessageName::WebPage_RunJavaScriptInFrameInScriptWorld:
        return jsValueForDecodedMessage<MessageName::WebPage_RunJavaScriptInFrameInScriptWorld>(globalObject, decoder);
    case MessageName::WebPage_GetAccessibilityTreeData:
        return jsValueForDecodedMessage<MessageName::WebPage_GetAccessibilityTreeData>(globalObject, decoder);
    case MessageName::WebPage_UpdateRenderingWithForcedRepaint:
        return jsValueForDecodedMessage<MessageName::WebPage_UpdateRenderingWithForcedRepaint>(globalObject, decoder);
    case MessageName::WebPage_SelectAll:
        return jsValueForDecodedMessage<MessageName::WebPage_SelectAll>(globalObject, decoder);
    case MessageName::WebPage_ScheduleFullEditorStateUpdate:
        return jsValueForDecodedMessage<MessageName::WebPage_ScheduleFullEditorStateUpdate>(globalObject, decoder);
#if PLATFORM(COCOA)
    case MessageName::WebPage_PerformDictionaryLookupAtLocation:
        return jsValueForDecodedMessage<MessageName::WebPage_PerformDictionaryLookupAtLocation>(globalObject, decoder);
#endif
#if ENABLE(DATA_DETECTION)
    case MessageName::WebPage_DetectDataInAllFrames:
        return jsValueForDecodedMessage<MessageName::WebPage_DetectDataInAllFrames>(globalObject, decoder);
    case MessageName::WebPage_RemoveDataDetectedLinks:
        return jsValueForDecodedMessage<MessageName::WebPage_RemoveDataDetectedLinks>(globalObject, decoder);
#endif
    case MessageName::WebPage_ChangeFont:
        return jsValueForDecodedMessage<MessageName::WebPage_ChangeFont>(globalObject, decoder);
    case MessageName::WebPage_ChangeFontAttributes:
        return jsValueForDecodedMessage<MessageName::WebPage_ChangeFontAttributes>(globalObject, decoder);
    case MessageName::WebPage_PreferencesDidChange:
        return jsValueForDecodedMessage<MessageName::WebPage_PreferencesDidChange>(globalObject, decoder);
    case MessageName::WebPage_PreferencesDidChangeDuringDOMPrintOperation:
        return jsValueForDecodedMessage<MessageName::WebPage_PreferencesDidChangeDuringDOMPrintOperation>(globalObject, decoder);
    case MessageName::WebPage_SetUserAgent:
        return jsValueForDecodedMessage<MessageName::WebPage_SetUserAgent>(globalObject, decoder);
    case MessageName::WebPage_SetHasCustomUserAgent:
        return jsValueForDecodedMessage<MessageName::WebPage_SetHasCustomUserAgent>(globalObject, decoder);
    case MessageName::WebPage_SetCustomTextEncodingName:
        return jsValueForDecodedMessage<MessageName::WebPage_SetCustomTextEncodingName>(globalObject, decoder);
    case MessageName::WebPage_SuspendActiveDOMObjectsAndAnimations:
        return jsValueForDecodedMessage<MessageName::WebPage_SuspendActiveDOMObjectsAndAnimations>(globalObject, decoder);
    case MessageName::WebPage_ResumeActiveDOMObjectsAndAnimations:
        return jsValueForDecodedMessage<MessageName::WebPage_ResumeActiveDOMObjectsAndAnimations>(globalObject, decoder);
    case MessageName::WebPage_Suspend:
        return jsValueForDecodedMessage<MessageName::WebPage_Suspend>(globalObject, decoder);
    case MessageName::WebPage_Resume:
        return jsValueForDecodedMessage<MessageName::WebPage_Resume>(globalObject, decoder);
    case MessageName::WebPage_Close:
        return jsValueForDecodedMessage<MessageName::WebPage_Close>(globalObject, decoder);
    case MessageName::WebPage_TryClose:
        return jsValueForDecodedMessage<MessageName::WebPage_TryClose>(globalObject, decoder);
    case MessageName::WebPage_SetEditable:
        return jsValueForDecodedMessage<MessageName::WebPage_SetEditable>(globalObject, decoder);
    case MessageName::WebPage_ValidateCommand:
        return jsValueForDecodedMessage<MessageName::WebPage_ValidateCommand>(globalObject, decoder);
    case MessageName::WebPage_ExecuteEditCommand:
        return jsValueForDecodedMessage<MessageName::WebPage_ExecuteEditCommand>(globalObject, decoder);
    case MessageName::WebPage_IncreaseListLevel:
        return jsValueForDecodedMessage<MessageName::WebPage_IncreaseListLevel>(globalObject, decoder);
    case MessageName::WebPage_DecreaseListLevel:
        return jsValueForDecodedMessage<MessageName::WebPage_DecreaseListLevel>(globalObject, decoder);
    case MessageName::WebPage_ChangeListType:
        return jsValueForDecodedMessage<MessageName::WebPage_ChangeListType>(globalObject, decoder);
    case MessageName::WebPage_SetBaseWritingDirection:
        return jsValueForDecodedMessage<MessageName::WebPage_SetBaseWritingDirection>(globalObject, decoder);
    case MessageName::WebPage_SetNeedsFontAttributes:
        return jsValueForDecodedMessage<MessageName::WebPage_SetNeedsFontAttributes>(globalObject, decoder);
    case MessageName::WebPage_RequestFontAttributesAtSelectionStart:
        return jsValueForDecodedMessage<MessageName::WebPage_RequestFontAttributesAtSelectionStart>(globalObject, decoder);
    case MessageName::WebPage_DidRemoveEditCommand:
        return jsValueForDecodedMessage<MessageName::WebPage_DidRemoveEditCommand>(globalObject, decoder);
    case MessageName::WebPage_ReapplyEditCommand:
        return jsValueForDecodedMessage<MessageName::WebPage_ReapplyEditCommand>(globalObject, decoder);
    case MessageName::WebPage_UnapplyEditCommand:
        return jsValueForDecodedMessage<MessageName::WebPage_UnapplyEditCommand>(globalObject, decoder);
    case MessageName::WebPage_DidSetPageZoomFactor:
        return jsValueForDecodedMessage<MessageName::WebPage_DidSetPageZoomFactor>(globalObject, decoder);
    case MessageName::WebPage_DidSetTextZoomFactor:
        return jsValueForDecodedMessage<MessageName::WebPage_DidSetTextZoomFactor>(globalObject, decoder);
    case MessageName::WebPage_WindowScreenDidChange:
        return jsValueForDecodedMessage<MessageName::WebPage_WindowScreenDidChange>(globalObject, decoder);
    case MessageName::WebPage_AccessibilitySettingsDidChange:
        return jsValueForDecodedMessage<MessageName::WebPage_AccessibilitySettingsDidChange>(globalObject, decoder);
    case MessageName::WebPage_DidScalePage:
        return jsValueForDecodedMessage<MessageName::WebPage_DidScalePage>(globalObject, decoder);
    case MessageName::WebPage_DidScalePageInViewCoordinates:
        return jsValueForDecodedMessage<MessageName::WebPage_DidScalePageInViewCoordinates>(globalObject, decoder);
    case MessageName::WebPage_DidScalePageRelativeToScrollPosition:
        return jsValueForDecodedMessage<MessageName::WebPage_DidScalePageRelativeToScrollPosition>(globalObject, decoder);
    case MessageName::WebPage_DidScaleView:
        return jsValueForDecodedMessage<MessageName::WebPage_DidScaleView>(globalObject, decoder);
    case MessageName::WebPage_SetUseFixedLayout:
        return jsValueForDecodedMessage<MessageName::WebPage_SetUseFixedLayout>(globalObject, decoder);
    case MessageName::WebPage_SetFixedLayoutSize:
        return jsValueForDecodedMessage<MessageName::WebPage_SetFixedLayoutSize>(globalObject, decoder);
    case MessageName::WebPage_SetDefaultUnobscuredSize:
        return jsValueForDecodedMessage<MessageName::WebPage_SetDefaultUnobscuredSize>(globalObject, decoder);
    case MessageName::WebPage_SetMinimumUnobscuredSize:
        return jsValueForDecodedMessage<MessageName::WebPage_SetMinimumUnobscuredSize>(globalObject, decoder);
    case MessageName::WebPage_SetMaximumUnobscuredSize:
        return jsValueForDecodedMessage<MessageName::WebPage_SetMaximumUnobscuredSize>(globalObject, decoder);
    case MessageName::WebPage_ListenForLayoutMilestones:
        return jsValueForDecodedMessage<MessageName::WebPage_ListenForLayoutMilestones>(globalObject, decoder);
    case MessageName::WebPage_SetSuppressScrollbarAnimations:
        return jsValueForDecodedMessage<MessageName::WebPage_SetSuppressScrollbarAnimations>(globalObject, decoder);
    case MessageName::WebPage_SetEnableVerticalRubberBanding:
        return jsValueForDecodedMessage<MessageName::WebPage_SetEnableVerticalRubberBanding>(globalObject, decoder);
    case MessageName::WebPage_SetEnableHorizontalRubberBanding:
        return jsValueForDecodedMessage<MessageName::WebPage_SetEnableHorizontalRubberBanding>(globalObject, decoder);
    case MessageName::WebPage_SetBackgroundExtendsBeyondPage:
        return jsValueForDecodedMessage<MessageName::WebPage_SetBackgroundExtendsBeyondPage>(globalObject, decoder);
    case MessageName::WebPage_SetPaginationMode:
        return jsValueForDecodedMessage<MessageName::WebPage_SetPaginationMode>(globalObject, decoder);
    case MessageName::WebPage_SetPaginationBehavesLikeColumns:
        return jsValueForDecodedMessage<MessageName::WebPage_SetPaginationBehavesLikeColumns>(globalObject, decoder);
    case MessageName::WebPage_SetPageLength:
        return jsValueForDecodedMessage<MessageName::WebPage_SetPageLength>(globalObject, decoder);
    case MessageName::WebPage_SetGapBetweenPages:
        return jsValueForDecodedMessage<MessageName::WebPage_SetGapBetweenPages>(globalObject, decoder);
    case MessageName::WebPage_PostInjectedBundleMessage:
        return jsValueForDecodedMessage<MessageName::WebPage_PostInjectedBundleMessage>(globalObject, decoder);
    case MessageName::WebPage_FindString:
        return jsValueForDecodedMessage<MessageName::WebPage_FindString>(globalObject, decoder);
#if ENABLE(IMAGE_ANALYSIS)
    case MessageName::WebPage_FindStringIncludingImages:
        return jsValueForDecodedMessage<MessageName::WebPage_FindStringIncludingImages>(globalObject, decoder);
#endif
    case MessageName::WebPage_FindStringMatches:
        return jsValueForDecodedMessage<MessageName::WebPage_FindStringMatches>(globalObject, decoder);
    case MessageName::WebPage_GetImageForFindMatch:
        return jsValueForDecodedMessage<MessageName::WebPage_GetImageForFindMatch>(globalObject, decoder);
    case MessageName::WebPage_SelectFindMatch:
        return jsValueForDecodedMessage<MessageName::WebPage_SelectFindMatch>(globalObject, decoder);
    case MessageName::WebPage_IndicateFindMatch:
        return jsValueForDecodedMessage<MessageName::WebPage_IndicateFindMatch>(globalObject, decoder);
    case MessageName::WebPage_HideFindUI:
        return jsValueForDecodedMessage<MessageName::WebPage_HideFindUI>(globalObject, decoder);
    case MessageName::WebPage_CountStringMatches:
        return jsValueForDecodedMessage<MessageName::WebPage_CountStringMatches>(globalObject, decoder);
    case MessageName::WebPage_ReplaceMatches:
        return jsValueForDecodedMessage<MessageName::WebPage_ReplaceMatches>(globalObject, decoder);
    case MessageName::WebPage_FindRectsForStringMatches:
        return jsValueForDecodedMessage<MessageName::WebPage_FindRectsForStringMatches>(globalObject, decoder);
    case MessageName::WebPage_FindTextRangesForStringMatches:
        return jsValueForDecodedMessage<MessageName::WebPage_FindTextRangesForStringMatches>(globalObject, decoder);
    case MessageName::WebPage_ReplaceFoundTextRangeWithString:
        return jsValueForDecodedMessage<MessageName::WebPage_ReplaceFoundTextRangeWithString>(globalObject, decoder);
    case MessageName::WebPage_DecorateTextRangeWithStyle:
        return jsValueForDecodedMessage<MessageName::WebPage_DecorateTextRangeWithStyle>(globalObject, decoder);
    case MessageName::WebPage_ScrollTextRangeToVisible:
        return jsValueForDecodedMessage<MessageName::WebPage_ScrollTextRangeToVisible>(globalObject, decoder);
    case MessageName::WebPage_ClearAllDecoratedFoundText:
        return jsValueForDecodedMessage<MessageName::WebPage_ClearAllDecoratedFoundText>(globalObject, decoder);
    case MessageName::WebPage_DidBeginTextSearchOperation:
        return jsValueForDecodedMessage<MessageName::WebPage_DidBeginTextSearchOperation>(globalObject, decoder);
    case MessageName::WebPage_RequestRectForFoundTextRange:
        return jsValueForDecodedMessage<MessageName::WebPage_RequestRectForFoundTextRange>(globalObject, decoder);
    case MessageName::WebPage_AddLayerForFindOverlay:
        return jsValueForDecodedMessage<MessageName::WebPage_AddLayerForFindOverlay>(globalObject, decoder);
    case MessageName::WebPage_RemoveLayerForFindOverlay:
        return jsValueForDecodedMessage<MessageName::WebPage_RemoveLayerForFindOverlay>(globalObject, decoder);
#if PLATFORM(GTK) && ENABLE(DRAG_SUPPORT)
    case MessageName::WebPage_PerformDragControllerAction:
        return jsValueForDecodedMessage<MessageName::WebPage_PerformDragControllerAction>(globalObject, decoder);
#endif
#if !PLATFORM(GTK) && ENABLE(DRAG_SUPPORT)
    case MessageName::WebPage_PerformDragControllerAction:
        return jsValueForDecodedMessage<MessageName::WebPage_PerformDragControllerAction>(globalObject, decoder);
    case MessageName::WebPage_PerformDragOperation:
        return jsValueForDecodedMessage<MessageName::WebPage_PerformDragOperation>(globalObject, decoder);
#endif
#if ENABLE(DRAG_SUPPORT)
    case MessageName::WebPage_DidStartDrag:
        return jsValueForDecodedMessage<MessageName::WebPage_DidStartDrag>(globalObject, decoder);
    case MessageName::WebPage_DragEnded:
        return jsValueForDecodedMessage<MessageName::WebPage_DragEnded>(globalObject, decoder);
    case MessageName::WebPage_DragCancelled:
        return jsValueForDecodedMessage<MessageName::WebPage_DragCancelled>(globalObject, decoder);
#endif
#if ENABLE(MODEL_PROCESS)
    case MessageName::WebPage_RequestInteractiveModelElementAtPoint:
        return jsValueForDecodedMessage<MessageName::WebPage_RequestInteractiveModelElementAtPoint>(globalObject, decoder);
    case MessageName::WebPage_StageModeSessionDidUpdate:
        return jsValueForDecodedMessage<MessageName::WebPage_StageModeSessionDidUpdate>(globalObject, decoder);
    case MessageName::WebPage_StageModeSessionDidEnd:
        return jsValueForDecodedMessage<MessageName::WebPage_StageModeSessionDidEnd>(globalObject, decoder);
#endif
#if ENABLE(MODEL_PROCESS) && ENABLE(DRAG_SUPPORT)
    case MessageName::WebPage_ModelDragEnded:
        return jsValueForDecodedMessage<MessageName::WebPage_ModelDragEnded>(globalObject, decoder);
#endif
#if PLATFORM(IOS_FAMILY) && ENABLE(DRAG_SUPPORT)
    case MessageName::WebPage_RequestDragStart:
        return jsValueForDecodedMessage<MessageName::WebPage_RequestDragStart>(globalObject, decoder);
    case MessageName::WebPage_RequestAdditionalItemsForDragSession:
        return jsValueForDecodedMessage<MessageName::WebPage_RequestAdditionalItemsForDragSession>(globalObject, decoder);
    case MessageName::WebPage_InsertDroppedImagePlaceholders:
        return jsValueForDecodedMessage<MessageName::WebPage_InsertDroppedImagePlaceholders>(globalObject, decoder);
    case MessageName::WebPage_DidConcludeDrop:
        return jsValueForDecodedMessage<MessageName::WebPage_DidConcludeDrop>(globalObject, decoder);
#endif
#if PLATFORM(COCOA)
    case MessageName::WebPage_InsertTextPlaceholder:
        return jsValueForDecodedMessage<MessageName::WebPage_InsertTextPlaceholder>(globalObject, decoder);
    case MessageName::WebPage_RemoveTextPlaceholder:
        return jsValueForDecodedMessage<MessageName::WebPage_RemoveTextPlaceholder>(globalObject, decoder);
#endif
    case MessageName::WebPage_DidChangeSelectedIndexForActivePopupMenu:
        return jsValueForDecodedMessage<MessageName::WebPage_DidChangeSelectedIndexForActivePopupMenu>(globalObject, decoder);
    case MessageName::WebPage_SetTextForActivePopupMenu:
        return jsValueForDecodedMessage<MessageName::WebPage_SetTextForActivePopupMenu>(globalObject, decoder);
#if PLATFORM(GTK)
    case MessageName::WebPage_FailedToShowPopupMenu:
        return jsValueForDecodedMessage<MessageName::WebPage_FailedToShowPopupMenu>(globalObject, decoder);
#endif
#if ENABLE(CONTEXT_MENUS)
    case MessageName::WebPage_DidDismissContextMenu:
        return jsValueForDecodedMessage<MessageName::WebPage_DidDismissContextMenu>(globalObject, decoder);
    case MessageName::WebPage_DidSelectItemFromActiveContextMenu:
        return jsValueForDecodedMessage<MessageName::WebPage_DidSelectItemFromActiveContextMenu>(globalObject, decoder);
    case MessageName::WebPage_ContextMenuForKeyEvent:
        return jsValueForDecodedMessage<MessageName::WebPage_ContextMenuForKeyEvent>(globalObject, decoder);
#endif
#if PLATFORM(IOS_FAMILY)
    case MessageName::WebPage_DidChooseFilesForOpenPanelWithDisplayStringAndIcon:
        return jsValueForDecodedMessage<MessageName::WebPage_DidChooseFilesForOpenPanelWithDisplayStringAndIcon>(globalObject, decoder);
#endif
    case MessageName::WebPage_DidChooseFilesForOpenPanel:
        return jsValueForDecodedMessage<MessageName::WebPage_DidChooseFilesForOpenPanel>(globalObject, decoder);
    case MessageName::WebPage_DidCancelForOpenPanel:
        return jsValueForDecodedMessage<MessageName::WebPage_DidCancelForOpenPanel>(globalObject, decoder);
#if ENABLE(SANDBOX_EXTENSIONS)
    case MessageName::WebPage_ExtendSandboxForFilesFromOpenPanel:
        return jsValueForDecodedMessage<MessageName::WebPage_ExtendSandboxForFilesFromOpenPanel>(globalObject, decoder);
#endif
    case MessageName::WebPage_AdvanceToNextMisspelling:
        return jsValueForDecodedMessage<MessageName::WebPage_AdvanceToNextMisspelling>(globalObject, decoder);
    case MessageName::WebPage_ChangeSpellingToWord:
        return jsValueForDecodedMessage<MessageName::WebPage_ChangeSpellingToWord>(globalObject, decoder);
    case MessageName::WebPage_DidFinishCheckingText:
        return jsValueForDecodedMessage<MessageName::WebPage_DidFinishCheckingText>(globalObject, decoder);
    case MessageName::WebPage_DidCancelCheckingText:
        return jsValueForDecodedMessage<MessageName::WebPage_DidCancelCheckingText>(globalObject, decoder);
#if USE(APPKIT)
    case MessageName::WebPage_UppercaseWord:
        return jsValueForDecodedMessage<MessageName::WebPage_UppercaseWord>(globalObject, decoder);
    case MessageName::WebPage_LowercaseWord:
        return jsValueForDecodedMessage<MessageName::WebPage_LowercaseWord>(globalObject, decoder);
    case MessageName::WebPage_CapitalizeWord:
        return jsValueForDecodedMessage<MessageName::WebPage_CapitalizeWord>(globalObject, decoder);
#endif
#if PLATFORM(COCOA)
    case MessageName::WebPage_SetSmartInsertDeleteEnabled:
        return jsValueForDecodedMessage<MessageName::WebPage_SetSmartInsertDeleteEnabled>(globalObject, decoder);
#endif
#if ENABLE(GEOLOCATION)
    case MessageName::WebPage_DidReceiveGeolocationPermissionDecision:
        return jsValueForDecodedMessage<MessageName::WebPage_DidReceiveGeolocationPermissionDecision>(globalObject, decoder);
#endif
#if ENABLE(MEDIA_STREAM)
    case MessageName::WebPage_UserMediaAccessWasGranted:
        return jsValueForDecodedMessage<MessageName::WebPage_UserMediaAccessWasGranted>(globalObject, decoder);
    case MessageName::WebPage_UserMediaAccessWasDenied:
        return jsValueForDecodedMessage<MessageName::WebPage_UserMediaAccessWasDenied>(globalObject, decoder);
    case MessageName::WebPage_CaptureDevicesChanged:
        return jsValueForDecodedMessage<MessageName::WebPage_CaptureDevicesChanged>(globalObject, decoder);
    case MessageName::WebPage_VoiceActivityDetected:
        return jsValueForDecodedMessage<MessageName::WebPage_VoiceActivityDetected>(globalObject, decoder);
#endif
#if (ENABLE(MEDIA_STREAM) && USE(GSTREAMER))
    case MessageName::WebPage_SetOrientationForMediaCapture:
        return jsValueForDecodedMessage<MessageName::WebPage_SetOrientationForMediaCapture>(globalObject, decoder);
    case MessageName::WebPage_SetMockCaptureDevicesInterrupted:
        return jsValueForDecodedMessage<MessageName::WebPage_SetMockCaptureDevicesInterrupted>(globalObject, decoder);
    case MessageName::WebPage_TriggerMockCaptureConfigurationChange:
        return jsValueForDecodedMessage<MessageName::WebPage_TriggerMockCaptureConfigurationChange>(globalObject, decoder);
#endif
#if ENABLE(ENCRYPTED_MEDIA)
    case MessageName::WebPage_MediaKeySystemWasGranted:
        return jsValueForDecodedMessage<MessageName::WebPage_MediaKeySystemWasGranted>(globalObject, decoder);
    case MessageName::WebPage_MediaKeySystemWasDenied:
        return jsValueForDecodedMessage<MessageName::WebPage_MediaKeySystemWasDenied>(globalObject, decoder);
#endif
    case MessageName::WebPage_RequestMediaPlaybackState:
        return jsValueForDecodedMessage<MessageName::WebPage_RequestMediaPlaybackState>(globalObject, decoder);
    case MessageName::WebPage_PauseAllMediaPlayback:
        return jsValueForDecodedMessage<MessageName::WebPage_PauseAllMediaPlayback>(globalObject, decoder);
    case MessageName::WebPage_SuspendAllMediaPlayback:
        return jsValueForDecodedMessage<MessageName::WebPage_SuspendAllMediaPlayback>(globalObject, decoder);
    case MessageName::WebPage_ResumeAllMediaPlayback:
        return jsValueForDecodedMessage<MessageName::WebPage_ResumeAllMediaPlayback>(globalObject, decoder);
    case MessageName::WebPage_SwipeAnimationDidStart:
        return jsValueForDecodedMessage<MessageName::WebPage_SwipeAnimationDidStart>(globalObject, decoder);
    case MessageName::WebPage_SwipeAnimationDidEnd:
        return jsValueForDecodedMessage<MessageName::WebPage_SwipeAnimationDidEnd>(globalObject, decoder);
    case MessageName::WebPage_BeginPrinting:
        return jsValueForDecodedMessage<MessageName::WebPage_BeginPrinting>(globalObject, decoder);
    case MessageName::WebPage_BeginPrintingDuringDOMPrintOperation:
        return jsValueForDecodedMessage<MessageName::WebPage_BeginPrintingDuringDOMPrintOperation>(globalObject, decoder);
    case MessageName::WebPage_EndPrinting:
        return jsValueForDecodedMessage<MessageName::WebPage_EndPrinting>(globalObject, decoder);
    case MessageName::WebPage_EndPrintingDuringDOMPrintOperation:
        return jsValueForDecodedMessage<MessageName::WebPage_EndPrintingDuringDOMPrintOperation>(globalObject, decoder);
    case MessageName::WebPage_ComputePagesForPrinting:
        return jsValueForDecodedMessage<MessageName::WebPage_ComputePagesForPrinting>(globalObject, decoder);
    case MessageName::WebPage_ComputePagesForPrintingDuringDOMPrintOperation:
        return jsValueForDecodedMessage<MessageName::WebPage_ComputePagesForPrintingDuringDOMPrintOperation>(globalObject, decoder);
#if PLATFORM(COCOA)
    case MessageName::WebPage_DrawRectToImage:
        return jsValueForDecodedMessage<MessageName::WebPage_DrawRectToImage>(globalObject, decoder);
    case MessageName::WebPage_DrawRectToImageDuringDOMPrintOperation:
        return jsValueForDecodedMessage<MessageName::WebPage_DrawRectToImageDuringDOMPrintOperation>(globalObject, decoder);
    case MessageName::WebPage_DrawPagesToPDF:
        return jsValueForDecodedMessage<MessageName::WebPage_DrawPagesToPDF>(globalObject, decoder);
    case MessageName::WebPage_DrawPagesToPDFDuringDOMPrintOperation:
        return jsValueForDecodedMessage<MessageName::WebPage_DrawPagesToPDFDuringDOMPrintOperation>(globalObject, decoder);
#endif
#if (PLATFORM(COCOA) && PLATFORM(IOS_FAMILY))
    case MessageName::WebPage_ComputePagesForPrintingiOS:
        return jsValueForDecodedMessage<MessageName::WebPage_ComputePagesForPrintingiOS>(globalObject, decoder);
    case MessageName::WebPage_DrawToPDFiOS:
        return jsValueForDecodedMessage<MessageName::WebPage_DrawToPDFiOS>(globalObject, decoder);
    case MessageName::WebPage_DrawToImage:
        return jsValueForDecodedMessage<MessageName::WebPage_DrawToImage>(globalObject, decoder);
#endif
#if PLATFORM(COCOA)
    case MessageName::WebPage_DrawToPDF:
        return jsValueForDecodedMessage<MessageName::WebPage_DrawToPDF>(globalObject, decoder);
    case MessageName::WebPage_DrawRemoteToPDF:
        return jsValueForDecodedMessage<MessageName::WebPage_DrawRemoteToPDF>(globalObject, decoder);
#endif
#if PLATFORM(GTK)
    case MessageName::WebPage_DrawPagesForPrinting:
        return jsValueForDecodedMessage<MessageName::WebPage_DrawPagesForPrinting>(globalObject, decoder);
    case MessageName::WebPage_DrawPagesForPrintingDuringDOMPrintOperation:
        return jsValueForDecodedMessage<MessageName::WebPage_DrawPagesForPrintingDuringDOMPrintOperation>(globalObject, decoder);
#endif
    case MessageName::WebPage_SetMediaVolume:
        return jsValueForDecodedMessage<MessageName::WebPage_SetMediaVolume>(globalObject, decoder);
    case MessageName::WebPage_SetMuted:
        return jsValueForDecodedMessage<MessageName::WebPage_SetMuted>(globalObject, decoder);
    case MessageName::WebPage_SetMayStartMediaWhenInWindow:
        return jsValueForDecodedMessage<MessageName::WebPage_SetMayStartMediaWhenInWindow>(globalObject, decoder);
    case MessageName::WebPage_StopMediaCapture:
        return jsValueForDecodedMessage<MessageName::WebPage_StopMediaCapture>(globalObject, decoder);
    case MessageName::WebPage_SetCanRunBeforeUnloadConfirmPanel:
        return jsValueForDecodedMessage<MessageName::WebPage_SetCanRunBeforeUnloadConfirmPanel>(globalObject, decoder);
    case MessageName::WebPage_SetCanRunModal:
        return jsValueForDecodedMessage<MessageName::WebPage_SetCanRunModal>(globalObject, decoder);
#if PLATFORM(GTK) || PLATFORM(WPE)
    case MessageName::WebPage_CancelComposition:
        return jsValueForDecodedMessage<MessageName::WebPage_CancelComposition>(globalObject, decoder);
    case MessageName::WebPage_DeleteSurrounding:
        return jsValueForDecodedMessage<MessageName::WebPage_DeleteSurrounding>(globalObject, decoder);
#endif
#if PLATFORM(GTK)
    case MessageName::WebPage_CollapseSelectionInFrame:
        return jsValueForDecodedMessage<MessageName::WebPage_CollapseSelectionInFrame>(globalObject, decoder);
#endif
    case MessageName::WebPage_CopyLinkWithHighlight:
        return jsValueForDecodedMessage<MessageName::WebPage_CopyLinkWithHighlight>(globalObject, decoder);
    case MessageName::WebPage_BindRemoteAccessibilityFrames:
        return jsValueForDecodedMessage<MessageName::WebPage_BindRemoteAccessibilityFrames>(globalObject, decoder);
    case MessageName::WebPage_UpdateRemotePageAccessibilityOffset:
        return jsValueForDecodedMessage<MessageName::WebPage_UpdateRemotePageAccessibilityOffset>(globalObject, decoder);
    case MessageName::WebPage_ResolveAccessibilityHitTestForTesting:
        return jsValueForDecodedMessage<MessageName::WebPage_ResolveAccessibilityHitTestForTesting>(globalObject, decoder);
    case MessageName::WebPage_EnableAccessibility:
        return jsValueForDecodedMessage<MessageName::WebPage_EnableAccessibility>(globalObject, decoder);
#if PLATFORM(MAC)
    case MessageName::WebPage_GetAccessibilityWebProcessDebugInfo:
        return jsValueForDecodedMessage<MessageName::WebPage_GetAccessibilityWebProcessDebugInfo>(globalObject, decoder);
#endif
#if (PLATFORM(MAC) && ENABLE(ACCESSIBILITY_ISOLATED_TREE))
    case MessageName::WebPage_ClearAccessibilityIsolatedTree:
        return jsValueForDecodedMessage<MessageName::WebPage_ClearAccessibilityIsolatedTree>(globalObject, decoder);
#endif
#if PLATFORM(COCOA)
    case MessageName::WebPage_WindowAndViewFramesChanged:
        return jsValueForDecodedMessage<MessageName::WebPage_WindowAndViewFramesChanged>(globalObject, decoder);
    case MessageName::WebPage_SetMainFrameIsScrollable:
        return jsValueForDecodedMessage<MessageName::WebPage_SetMainFrameIsScrollable>(globalObject, decoder);
    case MessageName::WebPage_RegisterUIProcessAccessibilityTokens:
        return jsValueForDecodedMessage<MessageName::WebPage_RegisterUIProcessAccessibilityTokens>(globalObject, decoder);
    case MessageName::WebPage_GetStringSelectionForPasteboard:
        return jsValueForDecodedMessage<MessageName::WebPage_GetStringSelectionForPasteboard>(globalObject, decoder);
    case MessageName::WebPage_GetDataSelectionForPasteboard:
        return jsValueForDecodedMessage<MessageName::WebPage_GetDataSelectionForPasteboard>(globalObject, decoder);
    case MessageName::WebPage_ReadSelectionFromPasteboard:
        return jsValueForDecodedMessage<MessageName::WebPage_ReadSelectionFromPasteboard>(globalObject, decoder);
    case MessageName::WebPage_ReplaceSelectionWithPasteboardData:
        return jsValueForDecodedMessage<MessageName::WebPage_ReplaceSelectionWithPasteboardData>(globalObject, decoder);
#endif
#if (PLATFORM(COCOA) && ENABLE(MULTI_REPRESENTATION_HEIC))
    case MessageName::WebPage_InsertMultiRepresentationHEIC:
        return jsValueForDecodedMessage<MessageName::WebPage_InsertMultiRepresentationHEIC>(globalObject, decoder);
#endif
#if PLATFORM(COCOA)
    case MessageName::WebPage_ShouldDelayWindowOrderingEvent:
        return jsValueForDecodedMessage<MessageName::WebPage_ShouldDelayWindowOrderingEvent>(globalObject, decoder);
    case MessageName::WebPage_SetTextAsync:
        return jsValueForDecodedMessage<MessageName::WebPage_SetTextAsync>(globalObject, decoder);
    case MessageName::WebPage_InsertTextAsync:
        return jsValueForDecodedMessage<MessageName::WebPage_InsertTextAsync>(globalObject, decoder);
    case MessageName::WebPage_InsertDictatedTextAsync:
        return jsValueForDecodedMessage<MessageName::WebPage_InsertDictatedTextAsync>(globalObject, decoder);
    case MessageName::WebPage_AddDictationAlternative:
        return jsValueForDecodedMessage<MessageName::WebPage_AddDictationAlternative>(globalObject, decoder);
    case MessageName::WebPage_DictationAlternativesAtSelection:
        return jsValueForDecodedMessage<MessageName::WebPage_DictationAlternativesAtSelection>(globalObject, decoder);
    case MessageName::WebPage_ClearDictationAlternatives:
        return jsValueForDecodedMessage<MessageName::WebPage_ClearDictationAlternatives>(globalObject, decoder);
    case MessageName::WebPage_HasMarkedText:
        return jsValueForDecodedMessage<MessageName::WebPage_HasMarkedText>(globalObject, decoder);
    case MessageName::WebPage_GetMarkedRangeAsync:
        return jsValueForDecodedMessage<MessageName::WebPage_GetMarkedRangeAsync>(globalObject, decoder);
    case MessageName::WebPage_GetSelectedRangeAsync:
        return jsValueForDecodedMessage<MessageName::WebPage_GetSelectedRangeAsync>(globalObject, decoder);
    case MessageName::WebPage_CharacterIndexForPointAsync:
        return jsValueForDecodedMessage<MessageName::WebPage_CharacterIndexForPointAsync>(globalObject, decoder);
    case MessageName::WebPage_FirstRectForCharacterRangeAsync:
        return jsValueForDecodedMessage<MessageName::WebPage_FirstRectForCharacterRangeAsync>(globalObject, decoder);
    case MessageName::WebPage_SetCompositionAsync:
        return jsValueForDecodedMessage<MessageName::WebPage_SetCompositionAsync>(globalObject, decoder);
    case MessageName::WebPage_SetWritingSuggestion:
        return jsValueForDecodedMessage<MessageName::WebPage_SetWritingSuggestion>(globalObject, decoder);
    case MessageName::WebPage_ConfirmCompositionAsync:
        return jsValueForDecodedMessage<MessageName::WebPage_ConfirmCompositionAsync>(globalObject, decoder);
#endif
#if PLATFORM(MAC)
    case MessageName::WebPage_AttributedSubstringForCharacterRangeAsync:
        return jsValueForDecodedMessage<MessageName::WebPage_AttributedSubstringForCharacterRangeAsync>(globalObject, decoder);
    case MessageName::WebPage_RequestAcceptsFirstMouse:
        return jsValueForDecodedMessage<MessageName::WebPage_RequestAcceptsFirstMouse>(globalObject, decoder);
    case MessageName::WebPage_SetCaretAnimatorType:
        return jsValueForDecodedMessage<MessageName::WebPage_SetCaretAnimatorType>(globalObject, decoder);
    case MessageName::WebPage_SetCaretBlinkingSuspended:
        return jsValueForDecodedMessage<MessageName::WebPage_SetCaretBlinkingSuspended>(globalObject, decoder);
#endif
#if ENABLE(IMAGE_ANALYSIS_ENHANCEMENTS)
    case MessageName::WebPage_ReplaceImageForRemoveBackground:
        return jsValueForDecodedMessage<MessageName::WebPage_ReplaceImageForRemoveBackground>(globalObject, decoder);
    case MessageName::WebPage_ShouldAllowRemoveBackground:
        return jsValueForDecodedMessage<MessageName::WebPage_ShouldAllowRemoveBackground>(globalObject, decoder);
#endif
    case MessageName::WebPage_SetAlwaysShowsHorizontalScroller:
        return jsValueForDecodedMessage<MessageName::WebPage_SetAlwaysShowsHorizontalScroller>(globalObject, decoder);
    case MessageName::WebPage_SetAlwaysShowsVerticalScroller:
        return jsValueForDecodedMessage<MessageName::WebPage_SetAlwaysShowsVerticalScroller>(globalObject, decoder);
    case MessageName::WebPage_SetMinimumSizeForAutoLayout:
        return jsValueForDecodedMessage<MessageName::WebPage_SetMinimumSizeForAutoLayout>(globalObject, decoder);
    case MessageName::WebPage_SetSizeToContentAutoSizeMaximumSize:
        return jsValueForDecodedMessage<MessageName::WebPage_SetSizeToContentAutoSizeMaximumSize>(globalObject, decoder);
    case MessageName::WebPage_SetAutoSizingShouldExpandToViewHeight:
        return jsValueForDecodedMessage<MessageName::WebPage_SetAutoSizingShouldExpandToViewHeight>(globalObject, decoder);
    case MessageName::WebPage_SetViewportSizeForCSSViewportUnits:
        return jsValueForDecodedMessage<MessageName::WebPage_SetViewportSizeForCSSViewportUnits>(globalObject, decoder);
#if PLATFORM(COCOA)
    case MessageName::WebPage_HandleAlternativeTextUIResult:
        return jsValueForDecodedMessage<MessageName::WebPage_HandleAlternativeTextUIResult>(globalObject, decoder);
#endif
#if PLATFORM(IOS_FAMILY)
    case MessageName::WebPage_WillStartUserTriggeredZooming:
        return jsValueForDecodedMessage<MessageName::WebPage_WillStartUserTriggeredZooming>(globalObject, decoder);
    case MessageName::WebPage_DidEndUserTriggeredZooming:
        return jsValueForDecodedMessage<MessageName::WebPage_DidEndUserTriggeredZooming>(globalObject, decoder);
#endif
    case MessageName::WebPage_SetScrollPinningBehavior:
        return jsValueForDecodedMessage<MessageName::WebPage_SetScrollPinningBehavior>(globalObject, decoder);
    case MessageName::WebPage_SetScrollbarOverlayStyle:
        return jsValueForDecodedMessage<MessageName::WebPage_SetScrollbarOverlayStyle>(globalObject, decoder);
    case MessageName::WebPage_GetBytecodeProfile:
        return jsValueForDecodedMessage<MessageName::WebPage_GetBytecodeProfile>(globalObject, decoder);
    case MessageName::WebPage_GetSamplingProfilerOutput:
        return jsValueForDecodedMessage<MessageName::WebPage_GetSamplingProfilerOutput>(globalObject, decoder);
    case MessageName::WebPage_TakeSnapshot:
        return jsValueForDecodedMessage<MessageName::WebPage_TakeSnapshot>(globalObject, decoder);
#if PLATFORM(MAC)
    case MessageName::WebPage_PerformImmediateActionHitTestAtLocation:
        return jsValueForDecodedMessage<MessageName::WebPage_PerformImmediateActionHitTestAtLocation>(globalObject, decoder);
    case MessageName::WebPage_ImmediateActionDidUpdate:
        return jsValueForDecodedMessage<MessageName::WebPage_ImmediateActionDidUpdate>(globalObject, decoder);
    case MessageName::WebPage_ImmediateActionDidCancel:
        return jsValueForDecodedMessage<MessageName::WebPage_ImmediateActionDidCancel>(globalObject, decoder);
    case MessageName::WebPage_ImmediateActionDidComplete:
        return jsValueForDecodedMessage<MessageName::WebPage_ImmediateActionDidComplete>(globalObject, decoder);
    case MessageName::WebPage_DataDetectorsDidPresentUI:
        return jsValueForDecodedMessage<MessageName::WebPage_DataDetectorsDidPresentUI>(globalObject, decoder);
    case MessageName::WebPage_DataDetectorsDidChangeUI:
        return jsValueForDecodedMessage<MessageName::WebPage_DataDetectorsDidChangeUI>(globalObject, decoder);
    case MessageName::WebPage_DataDetectorsDidHideUI:
        return jsValueForDecodedMessage<MessageName::WebPage_DataDetectorsDidHideUI>(globalObject, decoder);
    case MessageName::WebPage_HandleAcceptedCandidate:
        return jsValueForDecodedMessage<MessageName::WebPage_HandleAcceptedCandidate>(globalObject, decoder);
    case MessageName::WebPage_SemanticContextDidChange:
        return jsValueForDecodedMessage<MessageName::WebPage_SemanticContextDidChange>(globalObject, decoder);
    case MessageName::WebPage_SetHeaderBannerHeight:
        return jsValueForDecodedMessage<MessageName::WebPage_SetHeaderBannerHeight>(globalObject, decoder);
    case MessageName::WebPage_SetFooterBannerHeight:
        return jsValueForDecodedMessage<MessageName::WebPage_SetFooterBannerHeight>(globalObject, decoder);
    case MessageName::WebPage_DidBeginMagnificationGesture:
        return jsValueForDecodedMessage<MessageName::WebPage_DidBeginMagnificationGesture>(globalObject, decoder);
    case MessageName::WebPage_DidEndMagnificationGesture:
        return jsValueForDecodedMessage<MessageName::WebPage_DidEndMagnificationGesture>(globalObject, decoder);
#endif
    case MessageName::WebPage_StartDeferringResizeEvents:
        return jsValueForDecodedMessage<MessageName::WebPage_StartDeferringResizeEvents>(globalObject, decoder);
    case MessageName::WebPage_FlushDeferredResizeEvents:
        return jsValueForDecodedMessage<MessageName::WebPage_FlushDeferredResizeEvents>(globalObject, decoder);
    case MessageName::WebPage_StartDeferringScrollEvents:
        return jsValueForDecodedMessage<MessageName::WebPage_StartDeferringScrollEvents>(globalObject, decoder);
    case MessageName::WebPage_FlushDeferredScrollEvents:
        return jsValueForDecodedMessage<MessageName::WebPage_FlushDeferredScrollEvents>(globalObject, decoder);
    case MessageName::WebPage_FlushDeferredDidReceiveMouseEvent:
        return jsValueForDecodedMessage<MessageName::WebPage_FlushDeferredDidReceiveMouseEvent>(globalObject, decoder);
    case MessageName::WebPage_PerformHitTestForMouseEvent:
        return jsValueForDecodedMessage<MessageName::WebPage_PerformHitTestForMouseEvent>(globalObject, decoder);
    case MessageName::WebPage_SetUseColorAppearance:
        return jsValueForDecodedMessage<MessageName::WebPage_SetUseColorAppearance>(globalObject, decoder);
#if HAVE(APP_ACCENT_COLORS)
    case MessageName::WebPage_SetAccentColor:
        return jsValueForDecodedMessage<MessageName::WebPage_SetAccentColor>(globalObject, decoder);
#endif
#if PLATFORM(COCOA)
    case MessageName::WebPage_RequestActiveNowPlayingSessionInfo:
        return jsValueForDecodedMessage<MessageName::WebPage_RequestActiveNowPlayingSessionInfo>(globalObject, decoder);
#endif
    case MessageName::WebPage_SetShouldDispatchFakeMouseMoveEvents:
        return jsValueForDecodedMessage<MessageName::WebPage_SetShouldDispatchFakeMouseMoveEvents>(globalObject, decoder);
#if ENABLE(WIRELESS_PLAYBACK_TARGET) && !PLATFORM(IOS_FAMILY)
    case MessageName::WebPage_PlaybackTargetSelected:
        return jsValueForDecodedMessage<MessageName::WebPage_PlaybackTargetSelected>(globalObject, decoder);
    case MessageName::WebPage_PlaybackTargetAvailabilityDidChange:
        return jsValueForDecodedMessage<MessageName::WebPage_PlaybackTargetAvailabilityDidChange>(globalObject, decoder);
    case MessageName::WebPage_SetShouldPlayToPlaybackTarget:
        return jsValueForDecodedMessage<MessageName::WebPage_SetShouldPlayToPlaybackTarget>(globalObject, decoder);
    case MessageName::WebPage_PlaybackTargetPickerWasDismissed:
        return jsValueForDecodedMessage<MessageName::WebPage_PlaybackTargetPickerWasDismissed>(globalObject, decoder);
#endif
#if ENABLE(POINTER_LOCK)
    case MessageName::WebPage_DidLosePointerLock:
        return jsValueForDecodedMessage<MessageName::WebPage_DidLosePointerLock>(globalObject, decoder);
#endif
    case MessageName::WebPage_SetShouldScaleViewToFitDocument:
        return jsValueForDecodedMessage<MessageName::WebPage_SetShouldScaleViewToFitDocument>(globalObject, decoder);
    case MessageName::WebPage_SetUserInterfaceLayoutDirection:
        return jsValueForDecodedMessage<MessageName::WebPage_SetUserInterfaceLayoutDirection>(globalObject, decoder);
    case MessageName::WebPage_DidGetLoadDecisionForIcon:
        return jsValueForDecodedMessage<MessageName::WebPage_DidGetLoadDecisionForIcon>(globalObject, decoder);
    case MessageName::WebPage_SetUseIconLoadingClient:
        return jsValueForDecodedMessage<MessageName::WebPage_SetUseIconLoadingClient>(globalObject, decoder);
#if ENABLE(GAMEPAD)
    case MessageName::WebPage_GamepadActivity:
        return jsValueForDecodedMessage<MessageName::WebPage_GamepadActivity>(globalObject, decoder);
#endif
#if (ENABLE(GAMEPAD) && PLATFORM(VISION))
    case MessageName::WebPage_AllowGamepadAccess:
        return jsValueForDecodedMessage<MessageName::WebPage_AllowGamepadAccess>(globalObject, decoder);
#endif
    case MessageName::WebPage_RegisterURLSchemeHandler:
        return jsValueForDecodedMessage<MessageName::WebPage_RegisterURLSchemeHandler>(globalObject, decoder);
    case MessageName::WebPage_URLSchemeTaskWillPerformRedirection:
        return jsValueForDecodedMessage<MessageName::WebPage_URLSchemeTaskWillPerformRedirection>(globalObject, decoder);
    case MessageName::WebPage_URLSchemeTaskDidPerformRedirection:
        return jsValueForDecodedMessage<MessageName::WebPage_URLSchemeTaskDidPerformRedirection>(globalObject, decoder);
    case MessageName::WebPage_URLSchemeTaskDidReceiveResponse:
        return jsValueForDecodedMessage<MessageName::WebPage_URLSchemeTaskDidReceiveResponse>(globalObject, decoder);
    case MessageName::WebPage_URLSchemeTaskDidReceiveData:
        return jsValueForDecodedMessage<MessageName::WebPage_URLSchemeTaskDidReceiveData>(globalObject, decoder);
    case MessageName::WebPage_URLSchemeTaskDidComplete:
        return jsValueForDecodedMessage<MessageName::WebPage_URLSchemeTaskDidComplete>(globalObject, decoder);
    case MessageName::WebPage_SetIsSuspended:
        return jsValueForDecodedMessage<MessageName::WebPage_SetIsSuspended>(globalObject, decoder);
#if ENABLE(ATTACHMENT_ELEMENT)
    case MessageName::WebPage_InsertAttachment:
        return jsValueForDecodedMessage<MessageName::WebPage_InsertAttachment>(globalObject, decoder);
    case MessageName::WebPage_UpdateAttachmentAttributes:
        return jsValueForDecodedMessage<MessageName::WebPage_UpdateAttachmentAttributes>(globalObject, decoder);
    case MessageName::WebPage_UpdateAttachmentIcon:
        return jsValueForDecodedMessage<MessageName::WebPage_UpdateAttachmentIcon>(globalObject, decoder);
#endif
#if ENABLE(APPLICATION_MANIFEST)
    case MessageName::WebPage_GetApplicationManifest:
        return jsValueForDecodedMessage<MessageName::WebPage_GetApplicationManifest>(globalObject, decoder);
#endif
    case MessageName::WebPage_GetTextFragmentMatch:
        return jsValueForDecodedMessage<MessageName::WebPage_GetTextFragmentMatch>(globalObject, decoder);
#if ENABLE(PDF_PLUGIN) && PLATFORM(MAC)
    case MessageName::WebPage_ZoomPDFIn:
        return jsValueForDecodedMessage<MessageName::WebPage_ZoomPDFIn>(globalObject, decoder);
    case MessageName::WebPage_ZoomPDFOut:
        return jsValueForDecodedMessage<MessageName::WebPage_ZoomPDFOut>(globalObject, decoder);
    case MessageName::WebPage_SavePDF:
        return jsValueForDecodedMessage<MessageName::WebPage_SavePDF>(globalObject, decoder);
    case MessageName::WebPage_OpenPDFWithPreview:
        return jsValueForDecodedMessage<MessageName::WebPage_OpenPDFWithPreview>(globalObject, decoder);
#endif
    case MessageName::WebPage_UpdateCurrentModifierState:
        return jsValueForDecodedMessage<MessageName::WebPage_UpdateCurrentModifierState>(globalObject, decoder);
    case MessageName::WebPage_SimulateDeviceOrientationChange:
        return jsValueForDecodedMessage<MessageName::WebPage_SimulateDeviceOrientationChange>(globalObject, decoder);
#if ENABLE(SPEECH_SYNTHESIS)
    case MessageName::WebPage_SpeakingErrorOccurred:
        return jsValueForDecodedMessage<MessageName::WebPage_SpeakingErrorOccurred>(globalObject, decoder);
    case MessageName::WebPage_BoundaryEventOccurred:
        return jsValueForDecodedMessage<MessageName::WebPage_BoundaryEventOccurred>(globalObject, decoder);
    case MessageName::WebPage_VoicesDidChange:
        return jsValueForDecodedMessage<MessageName::WebPage_VoicesDidChange>(globalObject, decoder);
#endif
    case MessageName::WebPage_SetCanShowPlaceholder:
        return jsValueForDecodedMessage<MessageName::WebPage_SetCanShowPlaceholder>(globalObject, decoder);
    case MessageName::WebPage_WasLoadedWithDataTransferFromPrevalentResource:
        return jsValueForDecodedMessage<MessageName::WebPage_WasLoadedWithDataTransferFromPrevalentResource>(globalObject, decoder);
    case MessageName::WebPage_ClearLoadedSubresourceDomains:
        return jsValueForDecodedMessage<MessageName::WebPage_ClearLoadedSubresourceDomains>(globalObject, decoder);
    case MessageName::WebPage_GetLoadedSubresourceDomains:
        return jsValueForDecodedMessage<MessageName::WebPage_GetLoadedSubresourceDomains>(globalObject, decoder);
#if USE(SYSTEM_PREVIEW)
    case MessageName::WebPage_SystemPreviewActionTriggered:
        return jsValueForDecodedMessage<MessageName::WebPage_SystemPreviewActionTriggered>(globalObject, decoder);
#endif
#if PLATFORM(GTK) || PLATFORM(WPE)
    case MessageName::WebPage_SendMessageToWebProcessExtension:
        return jsValueForDecodedMessage<MessageName::WebPage_SendMessageToWebProcessExtension>(globalObject, decoder);
    case MessageName::WebPage_SendMessageToWebProcessExtensionWithReply:
        return jsValueForDecodedMessage<MessageName::WebPage_SendMessageToWebProcessExtensionWithReply>(globalObject, decoder);
#endif
#if PLATFORM(WPE) && USE(GBM) && ENABLE(WPE_PLATFORM)
    case MessageName::WebPage_PreferredBufferFormatsDidChange:
        return jsValueForDecodedMessage<MessageName::WebPage_PreferredBufferFormatsDidChange>(globalObject, decoder);
#endif
    case MessageName::WebPage_StartTextManipulations:
        return jsValueForDecodedMessage<MessageName::WebPage_StartTextManipulations>(globalObject, decoder);
    case MessageName::WebPage_CompleteTextManipulation:
        return jsValueForDecodedMessage<MessageName::WebPage_CompleteTextManipulation>(globalObject, decoder);
    case MessageName::WebPage_SetOverriddenMediaType:
        return jsValueForDecodedMessage<MessageName::WebPage_SetOverriddenMediaType>(globalObject, decoder);
    case MessageName::WebPage_GetProcessDisplayName:
        return jsValueForDecodedMessage<MessageName::WebPage_GetProcessDisplayName>(globalObject, decoder);
    case MessageName::WebPage_UpdateCORSDisablingPatterns:
        return jsValueForDecodedMessage<MessageName::WebPage_UpdateCORSDisablingPatterns>(globalObject, decoder);
    case MessageName::WebPage_SetIsTakingSnapshotsForApplicationSuspension:
        return jsValueForDecodedMessage<MessageName::WebPage_SetIsTakingSnapshotsForApplicationSuspension>(globalObject, decoder);
    case MessageName::WebPage_SetNeedsDOMWindowResizeEvent:
        return jsValueForDecodedMessage<MessageName::WebPage_SetNeedsDOMWindowResizeEvent>(globalObject, decoder);
    case MessageName::WebPage_SetHasResourceLoadClient:
        return jsValueForDecodedMessage<MessageName::WebPage_SetHasResourceLoadClient>(globalObject, decoder);
    case MessageName::WebPage_SetCanUseCredentialStorage:
        return jsValueForDecodedMessage<MessageName::WebPage_SetCanUseCredentialStorage>(globalObject, decoder);
#if ENABLE(APP_HIGHLIGHTS)
    case MessageName::WebPage_CreateAppHighlightInSelectedRange:
        return jsValueForDecodedMessage<MessageName::WebPage_CreateAppHighlightInSelectedRange>(globalObject, decoder);
    case MessageName::WebPage_RestoreAppHighlightsAndScrollToIndex:
        return jsValueForDecodedMessage<MessageName::WebPage_RestoreAppHighlightsAndScrollToIndex>(globalObject, decoder);
    case MessageName::WebPage_SetAppHighlightsVisibility:
        return jsValueForDecodedMessage<MessageName::WebPage_SetAppHighlightsVisibility>(globalObject, decoder);
#endif
    case MessageName::WebPage_CreateTextFragmentDirectiveFromSelection:
        return jsValueForDecodedMessage<MessageName::WebPage_CreateTextFragmentDirectiveFromSelection>(globalObject, decoder);
    case MessageName::WebPage_GetTextFragmentRanges:
        return jsValueForDecodedMessage<MessageName::WebPage_GetTextFragmentRanges>(globalObject, decoder);
    case MessageName::WebPage_HandleWheelEvent:
        return jsValueForDecodedMessage<MessageName::WebPage_HandleWheelEvent>(globalObject, decoder);
#if PLATFORM(IOS_FAMILY)
    case MessageName::WebPage_DispatchWheelEventWithoutScrolling:
        return jsValueForDecodedMessage<MessageName::WebPage_DispatchWheelEventWithoutScrolling>(globalObject, decoder);
#endif
    case MessageName::WebPage_LastNavigationWasAppInitiated:
        return jsValueForDecodedMessage<MessageName::WebPage_LastNavigationWasAppInitiated>(globalObject, decoder);
#if ENABLE(MEDIA_SESSION_COORDINATOR)
    case MessageName::WebPage_CreateMediaSessionCoordinator:
        return jsValueForDecodedMessage<MessageName::WebPage_CreateMediaSessionCoordinator>(globalObject, decoder);
#endif
#if ENABLE(IMAGE_ANALYSIS)
    case MessageName::WebPage_UpdateWithTextRecognitionResult:
        return jsValueForDecodedMessage<MessageName::WebPage_UpdateWithTextRecognitionResult>(globalObject, decoder);
    case MessageName::WebPage_StartVisualTranslation:
        return jsValueForDecodedMessage<MessageName::WebPage_StartVisualTranslation>(globalObject, decoder);
#endif
    case MessageName::WebPage_ScrollToRect:
        return jsValueForDecodedMessage<MessageName::WebPage_ScrollToRect>(globalObject, decoder);
    case MessageName::WebPage_SetContentOffset:
        return jsValueForDecodedMessage<MessageName::WebPage_SetContentOffset>(globalObject, decoder);
    case MessageName::WebPage_ScrollToEdge:
        return jsValueForDecodedMessage<MessageName::WebPage_ScrollToEdge>(globalObject, decoder);
    case MessageName::WebPage_NavigateServiceWorkerClient:
        return jsValueForDecodedMessage<MessageName::WebPage_NavigateServiceWorkerClient>(globalObject, decoder);
#if ENABLE(ARKIT_INLINE_PREVIEW_IOS)
    case MessageName::WebPage_ModelInlinePreviewDidLoad:
        return jsValueForDecodedMessage<MessageName::WebPage_ModelInlinePreviewDidLoad>(globalObject, decoder);
    case MessageName::WebPage_ModelInlinePreviewDidFailToLoad:
        return jsValueForDecodedMessage<MessageName::WebPage_ModelInlinePreviewDidFailToLoad>(globalObject, decoder);
#endif
#if HAVE(UIKIT_RESIZABLE_WINDOWS)
    case MessageName::WebPage_SetIsWindowResizingEnabled:
        return jsValueForDecodedMessage<MessageName::WebPage_SetIsWindowResizingEnabled>(globalObject, decoder);
#endif
#if ENABLE(INTERACTION_REGIONS_IN_EVENT_REGION)
    case MessageName::WebPage_SetInteractionRegionsEnabled:
        return jsValueForDecodedMessage<MessageName::WebPage_SetInteractionRegionsEnabled>(globalObject, decoder);
#endif
    case MessageName::WebPage_SetNeedsScrollGeometryUpdates:
        return jsValueForDecodedMessage<MessageName::WebPage_SetNeedsScrollGeometryUpdates>(globalObject, decoder);
    case MessageName::WebPage_GenerateTestReport:
        return jsValueForDecodedMessage<MessageName::WebPage_GenerateTestReport>(globalObject, decoder);
#if ENABLE(ADVANCED_PRIVACY_PROTECTIONS)
    case MessageName::WebPage_SetLinkDecorationFilteringData:
        return jsValueForDecodedMessage<MessageName::WebPage_SetLinkDecorationFilteringData>(globalObject, decoder);
    case MessageName::WebPage_SetAllowedQueryParametersForAdvancedPrivacyProtections:
        return jsValueForDecodedMessage<MessageName::WebPage_SetAllowedQueryParametersForAdvancedPrivacyProtections>(globalObject, decoder);
#endif
#if ENABLE(ACCESSIBILITY_ANIMATION_CONTROL)
    case MessageName::WebPage_PauseAllAnimations:
        return jsValueForDecodedMessage<MessageName::WebPage_PauseAllAnimations>(globalObject, decoder);
    case MessageName::WebPage_PlayAllAnimations:
        return jsValueForDecodedMessage<MessageName::WebPage_PlayAllAnimations>(globalObject, decoder);
#endif
    case MessageName::WebPage_UseRedirectionForCurrentNavigation:
        return jsValueForDecodedMessage<MessageName::WebPage_UseRedirectionForCurrentNavigation>(globalObject, decoder);
    case MessageName::WebPage_UpdateFrameScrollingMode:
        return jsValueForDecodedMessage<MessageName::WebPage_UpdateFrameScrollingMode>(globalObject, decoder);
    case MessageName::WebPage_DispatchLoadEventToFrameOwnerElement:
        return jsValueForDecodedMessage<MessageName::WebPage_DispatchLoadEventToFrameOwnerElement>(globalObject, decoder);
    case MessageName::WebPage_FrameWasFocusedInAnotherProcess:
        return jsValueForDecodedMessage<MessageName::WebPage_FrameWasFocusedInAnotherProcess>(globalObject, decoder);
    case MessageName::WebPage_RemotePostMessage:
        return jsValueForDecodedMessage<MessageName::WebPage_RemotePostMessage>(globalObject, decoder);
    case MessageName::WebPage_RenderTreeAsTextForTesting:
        return jsValueForDecodedMessage<MessageName::WebPage_RenderTreeAsTextForTesting>(globalObject, decoder);
    case MessageName::WebPage_LayerTreeAsTextForTesting:
        return jsValueForDecodedMessage<MessageName::WebPage_LayerTreeAsTextForTesting>(globalObject, decoder);
    case MessageName::WebPage_FrameTextForTesting:
        return jsValueForDecodedMessage<MessageName::WebPage_FrameTextForTesting>(globalObject, decoder);
    case MessageName::WebPage_RequestAllTextAndRects:
        return jsValueForDecodedMessage<MessageName::WebPage_RequestAllTextAndRects>(globalObject, decoder);
    case MessageName::WebPage_RequestTargetedElement:
        return jsValueForDecodedMessage<MessageName::WebPage_RequestTargetedElement>(globalObject, decoder);
    case MessageName::WebPage_RequestAllTargetableElements:
        return jsValueForDecodedMessage<MessageName::WebPage_RequestAllTargetableElements>(globalObject, decoder);
    case MessageName::WebPage_RequestTextExtraction:
        return jsValueForDecodedMessage<MessageName::WebPage_RequestTextExtraction>(globalObject, decoder);
#if PLATFORM(IOS_FAMILY)
    case MessageName::WebPage_ShouldDismissKeyboardAfterTapAtPoint:
        return jsValueForDecodedMessage<MessageName::WebPage_ShouldDismissKeyboardAfterTapAtPoint>(globalObject, decoder);
#endif
#if ENABLE(EXTENSION_CAPABILITIES)
    case MessageName::WebPage_SetMediaEnvironment:
        return jsValueForDecodedMessage<MessageName::WebPage_SetMediaEnvironment>(globalObject, decoder);
#endif
#if ENABLE(WRITING_TOOLS)
    case MessageName::WebPage_WillBeginWritingToolsSession:
        return jsValueForDecodedMessage<MessageName::WebPage_WillBeginWritingToolsSession>(globalObject, decoder);
    case MessageName::WebPage_DidBeginWritingToolsSession:
        return jsValueForDecodedMessage<MessageName::WebPage_DidBeginWritingToolsSession>(globalObject, decoder);
    case MessageName::WebPage_ProofreadingSessionDidReceiveSuggestions:
        return jsValueForDecodedMessage<MessageName::WebPage_ProofreadingSessionDidReceiveSuggestions>(globalObject, decoder);
    case MessageName::WebPage_ProofreadingSessionDidUpdateStateForSuggestion:
        return jsValueForDecodedMessage<MessageName::WebPage_ProofreadingSessionDidUpdateStateForSuggestion>(globalObject, decoder);
    case MessageName::WebPage_WillEndWritingToolsSession:
        return jsValueForDecodedMessage<MessageName::WebPage_WillEndWritingToolsSession>(globalObject, decoder);
    case MessageName::WebPage_DidEndWritingToolsSession:
        return jsValueForDecodedMessage<MessageName::WebPage_DidEndWritingToolsSession>(globalObject, decoder);
    case MessageName::WebPage_CompositionSessionDidReceiveTextWithReplacementRange:
        return jsValueForDecodedMessage<MessageName::WebPage_CompositionSessionDidReceiveTextWithReplacementRange>(globalObject, decoder);
    case MessageName::WebPage_WritingToolsSessionDidReceiveAction:
        return jsValueForDecodedMessage<MessageName::WebPage_WritingToolsSessionDidReceiveAction>(globalObject, decoder);
    case MessageName::WebPage_ProofreadingSessionSuggestionTextRectsInRootViewCoordinates:
        return jsValueForDecodedMessage<MessageName::WebPage_ProofreadingSessionSuggestionTextRectsInRootViewCoordinates>(globalObject, decoder);
    case MessageName::WebPage_UpdateTextVisibilityForActiveWritingToolsSession:
        return jsValueForDecodedMessage<MessageName::WebPage_UpdateTextVisibilityForActiveWritingToolsSession>(globalObject, decoder);
    case MessageName::WebPage_TextPreviewDataForActiveWritingToolsSession:
        return jsValueForDecodedMessage<MessageName::WebPage_TextPreviewDataForActiveWritingToolsSession>(globalObject, decoder);
    case MessageName::WebPage_SetSelectionForActiveWritingToolsSession:
        return jsValueForDecodedMessage<MessageName::WebPage_SetSelectionForActiveWritingToolsSession>(globalObject, decoder);
    case MessageName::WebPage_DecorateTextReplacementsForActiveWritingToolsSession:
        return jsValueForDecodedMessage<MessageName::WebPage_DecorateTextReplacementsForActiveWritingToolsSession>(globalObject, decoder);
    case MessageName::WebPage_CreateTextIndicatorForTextAnimationID:
        return jsValueForDecodedMessage<MessageName::WebPage_CreateTextIndicatorForTextAnimationID>(globalObject, decoder);
    case MessageName::WebPage_UpdateUnderlyingTextVisibilityForTextAnimationID:
        return jsValueForDecodedMessage<MessageName::WebPage_UpdateUnderlyingTextVisibilityForTextAnimationID>(globalObject, decoder);
    case MessageName::WebPage_IntelligenceTextAnimationsDidComplete:
        return jsValueForDecodedMessage<MessageName::WebPage_IntelligenceTextAnimationsDidComplete>(globalObject, decoder);
#endif
#if PLATFORM(COCOA)
    case MessageName::WebPage_CreateTextIndicatorForElementWithID:
        return jsValueForDecodedMessage<MessageName::WebPage_CreateTextIndicatorForElementWithID>(globalObject, decoder);
#endif
    case MessageName::WebPage_TakeSnapshotForTargetedElement:
        return jsValueForDecodedMessage<MessageName::WebPage_TakeSnapshotForTargetedElement>(globalObject, decoder);
    case MessageName::WebPage_ResetVisibilityAdjustmentsForTargetedElements:
        return jsValueForDecodedMessage<MessageName::WebPage_ResetVisibilityAdjustmentsForTargetedElements>(globalObject, decoder);
    case MessageName::WebPage_AdjustVisibilityForTargetedElements:
        return jsValueForDecodedMessage<MessageName::WebPage_AdjustVisibilityForTargetedElements>(globalObject, decoder);
    case MessageName::WebPage_NumberOfVisibilityAdjustmentRects:
        return jsValueForDecodedMessage<MessageName::WebPage_NumberOfVisibilityAdjustmentRects>(globalObject, decoder);
    case MessageName::WebPage_ContentsToRootViewRect:
        return jsValueForDecodedMessage<MessageName::WebPage_ContentsToRootViewRect>(globalObject, decoder);
    case MessageName::WebPage_ContentsToRootViewPoint:
        return jsValueForDecodedMessage<MessageName::WebPage_ContentsToRootViewPoint>(globalObject, decoder);
    case MessageName::WebPage_RemoteDictionaryPopupInfoToRootView:
        return jsValueForDecodedMessage<MessageName::WebPage_RemoteDictionaryPopupInfoToRootView>(globalObject, decoder);
#if HAVE(SPATIAL_TRACKING_LABEL)
    case MessageName::WebPage_SetDefaultSpatialTrackingLabel:
        return jsValueForDecodedMessage<MessageName::WebPage_SetDefaultSpatialTrackingLabel>(globalObject, decoder);
#endif
    case MessageName::WebPage_StartObservingNowPlayingMetadata:
        return jsValueForDecodedMessage<MessageName::WebPage_StartObservingNowPlayingMetadata>(globalObject, decoder);
    case MessageName::WebPage_StopObservingNowPlayingMetadata:
        return jsValueForDecodedMessage<MessageName::WebPage_StopObservingNowPlayingMetadata>(globalObject, decoder);
    case MessageName::WebPage_LoadAndDecodeImage:
        return jsValueForDecodedMessage<MessageName::WebPage_LoadAndDecodeImage>(globalObject, decoder);
#if PLATFORM(COCOA)
    case MessageName::WebPage_GetInformationFromImageData:
        return jsValueForDecodedMessage<MessageName::WebPage_GetInformationFromImageData>(globalObject, decoder);
    case MessageName::WebPage_CreateBitmapsFromImageData:
        return jsValueForDecodedMessage<MessageName::WebPage_CreateBitmapsFromImageData>(globalObject, decoder);
    case MessageName::WebPage_DecodeImageData:
        return jsValueForDecodedMessage<MessageName::WebPage_DecodeImageData>(globalObject, decoder);
#endif
    case MessageName::WebPage_FrameNameWasChangedInAnotherProcess:
        return jsValueForDecodedMessage<MessageName::WebPage_FrameNameWasChangedInAnotherProcess>(globalObject, decoder);
#if ENABLE(VIDEO_PRESENTATION_MODE)
    case MessageName::WebPage_StartPlayingPredominantVideo:
        return jsValueForDecodedMessage<MessageName::WebPage_StartPlayingPredominantVideo>(globalObject, decoder);
#endif
    case MessageName::WebPage_CloseCurrentTypingCommand:
        return jsValueForDecodedMessage<MessageName::WebPage_CloseCurrentTypingCommand>(globalObject, decoder);
    case MessageName::WebPage_SimulateClickOverFirstMatchingTextInViewportWithUserInteraction:
        return jsValueForDecodedMessage<MessageName::WebPage_SimulateClickOverFirstMatchingTextInViewportWithUserInteraction>(globalObject, decoder);
    case MessageName::WebPage_UpdateOpener:
        return jsValueForDecodedMessage<MessageName::WebPage_UpdateOpener>(globalObject, decoder);
#if HAVE(AUDIT_TOKEN)
    case MessageName::WebPage_SetPresentingApplicationAuditTokenAndBundleIdentifier:
        return jsValueForDecodedMessage<MessageName::WebPage_SetPresentingApplicationAuditTokenAndBundleIdentifier>(globalObject, decoder);
#endif
#if USE(UICONTEXTMENU)
    case MessageName::WebPage_WillBeginContextMenuInteraction:
        return jsValueForDecodedMessage<MessageName::WebPage_WillBeginContextMenuInteraction>(globalObject, decoder);
    case MessageName::WebPage_DidEndContextMenuInteraction:
        return jsValueForDecodedMessage<MessageName::WebPage_DidEndContextMenuInteraction>(globalObject, decoder);
#endif
    case MessageName::WebPageTesting_IsLayerTreeFrozen:
        return jsValueForDecodedMessage<MessageName::WebPageTesting_IsLayerTreeFrozen>(globalObject, decoder);
    case MessageName::WebPageTesting_SetPermissionLevel:
        return jsValueForDecodedMessage<MessageName::WebPageTesting_SetPermissionLevel>(globalObject, decoder);
    case MessageName::WebPageTesting_IsEditingCommandEnabled:
        return jsValueForDecodedMessage<MessageName::WebPageTesting_IsEditingCommandEnabled>(globalObject, decoder);
#if ENABLE(NOTIFICATIONS)
    case MessageName::WebPageTesting_ClearNotificationPermissionState:
        return jsValueForDecodedMessage<MessageName::WebPageTesting_ClearNotificationPermissionState>(globalObject, decoder);
#endif
    case MessageName::WebPageTesting_ClearWheelEventTestMonitor:
        return jsValueForDecodedMessage<MessageName::WebPageTesting_ClearWheelEventTestMonitor>(globalObject, decoder);
    case MessageName::WebPageTesting_ResetStateBetweenTests:
        return jsValueForDecodedMessage<MessageName::WebPageTesting_ResetStateBetweenTests>(globalObject, decoder);
    case MessageName::WebPageTesting_SetObscuredContentInsets:
        return jsValueForDecodedMessage<MessageName::WebPageTesting_SetObscuredContentInsets>(globalObject, decoder);
    case MessageName::WebPageTesting_ClearCachedBackForwardListCounts:
        return jsValueForDecodedMessage<MessageName::WebPageTesting_ClearCachedBackForwardListCounts>(globalObject, decoder);
    case MessageName::WebPageTesting_SetTracksRepaints:
        return jsValueForDecodedMessage<MessageName::WebPageTesting_SetTracksRepaints>(globalObject, decoder);
    case MessageName::WebPageTesting_DisplayAndTrackRepaints:
        return jsValueForDecodedMessage<MessageName::WebPageTesting_DisplayAndTrackRepaints>(globalObject, decoder);
    case MessageName::StorageAreaMap_DispatchStorageEvent:
        return jsValueForDecodedMessage<MessageName::StorageAreaMap_DispatchStorageEvent>(globalObject, decoder);
    case MessageName::StorageAreaMap_ClearCache:
        return jsValueForDecodedMessage<MessageName::StorageAreaMap_ClearCache>(globalObject, decoder);
#if ENABLE(WEBXR)
    case MessageName::PlatformXRSystemProxy_SessionDidEnd:
        return jsValueForDecodedMessage<MessageName::PlatformXRSystemProxy_SessionDidEnd>(globalObject, decoder);
    case MessageName::PlatformXRSystemProxy_SessionDidUpdateVisibilityState:
        return jsValueForDecodedMessage<MessageName::PlatformXRSystemProxy_SessionDidUpdateVisibilityState>(globalObject, decoder);
#endif
#if ENABLE(WEB_PUSH_NOTIFICATIONS)
    case MessageName::PushClientConnection_SetPushAndNotificationsEnabledForOrigin:
        return jsValueForDecodedMessage<MessageName::PushClientConnection_SetPushAndNotificationsEnabledForOrigin>(globalObject, decoder);
    case MessageName::PushClientConnection_GetPendingPushMessage:
        return jsValueForDecodedMessage<MessageName::PushClientConnection_GetPendingPushMessage>(globalObject, decoder);
    case MessageName::PushClientConnection_GetPendingPushMessages:
        return jsValueForDecodedMessage<MessageName::PushClientConnection_GetPendingPushMessages>(globalObject, decoder);
    case MessageName::PushClientConnection_InitializeConnection:
        return jsValueForDecodedMessage<MessageName::PushClientConnection_InitializeConnection>(globalObject, decoder);
    case MessageName::PushClientConnection_InjectPushMessageForTesting:
        return jsValueForDecodedMessage<MessageName::PushClientConnection_InjectPushMessageForTesting>(globalObject, decoder);
    case MessageName::PushClientConnection_InjectEncryptedPushMessageForTesting:
        return jsValueForDecodedMessage<MessageName::PushClientConnection_InjectEncryptedPushMessageForTesting>(globalObject, decoder);
    case MessageName::PushClientConnection_SubscribeToPushService:
        return jsValueForDecodedMessage<MessageName::PushClientConnection_SubscribeToPushService>(globalObject, decoder);
    case MessageName::PushClientConnection_UnsubscribeFromPushService:
        return jsValueForDecodedMessage<MessageName::PushClientConnection_UnsubscribeFromPushService>(globalObject, decoder);
    case MessageName::PushClientConnection_GetPushSubscription:
        return jsValueForDecodedMessage<MessageName::PushClientConnection_GetPushSubscription>(globalObject, decoder);
    case MessageName::PushClientConnection_GetPushPermissionState:
        return jsValueForDecodedMessage<MessageName::PushClientConnection_GetPushPermissionState>(globalObject, decoder);
    case MessageName::PushClientConnection_IncrementSilentPushCount:
        return jsValueForDecodedMessage<MessageName::PushClientConnection_IncrementSilentPushCount>(globalObject, decoder);
    case MessageName::PushClientConnection_RemoveAllPushSubscriptions:
        return jsValueForDecodedMessage<MessageName::PushClientConnection_RemoveAllPushSubscriptions>(globalObject, decoder);
    case MessageName::PushClientConnection_RemovePushSubscriptionsForOrigin:
        return jsValueForDecodedMessage<MessageName::PushClientConnection_RemovePushSubscriptionsForOrigin>(globalObject, decoder);
    case MessageName::PushClientConnection_SetPublicTokenForTesting:
        return jsValueForDecodedMessage<MessageName::PushClientConnection_SetPublicTokenForTesting>(globalObject, decoder);
    case MessageName::PushClientConnection_GetPushTopicsForTesting:
        return jsValueForDecodedMessage<MessageName::PushClientConnection_GetPushTopicsForTesting>(globalObject, decoder);
    case MessageName::PushClientConnection_ShowNotification:
        return jsValueForDecodedMessage<MessageName::PushClientConnection_ShowNotification>(globalObject, decoder);
    case MessageName::PushClientConnection_GetNotifications:
        return jsValueForDecodedMessage<MessageName::PushClientConnection_GetNotifications>(globalObject, decoder);
    case MessageName::PushClientConnection_CancelNotification:
        return jsValueForDecodedMessage<MessageName::PushClientConnection_CancelNotification>(globalObject, decoder);
    case MessageName::PushClientConnection_RequestPushPermission:
        return jsValueForDecodedMessage<MessageName::PushClientConnection_RequestPushPermission>(globalObject, decoder);
    case MessageName::PushClientConnection_SetAppBadge:
        return jsValueForDecodedMessage<MessageName::PushClientConnection_SetAppBadge>(globalObject, decoder);
    case MessageName::PushClientConnection_GetAppBadgeForTesting:
        return jsValueForDecodedMessage<MessageName::PushClientConnection_GetAppBadgeForTesting>(globalObject, decoder);
    case MessageName::PushClientConnection_SetServiceWorkerIsBeingInspected:
        return jsValueForDecodedMessage<MessageName::PushClientConnection_SetServiceWorkerIsBeingInspected>(globalObject, decoder);
    case MessageName::PushClientConnection_SetProtocolVersionForTesting:
        return jsValueForDecodedMessage<MessageName::PushClientConnection_SetProtocolVersionForTesting>(globalObject, decoder);
#endif
#if PLATFORM(MAC)
    case MessageName::ViewGestureController_DidCollectGeometryForSmartMagnificationGesture:
        return jsValueForDecodedMessage<MessageName::ViewGestureController_DidCollectGeometryForSmartMagnificationGesture>(globalObject, decoder);
#endif
#if !PLATFORM(IOS_FAMILY)
    case MessageName::ViewGestureController_DidCollectGeometryForMagnificationGesture:
        return jsValueForDecodedMessage<MessageName::ViewGestureController_DidCollectGeometryForMagnificationGesture>(globalObject, decoder);
    case MessageName::ViewGestureController_DidHitRenderTreeSizeThreshold:
        return jsValueForDecodedMessage<MessageName::ViewGestureController_DidHitRenderTreeSizeThreshold>(globalObject, decoder);
#endif
    case MessageName::AcceleratedBackingStore_DidCreateDMABufBuffer:
        return jsValueForDecodedMessage<MessageName::AcceleratedBackingStore_DidCreateDMABufBuffer>(globalObject, decoder);
    case MessageName::AcceleratedBackingStore_DidCreateSHMBuffer:
        return jsValueForDecodedMessage<MessageName::AcceleratedBackingStore_DidCreateSHMBuffer>(globalObject, decoder);
    case MessageName::AcceleratedBackingStore_DidDestroyBuffer:
        return jsValueForDecodedMessage<MessageName::AcceleratedBackingStore_DidDestroyBuffer>(globalObject, decoder);
    case MessageName::AcceleratedBackingStore_Frame:
        return jsValueForDecodedMessage<MessageName::AcceleratedBackingStore_Frame>(globalObject, decoder);
#if PLATFORM(COCOA)
    case MessageName::ViewGestureGeometryCollector_CollectGeometryForSmartMagnificationGesture:
        return jsValueForDecodedMessage<MessageName::ViewGestureGeometryCollector_CollectGeometryForSmartMagnificationGesture>(globalObject, decoder);
#endif
#if !PLATFORM(IOS_FAMILY)
    case MessageName::ViewGestureGeometryCollector_CollectGeometryForMagnificationGesture:
        return jsValueForDecodedMessage<MessageName::ViewGestureGeometryCollector_CollectGeometryForMagnificationGesture>(globalObject, decoder);
    case MessageName::ViewGestureGeometryCollector_SetRenderTreeSizeNotificationThreshold:
        return jsValueForDecodedMessage<MessageName::ViewGestureGeometryCollector_SetRenderTreeSizeNotificationThreshold>(globalObject, decoder);
#endif
    case MessageName::AcceleratedSurface_ReleaseBuffer:
        return jsValueForDecodedMessage<MessageName::AcceleratedSurface_ReleaseBuffer>(globalObject, decoder);
    case MessageName::AcceleratedSurface_FrameDone:
        return jsValueForDecodedMessage<MessageName::AcceleratedSurface_FrameDone>(globalObject, decoder);
    case MessageName::SystemSettingsManager_DidChange:
        return jsValueForDecodedMessage<MessageName::SystemSettingsManager_DidChange>(globalObject, decoder);
#if ENABLE(MEDIA_STREAM)
    case MessageName::UserMediaCaptureManager_ValidateUserMediaRequestConstraints:
        return jsValueForDecodedMessage<MessageName::UserMediaCaptureManager_ValidateUserMediaRequestConstraints>(globalObject, decoder);
    case MessageName::UserMediaCaptureManager_GetMediaStreamDevices:
        return jsValueForDecodedMessage<MessageName::UserMediaCaptureManager_GetMediaStreamDevices>(globalObject, decoder);
#endif
    default:
        break;
    }
    return std::nullopt;
}

std::optional<JSC::JSValue> jsValueForReplyArguments(JSC::JSGlobalObject* globalObject, MessageName name, Decoder& decoder)
{
    switch (name) {
#if ENABLE(GPU_PROCESS)
#if USE(AUDIO_SESSION)
    case MessageName::GPUConnectionToWebProcess_EnsureAudioSession:
        return jsValueForDecodedMessageReply<MessageName::GPUConnectionToWebProcess_EnsureAudioSession>(globalObject, decoder);
#endif
#endif
#if ENABLE(GPU_PROCESS)
    case MessageName::GPUProcess_InitializeGPUProcess:
        return jsValueForDecodedMessageReply<MessageName::GPUProcess_InitializeGPUProcess>(globalObject, decoder);
    case MessageName::GPUProcess_CreateGPUConnectionToWebProcess:
        return jsValueForDecodedMessageReply<MessageName::GPUProcess_CreateGPUConnectionToWebProcess>(globalObject, decoder);
    case MessageName::GPUProcess_SharedPreferencesForWebProcessDidChange:
        return jsValueForDecodedMessageReply<MessageName::GPUProcess_SharedPreferencesForWebProcessDidChange>(globalObject, decoder);
    case MessageName::GPUProcess_PrepareToSuspend:
        return jsValueForDecodedMessageReply<MessageName::GPUProcess_PrepareToSuspend>(globalObject, decoder);
#if ENABLE(MEDIA_STREAM)
    case MessageName::GPUProcess_UpdateCaptureAccess:
        return jsValueForDecodedMessageReply<MessageName::GPUProcess_UpdateCaptureAccess>(globalObject, decoder);
#endif
#if HAVE(SCREEN_CAPTURE_KIT)
    case MessageName::GPUProcess_PromptForGetDisplayMedia:
        return jsValueForDecodedMessageReply<MessageName::GPUProcess_PromptForGetDisplayMedia>(globalObject, decoder);
#endif
#if ENABLE(VIDEO)
    case MessageName::GPUProcess_RequestBitmapImageForCurrentTime:
        return jsValueForDecodedMessageReply<MessageName::GPUProcess_RequestBitmapImageForCurrentTime>(globalObject, decoder);
#endif
    case MessageName::GPUProcess_WebProcessConnectionCountForTesting:
        return jsValueForDecodedMessageReply<MessageName::GPUProcess_WebProcessConnectionCountForTesting>(globalObject, decoder);
#if ENABLE(WEBXR)
    case MessageName::GPUProcess_WebXRPromptAccepted:
        return jsValueForDecodedMessageReply<MessageName::GPUProcess_WebXRPromptAccepted>(globalObject, decoder);
#endif
#if PLATFORM(VISION) && ENABLE(MODEL_PROCESS)
    case MessageName::GPUProcess_RequestSharedSimulationConnection:
        return jsValueForDecodedMessageReply<MessageName::GPUProcess_RequestSharedSimulationConnection>(globalObject, decoder);
#endif
#if ((PLATFORM(VISION) && ENABLE(MODEL_PROCESS)) && HAVE(TASK_IDENTITY_TOKEN))
    case MessageName::GPUProcess_CreateMemoryAttributionIDForTask:
        return jsValueForDecodedMessageReply<MessageName::GPUProcess_CreateMemoryAttributionIDForTask>(globalObject, decoder);
    case MessageName::GPUProcess_UnregisterMemoryAttributionID:
        return jsValueForDecodedMessageReply<MessageName::GPUProcess_UnregisterMemoryAttributionID>(globalObject, decoder);
#endif
#if PLATFORM(COCOA)
    case MessageName::GPUProcess_PostWillTakeSnapshotNotification:
        return jsValueForDecodedMessageReply<MessageName::GPUProcess_PostWillTakeSnapshotNotification>(globalObject, decoder);
#endif
#endif
#if ENABLE(GPU_PROCESS)
#endif
#if ENABLE(GPU_PROCESS)
    case MessageName::RemoteBarcodeDetector_Detect:
        return jsValueForDecodedMessageReply<MessageName::RemoteBarcodeDetector_Detect>(globalObject, decoder);
#endif
#if ENABLE(GPU_PROCESS)
    case MessageName::RemoteFaceDetector_Detect:
        return jsValueForDecodedMessageReply<MessageName::RemoteFaceDetector_Detect>(globalObject, decoder);
#endif
#if ENABLE(GPU_PROCESS)
    case MessageName::RemoteTextDetector_Detect:
        return jsValueForDecodedMessageReply<MessageName::RemoteTextDetector_Detect>(globalObject, decoder);
#endif
#if ENABLE(GPU_PROCESS)
#endif
#if ENABLE(GPU_PROCESS) && ENABLE(WEBGL)
#if PLATFORM(COCOA)
    case MessageName::RemoteGraphicsContextGL_PrepareForDisplay:
        return jsValueForDecodedMessageReply<MessageName::RemoteGraphicsContextGL_PrepareForDisplay>(globalObject, decoder);
#endif
#if USE(GRAPHICS_LAYER_WC)
    case MessageName::RemoteGraphicsContextGL_PrepareForDisplay:
        return jsValueForDecodedMessageReply<MessageName::RemoteGraphicsContextGL_PrepareForDisplay>(globalObject, decoder);
#endif
#if USE(GBM)
    case MessageName::RemoteGraphicsContextGL_PrepareForDisplay:
        return jsValueForDecodedMessageReply<MessageName::RemoteGraphicsContextGL_PrepareForDisplay>(globalObject, decoder);
#endif
#if !PLATFORM(COCOA) && !USE(GRAPHICS_LAYER_WC) && !USE(GBM)
    case MessageName::RemoteGraphicsContextGL_PrepareForDisplay:
        return jsValueForDecodedMessageReply<MessageName::RemoteGraphicsContextGL_PrepareForDisplay>(globalObject, decoder);
#endif
    case MessageName::RemoteGraphicsContextGL_GetErrors:
        return jsValueForDecodedMessageReply<MessageName::RemoteGraphicsContextGL_GetErrors>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_DrawSurfaceBufferToImageBuffer:
        return jsValueForDecodedMessageReply<MessageName::RemoteGraphicsContextGL_DrawSurfaceBufferToImageBuffer>(globalObject, decoder);
#if ENABLE(MEDIA_STREAM) || ENABLE(WEB_CODECS)
    case MessageName::RemoteGraphicsContextGL_SurfaceBufferToVideoFrame:
        return jsValueForDecodedMessageReply<MessageName::RemoteGraphicsContextGL_SurfaceBufferToVideoFrame>(globalObject, decoder);
#endif
#if ENABLE(VIDEO) && PLATFORM(COCOA)
    case MessageName::RemoteGraphicsContextGL_CopyTextureFromVideoFrame:
        return jsValueForDecodedMessageReply<MessageName::RemoteGraphicsContextGL_CopyTextureFromVideoFrame>(globalObject, decoder);
#endif
    case MessageName::RemoteGraphicsContextGL_GetBufferSubDataInline:
        return jsValueForDecodedMessageReply<MessageName::RemoteGraphicsContextGL_GetBufferSubDataInline>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_GetBufferSubDataSharedMemory:
        return jsValueForDecodedMessageReply<MessageName::RemoteGraphicsContextGL_GetBufferSubDataSharedMemory>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_ReadPixelsInline:
        return jsValueForDecodedMessageReply<MessageName::RemoteGraphicsContextGL_ReadPixelsInline>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_ReadPixelsSharedMemory:
        return jsValueForDecodedMessageReply<MessageName::RemoteGraphicsContextGL_ReadPixelsSharedMemory>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_CheckFramebufferStatus:
        return jsValueForDecodedMessageReply<MessageName::RemoteGraphicsContextGL_CheckFramebufferStatus>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_GetActiveAttrib:
        return jsValueForDecodedMessageReply<MessageName::RemoteGraphicsContextGL_GetActiveAttrib>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_GetActiveUniform:
        return jsValueForDecodedMessageReply<MessageName::RemoteGraphicsContextGL_GetActiveUniform>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_GetAttribLocation:
        return jsValueForDecodedMessageReply<MessageName::RemoteGraphicsContextGL_GetAttribLocation>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_GetBufferParameteri:
        return jsValueForDecodedMessageReply<MessageName::RemoteGraphicsContextGL_GetBufferParameteri>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_GetString:
        return jsValueForDecodedMessageReply<MessageName::RemoteGraphicsContextGL_GetString>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_GetFloatv:
        return jsValueForDecodedMessageReply<MessageName::RemoteGraphicsContextGL_GetFloatv>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_GetIntegerv:
        return jsValueForDecodedMessageReply<MessageName::RemoteGraphicsContextGL_GetIntegerv>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_GetIntegeri_v:
        return jsValueForDecodedMessageReply<MessageName::RemoteGraphicsContextGL_GetIntegeri_v>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_GetInteger64:
        return jsValueForDecodedMessageReply<MessageName::RemoteGraphicsContextGL_GetInteger64>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_GetInteger64i:
        return jsValueForDecodedMessageReply<MessageName::RemoteGraphicsContextGL_GetInteger64i>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_GetProgrami:
        return jsValueForDecodedMessageReply<MessageName::RemoteGraphicsContextGL_GetProgrami>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_GetBooleanv:
        return jsValueForDecodedMessageReply<MessageName::RemoteGraphicsContextGL_GetBooleanv>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_GetFramebufferAttachmentParameteri:
        return jsValueForDecodedMessageReply<MessageName::RemoteGraphicsContextGL_GetFramebufferAttachmentParameteri>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_GetProgramInfoLog:
        return jsValueForDecodedMessageReply<MessageName::RemoteGraphicsContextGL_GetProgramInfoLog>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_GetRenderbufferParameteri:
        return jsValueForDecodedMessageReply<MessageName::RemoteGraphicsContextGL_GetRenderbufferParameteri>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_GetShaderi:
        return jsValueForDecodedMessageReply<MessageName::RemoteGraphicsContextGL_GetShaderi>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_GetShaderInfoLog:
        return jsValueForDecodedMessageReply<MessageName::RemoteGraphicsContextGL_GetShaderInfoLog>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_GetShaderPrecisionFormat:
        return jsValueForDecodedMessageReply<MessageName::RemoteGraphicsContextGL_GetShaderPrecisionFormat>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_GetShaderSource:
        return jsValueForDecodedMessageReply<MessageName::RemoteGraphicsContextGL_GetShaderSource>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_GetTexParameterf:
        return jsValueForDecodedMessageReply<MessageName::RemoteGraphicsContextGL_GetTexParameterf>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_GetTexParameteri:
        return jsValueForDecodedMessageReply<MessageName::RemoteGraphicsContextGL_GetTexParameteri>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_GetUniformfv:
        return jsValueForDecodedMessageReply<MessageName::RemoteGraphicsContextGL_GetUniformfv>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_GetUniformiv:
        return jsValueForDecodedMessageReply<MessageName::RemoteGraphicsContextGL_GetUniformiv>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_GetUniformuiv:
        return jsValueForDecodedMessageReply<MessageName::RemoteGraphicsContextGL_GetUniformuiv>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_GetUniformLocation:
        return jsValueForDecodedMessageReply<MessageName::RemoteGraphicsContextGL_GetUniformLocation>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_GetVertexAttribOffset:
        return jsValueForDecodedMessageReply<MessageName::RemoteGraphicsContextGL_GetVertexAttribOffset>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_IsBuffer:
        return jsValueForDecodedMessageReply<MessageName::RemoteGraphicsContextGL_IsBuffer>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_IsEnabled:
        return jsValueForDecodedMessageReply<MessageName::RemoteGraphicsContextGL_IsEnabled>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_IsFramebuffer:
        return jsValueForDecodedMessageReply<MessageName::RemoteGraphicsContextGL_IsFramebuffer>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_IsProgram:
        return jsValueForDecodedMessageReply<MessageName::RemoteGraphicsContextGL_IsProgram>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_IsRenderbuffer:
        return jsValueForDecodedMessageReply<MessageName::RemoteGraphicsContextGL_IsRenderbuffer>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_IsShader:
        return jsValueForDecodedMessageReply<MessageName::RemoteGraphicsContextGL_IsShader>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_IsTexture:
        return jsValueForDecodedMessageReply<MessageName::RemoteGraphicsContextGL_IsTexture>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_IsVertexArray:
        return jsValueForDecodedMessageReply<MessageName::RemoteGraphicsContextGL_IsVertexArray>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_GetFragDataLocation:
        return jsValueForDecodedMessageReply<MessageName::RemoteGraphicsContextGL_GetFragDataLocation>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_IsQuery:
        return jsValueForDecodedMessageReply<MessageName::RemoteGraphicsContextGL_IsQuery>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_GetQuery:
        return jsValueForDecodedMessageReply<MessageName::RemoteGraphicsContextGL_GetQuery>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_GetQueryObjectui:
        return jsValueForDecodedMessageReply<MessageName::RemoteGraphicsContextGL_GetQueryObjectui>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_IsSampler:
        return jsValueForDecodedMessageReply<MessageName::RemoteGraphicsContextGL_IsSampler>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_GetSamplerParameterf:
        return jsValueForDecodedMessageReply<MessageName::RemoteGraphicsContextGL_GetSamplerParameterf>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_GetSamplerParameteri:
        return jsValueForDecodedMessageReply<MessageName::RemoteGraphicsContextGL_GetSamplerParameteri>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_FenceSync:
        return jsValueForDecodedMessageReply<MessageName::RemoteGraphicsContextGL_FenceSync>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_IsSync:
        return jsValueForDecodedMessageReply<MessageName::RemoteGraphicsContextGL_IsSync>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_ClientWaitSync:
        return jsValueForDecodedMessageReply<MessageName::RemoteGraphicsContextGL_ClientWaitSync>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_GetSynci:
        return jsValueForDecodedMessageReply<MessageName::RemoteGraphicsContextGL_GetSynci>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_IsTransformFeedback:
        return jsValueForDecodedMessageReply<MessageName::RemoteGraphicsContextGL_IsTransformFeedback>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_GetTransformFeedbackVarying:
        return jsValueForDecodedMessageReply<MessageName::RemoteGraphicsContextGL_GetTransformFeedbackVarying>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_GetUniformIndices:
        return jsValueForDecodedMessageReply<MessageName::RemoteGraphicsContextGL_GetUniformIndices>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_GetActiveUniforms:
        return jsValueForDecodedMessageReply<MessageName::RemoteGraphicsContextGL_GetActiveUniforms>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_GetUniformBlockIndex:
        return jsValueForDecodedMessageReply<MessageName::RemoteGraphicsContextGL_GetUniformBlockIndex>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_GetActiveUniformBlockName:
        return jsValueForDecodedMessageReply<MessageName::RemoteGraphicsContextGL_GetActiveUniformBlockName>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_GetActiveUniformBlockiv:
        return jsValueForDecodedMessageReply<MessageName::RemoteGraphicsContextGL_GetActiveUniformBlockiv>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_GetTranslatedShaderSourceANGLE:
        return jsValueForDecodedMessageReply<MessageName::RemoteGraphicsContextGL_GetTranslatedShaderSourceANGLE>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_IsQueryEXT:
        return jsValueForDecodedMessageReply<MessageName::RemoteGraphicsContextGL_IsQueryEXT>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_GetQueryiEXT:
        return jsValueForDecodedMessageReply<MessageName::RemoteGraphicsContextGL_GetQueryiEXT>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_GetQueryObjectiEXT:
        return jsValueForDecodedMessageReply<MessageName::RemoteGraphicsContextGL_GetQueryObjectiEXT>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_GetQueryObjectui64EXT:
        return jsValueForDecodedMessageReply<MessageName::RemoteGraphicsContextGL_GetQueryObjectui64EXT>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_GetInteger64EXT:
        return jsValueForDecodedMessageReply<MessageName::RemoteGraphicsContextGL_GetInteger64EXT>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_GetInternalformativ:
        return jsValueForDecodedMessageReply<MessageName::RemoteGraphicsContextGL_GetInternalformativ>(globalObject, decoder);
#if ENABLE(WEBXR)
    case MessageName::RemoteGraphicsContextGL_EnableRequiredWebXRExtensions:
        return jsValueForDecodedMessageReply<MessageName::RemoteGraphicsContextGL_EnableRequiredWebXRExtensions>(globalObject, decoder);
    case MessageName::RemoteGraphicsContextGL_AddFoveation:
        return jsValueForDecodedMessageReply<MessageName::RemoteGraphicsContextGL_AddFoveation>(globalObject, decoder);
#endif
#endif
#if ENABLE(GPU_PROCESS)
    case MessageName::RemoteImageBuffer_GetPixelBuffer:
        return jsValueForDecodedMessageReply<MessageName::RemoteImageBuffer_GetPixelBuffer>(globalObject, decoder);
    case MessageName::RemoteImageBuffer_GetPixelBufferWithNewMemory:
        return jsValueForDecodedMessageReply<MessageName::RemoteImageBuffer_GetPixelBufferWithNewMemory>(globalObject, decoder);
    case MessageName::RemoteImageBuffer_GetShareableBitmap:
        return jsValueForDecodedMessageReply<MessageName::RemoteImageBuffer_GetShareableBitmap>(globalObject, decoder);
    case MessageName::RemoteImageBuffer_FilteredNativeImage:
        return jsValueForDecodedMessageReply<MessageName::RemoteImageBuffer_FilteredNativeImage>(globalObject, decoder);
    case MessageName::RemoteImageBuffer_FlushContextSync:
        return jsValueForDecodedMessageReply<MessageName::RemoteImageBuffer_FlushContextSync>(globalObject, decoder);
#if ENABLE(RE_DYNAMIC_CONTENT_SCALING)
    case MessageName::RemoteImageBuffer_DynamicContentScalingDisplayList:
        return jsValueForDecodedMessageReply<MessageName::RemoteImageBuffer_DynamicContentScalingDisplayList>(globalObject, decoder);
#endif
#endif
#if ENABLE(GPU_PROCESS)
#if ENABLE(RE_DYNAMIC_CONTENT_SCALING)
    case MessageName::RemoteImageBufferSet_DynamicContentScalingDisplayList:
        return jsValueForDecodedMessageReply<MessageName::RemoteImageBufferSet_DynamicContentScalingDisplayList>(globalObject, decoder);
#endif
#endif
#if ENABLE(GPU_PROCESS)
    case MessageName::RemoteRenderingBackend_GetImageBufferResourceLimitsForTesting:
        return jsValueForDecodedMessageReply<MessageName::RemoteRenderingBackend_GetImageBufferResourceLimitsForTesting>(globalObject, decoder);
#if PLATFORM(COCOA)
    case MessageName::RemoteRenderingBackend_PrepareImageBufferSetsForDisplaySync:
        return jsValueForDecodedMessageReply<MessageName::RemoteRenderingBackend_PrepareImageBufferSetsForDisplaySync>(globalObject, decoder);
#endif
    case MessageName::RemoteRenderingBackend_GetRemoteBarcodeDetectorSupportedFormats:
        return jsValueForDecodedMessageReply<MessageName::RemoteRenderingBackend_GetRemoteBarcodeDetectorSupportedFormats>(globalObject, decoder);
#endif
#if ENABLE(GPU_PROCESS)
    case MessageName::RemoteAdapter_RequestDevice:
        return jsValueForDecodedMessageReply<MessageName::RemoteAdapter_RequestDevice>(globalObject, decoder);
#endif
#if ENABLE(GPU_PROCESS)
    case MessageName::RemoteBindGroup_UpdateExternalTextures:
        return jsValueForDecodedMessageReply<MessageName::RemoteBindGroup_UpdateExternalTextures>(globalObject, decoder);
#endif
#if ENABLE(GPU_PROCESS)
#endif
#if ENABLE(GPU_PROCESS)
    case MessageName::RemoteBuffer_GetMappedRange:
        return jsValueForDecodedMessageReply<MessageName::RemoteBuffer_GetMappedRange>(globalObject, decoder);
    case MessageName::RemoteBuffer_MapAsync:
        return jsValueForDecodedMessageReply<MessageName::RemoteBuffer_MapAsync>(globalObject, decoder);
    case MessageName::RemoteBuffer_Copy:
        return jsValueForDecodedMessageReply<MessageName::RemoteBuffer_Copy>(globalObject, decoder);
#endif
#if ENABLE(GPU_PROCESS)
#endif
#if ENABLE(GPU_PROCESS)
#endif
#if ENABLE(GPU_PROCESS)
#if PLATFORM(COCOA)
    case MessageName::RemoteCompositorIntegration_RecreateRenderBuffers:
        return jsValueForDecodedMessageReply<MessageName::RemoteCompositorIntegration_RecreateRenderBuffers>(globalObject, decoder);
#endif
    case MessageName::RemoteCompositorIntegration_PrepareForDisplay:
        return jsValueForDecodedMessageReply<MessageName::RemoteCompositorIntegration_PrepareForDisplay>(globalObject, decoder);
    case MessageName::RemoteCompositorIntegration_PaintCompositedResultsToCanvas:
        return jsValueForDecodedMessageReply<MessageName::RemoteCompositorIntegration_PaintCompositedResultsToCanvas>(globalObject, decoder);
#endif
#if ENABLE(GPU_PROCESS)
#endif
#if ENABLE(GPU_PROCESS)
#endif
#if ENABLE(GPU_PROCESS)
    case MessageName::RemoteDevice_CreateComputePipelineAsync:
        return jsValueForDecodedMessageReply<MessageName::RemoteDevice_CreateComputePipelineAsync>(globalObject, decoder);
    case MessageName::RemoteDevice_CreateRenderPipelineAsync:
        return jsValueForDecodedMessageReply<MessageName::RemoteDevice_CreateRenderPipelineAsync>(globalObject, decoder);
    case MessageName::RemoteDevice_PopErrorScope:
        return jsValueForDecodedMessageReply<MessageName::RemoteDevice_PopErrorScope>(globalObject, decoder);
    case MessageName::RemoteDevice_ResolveUncapturedErrorEvent:
        return jsValueForDecodedMessageReply<MessageName::RemoteDevice_ResolveUncapturedErrorEvent>(globalObject, decoder);
    case MessageName::RemoteDevice_ResolveDeviceLostPromise:
        return jsValueForDecodedMessageReply<MessageName::RemoteDevice_ResolveDeviceLostPromise>(globalObject, decoder);
#endif
#if ENABLE(GPU_PROCESS)
#endif
#if ENABLE(GPU_PROCESS)
    case MessageName::RemoteGPU_RequestAdapter:
        return jsValueForDecodedMessageReply<MessageName::RemoteGPU_RequestAdapter>(globalObject, decoder);
    case MessageName::RemoteGPU_IsValid:
        return jsValueForDecodedMessageReply<MessageName::RemoteGPU_IsValid>(globalObject, decoder);
#endif
#if ENABLE(GPU_PROCESS)
#endif
#if ENABLE(GPU_PROCESS)
#endif
#if ENABLE(GPU_PROCESS)
#endif
#if ENABLE(GPU_PROCESS)
    case MessageName::RemoteQueue_OnSubmittedWorkDone:
        return jsValueForDecodedMessageReply<MessageName::RemoteQueue_OnSubmittedWorkDone>(globalObject, decoder);
    case MessageName::RemoteQueue_WriteBuffer:
        return jsValueForDecodedMessageReply<MessageName::RemoteQueue_WriteBuffer>(globalObject, decoder);
    case MessageName::RemoteQueue_WriteTexture:
        return jsValueForDecodedMessageReply<MessageName::RemoteQueue_WriteTexture>(globalObject, decoder);
#endif
#if ENABLE(GPU_PROCESS)
#endif
#if ENABLE(GPU_PROCESS)
#endif
#if ENABLE(GPU_PROCESS)
#endif
#if ENABLE(GPU_PROCESS)
#endif
#if ENABLE(GPU_PROCESS)
#endif
#if ENABLE(GPU_PROCESS)
    case MessageName::RemoteShaderModule_CompilationInfo:
        return jsValueForDecodedMessageReply<MessageName::RemoteShaderModule_CompilationInfo>(globalObject, decoder);
#endif
#if ENABLE(GPU_PROCESS)
#endif
#if ENABLE(GPU_PROCESS)
#endif
#if ENABLE(GPU_PROCESS)
#endif
#if ENABLE(GPU_PROCESS)
#endif
#if ENABLE(GPU_PROCESS)
#endif
#if ENABLE(GPU_PROCESS)
#endif
#if ENABLE(GPU_PROCESS) && ENABLE(WEB_AUDIO)
    case MessageName::RemoteAudioDestinationManager_CreateAudioDestination:
        return jsValueForDecodedMessageReply<MessageName::RemoteAudioDestinationManager_CreateAudioDestination>(globalObject, decoder);
    case MessageName::RemoteAudioDestinationManager_StartAudioDestination:
        return jsValueForDecodedMessageReply<MessageName::RemoteAudioDestinationManager_StartAudioDestination>(globalObject, decoder);
    case MessageName::RemoteAudioDestinationManager_StopAudioDestination:
        return jsValueForDecodedMessageReply<MessageName::RemoteAudioDestinationManager_StopAudioDestination>(globalObject, decoder);
#endif
#if ENABLE(GPU_PROCESS) && USE(AUDIO_SESSION)
    case MessageName::RemoteAudioSessionProxy_TryToSetActive:
        return jsValueForDecodedMessageReply<MessageName::RemoteAudioSessionProxy_TryToSetActive>(globalObject, decoder);
#endif
#if ENABLE(GPU_PROCESS) && ENABLE(ENCRYPTED_MEDIA)
    case MessageName::RemoteCDMFactoryProxy_CreateCDM:
        return jsValueForDecodedMessageReply<MessageName::RemoteCDMFactoryProxy_CreateCDM>(globalObject, decoder);
    case MessageName::RemoteCDMFactoryProxy_SupportsKeySystem:
        return jsValueForDecodedMessageReply<MessageName::RemoteCDMFactoryProxy_SupportsKeySystem>(globalObject, decoder);
#endif
#if ENABLE(GPU_PROCESS) && ENABLE(ENCRYPTED_MEDIA)
    case MessageName::RemoteCDMInstanceProxy_CreateSession:
        return jsValueForDecodedMessageReply<MessageName::RemoteCDMInstanceProxy_CreateSession>(globalObject, decoder);
    case MessageName::RemoteCDMInstanceProxy_InitializeWithConfiguration:
        return jsValueForDecodedMessageReply<MessageName::RemoteCDMInstanceProxy_InitializeWithConfiguration>(globalObject, decoder);
    case MessageName::RemoteCDMInstanceProxy_SetServerCertificate:
        return jsValueForDecodedMessageReply<MessageName::RemoteCDMInstanceProxy_SetServerCertificate>(globalObject, decoder);
#endif
#if ENABLE(GPU_PROCESS) && ENABLE(ENCRYPTED_MEDIA)
    case MessageName::RemoteCDMInstanceSessionProxy_RequestLicense:
        return jsValueForDecodedMessageReply<MessageName::RemoteCDMInstanceSessionProxy_RequestLicense>(globalObject, decoder);
    case MessageName::RemoteCDMInstanceSessionProxy_UpdateLicense:
        return jsValueForDecodedMessageReply<MessageName::RemoteCDMInstanceSessionProxy_UpdateLicense>(globalObject, decoder);
    case MessageName::RemoteCDMInstanceSessionProxy_LoadSession:
        return jsValueForDecodedMessageReply<MessageName::RemoteCDMInstanceSessionProxy_LoadSession>(globalObject, decoder);
    case MessageName::RemoteCDMInstanceSessionProxy_CloseSession:
        return jsValueForDecodedMessageReply<MessageName::RemoteCDMInstanceSessionProxy_CloseSession>(globalObject, decoder);
    case MessageName::RemoteCDMInstanceSessionProxy_RemoveSessionData:
        return jsValueForDecodedMessageReply<MessageName::RemoteCDMInstanceSessionProxy_RemoveSessionData>(globalObject, decoder);
#endif
#if ENABLE(GPU_PROCESS) && ENABLE(ENCRYPTED_MEDIA)
    case MessageName::RemoteCDMProxy_GetSupportedConfiguration:
        return jsValueForDecodedMessageReply<MessageName::RemoteCDMProxy_GetSupportedConfiguration>(globalObject, decoder);
    case MessageName::RemoteCDMProxy_CreateInstance:
        return jsValueForDecodedMessageReply<MessageName::RemoteCDMProxy_CreateInstance>(globalObject, decoder);
#endif
#if ENABLE(GPU_PROCESS) && ENABLE(LEGACY_ENCRYPTED_MEDIA)
    case MessageName::RemoteLegacyCDMFactoryProxy_CreateCDM:
        return jsValueForDecodedMessageReply<MessageName::RemoteLegacyCDMFactoryProxy_CreateCDM>(globalObject, decoder);
    case MessageName::RemoteLegacyCDMFactoryProxy_SupportsKeySystem:
        return jsValueForDecodedMessageReply<MessageName::RemoteLegacyCDMFactoryProxy_SupportsKeySystem>(globalObject, decoder);
    case MessageName::RemoteLegacyCDMFactoryProxy_RemoveSession:
        return jsValueForDecodedMessageReply<MessageName::RemoteLegacyCDMFactoryProxy_RemoveSession>(globalObject, decoder);
#endif
#if ENABLE(GPU_PROCESS) && ENABLE(LEGACY_ENCRYPTED_MEDIA)
    case MessageName::RemoteLegacyCDMProxy_SupportsMIMEType:
        return jsValueForDecodedMessageReply<MessageName::RemoteLegacyCDMProxy_SupportsMIMEType>(globalObject, decoder);
    case MessageName::RemoteLegacyCDMProxy_CreateSession:
        return jsValueForDecodedMessageReply<MessageName::RemoteLegacyCDMProxy_CreateSession>(globalObject, decoder);
#endif
#if ENABLE(GPU_PROCESS) && ENABLE(LEGACY_ENCRYPTED_MEDIA)
    case MessageName::RemoteLegacyCDMSessionProxy_GenerateKeyRequest:
        return jsValueForDecodedMessageReply<MessageName::RemoteLegacyCDMSessionProxy_GenerateKeyRequest>(globalObject, decoder);
    case MessageName::RemoteLegacyCDMSessionProxy_Update:
        return jsValueForDecodedMessageReply<MessageName::RemoteLegacyCDMSessionProxy_Update>(globalObject, decoder);
    case MessageName::RemoteLegacyCDMSessionProxy_CachedKeyForKeyID:
        return jsValueForDecodedMessageReply<MessageName::RemoteLegacyCDMSessionProxy_CachedKeyForKeyID>(globalObject, decoder);
#endif
#if ENABLE(GPU_PROCESS)
    case MessageName::RemoteMediaEngineConfigurationFactoryProxy_CreateDecodingConfiguration:
        return jsValueForDecodedMessageReply<MessageName::RemoteMediaEngineConfigurationFactoryProxy_CreateDecodingConfiguration>(globalObject, decoder);
    case MessageName::RemoteMediaEngineConfigurationFactoryProxy_CreateEncodingConfiguration:
        return jsValueForDecodedMessageReply<MessageName::RemoteMediaEngineConfigurationFactoryProxy_CreateEncodingConfiguration>(globalObject, decoder);
#endif
#if ENABLE(GPU_PROCESS) && ENABLE(VIDEO)
    case MessageName::RemoteMediaPlayerManagerProxy_GetSupportedTypes:
        return jsValueForDecodedMessageReply<MessageName::RemoteMediaPlayerManagerProxy_GetSupportedTypes>(globalObject, decoder);
    case MessageName::RemoteMediaPlayerManagerProxy_SupportsTypeAndCodecs:
        return jsValueForDecodedMessageReply<MessageName::RemoteMediaPlayerManagerProxy_SupportsTypeAndCodecs>(globalObject, decoder);
    case MessageName::RemoteMediaPlayerManagerProxy_SupportsKeySystem:
        return jsValueForDecodedMessageReply<MessageName::RemoteMediaPlayerManagerProxy_SupportsKeySystem>(globalObject, decoder);
#endif
#if ENABLE(GPU_PROCESS) && ENABLE(VIDEO)
    case MessageName::RemoteMediaPlayerProxy_Load:
        return jsValueForDecodedMessageReply<MessageName::RemoteMediaPlayerProxy_Load>(globalObject, decoder);
#if ENABLE(MEDIA_SOURCE)
    case MessageName::RemoteMediaPlayerProxy_LoadMediaSource:
        return jsValueForDecodedMessageReply<MessageName::RemoteMediaPlayerProxy_LoadMediaSource>(globalObject, decoder);
#endif
    case MessageName::RemoteMediaPlayerProxy_DidLoadingProgress:
        return jsValueForDecodedMessageReply<MessageName::RemoteMediaPlayerProxy_DidLoadingProgress>(globalObject, decoder);
    case MessageName::RemoteMediaPlayerProxy_PerformTaskAtTime:
        return jsValueForDecodedMessageReply<MessageName::RemoteMediaPlayerProxy_PerformTaskAtTime>(globalObject, decoder);
    case MessageName::RemoteMediaPlayerProxy_IsCrossOrigin:
        return jsValueForDecodedMessageReply<MessageName::RemoteMediaPlayerProxy_IsCrossOrigin>(globalObject, decoder);
#if PLATFORM(IOS_FAMILY)
    case MessageName::RemoteMediaPlayerProxy_ErrorLog:
        return jsValueForDecodedMessageReply<MessageName::RemoteMediaPlayerProxy_ErrorLog>(globalObject, decoder);
    case MessageName::RemoteMediaPlayerProxy_AccessLog:
        return jsValueForDecodedMessageReply<MessageName::RemoteMediaPlayerProxy_AccessLog>(globalObject, decoder);
#endif
#if PLATFORM(COCOA)
    case MessageName::RemoteMediaPlayerProxy_NativeImageForCurrentTime:
        return jsValueForDecodedMessageReply<MessageName::RemoteMediaPlayerProxy_NativeImageForCurrentTime>(globalObject, decoder);
    case MessageName::RemoteMediaPlayerProxy_ColorSpace:
        return jsValueForDecodedMessageReply<MessageName::RemoteMediaPlayerProxy_ColorSpace>(globalObject, decoder);
#endif
    case MessageName::RemoteMediaPlayerProxy_VideoFrameForCurrentTimeIfChanged:
        return jsValueForDecodedMessageReply<MessageName::RemoteMediaPlayerProxy_VideoFrameForCurrentTimeIfChanged>(globalObject, decoder);
    case MessageName::RemoteMediaPlayerProxy_RequestHostingContext:
        return jsValueForDecodedMessageReply<MessageName::RemoteMediaPlayerProxy_RequestHostingContext>(globalObject, decoder);
#endif
#if ENABLE(GPU_PROCESS) && ENABLE(VIDEO)
    case MessageName::RemoteMediaResourceManager_ResponseReceived:
        return jsValueForDecodedMessageReply<MessageName::RemoteMediaResourceManager_ResponseReceived>(globalObject, decoder);
    case MessageName::RemoteMediaResourceManager_RedirectReceived:
        return jsValueForDecodedMessageReply<MessageName::RemoteMediaResourceManager_RedirectReceived>(globalObject, decoder);
    case MessageName::RemoteMediaResourceManager_DataReceived:
        return jsValueForDecodedMessageReply<MessageName::RemoteMediaResourceManager_DataReceived>(globalObject, decoder);
#endif
#if ENABLE(GPU_PROCESS) && ENABLE(MEDIA_SOURCE)
    case MessageName::RemoteMediaSourceProxy_AddSourceBuffer:
        return jsValueForDecodedMessageReply<MessageName::RemoteMediaSourceProxy_AddSourceBuffer>(globalObject, decoder);
#endif
#if ENABLE(GPU_PROCESS)
#endif
#if ENABLE(GPU_PROCESS) && ENABLE(MEDIA_SOURCE)
    case MessageName::RemoteSourceBufferProxy_CanSwitchToType:
        return jsValueForDecodedMessageReply<MessageName::RemoteSourceBufferProxy_CanSwitchToType>(globalObject, decoder);
    case MessageName::RemoteSourceBufferProxy_Append:
        return jsValueForDecodedMessageReply<MessageName::RemoteSourceBufferProxy_Append>(globalObject, decoder);
    case MessageName::RemoteSourceBufferProxy_RemoveCodedFrames:
        return jsValueForDecodedMessageReply<MessageName::RemoteSourceBufferProxy_RemoveCodedFrames>(globalObject, decoder);
    case MessageName::RemoteSourceBufferProxy_EvictCodedFrames:
        return jsValueForDecodedMessageReply<MessageName::RemoteSourceBufferProxy_EvictCodedFrames>(globalObject, decoder);
    case MessageName::RemoteSourceBufferProxy_SetMaximumBufferSize:
        return jsValueForDecodedMessageReply<MessageName::RemoteSourceBufferProxy_SetMaximumBufferSize>(globalObject, decoder);
    case MessageName::RemoteSourceBufferProxy_ComputeSeekTime:
        return jsValueForDecodedMessageReply<MessageName::RemoteSourceBufferProxy_ComputeSeekTime>(globalObject, decoder);
    case MessageName::RemoteSourceBufferProxy_BufferedSamplesForTrackId:
        return jsValueForDecodedMessageReply<MessageName::RemoteSourceBufferProxy_BufferedSamplesForTrackId>(globalObject, decoder);
    case MessageName::RemoteSourceBufferProxy_EnqueuedSamplesForTrackID:
        return jsValueForDecodedMessageReply<MessageName::RemoteSourceBufferProxy_EnqueuedSamplesForTrackID>(globalObject, decoder);
    case MessageName::RemoteSourceBufferProxy_MinimumUpcomingPresentationTimeForTrackID:
        return jsValueForDecodedMessageReply<MessageName::RemoteSourceBufferProxy_MinimumUpcomingPresentationTimeForTrackID>(globalObject, decoder);
#endif
#if ENABLE(GPU_PROCESS) && ENABLE(VIDEO)
#if PLATFORM(COCOA)
    case MessageName::RemoteVideoFrameObjectHeap_PixelBuffer:
        return jsValueForDecodedMessageReply<MessageName::RemoteVideoFrameObjectHeap_PixelBuffer>(globalObject, decoder);
    case MessageName::RemoteVideoFrameObjectHeap_ConvertFrameBuffer:
        return jsValueForDecodedMessageReply<MessageName::RemoteVideoFrameObjectHeap_ConvertFrameBuffer>(globalObject, decoder);
#endif
#endif
#if USE(LIBWEBRTC) && PLATFORM(COCOA) && ENABLE(GPU_PROCESS)
    case MessageName::LibWebRTCCodecsProxy_CreateDecoder:
        return jsValueForDecodedMessageReply<MessageName::LibWebRTCCodecsProxy_CreateDecoder>(globalObject, decoder);
    case MessageName::LibWebRTCCodecsProxy_FlushDecoder:
        return jsValueForDecodedMessageReply<MessageName::LibWebRTCCodecsProxy_FlushDecoder>(globalObject, decoder);
    case MessageName::LibWebRTCCodecsProxy_DecodeFrame:
        return jsValueForDecodedMessageReply<MessageName::LibWebRTCCodecsProxy_DecodeFrame>(globalObject, decoder);
    case MessageName::LibWebRTCCodecsProxy_CreateEncoder:
        return jsValueForDecodedMessageReply<MessageName::LibWebRTCCodecsProxy_CreateEncoder>(globalObject, decoder);
    case MessageName::LibWebRTCCodecsProxy_EncodeFrame:
        return jsValueForDecodedMessageReply<MessageName::LibWebRTCCodecsProxy_EncodeFrame>(globalObject, decoder);
    case MessageName::LibWebRTCCodecsProxy_FlushEncoder:
        return jsValueForDecodedMessageReply<MessageName::LibWebRTCCodecsProxy_FlushEncoder>(globalObject, decoder);
    case MessageName::LibWebRTCCodecsProxy_SetEncodeRates:
        return jsValueForDecodedMessageReply<MessageName::LibWebRTCCodecsProxy_SetEncodeRates>(globalObject, decoder);
#endif
#if ENABLE(GPU_PROCESS) && ENABLE(MEDIA_STREAM) && PLATFORM(COCOA)
    case MessageName::RemoteAudioMediaStreamTrackRendererInternalUnitManager_CreateUnit:
        return jsValueForDecodedMessageReply<MessageName::RemoteAudioMediaStreamTrackRendererInternalUnitManager_CreateUnit>(globalObject, decoder);
#endif
#if PLATFORM(COCOA) && ENABLE(GPU_PROCESS) && ENABLE(MEDIA_STREAM)
#endif
#if PLATFORM(COCOA) && ENABLE(GPU_PROCESS) && ENABLE(MEDIA_STREAM)
    case MessageName::RemoteSampleBufferDisplayLayerManager_CreateLayer:
        return jsValueForDecodedMessageReply<MessageName::RemoteSampleBufferDisplayLayerManager_CreateLayer>(globalObject, decoder);
#endif
#if ENABLE(MODEL_PROCESS)
#endif
#if ENABLE(MODEL_PROCESS)
    case MessageName::ModelProcess_InitializeModelProcess:
        return jsValueForDecodedMessageReply<MessageName::ModelProcess_InitializeModelProcess>(globalObject, decoder);
    case MessageName::ModelProcess_CreateModelConnectionToWebProcess:
        return jsValueForDecodedMessageReply<MessageName::ModelProcess_CreateModelConnectionToWebProcess>(globalObject, decoder);
    case MessageName::ModelProcess_SharedPreferencesForWebProcessDidChange:
        return jsValueForDecodedMessageReply<MessageName::ModelProcess_SharedPreferencesForWebProcessDidChange>(globalObject, decoder);
    case MessageName::ModelProcess_PrepareToSuspend:
        return jsValueForDecodedMessageReply<MessageName::ModelProcess_PrepareToSuspend>(globalObject, decoder);
    case MessageName::ModelProcess_WebProcessConnectionCountForTesting:
        return jsValueForDecodedMessageReply<MessageName::ModelProcess_WebProcessConnectionCountForTesting>(globalObject, decoder);
    case MessageName::ModelProcess_ModelPlayerCountForTesting:
        return jsValueForDecodedMessageReply<MessageName::ModelProcess_ModelPlayerCountForTesting>(globalObject, decoder);
#endif
#if ENABLE(MODEL_PROCESS)
#endif
    case MessageName::WebCookieManager_GetHostnamesWithCookies:
        return jsValueForDecodedMessageReply<MessageName::WebCookieManager_GetHostnamesWithCookies>(globalObject, decoder);
    case MessageName::WebCookieManager_DeleteCookiesForHostnames:
        return jsValueForDecodedMessageReply<MessageName::WebCookieManager_DeleteCookiesForHostnames>(globalObject, decoder);
    case MessageName::WebCookieManager_DeleteAllCookies:
        return jsValueForDecodedMessageReply<MessageName::WebCookieManager_DeleteAllCookies>(globalObject, decoder);
    case MessageName::WebCookieManager_SetCookie:
        return jsValueForDecodedMessageReply<MessageName::WebCookieManager_SetCookie>(globalObject, decoder);
    case MessageName::WebCookieManager_SetCookies:
        return jsValueForDecodedMessageReply<MessageName::WebCookieManager_SetCookies>(globalObject, decoder);
    case MessageName::WebCookieManager_GetAllCookies:
        return jsValueForDecodedMessageReply<MessageName::WebCookieManager_GetAllCookies>(globalObject, decoder);
    case MessageName::WebCookieManager_GetCookies:
        return jsValueForDecodedMessageReply<MessageName::WebCookieManager_GetCookies>(globalObject, decoder);
    case MessageName::WebCookieManager_DeleteCookie:
        return jsValueForDecodedMessageReply<MessageName::WebCookieManager_DeleteCookie>(globalObject, decoder);
    case MessageName::WebCookieManager_DeleteAllCookiesModifiedSince:
        return jsValueForDecodedMessageReply<MessageName::WebCookieManager_DeleteAllCookiesModifiedSince>(globalObject, decoder);
    case MessageName::WebCookieManager_SetHTTPCookieAcceptPolicy:
        return jsValueForDecodedMessageReply<MessageName::WebCookieManager_SetHTTPCookieAcceptPolicy>(globalObject, decoder);
    case MessageName::WebCookieManager_GetHTTPCookieAcceptPolicy:
        return jsValueForDecodedMessageReply<MessageName::WebCookieManager_GetHTTPCookieAcceptPolicy>(globalObject, decoder);
#if USE(SOUP)
    case MessageName::WebCookieManager_ReplaceCookies:
        return jsValueForDecodedMessageReply<MessageName::WebCookieManager_ReplaceCookies>(globalObject, decoder);
#endif
    case MessageName::NetworkBroadcastChannelRegistry_PostMessage:
        return jsValueForDecodedMessageReply<MessageName::NetworkBroadcastChannelRegistry_PostMessage>(globalObject, decoder);
    case MessageName::NetworkConnectionToWebProcess_PerformSynchronousLoad:
        return jsValueForDecodedMessageReply<MessageName::NetworkConnectionToWebProcess_PerformSynchronousLoad>(globalObject, decoder);
    case MessageName::NetworkConnectionToWebProcess_TestProcessIncomingSyncMessagesWhenWaitingForSyncReply:
        return jsValueForDecodedMessageReply<MessageName::NetworkConnectionToWebProcess_TestProcessIncomingSyncMessagesWhenWaitingForSyncReply>(globalObject, decoder);
    case MessageName::NetworkConnectionToWebProcess_SendH2Ping:
        return jsValueForDecodedMessageReply<MessageName::NetworkConnectionToWebProcess_SendH2Ping>(globalObject, decoder);
    case MessageName::NetworkConnectionToWebProcess_IsResourceLoadFinished:
        return jsValueForDecodedMessageReply<MessageName::NetworkConnectionToWebProcess_IsResourceLoadFinished>(globalObject, decoder);
    case MessageName::NetworkConnectionToWebProcess_CookiesForDOM:
        return jsValueForDecodedMessageReply<MessageName::NetworkConnectionToWebProcess_CookiesForDOM>(globalObject, decoder);
    case MessageName::NetworkConnectionToWebProcess_CookiesEnabledSync:
        return jsValueForDecodedMessageReply<MessageName::NetworkConnectionToWebProcess_CookiesEnabledSync>(globalObject, decoder);
    case MessageName::NetworkConnectionToWebProcess_CookiesEnabled:
        return jsValueForDecodedMessageReply<MessageName::NetworkConnectionToWebProcess_CookiesEnabled>(globalObject, decoder);
    case MessageName::NetworkConnectionToWebProcess_CookieRequestHeaderFieldValue:
        return jsValueForDecodedMessageReply<MessageName::NetworkConnectionToWebProcess_CookieRequestHeaderFieldValue>(globalObject, decoder);
    case MessageName::NetworkConnectionToWebProcess_GetRawCookies:
        return jsValueForDecodedMessageReply<MessageName::NetworkConnectionToWebProcess_GetRawCookies>(globalObject, decoder);
    case MessageName::NetworkConnectionToWebProcess_DeleteCookie:
        return jsValueForDecodedMessageReply<MessageName::NetworkConnectionToWebProcess_DeleteCookie>(globalObject, decoder);
    case MessageName::NetworkConnectionToWebProcess_DomCookiesForHost:
        return jsValueForDecodedMessageReply<MessageName::NetworkConnectionToWebProcess_DomCookiesForHost>(globalObject, decoder);
    case MessageName::NetworkConnectionToWebProcess_CookiesForDOMAsync:
        return jsValueForDecodedMessageReply<MessageName::NetworkConnectionToWebProcess_CookiesForDOMAsync>(globalObject, decoder);
    case MessageName::NetworkConnectionToWebProcess_SetCookieFromDOMAsync:
        return jsValueForDecodedMessageReply<MessageName::NetworkConnectionToWebProcess_SetCookieFromDOMAsync>(globalObject, decoder);
#if HAVE(COOKIE_CHANGE_LISTENER_API)
    case MessageName::NetworkConnectionToWebProcess_SubscribeToCookieChangeNotifications:
        return jsValueForDecodedMessageReply<MessageName::NetworkConnectionToWebProcess_SubscribeToCookieChangeNotifications>(globalObject, decoder);
#endif
    case MessageName::NetworkConnectionToWebProcess_BlobType:
        return jsValueForDecodedMessageReply<MessageName::NetworkConnectionToWebProcess_BlobType>(globalObject, decoder);
    case MessageName::NetworkConnectionToWebProcess_BlobSize:
        return jsValueForDecodedMessageReply<MessageName::NetworkConnectionToWebProcess_BlobSize>(globalObject, decoder);
    case MessageName::NetworkConnectionToWebProcess_WriteBlobsToTemporaryFilesForIndexedDB:
        return jsValueForDecodedMessageReply<MessageName::NetworkConnectionToWebProcess_WriteBlobsToTemporaryFilesForIndexedDB>(globalObject, decoder);
    case MessageName::NetworkConnectionToWebProcess_RegisterBlobPathForTesting:
        return jsValueForDecodedMessageReply<MessageName::NetworkConnectionToWebProcess_RegisterBlobPathForTesting>(globalObject, decoder);
    case MessageName::NetworkConnectionToWebProcess_ResourceLoadStatisticsUpdated:
        return jsValueForDecodedMessageReply<MessageName::NetworkConnectionToWebProcess_ResourceLoadStatisticsUpdated>(globalObject, decoder);
    case MessageName::NetworkConnectionToWebProcess_HasStorageAccess:
        return jsValueForDecodedMessageReply<MessageName::NetworkConnectionToWebProcess_HasStorageAccess>(globalObject, decoder);
    case MessageName::NetworkConnectionToWebProcess_RequestStorageAccess:
        return jsValueForDecodedMessageReply<MessageName::NetworkConnectionToWebProcess_RequestStorageAccess>(globalObject, decoder);
    case MessageName::NetworkConnectionToWebProcess_StorageAccessQuirkForTopFrameDomain:
        return jsValueForDecodedMessageReply<MessageName::NetworkConnectionToWebProcess_StorageAccessQuirkForTopFrameDomain>(globalObject, decoder);
    case MessageName::NetworkConnectionToWebProcess_GetNetworkLoadInformationResponse:
        return jsValueForDecodedMessageReply<MessageName::NetworkConnectionToWebProcess_GetNetworkLoadInformationResponse>(globalObject, decoder);
    case MessageName::NetworkConnectionToWebProcess_GetNetworkLoadIntermediateInformation:
        return jsValueForDecodedMessageReply<MessageName::NetworkConnectionToWebProcess_GetNetworkLoadIntermediateInformation>(globalObject, decoder);
    case MessageName::NetworkConnectionToWebProcess_TakeNetworkLoadInformationMetrics:
        return jsValueForDecodedMessageReply<MessageName::NetworkConnectionToWebProcess_TakeNetworkLoadInformationMetrics>(globalObject, decoder);
    case MessageName::NetworkConnectionToWebProcess_EstablishSWContextConnection:
        return jsValueForDecodedMessageReply<MessageName::NetworkConnectionToWebProcess_EstablishSWContextConnection>(globalObject, decoder);
    case MessageName::NetworkConnectionToWebProcess_PingPongForServiceWorkers:
        return jsValueForDecodedMessageReply<MessageName::NetworkConnectionToWebProcess_PingPongForServiceWorkers>(globalObject, decoder);
    case MessageName::NetworkConnectionToWebProcess_EstablishSharedWorkerContextConnection:
        return jsValueForDecodedMessageReply<MessageName::NetworkConnectionToWebProcess_EstablishSharedWorkerContextConnection>(globalObject, decoder);
    case MessageName::NetworkConnectionToWebProcess_CreateRTCProvider:
        return jsValueForDecodedMessageReply<MessageName::NetworkConnectionToWebProcess_CreateRTCProvider>(globalObject, decoder);
#if ENABLE(WEB_RTC)
    case MessageName::NetworkConnectionToWebProcess_ConnectToRTCDataChannelRemoteSource:
        return jsValueForDecodedMessageReply<MessageName::NetworkConnectionToWebProcess_ConnectToRTCDataChannelRemoteSource>(globalObject, decoder);
#endif
    case MessageName::NetworkConnectionToWebProcess_TakeAllMessagesForPort:
        return jsValueForDecodedMessageReply<MessageName::NetworkConnectionToWebProcess_TakeAllMessagesForPort>(globalObject, decoder);
#if PLATFORM(MAC)
    case MessageName::NetworkConnectionToWebProcess_GetProcessDisplayName:
        return jsValueForDecodedMessageReply<MessageName::NetworkConnectionToWebProcess_GetProcessDisplayName>(globalObject, decoder);
#endif
#if ENABLE(DECLARATIVE_WEB_PUSH)
    case MessageName::NetworkConnectionToWebProcess_NavigatorSubscribeToPushService:
        return jsValueForDecodedMessageReply<MessageName::NetworkConnectionToWebProcess_NavigatorSubscribeToPushService>(globalObject, decoder);
    case MessageName::NetworkConnectionToWebProcess_NavigatorUnsubscribeFromPushService:
        return jsValueForDecodedMessageReply<MessageName::NetworkConnectionToWebProcess_NavigatorUnsubscribeFromPushService>(globalObject, decoder);
    case MessageName::NetworkConnectionToWebProcess_NavigatorGetPushSubscription:
        return jsValueForDecodedMessageReply<MessageName::NetworkConnectionToWebProcess_NavigatorGetPushSubscription>(globalObject, decoder);
    case MessageName::NetworkConnectionToWebProcess_NavigatorGetPushPermissionState:
        return jsValueForDecodedMessageReply<MessageName::NetworkConnectionToWebProcess_NavigatorGetPushPermissionState>(globalObject, decoder);
#endif
    case MessageName::NetworkConnectionToWebProcess_InitializeWebTransportSession:
        return jsValueForDecodedMessageReply<MessageName::NetworkConnectionToWebProcess_InitializeWebTransportSession>(globalObject, decoder);
    case MessageName::NetworkConnectionToWebProcess_LoadImageForDecoding:
        return jsValueForDecodedMessageReply<MessageName::NetworkConnectionToWebProcess_LoadImageForDecoding>(globalObject, decoder);
    case MessageName::NetworkConnectionToWebProcess_SetLoginStatus:
        return jsValueForDecodedMessageReply<MessageName::NetworkConnectionToWebProcess_SetLoginStatus>(globalObject, decoder);
    case MessageName::NetworkConnectionToWebProcess_IsLoggedIn:
        return jsValueForDecodedMessageReply<MessageName::NetworkConnectionToWebProcess_IsLoggedIn>(globalObject, decoder);
#if ENABLE(CONTENT_EXTENSIONS)
    case MessageName::NetworkConnectionToWebProcess_ShouldOffloadIFrameForHost:
        return jsValueForDecodedMessageReply<MessageName::NetworkConnectionToWebProcess_ShouldOffloadIFrameForHost>(globalObject, decoder);
#endif
#if ENABLE(CONTENT_EXTENSIONS)
#endif
    case MessageName::NetworkProcess_InitializeNetworkProcess:
        return jsValueForDecodedMessageReply<MessageName::NetworkProcess_InitializeNetworkProcess>(globalObject, decoder);
    case MessageName::NetworkProcess_CreateNetworkConnectionToWebProcess:
        return jsValueForDecodedMessageReply<MessageName::NetworkProcess_CreateNetworkConnectionToWebProcess>(globalObject, decoder);
    case MessageName::NetworkProcess_SharedPreferencesForWebProcessDidChange:
        return jsValueForDecodedMessageReply<MessageName::NetworkProcess_SharedPreferencesForWebProcessDidChange>(globalObject, decoder);
    case MessageName::NetworkProcess_AddAllowedFirstPartyForCookies:
        return jsValueForDecodedMessageReply<MessageName::NetworkProcess_AddAllowedFirstPartyForCookies>(globalObject, decoder);
    case MessageName::NetworkProcess_DestroySession:
        return jsValueForDecodedMessageReply<MessageName::NetworkProcess_DestroySession>(globalObject, decoder);
    case MessageName::NetworkProcess_EnsureSessionWithDataStoreIdentifierRemoved:
        return jsValueForDecodedMessageReply<MessageName::NetworkProcess_EnsureSessionWithDataStoreIdentifierRemoved>(globalObject, decoder);
    case MessageName::NetworkProcess_FetchWebsiteData:
        return jsValueForDecodedMessageReply<MessageName::NetworkProcess_FetchWebsiteData>(globalObject, decoder);
    case MessageName::NetworkProcess_DeleteWebsiteData:
        return jsValueForDecodedMessageReply<MessageName::NetworkProcess_DeleteWebsiteData>(globalObject, decoder);
    case MessageName::NetworkProcess_DeleteWebsiteDataForOrigins:
        return jsValueForDecodedMessageReply<MessageName::NetworkProcess_DeleteWebsiteDataForOrigins>(globalObject, decoder);
    case MessageName::NetworkProcess_RenameOriginInWebsiteData:
        return jsValueForDecodedMessageReply<MessageName::NetworkProcess_RenameOriginInWebsiteData>(globalObject, decoder);
    case MessageName::NetworkProcess_WebsiteDataOriginDirectoryForTesting:
        return jsValueForDecodedMessageReply<MessageName::NetworkProcess_WebsiteDataOriginDirectoryForTesting>(globalObject, decoder);
    case MessageName::NetworkProcess_CancelDownload:
        return jsValueForDecodedMessageReply<MessageName::NetworkProcess_CancelDownload>(globalObject, decoder);
    case MessageName::NetworkProcess_DataTaskWithRequest:
        return jsValueForDecodedMessageReply<MessageName::NetworkProcess_DataTaskWithRequest>(globalObject, decoder);
    case MessageName::NetworkProcess_CancelDataTask:
        return jsValueForDecodedMessageReply<MessageName::NetworkProcess_CancelDataTask>(globalObject, decoder);
    case MessageName::NetworkProcess_FlushCookies:
        return jsValueForDecodedMessageReply<MessageName::NetworkProcess_FlushCookies>(globalObject, decoder);
    case MessageName::NetworkProcess_SetCacheModelSynchronouslyForTesting:
        return jsValueForDecodedMessageReply<MessageName::NetworkProcess_SetCacheModelSynchronouslyForTesting>(globalObject, decoder);
    case MessageName::NetworkProcess_ProcessWillSuspendImminentlyForTestingSync:
        return jsValueForDecodedMessageReply<MessageName::NetworkProcess_ProcessWillSuspendImminentlyForTestingSync>(globalObject, decoder);
    case MessageName::NetworkProcess_PrepareToSuspend:
        return jsValueForDecodedMessageReply<MessageName::NetworkProcess_PrepareToSuspend>(globalObject, decoder);
    case MessageName::NetworkProcess_ClearPrevalentResource:
        return jsValueForDecodedMessageReply<MessageName::NetworkProcess_ClearPrevalentResource>(globalObject, decoder);
    case MessageName::NetworkProcess_ClearUserInteraction:
        return jsValueForDecodedMessageReply<MessageName::NetworkProcess_ClearUserInteraction>(globalObject, decoder);
    case MessageName::NetworkProcess_DumpResourceLoadStatistics:
        return jsValueForDecodedMessageReply<MessageName::NetworkProcess_DumpResourceLoadStatistics>(globalObject, decoder);
    case MessageName::NetworkProcess_UpdatePrevalentDomainsToBlockCookiesFor:
        return jsValueForDecodedMessageReply<MessageName::NetworkProcess_UpdatePrevalentDomainsToBlockCookiesFor>(globalObject, decoder);
    case MessageName::NetworkProcess_IsGrandfathered:
        return jsValueForDecodedMessageReply<MessageName::NetworkProcess_IsGrandfathered>(globalObject, decoder);
    case MessageName::NetworkProcess_IsPrevalentResource:
        return jsValueForDecodedMessageReply<MessageName::NetworkProcess_IsPrevalentResource>(globalObject, decoder);
    case MessageName::NetworkProcess_IsVeryPrevalentResource:
        return jsValueForDecodedMessageReply<MessageName::NetworkProcess_IsVeryPrevalentResource>(globalObject, decoder);
    case MessageName::NetworkProcess_SetLastSeen:
        return jsValueForDecodedMessageReply<MessageName::NetworkProcess_SetLastSeen>(globalObject, decoder);
    case MessageName::NetworkProcess_MergeStatisticForTesting:
        return jsValueForDecodedMessageReply<MessageName::NetworkProcess_MergeStatisticForTesting>(globalObject, decoder);
    case MessageName::NetworkProcess_InsertExpiredStatisticForTesting:
        return jsValueForDecodedMessageReply<MessageName::NetworkProcess_InsertExpiredStatisticForTesting>(globalObject, decoder);
    case MessageName::NetworkProcess_SetPrevalentResource:
        return jsValueForDecodedMessageReply<MessageName::NetworkProcess_SetPrevalentResource>(globalObject, decoder);
    case MessageName::NetworkProcess_SetPrevalentResourceForDebugMode:
        return jsValueForDecodedMessageReply<MessageName::NetworkProcess_SetPrevalentResourceForDebugMode>(globalObject, decoder);
    case MessageName::NetworkProcess_IsResourceLoadStatisticsEphemeral:
        return jsValueForDecodedMessageReply<MessageName::NetworkProcess_IsResourceLoadStatisticsEphemeral>(globalObject, decoder);
    case MessageName::NetworkProcess_HadUserInteraction:
        return jsValueForDecodedMessageReply<MessageName::NetworkProcess_HadUserInteraction>(globalObject, decoder);
    case MessageName::NetworkProcess_IsRelationshipOnlyInDatabaseOnce:
        return jsValueForDecodedMessageReply<MessageName::NetworkProcess_IsRelationshipOnlyInDatabaseOnce>(globalObject, decoder);
    case MessageName::NetworkProcess_HasLocalStorage:
        return jsValueForDecodedMessageReply<MessageName::NetworkProcess_HasLocalStorage>(globalObject, decoder);
    case MessageName::NetworkProcess_GetAllStorageAccessEntries:
        return jsValueForDecodedMessageReply<MessageName::NetworkProcess_GetAllStorageAccessEntries>(globalObject, decoder);
    case MessageName::NetworkProcess_IsRegisteredAsRedirectingTo:
        return jsValueForDecodedMessageReply<MessageName::NetworkProcess_IsRegisteredAsRedirectingTo>(globalObject, decoder);
    case MessageName::NetworkProcess_IsRegisteredAsSubFrameUnder:
        return jsValueForDecodedMessageReply<MessageName::NetworkProcess_IsRegisteredAsSubFrameUnder>(globalObject, decoder);
    case MessageName::NetworkProcess_IsRegisteredAsSubresourceUnder:
        return jsValueForDecodedMessageReply<MessageName::NetworkProcess_IsRegisteredAsSubresourceUnder>(globalObject, decoder);
    case MessageName::NetworkProcess_DomainIDExistsInDatabase:
        return jsValueForDecodedMessageReply<MessageName::NetworkProcess_DomainIDExistsInDatabase>(globalObject, decoder);
    case MessageName::NetworkProcess_LogUserInteraction:
        return jsValueForDecodedMessageReply<MessageName::NetworkProcess_LogUserInteraction>(globalObject, decoder);
    case MessageName::NetworkProcess_ResetParametersToDefaultValues:
        return jsValueForDecodedMessageReply<MessageName::NetworkProcess_ResetParametersToDefaultValues>(globalObject, decoder);
    case MessageName::NetworkProcess_ScheduleClearInMemoryAndPersistent:
        return jsValueForDecodedMessageReply<MessageName::NetworkProcess_ScheduleClearInMemoryAndPersistent>(globalObject, decoder);
    case MessageName::NetworkProcess_ScheduleCookieBlockingUpdate:
        return jsValueForDecodedMessageReply<MessageName::NetworkProcess_ScheduleCookieBlockingUpdate>(globalObject, decoder);
    case MessageName::NetworkProcess_ScheduleStatisticsAndDataRecordsProcessing:
        return jsValueForDecodedMessageReply<MessageName::NetworkProcess_ScheduleStatisticsAndDataRecordsProcessing>(globalObject, decoder);
    case MessageName::NetworkProcess_StatisticsDatabaseHasAllTables:
        return jsValueForDecodedMessageReply<MessageName::NetworkProcess_StatisticsDatabaseHasAllTables>(globalObject, decoder);
    case MessageName::NetworkProcess_SetCacheMaxAgeCapForPrevalentResources:
        return jsValueForDecodedMessageReply<MessageName::NetworkProcess_SetCacheMaxAgeCapForPrevalentResources>(globalObject, decoder);
    case MessageName::NetworkProcess_SetGrandfathered:
        return jsValueForDecodedMessageReply<MessageName::NetworkProcess_SetGrandfathered>(globalObject, decoder);
    case MessageName::NetworkProcess_GetResourceLoadStatisticsDataSummary:
        return jsValueForDecodedMessageReply<MessageName::NetworkProcess_GetResourceLoadStatisticsDataSummary>(globalObject, decoder);
    case MessageName::NetworkProcess_SetGrandfatheringTime:
        return jsValueForDecodedMessageReply<MessageName::NetworkProcess_SetGrandfatheringTime>(globalObject, decoder);
    case MessageName::NetworkProcess_SetMaxStatisticsEntries:
        return jsValueForDecodedMessageReply<MessageName::NetworkProcess_SetMaxStatisticsEntries>(globalObject, decoder);
    case MessageName::NetworkProcess_SetMinimumTimeBetweenDataRecordsRemoval:
        return jsValueForDecodedMessageReply<MessageName::NetworkProcess_SetMinimumTimeBetweenDataRecordsRemoval>(globalObject, decoder);
    case MessageName::NetworkProcess_SetPruneEntriesDownTo:
        return jsValueForDecodedMessageReply<MessageName::NetworkProcess_SetPruneEntriesDownTo>(globalObject, decoder);
    case MessageName::NetworkProcess_SetShouldClassifyResourcesBeforeDataRecordsRemoval:
        return jsValueForDecodedMessageReply<MessageName::NetworkProcess_SetShouldClassifyResourcesBeforeDataRecordsRemoval>(globalObject, decoder);
    case MessageName::NetworkProcess_SetResourceLoadStatisticsTimeAdvanceForTesting:
        return jsValueForDecodedMessageReply<MessageName::NetworkProcess_SetResourceLoadStatisticsTimeAdvanceForTesting>(globalObject, decoder);
    case MessageName::NetworkProcess_SetIsRunningResourceLoadStatisticsTest:
        return jsValueForDecodedMessageReply<MessageName::NetworkProcess_SetIsRunningResourceLoadStatisticsTest>(globalObject, decoder);
    case MessageName::NetworkProcess_SetResourceLoadStatisticsDebugMode:
        return jsValueForDecodedMessageReply<MessageName::NetworkProcess_SetResourceLoadStatisticsDebugMode>(globalObject, decoder);
    case MessageName::NetworkProcess_SetVeryPrevalentResource:
        return jsValueForDecodedMessageReply<MessageName::NetworkProcess_SetVeryPrevalentResource>(globalObject, decoder);
    case MessageName::NetworkProcess_SetSubframeUnderTopFrameDomain:
        return jsValueForDecodedMessageReply<MessageName::NetworkProcess_SetSubframeUnderTopFrameDomain>(globalObject, decoder);
    case MessageName::NetworkProcess_SetSubresourceUnderTopFrameDomain:
        return jsValueForDecodedMessageReply<MessageName::NetworkProcess_SetSubresourceUnderTopFrameDomain>(globalObject, decoder);
    case MessageName::NetworkProcess_SetSubresourceUniqueRedirectTo:
        return jsValueForDecodedMessageReply<MessageName::NetworkProcess_SetSubresourceUniqueRedirectTo>(globalObject, decoder);
    case MessageName::NetworkProcess_SetSubresourceUniqueRedirectFrom:
        return jsValueForDecodedMessageReply<MessageName::NetworkProcess_SetSubresourceUniqueRedirectFrom>(globalObject, decoder);
    case MessageName::NetworkProcess_SetTimeToLiveUserInteraction:
        return jsValueForDecodedMessageReply<MessageName::NetworkProcess_SetTimeToLiveUserInteraction>(globalObject, decoder);
    case MessageName::NetworkProcess_SetTopFrameUniqueRedirectTo:
        return jsValueForDecodedMessageReply<MessageName::NetworkProcess_SetTopFrameUniqueRedirectTo>(globalObject, decoder);
    case MessageName::NetworkProcess_SetTopFrameUniqueRedirectFrom:
        return jsValueForDecodedMessageReply<MessageName::NetworkProcess_SetTopFrameUniqueRedirectFrom>(globalObject, decoder);
    case MessageName::NetworkProcess_ResetCacheMaxAgeCapForPrevalentResources:
        return jsValueForDecodedMessageReply<MessageName::NetworkProcess_ResetCacheMaxAgeCapForPrevalentResources>(globalObject, decoder);
    case MessageName::NetworkProcess_SetCrossSiteLoadWithLinkDecorationForTesting:
        return jsValueForDecodedMessageReply<MessageName::NetworkProcess_SetCrossSiteLoadWithLinkDecorationForTesting>(globalObject, decoder);
    case MessageName::NetworkProcess_ResetCrossSiteLoadsWithLinkDecorationForTesting:
        return jsValueForDecodedMessageReply<MessageName::NetworkProcess_ResetCrossSiteLoadsWithLinkDecorationForTesting>(globalObject, decoder);
    case MessageName::NetworkProcess_GrantStorageAccessForTesting:
        return jsValueForDecodedMessageReply<MessageName::NetworkProcess_GrantStorageAccessForTesting>(globalObject, decoder);
    case MessageName::NetworkProcess_SetStorageAccessPermissionForTesting:
        return jsValueForDecodedMessageReply<MessageName::NetworkProcess_SetStorageAccessPermissionForTesting>(globalObject, decoder);
    case MessageName::NetworkProcess_DeleteCookiesForTesting:
        return jsValueForDecodedMessageReply<MessageName::NetworkProcess_DeleteCookiesForTesting>(globalObject, decoder);
    case MessageName::NetworkProcess_HasIsolatedSession:
        return jsValueForDecodedMessageReply<MessageName::NetworkProcess_HasIsolatedSession>(globalObject, decoder);
    case MessageName::NetworkProcess_CloseITPDatabase:
        return jsValueForDecodedMessageReply<MessageName::NetworkProcess_CloseITPDatabase>(globalObject, decoder);
#if ENABLE(APP_BOUND_DOMAINS)
    case MessageName::NetworkProcess_SetAppBoundDomainsForResourceLoadStatistics:
        return jsValueForDecodedMessageReply<MessageName::NetworkProcess_SetAppBoundDomainsForResourceLoadStatistics>(globalObject, decoder);
#endif
#if ENABLE(MANAGED_DOMAINS)
    case MessageName::NetworkProcess_SetManagedDomainsForResourceLoadStatistics:
        return jsValueForDecodedMessageReply<MessageName::NetworkProcess_SetManagedDomainsForResourceLoadStatistics>(globalObject, decoder);
#endif
    case MessageName::NetworkProcess_SetShouldDowngradeReferrerForTesting:
        return jsValueForDecodedMessageReply<MessageName::NetworkProcess_SetShouldDowngradeReferrerForTesting>(globalObject, decoder);
    case MessageName::NetworkProcess_SetThirdPartyCookieBlockingMode:
        return jsValueForDecodedMessageReply<MessageName::NetworkProcess_SetThirdPartyCookieBlockingMode>(globalObject, decoder);
    case MessageName::NetworkProcess_SetShouldEnbleSameSiteStrictEnforcementForTesting:
        return jsValueForDecodedMessageReply<MessageName::NetworkProcess_SetShouldEnbleSameSiteStrictEnforcementForTesting>(globalObject, decoder);
    case MessageName::NetworkProcess_SetFirstPartyWebsiteDataRemovalModeForTesting:
        return jsValueForDecodedMessageReply<MessageName::NetworkProcess_SetFirstPartyWebsiteDataRemovalModeForTesting>(globalObject, decoder);
    case MessageName::NetworkProcess_SetToSameSiteStrictCookiesForTesting:
        return jsValueForDecodedMessageReply<MessageName::NetworkProcess_SetToSameSiteStrictCookiesForTesting>(globalObject, decoder);
    case MessageName::NetworkProcess_SetFirstPartyHostCNAMEDomainForTesting:
        return jsValueForDecodedMessageReply<MessageName::NetworkProcess_SetFirstPartyHostCNAMEDomainForTesting>(globalObject, decoder);
    case MessageName::NetworkProcess_SetThirdPartyCNAMEDomainForTesting:
        return jsValueForDecodedMessageReply<MessageName::NetworkProcess_SetThirdPartyCNAMEDomainForTesting>(globalObject, decoder);
    case MessageName::NetworkProcess_SyncLocalStorage:
        return jsValueForDecodedMessageReply<MessageName::NetworkProcess_SyncLocalStorage>(globalObject, decoder);
    case MessageName::NetworkProcess_StoreServiceWorkerRegistrations:
        return jsValueForDecodedMessageReply<MessageName::NetworkProcess_StoreServiceWorkerRegistrations>(globalObject, decoder);
    case MessageName::NetworkProcess_DumpPrivateClickMeasurement:
        return jsValueForDecodedMessageReply<MessageName::NetworkProcess_DumpPrivateClickMeasurement>(globalObject, decoder);
    case MessageName::NetworkProcess_ClearPrivateClickMeasurement:
        return jsValueForDecodedMessageReply<MessageName::NetworkProcess_ClearPrivateClickMeasurement>(globalObject, decoder);
    case MessageName::NetworkProcess_SetPrivateClickMeasurementOverrideTimerForTesting:
        return jsValueForDecodedMessageReply<MessageName::NetworkProcess_SetPrivateClickMeasurementOverrideTimerForTesting>(globalObject, decoder);
    case MessageName::NetworkProcess_MarkAttributedPrivateClickMeasurementsAsExpiredForTesting:
        return jsValueForDecodedMessageReply<MessageName::NetworkProcess_MarkAttributedPrivateClickMeasurementsAsExpiredForTesting>(globalObject, decoder);
    case MessageName::NetworkProcess_SetPrivateClickMeasurementEphemeralMeasurementForTesting:
        return jsValueForDecodedMessageReply<MessageName::NetworkProcess_SetPrivateClickMeasurementEphemeralMeasurementForTesting>(globalObject, decoder);
    case MessageName::NetworkProcess_SimulatePrivateClickMeasurementSessionRestart:
        return jsValueForDecodedMessageReply<MessageName::NetworkProcess_SimulatePrivateClickMeasurementSessionRestart>(globalObject, decoder);
    case MessageName::NetworkProcess_SetPrivateClickMeasurementTokenPublicKeyURLForTesting:
        return jsValueForDecodedMessageReply<MessageName::NetworkProcess_SetPrivateClickMeasurementTokenPublicKeyURLForTesting>(globalObject, decoder);
    case MessageName::NetworkProcess_SetPrivateClickMeasurementTokenSignatureURLForTesting:
        return jsValueForDecodedMessageReply<MessageName::NetworkProcess_SetPrivateClickMeasurementTokenSignatureURLForTesting>(globalObject, decoder);
    case MessageName::NetworkProcess_SetPrivateClickMeasurementAttributionReportURLsForTesting:
        return jsValueForDecodedMessageReply<MessageName::NetworkProcess_SetPrivateClickMeasurementAttributionReportURLsForTesting>(globalObject, decoder);
    case MessageName::NetworkProcess_MarkPrivateClickMeasurementsAsExpiredForTesting:
        return jsValueForDecodedMessageReply<MessageName::NetworkProcess_MarkPrivateClickMeasurementsAsExpiredForTesting>(globalObject, decoder);
    case MessageName::NetworkProcess_SetPCMFraudPreventionValuesForTesting:
        return jsValueForDecodedMessageReply<MessageName::NetworkProcess_SetPCMFraudPreventionValuesForTesting>(globalObject, decoder);
    case MessageName::NetworkProcess_SetPrivateClickMeasurementAppBundleIDForTesting:
        return jsValueForDecodedMessageReply<MessageName::NetworkProcess_SetPrivateClickMeasurementAppBundleIDForTesting>(globalObject, decoder);
    case MessageName::NetworkProcess_ClosePCMDatabase:
        return jsValueForDecodedMessageReply<MessageName::NetworkProcess_ClosePCMDatabase>(globalObject, decoder);
    case MessageName::NetworkProcess_SetServiceWorkerFetchTimeoutForTesting:
        return jsValueForDecodedMessageReply<MessageName::NetworkProcess_SetServiceWorkerFetchTimeoutForTesting>(globalObject, decoder);
    case MessageName::NetworkProcess_ResetServiceWorkerFetchTimeoutForTesting:
        return jsValueForDecodedMessageReply<MessageName::NetworkProcess_ResetServiceWorkerFetchTimeoutForTesting>(globalObject, decoder);
    case MessageName::NetworkProcess_TerminateIdleServiceWorkers:
        return jsValueForDecodedMessageReply<MessageName::NetworkProcess_TerminateIdleServiceWorkers>(globalObject, decoder);
    case MessageName::NetworkProcess_ResetQuota:
        return jsValueForDecodedMessageReply<MessageName::NetworkProcess_ResetQuota>(globalObject, decoder);
    case MessageName::NetworkProcess_SetOriginQuotaRatioEnabledForTesting:
        return jsValueForDecodedMessageReply<MessageName::NetworkProcess_SetOriginQuotaRatioEnabledForTesting>(globalObject, decoder);
#if PLATFORM(IOS_FAMILY)
    case MessageName::NetworkProcess_SetBackupExclusionPeriodForTesting:
        return jsValueForDecodedMessageReply<MessageName::NetworkProcess_SetBackupExclusionPeriodForTesting>(globalObject, decoder);
#endif
    case MessageName::NetworkProcess_ResetStoragePersistedState:
        return jsValueForDecodedMessageReply<MessageName::NetworkProcess_ResetStoragePersistedState>(globalObject, decoder);
#if ENABLE(APP_BOUND_DOMAINS)
    case MessageName::NetworkProcess_HasAppBoundSession:
        return jsValueForDecodedMessageReply<MessageName::NetworkProcess_HasAppBoundSession>(globalObject, decoder);
    case MessageName::NetworkProcess_ClearAppBoundSession:
        return jsValueForDecodedMessageReply<MessageName::NetworkProcess_ClearAppBoundSession>(globalObject, decoder);
#endif
#if PLATFORM(IOS_FAMILY) && !PLATFORM(MACCATALYST)
    case MessageName::NetworkProcess_ClearServiceWorkerEntitlementOverride:
        return jsValueForDecodedMessageReply<MessageName::NetworkProcess_ClearServiceWorkerEntitlementOverride>(globalObject, decoder);
#endif
    case MessageName::NetworkProcess_UpdateBundleIdentifier:
        return jsValueForDecodedMessageReply<MessageName::NetworkProcess_UpdateBundleIdentifier>(globalObject, decoder);
    case MessageName::NetworkProcess_ClearBundleIdentifier:
        return jsValueForDecodedMessageReply<MessageName::NetworkProcess_ClearBundleIdentifier>(globalObject, decoder);
#if PLATFORM(COCOA)
    case MessageName::NetworkProcess_AppPrivacyReportTestingData:
        return jsValueForDecodedMessageReply<MessageName::NetworkProcess_AppPrivacyReportTestingData>(globalObject, decoder);
    case MessageName::NetworkProcess_ClearAppPrivacyReportTestingData:
        return jsValueForDecodedMessageReply<MessageName::NetworkProcess_ClearAppPrivacyReportTestingData>(globalObject, decoder);
#endif
    case MessageName::NetworkProcess_CountNonDefaultSessionSets:
        return jsValueForDecodedMessageReply<MessageName::NetworkProcess_CountNonDefaultSessionSets>(globalObject, decoder);
    case MessageName::NetworkProcess_AllowFileAccessFromWebProcess:
        return jsValueForDecodedMessageReply<MessageName::NetworkProcess_AllowFileAccessFromWebProcess>(globalObject, decoder);
    case MessageName::NetworkProcess_AllowFilesAccessFromWebProcess:
        return jsValueForDecodedMessageReply<MessageName::NetworkProcess_AllowFilesAccessFromWebProcess>(globalObject, decoder);
    case MessageName::NetworkProcess_RunningOrTerminatingServiceWorkerCountForTesting:
        return jsValueForDecodedMessageReply<MessageName::NetworkProcess_RunningOrTerminatingServiceWorkerCountForTesting>(globalObject, decoder);
    case MessageName::NetworkProcess_GetPendingPushMessage:
        return jsValueForDecodedMessageReply<MessageName::NetworkProcess_GetPendingPushMessage>(globalObject, decoder);
    case MessageName::NetworkProcess_GetPendingPushMessages:
        return jsValueForDecodedMessageReply<MessageName::NetworkProcess_GetPendingPushMessages>(globalObject, decoder);
    case MessageName::NetworkProcess_ProcessPushMessage:
        return jsValueForDecodedMessageReply<MessageName::NetworkProcess_ProcessPushMessage>(globalObject, decoder);
    case MessageName::NetworkProcess_ProcessNotificationEvent:
        return jsValueForDecodedMessageReply<MessageName::NetworkProcess_ProcessNotificationEvent>(globalObject, decoder);
    case MessageName::NetworkProcess_GetAllBackgroundFetchIdentifiers:
        return jsValueForDecodedMessageReply<MessageName::NetworkProcess_GetAllBackgroundFetchIdentifiers>(globalObject, decoder);
    case MessageName::NetworkProcess_GetBackgroundFetchState:
        return jsValueForDecodedMessageReply<MessageName::NetworkProcess_GetBackgroundFetchState>(globalObject, decoder);
    case MessageName::NetworkProcess_AbortBackgroundFetch:
        return jsValueForDecodedMessageReply<MessageName::NetworkProcess_AbortBackgroundFetch>(globalObject, decoder);
    case MessageName::NetworkProcess_PauseBackgroundFetch:
        return jsValueForDecodedMessageReply<MessageName::NetworkProcess_PauseBackgroundFetch>(globalObject, decoder);
    case MessageName::NetworkProcess_ResumeBackgroundFetch:
        return jsValueForDecodedMessageReply<MessageName::NetworkProcess_ResumeBackgroundFetch>(globalObject, decoder);
    case MessageName::NetworkProcess_ClickBackgroundFetch:
        return jsValueForDecodedMessageReply<MessageName::NetworkProcess_ClickBackgroundFetch>(globalObject, decoder);
    case MessageName::NetworkProcess_SetPushAndNotificationsEnabledForOrigin:
        return jsValueForDecodedMessageReply<MessageName::NetworkProcess_SetPushAndNotificationsEnabledForOrigin>(globalObject, decoder);
    case MessageName::NetworkProcess_RemovePushSubscriptionsForOrigin:
        return jsValueForDecodedMessageReply<MessageName::NetworkProcess_RemovePushSubscriptionsForOrigin>(globalObject, decoder);
    case MessageName::NetworkProcess_HasPushSubscriptionForTesting:
        return jsValueForDecodedMessageReply<MessageName::NetworkProcess_HasPushSubscriptionForTesting>(globalObject, decoder);
    case MessageName::NetworkProcess_GetAppBadgeForTesting:
        return jsValueForDecodedMessageReply<MessageName::NetworkProcess_GetAppBadgeForTesting>(globalObject, decoder);
    case MessageName::NetworkProcess_FetchLocalStorage:
        return jsValueForDecodedMessageReply<MessageName::NetworkProcess_FetchLocalStorage>(globalObject, decoder);
    case MessageName::NetworkProcess_RestoreLocalStorage:
        return jsValueForDecodedMessageReply<MessageName::NetworkProcess_RestoreLocalStorage>(globalObject, decoder);
    case MessageName::NetworkProcess_FetchSessionStorage:
        return jsValueForDecodedMessageReply<MessageName::NetworkProcess_FetchSessionStorage>(globalObject, decoder);
    case MessageName::NetworkProcess_RestoreSessionStorage:
        return jsValueForDecodedMessageReply<MessageName::NetworkProcess_RestoreSessionStorage>(globalObject, decoder);
#if ENABLE(CONTENT_EXTENSIONS)
    case MessageName::NetworkProcess_ResetResourceMonitorThrottlerForTesting:
        return jsValueForDecodedMessageReply<MessageName::NetworkProcess_ResetResourceMonitorThrottlerForTesting>(globalObject, decoder);
#endif
    case MessageName::NetworkSocketChannel_SendString:
        return jsValueForDecodedMessageReply<MessageName::NetworkSocketChannel_SendString>(globalObject, decoder);
    case MessageName::NetworkSocketChannel_SendData:
        return jsValueForDecodedMessageReply<MessageName::NetworkSocketChannel_SendData>(globalObject, decoder);
    case MessageName::WebSWServerConnection_ScheduleUnregisterJobInServer:
        return jsValueForDecodedMessageReply<MessageName::WebSWServerConnection_ScheduleUnregisterJobInServer>(globalObject, decoder);
    case MessageName::WebSWServerConnection_MatchRegistration:
        return jsValueForDecodedMessageReply<MessageName::WebSWServerConnection_MatchRegistration>(globalObject, decoder);
    case MessageName::WebSWServerConnection_WhenRegistrationReady:
        return jsValueForDecodedMessageReply<MessageName::WebSWServerConnection_WhenRegistrationReady>(globalObject, decoder);
    case MessageName::WebSWServerConnection_GetRegistrations:
        return jsValueForDecodedMessageReply<MessageName::WebSWServerConnection_GetRegistrations>(globalObject, decoder);
    case MessageName::WebSWServerConnection_TerminateWorkerFromClient:
        return jsValueForDecodedMessageReply<MessageName::WebSWServerConnection_TerminateWorkerFromClient>(globalObject, decoder);
    case MessageName::WebSWServerConnection_WhenServiceWorkerIsTerminatedForTesting:
        return jsValueForDecodedMessageReply<MessageName::WebSWServerConnection_WhenServiceWorkerIsTerminatedForTesting>(globalObject, decoder);
    case MessageName::WebSWServerConnection_StoreRegistrationsOnDisk:
        return jsValueForDecodedMessageReply<MessageName::WebSWServerConnection_StoreRegistrationsOnDisk>(globalObject, decoder);
    case MessageName::WebSWServerConnection_SubscribeToPushService:
        return jsValueForDecodedMessageReply<MessageName::WebSWServerConnection_SubscribeToPushService>(globalObject, decoder);
    case MessageName::WebSWServerConnection_UnsubscribeFromPushService:
        return jsValueForDecodedMessageReply<MessageName::WebSWServerConnection_UnsubscribeFromPushService>(globalObject, decoder);
    case MessageName::WebSWServerConnection_GetPushSubscription:
        return jsValueForDecodedMessageReply<MessageName::WebSWServerConnection_GetPushSubscription>(globalObject, decoder);
    case MessageName::WebSWServerConnection_GetPushPermissionState:
        return jsValueForDecodedMessageReply<MessageName::WebSWServerConnection_GetPushPermissionState>(globalObject, decoder);
    case MessageName::WebSWServerConnection_EnableNavigationPreload:
        return jsValueForDecodedMessageReply<MessageName::WebSWServerConnection_EnableNavigationPreload>(globalObject, decoder);
    case MessageName::WebSWServerConnection_DisableNavigationPreload:
        return jsValueForDecodedMessageReply<MessageName::WebSWServerConnection_DisableNavigationPreload>(globalObject, decoder);
    case MessageName::WebSWServerConnection_SetNavigationPreloadHeaderValue:
        return jsValueForDecodedMessageReply<MessageName::WebSWServerConnection_SetNavigationPreloadHeaderValue>(globalObject, decoder);
    case MessageName::WebSWServerConnection_GetNavigationPreloadState:
        return jsValueForDecodedMessageReply<MessageName::WebSWServerConnection_GetNavigationPreloadState>(globalObject, decoder);
    case MessageName::WebSWServerConnection_StartBackgroundFetch:
        return jsValueForDecodedMessageReply<MessageName::WebSWServerConnection_StartBackgroundFetch>(globalObject, decoder);
    case MessageName::WebSWServerConnection_BackgroundFetchInformation:
        return jsValueForDecodedMessageReply<MessageName::WebSWServerConnection_BackgroundFetchInformation>(globalObject, decoder);
    case MessageName::WebSWServerConnection_BackgroundFetchIdentifiers:
        return jsValueForDecodedMessageReply<MessageName::WebSWServerConnection_BackgroundFetchIdentifiers>(globalObject, decoder);
    case MessageName::WebSWServerConnection_AbortBackgroundFetch:
        return jsValueForDecodedMessageReply<MessageName::WebSWServerConnection_AbortBackgroundFetch>(globalObject, decoder);
    case MessageName::WebSWServerConnection_MatchBackgroundFetch:
        return jsValueForDecodedMessageReply<MessageName::WebSWServerConnection_MatchBackgroundFetch>(globalObject, decoder);
    case MessageName::WebSWServerConnection_RetrieveRecordResponse:
        return jsValueForDecodedMessageReply<MessageName::WebSWServerConnection_RetrieveRecordResponse>(globalObject, decoder);
    case MessageName::WebSWServerConnection_AddCookieChangeSubscriptions:
        return jsValueForDecodedMessageReply<MessageName::WebSWServerConnection_AddCookieChangeSubscriptions>(globalObject, decoder);
    case MessageName::WebSWServerConnection_RemoveCookieChangeSubscriptions:
        return jsValueForDecodedMessageReply<MessageName::WebSWServerConnection_RemoveCookieChangeSubscriptions>(globalObject, decoder);
    case MessageName::WebSWServerConnection_CookieChangeSubscriptions:
        return jsValueForDecodedMessageReply<MessageName::WebSWServerConnection_CookieChangeSubscriptions>(globalObject, decoder);
    case MessageName::WebSWServerConnection_AddRoutes:
        return jsValueForDecodedMessageReply<MessageName::WebSWServerConnection_AddRoutes>(globalObject, decoder);
#if ENABLE(WEB_PUSH_NOTIFICATIONS)
    case MessageName::WebSWServerConnection_GetNotifications:
        return jsValueForDecodedMessageReply<MessageName::WebSWServerConnection_GetNotifications>(globalObject, decoder);
#endif
    case MessageName::WebSWServerToContextConnection_SkipWaiting:
        return jsValueForDecodedMessageReply<MessageName::WebSWServerToContextConnection_SkipWaiting>(globalObject, decoder);
    case MessageName::WebSWServerToContextConnection_FindClientByVisibleIdentifier:
        return jsValueForDecodedMessageReply<MessageName::WebSWServerToContextConnection_FindClientByVisibleIdentifier>(globalObject, decoder);
    case MessageName::WebSWServerToContextConnection_MatchAll:
        return jsValueForDecodedMessageReply<MessageName::WebSWServerToContextConnection_MatchAll>(globalObject, decoder);
    case MessageName::WebSWServerToContextConnection_Claim:
        return jsValueForDecodedMessageReply<MessageName::WebSWServerToContextConnection_Claim>(globalObject, decoder);
    case MessageName::WebSWServerToContextConnection_Focus:
        return jsValueForDecodedMessageReply<MessageName::WebSWServerToContextConnection_Focus>(globalObject, decoder);
    case MessageName::WebSWServerToContextConnection_Navigate:
        return jsValueForDecodedMessageReply<MessageName::WebSWServerToContextConnection_Navigate>(globalObject, decoder);
    case MessageName::WebSWServerToContextConnection_OpenWindow:
        return jsValueForDecodedMessageReply<MessageName::WebSWServerToContextConnection_OpenWindow>(globalObject, decoder);
    case MessageName::NetworkStorageManager_Persisted:
        return jsValueForDecodedMessageReply<MessageName::NetworkStorageManager_Persisted>(globalObject, decoder);
    case MessageName::NetworkStorageManager_Persist:
        return jsValueForDecodedMessageReply<MessageName::NetworkStorageManager_Persist>(globalObject, decoder);
    case MessageName::NetworkStorageManager_Estimate:
        return jsValueForDecodedMessageReply<MessageName::NetworkStorageManager_Estimate>(globalObject, decoder);
    case MessageName::NetworkStorageManager_FileSystemGetDirectory:
        return jsValueForDecodedMessageReply<MessageName::NetworkStorageManager_FileSystemGetDirectory>(globalObject, decoder);
    case MessageName::NetworkStorageManager_IsSameEntry:
        return jsValueForDecodedMessageReply<MessageName::NetworkStorageManager_IsSameEntry>(globalObject, decoder);
    case MessageName::NetworkStorageManager_GetFileHandle:
        return jsValueForDecodedMessageReply<MessageName::NetworkStorageManager_GetFileHandle>(globalObject, decoder);
    case MessageName::NetworkStorageManager_GetDirectoryHandle:
        return jsValueForDecodedMessageReply<MessageName::NetworkStorageManager_GetDirectoryHandle>(globalObject, decoder);
    case MessageName::NetworkStorageManager_RemoveEntry:
        return jsValueForDecodedMessageReply<MessageName::NetworkStorageManager_RemoveEntry>(globalObject, decoder);
    case MessageName::NetworkStorageManager_Resolve:
        return jsValueForDecodedMessageReply<MessageName::NetworkStorageManager_Resolve>(globalObject, decoder);
    case MessageName::NetworkStorageManager_Move:
        return jsValueForDecodedMessageReply<MessageName::NetworkStorageManager_Move>(globalObject, decoder);
    case MessageName::NetworkStorageManager_GetFile:
        return jsValueForDecodedMessageReply<MessageName::NetworkStorageManager_GetFile>(globalObject, decoder);
    case MessageName::NetworkStorageManager_CreateSyncAccessHandle:
        return jsValueForDecodedMessageReply<MessageName::NetworkStorageManager_CreateSyncAccessHandle>(globalObject, decoder);
    case MessageName::NetworkStorageManager_CloseSyncAccessHandle:
        return jsValueForDecodedMessageReply<MessageName::NetworkStorageManager_CloseSyncAccessHandle>(globalObject, decoder);
    case MessageName::NetworkStorageManager_RequestNewCapacityForSyncAccessHandle:
        return jsValueForDecodedMessageReply<MessageName::NetworkStorageManager_RequestNewCapacityForSyncAccessHandle>(globalObject, decoder);
    case MessageName::NetworkStorageManager_CreateWritable:
        return jsValueForDecodedMessageReply<MessageName::NetworkStorageManager_CreateWritable>(globalObject, decoder);
    case MessageName::NetworkStorageManager_CloseWritable:
        return jsValueForDecodedMessageReply<MessageName::NetworkStorageManager_CloseWritable>(globalObject, decoder);
    case MessageName::NetworkStorageManager_ExecuteCommandForWritable:
        return jsValueForDecodedMessageReply<MessageName::NetworkStorageManager_ExecuteCommandForWritable>(globalObject, decoder);
    case MessageName::NetworkStorageManager_GetHandleNames:
        return jsValueForDecodedMessageReply<MessageName::NetworkStorageManager_GetHandleNames>(globalObject, decoder);
    case MessageName::NetworkStorageManager_GetHandle:
        return jsValueForDecodedMessageReply<MessageName::NetworkStorageManager_GetHandle>(globalObject, decoder);
    case MessageName::NetworkStorageManager_ConnectToStorageArea:
        return jsValueForDecodedMessageReply<MessageName::NetworkStorageManager_ConnectToStorageArea>(globalObject, decoder);
    case MessageName::NetworkStorageManager_ConnectToStorageAreaSync:
        return jsValueForDecodedMessageReply<MessageName::NetworkStorageManager_ConnectToStorageAreaSync>(globalObject, decoder);
    case MessageName::NetworkStorageManager_SetItem:
        return jsValueForDecodedMessageReply<MessageName::NetworkStorageManager_SetItem>(globalObject, decoder);
    case MessageName::NetworkStorageManager_RemoveItem:
        return jsValueForDecodedMessageReply<MessageName::NetworkStorageManager_RemoveItem>(globalObject, decoder);
    case MessageName::NetworkStorageManager_Clear:
        return jsValueForDecodedMessageReply<MessageName::NetworkStorageManager_Clear>(globalObject, decoder);
    case MessageName::NetworkStorageManager_CacheStorageOpenCache:
        return jsValueForDecodedMessageReply<MessageName::NetworkStorageManager_CacheStorageOpenCache>(globalObject, decoder);
    case MessageName::NetworkStorageManager_CacheStorageRemoveCache:
        return jsValueForDecodedMessageReply<MessageName::NetworkStorageManager_CacheStorageRemoveCache>(globalObject, decoder);
    case MessageName::NetworkStorageManager_CacheStorageAllCaches:
        return jsValueForDecodedMessageReply<MessageName::NetworkStorageManager_CacheStorageAllCaches>(globalObject, decoder);
    case MessageName::NetworkStorageManager_CacheStorageRetrieveRecords:
        return jsValueForDecodedMessageReply<MessageName::NetworkStorageManager_CacheStorageRetrieveRecords>(globalObject, decoder);
    case MessageName::NetworkStorageManager_CacheStorageRemoveRecords:
        return jsValueForDecodedMessageReply<MessageName::NetworkStorageManager_CacheStorageRemoveRecords>(globalObject, decoder);
    case MessageName::NetworkStorageManager_CacheStoragePutRecords:
        return jsValueForDecodedMessageReply<MessageName::NetworkStorageManager_CacheStoragePutRecords>(globalObject, decoder);
    case MessageName::NetworkStorageManager_CacheStorageClearMemoryRepresentation:
        return jsValueForDecodedMessageReply<MessageName::NetworkStorageManager_CacheStorageClearMemoryRepresentation>(globalObject, decoder);
    case MessageName::NetworkStorageManager_CacheStorageRepresentation:
        return jsValueForDecodedMessageReply<MessageName::NetworkStorageManager_CacheStorageRepresentation>(globalObject, decoder);
#if ENABLE(WEB_RTC)
    case MessageName::NetworkMDNSRegister_RegisterMDNSName:
        return jsValueForDecodedMessageReply<MessageName::NetworkMDNSRegister_RegisterMDNSName>(globalObject, decoder);
#endif
#if USE(LIBWEBRTC)
#endif
#if USE(LIBWEBRTC)
#if PLATFORM(COCOA)
    case MessageName::NetworkRTCProvider_GetInterfaceName:
        return jsValueForDecodedMessageReply<MessageName::NetworkRTCProvider_GetInterfaceName>(globalObject, decoder);
#endif
#endif
#if ENABLE(WEB_RTC)
#endif
    case MessageName::NetworkTransportSession_SendDatagram:
        return jsValueForDecodedMessageReply<MessageName::NetworkTransportSession_SendDatagram>(globalObject, decoder);
    case MessageName::NetworkTransportSession_CreateOutgoingUnidirectionalStream:
        return jsValueForDecodedMessageReply<MessageName::NetworkTransportSession_CreateOutgoingUnidirectionalStream>(globalObject, decoder);
    case MessageName::NetworkTransportSession_CreateBidirectionalStream:
        return jsValueForDecodedMessageReply<MessageName::NetworkTransportSession_CreateBidirectionalStream>(globalObject, decoder);
    case MessageName::NetworkTransportSession_StreamSendBytes:
        return jsValueForDecodedMessageReply<MessageName::NetworkTransportSession_StreamSendBytes>(globalObject, decoder);
    case MessageName::AuxiliaryProcess_MainThreadPing:
        return jsValueForDecodedMessageReply<MessageName::AuxiliaryProcess_MainThreadPing>(globalObject, decoder);
#if ENABLE(IPC_TESTING_API)
    case MessageName::IPCConnectionTester_SyncMessage:
        return jsValueForDecodedMessageReply<MessageName::IPCConnectionTester_SyncMessage>(globalObject, decoder);
#endif
#if ENABLE(IPC_TESTING_API)
    case MessageName::IPCStreamTester_SyncMessage:
        return jsValueForDecodedMessageReply<MessageName::IPCStreamTester_SyncMessage>(globalObject, decoder);
    case MessageName::IPCStreamTester_SyncMessageNotStreamEncodableReply:
        return jsValueForDecodedMessageReply<MessageName::IPCStreamTester_SyncMessageNotStreamEncodableReply>(globalObject, decoder);
    case MessageName::IPCStreamTester_SyncMessageNotStreamEncodableBoth:
        return jsValueForDecodedMessageReply<MessageName::IPCStreamTester_SyncMessageNotStreamEncodableBoth>(globalObject, decoder);
    case MessageName::IPCStreamTester_SyncMessageReturningSharedMemory1:
        return jsValueForDecodedMessageReply<MessageName::IPCStreamTester_SyncMessageReturningSharedMemory1>(globalObject, decoder);
    case MessageName::IPCStreamTester_SyncMessageEmptyReply:
        return jsValueForDecodedMessageReply<MessageName::IPCStreamTester_SyncMessageEmptyReply>(globalObject, decoder);
    case MessageName::IPCStreamTester_SyncCrashOnZero:
        return jsValueForDecodedMessageReply<MessageName::IPCStreamTester_SyncCrashOnZero>(globalObject, decoder);
    case MessageName::IPCStreamTester_CheckAutoreleasePool:
        return jsValueForDecodedMessageReply<MessageName::IPCStreamTester_CheckAutoreleasePool>(globalObject, decoder);
    case MessageName::IPCStreamTester_AsyncPing:
        return jsValueForDecodedMessageReply<MessageName::IPCStreamTester_AsyncPing>(globalObject, decoder);
#endif
#if ENABLE(IPC_TESTING_API)
#endif
#if ENABLE(IPC_TESTING_API)
    case MessageName::IPCTester_StopMessageTesting:
        return jsValueForDecodedMessageReply<MessageName::IPCTester_StopMessageTesting>(globalObject, decoder);
    case MessageName::IPCTester_ReleaseStreamTester:
        return jsValueForDecodedMessageReply<MessageName::IPCTester_ReleaseStreamTester>(globalObject, decoder);
    case MessageName::IPCTester_ReleaseConnectionTester:
        return jsValueForDecodedMessageReply<MessageName::IPCTester_ReleaseConnectionTester>(globalObject, decoder);
    case MessageName::IPCTester_AsyncPing:
        return jsValueForDecodedMessageReply<MessageName::IPCTester_AsyncPing>(globalObject, decoder);
    case MessageName::IPCTester_SyncPing:
        return jsValueForDecodedMessageReply<MessageName::IPCTester_SyncPing>(globalObject, decoder);
    case MessageName::IPCTester_SyncPingEmptyReply:
        return jsValueForDecodedMessageReply<MessageName::IPCTester_SyncPingEmptyReply>(globalObject, decoder);
    case MessageName::IPCTester_AsyncOptionalExceptionData:
        return jsValueForDecodedMessageReply<MessageName::IPCTester_AsyncOptionalExceptionData>(globalObject, decoder);
#endif
#if ENABLE(IPC_TESTING_API)
    case MessageName::IPCTesterReceiver_AsyncMessage:
        return jsValueForDecodedMessageReply<MessageName::IPCTesterReceiver_AsyncMessage>(globalObject, decoder);
#endif
#if ENABLE(NOTIFICATIONS)
    case MessageName::NotificationManagerMessageHandler_ShowNotification:
        return jsValueForDecodedMessageReply<MessageName::NotificationManagerMessageHandler_ShowNotification>(globalObject, decoder);
    case MessageName::NotificationManagerMessageHandler_RequestPermission:
        return jsValueForDecodedMessageReply<MessageName::NotificationManagerMessageHandler_RequestPermission>(globalObject, decoder);
#endif
#if ENABLE(WEB_PUSH_NOTIFICATIONS)
    case MessageName::NotificationManagerMessageHandler_GetPermissionState:
        return jsValueForDecodedMessageReply<MessageName::NotificationManagerMessageHandler_GetPermissionState>(globalObject, decoder);
    case MessageName::NotificationManagerMessageHandler_GetPermissionStateSync:
        return jsValueForDecodedMessageReply<MessageName::NotificationManagerMessageHandler_GetPermissionStateSync>(globalObject, decoder);
#endif
#if ENABLE(WK_WEB_EXTENSIONS)
    case MessageName::WebExtensionContext_ActionGetTitle:
        return jsValueForDecodedMessageReply<MessageName::WebExtensionContext_ActionGetTitle>(globalObject, decoder);
    case MessageName::WebExtensionContext_ActionSetTitle:
        return jsValueForDecodedMessageReply<MessageName::WebExtensionContext_ActionSetTitle>(globalObject, decoder);
    case MessageName::WebExtensionContext_ActionSetIcon:
        return jsValueForDecodedMessageReply<MessageName::WebExtensionContext_ActionSetIcon>(globalObject, decoder);
    case MessageName::WebExtensionContext_ActionGetPopup:
        return jsValueForDecodedMessageReply<MessageName::WebExtensionContext_ActionGetPopup>(globalObject, decoder);
    case MessageName::WebExtensionContext_ActionSetPopup:
        return jsValueForDecodedMessageReply<MessageName::WebExtensionContext_ActionSetPopup>(globalObject, decoder);
    case MessageName::WebExtensionContext_ActionOpenPopup:
        return jsValueForDecodedMessageReply<MessageName::WebExtensionContext_ActionOpenPopup>(globalObject, decoder);
    case MessageName::WebExtensionContext_ActionGetBadgeText:
        return jsValueForDecodedMessageReply<MessageName::WebExtensionContext_ActionGetBadgeText>(globalObject, decoder);
    case MessageName::WebExtensionContext_ActionSetBadgeText:
        return jsValueForDecodedMessageReply<MessageName::WebExtensionContext_ActionSetBadgeText>(globalObject, decoder);
    case MessageName::WebExtensionContext_ActionGetEnabled:
        return jsValueForDecodedMessageReply<MessageName::WebExtensionContext_ActionGetEnabled>(globalObject, decoder);
    case MessageName::WebExtensionContext_ActionSetEnabled:
        return jsValueForDecodedMessageReply<MessageName::WebExtensionContext_ActionSetEnabled>(globalObject, decoder);
    case MessageName::WebExtensionContext_AlarmsGet:
        return jsValueForDecodedMessageReply<MessageName::WebExtensionContext_AlarmsGet>(globalObject, decoder);
    case MessageName::WebExtensionContext_AlarmsClear:
        return jsValueForDecodedMessageReply<MessageName::WebExtensionContext_AlarmsClear>(globalObject, decoder);
    case MessageName::WebExtensionContext_AlarmsGetAll:
        return jsValueForDecodedMessageReply<MessageName::WebExtensionContext_AlarmsGetAll>(globalObject, decoder);
    case MessageName::WebExtensionContext_AlarmsClearAll:
        return jsValueForDecodedMessageReply<MessageName::WebExtensionContext_AlarmsClearAll>(globalObject, decoder);
#if ENABLE(WK_WEB_EXTENSIONS_BOOKMARKS)
    case MessageName::WebExtensionContext_BookmarksCreate:
        return jsValueForDecodedMessageReply<MessageName::WebExtensionContext_BookmarksCreate>(globalObject, decoder);
    case MessageName::WebExtensionContext_BookmarksGetTree:
        return jsValueForDecodedMessageReply<MessageName::WebExtensionContext_BookmarksGetTree>(globalObject, decoder);
    case MessageName::WebExtensionContext_BookmarksGetSubTree:
        return jsValueForDecodedMessageReply<MessageName::WebExtensionContext_BookmarksGetSubTree>(globalObject, decoder);
    case MessageName::WebExtensionContext_BookmarksGet:
        return jsValueForDecodedMessageReply<MessageName::WebExtensionContext_BookmarksGet>(globalObject, decoder);
    case MessageName::WebExtensionContext_BookmarksGetChildren:
        return jsValueForDecodedMessageReply<MessageName::WebExtensionContext_BookmarksGetChildren>(globalObject, decoder);
    case MessageName::WebExtensionContext_BookmarksGetRecent:
        return jsValueForDecodedMessageReply<MessageName::WebExtensionContext_BookmarksGetRecent>(globalObject, decoder);
    case MessageName::WebExtensionContext_BookmarksSearch:
        return jsValueForDecodedMessageReply<MessageName::WebExtensionContext_BookmarksSearch>(globalObject, decoder);
    case MessageName::WebExtensionContext_BookmarksUpdate:
        return jsValueForDecodedMessageReply<MessageName::WebExtensionContext_BookmarksUpdate>(globalObject, decoder);
    case MessageName::WebExtensionContext_BookmarksMove:
        return jsValueForDecodedMessageReply<MessageName::WebExtensionContext_BookmarksMove>(globalObject, decoder);
    case MessageName::WebExtensionContext_BookmarksRemove:
        return jsValueForDecodedMessageReply<MessageName::WebExtensionContext_BookmarksRemove>(globalObject, decoder);
    case MessageName::WebExtensionContext_BookmarksRemoveTree:
        return jsValueForDecodedMessageReply<MessageName::WebExtensionContext_BookmarksRemoveTree>(globalObject, decoder);
#endif
    case MessageName::WebExtensionContext_CommandsGetAll:
        return jsValueForDecodedMessageReply<MessageName::WebExtensionContext_CommandsGetAll>(globalObject, decoder);
    case MessageName::WebExtensionContext_CookiesGet:
        return jsValueForDecodedMessageReply<MessageName::WebExtensionContext_CookiesGet>(globalObject, decoder);
    case MessageName::WebExtensionContext_CookiesGetAll:
        return jsValueForDecodedMessageReply<MessageName::WebExtensionContext_CookiesGetAll>(globalObject, decoder);
    case MessageName::WebExtensionContext_CookiesSet:
        return jsValueForDecodedMessageReply<MessageName::WebExtensionContext_CookiesSet>(globalObject, decoder);
    case MessageName::WebExtensionContext_CookiesRemove:
        return jsValueForDecodedMessageReply<MessageName::WebExtensionContext_CookiesRemove>(globalObject, decoder);
    case MessageName::WebExtensionContext_CookiesGetAllCookieStores:
        return jsValueForDecodedMessageReply<MessageName::WebExtensionContext_CookiesGetAllCookieStores>(globalObject, decoder);
    case MessageName::WebExtensionContext_DeclarativeNetRequestGetEnabledRulesets:
        return jsValueForDecodedMessageReply<MessageName::WebExtensionContext_DeclarativeNetRequestGetEnabledRulesets>(globalObject, decoder);
    case MessageName::WebExtensionContext_DeclarativeNetRequestUpdateEnabledRulesets:
        return jsValueForDecodedMessageReply<MessageName::WebExtensionContext_DeclarativeNetRequestUpdateEnabledRulesets>(globalObject, decoder);
    case MessageName::WebExtensionContext_DeclarativeNetRequestDisplayActionCountAsBadgeText:
        return jsValueForDecodedMessageReply<MessageName::WebExtensionContext_DeclarativeNetRequestDisplayActionCountAsBadgeText>(globalObject, decoder);
    case MessageName::WebExtensionContext_DeclarativeNetRequestIncrementActionCount:
        return jsValueForDecodedMessageReply<MessageName::WebExtensionContext_DeclarativeNetRequestIncrementActionCount>(globalObject, decoder);
    case MessageName::WebExtensionContext_DeclarativeNetRequestGetMatchedRules:
        return jsValueForDecodedMessageReply<MessageName::WebExtensionContext_DeclarativeNetRequestGetMatchedRules>(globalObject, decoder);
    case MessageName::WebExtensionContext_DeclarativeNetRequestGetDynamicRules:
        return jsValueForDecodedMessageReply<MessageName::WebExtensionContext_DeclarativeNetRequestGetDynamicRules>(globalObject, decoder);
    case MessageName::WebExtensionContext_DeclarativeNetRequestUpdateDynamicRules:
        return jsValueForDecodedMessageReply<MessageName::WebExtensionContext_DeclarativeNetRequestUpdateDynamicRules>(globalObject, decoder);
    case MessageName::WebExtensionContext_DeclarativeNetRequestGetSessionRules:
        return jsValueForDecodedMessageReply<MessageName::WebExtensionContext_DeclarativeNetRequestGetSessionRules>(globalObject, decoder);
    case MessageName::WebExtensionContext_DeclarativeNetRequestUpdateSessionRules:
        return jsValueForDecodedMessageReply<MessageName::WebExtensionContext_DeclarativeNetRequestUpdateSessionRules>(globalObject, decoder);
#if ENABLE(INSPECTOR_EXTENSIONS)
    case MessageName::WebExtensionContext_DevToolsPanelsCreate:
        return jsValueForDecodedMessageReply<MessageName::WebExtensionContext_DevToolsPanelsCreate>(globalObject, decoder);
    case MessageName::WebExtensionContext_DevToolsInspectedWindowEval:
        return jsValueForDecodedMessageReply<MessageName::WebExtensionContext_DevToolsInspectedWindowEval>(globalObject, decoder);
#endif
    case MessageName::WebExtensionContext_ExtensionIsAllowedIncognitoAccess:
        return jsValueForDecodedMessageReply<MessageName::WebExtensionContext_ExtensionIsAllowedIncognitoAccess>(globalObject, decoder);
    case MessageName::WebExtensionContext_MenusCreate:
        return jsValueForDecodedMessageReply<MessageName::WebExtensionContext_MenusCreate>(globalObject, decoder);
    case MessageName::WebExtensionContext_MenusUpdate:
        return jsValueForDecodedMessageReply<MessageName::WebExtensionContext_MenusUpdate>(globalObject, decoder);
    case MessageName::WebExtensionContext_MenusRemove:
        return jsValueForDecodedMessageReply<MessageName::WebExtensionContext_MenusRemove>(globalObject, decoder);
    case MessageName::WebExtensionContext_MenusRemoveAll:
        return jsValueForDecodedMessageReply<MessageName::WebExtensionContext_MenusRemoveAll>(globalObject, decoder);
    case MessageName::WebExtensionContext_PermissionsGetAll:
        return jsValueForDecodedMessageReply<MessageName::WebExtensionContext_PermissionsGetAll>(globalObject, decoder);
    case MessageName::WebExtensionContext_PermissionsContains:
        return jsValueForDecodedMessageReply<MessageName::WebExtensionContext_PermissionsContains>(globalObject, decoder);
    case MessageName::WebExtensionContext_PermissionsRequest:
        return jsValueForDecodedMessageReply<MessageName::WebExtensionContext_PermissionsRequest>(globalObject, decoder);
    case MessageName::WebExtensionContext_PermissionsRemove:
        return jsValueForDecodedMessageReply<MessageName::WebExtensionContext_PermissionsRemove>(globalObject, decoder);
    case MessageName::WebExtensionContext_RuntimeGetBackgroundPage:
        return jsValueForDecodedMessageReply<MessageName::WebExtensionContext_RuntimeGetBackgroundPage>(globalObject, decoder);
    case MessageName::WebExtensionContext_RuntimeOpenOptionsPage:
        return jsValueForDecodedMessageReply<MessageName::WebExtensionContext_RuntimeOpenOptionsPage>(globalObject, decoder);
    case MessageName::WebExtensionContext_RuntimeSendMessage:
        return jsValueForDecodedMessageReply<MessageName::WebExtensionContext_RuntimeSendMessage>(globalObject, decoder);
    case MessageName::WebExtensionContext_RuntimeConnect:
        return jsValueForDecodedMessageReply<MessageName::WebExtensionContext_RuntimeConnect>(globalObject, decoder);
    case MessageName::WebExtensionContext_RuntimeSendNativeMessage:
        return jsValueForDecodedMessageReply<MessageName::WebExtensionContext_RuntimeSendNativeMessage>(globalObject, decoder);
    case MessageName::WebExtensionContext_RuntimeConnectNative:
        return jsValueForDecodedMessageReply<MessageName::WebExtensionContext_RuntimeConnectNative>(globalObject, decoder);
    case MessageName::WebExtensionContext_RuntimeWebPageSendMessage:
        return jsValueForDecodedMessageReply<MessageName::WebExtensionContext_RuntimeWebPageSendMessage>(globalObject, decoder);
    case MessageName::WebExtensionContext_RuntimeWebPageConnect:
        return jsValueForDecodedMessageReply<MessageName::WebExtensionContext_RuntimeWebPageConnect>(globalObject, decoder);
    case MessageName::WebExtensionContext_ScriptingExecuteScript:
        return jsValueForDecodedMessageReply<MessageName::WebExtensionContext_ScriptingExecuteScript>(globalObject, decoder);
    case MessageName::WebExtensionContext_ScriptingInsertCSS:
        return jsValueForDecodedMessageReply<MessageName::WebExtensionContext_ScriptingInsertCSS>(globalObject, decoder);
    case MessageName::WebExtensionContext_ScriptingRemoveCSS:
        return jsValueForDecodedMessageReply<MessageName::WebExtensionContext_ScriptingRemoveCSS>(globalObject, decoder);
    case MessageName::WebExtensionContext_ScriptingRegisterContentScripts:
        return jsValueForDecodedMessageReply<MessageName::WebExtensionContext_ScriptingRegisterContentScripts>(globalObject, decoder);
    case MessageName::WebExtensionContext_ScriptingUpdateRegisteredScripts:
        return jsValueForDecodedMessageReply<MessageName::WebExtensionContext_ScriptingUpdateRegisteredScripts>(globalObject, decoder);
    case MessageName::WebExtensionContext_ScriptingGetRegisteredScripts:
        return jsValueForDecodedMessageReply<MessageName::WebExtensionContext_ScriptingGetRegisteredScripts>(globalObject, decoder);
    case MessageName::WebExtensionContext_ScriptingUnregisterContentScripts:
        return jsValueForDecodedMessageReply<MessageName::WebExtensionContext_ScriptingUnregisterContentScripts>(globalObject, decoder);
#if ENABLE(WK_WEB_EXTENSIONS_SIDEBAR)
    case MessageName::WebExtensionContext_SidebarOpen:
        return jsValueForDecodedMessageReply<MessageName::WebExtensionContext_SidebarOpen>(globalObject, decoder);
    case MessageName::WebExtensionContext_SidebarIsOpen:
        return jsValueForDecodedMessageReply<MessageName::WebExtensionContext_SidebarIsOpen>(globalObject, decoder);
    case MessageName::WebExtensionContext_SidebarClose:
        return jsValueForDecodedMessageReply<MessageName::WebExtensionContext_SidebarClose>(globalObject, decoder);
    case MessageName::WebExtensionContext_SidebarToggle:
        return jsValueForDecodedMessageReply<MessageName::WebExtensionContext_SidebarToggle>(globalObject, decoder);
    case MessageName::WebExtensionContext_SidebarGetOptions:
        return jsValueForDecodedMessageReply<MessageName::WebExtensionContext_SidebarGetOptions>(globalObject, decoder);
    case MessageName::WebExtensionContext_SidebarSetOptions:
        return jsValueForDecodedMessageReply<MessageName::WebExtensionContext_SidebarSetOptions>(globalObject, decoder);
    case MessageName::WebExtensionContext_SidebarGetTitle:
        return jsValueForDecodedMessageReply<MessageName::WebExtensionContext_SidebarGetTitle>(globalObject, decoder);
    case MessageName::WebExtensionContext_SidebarSetTitle:
        return jsValueForDecodedMessageReply<MessageName::WebExtensionContext_SidebarSetTitle>(globalObject, decoder);
    case MessageName::WebExtensionContext_SidebarSetIcon:
        return jsValueForDecodedMessageReply<MessageName::WebExtensionContext_SidebarSetIcon>(globalObject, decoder);
    case MessageName::WebExtensionContext_SidebarSetActionClickBehavior:
        return jsValueForDecodedMessageReply<MessageName::WebExtensionContext_SidebarSetActionClickBehavior>(globalObject, decoder);
    case MessageName::WebExtensionContext_SidebarGetActionClickBehavior:
        return jsValueForDecodedMessageReply<MessageName::WebExtensionContext_SidebarGetActionClickBehavior>(globalObject, decoder);
#endif
    case MessageName::WebExtensionContext_StorageGet:
        return jsValueForDecodedMessageReply<MessageName::WebExtensionContext_StorageGet>(globalObject, decoder);
    case MessageName::WebExtensionContext_StorageGetKeys:
        return jsValueForDecodedMessageReply<MessageName::WebExtensionContext_StorageGetKeys>(globalObject, decoder);
    case MessageName::WebExtensionContext_StorageGetBytesInUse:
        return jsValueForDecodedMessageReply<MessageName::WebExtensionContext_StorageGetBytesInUse>(globalObject, decoder);
    case MessageName::WebExtensionContext_StorageSet:
        return jsValueForDecodedMessageReply<MessageName::WebExtensionContext_StorageSet>(globalObject, decoder);
    case MessageName::WebExtensionContext_StorageRemove:
        return jsValueForDecodedMessageReply<MessageName::WebExtensionContext_StorageRemove>(globalObject, decoder);
    case MessageName::WebExtensionContext_StorageClear:
        return jsValueForDecodedMessageReply<MessageName::WebExtensionContext_StorageClear>(globalObject, decoder);
    case MessageName::WebExtensionContext_StorageSetAccessLevel:
        return jsValueForDecodedMessageReply<MessageName::WebExtensionContext_StorageSetAccessLevel>(globalObject, decoder);
    case MessageName::WebExtensionContext_TabsCreate:
        return jsValueForDecodedMessageReply<MessageName::WebExtensionContext_TabsCreate>(globalObject, decoder);
    case MessageName::WebExtensionContext_TabsUpdate:
        return jsValueForDecodedMessageReply<MessageName::WebExtensionContext_TabsUpdate>(globalObject, decoder);
    case MessageName::WebExtensionContext_TabsDuplicate:
        return jsValueForDecodedMessageReply<MessageName::WebExtensionContext_TabsDuplicate>(globalObject, decoder);
    case MessageName::WebExtensionContext_TabsGet:
        return jsValueForDecodedMessageReply<MessageName::WebExtensionContext_TabsGet>(globalObject, decoder);
    case MessageName::WebExtensionContext_TabsGetCurrent:
        return jsValueForDecodedMessageReply<MessageName::WebExtensionContext_TabsGetCurrent>(globalObject, decoder);
    case MessageName::WebExtensionContext_TabsQuery:
        return jsValueForDecodedMessageReply<MessageName::WebExtensionContext_TabsQuery>(globalObject, decoder);
    case MessageName::WebExtensionContext_TabsReload:
        return jsValueForDecodedMessageReply<MessageName::WebExtensionContext_TabsReload>(globalObject, decoder);
    case MessageName::WebExtensionContext_TabsGoBack:
        return jsValueForDecodedMessageReply<MessageName::WebExtensionContext_TabsGoBack>(globalObject, decoder);
    case MessageName::WebExtensionContext_TabsGoForward:
        return jsValueForDecodedMessageReply<MessageName::WebExtensionContext_TabsGoForward>(globalObject, decoder);
    case MessageName::WebExtensionContext_TabsDetectLanguage:
        return jsValueForDecodedMessageReply<MessageName::WebExtensionContext_TabsDetectLanguage>(globalObject, decoder);
    case MessageName::WebExtensionContext_TabsToggleReaderMode:
        return jsValueForDecodedMessageReply<MessageName::WebExtensionContext_TabsToggleReaderMode>(globalObject, decoder);
    case MessageName::WebExtensionContext_TabsCaptureVisibleTab:
        return jsValueForDecodedMessageReply<MessageName::WebExtensionContext_TabsCaptureVisibleTab>(globalObject, decoder);
    case MessageName::WebExtensionContext_TabsSendMessage:
        return jsValueForDecodedMessageReply<MessageName::WebExtensionContext_TabsSendMessage>(globalObject, decoder);
    case MessageName::WebExtensionContext_TabsConnect:
        return jsValueForDecodedMessageReply<MessageName::WebExtensionContext_TabsConnect>(globalObject, decoder);
    case MessageName::WebExtensionContext_TabsGetZoom:
        return jsValueForDecodedMessageReply<MessageName::WebExtensionContext_TabsGetZoom>(globalObject, decoder);
    case MessageName::WebExtensionContext_TabsSetZoom:
        return jsValueForDecodedMessageReply<MessageName::WebExtensionContext_TabsSetZoom>(globalObject, decoder);
    case MessageName::WebExtensionContext_TabsRemove:
        return jsValueForDecodedMessageReply<MessageName::WebExtensionContext_TabsRemove>(globalObject, decoder);
    case MessageName::WebExtensionContext_TabsExecuteScript:
        return jsValueForDecodedMessageReply<MessageName::WebExtensionContext_TabsExecuteScript>(globalObject, decoder);
    case MessageName::WebExtensionContext_TabsInsertCSS:
        return jsValueForDecodedMessageReply<MessageName::WebExtensionContext_TabsInsertCSS>(globalObject, decoder);
    case MessageName::WebExtensionContext_TabsRemoveCSS:
        return jsValueForDecodedMessageReply<MessageName::WebExtensionContext_TabsRemoveCSS>(globalObject, decoder);
    case MessageName::WebExtensionContext_WebNavigationGetAllFrames:
        return jsValueForDecodedMessageReply<MessageName::WebExtensionContext_WebNavigationGetAllFrames>(globalObject, decoder);
    case MessageName::WebExtensionContext_WebNavigationGetFrame:
        return jsValueForDecodedMessageReply<MessageName::WebExtensionContext_WebNavigationGetFrame>(globalObject, decoder);
    case MessageName::WebExtensionContext_WindowsCreate:
        return jsValueForDecodedMessageReply<MessageName::WebExtensionContext_WindowsCreate>(globalObject, decoder);
    case MessageName::WebExtensionContext_WindowsGet:
        return jsValueForDecodedMessageReply<MessageName::WebExtensionContext_WindowsGet>(globalObject, decoder);
    case MessageName::WebExtensionContext_WindowsGetLastFocused:
        return jsValueForDecodedMessageReply<MessageName::WebExtensionContext_WindowsGetLastFocused>(globalObject, decoder);
    case MessageName::WebExtensionContext_WindowsGetAll:
        return jsValueForDecodedMessageReply<MessageName::WebExtensionContext_WindowsGetAll>(globalObject, decoder);
    case MessageName::WebExtensionContext_WindowsUpdate:
        return jsValueForDecodedMessageReply<MessageName::WebExtensionContext_WindowsUpdate>(globalObject, decoder);
    case MessageName::WebExtensionContext_WindowsRemove:
        return jsValueForDecodedMessageReply<MessageName::WebExtensionContext_WindowsRemove>(globalObject, decoder);
#endif
#if ENABLE(WK_WEB_EXTENSIONS)
#endif
#if ENABLE(MEDIA_SESSION_COORDINATOR)
    case MessageName::RemoteMediaSessionCoordinatorProxy_Join:
        return jsValueForDecodedMessageReply<MessageName::RemoteMediaSessionCoordinatorProxy_Join>(globalObject, decoder);
    case MessageName::RemoteMediaSessionCoordinatorProxy_CoordinateSeekTo:
        return jsValueForDecodedMessageReply<MessageName::RemoteMediaSessionCoordinatorProxy_CoordinateSeekTo>(globalObject, decoder);
    case MessageName::RemoteMediaSessionCoordinatorProxy_CoordinatePlay:
        return jsValueForDecodedMessageReply<MessageName::RemoteMediaSessionCoordinatorProxy_CoordinatePlay>(globalObject, decoder);
    case MessageName::RemoteMediaSessionCoordinatorProxy_CoordinatePause:
        return jsValueForDecodedMessageReply<MessageName::RemoteMediaSessionCoordinatorProxy_CoordinatePause>(globalObject, decoder);
    case MessageName::RemoteMediaSessionCoordinatorProxy_CoordinateSetTrack:
        return jsValueForDecodedMessageReply<MessageName::RemoteMediaSessionCoordinatorProxy_CoordinateSetTrack>(globalObject, decoder);
#endif
#if ENABLE(MEDIA_STREAM)
#endif
    case MessageName::WebFrameProxy_FindFocusableElementDescendingIntoRemoteFrame:
        return jsValueForDecodedMessageReply<MessageName::WebFrameProxy_FindFocusableElementDescendingIntoRemoteFrame>(globalObject, decoder);
#if ENABLE(FULLSCREEN_API)
    case MessageName::WebFullScreenManagerProxy_EnterFullScreen:
        return jsValueForDecodedMessageReply<MessageName::WebFullScreenManagerProxy_EnterFullScreen>(globalObject, decoder);
    case MessageName::WebFullScreenManagerProxy_ExitFullScreen:
        return jsValueForDecodedMessageReply<MessageName::WebFullScreenManagerProxy_ExitFullScreen>(globalObject, decoder);
    case MessageName::WebFullScreenManagerProxy_BeganEnterFullScreen:
        return jsValueForDecodedMessageReply<MessageName::WebFullScreenManagerProxy_BeganEnterFullScreen>(globalObject, decoder);
    case MessageName::WebFullScreenManagerProxy_BeganExitFullScreen:
        return jsValueForDecodedMessageReply<MessageName::WebFullScreenManagerProxy_BeganExitFullScreen>(globalObject, decoder);
#endif
    case MessageName::WebLockRegistryProxy_AbortLockRequest:
        return jsValueForDecodedMessageReply<MessageName::WebLockRegistryProxy_AbortLockRequest>(globalObject, decoder);
    case MessageName::WebLockRegistryProxy_Snapshot:
        return jsValueForDecodedMessageReply<MessageName::WebLockRegistryProxy_Snapshot>(globalObject, decoder);
    case MessageName::WebPageProxy_CreateNewPage:
        return jsValueForDecodedMessageReply<MessageName::WebPageProxy_CreateNewPage>(globalObject, decoder);
    case MessageName::WebPageProxy_RunJavaScriptAlert:
        return jsValueForDecodedMessageReply<MessageName::WebPageProxy_RunJavaScriptAlert>(globalObject, decoder);
    case MessageName::WebPageProxy_RunJavaScriptConfirm:
        return jsValueForDecodedMessageReply<MessageName::WebPageProxy_RunJavaScriptConfirm>(globalObject, decoder);
    case MessageName::WebPageProxy_RunJavaScriptPrompt:
        return jsValueForDecodedMessageReply<MessageName::WebPageProxy_RunJavaScriptPrompt>(globalObject, decoder);
    case MessageName::WebPageProxy_FocusFromServiceWorker:
        return jsValueForDecodedMessageReply<MessageName::WebPageProxy_FocusFromServiceWorker>(globalObject, decoder);
    case MessageName::WebPageProxy_GetToolbarsAreVisible:
        return jsValueForDecodedMessageReply<MessageName::WebPageProxy_GetToolbarsAreVisible>(globalObject, decoder);
    case MessageName::WebPageProxy_GetMenuBarIsVisible:
        return jsValueForDecodedMessageReply<MessageName::WebPageProxy_GetMenuBarIsVisible>(globalObject, decoder);
    case MessageName::WebPageProxy_GetStatusBarIsVisible:
        return jsValueForDecodedMessageReply<MessageName::WebPageProxy_GetStatusBarIsVisible>(globalObject, decoder);
    case MessageName::WebPageProxy_GetWindowFrame:
        return jsValueForDecodedMessageReply<MessageName::WebPageProxy_GetWindowFrame>(globalObject, decoder);
    case MessageName::WebPageProxy_ScreenToRootView:
        return jsValueForDecodedMessageReply<MessageName::WebPageProxy_ScreenToRootView>(globalObject, decoder);
    case MessageName::WebPageProxy_RootViewPointToScreen:
        return jsValueForDecodedMessageReply<MessageName::WebPageProxy_RootViewPointToScreen>(globalObject, decoder);
    case MessageName::WebPageProxy_RootViewRectToScreen:
        return jsValueForDecodedMessageReply<MessageName::WebPageProxy_RootViewRectToScreen>(globalObject, decoder);
    case MessageName::WebPageProxy_AccessibilityScreenToRootView:
        return jsValueForDecodedMessageReply<MessageName::WebPageProxy_AccessibilityScreenToRootView>(globalObject, decoder);
    case MessageName::WebPageProxy_RootViewToAccessibilityScreen:
        return jsValueForDecodedMessageReply<MessageName::WebPageProxy_RootViewToAccessibilityScreen>(globalObject, decoder);
    case MessageName::WebPageProxy_RunBeforeUnloadConfirmPanel:
        return jsValueForDecodedMessageReply<MessageName::WebPageProxy_RunBeforeUnloadConfirmPanel>(globalObject, decoder);
    case MessageName::WebPageProxy_ShowShareSheet:
        return jsValueForDecodedMessageReply<MessageName::WebPageProxy_ShowShareSheet>(globalObject, decoder);
    case MessageName::WebPageProxy_ShowContactPicker:
        return jsValueForDecodedMessageReply<MessageName::WebPageProxy_ShowContactPicker>(globalObject, decoder);
#if HAVE(DIGITAL_CREDENTIALS_UI)
    case MessageName::WebPageProxy_ShowDigitalCredentialsPicker:
        return jsValueForDecodedMessageReply<MessageName::WebPageProxy_ShowDigitalCredentialsPicker>(globalObject, decoder);
    case MessageName::WebPageProxy_DismissDigitalCredentialsPicker:
        return jsValueForDecodedMessageReply<MessageName::WebPageProxy_DismissDigitalCredentialsPicker>(globalObject, decoder);
#endif
    case MessageName::WebPageProxy_PrintFrame:
        return jsValueForDecodedMessageReply<MessageName::WebPageProxy_PrintFrame>(globalObject, decoder);
    case MessageName::WebPageProxy_DecidePolicyForResponse:
        return jsValueForDecodedMessageReply<MessageName::WebPageProxy_DecidePolicyForResponse>(globalObject, decoder);
    case MessageName::WebPageProxy_DecidePolicyForNavigationActionAsync:
        return jsValueForDecodedMessageReply<MessageName::WebPageProxy_DecidePolicyForNavigationActionAsync>(globalObject, decoder);
    case MessageName::WebPageProxy_DecidePolicyForNavigationActionSync:
        return jsValueForDecodedMessageReply<MessageName::WebPageProxy_DecidePolicyForNavigationActionSync>(globalObject, decoder);
    case MessageName::WebPageProxy_DecidePolicyForNewWindowAction:
        return jsValueForDecodedMessageReply<MessageName::WebPageProxy_DecidePolicyForNewWindowAction>(globalObject, decoder);
    case MessageName::WebPageProxy_ResolveAccessibilityHitTestForTesting:
        return jsValueForDecodedMessageReply<MessageName::WebPageProxy_ResolveAccessibilityHitTestForTesting>(globalObject, decoder);
    case MessageName::WebPageProxy_WillSubmitForm:
        return jsValueForDecodedMessageReply<MessageName::WebPageProxy_WillSubmitForm>(globalObject, decoder);
#if PLATFORM(IOS_FAMILY)
    case MessageName::WebPageProxy_InterpretKeyEvent:
        return jsValueForDecodedMessageReply<MessageName::WebPageProxy_InterpretKeyEvent>(globalObject, decoder);
    case MessageName::WebPageProxy_IsPotentialTapInProgress:
        return jsValueForDecodedMessageReply<MessageName::WebPageProxy_IsPotentialTapInProgress>(globalObject, decoder);
#endif
    case MessageName::WebPageProxy_BackForwardGoToItem:
        return jsValueForDecodedMessageReply<MessageName::WebPageProxy_BackForwardGoToItem>(globalObject, decoder);
    case MessageName::WebPageProxy_BackForwardItemAtIndex:
        return jsValueForDecodedMessageReply<MessageName::WebPageProxy_BackForwardItemAtIndex>(globalObject, decoder);
    case MessageName::WebPageProxy_BackForwardListContainsItem:
        return jsValueForDecodedMessageReply<MessageName::WebPageProxy_BackForwardListContainsItem>(globalObject, decoder);
    case MessageName::WebPageProxy_BackForwardListCounts:
        return jsValueForDecodedMessageReply<MessageName::WebPageProxy_BackForwardListCounts>(globalObject, decoder);
    case MessageName::WebPageProxy_ShouldGoToBackForwardListItem:
        return jsValueForDecodedMessageReply<MessageName::WebPageProxy_ShouldGoToBackForwardListItem>(globalObject, decoder);
    case MessageName::WebPageProxy_ShouldGoToBackForwardListItemSync:
        return jsValueForDecodedMessageReply<MessageName::WebPageProxy_ShouldGoToBackForwardListItemSync>(globalObject, decoder);
    case MessageName::WebPageProxy_CanUndoRedo:
        return jsValueForDecodedMessageReply<MessageName::WebPageProxy_CanUndoRedo>(globalObject, decoder);
    case MessageName::WebPageProxy_ExecuteUndoRedo:
        return jsValueForDecodedMessageReply<MessageName::WebPageProxy_ExecuteUndoRedo>(globalObject, decoder);
#if ENABLE(IMAGE_ANALYSIS)
    case MessageName::WebPageProxy_RequestTextRecognition:
        return jsValueForDecodedMessageReply<MessageName::WebPageProxy_RequestTextRecognition>(globalObject, decoder);
#endif
#if ENABLE(WRITING_TOOLS)
    case MessageName::WebPageProxy_AddTextAnimationForAnimationIDWithCompletionHandler:
        return jsValueForDecodedMessageReply<MessageName::WebPageProxy_AddTextAnimationForAnimationIDWithCompletionHandler>(globalObject, decoder);
#endif
#if ENABLE(MEDIA_CONTROLS_CONTEXT_MENUS) && USE(UICONTEXTMENU)
    case MessageName::WebPageProxy_ShowMediaControlsContextMenu:
        return jsValueForDecodedMessageReply<MessageName::WebPageProxy_ShowMediaControlsContextMenu>(globalObject, decoder);
#endif
    case MessageName::WebPageProxy_RequestDOMPasteAccess:
        return jsValueForDecodedMessageReply<MessageName::WebPageProxy_RequestDOMPasteAccess>(globalObject, decoder);
    case MessageName::WebPageProxy_ExceededDatabaseQuota:
        return jsValueForDecodedMessageReply<MessageName::WebPageProxy_ExceededDatabaseQuota>(globalObject, decoder);
#if ENABLE(MEDIA_STREAM)
    case MessageName::WebPageProxy_EnumerateMediaDevicesForFrame:
        return jsValueForDecodedMessageReply<MessageName::WebPageProxy_EnumerateMediaDevicesForFrame>(globalObject, decoder);
    case MessageName::WebPageProxy_ValidateCaptureStateUpdate:
        return jsValueForDecodedMessageReply<MessageName::WebPageProxy_ValidateCaptureStateUpdate>(globalObject, decoder);
#endif
    case MessageName::WebPageProxy_RequestNotificationPermission:
        return jsValueForDecodedMessageReply<MessageName::WebPageProxy_RequestNotificationPermission>(globalObject, decoder);
#if USE(UNIFIED_TEXT_CHECKING)
    case MessageName::WebPageProxy_CheckTextOfParagraph:
        return jsValueForDecodedMessageReply<MessageName::WebPageProxy_CheckTextOfParagraph>(globalObject, decoder);
#endif
    case MessageName::WebPageProxy_CheckSpellingOfString:
        return jsValueForDecodedMessageReply<MessageName::WebPageProxy_CheckSpellingOfString>(globalObject, decoder);
    case MessageName::WebPageProxy_CheckGrammarOfString:
        return jsValueForDecodedMessageReply<MessageName::WebPageProxy_CheckGrammarOfString>(globalObject, decoder);
    case MessageName::WebPageProxy_SpellingUIIsShowing:
        return jsValueForDecodedMessageReply<MessageName::WebPageProxy_SpellingUIIsShowing>(globalObject, decoder);
    case MessageName::WebPageProxy_GetGuessesForWord:
        return jsValueForDecodedMessageReply<MessageName::WebPageProxy_GetGuessesForWord>(globalObject, decoder);
#if PLATFORM(COCOA)
    case MessageName::WebPageProxy_ExecuteSavedCommandBySelector:
        return jsValueForDecodedMessageReply<MessageName::WebPageProxy_ExecuteSavedCommandBySelector>(globalObject, decoder);
    case MessageName::WebPageProxy_GetIsSpeaking:
        return jsValueForDecodedMessageReply<MessageName::WebPageProxy_GetIsSpeaking>(globalObject, decoder);
#endif
#if USE(APPKIT)
    case MessageName::WebPageProxy_SubstitutionsPanelIsShowing:
        return jsValueForDecodedMessageReply<MessageName::WebPageProxy_SubstitutionsPanelIsShowing>(globalObject, decoder);
#endif
#if PLATFORM(MAC)
    case MessageName::WebPageProxy_DismissCorrectionPanelSoon:
        return jsValueForDecodedMessageReply<MessageName::WebPageProxy_DismissCorrectionPanelSoon>(globalObject, decoder);
#endif
#if USE(DICTATION_ALTERNATIVES)
    case MessageName::WebPageProxy_DictationAlternatives:
        return jsValueForDecodedMessageReply<MessageName::WebPageProxy_DictationAlternatives>(globalObject, decoder);
#endif
    case MessageName::WebPageProxy_LoadRecentSearches:
        return jsValueForDecodedMessageReply<MessageName::WebPageProxy_LoadRecentSearches>(globalObject, decoder);
    case MessageName::WebPageProxy_SerializeAndWrapCryptoKey:
        return jsValueForDecodedMessageReply<MessageName::WebPageProxy_SerializeAndWrapCryptoKey>(globalObject, decoder);
    case MessageName::WebPageProxy_UnwrapCryptoKey:
        return jsValueForDecodedMessageReply<MessageName::WebPageProxy_UnwrapCryptoKey>(globalObject, decoder);
#if USE(QUICK_LOOK)
    case MessageName::WebPageProxy_RequestPasswordForQuickLookDocumentInMainFrame:
        return jsValueForDecodedMessageReply<MessageName::WebPageProxy_RequestPasswordForQuickLookDocumentInMainFrame>(globalObject, decoder);
#endif
    case MessageName::WebPageProxy_HandleMessageWithAsyncReply:
        return jsValueForDecodedMessageReply<MessageName::WebPageProxy_HandleMessageWithAsyncReply>(globalObject, decoder);
    case MessageName::WebPageProxy_HandleSynchronousMessage:
        return jsValueForDecodedMessageReply<MessageName::WebPageProxy_HandleSynchronousMessage>(globalObject, decoder);
#if ENABLE(POINTER_LOCK)
    case MessageName::WebPageProxy_RequestPointerLock:
        return jsValueForDecodedMessageReply<MessageName::WebPageProxy_RequestPointerLock>(globalObject, decoder);
    case MessageName::WebPageProxy_RequestPointerUnlock:
        return jsValueForDecodedMessageReply<MessageName::WebPageProxy_RequestPointerUnlock>(globalObject, decoder);
#endif
    case MessageName::WebPageProxy_LoadSynchronousURLSchemeTask:
        return jsValueForDecodedMessageReply<MessageName::WebPageProxy_LoadSynchronousURLSchemeTask>(globalObject, decoder);
#if ENABLE(DEVICE_ORIENTATION)
    case MessageName::WebPageProxy_ShouldAllowDeviceOrientationAndMotionAccess:
        return jsValueForDecodedMessageReply<MessageName::WebPageProxy_ShouldAllowDeviceOrientationAndMotionAccess>(globalObject, decoder);
#endif
#if ENABLE(ATTACHMENT_ELEMENT)
    case MessageName::WebPageProxy_SerializedAttachmentDataForIdentifiers:
        return jsValueForDecodedMessageReply<MessageName::WebPageProxy_SerializedAttachmentDataForIdentifiers>(globalObject, decoder);
#endif
#if ENABLE(SPEECH_SYNTHESIS)
    case MessageName::WebPageProxy_SpeechSynthesisVoiceList:
        return jsValueForDecodedMessageReply<MessageName::WebPageProxy_SpeechSynthesisVoiceList>(globalObject, decoder);
    case MessageName::WebPageProxy_SpeechSynthesisSpeak:
        return jsValueForDecodedMessageReply<MessageName::WebPageProxy_SpeechSynthesisSpeak>(globalObject, decoder);
    case MessageName::WebPageProxy_SpeechSynthesisSetFinishedCallback:
        return jsValueForDecodedMessageReply<MessageName::WebPageProxy_SpeechSynthesisSetFinishedCallback>(globalObject, decoder);
    case MessageName::WebPageProxy_SpeechSynthesisPause:
        return jsValueForDecodedMessageReply<MessageName::WebPageProxy_SpeechSynthesisPause>(globalObject, decoder);
    case MessageName::WebPageProxy_SpeechSynthesisResume:
        return jsValueForDecodedMessageReply<MessageName::WebPageProxy_SpeechSynthesisResume>(globalObject, decoder);
#endif
#if ENABLE(PDF_PLUGIN) && PLATFORM(MAC)
    case MessageName::WebPageProxy_ShowPDFContextMenu:
        return jsValueForDecodedMessageReply<MessageName::WebPageProxy_ShowPDFContextMenu>(globalObject, decoder);
#endif
#if PLATFORM(GTK)
    case MessageName::WebPageProxy_ShowEmojiPicker:
        return jsValueForDecodedMessageReply<MessageName::WebPageProxy_ShowEmojiPicker>(globalObject, decoder);
#endif
#if PLATFORM(GTK) || PLATFORM(WPE)
    case MessageName::WebPageProxy_SendMessageToWebViewWithReply:
        return jsValueForDecodedMessageReply<MessageName::WebPageProxy_SendMessageToWebViewWithReply>(globalObject, decoder);
#endif
#if ENABLE(ARKIT_INLINE_PREVIEW_MAC)
    case MessageName::WebPageProxy_ModelElementCreateRemotePreview:
        return jsValueForDecodedMessageReply<MessageName::WebPageProxy_ModelElementCreateRemotePreview>(globalObject, decoder);
    case MessageName::WebPageProxy_ModelElementLoadRemotePreview:
        return jsValueForDecodedMessageReply<MessageName::WebPageProxy_ModelElementLoadRemotePreview>(globalObject, decoder);
    case MessageName::WebPageProxy_ModelElementSizeDidChange:
        return jsValueForDecodedMessageReply<MessageName::WebPageProxy_ModelElementSizeDidChange>(globalObject, decoder);
    case MessageName::WebPageProxy_ModelInlinePreviewUUIDs:
        return jsValueForDecodedMessageReply<MessageName::WebPageProxy_ModelInlinePreviewUUIDs>(globalObject, decoder);
#endif
#if ENABLE(ARKIT_INLINE_PREVIEW)
    case MessageName::WebPageProxy_ModelElementGetCamera:
        return jsValueForDecodedMessageReply<MessageName::WebPageProxy_ModelElementGetCamera>(globalObject, decoder);
    case MessageName::WebPageProxy_ModelElementSetCamera:
        return jsValueForDecodedMessageReply<MessageName::WebPageProxy_ModelElementSetCamera>(globalObject, decoder);
    case MessageName::WebPageProxy_ModelElementIsPlayingAnimation:
        return jsValueForDecodedMessageReply<MessageName::WebPageProxy_ModelElementIsPlayingAnimation>(globalObject, decoder);
    case MessageName::WebPageProxy_ModelElementSetAnimationIsPlaying:
        return jsValueForDecodedMessageReply<MessageName::WebPageProxy_ModelElementSetAnimationIsPlaying>(globalObject, decoder);
    case MessageName::WebPageProxy_ModelElementIsLoopingAnimation:
        return jsValueForDecodedMessageReply<MessageName::WebPageProxy_ModelElementIsLoopingAnimation>(globalObject, decoder);
    case MessageName::WebPageProxy_ModelElementSetIsLoopingAnimation:
        return jsValueForDecodedMessageReply<MessageName::WebPageProxy_ModelElementSetIsLoopingAnimation>(globalObject, decoder);
    case MessageName::WebPageProxy_ModelElementAnimationDuration:
        return jsValueForDecodedMessageReply<MessageName::WebPageProxy_ModelElementAnimationDuration>(globalObject, decoder);
    case MessageName::WebPageProxy_ModelElementAnimationCurrentTime:
        return jsValueForDecodedMessageReply<MessageName::WebPageProxy_ModelElementAnimationCurrentTime>(globalObject, decoder);
    case MessageName::WebPageProxy_ModelElementSetAnimationCurrentTime:
        return jsValueForDecodedMessageReply<MessageName::WebPageProxy_ModelElementSetAnimationCurrentTime>(globalObject, decoder);
    case MessageName::WebPageProxy_ModelElementHasAudio:
        return jsValueForDecodedMessageReply<MessageName::WebPageProxy_ModelElementHasAudio>(globalObject, decoder);
    case MessageName::WebPageProxy_ModelElementIsMuted:
        return jsValueForDecodedMessageReply<MessageName::WebPageProxy_ModelElementIsMuted>(globalObject, decoder);
    case MessageName::WebPageProxy_ModelElementSetIsMuted:
        return jsValueForDecodedMessageReply<MessageName::WebPageProxy_ModelElementSetIsMuted>(globalObject, decoder);
#endif
#if ENABLE(APPLE_PAY_AMS_UI)
    case MessageName::WebPageProxy_StartApplePayAMSUISession:
        return jsValueForDecodedMessageReply<MessageName::WebPageProxy_StartApplePayAMSUISession>(globalObject, decoder);
#endif
#if USE(SYSTEM_PREVIEW)
    case MessageName::WebPageProxy_BeginSystemPreview:
        return jsValueForDecodedMessageReply<MessageName::WebPageProxy_BeginSystemPreview>(globalObject, decoder);
#endif
    case MessageName::WebPageProxy_RequestCookieConsent:
        return jsValueForDecodedMessageReply<MessageName::WebPageProxy_RequestCookieConsent>(globalObject, decoder);
    case MessageName::WebPageProxy_RenderTreeAsTextForTesting:
        return jsValueForDecodedMessageReply<MessageName::WebPageProxy_RenderTreeAsTextForTesting>(globalObject, decoder);
    case MessageName::WebPageProxy_FrameTextForTesting:
        return jsValueForDecodedMessageReply<MessageName::WebPageProxy_FrameTextForTesting>(globalObject, decoder);
    case MessageName::WebPageProxy_LayerTreeAsTextForTesting:
        return jsValueForDecodedMessageReply<MessageName::WebPageProxy_LayerTreeAsTextForTesting>(globalObject, decoder);
    case MessageName::WebPageProxy_BindRemoteAccessibilityFrames:
        return jsValueForDecodedMessageReply<MessageName::WebPageProxy_BindRemoteAccessibilityFrames>(globalObject, decoder);
    case MessageName::WebPageProxy_DocumentURLForConsoleLog:
        return jsValueForDecodedMessageReply<MessageName::WebPageProxy_DocumentURLForConsoleLog>(globalObject, decoder);
    case MessageName::WebPasteboardProxy_WriteCustomData:
        return jsValueForDecodedMessageReply<MessageName::WebPasteboardProxy_WriteCustomData>(globalObject, decoder);
    case MessageName::WebPasteboardProxy_TypesSafeForDOMToReadAndWrite:
        return jsValueForDecodedMessageReply<MessageName::WebPasteboardProxy_TypesSafeForDOMToReadAndWrite>(globalObject, decoder);
    case MessageName::WebPasteboardProxy_AllPasteboardItemInfo:
        return jsValueForDecodedMessageReply<MessageName::WebPasteboardProxy_AllPasteboardItemInfo>(globalObject, decoder);
    case MessageName::WebPasteboardProxy_InformationForItemAtIndex:
        return jsValueForDecodedMessageReply<MessageName::WebPasteboardProxy_InformationForItemAtIndex>(globalObject, decoder);
    case MessageName::WebPasteboardProxy_GetPasteboardItemsCount:
        return jsValueForDecodedMessageReply<MessageName::WebPasteboardProxy_GetPasteboardItemsCount>(globalObject, decoder);
    case MessageName::WebPasteboardProxy_ReadStringFromPasteboard:
        return jsValueForDecodedMessageReply<MessageName::WebPasteboardProxy_ReadStringFromPasteboard>(globalObject, decoder);
    case MessageName::WebPasteboardProxy_ReadURLFromPasteboard:
        return jsValueForDecodedMessageReply<MessageName::WebPasteboardProxy_ReadURLFromPasteboard>(globalObject, decoder);
    case MessageName::WebPasteboardProxy_ReadBufferFromPasteboard:
        return jsValueForDecodedMessageReply<MessageName::WebPasteboardProxy_ReadBufferFromPasteboard>(globalObject, decoder);
    case MessageName::WebPasteboardProxy_ContainsStringSafeForDOMToReadForType:
        return jsValueForDecodedMessageReply<MessageName::WebPasteboardProxy_ContainsStringSafeForDOMToReadForType>(globalObject, decoder);
#if PLATFORM(COCOA)
    case MessageName::WebPasteboardProxy_GetNumberOfFiles:
        return jsValueForDecodedMessageReply<MessageName::WebPasteboardProxy_GetNumberOfFiles>(globalObject, decoder);
    case MessageName::WebPasteboardProxy_GetPasteboardTypes:
        return jsValueForDecodedMessageReply<MessageName::WebPasteboardProxy_GetPasteboardTypes>(globalObject, decoder);
    case MessageName::WebPasteboardProxy_GetPasteboardPathnamesForType:
        return jsValueForDecodedMessageReply<MessageName::WebPasteboardProxy_GetPasteboardPathnamesForType>(globalObject, decoder);
    case MessageName::WebPasteboardProxy_GetPasteboardStringForType:
        return jsValueForDecodedMessageReply<MessageName::WebPasteboardProxy_GetPasteboardStringForType>(globalObject, decoder);
    case MessageName::WebPasteboardProxy_GetPasteboardStringsForType:
        return jsValueForDecodedMessageReply<MessageName::WebPasteboardProxy_GetPasteboardStringsForType>(globalObject, decoder);
    case MessageName::WebPasteboardProxy_GetPasteboardBufferForType:
        return jsValueForDecodedMessageReply<MessageName::WebPasteboardProxy_GetPasteboardBufferForType>(globalObject, decoder);
    case MessageName::WebPasteboardProxy_GetPasteboardChangeCount:
        return jsValueForDecodedMessageReply<MessageName::WebPasteboardProxy_GetPasteboardChangeCount>(globalObject, decoder);
    case MessageName::WebPasteboardProxy_GetPasteboardColor:
        return jsValueForDecodedMessageReply<MessageName::WebPasteboardProxy_GetPasteboardColor>(globalObject, decoder);
    case MessageName::WebPasteboardProxy_GetPasteboardURL:
        return jsValueForDecodedMessageReply<MessageName::WebPasteboardProxy_GetPasteboardURL>(globalObject, decoder);
    case MessageName::WebPasteboardProxy_AddPasteboardTypes:
        return jsValueForDecodedMessageReply<MessageName::WebPasteboardProxy_AddPasteboardTypes>(globalObject, decoder);
    case MessageName::WebPasteboardProxy_SetPasteboardTypes:
        return jsValueForDecodedMessageReply<MessageName::WebPasteboardProxy_SetPasteboardTypes>(globalObject, decoder);
    case MessageName::WebPasteboardProxy_SetPasteboardURL:
        return jsValueForDecodedMessageReply<MessageName::WebPasteboardProxy_SetPasteboardURL>(globalObject, decoder);
    case MessageName::WebPasteboardProxy_SetPasteboardColor:
        return jsValueForDecodedMessageReply<MessageName::WebPasteboardProxy_SetPasteboardColor>(globalObject, decoder);
    case MessageName::WebPasteboardProxy_SetPasteboardStringForType:
        return jsValueForDecodedMessageReply<MessageName::WebPasteboardProxy_SetPasteboardStringForType>(globalObject, decoder);
    case MessageName::WebPasteboardProxy_SetPasteboardBufferForType:
        return jsValueForDecodedMessageReply<MessageName::WebPasteboardProxy_SetPasteboardBufferForType>(globalObject, decoder);
    case MessageName::WebPasteboardProxy_ContainsURLStringSuitableForLoading:
        return jsValueForDecodedMessageReply<MessageName::WebPasteboardProxy_ContainsURLStringSuitableForLoading>(globalObject, decoder);
    case MessageName::WebPasteboardProxy_URLStringSuitableForLoading:
        return jsValueForDecodedMessageReply<MessageName::WebPasteboardProxy_URLStringSuitableForLoading>(globalObject, decoder);
#endif
#if (PLATFORM(COCOA) && ENABLE(IPC_TESTING_API))
    case MessageName::WebPasteboardProxy_TestIPCSharedMemory:
        return jsValueForDecodedMessageReply<MessageName::WebPasteboardProxy_TestIPCSharedMemory>(globalObject, decoder);
#endif
#if PLATFORM(GTK) || PLATFORM(WPE)
    case MessageName::WebPasteboardProxy_GetTypes:
        return jsValueForDecodedMessageReply<MessageName::WebPasteboardProxy_GetTypes>(globalObject, decoder);
    case MessageName::WebPasteboardProxy_ReadText:
        return jsValueForDecodedMessageReply<MessageName::WebPasteboardProxy_ReadText>(globalObject, decoder);
    case MessageName::WebPasteboardProxy_ReadFilePaths:
        return jsValueForDecodedMessageReply<MessageName::WebPasteboardProxy_ReadFilePaths>(globalObject, decoder);
    case MessageName::WebPasteboardProxy_ReadBuffer:
        return jsValueForDecodedMessageReply<MessageName::WebPasteboardProxy_ReadBuffer>(globalObject, decoder);
    case MessageName::WebPasteboardProxy_GetPasteboardChangeCount:
        return jsValueForDecodedMessageReply<MessageName::WebPasteboardProxy_GetPasteboardChangeCount>(globalObject, decoder);
#endif
#if USE(LIBWPE) && !PLATFORM(WPE)
    case MessageName::WebPasteboardProxy_GetPasteboardTypes:
        return jsValueForDecodedMessageReply<MessageName::WebPasteboardProxy_GetPasteboardTypes>(globalObject, decoder);
#endif
    case MessageName::WebPermissionControllerProxy_Query:
        return jsValueForDecodedMessageReply<MessageName::WebPermissionControllerProxy_Query>(globalObject, decoder);
    case MessageName::WebProcessPool_HandleSynchronousMessage:
        return jsValueForDecodedMessageReply<MessageName::WebProcessPool_HandleSynchronousMessage>(globalObject, decoder);
#if ENABLE(GAMEPAD)
    case MessageName::WebProcessPool_StoppedUsingGamepads:
        return jsValueForDecodedMessageReply<MessageName::WebProcessPool_StoppedUsingGamepads>(globalObject, decoder);
    case MessageName::WebProcessPool_PlayGamepadEffect:
        return jsValueForDecodedMessageReply<MessageName::WebProcessPool_PlayGamepadEffect>(globalObject, decoder);
    case MessageName::WebProcessPool_StopGamepadEffects:
        return jsValueForDecodedMessageReply<MessageName::WebProcessPool_StopGamepadEffects>(globalObject, decoder);
#endif
    case MessageName::WebProcessProxy_ShouldTerminate:
        return jsValueForDecodedMessageReply<MessageName::WebProcessProxy_ShouldTerminate>(globalObject, decoder);
    case MessageName::WebProcessProxy_GetNetworkProcessConnection:
        return jsValueForDecodedMessageReply<MessageName::WebProcessProxy_GetNetworkProcessConnection>(globalObject, decoder);
    case MessageName::WebProcessProxy_WaitForSharedPreferencesForWebProcessToSync:
        return jsValueForDecodedMessageReply<MessageName::WebProcessProxy_WaitForSharedPreferencesForWebProcessToSync>(globalObject, decoder);
#if PLATFORM(GTK) || PLATFORM(WPE)
    case MessageName::WebProcessProxy_SendMessageToWebContextWithReply:
        return jsValueForDecodedMessageReply<MessageName::WebProcessProxy_SendMessageToWebContextWithReply>(globalObject, decoder);
#endif
#if PLATFORM(MAC) || PLATFORM(MACCATALYST)
    case MessageName::WebProcessProxy_IsAXAuthenticated:
        return jsValueForDecodedMessageReply<MessageName::WebProcessProxy_IsAXAuthenticated>(globalObject, decoder);
#endif
#if ENABLE(NOTIFICATION_EVENT)
    case MessageName::WebProcessProxy_GetNotifications:
        return jsValueForDecodedMessageReply<MessageName::WebProcessProxy_GetNotifications>(globalObject, decoder);
#endif
    case MessageName::WebProcessProxy_SerializeAndWrapCryptoKey:
        return jsValueForDecodedMessageReply<MessageName::WebProcessProxy_SerializeAndWrapCryptoKey>(globalObject, decoder);
    case MessageName::WebProcessProxy_UnwrapCryptoKey:
        return jsValueForDecodedMessageReply<MessageName::WebProcessProxy_UnwrapCryptoKey>(globalObject, decoder);
#if (ENABLE(LOGD_BLOCKING_IN_WEBCONTENT) && ENABLE(STREAMING_IPC_IN_LOG_FORWARDING))
    case MessageName::WebProcessProxy_SetupLogStream:
        return jsValueForDecodedMessageReply<MessageName::WebProcessProxy_SetupLogStream>(globalObject, decoder);
#endif
#if (ENABLE(LOGD_BLOCKING_IN_WEBCONTENT) && !ENABLE(STREAMING_IPC_IN_LOG_FORWARDING))
    case MessageName::WebProcessProxy_SetupLogStream:
        return jsValueForDecodedMessageReply<MessageName::WebProcessProxy_SetupLogStream>(globalObject, decoder);
#endif
#if ENABLE(REMOTE_INSPECTOR) && PLATFORM(COCOA)
    case MessageName::WebProcessProxy_CreateServiceWorkerDebuggable:
        return jsValueForDecodedMessageReply<MessageName::WebProcessProxy_CreateServiceWorkerDebuggable>(globalObject, decoder);
#endif
    case MessageName::WebScreenOrientationManagerProxy_CurrentOrientation:
        return jsValueForDecodedMessageReply<MessageName::WebScreenOrientationManagerProxy_CurrentOrientation>(globalObject, decoder);
    case MessageName::WebScreenOrientationManagerProxy_Lock:
        return jsValueForDecodedMessageReply<MessageName::WebScreenOrientationManagerProxy_Lock>(globalObject, decoder);
    case MessageName::DownloadProxy_WillSendRequest:
        return jsValueForDecodedMessageReply<MessageName::DownloadProxy_WillSendRequest>(globalObject, decoder);
    case MessageName::DownloadProxy_DecideDestinationWithSuggestedFilename:
        return jsValueForDecodedMessageReply<MessageName::DownloadProxy_DecideDestinationWithSuggestedFilename>(globalObject, decoder);
#if HAVE(MODERN_DOWNLOADPROGRESS)
    case MessageName::DownloadProxy_DidReceivePlaceholderURL:
        return jsValueForDecodedMessageReply<MessageName::DownloadProxy_DidReceivePlaceholderURL>(globalObject, decoder);
#endif
#if ENABLE(GPU_PROCESS)
#if (ENABLE(MEDIA_STREAM) && PLATFORM(IOS_FAMILY))
    case MessageName::GPUProcessProxy_StatusBarWasTapped:
        return jsValueForDecodedMessageReply<MessageName::GPUProcessProxy_StatusBarWasTapped>(globalObject, decoder);
#endif
#endif
#if ENABLE(MODEL_PROCESS)
#if PLATFORM(VISION) && ENABLE(GPU_PROCESS)
    case MessageName::ModelProcessProxy_RequestSharedSimulationConnection:
        return jsValueForDecodedMessageReply<MessageName::ModelProcessProxy_RequestSharedSimulationConnection>(globalObject, decoder);
#endif
#endif
    case MessageName::RemoteWebInspectorUIProxy_Load:
        return jsValueForDecodedMessageReply<MessageName::RemoteWebInspectorUIProxy_Load>(globalObject, decoder);
    case MessageName::RemoteWebInspectorUIProxy_PickColorFromScreen:
        return jsValueForDecodedMessageReply<MessageName::RemoteWebInspectorUIProxy_PickColorFromScreen>(globalObject, decoder);
    case MessageName::WebInspectorUIProxy_Load:
        return jsValueForDecodedMessageReply<MessageName::WebInspectorUIProxy_Load>(globalObject, decoder);
    case MessageName::WebInspectorUIProxy_PickColorFromScreen:
        return jsValueForDecodedMessageReply<MessageName::WebInspectorUIProxy_PickColorFromScreen>(globalObject, decoder);
    case MessageName::NetworkProcessProxy_TestProcessIncomingSyncMessagesWhenWaitingForSyncReply:
        return jsValueForDecodedMessageReply<MessageName::NetworkProcessProxy_TestProcessIncomingSyncMessagesWhenWaitingForSyncReply>(globalObject, decoder);
    case MessageName::NetworkProcessProxy_RequestStorageAccessConfirm:
        return jsValueForDecodedMessageReply<MessageName::NetworkProcessProxy_RequestStorageAccessConfirm>(globalObject, decoder);
    case MessageName::NetworkProcessProxy_DeleteWebsiteDataInUIProcessForRegistrableDomains:
        return jsValueForDecodedMessageReply<MessageName::NetworkProcessProxy_DeleteWebsiteDataInUIProcessForRegistrableDomains>(globalObject, decoder);
    case MessageName::NetworkProcessProxy_SetDomainsWithCrossPageStorageAccess:
        return jsValueForDecodedMessageReply<MessageName::NetworkProcessProxy_SetDomainsWithCrossPageStorageAccess>(globalObject, decoder);
    case MessageName::NetworkProcessProxy_RequestBackgroundFetchPermission:
        return jsValueForDecodedMessageReply<MessageName::NetworkProcessProxy_RequestBackgroundFetchPermission>(globalObject, decoder);
    case MessageName::NetworkProcessProxy_EstablishRemoteWorkerContextConnectionToNetworkProcess:
        return jsValueForDecodedMessageReply<MessageName::NetworkProcessProxy_EstablishRemoteWorkerContextConnectionToNetworkProcess>(globalObject, decoder);
#if ENABLE(APP_BOUND_DOMAINS)
    case MessageName::NetworkProcessProxy_GetAppBoundDomains:
        return jsValueForDecodedMessageReply<MessageName::NetworkProcessProxy_GetAppBoundDomains>(globalObject, decoder);
#endif
    case MessageName::NetworkProcessProxy_TriggerBrowsingContextGroupSwitchForNavigation:
        return jsValueForDecodedMessageReply<MessageName::NetworkProcessProxy_TriggerBrowsingContextGroupSwitchForNavigation>(globalObject, decoder);
#if ENABLE(APPLE_PAY_REMOTE_UI_USES_SCENE)
    case MessageName::NetworkProcessProxy_GetWindowSceneAndBundleIdentifierForPaymentPresentation:
        return jsValueForDecodedMessageReply<MessageName::NetworkProcessProxy_GetWindowSceneAndBundleIdentifierForPaymentPresentation>(globalObject, decoder);
#endif
#if ENABLE(APPLE_PAY_REMOTE_UI)
    case MessageName::NetworkProcessProxy_GetPaymentCoordinatorEmbeddingUserAgent:
        return jsValueForDecodedMessageReply<MessageName::NetworkProcessProxy_GetPaymentCoordinatorEmbeddingUserAgent>(globalObject, decoder);
#endif
    case MessageName::NetworkProcessProxy_DataTaskReceivedChallenge:
        return jsValueForDecodedMessageReply<MessageName::NetworkProcessProxy_DataTaskReceivedChallenge>(globalObject, decoder);
    case MessageName::NetworkProcessProxy_DataTaskWillPerformHTTPRedirection:
        return jsValueForDecodedMessageReply<MessageName::NetworkProcessProxy_DataTaskWillPerformHTTPRedirection>(globalObject, decoder);
    case MessageName::NetworkProcessProxy_DataTaskDidReceiveResponse:
        return jsValueForDecodedMessageReply<MessageName::NetworkProcessProxy_DataTaskDidReceiveResponse>(globalObject, decoder);
    case MessageName::NetworkProcessProxy_OpenWindowFromServiceWorker:
        return jsValueForDecodedMessageReply<MessageName::NetworkProcessProxy_OpenWindowFromServiceWorker>(globalObject, decoder);
    case MessageName::NetworkProcessProxy_NavigateServiceWorkerClient:
        return jsValueForDecodedMessageReply<MessageName::NetworkProcessProxy_NavigateServiceWorkerClient>(globalObject, decoder);
    case MessageName::NetworkProcessProxy_DeleteWebsiteDataInWebProcessesForOrigin:
        return jsValueForDecodedMessageReply<MessageName::NetworkProcessProxy_DeleteWebsiteDataInWebProcessesForOrigin>(globalObject, decoder);
    case MessageName::NetworkProcessProxy_ReloadExecutionContextsForOrigin:
        return jsValueForDecodedMessageReply<MessageName::NetworkProcessProxy_ReloadExecutionContextsForOrigin>(globalObject, decoder);
    case MessageName::WebUserContentControllerProxy_DidPostMessage:
        return jsValueForDecodedMessageReply<MessageName::WebUserContentControllerProxy_DidPostMessage>(globalObject, decoder);
#if ENABLE(WEBXR)
    case MessageName::PlatformXRSystem_EnumerateImmersiveXRDevices:
        return jsValueForDecodedMessageReply<MessageName::PlatformXRSystem_EnumerateImmersiveXRDevices>(globalObject, decoder);
    case MessageName::PlatformXRSystem_RequestPermissionOnSessionFeatures:
        return jsValueForDecodedMessageReply<MessageName::PlatformXRSystem_RequestPermissionOnSessionFeatures>(globalObject, decoder);
    case MessageName::PlatformXRSystem_RequestFrame:
        return jsValueForDecodedMessageReply<MessageName::PlatformXRSystem_RequestFrame>(globalObject, decoder);
#endif
    case MessageName::WebProcess_InitializeWebProcess:
        return jsValueForDecodedMessageReply<MessageName::WebProcess_InitializeWebProcess>(globalObject, decoder);
    case MessageName::WebProcess_FetchWebsiteData:
        return jsValueForDecodedMessageReply<MessageName::WebProcess_FetchWebsiteData>(globalObject, decoder);
    case MessageName::WebProcess_DeleteWebsiteData:
        return jsValueForDecodedMessageReply<MessageName::WebProcess_DeleteWebsiteData>(globalObject, decoder);
    case MessageName::WebProcess_DeleteWebsiteDataForOrigins:
        return jsValueForDecodedMessageReply<MessageName::WebProcess_DeleteWebsiteDataForOrigins>(globalObject, decoder);
    case MessageName::WebProcess_DeleteWebsiteDataForOrigin:
        return jsValueForDecodedMessageReply<MessageName::WebProcess_DeleteWebsiteDataForOrigin>(globalObject, decoder);
    case MessageName::WebProcess_ReloadExecutionContextsForOrigin:
        return jsValueForDecodedMessageReply<MessageName::WebProcess_ReloadExecutionContextsForOrigin>(globalObject, decoder);
    case MessageName::WebProcess_DeleteAllCookies:
        return jsValueForDecodedMessageReply<MessageName::WebProcess_DeleteAllCookies>(globalObject, decoder);
    case MessageName::WebProcess_PrepareToSuspend:
        return jsValueForDecodedMessageReply<MessageName::WebProcess_PrepareToSuspend>(globalObject, decoder);
    case MessageName::WebProcess_EstablishRemoteWorkerContextConnectionToNetworkProcess:
        return jsValueForDecodedMessageReply<MessageName::WebProcess_EstablishRemoteWorkerContextConnectionToNetworkProcess>(globalObject, decoder);
    case MessageName::WebProcess_RegisterServiceWorkerClients:
        return jsValueForDecodedMessageReply<MessageName::WebProcess_RegisterServiceWorkerClients>(globalObject, decoder);
    case MessageName::WebProcess_SetIsInProcessCache:
        return jsValueForDecodedMessageReply<MessageName::WebProcess_SetIsInProcessCache>(globalObject, decoder);
    case MessageName::WebProcess_GetActivePagesOriginsForTesting:
        return jsValueForDecodedMessageReply<MessageName::WebProcess_GetActivePagesOriginsForTesting>(globalObject, decoder);
    case MessageName::WebProcess_IsJITEnabled:
        return jsValueForDecodedMessageReply<MessageName::WebProcess_IsJITEnabled>(globalObject, decoder);
    case MessageName::WebProcess_ClearCachedPage:
        return jsValueForDecodedMessageReply<MessageName::WebProcess_ClearCachedPage>(globalObject, decoder);
    case MessageName::WebProcess_SeedResourceLoadStatisticsForTesting:
        return jsValueForDecodedMessageReply<MessageName::WebProcess_SeedResourceLoadStatisticsForTesting>(globalObject, decoder);
    case MessageName::WebProcess_SetThirdPartyCookieBlockingMode:
        return jsValueForDecodedMessageReply<MessageName::WebProcess_SetThirdPartyCookieBlockingMode>(globalObject, decoder);
    case MessageName::WebProcess_SetDomainsWithCrossPageStorageAccess:
        return jsValueForDecodedMessageReply<MessageName::WebProcess_SetDomainsWithCrossPageStorageAccess>(globalObject, decoder);
    case MessageName::WebProcess_SendResourceLoadStatisticsDataImmediately:
        return jsValueForDecodedMessageReply<MessageName::WebProcess_SendResourceLoadStatisticsDataImmediately>(globalObject, decoder);
    case MessageName::WebProcess_ReleaseMemory:
        return jsValueForDecodedMessageReply<MessageName::WebProcess_ReleaseMemory>(globalObject, decoder);
#if ENABLE(NOTIFY_BLOCKING)
    case MessageName::WebProcess_GetNotifyStateForTesting:
        return jsValueForDecodedMessageReply<MessageName::WebProcess_GetNotifyStateForTesting>(globalObject, decoder);
#endif
#if ENABLE(CONTENT_EXTENSIONS)
    case MessageName::WebProcess_SetResourceMonitorContentRuleListAsync:
        return jsValueForDecodedMessageReply<MessageName::WebProcess_SetResourceMonitorContentRuleListAsync>(globalObject, decoder);
#endif
    case MessageName::WebAutomationSessionProxy_EvaluateJavaScriptFunction:
        return jsValueForDecodedMessageReply<MessageName::WebAutomationSessionProxy_EvaluateJavaScriptFunction>(globalObject, decoder);
    case MessageName::WebAutomationSessionProxy_ResolveChildFrameWithOrdinal:
        return jsValueForDecodedMessageReply<MessageName::WebAutomationSessionProxy_ResolveChildFrameWithOrdinal>(globalObject, decoder);
    case MessageName::WebAutomationSessionProxy_ResolveChildFrameWithNodeHandle:
        return jsValueForDecodedMessageReply<MessageName::WebAutomationSessionProxy_ResolveChildFrameWithNodeHandle>(globalObject, decoder);
    case MessageName::WebAutomationSessionProxy_ResolveChildFrameWithName:
        return jsValueForDecodedMessageReply<MessageName::WebAutomationSessionProxy_ResolveChildFrameWithName>(globalObject, decoder);
    case MessageName::WebAutomationSessionProxy_ResolveParentFrame:
        return jsValueForDecodedMessageReply<MessageName::WebAutomationSessionProxy_ResolveParentFrame>(globalObject, decoder);
    case MessageName::WebAutomationSessionProxy_FocusFrame:
        return jsValueForDecodedMessageReply<MessageName::WebAutomationSessionProxy_FocusFrame>(globalObject, decoder);
    case MessageName::WebAutomationSessionProxy_ComputeElementLayout:
        return jsValueForDecodedMessageReply<MessageName::WebAutomationSessionProxy_ComputeElementLayout>(globalObject, decoder);
    case MessageName::WebAutomationSessionProxy_GetComputedRole:
        return jsValueForDecodedMessageReply<MessageName::WebAutomationSessionProxy_GetComputedRole>(globalObject, decoder);
    case MessageName::WebAutomationSessionProxy_GetComputedLabel:
        return jsValueForDecodedMessageReply<MessageName::WebAutomationSessionProxy_GetComputedLabel>(globalObject, decoder);
    case MessageName::WebAutomationSessionProxy_SelectOptionElement:
        return jsValueForDecodedMessageReply<MessageName::WebAutomationSessionProxy_SelectOptionElement>(globalObject, decoder);
    case MessageName::WebAutomationSessionProxy_SetFilesForInputFileUpload:
        return jsValueForDecodedMessageReply<MessageName::WebAutomationSessionProxy_SetFilesForInputFileUpload>(globalObject, decoder);
    case MessageName::WebAutomationSessionProxy_TakeScreenshot:
        return jsValueForDecodedMessageReply<MessageName::WebAutomationSessionProxy_TakeScreenshot>(globalObject, decoder);
    case MessageName::WebAutomationSessionProxy_SnapshotRectForScreenshot:
        return jsValueForDecodedMessageReply<MessageName::WebAutomationSessionProxy_SnapshotRectForScreenshot>(globalObject, decoder);
    case MessageName::WebAutomationSessionProxy_GetCookiesForFrame:
        return jsValueForDecodedMessageReply<MessageName::WebAutomationSessionProxy_GetCookiesForFrame>(globalObject, decoder);
    case MessageName::WebAutomationSessionProxy_DeleteCookie:
        return jsValueForDecodedMessageReply<MessageName::WebAutomationSessionProxy_DeleteCookie>(globalObject, decoder);
#if HAVE(DIGITAL_CREDENTIALS_UI)
    case MessageName::DigitalCredentialsCoordinator_ProvideRawDigitalCredentialRequests:
        return jsValueForDecodedMessageReply<MessageName::DigitalCredentialsCoordinator_ProvideRawDigitalCredentialRequests>(globalObject, decoder);
#endif
#if ENABLE(WK_WEB_EXTENSIONS)
    case MessageName::WebExtensionContextProxy_DispatchRuntimeMessageEvent:
        return jsValueForDecodedMessageReply<MessageName::WebExtensionContextProxy_DispatchRuntimeMessageEvent>(globalObject, decoder);
    case MessageName::WebExtensionContextProxy_DispatchRuntimeConnectEvent:
        return jsValueForDecodedMessageReply<MessageName::WebExtensionContextProxy_DispatchRuntimeConnectEvent>(globalObject, decoder);
#endif
#if ENABLE(WK_WEB_EXTENSIONS)
#endif
#if ENABLE(FULLSCREEN_API)
    case MessageName::WebFullScreenManager_RequestRestoreFullScreen:
        return jsValueForDecodedMessageReply<MessageName::WebFullScreenManager_RequestRestoreFullScreen>(globalObject, decoder);
    case MessageName::WebFullScreenManager_EnterFullScreenForOwnerElements:
        return jsValueForDecodedMessageReply<MessageName::WebFullScreenManager_EnterFullScreenForOwnerElements>(globalObject, decoder);
    case MessageName::WebFullScreenManager_ExitFullScreenInMainFrame:
        return jsValueForDecodedMessageReply<MessageName::WebFullScreenManager_ExitFullScreenInMainFrame>(globalObject, decoder);
#endif
#if ENABLE(GPU_PROCESS)
#if ENABLE(ROUTING_ARBITRATION)
    case MessageName::GPUProcessConnection_BeginRoutingArbitrationWithCategory:
        return jsValueForDecodedMessageReply<MessageName::GPUProcessConnection_BeginRoutingArbitrationWithCategory>(globalObject, decoder);
#endif
#endif
#if ENABLE(GPU_PROCESS) && ENABLE(WEBGL)
#endif
#if ENABLE(GPU_PROCESS)
#endif
#if ENABLE(GPU_PROCESS)
#endif
#if ENABLE(GPU_PROCESS)
#endif
#if ENABLE(GPU_PROCESS)
#endif
#if ENABLE(GPU_PROCESS)
#endif
#if ENABLE(GPU_PROCESS) && ENABLE(VIDEO)
    case MessageName::MediaPlayerPrivateRemote_SendH2Ping:
        return jsValueForDecodedMessageReply<MessageName::MediaPlayerPrivateRemote_SendH2Ping>(globalObject, decoder);
#if PLATFORM(IOS_FAMILY)
    case MessageName::MediaPlayerPrivateRemote_GetRawCookies:
        return jsValueForDecodedMessageReply<MessageName::MediaPlayerPrivateRemote_GetRawCookies>(globalObject, decoder);
#endif
    case MessageName::MediaPlayerPrivateRemote_CommitAllTransactions:
        return jsValueForDecodedMessageReply<MessageName::MediaPlayerPrivateRemote_CommitAllTransactions>(globalObject, decoder);
#endif
#if ENABLE(GPU_PROCESS) && ENABLE(MEDIA_SOURCE)
    case MessageName::MediaSourcePrivateRemoteMessageReceiver_ProxyWaitForTarget:
        return jsValueForDecodedMessageReply<MessageName::MediaSourcePrivateRemoteMessageReceiver_ProxyWaitForTarget>(globalObject, decoder);
    case MessageName::MediaSourcePrivateRemoteMessageReceiver_ProxySeekToTime:
        return jsValueForDecodedMessageReply<MessageName::MediaSourcePrivateRemoteMessageReceiver_ProxySeekToTime>(globalObject, decoder);
#endif
#if ENABLE(GPU_PROCESS) && USE(AUDIO_SESSION)
#endif
#if PLATFORM(COCOA) && ENABLE(GPU_PROCESS)
#endif
#if ENABLE(GPU_PROCESS) && ENABLE(ENCRYPTED_MEDIA)
#endif
#if ENABLE(GPU_PROCESS) && ENABLE(ENCRYPTED_MEDIA)
#endif
#if ENABLE(GPU_PROCESS) && ENABLE(LEGACY_ENCRYPTED_MEDIA)
#endif
#if ENABLE(GPU_PROCESS)
#endif
#if ENABLE(GPU_PROCESS) && ENABLE(MEDIA_SOURCE)
    case MessageName::SourceBufferPrivateRemoteMessageReceiver_SourceBufferPrivateDidReceiveInitializationSegment:
        return jsValueForDecodedMessageReply<MessageName::SourceBufferPrivateRemoteMessageReceiver_SourceBufferPrivateDidReceiveInitializationSegment>(globalObject, decoder);
    case MessageName::SourceBufferPrivateRemoteMessageReceiver_SourceBufferPrivateBufferedChanged:
        return jsValueForDecodedMessageReply<MessageName::SourceBufferPrivateRemoteMessageReceiver_SourceBufferPrivateBufferedChanged>(globalObject, decoder);
    case MessageName::SourceBufferPrivateRemoteMessageReceiver_SourceBufferPrivateDurationChanged:
        return jsValueForDecodedMessageReply<MessageName::SourceBufferPrivateRemoteMessageReceiver_SourceBufferPrivateDurationChanged>(globalObject, decoder);
    case MessageName::SourceBufferPrivateRemoteMessageReceiver_SourceBufferPrivateDidAttach:
        return jsValueForDecodedMessageReply<MessageName::SourceBufferPrivateRemoteMessageReceiver_SourceBufferPrivateDidAttach>(globalObject, decoder);
#endif
#if USE(LIBWEBRTC) && PLATFORM(COCOA) && ENABLE(GPU_PROCESS)
#endif
#if PLATFORM(COCOA) && ENABLE(GPU_PROCESS) && ENABLE(VIDEO)
#endif
#if PLATFORM(COCOA) && ENABLE(GPU_PROCESS) && ENABLE(MEDIA_STREAM)
#endif
    case MessageName::WebInspector_Show:
        return jsValueForDecodedMessageReply<MessageName::WebInspector_Show>(globalObject, decoder);
#if ENABLE(MEDIA_SESSION_COORDINATOR)
    case MessageName::RemoteMediaSessionCoordinator_SeekSessionToTime:
        return jsValueForDecodedMessageReply<MessageName::RemoteMediaSessionCoordinator_SeekSessionToTime>(globalObject, decoder);
    case MessageName::RemoteMediaSessionCoordinator_PlaySession:
        return jsValueForDecodedMessageReply<MessageName::RemoteMediaSessionCoordinator_PlaySession>(globalObject, decoder);
    case MessageName::RemoteMediaSessionCoordinator_PauseSession:
        return jsValueForDecodedMessageReply<MessageName::RemoteMediaSessionCoordinator_PauseSession>(globalObject, decoder);
    case MessageName::RemoteMediaSessionCoordinator_SetSessionTrack:
        return jsValueForDecodedMessageReply<MessageName::RemoteMediaSessionCoordinator_SetSessionTrack>(globalObject, decoder);
#endif
#if ENABLE(MODEL_PROCESS)
#endif
#if ENABLE(MODEL_PROCESS)
#endif
#if USE(LIBWEBRTC)
#endif
#if ENABLE(WEB_RTC)
#endif
#if USE(LIBWEBRTC)
#endif
#if USE(LIBWEBRTC)
#endif
#if ENABLE(WEB_RTC)
    case MessageName::NetworkProcessConnection_ConnectToRTCDataChannelRemoteSource:
        return jsValueForDecodedMessageReply<MessageName::NetworkProcessConnection_ConnectToRTCDataChannelRemoteSource>(globalObject, decoder);
#endif
    case MessageName::WebResourceLoader_WillSendRequest:
        return jsValueForDecodedMessageReply<MessageName::WebResourceLoader_WillSendRequest>(globalObject, decoder);
#if ENABLE(MEDIA_STREAM)
#endif
    case MessageName::WebSharedWorkerContextManagerConnection_PostConnectEvent:
        return jsValueForDecodedMessageReply<MessageName::WebSharedWorkerContextManagerConnection_PostConnectEvent>(globalObject, decoder);
    case MessageName::WebSharedWorkerObjectConnection_FetchScriptInClient:
        return jsValueForDecodedMessageReply<MessageName::WebSharedWorkerObjectConnection_FetchScriptInClient>(globalObject, decoder);
    case MessageName::WebSWClientConnection_SetServiceWorkerClientIsControlled:
        return jsValueForDecodedMessageReply<MessageName::WebSWClientConnection_SetServiceWorkerClientIsControlled>(globalObject, decoder);
    case MessageName::WebSWClientConnection_FocusServiceWorkerClient:
        return jsValueForDecodedMessageReply<MessageName::WebSWClientConnection_FocusServiceWorkerClient>(globalObject, decoder);
    case MessageName::WebSWContextManagerConnection_FirePushEvent:
        return jsValueForDecodedMessageReply<MessageName::WebSWContextManagerConnection_FirePushEvent>(globalObject, decoder);
    case MessageName::WebSWContextManagerConnection_FireNotificationEvent:
        return jsValueForDecodedMessageReply<MessageName::WebSWContextManagerConnection_FireNotificationEvent>(globalObject, decoder);
    case MessageName::WebSWContextManagerConnection_FireBackgroundFetchEvent:
        return jsValueForDecodedMessageReply<MessageName::WebSWContextManagerConnection_FireBackgroundFetchEvent>(globalObject, decoder);
    case MessageName::WebSWContextManagerConnection_FireBackgroundFetchClickEvent:
        return jsValueForDecodedMessageReply<MessageName::WebSWContextManagerConnection_FireBackgroundFetchClickEvent>(globalObject, decoder);
    case MessageName::WebBroadcastChannelRegistry_PostMessageToRemote:
        return jsValueForDecodedMessageReply<MessageName::WebBroadcastChannelRegistry_PostMessageToRemote>(globalObject, decoder);
#if USE(COORDINATED_GRAPHICS) || USE(TEXTURE_MAPPER)
    case MessageName::DrawingArea_UpdateGeometry:
        return jsValueForDecodedMessageReply<MessageName::DrawingArea_UpdateGeometry>(globalObject, decoder);
#endif
    case MessageName::DrawingArea_SetDeviceScaleFactor:
        return jsValueForDecodedMessageReply<MessageName::DrawingArea_SetDeviceScaleFactor>(globalObject, decoder);
#if PLATFORM(COCOA)
    case MessageName::DrawingArea_UpdateGeometry:
        return jsValueForDecodedMessageReply<MessageName::DrawingArea_UpdateGeometry>(globalObject, decoder);
#endif
#if PLATFORM(COCOA) || PLATFORM(GTK) || PLATFORM(WPE)
    case MessageName::DrawingArea_DispatchAfterEnsuringDrawing:
        return jsValueForDecodedMessageReply<MessageName::DrawingArea_DispatchAfterEnsuringDrawing>(globalObject, decoder);
#endif
#if PLATFORM(COCOA) || PLATFORM(GTK)
    case MessageName::DrawingArea_CommitTransientZoom:
        return jsValueForDecodedMessageReply<MessageName::DrawingArea_CommitTransientZoom>(globalObject, decoder);
#endif
#if ENABLE(IOS_TOUCH_EVENTS)
    case MessageName::EventDispatcher_TouchEvent:
        return jsValueForDecodedMessageReply<MessageName::EventDispatcher_TouchEvent>(globalObject, decoder);
#endif
#if ENABLE(MAC_GESTURE_EVENTS)
    case MessageName::EventDispatcher_GestureEvent:
        return jsValueForDecodedMessageReply<MessageName::EventDispatcher_GestureEvent>(globalObject, decoder);
#endif
    case MessageName::WebFrame_GetFrameInfo:
        return jsValueForDecodedMessageReply<MessageName::WebFrame_GetFrameInfo>(globalObject, decoder);
    case MessageName::WebFrame_FindFocusableElementDescendingIntoRemoteFrame:
        return jsValueForDecodedMessageReply<MessageName::WebFrame_FindFocusableElementDescendingIntoRemoteFrame>(globalObject, decoder);
    case MessageName::WebPage_SetInitialFocus:
        return jsValueForDecodedMessageReply<MessageName::WebPage_SetInitialFocus>(globalObject, decoder);
    case MessageName::WebPage_SetActivityState:
        return jsValueForDecodedMessageReply<MessageName::WebPage_SetActivityState>(globalObject, decoder);
    case MessageName::WebPage_TestProcessIncomingSyncMessagesWhenWaitingForSyncReply:
        return jsValueForDecodedMessageReply<MessageName::WebPage_TestProcessIncomingSyncMessagesWhenWaitingForSyncReply>(globalObject, decoder);
    case MessageName::WebPage_ExecuteEditCommandWithCallback:
        return jsValueForDecodedMessageReply<MessageName::WebPage_ExecuteEditCommandWithCallback>(globalObject, decoder);
#if PLATFORM(IOS_FAMILY)
    case MessageName::WebPage_PotentialTapAtPosition:
        return jsValueForDecodedMessageReply<MessageName::WebPage_PotentialTapAtPosition>(globalObject, decoder);
    case MessageName::WebPage_CommitPotentialTap:
        return jsValueForDecodedMessageReply<MessageName::WebPage_CommitPotentialTap>(globalObject, decoder);
    case MessageName::WebPage_SelectWithGesture:
        return jsValueForDecodedMessageReply<MessageName::WebPage_SelectWithGesture>(globalObject, decoder);
    case MessageName::WebPage_UpdateSelectionWithTouches:
        return jsValueForDecodedMessageReply<MessageName::WebPage_UpdateSelectionWithTouches>(globalObject, decoder);
    case MessageName::WebPage_SelectWithTwoTouches:
        return jsValueForDecodedMessageReply<MessageName::WebPage_SelectWithTwoTouches>(globalObject, decoder);
    case MessageName::WebPage_ExtendSelection:
        return jsValueForDecodedMessageReply<MessageName::WebPage_ExtendSelection>(globalObject, decoder);
    case MessageName::WebPage_ExtendSelectionForReplacement:
        return jsValueForDecodedMessageReply<MessageName::WebPage_ExtendSelectionForReplacement>(globalObject, decoder);
    case MessageName::WebPage_MoveSelectionByOffset:
        return jsValueForDecodedMessageReply<MessageName::WebPage_MoveSelectionByOffset>(globalObject, decoder);
    case MessageName::WebPage_SelectTextWithGranularityAtPoint:
        return jsValueForDecodedMessageReply<MessageName::WebPage_SelectTextWithGranularityAtPoint>(globalObject, decoder);
    case MessageName::WebPage_SelectPositionAtBoundaryWithDirection:
        return jsValueForDecodedMessageReply<MessageName::WebPage_SelectPositionAtBoundaryWithDirection>(globalObject, decoder);
    case MessageName::WebPage_MoveSelectionAtBoundaryWithDirection:
        return jsValueForDecodedMessageReply<MessageName::WebPage_MoveSelectionAtBoundaryWithDirection>(globalObject, decoder);
    case MessageName::WebPage_SelectPositionAtPoint:
        return jsValueForDecodedMessageReply<MessageName::WebPage_SelectPositionAtPoint>(globalObject, decoder);
    case MessageName::WebPage_BeginSelectionInDirection:
        return jsValueForDecodedMessageReply<MessageName::WebPage_BeginSelectionInDirection>(globalObject, decoder);
    case MessageName::WebPage_UpdateSelectionWithExtentPoint:
        return jsValueForDecodedMessageReply<MessageName::WebPage_UpdateSelectionWithExtentPoint>(globalObject, decoder);
    case MessageName::WebPage_UpdateSelectionWithExtentPointAndBoundary:
        return jsValueForDecodedMessageReply<MessageName::WebPage_UpdateSelectionWithExtentPointAndBoundary>(globalObject, decoder);
#endif
#if (PLATFORM(IOS_FAMILY) && ENABLE(REVEAL))
    case MessageName::WebPage_RequestRVItemInCurrentSelectedRange:
        return jsValueForDecodedMessageReply<MessageName::WebPage_RequestRVItemInCurrentSelectedRange>(globalObject, decoder);
    case MessageName::WebPage_PrepareSelectionForContextMenuWithLocationInView:
        return jsValueForDecodedMessageReply<MessageName::WebPage_PrepareSelectionForContextMenuWithLocationInView>(globalObject, decoder);
#endif
#if PLATFORM(IOS_FAMILY)
    case MessageName::WebPage_RequestAutocorrectionData:
        return jsValueForDecodedMessageReply<MessageName::WebPage_RequestAutocorrectionData>(globalObject, decoder);
    case MessageName::WebPage_ApplyAutocorrection:
        return jsValueForDecodedMessageReply<MessageName::WebPage_ApplyAutocorrection>(globalObject, decoder);
    case MessageName::WebPage_SyncApplyAutocorrection:
        return jsValueForDecodedMessageReply<MessageName::WebPage_SyncApplyAutocorrection>(globalObject, decoder);
    case MessageName::WebPage_RequestEvasionRectsAboveSelection:
        return jsValueForDecodedMessageReply<MessageName::WebPage_RequestEvasionRectsAboveSelection>(globalObject, decoder);
    case MessageName::WebPage_PerformActionOnElement:
        return jsValueForDecodedMessageReply<MessageName::WebPage_PerformActionOnElement>(globalObject, decoder);
    case MessageName::WebPage_FocusNextFocusedElement:
        return jsValueForDecodedMessageReply<MessageName::WebPage_FocusNextFocusedElement>(globalObject, decoder);
    case MessageName::WebPage_GetSelectionContext:
        return jsValueForDecodedMessageReply<MessageName::WebPage_GetSelectionContext>(globalObject, decoder);
    case MessageName::WebPage_GetRectsForGranularityWithSelectionOffset:
        return jsValueForDecodedMessageReply<MessageName::WebPage_GetRectsForGranularityWithSelectionOffset>(globalObject, decoder);
    case MessageName::WebPage_GetRectsAtSelectionOffsetWithText:
        return jsValueForDecodedMessageReply<MessageName::WebPage_GetRectsAtSelectionOffsetWithText>(globalObject, decoder);
    case MessageName::WebPage_RequestFocusedElementInformation:
        return jsValueForDecodedMessageReply<MessageName::WebPage_RequestFocusedElementInformation>(globalObject, decoder);
    case MessageName::WebPage_UpdateSelectionWithDelta:
        return jsValueForDecodedMessageReply<MessageName::WebPage_UpdateSelectionWithDelta>(globalObject, decoder);
    case MessageName::WebPage_RequestDocumentEditingContext:
        return jsValueForDecodedMessageReply<MessageName::WebPage_RequestDocumentEditingContext>(globalObject, decoder);
    case MessageName::WebPage_TextInputContextsInRect:
        return jsValueForDecodedMessageReply<MessageName::WebPage_TextInputContextsInRect>(globalObject, decoder);
    case MessageName::WebPage_FocusTextInputContextAndPlaceCaret:
        return jsValueForDecodedMessageReply<MessageName::WebPage_FocusTextInputContextAndPlaceCaret>(globalObject, decoder);
    case MessageName::WebPage_ClearServiceWorkerEntitlementOverride:
        return jsValueForDecodedMessageReply<MessageName::WebPage_ClearServiceWorkerEntitlementOverride>(globalObject, decoder);
#endif
    case MessageName::WebPage_RequestImageBitmap:
        return jsValueForDecodedMessageReply<MessageName::WebPage_RequestImageBitmap>(globalObject, decoder);
#if !ENABLE(IOS_TOUCH_EVENTS) && ENABLE(TOUCH_EVENTS)
    case MessageName::WebPage_TouchEvent:
        return jsValueForDecodedMessageReply<MessageName::WebPage_TouchEvent>(globalObject, decoder);
#endif
    case MessageName::WebPage_GetFrameTree:
        return jsValueForDecodedMessageReply<MessageName::WebPage_GetFrameTree>(globalObject, decoder);
    case MessageName::WebPage_GetPDFFirstPageSize:
        return jsValueForDecodedMessageReply<MessageName::WebPage_GetPDFFirstPageSize>(globalObject, decoder);
    case MessageName::WebPage_GetContentsAsString:
        return jsValueForDecodedMessageReply<MessageName::WebPage_GetContentsAsString>(globalObject, decoder);
#if PLATFORM(COCOA)
    case MessageName::WebPage_GetContentsAsAttributedString:
        return jsValueForDecodedMessageReply<MessageName::WebPage_GetContentsAsAttributedString>(globalObject, decoder);
#endif
#if ENABLE(MHTML)
    case MessageName::WebPage_GetContentsAsMHTMLData:
        return jsValueForDecodedMessageReply<MessageName::WebPage_GetContentsAsMHTMLData>(globalObject, decoder);
#endif
    case MessageName::WebPage_GetMainResourceDataOfFrame:
        return jsValueForDecodedMessageReply<MessageName::WebPage_GetMainResourceDataOfFrame>(globalObject, decoder);
    case MessageName::WebPage_GetResourceDataFromFrame:
        return jsValueForDecodedMessageReply<MessageName::WebPage_GetResourceDataFromFrame>(globalObject, decoder);
    case MessageName::WebPage_GetRenderTreeExternalRepresentation:
        return jsValueForDecodedMessageReply<MessageName::WebPage_GetRenderTreeExternalRepresentation>(globalObject, decoder);
    case MessageName::WebPage_GetSelectionOrContentsAsString:
        return jsValueForDecodedMessageReply<MessageName::WebPage_GetSelectionOrContentsAsString>(globalObject, decoder);
    case MessageName::WebPage_GetSelectionAsWebArchiveData:
        return jsValueForDecodedMessageReply<MessageName::WebPage_GetSelectionAsWebArchiveData>(globalObject, decoder);
    case MessageName::WebPage_GetSourceForFrame:
        return jsValueForDecodedMessageReply<MessageName::WebPage_GetSourceForFrame>(globalObject, decoder);
    case MessageName::WebPage_GetWebArchiveOfFrame:
        return jsValueForDecodedMessageReply<MessageName::WebPage_GetWebArchiveOfFrame>(globalObject, decoder);
    case MessageName::WebPage_GetWebArchiveOfFrameWithFileName:
        return jsValueForDecodedMessageReply<MessageName::WebPage_GetWebArchiveOfFrameWithFileName>(globalObject, decoder);
#if PLATFORM(COCOA)
    case MessageName::WebPage_GetWebArchives:
        return jsValueForDecodedMessageReply<MessageName::WebPage_GetWebArchives>(globalObject, decoder);
#endif
    case MessageName::WebPage_RunJavaScriptInFrameInScriptWorld:
        return jsValueForDecodedMessageReply<MessageName::WebPage_RunJavaScriptInFrameInScriptWorld>(globalObject, decoder);
    case MessageName::WebPage_GetAccessibilityTreeData:
        return jsValueForDecodedMessageReply<MessageName::WebPage_GetAccessibilityTreeData>(globalObject, decoder);
    case MessageName::WebPage_UpdateRenderingWithForcedRepaint:
        return jsValueForDecodedMessageReply<MessageName::WebPage_UpdateRenderingWithForcedRepaint>(globalObject, decoder);
#if ENABLE(DATA_DETECTION)
    case MessageName::WebPage_DetectDataInAllFrames:
        return jsValueForDecodedMessageReply<MessageName::WebPage_DetectDataInAllFrames>(globalObject, decoder);
    case MessageName::WebPage_RemoveDataDetectedLinks:
        return jsValueForDecodedMessageReply<MessageName::WebPage_RemoveDataDetectedLinks>(globalObject, decoder);
#endif
    case MessageName::WebPage_Suspend:
        return jsValueForDecodedMessageReply<MessageName::WebPage_Suspend>(globalObject, decoder);
    case MessageName::WebPage_Resume:
        return jsValueForDecodedMessageReply<MessageName::WebPage_Resume>(globalObject, decoder);
    case MessageName::WebPage_TryClose:
        return jsValueForDecodedMessageReply<MessageName::WebPage_TryClose>(globalObject, decoder);
    case MessageName::WebPage_ValidateCommand:
        return jsValueForDecodedMessageReply<MessageName::WebPage_ValidateCommand>(globalObject, decoder);
    case MessageName::WebPage_RequestFontAttributesAtSelectionStart:
        return jsValueForDecodedMessageReply<MessageName::WebPage_RequestFontAttributesAtSelectionStart>(globalObject, decoder);
    case MessageName::WebPage_FindString:
        return jsValueForDecodedMessageReply<MessageName::WebPage_FindString>(globalObject, decoder);
#if ENABLE(IMAGE_ANALYSIS)
    case MessageName::WebPage_FindStringIncludingImages:
        return jsValueForDecodedMessageReply<MessageName::WebPage_FindStringIncludingImages>(globalObject, decoder);
#endif
    case MessageName::WebPage_FindStringMatches:
        return jsValueForDecodedMessageReply<MessageName::WebPage_FindStringMatches>(globalObject, decoder);
    case MessageName::WebPage_CountStringMatches:
        return jsValueForDecodedMessageReply<MessageName::WebPage_CountStringMatches>(globalObject, decoder);
    case MessageName::WebPage_ReplaceMatches:
        return jsValueForDecodedMessageReply<MessageName::WebPage_ReplaceMatches>(globalObject, decoder);
    case MessageName::WebPage_FindRectsForStringMatches:
        return jsValueForDecodedMessageReply<MessageName::WebPage_FindRectsForStringMatches>(globalObject, decoder);
    case MessageName::WebPage_FindTextRangesForStringMatches:
        return jsValueForDecodedMessageReply<MessageName::WebPage_FindTextRangesForStringMatches>(globalObject, decoder);
    case MessageName::WebPage_RequestRectForFoundTextRange:
        return jsValueForDecodedMessageReply<MessageName::WebPage_RequestRectForFoundTextRange>(globalObject, decoder);
    case MessageName::WebPage_AddLayerForFindOverlay:
        return jsValueForDecodedMessageReply<MessageName::WebPage_AddLayerForFindOverlay>(globalObject, decoder);
    case MessageName::WebPage_RemoveLayerForFindOverlay:
        return jsValueForDecodedMessageReply<MessageName::WebPage_RemoveLayerForFindOverlay>(globalObject, decoder);
#if PLATFORM(GTK) && ENABLE(DRAG_SUPPORT)
    case MessageName::WebPage_PerformDragControllerAction:
        return jsValueForDecodedMessageReply<MessageName::WebPage_PerformDragControllerAction>(globalObject, decoder);
#endif
#if !PLATFORM(GTK) && ENABLE(DRAG_SUPPORT)
    case MessageName::WebPage_PerformDragControllerAction:
        return jsValueForDecodedMessageReply<MessageName::WebPage_PerformDragControllerAction>(globalObject, decoder);
    case MessageName::WebPage_PerformDragOperation:
        return jsValueForDecodedMessageReply<MessageName::WebPage_PerformDragOperation>(globalObject, decoder);
#endif
#if ENABLE(DRAG_SUPPORT)
    case MessageName::WebPage_DragEnded:
        return jsValueForDecodedMessageReply<MessageName::WebPage_DragEnded>(globalObject, decoder);
#endif
#if PLATFORM(IOS_FAMILY) && ENABLE(DRAG_SUPPORT)
    case MessageName::WebPage_RequestDragStart:
        return jsValueForDecodedMessageReply<MessageName::WebPage_RequestDragStart>(globalObject, decoder);
    case MessageName::WebPage_RequestAdditionalItemsForDragSession:
        return jsValueForDecodedMessageReply<MessageName::WebPage_RequestAdditionalItemsForDragSession>(globalObject, decoder);
    case MessageName::WebPage_InsertDroppedImagePlaceholders:
        return jsValueForDecodedMessageReply<MessageName::WebPage_InsertDroppedImagePlaceholders>(globalObject, decoder);
#endif
#if PLATFORM(COCOA)
    case MessageName::WebPage_InsertTextPlaceholder:
        return jsValueForDecodedMessageReply<MessageName::WebPage_InsertTextPlaceholder>(globalObject, decoder);
    case MessageName::WebPage_RemoveTextPlaceholder:
        return jsValueForDecodedMessageReply<MessageName::WebPage_RemoveTextPlaceholder>(globalObject, decoder);
#endif
#if ENABLE(MEDIA_STREAM)
    case MessageName::WebPage_UserMediaAccessWasGranted:
        return jsValueForDecodedMessageReply<MessageName::WebPage_UserMediaAccessWasGranted>(globalObject, decoder);
#endif
    case MessageName::WebPage_RequestMediaPlaybackState:
        return jsValueForDecodedMessageReply<MessageName::WebPage_RequestMediaPlaybackState>(globalObject, decoder);
    case MessageName::WebPage_PauseAllMediaPlayback:
        return jsValueForDecodedMessageReply<MessageName::WebPage_PauseAllMediaPlayback>(globalObject, decoder);
    case MessageName::WebPage_SuspendAllMediaPlayback:
        return jsValueForDecodedMessageReply<MessageName::WebPage_SuspendAllMediaPlayback>(globalObject, decoder);
    case MessageName::WebPage_ResumeAllMediaPlayback:
        return jsValueForDecodedMessageReply<MessageName::WebPage_ResumeAllMediaPlayback>(globalObject, decoder);
    case MessageName::WebPage_EndPrinting:
        return jsValueForDecodedMessageReply<MessageName::WebPage_EndPrinting>(globalObject, decoder);
    case MessageName::WebPage_EndPrintingDuringDOMPrintOperation:
        return jsValueForDecodedMessageReply<MessageName::WebPage_EndPrintingDuringDOMPrintOperation>(globalObject, decoder);
    case MessageName::WebPage_ComputePagesForPrinting:
        return jsValueForDecodedMessageReply<MessageName::WebPage_ComputePagesForPrinting>(globalObject, decoder);
    case MessageName::WebPage_ComputePagesForPrintingDuringDOMPrintOperation:
        return jsValueForDecodedMessageReply<MessageName::WebPage_ComputePagesForPrintingDuringDOMPrintOperation>(globalObject, decoder);
#if PLATFORM(COCOA)
    case MessageName::WebPage_DrawRectToImage:
        return jsValueForDecodedMessageReply<MessageName::WebPage_DrawRectToImage>(globalObject, decoder);
    case MessageName::WebPage_DrawRectToImageDuringDOMPrintOperation:
        return jsValueForDecodedMessageReply<MessageName::WebPage_DrawRectToImageDuringDOMPrintOperation>(globalObject, decoder);
    case MessageName::WebPage_DrawPagesToPDF:
        return jsValueForDecodedMessageReply<MessageName::WebPage_DrawPagesToPDF>(globalObject, decoder);
    case MessageName::WebPage_DrawPagesToPDFDuringDOMPrintOperation:
        return jsValueForDecodedMessageReply<MessageName::WebPage_DrawPagesToPDFDuringDOMPrintOperation>(globalObject, decoder);
#endif
#if (PLATFORM(COCOA) && PLATFORM(IOS_FAMILY))
    case MessageName::WebPage_ComputePagesForPrintingiOS:
        return jsValueForDecodedMessageReply<MessageName::WebPage_ComputePagesForPrintingiOS>(globalObject, decoder);
    case MessageName::WebPage_DrawToPDFiOS:
        return jsValueForDecodedMessageReply<MessageName::WebPage_DrawToPDFiOS>(globalObject, decoder);
    case MessageName::WebPage_DrawToImage:
        return jsValueForDecodedMessageReply<MessageName::WebPage_DrawToImage>(globalObject, decoder);
#endif
#if PLATFORM(COCOA)
    case MessageName::WebPage_DrawToPDF:
        return jsValueForDecodedMessageReply<MessageName::WebPage_DrawToPDF>(globalObject, decoder);
#endif
#if PLATFORM(GTK)
    case MessageName::WebPage_DrawPagesForPrinting:
        return jsValueForDecodedMessageReply<MessageName::WebPage_DrawPagesForPrinting>(globalObject, decoder);
    case MessageName::WebPage_DrawPagesForPrintingDuringDOMPrintOperation:
        return jsValueForDecodedMessageReply<MessageName::WebPage_DrawPagesForPrintingDuringDOMPrintOperation>(globalObject, decoder);
#endif
    case MessageName::WebPage_SetMuted:
        return jsValueForDecodedMessageReply<MessageName::WebPage_SetMuted>(globalObject, decoder);
    case MessageName::WebPage_StopMediaCapture:
        return jsValueForDecodedMessageReply<MessageName::WebPage_StopMediaCapture>(globalObject, decoder);
    case MessageName::WebPage_BindRemoteAccessibilityFrames:
        return jsValueForDecodedMessageReply<MessageName::WebPage_BindRemoteAccessibilityFrames>(globalObject, decoder);
    case MessageName::WebPage_ResolveAccessibilityHitTestForTesting:
        return jsValueForDecodedMessageReply<MessageName::WebPage_ResolveAccessibilityHitTestForTesting>(globalObject, decoder);
#if PLATFORM(MAC)
    case MessageName::WebPage_GetAccessibilityWebProcessDebugInfo:
        return jsValueForDecodedMessageReply<MessageName::WebPage_GetAccessibilityWebProcessDebugInfo>(globalObject, decoder);
#endif
#if PLATFORM(COCOA)
    case MessageName::WebPage_GetStringSelectionForPasteboard:
        return jsValueForDecodedMessageReply<MessageName::WebPage_GetStringSelectionForPasteboard>(globalObject, decoder);
    case MessageName::WebPage_GetDataSelectionForPasteboard:
        return jsValueForDecodedMessageReply<MessageName::WebPage_GetDataSelectionForPasteboard>(globalObject, decoder);
    case MessageName::WebPage_ReadSelectionFromPasteboard:
        return jsValueForDecodedMessageReply<MessageName::WebPage_ReadSelectionFromPasteboard>(globalObject, decoder);
    case MessageName::WebPage_ShouldDelayWindowOrderingEvent:
        return jsValueForDecodedMessageReply<MessageName::WebPage_ShouldDelayWindowOrderingEvent>(globalObject, decoder);
    case MessageName::WebPage_AddDictationAlternative:
        return jsValueForDecodedMessageReply<MessageName::WebPage_AddDictationAlternative>(globalObject, decoder);
    case MessageName::WebPage_DictationAlternativesAtSelection:
        return jsValueForDecodedMessageReply<MessageName::WebPage_DictationAlternativesAtSelection>(globalObject, decoder);
    case MessageName::WebPage_HasMarkedText:
        return jsValueForDecodedMessageReply<MessageName::WebPage_HasMarkedText>(globalObject, decoder);
    case MessageName::WebPage_GetMarkedRangeAsync:
        return jsValueForDecodedMessageReply<MessageName::WebPage_GetMarkedRangeAsync>(globalObject, decoder);
    case MessageName::WebPage_GetSelectedRangeAsync:
        return jsValueForDecodedMessageReply<MessageName::WebPage_GetSelectedRangeAsync>(globalObject, decoder);
    case MessageName::WebPage_CharacterIndexForPointAsync:
        return jsValueForDecodedMessageReply<MessageName::WebPage_CharacterIndexForPointAsync>(globalObject, decoder);
    case MessageName::WebPage_FirstRectForCharacterRangeAsync:
        return jsValueForDecodedMessageReply<MessageName::WebPage_FirstRectForCharacterRangeAsync>(globalObject, decoder);
#endif
#if PLATFORM(MAC)
    case MessageName::WebPage_AttributedSubstringForCharacterRangeAsync:
        return jsValueForDecodedMessageReply<MessageName::WebPage_AttributedSubstringForCharacterRangeAsync>(globalObject, decoder);
#endif
#if ENABLE(IMAGE_ANALYSIS_ENHANCEMENTS)
    case MessageName::WebPage_ShouldAllowRemoveBackground:
        return jsValueForDecodedMessageReply<MessageName::WebPage_ShouldAllowRemoveBackground>(globalObject, decoder);
#endif
    case MessageName::WebPage_GetBytecodeProfile:
        return jsValueForDecodedMessageReply<MessageName::WebPage_GetBytecodeProfile>(globalObject, decoder);
    case MessageName::WebPage_GetSamplingProfilerOutput:
        return jsValueForDecodedMessageReply<MessageName::WebPage_GetSamplingProfilerOutput>(globalObject, decoder);
    case MessageName::WebPage_TakeSnapshot:
        return jsValueForDecodedMessageReply<MessageName::WebPage_TakeSnapshot>(globalObject, decoder);
    case MessageName::WebPage_PerformHitTestForMouseEvent:
        return jsValueForDecodedMessageReply<MessageName::WebPage_PerformHitTestForMouseEvent>(globalObject, decoder);
#if PLATFORM(COCOA)
    case MessageName::WebPage_RequestActiveNowPlayingSessionInfo:
        return jsValueForDecodedMessageReply<MessageName::WebPage_RequestActiveNowPlayingSessionInfo>(globalObject, decoder);
#endif
    case MessageName::WebPage_DidGetLoadDecisionForIcon:
        return jsValueForDecodedMessageReply<MessageName::WebPage_DidGetLoadDecisionForIcon>(globalObject, decoder);
    case MessageName::WebPage_URLSchemeTaskWillPerformRedirection:
        return jsValueForDecodedMessageReply<MessageName::WebPage_URLSchemeTaskWillPerformRedirection>(globalObject, decoder);
    case MessageName::WebPage_SetIsSuspended:
        return jsValueForDecodedMessageReply<MessageName::WebPage_SetIsSuspended>(globalObject, decoder);
#if ENABLE(ATTACHMENT_ELEMENT)
    case MessageName::WebPage_InsertAttachment:
        return jsValueForDecodedMessageReply<MessageName::WebPage_InsertAttachment>(globalObject, decoder);
    case MessageName::WebPage_UpdateAttachmentAttributes:
        return jsValueForDecodedMessageReply<MessageName::WebPage_UpdateAttachmentAttributes>(globalObject, decoder);
#endif
#if ENABLE(APPLICATION_MANIFEST)
    case MessageName::WebPage_GetApplicationManifest:
        return jsValueForDecodedMessageReply<MessageName::WebPage_GetApplicationManifest>(globalObject, decoder);
#endif
    case MessageName::WebPage_GetTextFragmentMatch:
        return jsValueForDecodedMessageReply<MessageName::WebPage_GetTextFragmentMatch>(globalObject, decoder);
#if ENABLE(PDF_PLUGIN) && PLATFORM(MAC)
    case MessageName::WebPage_SavePDF:
        return jsValueForDecodedMessageReply<MessageName::WebPage_SavePDF>(globalObject, decoder);
    case MessageName::WebPage_OpenPDFWithPreview:
        return jsValueForDecodedMessageReply<MessageName::WebPage_OpenPDFWithPreview>(globalObject, decoder);
#endif
    case MessageName::WebPage_GetLoadedSubresourceDomains:
        return jsValueForDecodedMessageReply<MessageName::WebPage_GetLoadedSubresourceDomains>(globalObject, decoder);
#if PLATFORM(GTK) || PLATFORM(WPE)
    case MessageName::WebPage_SendMessageToWebProcessExtensionWithReply:
        return jsValueForDecodedMessageReply<MessageName::WebPage_SendMessageToWebProcessExtensionWithReply>(globalObject, decoder);
#endif
    case MessageName::WebPage_StartTextManipulations:
        return jsValueForDecodedMessageReply<MessageName::WebPage_StartTextManipulations>(globalObject, decoder);
    case MessageName::WebPage_CompleteTextManipulation:
        return jsValueForDecodedMessageReply<MessageName::WebPage_CompleteTextManipulation>(globalObject, decoder);
    case MessageName::WebPage_GetProcessDisplayName:
        return jsValueForDecodedMessageReply<MessageName::WebPage_GetProcessDisplayName>(globalObject, decoder);
#if ENABLE(APP_HIGHLIGHTS)
    case MessageName::WebPage_CreateAppHighlightInSelectedRange:
        return jsValueForDecodedMessageReply<MessageName::WebPage_CreateAppHighlightInSelectedRange>(globalObject, decoder);
#endif
    case MessageName::WebPage_CreateTextFragmentDirectiveFromSelection:
        return jsValueForDecodedMessageReply<MessageName::WebPage_CreateTextFragmentDirectiveFromSelection>(globalObject, decoder);
    case MessageName::WebPage_GetTextFragmentRanges:
        return jsValueForDecodedMessageReply<MessageName::WebPage_GetTextFragmentRanges>(globalObject, decoder);
    case MessageName::WebPage_HandleWheelEvent:
        return jsValueForDecodedMessageReply<MessageName::WebPage_HandleWheelEvent>(globalObject, decoder);
#if PLATFORM(IOS_FAMILY)
    case MessageName::WebPage_DispatchWheelEventWithoutScrolling:
        return jsValueForDecodedMessageReply<MessageName::WebPage_DispatchWheelEventWithoutScrolling>(globalObject, decoder);
#endif
    case MessageName::WebPage_LastNavigationWasAppInitiated:
        return jsValueForDecodedMessageReply<MessageName::WebPage_LastNavigationWasAppInitiated>(globalObject, decoder);
#if ENABLE(MEDIA_SESSION_COORDINATOR)
    case MessageName::WebPage_CreateMediaSessionCoordinator:
        return jsValueForDecodedMessageReply<MessageName::WebPage_CreateMediaSessionCoordinator>(globalObject, decoder);
#endif
#if ENABLE(IMAGE_ANALYSIS)
    case MessageName::WebPage_UpdateWithTextRecognitionResult:
        return jsValueForDecodedMessageReply<MessageName::WebPage_UpdateWithTextRecognitionResult>(globalObject, decoder);
#endif
    case MessageName::WebPage_NavigateServiceWorkerClient:
        return jsValueForDecodedMessageReply<MessageName::WebPage_NavigateServiceWorkerClient>(globalObject, decoder);
#if ENABLE(ACCESSIBILITY_ANIMATION_CONTROL)
    case MessageName::WebPage_PauseAllAnimations:
        return jsValueForDecodedMessageReply<MessageName::WebPage_PauseAllAnimations>(globalObject, decoder);
    case MessageName::WebPage_PlayAllAnimations:
        return jsValueForDecodedMessageReply<MessageName::WebPage_PlayAllAnimations>(globalObject, decoder);
#endif
    case MessageName::WebPage_RenderTreeAsTextForTesting:
        return jsValueForDecodedMessageReply<MessageName::WebPage_RenderTreeAsTextForTesting>(globalObject, decoder);
    case MessageName::WebPage_LayerTreeAsTextForTesting:
        return jsValueForDecodedMessageReply<MessageName::WebPage_LayerTreeAsTextForTesting>(globalObject, decoder);
    case MessageName::WebPage_FrameTextForTesting:
        return jsValueForDecodedMessageReply<MessageName::WebPage_FrameTextForTesting>(globalObject, decoder);
    case MessageName::WebPage_RequestAllTextAndRects:
        return jsValueForDecodedMessageReply<MessageName::WebPage_RequestAllTextAndRects>(globalObject, decoder);
    case MessageName::WebPage_RequestTargetedElement:
        return jsValueForDecodedMessageReply<MessageName::WebPage_RequestTargetedElement>(globalObject, decoder);
    case MessageName::WebPage_RequestAllTargetableElements:
        return jsValueForDecodedMessageReply<MessageName::WebPage_RequestAllTargetableElements>(globalObject, decoder);
    case MessageName::WebPage_RequestTextExtraction:
        return jsValueForDecodedMessageReply<MessageName::WebPage_RequestTextExtraction>(globalObject, decoder);
#if PLATFORM(IOS_FAMILY)
    case MessageName::WebPage_ShouldDismissKeyboardAfterTapAtPoint:
        return jsValueForDecodedMessageReply<MessageName::WebPage_ShouldDismissKeyboardAfterTapAtPoint>(globalObject, decoder);
#endif
#if ENABLE(WRITING_TOOLS)
    case MessageName::WebPage_WillBeginWritingToolsSession:
        return jsValueForDecodedMessageReply<MessageName::WebPage_WillBeginWritingToolsSession>(globalObject, decoder);
    case MessageName::WebPage_ProofreadingSessionDidReceiveSuggestions:
        return jsValueForDecodedMessageReply<MessageName::WebPage_ProofreadingSessionDidReceiveSuggestions>(globalObject, decoder);
    case MessageName::WebPage_WillEndWritingToolsSession:
        return jsValueForDecodedMessageReply<MessageName::WebPage_WillEndWritingToolsSession>(globalObject, decoder);
    case MessageName::WebPage_CompositionSessionDidReceiveTextWithReplacementRange:
        return jsValueForDecodedMessageReply<MessageName::WebPage_CompositionSessionDidReceiveTextWithReplacementRange>(globalObject, decoder);
    case MessageName::WebPage_ProofreadingSessionSuggestionTextRectsInRootViewCoordinates:
        return jsValueForDecodedMessageReply<MessageName::WebPage_ProofreadingSessionSuggestionTextRectsInRootViewCoordinates>(globalObject, decoder);
    case MessageName::WebPage_UpdateTextVisibilityForActiveWritingToolsSession:
        return jsValueForDecodedMessageReply<MessageName::WebPage_UpdateTextVisibilityForActiveWritingToolsSession>(globalObject, decoder);
    case MessageName::WebPage_TextPreviewDataForActiveWritingToolsSession:
        return jsValueForDecodedMessageReply<MessageName::WebPage_TextPreviewDataForActiveWritingToolsSession>(globalObject, decoder);
    case MessageName::WebPage_SetSelectionForActiveWritingToolsSession:
        return jsValueForDecodedMessageReply<MessageName::WebPage_SetSelectionForActiveWritingToolsSession>(globalObject, decoder);
    case MessageName::WebPage_DecorateTextReplacementsForActiveWritingToolsSession:
        return jsValueForDecodedMessageReply<MessageName::WebPage_DecorateTextReplacementsForActiveWritingToolsSession>(globalObject, decoder);
    case MessageName::WebPage_CreateTextIndicatorForTextAnimationID:
        return jsValueForDecodedMessageReply<MessageName::WebPage_CreateTextIndicatorForTextAnimationID>(globalObject, decoder);
    case MessageName::WebPage_UpdateUnderlyingTextVisibilityForTextAnimationID:
        return jsValueForDecodedMessageReply<MessageName::WebPage_UpdateUnderlyingTextVisibilityForTextAnimationID>(globalObject, decoder);
#endif
#if PLATFORM(COCOA)
    case MessageName::WebPage_CreateTextIndicatorForElementWithID:
        return jsValueForDecodedMessageReply<MessageName::WebPage_CreateTextIndicatorForElementWithID>(globalObject, decoder);
#endif
    case MessageName::WebPage_TakeSnapshotForTargetedElement:
        return jsValueForDecodedMessageReply<MessageName::WebPage_TakeSnapshotForTargetedElement>(globalObject, decoder);
    case MessageName::WebPage_ResetVisibilityAdjustmentsForTargetedElements:
        return jsValueForDecodedMessageReply<MessageName::WebPage_ResetVisibilityAdjustmentsForTargetedElements>(globalObject, decoder);
    case MessageName::WebPage_AdjustVisibilityForTargetedElements:
        return jsValueForDecodedMessageReply<MessageName::WebPage_AdjustVisibilityForTargetedElements>(globalObject, decoder);
    case MessageName::WebPage_NumberOfVisibilityAdjustmentRects:
        return jsValueForDecodedMessageReply<MessageName::WebPage_NumberOfVisibilityAdjustmentRects>(globalObject, decoder);
    case MessageName::WebPage_ContentsToRootViewRect:
        return jsValueForDecodedMessageReply<MessageName::WebPage_ContentsToRootViewRect>(globalObject, decoder);
    case MessageName::WebPage_ContentsToRootViewPoint:
        return jsValueForDecodedMessageReply<MessageName::WebPage_ContentsToRootViewPoint>(globalObject, decoder);
    case MessageName::WebPage_RemoteDictionaryPopupInfoToRootView:
        return jsValueForDecodedMessageReply<MessageName::WebPage_RemoteDictionaryPopupInfoToRootView>(globalObject, decoder);
    case MessageName::WebPage_LoadAndDecodeImage:
        return jsValueForDecodedMessageReply<MessageName::WebPage_LoadAndDecodeImage>(globalObject, decoder);
#if PLATFORM(COCOA)
    case MessageName::WebPage_GetInformationFromImageData:
        return jsValueForDecodedMessageReply<MessageName::WebPage_GetInformationFromImageData>(globalObject, decoder);
    case MessageName::WebPage_CreateBitmapsFromImageData:
        return jsValueForDecodedMessageReply<MessageName::WebPage_CreateBitmapsFromImageData>(globalObject, decoder);
    case MessageName::WebPage_DecodeImageData:
        return jsValueForDecodedMessageReply<MessageName::WebPage_DecodeImageData>(globalObject, decoder);
#endif
#if ENABLE(VIDEO_PRESENTATION_MODE)
    case MessageName::WebPage_StartPlayingPredominantVideo:
        return jsValueForDecodedMessageReply<MessageName::WebPage_StartPlayingPredominantVideo>(globalObject, decoder);
#endif
    case MessageName::WebPage_SimulateClickOverFirstMatchingTextInViewportWithUserInteraction:
        return jsValueForDecodedMessageReply<MessageName::WebPage_SimulateClickOverFirstMatchingTextInViewportWithUserInteraction>(globalObject, decoder);
    case MessageName::WebPageTesting_IsLayerTreeFrozen:
        return jsValueForDecodedMessageReply<MessageName::WebPageTesting_IsLayerTreeFrozen>(globalObject, decoder);
    case MessageName::WebPageTesting_IsEditingCommandEnabled:
        return jsValueForDecodedMessageReply<MessageName::WebPageTesting_IsEditingCommandEnabled>(globalObject, decoder);
    case MessageName::WebPageTesting_SetObscuredContentInsets:
        return jsValueForDecodedMessageReply<MessageName::WebPageTesting_SetObscuredContentInsets>(globalObject, decoder);
    case MessageName::WebPageTesting_ClearCachedBackForwardListCounts:
        return jsValueForDecodedMessageReply<MessageName::WebPageTesting_ClearCachedBackForwardListCounts>(globalObject, decoder);
    case MessageName::WebPageTesting_SetTracksRepaints:
        return jsValueForDecodedMessageReply<MessageName::WebPageTesting_SetTracksRepaints>(globalObject, decoder);
    case MessageName::WebPageTesting_DisplayAndTrackRepaints:
        return jsValueForDecodedMessageReply<MessageName::WebPageTesting_DisplayAndTrackRepaints>(globalObject, decoder);
#if ENABLE(WEBXR)
#endif
#if ENABLE(WEB_PUSH_NOTIFICATIONS)
    case MessageName::PushClientConnection_SetPushAndNotificationsEnabledForOrigin:
        return jsValueForDecodedMessageReply<MessageName::PushClientConnection_SetPushAndNotificationsEnabledForOrigin>(globalObject, decoder);
    case MessageName::PushClientConnection_GetPendingPushMessage:
        return jsValueForDecodedMessageReply<MessageName::PushClientConnection_GetPendingPushMessage>(globalObject, decoder);
    case MessageName::PushClientConnection_GetPendingPushMessages:
        return jsValueForDecodedMessageReply<MessageName::PushClientConnection_GetPendingPushMessages>(globalObject, decoder);
    case MessageName::PushClientConnection_InjectPushMessageForTesting:
        return jsValueForDecodedMessageReply<MessageName::PushClientConnection_InjectPushMessageForTesting>(globalObject, decoder);
    case MessageName::PushClientConnection_InjectEncryptedPushMessageForTesting:
        return jsValueForDecodedMessageReply<MessageName::PushClientConnection_InjectEncryptedPushMessageForTesting>(globalObject, decoder);
    case MessageName::PushClientConnection_SubscribeToPushService:
        return jsValueForDecodedMessageReply<MessageName::PushClientConnection_SubscribeToPushService>(globalObject, decoder);
    case MessageName::PushClientConnection_UnsubscribeFromPushService:
        return jsValueForDecodedMessageReply<MessageName::PushClientConnection_UnsubscribeFromPushService>(globalObject, decoder);
    case MessageName::PushClientConnection_GetPushSubscription:
        return jsValueForDecodedMessageReply<MessageName::PushClientConnection_GetPushSubscription>(globalObject, decoder);
    case MessageName::PushClientConnection_GetPushPermissionState:
        return jsValueForDecodedMessageReply<MessageName::PushClientConnection_GetPushPermissionState>(globalObject, decoder);
    case MessageName::PushClientConnection_IncrementSilentPushCount:
        return jsValueForDecodedMessageReply<MessageName::PushClientConnection_IncrementSilentPushCount>(globalObject, decoder);
    case MessageName::PushClientConnection_RemoveAllPushSubscriptions:
        return jsValueForDecodedMessageReply<MessageName::PushClientConnection_RemoveAllPushSubscriptions>(globalObject, decoder);
    case MessageName::PushClientConnection_RemovePushSubscriptionsForOrigin:
        return jsValueForDecodedMessageReply<MessageName::PushClientConnection_RemovePushSubscriptionsForOrigin>(globalObject, decoder);
    case MessageName::PushClientConnection_SetPublicTokenForTesting:
        return jsValueForDecodedMessageReply<MessageName::PushClientConnection_SetPublicTokenForTesting>(globalObject, decoder);
    case MessageName::PushClientConnection_GetPushTopicsForTesting:
        return jsValueForDecodedMessageReply<MessageName::PushClientConnection_GetPushTopicsForTesting>(globalObject, decoder);
    case MessageName::PushClientConnection_ShowNotification:
        return jsValueForDecodedMessageReply<MessageName::PushClientConnection_ShowNotification>(globalObject, decoder);
    case MessageName::PushClientConnection_GetNotifications:
        return jsValueForDecodedMessageReply<MessageName::PushClientConnection_GetNotifications>(globalObject, decoder);
    case MessageName::PushClientConnection_RequestPushPermission:
        return jsValueForDecodedMessageReply<MessageName::PushClientConnection_RequestPushPermission>(globalObject, decoder);
    case MessageName::PushClientConnection_GetAppBadgeForTesting:
        return jsValueForDecodedMessageReply<MessageName::PushClientConnection_GetAppBadgeForTesting>(globalObject, decoder);
    case MessageName::PushClientConnection_SetServiceWorkerIsBeingInspected:
        return jsValueForDecodedMessageReply<MessageName::PushClientConnection_SetServiceWorkerIsBeingInspected>(globalObject, decoder);
    case MessageName::PushClientConnection_SetProtocolVersionForTesting:
        return jsValueForDecodedMessageReply<MessageName::PushClientConnection_SetProtocolVersionForTesting>(globalObject, decoder);
#endif
#if ENABLE(MEDIA_STREAM)
    case MessageName::UserMediaCaptureManager_ValidateUserMediaRequestConstraints:
        return jsValueForDecodedMessageReply<MessageName::UserMediaCaptureManager_ValidateUserMediaRequestConstraints>(globalObject, decoder);
    case MessageName::UserMediaCaptureManager_GetMediaStreamDevices:
        return jsValueForDecodedMessageReply<MessageName::UserMediaCaptureManager_GetMediaStreamDevices>(globalObject, decoder);
#endif
    default:
        break;
    }
    return std::nullopt;
}

Vector<ASCIILiteral> serializedIdentifiers()
{
    return {
        "IPC::AsyncReplyID"_s,
        "WebCore::AttributedStringTextListID"_s,
        "WebCore::AttributedStringTextTableBlockID"_s,
        "WebCore::AttributedStringTextTableID"_s,
        "WebCore::BackForwardFrameItemIdentifierID"_s,
        "WebCore::BackForwardItemIdentifierID"_s,
        "WebCore::BackgroundFetchRecordIdentifier"_s,
        "WebCore::DOMCacheIdentifierID"_s,
        "WebCore::DictationContext"_s,
        "WebCore::NodeIdentifier"_s,
        "WebCore::FetchIdentifier"_s,
        "WebCore::FileSystemHandleIdentifier"_s,
        "WebCore::FileSystemSyncAccessHandleIdentifier"_s,
        "WebCore::FileSystemWritableFileStreamIdentifier"_s,
        "WebCore::FrameIdentifier"_s,
        "WebCore::IDBIndexIdentifier"_s,
        "WebCore::IDBObjectStoreIdentifier"_s,
        "WebCore::ImageDecoderIdentifier"_s,
        "WebCore::InbandGenericCueIdentifier"_s,
        "WebCore::LayerHostingContextIdentifier"_s,
        "WebCore::LibWebRTCSocketIdentifier"_s,
        "WebCore::MediaKeySystemRequestIdentifier"_s,
        "WebCore::MediaPlayerClientIdentifier"_s,
        "WebCore::MediaPlayerIdentifier"_s,
        "WebCore::MediaSessionIdentifier"_s,
        "WebCore::ModelPlayerIdentifier"_s,
        "WebCore::MediaUniqueIdentifier"_s,
        "WebCore::NavigationIdentifier"_s,
        "WebCore::OpaqueOriginIdentifier"_s,
        "WebCore::PageIdentifier"_s,
        "WebCore::PlatformLayerIdentifierID"_s,
        "WebCore::PlaybackTargetClientContextID"_s,
        "WebCore::PortIdentifier"_s,
        "WebCore::ProcessIdentifier"_s,
        "WebCore::PushSubscriptionIdentifier"_s,
        "WebCore::RTCDataChannelLocalIdentifier"_s,
        "WebCore::RealtimeMediaSourceIdentifier"_s,
        "WebCore::RenderingResourceIdentifier"_s,
        "WebCore::ResourceLoaderIdentifier"_s,
        "WebCore::SWServerConnectionIdentifier"_s,
        "WebCore::ScrollingNodeIdentifier"_s,
        "WebCore::ServiceWorkerIdentifier"_s,
        "WebCore::ServiceWorkerJobIdentifier"_s,
        "WebCore::ServiceWorkerRegistrationIdentifier"_s,
        "WebCore::SharedWorkerIdentifier"_s,
        "WebCore::SharedWorkerObjectIdentifierID"_s,
        "WebCore::SleepDisablerIdentifier"_s,
        "WebCore::SnapshotIdentifier"_s,
        "WebCore::SpeechRecognitionConnectionClientIdentifier"_s,
        "WebCore::TextCheckingRequestIdentifier"_s,
        "WebCore::TextManipulationItemIdentifier"_s,
        "WebCore::TextManipulationTokenIdentifier"_s,
        "WebCore::IDBDatabaseConnectionIdentifier"_s,
        "WebCore::IDBResourceObjectIdentifier"_s,
        "WebCore::UserGestureTokenIdentifierID"_s,
        "WebCore::UserMediaRequestIdentifier"_s,
        "WebCore::WebLockIdentifierID"_s,
        "WebCore::WebSocketIdentifier"_s,
        "WebCore::WebTransportStreamIdentifier"_s,
        "WebCore::WindowIdentifier"_s,
        "WebKit::AudioMediaStreamTrackRendererInternalUnitIdentifier"_s,
        "WebKit::AuthenticationChallengeIdentifier"_s,
        "WebKit::ContentWorldIdentifier"_s,
        "WebKit::DataTaskIdentifier"_s,
        "WebKit::DisplayLinkObserverID"_s,
        "WebKit::DownloadID"_s,
        "WebKit::DrawingAreaIdentifier"_s,
        "WebKit::GeolocationIdentifier"_s,
        "WebKit::GPUProcessConnectionIdentifier"_s,
        "WebKit::GraphicsContextGLIdentifier"_s,
        "WebKit::IPCConnectionTesterIdentifier"_s,
        "WebKit::IPCStreamTesterIdentifier"_s,
        "WebKit::JSObjectID"_s,
        "WebKit::LegacyCustomProtocolID"_s,
        "WebKit::LibWebRTCResolverIdentifier"_s,
        "WebKit::LogStreamIdentifier"_s,
        "WebKit::MarkSurfacesAsVolatileRequestIdentifier"_s,
        "WebKit::MessageBatchIdentifier"_s,
        "WebKit::NetworkResourceLoadIdentifier"_s,
        "WebKit::PDFPluginIdentifier"_s,
        "WebKit::PageGroupIdentifier"_s,
        "WebKit::QuotaIncreaseRequestIdentifier"_s,
        "WebKit::RemoteAudioDestinationIdentifier"_s,
        "WebKit::RemoteAudioHardwareListenerIdentifier"_s,
        "WebKit::RemoteImageBufferSetIdentifier"_s,
        "WebKit::RemoteCDMIdentifier"_s,
        "WebKit::RemoteCDMInstanceIdentifier"_s,
        "WebKit::RemoteCDMInstanceSessionIdentifier"_s,
        "WebKit::RemoteDisplayListRecorderIdentifier"_s,
        "WebKit::RemoteLegacyCDMIdentifier"_s,
        "WebKit::RemoteLegacyCDMSessionIdentifier"_s,
        "WebKit::RemoteMediaResourceIdentifier"_s,
        "WebKit::RemoteMediaSourceIdentifier"_s,
        "WebKit::RemoteRemoteCommandListenerIdentifier"_s,
        "WebKit::RemoteSerializedImageBufferIdentifier"_s,
        "WebKit::RemoteSourceBufferIdentifier"_s,
        "WebKit::RemoteVideoFrameIdentifier"_s,
        "WebKit::RenderingBackendIdentifier"_s,
        "WebKit::RenderingUpdateID"_s,
        "WebKit::RetrieveRecordResponseBodyCallbackIdentifier"_s,
        "WebKit::SampleBufferDisplayLayerIdentifier"_s,
        "WebKit::ScriptMessageHandlerIdentifier"_s,
        "WebKit::ShapeDetectionIdentifier"_s,
        "WebKit::StorageAreaIdentifier"_s,
        "WebKit::StorageAreaImplIdentifier"_s,
        "WebKit::StorageAreaMapIdentifier"_s,
        "WebKit::StorageNamespaceIdentifier"_s,
        "WebKit::TapIdentifier"_s,
        "WebKit::TextCheckerRequestID"_s,
        "WebKit::UserContentControllerIdentifier"_s,
        "WebKit::UserScriptIdentifier"_s,
        "WebKit::UserStyleSheetIdentifier"_s,
        "WebKit::VideoDecoderIdentifier"_s,
        "WebKit::VideoEncoderIdentifier"_s,
        "WebKit::VisitedLinkTableIdentifier"_s,
        "WebKit::WebExtensionContextIdentifier"_s,
        "WebKit::WebExtensionControllerIdentifier"_s,
        "WebKit::WebExtensionFrameIdentifier"_s,
        "WebKit::WebExtensionPortChannelIdentifier"_s,
        "WebKit::WebExtensionTabIdentifier"_s,
        "WebKit::WebExtensionWindowIdentifier"_s,
        "WebKit::WebGPUIdentifier"_s,
        "WebKit::WebPageProxyIdentifier"_s,
        "WebKit::WebTransportSessionIdentifier"_s,
        "WebKit::WebURLSchemeHandlerIdentifier"_s,
    };
}

#endif // ENABLE(IPC_TESTING_API)

std::optional<Vector<ArgumentDescription>> messageArgumentDescriptions(MessageName name)
{
    switch (name) {
#if ENABLE(GPU_PROCESS)
    case MessageName::GPUConnectionToWebProcess_CreateRenderingBackend:
        return Vector<ArgumentDescription> {
            { "renderingBackendIdentifier"_s, "WebKit::RenderingBackendIdentifier"_s },
            { "connectionHandle"_s, "IPC::StreamServerConnectionHandle"_s },
        };
    case MessageName::GPUConnectionToWebProcess_ReleaseRenderingBackend:
        return Vector<ArgumentDescription> {
            { "renderingBackendIdentifier"_s, "WebKit::RenderingBackendIdentifier"_s },
        };
#if ENABLE(WEBGL)
    case MessageName::GPUConnectionToWebProcess_CreateGraphicsContextGL:
        return Vector<ArgumentDescription> {
            { "identifier"_s, "WebKit::GraphicsContextGLIdentifier"_s },
            { "attributes"_s, "WebCore::GraphicsContextGLAttributes"_s },
            { "renderingBackendIdentifier"_s, "WebKit::RenderingBackendIdentifier"_s },
            { "serverConnection"_s, "IPC::StreamServerConnectionHandle"_s },
        };
    case MessageName::GPUConnectionToWebProcess_ReleaseGraphicsContextGL:
        return Vector<ArgumentDescription> {
            { "identifier"_s, "WebKit::GraphicsContextGLIdentifier"_s },
        };
#endif
    case MessageName::GPUConnectionToWebProcess_CreateGPU:
        return Vector<ArgumentDescription> {
            { "identifier"_s, "WebKit::WebGPUIdentifier"_s },
            { "renderingBackendIdentifier"_s, "WebKit::RenderingBackendIdentifier"_s },
            { "serverConnection"_s, "IPC::StreamServerConnectionHandle"_s },
        };
    case MessageName::GPUConnectionToWebProcess_ReleaseGPU:
        return Vector<ArgumentDescription> {
            { "identifier"_s, "WebKit::WebGPUIdentifier"_s },
        };
    case MessageName::GPUConnectionToWebProcess_ClearNowPlayingInfo:
        return Vector<ArgumentDescription> { };
    case MessageName::GPUConnectionToWebProcess_SetNowPlayingInfo:
        return Vector<ArgumentDescription> {
            { "nowPlayingInfo"_s, "WebCore::NowPlayingInfo"_s },
        };
#if USE(AUDIO_SESSION)
    case MessageName::GPUConnectionToWebProcess_EnsureAudioSession:
        return Vector<ArgumentDescription> { };
#endif
#if PLATFORM(IOS_FAMILY)
    case MessageName::GPUConnectionToWebProcess_EnsureMediaSessionHelper:
        return Vector<ArgumentDescription> { };
#endif
#if HAVE(VISIBILITY_PROPAGATION_VIEW)
    case MessageName::GPUConnectionToWebProcess_CreateVisibilityPropagationContextForPage:
        return Vector<ArgumentDescription> {
            { "pageProxyID"_s, "WebKit::WebPageProxyIdentifier"_s },
            { "pageID"_s, "WebCore::PageIdentifier"_s },
            { "canShowWhileLocked"_s, "bool"_s },
        };
    case MessageName::GPUConnectionToWebProcess_DestroyVisibilityPropagationContextForPage:
        return Vector<ArgumentDescription> {
            { "pageProxyID"_s, "WebKit::WebPageProxyIdentifier"_s },
            { "pageID"_s, "WebCore::PageIdentifier"_s },
        };
#endif
    case MessageName::GPUConnectionToWebProcess_SetMediaOverridesForTesting:
        return Vector<ArgumentDescription> {
            { "configuration"_s, "WebKit::MediaOverridesForTesting"_s },
        };
    case MessageName::GPUConnectionToWebProcess_CreateAudioHardwareListener:
        return Vector<ArgumentDescription> {
            { "identifier"_s, "WebKit::RemoteAudioHardwareListenerIdentifier"_s },
        };
    case MessageName::GPUConnectionToWebProcess_ReleaseAudioHardwareListener:
        return Vector<ArgumentDescription> {
            { "identifier"_s, "WebKit::RemoteAudioHardwareListenerIdentifier"_s },
        };
    case MessageName::GPUConnectionToWebProcess_CreateRemoteCommandListener:
        return Vector<ArgumentDescription> {
            { "identifier"_s, "WebKit::RemoteRemoteCommandListenerIdentifier"_s },
        };
    case MessageName::GPUConnectionToWebProcess_ReleaseRemoteCommandListener:
        return Vector<ArgumentDescription> {
            { "identifier"_s, "WebKit::RemoteRemoteCommandListenerIdentifier"_s },
        };
    case MessageName::GPUConnectionToWebProcess_ConfigureLoggingChannel:
        return Vector<ArgumentDescription> {
            { "channelName"_s, "String"_s },
            { "state"_s, "WTFLogChannelState"_s },
            { "level"_s, "WTFLogLevel"_s },
        };
#if USE(GRAPHICS_LAYER_WC)
    case MessageName::GPUConnectionToWebProcess_CreateWCLayerTreeHost:
        return Vector<ArgumentDescription> {
            { "identifier"_s, "WebKit::WCLayerTreeHostIdentifier"_s },
            { "nativeWindow"_s, "uint64_t"_s },
            { "usesOffscreenRendering"_s, "bool"_s },
        };
    case MessageName::GPUConnectionToWebProcess_ReleaseWCLayerTreeHost:
        return Vector<ArgumentDescription> {
            { "identifier"_s, "WebKit::WCLayerTreeHostIdentifier"_s },
        };
#endif
#if ENABLE(MEDIA_SOURCE)
    case MessageName::GPUConnectionToWebProcess_EnableMockMediaSource:
        return Vector<ArgumentDescription> { };
#endif
#if PLATFORM(COCOA) && ENABLE(MEDIA_STREAM)
    case MessageName::GPUConnectionToWebProcess_UpdateSampleBufferDisplayLayerBoundsAndPosition:
        return Vector<ArgumentDescription> {
            { "identifier"_s, "WebKit::SampleBufferDisplayLayerIdentifier"_s },
            { "bounds"_s, "WebCore::FloatRect"_s },
            { "fence"_s, "std::optional<MachSendRightAnnotated>"_s },
        };
#endif
#if ENABLE(EXTENSION_CAPABILITIES)
    case MessageName::GPUConnectionToWebProcess_SetMediaEnvironment:
        return Vector<ArgumentDescription> {
            { "pageIdentifier"_s, "WebCore::PageIdentifier"_s },
            { "mediaEnvironment"_s, "String"_s },
        };
#endif
#endif
#if ENABLE(GPU_PROCESS)
    case MessageName::GPUProcess_InitializeGPUProcess:
        return Vector<ArgumentDescription> {
            { "processCreationParameters"_s, "WebKit::GPUProcessCreationParameters"_s },
        };
    case MessageName::GPUProcess_CreateGPUConnectionToWebProcess:
        return Vector<ArgumentDescription> {
            { "processIdentifier"_s, "WebCore::ProcessIdentifier"_s },
            { "sessionID"_s, "PAL::SessionID"_s },
            { "connectionHandle"_s, "IPC::ConnectionHandle"_s },
            { "parameters"_s, "WebKit::GPUProcessConnectionParameters"_s },
        };
    case MessageName::GPUProcess_SharedPreferencesForWebProcessDidChange:
        return Vector<ArgumentDescription> {
            { "processIdentifier"_s, "WebCore::ProcessIdentifier"_s },
            { "sharedPreferencesForWebProcess"_s, "WebKit::SharedPreferencesForWebProcess"_s },
        };
    case MessageName::GPUProcess_UpdateGPUProcessPreferences:
        return Vector<ArgumentDescription> {
            { "preferences"_s, "WebKit::GPUProcessPreferences"_s },
        };
    case MessageName::GPUProcess_UpdateSandboxAccess:
        return Vector<ArgumentDescription> {
            { "extensions"_s, "Vector<WebKit::SandboxExtensionHandle>"_s },
        };
    case MessageName::GPUProcess_PrepareToSuspend:
        return Vector<ArgumentDescription> {
            { "isSuspensionImminent"_s, "bool"_s },
            { "estimatedSuspendTime"_s, "MonotonicTime"_s },
        };
    case MessageName::GPUProcess_ProcessDidResume:
        return Vector<ArgumentDescription> { };
    case MessageName::GPUProcess_AddSession:
        return Vector<ArgumentDescription> {
            { "sessionID"_s, "PAL::SessionID"_s },
            { "parameters"_s, "WebKit::GPUProcessSessionParameters"_s },
        };
    case MessageName::GPUProcess_RemoveSession:
        return Vector<ArgumentDescription> {
            { "sessionID"_s, "PAL::SessionID"_s },
        };
#if ENABLE(MEDIA_STREAM)
    case MessageName::GPUProcess_SetMockCaptureDevicesEnabled:
        return Vector<ArgumentDescription> {
            { "isEnabled"_s, "bool"_s },
        };
    case MessageName::GPUProcess_SetOrientationForMediaCapture:
        return Vector<ArgumentDescription> {
            { "orientation"_s, "WebCore::IntDegrees"_s },
        };
    case MessageName::GPUProcess_RotationAngleForCaptureDeviceChanged:
        return Vector<ArgumentDescription> {
            { "persistentId"_s, "String"_s },
            { "rotation"_s, "WebCore::VideoFrameRotation"_s },
        };
    case MessageName::GPUProcess_UpdateCaptureAccess:
        return Vector<ArgumentDescription> {
            { "allowAudioCapture"_s, "bool"_s },
            { "allowVideoCapture"_s, "bool"_s },
            { "allowDisplayCapture"_s, "bool"_s },
            { "processID"_s, "WebCore::ProcessIdentifier"_s },
        };
    case MessageName::GPUProcess_UpdateCaptureOrigin:
        return Vector<ArgumentDescription> {
            { "originData"_s, "WebCore::SecurityOriginData"_s },
            { "processID"_s, "WebCore::ProcessIdentifier"_s },
        };
    case MessageName::GPUProcess_AddMockMediaDevice:
        return Vector<ArgumentDescription> {
            { "device"_s, "WebCore::MockMediaDevice"_s },
        };
    case MessageName::GPUProcess_ClearMockMediaDevices:
        return Vector<ArgumentDescription> { };
    case MessageName::GPUProcess_RemoveMockMediaDevice:
        return Vector<ArgumentDescription> {
            { "persistentId"_s, "String"_s },
        };
    case MessageName::GPUProcess_SetMockMediaDeviceIsEphemeral:
        return Vector<ArgumentDescription> {
            { "persistentId"_s, "String"_s },
            { "isEphemeral"_s, "bool"_s },
        };
    case MessageName::GPUProcess_ResetMockMediaDevices:
        return Vector<ArgumentDescription> { };
    case MessageName::GPUProcess_SetMockCaptureDevicesInterrupted:
        return Vector<ArgumentDescription> {
            { "isCameraInterrupted"_s, "bool"_s },
            { "isMicrophoneInterrupted"_s, "bool"_s },
        };
    case MessageName::GPUProcess_TriggerMockCaptureConfigurationChange:
        return Vector<ArgumentDescription> {
            { "forCamera"_s, "bool"_s },
            { "forMicrophone"_s, "bool"_s },
            { "forDisplay"_s, "bool"_s },
        };
    case MessageName::GPUProcess_SetShouldListenToVoiceActivity:
        return Vector<ArgumentDescription> {
            { "shouldListen"_s, "bool"_s },
        };
    case MessageName::GPUProcess_EnableMicrophoneMuteStatusAPI:
        return Vector<ArgumentDescription> { };
#endif
#if PLATFORM(MAC)
    case MessageName::GPUProcess_SetScreenProperties:
        return Vector<ArgumentDescription> {
            { "screenProperties"_s, "WebCore::ScreenProperties"_s },
        };
#endif
#if HAVE(SCREEN_CAPTURE_KIT)
    case MessageName::GPUProcess_PromptForGetDisplayMedia:
        return Vector<ArgumentDescription> {
            { "type"_s, "WebCore::DisplayCapturePromptType"_s },
        };
    case MessageName::GPUProcess_CancelGetDisplayMediaPrompt:
        return Vector<ArgumentDescription> { };
#endif
#if ENABLE(VIDEO)
    case MessageName::GPUProcess_RequestBitmapImageForCurrentTime:
        return Vector<ArgumentDescription> {
            { "processIdentifier"_s, "WebCore::ProcessIdentifier"_s },
            { "playerIdentifier"_s, "WebCore::MediaPlayerIdentifier"_s },
        };
#endif
#if PLATFORM(MAC)
    case MessageName::GPUProcess_OpenDirectoryCacheInvalidated:
        return Vector<ArgumentDescription> {
            { "handle"_s, "WebKit::SandboxExtensionHandle"_s },
        };
#endif
#if HAVE(AUDIO_COMPONENT_SERVER_REGISTRATIONS)
    case MessageName::GPUProcess_ConsumeAudioComponentRegistrations:
        return Vector<ArgumentDescription> {
            { "registrationData"_s, "IPC::SharedBufferReference"_s },
        };
#endif
#if HAVE(POWERLOG_TASK_MODE_QUERY)
    case MessageName::GPUProcess_EnablePowerLogging:
        return Vector<ArgumentDescription> {
            { "handle"_s, "WebKit::SandboxExtensionHandle"_s },
        };
#endif
    case MessageName::GPUProcess_UserPreferredLanguagesChanged:
        return Vector<ArgumentDescription> {
            { "languages"_s, "Vector<String>"_s },
        };
    case MessageName::GPUProcess_WebProcessConnectionCountForTesting:
        return Vector<ArgumentDescription> { };
#if USE(EXTENSIONKIT)
    case MessageName::GPUProcess_ResolveBookmarkDataForCacheDirectory:
        return Vector<ArgumentDescription> {
            { "bookmarkData"_s, "std::span<const uint8_t>"_s },
        };
#endif
#if ENABLE(WEBXR)
    case MessageName::GPUProcess_WebXRPromptAccepted:
        return Vector<ArgumentDescription> {
            { "processIdentity"_s, "std::optional<WebCore::ProcessIdentity>"_s },
        };
#endif
#if HAVE(AUDIT_TOKEN)
    case MessageName::GPUProcess_SetPresentingApplicationAuditToken:
        return Vector<ArgumentDescription> {
            { "processIdentifier"_s, "WebCore::ProcessIdentifier"_s },
            { "pageIdentifier"_s, "WebCore::PageIdentifier"_s },
            { "auditToken"_s, "std::optional<WebKit::CoreIPCAuditToken>"_s },
        };
#endif
#if PLATFORM(VISION) && ENABLE(MODEL_PROCESS)
    case MessageName::GPUProcess_RequestSharedSimulationConnection:
        return Vector<ArgumentDescription> {
            { "modelProcessAuditToken"_s, "WebKit::CoreIPCAuditToken"_s },
        };
#endif
#if ((PLATFORM(VISION) && ENABLE(MODEL_PROCESS)) && HAVE(TASK_IDENTITY_TOKEN))
    case MessageName::GPUProcess_CreateMemoryAttributionIDForTask:
        return Vector<ArgumentDescription> {
            { "processIdentity"_s, "WebCore::ProcessIdentity"_s },
        };
    case MessageName::GPUProcess_UnregisterMemoryAttributionID:
        return Vector<ArgumentDescription> {
            { "attributionID"_s, "String"_s },
        };
#endif
#if PLATFORM(COCOA)
    case MessageName::GPUProcess_PostWillTakeSnapshotNotification:
        return Vector<ArgumentDescription> { };
    case MessageName::GPUProcess_RegisterFonts:
        return Vector<ArgumentDescription> {
            { "sandboxExtensions"_s, "Vector<WebKit::SandboxExtensionHandle>"_s },
        };
#endif
#endif
#if ENABLE(GPU_PROCESS)
    case MessageName::RemoteSharedResourceCache_ReleaseSerializedImageBuffer:
        return Vector<ArgumentDescription> {
            { "identifier"_s, "WebKit::RemoteSerializedImageBufferIdentifier"_s },
        };
#endif
#if ENABLE(GPU_PROCESS)
    case MessageName::RemoteBarcodeDetector_Detect:
        return Vector<ArgumentDescription> {
            { "renderingResourceIdentifier"_s, "WebCore::RenderingResourceIdentifier"_s },
        };
#endif
#if ENABLE(GPU_PROCESS)
    case MessageName::RemoteFaceDetector_Detect:
        return Vector<ArgumentDescription> {
            { "renderingResourceIdentifier"_s, "WebCore::RenderingResourceIdentifier"_s },
        };
#endif
#if ENABLE(GPU_PROCESS)
    case MessageName::RemoteTextDetector_Detect:
        return Vector<ArgumentDescription> {
            { "renderingResourceIdentifier"_s, "WebCore::RenderingResourceIdentifier"_s },
        };
#endif
#if ENABLE(GPU_PROCESS)
    case MessageName::RemoteDisplayListRecorder_Save:
        return Vector<ArgumentDescription> { };
    case MessageName::RemoteDisplayListRecorder_Restore:
        return Vector<ArgumentDescription> { };
    case MessageName::RemoteDisplayListRecorder_Translate:
        return Vector<ArgumentDescription> {
            { "x"_s, "float"_s },
            { "y"_s, "float"_s },
        };
    case MessageName::RemoteDisplayListRecorder_Rotate:
        return Vector<ArgumentDescription> {
            { "angle"_s, "float"_s },
        };
    case MessageName::RemoteDisplayListRecorder_Scale:
        return Vector<ArgumentDescription> {
            { "scale"_s, "WebCore::FloatSize"_s },
        };
    case MessageName::RemoteDisplayListRecorder_SetCTM:
        return Vector<ArgumentDescription> {
            { "ctm"_s, "WebCore::AffineTransform"_s },
        };
    case MessageName::RemoteDisplayListRecorder_ConcatCTM:
        return Vector<ArgumentDescription> {
            { "ctm"_s, "WebCore::AffineTransform"_s },
        };
    case MessageName::RemoteDisplayListRecorder_SetFillPackedColor:
        return Vector<ArgumentDescription> {
            { "color"_s, "WebCore::PackedColor::RGBA"_s },
        };
    case MessageName::RemoteDisplayListRecorder_SetFillColor:
        return Vector<ArgumentDescription> {
            { "color"_s, "WebCore::Color"_s },
        };
    case MessageName::RemoteDisplayListRecorder_SetFillCachedGradient:
        return Vector<ArgumentDescription> {
            { "gradientIdentifier"_s, "WebCore::RenderingResourceIdentifier"_s },
            { "spaceTransform"_s, "WebCore::AffineTransform"_s },
        };
    case MessageName::RemoteDisplayListRecorder_SetFillGradient:
        return Vector<ArgumentDescription> {
            { "gradient"_s, "Ref<WebCore::Gradient>"_s },
            { "spaceTransform"_s, "WebCore::AffineTransform"_s },
        };
    case MessageName::RemoteDisplayListRecorder_SetFillPattern:
        return Vector<ArgumentDescription> {
            { "tileImageIdentifier"_s, "WebCore::RenderingResourceIdentifier"_s },
            { "pattern"_s, "WebCore::PatternParameters"_s },
        };
    case MessageName::RemoteDisplayListRecorder_SetFillRule:
        return Vector<ArgumentDescription> {
            { "rule"_s, "WebCore::WindRule"_s },
        };
    case MessageName::RemoteDisplayListRecorder_SetStrokePackedColor:
        return Vector<ArgumentDescription> {
            { "color"_s, "WebCore::PackedColor::RGBA"_s },
        };
    case MessageName::RemoteDisplayListRecorder_SetStrokeColor:
        return Vector<ArgumentDescription> {
            { "color"_s, "WebCore::Color"_s },
        };
    case MessageName::RemoteDisplayListRecorder_SetStrokeCachedGradient:
        return Vector<ArgumentDescription> {
            { "gradientIdentifier"_s, "WebCore::RenderingResourceIdentifier"_s },
            { "spaceTransform"_s, "WebCore::AffineTransform"_s },
        };
    case MessageName::RemoteDisplayListRecorder_SetStrokeGradient:
        return Vector<ArgumentDescription> {
            { "gradient"_s, "Ref<WebCore::Gradient>"_s },
            { "spaceTransform"_s, "WebCore::AffineTransform"_s },
        };
    case MessageName::RemoteDisplayListRecorder_SetStrokePattern:
        return Vector<ArgumentDescription> {
            { "tileImageIdentifier"_s, "WebCore::RenderingResourceIdentifier"_s },
            { "pattern"_s, "WebCore::PatternParameters"_s },
        };
    case MessageName::RemoteDisplayListRecorder_SetStrokePackedColorAndThickness:
        return Vector<ArgumentDescription> {
            { "color"_s, "WebCore::PackedColor::RGBA"_s },
            { "thickness"_s, "float"_s },
        };
    case MessageName::RemoteDisplayListRecorder_SetStrokeThickness:
        return Vector<ArgumentDescription> {
            { "thickness"_s, "float"_s },
        };
    case MessageName::RemoteDisplayListRecorder_SetStrokeStyle:
        return Vector<ArgumentDescription> {
            { "style"_s, "WebCore::StrokeStyle"_s },
        };
    case MessageName::RemoteDisplayListRecorder_SetCompositeMode:
        return Vector<ArgumentDescription> {
            { "mode"_s, "WebCore::CompositeMode"_s },
        };
    case MessageName::RemoteDisplayListRecorder_SetDropShadow:
        return Vector<ArgumentDescription> {
            { "dropShadow"_s, "std::optional<WebCore::GraphicsDropShadow>"_s },
        };
    case MessageName::RemoteDisplayListRecorder_SetStyle:
        return Vector<ArgumentDescription> {
            { "style"_s, "std::optional<WebCore::GraphicsStyle>"_s },
        };
    case MessageName::RemoteDisplayListRecorder_SetAlpha:
        return Vector<ArgumentDescription> {
            { "alpha"_s, "float"_s },
        };
    case MessageName::RemoteDisplayListRecorder_SetTextDrawingMode:
        return Vector<ArgumentDescription> {
            { "mode"_s, "WebCore::TextDrawingModeFlags"_s },
        };
    case MessageName::RemoteDisplayListRecorder_SetImageInterpolationQuality:
        return Vector<ArgumentDescription> {
            { "quality"_s, "WebCore::InterpolationQuality"_s },
        };
    case MessageName::RemoteDisplayListRecorder_SetShouldAntialias:
        return Vector<ArgumentDescription> {
            { "shouldAntialias"_s, "bool"_s },
        };
    case MessageName::RemoteDisplayListRecorder_SetShouldSmoothFonts:
        return Vector<ArgumentDescription> {
            { "shouldSmooth"_s, "bool"_s },
        };
    case MessageName::RemoteDisplayListRecorder_SetShouldSubpixelQuantizeFonts:
        return Vector<ArgumentDescription> {
            { "shouldQuantize"_s, "bool"_s },
        };
    case MessageName::RemoteDisplayListRecorder_SetShadowsIgnoreTransforms:
        return Vector<ArgumentDescription> {
            { "shouldIgnore"_s, "bool"_s },
        };
    case MessageName::RemoteDisplayListRecorder_SetDrawLuminanceMask:
        return Vector<ArgumentDescription> {
            { "shouldDraw"_s, "bool"_s },
        };
    case MessageName::RemoteDisplayListRecorder_SetLineCap:
        return Vector<ArgumentDescription> {
            { "lineCap"_s, "WebCore::LineCap"_s },
        };
    case MessageName::RemoteDisplayListRecorder_SetLineDash:
        return Vector<ArgumentDescription> {
            { "dashArray"_s, "FixedVector<double>"_s },
            { "dashOffset"_s, "float"_s },
        };
    case MessageName::RemoteDisplayListRecorder_SetLineJoin:
        return Vector<ArgumentDescription> {
            { "lineJoin"_s, "WebCore::LineJoin"_s },
        };
    case MessageName::RemoteDisplayListRecorder_SetMiterLimit:
        return Vector<ArgumentDescription> {
            { "limit"_s, "float"_s },
        };
    case MessageName::RemoteDisplayListRecorder_Clip:
        return Vector<ArgumentDescription> {
            { "rect"_s, "WebCore::FloatRect"_s },
        };
    case MessageName::RemoteDisplayListRecorder_ClipRoundedRect:
        return Vector<ArgumentDescription> {
            { "rect"_s, "WebCore::FloatRoundedRect"_s },
        };
    case MessageName::RemoteDisplayListRecorder_ClipOut:
        return Vector<ArgumentDescription> {
            { "rect"_s, "WebCore::FloatRect"_s },
        };
    case MessageName::RemoteDisplayListRecorder_ClipOutRoundedRect:
        return Vector<ArgumentDescription> {
            { "rect"_s, "WebCore::FloatRoundedRect"_s },
        };
    case MessageName::RemoteDisplayListRecorder_ClipToImageBuffer:
        return Vector<ArgumentDescription> {
            { "renderingResourceIdentifier"_s, "WebCore::RenderingResourceIdentifier"_s },
            { "destinationRect"_s, "WebCore::FloatRect"_s },
        };
    case MessageName::RemoteDisplayListRecorder_ClipOutToPath:
        return Vector<ArgumentDescription> {
            { "path"_s, "WebCore::Path"_s },
        };
    case MessageName::RemoteDisplayListRecorder_ClipPath:
        return Vector<ArgumentDescription> {
            { "path"_s, "WebCore::Path"_s },
            { "windRule"_s, "WebCore::WindRule"_s },
        };
    case MessageName::RemoteDisplayListRecorder_ResetClip:
        return Vector<ArgumentDescription> { };
    case MessageName::RemoteDisplayListRecorder_DrawGlyphs:
        return Vector<ArgumentDescription> {
            { "fontIdentifier"_s, "WebCore::RenderingResourceIdentifier"_s },
            { "glyphsAdvances"_s, "IPC::ArrayReferenceTuple<WebCore::GlyphBufferGlyph, WebCore::FloatSize>"_s },
            { "localAnchor"_s, "WebCore::FloatPoint"_s },
            { "smoothingMode"_s, "WebCore::FontSmoothingMode"_s },
        };
    case MessageName::RemoteDisplayListRecorder_DrawDecomposedGlyphs:
        return Vector<ArgumentDescription> {
            { "fontIdentifier"_s, "WebCore::RenderingResourceIdentifier"_s },
            { "decomposedGlyphsIdentifier"_s, "WebCore::RenderingResourceIdentifier"_s },
        };
    case MessageName::RemoteDisplayListRecorder_DrawFilteredImageBuffer:
        return Vector<ArgumentDescription> {
            { "sourceImageIdentifier"_s, "std::optional<WebCore::RenderingResourceIdentifier>"_s },
            { "sourceImageRect"_s, "WebCore::FloatRect"_s },
            { "filter"_s, "Ref<WebCore::Filter>"_s },
        };
    case MessageName::RemoteDisplayListRecorder_DrawImageBuffer:
        return Vector<ArgumentDescription> {
            { "imageBufferIdentifier"_s, "WebCore::RenderingResourceIdentifier"_s },
            { "destinationRect"_s, "WebCore::FloatRect"_s },
            { "srcRect"_s, "WebCore::FloatRect"_s },
            { "options"_s, "WebCore::ImagePaintingOptions"_s },
        };
    case MessageName::RemoteDisplayListRecorder_DrawNativeImage:
        return Vector<ArgumentDescription> {
            { "imageIdentifier"_s, "WebCore::RenderingResourceIdentifier"_s },
            { "destRect"_s, "WebCore::FloatRect"_s },
            { "srcRect"_s, "WebCore::FloatRect"_s },
            { "options"_s, "WebCore::ImagePaintingOptions"_s },
        };
    case MessageName::RemoteDisplayListRecorder_DrawSystemImage:
        return Vector<ArgumentDescription> {
            { "systemImage"_s, "Ref<WebCore::SystemImage>"_s },
            { "destinationRect"_s, "WebCore::FloatRect"_s },
        };
    case MessageName::RemoteDisplayListRecorder_DrawPatternNativeImage:
        return Vector<ArgumentDescription> {
            { "imageIdentifier"_s, "WebCore::RenderingResourceIdentifier"_s },
            { "destRect"_s, "WebCore::FloatRect"_s },
            { "tileRect"_s, "WebCore::FloatRect"_s },
            { "transform"_s, "WebCore::AffineTransform"_s },
            { "phase"_s, "WebCore::FloatPoint"_s },
            { "spacing"_s, "WebCore::FloatSize"_s },
            { "options"_s, "WebCore::ImagePaintingOptions"_s },
        };
    case MessageName::RemoteDisplayListRecorder_DrawPatternImageBuffer:
        return Vector<ArgumentDescription> {
            { "imageIdentifier"_s, "WebCore::RenderingResourceIdentifier"_s },
            { "destRect"_s, "WebCore::FloatRect"_s },
            { "tileRect"_s, "WebCore::FloatRect"_s },
            { "transform"_s, "WebCore::AffineTransform"_s },
            { "phase"_s, "WebCore::FloatPoint"_s },
            { "spacing"_s, "WebCore::FloatSize"_s },
            { "options"_s, "WebCore::ImagePaintingOptions"_s },
        };
    case MessageName::RemoteDisplayListRecorder_BeginTransparencyLayer:
        return Vector<ArgumentDescription> {
            { "opacity"_s, "float"_s },
        };
    case MessageName::RemoteDisplayListRecorder_BeginTransparencyLayerWithCompositeMode:
        return Vector<ArgumentDescription> {
            { "compositeMode"_s, "WebCore::CompositeMode"_s },
        };
    case MessageName::RemoteDisplayListRecorder_EndTransparencyLayer:
        return Vector<ArgumentDescription> { };
    case MessageName::RemoteDisplayListRecorder_DrawRect:
        return Vector<ArgumentDescription> {
            { "rect"_s, "WebCore::FloatRect"_s },
            { "borderThickness"_s, "float"_s },
        };
    case MessageName::RemoteDisplayListRecorder_DrawLine:
        return Vector<ArgumentDescription> {
            { "point1"_s, "WebCore::FloatPoint"_s },
            { "point2"_s, "WebCore::FloatPoint"_s },
        };
    case MessageName::RemoteDisplayListRecorder_DrawLinesForText:
        return Vector<ArgumentDescription> {
            { "point"_s, "WebCore::FloatPoint"_s },
            { "thickness"_s, "float"_s },
            { "lineSegments"_s, "std::span<const WebCore::FloatSegment>"_s },
            { "printing"_s, "bool"_s },
            { "doubleLines"_s, "bool"_s },
            { "strokeStyle"_s, "WebCore::StrokeStyle"_s },
        };
    case MessageName::RemoteDisplayListRecorder_DrawDotsForDocumentMarker:
        return Vector<ArgumentDescription> {
            { "rect"_s, "WebCore::FloatRect"_s },
            { "style"_s, "WebCore::DocumentMarkerLineStyle"_s },
        };
    case MessageName::RemoteDisplayListRecorder_DrawEllipse:
        return Vector<ArgumentDescription> {
            { "rect"_s, "WebCore::FloatRect"_s },
        };
    case MessageName::RemoteDisplayListRecorder_DrawPath:
        return Vector<ArgumentDescription> {
            { "path"_s, "WebCore::Path"_s },
        };
    case MessageName::RemoteDisplayListRecorder_DrawFocusRingPath:
        return Vector<ArgumentDescription> {
            { "path"_s, "WebCore::Path"_s },
            { "outlineWidth"_s, "float"_s },
            { "color"_s, "WebCore::Color"_s },
        };
    case MessageName::RemoteDisplayListRecorder_DrawFocusRingRects:
        return Vector<ArgumentDescription> {
            { "rects"_s, "Vector<WebCore::FloatRect>"_s },
            { "outlineOffset"_s, "float"_s },
            { "outlineWidth"_s, "float"_s },
            { "color"_s, "WebCore::Color"_s },
        };
    case MessageName::RemoteDisplayListRecorder_FillRect:
        return Vector<ArgumentDescription> {
            { "rect"_s, "WebCore::FloatRect"_s },
            { "requiresClipToRect"_s, "WebCore::RequiresClipToRect"_s },
        };
    case MessageName::RemoteDisplayListRecorder_FillRectWithColor:
        return Vector<ArgumentDescription> {
            { "rect"_s, "WebCore::FloatRect"_s },
            { "color"_s, "WebCore::Color"_s },
        };
    case MessageName::RemoteDisplayListRecorder_FillRectWithGradient:
        return Vector<ArgumentDescription> {
            { "rect"_s, "WebCore::FloatRect"_s },
            { "gradient"_s, "Ref<WebCore::Gradient>"_s },
        };
    case MessageName::RemoteDisplayListRecorder_FillRectWithGradientAndSpaceTransform:
        return Vector<ArgumentDescription> {
            { "rect"_s, "WebCore::FloatRect"_s },
            { "gradient"_s, "Ref<WebCore::Gradient>"_s },
            { "transform"_s, "WebCore::AffineTransform"_s },
            { "requiresClipToRect"_s, "WebCore::RequiresClipToRect"_s },
        };
    case MessageName::RemoteDisplayListRecorder_FillCompositedRect:
        return Vector<ArgumentDescription> {
            { "rect"_s, "WebCore::FloatRect"_s },
            { "color"_s, "WebCore::Color"_s },
            { "op"_s, "WebCore::CompositeOperator"_s },
            { "blendMode"_s, "WebCore::BlendMode"_s },
        };
    case MessageName::RemoteDisplayListRecorder_FillRoundedRect:
        return Vector<ArgumentDescription> {
            { "rect"_s, "WebCore::FloatRoundedRect"_s },
            { "color"_s, "WebCore::Color"_s },
            { "blendMode"_s, "WebCore::BlendMode"_s },
        };
    case MessageName::RemoteDisplayListRecorder_FillRectWithRoundedHole:
        return Vector<ArgumentDescription> {
            { "rect"_s, "WebCore::FloatRect"_s },
            { "roundedHoleRect"_s, "WebCore::FloatRoundedRect"_s },
            { "color"_s, "WebCore::Color"_s },
        };
#if ENABLE(INLINE_PATH_DATA)
    case MessageName::RemoteDisplayListRecorder_FillLine:
        return Vector<ArgumentDescription> {
            { "line"_s, "WebCore::PathDataLine"_s },
        };
    case MessageName::RemoteDisplayListRecorder_FillArc:
        return Vector<ArgumentDescription> {
            { "arc"_s, "WebCore::PathArc"_s },
        };
    case MessageName::RemoteDisplayListRecorder_FillClosedArc:
        return Vector<ArgumentDescription> {
            { "closedArc"_s, "WebCore::PathClosedArc"_s },
        };
    case MessageName::RemoteDisplayListRecorder_FillQuadCurve:
        return Vector<ArgumentDescription> {
            { "curve"_s, "WebCore::PathDataQuadCurve"_s },
        };
    case MessageName::RemoteDisplayListRecorder_FillBezierCurve:
        return Vector<ArgumentDescription> {
            { "curve"_s, "WebCore::PathDataBezierCurve"_s },
        };
#endif
    case MessageName::RemoteDisplayListRecorder_FillPathSegment:
        return Vector<ArgumentDescription> {
            { "segment"_s, "WebCore::PathSegment"_s },
        };
    case MessageName::RemoteDisplayListRecorder_FillPath:
        return Vector<ArgumentDescription> {
            { "path"_s, "WebCore::Path"_s },
        };
    case MessageName::RemoteDisplayListRecorder_FillEllipse:
        return Vector<ArgumentDescription> {
            { "rect"_s, "WebCore::FloatRect"_s },
        };
    case MessageName::RemoteDisplayListRecorder_StrokeRect:
        return Vector<ArgumentDescription> {
            { "rect"_s, "WebCore::FloatRect"_s },
            { "lineWidth"_s, "float"_s },
        };
#if ENABLE(INLINE_PATH_DATA)
    case MessageName::RemoteDisplayListRecorder_StrokeLine:
        return Vector<ArgumentDescription> {
            { "line"_s, "WebCore::PathDataLine"_s },
        };
    case MessageName::RemoteDisplayListRecorder_StrokeLineWithColorAndThickness:
        return Vector<ArgumentDescription> {
            { "line"_s, "WebCore::PathDataLine"_s },
            { "strokeColor"_s, "std::optional<WebCore::PackedColor::RGBA>"_s },
            { "strokeThickness"_s, "std::optional<float>"_s },
        };
    case MessageName::RemoteDisplayListRecorder_StrokeArc:
        return Vector<ArgumentDescription> {
            { "arc"_s, "WebCore::PathArc"_s },
        };
    case MessageName::RemoteDisplayListRecorder_StrokeClosedArc:
        return Vector<ArgumentDescription> {
            { "closedArc"_s, "WebCore::PathClosedArc"_s },
        };
    case MessageName::RemoteDisplayListRecorder_StrokeQuadCurve:
        return Vector<ArgumentDescription> {
            { "curve"_s, "WebCore::PathDataQuadCurve"_s },
        };
    case MessageName::RemoteDisplayListRecorder_StrokeBezierCurve:
        return Vector<ArgumentDescription> {
            { "curve"_s, "WebCore::PathDataBezierCurve"_s },
        };
#endif
    case MessageName::RemoteDisplayListRecorder_StrokePathSegment:
        return Vector<ArgumentDescription> {
            { "segment"_s, "WebCore::PathSegment"_s },
        };
    case MessageName::RemoteDisplayListRecorder_StrokePath:
        return Vector<ArgumentDescription> {
            { "path"_s, "WebCore::Path"_s },
        };
    case MessageName::RemoteDisplayListRecorder_StrokeEllipse:
        return Vector<ArgumentDescription> {
            { "rect"_s, "WebCore::FloatRect"_s },
        };
    case MessageName::RemoteDisplayListRecorder_ClearRect:
        return Vector<ArgumentDescription> {
            { "rect"_s, "WebCore::FloatRect"_s },
        };
    case MessageName::RemoteDisplayListRecorder_DrawControlPart:
        return Vector<ArgumentDescription> {
            { "part"_s, "Ref<WebCore::ControlPart>"_s },
            { "borderRect"_s, "WebCore::FloatRoundedRect"_s },
            { "deviceScaleFactor"_s, "float"_s },
            { "style"_s, "WebCore::ControlStyle"_s },
        };
#if USE(CG)
    case MessageName::RemoteDisplayListRecorder_ApplyStrokePattern:
        return Vector<ArgumentDescription> { };
    case MessageName::RemoteDisplayListRecorder_ApplyFillPattern:
        return Vector<ArgumentDescription> { };
#endif
    case MessageName::RemoteDisplayListRecorder_ApplyDeviceScaleFactor:
        return Vector<ArgumentDescription> {
            { "scaleFactor"_s, "float"_s },
        };
    case MessageName::RemoteDisplayListRecorder_BeginPage:
        return Vector<ArgumentDescription> {
            { "pageSize"_s, "WebCore::IntSize"_s },
        };
    case MessageName::RemoteDisplayListRecorder_EndPage:
        return Vector<ArgumentDescription> { };
    case MessageName::RemoteDisplayListRecorder_SetURLForRect:
        return Vector<ArgumentDescription> {
            { "link"_s, "URL"_s },
            { "destRect"_s, "WebCore::FloatRect"_s },
        };
#if PLATFORM(COCOA) && ENABLE(VIDEO)
    case MessageName::RemoteDisplayListRecorder_DrawVideoFrame:
        return Vector<ArgumentDescription> {
            { "frame"_s, "WebKit::SharedVideoFrame"_s },
            { "rect"_s, "WebCore::FloatRect"_s },
            { "orientation"_s, "WebCore::ImageOrientation"_s },
            { "shouldDiscardAlpha"_s, "bool"_s },
        };
    case MessageName::RemoteDisplayListRecorder_SetSharedVideoFrameSemaphore:
        return Vector<ArgumentDescription> {
            { "semaphore"_s, "IPC::Semaphore"_s },
        };
    case MessageName::RemoteDisplayListRecorder_SetSharedVideoFrameMemory:
        return Vector<ArgumentDescription> {
            { "storageHandle"_s, "WebCore::SharedMemory::Handle"_s },
        };
#endif
#endif
#if ENABLE(GPU_PROCESS) && ENABLE(WEBGL)
    case MessageName::RemoteGraphicsContextGL_Reshape:
        return Vector<ArgumentDescription> {
            { "width"_s, "int32_t"_s },
            { "height"_s, "int32_t"_s },
        };
#if PLATFORM(COCOA)
    case MessageName::RemoteGraphicsContextGL_PrepareForDisplay:
        return Vector<ArgumentDescription> {
            { "finishedFence"_s, "IPC::Semaphore"_s },
        };
#endif
#if USE(GRAPHICS_LAYER_WC)
    case MessageName::RemoteGraphicsContextGL_PrepareForDisplay:
        return Vector<ArgumentDescription> { };
#endif
#if USE(GBM)
    case MessageName::RemoteGraphicsContextGL_PrepareForDisplay:
        return Vector<ArgumentDescription> { };
#endif
#if !PLATFORM(COCOA) && !USE(GRAPHICS_LAYER_WC) && !USE(GBM)
    case MessageName::RemoteGraphicsContextGL_PrepareForDisplay:
        return Vector<ArgumentDescription> { };
#endif
    case MessageName::RemoteGraphicsContextGL_EnsureExtensionEnabled:
        return Vector<ArgumentDescription> {
            { "extension"_s, "String"_s },
        };
    case MessageName::RemoteGraphicsContextGL_GetErrors:
        return Vector<ArgumentDescription> { };
    case MessageName::RemoteGraphicsContextGL_DrawSurfaceBufferToImageBuffer:
        return Vector<ArgumentDescription> {
            { "buffer"_s, "WebCore::GraphicsContextGLSurfaceBuffer"_s },
            { "imageBuffer"_s, "WebCore::RenderingResourceIdentifier"_s },
        };
#if ENABLE(MEDIA_STREAM) || ENABLE(WEB_CODECS)
    case MessageName::RemoteGraphicsContextGL_SurfaceBufferToVideoFrame:
        return Vector<ArgumentDescription> {
            { "buffer"_s, "WebCore::GraphicsContextGLSurfaceBuffer"_s },
        };
#endif
#if ENABLE(VIDEO) && PLATFORM(COCOA)
    case MessageName::RemoteGraphicsContextGL_CopyTextureFromVideoFrame:
        return Vector<ArgumentDescription> {
            { "frame"_s, "WebKit::SharedVideoFrame"_s },
            { "texture"_s, "PlatformGLObject"_s },
            { "target"_s, "uint32_t"_s },
            { "level"_s, "int32_t"_s },
            { "internalFormat"_s, "uint32_t"_s },
            { "format"_s, "uint32_t"_s },
            { "type"_s, "uint32_t"_s },
            { "premultiplyAlpha"_s, "bool"_s },
            { "flipY"_s, "bool"_s },
        };
    case MessageName::RemoteGraphicsContextGL_SetSharedVideoFrameSemaphore:
        return Vector<ArgumentDescription> {
            { "semaphore"_s, "IPC::Semaphore"_s },
        };
    case MessageName::RemoteGraphicsContextGL_SetSharedVideoFrameMemory:
        return Vector<ArgumentDescription> {
            { "storageHandle"_s, "WebCore::SharedMemory::Handle"_s },
        };
#endif
    case MessageName::RemoteGraphicsContextGL_SimulateEventForTesting:
        return Vector<ArgumentDescription> {
            { "event"_s, "WebCore::GraphicsContextGLSimulatedEventForTesting"_s },
        };
    case MessageName::RemoteGraphicsContextGL_GetBufferSubDataInline:
        return Vector<ArgumentDescription> {
            { "target"_s, "uint32_t"_s },
            { "offset"_s, "uint64_t"_s },
            { "dataSize"_s, "uint64_t"_s },
        };
    case MessageName::RemoteGraphicsContextGL_GetBufferSubDataSharedMemory:
        return Vector<ArgumentDescription> {
            { "target"_s, "uint32_t"_s },
            { "offset"_s, "uint64_t"_s },
            { "dataSize"_s, "uint64_t"_s },
            { "handle"_s, "WebCore::SharedMemory::Handle"_s },
        };
    case MessageName::RemoteGraphicsContextGL_ReadPixelsInline:
        return Vector<ArgumentDescription> {
            { "rect"_s, "WebCore::IntRect"_s },
            { "format"_s, "uint32_t"_s },
            { "type"_s, "uint32_t"_s },
            { "packReverseRowOrder"_s, "bool"_s },
        };
    case MessageName::RemoteGraphicsContextGL_ReadPixelsSharedMemory:
        return Vector<ArgumentDescription> {
            { "rect"_s, "WebCore::IntRect"_s },
            { "format"_s, "uint32_t"_s },
            { "type"_s, "uint32_t"_s },
            { "packReverseRowOrder"_s, "bool"_s },
            { "handle"_s, "WebCore::SharedMemory::Handle"_s },
        };
    case MessageName::RemoteGraphicsContextGL_MultiDrawArraysANGLE:
        return Vector<ArgumentDescription> {
            { "mode"_s, "uint32_t"_s },
            { "firstsAndCounts"_s, "IPC::ArrayReferenceTuple<int32_t, int32_t>"_s },
        };
    case MessageName::RemoteGraphicsContextGL_MultiDrawArraysInstancedANGLE:
        return Vector<ArgumentDescription> {
            { "mode"_s, "uint32_t"_s },
            { "firstsCountsAandInstanceCounts"_s, "IPC::ArrayReferenceTuple<int32_t, int32_t, int32_t>"_s },
        };
    case MessageName::RemoteGraphicsContextGL_MultiDrawElementsANGLE:
        return Vector<ArgumentDescription> {
            { "mode"_s, "uint32_t"_s },
            { "countsAndOffsets"_s, "IPC::ArrayReferenceTuple<int32_t, int32_t>"_s },
            { "type"_s, "uint32_t"_s },
        };
    case MessageName::RemoteGraphicsContextGL_MultiDrawElementsInstancedANGLE:
        return Vector<ArgumentDescription> {
            { "mode"_s, "uint32_t"_s },
            { "countsOffsetsAndInstanceCounts"_s, "IPC::ArrayReferenceTuple<int32_t, int32_t, int32_t>"_s },
            { "type"_s, "uint32_t"_s },
        };
    case MessageName::RemoteGraphicsContextGL_MultiDrawArraysInstancedBaseInstanceANGLE:
        return Vector<ArgumentDescription> {
            { "mode"_s, "uint32_t"_s },
            { "firstsCountsInstanceCountsAndBaseInstances"_s, "IPC::ArrayReferenceTuple<int32_t, int32_t, int32_t, uint32_t>"_s },
        };
    case MessageName::RemoteGraphicsContextGL_MultiDrawElementsInstancedBaseVertexBaseInstanceANGLE:
        return Vector<ArgumentDescription> {
            { "mode"_s, "uint32_t"_s },
            { "countsOffsetsInstanceCountsBaseVerticesAndBaseInstances"_s, "IPC::ArrayReferenceTuple<int32_t, int32_t, int32_t, int32_t, uint32_t>"_s },
            { "type"_s, "uint32_t"_s },
        };
    case MessageName::RemoteGraphicsContextGL_DrawBuffers:
        return Vector<ArgumentDescription> {
            { "bufs"_s, "std::span<const uint32_t>"_s },
        };
    case MessageName::RemoteGraphicsContextGL_DrawBuffersEXT:
        return Vector<ArgumentDescription> {
            { "bufs"_s, "std::span<const uint32_t>"_s },
        };
    case MessageName::RemoteGraphicsContextGL_InvalidateFramebuffer:
        return Vector<ArgumentDescription> {
            { "target"_s, "uint32_t"_s },
            { "attachments"_s, "std::span<const uint32_t>"_s },
        };
    case MessageName::RemoteGraphicsContextGL_InvalidateSubFramebuffer:
        return Vector<ArgumentDescription> {
            { "target"_s, "uint32_t"_s },
            { "attachments"_s, "std::span<const uint32_t>"_s },
            { "x"_s, "int32_t"_s },
            { "y"_s, "int32_t"_s },
            { "width"_s, "int32_t"_s },
            { "height"_s, "int32_t"_s },
        };
#if ENABLE(WEBXR)
    case MessageName::RemoteGraphicsContextGL_FramebufferDiscard:
        return Vector<ArgumentDescription> {
            { "target"_s, "uint32_t"_s },
            { "attachments"_s, "std::span<const uint32_t>"_s },
        };
#endif
    case MessageName::RemoteGraphicsContextGL_ActiveTexture:
        return Vector<ArgumentDescription> {
            { "texture"_s, "uint32_t"_s },
        };
    case MessageName::RemoteGraphicsContextGL_AttachShader:
        return Vector<ArgumentDescription> {
            { "program"_s, "uint32_t"_s },
            { "shader"_s, "uint32_t"_s },
        };
    case MessageName::RemoteGraphicsContextGL_BindAttribLocation:
        return Vector<ArgumentDescription> {
            { "arg0"_s, "uint32_t"_s },
            { "index"_s, "uint32_t"_s },
            { "name"_s, "String"_s },
        };
    case MessageName::RemoteGraphicsContextGL_BindBuffer:
        return Vector<ArgumentDescription> {
            { "target"_s, "uint32_t"_s },
            { "arg1"_s, "uint32_t"_s },
        };
    case MessageName::RemoteGraphicsContextGL_BindFramebuffer:
        return Vector<ArgumentDescription> {
            { "target"_s, "uint32_t"_s },
            { "arg1"_s, "uint32_t"_s },
        };
    case MessageName::RemoteGraphicsContextGL_BindRenderbuffer:
        return Vector<ArgumentDescription> {
            { "target"_s, "uint32_t"_s },
            { "arg1"_s, "uint32_t"_s },
        };
    case MessageName::RemoteGraphicsContextGL_BindTexture:
        return Vector<ArgumentDescription> {
            { "target"_s, "uint32_t"_s },
            { "arg1"_s, "uint32_t"_s },
        };
    case MessageName::RemoteGraphicsContextGL_BlendColor:
        return Vector<ArgumentDescription> {
            { "red"_s, "float"_s },
            { "green"_s, "float"_s },
            { "blue"_s, "float"_s },
            { "alpha"_s, "float"_s },
        };
    case MessageName::RemoteGraphicsContextGL_BlendEquation:
        return Vector<ArgumentDescription> {
            { "mode"_s, "uint32_t"_s },
        };
    case MessageName::RemoteGraphicsContextGL_BlendEquationSeparate:
        return Vector<ArgumentDescription> {
            { "modeRGB"_s, "uint32_t"_s },
            { "modeAlpha"_s, "uint32_t"_s },
        };
    case MessageName::RemoteGraphicsContextGL_BlendFunc:
        return Vector<ArgumentDescription> {
            { "sfactor"_s, "uint32_t"_s },
            { "dfactor"_s, "uint32_t"_s },
        };
    case MessageName::RemoteGraphicsContextGL_BlendFuncSeparate:
        return Vector<ArgumentDescription> {
            { "srcRGB"_s, "uint32_t"_s },
            { "dstRGB"_s, "uint32_t"_s },
            { "srcAlpha"_s, "uint32_t"_s },
            { "dstAlpha"_s, "uint32_t"_s },
        };
    case MessageName::RemoteGraphicsContextGL_CheckFramebufferStatus:
        return Vector<ArgumentDescription> {
            { "target"_s, "uint32_t"_s },
        };
    case MessageName::RemoteGraphicsContextGL_Clear:
        return Vector<ArgumentDescription> {
            { "mask"_s, "uint32_t"_s },
        };
    case MessageName::RemoteGraphicsContextGL_ClearColor:
        return Vector<ArgumentDescription> {
            { "red"_s, "float"_s },
            { "green"_s, "float"_s },
            { "blue"_s, "float"_s },
            { "alpha"_s, "float"_s },
        };
    case MessageName::RemoteGraphicsContextGL_ClearDepth:
        return Vector<ArgumentDescription> {
            { "depth"_s, "float"_s },
        };
    case MessageName::RemoteGraphicsContextGL_ClearStencil:
        return Vector<ArgumentDescription> {
            { "s"_s, "int32_t"_s },
        };
    case MessageName::RemoteGraphicsContextGL_ColorMask:
        return Vector<ArgumentDescription> {
            { "red"_s, "bool"_s },
            { "green"_s, "bool"_s },
            { "blue"_s, "bool"_s },
            { "alpha"_s, "bool"_s },
        };
    case MessageName::RemoteGraphicsContextGL_CompileShader:
        return Vector<ArgumentDescription> {
            { "arg0"_s, "uint32_t"_s },
        };
    case MessageName::RemoteGraphicsContextGL_CopyTexImage2D:
        return Vector<ArgumentDescription> {
            { "target"_s, "uint32_t"_s },
            { "level"_s, "int32_t"_s },
            { "internalformat"_s, "uint32_t"_s },
            { "x"_s, "int32_t"_s },
            { "y"_s, "int32_t"_s },
            { "width"_s, "int32_t"_s },
            { "height"_s, "int32_t"_s },
            { "border"_s, "int32_t"_s },
        };
    case MessageName::RemoteGraphicsContextGL_CopyTexSubImage2D:
        return Vector<ArgumentDescription> {
            { "target"_s, "uint32_t"_s },
            { "level"_s, "int32_t"_s },
            { "xoffset"_s, "int32_t"_s },
            { "yoffset"_s, "int32_t"_s },
            { "x"_s, "int32_t"_s },
            { "y"_s, "int32_t"_s },
            { "width"_s, "int32_t"_s },
            { "height"_s, "int32_t"_s },
        };
    case MessageName::RemoteGraphicsContextGL_CreateBuffer:
        return Vector<ArgumentDescription> {
            { "buffer"_s, "uint32_t"_s },
        };
    case MessageName::RemoteGraphicsContextGL_CreateFramebuffer:
        return Vector<ArgumentDescription> {
            { "framebuffer"_s, "uint32_t"_s },
        };
    case MessageName::RemoteGraphicsContextGL_CreateProgram:
        return Vector<ArgumentDescription> {
            { "program"_s, "uint32_t"_s },
        };
    case MessageName::RemoteGraphicsContextGL_CreateRenderbuffer:
        return Vector<ArgumentDescription> {
            { "renderbuffer"_s, "uint32_t"_s },
        };
    case MessageName::RemoteGraphicsContextGL_CreateShader:
        return Vector<ArgumentDescription> {
            { "shader"_s, "uint32_t"_s },
            { "arg0"_s, "uint32_t"_s },
        };
    case MessageName::RemoteGraphicsContextGL_CreateTexture:
        return Vector<ArgumentDescription> {
            { "texture"_s, "uint32_t"_s },
        };
    case MessageName::RemoteGraphicsContextGL_CullFace:
        return Vector<ArgumentDescription> {
            { "mode"_s, "uint32_t"_s },
        };
    case MessageName::RemoteGraphicsContextGL_DeleteBuffer:
        return Vector<ArgumentDescription> {
            { "arg0"_s, "uint32_t"_s },
        };
    case MessageName::RemoteGraphicsContextGL_DeleteFramebuffer:
        return Vector<ArgumentDescription> {
            { "arg0"_s, "uint32_t"_s },
        };
    case MessageName::RemoteGraphicsContextGL_DeleteProgram:
        return Vector<ArgumentDescription> {
            { "arg0"_s, "uint32_t"_s },
        };
    case MessageName::RemoteGraphicsContextGL_DeleteRenderbuffer:
        return Vector<ArgumentDescription> {
            { "arg0"_s, "uint32_t"_s },
        };
    case MessageName::RemoteGraphicsContextGL_DeleteShader:
        return Vector<ArgumentDescription> {
            { "arg0"_s, "uint32_t"_s },
        };
    case MessageName::RemoteGraphicsContextGL_DeleteTexture:
        return Vector<ArgumentDescription> {
            { "arg0"_s, "uint32_t"_s },
        };
    case MessageName::RemoteGraphicsContextGL_DepthFunc:
        return Vector<ArgumentDescription> {
            { "func"_s, "uint32_t"_s },
        };
    case MessageName::RemoteGraphicsContextGL_DepthMask:
        return Vector<ArgumentDescription> {
            { "flag"_s, "bool"_s },
        };
    case MessageName::RemoteGraphicsContextGL_DepthRange:
        return Vector<ArgumentDescription> {
            { "zNear"_s, "float"_s },
            { "zFar"_s, "float"_s },
        };
    case MessageName::RemoteGraphicsContextGL_DetachShader:
        return Vector<ArgumentDescription> {
            { "arg0"_s, "uint32_t"_s },
            { "arg1"_s, "uint32_t"_s },
        };
    case MessageName::RemoteGraphicsContextGL_Disable:
        return Vector<ArgumentDescription> {
            { "cap"_s, "uint32_t"_s },
        };
    case MessageName::RemoteGraphicsContextGL_DisableVertexAttribArray:
        return Vector<ArgumentDescription> {
            { "index"_s, "uint32_t"_s },
        };
    case MessageName::RemoteGraphicsContextGL_DrawArrays:
        return Vector<ArgumentDescription> {
            { "mode"_s, "uint32_t"_s },
            { "first"_s, "int32_t"_s },
            { "count"_s, "int32_t"_s },
        };
    case MessageName::RemoteGraphicsContextGL_DrawElements:
        return Vector<ArgumentDescription> {
            { "mode"_s, "uint32_t"_s },
            { "count"_s, "int32_t"_s },
            { "type"_s, "uint32_t"_s },
            { "offset"_s, "uint64_t"_s },
        };
    case MessageName::RemoteGraphicsContextGL_Enable:
        return Vector<ArgumentDescription> {
            { "cap"_s, "uint32_t"_s },
        };
    case MessageName::RemoteGraphicsContextGL_EnableVertexAttribArray:
        return Vector<ArgumentDescription> {
            { "index"_s, "uint32_t"_s },
        };
    case MessageName::RemoteGraphicsContextGL_Finish:
        return Vector<ArgumentDescription> { };
    case MessageName::RemoteGraphicsContextGL_Flush:
        return Vector<ArgumentDescription> { };
    case MessageName::RemoteGraphicsContextGL_FramebufferRenderbuffer:
        return Vector<ArgumentDescription> {
            { "target"_s, "uint32_t"_s },
            { "attachment"_s, "uint32_t"_s },
            { "renderbuffertarget"_s, "uint32_t"_s },
            { "arg3"_s, "uint32_t"_s },
        };
    case MessageName::RemoteGraphicsContextGL_FramebufferTexture2D:
        return Vector<ArgumentDescription> {
            { "target"_s, "uint32_t"_s },
            { "attachment"_s, "uint32_t"_s },
            { "textarget"_s, "uint32_t"_s },
            { "arg3"_s, "uint32_t"_s },
            { "level"_s, "int32_t"_s },
        };
    case MessageName::RemoteGraphicsContextGL_FrontFace:
        return Vector<ArgumentDescription> {
            { "mode"_s, "uint32_t"_s },
        };
    case MessageName::RemoteGraphicsContextGL_GenerateMipmap:
        return Vector<ArgumentDescription> {
            { "target"_s, "uint32_t"_s },
        };
    case MessageName::RemoteGraphicsContextGL_GetActiveAttrib:
        return Vector<ArgumentDescription> {
            { "program"_s, "uint32_t"_s },
            { "index"_s, "uint32_t"_s },
        };
    case MessageName::RemoteGraphicsContextGL_GetActiveUniform:
        return Vector<ArgumentDescription> {
            { "program"_s, "uint32_t"_s },
            { "index"_s, "uint32_t"_s },
        };
    case MessageName::RemoteGraphicsContextGL_GetAttribLocation:
        return Vector<ArgumentDescription> {
            { "arg0"_s, "uint32_t"_s },
            { "name"_s, "String"_s },
        };
    case MessageName::RemoteGraphicsContextGL_GetBufferParameteri:
        return Vector<ArgumentDescription> {
            { "target"_s, "uint32_t"_s },
            { "pname"_s, "uint32_t"_s },
        };
    case MessageName::RemoteGraphicsContextGL_GetString:
        return Vector<ArgumentDescription> {
            { "name"_s, "uint32_t"_s },
        };
    case MessageName::RemoteGraphicsContextGL_GetFloatv:
        return Vector<ArgumentDescription> {
            { "pname"_s, "uint32_t"_s },
            { "valueSize"_s, "uint64_t"_s },
        };
    case MessageName::RemoteGraphicsContextGL_GetIntegerv:
        return Vector<ArgumentDescription> {
            { "pname"_s, "uint32_t"_s },
            { "valueSize"_s, "uint64_t"_s },
        };
    case MessageName::RemoteGraphicsContextGL_GetIntegeri_v:
        return Vector<ArgumentDescription> {
            { "pname"_s, "uint32_t"_s },
            { "index"_s, "uint32_t"_s },
        };
    case MessageName::RemoteGraphicsContextGL_GetInteger64:
        return Vector<ArgumentDescription> {
            { "pname"_s, "uint32_t"_s },
        };
    case MessageName::RemoteGraphicsContextGL_GetInteger64i:
        return Vector<ArgumentDescription> {
            { "pname"_s, "uint32_t"_s },
            { "index"_s, "uint32_t"_s },
        };
    case MessageName::RemoteGraphicsContextGL_GetProgrami:
        return Vector<ArgumentDescription> {
            { "program"_s, "uint32_t"_s },
            { "pname"_s, "uint32_t"_s },
        };
    case MessageName::RemoteGraphicsContextGL_GetBooleanv:
        return Vector<ArgumentDescription> {
            { "pname"_s, "uint32_t"_s },
            { "valueSize"_s, "uint64_t"_s },
        };
    case MessageName::RemoteGraphicsContextGL_GetFramebufferAttachmentParameteri:
        return Vector<ArgumentDescription> {
            { "target"_s, "uint32_t"_s },
            { "attachment"_s, "uint32_t"_s },
            { "pname"_s, "uint32_t"_s },
        };
    case MessageName::RemoteGraphicsContextGL_GetProgramInfoLog:
        return Vector<ArgumentDescription> {
            { "arg0"_s, "uint32_t"_s },
        };
    case MessageName::RemoteGraphicsContextGL_GetRenderbufferParameteri:
        return Vector<ArgumentDescription> {
            { "target"_s, "uint32_t"_s },
            { "pname"_s, "uint32_t"_s },
        };
    case MessageName::RemoteGraphicsContextGL_GetShaderi:
        return Vector<ArgumentDescription> {
            { "arg0"_s, "uint32_t"_s },
            { "pname"_s, "uint32_t"_s },
        };
    case MessageName::RemoteGraphicsContextGL_GetShaderInfoLog:
        return Vector<ArgumentDescription> {
            { "arg0"_s, "uint32_t"_s },
        };
    case MessageName::RemoteGraphicsContextGL_GetShaderPrecisionFormat:
        return Vector<ArgumentDescription> {
            { "shaderType"_s, "uint32_t"_s },
            { "precisionType"_s, "uint32_t"_s },
        };
    case MessageName::RemoteGraphicsContextGL_GetShaderSource:
        return Vector<ArgumentDescription> {
            { "arg0"_s, "uint32_t"_s },
        };
    case MessageName::RemoteGraphicsContextGL_GetTexParameterf:
        return Vector<ArgumentDescription> {
            { "target"_s, "uint32_t"_s },
            { "pname"_s, "uint32_t"_s },
        };
    case MessageName::RemoteGraphicsContextGL_GetTexParameteri:
        return Vector<ArgumentDescription> {
            { "target"_s, "uint32_t"_s },
            { "pname"_s, "uint32_t"_s },
        };
    case MessageName::RemoteGraphicsContextGL_GetUniformfv:
        return Vector<ArgumentDescription> {
            { "program"_s, "uint32_t"_s },
            { "location"_s, "int32_t"_s },
            { "valueSize"_s, "uint64_t"_s },
        };
    case MessageName::RemoteGraphicsContextGL_GetUniformiv:
        return Vector<ArgumentDescription> {
            { "program"_s, "uint32_t"_s },
            { "location"_s, "int32_t"_s },
            { "valueSize"_s, "uint64_t"_s },
        };
    case MessageName::RemoteGraphicsContextGL_GetUniformuiv:
        return Vector<ArgumentDescription> {
            { "program"_s, "uint32_t"_s },
            { "location"_s, "int32_t"_s },
            { "valueSize"_s, "uint64_t"_s },
        };
    case MessageName::RemoteGraphicsContextGL_GetUniformLocation:
        return Vector<ArgumentDescription> {
            { "arg0"_s, "uint32_t"_s },
            { "name"_s, "String"_s },
        };
    case MessageName::RemoteGraphicsContextGL_GetVertexAttribOffset:
        return Vector<ArgumentDescription> {
            { "index"_s, "uint32_t"_s },
            { "pname"_s, "uint32_t"_s },
        };
    case MessageName::RemoteGraphicsContextGL_Hint:
        return Vector<ArgumentDescription> {
            { "target"_s, "uint32_t"_s },
            { "mode"_s, "uint32_t"_s },
        };
    case MessageName::RemoteGraphicsContextGL_IsBuffer:
        return Vector<ArgumentDescription> {
            { "arg0"_s, "uint32_t"_s },
        };
    case MessageName::RemoteGraphicsContextGL_IsEnabled:
        return Vector<ArgumentDescription> {
            { "cap"_s, "uint32_t"_s },
        };
    case MessageName::RemoteGraphicsContextGL_IsFramebuffer:
        return Vector<ArgumentDescription> {
            { "arg0"_s, "uint32_t"_s },
        };
    case MessageName::RemoteGraphicsContextGL_IsProgram:
        return Vector<ArgumentDescription> {
            { "arg0"_s, "uint32_t"_s },
        };
    case MessageName::RemoteGraphicsContextGL_IsRenderbuffer:
        return Vector<ArgumentDescription> {
            { "arg0"_s, "uint32_t"_s },
        };
    case MessageName::RemoteGraphicsContextGL_IsShader:
        return Vector<ArgumentDescription> {
            { "arg0"_s, "uint32_t"_s },
        };
    case MessageName::RemoteGraphicsContextGL_IsTexture:
        return Vector<ArgumentDescription> {
            { "arg0"_s, "uint32_t"_s },
        };
    case MessageName::RemoteGraphicsContextGL_LineWidth:
        return Vector<ArgumentDescription> {
            { "arg0"_s, "float"_s },
        };
    case MessageName::RemoteGraphicsContextGL_LinkProgram:
        return Vector<ArgumentDescription> {
            { "arg0"_s, "uint32_t"_s },
        };
    case MessageName::RemoteGraphicsContextGL_PixelStorei:
        return Vector<ArgumentDescription> {
            { "pname"_s, "uint32_t"_s },
            { "param"_s, "int32_t"_s },
        };
    case MessageName::RemoteGraphicsContextGL_PolygonOffset:
        return Vector<ArgumentDescription> {
            { "factor"_s, "float"_s },
            { "units"_s, "float"_s },
        };
    case MessageName::RemoteGraphicsContextGL_RenderbufferStorage:
        return Vector<ArgumentDescription> {
            { "target"_s, "uint32_t"_s },
            { "internalformat"_s, "uint32_t"_s },
            { "width"_s, "int32_t"_s },
            { "height"_s, "int32_t"_s },
        };
    case MessageName::RemoteGraphicsContextGL_SampleCoverage:
        return Vector<ArgumentDescription> {
            { "value"_s, "float"_s },
            { "invert"_s, "bool"_s },
        };
    case MessageName::RemoteGraphicsContextGL_Scissor:
        return Vector<ArgumentDescription> {
            { "x"_s, "int32_t"_s },
            { "y"_s, "int32_t"_s },
            { "width"_s, "int32_t"_s },
            { "height"_s, "int32_t"_s },
        };
    case MessageName::RemoteGraphicsContextGL_ShaderSource:
        return Vector<ArgumentDescription> {
            { "arg0"_s, "uint32_t"_s },
            { "arg1"_s, "String"_s },
        };
    case MessageName::RemoteGraphicsContextGL_StencilFunc:
        return Vector<ArgumentDescription> {
            { "func"_s, "uint32_t"_s },
            { "ref"_s, "int32_t"_s },
            { "mask"_s, "uint32_t"_s },
        };
    case MessageName::RemoteGraphicsContextGL_StencilFuncSeparate:
        return Vector<ArgumentDescription> {
            { "face"_s, "uint32_t"_s },
            { "func"_s, "uint32_t"_s },
            { "ref"_s, "int32_t"_s },
            { "mask"_s, "uint32_t"_s },
        };
    case MessageName::RemoteGraphicsContextGL_StencilMask:
        return Vector<ArgumentDescription> {
            { "mask"_s, "uint32_t"_s },
        };
    case MessageName::RemoteGraphicsContextGL_StencilMaskSeparate:
        return Vector<ArgumentDescription> {
            { "face"_s, "uint32_t"_s },
            { "mask"_s, "uint32_t"_s },
        };
    case MessageName::RemoteGraphicsContextGL_StencilOp:
        return Vector<ArgumentDescription> {
            { "fail"_s, "uint32_t"_s },
            { "zfail"_s, "uint32_t"_s },
            { "zpass"_s, "uint32_t"_s },
        };
    case MessageName::RemoteGraphicsContextGL_StencilOpSeparate:
        return Vector<ArgumentDescription> {
            { "face"_s, "uint32_t"_s },
            { "fail"_s, "uint32_t"_s },
            { "zfail"_s, "uint32_t"_s },
            { "zpass"_s, "uint32_t"_s },
        };
    case MessageName::RemoteGraphicsContextGL_TexParameterf:
        return Vector<ArgumentDescription> {
            { "target"_s, "uint32_t"_s },
            { "pname"_s, "uint32_t"_s },
            { "param"_s, "float"_s },
        };
    case MessageName::RemoteGraphicsContextGL_TexParameteri:
        return Vector<ArgumentDescription> {
            { "target"_s, "uint32_t"_s },
            { "pname"_s, "uint32_t"_s },
            { "param"_s, "int32_t"_s },
        };
    case MessageName::RemoteGraphicsContextGL_Uniform1f:
        return Vector<ArgumentDescription> {
            { "location"_s, "int32_t"_s },
            { "x"_s, "float"_s },
        };
    case MessageName::RemoteGraphicsContextGL_Uniform1fv:
        return Vector<ArgumentDescription> {
            { "location"_s, "int32_t"_s },
            { "v"_s, "std::span<const float>"_s },
        };
    case MessageName::RemoteGraphicsContextGL_Uniform1i:
        return Vector<ArgumentDescription> {
            { "location"_s, "int32_t"_s },
            { "x"_s, "int32_t"_s },
        };
    case MessageName::RemoteGraphicsContextGL_Uniform1iv:
        return Vector<ArgumentDescription> {
            { "location"_s, "int32_t"_s },
            { "v"_s, "std::span<const int32_t>"_s },
        };
    case MessageName::RemoteGraphicsContextGL_Uniform2f:
        return Vector<ArgumentDescription> {
            { "location"_s, "int32_t"_s },
            { "x"_s, "float"_s },
            { "y"_s, "float"_s },
        };
    case MessageName::RemoteGraphicsContextGL_Uniform2fv:
        return Vector<ArgumentDescription> {
            { "location"_s, "int32_t"_s },
            { "v"_s, "std::span<const float>"_s },
        };
    case MessageName::RemoteGraphicsContextGL_Uniform2i:
        return Vector<ArgumentDescription> {
            { "location"_s, "int32_t"_s },
            { "x"_s, "int32_t"_s },
            { "y"_s, "int32_t"_s },
        };
    case MessageName::RemoteGraphicsContextGL_Uniform2iv:
        return Vector<ArgumentDescription> {
            { "location"_s, "int32_t"_s },
            { "v"_s, "std::span<const int32_t>"_s },
        };
    case MessageName::RemoteGraphicsContextGL_Uniform3f:
        return Vector<ArgumentDescription> {
            { "location"_s, "int32_t"_s },
            { "x"_s, "float"_s },
            { "y"_s, "float"_s },
            { "z"_s, "float"_s },
        };
    case MessageName::RemoteGraphicsContextGL_Uniform3fv:
        return Vector<ArgumentDescription> {
            { "location"_s, "int32_t"_s },
            { "v"_s, "std::span<const float>"_s },
        };
    case MessageName::RemoteGraphicsContextGL_Uniform3i:
        return Vector<ArgumentDescription> {
            { "location"_s, "int32_t"_s },
            { "x"_s, "int32_t"_s },
            { "y"_s, "int32_t"_s },
            { "z"_s, "int32_t"_s },
        };
    case MessageName::RemoteGraphicsContextGL_Uniform3iv:
        return Vector<ArgumentDescription> {
            { "location"_s, "int32_t"_s },
            { "v"_s, "std::span<const int32_t>"_s },
        };
    case MessageName::RemoteGraphicsContextGL_Uniform4f:
        return Vector<ArgumentDescription> {
            { "location"_s, "int32_t"_s },
            { "x"_s, "float"_s },
            { "y"_s, "float"_s },
            { "z"_s, "float"_s },
            { "w"_s, "float"_s },
        };
    case MessageName::RemoteGraphicsContextGL_Uniform4fv:
        return Vector<ArgumentDescription> {
            { "location"_s, "int32_t"_s },
            { "v"_s, "std::span<const float>"_s },
        };
    case MessageName::RemoteGraphicsContextGL_Uniform4i:
        return Vector<ArgumentDescription> {
            { "location"_s, "int32_t"_s },
            { "x"_s, "int32_t"_s },
            { "y"_s, "int32_t"_s },
            { "z"_s, "int32_t"_s },
            { "w"_s, "int32_t"_s },
        };
    case MessageName::RemoteGraphicsContextGL_Uniform4iv:
        return Vector<ArgumentDescription> {
            { "location"_s, "int32_t"_s },
            { "v"_s, "std::span<const int32_t>"_s },
        };
    case MessageName::RemoteGraphicsContextGL_UniformMatrix2fv:
        return Vector<ArgumentDescription> {
            { "location"_s, "int32_t"_s },
            { "transpose"_s, "bool"_s },
            { "value"_s, "std::span<const float>"_s },
        };
    case MessageName::RemoteGraphicsContextGL_UniformMatrix3fv:
        return Vector<ArgumentDescription> {
            { "location"_s, "int32_t"_s },
            { "transpose"_s, "bool"_s },
            { "value"_s, "std::span<const float>"_s },
        };
    case MessageName::RemoteGraphicsContextGL_UniformMatrix4fv:
        return Vector<ArgumentDescription> {
            { "location"_s, "int32_t"_s },
            { "transpose"_s, "bool"_s },
            { "value"_s, "std::span<const float>"_s },
        };
    case MessageName::RemoteGraphicsContextGL_UseProgram:
        return Vector<ArgumentDescription> {
            { "arg0"_s, "uint32_t"_s },
        };
    case MessageName::RemoteGraphicsContextGL_ValidateProgram:
        return Vector<ArgumentDescription> {
            { "arg0"_s, "uint32_t"_s },
        };
    case MessageName::RemoteGraphicsContextGL_VertexAttrib1f:
        return Vector<ArgumentDescription> {
            { "index"_s, "uint32_t"_s },
            { "x"_s, "float"_s },
        };
    case MessageName::RemoteGraphicsContextGL_VertexAttrib1fv:
        return Vector<ArgumentDescription> {
            { "index"_s, "uint32_t"_s },
            { "values"_s, "std::span<const float, 1>"_s },
        };
    case MessageName::RemoteGraphicsContextGL_VertexAttrib2f:
        return Vector<ArgumentDescription> {
            { "index"_s, "uint32_t"_s },
            { "x"_s, "float"_s },
            { "y"_s, "float"_s },
        };
    case MessageName::RemoteGraphicsContextGL_VertexAttrib2fv:
        return Vector<ArgumentDescription> {
            { "index"_s, "uint32_t"_s },
            { "values"_s, "std::span<const float, 2>"_s },
        };
    case MessageName::RemoteGraphicsContextGL_VertexAttrib3f:
        return Vector<ArgumentDescription> {
            { "index"_s, "uint32_t"_s },
            { "x"_s, "float"_s },
            { "y"_s, "float"_s },
            { "z"_s, "float"_s },
        };
    case MessageName::RemoteGraphicsContextGL_VertexAttrib3fv:
        return Vector<ArgumentDescription> {
            { "index"_s, "uint32_t"_s },
            { "values"_s, "std::span<const float, 3>"_s },
        };
    case MessageName::RemoteGraphicsContextGL_VertexAttrib4f:
        return Vector<ArgumentDescription> {
            { "index"_s, "uint32_t"_s },
            { "x"_s, "float"_s },
            { "y"_s, "float"_s },
            { "z"_s, "float"_s },
            { "w"_s, "float"_s },
        };
    case MessageName::RemoteGraphicsContextGL_VertexAttrib4fv:
        return Vector<ArgumentDescription> {
            { "index"_s, "uint32_t"_s },
            { "values"_s, "std::span<const float, 4>"_s },
        };
    case MessageName::RemoteGraphicsContextGL_VertexAttribPointer:
        return Vector<ArgumentDescription> {
            { "index"_s, "uint32_t"_s },
            { "size"_s, "int32_t"_s },
            { "type"_s, "uint32_t"_s },
            { "normalized"_s, "bool"_s },
            { "stride"_s, "int32_t"_s },
            { "offset"_s, "uint64_t"_s },
        };
    case MessageName::RemoteGraphicsContextGL_Viewport:
        return Vector<ArgumentDescription> {
            { "x"_s, "int32_t"_s },
            { "y"_s, "int32_t"_s },
            { "width"_s, "int32_t"_s },
            { "height"_s, "int32_t"_s },
        };
    case MessageName::RemoteGraphicsContextGL_BufferData0:
        return Vector<ArgumentDescription> {
            { "target"_s, "uint32_t"_s },
            { "arg1"_s, "uint64_t"_s },
            { "usage"_s, "uint32_t"_s },
        };
    case MessageName::RemoteGraphicsContextGL_BufferData1:
        return Vector<ArgumentDescription> {
            { "target"_s, "uint32_t"_s },
            { "data"_s, "std::span<const uint8_t>"_s },
            { "usage"_s, "uint32_t"_s },
        };
    case MessageName::RemoteGraphicsContextGL_BufferSubData:
        return Vector<ArgumentDescription> {
            { "target"_s, "uint32_t"_s },
            { "offset"_s, "uint64_t"_s },
            { "data"_s, "std::span<const uint8_t>"_s },
        };
    case MessageName::RemoteGraphicsContextGL_ReadPixelsBufferObject:
        return Vector<ArgumentDescription> {
            { "arg0"_s, "WebCore::IntRect"_s },
            { "format"_s, "uint32_t"_s },
            { "type"_s, "uint32_t"_s },
            { "offset"_s, "uint64_t"_s },
            { "alignment"_s, "int32_t"_s },
            { "rowLength"_s, "int32_t"_s },
        };
    case MessageName::RemoteGraphicsContextGL_TexImage2D0:
        return Vector<ArgumentDescription> {
            { "target"_s, "uint32_t"_s },
            { "level"_s, "int32_t"_s },
            { "internalformat"_s, "uint32_t"_s },
            { "width"_s, "int32_t"_s },
            { "height"_s, "int32_t"_s },
            { "border"_s, "int32_t"_s },
            { "format"_s, "uint32_t"_s },
            { "type"_s, "uint32_t"_s },
            { "pixels"_s, "std::span<const uint8_t>"_s },
        };
    case MessageName::RemoteGraphicsContextGL_TexImage2D1:
        return Vector<ArgumentDescription> {
            { "target"_s, "uint32_t"_s },
            { "level"_s, "int32_t"_s },
            { "internalformat"_s, "uint32_t"_s },
            { "width"_s, "int32_t"_s },
            { "height"_s, "int32_t"_s },
            { "border"_s, "int32_t"_s },
            { "format"_s, "uint32_t"_s },
            { "type"_s, "uint32_t"_s },
            { "offset"_s, "uint64_t"_s },
        };
    case MessageName::RemoteGraphicsContextGL_TexSubImage2D0:
        return Vector<ArgumentDescription> {
            { "target"_s, "uint32_t"_s },
            { "level"_s, "int32_t"_s },
            { "xoffset"_s, "int32_t"_s },
            { "yoffset"_s, "int32_t"_s },
            { "width"_s, "int32_t"_s },
            { "height"_s, "int32_t"_s },
            { "format"_s, "uint32_t"_s },
            { "type"_s, "uint32_t"_s },
            { "pixels"_s, "std::span<const uint8_t>"_s },
        };
    case MessageName::RemoteGraphicsContextGL_TexSubImage2D1:
        return Vector<ArgumentDescription> {
            { "target"_s, "uint32_t"_s },
            { "level"_s, "int32_t"_s },
            { "xoffset"_s, "int32_t"_s },
            { "yoffset"_s, "int32_t"_s },
            { "width"_s, "int32_t"_s },
            { "height"_s, "int32_t"_s },
            { "format"_s, "uint32_t"_s },
            { "type"_s, "uint32_t"_s },
            { "offset"_s, "uint64_t"_s },
        };
    case MessageName::RemoteGraphicsContextGL_CompressedTexImage2D0:
        return Vector<ArgumentDescription> {
            { "target"_s, "uint32_t"_s },
            { "level"_s, "int32_t"_s },
            { "internalformat"_s, "uint32_t"_s },
            { "width"_s, "int32_t"_s },
            { "height"_s, "int32_t"_s },
            { "border"_s, "int32_t"_s },
            { "imageSize"_s, "int32_t"_s },
            { "data"_s, "std::span<const uint8_t>"_s },
        };
    case MessageName::RemoteGraphicsContextGL_CompressedTexImage2D1:
        return Vector<ArgumentDescription> {
            { "target"_s, "uint32_t"_s },
            { "level"_s, "int32_t"_s },
            { "internalformat"_s, "uint32_t"_s },
            { "width"_s, "int32_t"_s },
            { "height"_s, "int32_t"_s },
            { "border"_s, "int32_t"_s },
            { "imageSize"_s, "int32_t"_s },
            { "offset"_s, "uint64_t"_s },
        };
    case MessageName::RemoteGraphicsContextGL_CompressedTexSubImage2D0:
        return Vector<ArgumentDescription> {
            { "target"_s, "uint32_t"_s },
            { "level"_s, "int32_t"_s },
            { "xoffset"_s, "int32_t"_s },
            { "yoffset"_s, "int32_t"_s },
            { "width"_s, "int32_t"_s },
            { "height"_s, "int32_t"_s },
            { "format"_s, "uint32_t"_s },
            { "imageSize"_s, "int32_t"_s },
            { "data"_s, "std::span<const uint8_t>"_s },
        };
    case MessageName::RemoteGraphicsContextGL_CompressedTexSubImage2D1:
        return Vector<ArgumentDescription> {
            { "target"_s, "uint32_t"_s },
            { "level"_s, "int32_t"_s },
            { "xoffset"_s, "int32_t"_s },
            { "yoffset"_s, "int32_t"_s },
            { "width"_s, "int32_t"_s },
            { "height"_s, "int32_t"_s },
            { "format"_s, "uint32_t"_s },
            { "imageSize"_s, "int32_t"_s },
            { "offset"_s, "uint64_t"_s },
        };
    case MessageName::RemoteGraphicsContextGL_DrawArraysInstanced:
        return Vector<ArgumentDescription> {
            { "mode"_s, "uint32_t"_s },
            { "first"_s, "int32_t"_s },
            { "count"_s, "int32_t"_s },
            { "primcount"_s, "int32_t"_s },
        };
    case MessageName::RemoteGraphicsContextGL_DrawElementsInstanced:
        return Vector<ArgumentDescription> {
            { "mode"_s, "uint32_t"_s },
            { "count"_s, "int32_t"_s },
            { "type"_s, "uint32_t"_s },
            { "offset"_s, "uint64_t"_s },
            { "primcount"_s, "int32_t"_s },
        };
    case MessageName::RemoteGraphicsContextGL_VertexAttribDivisor:
        return Vector<ArgumentDescription> {
            { "index"_s, "uint32_t"_s },
            { "divisor"_s, "uint32_t"_s },
        };
    case MessageName::RemoteGraphicsContextGL_CreateVertexArray:
        return Vector<ArgumentDescription> {
            { "vertexArray"_s, "uint32_t"_s },
        };
    case MessageName::RemoteGraphicsContextGL_DeleteVertexArray:
        return Vector<ArgumentDescription> {
            { "arg0"_s, "uint32_t"_s },
        };
    case MessageName::RemoteGraphicsContextGL_IsVertexArray:
        return Vector<ArgumentDescription> {
            { "arg0"_s, "uint32_t"_s },
        };
    case MessageName::RemoteGraphicsContextGL_BindVertexArray:
        return Vector<ArgumentDescription> {
            { "arg0"_s, "uint32_t"_s },
        };
    case MessageName::RemoteGraphicsContextGL_CopyBufferSubData:
        return Vector<ArgumentDescription> {
            { "readTarget"_s, "uint32_t"_s },
            { "writeTarget"_s, "uint32_t"_s },
            { "readOffset"_s, "uint64_t"_s },
            { "writeOffset"_s, "uint64_t"_s },
            { "arg4"_s, "uint64_t"_s },
        };
    case MessageName::RemoteGraphicsContextGL_BlitFramebuffer:
        return Vector<ArgumentDescription> {
            { "srcX0"_s, "int32_t"_s },
            { "srcY0"_s, "int32_t"_s },
            { "srcX1"_s, "int32_t"_s },
            { "srcY1"_s, "int32_t"_s },
            { "dstX0"_s, "int32_t"_s },
            { "dstY0"_s, "int32_t"_s },
            { "dstX1"_s, "int32_t"_s },
            { "dstY1"_s, "int32_t"_s },
            { "mask"_s, "uint32_t"_s },
            { "filter"_s, "uint32_t"_s },
        };
    case MessageName::RemoteGraphicsContextGL_FramebufferTextureLayer:
        return Vector<ArgumentDescription> {
            { "target"_s, "uint32_t"_s },
            { "attachment"_s, "uint32_t"_s },
            { "texture"_s, "uint32_t"_s },
            { "level"_s, "int32_t"_s },
            { "layer"_s, "int32_t"_s },
        };
    case MessageName::RemoteGraphicsContextGL_ReadBuffer:
        return Vector<ArgumentDescription> {
            { "src"_s, "uint32_t"_s },
        };
    case MessageName::RemoteGraphicsContextGL_RenderbufferStorageMultisample:
        return Vector<ArgumentDescription> {
            { "target"_s, "uint32_t"_s },
            { "samples"_s, "int32_t"_s },
            { "internalformat"_s, "uint32_t"_s },
            { "width"_s, "int32_t"_s },
            { "height"_s, "int32_t"_s },
        };
    case MessageName::RemoteGraphicsContextGL_TexStorage2D:
        return Vector<ArgumentDescription> {
            { "target"_s, "uint32_t"_s },
            { "levels"_s, "int32_t"_s },
            { "internalformat"_s, "uint32_t"_s },
            { "width"_s, "int32_t"_s },
            { "height"_s, "int32_t"_s },
        };
    case MessageName::RemoteGraphicsContextGL_TexStorage3D:
        return Vector<ArgumentDescription> {
            { "target"_s, "uint32_t"_s },
            { "levels"_s, "int32_t"_s },
            { "internalformat"_s, "uint32_t"_s },
            { "width"_s, "int32_t"_s },
            { "height"_s, "int32_t"_s },
            { "depth"_s, "int32_t"_s },
        };
    case MessageName::RemoteGraphicsContextGL_TexImage3D0:
        return Vector<ArgumentDescription> {
            { "target"_s, "uint32_t"_s },
            { "level"_s, "int32_t"_s },
            { "internalformat"_s, "int32_t"_s },
            { "width"_s, "int32_t"_s },
            { "height"_s, "int32_t"_s },
            { "depth"_s, "int32_t"_s },
            { "border"_s, "int32_t"_s },
            { "format"_s, "uint32_t"_s },
            { "type"_s, "uint32_t"_s },
            { "pixels"_s, "std::span<const uint8_t>"_s },
        };
    case MessageName::RemoteGraphicsContextGL_TexImage3D1:
        return Vector<ArgumentDescription> {
            { "target"_s, "uint32_t"_s },
            { "level"_s, "int32_t"_s },
            { "internalformat"_s, "int32_t"_s },
            { "width"_s, "int32_t"_s },
            { "height"_s, "int32_t"_s },
            { "depth"_s, "int32_t"_s },
            { "border"_s, "int32_t"_s },
            { "format"_s, "uint32_t"_s },
            { "type"_s, "uint32_t"_s },
            { "offset"_s, "uint64_t"_s },
        };
    case MessageName::RemoteGraphicsContextGL_TexSubImage3D0:
        return Vector<ArgumentDescription> {
            { "target"_s, "uint32_t"_s },
            { "level"_s, "int32_t"_s },
            { "xoffset"_s, "int32_t"_s },
            { "yoffset"_s, "int32_t"_s },
            { "zoffset"_s, "int32_t"_s },
            { "width"_s, "int32_t"_s },
            { "height"_s, "int32_t"_s },
            { "depth"_s, "int32_t"_s },
            { "format"_s, "uint32_t"_s },
            { "type"_s, "uint32_t"_s },
            { "pixels"_s, "std::span<const uint8_t>"_s },
        };
    case MessageName::RemoteGraphicsContextGL_TexSubImage3D1:
        return Vector<ArgumentDescription> {
            { "target"_s, "uint32_t"_s },
            { "level"_s, "int32_t"_s },
            { "xoffset"_s, "int32_t"_s },
            { "yoffset"_s, "int32_t"_s },
            { "zoffset"_s, "int32_t"_s },
            { "width"_s, "int32_t"_s },
            { "height"_s, "int32_t"_s },
            { "depth"_s, "int32_t"_s },
            { "format"_s, "uint32_t"_s },
            { "type"_s, "uint32_t"_s },
            { "offset"_s, "uint64_t"_s },
        };
    case MessageName::RemoteGraphicsContextGL_CopyTexSubImage3D:
        return Vector<ArgumentDescription> {
            { "target"_s, "uint32_t"_s },
            { "level"_s, "int32_t"_s },
            { "xoffset"_s, "int32_t"_s },
            { "yoffset"_s, "int32_t"_s },
            { "zoffset"_s, "int32_t"_s },
            { "x"_s, "int32_t"_s },
            { "y"_s, "int32_t"_s },
            { "width"_s, "int32_t"_s },
            { "height"_s, "int32_t"_s },
        };
    case MessageName::RemoteGraphicsContextGL_CompressedTexImage3D0:
        return Vector<ArgumentDescription> {
            { "target"_s, "uint32_t"_s },
            { "level"_s, "int32_t"_s },
            { "internalformat"_s, "uint32_t"_s },
            { "width"_s, "int32_t"_s },
            { "height"_s, "int32_t"_s },
            { "depth"_s, "int32_t"_s },
            { "border"_s, "int32_t"_s },
            { "imageSize"_s, "int32_t"_s },
            { "data"_s, "std::span<const uint8_t>"_s },
        };
    case MessageName::RemoteGraphicsContextGL_CompressedTexImage3D1:
        return Vector<ArgumentDescription> {
            { "target"_s, "uint32_t"_s },
            { "level"_s, "int32_t"_s },
            { "internalformat"_s, "uint32_t"_s },
            { "width"_s, "int32_t"_s },
            { "height"_s, "int32_t"_s },
            { "depth"_s, "int32_t"_s },
            { "border"_s, "int32_t"_s },
            { "imageSize"_s, "int32_t"_s },
            { "offset"_s, "uint64_t"_s },
        };
    case MessageName::RemoteGraphicsContextGL_CompressedTexSubImage3D0:
        return Vector<ArgumentDescription> {
            { "target"_s, "uint32_t"_s },
            { "level"_s, "int32_t"_s },
            { "xoffset"_s, "int32_t"_s },
            { "yoffset"_s, "int32_t"_s },
            { "zoffset"_s, "int32_t"_s },
            { "width"_s, "int32_t"_s },
            { "height"_s, "int32_t"_s },
            { "depth"_s, "int32_t"_s },
            { "format"_s, "uint32_t"_s },
            { "imageSize"_s, "int32_t"_s },
            { "data"_s, "std::span<const uint8_t>"_s },
        };
    case MessageName::RemoteGraphicsContextGL_CompressedTexSubImage3D1:
        return Vector<ArgumentDescription> {
            { "target"_s, "uint32_t"_s },
            { "level"_s, "int32_t"_s },
            { "xoffset"_s, "int32_t"_s },
            { "yoffset"_s, "int32_t"_s },
            { "zoffset"_s, "int32_t"_s },
            { "width"_s, "int32_t"_s },
            { "height"_s, "int32_t"_s },
            { "depth"_s, "int32_t"_s },
            { "format"_s, "uint32_t"_s },
            { "imageSize"_s, "int32_t"_s },
            { "offset"_s, "uint64_t"_s },
        };
    case MessageName::RemoteGraphicsContextGL_GetFragDataLocation:
        return Vector<ArgumentDescription> {
            { "program"_s, "uint32_t"_s },
            { "name"_s, "String"_s },
        };
    case MessageName::RemoteGraphicsContextGL_Uniform1ui:
        return Vector<ArgumentDescription> {
            { "location"_s, "int32_t"_s },
            { "v0"_s, "uint32_t"_s },
        };
    case MessageName::RemoteGraphicsContextGL_Uniform2ui:
        return Vector<ArgumentDescription> {
            { "location"_s, "int32_t"_s },
            { "v0"_s, "uint32_t"_s },
            { "v1"_s, "uint32_t"_s },
        };
    case MessageName::RemoteGraphicsContextGL_Uniform3ui:
        return Vector<ArgumentDescription> {
            { "location"_s, "int32_t"_s },
            { "v0"_s, "uint32_t"_s },
            { "v1"_s, "uint32_t"_s },
            { "v2"_s, "uint32_t"_s },
        };
    case MessageName::RemoteGraphicsContextGL_Uniform4ui:
        return Vector<ArgumentDescription> {
            { "location"_s, "int32_t"_s },
            { "v0"_s, "uint32_t"_s },
            { "v1"_s, "uint32_t"_s },
            { "v2"_s, "uint32_t"_s },
            { "v3"_s, "uint32_t"_s },
        };
    case MessageName::RemoteGraphicsContextGL_Uniform1uiv:
        return Vector<ArgumentDescription> {
            { "location"_s, "int32_t"_s },
            { "data"_s, "std::span<const uint32_t>"_s },
        };
    case MessageName::RemoteGraphicsContextGL_Uniform2uiv:
        return Vector<ArgumentDescription> {
            { "location"_s, "int32_t"_s },
            { "data"_s, "std::span<const uint32_t>"_s },
        };
    case MessageName::RemoteGraphicsContextGL_Uniform3uiv:
        return Vector<ArgumentDescription> {
            { "location"_s, "int32_t"_s },
            { "data"_s, "std::span<const uint32_t>"_s },
        };
    case MessageName::RemoteGraphicsContextGL_Uniform4uiv:
        return Vector<ArgumentDescription> {
            { "location"_s, "int32_t"_s },
            { "data"_s, "std::span<const uint32_t>"_s },
        };
    case MessageName::RemoteGraphicsContextGL_UniformMatrix2x3fv:
        return Vector<ArgumentDescription> {
            { "location"_s, "int32_t"_s },
            { "transpose"_s, "bool"_s },
            { "data"_s, "std::span<const float>"_s },
        };
    case MessageName::RemoteGraphicsContextGL_UniformMatrix3x2fv:
        return Vector<ArgumentDescription> {
            { "location"_s, "int32_t"_s },
            { "transpose"_s, "bool"_s },
            { "data"_s, "std::span<const float>"_s },
        };
    case MessageName::RemoteGraphicsContextGL_UniformMatrix2x4fv:
        return Vector<ArgumentDescription> {
            { "location"_s, "int32_t"_s },
            { "transpose"_s, "bool"_s },
            { "data"_s, "std::span<const float>"_s },
        };
    case MessageName::RemoteGraphicsContextGL_UniformMatrix4x2fv:
        return Vector<ArgumentDescription> {
            { "location"_s, "int32_t"_s },
            { "transpose"_s, "bool"_s },
            { "data"_s, "std::span<const float>"_s },
        };
    case MessageName::RemoteGraphicsContextGL_UniformMatrix3x4fv:
        return Vector<ArgumentDescription> {
            { "location"_s, "int32_t"_s },
            { "transpose"_s, "bool"_s },
            { "data"_s, "std::span<const float>"_s },
        };
    case MessageName::RemoteGraphicsContextGL_UniformMatrix4x3fv:
        return Vector<ArgumentDescription> {
            { "location"_s, "int32_t"_s },
            { "transpose"_s, "bool"_s },
            { "data"_s, "std::span<const float>"_s },
        };
    case MessageName::RemoteGraphicsContextGL_VertexAttribI4i:
        return Vector<ArgumentDescription> {
            { "index"_s, "uint32_t"_s },
            { "x"_s, "int32_t"_s },
            { "y"_s, "int32_t"_s },
            { "z"_s, "int32_t"_s },
            { "w"_s, "int32_t"_s },
        };
    case MessageName::RemoteGraphicsContextGL_VertexAttribI4iv:
        return Vector<ArgumentDescription> {
            { "index"_s, "uint32_t"_s },
            { "values"_s, "std::span<const int32_t, 4>"_s },
        };
    case MessageName::RemoteGraphicsContextGL_VertexAttribI4ui:
        return Vector<ArgumentDescription> {
            { "index"_s, "uint32_t"_s },
            { "x"_s, "uint32_t"_s },
            { "y"_s, "uint32_t"_s },
            { "z"_s, "uint32_t"_s },
            { "w"_s, "uint32_t"_s },
        };
    case MessageName::RemoteGraphicsContextGL_VertexAttribI4uiv:
        return Vector<ArgumentDescription> {
            { "index"_s, "uint32_t"_s },
            { "values"_s, "std::span<const uint32_t, 4>"_s },
        };
    case MessageName::RemoteGraphicsContextGL_VertexAttribIPointer:
        return Vector<ArgumentDescription> {
            { "index"_s, "uint32_t"_s },
            { "size"_s, "int32_t"_s },
            { "type"_s, "uint32_t"_s },
            { "stride"_s, "int32_t"_s },
            { "offset"_s, "uint64_t"_s },
        };
    case MessageName::RemoteGraphicsContextGL_DrawRangeElements:
        return Vector<ArgumentDescription> {
            { "mode"_s, "uint32_t"_s },
            { "start"_s, "uint32_t"_s },
            { "end"_s, "uint32_t"_s },
            { "count"_s, "int32_t"_s },
            { "type"_s, "uint32_t"_s },
            { "offset"_s, "uint64_t"_s },
        };
    case MessageName::RemoteGraphicsContextGL_ClearBufferiv:
        return Vector<ArgumentDescription> {
            { "buffer"_s, "uint32_t"_s },
            { "drawbuffer"_s, "int32_t"_s },
            { "values"_s, "std::span<const int32_t>"_s },
        };
    case MessageName::RemoteGraphicsContextGL_ClearBufferuiv:
        return Vector<ArgumentDescription> {
            { "buffer"_s, "uint32_t"_s },
            { "drawbuffer"_s, "int32_t"_s },
            { "values"_s, "std::span<const uint32_t>"_s },
        };
    case MessageName::RemoteGraphicsContextGL_ClearBufferfv:
        return Vector<ArgumentDescription> {
            { "buffer"_s, "uint32_t"_s },
            { "drawbuffer"_s, "int32_t"_s },
            { "values"_s, "std::span<const float>"_s },
        };
    case MessageName::RemoteGraphicsContextGL_ClearBufferfi:
        return Vector<ArgumentDescription> {
            { "buffer"_s, "uint32_t"_s },
            { "drawbuffer"_s, "int32_t"_s },
            { "depth"_s, "float"_s },
            { "stencil"_s, "int32_t"_s },
        };
    case MessageName::RemoteGraphicsContextGL_CreateQuery:
        return Vector<ArgumentDescription> {
            { "query"_s, "uint32_t"_s },
        };
    case MessageName::RemoteGraphicsContextGL_DeleteQuery:
        return Vector<ArgumentDescription> {
            { "query"_s, "uint32_t"_s },
        };
    case MessageName::RemoteGraphicsContextGL_IsQuery:
        return Vector<ArgumentDescription> {
            { "query"_s, "uint32_t"_s },
        };
    case MessageName::RemoteGraphicsContextGL_BeginQuery:
        return Vector<ArgumentDescription> {
            { "target"_s, "uint32_t"_s },
            { "query"_s, "uint32_t"_s },
        };
    case MessageName::RemoteGraphicsContextGL_EndQuery:
        return Vector<ArgumentDescription> {
            { "target"_s, "uint32_t"_s },
        };
    case MessageName::RemoteGraphicsContextGL_GetQuery:
        return Vector<ArgumentDescription> {
            { "target"_s, "uint32_t"_s },
            { "pname"_s, "uint32_t"_s },
        };
    case MessageName::RemoteGraphicsContextGL_GetQueryObjectui:
        return Vector<ArgumentDescription> {
            { "query"_s, "uint32_t"_s },
            { "pname"_s, "uint32_t"_s },
        };
    case MessageName::RemoteGraphicsContextGL_CreateSampler:
        return Vector<ArgumentDescription> {
            { "sampler"_s, "uint32_t"_s },
        };
    case MessageName::RemoteGraphicsContextGL_DeleteSampler:
        return Vector<ArgumentDescription> {
            { "sampler"_s, "uint32_t"_s },
        };
    case MessageName::RemoteGraphicsContextGL_IsSampler:
        return Vector<ArgumentDescription> {
            { "sampler"_s, "uint32_t"_s },
        };
    case MessageName::RemoteGraphicsContextGL_BindSampler:
        return Vector<ArgumentDescription> {
            { "unit"_s, "uint32_t"_s },
            { "sampler"_s, "uint32_t"_s },
        };
    case MessageName::RemoteGraphicsContextGL_SamplerParameteri:
        return Vector<ArgumentDescription> {
            { "sampler"_s, "uint32_t"_s },
            { "pname"_s, "uint32_t"_s },
            { "param"_s, "int32_t"_s },
        };
    case MessageName::RemoteGraphicsContextGL_SamplerParameterf:
        return Vector<ArgumentDescription> {
            { "sampler"_s, "uint32_t"_s },
            { "pname"_s, "uint32_t"_s },
            { "param"_s, "float"_s },
        };
    case MessageName::RemoteGraphicsContextGL_GetSamplerParameterf:
        return Vector<ArgumentDescription> {
            { "sampler"_s, "uint32_t"_s },
            { "pname"_s, "uint32_t"_s },
        };
    case MessageName::RemoteGraphicsContextGL_GetSamplerParameteri:
        return Vector<ArgumentDescription> {
            { "sampler"_s, "uint32_t"_s },
            { "pname"_s, "uint32_t"_s },
        };
    case MessageName::RemoteGraphicsContextGL_FenceSync:
        return Vector<ArgumentDescription> {
            { "condition"_s, "uint32_t"_s },
            { "flags"_s, "uint32_t"_s },
        };
    case MessageName::RemoteGraphicsContextGL_IsSync:
        return Vector<ArgumentDescription> {
            { "arg0"_s, "uint64_t"_s },
        };
    case MessageName::RemoteGraphicsContextGL_DeleteSync:
        return Vector<ArgumentDescription> {
            { "arg0"_s, "uint64_t"_s },
        };
    case MessageName::RemoteGraphicsContextGL_ClientWaitSync:
        return Vector<ArgumentDescription> {
            { "arg0"_s, "uint64_t"_s },
            { "flags"_s, "uint32_t"_s },
            { "timeout"_s, "uint64_t"_s },
        };
    case MessageName::RemoteGraphicsContextGL_WaitSync:
        return Vector<ArgumentDescription> {
            { "arg0"_s, "uint64_t"_s },
            { "flags"_s, "uint32_t"_s },
            { "timeout"_s, "int64_t"_s },
        };
    case MessageName::RemoteGraphicsContextGL_GetSynci:
        return Vector<ArgumentDescription> {
            { "arg0"_s, "uint64_t"_s },
            { "pname"_s, "uint32_t"_s },
        };
    case MessageName::RemoteGraphicsContextGL_CreateTransformFeedback:
        return Vector<ArgumentDescription> {
            { "transformFeedback"_s, "uint32_t"_s },
        };
    case MessageName::RemoteGraphicsContextGL_DeleteTransformFeedback:
        return Vector<ArgumentDescription> {
            { "id"_s, "uint32_t"_s },
        };
    case MessageName::RemoteGraphicsContextGL_IsTransformFeedback:
        return Vector<ArgumentDescription> {
            { "id"_s, "uint32_t"_s },
        };
    case MessageName::RemoteGraphicsContextGL_BindTransformFeedback:
        return Vector<ArgumentDescription> {
            { "target"_s, "uint32_t"_s },
            { "id"_s, "uint32_t"_s },
        };
    case MessageName::RemoteGraphicsContextGL_BeginTransformFeedback:
        return Vector<ArgumentDescription> {
            { "primitiveMode"_s, "uint32_t"_s },
        };
    case MessageName::RemoteGraphicsContextGL_EndTransformFeedback:
        return Vector<ArgumentDescription> { };
    case MessageName::RemoteGraphicsContextGL_TransformFeedbackVaryings:
        return Vector<ArgumentDescription> {
            { "program"_s, "uint32_t"_s },
            { "varyings"_s, "Vector<String>"_s },
            { "bufferMode"_s, "uint32_t"_s },
        };
    case MessageName::RemoteGraphicsContextGL_GetTransformFeedbackVarying:
        return Vector<ArgumentDescription> {
            { "program"_s, "uint32_t"_s },
            { "index"_s, "uint32_t"_s },
        };
    case MessageName::RemoteGraphicsContextGL_PauseTransformFeedback:
        return Vector<ArgumentDescription> { };
    case MessageName::RemoteGraphicsContextGL_ResumeTransformFeedback:
        return Vector<ArgumentDescription> { };
    case MessageName::RemoteGraphicsContextGL_BindBufferBase:
        return Vector<ArgumentDescription> {
            { "target"_s, "uint32_t"_s },
            { "index"_s, "uint32_t"_s },
            { "buffer"_s, "uint32_t"_s },
        };
    case MessageName::RemoteGraphicsContextGL_BindBufferRange:
        return Vector<ArgumentDescription> {
            { "target"_s, "uint32_t"_s },
            { "index"_s, "uint32_t"_s },
            { "buffer"_s, "uint32_t"_s },
            { "offset"_s, "uint64_t"_s },
            { "arg4"_s, "uint64_t"_s },
        };
    case MessageName::RemoteGraphicsContextGL_GetUniformIndices:
        return Vector<ArgumentDescription> {
            { "program"_s, "uint32_t"_s },
            { "uniformNames"_s, "Vector<String>"_s },
        };
    case MessageName::RemoteGraphicsContextGL_GetActiveUniforms:
        return Vector<ArgumentDescription> {
            { "program"_s, "uint32_t"_s },
            { "uniformIndices"_s, "Vector<uint32_t>"_s },
            { "pname"_s, "uint32_t"_s },
        };
    case MessageName::RemoteGraphicsContextGL_GetUniformBlockIndex:
        return Vector<ArgumentDescription> {
            { "program"_s, "uint32_t"_s },
            { "uniformBlockName"_s, "String"_s },
        };
    case MessageName::RemoteGraphicsContextGL_GetActiveUniformBlockName:
        return Vector<ArgumentDescription> {
            { "program"_s, "uint32_t"_s },
            { "uniformBlockIndex"_s, "uint32_t"_s },
        };
    case MessageName::RemoteGraphicsContextGL_UniformBlockBinding:
        return Vector<ArgumentDescription> {
            { "program"_s, "uint32_t"_s },
            { "uniformBlockIndex"_s, "uint32_t"_s },
            { "uniformBlockBinding"_s, "uint32_t"_s },
        };
    case MessageName::RemoteGraphicsContextGL_GetActiveUniformBlockiv:
        return Vector<ArgumentDescription> {
            { "program"_s, "uint32_t"_s },
            { "uniformBlockIndex"_s, "uint32_t"_s },
            { "pname"_s, "uint32_t"_s },
            { "paramsSize"_s, "uint64_t"_s },
        };
    case MessageName::RemoteGraphicsContextGL_GetTranslatedShaderSourceANGLE:
        return Vector<ArgumentDescription> {
            { "arg0"_s, "uint32_t"_s },
        };
    case MessageName::RemoteGraphicsContextGL_CreateQueryEXT:
        return Vector<ArgumentDescription> {
            { "queryEXT"_s, "uint32_t"_s },
        };
    case MessageName::RemoteGraphicsContextGL_DeleteQueryEXT:
        return Vector<ArgumentDescription> {
            { "query"_s, "uint32_t"_s },
        };
    case MessageName::RemoteGraphicsContextGL_IsQueryEXT:
        return Vector<ArgumentDescription> {
            { "query"_s, "uint32_t"_s },
        };
    case MessageName::RemoteGraphicsContextGL_BeginQueryEXT:
        return Vector<ArgumentDescription> {
            { "target"_s, "uint32_t"_s },
            { "query"_s, "uint32_t"_s },
        };
    case MessageName::RemoteGraphicsContextGL_EndQueryEXT:
        return Vector<ArgumentDescription> {
            { "target"_s, "uint32_t"_s },
        };
    case MessageName::RemoteGraphicsContextGL_QueryCounterEXT:
        return Vector<ArgumentDescription> {
            { "query"_s, "uint32_t"_s },
            { "target"_s, "uint32_t"_s },
        };
    case MessageName::RemoteGraphicsContextGL_GetQueryiEXT:
        return Vector<ArgumentDescription> {
            { "target"_s, "uint32_t"_s },
            { "pname"_s, "uint32_t"_s },
        };
    case MessageName::RemoteGraphicsContextGL_GetQueryObjectiEXT:
        return Vector<ArgumentDescription> {
            { "query"_s, "uint32_t"_s },
            { "pname"_s, "uint32_t"_s },
        };
    case MessageName::RemoteGraphicsContextGL_GetQueryObjectui64EXT:
        return Vector<ArgumentDescription> {
            { "query"_s, "uint32_t"_s },
            { "pname"_s, "uint32_t"_s },
        };
    case MessageName::RemoteGraphicsContextGL_GetInteger64EXT:
        return Vector<ArgumentDescription> {
            { "pname"_s, "uint32_t"_s },
        };
    case MessageName::RemoteGraphicsContextGL_EnableiOES:
        return Vector<ArgumentDescription> {
            { "target"_s, "uint32_t"_s },
            { "index"_s, "uint32_t"_s },
        };
    case MessageName::RemoteGraphicsContextGL_DisableiOES:
        return Vector<ArgumentDescription> {
            { "target"_s, "uint32_t"_s },
            { "index"_s, "uint32_t"_s },
        };
    case MessageName::RemoteGraphicsContextGL_BlendEquationiOES:
        return Vector<ArgumentDescription> {
            { "buf"_s, "uint32_t"_s },
            { "mode"_s, "uint32_t"_s },
        };
    case MessageName::RemoteGraphicsContextGL_BlendEquationSeparateiOES:
        return Vector<ArgumentDescription> {
            { "buf"_s, "uint32_t"_s },
            { "modeRGB"_s, "uint32_t"_s },
            { "modeAlpha"_s, "uint32_t"_s },
        };
    case MessageName::RemoteGraphicsContextGL_BlendFunciOES:
        return Vector<ArgumentDescription> {
            { "buf"_s, "uint32_t"_s },
            { "src"_s, "uint32_t"_s },
            { "dst"_s, "uint32_t"_s },
        };
    case MessageName::RemoteGraphicsContextGL_BlendFuncSeparateiOES:
        return Vector<ArgumentDescription> {
            { "buf"_s, "uint32_t"_s },
            { "srcRGB"_s, "uint32_t"_s },
            { "dstRGB"_s, "uint32_t"_s },
            { "srcAlpha"_s, "uint32_t"_s },
            { "dstAlpha"_s, "uint32_t"_s },
        };
    case MessageName::RemoteGraphicsContextGL_ColorMaskiOES:
        return Vector<ArgumentDescription> {
            { "buf"_s, "uint32_t"_s },
            { "red"_s, "bool"_s },
            { "green"_s, "bool"_s },
            { "blue"_s, "bool"_s },
            { "alpha"_s, "bool"_s },
        };
    case MessageName::RemoteGraphicsContextGL_DrawArraysInstancedBaseInstanceANGLE:
        return Vector<ArgumentDescription> {
            { "mode"_s, "uint32_t"_s },
            { "first"_s, "int32_t"_s },
            { "count"_s, "int32_t"_s },
            { "instanceCount"_s, "int32_t"_s },
            { "baseInstance"_s, "uint32_t"_s },
        };
    case MessageName::RemoteGraphicsContextGL_DrawElementsInstancedBaseVertexBaseInstanceANGLE:
        return Vector<ArgumentDescription> {
            { "mode"_s, "uint32_t"_s },
            { "count"_s, "int32_t"_s },
            { "type"_s, "uint32_t"_s },
            { "offset"_s, "uint64_t"_s },
            { "instanceCount"_s, "int32_t"_s },
            { "baseVertex"_s, "int32_t"_s },
            { "baseInstance"_s, "uint32_t"_s },
        };
    case MessageName::RemoteGraphicsContextGL_ClipControlEXT:
        return Vector<ArgumentDescription> {
            { "origin"_s, "uint32_t"_s },
            { "depth"_s, "uint32_t"_s },
        };
    case MessageName::RemoteGraphicsContextGL_ProvokingVertexANGLE:
        return Vector<ArgumentDescription> {
            { "provokeMode"_s, "uint32_t"_s },
        };
    case MessageName::RemoteGraphicsContextGL_PolygonModeANGLE:
        return Vector<ArgumentDescription> {
            { "face"_s, "uint32_t"_s },
            { "mode"_s, "uint32_t"_s },
        };
    case MessageName::RemoteGraphicsContextGL_PolygonOffsetClampEXT:
        return Vector<ArgumentDescription> {
            { "factor"_s, "float"_s },
            { "units"_s, "float"_s },
            { "clamp"_s, "float"_s },
        };
    case MessageName::RemoteGraphicsContextGL_RenderbufferStorageMultisampleANGLE:
        return Vector<ArgumentDescription> {
            { "target"_s, "uint32_t"_s },
            { "samples"_s, "int32_t"_s },
            { "internalformat"_s, "uint32_t"_s },
            { "width"_s, "int32_t"_s },
            { "height"_s, "int32_t"_s },
        };
    case MessageName::RemoteGraphicsContextGL_GetInternalformativ:
        return Vector<ArgumentDescription> {
            { "target"_s, "uint32_t"_s },
            { "internalformat"_s, "uint32_t"_s },
            { "pname"_s, "uint32_t"_s },
            { "paramsSize"_s, "uint64_t"_s },
        };
    case MessageName::RemoteGraphicsContextGL_SetDrawingBufferColorSpace:
        return Vector<ArgumentDescription> {
            { "arg0"_s, "WebCore::DestinationColorSpace"_s },
        };
#if ENABLE(WEBXR)
    case MessageName::RemoteGraphicsContextGL_CreateExternalImage:
        return Vector<ArgumentDescription> {
            { "externalImage"_s, "uint32_t"_s },
            { "arg0"_s, "WebCore::GraphicsContextGL::ExternalImageSource"_s },
            { "internalFormat"_s, "uint32_t"_s },
            { "layer"_s, "int32_t"_s },
        };
    case MessageName::RemoteGraphicsContextGL_DeleteExternalImage:
        return Vector<ArgumentDescription> {
            { "handle"_s, "uint32_t"_s },
        };
    case MessageName::RemoteGraphicsContextGL_BindExternalImage:
        return Vector<ArgumentDescription> {
            { "target"_s, "uint32_t"_s },
            { "arg1"_s, "uint32_t"_s },
        };
    case MessageName::RemoteGraphicsContextGL_CreateExternalSync:
        return Vector<ArgumentDescription> {
            { "externalSync"_s, "uint32_t"_s },
            { "arg0"_s, "WebCore::GraphicsContextGL::ExternalSyncSource"_s },
        };
    case MessageName::RemoteGraphicsContextGL_DeleteExternalSync:
        return Vector<ArgumentDescription> {
            { "arg0"_s, "uint32_t"_s },
        };
    case MessageName::RemoteGraphicsContextGL_EnableRequiredWebXRExtensions:
        return Vector<ArgumentDescription> { };
    case MessageName::RemoteGraphicsContextGL_AddFoveation:
        return Vector<ArgumentDescription> {
            { "physicalSizeLeft"_s, "WebCore::IntSize"_s },
            { "physicalSizeRight"_s, "WebCore::IntSize"_s },
            { "screenSize"_s, "WebCore::IntSize"_s },
            { "horizontalSamplesLeft"_s, "std::span<const float>"_s },
            { "verticalSamples"_s, "std::span<const float>"_s },
            { "horizontalSamplesRight"_s, "std::span<const float>"_s },
        };
    case MessageName::RemoteGraphicsContextGL_EnableFoveation:
        return Vector<ArgumentDescription> {
            { "arg0"_s, "uint32_t"_s },
        };
    case MessageName::RemoteGraphicsContextGL_DisableFoveation:
        return Vector<ArgumentDescription> { };
    case MessageName::RemoteGraphicsContextGL_FramebufferResolveRenderbuffer:
        return Vector<ArgumentDescription> {
            { "target"_s, "uint32_t"_s },
            { "attachment"_s, "uint32_t"_s },
            { "renderbuffertarget"_s, "uint32_t"_s },
            { "arg3"_s, "uint32_t"_s },
        };
#endif
#endif
#if ENABLE(GPU_PROCESS)
    case MessageName::RemoteImageBuffer_GetPixelBuffer:
        return Vector<ArgumentDescription> {
            { "outputFormat"_s, "WebCore::PixelBufferFormat"_s },
            { "srcPoint"_s, "WebCore::IntPoint"_s },
            { "srcSize"_s, "WebCore::IntSize"_s },
        };
    case MessageName::RemoteImageBuffer_GetPixelBufferWithNewMemory:
        return Vector<ArgumentDescription> {
            { "handle"_s, "WebCore::SharedMemory::Handle"_s },
            { "outputFormat"_s, "WebCore::PixelBufferFormat"_s },
            { "srcPoint"_s, "WebCore::IntPoint"_s },
            { "srcSize"_s, "WebCore::IntSize"_s },
        };
    case MessageName::RemoteImageBuffer_PutPixelBuffer:
        return Vector<ArgumentDescription> {
            { "pixelBuffer"_s, "WebCore::PixelBufferSourceView"_s },
            { "srcPoint"_s, "WebCore::IntPoint"_s },
            { "srcSize"_s, "WebCore::IntSize"_s },
            { "destPoint"_s, "WebCore::IntPoint"_s },
            { "destFormat"_s, "WebCore::AlphaPremultiplication"_s },
        };
    case MessageName::RemoteImageBuffer_GetShareableBitmap:
        return Vector<ArgumentDescription> {
            { "preserveResolution"_s, "WebCore::PreserveResolution"_s },
        };
    case MessageName::RemoteImageBuffer_FilteredNativeImage:
        return Vector<ArgumentDescription> {
            { "filter"_s, "Ref<WebCore::Filter>"_s },
        };
    case MessageName::RemoteImageBuffer_ConvertToLuminanceMask:
        return Vector<ArgumentDescription> { };
    case MessageName::RemoteImageBuffer_TransformToColorSpace:
        return Vector<ArgumentDescription> {
            { "colorSpace"_s, "WebCore::DestinationColorSpace"_s },
        };
    case MessageName::RemoteImageBuffer_FlushContext:
        return Vector<ArgumentDescription> { };
    case MessageName::RemoteImageBuffer_FlushContextSync:
        return Vector<ArgumentDescription> { };
#if ENABLE(RE_DYNAMIC_CONTENT_SCALING)
    case MessageName::RemoteImageBuffer_DynamicContentScalingDisplayList:
        return Vector<ArgumentDescription> { };
#endif
#endif
#if ENABLE(GPU_PROCESS)
    case MessageName::RemoteImageBufferSet_UpdateConfiguration:
        return Vector<ArgumentDescription> {
            { "configuration"_s, "WebKit::RemoteImageBufferSetConfiguration"_s },
        };
    case MessageName::RemoteImageBufferSet_EndPrepareForDisplay:
        return Vector<ArgumentDescription> {
            { "renderingUpdateID"_s, "WebKit::RenderingUpdateID"_s },
        };
#if ENABLE(RE_DYNAMIC_CONTENT_SCALING)
    case MessageName::RemoteImageBufferSet_DynamicContentScalingDisplayList:
        return Vector<ArgumentDescription> { };
#endif
#endif
#if ENABLE(GPU_PROCESS)
    case MessageName::RemoteRenderingBackend_CreateImageBuffer:
        return Vector<ArgumentDescription> {
            { "logicalSize"_s, "WebCore::FloatSize"_s },
            { "renderingMode"_s, "WebCore::RenderingMode"_s },
            { "renderingPurpose"_s, "WebCore::RenderingPurpose"_s },
            { "resolutionScale"_s, "float"_s },
            { "colorSpace"_s, "WebCore::DestinationColorSpace"_s },
            { "bufferFormat"_s, "WebCore::ImageBufferFormat"_s },
            { "identifier"_s, "WebCore::RenderingResourceIdentifier"_s },
            { "contextIdentifier"_s, "WebKit::RemoteDisplayListRecorderIdentifier"_s },
        };
    case MessageName::RemoteRenderingBackend_ReleaseImageBuffer:
        return Vector<ArgumentDescription> {
            { "identifier"_s, "WebCore::RenderingResourceIdentifier"_s },
        };
    case MessageName::RemoteRenderingBackend_GetImageBufferResourceLimitsForTesting:
        return Vector<ArgumentDescription> { };
    case MessageName::RemoteRenderingBackend_DestroyGetPixelBufferSharedMemory:
        return Vector<ArgumentDescription> { };
    case MessageName::RemoteRenderingBackend_CacheNativeImage:
        return Vector<ArgumentDescription> {
            { "handle"_s, "WebCore::ShareableBitmapHandle"_s },
            { "renderingResourceIdentifier"_s, "WebCore::RenderingResourceIdentifier"_s },
        };
    case MessageName::RemoteRenderingBackend_ReleaseNativeImage:
        return Vector<ArgumentDescription> {
            { "identifier"_s, "WebCore::RenderingResourceIdentifier"_s },
        };
    case MessageName::RemoteRenderingBackend_CacheFont:
        return Vector<ArgumentDescription> {
            { "data"_s, "WebCore::FontInternalAttributes"_s },
            { "platformData"_s, "WebCore::FontPlatformDataAttributes"_s },
            { "renderingResourceIdentifier"_s, "std::optional<WebCore::RenderingResourceIdentifier>"_s },
        };
    case MessageName::RemoteRenderingBackend_ReleaseFont:
        return Vector<ArgumentDescription> {
            { "identifier"_s, "WebCore::RenderingResourceIdentifier"_s },
        };
    case MessageName::RemoteRenderingBackend_CacheFontCustomPlatformData:
        return Vector<ArgumentDescription> {
            { "fontCustomPlatformData"_s, "WebCore::FontCustomPlatformSerializedData"_s },
        };
    case MessageName::RemoteRenderingBackend_ReleaseFontCustomPlatformData:
        return Vector<ArgumentDescription> {
            { "identifier"_s, "WebCore::RenderingResourceIdentifier"_s },
        };
    case MessageName::RemoteRenderingBackend_CacheDecomposedGlyphs:
        return Vector<ArgumentDescription> {
            { "glyphsAdvances"_s, "IPC::ArrayReferenceTuple<WebCore::GlyphBufferGlyph, WebCore::FloatSize>"_s },
            { "localAnchor"_s, "WebCore::FloatPoint"_s },
            { "smoothingMode"_s, "WebCore::FontSmoothingMode"_s },
            { "identifier"_s, "WebCore::RenderingResourceIdentifier"_s },
        };
    case MessageName::RemoteRenderingBackend_ReleaseDecomposedGlyphs:
        return Vector<ArgumentDescription> {
            { "identifier"_s, "WebCore::RenderingResourceIdentifier"_s },
        };
    case MessageName::RemoteRenderingBackend_CacheGradient:
        return Vector<ArgumentDescription> {
            { "gradient"_s, "Ref<WebCore::Gradient>"_s },
            { "identifier"_s, "WebCore::RenderingResourceIdentifier"_s },
        };
    case MessageName::RemoteRenderingBackend_ReleaseGradient:
        return Vector<ArgumentDescription> {
            { "identifier"_s, "WebCore::RenderingResourceIdentifier"_s },
        };
    case MessageName::RemoteRenderingBackend_CacheFilter:
        return Vector<ArgumentDescription> {
            { "filter"_s, "Ref<WebCore::Filter>"_s },
        };
    case MessageName::RemoteRenderingBackend_ReleaseFilter:
        return Vector<ArgumentDescription> {
            { "identifier"_s, "WebCore::RenderingResourceIdentifier"_s },
        };
    case MessageName::RemoteRenderingBackend_ReleaseMemory:
        return Vector<ArgumentDescription> { };
    case MessageName::RemoteRenderingBackend_ReleaseNativeImages:
        return Vector<ArgumentDescription> { };
    case MessageName::RemoteRenderingBackend_CreateImageBufferSet:
        return Vector<ArgumentDescription> {
            { "identifier"_s, "WebKit::RemoteImageBufferSetIdentifier"_s },
            { "contextIdentifier"_s, "WebKit::RemoteDisplayListRecorderIdentifier"_s },
        };
    case MessageName::RemoteRenderingBackend_ReleaseImageBufferSet:
        return Vector<ArgumentDescription> {
            { "identifier"_s, "WebKit::RemoteImageBufferSetIdentifier"_s },
        };
#if PLATFORM(COCOA)
    case MessageName::RemoteRenderingBackend_PrepareImageBufferSetsForDisplay:
        return Vector<ArgumentDescription> {
            { "swapBuffersInput"_s, "Vector<WebKit::ImageBufferSetPrepareBufferForDisplayInputData>"_s },
        };
    case MessageName::RemoteRenderingBackend_PrepareImageBufferSetsForDisplaySync:
        return Vector<ArgumentDescription> {
            { "swapBuffersInput"_s, "Vector<WebKit::ImageBufferSetPrepareBufferForDisplayInputData>"_s },
        };
#endif
    case MessageName::RemoteRenderingBackend_MarkSurfacesVolatile:
        return Vector<ArgumentDescription> {
            { "requestIdentifier"_s, "WebKit::MarkSurfacesAsVolatileRequestIdentifier"_s },
            { "renderingResourceIdentifiers"_s, "Vector<std::pair<WebKit::RemoteImageBufferSetIdentifier, OptionSet<WebKit::BufferInSetType>>>"_s },
            { "forcePurge"_s, "bool"_s },
        };
    case MessageName::RemoteRenderingBackend_FinalizeRenderingUpdate:
        return Vector<ArgumentDescription> {
            { "renderingUpdateID"_s, "WebKit::RenderingUpdateID"_s },
        };
#if USE(GRAPHICS_LAYER_WC)
    case MessageName::RemoteRenderingBackend_Flush:
        return Vector<ArgumentDescription> {
            { "semaphore"_s, "IPC::Semaphore"_s },
        };
#endif
    case MessageName::RemoteRenderingBackend_MoveToSerializedBuffer:
        return Vector<ArgumentDescription> {
            { "identifier"_s, "WebCore::RenderingResourceIdentifier"_s },
            { "serializedIdentifier"_s, "WebKit::RemoteSerializedImageBufferIdentifier"_s },
        };
    case MessageName::RemoteRenderingBackend_MoveToImageBuffer:
        return Vector<ArgumentDescription> {
            { "identifier"_s, "WebKit::RemoteSerializedImageBufferIdentifier"_s },
            { "imageBufferIdentifier"_s, "WebCore::RenderingResourceIdentifier"_s },
            { "contextIdentifier"_s, "WebKit::RemoteDisplayListRecorderIdentifier"_s },
        };
#if PLATFORM(COCOA)
    case MessageName::RemoteRenderingBackend_DidDrawRemoteToPDF:
        return Vector<ArgumentDescription> {
            { "pageID"_s, "WebCore::PageIdentifier"_s },
            { "imageBufferIdentifier"_s, "WebCore::RenderingResourceIdentifier"_s },
            { "snapshotIdentifier"_s, "WebCore::SnapshotIdentifier"_s },
        };
#endif
    case MessageName::RemoteRenderingBackend_CreateRemoteBarcodeDetector:
        return Vector<ArgumentDescription> {
            { "identifier"_s, "WebKit::ShapeDetectionIdentifier"_s },
            { "barcodeDetectorOptions"_s, "WebCore::ShapeDetection::BarcodeDetectorOptions"_s },
        };
    case MessageName::RemoteRenderingBackend_ReleaseRemoteBarcodeDetector:
        return Vector<ArgumentDescription> {
            { "identifier"_s, "WebKit::ShapeDetectionIdentifier"_s },
        };
    case MessageName::RemoteRenderingBackend_GetRemoteBarcodeDetectorSupportedFormats:
        return Vector<ArgumentDescription> { };
    case MessageName::RemoteRenderingBackend_CreateRemoteFaceDetector:
        return Vector<ArgumentDescription> {
            { "identifier"_s, "WebKit::ShapeDetectionIdentifier"_s },
            { "faceDetectorOptions"_s, "WebCore::ShapeDetection::FaceDetectorOptions"_s },
        };
    case MessageName::RemoteRenderingBackend_ReleaseRemoteFaceDetector:
        return Vector<ArgumentDescription> {
            { "identifier"_s, "WebKit::ShapeDetectionIdentifier"_s },
        };
    case MessageName::RemoteRenderingBackend_CreateRemoteTextDetector:
        return Vector<ArgumentDescription> {
            { "identifier"_s, "WebKit::ShapeDetectionIdentifier"_s },
        };
    case MessageName::RemoteRenderingBackend_ReleaseRemoteTextDetector:
        return Vector<ArgumentDescription> {
            { "identifier"_s, "WebKit::ShapeDetectionIdentifier"_s },
        };
#endif
#if ENABLE(GPU_PROCESS)
    case MessageName::RemoteAdapter_Destruct:
        return Vector<ArgumentDescription> { };
    case MessageName::RemoteAdapter_RequestDevice:
        return Vector<ArgumentDescription> {
            { "deviceDescriptor"_s, "WebKit::WebGPU::DeviceDescriptor"_s },
            { "identifier"_s, "WebKit::WebGPUIdentifier"_s },
            { "queueIdentifier"_s, "WebKit::WebGPUIdentifier"_s },
        };
#endif
#if ENABLE(GPU_PROCESS)
    case MessageName::RemoteBindGroup_Destruct:
        return Vector<ArgumentDescription> { };
    case MessageName::RemoteBindGroup_SetLabel:
        return Vector<ArgumentDescription> {
            { "label"_s, "String"_s },
        };
    case MessageName::RemoteBindGroup_UpdateExternalTextures:
        return Vector<ArgumentDescription> {
            { "externalTextureIdentifier"_s, "WebKit::WebGPUIdentifier"_s },
        };
#endif
#if ENABLE(GPU_PROCESS)
    case MessageName::RemoteBindGroupLayout_Destruct:
        return Vector<ArgumentDescription> { };
    case MessageName::RemoteBindGroupLayout_SetLabel:
        return Vector<ArgumentDescription> {
            { "label"_s, "String"_s },
        };
#endif
#if ENABLE(GPU_PROCESS)
    case MessageName::RemoteBuffer_GetMappedRange:
        return Vector<ArgumentDescription> {
            { "offset"_s, "WebCore::WebGPU::Size64"_s },
            { "size"_s, "std::optional<WebCore::WebGPU::Size64>"_s },
        };
    case MessageName::RemoteBuffer_MapAsync:
        return Vector<ArgumentDescription> {
            { "mapModeFlags"_s, "WebCore::WebGPU::MapModeFlags"_s },
            { "offset"_s, "WebCore::WebGPU::Size64"_s },
            { "size"_s, "std::optional<WebCore::WebGPU::Size64>"_s },
        };
    case MessageName::RemoteBuffer_Copy:
        return Vector<ArgumentDescription> {
            { "data"_s, "std::optional<WebCore::SharedMemory::Handle>"_s },
            { "offset"_s, "uint64_t"_s },
        };
    case MessageName::RemoteBuffer_CopyWithCopy:
        return Vector<ArgumentDescription> {
            { "data"_s, "Vector<uint8_t>"_s },
            { "offset"_s, "uint64_t"_s },
        };
    case MessageName::RemoteBuffer_Unmap:
        return Vector<ArgumentDescription> { };
    case MessageName::RemoteBuffer_Destroy:
        return Vector<ArgumentDescription> { };
    case MessageName::RemoteBuffer_Destruct:
        return Vector<ArgumentDescription> { };
    case MessageName::RemoteBuffer_SetLabel:
        return Vector<ArgumentDescription> {
            { "label"_s, "String"_s },
        };
#endif
#if ENABLE(GPU_PROCESS)
    case MessageName::RemoteCommandBuffer_Destruct:
        return Vector<ArgumentDescription> { };
    case MessageName::RemoteCommandBuffer_SetLabel:
        return Vector<ArgumentDescription> {
            { "label"_s, "String"_s },
        };
#endif
#if ENABLE(GPU_PROCESS)
    case MessageName::RemoteCommandEncoder_BeginRenderPass:
        return Vector<ArgumentDescription> {
            { "descriptor"_s, "WebKit::WebGPU::RenderPassDescriptor"_s },
            { "identifier"_s, "WebKit::WebGPUIdentifier"_s },
        };
    case MessageName::RemoteCommandEncoder_BeginComputePass:
        return Vector<ArgumentDescription> {
            { "descriptor"_s, "std::optional<WebKit::WebGPU::ComputePassDescriptor>"_s },
            { "identifier"_s, "WebKit::WebGPUIdentifier"_s },
        };
    case MessageName::RemoteCommandEncoder_CopyBufferToBuffer:
        return Vector<ArgumentDescription> {
            { "source"_s, "WebKit::WebGPUIdentifier"_s },
            { "sourceOffset"_s, "WebCore::WebGPU::Size64"_s },
            { "destination"_s, "WebKit::WebGPUIdentifier"_s },
            { "destinationOffset"_s, "WebCore::WebGPU::Size64"_s },
            { "size"_s, "WebCore::WebGPU::Size64"_s },
        };
    case MessageName::RemoteCommandEncoder_CopyBufferToTexture:
        return Vector<ArgumentDescription> {
            { "source"_s, "WebKit::WebGPU::ImageCopyBuffer"_s },
            { "destination"_s, "WebKit::WebGPU::ImageCopyTexture"_s },
            { "copySize"_s, "WebKit::WebGPU::Extent3D"_s },
        };
    case MessageName::RemoteCommandEncoder_CopyTextureToBuffer:
        return Vector<ArgumentDescription> {
            { "source"_s, "WebKit::WebGPU::ImageCopyTexture"_s },
            { "destination"_s, "WebKit::WebGPU::ImageCopyBuffer"_s },
            { "copySize"_s, "WebKit::WebGPU::Extent3D"_s },
        };
    case MessageName::RemoteCommandEncoder_CopyTextureToTexture:
        return Vector<ArgumentDescription> {
            { "source"_s, "WebKit::WebGPU::ImageCopyTexture"_s },
            { "destination"_s, "WebKit::WebGPU::ImageCopyTexture"_s },
            { "copySize"_s, "WebKit::WebGPU::Extent3D"_s },
        };
    case MessageName::RemoteCommandEncoder_ClearBuffer:
        return Vector<ArgumentDescription> {
            { "buffer"_s, "WebKit::WebGPUIdentifier"_s },
            { "offset"_s, "WebCore::WebGPU::Size64"_s },
            { "size"_s, "std::optional<WebCore::WebGPU::Size64>"_s },
        };
    case MessageName::RemoteCommandEncoder_Destruct:
        return Vector<ArgumentDescription> { };
    case MessageName::RemoteCommandEncoder_PushDebugGroup:
        return Vector<ArgumentDescription> {
            { "groupLabel"_s, "String"_s },
        };
    case MessageName::RemoteCommandEncoder_PopDebugGroup:
        return Vector<ArgumentDescription> { };
    case MessageName::RemoteCommandEncoder_InsertDebugMarker:
        return Vector<ArgumentDescription> {
            { "markerLabel"_s, "String"_s },
        };
    case MessageName::RemoteCommandEncoder_WriteTimestamp:
        return Vector<ArgumentDescription> {
            { "identifier"_s, "WebKit::WebGPUIdentifier"_s },
            { "queryIndex"_s, "WebCore::WebGPU::Size32"_s },
        };
    case MessageName::RemoteCommandEncoder_ResolveQuerySet:
        return Vector<ArgumentDescription> {
            { "identifier"_s, "WebKit::WebGPUIdentifier"_s },
            { "firstQuery"_s, "WebCore::WebGPU::Size32"_s },
            { "queryCount"_s, "WebCore::WebGPU::Size32"_s },
            { "destination"_s, "WebKit::WebGPUIdentifier"_s },
            { "destinationOffset"_s, "WebCore::WebGPU::Size64"_s },
        };
    case MessageName::RemoteCommandEncoder_Finish:
        return Vector<ArgumentDescription> {
            { "descriptor"_s, "WebKit::WebGPU::CommandBufferDescriptor"_s },
            { "identifier"_s, "WebKit::WebGPUIdentifier"_s },
        };
    case MessageName::RemoteCommandEncoder_SetLabel:
        return Vector<ArgumentDescription> {
            { "label"_s, "String"_s },
        };
#endif
#if ENABLE(GPU_PROCESS)
#if PLATFORM(COCOA)
    case MessageName::RemoteCompositorIntegration_RecreateRenderBuffers:
        return Vector<ArgumentDescription> {
            { "width"_s, "int"_s },
            { "height"_s, "int"_s },
            { "destinationColorSpace"_s, "WebCore::DestinationColorSpace"_s },
            { "alphaMode"_s, "WebCore::AlphaPremultiplication"_s },
            { "textureFormat"_s, "WebCore::WebGPU::TextureFormat"_s },
            { "deviceIdentifier"_s, "WebKit::WebGPUIdentifier"_s },
        };
#endif
    case MessageName::RemoteCompositorIntegration_PrepareForDisplay:
        return Vector<ArgumentDescription> {
            { "frameIndex"_s, "uint32_t"_s },
        };
    case MessageName::RemoteCompositorIntegration_PaintCompositedResultsToCanvas:
        return Vector<ArgumentDescription> {
            { "imageBuffer"_s, "WebCore::RenderingResourceIdentifier"_s },
            { "bufferIndex"_s, "uint32_t"_s },
        };
    case MessageName::RemoteCompositorIntegration_Destruct:
        return Vector<ArgumentDescription> { };
    case MessageName::RemoteCompositorIntegration_UpdateContentsHeadroom:
        return Vector<ArgumentDescription> {
            { "headroom"_s, "float"_s },
        };
#endif
#if ENABLE(GPU_PROCESS)
    case MessageName::RemoteComputePassEncoder_Destruct:
        return Vector<ArgumentDescription> { };
    case MessageName::RemoteComputePassEncoder_SetPipeline:
        return Vector<ArgumentDescription> {
            { "identifier"_s, "WebKit::WebGPUIdentifier"_s },
        };
    case MessageName::RemoteComputePassEncoder_Dispatch:
        return Vector<ArgumentDescription> {
            { "workgroupCountX"_s, "WebCore::WebGPU::Size32"_s },
            { "workgroupCountY"_s, "WebCore::WebGPU::Size32"_s },
            { "workgroupCountZ"_s, "WebCore::WebGPU::Size32"_s },
        };
    case MessageName::RemoteComputePassEncoder_DispatchIndirect:
        return Vector<ArgumentDescription> {
            { "indirectBuffer"_s, "WebKit::WebGPUIdentifier"_s },
            { "indirectOffset"_s, "WebCore::WebGPU::Size64"_s },
        };
    case MessageName::RemoteComputePassEncoder_End:
        return Vector<ArgumentDescription> { };
    case MessageName::RemoteComputePassEncoder_SetBindGroup:
        return Vector<ArgumentDescription> {
            { "index"_s, "WebCore::WebGPU::Index32"_s },
            { "identifier"_s, "std::optional<WebKit::WebGPUIdentifier>"_s },
            { "dynamicOffsets"_s, "std::optional<Vector<WebCore::WebGPU::BufferDynamicOffset>>"_s },
        };
    case MessageName::RemoteComputePassEncoder_PushDebugGroup:
        return Vector<ArgumentDescription> {
            { "groupLabel"_s, "String"_s },
        };
    case MessageName::RemoteComputePassEncoder_PopDebugGroup:
        return Vector<ArgumentDescription> { };
    case MessageName::RemoteComputePassEncoder_InsertDebugMarker:
        return Vector<ArgumentDescription> {
            { "markerLabel"_s, "String"_s },
        };
    case MessageName::RemoteComputePassEncoder_SetLabel:
        return Vector<ArgumentDescription> {
            { "label"_s, "String"_s },
        };
#endif
#if ENABLE(GPU_PROCESS)
    case MessageName::RemoteComputePipeline_Destruct:
        return Vector<ArgumentDescription> { };
    case MessageName::RemoteComputePipeline_GetBindGroupLayout:
        return Vector<ArgumentDescription> {
            { "index"_s, "uint32_t"_s },
            { "identifier"_s, "WebKit::WebGPUIdentifier"_s },
        };
    case MessageName::RemoteComputePipeline_SetLabel:
        return Vector<ArgumentDescription> {
            { "label"_s, "String"_s },
        };
#endif
#if ENABLE(GPU_PROCESS)
    case MessageName::RemoteDevice_Destroy:
        return Vector<ArgumentDescription> { };
    case MessageName::RemoteDevice_Destruct:
        return Vector<ArgumentDescription> { };
    case MessageName::RemoteDevice_CreateXRBinding:
        return Vector<ArgumentDescription> {
            { "identifier"_s, "WebKit::WebGPUIdentifier"_s },
        };
    case MessageName::RemoteDevice_CreateBuffer:
        return Vector<ArgumentDescription> {
            { "descriptor"_s, "WebKit::WebGPU::BufferDescriptor"_s },
            { "identifier"_s, "WebKit::WebGPUIdentifier"_s },
        };
    case MessageName::RemoteDevice_CreateTexture:
        return Vector<ArgumentDescription> {
            { "descriptor"_s, "WebKit::WebGPU::TextureDescriptor"_s },
            { "identifier"_s, "WebKit::WebGPUIdentifier"_s },
        };
    case MessageName::RemoteDevice_CreateSampler:
        return Vector<ArgumentDescription> {
            { "descriptor"_s, "WebKit::WebGPU::SamplerDescriptor"_s },
            { "identifier"_s, "WebKit::WebGPUIdentifier"_s },
        };
    case MessageName::RemoteDevice_CreateBindGroupLayout:
        return Vector<ArgumentDescription> {
            { "descriptor"_s, "WebKit::WebGPU::BindGroupLayoutDescriptor"_s },
            { "identifier"_s, "WebKit::WebGPUIdentifier"_s },
        };
    case MessageName::RemoteDevice_CreatePipelineLayout:
        return Vector<ArgumentDescription> {
            { "descriptor"_s, "WebKit::WebGPU::PipelineLayoutDescriptor"_s },
            { "identifier"_s, "WebKit::WebGPUIdentifier"_s },
        };
    case MessageName::RemoteDevice_CreateBindGroup:
        return Vector<ArgumentDescription> {
            { "descriptor"_s, "WebKit::WebGPU::BindGroupDescriptor"_s },
            { "identifier"_s, "WebKit::WebGPUIdentifier"_s },
        };
    case MessageName::RemoteDevice_CreateShaderModule:
        return Vector<ArgumentDescription> {
            { "descriptor"_s, "WebKit::WebGPU::ShaderModuleDescriptor"_s },
            { "identifier"_s, "WebKit::WebGPUIdentifier"_s },
        };
    case MessageName::RemoteDevice_CreateComputePipeline:
        return Vector<ArgumentDescription> {
            { "descriptor"_s, "WebKit::WebGPU::ComputePipelineDescriptor"_s },
            { "identifier"_s, "WebKit::WebGPUIdentifier"_s },
        };
    case MessageName::RemoteDevice_CreateRenderPipeline:
        return Vector<ArgumentDescription> {
            { "descriptor"_s, "WebKit::WebGPU::RenderPipelineDescriptor"_s },
            { "identifier"_s, "WebKit::WebGPUIdentifier"_s },
        };
    case MessageName::RemoteDevice_CreateComputePipelineAsync:
        return Vector<ArgumentDescription> {
            { "descriptor"_s, "WebKit::WebGPU::ComputePipelineDescriptor"_s },
            { "identifier"_s, "WebKit::WebGPUIdentifier"_s },
        };
    case MessageName::RemoteDevice_CreateRenderPipelineAsync:
        return Vector<ArgumentDescription> {
            { "descriptor"_s, "WebKit::WebGPU::RenderPipelineDescriptor"_s },
            { "identifier"_s, "WebKit::WebGPUIdentifier"_s },
        };
    case MessageName::RemoteDevice_CreateCommandEncoder:
        return Vector<ArgumentDescription> {
            { "descriptor"_s, "std::optional<WebKit::WebGPU::CommandEncoderDescriptor>"_s },
            { "identifier"_s, "WebKit::WebGPUIdentifier"_s },
        };
    case MessageName::RemoteDevice_CreateRenderBundleEncoder:
        return Vector<ArgumentDescription> {
            { "descriptor"_s, "WebKit::WebGPU::RenderBundleEncoderDescriptor"_s },
            { "identifier"_s, "WebKit::WebGPUIdentifier"_s },
        };
    case MessageName::RemoteDevice_CreateQuerySet:
        return Vector<ArgumentDescription> {
            { "descriptor"_s, "WebKit::WebGPU::QuerySetDescriptor"_s },
            { "identifier"_s, "WebKit::WebGPUIdentifier"_s },
        };
    case MessageName::RemoteDevice_PushErrorScope:
        return Vector<ArgumentDescription> {
            { "errorFilter"_s, "WebCore::WebGPU::ErrorFilter"_s },
        };
    case MessageName::RemoteDevice_PopErrorScope:
        return Vector<ArgumentDescription> { };
    case MessageName::RemoteDevice_ResolveUncapturedErrorEvent:
        return Vector<ArgumentDescription> { };
    case MessageName::RemoteDevice_ResolveDeviceLostPromise:
        return Vector<ArgumentDescription> { };
    case MessageName::RemoteDevice_SetLabel:
        return Vector<ArgumentDescription> {
            { "label"_s, "String"_s },
        };
    case MessageName::RemoteDevice_PauseAllErrorReporting:
        return Vector<ArgumentDescription> {
            { "pauseErrorReporting"_s, "bool"_s },
        };
#if PLATFORM(COCOA) && ENABLE(VIDEO)
    case MessageName::RemoteDevice_SetSharedVideoFrameSemaphore:
        return Vector<ArgumentDescription> {
            { "semaphore"_s, "IPC::Semaphore"_s },
        };
    case MessageName::RemoteDevice_SetSharedVideoFrameMemory:
        return Vector<ArgumentDescription> {
            { "storageHandle"_s, "WebCore::SharedMemory::Handle"_s },
        };
    case MessageName::RemoteDevice_ImportExternalTextureFromVideoFrame:
        return Vector<ArgumentDescription> {
            { "descriptor"_s, "WebKit::WebGPU::ExternalTextureDescriptor"_s },
            { "identifier"_s, "WebKit::WebGPUIdentifier"_s },
        };
    case MessageName::RemoteDevice_UpdateExternalTexture:
        return Vector<ArgumentDescription> {
            { "externalTextureIdentifier"_s, "WebKit::WebGPUIdentifier"_s },
            { "mediaIdentifier"_s, "WebCore::MediaPlayerIdentifier"_s },
        };
#endif
#endif
#if ENABLE(GPU_PROCESS)
    case MessageName::RemoteExternalTexture_Destruct:
        return Vector<ArgumentDescription> { };
    case MessageName::RemoteExternalTexture_SetLabel:
        return Vector<ArgumentDescription> {
            { "label"_s, "String"_s },
        };
    case MessageName::RemoteExternalTexture_Destroy:
        return Vector<ArgumentDescription> { };
    case MessageName::RemoteExternalTexture_Undestroy:
        return Vector<ArgumentDescription> { };
#endif
#if ENABLE(GPU_PROCESS)
    case MessageName::RemoteGPU_RequestAdapter:
        return Vector<ArgumentDescription> {
            { "options"_s, "WebKit::WebGPU::RequestAdapterOptions"_s },
            { "identifier"_s, "WebKit::WebGPUIdentifier"_s },
        };
    case MessageName::RemoteGPU_CreatePresentationContext:
        return Vector<ArgumentDescription> {
            { "descriptor"_s, "WebKit::WebGPU::PresentationContextDescriptor"_s },
            { "identifier"_s, "WebKit::WebGPUIdentifier"_s },
        };
    case MessageName::RemoteGPU_CreateCompositorIntegration:
        return Vector<ArgumentDescription> {
            { "identifier"_s, "WebKit::WebGPUIdentifier"_s },
        };
    case MessageName::RemoteGPU_IsValid:
        return Vector<ArgumentDescription> {
            { "identifier"_s, "WebKit::WebGPUIdentifier"_s },
        };
#endif
#if ENABLE(GPU_PROCESS)
    case MessageName::RemotePipelineLayout_Destruct:
        return Vector<ArgumentDescription> { };
    case MessageName::RemotePipelineLayout_SetLabel:
        return Vector<ArgumentDescription> {
            { "label"_s, "String"_s },
        };
#endif
#if ENABLE(GPU_PROCESS)
    case MessageName::RemotePresentationContext_Configure:
        return Vector<ArgumentDescription> {
            { "configuration"_s, "WebKit::WebGPU::CanvasConfiguration"_s },
        };
    case MessageName::RemotePresentationContext_Unconfigure:
        return Vector<ArgumentDescription> { };
    case MessageName::RemotePresentationContext_GetCurrentTexture:
        return Vector<ArgumentDescription> {
            { "identifier"_s, "WebKit::WebGPUIdentifier"_s },
            { "frameIndex"_s, "uint32_t"_s },
        };
    case MessageName::RemotePresentationContext_Present:
        return Vector<ArgumentDescription> {
            { "frameIndex"_s, "uint32_t"_s },
        };
#endif
#if ENABLE(GPU_PROCESS)
    case MessageName::RemoteQuerySet_Destroy:
        return Vector<ArgumentDescription> { };
    case MessageName::RemoteQuerySet_Destruct:
        return Vector<ArgumentDescription> { };
    case MessageName::RemoteQuerySet_SetLabel:
        return Vector<ArgumentDescription> {
            { "label"_s, "String"_s },
        };
#endif
#if ENABLE(GPU_PROCESS)
    case MessageName::RemoteQueue_Destruct:
        return Vector<ArgumentDescription> { };
    case MessageName::RemoteQueue_Submit:
        return Vector<ArgumentDescription> {
            { "commandBuffers"_s, "Vector<WebKit::WebGPUIdentifier>"_s },
        };
    case MessageName::RemoteQueue_OnSubmittedWorkDone:
        return Vector<ArgumentDescription> { };
    case MessageName::RemoteQueue_WriteBufferWithCopy:
        return Vector<ArgumentDescription> {
            { "identifier"_s, "WebKit::WebGPUIdentifier"_s },
            { "bufferOffset"_s, "WebCore::WebGPU::Size64"_s },
            { "data"_s, "Vector<uint8_t>"_s },
        };
    case MessageName::RemoteQueue_WriteBuffer:
        return Vector<ArgumentDescription> {
            { "identifier"_s, "WebKit::WebGPUIdentifier"_s },
            { "bufferOffset"_s, "WebCore::WebGPU::Size64"_s },
            { "data"_s, "std::optional<WebCore::SharedMemory::Handle>"_s },
        };
    case MessageName::RemoteQueue_WriteTexture:
        return Vector<ArgumentDescription> {
            { "destination"_s, "WebKit::WebGPU::ImageCopyTexture"_s },
            { "dataHandle"_s, "std::optional<WebCore::SharedMemory::Handle>"_s },
            { "imageDataLayout"_s, "WebKit::WebGPU::ImageDataLayout"_s },
            { "size"_s, "WebKit::WebGPU::Extent3D"_s },
        };
    case MessageName::RemoteQueue_WriteTextureWithCopy:
        return Vector<ArgumentDescription> {
            { "destination"_s, "WebKit::WebGPU::ImageCopyTexture"_s },
            { "data"_s, "Vector<uint8_t>"_s },
            { "imageDataLayout"_s, "WebKit::WebGPU::ImageDataLayout"_s },
            { "size"_s, "WebKit::WebGPU::Extent3D"_s },
        };
    case MessageName::RemoteQueue_CopyExternalImageToTexture:
        return Vector<ArgumentDescription> {
            { "source"_s, "WebKit::WebGPU::ImageCopyExternalImage"_s },
            { "destination"_s, "WebKit::WebGPU::ImageCopyTextureTagged"_s },
            { "copySize"_s, "WebKit::WebGPU::Extent3D"_s },
        };
    case MessageName::RemoteQueue_SetLabel:
        return Vector<ArgumentDescription> {
            { "label"_s, "String"_s },
        };
#endif
#if ENABLE(GPU_PROCESS)
    case MessageName::RemoteRenderBundle_Destruct:
        return Vector<ArgumentDescription> { };
    case MessageName::RemoteRenderBundle_SetLabel:
        return Vector<ArgumentDescription> {
            { "label"_s, "String"_s },
        };
#endif
#if ENABLE(GPU_PROCESS)
    case MessageName::RemoteRenderBundleEncoder_Destruct:
        return Vector<ArgumentDescription> { };
    case MessageName::RemoteRenderBundleEncoder_SetPipeline:
        return Vector<ArgumentDescription> {
            { "identifier"_s, "WebKit::WebGPUIdentifier"_s },
        };
    case MessageName::RemoteRenderBundleEncoder_SetIndexBuffer:
        return Vector<ArgumentDescription> {
            { "identifier"_s, "WebKit::WebGPUIdentifier"_s },
            { "indexFormat"_s, "WebCore::WebGPU::IndexFormat"_s },
            { "offset"_s, "std::optional<WebCore::WebGPU::Size64>"_s },
            { "size"_s, "std::optional<WebCore::WebGPU::Size64>"_s },
        };
    case MessageName::RemoteRenderBundleEncoder_SetVertexBuffer:
        return Vector<ArgumentDescription> {
            { "slot"_s, "WebCore::WebGPU::Index32"_s },
            { "identifier"_s, "WebKit::WebGPUIdentifier"_s },
            { "offset"_s, "std::optional<WebCore::WebGPU::Size64>"_s },
            { "size"_s, "std::optional<WebCore::WebGPU::Size64>"_s },
        };
    case MessageName::RemoteRenderBundleEncoder_UnsetVertexBuffer:
        return Vector<ArgumentDescription> {
            { "slot"_s, "WebCore::WebGPU::Index32"_s },
            { "offset"_s, "std::optional<WebCore::WebGPU::Size64>"_s },
            { "size"_s, "std::optional<WebCore::WebGPU::Size64>"_s },
        };
    case MessageName::RemoteRenderBundleEncoder_Draw:
        return Vector<ArgumentDescription> {
            { "vertexCount"_s, "WebCore::WebGPU::Size32"_s },
            { "instanceCount"_s, "std::optional<WebCore::WebGPU::Size32>"_s },
            { "firstVertex"_s, "std::optional<WebCore::WebGPU::Size32>"_s },
            { "firstInstance"_s, "std::optional<WebCore::WebGPU::Size32>"_s },
        };
    case MessageName::RemoteRenderBundleEncoder_DrawIndexed:
        return Vector<ArgumentDescription> {
            { "indexCount"_s, "WebCore::WebGPU::Size32"_s },
            { "instanceCount"_s, "std::optional<WebCore::WebGPU::Size32>"_s },
            { "firstIndex"_s, "std::optional<WebCore::WebGPU::Size32>"_s },
            { "baseVertex"_s, "std::optional<WebCore::WebGPU::SignedOffset32>"_s },
            { "firstInstance"_s, "std::optional<WebCore::WebGPU::Size32>"_s },
        };
    case MessageName::RemoteRenderBundleEncoder_DrawIndirect:
        return Vector<ArgumentDescription> {
            { "indirectBuffer"_s, "WebKit::WebGPUIdentifier"_s },
            { "indirectOffset"_s, "WebCore::WebGPU::Size64"_s },
        };
    case MessageName::RemoteRenderBundleEncoder_DrawIndexedIndirect:
        return Vector<ArgumentDescription> {
            { "indirectBuffer"_s, "WebKit::WebGPUIdentifier"_s },
            { "indirectOffset"_s, "WebCore::WebGPU::Size64"_s },
        };
    case MessageName::RemoteRenderBundleEncoder_SetBindGroup:
        return Vector<ArgumentDescription> {
            { "index"_s, "WebCore::WebGPU::Index32"_s },
            { "identifier"_s, "std::optional<WebKit::WebGPUIdentifier>"_s },
            { "dynamicOffsets"_s, "std::optional<Vector<WebCore::WebGPU::BufferDynamicOffset>>"_s },
        };
    case MessageName::RemoteRenderBundleEncoder_PushDebugGroup:
        return Vector<ArgumentDescription> {
            { "groupLabel"_s, "String"_s },
        };
    case MessageName::RemoteRenderBundleEncoder_PopDebugGroup:
        return Vector<ArgumentDescription> { };
    case MessageName::RemoteRenderBundleEncoder_InsertDebugMarker:
        return Vector<ArgumentDescription> {
            { "markerLabel"_s, "String"_s },
        };
    case MessageName::RemoteRenderBundleEncoder_Finish:
        return Vector<ArgumentDescription> {
            { "descriptor"_s, "WebKit::WebGPU::RenderBundleDescriptor"_s },
            { "identifier"_s, "WebKit::WebGPUIdentifier"_s },
        };
    case MessageName::RemoteRenderBundleEncoder_SetLabel:
        return Vector<ArgumentDescription> {
            { "label"_s, "String"_s },
        };
#endif
#if ENABLE(GPU_PROCESS)
    case MessageName::RemoteRenderPassEncoder_Destruct:
        return Vector<ArgumentDescription> { };
    case MessageName::RemoteRenderPassEncoder_SetPipeline:
        return Vector<ArgumentDescription> {
            { "identifier"_s, "WebKit::WebGPUIdentifier"_s },
        };
    case MessageName::RemoteRenderPassEncoder_SetIndexBuffer:
        return Vector<ArgumentDescription> {
            { "identifier"_s, "WebKit::WebGPUIdentifier"_s },
            { "indexFormat"_s, "WebCore::WebGPU::IndexFormat"_s },
            { "offset"_s, "std::optional<WebCore::WebGPU::Size64>"_s },
            { "size"_s, "std::optional<WebCore::WebGPU::Size64>"_s },
        };
    case MessageName::RemoteRenderPassEncoder_SetVertexBuffer:
        return Vector<ArgumentDescription> {
            { "slot"_s, "WebCore::WebGPU::Index32"_s },
            { "identifier"_s, "WebKit::WebGPUIdentifier"_s },
            { "offset"_s, "std::optional<WebCore::WebGPU::Size64>"_s },
            { "size"_s, "std::optional<WebCore::WebGPU::Size64>"_s },
        };
    case MessageName::RemoteRenderPassEncoder_UnsetVertexBuffer:
        return Vector<ArgumentDescription> {
            { "slot"_s, "WebCore::WebGPU::Index32"_s },
            { "offset"_s, "std::optional<WebCore::WebGPU::Size64>"_s },
            { "size"_s, "std::optional<WebCore::WebGPU::Size64>"_s },
        };
    case MessageName::RemoteRenderPassEncoder_Draw:
        return Vector<ArgumentDescription> {
            { "vertexCount"_s, "WebCore::WebGPU::Size32"_s },
            { "instanceCount"_s, "std::optional<WebCore::WebGPU::Size32>"_s },
            { "firstVertex"_s, "std::optional<WebCore::WebGPU::Size32>"_s },
            { "firstInstance"_s, "std::optional<WebCore::WebGPU::Size32>"_s },
        };
    case MessageName::RemoteRenderPassEncoder_DrawIndexed:
        return Vector<ArgumentDescription> {
            { "indexCount"_s, "WebCore::WebGPU::Size32"_s },
            { "instanceCount"_s, "std::optional<WebCore::WebGPU::Size32>"_s },
            { "firstIndex"_s, "std::optional<WebCore::WebGPU::Size32>"_s },
            { "baseVertex"_s, "std::optional<WebCore::WebGPU::SignedOffset32>"_s },
            { "firstInstance"_s, "std::optional<WebCore::WebGPU::Size32>"_s },
        };
    case MessageName::RemoteRenderPassEncoder_DrawIndirect:
        return Vector<ArgumentDescription> {
            { "indirectBuffer"_s, "WebKit::WebGPUIdentifier"_s },
            { "indirectOffset"_s, "WebCore::WebGPU::Size64"_s },
        };
    case MessageName::RemoteRenderPassEncoder_DrawIndexedIndirect:
        return Vector<ArgumentDescription> {
            { "indirectBuffer"_s, "WebKit::WebGPUIdentifier"_s },
            { "indirectOffset"_s, "WebCore::WebGPU::Size64"_s },
        };
    case MessageName::RemoteRenderPassEncoder_SetBindGroup:
        return Vector<ArgumentDescription> {
            { "index"_s, "WebCore::WebGPU::Index32"_s },
            { "identifier"_s, "std::optional<WebKit::WebGPUIdentifier>"_s },
            { "dynamicOffsets"_s, "std::optional<Vector<WebCore::WebGPU::BufferDynamicOffset>>"_s },
        };
    case MessageName::RemoteRenderPassEncoder_PushDebugGroup:
        return Vector<ArgumentDescription> {
            { "groupLabel"_s, "String"_s },
        };
    case MessageName::RemoteRenderPassEncoder_PopDebugGroup:
        return Vector<ArgumentDescription> { };
    case MessageName::RemoteRenderPassEncoder_InsertDebugMarker:
        return Vector<ArgumentDescription> {
            { "markerLabel"_s, "String"_s },
        };
    case MessageName::RemoteRenderPassEncoder_SetViewport:
        return Vector<ArgumentDescription> {
            { "x"_s, "float"_s },
            { "y"_s, "float"_s },
            { "width"_s, "float"_s },
            { "height"_s, "float"_s },
            { "minDepth"_s, "float"_s },
            { "maxDepth"_s, "float"_s },
        };
    case MessageName::RemoteRenderPassEncoder_SetScissorRect:
        return Vector<ArgumentDescription> {
            { "x"_s, "WebCore::WebGPU::IntegerCoordinate"_s },
            { "y"_s, "WebCore::WebGPU::IntegerCoordinate"_s },
            { "width"_s, "WebCore::WebGPU::IntegerCoordinate"_s },
            { "height"_s, "WebCore::WebGPU::IntegerCoordinate"_s },
        };
    case MessageName::RemoteRenderPassEncoder_SetBlendConstant:
        return Vector<ArgumentDescription> {
            { "color"_s, "WebKit::WebGPU::Color"_s },
        };
    case MessageName::RemoteRenderPassEncoder_SetStencilReference:
        return Vector<ArgumentDescription> {
            { "stencilValue"_s, "WebCore::WebGPU::StencilValue"_s },
        };
    case MessageName::RemoteRenderPassEncoder_BeginOcclusionQuery:
        return Vector<ArgumentDescription> {
            { "queryIndex"_s, "WebCore::WebGPU::Size32"_s },
        };
    case MessageName::RemoteRenderPassEncoder_EndOcclusionQuery:
        return Vector<ArgumentDescription> { };
    case MessageName::RemoteRenderPassEncoder_ExecuteBundles:
        return Vector<ArgumentDescription> {
            { "bundles"_s, "Vector<WebKit::WebGPUIdentifier>"_s },
        };
    case MessageName::RemoteRenderPassEncoder_End:
        return Vector<ArgumentDescription> { };
    case MessageName::RemoteRenderPassEncoder_SetLabel:
        return Vector<ArgumentDescription> {
            { "label"_s, "String"_s },
        };
#endif
#if ENABLE(GPU_PROCESS)
    case MessageName::RemoteRenderPipeline_Destruct:
        return Vector<ArgumentDescription> { };
    case MessageName::RemoteRenderPipeline_GetBindGroupLayout:
        return Vector<ArgumentDescription> {
            { "index"_s, "uint32_t"_s },
            { "identifier"_s, "WebKit::WebGPUIdentifier"_s },
        };
    case MessageName::RemoteRenderPipeline_SetLabel:
        return Vector<ArgumentDescription> {
            { "label"_s, "String"_s },
        };
#endif
#if ENABLE(GPU_PROCESS)
    case MessageName::RemoteSampler_Destruct:
        return Vector<ArgumentDescription> { };
    case MessageName::RemoteSampler_SetLabel:
        return Vector<ArgumentDescription> {
            { "label"_s, "String"_s },
        };
#endif
#if ENABLE(GPU_PROCESS)
    case MessageName::RemoteShaderModule_CompilationInfo:
        return Vector<ArgumentDescription> { };
    case MessageName::RemoteShaderModule_SetLabel:
        return Vector<ArgumentDescription> {
            { "label"_s, "String"_s },
        };
    case MessageName::RemoteShaderModule_Destruct:
        return Vector<ArgumentDescription> { };
#endif
#if ENABLE(GPU_PROCESS)
    case MessageName::RemoteTexture_CreateView:
        return Vector<ArgumentDescription> {
            { "descriptor"_s, "std::optional<WebKit::WebGPU::TextureViewDescriptor>"_s },
            { "identifier"_s, "WebKit::WebGPUIdentifier"_s },
        };
    case MessageName::RemoteTexture_Destroy:
        return Vector<ArgumentDescription> { };
    case MessageName::RemoteTexture_Undestroy:
        return Vector<ArgumentDescription> { };
    case MessageName::RemoteTexture_Destruct:
        return Vector<ArgumentDescription> { };
    case MessageName::RemoteTexture_SetLabel:
        return Vector<ArgumentDescription> {
            { "label"_s, "String"_s },
        };
#endif
#if ENABLE(GPU_PROCESS)
    case MessageName::RemoteTextureView_Destruct:
        return Vector<ArgumentDescription> { };
    case MessageName::RemoteTextureView_SetLabel:
        return Vector<ArgumentDescription> {
            { "label"_s, "String"_s },
        };
#endif
#if ENABLE(GPU_PROCESS)
    case MessageName::RemoteXRBinding_Destruct:
        return Vector<ArgumentDescription> { };
    case MessageName::RemoteXRBinding_CreateProjectionLayer:
        return Vector<ArgumentDescription> {
            { "colorFormat"_s, "WebCore::WebGPU::TextureFormat"_s },
            { "depthStencilFormat"_s, "std::optional<WebCore::WebGPU::TextureFormat>"_s },
            { "textureUsage"_s, "WebCore::WebGPU::TextureUsageFlags"_s },
            { "scaleFactor"_s, "double"_s },
            { "identifier"_s, "WebKit::WebGPUIdentifier"_s },
        };
    case MessageName::RemoteXRBinding_GetViewSubImage:
        return Vector<ArgumentDescription> {
            { "projectionLayerIdentifier"_s, "WebKit::WebGPUIdentifier"_s },
            { "identifier"_s, "WebKit::WebGPUIdentifier"_s },
        };
#endif
#if ENABLE(GPU_PROCESS)
#if PLATFORM(COCOA)
    case MessageName::RemoteXRProjectionLayer_StartFrame:
        return Vector<ArgumentDescription> {
            { "frameIndex"_s, "uint64_t"_s },
            { "colorBuffer"_s, "MachSendRight"_s },
            { "depthBuffer"_s, "MachSendRight"_s },
            { "completionSyncEvent"_s, "MachSendRight"_s },
            { "textureIndex"_s, "uint64_t"_s },
        };
#endif
    case MessageName::RemoteXRProjectionLayer_EndFrame:
        return Vector<ArgumentDescription> { };
    case MessageName::RemoteXRProjectionLayer_Destruct:
        return Vector<ArgumentDescription> { };
#endif
#if ENABLE(GPU_PROCESS)
    case MessageName::RemoteXRSubImage_Destruct:
        return Vector<ArgumentDescription> { };
    case MessageName::RemoteXRSubImage_GetColorTexture:
        return Vector<ArgumentDescription> {
            { "identifier"_s, "WebKit::WebGPUIdentifier"_s },
        };
    case MessageName::RemoteXRSubImage_GetDepthTexture:
        return Vector<ArgumentDescription> {
            { "identifier"_s, "WebKit::WebGPUIdentifier"_s },
        };
#endif
#if ENABLE(GPU_PROCESS)
    case MessageName::RemoteXRView_Destruct:
        return Vector<ArgumentDescription> { };
#endif
#if ENABLE(GPU_PROCESS) && ENABLE(WEB_AUDIO)
    case MessageName::RemoteAudioDestinationManager_CreateAudioDestination:
        return Vector<ArgumentDescription> {
            { "identifier"_s, "WebKit::RemoteAudioDestinationIdentifier"_s },
            { "inputDeviceId"_s, "String"_s },
            { "numberOfInputChannels"_s, "uint32_t"_s },
            { "numberOfOutputChannels"_s, "uint32_t"_s },
            { "sampleRate"_s, "float"_s },
            { "hardwareSampleRate"_s, "float"_s },
            { "renderSemaphore"_s, "IPC::Semaphore"_s },
            { "frameCount"_s, "WebCore::SharedMemory::Handle"_s },
        };
    case MessageName::RemoteAudioDestinationManager_DeleteAudioDestination:
        return Vector<ArgumentDescription> {
            { "identifier"_s, "WebKit::RemoteAudioDestinationIdentifier"_s },
        };
    case MessageName::RemoteAudioDestinationManager_StartAudioDestination:
        return Vector<ArgumentDescription> {
            { "identifier"_s, "WebKit::RemoteAudioDestinationIdentifier"_s },
        };
    case MessageName::RemoteAudioDestinationManager_StopAudioDestination:
        return Vector<ArgumentDescription> {
            { "identifier"_s, "WebKit::RemoteAudioDestinationIdentifier"_s },
        };
#if PLATFORM(COCOA)
    case MessageName::RemoteAudioDestinationManager_AudioSamplesStorageChanged:
        return Vector<ArgumentDescription> {
            { "identifier"_s, "WebKit::RemoteAudioDestinationIdentifier"_s },
            { "storageHandle"_s, "WebKit::ConsumerSharedCARingBufferHandle"_s },
        };
#endif
#if PLATFORM(IOS_FAMILY)
    case MessageName::RemoteAudioDestinationManager_SetSceneIdentifier:
        return Vector<ArgumentDescription> {
            { "identifier"_s, "WebKit::RemoteAudioDestinationIdentifier"_s },
            { "sceneIdentifier"_s, "String"_s },
        };
#endif
#endif
#if ENABLE(GPU_PROCESS) && USE(AUDIO_SESSION)
    case MessageName::RemoteAudioSessionProxy_SetCategory:
        return Vector<ArgumentDescription> {
            { "type"_s, "WebCore::AudioSessionCategory"_s },
            { "mode"_s, "WebCore::AudioSessionMode"_s },
            { "policy"_s, "WebCore::RouteSharingPolicy"_s },
        };
    case MessageName::RemoteAudioSessionProxy_SetPreferredBufferSize:
        return Vector<ArgumentDescription> {
            { "preferredBufferSize"_s, "uint64_t"_s },
        };
    case MessageName::RemoteAudioSessionProxy_TryToSetActive:
        return Vector<ArgumentDescription> {
            { "active"_s, "bool"_s },
        };
    case MessageName::RemoteAudioSessionProxy_SetIsPlayingToBluetoothOverride:
        return Vector<ArgumentDescription> {
            { "value"_s, "std::optional<bool>"_s },
        };
    case MessageName::RemoteAudioSessionProxy_TriggerBeginInterruptionForTesting:
        return Vector<ArgumentDescription> { };
    case MessageName::RemoteAudioSessionProxy_TriggerEndInterruptionForTesting:
        return Vector<ArgumentDescription> { };
    case MessageName::RemoteAudioSessionProxy_BeginInterruptionRemote:
        return Vector<ArgumentDescription> { };
    case MessageName::RemoteAudioSessionProxy_EndInterruptionRemote:
        return Vector<ArgumentDescription> {
            { "flags"_s, "WebCore::AudioSessionMayResume"_s },
        };
    case MessageName::RemoteAudioSessionProxy_SetSceneIdentifier:
        return Vector<ArgumentDescription> {
            { "sceneIdentifier"_s, "String"_s },
        };
    case MessageName::RemoteAudioSessionProxy_SetSoundStageSize:
        return Vector<ArgumentDescription> {
            { "size"_s, "WebCore::AudioSessionSoundStageSize"_s },
        };
#endif
#if ENABLE(GPU_PROCESS) && ENABLE(ENCRYPTED_MEDIA)
    case MessageName::RemoteCDMFactoryProxy_CreateCDM:
        return Vector<ArgumentDescription> {
            { "keySystem"_s, "String"_s },
            { "mediaKeysHashSalt"_s, "String"_s },
        };
    case MessageName::RemoteCDMFactoryProxy_SupportsKeySystem:
        return Vector<ArgumentDescription> {
            { "keySystem"_s, "String"_s },
        };
    case MessageName::RemoteCDMFactoryProxy_RemoveInstance:
        return Vector<ArgumentDescription> {
            { "identifier"_s, "WebKit::RemoteCDMInstanceIdentifier"_s },
        };
    case MessageName::RemoteCDMFactoryProxy_RemoveSession:
        return Vector<ArgumentDescription> {
            { "identifier"_s, "WebKit::RemoteCDMInstanceSessionIdentifier"_s },
        };
#endif
#if ENABLE(GPU_PROCESS) && ENABLE(ENCRYPTED_MEDIA)
    case MessageName::RemoteCDMInstanceProxy_CreateSession:
        return Vector<ArgumentDescription> {
            { "logIdentifier"_s, "uint64_t"_s },
        };
    case MessageName::RemoteCDMInstanceProxy_InitializeWithConfiguration:
        return Vector<ArgumentDescription> {
            { "configuration"_s, "WebCore::CDMKeySystemConfiguration"_s },
            { "distinctiveIdentifiersAllowed"_s, "WebCore::CDMInstanceAllowDistinctiveIdentifiers"_s },
            { "persistentStateAllowed"_s, "WebCore::CDMInstanceAllowPersistentState"_s },
        };
    case MessageName::RemoteCDMInstanceProxy_SetServerCertificate:
        return Vector<ArgumentDescription> {
            { "certificate"_s, "Ref<WebCore::SharedBuffer>"_s },
        };
    case MessageName::RemoteCDMInstanceProxy_SetStorageDirectory:
        return Vector<ArgumentDescription> {
            { "directory"_s, "String"_s },
        };
#endif
#if ENABLE(GPU_PROCESS) && ENABLE(ENCRYPTED_MEDIA)
    case MessageName::RemoteCDMInstanceSessionProxy_SetLogIdentifier:
        return Vector<ArgumentDescription> {
            { "logIdentifier"_s, "uint64_t"_s },
        };
    case MessageName::RemoteCDMInstanceSessionProxy_RequestLicense:
        return Vector<ArgumentDescription> {
            { "type"_s, "WebCore::CDMSessionType"_s },
            { "keyGroupingStrategy"_s, "WebCore::CDMKeyGroupingStrategy"_s },
            { "initDataType"_s, "AtomString"_s },
            { "initData"_s, "RefPtr<WebCore::SharedBuffer>"_s },
        };
    case MessageName::RemoteCDMInstanceSessionProxy_UpdateLicense:
        return Vector<ArgumentDescription> {
            { "sessionId"_s, "String"_s },
            { "type"_s, "WebCore::CDMSessionType"_s },
            { "response"_s, "RefPtr<WebCore::SharedBuffer>"_s },
        };
    case MessageName::RemoteCDMInstanceSessionProxy_LoadSession:
        return Vector<ArgumentDescription> {
            { "type"_s, "WebCore::CDMSessionType"_s },
            { "sessionId"_s, "String"_s },
            { "origin"_s, "String"_s },
        };
    case MessageName::RemoteCDMInstanceSessionProxy_CloseSession:
        return Vector<ArgumentDescription> {
            { "sessionId"_s, "String"_s },
        };
    case MessageName::RemoteCDMInstanceSessionProxy_RemoveSessionData:
        return Vector<ArgumentDescription> {
            { "sessionId"_s, "String"_s },
            { "type"_s, "WebCore::CDMSessionType"_s },
        };
    case MessageNa