/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSGPUBufferDescriptor.h"

#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertOptional.h"
#include "JSDOMConvertStrings.h"
#include <JavaScriptCore/JSCInlines.h>



namespace WebCore {
using namespace JSC;

template<> ConversionResult<IDLDictionary<GPUBufferDescriptor>> convertDictionary<GPUBufferDescriptor>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (!isNullOrUndefined && !object) [[unlikely]] {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return ConversionResultException { };
    }
    GPUBufferDescriptor result;
    JSValue labelValue;
    if (isNullOrUndefined)
        labelValue = jsUndefined();
    else {
        labelValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "label"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!labelValue.isUndefined()) {
        auto labelConversionResult = convert<IDLUSVString>(lexicalGlobalObject, labelValue);
        if (labelConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.label = labelConversionResult.releaseReturnValue();
    }
    JSValue mappedAtCreationValue;
    if (isNullOrUndefined)
        mappedAtCreationValue = jsUndefined();
    else {
        mappedAtCreationValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "mappedAtCreation"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto mappedAtCreationConversionResult = convertOptionalWithDefault<IDLBoolean>(lexicalGlobalObject, mappedAtCreationValue, [&]() -> ConversionResult<IDLBoolean> { return Converter<IDLBoolean>::ReturnType { false }; });
    if (mappedAtCreationConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.mappedAtCreation = mappedAtCreationConversionResult.releaseReturnValue();
    JSValue sizeValue;
    if (isNullOrUndefined)
        sizeValue = jsUndefined();
    else {
        sizeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "size"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (sizeValue.isUndefined()) {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "size"_s, "GPUBufferDescriptor"_s, "unsigned long long"_s);
        return ConversionResultException { };
    }
    auto sizeConversionResult = convert<IDLEnforceRangeAdaptor<IDLUnsignedLongLong>>(lexicalGlobalObject, sizeValue);
    if (sizeConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.size = sizeConversionResult.releaseReturnValue();
    JSValue usageValue;
    if (isNullOrUndefined)
        usageValue = jsUndefined();
    else {
        usageValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "usage"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (usageValue.isUndefined()) {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "usage"_s, "GPUBufferDescriptor"_s, "unsigned long"_s);
        return ConversionResultException { };
    }
    auto usageConversionResult = convert<IDLEnforceRangeAdaptor<IDLUnsignedLong>>(lexicalGlobalObject, usageValue);
    if (usageConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.usage = usageConversionResult.releaseReturnValue();
    return result;
}

} // namespace WebCore

