/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(MEDIA_STREAM)

#include "JSMediaDeviceInfo.h"

#include "ActiveDOMObject.h"
#include "ContextDestructionObserverInlines.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/JSString.h>
#include <JavaScriptCore/ObjectConstructor.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/SortedArrayMap.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>

namespace WebCore {
using namespace JSC;

String convertEnumerationToString(MediaDeviceInfo::Kind enumerationValue)
{
    static const std::array<NeverDestroyed<String>, 3> values {
        MAKE_STATIC_STRING_IMPL("audioinput"),
        MAKE_STATIC_STRING_IMPL("audiooutput"),
        MAKE_STATIC_STRING_IMPL("videoinput"),
    };
    static_assert(static_cast<size_t>(MediaDeviceInfo::Kind::Audioinput) == 0, "MediaDeviceInfo::Kind::Audioinput is not 0 as expected");
    static_assert(static_cast<size_t>(MediaDeviceInfo::Kind::Audiooutput) == 1, "MediaDeviceInfo::Kind::Audiooutput is not 1 as expected");
    static_assert(static_cast<size_t>(MediaDeviceInfo::Kind::Videoinput) == 2, "MediaDeviceInfo::Kind::Videoinput is not 2 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < std::size(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(VM& vm, MediaDeviceInfo::Kind enumerationValue)
{
    return jsStringWithCache(vm, convertEnumerationToString(enumerationValue));
}

template<> std::optional<MediaDeviceInfo::Kind> parseEnumerationFromString<MediaDeviceInfo::Kind>(const String& stringValue)
{
    static constexpr std::array<std::pair<ComparableASCIILiteral, MediaDeviceInfo::Kind>, 3> mappings {
        std::pair<ComparableASCIILiteral, MediaDeviceInfo::Kind> { "audioinput"_s, MediaDeviceInfo::Kind::Audioinput },
        std::pair<ComparableASCIILiteral, MediaDeviceInfo::Kind> { "audiooutput"_s, MediaDeviceInfo::Kind::Audiooutput },
        std::pair<ComparableASCIILiteral, MediaDeviceInfo::Kind> { "videoinput"_s, MediaDeviceInfo::Kind::Videoinput },
    };
    static constexpr SortedArrayMap enumerationMapping { mappings };
    if (auto* enumerationValue = enumerationMapping.tryGet(stringValue); enumerationValue) [[likely]]
        return *enumerationValue;
    return std::nullopt;
}

template<> std::optional<MediaDeviceInfo::Kind> parseEnumeration<MediaDeviceInfo::Kind>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    return parseEnumerationFromString<MediaDeviceInfo::Kind>(value.toWTFString(&lexicalGlobalObject));
}

template<> ASCIILiteral expectedEnumerationValues<MediaDeviceInfo::Kind>()
{
    return "\"audioinput\", \"audiooutput\", \"videoinput\""_s;
}

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsMediaDeviceInfoPrototypeFunction_toJSON);

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsMediaDeviceInfoConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsMediaDeviceInfo_deviceId);
static JSC_DECLARE_CUSTOM_GETTER(jsMediaDeviceInfo_kind);
static JSC_DECLARE_CUSTOM_GETTER(jsMediaDeviceInfo_label);
static JSC_DECLARE_CUSTOM_GETTER(jsMediaDeviceInfo_groupId);

class JSMediaDeviceInfoPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSMediaDeviceInfoPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSMediaDeviceInfoPrototype* ptr = new (NotNull, JSC::allocateCell<JSMediaDeviceInfoPrototype>(vm)) JSMediaDeviceInfoPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSMediaDeviceInfoPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSMediaDeviceInfoPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSMediaDeviceInfoPrototype, JSMediaDeviceInfoPrototype::Base);

using JSMediaDeviceInfoDOMConstructor = JSDOMConstructorNotConstructable<JSMediaDeviceInfo>;

template<> const ClassInfo JSMediaDeviceInfoDOMConstructor::s_info = { "MediaDeviceInfo"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSMediaDeviceInfoDOMConstructor) };

template<> JSValue JSMediaDeviceInfoDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSMediaDeviceInfoDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "MediaDeviceInfo"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSMediaDeviceInfo::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const std::array<HashTableValue, 6> JSMediaDeviceInfoPrototypeTableValues {
    HashTableValue { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsMediaDeviceInfoConstructor, 0 } },
    HashTableValue { "deviceId"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsMediaDeviceInfo_deviceId, 0 } },
    HashTableValue { "kind"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsMediaDeviceInfo_kind, 0 } },
    HashTableValue { "label"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsMediaDeviceInfo_label, 0 } },
    HashTableValue { "groupId"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsMediaDeviceInfo_groupId, 0 } },
    HashTableValue { "toJSON"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsMediaDeviceInfoPrototypeFunction_toJSON, 0 } },
};

const ClassInfo JSMediaDeviceInfoPrototype::s_info = { "MediaDeviceInfo"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSMediaDeviceInfoPrototype) };

void JSMediaDeviceInfoPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSMediaDeviceInfo::info(), JSMediaDeviceInfoPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSMediaDeviceInfo::s_info = { "MediaDeviceInfo"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSMediaDeviceInfo) };

JSMediaDeviceInfo::JSMediaDeviceInfo(Structure* structure, JSDOMGlobalObject& globalObject, Ref<MediaDeviceInfo>&& impl)
    : JSDOMWrapper<MediaDeviceInfo>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, MediaDeviceInfo>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSMediaDeviceInfo::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSMediaDeviceInfoPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSMediaDeviceInfoPrototype::create(vm, &globalObject, structure);
}

JSObject* JSMediaDeviceInfo::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSMediaDeviceInfo>(vm, globalObject);
}

JSValue JSMediaDeviceInfo::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSMediaDeviceInfoDOMConstructor, DOMConstructorID::MediaDeviceInfo>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSMediaDeviceInfo::destroy(JSC::JSCell* cell)
{
    JSMediaDeviceInfo* thisObject = static_cast<JSMediaDeviceInfo*>(cell);
    thisObject->JSMediaDeviceInfo::~JSMediaDeviceInfo();
}

JSC_DEFINE_CUSTOM_GETTER(jsMediaDeviceInfoConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSMediaDeviceInfoPrototype*>(JSValue::decode(thisValue));
    if (!prototype) [[unlikely]]
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSMediaDeviceInfo::getConstructor(vm, prototype->globalObject()));
}

static inline JSValue jsMediaDeviceInfo_deviceIdGetter(JSGlobalObject& lexicalGlobalObject, JSMediaDeviceInfo& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.deviceId())));
}

JSC_DEFINE_CUSTOM_GETTER(jsMediaDeviceInfo_deviceId, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSMediaDeviceInfo>::get<jsMediaDeviceInfo_deviceIdGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsMediaDeviceInfo_kindGetter(JSGlobalObject& lexicalGlobalObject, JSMediaDeviceInfo& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLEnumeration<MediaDeviceInfo::Kind>>(lexicalGlobalObject, throwScope, impl.kind())));
}

JSC_DEFINE_CUSTOM_GETTER(jsMediaDeviceInfo_kind, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSMediaDeviceInfo>::get<jsMediaDeviceInfo_kindGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsMediaDeviceInfo_labelGetter(JSGlobalObject& lexicalGlobalObject, JSMediaDeviceInfo& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.label())));
}

JSC_DEFINE_CUSTOM_GETTER(jsMediaDeviceInfo_label, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSMediaDeviceInfo>::get<jsMediaDeviceInfo_labelGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsMediaDeviceInfo_groupIdGetter(JSGlobalObject& lexicalGlobalObject, JSMediaDeviceInfo& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.groupId())));
}

JSC_DEFINE_CUSTOM_GETTER(jsMediaDeviceInfo_groupId, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSMediaDeviceInfo>::get<jsMediaDeviceInfo_groupIdGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline EncodedJSValue jsMediaDeviceInfoPrototypeFunction_toJSONBody(JSGlobalObject* lexicalGlobalObject, CallFrame*, JSMediaDeviceInfo* castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    auto* result = constructEmptyObject(lexicalGlobalObject);
    auto deviceIdValue = toJS<IDLDOMString>(*lexicalGlobalObject, throwScope, impl.deviceId());
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, Identifier::fromString(vm, "deviceId"_s), deviceIdValue);
    auto kindValue = toJS<IDLEnumeration<MediaDeviceInfo::Kind>>(*lexicalGlobalObject, throwScope, impl.kind());
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, Identifier::fromString(vm, "kind"_s), kindValue);
    auto labelValue = toJS<IDLDOMString>(*lexicalGlobalObject, throwScope, impl.label());
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, Identifier::fromString(vm, "label"_s), labelValue);
    auto groupIdValue = toJS<IDLDOMString>(*lexicalGlobalObject, throwScope, impl.groupId());
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, Identifier::fromString(vm, "groupId"_s), groupIdValue);
    return JSValue::encode(result);
}

JSC_DEFINE_HOST_FUNCTION(jsMediaDeviceInfoPrototypeFunction_toJSON, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSMediaDeviceInfo>::call<jsMediaDeviceInfoPrototypeFunction_toJSONBody>(*lexicalGlobalObject, *callFrame, "toJSON");
}

JSC::GCClient::IsoSubspace* JSMediaDeviceInfo::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSMediaDeviceInfo, UseCustomHeapCellType::No>(vm, "JSMediaDeviceInfo"_s,
        [] (auto& spaces) { return spaces.m_clientSubspaceForMediaDeviceInfo.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForMediaDeviceInfo = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForMediaDeviceInfo.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForMediaDeviceInfo = std::forward<decltype(space)>(space); }
    );
}

void JSMediaDeviceInfo::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSMediaDeviceInfo*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (RefPtr context = thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, context->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

bool JSMediaDeviceInfoOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, ASCIILiteral* reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSMediaDeviceInfoOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsMediaDeviceInfo = static_cast<JSMediaDeviceInfo*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsMediaDeviceInfo->protectedWrapped().ptr(), jsMediaDeviceInfo);
}

WTF_ALLOW_UNSAFE_BUFFER_USAGE_BEGIN
#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7MediaDeviceInfo@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore15MediaDeviceInfoE[]; }
#endif
template<std::same_as<MediaDeviceInfo> T>
static inline void verifyVTable(MediaDeviceInfo* ptr) 
{
    if constexpr (std::is_polymorphic_v<T>) {
        const void* actualVTablePointer = getVTablePointer<T>(ptr);
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7MediaDeviceInfo@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore15MediaDeviceInfoE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // MediaDeviceInfo has subclasses. If MediaDeviceInfo has subclasses that get passed
        // to toJS() we currently require MediaDeviceInfo you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
    }
}
#endif
WTF_ALLOW_UNSAFE_BUFFER_USAGE_END

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<MediaDeviceInfo>&& impl)
{
#if ENABLE(BINDING_INTEGRITY)
    verifyVTable<MediaDeviceInfo>(impl.ptr());
#endif
    return createWrapper<MediaDeviceInfo>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, MediaDeviceInfo& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

MediaDeviceInfo* JSMediaDeviceInfo::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSMediaDeviceInfo*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(MEDIA_STREAM)
