/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(SPEECH_SYNTHESIS)

#include "JSSpeechSynthesisEventInit.h"

#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertOptional.h"
#include "JSDOMConvertStrings.h"
#include "JSSpeechSynthesisUtterance.h"
#include <JavaScriptCore/JSCInlines.h>



namespace WebCore {
using namespace JSC;

#if ENABLE(SPEECH_SYNTHESIS)

template<> ConversionResult<IDLDictionary<SpeechSynthesisEventInit>> convertDictionary<SpeechSynthesisEventInit>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (!isNullOrUndefined && !object) [[unlikely]] {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return ConversionResultException { };
    }
    SpeechSynthesisEventInit result;
    JSValue bubblesValue;
    if (isNullOrUndefined)
        bubblesValue = jsUndefined();
    else {
        bubblesValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "bubbles"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto bubblesConversionResult = convertOptionalWithDefault<IDLBoolean>(lexicalGlobalObject, bubblesValue, [&]() -> ConversionResult<IDLBoolean> { return Converter<IDLBoolean>::ReturnType { false }; });
    if (bubblesConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.bubbles = bubblesConversionResult.releaseReturnValue();
    JSValue cancelableValue;
    if (isNullOrUndefined)
        cancelableValue = jsUndefined();
    else {
        cancelableValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "cancelable"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto cancelableConversionResult = convertOptionalWithDefault<IDLBoolean>(lexicalGlobalObject, cancelableValue, [&]() -> ConversionResult<IDLBoolean> { return Converter<IDLBoolean>::ReturnType { false }; });
    if (cancelableConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.cancelable = cancelableConversionResult.releaseReturnValue();
    JSValue composedValue;
    if (isNullOrUndefined)
        composedValue = jsUndefined();
    else {
        composedValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "composed"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto composedConversionResult = convertOptionalWithDefault<IDLBoolean>(lexicalGlobalObject, composedValue, [&]() -> ConversionResult<IDLBoolean> { return Converter<IDLBoolean>::ReturnType { false }; });
    if (composedConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.composed = composedConversionResult.releaseReturnValue();
    JSValue charIndexValue;
    if (isNullOrUndefined)
        charIndexValue = jsUndefined();
    else {
        charIndexValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "charIndex"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto charIndexConversionResult = convertOptionalWithDefault<IDLUnsignedLong>(lexicalGlobalObject, charIndexValue, [&]() -> ConversionResult<IDLUnsignedLong> { return Converter<IDLUnsignedLong>::ReturnType { 0 }; });
    if (charIndexConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.charIndex = charIndexConversionResult.releaseReturnValue();
    JSValue charLengthValue;
    if (isNullOrUndefined)
        charLengthValue = jsUndefined();
    else {
        charLengthValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "charLength"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto charLengthConversionResult = convertOptionalWithDefault<IDLUnsignedLong>(lexicalGlobalObject, charLengthValue, [&]() -> ConversionResult<IDLUnsignedLong> { return Converter<IDLUnsignedLong>::ReturnType { 0 }; });
    if (charLengthConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.charLength = charLengthConversionResult.releaseReturnValue();
    JSValue elapsedTimeValue;
    if (isNullOrUndefined)
        elapsedTimeValue = jsUndefined();
    else {
        elapsedTimeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "elapsedTime"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto elapsedTimeConversionResult = convertOptionalWithDefault<IDLFloat>(lexicalGlobalObject, elapsedTimeValue, [&]() -> ConversionResult<IDLFloat> { return Converter<IDLFloat>::ReturnType { 0 }; });
    if (elapsedTimeConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.elapsedTime = elapsedTimeConversionResult.releaseReturnValue();
    JSValue nameValue;
    if (isNullOrUndefined)
        nameValue = jsUndefined();
    else {
        nameValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "name"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto nameConversionResult = convertOptionalWithDefault<IDLDOMString>(lexicalGlobalObject, nameValue, [&]() -> ConversionResult<IDLDOMString> { return Converter<IDLDOMString>::ReturnType { emptyString() }; });
    if (nameConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.name = nameConversionResult.releaseReturnValue();
    JSValue utteranceValue;
    if (isNullOrUndefined)
        utteranceValue = jsUndefined();
    else {
        utteranceValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "utterance"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (utteranceValue.isUndefined()) {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "utterance"_s, "SpeechSynthesisEventInit"_s, "SpeechSynthesisUtterance"_s);
        return ConversionResultException { };
    }
    auto utteranceConversionResult = convert<IDLInterface<SpeechSynthesisUtterance>>(lexicalGlobalObject, utteranceValue);
    if (utteranceConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.utterance = utteranceConversionResult.releaseReturnValue();
    return result;
}

#endif

} // namespace WebCore


#endif // ENABLE(SPEECH_SYNTHESIS)
