// This file is automatically generated from CSSProperties.json by the process-css-properties.py script. Do not edit it.

#pragma once

#include <array>
#include <wtf/HashFunctions.h>
#include <wtf/HashTraits.h>

namespace WebCore {

class Settings;

enum CSSPropertyID : uint16_t {
    CSSPropertyInvalid = 0,
    CSSPropertyCustom = 1,
    CSSPropertyColorScheme = 2,
    CSSPropertyRubyPosition = 3,
    CSSPropertyWritingMode = 4,
    CSSPropertyDirection = 5,
    CSSPropertyDisplay = 6,
    CSSPropertyFontFamily = 7,
    CSSPropertyFontFeatureSettings = 8,
    CSSPropertyFontKerning = 9,
    CSSPropertyFontOpticalSizing = 10,
    CSSPropertyFontPalette = 11,
    CSSPropertyFontSize = 12,
    CSSPropertyFontSizeAdjust = 13,
    CSSPropertyFontStyle = 14,
    CSSPropertyFontSynthesisSmallCaps = 15,
    CSSPropertyFontSynthesisStyle = 16,
    CSSPropertyFontSynthesisWeight = 17,
    CSSPropertyFontVariantAlternates = 18,
    CSSPropertyFontVariantCaps = 19,
    CSSPropertyFontVariantEastAsian = 20,
    CSSPropertyFontVariantEmoji = 21,
    CSSPropertyFontVariantLigatures = 22,
    CSSPropertyFontVariantNumeric = 23,
    CSSPropertyFontVariantPosition = 24,
    CSSPropertyFontVariationSettings = 25,
    CSSPropertyFontWeight = 26,
    CSSPropertyFontWidth = 27,
    CSSPropertyTextOrientation = 28,
    CSSPropertyTextRendering = 29,
    CSSPropertyZoom = 30,
    CSSPropertyWebkitFontSmoothing = 31,
    CSSPropertyWebkitLocale = 32,
    CSSPropertyWebkitTextZoom = 33,
    CSSPropertyLetterSpacing = 34,
    CSSPropertyTextAutospace = 35,
    CSSPropertyTextSpacingTrim = 36,
    CSSPropertyAccentColor = 37,
    CSSPropertyAdditiveSymbols = 38,
    CSSPropertyAlignContent = 39,
    CSSPropertyAlignItems = 40,
    CSSPropertyAlignSelf = 41,
    CSSPropertyAlignmentBaseline = 42,
    CSSPropertyAnchorName = 43,
    CSSPropertyAnchorScope = 44,
    CSSPropertyAnimationComposition = 45,
    CSSPropertyAnimationDelay = 46,
    CSSPropertyAnimationDirection = 47,
    CSSPropertyAnimationDuration = 48,
    CSSPropertyAnimationFillMode = 49,
    CSSPropertyAnimationIterationCount = 50,
    CSSPropertyAnimationName = 51,
    CSSPropertyAnimationPlayState = 52,
    CSSPropertyAnimationRangeEnd = 53,
    CSSPropertyAnimationRangeStart = 54,
    CSSPropertyAnimationTimeline = 55,
    CSSPropertyAnimationTimingFunction = 56,
    CSSPropertyAppearance = 57,
    CSSPropertyAspectRatio = 58,
    CSSPropertyBackdropFilter = 59,
    CSSPropertyBackfaceVisibility = 60,
    CSSPropertyBackgroundAttachment = 61,
    CSSPropertyBackgroundBlendMode = 62,
    CSSPropertyBackgroundClip = 63,
    CSSPropertyBackgroundColor = 64,
    CSSPropertyBackgroundImage = 65,
    CSSPropertyBackgroundOrigin = 66,
    CSSPropertyBackgroundPositionX = 67,
    CSSPropertyBackgroundPositionY = 68,
    CSSPropertyBackgroundRepeat = 69,
    CSSPropertyBackgroundSize = 70,
    CSSPropertyBasePalette = 71,
    CSSPropertyBaselineShift = 72,
    CSSPropertyBlockEllipsis = 73,
    CSSPropertyBlockStepAlign = 74,
    CSSPropertyBlockStepInsert = 75,
    CSSPropertyBlockStepRound = 76,
    CSSPropertyBlockStepSize = 77,
    CSSPropertyBorderCollapse = 78,
    CSSPropertyBorderImageOutset = 79,
    CSSPropertyBorderImageRepeat = 80,
    CSSPropertyBorderImageSlice = 81,
    CSSPropertyBorderImageSource = 82,
    CSSPropertyBorderImageWidth = 83,
    CSSPropertyBoxShadow = 84,
    CSSPropertyBoxSizing = 85,
    CSSPropertyBreakAfter = 86,
    CSSPropertyBreakBefore = 87,
    CSSPropertyBreakInside = 88,
    CSSPropertyBufferedRendering = 89,
    CSSPropertyCaptionSide = 90,
    CSSPropertyCaretColor = 91,
    CSSPropertyClear = 92,
    CSSPropertyClip = 93,
    CSSPropertyClipPath = 94,
    CSSPropertyClipRule = 95,
    CSSPropertyColor = 96,
    CSSPropertyColorInterpolation = 97,
    CSSPropertyColorInterpolationFilters = 98,
    CSSPropertyColumnCount = 99,
    CSSPropertyColumnFill = 100,
    CSSPropertyColumnGap = 101,
    CSSPropertyColumnRuleColor = 102,
    CSSPropertyColumnRuleStyle = 103,
    CSSPropertyColumnRuleWidth = 104,
    CSSPropertyColumnSpan = 105,
    CSSPropertyColumnWidth = 106,
    CSSPropertyContain = 107,
    CSSPropertyContainerName = 108,
    CSSPropertyContainerType = 109,
    CSSPropertyContent = 110,
    CSSPropertyContentVisibility = 111,
    CSSPropertyContinue = 112,
    CSSPropertyCounterIncrement = 113,
    CSSPropertyCounterReset = 114,
    CSSPropertyCounterSet = 115,
    CSSPropertyCursor = 116,
    CSSPropertyCx = 117,
    CSSPropertyCy = 118,
    CSSPropertyD = 119,
    CSSPropertyDominantBaseline = 120,
    CSSPropertyDynamicRangeLimit = 121,
    CSSPropertyEmptyCells = 122,
    CSSPropertyFallback = 123,
    CSSPropertyFieldSizing = 124,
    CSSPropertyFill = 125,
    CSSPropertyFillOpacity = 126,
    CSSPropertyFillRule = 127,
    CSSPropertyFilter = 128,
    CSSPropertyFlexBasis = 129,
    CSSPropertyFlexDirection = 130,
    CSSPropertyFlexGrow = 131,
    CSSPropertyFlexShrink = 132,
    CSSPropertyFlexWrap = 133,
    CSSPropertyFloat = 134,
    CSSPropertyFloodColor = 135,
    CSSPropertyFloodOpacity = 136,
    CSSPropertyFontDisplay = 137,
    CSSPropertyGlyphOrientationHorizontal = 138,
    CSSPropertyGlyphOrientationVertical = 139,
    CSSPropertyGridAutoColumns = 140,
    CSSPropertyGridAutoFlow = 141,
    CSSPropertyGridAutoRows = 142,
    CSSPropertyGridColumnEnd = 143,
    CSSPropertyGridColumnStart = 144,
    CSSPropertyGridRowEnd = 145,
    CSSPropertyGridRowStart = 146,
    CSSPropertyGridTemplateAreas = 147,
    CSSPropertyGridTemplateColumns = 148,
    CSSPropertyGridTemplateRows = 149,
    CSSPropertyHangingPunctuation = 150,
    CSSPropertyHyphenateCharacter = 151,
    CSSPropertyHyphens = 152,
    CSSPropertyImageOrientation = 153,
    CSSPropertyImageRendering = 154,
    CSSPropertyInherits = 155,
    CSSPropertyInitialValue = 156,
    CSSPropertyInputSecurity = 157,
    CSSPropertyIsolation = 158,
    CSSPropertyJustifyContent = 159,
    CSSPropertyJustifyItems = 160,
    CSSPropertyJustifySelf = 161,
    CSSPropertyLightingColor = 162,
    CSSPropertyLineBreak = 163,
    CSSPropertyLineFitEdge = 164,
    CSSPropertyLineHeight = 165,
    CSSPropertyListStyleImage = 166,
    CSSPropertyListStylePosition = 167,
    CSSPropertyListStyleType = 168,
    CSSPropertyMarginTrim = 169,
    CSSPropertyMarkerEnd = 170,
    CSSPropertyMarkerMid = 171,
    CSSPropertyMarkerStart = 172,
    CSSPropertyMaskBorderOutset = 173,
    CSSPropertyMaskBorderRepeat = 174,
    CSSPropertyMaskBorderSlice = 175,
    CSSPropertyMaskBorderSource = 176,
    CSSPropertyMaskBorderWidth = 177,
    CSSPropertyMaskClip = 178,
    CSSPropertyMaskComposite = 179,
    CSSPropertyMaskImage = 180,
    CSSPropertyMaskMode = 181,
    CSSPropertyMaskOrigin = 182,
    CSSPropertyMaskRepeat = 183,
    CSSPropertyMaskSize = 184,
    CSSPropertyMaskType = 185,
    CSSPropertyMathStyle = 186,
    CSSPropertyMaxLines = 187,
    CSSPropertyMixBlendMode = 188,
    CSSPropertyNavigation = 189,
    CSSPropertyNegative = 190,
    CSSPropertyObjectFit = 191,
    CSSPropertyObjectPosition = 192,
    CSSPropertyOffsetAnchor = 193,
    CSSPropertyOffsetDistance = 194,
    CSSPropertyOffsetPath = 195,
    CSSPropertyOffsetPosition = 196,
    CSSPropertyOffsetRotate = 197,
    CSSPropertyOpacity = 198,
    CSSPropertyOrder = 199,
    CSSPropertyOrphans = 200,
    CSSPropertyOutlineColor = 201,
    CSSPropertyOutlineOffset = 202,
    CSSPropertyOutlineStyle = 203,
    CSSPropertyOutlineWidth = 204,
    CSSPropertyOverflowAnchor = 205,
    CSSPropertyOverflowWrap = 206,
    CSSPropertyOverrideColors = 207,
    CSSPropertyPad = 208,
    CSSPropertyPage = 209,
    CSSPropertyPaintOrder = 210,
    CSSPropertyPerspective = 211,
    CSSPropertyPerspectiveOriginX = 212,
    CSSPropertyPerspectiveOriginY = 213,
    CSSPropertyPointerEvents = 214,
    CSSPropertyPosition = 215,
    CSSPropertyPositionAnchor = 216,
    CSSPropertyPositionArea = 217,
    CSSPropertyPositionTryFallbacks = 218,
    CSSPropertyPositionTryOrder = 219,
    CSSPropertyPositionVisibility = 220,
    CSSPropertyPrefix = 221,
    CSSPropertyPrintColorAdjust = 222,
    CSSPropertyQuotes = 223,
    CSSPropertyR = 224,
    CSSPropertyRange = 225,
    CSSPropertyResize = 226,
    CSSPropertyRotate = 227,
    CSSPropertyRowGap = 228,
    CSSPropertyRubyAlign = 229,
    CSSPropertyRubyOverhang = 230,
    CSSPropertyRx = 231,
    CSSPropertyRy = 232,
    CSSPropertyScale = 233,
    CSSPropertyScrollBehavior = 234,
    CSSPropertyScrollSnapAlign = 235,
    CSSPropertyScrollSnapStop = 236,
    CSSPropertyScrollSnapType = 237,
    CSSPropertyScrollTimelineAxis = 238,
    CSSPropertyScrollTimelineName = 239,
    CSSPropertyScrollbarColor = 240,
    CSSPropertyScrollbarGutter = 241,
    CSSPropertyScrollbarWidth = 242,
    CSSPropertyShapeImageThreshold = 243,
    CSSPropertyShapeMargin = 244,
    CSSPropertyShapeOutside = 245,
    CSSPropertyShapeRendering = 246,
    CSSPropertySize = 247,
    CSSPropertySizeAdjust = 248,
    CSSPropertySpeakAs = 249,
    CSSPropertySrc = 250,
    CSSPropertyStopColor = 251,
    CSSPropertyStopOpacity = 252,
    CSSPropertyStroke = 253,
    CSSPropertyStrokeColor = 254,
    CSSPropertyStrokeDasharray = 255,
    CSSPropertyStrokeDashoffset = 256,
    CSSPropertyStrokeLinecap = 257,
    CSSPropertyStrokeLinejoin = 258,
    CSSPropertyStrokeMiterlimit = 259,
    CSSPropertyStrokeOpacity = 260,
    CSSPropertyStrokeWidth = 261,
    CSSPropertySuffix = 262,
    CSSPropertySymbols = 263,
    CSSPropertySyntax = 264,
    CSSPropertySystem = 265,
    CSSPropertyTabSize = 266,
    CSSPropertyTableLayout = 267,
    CSSPropertyTextAlign = 268,
    CSSPropertyTextAlignLast = 269,
    CSSPropertyTextAnchor = 270,
    CSSPropertyTextBoxEdge = 271,
    CSSPropertyTextBoxTrim = 272,
    CSSPropertyTextCombineUpright = 273,
    CSSPropertyTextDecorationColor = 274,
    CSSPropertyTextDecorationLine = 275,
    CSSPropertyTextDecorationSkipInk = 276,
    CSSPropertyTextDecorationStyle = 277,
    CSSPropertyTextDecorationThickness = 278,
    CSSPropertyTextEmphasisColor = 279,
    CSSPropertyTextEmphasisPosition = 280,
    CSSPropertyTextEmphasisStyle = 281,
    CSSPropertyTextGroupAlign = 282,
    CSSPropertyTextIndent = 283,
    CSSPropertyTextJustify = 284,
    CSSPropertyTextOverflow = 285,
    CSSPropertyTextShadow = 286,
    CSSPropertyTextTransform = 287,
    CSSPropertyTextUnderlineOffset = 288,
    CSSPropertyTextUnderlinePosition = 289,
    CSSPropertyTextWrapMode = 290,
    CSSPropertyTextWrapStyle = 291,
    CSSPropertyTimelineScope = 292,
    CSSPropertyTouchAction = 293,
    CSSPropertyTransform = 294,
    CSSPropertyTransformBox = 295,
    CSSPropertyTransformOriginX = 296,
    CSSPropertyTransformOriginY = 297,
    CSSPropertyTransformOriginZ = 298,
    CSSPropertyTransformStyle = 299,
    CSSPropertyTransitionBehavior = 300,
    CSSPropertyTransitionDelay = 301,
    CSSPropertyTransitionDuration = 302,
    CSSPropertyTransitionProperty = 303,
    CSSPropertyTransitionTimingFunction = 304,
    CSSPropertyTranslate = 305,
    CSSPropertyTypes = 306,
    CSSPropertyUnicodeBidi = 307,
    CSSPropertyUnicodeRange = 308,
    CSSPropertyVectorEffect = 309,
    CSSPropertyVerticalAlign = 310,
    CSSPropertyViewTimelineAxis = 311,
    CSSPropertyViewTimelineInset = 312,
    CSSPropertyViewTimelineName = 313,
    CSSPropertyViewTransitionClass = 314,
    CSSPropertyViewTransitionName = 315,
    CSSPropertyVisibility = 316,
    CSSPropertyWhiteSpaceCollapse = 317,
    CSSPropertyWidows = 318,
    CSSPropertyWillChange = 319,
    CSSPropertyWordBreak = 320,
    CSSPropertyX = 321,
    CSSPropertyY = 322,
    CSSPropertyZIndex = 323,
    CSSPropertyAppleColorFilter = 324,
    CSSPropertyWebkitBackdropFilter = 325,
    CSSPropertyWebkitBackgroundClip = 326,
    CSSPropertyWebkitBackgroundOrigin = 327,
    CSSPropertyWebkitBorderHorizontalSpacing = 328,
    CSSPropertyWebkitBorderVerticalSpacing = 329,
    CSSPropertyWebkitBoxAlign = 330,
    CSSPropertyWebkitBoxDecorationBreak = 331,
    CSSPropertyWebkitBoxDirection = 332,
    CSSPropertyWebkitBoxFlex = 333,
    CSSPropertyWebkitBoxFlexGroup = 334,
    CSSPropertyWebkitBoxLines = 335,
    CSSPropertyWebkitBoxOrdinalGroup = 336,
    CSSPropertyWebkitBoxOrient = 337,
    CSSPropertyWebkitBoxPack = 338,
    CSSPropertyWebkitBoxReflect = 339,
    CSSPropertyWebkitBoxShadow = 340,
    CSSPropertyWebkitColumnAxis = 341,
    CSSPropertyWebkitColumnProgression = 342,
    CSSPropertyWebkitCursorVisibility = 343,
    CSSPropertyWebkitFontSizeDelta = 344,
    CSSPropertyWebkitHyphenateLimitAfter = 345,
    CSSPropertyWebkitHyphenateLimitBefore = 346,
    CSSPropertyWebkitHyphenateLimitLines = 347,
    CSSPropertyWebkitInitialLetter = 348,
    CSSPropertyWebkitLineAlign = 349,
    CSSPropertyWebkitLineBoxContain = 350,
    CSSPropertyWebkitLineClamp = 351,
    CSSPropertyWebkitLineGrid = 352,
    CSSPropertyWebkitLineSnap = 353,
    CSSPropertyWebkitMarqueeDirection = 354,
    CSSPropertyWebkitMarqueeIncrement = 355,
    CSSPropertyWebkitMarqueeRepetition = 356,
    CSSPropertyWebkitMarqueeSpeed = 357,
    CSSPropertyWebkitMarqueeStyle = 358,
    CSSPropertyWebkitMaskClip = 359,
    CSSPropertyWebkitMaskComposite = 360,
    CSSPropertyWebkitMaskPositionX = 361,
    CSSPropertyWebkitMaskPositionY = 362,
    CSSPropertyWebkitMaskSourceType = 363,
    CSSPropertyWebkitNbspMode = 364,
    CSSPropertyWebkitRtlOrdering = 365,
    CSSPropertyWebkitRubyPosition = 366,
    CSSPropertyWebkitTapHighlightColor = 367,
    CSSPropertyWebkitTextCombine = 368,
    CSSPropertyWebkitTextDecorationsInEffect = 369,
    CSSPropertyWebkitTextFillColor = 370,
    CSSPropertyWebkitTextSecurity = 371,
    CSSPropertyWebkitTextStrokeColor = 372,
    CSSPropertyWebkitTextStrokeWidth = 373,
    CSSPropertyWebkitUserDrag = 374,
    CSSPropertyWebkitUserModify = 375,
    CSSPropertyWebkitUserSelect = 376,
    CSSPropertyWordSpacing = 377,
    CSSPropertyBorderBottomColor = 378,
    CSSPropertyBorderBottomLeftRadius = 379,
    CSSPropertyBorderBottomRightRadius = 380,
    CSSPropertyBorderBottomStyle = 381,
    CSSPropertyBorderBottomWidth = 382,
    CSSPropertyBorderLeftColor = 383,
    CSSPropertyBorderLeftStyle = 384,
    CSSPropertyBorderLeftWidth = 385,
    CSSPropertyBorderRightColor = 386,
    CSSPropertyBorderRightStyle = 387,
    CSSPropertyBorderRightWidth = 388,
    CSSPropertyBorderTopColor = 389,
    CSSPropertyBorderTopLeftRadius = 390,
    CSSPropertyBorderTopRightRadius = 391,
    CSSPropertyBorderTopStyle = 392,
    CSSPropertyBorderTopWidth = 393,
    CSSPropertyBottom = 394,
    CSSPropertyContainIntrinsicHeight = 395,
    CSSPropertyContainIntrinsicWidth = 396,
    CSSPropertyCornerBottomLeftShape = 397,
    CSSPropertyCornerBottomRightShape = 398,
    CSSPropertyCornerTopLeftShape = 399,
    CSSPropertyCornerTopRightShape = 400,
    CSSPropertyHeight = 401,
    CSSPropertyLeft = 402,
    CSSPropertyMarginBottom = 403,
    CSSPropertyMarginLeft = 404,
    CSSPropertyMarginRight = 405,
    CSSPropertyMarginTop = 406,
    CSSPropertyMaxHeight = 407,
    CSSPropertyMaxWidth = 408,
    CSSPropertyMinHeight = 409,
    CSSPropertyMinWidth = 410,
    CSSPropertyOverflowX = 411,
    CSSPropertyOverflowY = 412,
    CSSPropertyOverscrollBehaviorX = 413,
    CSSPropertyOverscrollBehaviorY = 414,
    CSSPropertyPaddingBottom = 415,
    CSSPropertyPaddingLeft = 416,
    CSSPropertyPaddingRight = 417,
    CSSPropertyPaddingTop = 418,
    CSSPropertyRight = 419,
    CSSPropertyScrollMarginBottom = 420,
    CSSPropertyScrollMarginLeft = 421,
    CSSPropertyScrollMarginRight = 422,
    CSSPropertyScrollMarginTop = 423,
    CSSPropertyScrollPaddingBottom = 424,
    CSSPropertyScrollPaddingLeft = 425,
    CSSPropertyScrollPaddingRight = 426,
    CSSPropertyScrollPaddingTop = 427,
    CSSPropertyTop = 428,
    CSSPropertyWidth = 429,
    CSSPropertyBlockSize = 430,
    CSSPropertyBorderBlockEndColor = 431,
    CSSPropertyBorderBlockEndStyle = 432,
    CSSPropertyBorderBlockEndWidth = 433,
    CSSPropertyBorderBlockStartColor = 434,
    CSSPropertyBorderBlockStartStyle = 435,
    CSSPropertyBorderBlockStartWidth = 436,
    CSSPropertyBorderEndEndRadius = 437,
    CSSPropertyBorderEndStartRadius = 438,
    CSSPropertyBorderInlineEndColor = 439,
    CSSPropertyBorderInlineEndStyle = 440,
    CSSPropertyBorderInlineEndWidth = 441,
    CSSPropertyBorderInlineStartColor = 442,
    CSSPropertyBorderInlineStartStyle = 443,
    CSSPropertyBorderInlineStartWidth = 444,
    CSSPropertyBorderStartEndRadius = 445,
    CSSPropertyBorderStartStartRadius = 446,
    CSSPropertyContainIntrinsicBlockSize = 447,
    CSSPropertyContainIntrinsicInlineSize = 448,
    CSSPropertyCornerEndEndShape = 449,
    CSSPropertyCornerEndStartShape = 450,
    CSSPropertyCornerStartEndShape = 451,
    CSSPropertyCornerStartStartShape = 452,
    CSSPropertyInlineSize = 453,
    CSSPropertyInsetBlockEnd = 454,
    CSSPropertyInsetBlockStart = 455,
    CSSPropertyInsetInlineEnd = 456,
    CSSPropertyInsetInlineStart = 457,
    CSSPropertyMarginBlockEnd = 458,
    CSSPropertyMarginBlockStart = 459,
    CSSPropertyMarginInlineEnd = 460,
    CSSPropertyMarginInlineStart = 461,
    CSSPropertyMaxBlockSize = 462,
    CSSPropertyMaxInlineSize = 463,
    CSSPropertyMinBlockSize = 464,
    CSSPropertyMinInlineSize = 465,
    CSSPropertyOverflowBlock = 466,
    CSSPropertyOverflowInline = 467,
    CSSPropertyOverscrollBehaviorBlock = 468,
    CSSPropertyOverscrollBehaviorInline = 469,
    CSSPropertyPaddingBlockEnd = 470,
    CSSPropertyPaddingBlockStart = 471,
    CSSPropertyPaddingInlineEnd = 472,
    CSSPropertyPaddingInlineStart = 473,
    CSSPropertyScrollMarginBlockEnd = 474,
    CSSPropertyScrollMarginBlockStart = 475,
    CSSPropertyScrollMarginInlineEnd = 476,
    CSSPropertyScrollMarginInlineStart = 477,
    CSSPropertyScrollPaddingBlockEnd = 478,
    CSSPropertyScrollPaddingBlockStart = 479,
    CSSPropertyScrollPaddingInlineEnd = 480,
    CSSPropertyScrollPaddingInlineStart = 481,
    CSSPropertyAll = 482,
    CSSPropertyAnimation = 483,
    CSSPropertyAnimationRange = 484,
    CSSPropertyBackground = 485,
    CSSPropertyBackgroundPosition = 486,
    CSSPropertyBlockStep = 487,
    CSSPropertyBorder = 488,
    CSSPropertyBorderBlock = 489,
    CSSPropertyBorderBlockColor = 490,
    CSSPropertyBorderBlockEnd = 491,
    CSSPropertyBorderBlockStart = 492,
    CSSPropertyBorderBlockStyle = 493,
    CSSPropertyBorderBlockWidth = 494,
    CSSPropertyBorderBottom = 495,
    CSSPropertyBorderColor = 496,
    CSSPropertyBorderImage = 497,
    CSSPropertyBorderInline = 498,
    CSSPropertyBorderInlineColor = 499,
    CSSPropertyBorderInlineEnd = 500,
    CSSPropertyBorderInlineStart = 501,
    CSSPropertyBorderInlineStyle = 502,
    CSSPropertyBorderInlineWidth = 503,
    CSSPropertyBorderLeft = 504,
    CSSPropertyBorderRadius = 505,
    CSSPropertyBorderRight = 506,
    CSSPropertyBorderSpacing = 507,
    CSSPropertyBorderStyle = 508,
    CSSPropertyBorderTop = 509,
    CSSPropertyBorderWidth = 510,
    CSSPropertyColumnRule = 511,
    CSSPropertyColumns = 512,
    CSSPropertyContainIntrinsicSize = 513,
    CSSPropertyContainer = 514,
    CSSPropertyCornerShape = 515,
    CSSPropertyFlex = 516,
    CSSPropertyFlexFlow = 517,
    CSSPropertyFont = 518,
    CSSPropertyFontSynthesis = 519,
    CSSPropertyFontVariant = 520,
    CSSPropertyGap = 521,
    CSSPropertyGrid = 522,
    CSSPropertyGridArea = 523,
    CSSPropertyGridColumn = 524,
    CSSPropertyGridRow = 525,
    CSSPropertyGridTemplate = 526,
    CSSPropertyInset = 527,
    CSSPropertyInsetBlock = 528,
    CSSPropertyInsetInline = 529,
    CSSPropertyLineClamp = 530,
    CSSPropertyListStyle = 531,
    CSSPropertyMargin = 532,
    CSSPropertyMarginBlock = 533,
    CSSPropertyMarginInline = 534,
    CSSPropertyMarker = 535,
    CSSPropertyMask = 536,
    CSSPropertyMaskBorder = 537,
    CSSPropertyMaskPosition = 538,
    CSSPropertyOffset = 539,
    CSSPropertyOutline = 540,
    CSSPropertyOverflow = 541,
    CSSPropertyOverscrollBehavior = 542,
    CSSPropertyPadding = 543,
    CSSPropertyPaddingBlock = 544,
    CSSPropertyPaddingInline = 545,
    CSSPropertyPageBreakAfter = 546,
    CSSPropertyPageBreakBefore = 547,
    CSSPropertyPageBreakInside = 548,
    CSSPropertyPerspectiveOrigin = 549,
    CSSPropertyPlaceContent = 550,
    CSSPropertyPlaceItems = 551,
    CSSPropertyPlaceSelf = 552,
    CSSPropertyPositionTry = 553,
    CSSPropertyScrollMargin = 554,
    CSSPropertyScrollMarginBlock = 555,
    CSSPropertyScrollMarginInline = 556,
    CSSPropertyScrollPadding = 557,
    CSSPropertyScrollPaddingBlock = 558,
    CSSPropertyScrollPaddingInline = 559,
    CSSPropertyScrollTimeline = 560,
    CSSPropertyTextBox = 561,
    CSSPropertyTextDecoration = 562,
    CSSPropertyTextDecorationSkip = 563,
    CSSPropertyTextEmphasis = 564,
    CSSPropertyTextWrap = 565,
    CSSPropertyTransformOrigin = 566,
    CSSPropertyTransition = 567,
    CSSPropertyViewTimeline = 568,
    CSSPropertyWhiteSpace = 569,
    CSSPropertyWebkitBackgroundSize = 570,
    CSSPropertyWebkitBorderImage = 571,
    CSSPropertyWebkitBorderRadius = 572,
    CSSPropertyWebkitColumnBreakAfter = 573,
    CSSPropertyWebkitColumnBreakBefore = 574,
    CSSPropertyWebkitColumnBreakInside = 575,
    CSSPropertyWebkitMask = 576,
    CSSPropertyWebkitMaskBoxImage = 577,
    CSSPropertyWebkitMaskPosition = 578,
    CSSPropertyWebkitPerspective = 579,
    CSSPropertyWebkitTextDecoration = 580,
    CSSPropertyWebkitTextOrientation = 581,
    CSSPropertyWebkitTextStroke = 582,
};

// Enum value of the first "real" CSS property, which excludes
// CSSPropertyInvalid and CSSPropertyCustom.
constexpr uint16_t firstCSSProperty = 2;
// Total number of enum values in the CSSPropertyID enum. If making an array
// that can be indexed into using the enum value, use this as the size.
constexpr uint16_t cssPropertyIDEnumValueCount = 583;
// Number of "real" CSS properties. This differs from cssPropertyIDEnumValueCount,
// as this doesn't consider CSSPropertyInvalid and CSSPropertyCustom.
constexpr uint16_t numCSSProperties = 581;
constexpr unsigned maxCSSPropertyNameLength = 34;
constexpr auto firstTopPriorityProperty = CSSPropertyID::CSSPropertyColorScheme;
constexpr auto lastTopPriorityProperty = CSSPropertyID::CSSPropertyWritingMode;
constexpr auto firstHighPriorityProperty = CSSPropertyID::CSSPropertyDirection;
constexpr auto lastHighPriorityProperty = CSSPropertyID::CSSPropertyTextSpacingTrim;
constexpr auto firstLowPriorityProperty = CSSPropertyID::CSSPropertyAccentColor;
constexpr auto lastLowPriorityProperty = CSSPropertyID::CSSPropertyWordSpacing;
constexpr auto firstLogicalGroupPhysicalProperty = CSSPropertyID::CSSPropertyBorderBottomColor;
constexpr auto lastLogicalGroupPhysicalProperty = CSSPropertyID::CSSPropertyWidth;
constexpr auto firstLogicalGroupLogicalProperty = CSSPropertyID::CSSPropertyBlockSize;
constexpr auto lastLogicalGroupLogicalProperty = CSSPropertyID::CSSPropertyScrollPaddingInlineStart;
constexpr auto firstLogicalGroupProperty = firstLogicalGroupPhysicalProperty;
constexpr auto lastLogicalGroupProperty = lastLogicalGroupLogicalProperty;
constexpr auto firstShorthandProperty = CSSPropertyID::CSSPropertyAll;
constexpr auto lastShorthandProperty = CSSPropertyID::CSSPropertyWebkitTextStroke;
constexpr uint16_t numCSSPropertyLonghands = firstShorthandProperty - firstCSSProperty;
extern const std::array<CSSPropertyID, 448> computedPropertyIDs;

struct CSSPropertySettings {
    WTF_DEPRECATED_MAKE_STRUCT_FAST_ALLOCATED(CSSPropertySettings);

    bool accentColorEnabled : 1 { false };
    bool colorFilterEnabled : 1 { false };
    bool crossDocumentViewTransitionsEnabled : 1 { false };
    bool cssAnchorPositioningEnabled : 1 { false };
    bool cssAnchorPositioningPositionVisibilityEnabled : 1 { false };
    bool cssCornerShapeEnabled : 1 { false };
    bool cssDPropertyEnabled : 1 { false };
    bool cssFieldSizingEnabled : 1 { false };
    bool cssFontVariantEmojiEnabled : 1 { false };
    bool cssInputSecurityEnabled : 1 { false };
    bool cssLineClampEnabled : 1 { false };
    bool cssLineFitEdgeEnabled : 1 { false };
    bool cssRhythmicSizingEnabled : 1 { false };
    bool cssRubyAlignEnabled : 1 { false };
    bool cssRubyOverhangEnabled : 1 { false };
    bool cssScrollAnchoringEnabled : 1 { false };
    bool cssScrollbarColorEnabled : 1 { false };
    bool cssScrollbarGutterEnabled : 1 { false };
    bool cssScrollbarWidthEnabled : 1 { false };
    bool cssTextAutospaceEnabled : 1 { false };
    bool cssTextBoxTrimEnabled : 1 { false };
    bool cssTextGroupAlignEnabled : 1 { false };
    bool cssTextJustifyEnabled : 1 { false };
    bool cssTextSpacingTrimEnabled : 1 { false };
    bool cssUnprefixedBackdropFilterEnabled : 1 { false };
    bool overscrollBehaviorEnabled : 1 { false };
    bool scrollDrivenAnimationsEnabled : 1 { false };
    bool supportHDRDisplayEnabled : 1 { false };
    bool viewTransitionClassesEnabled : 1 { false };
    bool viewTransitionsEnabled : 1 { false };

    CSSPropertySettings() = default;
    explicit CSSPropertySettings(const Settings&);
};

bool operator==(const CSSPropertySettings&, const CSSPropertySettings&);
void add(Hasher&, const CSSPropertySettings&);

constexpr bool isLonghand(CSSPropertyID);
bool isInternal(CSSPropertyID);
bool isExposed(CSSPropertyID, const Settings*);
bool isExposed(CSSPropertyID, const Settings&);
bool isExposed(CSSPropertyID, const CSSPropertySettings*);
bool isExposed(CSSPropertyID, const CSSPropertySettings&);

CSSPropertyID findCSSProperty(const char* characters, unsigned length);
ASCIILiteral nameLiteral(CSSPropertyID);
const AtomString& nameString(CSSPropertyID);
String nameForIDL(CSSPropertyID);

CSSPropertyID cascadeAliasProperty(CSSPropertyID);

template<CSSPropertyID first, CSSPropertyID last> struct CSSPropertiesRange {
    struct Iterator {
        uint16_t index { static_cast<uint16_t>(first) };
        constexpr CSSPropertyID operator*() const { return static_cast<CSSPropertyID>(index); }
        constexpr Iterator& operator++() { ++index; return *this; }
        constexpr bool operator==(std::nullptr_t) const { return index > static_cast<uint16_t>(last); }
    };
    static constexpr Iterator begin() { return { }; }
    static constexpr std::nullptr_t end() { return nullptr; }
    static constexpr uint16_t size() { return last - first + 1; }
};
using AllCSSPropertiesRange = CSSPropertiesRange<static_cast<CSSPropertyID>(firstCSSProperty), lastShorthandProperty>;
using AllLonghandCSSPropertiesRange = CSSPropertiesRange<static_cast<CSSPropertyID>(firstCSSProperty), lastLogicalGroupProperty>;
constexpr AllCSSPropertiesRange allCSSProperties() { return { }; }
constexpr AllLonghandCSSPropertiesRange allLonghandCSSProperties() { return { }; }

constexpr bool isLonghand(CSSPropertyID property)
{
    return static_cast<uint16_t>(property) >= firstCSSProperty
        && static_cast<uint16_t>(property) < static_cast<uint16_t>(firstShorthandProperty);
}
constexpr bool isShorthand(CSSPropertyID property)
{
    return static_cast<uint16_t>(property) >= static_cast<uint16_t>(firstShorthandProperty)
        && static_cast<uint16_t>(property) <= static_cast<uint16_t>(lastShorthandProperty);
}

constexpr bool isLogicalPropertyGroupProperty(CSSPropertyID property)
{
    return static_cast<uint16_t>(property) >= static_cast<uint16_t>(firstLogicalGroupPhysicalProperty)
        && static_cast<uint16_t>(property) <= static_cast<uint16_t>(lastLogicalGroupLogicalProperty);
}

constexpr bool isLogicalPropertyGroupPhysicalProperty(CSSPropertyID property)
{
    return static_cast<uint16_t>(property) >= static_cast<uint16_t>(firstLogicalGroupPhysicalProperty)
        && static_cast<uint16_t>(property) <= static_cast<uint16_t>(lastLogicalGroupPhysicalProperty);
}

constexpr bool isLogicalPropertyGroupLogicalProperty(CSSPropertyID property)
{
    return static_cast<uint16_t>(property) >= static_cast<uint16_t>(firstLogicalGroupLogicalProperty)
        && static_cast<uint16_t>(property) <= static_cast<uint16_t>(lastLogicalGroupLogicalProperty);
}

WTF::TextStream& operator<<(WTF::TextStream&, CSSPropertyID);

} // namespace WebCore

namespace WTF {

template<> struct DefaultHash<WebCore::CSSPropertyID> : IntHash<unsigned> { };

template<> struct HashTraits<WebCore::CSSPropertyID> : GenericHashTraits<WebCore::CSSPropertyID> {
    static const bool emptyValueIsZero = true;
    static void constructDeletedValue(WebCore::CSSPropertyID& slot) { slot = static_cast<WebCore::CSSPropertyID>(std::numeric_limits<uint16_t>::max()); }
    static bool isDeletedValue(WebCore::CSSPropertyID value) { return static_cast<uint16_t>(value) == std::numeric_limits<uint16_t>::max(); }
};

} // namespace WTF

namespace std {

template<> struct iterator_traits<WebCore::AllCSSPropertiesRange::Iterator> { using value_type = WebCore::CSSPropertyID; };
template<> struct iterator_traits<WebCore::AllLonghandCSSPropertiesRange::Iterator> { using value_type = WebCore::CSSPropertyID; };

} // namespace std

