/* Device.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from Device.vala, do not modify */

/*
 * Copyright (c) 2011-2015 elementary LLC. (https://elementary.io)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street - Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#include "power.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <float.h>
#include <math.h>
#include <glib/gi18n-lib.h>
#include <glib-object.h>
#include <gio/gio.h>

#define POWER_SERVICES_DEVICE_DEVICE_INTERFACE "org.freedesktop.UPower"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	POWER_SERVICES_DEVICE_0_PROPERTY,
	POWER_SERVICES_DEVICE_COARSE_BATTERY_LEVEL_PROPERTY,
	POWER_SERVICES_DEVICE_HAS_HISTORY_PROPERTY,
	POWER_SERVICES_DEVICE_HAS_STATISTICS_PROPERTY,
	POWER_SERVICES_DEVICE_IS_PRESENT_PROPERTY,
	POWER_SERVICES_DEVICE_IS_RECHARGEABLE_PROPERTY,
	POWER_SERVICES_DEVICE_ONLINE_PROPERTY,
	POWER_SERVICES_DEVICE_POWER_SUPPLY_PROPERTY,
	POWER_SERVICES_DEVICE_CAPACITY_PROPERTY,
	POWER_SERVICES_DEVICE_DESCRIPTION_PROPERTY,
	POWER_SERVICES_DEVICE_ENERGY_PROPERTY,
	POWER_SERVICES_DEVICE_ENERGY_EMPTY_PROPERTY,
	POWER_SERVICES_DEVICE_ENERGY_FULL_PROPERTY,
	POWER_SERVICES_DEVICE_ENERGY_FULL_DESIGN_PROPERTY,
	POWER_SERVICES_DEVICE_ENERGY_RATE_PROPERTY,
	POWER_SERVICES_DEVICE_LUMINOSITY_PROPERTY,
	POWER_SERVICES_DEVICE_PERCENTAGE_PROPERTY,
	POWER_SERVICES_DEVICE_TEMPERATURE_PROPERTY,
	POWER_SERVICES_DEVICE_VOLTAGE_PROPERTY,
	POWER_SERVICES_DEVICE_TIME_TO_EMPTY_PROPERTY,
	POWER_SERVICES_DEVICE_TIME_TO_FULL_PROPERTY,
	POWER_SERVICES_DEVICE_MODEL_PROPERTY,
	POWER_SERVICES_DEVICE_NATIVE_PATH_PROPERTY,
	POWER_SERVICES_DEVICE_SERIAL_PROPERTY,
	POWER_SERVICES_DEVICE_VENDOR_PROPERTY,
	POWER_SERVICES_DEVICE_STATE_PROPERTY,
	POWER_SERVICES_DEVICE_TECHNOLOGY_PROPERTY,
	POWER_SERVICES_DEVICE_DEVICE_TYPE_PROPERTY,
	POWER_SERVICES_DEVICE_UPDATE_TIME_PROPERTY,
	POWER_SERVICES_DEVICE_IS_CHARGING_PROPERTY,
	POWER_SERVICES_DEVICE_IS_A_BATTERY_PROPERTY,
	POWER_SERVICES_DEVICE_NUM_PROPERTIES
};
static GParamSpec* power_services_device_properties[POWER_SERVICES_DEVICE_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
enum  {
	POWER_SERVICES_DEVICE_PROPERTIES_UPDATED_SIGNAL,
	POWER_SERVICES_DEVICE_NUM_SIGNALS
};
static guint power_services_device_signals[POWER_SERVICES_DEVICE_NUM_SIGNALS] = {0};

struct _PowerServicesDevicePrivate {
	gchar* device_path;
	PowerServicesDBusInterfacesDevice* device;
	gboolean _coarse_battery_level;
	gboolean _has_history;
	gboolean _has_statistics;
	gboolean _is_present;
	gboolean _is_rechargeable;
	gboolean _online;
	gboolean _power_supply;
	gdouble _capacity;
	gchar* _description;
	gdouble _energy;
	gdouble _energy_empty;
	gdouble _energy_full;
	gdouble _energy_full_design;
	gdouble _energy_rate;
	gdouble _luminosity;
	gdouble _percentage;
	gdouble _temperature;
	gdouble _voltage;
	gint64 _time_to_empty;
	gint64 _time_to_full;
	gchar* _model;
	gchar* _native_path;
	gchar* _serial;
	gchar* _vendor;
	PowerServicesDeviceState _state;
	PowerServicesDeviceTechnology _technology;
	PowerServicesDeviceType _device_type;
	guint64 _update_time;
	gboolean _is_charging;
	gboolean _is_a_battery;
};

static gint PowerServicesDevice_private_offset;
static gpointer power_services_device_parent_class = NULL;

static gboolean power_services_device_connect_to_bus (PowerServicesDevice* self);
static void power_services_device_update_properties (PowerServicesDevice* self);
static void power_services_device_connect_signals (PowerServicesDevice* self);
static void power_services_device_update_description (PowerServicesDevice* self);
static void _power_services_device_update_description_g_object_notify (GObject* _sender,
                                                                GParamSpec* pspec,
                                                                gpointer self);
static void _power_services_device_update_properties_g_dbus_proxy_g_properties_changed (GDBusProxy* _sender,
                                                                                 GVariant* changed_properties,
                                                                                 gchar** invalidated_properties,
                                                                                 gpointer self);
static void power_services_device_set_coarse_battery_level (PowerServicesDevice* self,
                                                     gboolean value);
static void power_services_device_set_has_history (PowerServicesDevice* self,
                                            gboolean value);
static void power_services_device_set_has_statistics (PowerServicesDevice* self,
                                               gboolean value);
static void power_services_device_set_is_present (PowerServicesDevice* self,
                                           gboolean value);
static void power_services_device_set_is_rechargeable (PowerServicesDevice* self,
                                                gboolean value);
static void power_services_device_set_online (PowerServicesDevice* self,
                                       gboolean value);
static void power_services_device_set_power_supply (PowerServicesDevice* self,
                                             gboolean value);
static void power_services_device_set_capacity (PowerServicesDevice* self,
                                         gdouble value);
static void power_services_device_set_energy (PowerServicesDevice* self,
                                       gdouble value);
static void power_services_device_set_energy_empty (PowerServicesDevice* self,
                                             gdouble value);
static void power_services_device_set_energy_full (PowerServicesDevice* self,
                                            gdouble value);
static void power_services_device_set_energy_full_design (PowerServicesDevice* self,
                                                   gdouble value);
static void power_services_device_set_energy_rate (PowerServicesDevice* self,
                                            gdouble value);
static void power_services_device_set_luminosity (PowerServicesDevice* self,
                                           gdouble value);
static void power_services_device_set_percentage (PowerServicesDevice* self,
                                           gdouble value);
static void power_services_device_set_temperature (PowerServicesDevice* self,
                                            gdouble value);
static void power_services_device_set_voltage (PowerServicesDevice* self,
                                        gdouble value);
static void power_services_device_set_time_to_empty (PowerServicesDevice* self,
                                              gint64 value);
static void power_services_device_set_time_to_full (PowerServicesDevice* self,
                                             gint64 value);
static void power_services_device_set_model (PowerServicesDevice* self,
                                      const gchar* value);
static void power_services_device_set_native_path (PowerServicesDevice* self,
                                            const gchar* value);
static void power_services_device_set_serial (PowerServicesDevice* self,
                                       const gchar* value);
static void power_services_device_set_vendor (PowerServicesDevice* self,
                                       const gchar* value);
static PowerServicesDeviceType power_services_device_determine_device_type (PowerServicesDevice* self);
static void power_services_device_set_device_type (PowerServicesDevice* self,
                                            PowerServicesDeviceType value);
static void power_services_device_set_state (PowerServicesDevice* self,
                                      PowerServicesDeviceState value);
static void power_services_device_set_technology (PowerServicesDevice* self,
                                           PowerServicesDeviceTechnology value);
static void power_services_device_set_update_time (PowerServicesDevice* self,
                                            guint64 value);
static void power_services_device_set_is_charging (PowerServicesDevice* self,
                                            gboolean value);
static void power_services_device_set_is_a_battery (PowerServicesDevice* self,
                                             gboolean value);
static const gchar* power_services_device_get_battery_icon (PowerServicesDevice* self);
static void power_services_device_set_description (PowerServicesDevice* self,
                                            const gchar* value);
static void power_services_device_finalize (GObject * obj);
static GType power_services_device_get_type_once (void);
static void _vala_power_services_device_get_property (GObject * object,
                                               guint property_id,
                                               GValue * value,
                                               GParamSpec * pspec);
static void _vala_power_services_device_set_property (GObject * object,
                                               guint property_id,
                                               const GValue * value,
                                               GParamSpec * pspec);

static inline gpointer
power_services_device_get_instance_private (PowerServicesDevice* self)
{
	return G_STRUCT_MEMBER_P (self, PowerServicesDevice_private_offset);
}

static GType
power_services_device_state_get_type_once (void)
{
	static const GEnumValue values[] = {{POWER_SERVICES_DEVICE_STATE_UNKNOWN, "POWER_SERVICES_DEVICE_STATE_UNKNOWN", "unknown"}, {POWER_SERVICES_DEVICE_STATE_CHARGING, "POWER_SERVICES_DEVICE_STATE_CHARGING", "charging"}, {POWER_SERVICES_DEVICE_STATE_DISCHARGING, "POWER_SERVICES_DEVICE_STATE_DISCHARGING", "discharging"}, {POWER_SERVICES_DEVICE_STATE_EMPTY, "POWER_SERVICES_DEVICE_STATE_EMPTY", "empty"}, {POWER_SERVICES_DEVICE_STATE_FULLY_CHARGED, "POWER_SERVICES_DEVICE_STATE_FULLY_CHARGED", "fully-charged"}, {POWER_SERVICES_DEVICE_STATE_PENDING_CHARGE, "POWER_SERVICES_DEVICE_STATE_PENDING_CHARGE", "pending-charge"}, {POWER_SERVICES_DEVICE_STATE_PENDING_DISCHARGE, "POWER_SERVICES_DEVICE_STATE_PENDING_DISCHARGE", "pending-discharge"}, {0, NULL, NULL}};
	GType power_services_device_state_type_id;
	power_services_device_state_type_id = g_enum_register_static ("PowerServicesDeviceState", values);
	return power_services_device_state_type_id;
}

GType
power_services_device_state_get_type (void)
{
	static volatile gsize power_services_device_state_type_id__once = 0;
	if (g_once_init_enter (&power_services_device_state_type_id__once)) {
		GType power_services_device_state_type_id;
		power_services_device_state_type_id = power_services_device_state_get_type_once ();
		g_once_init_leave (&power_services_device_state_type_id__once, power_services_device_state_type_id);
	}
	return power_services_device_state_type_id__once;
}

static GType
power_services_device_technology_get_type_once (void)
{
	static const GEnumValue values[] = {{POWER_SERVICES_DEVICE_TECHNOLOGY_UNKNOWN, "POWER_SERVICES_DEVICE_TECHNOLOGY_UNKNOWN", "unknown"}, {POWER_SERVICES_DEVICE_TECHNOLOGY_LITHIUM_ION, "POWER_SERVICES_DEVICE_TECHNOLOGY_LITHIUM_ION", "lithium-ion"}, {POWER_SERVICES_DEVICE_TECHNOLOGY_LITHIUM_POLYMER, "POWER_SERVICES_DEVICE_TECHNOLOGY_LITHIUM_POLYMER", "lithium-polymer"}, {POWER_SERVICES_DEVICE_TECHNOLOGY_LITHIUM_IRON_PHOSPHATE, "POWER_SERVICES_DEVICE_TECHNOLOGY_LITHIUM_IRON_PHOSPHATE", "lithium-iron-phosphate"}, {POWER_SERVICES_DEVICE_TECHNOLOGY_LEAD_ACID, "POWER_SERVICES_DEVICE_TECHNOLOGY_LEAD_ACID", "lead-acid"}, {POWER_SERVICES_DEVICE_TECHNOLOGY_NICKEL_CADMIUM, "POWER_SERVICES_DEVICE_TECHNOLOGY_NICKEL_CADMIUM", "nickel-cadmium"}, {POWER_SERVICES_DEVICE_TECHNOLOGY_NICKEL_METAL_HYDRIDE, "POWER_SERVICES_DEVICE_TECHNOLOGY_NICKEL_METAL_HYDRIDE", "nickel-metal-hydride"}, {0, NULL, NULL}};
	GType power_services_device_technology_type_id;
	power_services_device_technology_type_id = g_enum_register_static ("PowerServicesDeviceTechnology", values);
	return power_services_device_technology_type_id;
}

GType
power_services_device_technology_get_type (void)
{
	static volatile gsize power_services_device_technology_type_id__once = 0;
	if (g_once_init_enter (&power_services_device_technology_type_id__once)) {
		GType power_services_device_technology_type_id;
		power_services_device_technology_type_id = power_services_device_technology_get_type_once ();
		g_once_init_leave (&power_services_device_technology_type_id__once, power_services_device_technology_type_id);
	}
	return power_services_device_technology_type_id__once;
}

const gchar*
power_services_device_type_get_name (PowerServicesDeviceType self)
{
	const gchar* result;
	switch (self) {
		case POWER_SERVICES_DEVICE_TYPE_BATTERY:
		{
			result = _ ("Battery");
			return result;
		}
		case POWER_SERVICES_DEVICE_TYPE_UPS:
		{
			result = _ ("UPS");
			return result;
		}
		case POWER_SERVICES_DEVICE_TYPE_MONITOR:
		{
			result = _ ("Display");
			return result;
		}
		case POWER_SERVICES_DEVICE_TYPE_MOUSE:
		{
			result = _ ("Mouse");
			return result;
		}
		case POWER_SERVICES_DEVICE_TYPE_KEYBOARD:
		{
			result = _ ("Keyboard");
			return result;
		}
		case POWER_SERVICES_DEVICE_TYPE_PDA:
		{
			result = _ ("PDA");
			return result;
		}
		case POWER_SERVICES_DEVICE_TYPE_PHONE:
		{
			result = _ ("Phone");
			return result;
		}
		case POWER_SERVICES_DEVICE_TYPE_MEDIA_PLAYER:
		{
			result = _ ("Media Player");
			return result;
		}
		case POWER_SERVICES_DEVICE_TYPE_TABLET:
		{
			result = _ ("Tablet");
			return result;
		}
		case POWER_SERVICES_DEVICE_TYPE_COMPUTER:
		{
			result = _ ("Computer");
			return result;
		}
		case POWER_SERVICES_DEVICE_TYPE_GAMING_INPUT:
		{
			result = _ ("Controller");
			return result;
		}
		case POWER_SERVICES_DEVICE_TYPE_PEN:
		{
			result = _ ("Pen");
			return result;
		}
		case POWER_SERVICES_DEVICE_TYPE_LINE_POWER:
		{
			result = _ ("Plugged In");
			return result;
		}
		default:
		{
			result = NULL;
			return result;
		}
	}
}

const gchar*
power_services_device_type_get_icon_name (PowerServicesDeviceType self)
{
	const gchar* result;
	switch (self) {
		case POWER_SERVICES_DEVICE_TYPE_UPS:
		{
			result = "uninterruptible-power-supply";
			return result;
		}
		case POWER_SERVICES_DEVICE_TYPE_MOUSE:
		{
			result = "input-mouse";
			return result;
		}
		case POWER_SERVICES_DEVICE_TYPE_KEYBOARD:
		{
			result = "input-keyboard";
			return result;
		}
		case POWER_SERVICES_DEVICE_TYPE_PDA:
		case POWER_SERVICES_DEVICE_TYPE_PHONE:
		{
			result = "phone";
			return result;
		}
		case POWER_SERVICES_DEVICE_TYPE_MEDIA_PLAYER:
		{
			result = "multimedia-player";
			return result;
		}
		case POWER_SERVICES_DEVICE_TYPE_TABLET:
		case POWER_SERVICES_DEVICE_TYPE_PEN:
		{
			result = "input-tablet";
			return result;
		}
		case POWER_SERVICES_DEVICE_TYPE_GAMING_INPUT:
		{
			result = "input-gaming";
			return result;
		}
		default:
		case POWER_SERVICES_DEVICE_TYPE_COMPUTER:
		case POWER_SERVICES_DEVICE_TYPE_MONITOR:
		case POWER_SERVICES_DEVICE_TYPE_UNKNOWN:
		case POWER_SERVICES_DEVICE_TYPE_BATTERY:
		case POWER_SERVICES_DEVICE_TYPE_LINE_POWER:
		{
			result = NULL;
			return result;
		}
	}
}

static GType
power_services_device_type_get_type_once (void)
{
	static const GEnumValue values[] = {{POWER_SERVICES_DEVICE_TYPE_UNKNOWN, "POWER_SERVICES_DEVICE_TYPE_UNKNOWN", "unknown"}, {POWER_SERVICES_DEVICE_TYPE_LINE_POWER, "POWER_SERVICES_DEVICE_TYPE_LINE_POWER", "line-power"}, {POWER_SERVICES_DEVICE_TYPE_BATTERY, "POWER_SERVICES_DEVICE_TYPE_BATTERY", "battery"}, {POWER_SERVICES_DEVICE_TYPE_UPS, "POWER_SERVICES_DEVICE_TYPE_UPS", "ups"}, {POWER_SERVICES_DEVICE_TYPE_MONITOR, "POWER_SERVICES_DEVICE_TYPE_MONITOR", "monitor"}, {POWER_SERVICES_DEVICE_TYPE_MOUSE, "POWER_SERVICES_DEVICE_TYPE_MOUSE", "mouse"}, {POWER_SERVICES_DEVICE_TYPE_KEYBOARD, "POWER_SERVICES_DEVICE_TYPE_KEYBOARD", "keyboard"}, {POWER_SERVICES_DEVICE_TYPE_PDA, "POWER_SERVICES_DEVICE_TYPE_PDA", "pda"}, {POWER_SERVICES_DEVICE_TYPE_PHONE, "POWER_SERVICES_DEVICE_TYPE_PHONE", "phone"}, {POWER_SERVICES_DEVICE_TYPE_MEDIA_PLAYER, "POWER_SERVICES_DEVICE_TYPE_MEDIA_PLAYER", "media-player"}, {POWER_SERVICES_DEVICE_TYPE_TABLET, "POWER_SERVICES_DEVICE_TYPE_TABLET", "tablet"}, {POWER_SERVICES_DEVICE_TYPE_COMPUTER, "POWER_SERVICES_DEVICE_TYPE_COMPUTER", "computer"}, {POWER_SERVICES_DEVICE_TYPE_GAMING_INPUT, "POWER_SERVICES_DEVICE_TYPE_GAMING_INPUT", "gaming-input"}, {POWER_SERVICES_DEVICE_TYPE_PEN, "POWER_SERVICES_DEVICE_TYPE_PEN", "pen"}, {0, NULL, NULL}};
	GType power_services_device_type_type_id;
	power_services_device_type_type_id = g_enum_register_static ("PowerServicesDeviceType", values);
	return power_services_device_type_type_id;
}

GType
power_services_device_type_get_type (void)
{
	static volatile gsize power_services_device_type_type_id__once = 0;
	if (g_once_init_enter (&power_services_device_type_type_id__once)) {
		GType power_services_device_type_type_id;
		power_services_device_type_type_id = power_services_device_type_get_type_once ();
		g_once_init_leave (&power_services_device_type_type_id__once, power_services_device_type_type_id);
	}
	return power_services_device_type_type_id__once;
}

static void
_power_services_device_update_description_g_object_notify (GObject* _sender,
                                                           GParamSpec* pspec,
                                                           gpointer self)
{
	power_services_device_update_description ((PowerServicesDevice*) self);
}

PowerServicesDevice*
power_services_device_construct (GType object_type,
                                 const gchar* device_path)
{
	PowerServicesDevice * self = NULL;
	gchar* _tmp0_;
	g_return_val_if_fail (device_path != NULL, NULL);
	self = (PowerServicesDevice*) g_object_new (object_type, NULL);
	_tmp0_ = g_strdup (device_path);
	_g_free0 (self->priv->device_path);
	self->priv->device_path = _tmp0_;
	if (power_services_device_connect_to_bus (self)) {
		power_services_device_update_properties (self);
		power_services_device_connect_signals (self);
		power_services_device_update_description (self);
		g_signal_connect_object ((GObject*) self, "notify::percentage", (GCallback) _power_services_device_update_description_g_object_notify, self, 0);
	}
	return self;
}

PowerServicesDevice*
power_services_device_new (const gchar* device_path)
{
	return power_services_device_construct (POWER_SERVICES_TYPE_DEVICE, device_path);
}

static gboolean
power_services_device_connect_to_bus (PowerServicesDevice* self)
{
	PowerServicesDBusInterfacesDevice* _tmp7_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	{
		PowerServicesDBusInterfacesDevice* _tmp0_ = NULL;
		const gchar* _tmp1_;
		PowerServicesDBusInterfacesDevice* _tmp2_;
		PowerServicesDBusInterfacesDevice* _tmp3_;
		_tmp1_ = self->priv->device_path;
		_tmp2_ = (PowerServicesDBusInterfacesDevice*) g_initable_new (POWER_SERVICES_DBUS_INTERFACES_TYPE_DEVICE_PROXY, NULL, &_inner_error0_, "g-flags", G_DBUS_PROXY_FLAGS_NONE, "g-name", POWER_SERVICES_DEVICE_DEVICE_INTERFACE, "g-bus-type", G_BUS_TYPE_SYSTEM, "g-object-path", _tmp1_, "g-interface-name", "org.freedesktop.UPower.Device", NULL);
		_tmp0_ = (PowerServicesDBusInterfacesDevice*) _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp3_ = _tmp0_;
		_tmp0_ = NULL;
		_g_object_unref0 (self->priv->device);
		self->priv->device = _tmp3_;
		g_debug ("Device.vala:179: Connection to UPower device established");
		_g_object_unref0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp4_;
		const gchar* _tmp5_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		g_critical ("Device.vala:181: Connecting to UPower device failed: %s", _tmp5_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp6_ = FALSE;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp6_;
	}
	_tmp7_ = self->priv->device;
	result = _tmp7_ != NULL;
	return result;
}

static void
_power_services_device_update_properties_g_dbus_proxy_g_properties_changed (GDBusProxy* _sender,
                                                                            GVariant* changed_properties,
                                                                            gchar** invalidated_properties,
                                                                            gpointer self)
{
	power_services_device_update_properties ((PowerServicesDevice*) self);
}

static void
power_services_device_connect_signals (PowerServicesDevice* self)
{
	PowerServicesDBusInterfacesDevice* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->device;
	g_signal_connect_object ((GDBusProxy*) _tmp0_, "g-properties-changed", (GCallback) _power_services_device_update_properties_g_dbus_proxy_g_properties_changed, self, 0);
}

static void
power_services_device_update_properties (PowerServicesDevice* self)
{
	PowerServicesDBusInterfacesDevice* _tmp0_;
	guint32 _tmp1_;
	guint32 _tmp2_;
	PowerServicesDBusInterfacesDevice* _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	PowerServicesDBusInterfacesDevice* _tmp6_;
	gboolean _tmp7_;
	gboolean _tmp8_;
	PowerServicesDBusInterfacesDevice* _tmp9_;
	gboolean _tmp10_;
	gboolean _tmp11_;
	PowerServicesDBusInterfacesDevice* _tmp12_;
	gboolean _tmp13_;
	gboolean _tmp14_;
	PowerServicesDBusInterfacesDevice* _tmp15_;
	gboolean _tmp16_;
	gboolean _tmp17_;
	PowerServicesDBusInterfacesDevice* _tmp18_;
	gboolean _tmp19_;
	gboolean _tmp20_;
	PowerServicesDBusInterfacesDevice* _tmp21_;
	gdouble _tmp22_;
	gdouble _tmp23_;
	PowerServicesDBusInterfacesDevice* _tmp24_;
	gdouble _tmp25_;
	gdouble _tmp26_;
	PowerServicesDBusInterfacesDevice* _tmp27_;
	gdouble _tmp28_;
	gdouble _tmp29_;
	PowerServicesDBusInterfacesDevice* _tmp30_;
	gdouble _tmp31_;
	gdouble _tmp32_;
	PowerServicesDBusInterfacesDevice* _tmp33_;
	gdouble _tmp34_;
	gdouble _tmp35_;
	PowerServicesDBusInterfacesDevice* _tmp36_;
	gdouble _tmp37_;
	gdouble _tmp38_;
	PowerServicesDBusInterfacesDevice* _tmp39_;
	gdouble _tmp40_;
	gdouble _tmp41_;
	PowerServicesDBusInterfacesDevice* _tmp42_;
	gdouble _tmp43_;
	gdouble _tmp44_;
	PowerServicesDBusInterfacesDevice* _tmp45_;
	gdouble _tmp46_;
	gdouble _tmp47_;
	PowerServicesDBusInterfacesDevice* _tmp48_;
	gdouble _tmp49_;
	gdouble _tmp50_;
	PowerServicesDBusInterfacesDevice* _tmp51_;
	gint64 _tmp52_;
	gint64 _tmp53_;
	PowerServicesDBusInterfacesDevice* _tmp54_;
	gint64 _tmp55_;
	gint64 _tmp56_;
	PowerServicesDBusInterfacesDevice* _tmp57_;
	gchar* _tmp58_;
	gchar* _tmp59_;
	gchar* _tmp60_;
	PowerServicesDBusInterfacesDevice* _tmp61_;
	gchar* _tmp62_;
	gchar* _tmp63_;
	gchar* _tmp64_;
	PowerServicesDBusInterfacesDevice* _tmp65_;
	gchar* _tmp66_;
	gchar* _tmp67_;
	gchar* _tmp68_;
	PowerServicesDBusInterfacesDevice* _tmp69_;
	gchar* _tmp70_;
	gchar* _tmp71_;
	gchar* _tmp72_;
	PowerServicesDBusInterfacesDevice* _tmp73_;
	guint32 _tmp74_;
	guint32 _tmp75_;
	PowerServicesDBusInterfacesDevice* _tmp76_;
	guint32 _tmp77_;
	guint32 _tmp78_;
	PowerServicesDBusInterfacesDevice* _tmp79_;
	guint64 _tmp80_;
	guint64 _tmp81_;
	gboolean _tmp82_ = FALSE;
	PowerServicesDeviceState _tmp83_;
	gboolean _tmp85_ = FALSE;
	PowerServicesDeviceType _tmp86_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->device;
	_tmp1_ = power_services_dbus_interfaces_device_get_battery_level (_tmp0_);
	_tmp2_ = _tmp1_;
	power_services_device_set_coarse_battery_level (self, _tmp2_ != ((guint32) 1));
	_tmp3_ = self->priv->device;
	_tmp4_ = power_services_dbus_interfaces_device_get_has_history (_tmp3_);
	_tmp5_ = _tmp4_;
	power_services_device_set_has_history (self, _tmp5_);
	_tmp6_ = self->priv->device;
	_tmp7_ = power_services_dbus_interfaces_device_get_has_statistics (_tmp6_);
	_tmp8_ = _tmp7_;
	power_services_device_set_has_statistics (self, _tmp8_);
	_tmp9_ = self->priv->device;
	_tmp10_ = power_services_dbus_interfaces_device_get_is_present (_tmp9_);
	_tmp11_ = _tmp10_;
	power_services_device_set_is_present (self, _tmp11_);
	_tmp12_ = self->priv->device;
	_tmp13_ = power_services_dbus_interfaces_device_get_is_rechargeable (_tmp12_);
	_tmp14_ = _tmp13_;
	power_services_device_set_is_rechargeable (self, _tmp14_);
	_tmp15_ = self->priv->device;
	_tmp16_ = power_services_dbus_interfaces_device_get_online (_tmp15_);
	_tmp17_ = _tmp16_;
	power_services_device_set_online (self, _tmp17_);
	_tmp18_ = self->priv->device;
	_tmp19_ = power_services_dbus_interfaces_device_get_power_supply (_tmp18_);
	_tmp20_ = _tmp19_;
	power_services_device_set_power_supply (self, _tmp20_);
	_tmp21_ = self->priv->device;
	_tmp22_ = power_services_dbus_interfaces_device_get_capacity (_tmp21_);
	_tmp23_ = _tmp22_;
	power_services_device_set_capacity (self, _tmp23_);
	_tmp24_ = self->priv->device;
	_tmp25_ = power_services_dbus_interfaces_device_get_energy (_tmp24_);
	_tmp26_ = _tmp25_;
	power_services_device_set_energy (self, _tmp26_);
	_tmp27_ = self->priv->device;
	_tmp28_ = power_services_dbus_interfaces_device_get_energy_empty (_tmp27_);
	_tmp29_ = _tmp28_;
	power_services_device_set_energy_empty (self, _tmp29_);
	_tmp30_ = self->priv->device;
	_tmp31_ = power_services_dbus_interfaces_device_get_energy_full (_tmp30_);
	_tmp32_ = _tmp31_;
	power_services_device_set_energy_full (self, _tmp32_);
	_tmp33_ = self->priv->device;
	_tmp34_ = power_services_dbus_interfaces_device_get_energy_full_design (_tmp33_);
	_tmp35_ = _tmp34_;
	power_services_device_set_energy_full_design (self, _tmp35_);
	_tmp36_ = self->priv->device;
	_tmp37_ = power_services_dbus_interfaces_device_get_energy_rate (_tmp36_);
	_tmp38_ = _tmp37_;
	power_services_device_set_energy_rate (self, _tmp38_);
	_tmp39_ = self->priv->device;
	_tmp40_ = power_services_dbus_interfaces_device_get_luminosity (_tmp39_);
	_tmp41_ = _tmp40_;
	power_services_device_set_luminosity (self, _tmp41_);
	_tmp42_ = self->priv->device;
	_tmp43_ = power_services_dbus_interfaces_device_get_percentage (_tmp42_);
	_tmp44_ = _tmp43_;
	power_services_device_set_percentage (self, _tmp44_);
	_tmp45_ = self->priv->device;
	_tmp46_ = power_services_dbus_interfaces_device_get_temperature (_tmp45_);
	_tmp47_ = _tmp46_;
	power_services_device_set_temperature (self, _tmp47_);
	_tmp48_ = self->priv->device;
	_tmp49_ = power_services_dbus_interfaces_device_get_voltage (_tmp48_);
	_tmp50_ = _tmp49_;
	power_services_device_set_voltage (self, _tmp50_);
	_tmp51_ = self->priv->device;
	_tmp52_ = power_services_dbus_interfaces_device_get_time_to_empty (_tmp51_);
	_tmp53_ = _tmp52_;
	power_services_device_set_time_to_empty (self, _tmp53_);
	_tmp54_ = self->priv->device;
	_tmp55_ = power_services_dbus_interfaces_device_get_time_to_full (_tmp54_);
	_tmp56_ = _tmp55_;
	power_services_device_set_time_to_full (self, _tmp56_);
	_tmp57_ = self->priv->device;
	_tmp58_ = power_services_dbus_interfaces_device_get_model (_tmp57_);
	_tmp59_ = _tmp58_;
	_tmp60_ = _tmp59_;
	power_services_device_set_model (self, _tmp60_);
	_g_free0 (_tmp60_);
	_tmp61_ = self->priv->device;
	_tmp62_ = power_services_dbus_interfaces_device_get_native_path (_tmp61_);
	_tmp63_ = _tmp62_;
	_tmp64_ = _tmp63_;
	power_services_device_set_native_path (self, _tmp64_);
	_g_free0 (_tmp64_);
	_tmp65_ = self->priv->device;
	_tmp66_ = power_services_dbus_interfaces_device_get_serial (_tmp65_);
	_tmp67_ = _tmp66_;
	_tmp68_ = _tmp67_;
	power_services_device_set_serial (self, _tmp68_);
	_g_free0 (_tmp68_);
	_tmp69_ = self->priv->device;
	_tmp70_ = power_services_dbus_interfaces_device_get_vendor (_tmp69_);
	_tmp71_ = _tmp70_;
	_tmp72_ = _tmp71_;
	power_services_device_set_vendor (self, _tmp72_);
	_g_free0 (_tmp72_);
	power_services_device_set_device_type (self, power_services_device_determine_device_type (self));
	_tmp73_ = self->priv->device;
	_tmp74_ = power_services_dbus_interfaces_device_get_state (_tmp73_);
	_tmp75_ = _tmp74_;
	power_services_device_set_state (self, (PowerServicesDeviceState) _tmp75_);
	_tmp76_ = self->priv->device;
	_tmp77_ = power_services_dbus_interfaces_device_get_technology (_tmp76_);
	_tmp78_ = _tmp77_;
	power_services_device_set_technology (self, (PowerServicesDeviceTechnology) _tmp78_);
	_tmp79_ = self->priv->device;
	_tmp80_ = power_services_dbus_interfaces_device_get_update_time (_tmp79_);
	_tmp81_ = _tmp80_;
	power_services_device_set_update_time (self, _tmp81_);
	_tmp83_ = self->priv->_state;
	if (_tmp83_ == POWER_SERVICES_DEVICE_STATE_FULLY_CHARGED) {
		_tmp82_ = TRUE;
	} else {
		PowerServicesDeviceState _tmp84_;
		_tmp84_ = self->priv->_state;
		_tmp82_ = _tmp84_ == POWER_SERVICES_DEVICE_STATE_CHARGING;
	}
	power_services_device_set_is_charging (self, _tmp82_);
	_tmp86_ = self->priv->_device_type;
	if (_tmp86_ != POWER_SERVICES_DEVICE_TYPE_UNKNOWN) {
		PowerServicesDeviceType _tmp87_;
		_tmp87_ = self->priv->_device_type;
		_tmp85_ = _tmp87_ != POWER_SERVICES_DEVICE_TYPE_LINE_POWER;
	} else {
		_tmp85_ = FALSE;
	}
	power_services_device_set_is_a_battery (self, _tmp85_);
	g_signal_emit (self, power_services_device_signals[POWER_SERVICES_DEVICE_PROPERTIES_UPDATED_SIGNAL], 0);
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

static PowerServicesDeviceType
power_services_device_determine_device_type (PowerServicesDevice* self)
{
	gboolean _tmp0_ = FALSE;
	PowerServicesDBusInterfacesDevice* _tmp1_;
	guint32 _tmp2_;
	guint32 _tmp3_;
	PowerServicesDBusInterfacesDevice* _tmp8_;
	guint32 _tmp9_;
	guint32 _tmp10_;
	PowerServicesDeviceType result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp1_ = self->priv->device;
	_tmp2_ = power_services_dbus_interfaces_device_get_Type (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == ((guint32) POWER_SERVICES_DEVICE_TYPE_MOUSE)) {
		PowerServicesDBusInterfacesDevice* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		_tmp4_ = self->priv->device;
		_tmp5_ = power_services_dbus_interfaces_device_get_model (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = _tmp6_;
		_tmp0_ = string_contains (_tmp7_, "keyboard");
		_g_free0 (_tmp7_);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = (PowerServicesDeviceType) POWER_SERVICES_DEVICE_TYPE_KEYBOARD;
		return result;
	}
	_tmp8_ = self->priv->device;
	_tmp9_ = power_services_dbus_interfaces_device_get_Type (_tmp8_);
	_tmp10_ = _tmp9_;
	result = (PowerServicesDeviceType) _tmp10_;
	return result;
}

gchar*
power_services_device_get_symbolic_icon_name_for_battery (PowerServicesDevice* self)
{
	gboolean _tmp0_;
	gchar* icon_name = NULL;
	gchar* _tmp2_;
	gdouble _tmp3_;
	gboolean _tmp14_;
	const gchar* _tmp26_;
	gchar* _tmp27_;
	const gchar* _tmp28_;
	gchar* _tmp29_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_is_a_battery;
	if (!_tmp0_) {
		gchar* _tmp1_;
		_tmp1_ = g_strdup ("preferences-system-power-symbolic");
		result = _tmp1_;
		return result;
	}
	_tmp2_ = g_strdup ("battery");
	icon_name = _tmp2_;
	_tmp3_ = self->priv->_percentage;
	if (_tmp3_ > ((gdouble) 10)) {
		gint rounded_percentage = 0;
		gdouble _tmp4_;
		const gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		_tmp4_ = self->priv->_percentage;
		rounded_percentage = (gint) CLAMP (5 * round (_tmp4_ / 5), (gdouble) 20, (gdouble) 100);
		_tmp5_ = icon_name;
		_tmp6_ = g_strdup_printf ("-%i", rounded_percentage);
		_tmp7_ = _tmp6_;
		_tmp8_ = g_strconcat (_tmp5_, _tmp7_, NULL);
		_g_free0 (icon_name);
		icon_name = _tmp8_;
		_g_free0 (_tmp7_);
	} else {
		gdouble _tmp9_;
		_tmp9_ = self->priv->_percentage;
		if (_tmp9_ > ((gdouble) 0)) {
			const gchar* _tmp10_;
			gchar* _tmp11_;
			_tmp10_ = icon_name;
			_tmp11_ = g_strconcat (_tmp10_, "-10", NULL);
			_g_free0 (icon_name);
			icon_name = _tmp11_;
		} else {
			const gchar* _tmp12_;
			gchar* _tmp13_;
			_tmp12_ = icon_name;
			_tmp13_ = g_strconcat (_tmp12_, "-0", NULL);
			_g_free0 (icon_name);
			icon_name = _tmp13_;
		}
	}
	_tmp14_ = self->priv->_is_charging;
	if (_tmp14_) {
		const gchar* _tmp15_;
		gchar* _tmp16_;
		_tmp15_ = icon_name;
		_tmp16_ = g_strconcat (_tmp15_, "-charging", NULL);
		_g_free0 (icon_name);
		icon_name = _tmp16_;
	} else {
		gdouble _tmp17_;
		_tmp17_ = self->priv->_percentage;
		if (_tmp17_ == ((gdouble) 0)) {
			gchar* _tmp18_;
			_tmp18_ = g_strdup ("battery-0");
			_g_free0 (icon_name);
			icon_name = _tmp18_;
		} else {
			gboolean _tmp19_ = FALSE;
			gboolean _tmp20_ = FALSE;
			gint64 _tmp21_;
			_tmp21_ = self->priv->_time_to_empty;
			if (_tmp21_ >= ((gint64) 0)) {
				gint64 _tmp22_;
				_tmp22_ = self->priv->_time_to_empty;
				_tmp20_ = _tmp22_ < ((gint64) (15 * 60));
			} else {
				_tmp20_ = FALSE;
			}
			if (_tmp20_) {
				gdouble _tmp23_;
				_tmp23_ = self->priv->_percentage;
				_tmp19_ = _tmp23_ > ((gdouble) 0);
			} else {
				_tmp19_ = FALSE;
			}
			if (_tmp19_) {
				gint rounded_percentage = 0;
				gdouble _tmp24_;
				gchar* _tmp25_;
				_tmp24_ = self->priv->_percentage;
				rounded_percentage = (gint) CLAMP (5 * round (_tmp24_ / 5), (gdouble) 20, (gdouble) 100);
				_tmp25_ = g_strdup_printf ("battery-%i", rounded_percentage);
				_g_free0 (icon_name);
				icon_name = _tmp25_;
			}
		}
	}
	_tmp26_ = icon_name;
	_tmp27_ = g_strconcat (_tmp26_, "-symbolic", NULL);
	_g_free0 (icon_name);
	icon_name = _tmp27_;
	_tmp28_ = icon_name;
	_tmp29_ = g_strdup (_tmp28_);
	result = _tmp29_;
	_g_free0 (icon_name);
	return result;
}

gchar*
power_services_device_get_icon_name_for_battery (PowerServicesDevice* self)
{
	gboolean _tmp0_;
	gboolean _tmp2_ = FALSE;
	gdouble _tmp3_;
	const gchar* battery_icon = NULL;
	const gchar* _tmp6_;
	gboolean _tmp7_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_is_a_battery;
	if (!_tmp0_) {
		gchar* _tmp1_;
		_tmp1_ = g_strdup ("preferences-system-power-symbolic");
		result = _tmp1_;
		return result;
	}
	_tmp3_ = self->priv->_percentage;
	if (_tmp3_ == ((gdouble) 100)) {
		gboolean _tmp4_;
		_tmp4_ = self->priv->_is_charging;
		_tmp2_ = _tmp4_;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		gchar* _tmp5_;
		_tmp5_ = g_strdup ("battery-full-charged");
		result = _tmp5_;
		return result;
	}
	_tmp6_ = power_services_device_get_battery_icon (self);
	battery_icon = _tmp6_;
	_tmp7_ = self->priv->_is_charging;
	if (_tmp7_) {
		const gchar* _tmp8_;
		gchar* _tmp9_;
		_tmp8_ = battery_icon;
		_tmp9_ = g_strconcat (_tmp8_, "-charging", NULL);
		result = _tmp9_;
		return result;
	} else {
		const gchar* _tmp10_;
		gchar* _tmp11_;
		_tmp10_ = battery_icon;
		_tmp11_ = g_strdup (_tmp10_);
		result = _tmp11_;
		return result;
	}
}

static const gchar*
power_services_device_get_battery_icon (PowerServicesDevice* self)
{
	gboolean _tmp0_;
	gdouble _tmp5_;
	gboolean _tmp6_ = FALSE;
	gdouble _tmp7_;
	gdouble _tmp11_;
	gdouble _tmp12_;
	gdouble _tmp13_;
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_coarse_battery_level;
	if (_tmp0_) {
		gdouble _tmp1_;
		_tmp1_ = self->priv->_percentage;
		if (_tmp1_ < ((gdouble) 20)) {
			result = "battery-empty";
			return result;
		} else {
			gdouble _tmp2_;
			_tmp2_ = self->priv->_percentage;
			if (_tmp2_ < ((gdouble) 40)) {
				result = "battery-caution";
				return result;
			} else {
				gdouble _tmp3_;
				_tmp3_ = self->priv->_percentage;
				if (_tmp3_ < ((gdouble) 60)) {
					result = "battery-low";
					return result;
				} else {
					gdouble _tmp4_;
					_tmp4_ = self->priv->_percentage;
					if (_tmp4_ < ((gdouble) 80)) {
						result = "battery-good";
						return result;
					} else {
						result = "battery-full";
						return result;
					}
				}
			}
		}
	}
	_tmp5_ = self->priv->_percentage;
	if (_tmp5_ <= ((gdouble) 0)) {
		result = "battery-good";
		return result;
	}
	_tmp7_ = self->priv->_percentage;
	if (_tmp7_ < ((gdouble) 10)) {
		gboolean _tmp8_ = FALSE;
		gint64 _tmp9_;
		_tmp9_ = self->priv->_time_to_empty;
		if (_tmp9_ == ((gint64) 0)) {
			_tmp8_ = TRUE;
		} else {
			gint64 _tmp10_;
			_tmp10_ = self->priv->_time_to_empty;
			_tmp8_ = _tmp10_ < ((gint64) (30 * 60));
		}
		_tmp6_ = _tmp8_;
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		result = "battery-empty";
		return result;
	}
	_tmp11_ = self->priv->_percentage;
	if (_tmp11_ < ((gdouble) 37.5f)) {
		result = "battery-caution";
		return result;
	}
	_tmp12_ = self->priv->_percentage;
	if (_tmp12_ < ((gdouble) 62.5f)) {
		result = "battery-low";
		return result;
	}
	_tmp13_ = self->priv->_percentage;
	if (_tmp13_ < ((gdouble) 87.5f)) {
		result = "battery-good";
		return result;
	}
	result = "battery-full";
	return result;
}

static void
power_services_device_update_description (PowerServicesDevice* self)
{
	gboolean _tmp0_;
	gboolean _tmp1_ = FALSE;
	gdouble _tmp2_;
	gboolean _tmp4_;
	gboolean _tmp18_ = FALSE;
	gboolean _tmp19_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_is_a_battery;
	if (!_tmp0_) {
		return;
	}
	_tmp2_ = self->priv->_percentage;
	if (_tmp2_ == ((gdouble) 0)) {
		PowerServicesDeviceState _tmp3_;
		_tmp3_ = self->priv->_state;
		_tmp1_ = _tmp3_ == POWER_SERVICES_DEVICE_STATE_UNKNOWN;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		power_services_device_set_description (self, _ ("Unknown. Device may be locked."));
		return;
	}
	_tmp4_ = self->priv->_coarse_battery_level;
	if (_tmp4_) {
		gdouble _tmp5_;
		_tmp5_ = self->priv->_percentage;
		if (_tmp5_ < ((gdouble) 20)) {
			power_services_device_set_description (self, C_ ("battery-level", "Critical"));
		} else {
			gdouble _tmp6_;
			_tmp6_ = self->priv->_percentage;
			if (_tmp6_ < ((gdouble) 40)) {
				power_services_device_set_description (self, C_ ("battery-level", "Low"));
			} else {
				gdouble _tmp7_;
				_tmp7_ = self->priv->_percentage;
				if (_tmp7_ < ((gdouble) 60)) {
					power_services_device_set_description (self, C_ ("battery-level", "Good"));
				} else {
					gdouble _tmp8_;
					_tmp8_ = self->priv->_percentage;
					if (_tmp8_ < ((gdouble) 80)) {
						power_services_device_set_description (self, C_ ("battery-level", "High"));
					} else {
						power_services_device_set_description (self, C_ ("battery-level", "Full"));
					}
				}
			}
		}
	} else {
		gboolean _tmp9_;
		_tmp9_ = self->priv->_is_charging;
		if (_tmp9_) {
			gdouble _tmp10_;
			gint64 _tmp11_;
			_tmp10_ = self->priv->_percentage;
			if (_tmp10_ == ((gdouble) 100)) {
				power_services_device_set_description (self, _ ("Fully charged"));
				return;
			}
			_tmp11_ = self->priv->_time_to_full;
			if (_tmp11_ > ((gint64) 0)) {
				gdouble _tmp12_;
				gchar* _tmp13_;
				gchar* _tmp14_;
				_tmp12_ = self->priv->_percentage;
				_tmp13_ = g_strdup_printf (_ ("%.0f%% charged"), _tmp12_);
				_tmp14_ = _tmp13_;
				power_services_device_set_description (self, _tmp14_);
				_g_free0 (_tmp14_);
			}
		} else {
			gdouble _tmp15_;
			gchar* _tmp16_;
			gchar* _tmp17_;
			_tmp15_ = self->priv->_percentage;
			_tmp16_ = g_strdup_printf (_ ("%.0f%% remaining"), _tmp15_);
			_tmp17_ = _tmp16_;
			power_services_device_set_description (self, _tmp17_);
			_g_free0 (_tmp17_);
		}
	}
	_tmp19_ = self->priv->_is_charging;
	if (_tmp19_) {
		gint64 _tmp20_;
		_tmp20_ = self->priv->_time_to_full;
		_tmp18_ = _tmp20_ > ((gint64) 0);
	} else {
		_tmp18_ = FALSE;
	}
	if (_tmp18_) {
		const gchar* _tmp21_;
		gchar* _tmp22_;
		gchar* _tmp23_;
		gint64 _tmp24_;
		_tmp21_ = self->priv->_description;
		_tmp22_ = g_strconcat (_tmp21_, "—", NULL);
		_tmp23_ = _tmp22_;
		power_services_device_set_description (self, _tmp23_);
		_g_free0 (_tmp23_);
		_tmp24_ = self->priv->_time_to_full;
		if (_tmp24_ >= ((gint64) 3600)) {
			gint64 hours = 0LL;
			gint64 _tmp25_;
			const gchar* _tmp26_;
			gchar* _tmp27_;
			gchar* _tmp28_;
			gchar* _tmp29_;
			gchar* _tmp30_;
			_tmp25_ = self->priv->_time_to_full;
			hours = _tmp25_ / 3600;
			_tmp26_ = self->priv->_description;
			_tmp27_ = g_strdup_printf (g_dngettext (CONSTANTS_GETTEXT_PACKAGE, "%lld hour until full", "%lld hours until full", (gulong) hours), hours);
			_tmp28_ = _tmp27_;
			_tmp29_ = g_strconcat (_tmp26_, _tmp28_, NULL);
			_tmp30_ = _tmp29_;
			power_services_device_set_description (self, _tmp30_);
			_g_free0 (_tmp30_);
			_g_free0 (_tmp28_);
		} else {
			gint64 _tmp31_;
			_tmp31_ = self->priv->_time_to_full;
			if (_tmp31_ >= ((gint64) 60)) {
				gint64 minutes = 0LL;
				gint64 _tmp32_;
				const gchar* _tmp33_;
				gchar* _tmp34_;
				gchar* _tmp35_;
				gchar* _tmp36_;
				gchar* _tmp37_;
				_tmp32_ = self->priv->_time_to_full;
				minutes = _tmp32_ / 60;
				_tmp33_ = self->priv->_description;
				_tmp34_ = g_strdup_printf (g_dngettext (CONSTANTS_GETTEXT_PACKAGE, "%lld minute until full", "%lld minutes until full", (gulong) minutes), minutes);
				_tmp35_ = _tmp34_;
				_tmp36_ = g_strconcat (_tmp33_, _tmp35_, NULL);
				_tmp37_ = _tmp36_;
				power_services_device_set_description (self, _tmp37_);
				_g_free0 (_tmp37_);
				_g_free0 (_tmp35_);
			} else {
				const gchar* _tmp38_;
				gint64 _tmp39_;
				gint64 _tmp40_;
				gchar* _tmp41_;
				gchar* _tmp42_;
				gchar* _tmp43_;
				gchar* _tmp44_;
				_tmp38_ = self->priv->_description;
				_tmp39_ = self->priv->_time_to_full;
				_tmp40_ = self->priv->_time_to_full;
				_tmp41_ = g_strdup_printf (g_dngettext (CONSTANTS_GETTEXT_PACKAGE, "%lld second until full", "%lld seconds until full", (gulong) _tmp39_), _tmp40_);
				_tmp42_ = _tmp41_;
				_tmp43_ = g_strconcat (_tmp38_, _tmp42_, NULL);
				_tmp44_ = _tmp43_;
				power_services_device_set_description (self, _tmp44_);
				_g_free0 (_tmp44_);
				_g_free0 (_tmp42_);
			}
		}
	} else {
		gint64 _tmp45_;
		_tmp45_ = self->priv->_time_to_empty;
		if (_tmp45_ > ((gint64) 0)) {
			const gchar* _tmp46_;
			gchar* _tmp47_;
			gchar* _tmp48_;
			gint64 _tmp49_;
			_tmp46_ = self->priv->_description;
			_tmp47_ = g_strconcat (_tmp46_, "—", NULL);
			_tmp48_ = _tmp47_;
			power_services_device_set_description (self, _tmp48_);
			_g_free0 (_tmp48_);
			_tmp49_ = self->priv->_time_to_empty;
			if (_tmp49_ >= ((gint64) 3600)) {
				gint64 hours = 0LL;
				gint64 _tmp50_;
				const gchar* _tmp51_;
				gchar* _tmp52_;
				gchar* _tmp53_;
				gchar* _tmp54_;
				gchar* _tmp55_;
				_tmp50_ = self->priv->_time_to_empty;
				hours = _tmp50_ / 3600;
				_tmp51_ = self->priv->_description;
				_tmp52_ = g_strdup_printf (g_dngettext (CONSTANTS_GETTEXT_PACKAGE, "%lld hour until empty", "%lld hours until empty", (gulong) hours), hours);
				_tmp53_ = _tmp52_;
				_tmp54_ = g_strconcat (_tmp51_, _tmp53_, NULL);
				_tmp55_ = _tmp54_;
				power_services_device_set_description (self, _tmp55_);
				_g_free0 (_tmp55_);
				_g_free0 (_tmp53_);
			} else {
				gint64 _tmp56_;
				_tmp56_ = self->priv->_time_to_empty;
				if (_tmp56_ >= ((gint64) 60)) {
					gint64 minutes = 0LL;
					gint64 _tmp57_;
					const gchar* _tmp58_;
					gchar* _tmp59_;
					gchar* _tmp60_;
					gchar* _tmp61_;
					gchar* _tmp62_;
					_tmp57_ = self->priv->_time_to_empty;
					minutes = _tmp57_ / 60;
					_tmp58_ = self->priv->_description;
					_tmp59_ = g_strdup_printf (g_dngettext (CONSTANTS_GETTEXT_PACKAGE, "%lld minute until empty", "%lld minutes until empty", (gulong) minutes), minutes);
					_tmp60_ = _tmp59_;
					_tmp61_ = g_strconcat (_tmp58_, _tmp60_, NULL);
					_tmp62_ = _tmp61_;
					power_services_device_set_description (self, _tmp62_);
					_g_free0 (_tmp62_);
					_g_free0 (_tmp60_);
				} else {
					const gchar* _tmp63_;
					gint64 _tmp64_;
					gint64 _tmp65_;
					gchar* _tmp66_;
					gchar* _tmp67_;
					gchar* _tmp68_;
					gchar* _tmp69_;
					_tmp63_ = self->priv->_description;
					_tmp64_ = self->priv->_time_to_empty;
					_tmp65_ = self->priv->_time_to_empty;
					_tmp66_ = g_strdup_printf (g_dngettext (CONSTANTS_GETTEXT_PACKAGE, "%lld second until empty", "%lld seconds until empty", (gulong) _tmp64_), _tmp65_);
					_tmp67_ = _tmp66_;
					_tmp68_ = g_strconcat (_tmp63_, _tmp67_, NULL);
					_tmp69_ = _tmp68_;
					power_services_device_set_description (self, _tmp69_);
					_g_free0 (_tmp69_);
					_g_free0 (_tmp67_);
				}
			}
		}
	}
}

gboolean
power_services_device_get_coarse_battery_level (PowerServicesDevice* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_coarse_battery_level;
	return result;
}

static void
power_services_device_set_coarse_battery_level (PowerServicesDevice* self,
                                                gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = power_services_device_get_coarse_battery_level (self);
	if (old_value != value) {
		self->priv->_coarse_battery_level = value;
		g_object_notify_by_pspec ((GObject *) self, power_services_device_properties[POWER_SERVICES_DEVICE_COARSE_BATTERY_LEVEL_PROPERTY]);
	}
}

gboolean
power_services_device_get_has_history (PowerServicesDevice* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_has_history;
	return result;
}

static void
power_services_device_set_has_history (PowerServicesDevice* self,
                                       gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = power_services_device_get_has_history (self);
	if (old_value != value) {
		self->priv->_has_history = value;
		g_object_notify_by_pspec ((GObject *) self, power_services_device_properties[POWER_SERVICES_DEVICE_HAS_HISTORY_PROPERTY]);
	}
}

gboolean
power_services_device_get_has_statistics (PowerServicesDevice* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_has_statistics;
	return result;
}

static void
power_services_device_set_has_statistics (PowerServicesDevice* self,
                                          gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = power_services_device_get_has_statistics (self);
	if (old_value != value) {
		self->priv->_has_statistics = value;
		g_object_notify_by_pspec ((GObject *) self, power_services_device_properties[POWER_SERVICES_DEVICE_HAS_STATISTICS_PROPERTY]);
	}
}

gboolean
power_services_device_get_is_present (PowerServicesDevice* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_present;
	return result;
}

static void
power_services_device_set_is_present (PowerServicesDevice* self,
                                      gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = power_services_device_get_is_present (self);
	if (old_value != value) {
		self->priv->_is_present = value;
		g_object_notify_by_pspec ((GObject *) self, power_services_device_properties[POWER_SERVICES_DEVICE_IS_PRESENT_PROPERTY]);
	}
}

gboolean
power_services_device_get_is_rechargeable (PowerServicesDevice* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_rechargeable;
	return result;
}

static void
power_services_device_set_is_rechargeable (PowerServicesDevice* self,
                                           gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = power_services_device_get_is_rechargeable (self);
	if (old_value != value) {
		self->priv->_is_rechargeable = value;
		g_object_notify_by_pspec ((GObject *) self, power_services_device_properties[POWER_SERVICES_DEVICE_IS_RECHARGEABLE_PROPERTY]);
	}
}

gboolean
power_services_device_get_online (PowerServicesDevice* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_online;
	return result;
}

static void
power_services_device_set_online (PowerServicesDevice* self,
                                  gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = power_services_device_get_online (self);
	if (old_value != value) {
		self->priv->_online = value;
		g_object_notify_by_pspec ((GObject *) self, power_services_device_properties[POWER_SERVICES_DEVICE_ONLINE_PROPERTY]);
	}
}

gboolean
power_services_device_get_power_supply (PowerServicesDevice* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_power_supply;
	return result;
}

static void
power_services_device_set_power_supply (PowerServicesDevice* self,
                                        gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = power_services_device_get_power_supply (self);
	if (old_value != value) {
		self->priv->_power_supply = value;
		g_object_notify_by_pspec ((GObject *) self, power_services_device_properties[POWER_SERVICES_DEVICE_POWER_SUPPLY_PROPERTY]);
	}
}

gdouble
power_services_device_get_capacity (PowerServicesDevice* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_capacity;
	return result;
}

static void
power_services_device_set_capacity (PowerServicesDevice* self,
                                    gdouble value)
{
	gdouble old_value;
	g_return_if_fail (self != NULL);
	old_value = power_services_device_get_capacity (self);
	if (old_value != value) {
		self->priv->_capacity = value;
		g_object_notify_by_pspec ((GObject *) self, power_services_device_properties[POWER_SERVICES_DEVICE_CAPACITY_PROPERTY]);
	}
}

const gchar*
power_services_device_get_description (PowerServicesDevice* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_description;
	result = _tmp0_;
	return result;
}

static void
power_services_device_set_description (PowerServicesDevice* self,
                                       const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = power_services_device_get_description (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_description);
		self->priv->_description = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, power_services_device_properties[POWER_SERVICES_DEVICE_DESCRIPTION_PROPERTY]);
	}
}

gdouble
power_services_device_get_energy (PowerServicesDevice* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_energy;
	return result;
}

static void
power_services_device_set_energy (PowerServicesDevice* self,
                                  gdouble value)
{
	gdouble old_value;
	g_return_if_fail (self != NULL);
	old_value = power_services_device_get_energy (self);
	if (old_value != value) {
		self->priv->_energy = value;
		g_object_notify_by_pspec ((GObject *) self, power_services_device_properties[POWER_SERVICES_DEVICE_ENERGY_PROPERTY]);
	}
}

gdouble
power_services_device_get_energy_empty (PowerServicesDevice* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_energy_empty;
	return result;
}

static void
power_services_device_set_energy_empty (PowerServicesDevice* self,
                                        gdouble value)
{
	gdouble old_value;
	g_return_if_fail (self != NULL);
	old_value = power_services_device_get_energy_empty (self);
	if (old_value != value) {
		self->priv->_energy_empty = value;
		g_object_notify_by_pspec ((GObject *) self, power_services_device_properties[POWER_SERVICES_DEVICE_ENERGY_EMPTY_PROPERTY]);
	}
}

gdouble
power_services_device_get_energy_full (PowerServicesDevice* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_energy_full;
	return result;
}

static void
power_services_device_set_energy_full (PowerServicesDevice* self,
                                       gdouble value)
{
	gdouble old_value;
	g_return_if_fail (self != NULL);
	old_value = power_services_device_get_energy_full (self);
	if (old_value != value) {
		self->priv->_energy_full = value;
		g_object_notify_by_pspec ((GObject *) self, power_services_device_properties[POWER_SERVICES_DEVICE_ENERGY_FULL_PROPERTY]);
	}
}

gdouble
power_services_device_get_energy_full_design (PowerServicesDevice* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_energy_full_design;
	return result;
}

static void
power_services_device_set_energy_full_design (PowerServicesDevice* self,
                                              gdouble value)
{
	gdouble old_value;
	g_return_if_fail (self != NULL);
	old_value = power_services_device_get_energy_full_design (self);
	if (old_value != value) {
		self->priv->_energy_full_design = value;
		g_object_notify_by_pspec ((GObject *) self, power_services_device_properties[POWER_SERVICES_DEVICE_ENERGY_FULL_DESIGN_PROPERTY]);
	}
}

gdouble
power_services_device_get_energy_rate (PowerServicesDevice* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_energy_rate;
	return result;
}

static void
power_services_device_set_energy_rate (PowerServicesDevice* self,
                                       gdouble value)
{
	gdouble old_value;
	g_return_if_fail (self != NULL);
	old_value = power_services_device_get_energy_rate (self);
	if (old_value != value) {
		self->priv->_energy_rate = value;
		g_object_notify_by_pspec ((GObject *) self, power_services_device_properties[POWER_SERVICES_DEVICE_ENERGY_RATE_PROPERTY]);
	}
}

gdouble
power_services_device_get_luminosity (PowerServicesDevice* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_luminosity;
	return result;
}

static void
power_services_device_set_luminosity (PowerServicesDevice* self,
                                      gdouble value)
{
	gdouble old_value;
	g_return_if_fail (self != NULL);
	old_value = power_services_device_get_luminosity (self);
	if (old_value != value) {
		self->priv->_luminosity = value;
		g_object_notify_by_pspec ((GObject *) self, power_services_device_properties[POWER_SERVICES_DEVICE_LUMINOSITY_PROPERTY]);
	}
}

gdouble
power_services_device_get_percentage (PowerServicesDevice* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_percentage;
	return result;
}

static void
power_services_device_set_percentage (PowerServicesDevice* self,
                                      gdouble value)
{
	gdouble old_value;
	g_return_if_fail (self != NULL);
	old_value = power_services_device_get_percentage (self);
	if (old_value != value) {
		self->priv->_percentage = value;
		g_object_notify_by_pspec ((GObject *) self, power_services_device_properties[POWER_SERVICES_DEVICE_PERCENTAGE_PROPERTY]);
	}
}

gdouble
power_services_device_get_temperature (PowerServicesDevice* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_temperature;
	return result;
}

static void
power_services_device_set_temperature (PowerServicesDevice* self,
                                       gdouble value)
{
	gdouble old_value;
	g_return_if_fail (self != NULL);
	old_value = power_services_device_get_temperature (self);
	if (old_value != value) {
		self->priv->_temperature = value;
		g_object_notify_by_pspec ((GObject *) self, power_services_device_properties[POWER_SERVICES_DEVICE_TEMPERATURE_PROPERTY]);
	}
}

gdouble
power_services_device_get_voltage (PowerServicesDevice* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_voltage;
	return result;
}

static void
power_services_device_set_voltage (PowerServicesDevice* self,
                                   gdouble value)
{
	gdouble old_value;
	g_return_if_fail (self != NULL);
	old_value = power_services_device_get_voltage (self);
	if (old_value != value) {
		self->priv->_voltage = value;
		g_object_notify_by_pspec ((GObject *) self, power_services_device_properties[POWER_SERVICES_DEVICE_VOLTAGE_PROPERTY]);
	}
}

gint64
power_services_device_get_time_to_empty (PowerServicesDevice* self)
{
	gint64 result;
	g_return_val_if_fail (self != NULL, 0LL);
	result = self->priv->_time_to_empty;
	return result;
}

static void
power_services_device_set_time_to_empty (PowerServicesDevice* self,
                                         gint64 value)
{
	gint64 old_value;
	g_return_if_fail (self != NULL);
	old_value = power_services_device_get_time_to_empty (self);
	if (old_value != value) {
		self->priv->_time_to_empty = value;
		g_object_notify_by_pspec ((GObject *) self, power_services_device_properties[POWER_SERVICES_DEVICE_TIME_TO_EMPTY_PROPERTY]);
	}
}

gint64
power_services_device_get_time_to_full (PowerServicesDevice* self)
{
	gint64 result;
	g_return_val_if_fail (self != NULL, 0LL);
	result = self->priv->_time_to_full;
	return result;
}

static void
power_services_device_set_time_to_full (PowerServicesDevice* self,
                                        gint64 value)
{
	gint64 old_value;
	g_return_if_fail (self != NULL);
	old_value = power_services_device_get_time_to_full (self);
	if (old_value != value) {
		self->priv->_time_to_full = value;
		g_object_notify_by_pspec ((GObject *) self, power_services_device_properties[POWER_SERVICES_DEVICE_TIME_TO_FULL_PROPERTY]);
	}
}

const gchar*
power_services_device_get_model (PowerServicesDevice* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_model;
	result = _tmp0_;
	return result;
}

static void
power_services_device_set_model (PowerServicesDevice* self,
                                 const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = power_services_device_get_model (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_model);
		self->priv->_model = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, power_services_device_properties[POWER_SERVICES_DEVICE_MODEL_PROPERTY]);
	}
}

const gchar*
power_services_device_get_native_path (PowerServicesDevice* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_native_path;
	result = _tmp0_;
	return result;
}

static void
power_services_device_set_native_path (PowerServicesDevice* self,
                                       const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = power_services_device_get_native_path (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_native_path);
		self->priv->_native_path = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, power_services_device_properties[POWER_SERVICES_DEVICE_NATIVE_PATH_PROPERTY]);
	}
}

const gchar*
power_services_device_get_serial (PowerServicesDevice* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_serial;
	result = _tmp0_;
	return result;
}

static void
power_services_device_set_serial (PowerServicesDevice* self,
                                  const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = power_services_device_get_serial (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_serial);
		self->priv->_serial = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, power_services_device_properties[POWER_SERVICES_DEVICE_SERIAL_PROPERTY]);
	}
}

const gchar*
power_services_device_get_vendor (PowerServicesDevice* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_vendor;
	result = _tmp0_;
	return result;
}

static void
power_services_device_set_vendor (PowerServicesDevice* self,
                                  const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = power_services_device_get_vendor (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_vendor);
		self->priv->_vendor = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, power_services_device_properties[POWER_SERVICES_DEVICE_VENDOR_PROPERTY]);
	}
}

PowerServicesDeviceState
power_services_device_get_state (PowerServicesDevice* self)
{
	PowerServicesDeviceState result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_state;
	return result;
}

static void
power_services_device_set_state (PowerServicesDevice* self,
                                 PowerServicesDeviceState value)
{
	PowerServicesDeviceState old_value;
	g_return_if_fail (self != NULL);
	old_value = power_services_device_get_state (self);
	if (old_value != value) {
		self->priv->_state = value;
		g_object_notify_by_pspec ((GObject *) self, power_services_device_properties[POWER_SERVICES_DEVICE_STATE_PROPERTY]);
	}
}

PowerServicesDeviceTechnology
power_services_device_get_technology (PowerServicesDevice* self)
{
	PowerServicesDeviceTechnology result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_technology;
	return result;
}

static void
power_services_device_set_technology (PowerServicesDevice* self,
                                      PowerServicesDeviceTechnology value)
{
	PowerServicesDeviceTechnology old_value;
	g_return_if_fail (self != NULL);
	old_value = power_services_device_get_technology (self);
	if (old_value != value) {
		self->priv->_technology = value;
		g_object_notify_by_pspec ((GObject *) self, power_services_device_properties[POWER_SERVICES_DEVICE_TECHNOLOGY_PROPERTY]);
	}
}

PowerServicesDeviceType
power_services_device_get_device_type (PowerServicesDevice* self)
{
	PowerServicesDeviceType result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_device_type;
	return result;
}

static void
power_services_device_set_device_type (PowerServicesDevice* self,
                                       PowerServicesDeviceType value)
{
	PowerServicesDeviceType old_value;
	g_return_if_fail (self != NULL);
	old_value = power_services_device_get_device_type (self);
	if (old_value != value) {
		self->priv->_device_type = value;
		g_object_notify_by_pspec ((GObject *) self, power_services_device_properties[POWER_SERVICES_DEVICE_DEVICE_TYPE_PROPERTY]);
	}
}

guint64
power_services_device_get_update_time (PowerServicesDevice* self)
{
	guint64 result;
	g_return_val_if_fail (self != NULL, 0ULL);
	result = self->priv->_update_time;
	return result;
}

static void
power_services_device_set_update_time (PowerServicesDevice* self,
                                       guint64 value)
{
	guint64 old_value;
	g_return_if_fail (self != NULL);
	old_value = power_services_device_get_update_time (self);
	if (old_value != value) {
		self->priv->_update_time = value;
		g_object_notify_by_pspec ((GObject *) self, power_services_device_properties[POWER_SERVICES_DEVICE_UPDATE_TIME_PROPERTY]);
	}
}

gboolean
power_services_device_get_is_charging (PowerServicesDevice* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_charging;
	return result;
}

static void
power_services_device_set_is_charging (PowerServicesDevice* self,
                                       gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = power_services_device_get_is_charging (self);
	if (old_value != value) {
		self->priv->_is_charging = value;
		g_object_notify_by_pspec ((GObject *) self, power_services_device_properties[POWER_SERVICES_DEVICE_IS_CHARGING_PROPERTY]);
	}
}

gboolean
power_services_device_get_is_a_battery (PowerServicesDevice* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_a_battery;
	return result;
}

static void
power_services_device_set_is_a_battery (PowerServicesDevice* self,
                                        gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = power_services_device_get_is_a_battery (self);
	if (old_value != value) {
		self->priv->_is_a_battery = value;
		g_object_notify_by_pspec ((GObject *) self, power_services_device_properties[POWER_SERVICES_DEVICE_IS_A_BATTERY_PROPERTY]);
	}
}

static void
power_services_device_class_init (PowerServicesDeviceClass * klass,
                                  gpointer klass_data)
{
	power_services_device_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PowerServicesDevice_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_power_services_device_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_power_services_device_set_property;
	G_OBJECT_CLASS (klass)->finalize = power_services_device_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), POWER_SERVICES_DEVICE_COARSE_BATTERY_LEVEL_PROPERTY, power_services_device_properties[POWER_SERVICES_DEVICE_COARSE_BATTERY_LEVEL_PROPERTY] = g_param_spec_boolean ("coarse-battery-level", "coarse-battery-level", "coarse-battery-level", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), POWER_SERVICES_DEVICE_HAS_HISTORY_PROPERTY, power_services_device_properties[POWER_SERVICES_DEVICE_HAS_HISTORY_PROPERTY] = g_param_spec_boolean ("has-history", "has-history", "has-history", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), POWER_SERVICES_DEVICE_HAS_STATISTICS_PROPERTY, power_services_device_properties[POWER_SERVICES_DEVICE_HAS_STATISTICS_PROPERTY] = g_param_spec_boolean ("has-statistics", "has-statistics", "has-statistics", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), POWER_SERVICES_DEVICE_IS_PRESENT_PROPERTY, power_services_device_properties[POWER_SERVICES_DEVICE_IS_PRESENT_PROPERTY] = g_param_spec_boolean ("is-present", "is-present", "is-present", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), POWER_SERVICES_DEVICE_IS_RECHARGEABLE_PROPERTY, power_services_device_properties[POWER_SERVICES_DEVICE_IS_RECHARGEABLE_PROPERTY] = g_param_spec_boolean ("is-rechargeable", "is-rechargeable", "is-rechargeable", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), POWER_SERVICES_DEVICE_ONLINE_PROPERTY, power_services_device_properties[POWER_SERVICES_DEVICE_ONLINE_PROPERTY] = g_param_spec_boolean ("online", "online", "online", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), POWER_SERVICES_DEVICE_POWER_SUPPLY_PROPERTY, power_services_device_properties[POWER_SERVICES_DEVICE_POWER_SUPPLY_PROPERTY] = g_param_spec_boolean ("power-supply", "power-supply", "power-supply", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), POWER_SERVICES_DEVICE_CAPACITY_PROPERTY, power_services_device_properties[POWER_SERVICES_DEVICE_CAPACITY_PROPERTY] = g_param_spec_double ("capacity", "capacity", "capacity", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), POWER_SERVICES_DEVICE_DESCRIPTION_PROPERTY, power_services_device_properties[POWER_SERVICES_DEVICE_DESCRIPTION_PROPERTY] = g_param_spec_string ("description", "description", "description", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), POWER_SERVICES_DEVICE_ENERGY_PROPERTY, power_services_device_properties[POWER_SERVICES_DEVICE_ENERGY_PROPERTY] = g_param_spec_double ("energy", "energy", "energy", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), POWER_SERVICES_DEVICE_ENERGY_EMPTY_PROPERTY, power_services_device_properties[POWER_SERVICES_DEVICE_ENERGY_EMPTY_PROPERTY] = g_param_spec_double ("energy-empty", "energy-empty", "energy-empty", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), POWER_SERVICES_DEVICE_ENERGY_FULL_PROPERTY, power_services_device_properties[POWER_SERVICES_DEVICE_ENERGY_FULL_PROPERTY] = g_param_spec_double ("energy-full", "energy-full", "energy-full", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), POWER_SERVICES_DEVICE_ENERGY_FULL_DESIGN_PROPERTY, power_services_device_properties[POWER_SERVICES_DEVICE_ENERGY_FULL_DESIGN_PROPERTY] = g_param_spec_double ("energy-full-design", "energy-full-design", "energy-full-design", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), POWER_SERVICES_DEVICE_ENERGY_RATE_PROPERTY, power_services_device_properties[POWER_SERVICES_DEVICE_ENERGY_RATE_PROPERTY] = g_param_spec_double ("energy-rate", "energy-rate", "energy-rate", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), POWER_SERVICES_DEVICE_LUMINOSITY_PROPERTY, power_services_device_properties[POWER_SERVICES_DEVICE_LUMINOSITY_PROPERTY] = g_param_spec_double ("luminosity", "luminosity", "luminosity", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), POWER_SERVICES_DEVICE_PERCENTAGE_PROPERTY, power_services_device_properties[POWER_SERVICES_DEVICE_PERCENTAGE_PROPERTY] = g_param_spec_double ("percentage", "percentage", "percentage", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), POWER_SERVICES_DEVICE_TEMPERATURE_PROPERTY, power_services_device_properties[POWER_SERVICES_DEVICE_TEMPERATURE_PROPERTY] = g_param_spec_double ("temperature", "temperature", "temperature", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), POWER_SERVICES_DEVICE_VOLTAGE_PROPERTY, power_services_device_properties[POWER_SERVICES_DEVICE_VOLTAGE_PROPERTY] = g_param_spec_double ("voltage", "voltage", "voltage", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), POWER_SERVICES_DEVICE_TIME_TO_EMPTY_PROPERTY, power_services_device_properties[POWER_SERVICES_DEVICE_TIME_TO_EMPTY_PROPERTY] = g_param_spec_int64 ("time-to-empty", "time-to-empty", "time-to-empty", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), POWER_SERVICES_DEVICE_TIME_TO_FULL_PROPERTY, power_services_device_properties[POWER_SERVICES_DEVICE_TIME_TO_FULL_PROPERTY] = g_param_spec_int64 ("time-to-full", "time-to-full", "time-to-full", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), POWER_SERVICES_DEVICE_MODEL_PROPERTY, power_services_device_properties[POWER_SERVICES_DEVICE_MODEL_PROPERTY] = g_param_spec_string ("model", "model", "model", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), POWER_SERVICES_DEVICE_NATIVE_PATH_PROPERTY, power_services_device_properties[POWER_SERVICES_DEVICE_NATIVE_PATH_PROPERTY] = g_param_spec_string ("native-path", "native-path", "native-path", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), POWER_SERVICES_DEVICE_SERIAL_PROPERTY, power_services_device_properties[POWER_SERVICES_DEVICE_SERIAL_PROPERTY] = g_param_spec_string ("serial", "serial", "serial", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), POWER_SERVICES_DEVICE_VENDOR_PROPERTY, power_services_device_properties[POWER_SERVICES_DEVICE_VENDOR_PROPERTY] = g_param_spec_string ("vendor", "vendor", "vendor", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), POWER_SERVICES_DEVICE_STATE_PROPERTY, power_services_device_properties[POWER_SERVICES_DEVICE_STATE_PROPERTY] = g_param_spec_enum ("state", "state", "state", POWER_SERVICES_DEVICE_TYPE_STATE, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), POWER_SERVICES_DEVICE_TECHNOLOGY_PROPERTY, power_services_device_properties[POWER_SERVICES_DEVICE_TECHNOLOGY_PROPERTY] = g_param_spec_enum ("technology", "technology", "technology", POWER_SERVICES_DEVICE_TYPE_TECHNOLOGY, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), POWER_SERVICES_DEVICE_DEVICE_TYPE_PROPERTY, power_services_device_properties[POWER_SERVICES_DEVICE_DEVICE_TYPE_PROPERTY] = g_param_spec_enum ("device-type", "device-type", "device-type", POWER_SERVICES_DEVICE_TYPE_TYPE, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), POWER_SERVICES_DEVICE_UPDATE_TIME_PROPERTY, power_services_device_properties[POWER_SERVICES_DEVICE_UPDATE_TIME_PROPERTY] = g_param_spec_uint64 ("update-time", "update-time", "update-time", 0, G_MAXUINT64, 0U, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), POWER_SERVICES_DEVICE_IS_CHARGING_PROPERTY, power_services_device_properties[POWER_SERVICES_DEVICE_IS_CHARGING_PROPERTY] = g_param_spec_boolean ("is-charging", "is-charging", "is-charging", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), POWER_SERVICES_DEVICE_IS_A_BATTERY_PROPERTY, power_services_device_properties[POWER_SERVICES_DEVICE_IS_A_BATTERY_PROPERTY] = g_param_spec_boolean ("is-a-battery", "is-a-battery", "is-a-battery", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	power_services_device_signals[POWER_SERVICES_DEVICE_PROPERTIES_UPDATED_SIGNAL] = g_signal_new ("properties-updated", POWER_SERVICES_TYPE_DEVICE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
power_services_device_instance_init (PowerServicesDevice * self,
                                     gpointer klass)
{
	gchar* _tmp0_;
	self->priv = power_services_device_get_instance_private (self);
	_tmp0_ = g_strdup ("");
	self->priv->device_path = _tmp0_;
	self->priv->device = NULL;
	self->priv->_coarse_battery_level = FALSE;
}

static void
power_services_device_finalize (GObject * obj)
{
	PowerServicesDevice * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, POWER_SERVICES_TYPE_DEVICE, PowerServicesDevice);
	_g_free0 (self->priv->device_path);
	_g_object_unref0 (self->priv->device);
	_g_free0 (self->priv->_description);
	_g_free0 (self->priv->_model);
	_g_free0 (self->priv->_native_path);
	_g_free0 (self->priv->_serial);
	_g_free0 (self->priv->_vendor);
	G_OBJECT_CLASS (power_services_device_parent_class)->finalize (obj);
}

static GType
power_services_device_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PowerServicesDeviceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) power_services_device_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PowerServicesDevice), 0, (GInstanceInitFunc) power_services_device_instance_init, NULL };
	GType power_services_device_type_id;
	power_services_device_type_id = g_type_register_static (G_TYPE_OBJECT, "PowerServicesDevice", &g_define_type_info, 0);
	PowerServicesDevice_private_offset = g_type_add_instance_private (power_services_device_type_id, sizeof (PowerServicesDevicePrivate));
	return power_services_device_type_id;
}

GType
power_services_device_get_type (void)
{
	static volatile gsize power_services_device_type_id__once = 0;
	if (g_once_init_enter (&power_services_device_type_id__once)) {
		GType power_services_device_type_id;
		power_services_device_type_id = power_services_device_get_type_once ();
		g_once_init_leave (&power_services_device_type_id__once, power_services_device_type_id);
	}
	return power_services_device_type_id__once;
}

static void
_vala_power_services_device_get_property (GObject * object,
                                          guint property_id,
                                          GValue * value,
                                          GParamSpec * pspec)
{
	PowerServicesDevice * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, POWER_SERVICES_TYPE_DEVICE, PowerServicesDevice);
	switch (property_id) {
		case POWER_SERVICES_DEVICE_COARSE_BATTERY_LEVEL_PROPERTY:
		g_value_set_boolean (value, power_services_device_get_coarse_battery_level (self));
		break;
		case POWER_SERVICES_DEVICE_HAS_HISTORY_PROPERTY:
		g_value_set_boolean (value, power_services_device_get_has_history (self));
		break;
		case POWER_SERVICES_DEVICE_HAS_STATISTICS_PROPERTY:
		g_value_set_boolean (value, power_services_device_get_has_statistics (self));
		break;
		case POWER_SERVICES_DEVICE_IS_PRESENT_PROPERTY:
		g_value_set_boolean (value, power_services_device_get_is_present (self));
		break;
		case POWER_SERVICES_DEVICE_IS_RECHARGEABLE_PROPERTY:
		g_value_set_boolean (value, power_services_device_get_is_rechargeable (self));
		break;
		case POWER_SERVICES_DEVICE_ONLINE_PROPERTY:
		g_value_set_boolean (value, power_services_device_get_online (self));
		break;
		case POWER_SERVICES_DEVICE_POWER_SUPPLY_PROPERTY:
		g_value_set_boolean (value, power_services_device_get_power_supply (self));
		break;
		case POWER_SERVICES_DEVICE_CAPACITY_PROPERTY:
		g_value_set_double (value, power_services_device_get_capacity (self));
		break;
		case POWER_SERVICES_DEVICE_DESCRIPTION_PROPERTY:
		g_value_set_string (value, power_services_device_get_description (self));
		break;
		case POWER_SERVICES_DEVICE_ENERGY_PROPERTY:
		g_value_set_double (value, power_services_device_get_energy (self));
		break;
		case POWER_SERVICES_DEVICE_ENERGY_EMPTY_PROPERTY:
		g_value_set_double (value, power_services_device_get_energy_empty (self));
		break;
		case POWER_SERVICES_DEVICE_ENERGY_FULL_PROPERTY:
		g_value_set_double (value, power_services_device_get_energy_full (self));
		break;
		case POWER_SERVICES_DEVICE_ENERGY_FULL_DESIGN_PROPERTY:
		g_value_set_double (value, power_services_device_get_energy_full_design (self));
		break;
		case POWER_SERVICES_DEVICE_ENERGY_RATE_PROPERTY:
		g_value_set_double (value, power_services_device_get_energy_rate (self));
		break;
		case POWER_SERVICES_DEVICE_LUMINOSITY_PROPERTY:
		g_value_set_double (value, power_services_device_get_luminosity (self));
		break;
		case POWER_SERVICES_DEVICE_PERCENTAGE_PROPERTY:
		g_value_set_double (value, power_services_device_get_percentage (self));
		break;
		case POWER_SERVICES_DEVICE_TEMPERATURE_PROPERTY:
		g_value_set_double (value, power_services_device_get_temperature (self));
		break;
		case POWER_SERVICES_DEVICE_VOLTAGE_PROPERTY:
		g_value_set_double (value, power_services_device_get_voltage (self));
		break;
		case POWER_SERVICES_DEVICE_TIME_TO_EMPTY_PROPERTY:
		g_value_set_int64 (value, power_services_device_get_time_to_empty (self));
		break;
		case POWER_SERVICES_DEVICE_TIME_TO_FULL_PROPERTY:
		g_value_set_int64 (value, power_services_device_get_time_to_full (self));
		break;
		case POWER_SERVICES_DEVICE_MODEL_PROPERTY:
		g_value_set_string (value, power_services_device_get_model (self));
		break;
		case POWER_SERVICES_DEVICE_NATIVE_PATH_PROPERTY:
		g_value_set_string (value, power_services_device_get_native_path (self));
		break;
		case POWER_SERVICES_DEVICE_SERIAL_PROPERTY:
		g_value_set_string (value, power_services_device_get_serial (self));
		break;
		case POWER_SERVICES_DEVICE_VENDOR_PROPERTY:
		g_value_set_string (value, power_services_device_get_vendor (self));
		break;
		case POWER_SERVICES_DEVICE_STATE_PROPERTY:
		g_value_set_enum (value, power_services_device_get_state (self));
		break;
		case POWER_SERVICES_DEVICE_TECHNOLOGY_PROPERTY:
		g_value_set_enum (value, power_services_device_get_technology (self));
		break;
		case POWER_SERVICES_DEVICE_DEVICE_TYPE_PROPERTY:
		g_value_set_enum (value, power_services_device_get_device_type (self));
		break;
		case POWER_SERVICES_DEVICE_UPDATE_TIME_PROPERTY:
		g_value_set_uint64 (value, power_services_device_get_update_time (self));
		break;
		case POWER_SERVICES_DEVICE_IS_CHARGING_PROPERTY:
		g_value_set_boolean (value, power_services_device_get_is_charging (self));
		break;
		case POWER_SERVICES_DEVICE_IS_A_BATTERY_PROPERTY:
		g_value_set_boolean (value, power_services_device_get_is_a_battery (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_power_services_device_set_property (GObject * object,
                                          guint property_id,
                                          const GValue * value,
                                          GParamSpec * pspec)
{
	PowerServicesDevice * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, POWER_SERVICES_TYPE_DEVICE, PowerServicesDevice);
	switch (property_id) {
		case POWER_SERVICES_DEVICE_COARSE_BATTERY_LEVEL_PROPERTY:
		power_services_device_set_coarse_battery_level (self, g_value_get_boolean (value));
		break;
		case POWER_SERVICES_DEVICE_HAS_HISTORY_PROPERTY:
		power_services_device_set_has_history (self, g_value_get_boolean (value));
		break;
		case POWER_SERVICES_DEVICE_HAS_STATISTICS_PROPERTY:
		power_services_device_set_has_statistics (self, g_value_get_boolean (value));
		break;
		case POWER_SERVICES_DEVICE_IS_PRESENT_PROPERTY:
		power_services_device_set_is_present (self, g_value_get_boolean (value));
		break;
		case POWER_SERVICES_DEVICE_IS_RECHARGEABLE_PROPERTY:
		power_services_device_set_is_rechargeable (self, g_value_get_boolean (value));
		break;
		case POWER_SERVICES_DEVICE_ONLINE_PROPERTY:
		power_services_device_set_online (self, g_value_get_boolean (value));
		break;
		case POWER_SERVICES_DEVICE_POWER_SUPPLY_PROPERTY:
		power_services_device_set_power_supply (self, g_value_get_boolean (value));
		break;
		case POWER_SERVICES_DEVICE_CAPACITY_PROPERTY:
		power_services_device_set_capacity (self, g_value_get_double (value));
		break;
		case POWER_SERVICES_DEVICE_DESCRIPTION_PROPERTY:
		power_services_device_set_description (self, g_value_get_string (value));
		break;
		case POWER_SERVICES_DEVICE_ENERGY_PROPERTY:
		power_services_device_set_energy (self, g_value_get_double (value));
		break;
		case POWER_SERVICES_DEVICE_ENERGY_EMPTY_PROPERTY:
		power_services_device_set_energy_empty (self, g_value_get_double (value));
		break;
		case POWER_SERVICES_DEVICE_ENERGY_FULL_PROPERTY:
		power_services_device_set_energy_full (self, g_value_get_double (value));
		break;
		case POWER_SERVICES_DEVICE_ENERGY_FULL_DESIGN_PROPERTY:
		power_services_device_set_energy_full_design (self, g_value_get_double (value));
		break;
		case POWER_SERVICES_DEVICE_ENERGY_RATE_PROPERTY:
		power_services_device_set_energy_rate (self, g_value_get_double (value));
		break;
		case POWER_SERVICES_DEVICE_LUMINOSITY_PROPERTY:
		power_services_device_set_luminosity (self, g_value_get_double (value));
		break;
		case POWER_SERVICES_DEVICE_PERCENTAGE_PROPERTY:
		power_services_device_set_percentage (self, g_value_get_double (value));
		break;
		case POWER_SERVICES_DEVICE_TEMPERATURE_PROPERTY:
		power_services_device_set_temperature (self, g_value_get_double (value));
		break;
		case POWER_SERVICES_DEVICE_VOLTAGE_PROPERTY:
		power_services_device_set_voltage (self, g_value_get_double (value));
		break;
		case POWER_SERVICES_DEVICE_TIME_TO_EMPTY_PROPERTY:
		power_services_device_set_time_to_empty (self, g_value_get_int64 (value));
		break;
		case POWER_SERVICES_DEVICE_TIME_TO_FULL_PROPERTY:
		power_services_device_set_time_to_full (self, g_value_get_int64 (value));
		break;
		case POWER_SERVICES_DEVICE_MODEL_PROPERTY:
		power_services_device_set_model (self, g_value_get_string (value));
		break;
		case POWER_SERVICES_DEVICE_NATIVE_PATH_PROPERTY:
		power_services_device_set_native_path (self, g_value_get_string (value));
		break;
		case POWER_SERVICES_DEVICE_SERIAL_PROPERTY:
		power_services_device_set_serial (self, g_value_get_string (value));
		break;
		case POWER_SERVICES_DEVICE_VENDOR_PROPERTY:
		power_services_device_set_vendor (self, g_value_get_string (value));
		break;
		case POWER_SERVICES_DEVICE_STATE_PROPERTY:
		power_services_device_set_state (self, g_value_get_enum (value));
		break;
		case POWER_SERVICES_DEVICE_TECHNOLOGY_PROPERTY:
		power_services_device_set_technology (self, g_value_get_enum (value));
		break;
		case POWER_SERVICES_DEVICE_DEVICE_TYPE_PROPERTY:
		power_services_device_set_device_type (self, g_value_get_enum (value));
		break;
		case POWER_SERVICES_DEVICE_UPDATE_TIME_PROPERTY:
		power_services_device_set_update_time (self, g_value_get_uint64 (value));
		break;
		case POWER_SERVICES_DEVICE_IS_CHARGING_PROPERTY:
		power_services_device_set_is_charging (self, g_value_get_boolean (value));
		break;
		case POWER_SERVICES_DEVICE_IS_A_BATTERY_PROPERTY:
		power_services_device_set_is_a_battery (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

