/*
 * Copyright (c) 2015 Canon Inc.
 * Copyright (c) 2015 Igalia.
 * Copyright (c) 2016 Apple Inc. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. AND ITS CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL APPLE INC. OR ITS CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 * 
 */

// DO NOT EDIT THIS FILE. It is automatically generated from JavaScript files for
// builtins by the script: Source/JavaScriptCore/Scripts/generate-js-builtins.py

#include "config.h"
#include "StreamInternalsBuiltins.h"

#include "WebCoreJSClientData.h"
#include <JavaScriptCore/IdentifierInlines.h>
#include <JavaScriptCore/ImplementationVisibility.h>
#include <JavaScriptCore/Intrinsic.h>
#include <JavaScriptCore/JSObjectInlines.h>
#include <JavaScriptCore/VM.h>

namespace WebCore {

constinit const JSC::ConstructAbility s_streamInternalsMarkPromiseAsHandledCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
constinit const JSC::ConstructorKind s_streamInternalsMarkPromiseAsHandledCodeConstructorKind = JSC::ConstructorKind::None;
constinit const JSC::ImplementationVisibility s_streamInternalsMarkPromiseAsHandledCodeImplementationVisibility = JSC::ImplementationVisibility::Public;
constinit const JSC::InlineAttribute s_streamInternalsMarkPromiseAsHandledCodeInlineAttribute = JSC::InlineAttribute::None;
constinit const int s_streamInternalsMarkPromiseAsHandledCodeLength = 217;
static constinit const JSC::Intrinsic s_streamInternalsMarkPromiseAsHandledCodeIntrinsic = JSC::NoIntrinsic;
constinit const char* const s_streamInternalsMarkPromiseAsHandledCode =
    "(function (promise)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "\n" \
    "    @assert(@isPromise(promise));\n" \
    "    @putPromiseInternalField(promise, @promiseFieldFlags, @getPromiseInternalField(promise, @promiseFieldFlags) | @promiseFlagsIsHandled);\n" \
    "})\n" \
;

constinit const JSC::ConstructAbility s_streamInternalsShieldingPromiseResolveCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
constinit const JSC::ConstructorKind s_streamInternalsShieldingPromiseResolveCodeConstructorKind = JSC::ConstructorKind::None;
constinit const JSC::ImplementationVisibility s_streamInternalsShieldingPromiseResolveCodeImplementationVisibility = JSC::ImplementationVisibility::Public;
constinit const JSC::InlineAttribute s_streamInternalsShieldingPromiseResolveCodeInlineAttribute = JSC::InlineAttribute::None;
constinit const int s_streamInternalsShieldingPromiseResolveCodeLength = 198;
static constinit const JSC::Intrinsic s_streamInternalsShieldingPromiseResolveCodeIntrinsic = JSC::NoIntrinsic;
constinit const char* const s_streamInternalsShieldingPromiseResolveCode =
    "(function (result)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "\n" \
    "    const promise = @Promise.@resolve(result);\n" \
    "    if (promise.@then === @undefined)\n" \
    "        promise.@then = @Promise.prototype.@then;\n" \
    "    return promise;\n" \
    "})\n" \
;

constinit const JSC::ConstructAbility s_streamInternalsPromiseInvokeOrNoopMethodNoCatchCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
constinit const JSC::ConstructorKind s_streamInternalsPromiseInvokeOrNoopMethodNoCatchCodeConstructorKind = JSC::ConstructorKind::None;
constinit const JSC::ImplementationVisibility s_streamInternalsPromiseInvokeOrNoopMethodNoCatchCodeImplementationVisibility = JSC::ImplementationVisibility::Public;
constinit const JSC::InlineAttribute s_streamInternalsPromiseInvokeOrNoopMethodNoCatchCodeInlineAttribute = JSC::InlineAttribute::None;
constinit const int s_streamInternalsPromiseInvokeOrNoopMethodNoCatchCodeLength = 190;
static constinit const JSC::Intrinsic s_streamInternalsPromiseInvokeOrNoopMethodNoCatchCodeIntrinsic = JSC::NoIntrinsic;
constinit const char* const s_streamInternalsPromiseInvokeOrNoopMethodNoCatchCode =
    "(function (object, method, args)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "\n" \
    "    if (method === @undefined)\n" \
    "        return @Promise.@resolve();\n" \
    "    return @shieldingPromiseResolve(method.@apply(object, args));\n" \
    "})\n" \
;

constinit const JSC::ConstructAbility s_streamInternalsPromiseInvokeOrNoopNoCatchCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
constinit const JSC::ConstructorKind s_streamInternalsPromiseInvokeOrNoopNoCatchCodeConstructorKind = JSC::ConstructorKind::None;
constinit const JSC::ImplementationVisibility s_streamInternalsPromiseInvokeOrNoopNoCatchCodeImplementationVisibility = JSC::ImplementationVisibility::Public;
constinit const JSC::InlineAttribute s_streamInternalsPromiseInvokeOrNoopNoCatchCodeInlineAttribute = JSC::InlineAttribute::None;
constinit const int s_streamInternalsPromiseInvokeOrNoopNoCatchCodeLength = 127;
static constinit const JSC::Intrinsic s_streamInternalsPromiseInvokeOrNoopNoCatchCodeIntrinsic = JSC::NoIntrinsic;
constinit const char* const s_streamInternalsPromiseInvokeOrNoopNoCatchCode =
    "(function (object, key, args)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "\n" \
    "    return @promiseInvokeOrNoopMethodNoCatch(object, object[key], args);\n" \
    "})\n" \
;

constinit const JSC::ConstructAbility s_streamInternalsPromiseInvokeOrNoopMethodCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
constinit const JSC::ConstructorKind s_streamInternalsPromiseInvokeOrNoopMethodCodeConstructorKind = JSC::ConstructorKind::None;
constinit const JSC::ImplementationVisibility s_streamInternalsPromiseInvokeOrNoopMethodCodeImplementationVisibility = JSC::ImplementationVisibility::Public;
constinit const JSC::InlineAttribute s_streamInternalsPromiseInvokeOrNoopMethodCodeInlineAttribute = JSC::InlineAttribute::None;
constinit const int s_streamInternalsPromiseInvokeOrNoopMethodCodeLength = 210;
static constinit const JSC::Intrinsic s_streamInternalsPromiseInvokeOrNoopMethodCodeIntrinsic = JSC::NoIntrinsic;
constinit const char* const s_streamInternalsPromiseInvokeOrNoopMethodCode =
    "(function (object, method, args)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "\n" \
    "    try {\n" \
    "        return @promiseInvokeOrNoopMethodNoCatch(object, method, args);\n" \
    "    }\n" \
    "    catch(error) {\n" \
    "        return @Promise.@reject(error);\n" \
    "    }\n" \
    "})\n" \
;

constinit const JSC::ConstructAbility s_streamInternalsPromiseInvokeOrNoopCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
constinit const JSC::ConstructorKind s_streamInternalsPromiseInvokeOrNoopCodeConstructorKind = JSC::ConstructorKind::None;
constinit const JSC::ImplementationVisibility s_streamInternalsPromiseInvokeOrNoopCodeImplementationVisibility = JSC::ImplementationVisibility::Public;
constinit const JSC::InlineAttribute s_streamInternalsPromiseInvokeOrNoopCodeInlineAttribute = JSC::InlineAttribute::None;
constinit const int s_streamInternalsPromiseInvokeOrNoopCodeLength = 198;
static constinit const JSC::Intrinsic s_streamInternalsPromiseInvokeOrNoopCodeIntrinsic = JSC::NoIntrinsic;
constinit const char* const s_streamInternalsPromiseInvokeOrNoopCode =
    "(function (object, key, args)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "\n" \
    "    try {\n" \
    "        return @promiseInvokeOrNoopNoCatch(object, key, args);\n" \
    "    }\n" \
    "    catch(error) {\n" \
    "        return @Promise.@reject(error);\n" \
    "    }\n" \
    "})\n" \
;

constinit const JSC::ConstructAbility s_streamInternalsPromiseInvokeOrFallbackOrNoopCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
constinit const JSC::ConstructorKind s_streamInternalsPromiseInvokeOrFallbackOrNoopCodeConstructorKind = JSC::ConstructorKind::None;
constinit const JSC::ImplementationVisibility s_streamInternalsPromiseInvokeOrFallbackOrNoopCodeImplementationVisibility = JSC::ImplementationVisibility::Public;
constinit const JSC::InlineAttribute s_streamInternalsPromiseInvokeOrFallbackOrNoopCodeInlineAttribute = JSC::InlineAttribute::None;
constinit const int s_streamInternalsPromiseInvokeOrFallbackOrNoopCodeLength = 362;
static constinit const JSC::Intrinsic s_streamInternalsPromiseInvokeOrFallbackOrNoopCodeIntrinsic = JSC::NoIntrinsic;
constinit const char* const s_streamInternalsPromiseInvokeOrFallbackOrNoopCode =
    "(function (object, key1, args1, key2, args2)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "\n" \
    "    try {\n" \
    "        const method = object[key1];\n" \
    "        if (method === @undefined)\n" \
    "            return @promiseInvokeOrNoopNoCatch(object, key2, args2);\n" \
    "        return @shieldingPromiseResolve(method.@apply(object, args1));\n" \
    "    }\n" \
    "    catch(error) {\n" \
    "        return @Promise.@reject(error);\n" \
    "    }\n" \
    "})\n" \
;

constinit const JSC::ConstructAbility s_streamInternalsValidateAndNormalizeQueuingStrategyCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
constinit const JSC::ConstructorKind s_streamInternalsValidateAndNormalizeQueuingStrategyCodeConstructorKind = JSC::ConstructorKind::None;
constinit const JSC::ImplementationVisibility s_streamInternalsValidateAndNormalizeQueuingStrategyCodeImplementationVisibility = JSC::ImplementationVisibility::Public;
constinit const JSC::InlineAttribute s_streamInternalsValidateAndNormalizeQueuingStrategyCodeInlineAttribute = JSC::InlineAttribute::None;
constinit const int s_streamInternalsValidateAndNormalizeQueuingStrategyCodeLength = 401;
static constinit const JSC::Intrinsic s_streamInternalsValidateAndNormalizeQueuingStrategyCodeIntrinsic = JSC::NoIntrinsic;
constinit const char* const s_streamInternalsValidateAndNormalizeQueuingStrategyCode =
    "(function (size, highWaterMark)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "\n" \
    "    if (size !== @undefined && typeof size !== \"function\")\n" \
    "        @throwTypeError(\"size parameter must be a function\");\n" \
    "\n" \
    "    highWaterMark = @toNumber(highWaterMark);\n" \
    "\n" \
    "    if (highWaterMark !== highWaterMark || highWaterMark < 0)\n" \
    "        @throwRangeError(\"highWaterMark value is negative or not a number\");\n" \
    "\n" \
    "    return { size, highWaterMark };\n" \
    "})\n" \
;

constinit const JSC::ConstructAbility s_streamInternalsNewQueueCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
constinit const JSC::ConstructorKind s_streamInternalsNewQueueCodeConstructorKind = JSC::ConstructorKind::None;
constinit const JSC::ImplementationVisibility s_streamInternalsNewQueueCodeImplementationVisibility = JSC::ImplementationVisibility::Public;
constinit const JSC::InlineAttribute s_streamInternalsNewQueueCodeInlineAttribute = JSC::InlineAttribute::None;
constinit const int s_streamInternalsNewQueueCodeLength = 74;
static constinit const JSC::Intrinsic s_streamInternalsNewQueueCodeIntrinsic = JSC::NoIntrinsic;
constinit const char* const s_streamInternalsNewQueueCode =
    "(function ()\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "\n" \
    "    return { content: [], size: 0 };\n" \
    "})\n" \
;

constinit const JSC::ConstructAbility s_streamInternalsDequeueValueCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
constinit const JSC::ConstructorKind s_streamInternalsDequeueValueCodeConstructorKind = JSC::ConstructorKind::None;
constinit const JSC::ImplementationVisibility s_streamInternalsDequeueValueCodeImplementationVisibility = JSC::ImplementationVisibility::Public;
constinit const JSC::InlineAttribute s_streamInternalsDequeueValueCodeInlineAttribute = JSC::InlineAttribute::None;
constinit const int s_streamInternalsDequeueValueCodeLength = 196;
static constinit const JSC::Intrinsic s_streamInternalsDequeueValueCodeIntrinsic = JSC::NoIntrinsic;
constinit const char* const s_streamInternalsDequeueValueCode =
    "(function (queue)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "\n" \
    "    const record = queue.content.@shift();\n" \
    "    queue.size -= record.size;\n" \
    "    //\n" \
    "    if (queue.size < 0)\n" \
    "        queue.size = 0;\n" \
    "    return record.value;\n" \
    "})\n" \
;

constinit const JSC::ConstructAbility s_streamInternalsEnqueueValueWithSizeCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
constinit const JSC::ConstructorKind s_streamInternalsEnqueueValueWithSizeCodeConstructorKind = JSC::ConstructorKind::None;
constinit const JSC::ImplementationVisibility s_streamInternalsEnqueueValueWithSizeCodeImplementationVisibility = JSC::ImplementationVisibility::Public;
constinit const JSC::InlineAttribute s_streamInternalsEnqueueValueWithSizeCodeInlineAttribute = JSC::InlineAttribute::None;
constinit const int s_streamInternalsEnqueueValueWithSizeCodeLength = 250;
static constinit const JSC::Intrinsic s_streamInternalsEnqueueValueWithSizeCodeIntrinsic = JSC::NoIntrinsic;
constinit const char* const s_streamInternalsEnqueueValueWithSizeCode =
    "(function (queue, value, size)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "\n" \
    "    size = @toNumber(size);\n" \
    "    if (!@isFinite(size) || size < 0)\n" \
    "        @throwRangeError(\"size has an incorrect value\");\n" \
    "    @arrayPush(queue.content, { value, size });\n" \
    "    queue.size += size;\n" \
    "})\n" \
;

constinit const JSC::ConstructAbility s_streamInternalsPeekQueueValueCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
constinit const JSC::ConstructorKind s_streamInternalsPeekQueueValueCodeConstructorKind = JSC::ConstructorKind::None;
constinit const JSC::ImplementationVisibility s_streamInternalsPeekQueueValueCodeImplementationVisibility = JSC::ImplementationVisibility::Public;
constinit const JSC::InlineAttribute s_streamInternalsPeekQueueValueCodeInlineAttribute = JSC::InlineAttribute::None;
constinit const int s_streamInternalsPeekQueueValueCodeLength = 117;
static constinit const JSC::Intrinsic s_streamInternalsPeekQueueValueCodeIntrinsic = JSC::NoIntrinsic;
constinit const char* const s_streamInternalsPeekQueueValueCode =
    "(function (queue)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "\n" \
    "    @assert(queue.content.length > 0);\n" \
    "\n" \
    "    return queue.content[0].value;\n" \
    "})\n" \
;

constinit const JSC::ConstructAbility s_streamInternalsResetQueueCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
constinit const JSC::ConstructorKind s_streamInternalsResetQueueCodeConstructorKind = JSC::ConstructorKind::None;
constinit const JSC::ImplementationVisibility s_streamInternalsResetQueueCodeImplementationVisibility = JSC::ImplementationVisibility::Public;
constinit const JSC::InlineAttribute s_streamInternalsResetQueueCodeInlineAttribute = JSC::InlineAttribute::None;
constinit const int s_streamInternalsResetQueueCodeLength = 149;
static constinit const JSC::Intrinsic s_streamInternalsResetQueueCodeIntrinsic = JSC::NoIntrinsic;
constinit const char* const s_streamInternalsResetQueueCode =
    "(function (queue)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "\n" \
    "    @assert(\"content\" in queue);\n" \
    "    @assert(\"size\" in queue);\n" \
    "    queue.content = [];\n" \
    "    queue.size = 0;\n" \
    "})\n" \
;

constinit const JSC::ConstructAbility s_streamInternalsExtractSizeAlgorithmCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
constinit const JSC::ConstructorKind s_streamInternalsExtractSizeAlgorithmCodeConstructorKind = JSC::ConstructorKind::None;
constinit const JSC::ImplementationVisibility s_streamInternalsExtractSizeAlgorithmCodeImplementationVisibility = JSC::ImplementationVisibility::Public;
constinit const JSC::InlineAttribute s_streamInternalsExtractSizeAlgorithmCodeInlineAttribute = JSC::InlineAttribute::None;
constinit const int s_streamInternalsExtractSizeAlgorithmCodeLength = 352;
static constinit const JSC::Intrinsic s_streamInternalsExtractSizeAlgorithmCodeIntrinsic = JSC::NoIntrinsic;
constinit const char* const s_streamInternalsExtractSizeAlgorithmCode =
    "(function (strategy)\n" \
    "{\n" \
    "    if (!(\"size\" in strategy))\n" \
    "        return () => 1;\n" \
    "\n" \
    "    const sizeAlgorithm = strategy[\"size\"];\n" \
    "    if (sizeAlgorithm === @undefined)\n" \
    "        return () => 1;\n" \
    "\n" \
    "    if (typeof sizeAlgorithm !== \"function\")\n" \
    "        @throwTypeError(\"strategy.size must be a function\");\n" \
    "\n" \
    "    return (chunk) => { return sizeAlgorithm(chunk); };\n" \
    "})\n" \
;

constinit const JSC::ConstructAbility s_streamInternalsExtractHighWaterMarkCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
constinit const JSC::ConstructorKind s_streamInternalsExtractHighWaterMarkCodeConstructorKind = JSC::ConstructorKind::None;
constinit const JSC::ImplementationVisibility s_streamInternalsExtractHighWaterMarkCodeImplementationVisibility = JSC::ImplementationVisibility::Public;
constinit const JSC::InlineAttribute s_streamInternalsExtractHighWaterMarkCodeInlineAttribute = JSC::InlineAttribute::None;
constinit const int s_streamInternalsExtractHighWaterMarkCodeLength = 408;
static constinit const JSC::Intrinsic s_streamInternalsExtractHighWaterMarkCodeIntrinsic = JSC::NoIntrinsic;
constinit const char* const s_streamInternalsExtractHighWaterMarkCode =
    "(function (strategy, defaultHWM)\n" \
    "{\n" \
    "    if (!(\"highWaterMark\" in strategy))\n" \
    "        return defaultHWM;\n" \
    "\n" \
    "    const highWaterMark = strategy[\"highWaterMark\"];\n" \
    "    if (highWaterMark === @undefined)\n" \
    "        return defaultHWM;\n" \
    "\n" \
    "    const result = @toNumber(highWaterMark);\n" \
    "    if (result !== result || result < 0)\n" \
    "        @throwRangeError(\"highWaterMark value is negative or not a number\");\n" \
    "\n" \
    "    return result;\n" \
    "})\n" \
;

constinit const JSC::ConstructAbility s_streamInternalsExtractHighWaterMarkFromQueuingStrategyInitCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
constinit const JSC::ConstructorKind s_streamInternalsExtractHighWaterMarkFromQueuingStrategyInitCodeConstructorKind = JSC::ConstructorKind::None;
constinit const JSC::ImplementationVisibility s_streamInternalsExtractHighWaterMarkFromQueuingStrategyInitCodeImplementationVisibility = JSC::ImplementationVisibility::Public;
constinit const JSC::InlineAttribute s_streamInternalsExtractHighWaterMarkFromQueuingStrategyInitCodeInlineAttribute = JSC::InlineAttribute::None;
constinit const int s_streamInternalsExtractHighWaterMarkFromQueuingStrategyInitCodeLength = 335;
static constinit const JSC::Intrinsic s_streamInternalsExtractHighWaterMarkFromQueuingStrategyInitCodeIntrinsic = JSC::NoIntrinsic;
constinit const char* const s_streamInternalsExtractHighWaterMarkFromQueuingStrategyInitCode =
    "(function (init)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "\n" \
    "    if (!@isObject(init))\n" \
    "        @throwTypeError(\"QueuingStrategyInit argument must be an object.\");\n" \
    "    const {highWaterMark} = init;\n" \
    "    if (highWaterMark === @undefined)\n" \
    "        @throwTypeError(\"QueuingStrategyInit.highWaterMark member is required.\");\n" \
    "\n" \
    "    return @toNumber(highWaterMark);\n" \
    "})\n" \
;

constinit const JSC::ConstructAbility s_streamInternalsCreateFulfilledPromiseCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
constinit const JSC::ConstructorKind s_streamInternalsCreateFulfilledPromiseCodeConstructorKind = JSC::ConstructorKind::None;
constinit const JSC::ImplementationVisibility s_streamInternalsCreateFulfilledPromiseCodeImplementationVisibility = JSC::ImplementationVisibility::Public;
constinit const JSC::InlineAttribute s_streamInternalsCreateFulfilledPromiseCodeInlineAttribute = JSC::InlineAttribute::None;
constinit const int s_streamInternalsCreateFulfilledPromiseCodeLength = 115;
static constinit const JSC::Intrinsic s_streamInternalsCreateFulfilledPromiseCodeIntrinsic = JSC::NoIntrinsic;
constinit const char* const s_streamInternalsCreateFulfilledPromiseCode =
    "(function (value)\n" \
    "{\n" \
    "    const promise = @newPromise();\n" \
    "    @fulfillPromise(promise, value);\n" \
    "    return promise;\n" \
    "})\n" \
;

constinit const JSC::ConstructAbility s_streamInternalsToDictionaryCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
constinit const JSC::ConstructorKind s_streamInternalsToDictionaryCodeConstructorKind = JSC::ConstructorKind::None;
constinit const JSC::ImplementationVisibility s_streamInternalsToDictionaryCodeImplementationVisibility = JSC::ImplementationVisibility::Public;
constinit const JSC::InlineAttribute s_streamInternalsToDictionaryCodeInlineAttribute = JSC::InlineAttribute::None;
constinit const int s_streamInternalsToDictionaryCodeLength = 212;
static constinit const JSC::Intrinsic s_streamInternalsToDictionaryCodeIntrinsic = JSC::NoIntrinsic;
constinit const char* const s_streamInternalsToDictionaryCode =
    "(function (value, defaultValue, errorMessage)\n" \
    "{\n" \
    "    if (value === @undefined || value === null)\n" \
    "        return defaultValue;\n" \
    "    if (!@isObject(value))\n" \
    "        @throwTypeError(errorMessage);\n" \
    "    return value;\n" \
    "})\n" \
;


#define DEFINE_BUILTIN_GENERATOR(codeName, functionName, overriddenName, argumentCount) \
JSC::FunctionExecutable* codeName##Generator(JSC::VM& vm) \
{\
    JSVMClientData* clientData = downcast<JSVMClientData>(vm.clientData); \
    return clientData->builtinFunctions().streamInternalsBuiltins().codeName##Executable()->link(vm, nullptr, clientData->builtinFunctions().streamInternalsBuiltins().codeName##Source(), std::nullopt, s_##codeName##Intrinsic); \
}
WEBCORE_FOREACH_STREAMINTERNALS_BUILTIN_CODE(DEFINE_BUILTIN_GENERATOR)
#undef DEFINE_BUILTIN_GENERATOR


} // namespace WebCore
