#include "livekit/video_frame.h"
#include "livekit/media_stream_track.h"
#include "livekit/video_track.h"
#include <cstddef>
#include <cstdint>
#include <memory>
#include <new>
#include <type_traits>
#include <utility>

#ifdef __GNUC__
#pragma GCC diagnostic ignored "-Wmissing-declarations"
#pragma GCC diagnostic ignored "-Wshadow"
#ifdef __clang__
#pragma clang diagnostic ignored "-Wdollar-in-identifier-extension"
#endif // __clang__
#endif // __GNUC__

namespace rust {
inline namespace cxxbridge1 {
// #include "rust/cxx.h"

#ifndef CXXBRIDGE1_RUST_BOX
#define CXXBRIDGE1_RUST_BOX
template <typename T>
class Box final {
public:
  using element_type = T;
  using const_pointer =
      typename std::add_pointer<typename std::add_const<T>::type>::type;
  using pointer = typename std::add_pointer<T>::type;

  Box() = delete;
  Box(Box &&) noexcept;
  ~Box() noexcept;

  explicit Box(const T &);
  explicit Box(T &&);

  Box &operator=(Box &&) & noexcept;

  const T *operator->() const noexcept;
  const T &operator*() const noexcept;
  T *operator->() noexcept;
  T &operator*() noexcept;

  template <typename... Fields>
  static Box in_place(Fields &&...);

  void swap(Box &) noexcept;

  static Box from_raw(T *) noexcept;

  T *into_raw() noexcept;

  /* Deprecated */ using value_type = element_type;

private:
  class uninit;
  class allocation;
  Box(uninit) noexcept;
  void drop() noexcept;

  friend void swap(Box &lhs, Box &rhs) noexcept { lhs.swap(rhs); }

  T *ptr;
};

template <typename T>
class Box<T>::uninit {};

template <typename T>
class Box<T>::allocation {
  static T *alloc() noexcept;
  static void dealloc(T *) noexcept;

public:
  allocation() noexcept : ptr(alloc()) {}
  ~allocation() noexcept {
    if (this->ptr) {
      dealloc(this->ptr);
    }
  }
  T *ptr;
};

template <typename T>
Box<T>::Box(Box &&other) noexcept : ptr(other.ptr) {
  other.ptr = nullptr;
}

template <typename T>
Box<T>::Box(const T &val) {
  allocation alloc;
  ::new (alloc.ptr) T(val);
  this->ptr = alloc.ptr;
  alloc.ptr = nullptr;
}

template <typename T>
Box<T>::Box(T &&val) {
  allocation alloc;
  ::new (alloc.ptr) T(std::move(val));
  this->ptr = alloc.ptr;
  alloc.ptr = nullptr;
}

template <typename T>
Box<T>::~Box() noexcept {
  if (this->ptr) {
    this->drop();
  }
}

template <typename T>
Box<T> &Box<T>::operator=(Box &&other) & noexcept {
  if (this->ptr) {
    this->drop();
  }
  this->ptr = other.ptr;
  other.ptr = nullptr;
  return *this;
}

template <typename T>
const T *Box<T>::operator->() const noexcept {
  return this->ptr;
}

template <typename T>
const T &Box<T>::operator*() const noexcept {
  return *this->ptr;
}

template <typename T>
T *Box<T>::operator->() noexcept {
  return this->ptr;
}

template <typename T>
T &Box<T>::operator*() noexcept {
  return *this->ptr;
}

template <typename T>
template <typename... Fields>
Box<T> Box<T>::in_place(Fields &&...fields) {
  allocation alloc;
  auto ptr = alloc.ptr;
  ::new (ptr) T{std::forward<Fields>(fields)...};
  alloc.ptr = nullptr;
  return from_raw(ptr);
}

template <typename T>
void Box<T>::swap(Box &rhs) noexcept {
  using std::swap;
  swap(this->ptr, rhs.ptr);
}

template <typename T>
Box<T> Box<T>::from_raw(T *raw) noexcept {
  Box box = uninit{};
  box.ptr = raw;
  return box;
}

template <typename T>
T *Box<T>::into_raw() noexcept {
  T *raw = this->ptr;
  this->ptr = nullptr;
  return raw;
}

template <typename T>
Box<T>::Box(uninit) noexcept {}
#endif // CXXBRIDGE1_RUST_BOX

#ifndef CXXBRIDGE1_RUST_OPAQUE
#define CXXBRIDGE1_RUST_OPAQUE
class Opaque {
public:
  Opaque() = delete;
  Opaque(const Opaque &) = delete;
  ~Opaque() = delete;
};
#endif // CXXBRIDGE1_RUST_OPAQUE

#ifndef CXXBRIDGE1_IS_COMPLETE
#define CXXBRIDGE1_IS_COMPLETE
namespace detail {
namespace {
template <typename T, typename = std::size_t>
struct is_complete : std::false_type {};
template <typename T>
struct is_complete<T, decltype(sizeof(T))> : std::true_type {};
} // namespace
} // namespace detail
#endif // CXXBRIDGE1_IS_COMPLETE

#ifndef CXXBRIDGE1_LAYOUT
#define CXXBRIDGE1_LAYOUT
class layout {
  template <typename T>
  friend std::size_t size_of();
  template <typename T>
  friend std::size_t align_of();
  template <typename T>
  static typename std::enable_if<std::is_base_of<Opaque, T>::value,
                                 std::size_t>::type
  do_size_of() {
    return T::layout::size();
  }
  template <typename T>
  static typename std::enable_if<!std::is_base_of<Opaque, T>::value,
                                 std::size_t>::type
  do_size_of() {
    return sizeof(T);
  }
  template <typename T>
  static
      typename std::enable_if<detail::is_complete<T>::value, std::size_t>::type
      size_of() {
    return do_size_of<T>();
  }
  template <typename T>
  static typename std::enable_if<std::is_base_of<Opaque, T>::value,
                                 std::size_t>::type
  do_align_of() {
    return T::layout::align();
  }
  template <typename T>
  static typename std::enable_if<!std::is_base_of<Opaque, T>::value,
                                 std::size_t>::type
  do_align_of() {
    return alignof(T);
  }
  template <typename T>
  static
      typename std::enable_if<detail::is_complete<T>::value, std::size_t>::type
      align_of() {
    return do_align_of<T>();
  }
};

template <typename T>
std::size_t size_of() {
  return layout::size_of<T>();
}

template <typename T>
std::size_t align_of() {
  return layout::align_of<T>();
}
#endif // CXXBRIDGE1_LAYOUT

template <typename T>
union ManuallyDrop {
  T value;
  ManuallyDrop(T &&value) : value(::std::move(value)) {}
  ~ManuallyDrop() {}
};

namespace {
template <typename T, bool = ::rust::detail::is_complete<T>::value>
struct is_destructible : ::std::false_type {};
template <typename T>
struct is_destructible<T, true> : ::std::is_destructible<T> {};
template <typename T>
struct is_destructible<T[], false> : is_destructible<T> {};
template <typename T, bool = ::rust::is_destructible<T>::value>
struct shared_ptr_if_destructible {
  explicit shared_ptr_if_destructible(typename ::std::shared_ptr<T>::element_type *) {}
};
template <typename T>
struct shared_ptr_if_destructible<T, true> : ::std::shared_ptr<T> {
  using ::std::shared_ptr<T>::shared_ptr;
};
} // namespace
} // namespace cxxbridge1
} // namespace rust

#if __cplusplus >= 201402L
#define CXX_DEFAULT_VALUE(value) = value
#else
#define CXX_DEFAULT_VALUE(value)
#endif

namespace livekit {
  enum class ContentHint : ::std::int32_t;
  struct VideoTrackSourceConstraints;
  struct VideoResolution;
  using VideoTrack = ::livekit::VideoTrack;
  using NativeVideoSink = ::livekit::NativeVideoSink;
  using VideoTrackSource = ::livekit::VideoTrackSource;
  struct VideoSinkWrapper;
}

namespace livekit {
#ifndef CXXBRIDGE1_ENUM_livekit$ContentHint
#define CXXBRIDGE1_ENUM_livekit$ContentHint
enum class ContentHint : ::std::int32_t {
  None = 0,
  Fluid = 1,
  Detailed = 2,
  Text = 3,
};
#endif // CXXBRIDGE1_ENUM_livekit$ContentHint

#ifndef CXXBRIDGE1_STRUCT_livekit$VideoTrackSourceConstraints
#define CXXBRIDGE1_STRUCT_livekit$VideoTrackSourceConstraints
struct VideoTrackSourceConstraints final {
  bool has_min_fps CXX_DEFAULT_VALUE(false);
  double min_fps CXX_DEFAULT_VALUE(0);
  bool has_max_fps CXX_DEFAULT_VALUE(false);
  double max_fps CXX_DEFAULT_VALUE(0);

  using IsRelocatable = ::std::true_type;
};
#endif // CXXBRIDGE1_STRUCT_livekit$VideoTrackSourceConstraints

#ifndef CXXBRIDGE1_STRUCT_livekit$VideoResolution
#define CXXBRIDGE1_STRUCT_livekit$VideoResolution
struct VideoResolution final {
  ::std::uint32_t width CXX_DEFAULT_VALUE(0);
  ::std::uint32_t height CXX_DEFAULT_VALUE(0);

  using IsRelocatable = ::std::true_type;
};
#endif // CXXBRIDGE1_STRUCT_livekit$VideoResolution

#ifndef CXXBRIDGE1_STRUCT_livekit$VideoSinkWrapper
#define CXXBRIDGE1_STRUCT_livekit$VideoSinkWrapper
struct VideoSinkWrapper final : public ::rust::Opaque {
  void on_frame(::std::unique_ptr<::livekit::VideoFrame> frame) const noexcept;
  void on_discarded_frame() const noexcept;
  void on_constraints_changed(::livekit::VideoTrackSourceConstraints constraints) const noexcept;
  ~VideoSinkWrapper() = delete;

private:
  friend ::rust::layout;
  struct layout {
    static ::std::size_t size() noexcept;
    static ::std::size_t align() noexcept;
  };
};
#endif // CXXBRIDGE1_STRUCT_livekit$VideoSinkWrapper

extern "C" {
void livekit$cxxbridge1$VideoTrack$add_sink(::livekit::VideoTrack const &self, ::std::shared_ptr<::livekit::NativeVideoSink> const &sink) noexcept {
  void (::livekit::VideoTrack::*add_sink$)(::std::shared_ptr<::livekit::NativeVideoSink> const &) const = &::livekit::VideoTrack::add_sink;
  (self.*add_sink$)(sink);
}

void livekit$cxxbridge1$VideoTrack$remove_sink(::livekit::VideoTrack const &self, ::std::shared_ptr<::livekit::NativeVideoSink> const &sink) noexcept {
  void (::livekit::VideoTrack::*remove_sink$)(::std::shared_ptr<::livekit::NativeVideoSink> const &) const = &::livekit::VideoTrack::remove_sink;
  (self.*remove_sink$)(sink);
}

void livekit$cxxbridge1$VideoTrack$set_should_receive(::livekit::VideoTrack const &self, bool should_receive) noexcept {
  void (::livekit::VideoTrack::*set_should_receive$)(bool) const = &::livekit::VideoTrack::set_should_receive;
  (self.*set_should_receive$)(should_receive);
}

bool livekit$cxxbridge1$VideoTrack$should_receive(::livekit::VideoTrack const &self) noexcept {
  bool (::livekit::VideoTrack::*should_receive$)() const = &::livekit::VideoTrack::should_receive;
  return (self.*should_receive$)();
}

::livekit::ContentHint livekit$cxxbridge1$VideoTrack$content_hint(::livekit::VideoTrack const &self) noexcept {
  ::livekit::ContentHint (::livekit::VideoTrack::*content_hint$)() const = &::livekit::VideoTrack::content_hint;
  return (self.*content_hint$)();
}

void livekit$cxxbridge1$VideoTrack$set_content_hint(::livekit::VideoTrack const &self, ::livekit::ContentHint hint) noexcept {
  void (::livekit::VideoTrack::*set_content_hint$)(::livekit::ContentHint) const = &::livekit::VideoTrack::set_content_hint;
  (self.*set_content_hint$)(hint);
}

void livekit$cxxbridge1$new_native_video_sink(::livekit::VideoSinkWrapper *observer, ::std::shared_ptr<::livekit::NativeVideoSink> *return$) noexcept {
  ::std::shared_ptr<::livekit::NativeVideoSink> (*new_native_video_sink$)(::rust::Box<::livekit::VideoSinkWrapper>) = ::livekit::new_native_video_sink;
  new (return$) ::std::shared_ptr<::livekit::NativeVideoSink>(new_native_video_sink$(::rust::Box<::livekit::VideoSinkWrapper>::from_raw(observer)));
}

void livekit$cxxbridge1$VideoTrackSource$video_resolution(::livekit::VideoTrackSource const &self, ::livekit::VideoResolution *return$) noexcept {
  ::livekit::VideoResolution (::livekit::VideoTrackSource::*video_resolution$)() const = &::livekit::VideoTrackSource::video_resolution;
  new (return$) ::livekit::VideoResolution((self.*video_resolution$)());
}

bool livekit$cxxbridge1$VideoTrackSource$on_captured_frame(::livekit::VideoTrackSource const &self, ::std::unique_ptr<::livekit::VideoFrame> const &frame) noexcept {
  bool (::livekit::VideoTrackSource::*on_captured_frame$)(::std::unique_ptr<::livekit::VideoFrame> const &) const = &::livekit::VideoTrackSource::on_captured_frame;
  return (self.*on_captured_frame$)(frame);
}

void livekit$cxxbridge1$new_video_track_source(::livekit::VideoResolution const &resolution, ::std::shared_ptr<::livekit::VideoTrackSource> *return$) noexcept {
  ::std::shared_ptr<::livekit::VideoTrackSource> (*new_video_track_source$)(::livekit::VideoResolution const &) = ::livekit::new_video_track_source;
  new (return$) ::std::shared_ptr<::livekit::VideoTrackSource>(new_video_track_source$(resolution));
}

void livekit$cxxbridge1$video_to_media(::std::shared_ptr<::livekit::VideoTrack> *track, ::std::shared_ptr<::livekit::MediaStreamTrack> *return$) noexcept {
  ::std::shared_ptr<::livekit::MediaStreamTrack> (*video_to_media$)(::std::shared_ptr<::livekit::VideoTrack>) = ::livekit::video_to_media;
  new (return$) ::std::shared_ptr<::livekit::MediaStreamTrack>(video_to_media$(::std::move(*track)));
}

void livekit$cxxbridge1$media_to_video(::std::shared_ptr<::livekit::MediaStreamTrack> *track, ::std::shared_ptr<::livekit::VideoTrack> *return$) noexcept {
  ::std::shared_ptr<::livekit::VideoTrack> (*media_to_video$)(::std::shared_ptr<::livekit::MediaStreamTrack>) = ::livekit::media_to_video;
  new (return$) ::std::shared_ptr<::livekit::VideoTrack>(media_to_video$(::std::move(*track)));
}

void livekit$cxxbridge1$_shared_video_track(::std::shared_ptr<::livekit::VideoTrack> *return$) noexcept {
  ::std::shared_ptr<::livekit::VideoTrack> (*_shared_video_track$)() = ::livekit::_shared_video_track;
  new (return$) ::std::shared_ptr<::livekit::VideoTrack>(_shared_video_track$());
}
::std::size_t livekit$cxxbridge1$VideoSinkWrapper$operator$sizeof() noexcept;
::std::size_t livekit$cxxbridge1$VideoSinkWrapper$operator$alignof() noexcept;

void livekit$cxxbridge1$VideoSinkWrapper$on_frame(::livekit::VideoSinkWrapper const &self, ::livekit::VideoFrame *frame) noexcept;

void livekit$cxxbridge1$VideoSinkWrapper$on_discarded_frame(::livekit::VideoSinkWrapper const &self) noexcept;

void livekit$cxxbridge1$VideoSinkWrapper$on_constraints_changed(::livekit::VideoSinkWrapper const &self, ::livekit::VideoTrackSourceConstraints *constraints) noexcept;
} // extern "C"

::std::size_t VideoSinkWrapper::layout::size() noexcept {
  return livekit$cxxbridge1$VideoSinkWrapper$operator$sizeof();
}

::std::size_t VideoSinkWrapper::layout::align() noexcept {
  return livekit$cxxbridge1$VideoSinkWrapper$operator$alignof();
}

void VideoSinkWrapper::on_frame(::std::unique_ptr<::livekit::VideoFrame> frame) const noexcept {
  livekit$cxxbridge1$VideoSinkWrapper$on_frame(*this, frame.release());
}

void VideoSinkWrapper::on_discarded_frame() const noexcept {
  livekit$cxxbridge1$VideoSinkWrapper$on_discarded_frame(*this);
}

void VideoSinkWrapper::on_constraints_changed(::livekit::VideoTrackSourceConstraints constraints) const noexcept {
  ::rust::ManuallyDrop<::livekit::VideoTrackSourceConstraints> constraints$(::std::move(constraints));
  livekit$cxxbridge1$VideoSinkWrapper$on_constraints_changed(*this, &constraints$.value);
}
} // namespace livekit

extern "C" {
static_assert(sizeof(::std::shared_ptr<::livekit::NativeVideoSink>) == 2 * sizeof(void *), "");
static_assert(alignof(::std::shared_ptr<::livekit::NativeVideoSink>) == alignof(void *), "");
void cxxbridge1$shared_ptr$livekit$NativeVideoSink$null(::std::shared_ptr<::livekit::NativeVideoSink> *ptr) noexcept {
  ::new (ptr) ::std::shared_ptr<::livekit::NativeVideoSink>();
}
bool cxxbridge1$shared_ptr$livekit$NativeVideoSink$raw(::std::shared_ptr<::livekit::NativeVideoSink> *ptr, ::std::shared_ptr<::livekit::NativeVideoSink>::element_type *raw) noexcept {
  ::new (ptr) ::rust::shared_ptr_if_destructible<::livekit::NativeVideoSink>(raw);
  return ::rust::is_destructible<::livekit::NativeVideoSink>::value;
}
void cxxbridge1$shared_ptr$livekit$NativeVideoSink$clone(::std::shared_ptr<::livekit::NativeVideoSink> const &self, ::std::shared_ptr<::livekit::NativeVideoSink> *ptr) noexcept {
  ::new (ptr) ::std::shared_ptr<::livekit::NativeVideoSink>(self);
}
::std::shared_ptr<::livekit::NativeVideoSink>::element_type const *cxxbridge1$shared_ptr$livekit$NativeVideoSink$get(::std::shared_ptr<::livekit::NativeVideoSink> const &self) noexcept {
  return self.get();
}
void cxxbridge1$shared_ptr$livekit$NativeVideoSink$drop(::std::shared_ptr<::livekit::NativeVideoSink> *self) noexcept {
  self->~shared_ptr();
}

::livekit::VideoSinkWrapper *cxxbridge1$box$livekit$VideoSinkWrapper$alloc() noexcept;
void cxxbridge1$box$livekit$VideoSinkWrapper$dealloc(::livekit::VideoSinkWrapper *) noexcept;
void cxxbridge1$box$livekit$VideoSinkWrapper$drop(::rust::Box<::livekit::VideoSinkWrapper> *ptr) noexcept;

static_assert(sizeof(::std::shared_ptr<::livekit::VideoTrackSource>) == 2 * sizeof(void *), "");
static_assert(alignof(::std::shared_ptr<::livekit::VideoTrackSource>) == alignof(void *), "");
void cxxbridge1$shared_ptr$livekit$VideoTrackSource$null(::std::shared_ptr<::livekit::VideoTrackSource> *ptr) noexcept {
  ::new (ptr) ::std::shared_ptr<::livekit::VideoTrackSource>();
}
bool cxxbridge1$shared_ptr$livekit$VideoTrackSource$raw(::std::shared_ptr<::livekit::VideoTrackSource> *ptr, ::std::shared_ptr<::livekit::VideoTrackSource>::element_type *raw) noexcept {
  ::new (ptr) ::rust::shared_ptr_if_destructible<::livekit::VideoTrackSource>(raw);
  return ::rust::is_destructible<::livekit::VideoTrackSource>::value;
}
void cxxbridge1$shared_ptr$livekit$VideoTrackSource$clone(::std::shared_ptr<::livekit::VideoTrackSource> const &self, ::std::shared_ptr<::livekit::VideoTrackSource> *ptr) noexcept {
  ::new (ptr) ::std::shared_ptr<::livekit::VideoTrackSource>(self);
}
::std::shared_ptr<::livekit::VideoTrackSource>::element_type const *cxxbridge1$shared_ptr$livekit$VideoTrackSource$get(::std::shared_ptr<::livekit::VideoTrackSource> const &self) noexcept {
  return self.get();
}
void cxxbridge1$shared_ptr$livekit$VideoTrackSource$drop(::std::shared_ptr<::livekit::VideoTrackSource> *self) noexcept {
  self->~shared_ptr();
}

static_assert(sizeof(::std::shared_ptr<::livekit::VideoTrack>) == 2 * sizeof(void *), "");
static_assert(alignof(::std::shared_ptr<::livekit::VideoTrack>) == alignof(void *), "");
void cxxbridge1$shared_ptr$livekit$VideoTrack$null(::std::shared_ptr<::livekit::VideoTrack> *ptr) noexcept {
  ::new (ptr) ::std::shared_ptr<::livekit::VideoTrack>();
}
bool cxxbridge1$shared_ptr$livekit$VideoTrack$raw(::std::shared_ptr<::livekit::VideoTrack> *ptr, ::std::shared_ptr<::livekit::VideoTrack>::element_type *raw) noexcept {
  ::new (ptr) ::rust::shared_ptr_if_destructible<::livekit::VideoTrack>(raw);
  return ::rust::is_destructible<::livekit::VideoTrack>::value;
}
void cxxbridge1$shared_ptr$livekit$VideoTrack$clone(::std::shared_ptr<::livekit::VideoTrack> const &self, ::std::shared_ptr<::livekit::VideoTrack> *ptr) noexcept {
  ::new (ptr) ::std::shared_ptr<::livekit::VideoTrack>(self);
}
::std::shared_ptr<::livekit::VideoTrack>::element_type const *cxxbridge1$shared_ptr$livekit$VideoTrack$get(::std::shared_ptr<::livekit::VideoTrack> const &self) noexcept {
  return self.get();
}
void cxxbridge1$shared_ptr$livekit$VideoTrack$drop(::std::shared_ptr<::livekit::VideoTrack> *self) noexcept {
  self->~shared_ptr();
}
} // extern "C"

namespace rust {
inline namespace cxxbridge1 {
template <>
::livekit::VideoSinkWrapper *Box<::livekit::VideoSinkWrapper>::allocation::alloc() noexcept {
  return cxxbridge1$box$livekit$VideoSinkWrapper$alloc();
}
template <>
void Box<::livekit::VideoSinkWrapper>::allocation::dealloc(::livekit::VideoSinkWrapper *ptr) noexcept {
  cxxbridge1$box$livekit$VideoSinkWrapper$dealloc(ptr);
}
template <>
void Box<::livekit::VideoSinkWrapper>::drop() noexcept {
  cxxbridge1$box$livekit$VideoSinkWrapper$drop(this);
}
} // namespace cxxbridge1
} // namespace rust
