#include "livekit/video_frame_buffer.h"
#include "livekit/video_frame.h"
#include <cstddef>
#include <cstdint>
#include <memory>
#include <new>
#include <type_traits>
#include <utility>

#ifdef __GNUC__
#pragma GCC diagnostic ignored "-Wmissing-declarations"
#ifdef __clang__
#pragma clang diagnostic ignored "-Wdollar-in-identifier-extension"
#endif // __clang__
#endif // __GNUC__

namespace rust {
inline namespace cxxbridge1 {
// #include "rust/cxx.h"

#ifndef CXXBRIDGE1_IS_COMPLETE
#define CXXBRIDGE1_IS_COMPLETE
namespace detail {
namespace {
template <typename T, typename = std::size_t>
struct is_complete : std::false_type {};
template <typename T>
struct is_complete<T, decltype(sizeof(T))> : std::true_type {};
} // namespace
} // namespace detail
#endif // CXXBRIDGE1_IS_COMPLETE

namespace {
template <bool> struct deleter_if {
  template <typename T> void operator()(T *) {}
};
template <> struct deleter_if<true> {
  template <typename T> void operator()(T *ptr) { ptr->~T(); }
};
} // namespace
} // namespace cxxbridge1
} // namespace rust

namespace livekit {
  enum class VideoRotation : ::std::int32_t;
  using VideoFrame = ::livekit::VideoFrame;
  using VideoFrameBuilder = ::livekit::VideoFrameBuilder;
}

namespace livekit {
#ifndef CXXBRIDGE1_ENUM_livekit$VideoRotation
#define CXXBRIDGE1_ENUM_livekit$VideoRotation
enum class VideoRotation : ::std::int32_t {
  VideoRotation0 = 0,
  VideoRotation90 = 90,
  VideoRotation180 = 180,
  VideoRotation270 = 270,
};
#endif // CXXBRIDGE1_ENUM_livekit$VideoRotation

extern "C" {
::std::uint32_t livekit$cxxbridge1$VideoFrame$width(::livekit::VideoFrame const &self) noexcept {
  ::std::uint32_t (::livekit::VideoFrame::*width$)() const = &::livekit::VideoFrame::width;
  return (self.*width$)();
}

::std::uint32_t livekit$cxxbridge1$VideoFrame$height(::livekit::VideoFrame const &self) noexcept {
  ::std::uint32_t (::livekit::VideoFrame::*height$)() const = &::livekit::VideoFrame::height;
  return (self.*height$)();
}

::std::uint32_t livekit$cxxbridge1$VideoFrame$size(::livekit::VideoFrame const &self) noexcept {
  ::std::uint32_t (::livekit::VideoFrame::*size$)() const = &::livekit::VideoFrame::size;
  return (self.*size$)();
}

::std::uint16_t livekit$cxxbridge1$VideoFrame$id(::livekit::VideoFrame const &self) noexcept {
  ::std::uint16_t (::livekit::VideoFrame::*id$)() const = &::livekit::VideoFrame::id;
  return (self.*id$)();
}

::std::int64_t livekit$cxxbridge1$VideoFrame$timestamp_us(::livekit::VideoFrame const &self) noexcept {
  ::std::int64_t (::livekit::VideoFrame::*timestamp_us$)() const = &::livekit::VideoFrame::timestamp_us;
  return (self.*timestamp_us$)();
}

::std::int64_t livekit$cxxbridge1$VideoFrame$ntp_time_ms(::livekit::VideoFrame const &self) noexcept {
  ::std::int64_t (::livekit::VideoFrame::*ntp_time_ms$)() const = &::livekit::VideoFrame::ntp_time_ms;
  return (self.*ntp_time_ms$)();
}

::std::uint32_t livekit$cxxbridge1$VideoFrame$timestamp(::livekit::VideoFrame const &self) noexcept {
  ::std::uint32_t (::livekit::VideoFrame::*timestamp$)() const = &::livekit::VideoFrame::timestamp;
  return (self.*timestamp$)();
}

::livekit::VideoRotation livekit$cxxbridge1$VideoFrame$rotation(::livekit::VideoFrame const &self) noexcept {
  ::livekit::VideoRotation (::livekit::VideoFrame::*rotation$)() const = &::livekit::VideoFrame::rotation;
  return (self.*rotation$)();
}

::livekit::VideoFrameBuffer *livekit$cxxbridge1$VideoFrame$video_frame_buffer(::livekit::VideoFrame const &self) noexcept {
  ::std::unique_ptr<::livekit::VideoFrameBuffer> (::livekit::VideoFrame::*video_frame_buffer$)() const = &::livekit::VideoFrame::video_frame_buffer;
  return (self.*video_frame_buffer$)().release();
}

::livekit::VideoFrameBuilder *livekit$cxxbridge1$new_video_frame_builder() noexcept {
  ::std::unique_ptr<::livekit::VideoFrameBuilder> (*new_video_frame_builder$)() = ::livekit::new_video_frame_builder;
  return new_video_frame_builder$().release();
}

void livekit$cxxbridge1$VideoFrameBuilder$set_timestamp_us(::livekit::VideoFrameBuilder &self, ::std::int64_t timestamp_us) noexcept {
  void (::livekit::VideoFrameBuilder::*set_timestamp_us$)(::std::int64_t) = &::livekit::VideoFrameBuilder::set_timestamp_us;
  (self.*set_timestamp_us$)(timestamp_us);
}

void livekit$cxxbridge1$VideoFrameBuilder$set_rotation(::livekit::VideoFrameBuilder &self, ::livekit::VideoRotation rotation) noexcept {
  void (::livekit::VideoFrameBuilder::*set_rotation$)(::livekit::VideoRotation) = &::livekit::VideoFrameBuilder::set_rotation;
  (self.*set_rotation$)(rotation);
}

void livekit$cxxbridge1$VideoFrameBuilder$set_id(::livekit::VideoFrameBuilder &self, ::std::uint16_t id) noexcept {
  void (::livekit::VideoFrameBuilder::*set_id$)(::std::uint16_t) = &::livekit::VideoFrameBuilder::set_id;
  (self.*set_id$)(id);
}

void livekit$cxxbridge1$VideoFrameBuilder$set_video_frame_buffer(::livekit::VideoFrameBuilder &self, ::livekit::VideoFrameBuffer const &buffer) noexcept {
  void (::livekit::VideoFrameBuilder::*set_video_frame_buffer$)(::livekit::VideoFrameBuffer const &) = &::livekit::VideoFrameBuilder::set_video_frame_buffer;
  (self.*set_video_frame_buffer$)(buffer);
}

::livekit::VideoFrame *livekit$cxxbridge1$VideoFrameBuilder$build(::livekit::VideoFrameBuilder &self) noexcept {
  ::std::unique_ptr<::livekit::VideoFrame> (::livekit::VideoFrameBuilder::*build$)() = &::livekit::VideoFrameBuilder::build;
  return (self.*build$)().release();
}
} // extern "C"
} // namespace livekit

extern "C" {
static_assert(::rust::detail::is_complete<::std::remove_extent<::livekit::VideoFrameBuilder>::type>::value, "definition of `::livekit::VideoFrameBuilder` is required");
static_assert(sizeof(::std::unique_ptr<::livekit::VideoFrameBuilder>) == sizeof(void *), "");
static_assert(alignof(::std::unique_ptr<::livekit::VideoFrameBuilder>) == alignof(void *), "");
void cxxbridge1$unique_ptr$livekit$VideoFrameBuilder$null(::std::unique_ptr<::livekit::VideoFrameBuilder> *ptr) noexcept {
  ::new (ptr) ::std::unique_ptr<::livekit::VideoFrameBuilder>();
}
void cxxbridge1$unique_ptr$livekit$VideoFrameBuilder$raw(::std::unique_ptr<::livekit::VideoFrameBuilder> *ptr, ::std::unique_ptr<::livekit::VideoFrameBuilder>::pointer raw) noexcept {
  ::new (ptr) ::std::unique_ptr<::livekit::VideoFrameBuilder>(raw);
}
::std::unique_ptr<::livekit::VideoFrameBuilder>::element_type const *cxxbridge1$unique_ptr$livekit$VideoFrameBuilder$get(::std::unique_ptr<::livekit::VideoFrameBuilder> const &ptr) noexcept {
  return ptr.get();
}
::std::unique_ptr<::livekit::VideoFrameBuilder>::pointer cxxbridge1$unique_ptr$livekit$VideoFrameBuilder$release(::std::unique_ptr<::livekit::VideoFrameBuilder> &ptr) noexcept {
  return ptr.release();
}
void cxxbridge1$unique_ptr$livekit$VideoFrameBuilder$drop(::std::unique_ptr<::livekit::VideoFrameBuilder> *ptr) noexcept {
  ::rust::deleter_if<::rust::detail::is_complete<::livekit::VideoFrameBuilder>::value>{}(ptr);
}

static_assert(::rust::detail::is_complete<::std::remove_extent<::livekit::VideoFrame>::type>::value, "definition of `::livekit::VideoFrame` is required");
static_assert(sizeof(::std::unique_ptr<::livekit::VideoFrame>) == sizeof(void *), "");
static_assert(alignof(::std::unique_ptr<::livekit::VideoFrame>) == alignof(void *), "");
void cxxbridge1$unique_ptr$livekit$VideoFrame$null(::std::unique_ptr<::livekit::VideoFrame> *ptr) noexcept {
  ::new (ptr) ::std::unique_ptr<::livekit::VideoFrame>();
}
void cxxbridge1$unique_ptr$livekit$VideoFrame$raw(::std::unique_ptr<::livekit::VideoFrame> *ptr, ::std::unique_ptr<::livekit::VideoFrame>::pointer raw) noexcept {
  ::new (ptr) ::std::unique_ptr<::livekit::VideoFrame>(raw);
}
::std::unique_ptr<::livekit::VideoFrame>::element_type const *cxxbridge1$unique_ptr$livekit$VideoFrame$get(::std::unique_ptr<::livekit::VideoFrame> const &ptr) noexcept {
  return ptr.get();
}
::std::unique_ptr<::livekit::VideoFrame>::pointer cxxbridge1$unique_ptr$livekit$VideoFrame$release(::std::unique_ptr<::livekit::VideoFrame> &ptr) noexcept {
  return ptr.release();
}
void cxxbridge1$unique_ptr$livekit$VideoFrame$drop(::std::unique_ptr<::livekit::VideoFrame> *ptr) noexcept {
  ::rust::deleter_if<::rust::detail::is_complete<::livekit::VideoFrame>::value>{}(ptr);
}
} // extern "C"
