/* event.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from event.vala, do not modify */

/* event.vala
 *
 * Copyright © 2011-2012 Collabora Ltd.
 *             By Seif Lotfy <seif@lotfy.com>
 *             By Siegfried-Angel Gevatter Pujals <siegfried@gevatter.com>
 * Copyright © 2011 Manish Sinha <manishsinha@ubuntu.com>
 * Copyright © 2011 Michal Hruby <michal.mhr@gmail.com>
 * Copyright © 2012 Canonical Ltd.
 *             By Siegfried-A. Gevatter <siegfried.gevatter@collabora.co.uk>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include "zeitgeist-datamodel.h"
#include <glib-object.h>
#include <stdarg.h>
#include <gio/gio.h>
#include <gio/gdesktopappinfo.h>
#include <stdio.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
enum  {
	ZEITGEIST_EVENT_0_PROPERTY,
	ZEITGEIST_EVENT_ID_PROPERTY,
	ZEITGEIST_EVENT_TIMESTAMP_PROPERTY,
	ZEITGEIST_EVENT_ORIGIN_PROPERTY,
	ZEITGEIST_EVENT_ACTOR_PROPERTY,
	ZEITGEIST_EVENT_INTERPRETATION_PROPERTY,
	ZEITGEIST_EVENT_MANIFESTATION_PROPERTY,
	ZEITGEIST_EVENT_SUBJECTS_PROPERTY,
	ZEITGEIST_EVENT_PAYLOAD_PROPERTY,
	ZEITGEIST_EVENT_NUM_PROPERTIES
};
static GParamSpec* zeitgeist_event_properties[ZEITGEIST_EVENT_NUM_PROPERTIES];
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
#define _g_byte_array_unref0(var) ((var == NULL) ? NULL : (var = (g_byte_array_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_variant_iter_free0(var) ((var == NULL) ? NULL : (var = (g_variant_iter_free (var), NULL)))
#define _g_variant_type_free0(var) ((var == NULL) ? NULL : (var = (g_variant_type_free (var), NULL)))
#define _g_variant_builder_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_builder_unref (var), NULL)))
#define _g_string_chunk_free0(var) ((var == NULL) ? NULL : (var = (g_string_chunk_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _ZeitgeistEventPrivate {
	guint32 _id;
	gint64 _timestamp;
	gchar* _origin;
	const gchar* _actor;
	const gchar* _interpretation;
	const gchar* _manifestation;
	GPtrArray* _subjects;
	GByteArray* _payload;
};

static gint ZeitgeistEvent_private_offset;
static gpointer zeitgeist_event_parent_class = NULL;
static GStringChunk* zeitgeist_event_url_store;
static GStringChunk* zeitgeist_event_url_store = NULL;

VALA_EXTERN gchar* zeitgeist_next_string_or_null (GVariantIter* iter);
VALA_EXTERN gboolean zeitgeist_check_field_match (const gchar* property,
                                      const gchar* template_property,
                                      gboolean is_symbol,
                                      gboolean can_wildcard);
VALA_EXTERN void zeitgeist_utils_assert_sig (gboolean condition,
                                 const gchar* error_message,
                                 GError** error);
static GVariant* zeitgeist_event_optimize_variant_allocation (ZeitgeistEvent* self,
                                                       GVariant* event_variant);
static GObject * zeitgeist_event_constructor (GType type,
                                       guint n_construct_properties,
                                       GObjectConstructParam * construct_properties);
static void _g_object_unref0_ (gpointer var);
static void zeitgeist_event_finalize (GObject * obj);
static GType zeitgeist_event_get_type_once (void);
static void _vala_zeitgeist_event_get_property (GObject * object,
                                         guint property_id,
                                         GValue * value,
                                         GParamSpec * pspec);
static void _vala_zeitgeist_event_set_property (GObject * object,
                                         guint property_id,
                                         const GValue * value,
                                         GParamSpec * pspec);
VALA_EXTERN GVariant* zeitgeist_events_get_null_event_variant (void);

gchar*
zeitgeist_next_string_or_null (GVariantIter* iter)
{
	gchar* text = NULL;
	GVariant* _tmp0_;
	GVariant* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	gchar* result;
	g_return_val_if_fail (iter != NULL, NULL);
	_tmp0_ = g_variant_iter_next_value (iter);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_variant_get_string (_tmp1_, NULL);
	_tmp3_ = g_strdup (_tmp2_);
	_tmp4_ = _tmp3_;
	_g_variant_unref0 (_tmp1_);
	text = _tmp4_;
	_tmp5_ = text;
	if (g_strcmp0 (_tmp5_, "") != 0) {
		result = text;
		return result;
	}
	result = NULL;
	_g_free0 (text);
	return result;
}

gboolean
zeitgeist_check_field_match (const gchar* property,
                             const gchar* template_property,
                             gboolean is_symbol,
                             gboolean can_wildcard)
{
	gboolean matches = FALSE;
	gboolean is_negated = FALSE;
	gchar* parsed = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp3_;
	gboolean _tmp16_ = FALSE;
	gboolean result;
	matches = FALSE;
	is_negated = FALSE;
	_tmp0_ = g_strdup (template_property);
	parsed = _tmp0_;
	_tmp1_ = parsed;
	if (_tmp1_ != NULL) {
		gboolean _tmp2_;
		_tmp2_ = zeitgeist_utils_parse_negation (&parsed);
		is_negated = _tmp2_;
	}
	_tmp3_ = parsed;
	if (zeitgeist_utils_is_empty_string (_tmp3_)) {
		result = TRUE;
		_g_free0 (parsed);
		return result;
	} else {
		const gchar* _tmp4_;
		_tmp4_ = parsed;
		if (g_strcmp0 (_tmp4_, property) == 0) {
			matches = TRUE;
		} else {
			gboolean _tmp5_ = FALSE;
			gboolean _tmp6_ = FALSE;
			if (is_symbol) {
				_tmp6_ = property != NULL;
			} else {
				_tmp6_ = FALSE;
			}
			if (_tmp6_) {
				GList* _tmp7_;
				GList* _tmp8_;
				const gchar* _tmp9_;
				GCompareFunc _tmp10_;
				GList* _tmp11_;
				_tmp7_ = zeitgeist_symbol_get_all_parents (property);
				_tmp8_ = _tmp7_;
				_tmp9_ = parsed;
				_tmp10_ = ((GCompareFunc) g_strcmp0);
				_tmp11_ = g_list_find_custom (_tmp8_, _tmp9_, _tmp10_);
				_tmp5_ = _tmp11_ != NULL;
				(_tmp8_ == NULL) ? NULL : (_tmp8_ = (g_list_free (_tmp8_), NULL));
			} else {
				_tmp5_ = FALSE;
			}
			if (_tmp5_) {
				matches = TRUE;
			} else {
				gboolean _tmp12_ = FALSE;
				if (can_wildcard) {
					gboolean _tmp13_;
					_tmp13_ = zeitgeist_utils_parse_wildcard (&parsed);
					_tmp12_ = _tmp13_;
				} else {
					_tmp12_ = FALSE;
				}
				if (_tmp12_) {
					gboolean _tmp14_ = FALSE;
					if (property != NULL) {
						const gchar* _tmp15_;
						_tmp15_ = parsed;
						_tmp14_ = g_str_has_prefix (property, _tmp15_);
					} else {
						_tmp14_ = FALSE;
					}
					if (_tmp14_) {
						matches = TRUE;
					}
				}
			}
		}
	}
	if (is_negated) {
		_tmp16_ = !matches;
	} else {
		_tmp16_ = matches;
	}
	result = _tmp16_;
	_g_free0 (parsed);
	return result;
}

static inline gpointer
zeitgeist_event_get_instance_private (ZeitgeistEvent* self)
{
	return G_STRUCT_MEMBER_P (self, ZeitgeistEvent_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

ZeitgeistSubject*
zeitgeist_event_get_subject (ZeitgeistEvent* self,
                             gint index)
{
	GPtrArray* _tmp0_;
	gconstpointer _tmp1_;
	ZeitgeistSubject* _tmp2_;
	ZeitgeistSubject* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_subjects;
	_tmp1_ = g_ptr_array_index (_tmp0_, (guint) index);
	_tmp2_ = _g_object_ref0 ((ZeitgeistSubject*) _tmp1_);
	result = _tmp2_;
	return result;
}

static gint
vala_g_ptr_array_get_length (GPtrArray* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = (gint) self->len;
	return result;
}

gint
zeitgeist_event_num_subjects (ZeitgeistEvent* self)
{
	GPtrArray* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_subjects;
	_tmp1_ = vala_g_ptr_array_get_length (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

void
zeitgeist_event_add_subject (ZeitgeistEvent* self,
                             ZeitgeistSubject* subject)
{
	GPtrArray* _tmp0_;
	ZeitgeistSubject* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (subject != NULL);
	_tmp0_ = self->priv->_subjects;
	_tmp1_ = _g_object_ref0 (subject);
	g_ptr_array_add (_tmp0_, _tmp1_);
}

void
zeitgeist_event_take_subject (ZeitgeistEvent* self,
                              ZeitgeistSubject* subject)
{
	GPtrArray* _tmp0_;
	ZeitgeistSubject* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (subject != NULL);
	_tmp0_ = self->priv->_subjects;
	_tmp1_ = subject;
	subject = NULL;
	g_ptr_array_add (_tmp0_, _tmp1_);
	_g_object_unref0 (subject);
}

ZeitgeistEvent*
zeitgeist_event_constructv_full (GType object_type,
                                 const gchar* interpretation,
                                 const gchar* manifestation,
                                 const gchar* actor,
                                 const gchar* origin,
                                 va_list _vala_va_list)
{
	ZeitgeistEvent * self = NULL;
	va_list subjects = {0};
	ZeitgeistSubject* subject = NULL;
	self = (ZeitgeistEvent*) g_object_new (object_type, NULL);
	zeitgeist_event_set_interpretation (self, interpretation);
	zeitgeist_event_set_manifestation (self, manifestation);
	zeitgeist_event_set_actor (self, actor);
	zeitgeist_event_set_origin (self, origin);
	va_copy (subjects, _vala_va_list);
	while (TRUE) {
		ZeitgeistSubject* _tmp0_;
		ZeitgeistSubject* _tmp1_;
		ZeitgeistSubject* _tmp2_;
		_tmp0_ = va_arg (subjects, ZeitgeistSubject*);
		subject = _tmp0_;
		_tmp1_ = subject;
		if (!(_tmp1_ != NULL)) {
			break;
		}
		_tmp2_ = subject;
		zeitgeist_event_add_subject (self, _tmp2_);
	}
	va_end (subjects);
	return self;
}

ZeitgeistEvent*
zeitgeist_event_new_full (const gchar* interpretation,
                          const gchar* manifestation,
                          const gchar* actor,
                          const gchar* origin,
                          ...)
{
	va_list _vala_va_list_obj;
	va_start (_vala_va_list_obj, origin);
	return zeitgeist_event_constructv_full (ZEITGEIST_TYPE_EVENT, interpretation, manifestation, actor, origin, _vala_va_list_obj);
}

ZeitgeistEvent*
zeitgeist_event_construct_full (GType object_type,
                                const gchar* interpretation,
                                const gchar* manifestation,
                                const gchar* actor,
                                const gchar* origin,
                                ...)
{
	va_list _vala_va_list_obj;
	va_start (_vala_va_list_obj, origin);
	return zeitgeist_event_constructv_full (object_type, interpretation, manifestation, actor, origin, _vala_va_list_obj);
}

static guint64
uint64_parse (const gchar* str,
              guint _base)
{
	guint64 result;
	g_return_val_if_fail (str != NULL, 0ULL);
	result = g_ascii_strtoull (str, NULL, _base);
	return result;
}

static gint64
int64_parse (const gchar* str,
             guint _base)
{
	gint64 result;
	g_return_val_if_fail (str != NULL, 0LL);
	result = g_ascii_strtoll (str, NULL, _base);
	return result;
}

ZeitgeistEvent*
zeitgeist_event_construct_from_variant (GType object_type,
                                        GVariant* event_variant,
                                        GError** error)
{
	ZeitgeistEvent * self = NULL;
	const gchar* _tmp0_;
	GVariantIter* iter = NULL;
	GVariantIter* _tmp1_;
	GVariantIter* _tmp2_;
	GVariantIter* event_array = NULL;
	GVariantIter* _tmp3_;
	GVariant* _tmp4_;
	GVariant* _tmp5_;
	GVariantIter* _tmp6_;
	GVariantIter* _tmp7_;
	GVariantIter* subjects_array = NULL;
	GVariantIter* _tmp8_;
	GVariant* _tmp9_;
	GVariant* _tmp10_;
	GVariantIter* _tmp11_;
	GVariantIter* _tmp12_;
	GVariant* payload_variant = NULL;
	GVariantIter* _tmp13_;
	GVariant* _tmp14_;
	gsize event_props = 0UL;
	GVariantIter* _tmp15_;
	GVariantIter* _tmp17_;
	GVariant* _tmp18_;
	GVariant* _tmp19_;
	const gchar* _tmp20_;
	gchar* str_timestamp = NULL;
	GVariantIter* _tmp21_;
	GVariant* _tmp22_;
	GVariant* _tmp23_;
	const gchar* _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	const gchar* _tmp27_;
	GVariantIter* _tmp29_;
	gchar* _tmp30_;
	gchar* _tmp31_;
	GVariantIter* _tmp32_;
	gchar* _tmp33_;
	gchar* _tmp34_;
	GVariantIter* _tmp35_;
	gchar* _tmp36_;
	gchar* _tmp37_;
	guint payload_length = 0U;
	GVariant* _tmp51_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (event_variant != NULL, NULL);
	self = (ZeitgeistEvent*) g_object_new (object_type, NULL);
	_tmp0_ = g_variant_get_type_string (event_variant);
	zeitgeist_utils_assert_sig (g_strcmp0 (_tmp0_, "(" ZEITGEIST_UTILS_SIG_EVENT ")") == 0, "Invalid D-Bus signature.", &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == ZEITGEIST_DATA_MODEL_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (self);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp1_ = g_variant_iter_new (event_variant);
	iter = _tmp1_;
	_tmp2_ = iter;
	zeitgeist_utils_assert_sig (g_variant_iter_n_children (_tmp2_) >= ((gsize) 3), "Incomplete event struct.", &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == ZEITGEIST_DATA_MODEL_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_variant_iter_free0 (iter);
			_g_object_unref0 (self);
			return NULL;
		} else {
			_g_variant_iter_free0 (iter);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp3_ = iter;
	_tmp4_ = g_variant_iter_next_value (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_variant_iter_new (_tmp5_);
	_tmp7_ = _tmp6_;
	_g_variant_unref0 (_tmp5_);
	event_array = _tmp7_;
	_tmp8_ = iter;
	_tmp9_ = g_variant_iter_next_value (_tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = g_variant_iter_new (_tmp10_);
	_tmp12_ = _tmp11_;
	_g_variant_unref0 (_tmp10_);
	subjects_array = _tmp12_;
	_tmp13_ = iter;
	_tmp14_ = g_variant_iter_next_value (_tmp13_);
	payload_variant = _tmp14_;
	_tmp15_ = event_array;
	event_props = g_variant_iter_n_children (_tmp15_);
	if (event_props == ((gsize) 0)) {
		GError* _tmp16_;
		_tmp16_ = g_error_new_literal (ZEITGEIST_DATA_MODEL_ERROR, ZEITGEIST_DATA_MODEL_ERROR_NULL_EVENT, "This is an empty event.");
		_inner_error0_ = _tmp16_;
		if (_inner_error0_->domain == ZEITGEIST_DATA_MODEL_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_variant_unref0 (payload_variant);
			_g_variant_iter_free0 (subjects_array);
			_g_variant_iter_free0 (event_array);
			_g_variant_iter_free0 (iter);
			_g_object_unref0 (self);
			return NULL;
		} else {
			_g_variant_unref0 (payload_variant);
			_g_variant_iter_free0 (subjects_array);
			_g_variant_iter_free0 (event_array);
			_g_variant_iter_free0 (iter);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	zeitgeist_utils_assert_sig (event_props >= ((gsize) 5), "Missing event information.", &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == ZEITGEIST_DATA_MODEL_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_variant_unref0 (payload_variant);
			_g_variant_iter_free0 (subjects_array);
			_g_variant_iter_free0 (event_array);
			_g_variant_iter_free0 (iter);
			_g_object_unref0 (self);
			return NULL;
		} else {
			_g_variant_unref0 (payload_variant);
			_g_variant_iter_free0 (subjects_array);
			_g_variant_iter_free0 (event_array);
			_g_variant_iter_free0 (iter);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp17_ = event_array;
	_tmp18_ = g_variant_iter_next_value (_tmp17_);
	_tmp19_ = _tmp18_;
	_tmp20_ = g_variant_get_string (_tmp19_, NULL);
	zeitgeist_event_set_id (self, (guint32) uint64_parse (_tmp20_, (guint) 0));
	_g_variant_unref0 (_tmp19_);
	_tmp21_ = event_array;
	_tmp22_ = g_variant_iter_next_value (_tmp21_);
	_tmp23_ = _tmp22_;
	_tmp24_ = g_variant_get_string (_tmp23_, NULL);
	_tmp25_ = g_strdup (_tmp24_);
	_tmp26_ = _tmp25_;
	_g_variant_unref0 (_tmp23_);
	str_timestamp = _tmp26_;
	_tmp27_ = str_timestamp;
	if (g_strcmp0 (_tmp27_, "") != 0) {
		const gchar* _tmp28_;
		_tmp28_ = str_timestamp;
		zeitgeist_event_set_timestamp (self, int64_parse (_tmp28_, (guint) 0));
	} else {
		zeitgeist_event_set_timestamp (self, zeitgeist_timestamp_from_now ());
	}
	_tmp29_ = event_array;
	_tmp30_ = zeitgeist_next_string_or_null (_tmp29_);
	_tmp31_ = _tmp30_;
	zeitgeist_event_set_interpretation (self, _tmp31_);
	_g_free0 (_tmp31_);
	_tmp32_ = event_array;
	_tmp33_ = zeitgeist_next_string_or_null (_tmp32_);
	_tmp34_ = _tmp33_;
	zeitgeist_event_set_manifestation (self, _tmp34_);
	_g_free0 (_tmp34_);
	_tmp35_ = event_array;
	_tmp36_ = zeitgeist_next_string_or_null (_tmp35_);
	_tmp37_ = _tmp36_;
	zeitgeist_event_set_actor (self, _tmp37_);
	_g_free0 (_tmp37_);
	if (event_props >= ((gsize) 6)) {
		GVariantIter* _tmp38_;
		gchar* _tmp39_;
		gchar* _tmp40_;
		_tmp38_ = event_array;
		_tmp39_ = zeitgeist_next_string_or_null (_tmp38_);
		_tmp40_ = _tmp39_;
		zeitgeist_event_set_origin (self, _tmp40_);
		_g_free0 (_tmp40_);
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp41_ = FALSE;
			_tmp41_ = TRUE;
			while (TRUE) {
				GVariantIter* _tmp43_;
				GVariant* subject_variant = NULL;
				GVariantIter* _tmp44_;
				GVariant* _tmp45_;
				ZeitgeistSubject* _tmp46_ = NULL;
				GVariant* _tmp47_;
				ZeitgeistSubject* _tmp48_;
				GPtrArray* _tmp49_;
				ZeitgeistSubject* _tmp50_;
				if (!_tmp41_) {
					gint _tmp42_;
					i = i + 1;
					_tmp42_ = i;
				}
				_tmp41_ = FALSE;
				_tmp43_ = subjects_array;
				if (!(((gsize) i) < g_variant_iter_n_children (_tmp43_))) {
					break;
				}
				_tmp44_ = subjects_array;
				_tmp45_ = g_variant_iter_next_value (_tmp44_);
				subject_variant = _tmp45_;
				_tmp47_ = subject_variant;
				_tmp48_ = zeitgeist_subject_new_from_variant (_tmp47_, &_inner_error0_);
				_tmp46_ = _tmp48_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					if (_inner_error0_->domain == ZEITGEIST_DATA_MODEL_ERROR) {
						g_propagate_error (error, _inner_error0_);
						_g_variant_unref0 (subject_variant);
						_g_free0 (str_timestamp);
						_g_variant_unref0 (payload_variant);
						_g_variant_iter_free0 (subjects_array);
						_g_variant_iter_free0 (event_array);
						_g_variant_iter_free0 (iter);
						_g_object_unref0 (self);
						return NULL;
					} else {
						_g_variant_unref0 (subject_variant);
						_g_free0 (str_timestamp);
						_g_variant_unref0 (payload_variant);
						_g_variant_iter_free0 (subjects_array);
						_g_variant_iter_free0 (event_array);
						_g_variant_iter_free0 (iter);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return NULL;
					}
				}
				_tmp49_ = self->priv->_subjects;
				_tmp50_ = _tmp46_;
				_tmp46_ = NULL;
				g_ptr_array_add (_tmp49_, _tmp50_);
				_g_object_unref0 (_tmp46_);
				_g_variant_unref0 (subject_variant);
			}
		}
	}
	_tmp51_ = payload_variant;
	payload_length = (guint) g_variant_n_children (_tmp51_);
	if (payload_length > ((guint) 0)) {
		GByteArray* _tmp52_;
		GByteArray* _tmp53_;
		guint8* data = NULL;
		GVariant* _tmp54_;
		void* _tmp55_;
		gint data_length1;
		gint _data_size_;
		GByteArray* _tmp56_;
		guint8* _tmp57_;
		gint _tmp57__length1;
		_tmp52_ = g_byte_array_sized_new (payload_length);
		_tmp53_ = _tmp52_;
		zeitgeist_event_set_payload (self, _tmp53_);
		_g_byte_array_unref0 (_tmp53_);
		_tmp54_ = payload_variant;
		_tmp55_ = g_variant_get_data (_tmp54_);
		data = (guint8*) _tmp55_;
		data_length1 = -1;
		_data_size_ = data_length1;
		data_length1 = (gint) payload_length;
		_tmp56_ = self->priv->_payload;
		_tmp57_ = data;
		_tmp57__length1 = data_length1;
		g_byte_array_append (_tmp56_, _tmp57_, (gint) _tmp57__length1);
	}
	_g_free0 (str_timestamp);
	_g_variant_unref0 (payload_variant);
	_g_variant_iter_free0 (subjects_array);
	_g_variant_iter_free0 (event_array);
	_g_variant_iter_free0 (iter);
	return self;
}

ZeitgeistEvent*
zeitgeist_event_new_from_variant (GVariant* event_variant,
                                  GError** error)
{
	return zeitgeist_event_construct_from_variant (ZEITGEIST_TYPE_EVENT, event_variant, error);
}

void
zeitgeist_event_set_actor_from_app_info (ZeitgeistEvent* self,
                                         GAppInfo* info)
{
	const gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (info != NULL);
	_tmp0_ = g_app_info_get_id (info);
	if (_tmp0_ != NULL) {
		const gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp1_ = g_app_info_get_id (info);
		_tmp2_ = g_strconcat ("application://", _tmp1_, NULL);
		_tmp3_ = _tmp2_;
		zeitgeist_event_set_actor (self, _tmp3_);
		_g_free0 (_tmp3_);
	} else {
		gchar* path = NULL;
		const gchar* _tmp7_;
		path = NULL;
		if (G_TYPE_CHECK_INSTANCE_TYPE (info, G_TYPE_DESKTOP_APP_INFO)) {
			const gchar* _tmp4_;
			const gchar* _tmp5_;
			gchar* _tmp6_;
			_tmp4_ = g_desktop_app_info_get_filename (G_TYPE_CHECK_INSTANCE_TYPE (info, G_TYPE_DESKTOP_APP_INFO) ? ((GDesktopAppInfo*) info) : NULL);
			_tmp5_ = _tmp4_;
			_tmp6_ = g_strdup (_tmp5_);
			_g_free0 (path);
			path = _tmp6_;
		}
		_tmp7_ = path;
		if (_tmp7_ != NULL) {
			const gchar* _tmp8_;
			gchar* _tmp9_;
			gchar* _tmp10_;
			gchar* _tmp11_;
			gchar* _tmp12_;
			_tmp8_ = path;
			_tmp9_ = g_path_get_basename (_tmp8_);
			_tmp10_ = _tmp9_;
			_tmp11_ = g_strconcat ("application://", _tmp10_, NULL);
			_tmp12_ = _tmp11_;
			zeitgeist_event_set_actor (self, _tmp12_);
			_g_free0 (_tmp12_);
			_g_free0 (_tmp10_);
		} else {
			const gchar* _tmp13_;
			_tmp13_ = g_app_info_get_name (info);
			if (_tmp13_ != NULL) {
				const gchar* _tmp14_;
				gchar* _tmp15_;
				gchar* _tmp16_;
				gchar* _tmp17_;
				gchar* _tmp18_;
				_tmp14_ = g_app_info_get_name (info);
				_tmp15_ = g_strconcat ("application://", _tmp14_, NULL);
				_tmp16_ = _tmp15_;
				_tmp17_ = g_strconcat (_tmp16_, ".desktop", NULL);
				_tmp18_ = _tmp17_;
				zeitgeist_event_set_actor (self, _tmp18_);
				_g_free0 (_tmp18_);
				_g_free0 (_tmp16_);
			}
		}
		_g_free0 (path);
	}
}

static gpointer
_g_byte_array_ref0 (gpointer self)
{
	return self ? g_byte_array_ref (self) : NULL;
}

GVariant*
zeitgeist_event_to_variant (ZeitgeistEvent* self)
{
	GVariantBuilder* vb = NULL;
	GVariantType* _tmp0_;
	GVariantType* _tmp1_;
	GVariantBuilder* _tmp2_;
	GVariantBuilder* _tmp3_;
	GVariantBuilder* _tmp4_;
	GVariantType* _tmp5_;
	GVariantType* _tmp6_;
	gchar* _tmp7_ = NULL;
	guint32 _tmp8_;
	GVariantBuilder* _tmp12_;
	gchar* _tmp13_ = NULL;
	gint64 _tmp14_;
	GVariantBuilder* _tmp18_;
	const gchar* _tmp19_ = NULL;
	const gchar* _tmp20_;
	const gchar* _tmp21_;
	GVariantBuilder* _tmp24_;
	const gchar* _tmp25_ = NULL;
	const gchar* _tmp26_;
	const gchar* _tmp27_;
	GVariantBuilder* _tmp30_;
	const gchar* _tmp31_ = NULL;
	const gchar* _tmp32_;
	const gchar* _tmp33_;
	GVariantBuilder* _tmp36_;
	const gchar* _tmp37_ = NULL;
	const gchar* _tmp38_;
	GVariantBuilder* _tmp40_;
	GVariantBuilder* _tmp41_;
	GVariantBuilder* _tmp42_;
	GVariantType* _tmp43_;
	GVariantType* _tmp44_;
	GVariantBuilder* _tmp55_;
	GByteArray* _tmp56_;
	GVariant* event_variant = NULL;
	GVariantBuilder* _tmp71_;
	GVariant* _tmp72_;
	GVariant* _tmp73_;
	GVariant* _tmp74_;
	GVariant* _tmp75_;
	GVariant* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_variant_type_new ("(" ZEITGEIST_UTILS_SIG_EVENT ")");
	_tmp1_ = _tmp0_;
	_tmp2_ = g_variant_builder_new (_tmp1_);
	_tmp3_ = _tmp2_;
	_g_variant_type_free0 (_tmp1_);
	vb = _tmp3_;
	_tmp4_ = vb;
	_tmp5_ = g_variant_type_new ("as");
	_tmp6_ = _tmp5_;
	g_variant_builder_open (_tmp4_, _tmp6_);
	_g_variant_type_free0 (_tmp6_);
	_tmp8_ = self->priv->_id;
	if (_tmp8_ == ((guint32) 0)) {
		gchar* _tmp9_;
		_tmp9_ = g_strdup ("");
		_g_free0 (_tmp7_);
		_tmp7_ = _tmp9_;
	} else {
		guint32 _tmp10_;
		gchar* _tmp11_;
		_tmp10_ = self->priv->_id;
		_tmp11_ = g_strdup_printf ("%u", _tmp10_);
		_g_free0 (_tmp7_);
		_tmp7_ = _tmp11_;
	}
	_tmp12_ = vb;
	g_variant_builder_add (_tmp12_, "s", _tmp7_, NULL);
	_tmp14_ = self->priv->_timestamp;
	if (_tmp14_ != ((gint64) 0)) {
		gint64 _tmp15_;
		gchar* _tmp16_;
		_tmp15_ = self->priv->_timestamp;
		_tmp16_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp15_);
		_g_free0 (_tmp13_);
		_tmp13_ = _tmp16_;
	} else {
		gchar* _tmp17_;
		_tmp17_ = g_strdup ("");
		_g_free0 (_tmp13_);
		_tmp13_ = _tmp17_;
	}
	_tmp18_ = vb;
	g_variant_builder_add (_tmp18_, "s", _tmp13_, NULL);
	_tmp20_ = zeitgeist_event_get_interpretation (self);
	_tmp21_ = _tmp20_;
	if (_tmp21_ != NULL) {
		const gchar* _tmp22_;
		const gchar* _tmp23_;
		_tmp22_ = zeitgeist_event_get_interpretation (self);
		_tmp23_ = _tmp22_;
		_tmp19_ = _tmp23_;
	} else {
		_tmp19_ = "";
	}
	_tmp24_ = vb;
	g_variant_builder_add (_tmp24_, "s", _tmp19_, NULL);
	_tmp26_ = zeitgeist_event_get_manifestation (self);
	_tmp27_ = _tmp26_;
	if (_tmp27_ != NULL) {
		const gchar* _tmp28_;
		const gchar* _tmp29_;
		_tmp28_ = zeitgeist_event_get_manifestation (self);
		_tmp29_ = _tmp28_;
		_tmp25_ = _tmp29_;
	} else {
		_tmp25_ = "";
	}
	_tmp30_ = vb;
	g_variant_builder_add (_tmp30_, "s", _tmp25_, NULL);
	_tmp32_ = zeitgeist_event_get_actor (self);
	_tmp33_ = _tmp32_;
	if (_tmp33_ != NULL) {
		const gchar* _tmp34_;
		const gchar* _tmp35_;
		_tmp34_ = zeitgeist_event_get_actor (self);
		_tmp35_ = _tmp34_;
		_tmp31_ = _tmp35_;
	} else {
		_tmp31_ = "";
	}
	_tmp36_ = vb;
	g_variant_builder_add (_tmp36_, "s", _tmp31_, NULL);
	_tmp38_ = self->priv->_origin;
	if (_tmp38_ != NULL) {
		const gchar* _tmp39_;
		_tmp39_ = self->priv->_origin;
		_tmp37_ = _tmp39_;
	} else {
		_tmp37_ = "";
	}
	_tmp40_ = vb;
	g_variant_builder_add (_tmp40_, "s", _tmp37_, NULL);
	_tmp41_ = vb;
	g_variant_builder_close (_tmp41_);
	_tmp42_ = vb;
	_tmp43_ = g_variant_type_new ("aas");
	_tmp44_ = _tmp43_;
	g_variant_builder_open (_tmp42_, _tmp44_);
	_g_variant_type_free0 (_tmp44_);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp45_ = FALSE;
			_tmp45_ = TRUE;
			while (TRUE) {
				GPtrArray* _tmp47_;
				gint _tmp48_;
				gint _tmp49_;
				GVariantBuilder* _tmp50_;
				GPtrArray* _tmp51_;
				gconstpointer _tmp52_;
				GVariant* _tmp53_;
				GVariant* _tmp54_;
				if (!_tmp45_) {
					gint _tmp46_;
					i = i + 1;
					_tmp46_ = i;
				}
				_tmp45_ = FALSE;
				_tmp47_ = self->priv->_subjects;
				_tmp48_ = vala_g_ptr_array_get_length (_tmp47_);
				_tmp49_ = _tmp48_;
				if (!(i < _tmp49_)) {
					break;
				}
				_tmp50_ = vb;
				_tmp51_ = self->priv->_subjects;
				_tmp52_ = g_ptr_array_index (_tmp51_, (guint) i);
				_tmp53_ = zeitgeist_subject_to_variant ((ZeitgeistSubject*) _tmp52_);
				_tmp54_ = _tmp53_;
				g_variant_builder_add_value (_tmp50_, _tmp54_);
				_g_variant_unref0 (_tmp54_);
			}
		}
	}
	_tmp55_ = vb;
	g_variant_builder_close (_tmp55_);
	_tmp56_ = self->priv->_payload;
	if (_tmp56_ != NULL) {
		GVariant* payload_variant = NULL;
		GVariantType* _tmp57_;
		GVariantType* _tmp58_;
		GByteArray* _tmp59_;
		guint8* _tmp60_;
		gint _tmp60__length1;
		GByteArray* _tmp61_;
		GByteArray* _tmp62_;
		GVariant* _tmp63_;
		GVariant* _tmp64_;
		GVariantBuilder* _tmp65_;
		GVariant* _tmp66_;
		_tmp57_ = g_variant_type_new ("ay");
		_tmp58_ = _tmp57_;
		_tmp59_ = self->priv->_payload;
		_tmp60_ = _tmp59_->data;
		_tmp60__length1 = _tmp59_->len;
		_tmp61_ = self->priv->_payload;
		_tmp62_ = _g_byte_array_ref0 (_tmp61_);
		_tmp63_ = g_variant_new_from_data (_tmp58_, _tmp60_, (gint) _tmp60__length1, FALSE, g_byte_array_unref, _tmp62_);
		g_variant_ref_sink (_tmp63_);
		_tmp64_ = _tmp63_;
		_g_variant_type_free0 (_tmp58_);
		payload_variant = _tmp64_;
		_tmp65_ = vb;
		_tmp66_ = payload_variant;
		g_variant_builder_add_value (_tmp65_, _tmp66_);
		_g_variant_unref0 (payload_variant);
	} else {
		GVariantBuilder* _tmp67_;
		GVariantType* _tmp68_;
		GVariantType* _tmp69_;
		GVariantBuilder* _tmp70_;
		_tmp67_ = vb;
		_tmp68_ = g_variant_type_new ("ay");
		_tmp69_ = _tmp68_;
		g_variant_builder_open (_tmp67_, _tmp69_);
		_g_variant_type_free0 (_tmp69_);
		_tmp70_ = vb;
		g_variant_builder_close (_tmp70_);
	}
	_tmp71_ = vb;
	_tmp72_ = g_variant_builder_end (_tmp71_);
	g_variant_ref_sink (_tmp72_);
	_tmp73_ = _tmp72_;
	_tmp74_ = g_variant_get_normal_form (_tmp73_);
	_tmp75_ = _tmp74_;
	_g_variant_unref0 (_tmp73_);
	event_variant = _tmp75_;
	result = event_variant;
	_g_free0 (_tmp13_);
	_g_free0 (_tmp7_);
	_g_variant_builder_unref0 (vb);
	return result;
}

static GVariant*
zeitgeist_event_optimize_variant_allocation (ZeitgeistEvent* self,
                                             GVariant* event_variant)
{
	guchar* data = NULL;
	guchar* _tmp0_;
	gint data_length1;
	gint _data_size_;
	guchar* _tmp1_;
	gint _tmp1__length1;
	guchar* data_copy = NULL;
	guchar* _tmp2_;
	gint _tmp2__length1;
	gint data_copy_length1;
	gint _data_copy_size_;
	GVariant* ret = NULL;
	GVariantType* _tmp3_;
	GVariantType* _tmp4_;
	guchar* _tmp5_;
	gint _tmp5__length1;
	GVariant* _tmp6_;
	GVariant* _tmp7_;
	GVariant* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (event_variant != NULL, NULL);
	_tmp0_ = g_new0 (guchar, g_variant_get_size (event_variant));
	data = _tmp0_;
	data_length1 = g_variant_get_size (event_variant);
	_data_size_ = data_length1;
	_tmp1_ = data;
	_tmp1__length1 = data_length1;
	g_variant_store (event_variant, _tmp1_);
	_tmp2_ = data;
	_tmp2__length1 = data_length1;
	data_copy = _tmp2_;
	data_copy_length1 = _tmp2__length1;
	_data_copy_size_ = data_copy_length1;
	_tmp3_ = g_variant_type_new ("(" ZEITGEIST_UTILS_SIG_EVENT ")");
	_tmp4_ = _tmp3_;
	_tmp5_ = data;
	_tmp5__length1 = data_length1;
	data = NULL;
	data_length1 = 0;
	_tmp6_ = g_variant_new_from_data (_tmp4_, data_copy, (gint) data_copy_length1, TRUE, g_free, _tmp5_);
	g_variant_ref_sink (_tmp6_);
	_tmp7_ = _tmp6_;
	_g_variant_type_free0 (_tmp4_);
	ret = _tmp7_;
	result = ret;
	data = (g_free (data), NULL);
	return result;
}

void
zeitgeist_event_debug_print (ZeitgeistEvent* self)
{
	FILE* _tmp0_;
	guint32 _tmp1_;
	gint64 _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	GPtrArray* _tmp10_;
	gint _tmp11_;
	gint _tmp12_;
	GByteArray* _tmp49_;
	g_return_if_fail (self != NULL);
	_tmp0_ = stdout;
	_tmp1_ = self->priv->_id;
	_tmp2_ = self->priv->_timestamp;
	_tmp3_ = zeitgeist_event_get_actor (self);
	_tmp4_ = _tmp3_;
	_tmp5_ = zeitgeist_event_get_interpretation (self);
	_tmp6_ = _tmp5_;
	_tmp7_ = zeitgeist_event_get_manifestation (self);
	_tmp8_ = _tmp7_;
	_tmp9_ = self->priv->_origin;
	_tmp10_ = self->priv->_subjects;
	_tmp11_ = vala_g_ptr_array_get_length (_tmp10_);
	_tmp12_ = _tmp11_;
	fprintf (_tmp0_, "id: %d\t" "timestamp: %" G_GINT64_FORMAT "\n" "actor: %s\n" "interpretation: %s\n" "manifestation: %s\n" "origin: %s\n" "num subjects: %d\n", _tmp1_, _tmp2_, _tmp4_, _tmp6_, _tmp8_, _tmp9_, _tmp12_);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp13_ = FALSE;
			_tmp13_ = TRUE;
			while (TRUE) {
				GPtrArray* _tmp15_;
				gint _tmp16_;
				gint _tmp17_;
				ZeitgeistSubject* s = NULL;
				GPtrArray* _tmp18_;
				gconstpointer _tmp19_;
				ZeitgeistSubject* _tmp20_;
				FILE* _tmp21_;
				ZeitgeistSubject* _tmp22_;
				const gchar* _tmp23_;
				const gchar* _tmp24_;
				ZeitgeistSubject* _tmp25_;
				const gchar* _tmp26_;
				const gchar* _tmp27_;
				ZeitgeistSubject* _tmp28_;
				const gchar* _tmp29_;
				const gchar* _tmp30_;
				ZeitgeistSubject* _tmp31_;
				const gchar* _tmp32_;
				const gchar* _tmp33_;
				ZeitgeistSubject* _tmp34_;
				const gchar* _tmp35_;
				const gchar* _tmp36_;
				ZeitgeistSubject* _tmp37_;
				const gchar* _tmp38_;
				const gchar* _tmp39_;
				ZeitgeistSubject* _tmp40_;
				const gchar* _tmp41_;
				const gchar* _tmp42_;
				ZeitgeistSubject* _tmp43_;
				const gchar* _tmp44_;
				const gchar* _tmp45_;
				ZeitgeistSubject* _tmp46_;
				const gchar* _tmp47_;
				const gchar* _tmp48_;
				if (!_tmp13_) {
					gint _tmp14_;
					_tmp14_ = i;
					i = _tmp14_ + 1;
				}
				_tmp13_ = FALSE;
				_tmp15_ = self->priv->_subjects;
				_tmp16_ = vala_g_ptr_array_get_length (_tmp15_);
				_tmp17_ = _tmp16_;
				if (!(i < _tmp17_)) {
					break;
				}
				_tmp18_ = self->priv->_subjects;
				_tmp19_ = g_ptr_array_index (_tmp18_, (guint) i);
				_tmp20_ = _g_object_ref0 ((ZeitgeistSubject*) _tmp19_);
				s = _tmp20_;
				_tmp21_ = stdout;
				_tmp22_ = s;
				_tmp23_ = zeitgeist_subject_get_uri (_tmp22_);
				_tmp24_ = _tmp23_;
				_tmp25_ = s;
				_tmp26_ = zeitgeist_subject_get_interpretation (_tmp25_);
				_tmp27_ = _tmp26_;
				_tmp28_ = s;
				_tmp29_ = zeitgeist_subject_get_manifestation (_tmp28_);
				_tmp30_ = _tmp29_;
				_tmp31_ = s;
				_tmp32_ = zeitgeist_subject_get_mimetype (_tmp31_);
				_tmp33_ = _tmp32_;
				_tmp34_ = s;
				_tmp35_ = zeitgeist_subject_get_origin (_tmp34_);
				_tmp36_ = _tmp35_;
				_tmp37_ = s;
				_tmp38_ = zeitgeist_subject_get_text (_tmp37_);
				_tmp39_ = _tmp38_;
				_tmp40_ = s;
				_tmp41_ = zeitgeist_subject_get_current_uri (_tmp40_);
				_tmp42_ = _tmp41_;
				_tmp43_ = s;
				_tmp44_ = zeitgeist_subject_get_current_origin (_tmp43_);
				_tmp45_ = _tmp44_;
				_tmp46_ = s;
				_tmp47_ = zeitgeist_subject_get_storage (_tmp46_);
				_tmp48_ = _tmp47_;
				fprintf (_tmp21_, "  Subject #%d:\n" "    uri: %s\n" "    interpretation: %s\n" "    manifestation: %s\n" "    mimetype: %s\n" "    origin: %s\n" "    text: %s\n" "    current_uri: %s\n" "    current_origin: %s\n" "    storage: %s\n", i, _tmp24_, _tmp27_, _tmp30_, _tmp33_, _tmp36_, _tmp39_, _tmp42_, _tmp45_, _tmp48_);
				_g_object_unref0 (s);
			}
		}
	}
	_tmp49_ = self->priv->_payload;
	if (_tmp49_ != NULL) {
		FILE* _tmp50_;
		GByteArray* _tmp51_;
		_tmp50_ = stdout;
		_tmp51_ = self->priv->_payload;
		fprintf (_tmp50_, "payload: %u bytes", _tmp51_->len);
	} else {
		FILE* _tmp52_;
		_tmp52_ = stdout;
		fprintf (_tmp52_, "payload: (null)\n");
	}
}

gboolean
zeitgeist_event_matches_template (ZeitgeistEvent* self,
                                  ZeitgeistEvent* template_event)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	const gchar* _tmp13_;
	GPtrArray* _tmp14_;
	gint _tmp15_;
	gint _tmp16_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (template_event != NULL, FALSE);
	_tmp0_ = zeitgeist_event_get_interpretation (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = zeitgeist_event_get_interpretation (template_event);
	_tmp3_ = _tmp2_;
	if (!zeitgeist_check_field_match (_tmp1_, _tmp3_, TRUE, FALSE)) {
		result = FALSE;
		return result;
	}
	_tmp4_ = zeitgeist_event_get_manifestation (self);
	_tmp5_ = _tmp4_;
	_tmp6_ = zeitgeist_event_get_manifestation (template_event);
	_tmp7_ = _tmp6_;
	if (!zeitgeist_check_field_match (_tmp5_, _tmp7_, TRUE, FALSE)) {
		result = FALSE;
		return result;
	}
	_tmp8_ = zeitgeist_event_get_actor (self);
	_tmp9_ = _tmp8_;
	_tmp10_ = zeitgeist_event_get_actor (template_event);
	_tmp11_ = _tmp10_;
	if (!zeitgeist_check_field_match (_tmp9_, _tmp11_, FALSE, TRUE)) {
		result = FALSE;
		return result;
	}
	_tmp12_ = self->priv->_origin;
	_tmp13_ = template_event->priv->_origin;
	if (!zeitgeist_check_field_match (_tmp12_, _tmp13_, FALSE, TRUE)) {
		result = FALSE;
		return result;
	}
	_tmp14_ = template_event->priv->_subjects;
	_tmp15_ = vala_g_ptr_array_get_length (_tmp14_);
	_tmp16_ = _tmp15_;
	if (_tmp16_ == 0) {
		result = TRUE;
		return result;
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp17_ = FALSE;
			_tmp17_ = TRUE;
			while (TRUE) {
				GPtrArray* _tmp19_;
				gint _tmp20_;
				gint _tmp21_;
				if (!_tmp17_) {
					gint _tmp18_;
					_tmp18_ = i;
					i = _tmp18_ + 1;
				}
				_tmp17_ = FALSE;
				_tmp19_ = self->priv->_subjects;
				_tmp20_ = vala_g_ptr_array_get_length (_tmp19_);
				_tmp21_ = _tmp20_;
				if (!(i < _tmp21_)) {
					break;
				}
				{
					gint j = 0;
					j = 0;
					{
						gboolean _tmp22_ = FALSE;
						_tmp22_ = TRUE;
						while (TRUE) {
							GPtrArray* _tmp24_;
							gint _tmp25_;
							gint _tmp26_;
							GPtrArray* _tmp27_;
							gconstpointer _tmp28_;
							GPtrArray* _tmp29_;
							gconstpointer _tmp30_;
							if (!_tmp22_) {
								gint _tmp23_;
								_tmp23_ = j;
								j = _tmp23_ + 1;
							}
							_tmp22_ = FALSE;
							_tmp24_ = template_event->priv->_subjects;
							_tmp25_ = vala_g_ptr_array_get_length (_tmp24_);
							_tmp26_ = _tmp25_;
							if (!(j < _tmp26_)) {
								break;
							}
							_tmp27_ = self->priv->_subjects;
							_tmp28_ = g_ptr_array_index (_tmp27_, (guint) i);
							_tmp29_ = template_event->priv->_subjects;
							_tmp30_ = g_ptr_array_index (_tmp29_, (guint) j);
							if (zeitgeist_subject_matches_template ((ZeitgeistSubject*) _tmp28_, (ZeitgeistSubject*) _tmp30_)) {
								result = TRUE;
								return result;
							}
						}
					}
				}
			}
		}
	}
	result = FALSE;
	return result;
}

ZeitgeistEvent*
zeitgeist_event_construct (GType object_type)
{
	ZeitgeistEvent * self = NULL;
	self = (ZeitgeistEvent*) g_object_new (object_type, NULL);
	return self;
}

ZeitgeistEvent*
zeitgeist_event_new (void)
{
	return zeitgeist_event_construct (ZEITGEIST_TYPE_EVENT);
}

guint32
zeitgeist_event_get_id (ZeitgeistEvent* self)
{
	guint32 result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_id;
	return result;
}

void
zeitgeist_event_set_id (ZeitgeistEvent* self,
                        guint32 value)
{
	guint32 old_value;
	g_return_if_fail (self != NULL);
	old_value = zeitgeist_event_get_id (self);
	if (old_value != value) {
		self->priv->_id = value;
		g_object_notify_by_pspec ((GObject *) self, zeitgeist_event_properties[ZEITGEIST_EVENT_ID_PROPERTY]);
	}
}

gint64
zeitgeist_event_get_timestamp (ZeitgeistEvent* self)
{
	gint64 result;
	g_return_val_if_fail (self != NULL, 0LL);
	result = self->priv->_timestamp;
	return result;
}

void
zeitgeist_event_set_timestamp (ZeitgeistEvent* self,
                               gint64 value)
{
	gint64 old_value;
	g_return_if_fail (self != NULL);
	old_value = zeitgeist_event_get_timestamp (self);
	if (old_value != value) {
		self->priv->_timestamp = value;
		g_object_notify_by_pspec ((GObject *) self, zeitgeist_event_properties[ZEITGEIST_EVENT_TIMESTAMP_PROPERTY]);
	}
}

const gchar*
zeitgeist_event_get_origin (ZeitgeistEvent* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_origin;
	result = _tmp0_;
	return result;
}

void
zeitgeist_event_set_origin (ZeitgeistEvent* self,
                            const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = zeitgeist_event_get_origin (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_origin);
		self->priv->_origin = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, zeitgeist_event_properties[ZEITGEIST_EVENT_ORIGIN_PROPERTY]);
	}
}

const gchar*
zeitgeist_event_get_actor (ZeitgeistEvent* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_actor;
	result = _tmp0_;
	return result;
}

void
zeitgeist_event_set_actor (ZeitgeistEvent* self,
                           const gchar* value)
{
	const gchar* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	if (value != NULL) {
		GStringChunk* _tmp1_;
		const gchar* _tmp2_;
		_tmp1_ = zeitgeist_event_url_store;
		_tmp2_ = g_string_chunk_insert_const (_tmp1_, value);
		_tmp0_ = _tmp2_;
	} else {
		_tmp0_ = NULL;
	}
	self->priv->_actor = _tmp0_;
	g_object_notify_by_pspec ((GObject *) self, zeitgeist_event_properties[ZEITGEIST_EVENT_ACTOR_PROPERTY]);
}

const gchar*
zeitgeist_event_get_interpretation (ZeitgeistEvent* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_interpretation;
	result = _tmp0_;
	return result;
}

void
zeitgeist_event_set_interpretation (ZeitgeistEvent* self,
                                    const gchar* value)
{
	const gchar* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	if (value != NULL) {
		GStringChunk* _tmp1_;
		const gchar* _tmp2_;
		_tmp1_ = zeitgeist_event_url_store;
		_tmp2_ = g_string_chunk_insert_const (_tmp1_, value);
		_tmp0_ = _tmp2_;
	} else {
		_tmp0_ = NULL;
	}
	self->priv->_interpretation = _tmp0_;
	g_object_notify_by_pspec ((GObject *) self, zeitgeist_event_properties[ZEITGEIST_EVENT_INTERPRETATION_PROPERTY]);
}

const gchar*
zeitgeist_event_get_manifestation (ZeitgeistEvent* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_manifestation;
	result = _tmp0_;
	return result;
}

void
zeitgeist_event_set_manifestation (ZeitgeistEvent* self,
                                   const gchar* value)
{
	const gchar* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	if (value != NULL) {
		GStringChunk* _tmp1_;
		const gchar* _tmp2_;
		_tmp1_ = zeitgeist_event_url_store;
		_tmp2_ = g_string_chunk_insert_const (_tmp1_, value);
		_tmp0_ = _tmp2_;
	} else {
		_tmp0_ = NULL;
	}
	self->priv->_manifestation = _tmp0_;
	g_object_notify_by_pspec ((GObject *) self, zeitgeist_event_properties[ZEITGEIST_EVENT_MANIFESTATION_PROPERTY]);
}

GPtrArray*
zeitgeist_event_get_subjects (ZeitgeistEvent* self)
{
	GPtrArray* result;
	GPtrArray* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_subjects;
	result = _tmp0_;
	return result;
}

static gpointer
_g_ptr_array_ref0 (gpointer self)
{
	return self ? g_ptr_array_ref (self) : NULL;
}

void
zeitgeist_event_set_subjects (ZeitgeistEvent* self,
                              GPtrArray* value)
{
	GPtrArray* old_value;
	g_return_if_fail (self != NULL);
	old_value = zeitgeist_event_get_subjects (self);
	if (old_value != value) {
		GPtrArray* _tmp0_;
		_tmp0_ = _g_ptr_array_ref0 (value);
		_g_ptr_array_unref0 (self->priv->_subjects);
		self->priv->_subjects = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, zeitgeist_event_properties[ZEITGEIST_EVENT_SUBJECTS_PROPERTY]);
	}
}

GByteArray*
zeitgeist_event_get_payload (ZeitgeistEvent* self)
{
	GByteArray* result;
	GByteArray* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_payload;
	result = _tmp0_;
	return result;
}

void
zeitgeist_event_set_payload (ZeitgeistEvent* self,
                             GByteArray* value)
{
	GByteArray* old_value;
	g_return_if_fail (self != NULL);
	old_value = zeitgeist_event_get_payload (self);
	if (old_value != value) {
		GByteArray* _tmp0_;
		_tmp0_ = _g_byte_array_ref0 (value);
		_g_byte_array_unref0 (self->priv->_payload);
		self->priv->_payload = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, zeitgeist_event_properties[ZEITGEIST_EVENT_PAYLOAD_PROPERTY]);
	}
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static GObject *
zeitgeist_event_constructor (GType type,
                             guint n_construct_properties,
                             GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	ZeitgeistEvent * self;
	GPtrArray* _tmp0_;
	GPtrArray* _tmp1_;
	parent_class = G_OBJECT_CLASS (zeitgeist_event_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, ZEITGEIST_TYPE_EVENT, ZeitgeistEvent);
	_tmp0_ = g_ptr_array_new_full ((guint) 0, _g_object_unref0_);
	_tmp1_ = _tmp0_;
	zeitgeist_event_set_subjects (self, _tmp1_);
	_g_ptr_array_unref0 (_tmp1_);
	return obj;
}

static void
zeitgeist_event_class_init (ZeitgeistEventClass * klass,
                            gpointer klass_data)
{
	GStringChunk* _tmp0_;
	zeitgeist_event_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ZeitgeistEvent_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_zeitgeist_event_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_zeitgeist_event_set_property;
	G_OBJECT_CLASS (klass)->constructor = zeitgeist_event_constructor;
	G_OBJECT_CLASS (klass)->finalize = zeitgeist_event_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), ZEITGEIST_EVENT_ID_PROPERTY, zeitgeist_event_properties[ZEITGEIST_EVENT_ID_PROPERTY] = g_param_spec_uint ("id", "id", "id", 0, G_MAXUINT, 0U, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ZEITGEIST_EVENT_TIMESTAMP_PROPERTY, zeitgeist_event_properties[ZEITGEIST_EVENT_TIMESTAMP_PROPERTY] = g_param_spec_int64 ("timestamp", "timestamp", "timestamp", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ZEITGEIST_EVENT_ORIGIN_PROPERTY, zeitgeist_event_properties[ZEITGEIST_EVENT_ORIGIN_PROPERTY] = g_param_spec_string ("origin", "origin", "origin", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ZEITGEIST_EVENT_ACTOR_PROPERTY, zeitgeist_event_properties[ZEITGEIST_EVENT_ACTOR_PROPERTY] = g_param_spec_string ("actor", "actor", "actor", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ZEITGEIST_EVENT_INTERPRETATION_PROPERTY, zeitgeist_event_properties[ZEITGEIST_EVENT_INTERPRETATION_PROPERTY] = g_param_spec_string ("interpretation", "interpretation", "interpretation", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ZEITGEIST_EVENT_MANIFESTATION_PROPERTY, zeitgeist_event_properties[ZEITGEIST_EVENT_MANIFESTATION_PROPERTY] = g_param_spec_string ("manifestation", "manifestation", "manifestation", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ZEITGEIST_EVENT_SUBJECTS_PROPERTY, zeitgeist_event_properties[ZEITGEIST_EVENT_SUBJECTS_PROPERTY] = g_param_spec_boxed ("subjects", "subjects", "subjects", G_TYPE_PTR_ARRAY, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ZEITGEIST_EVENT_PAYLOAD_PROPERTY, zeitgeist_event_properties[ZEITGEIST_EVENT_PAYLOAD_PROPERTY] = g_param_spec_boxed ("payload", "payload", "payload", G_TYPE_BYTE_ARRAY, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	_tmp0_ = g_string_chunk_new ((gsize) 4096);
	_g_string_chunk_free0 (zeitgeist_event_url_store);
	zeitgeist_event_url_store = _tmp0_;
}

static void
zeitgeist_event_instance_init (ZeitgeistEvent * self,
                               gpointer klass)
{
	self->priv = zeitgeist_event_get_instance_private (self);
}

static void
zeitgeist_event_finalize (GObject * obj)
{
	ZeitgeistEvent * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, ZEITGEIST_TYPE_EVENT, ZeitgeistEvent);
	_g_free0 (self->priv->_origin);
	_g_ptr_array_unref0 (self->priv->_subjects);
	_g_byte_array_unref0 (self->priv->_payload);
	G_OBJECT_CLASS (zeitgeist_event_parent_class)->finalize (obj);
}

/**
 * Event objects abstract Zeitgeist events
 *
 * The Event class is one of the primary elements for communicating
 * with the Zeitgeist daemon. Events serve two purposes
 * Unsurprisingly, they represent events that have happened, but they
 * can also act as templates. See also {@link Subject}.
 *
 * An event in the Zeitgeist world is characterized by two main
 * properties. "What happened", also called the interpretation, and
 * "How did it happen", also called the manifestation. Besides these
 * properties, an event also has an actor which identifies the party
 * responsible for triggering the event which in most cases will be
 * an application. Lastly there is an event timestamp and an event ID.
 * The timestamp is calculated as the number of milliseconds since the
 * Unix epoch and the event ID is a number assigned to the event by
 * the Zeitgeist engine when it's logged. These five properties are
 * collectively known as the event metadata.
 *
 * An event must also describe what it happened to. For this we have
 * event subjects. Most events have one subject, but they may also
 * have more. The metadata of the subjects are recorded at the time
 * of logging, and are encapsulated by the #Subject class. It's
 * important to understand that it's just the subject metadata at the
 * time of logging, not necessarily the subject metadata as it exists
 * right now.
 *
 * In addition to the listed properties, events may also carry a free
 * form binary payload. The usage of this is application specific and
 * is generally useless unless you have some contextual information to
 * figure out what's in it.
 *
 * A large part of the Zeitgeist query and monitoring API revolves
 * around a concept of template matching. A query is simply a list of
 * event templates that you want to look for in the log. An unset
 * property on an event template indicates that anything is allowed in
 * that field. If the property is set it indicates that the property
 * must be an exact match, unless a special operator is used.
 */
static GType
zeitgeist_event_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ZeitgeistEventClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) zeitgeist_event_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ZeitgeistEvent), 0, (GInstanceInitFunc) zeitgeist_event_instance_init, NULL };
	GType zeitgeist_event_type_id;
	zeitgeist_event_type_id = g_type_register_static (G_TYPE_OBJECT, "ZeitgeistEvent", &g_define_type_info, 0);
	ZeitgeistEvent_private_offset = g_type_add_instance_private (zeitgeist_event_type_id, sizeof (ZeitgeistEventPrivate));
	return zeitgeist_event_type_id;
}

GType
zeitgeist_event_get_type (void)
{
	static volatile gsize zeitgeist_event_type_id__once = 0;
	if (g_once_init_enter (&zeitgeist_event_type_id__once)) {
		GType zeitgeist_event_type_id;
		zeitgeist_event_type_id = zeitgeist_event_get_type_once ();
		g_once_init_leave (&zeitgeist_event_type_id__once, zeitgeist_event_type_id);
	}
	return zeitgeist_event_type_id__once;
}

static void
_vala_zeitgeist_event_get_property (GObject * object,
                                    guint property_id,
                                    GValue * value,
                                    GParamSpec * pspec)
{
	ZeitgeistEvent * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, ZEITGEIST_TYPE_EVENT, ZeitgeistEvent);
	switch (property_id) {
		case ZEITGEIST_EVENT_ID_PROPERTY:
		g_value_set_uint (value, zeitgeist_event_get_id (self));
		break;
		case ZEITGEIST_EVENT_TIMESTAMP_PROPERTY:
		g_value_set_int64 (value, zeitgeist_event_get_timestamp (self));
		break;
		case ZEITGEIST_EVENT_ORIGIN_PROPERTY:
		g_value_set_string (value, zeitgeist_event_get_origin (self));
		break;
		case ZEITGEIST_EVENT_ACTOR_PROPERTY:
		g_value_set_string (value, zeitgeist_event_get_actor (self));
		break;
		case ZEITGEIST_EVENT_INTERPRETATION_PROPERTY:
		g_value_set_string (value, zeitgeist_event_get_interpretation (self));
		break;
		case ZEITGEIST_EVENT_MANIFESTATION_PROPERTY:
		g_value_set_string (value, zeitgeist_event_get_manifestation (self));
		break;
		case ZEITGEIST_EVENT_SUBJECTS_PROPERTY:
		g_value_set_boxed (value, zeitgeist_event_get_subjects (self));
		break;
		case ZEITGEIST_EVENT_PAYLOAD_PROPERTY:
		g_value_set_boxed (value, zeitgeist_event_get_payload (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_zeitgeist_event_set_property (GObject * object,
                                    guint property_id,
                                    const GValue * value,
                                    GParamSpec * pspec)
{
	ZeitgeistEvent * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, ZEITGEIST_TYPE_EVENT, ZeitgeistEvent);
	switch (property_id) {
		case ZEITGEIST_EVENT_ID_PROPERTY:
		zeitgeist_event_set_id (self, g_value_get_uint (value));
		break;
		case ZEITGEIST_EVENT_TIMESTAMP_PROPERTY:
		zeitgeist_event_set_timestamp (self, g_value_get_int64 (value));
		break;
		case ZEITGEIST_EVENT_ORIGIN_PROPERTY:
		zeitgeist_event_set_origin (self, g_value_get_string (value));
		break;
		case ZEITGEIST_EVENT_ACTOR_PROPERTY:
		zeitgeist_event_set_actor (self, g_value_get_string (value));
		break;
		case ZEITGEIST_EVENT_INTERPRETATION_PROPERTY:
		zeitgeist_event_set_interpretation (self, g_value_get_string (value));
		break;
		case ZEITGEIST_EVENT_MANIFESTATION_PROPERTY:
		zeitgeist_event_set_manifestation (self, g_value_get_string (value));
		break;
		case ZEITGEIST_EVENT_SUBJECTS_PROPERTY:
		zeitgeist_event_set_subjects (self, g_value_get_boxed (value));
		break;
		case ZEITGEIST_EVENT_PAYLOAD_PROPERTY:
		zeitgeist_event_set_payload (self, g_value_get_boxed (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static gpointer
_g_error_copy0 (gpointer self)
{
	return self ? g_error_copy (self) : NULL;
}

GPtrArray*
zeitgeist_events_from_variant (GVariant* vevents,
                               GError** error)
{
	GPtrArray* events = NULL;
	GPtrArray* _tmp0_;
	const gchar* _tmp1_;
	GError* _inner_error0_ = NULL;
	GPtrArray* result;
	g_return_val_if_fail (vevents != NULL, NULL);
	_tmp0_ = g_ptr_array_new_full ((guint) 0, _g_object_unref0_);
	events = _tmp0_;
	_tmp1_ = g_variant_get_type_string (vevents);
	_vala_assert (g_strcmp0 (_tmp1_, "a(" ZEITGEIST_UTILS_SIG_EVENT ")") == 0, "vevents.get_type_string () == \"a(\"+Utils.SIG_EVENT+\")\"");
	{
		GVariantIter* _vevent_it = NULL;
		GVariantIter* _tmp2_;
		GVariant* vevent = NULL;
		_tmp2_ = g_variant_iter_new (vevents);
		_vevent_it = _tmp2_;
		while (TRUE) {
			GVariantIter* _tmp3_;
			GVariant* _tmp4_;
			GVariant* _tmp5_;
			ZeitgeistEvent* event = NULL;
			GPtrArray* _tmp13_;
			ZeitgeistEvent* _tmp14_;
			ZeitgeistEvent* _tmp15_;
			_tmp3_ = _vevent_it;
			_tmp4_ = g_variant_iter_next_value (_tmp3_);
			_g_variant_unref0 (vevent);
			vevent = _tmp4_;
			_tmp5_ = vevent;
			if (!(_tmp5_ != NULL)) {
				break;
			}
			event = NULL;
			{
				ZeitgeistEvent* _tmp6_ = NULL;
				GVariant* _tmp7_;
				ZeitgeistEvent* _tmp8_;
				ZeitgeistEvent* _tmp9_;
				_tmp7_ = vevent;
				_tmp8_ = zeitgeist_event_new_from_variant (_tmp7_, &_inner_error0_);
				_tmp6_ = _tmp8_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					if (_inner_error0_->domain == ZEITGEIST_DATA_MODEL_ERROR) {
						goto __catch0_zeitgeist_data_model_error;
					}
					_g_object_unref0 (event);
					_g_variant_unref0 (vevent);
					_g_variant_iter_free0 (_vevent_it);
					_g_ptr_array_unref0 (events);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return NULL;
				}
				_tmp9_ = _tmp6_;
				_tmp6_ = NULL;
				_g_object_unref0 (event);
				event = _tmp9_;
				_g_object_unref0 (_tmp6_);
			}
			goto __finally0;
			__catch0_zeitgeist_data_model_error:
			{
				GError* err = NULL;
				GError* _tmp10_;
				err = _inner_error0_;
				_inner_error0_ = NULL;
				_tmp10_ = err;
				if (!g_error_matches (_tmp10_, ZEITGEIST_DATA_MODEL_ERROR, ZEITGEIST_DATA_MODEL_ERROR_NULL_EVENT)) {
					GError* _tmp11_;
					GError* _tmp12_;
					_tmp11_ = err;
					_tmp12_ = _g_error_copy0 (_tmp11_);
					_inner_error0_ = _tmp12_;
					_g_error_free0 (err);
					goto __finally0;
				}
				_g_error_free0 (err);
			}
			__finally0:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == ZEITGEIST_DATA_MODEL_ERROR) {
					g_propagate_error (error, _inner_error0_);
					_g_object_unref0 (event);
					_g_variant_unref0 (vevent);
					_g_variant_iter_free0 (_vevent_it);
					_g_ptr_array_unref0 (events);
					return NULL;
				} else {
					_g_object_unref0 (event);
					_g_variant_unref0 (vevent);
					_g_variant_iter_free0 (_vevent_it);
					_g_ptr_array_unref0 (events);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return NULL;
				}
			}
			_tmp13_ = events;
			_tmp14_ = event;
			_tmp15_ = _g_object_ref0 (_tmp14_);
			g_ptr_array_add (_tmp13_, _tmp15_);
			_g_object_unref0 (event);
		}
		_g_variant_unref0 (vevent);
		_g_variant_iter_free0 (_vevent_it);
	}
	result = events;
	return result;
}

GVariant*
zeitgeist_events_to_variant (GPtrArray* events)
{
	GVariantBuilder* vb = NULL;
	GVariantType* _tmp0_;
	GVariantType* _tmp1_;
	GVariantBuilder* _tmp2_;
	GVariantBuilder* _tmp3_;
	GVariantBuilder* _tmp16_;
	GVariant* _tmp17_;
	GVariant* result;
	g_return_val_if_fail (events != NULL, NULL);
	_tmp0_ = g_variant_type_new ("a(" ZEITGEIST_UTILS_SIG_EVENT ")");
	_tmp1_ = _tmp0_;
	_tmp2_ = g_variant_builder_new (_tmp1_);
	_tmp3_ = _tmp2_;
	_g_variant_type_free0 (_tmp1_);
	vb = _tmp3_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp4_ = FALSE;
			_tmp4_ = TRUE;
			while (TRUE) {
				gint _tmp6_;
				gint _tmp7_;
				gconstpointer _tmp8_;
				if (!_tmp4_) {
					gint _tmp5_;
					i = i + 1;
					_tmp5_ = i;
				}
				_tmp4_ = FALSE;
				_tmp6_ = vala_g_ptr_array_get_length (events);
				_tmp7_ = _tmp6_;
				if (!(i < _tmp7_)) {
					break;
				}
				_tmp8_ = g_ptr_array_index (events, (guint) i);
				if (((ZeitgeistEvent*) _tmp8_) != NULL) {
					GVariantBuilder* _tmp9_;
					gconstpointer _tmp10_;
					GVariant* _tmp11_;
					GVariant* _tmp12_;
					_tmp9_ = vb;
					_tmp10_ = g_ptr_array_index (events, (guint) i);
					_tmp11_ = zeitgeist_event_to_variant ((ZeitgeistEvent*) _tmp10_);
					_tmp12_ = _tmp11_;
					g_variant_builder_add_value (_tmp9_, _tmp12_);
					_g_variant_unref0 (_tmp12_);
				} else {
					GVariantBuilder* _tmp13_;
					GVariant* _tmp14_;
					GVariant* _tmp15_;
					_tmp13_ = vb;
					_tmp14_ = zeitgeist_events_get_null_event_variant ();
					_tmp15_ = _tmp14_;
					g_variant_builder_add_value (_tmp13_, _tmp15_);
					_g_variant_unref0 (_tmp15_);
				}
			}
		}
	}
	_tmp16_ = vb;
	_tmp17_ = g_variant_builder_end (_tmp16_);
	g_variant_ref_sink (_tmp17_);
	result = _tmp17_;
	_g_variant_builder_unref0 (vb);
	return result;
}

GVariant*
zeitgeist_events_to_variant_with_limit (GPtrArray* events,
                                        gsize limit,
                                        GError** error)
{
	GVariantBuilder* vb = NULL;
	GVariantType* _tmp0_;
	GVariantType* _tmp1_;
	GVariantBuilder* _tmp2_;
	GVariantBuilder* _tmp3_;
	gsize variant_size = 0UL;
	GVariantBuilder* _tmp19_;
	GVariant* _tmp20_;
	GError* _inner_error0_ = NULL;
	GVariant* result;
	g_return_val_if_fail (events != NULL, NULL);
	_tmp0_ = g_variant_type_new ("a(" ZEITGEIST_UTILS_SIG_EVENT ")");
	_tmp1_ = _tmp0_;
	_tmp2_ = g_variant_builder_new (_tmp1_);
	_tmp3_ = _tmp2_;
	_g_variant_type_free0 (_tmp1_);
	vb = _tmp3_;
	variant_size = (gsize) 0;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp4_ = FALSE;
			_tmp4_ = TRUE;
			while (TRUE) {
				gint _tmp6_;
				gint _tmp7_;
				GVariant* event_variant = NULL;
				gconstpointer _tmp8_;
				GVariant* _tmp12_;
				GVariantBuilder* _tmp17_;
				GVariant* _tmp18_;
				if (!_tmp4_) {
					gint _tmp5_;
					i = i + 1;
					_tmp5_ = i;
				}
				_tmp4_ = FALSE;
				_tmp6_ = vala_g_ptr_array_get_length (events);
				_tmp7_ = _tmp6_;
				if (!(i < _tmp7_)) {
					break;
				}
				_tmp8_ = g_ptr_array_index (events, (guint) i);
				if (((ZeitgeistEvent*) _tmp8_) != NULL) {
					gconstpointer _tmp9_;
					GVariant* _tmp10_;
					_tmp9_ = g_ptr_array_index (events, (guint) i);
					_tmp10_ = zeitgeist_event_to_variant ((ZeitgeistEvent*) _tmp9_);
					_g_variant_unref0 (event_variant);
					event_variant = _tmp10_;
				} else {
					GVariant* _tmp11_;
					_tmp11_ = zeitgeist_events_get_null_event_variant ();
					_g_variant_unref0 (event_variant);
					event_variant = _tmp11_;
				}
				_tmp12_ = event_variant;
				variant_size += g_variant_get_size (_tmp12_);
				if (variant_size > limit) {
					gsize avg_event_size = 0UL;
					gchar* error_message = NULL;
					gchar* _tmp13_;
					const gchar* _tmp14_;
					const gchar* _tmp15_;
					GError* _tmp16_;
					avg_event_size = variant_size / (i + 1);
					_tmp13_ = g_strdup_printf ("Query exceeded size limit of % " G_GSIZE_FORMAT "MiB (roughly ~%d events).", (limit / 1024) / 1024, limit / avg_event_size);
					error_message = _tmp13_;
					_tmp14_ = error_message;
					g_warning ("event.vala:461: %s", _tmp14_);
					_tmp15_ = error_message;
					_tmp16_ = g_error_new_literal (ZEITGEIST_DATA_MODEL_ERROR, ZEITGEIST_DATA_MODEL_ERROR_TOO_MANY_RESULTS, _tmp15_);
					_inner_error0_ = _tmp16_;
					if (_inner_error0_->domain == ZEITGEIST_DATA_MODEL_ERROR) {
						g_propagate_error (error, _inner_error0_);
						_g_free0 (error_message);
						_g_variant_unref0 (event_variant);
						_g_variant_builder_unref0 (vb);
						return NULL;
					} else {
						_g_free0 (error_message);
						_g_variant_unref0 (event_variant);
						_g_variant_builder_unref0 (vb);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return NULL;
					}
					_g_free0 (error_message);
				}
				_tmp17_ = vb;
				_tmp18_ = event_variant;
				g_variant_builder_add_value (_tmp17_, _tmp18_);
				_g_variant_unref0 (event_variant);
			}
		}
	}
	_tmp19_ = vb;
	_tmp20_ = g_variant_builder_end (_tmp19_);
	g_variant_ref_sink (_tmp20_);
	result = _tmp20_;
	_g_variant_builder_unref0 (vb);
	return result;
}

GVariant*
zeitgeist_events_get_null_event_variant (void)
{
	GVariantBuilder* vb = NULL;
	GVariantType* _tmp0_;
	GVariantType* _tmp1_;
	GVariantBuilder* _tmp2_;
	GVariantBuilder* _tmp3_;
	GVariantType* _tmp4_;
	GVariantType* _tmp5_;
	GVariantType* _tmp6_;
	GVariantType* _tmp7_;
	GVariantType* _tmp8_;
	GVariantType* _tmp9_;
	GVariant* _tmp10_;
	GVariant* result;
	_tmp0_ = g_variant_type_new ("(" ZEITGEIST_UTILS_SIG_EVENT ")");
	_tmp1_ = _tmp0_;
	_tmp2_ = g_variant_builder_new (_tmp1_);
	_tmp3_ = _tmp2_;
	_g_variant_type_free0 (_tmp1_);
	vb = _tmp3_;
	_tmp4_ = g_variant_type_new ("as");
	_tmp5_ = _tmp4_;
	g_variant_builder_open (vb, _tmp5_);
	_g_variant_type_free0 (_tmp5_);
	g_variant_builder_close (vb);
	_tmp6_ = g_variant_type_new ("aas");
	_tmp7_ = _tmp6_;
	g_variant_builder_open (vb, _tmp7_);
	_g_variant_type_free0 (_tmp7_);
	g_variant_builder_close (vb);
	_tmp8_ = g_variant_type_new ("ay");
	_tmp9_ = _tmp8_;
	g_variant_builder_open (vb, _tmp9_);
	_g_variant_type_free0 (_tmp9_);
	g_variant_builder_close (vb);
	_tmp10_ = g_variant_builder_end (vb);
	g_variant_ref_sink (_tmp10_);
	result = _tmp10_;
	_g_variant_builder_unref0 (vb);
	return result;
}

