﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/apigatewayv2/ApiGatewayV2_EXPORTS.h>
#include <aws/apigatewayv2/model/DeploymentStatus.h>
#include <aws/core/utils/DateTime.h>
#include <aws/core/utils/memory/stl/AWSString.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace ApiGatewayV2 {
namespace Model {
class CreateDeploymentResult {
 public:
  AWS_APIGATEWAYV2_API CreateDeploymentResult() = default;
  AWS_APIGATEWAYV2_API CreateDeploymentResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_APIGATEWAYV2_API CreateDeploymentResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>Specifies whether a deployment was automatically released.</p>
   */
  inline bool GetAutoDeployed() const { return m_autoDeployed; }
  inline void SetAutoDeployed(bool value) {
    m_autoDeployedHasBeenSet = true;
    m_autoDeployed = value;
  }
  inline CreateDeploymentResult& WithAutoDeployed(bool value) {
    SetAutoDeployed(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The date and time when the Deployment resource was created.</p>
   */
  inline const Aws::Utils::DateTime& GetCreatedDate() const { return m_createdDate; }
  template <typename CreatedDateT = Aws::Utils::DateTime>
  void SetCreatedDate(CreatedDateT&& value) {
    m_createdDateHasBeenSet = true;
    m_createdDate = std::forward<CreatedDateT>(value);
  }
  template <typename CreatedDateT = Aws::Utils::DateTime>
  CreateDeploymentResult& WithCreatedDate(CreatedDateT&& value) {
    SetCreatedDate(std::forward<CreatedDateT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The identifier for the deployment.</p>
   */
  inline const Aws::String& GetDeploymentId() const { return m_deploymentId; }
  template <typename DeploymentIdT = Aws::String>
  void SetDeploymentId(DeploymentIdT&& value) {
    m_deploymentIdHasBeenSet = true;
    m_deploymentId = std::forward<DeploymentIdT>(value);
  }
  template <typename DeploymentIdT = Aws::String>
  CreateDeploymentResult& WithDeploymentId(DeploymentIdT&& value) {
    SetDeploymentId(std::forward<DeploymentIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The status of the deployment: PENDING, FAILED, or SUCCEEDED.</p>
   */
  inline DeploymentStatus GetDeploymentStatus() const { return m_deploymentStatus; }
  inline void SetDeploymentStatus(DeploymentStatus value) {
    m_deploymentStatusHasBeenSet = true;
    m_deploymentStatus = value;
  }
  inline CreateDeploymentResult& WithDeploymentStatus(DeploymentStatus value) {
    SetDeploymentStatus(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>May contain additional feedback on the status of an API deployment.</p>
   */
  inline const Aws::String& GetDeploymentStatusMessage() const { return m_deploymentStatusMessage; }
  template <typename DeploymentStatusMessageT = Aws::String>
  void SetDeploymentStatusMessage(DeploymentStatusMessageT&& value) {
    m_deploymentStatusMessageHasBeenSet = true;
    m_deploymentStatusMessage = std::forward<DeploymentStatusMessageT>(value);
  }
  template <typename DeploymentStatusMessageT = Aws::String>
  CreateDeploymentResult& WithDeploymentStatusMessage(DeploymentStatusMessageT&& value) {
    SetDeploymentStatusMessage(std::forward<DeploymentStatusMessageT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The description for the deployment.</p>
   */
  inline const Aws::String& GetDescription() const { return m_description; }
  template <typename DescriptionT = Aws::String>
  void SetDescription(DescriptionT&& value) {
    m_descriptionHasBeenSet = true;
    m_description = std::forward<DescriptionT>(value);
  }
  template <typename DescriptionT = Aws::String>
  CreateDeploymentResult& WithDescription(DescriptionT&& value) {
    SetDescription(std::forward<DescriptionT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  CreateDeploymentResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  bool m_autoDeployed{false};

  Aws::Utils::DateTime m_createdDate{};

  Aws::String m_deploymentId;

  DeploymentStatus m_deploymentStatus{DeploymentStatus::NOT_SET};

  Aws::String m_deploymentStatusMessage;

  Aws::String m_description;

  Aws::String m_requestId;
  bool m_autoDeployedHasBeenSet = false;
  bool m_createdDateHasBeenSet = false;
  bool m_deploymentIdHasBeenSet = false;
  bool m_deploymentStatusHasBeenSet = false;
  bool m_deploymentStatusMessageHasBeenSet = false;
  bool m_descriptionHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace ApiGatewayV2
}  // namespace Aws
