﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/backup/Backup_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace Backup {
namespace Model {
class CreateFrameworkResult {
 public:
  AWS_BACKUP_API CreateFrameworkResult() = default;
  AWS_BACKUP_API CreateFrameworkResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_BACKUP_API CreateFrameworkResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The unique name of the framework. The name must be between 1 and 256
   * characters, starting with a letter, and consisting of letters (a-z, A-Z),
   * numbers (0-9), and underscores (_).</p>
   */
  inline const Aws::String& GetFrameworkName() const { return m_frameworkName; }
  template <typename FrameworkNameT = Aws::String>
  void SetFrameworkName(FrameworkNameT&& value) {
    m_frameworkNameHasBeenSet = true;
    m_frameworkName = std::forward<FrameworkNameT>(value);
  }
  template <typename FrameworkNameT = Aws::String>
  CreateFrameworkResult& WithFrameworkName(FrameworkNameT&& value) {
    SetFrameworkName(std::forward<FrameworkNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>An Amazon Resource Name (ARN) that uniquely identifies a resource. The format
   * of the ARN depends on the resource type.</p>
   */
  inline const Aws::String& GetFrameworkArn() const { return m_frameworkArn; }
  template <typename FrameworkArnT = Aws::String>
  void SetFrameworkArn(FrameworkArnT&& value) {
    m_frameworkArnHasBeenSet = true;
    m_frameworkArn = std::forward<FrameworkArnT>(value);
  }
  template <typename FrameworkArnT = Aws::String>
  CreateFrameworkResult& WithFrameworkArn(FrameworkArnT&& value) {
    SetFrameworkArn(std::forward<FrameworkArnT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  CreateFrameworkResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_frameworkName;

  Aws::String m_frameworkArn;

  Aws::String m_requestId;
  bool m_frameworkNameHasBeenSet = false;
  bool m_frameworkArnHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace Backup
}  // namespace Aws
