﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/bcm-pricing-calculator/BCMPricingCalculator_EXPORTS.h>
#include <aws/bcm-pricing-calculator/model/BillScenarioCommitmentModificationAction.h>
#include <aws/core/utils/memory/stl/AWSString.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace BCMPricingCalculator {
namespace Model {

/**
 * <p> Represents an entry object in the batch operation to create bill scenario
 * commitment modifications. </p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/BatchCreateBillScenarioCommitmentModificationEntry">AWS
 * API Reference</a></p>
 */
class BatchCreateBillScenarioCommitmentModificationEntry {
 public:
  AWS_BCMPRICINGCALCULATOR_API BatchCreateBillScenarioCommitmentModificationEntry() = default;
  AWS_BCMPRICINGCALCULATOR_API BatchCreateBillScenarioCommitmentModificationEntry(Aws::Utils::Json::JsonView jsonValue);
  AWS_BCMPRICINGCALCULATOR_API BatchCreateBillScenarioCommitmentModificationEntry& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_BCMPRICINGCALCULATOR_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p> A unique identifier for this entry in the batch operation. This can be any
   * valid string. This key is useful to identify errors associated with any
   * commitment entry as any error is returned with this key. </p>
   */
  inline const Aws::String& GetKey() const { return m_key; }
  inline bool KeyHasBeenSet() const { return m_keyHasBeenSet; }
  template <typename KeyT = Aws::String>
  void SetKey(KeyT&& value) {
    m_keyHasBeenSet = true;
    m_key = std::forward<KeyT>(value);
  }
  template <typename KeyT = Aws::String>
  BatchCreateBillScenarioCommitmentModificationEntry& WithKey(KeyT&& value) {
    SetKey(std::forward<KeyT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p> An optional group identifier for the commitment modification. </p>
   */
  inline const Aws::String& GetGroup() const { return m_group; }
  inline bool GroupHasBeenSet() const { return m_groupHasBeenSet; }
  template <typename GroupT = Aws::String>
  void SetGroup(GroupT&& value) {
    m_groupHasBeenSet = true;
    m_group = std::forward<GroupT>(value);
  }
  template <typename GroupT = Aws::String>
  BatchCreateBillScenarioCommitmentModificationEntry& WithGroup(GroupT&& value) {
    SetGroup(std::forward<GroupT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p> The Amazon Web Services account ID to which this commitment will be applied
   * to. </p>
   */
  inline const Aws::String& GetUsageAccountId() const { return m_usageAccountId; }
  inline bool UsageAccountIdHasBeenSet() const { return m_usageAccountIdHasBeenSet; }
  template <typename UsageAccountIdT = Aws::String>
  void SetUsageAccountId(UsageAccountIdT&& value) {
    m_usageAccountIdHasBeenSet = true;
    m_usageAccountId = std::forward<UsageAccountIdT>(value);
  }
  template <typename UsageAccountIdT = Aws::String>
  BatchCreateBillScenarioCommitmentModificationEntry& WithUsageAccountId(UsageAccountIdT&& value) {
    SetUsageAccountId(std::forward<UsageAccountIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p> The specific commitment action to be taken (e.g., adding a Reserved Instance
   * or Savings Plan). </p>
   */
  inline const BillScenarioCommitmentModificationAction& GetCommitmentAction() const { return m_commitmentAction; }
  inline bool CommitmentActionHasBeenSet() const { return m_commitmentActionHasBeenSet; }
  template <typename CommitmentActionT = BillScenarioCommitmentModificationAction>
  void SetCommitmentAction(CommitmentActionT&& value) {
    m_commitmentActionHasBeenSet = true;
    m_commitmentAction = std::forward<CommitmentActionT>(value);
  }
  template <typename CommitmentActionT = BillScenarioCommitmentModificationAction>
  BatchCreateBillScenarioCommitmentModificationEntry& WithCommitmentAction(CommitmentActionT&& value) {
    SetCommitmentAction(std::forward<CommitmentActionT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_key;

  Aws::String m_group;

  Aws::String m_usageAccountId;

  BillScenarioCommitmentModificationAction m_commitmentAction;
  bool m_keyHasBeenSet = false;
  bool m_groupHasBeenSet = false;
  bool m_usageAccountIdHasBeenSet = false;
  bool m_commitmentActionHasBeenSet = false;
};

}  // namespace Model
}  // namespace BCMPricingCalculator
}  // namespace Aws
