﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/cloudfront/CloudFront_EXPORTS.h>
#include <aws/cloudfront/model/EncryptionEntities.h>
#include <aws/core/utils/memory/stl/AWSString.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Xml {
class XmlNode;
}  // namespace Xml
}  // namespace Utils
namespace CloudFront {
namespace Model {

/**
 * <p>A complex data type of profiles for the field-level encryption.</p><p><h3>See
 * Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/FieldLevelEncryptionProfileConfig">AWS
 * API Reference</a></p>
 */
class FieldLevelEncryptionProfileConfig {
 public:
  AWS_CLOUDFRONT_API FieldLevelEncryptionProfileConfig() = default;
  AWS_CLOUDFRONT_API FieldLevelEncryptionProfileConfig(const Aws::Utils::Xml::XmlNode& xmlNode);
  AWS_CLOUDFRONT_API FieldLevelEncryptionProfileConfig& operator=(const Aws::Utils::Xml::XmlNode& xmlNode);

  AWS_CLOUDFRONT_API void AddToNode(Aws::Utils::Xml::XmlNode& parentNode) const;

  ///@{
  /**
   * <p>Profile name for the field-level encryption profile.</p>
   */
  inline const Aws::String& GetName() const { return m_name; }
  inline bool NameHasBeenSet() const { return m_nameHasBeenSet; }
  template <typename NameT = Aws::String>
  void SetName(NameT&& value) {
    m_nameHasBeenSet = true;
    m_name = std::forward<NameT>(value);
  }
  template <typename NameT = Aws::String>
  FieldLevelEncryptionProfileConfig& WithName(NameT&& value) {
    SetName(std::forward<NameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>A unique number that ensures that the request can't be replayed.</p>
   */
  inline const Aws::String& GetCallerReference() const { return m_callerReference; }
  inline bool CallerReferenceHasBeenSet() const { return m_callerReferenceHasBeenSet; }
  template <typename CallerReferenceT = Aws::String>
  void SetCallerReference(CallerReferenceT&& value) {
    m_callerReferenceHasBeenSet = true;
    m_callerReference = std::forward<CallerReferenceT>(value);
  }
  template <typename CallerReferenceT = Aws::String>
  FieldLevelEncryptionProfileConfig& WithCallerReference(CallerReferenceT&& value) {
    SetCallerReference(std::forward<CallerReferenceT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>An optional comment for the field-level encryption profile. The comment
   * cannot be longer than 128 characters.</p>
   */
  inline const Aws::String& GetComment() const { return m_comment; }
  inline bool CommentHasBeenSet() const { return m_commentHasBeenSet; }
  template <typename CommentT = Aws::String>
  void SetComment(CommentT&& value) {
    m_commentHasBeenSet = true;
    m_comment = std::forward<CommentT>(value);
  }
  template <typename CommentT = Aws::String>
  FieldLevelEncryptionProfileConfig& WithComment(CommentT&& value) {
    SetComment(std::forward<CommentT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>A complex data type of encryption entities for the field-level encryption
   * profile that include the public key ID, provider, and field patterns for
   * specifying which fields to encrypt with this key.</p>
   */
  inline const EncryptionEntities& GetEncryptionEntities() const { return m_encryptionEntities; }
  inline bool EncryptionEntitiesHasBeenSet() const { return m_encryptionEntitiesHasBeenSet; }
  template <typename EncryptionEntitiesT = EncryptionEntities>
  void SetEncryptionEntities(EncryptionEntitiesT&& value) {
    m_encryptionEntitiesHasBeenSet = true;
    m_encryptionEntities = std::forward<EncryptionEntitiesT>(value);
  }
  template <typename EncryptionEntitiesT = EncryptionEntities>
  FieldLevelEncryptionProfileConfig& WithEncryptionEntities(EncryptionEntitiesT&& value) {
    SetEncryptionEntities(std::forward<EncryptionEntitiesT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_name;

  Aws::String m_callerReference;

  Aws::String m_comment;

  EncryptionEntities m_encryptionEntities;
  bool m_nameHasBeenSet = false;
  bool m_callerReferenceHasBeenSet = false;
  bool m_commentHasBeenSet = false;
  bool m_encryptionEntitiesHasBeenSet = false;
};

}  // namespace Model
}  // namespace CloudFront
}  // namespace Aws
