﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/dataexchange/DataExchange_EXPORTS.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace DataExchange {
namespace Model {

/**
 * <p>Details of the operation to be performed by the job.</p><p><h3>See Also:</h3>
 * <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/dataexchange-2017-07-25/ImportAssetFromSignedUrlRequestDetails">AWS
 * API Reference</a></p>
 */
class ImportAssetFromSignedUrlRequestDetails {
 public:
  AWS_DATAEXCHANGE_API ImportAssetFromSignedUrlRequestDetails() = default;
  AWS_DATAEXCHANGE_API ImportAssetFromSignedUrlRequestDetails(Aws::Utils::Json::JsonView jsonValue);
  AWS_DATAEXCHANGE_API ImportAssetFromSignedUrlRequestDetails& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_DATAEXCHANGE_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The name of the asset. When importing from Amazon S3, the Amazon S3 object
   * key is used as the asset name.</p>
   */
  inline const Aws::String& GetAssetName() const { return m_assetName; }
  inline bool AssetNameHasBeenSet() const { return m_assetNameHasBeenSet; }
  template <typename AssetNameT = Aws::String>
  void SetAssetName(AssetNameT&& value) {
    m_assetNameHasBeenSet = true;
    m_assetName = std::forward<AssetNameT>(value);
  }
  template <typename AssetNameT = Aws::String>
  ImportAssetFromSignedUrlRequestDetails& WithAssetName(AssetNameT&& value) {
    SetAssetName(std::forward<AssetNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The unique identifier for the data set associated with this import job.</p>
   */
  inline const Aws::String& GetDataSetId() const { return m_dataSetId; }
  inline bool DataSetIdHasBeenSet() const { return m_dataSetIdHasBeenSet; }
  template <typename DataSetIdT = Aws::String>
  void SetDataSetId(DataSetIdT&& value) {
    m_dataSetIdHasBeenSet = true;
    m_dataSetId = std::forward<DataSetIdT>(value);
  }
  template <typename DataSetIdT = Aws::String>
  ImportAssetFromSignedUrlRequestDetails& WithDataSetId(DataSetIdT&& value) {
    SetDataSetId(std::forward<DataSetIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The Base64-encoded Md5 hash for the asset, used to ensure the integrity of
   * the file at that location.</p>
   */
  inline const Aws::String& GetMd5Hash() const { return m_md5Hash; }
  inline bool Md5HashHasBeenSet() const { return m_md5HashHasBeenSet; }
  template <typename Md5HashT = Aws::String>
  void SetMd5Hash(Md5HashT&& value) {
    m_md5HashHasBeenSet = true;
    m_md5Hash = std::forward<Md5HashT>(value);
  }
  template <typename Md5HashT = Aws::String>
  ImportAssetFromSignedUrlRequestDetails& WithMd5Hash(Md5HashT&& value) {
    SetMd5Hash(std::forward<Md5HashT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The unique identifier for the revision associated with this import
   * request.</p>
   */
  inline const Aws::String& GetRevisionId() const { return m_revisionId; }
  inline bool RevisionIdHasBeenSet() const { return m_revisionIdHasBeenSet; }
  template <typename RevisionIdT = Aws::String>
  void SetRevisionId(RevisionIdT&& value) {
    m_revisionIdHasBeenSet = true;
    m_revisionId = std::forward<RevisionIdT>(value);
  }
  template <typename RevisionIdT = Aws::String>
  ImportAssetFromSignedUrlRequestDetails& WithRevisionId(RevisionIdT&& value) {
    SetRevisionId(std::forward<RevisionIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_assetName;

  Aws::String m_dataSetId;

  Aws::String m_md5Hash;

  Aws::String m_revisionId;
  bool m_assetNameHasBeenSet = false;
  bool m_dataSetIdHasBeenSet = false;
  bool m_md5HashHasBeenSet = false;
  bool m_revisionIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace DataExchange
}  // namespace Aws
