﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/deadline/Deadline_EXPORTS.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace deadline {
namespace Model {

/**
 * <p>Provides information about the number of resources used.</p><p><h3>See
 * Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/AcquiredLimit">AWS
 * API Reference</a></p>
 */
class AcquiredLimit {
 public:
  AWS_DEADLINE_API AcquiredLimit() = default;
  AWS_DEADLINE_API AcquiredLimit(Aws::Utils::Json::JsonView jsonValue);
  AWS_DEADLINE_API AcquiredLimit& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_DEADLINE_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The unique identifier of the limit.</p>
   */
  inline const Aws::String& GetLimitId() const { return m_limitId; }
  inline bool LimitIdHasBeenSet() const { return m_limitIdHasBeenSet; }
  template <typename LimitIdT = Aws::String>
  void SetLimitId(LimitIdT&& value) {
    m_limitIdHasBeenSet = true;
    m_limitId = std::forward<LimitIdT>(value);
  }
  template <typename LimitIdT = Aws::String>
  AcquiredLimit& WithLimitId(LimitIdT&& value) {
    SetLimitId(std::forward<LimitIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The number of limit resources used.</p>
   */
  inline int GetCount() const { return m_count; }
  inline bool CountHasBeenSet() const { return m_countHasBeenSet; }
  inline void SetCount(int value) {
    m_countHasBeenSet = true;
    m_count = value;
  }
  inline AcquiredLimit& WithCount(int value) {
    SetCount(value);
    return *this;
  }
  ///@}
 private:
  Aws::String m_limitId;

  int m_count{0};
  bool m_limitIdHasBeenSet = false;
  bool m_countHasBeenSet = false;
};

}  // namespace Model
}  // namespace deadline
}  // namespace Aws
