﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/deadline/Deadline_EXPORTS.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace deadline {
namespace Model {
class CreateBudgetResult {
 public:
  AWS_DEADLINE_API CreateBudgetResult() = default;
  AWS_DEADLINE_API CreateBudgetResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_DEADLINE_API CreateBudgetResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The budget ID.</p>
   */
  inline const Aws::String& GetBudgetId() const { return m_budgetId; }
  template <typename BudgetIdT = Aws::String>
  void SetBudgetId(BudgetIdT&& value) {
    m_budgetIdHasBeenSet = true;
    m_budgetId = std::forward<BudgetIdT>(value);
  }
  template <typename BudgetIdT = Aws::String>
  CreateBudgetResult& WithBudgetId(BudgetIdT&& value) {
    SetBudgetId(std::forward<BudgetIdT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  CreateBudgetResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_budgetId;

  Aws::String m_requestId;
  bool m_budgetIdHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace deadline
}  // namespace Aws
