﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/dms/DatabaseMigrationService_EXPORTS.h>
#include <aws/dms/model/ReplicationTask.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace DatabaseMigrationService {
namespace Model {
/**
 * <p/><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/StopReplicationTaskResponse">AWS
 * API Reference</a></p>
 */
class StopReplicationTaskResult {
 public:
  AWS_DATABASEMIGRATIONSERVICE_API StopReplicationTaskResult() = default;
  AWS_DATABASEMIGRATIONSERVICE_API StopReplicationTaskResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_DATABASEMIGRATIONSERVICE_API StopReplicationTaskResult& operator=(
      const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The replication task stopped.</p>
   */
  inline const ReplicationTask& GetReplicationTask() const { return m_replicationTask; }
  template <typename ReplicationTaskT = ReplicationTask>
  void SetReplicationTask(ReplicationTaskT&& value) {
    m_replicationTaskHasBeenSet = true;
    m_replicationTask = std::forward<ReplicationTaskT>(value);
  }
  template <typename ReplicationTaskT = ReplicationTask>
  StopReplicationTaskResult& WithReplicationTask(ReplicationTaskT&& value) {
    SetReplicationTask(std::forward<ReplicationTaskT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  StopReplicationTaskResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  ReplicationTask m_replicationTask;

  Aws::String m_requestId;
  bool m_replicationTaskHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace DatabaseMigrationService
}  // namespace Aws
