﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSMap.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/drs/Drs_EXPORTS.h>
#include <aws/drs/model/LaunchDisposition.h>
#include <aws/drs/model/Licensing.h>
#include <aws/drs/model/TargetInstanceTypeRightSizingMethod.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace drs {
namespace Model {

/**
 * <p>Account level Launch Configuration Template.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/drs-2020-02-26/LaunchConfigurationTemplate">AWS
 * API Reference</a></p>
 */
class LaunchConfigurationTemplate {
 public:
  AWS_DRS_API LaunchConfigurationTemplate() = default;
  AWS_DRS_API LaunchConfigurationTemplate(Aws::Utils::Json::JsonView jsonValue);
  AWS_DRS_API LaunchConfigurationTemplate& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_DRS_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>ARN of the Launch Configuration Template.</p>
   */
  inline const Aws::String& GetArn() const { return m_arn; }
  inline bool ArnHasBeenSet() const { return m_arnHasBeenSet; }
  template <typename ArnT = Aws::String>
  void SetArn(ArnT&& value) {
    m_arnHasBeenSet = true;
    m_arn = std::forward<ArnT>(value);
  }
  template <typename ArnT = Aws::String>
  LaunchConfigurationTemplate& WithArn(ArnT&& value) {
    SetArn(std::forward<ArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Copy private IP.</p>
   */
  inline bool GetCopyPrivateIp() const { return m_copyPrivateIp; }
  inline bool CopyPrivateIpHasBeenSet() const { return m_copyPrivateIpHasBeenSet; }
  inline void SetCopyPrivateIp(bool value) {
    m_copyPrivateIpHasBeenSet = true;
    m_copyPrivateIp = value;
  }
  inline LaunchConfigurationTemplate& WithCopyPrivateIp(bool value) {
    SetCopyPrivateIp(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Copy tags.</p>
   */
  inline bool GetCopyTags() const { return m_copyTags; }
  inline bool CopyTagsHasBeenSet() const { return m_copyTagsHasBeenSet; }
  inline void SetCopyTags(bool value) {
    m_copyTagsHasBeenSet = true;
    m_copyTags = value;
  }
  inline LaunchConfigurationTemplate& WithCopyTags(bool value) {
    SetCopyTags(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>S3 bucket ARN to export Source Network templates.</p>
   */
  inline const Aws::String& GetExportBucketArn() const { return m_exportBucketArn; }
  inline bool ExportBucketArnHasBeenSet() const { return m_exportBucketArnHasBeenSet; }
  template <typename ExportBucketArnT = Aws::String>
  void SetExportBucketArn(ExportBucketArnT&& value) {
    m_exportBucketArnHasBeenSet = true;
    m_exportBucketArn = std::forward<ExportBucketArnT>(value);
  }
  template <typename ExportBucketArnT = Aws::String>
  LaunchConfigurationTemplate& WithExportBucketArn(ExportBucketArnT&& value) {
    SetExportBucketArn(std::forward<ExportBucketArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>ID of the Launch Configuration Template.</p>
   */
  inline const Aws::String& GetLaunchConfigurationTemplateID() const { return m_launchConfigurationTemplateID; }
  inline bool LaunchConfigurationTemplateIDHasBeenSet() const { return m_launchConfigurationTemplateIDHasBeenSet; }
  template <typename LaunchConfigurationTemplateIDT = Aws::String>
  void SetLaunchConfigurationTemplateID(LaunchConfigurationTemplateIDT&& value) {
    m_launchConfigurationTemplateIDHasBeenSet = true;
    m_launchConfigurationTemplateID = std::forward<LaunchConfigurationTemplateIDT>(value);
  }
  template <typename LaunchConfigurationTemplateIDT = Aws::String>
  LaunchConfigurationTemplate& WithLaunchConfigurationTemplateID(LaunchConfigurationTemplateIDT&& value) {
    SetLaunchConfigurationTemplateID(std::forward<LaunchConfigurationTemplateIDT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Launch disposition.</p>
   */
  inline LaunchDisposition GetLaunchDisposition() const { return m_launchDisposition; }
  inline bool LaunchDispositionHasBeenSet() const { return m_launchDispositionHasBeenSet; }
  inline void SetLaunchDisposition(LaunchDisposition value) {
    m_launchDispositionHasBeenSet = true;
    m_launchDisposition = value;
  }
  inline LaunchConfigurationTemplate& WithLaunchDisposition(LaunchDisposition value) {
    SetLaunchDisposition(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>DRS will set the 'launch into instance ID' of any source server when
   * performing a drill, recovery or failback to the previous region or availability
   * zone, using the instance ID of the source instance.</p>
   */
  inline bool GetLaunchIntoSourceInstance() const { return m_launchIntoSourceInstance; }
  inline bool LaunchIntoSourceInstanceHasBeenSet() const { return m_launchIntoSourceInstanceHasBeenSet; }
  inline void SetLaunchIntoSourceInstance(bool value) {
    m_launchIntoSourceInstanceHasBeenSet = true;
    m_launchIntoSourceInstance = value;
  }
  inline LaunchConfigurationTemplate& WithLaunchIntoSourceInstance(bool value) {
    SetLaunchIntoSourceInstance(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Licensing.</p>
   */
  inline const Licensing& GetLicensing() const { return m_licensing; }
  inline bool LicensingHasBeenSet() const { return m_licensingHasBeenSet; }
  template <typename LicensingT = Licensing>
  void SetLicensing(LicensingT&& value) {
    m_licensingHasBeenSet = true;
    m_licensing = std::forward<LicensingT>(value);
  }
  template <typename LicensingT = Licensing>
  LaunchConfigurationTemplate& WithLicensing(LicensingT&& value) {
    SetLicensing(std::forward<LicensingT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Post-launch actions activated.</p>
   */
  inline bool GetPostLaunchEnabled() const { return m_postLaunchEnabled; }
  inline bool PostLaunchEnabledHasBeenSet() const { return m_postLaunchEnabledHasBeenSet; }
  inline void SetPostLaunchEnabled(bool value) {
    m_postLaunchEnabledHasBeenSet = true;
    m_postLaunchEnabled = value;
  }
  inline LaunchConfigurationTemplate& WithPostLaunchEnabled(bool value) {
    SetPostLaunchEnabled(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Tags of the Launch Configuration Template.</p>
   */
  inline const Aws::Map<Aws::String, Aws::String>& GetTags() const { return m_tags; }
  inline bool TagsHasBeenSet() const { return m_tagsHasBeenSet; }
  template <typename TagsT = Aws::Map<Aws::String, Aws::String>>
  void SetTags(TagsT&& value) {
    m_tagsHasBeenSet = true;
    m_tags = std::forward<TagsT>(value);
  }
  template <typename TagsT = Aws::Map<Aws::String, Aws::String>>
  LaunchConfigurationTemplate& WithTags(TagsT&& value) {
    SetTags(std::forward<TagsT>(value));
    return *this;
  }
  template <typename TagsKeyT = Aws::String, typename TagsValueT = Aws::String>
  LaunchConfigurationTemplate& AddTags(TagsKeyT&& key, TagsValueT&& value) {
    m_tagsHasBeenSet = true;
    m_tags.emplace(std::forward<TagsKeyT>(key), std::forward<TagsValueT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Target instance type right-sizing method.</p>
   */
  inline TargetInstanceTypeRightSizingMethod GetTargetInstanceTypeRightSizingMethod() const {
    return m_targetInstanceTypeRightSizingMethod;
  }
  inline bool TargetInstanceTypeRightSizingMethodHasBeenSet() const { return m_targetInstanceTypeRightSizingMethodHasBeenSet; }
  inline void SetTargetInstanceTypeRightSizingMethod(TargetInstanceTypeRightSizingMethod value) {
    m_targetInstanceTypeRightSizingMethodHasBeenSet = true;
    m_targetInstanceTypeRightSizingMethod = value;
  }
  inline LaunchConfigurationTemplate& WithTargetInstanceTypeRightSizingMethod(TargetInstanceTypeRightSizingMethod value) {
    SetTargetInstanceTypeRightSizingMethod(value);
    return *this;
  }
  ///@}
 private:
  Aws::String m_arn;

  bool m_copyPrivateIp{false};

  bool m_copyTags{false};

  Aws::String m_exportBucketArn;

  Aws::String m_launchConfigurationTemplateID;

  LaunchDisposition m_launchDisposition{LaunchDisposition::NOT_SET};

  bool m_launchIntoSourceInstance{false};

  Licensing m_licensing;

  bool m_postLaunchEnabled{false};

  Aws::Map<Aws::String, Aws::String> m_tags;

  TargetInstanceTypeRightSizingMethod m_targetInstanceTypeRightSizingMethod{TargetInstanceTypeRightSizingMethod::NOT_SET};
  bool m_arnHasBeenSet = false;
  bool m_copyPrivateIpHasBeenSet = false;
  bool m_copyTagsHasBeenSet = false;
  bool m_exportBucketArnHasBeenSet = false;
  bool m_launchConfigurationTemplateIDHasBeenSet = false;
  bool m_launchDispositionHasBeenSet = false;
  bool m_launchIntoSourceInstanceHasBeenSet = false;
  bool m_licensingHasBeenSet = false;
  bool m_postLaunchEnabledHasBeenSet = false;
  bool m_tagsHasBeenSet = false;
  bool m_targetInstanceTypeRightSizingMethodHasBeenSet = false;
};

}  // namespace Model
}  // namespace drs
}  // namespace Aws
