﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/fms/FMS_EXPORTS.h>
#include <aws/fms/model/ActionTarget.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace FMS {
namespace Model {

/**
 * <p>Information about the CreateRoute action in Amazon EC2.</p><p><h3>See
 * Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/EC2CreateRouteAction">AWS
 * API Reference</a></p>
 */
class EC2CreateRouteAction {
 public:
  AWS_FMS_API EC2CreateRouteAction() = default;
  AWS_FMS_API EC2CreateRouteAction(Aws::Utils::Json::JsonView jsonValue);
  AWS_FMS_API EC2CreateRouteAction& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_FMS_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>A description of CreateRoute action in Amazon EC2.</p>
   */
  inline const Aws::String& GetDescription() const { return m_description; }
  inline bool DescriptionHasBeenSet() const { return m_descriptionHasBeenSet; }
  template <typename DescriptionT = Aws::String>
  void SetDescription(DescriptionT&& value) {
    m_descriptionHasBeenSet = true;
    m_description = std::forward<DescriptionT>(value);
  }
  template <typename DescriptionT = Aws::String>
  EC2CreateRouteAction& WithDescription(DescriptionT&& value) {
    SetDescription(std::forward<DescriptionT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Information about the IPv4 CIDR address block used for the destination
   * match.</p>
   */
  inline const Aws::String& GetDestinationCidrBlock() const { return m_destinationCidrBlock; }
  inline bool DestinationCidrBlockHasBeenSet() const { return m_destinationCidrBlockHasBeenSet; }
  template <typename DestinationCidrBlockT = Aws::String>
  void SetDestinationCidrBlock(DestinationCidrBlockT&& value) {
    m_destinationCidrBlockHasBeenSet = true;
    m_destinationCidrBlock = std::forward<DestinationCidrBlockT>(value);
  }
  template <typename DestinationCidrBlockT = Aws::String>
  EC2CreateRouteAction& WithDestinationCidrBlock(DestinationCidrBlockT&& value) {
    SetDestinationCidrBlock(std::forward<DestinationCidrBlockT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Information about the ID of a prefix list used for the destination match.</p>
   */
  inline const Aws::String& GetDestinationPrefixListId() const { return m_destinationPrefixListId; }
  inline bool DestinationPrefixListIdHasBeenSet() const { return m_destinationPrefixListIdHasBeenSet; }
  template <typename DestinationPrefixListIdT = Aws::String>
  void SetDestinationPrefixListId(DestinationPrefixListIdT&& value) {
    m_destinationPrefixListIdHasBeenSet = true;
    m_destinationPrefixListId = std::forward<DestinationPrefixListIdT>(value);
  }
  template <typename DestinationPrefixListIdT = Aws::String>
  EC2CreateRouteAction& WithDestinationPrefixListId(DestinationPrefixListIdT&& value) {
    SetDestinationPrefixListId(std::forward<DestinationPrefixListIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Information about the IPv6 CIDR block destination.</p>
   */
  inline const Aws::String& GetDestinationIpv6CidrBlock() const { return m_destinationIpv6CidrBlock; }
  inline bool DestinationIpv6CidrBlockHasBeenSet() const { return m_destinationIpv6CidrBlockHasBeenSet; }
  template <typename DestinationIpv6CidrBlockT = Aws::String>
  void SetDestinationIpv6CidrBlock(DestinationIpv6CidrBlockT&& value) {
    m_destinationIpv6CidrBlockHasBeenSet = true;
    m_destinationIpv6CidrBlock = std::forward<DestinationIpv6CidrBlockT>(value);
  }
  template <typename DestinationIpv6CidrBlockT = Aws::String>
  EC2CreateRouteAction& WithDestinationIpv6CidrBlock(DestinationIpv6CidrBlockT&& value) {
    SetDestinationIpv6CidrBlock(std::forward<DestinationIpv6CidrBlockT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Information about the ID of a VPC endpoint. Supported for Gateway Load
   * Balancer endpoints only.</p>
   */
  inline const ActionTarget& GetVpcEndpointId() const { return m_vpcEndpointId; }
  inline bool VpcEndpointIdHasBeenSet() const { return m_vpcEndpointIdHasBeenSet; }
  template <typename VpcEndpointIdT = ActionTarget>
  void SetVpcEndpointId(VpcEndpointIdT&& value) {
    m_vpcEndpointIdHasBeenSet = true;
    m_vpcEndpointId = std::forward<VpcEndpointIdT>(value);
  }
  template <typename VpcEndpointIdT = ActionTarget>
  EC2CreateRouteAction& WithVpcEndpointId(VpcEndpointIdT&& value) {
    SetVpcEndpointId(std::forward<VpcEndpointIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Information about the ID of an internet gateway or virtual private gateway
   * attached to your VPC.</p>
   */
  inline const ActionTarget& GetGatewayId() const { return m_gatewayId; }
  inline bool GatewayIdHasBeenSet() const { return m_gatewayIdHasBeenSet; }
  template <typename GatewayIdT = ActionTarget>
  void SetGatewayId(GatewayIdT&& value) {
    m_gatewayIdHasBeenSet = true;
    m_gatewayId = std::forward<GatewayIdT>(value);
  }
  template <typename GatewayIdT = ActionTarget>
  EC2CreateRouteAction& WithGatewayId(GatewayIdT&& value) {
    SetGatewayId(std::forward<GatewayIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Information about the ID of the route table for the route.</p>
   */
  inline const ActionTarget& GetRouteTableId() const { return m_routeTableId; }
  inline bool RouteTableIdHasBeenSet() const { return m_routeTableIdHasBeenSet; }
  template <typename RouteTableIdT = ActionTarget>
  void SetRouteTableId(RouteTableIdT&& value) {
    m_routeTableIdHasBeenSet = true;
    m_routeTableId = std::forward<RouteTableIdT>(value);
  }
  template <typename RouteTableIdT = ActionTarget>
  EC2CreateRouteAction& WithRouteTableId(RouteTableIdT&& value) {
    SetRouteTableId(std::forward<RouteTableIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_description;

  Aws::String m_destinationCidrBlock;

  Aws::String m_destinationPrefixListId;

  Aws::String m_destinationIpv6CidrBlock;

  ActionTarget m_vpcEndpointId;

  ActionTarget m_gatewayId;

  ActionTarget m_routeTableId;
  bool m_descriptionHasBeenSet = false;
  bool m_destinationCidrBlockHasBeenSet = false;
  bool m_destinationPrefixListIdHasBeenSet = false;
  bool m_destinationIpv6CidrBlockHasBeenSet = false;
  bool m_vpcEndpointIdHasBeenSet = false;
  bool m_gatewayIdHasBeenSet = false;
  bool m_routeTableIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace FMS
}  // namespace Aws
