﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/greengrass/Greengrass_EXPORTS.h>
#include <aws/greengrass/model/DefinitionInformation.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace Greengrass {
namespace Model {
class ListDeviceDefinitionsResult {
 public:
  AWS_GREENGRASS_API ListDeviceDefinitionsResult() = default;
  AWS_GREENGRASS_API ListDeviceDefinitionsResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_GREENGRASS_API ListDeviceDefinitionsResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * Information about a definition.
   */
  inline const Aws::Vector<DefinitionInformation>& GetDefinitions() const { return m_definitions; }
  template <typename DefinitionsT = Aws::Vector<DefinitionInformation>>
  void SetDefinitions(DefinitionsT&& value) {
    m_definitionsHasBeenSet = true;
    m_definitions = std::forward<DefinitionsT>(value);
  }
  template <typename DefinitionsT = Aws::Vector<DefinitionInformation>>
  ListDeviceDefinitionsResult& WithDefinitions(DefinitionsT&& value) {
    SetDefinitions(std::forward<DefinitionsT>(value));
    return *this;
  }
  template <typename DefinitionsT = DefinitionInformation>
  ListDeviceDefinitionsResult& AddDefinitions(DefinitionsT&& value) {
    m_definitionsHasBeenSet = true;
    m_definitions.emplace_back(std::forward<DefinitionsT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * The token for the next set of results, or ''null'' if there are no additional
   * results.
   */
  inline const Aws::String& GetNextToken() const { return m_nextToken; }
  template <typename NextTokenT = Aws::String>
  void SetNextToken(NextTokenT&& value) {
    m_nextTokenHasBeenSet = true;
    m_nextToken = std::forward<NextTokenT>(value);
  }
  template <typename NextTokenT = Aws::String>
  ListDeviceDefinitionsResult& WithNextToken(NextTokenT&& value) {
    SetNextToken(std::forward<NextTokenT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  ListDeviceDefinitionsResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::Vector<DefinitionInformation> m_definitions;

  Aws::String m_nextToken;

  Aws::String m_requestId;
  bool m_definitionsHasBeenSet = false;
  bool m_nextTokenHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace Greengrass
}  // namespace Aws
