﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/lexv2-models/LexModelsV2_EXPORTS.h>
#include <aws/lexv2-models/model/BotAliasStatus.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace LexModelsV2 {
namespace Model {
class DeleteBotAliasResult {
 public:
  AWS_LEXMODELSV2_API DeleteBotAliasResult() = default;
  AWS_LEXMODELSV2_API DeleteBotAliasResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_LEXMODELSV2_API DeleteBotAliasResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The unique identifier of the bot alias to delete.</p>
   */
  inline const Aws::String& GetBotAliasId() const { return m_botAliasId; }
  template <typename BotAliasIdT = Aws::String>
  void SetBotAliasId(BotAliasIdT&& value) {
    m_botAliasIdHasBeenSet = true;
    m_botAliasId = std::forward<BotAliasIdT>(value);
  }
  template <typename BotAliasIdT = Aws::String>
  DeleteBotAliasResult& WithBotAliasId(BotAliasIdT&& value) {
    SetBotAliasId(std::forward<BotAliasIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The unique identifier of the bot that contains the alias to delete.</p>
   */
  inline const Aws::String& GetBotId() const { return m_botId; }
  template <typename BotIdT = Aws::String>
  void SetBotId(BotIdT&& value) {
    m_botIdHasBeenSet = true;
    m_botId = std::forward<BotIdT>(value);
  }
  template <typename BotIdT = Aws::String>
  DeleteBotAliasResult& WithBotId(BotIdT&& value) {
    SetBotId(std::forward<BotIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The current status of the alias. The status is <code>Deleting</code> while
   * the alias is in the process of being deleted. Once the alias is deleted, it will
   * no longer appear in the list of aliases returned by the
   * <code>ListBotAliases</code> operation.</p>
   */
  inline BotAliasStatus GetBotAliasStatus() const { return m_botAliasStatus; }
  inline void SetBotAliasStatus(BotAliasStatus value) {
    m_botAliasStatusHasBeenSet = true;
    m_botAliasStatus = value;
  }
  inline DeleteBotAliasResult& WithBotAliasStatus(BotAliasStatus value) {
    SetBotAliasStatus(value);
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  DeleteBotAliasResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_botAliasId;

  Aws::String m_botId;

  BotAliasStatus m_botAliasStatus{BotAliasStatus::NOT_SET};

  Aws::String m_requestId;
  bool m_botAliasIdHasBeenSet = false;
  bool m_botIdHasBeenSet = false;
  bool m_botAliasStatusHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace LexModelsV2
}  // namespace Aws
