﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/m2/MainframeModernizationRequest.h>
#include <aws/m2/MainframeModernization_EXPORTS.h>

#include <utility>

namespace Aws {
namespace MainframeModernization {
namespace Model {

/**
 */
class GetApplicationVersionRequest : public MainframeModernizationRequest {
 public:
  AWS_MAINFRAMEMODERNIZATION_API GetApplicationVersionRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "GetApplicationVersion"; }

  AWS_MAINFRAMEMODERNIZATION_API Aws::String SerializePayload() const override;

  ///@{
  /**
   * <p>The unique identifier of the application.</p>
   */
  inline const Aws::String& GetApplicationId() const { return m_applicationId; }
  inline bool ApplicationIdHasBeenSet() const { return m_applicationIdHasBeenSet; }
  template <typename ApplicationIdT = Aws::String>
  void SetApplicationId(ApplicationIdT&& value) {
    m_applicationIdHasBeenSet = true;
    m_applicationId = std::forward<ApplicationIdT>(value);
  }
  template <typename ApplicationIdT = Aws::String>
  GetApplicationVersionRequest& WithApplicationId(ApplicationIdT&& value) {
    SetApplicationId(std::forward<ApplicationIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The specific version of the application.</p>
   */
  inline int GetApplicationVersion() const { return m_applicationVersion; }
  inline bool ApplicationVersionHasBeenSet() const { return m_applicationVersionHasBeenSet; }
  inline void SetApplicationVersion(int value) {
    m_applicationVersionHasBeenSet = true;
    m_applicationVersion = value;
  }
  inline GetApplicationVersionRequest& WithApplicationVersion(int value) {
    SetApplicationVersion(value);
    return *this;
  }
  ///@}
 private:
  Aws::String m_applicationId;

  int m_applicationVersion{0};
  bool m_applicationIdHasBeenSet = false;
  bool m_applicationVersionHasBeenSet = false;
};

}  // namespace Model
}  // namespace MainframeModernization
}  // namespace Aws
