﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/m2/MainframeModernization_EXPORTS.h>
#include <aws/m2/model/EnvironmentSummary.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace MainframeModernization {
namespace Model {
class ListEnvironmentsResult {
 public:
  AWS_MAINFRAMEMODERNIZATION_API ListEnvironmentsResult() = default;
  AWS_MAINFRAMEMODERNIZATION_API ListEnvironmentsResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_MAINFRAMEMODERNIZATION_API ListEnvironmentsResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>Returns a list of summary details for all the runtime environments in your
   * account. </p>
   */
  inline const Aws::Vector<EnvironmentSummary>& GetEnvironments() const { return m_environments; }
  template <typename EnvironmentsT = Aws::Vector<EnvironmentSummary>>
  void SetEnvironments(EnvironmentsT&& value) {
    m_environmentsHasBeenSet = true;
    m_environments = std::forward<EnvironmentsT>(value);
  }
  template <typename EnvironmentsT = Aws::Vector<EnvironmentSummary>>
  ListEnvironmentsResult& WithEnvironments(EnvironmentsT&& value) {
    SetEnvironments(std::forward<EnvironmentsT>(value));
    return *this;
  }
  template <typename EnvironmentsT = EnvironmentSummary>
  ListEnvironmentsResult& AddEnvironments(EnvironmentsT&& value) {
    m_environmentsHasBeenSet = true;
    m_environments.emplace_back(std::forward<EnvironmentsT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>A pagination token that's returned when the response doesn't contain all the
   * runtime environments.</p>
   */
  inline const Aws::String& GetNextToken() const { return m_nextToken; }
  template <typename NextTokenT = Aws::String>
  void SetNextToken(NextTokenT&& value) {
    m_nextTokenHasBeenSet = true;
    m_nextToken = std::forward<NextTokenT>(value);
  }
  template <typename NextTokenT = Aws::String>
  ListEnvironmentsResult& WithNextToken(NextTokenT&& value) {
    SetNextToken(std::forward<NextTokenT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  ListEnvironmentsResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::Vector<EnvironmentSummary> m_environments;

  Aws::String m_nextToken;

  Aws::String m_requestId;
  bool m_environmentsHasBeenSet = false;
  bool m_nextTokenHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace MainframeModernization
}  // namespace Aws
