﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/DateTime.h>
#include <aws/core/utils/memory/stl/AWSMap.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/omics/Omics_EXPORTS.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace Omics {
namespace Model {
class GetRunGroupResult {
 public:
  AWS_OMICS_API GetRunGroupResult() = default;
  AWS_OMICS_API GetRunGroupResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_OMICS_API GetRunGroupResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The group's ARN.</p>
   */
  inline const Aws::String& GetArn() const { return m_arn; }
  template <typename ArnT = Aws::String>
  void SetArn(ArnT&& value) {
    m_arnHasBeenSet = true;
    m_arn = std::forward<ArnT>(value);
  }
  template <typename ArnT = Aws::String>
  GetRunGroupResult& WithArn(ArnT&& value) {
    SetArn(std::forward<ArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The group's ID.</p>
   */
  inline const Aws::String& GetId() const { return m_id; }
  template <typename IdT = Aws::String>
  void SetId(IdT&& value) {
    m_idHasBeenSet = true;
    m_id = std::forward<IdT>(value);
  }
  template <typename IdT = Aws::String>
  GetRunGroupResult& WithId(IdT&& value) {
    SetId(std::forward<IdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The group's name.</p>
   */
  inline const Aws::String& GetName() const { return m_name; }
  template <typename NameT = Aws::String>
  void SetName(NameT&& value) {
    m_nameHasBeenSet = true;
    m_name = std::forward<NameT>(value);
  }
  template <typename NameT = Aws::String>
  GetRunGroupResult& WithName(NameT&& value) {
    SetName(std::forward<NameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The group's maximum number of CPUs to use.</p>
   */
  inline int GetMaxCpus() const { return m_maxCpus; }
  inline void SetMaxCpus(int value) {
    m_maxCpusHasBeenSet = true;
    m_maxCpus = value;
  }
  inline GetRunGroupResult& WithMaxCpus(int value) {
    SetMaxCpus(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The maximum number of concurrent runs for the group.</p>
   */
  inline int GetMaxRuns() const { return m_maxRuns; }
  inline void SetMaxRuns(int value) {
    m_maxRunsHasBeenSet = true;
    m_maxRuns = value;
  }
  inline GetRunGroupResult& WithMaxRuns(int value) {
    SetMaxRuns(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The group's maximum run time in minutes.</p>
   */
  inline int GetMaxDuration() const { return m_maxDuration; }
  inline void SetMaxDuration(int value) {
    m_maxDurationHasBeenSet = true;
    m_maxDuration = value;
  }
  inline GetRunGroupResult& WithMaxDuration(int value) {
    SetMaxDuration(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>When the group was created.</p>
   */
  inline const Aws::Utils::DateTime& GetCreationTime() const { return m_creationTime; }
  template <typename CreationTimeT = Aws::Utils::DateTime>
  void SetCreationTime(CreationTimeT&& value) {
    m_creationTimeHasBeenSet = true;
    m_creationTime = std::forward<CreationTimeT>(value);
  }
  template <typename CreationTimeT = Aws::Utils::DateTime>
  GetRunGroupResult& WithCreationTime(CreationTimeT&& value) {
    SetCreationTime(std::forward<CreationTimeT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The group's tags.</p>
   */
  inline const Aws::Map<Aws::String, Aws::String>& GetTags() const { return m_tags; }
  template <typename TagsT = Aws::Map<Aws::String, Aws::String>>
  void SetTags(TagsT&& value) {
    m_tagsHasBeenSet = true;
    m_tags = std::forward<TagsT>(value);
  }
  template <typename TagsT = Aws::Map<Aws::String, Aws::String>>
  GetRunGroupResult& WithTags(TagsT&& value) {
    SetTags(std::forward<TagsT>(value));
    return *this;
  }
  template <typename TagsKeyT = Aws::String, typename TagsValueT = Aws::String>
  GetRunGroupResult& AddTags(TagsKeyT&& key, TagsValueT&& value) {
    m_tagsHasBeenSet = true;
    m_tags.emplace(std::forward<TagsKeyT>(key), std::forward<TagsValueT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The maximum GPUs that can be used by a run group.</p>
   */
  inline int GetMaxGpus() const { return m_maxGpus; }
  inline void SetMaxGpus(int value) {
    m_maxGpusHasBeenSet = true;
    m_maxGpus = value;
  }
  inline GetRunGroupResult& WithMaxGpus(int value) {
    SetMaxGpus(value);
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  GetRunGroupResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_arn;

  Aws::String m_id;

  Aws::String m_name;

  int m_maxCpus{0};

  int m_maxRuns{0};

  int m_maxDuration{0};

  Aws::Utils::DateTime m_creationTime{};

  Aws::Map<Aws::String, Aws::String> m_tags;

  int m_maxGpus{0};

  Aws::String m_requestId;
  bool m_arnHasBeenSet = false;
  bool m_idHasBeenSet = false;
  bool m_nameHasBeenSet = false;
  bool m_maxCpusHasBeenSet = false;
  bool m_maxRunsHasBeenSet = false;
  bool m_maxDurationHasBeenSet = false;
  bool m_creationTimeHasBeenSet = false;
  bool m_tagsHasBeenSet = false;
  bool m_maxGpusHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace Omics
}  // namespace Aws
