﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/DateTime.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/outposts/Outposts_EXPORTS.h>
#include <aws/outposts/model/CapacityTaskStatus.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace Outposts {
namespace Model {

/**
 * <p>The summary of the capacity task.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/outposts-2019-12-03/CapacityTaskSummary">AWS
 * API Reference</a></p>
 */
class CapacityTaskSummary {
 public:
  AWS_OUTPOSTS_API CapacityTaskSummary() = default;
  AWS_OUTPOSTS_API CapacityTaskSummary(Aws::Utils::Json::JsonView jsonValue);
  AWS_OUTPOSTS_API CapacityTaskSummary& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_OUTPOSTS_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The ID of the specified capacity task.</p>
   */
  inline const Aws::String& GetCapacityTaskId() const { return m_capacityTaskId; }
  inline bool CapacityTaskIdHasBeenSet() const { return m_capacityTaskIdHasBeenSet; }
  template <typename CapacityTaskIdT = Aws::String>
  void SetCapacityTaskId(CapacityTaskIdT&& value) {
    m_capacityTaskIdHasBeenSet = true;
    m_capacityTaskId = std::forward<CapacityTaskIdT>(value);
  }
  template <typename CapacityTaskIdT = Aws::String>
  CapacityTaskSummary& WithCapacityTaskId(CapacityTaskIdT&& value) {
    SetCapacityTaskId(std::forward<CapacityTaskIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The ID of the Outpost associated with the specified capacity task.</p>
   */
  inline const Aws::String& GetOutpostId() const { return m_outpostId; }
  inline bool OutpostIdHasBeenSet() const { return m_outpostIdHasBeenSet; }
  template <typename OutpostIdT = Aws::String>
  void SetOutpostId(OutpostIdT&& value) {
    m_outpostIdHasBeenSet = true;
    m_outpostId = std::forward<OutpostIdT>(value);
  }
  template <typename OutpostIdT = Aws::String>
  CapacityTaskSummary& WithOutpostId(OutpostIdT&& value) {
    SetOutpostId(std::forward<OutpostIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The ID of the Amazon Web Services Outposts order of the host associated with
   * the capacity task.</p>
   */
  inline const Aws::String& GetOrderId() const { return m_orderId; }
  inline bool OrderIdHasBeenSet() const { return m_orderIdHasBeenSet; }
  template <typename OrderIdT = Aws::String>
  void SetOrderId(OrderIdT&& value) {
    m_orderIdHasBeenSet = true;
    m_orderId = std::forward<OrderIdT>(value);
  }
  template <typename OrderIdT = Aws::String>
  CapacityTaskSummary& WithOrderId(OrderIdT&& value) {
    SetOrderId(std::forward<OrderIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The ID of the asset. An Outpost asset can be a single server within an
   * Outposts rack or an Outposts server configuration.</p>
   */
  inline const Aws::String& GetAssetId() const { return m_assetId; }
  inline bool AssetIdHasBeenSet() const { return m_assetIdHasBeenSet; }
  template <typename AssetIdT = Aws::String>
  void SetAssetId(AssetIdT&& value) {
    m_assetIdHasBeenSet = true;
    m_assetId = std::forward<AssetIdT>(value);
  }
  template <typename AssetIdT = Aws::String>
  CapacityTaskSummary& WithAssetId(AssetIdT&& value) {
    SetAssetId(std::forward<AssetIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The status of the capacity task.</p>
   */
  inline CapacityTaskStatus GetCapacityTaskStatus() const { return m_capacityTaskStatus; }
  inline bool CapacityTaskStatusHasBeenSet() const { return m_capacityTaskStatusHasBeenSet; }
  inline void SetCapacityTaskStatus(CapacityTaskStatus value) {
    m_capacityTaskStatusHasBeenSet = true;
    m_capacityTaskStatus = value;
  }
  inline CapacityTaskSummary& WithCapacityTaskStatus(CapacityTaskStatus value) {
    SetCapacityTaskStatus(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The date that the specified capacity task was created.</p>
   */
  inline const Aws::Utils::DateTime& GetCreationDate() const { return m_creationDate; }
  inline bool CreationDateHasBeenSet() const { return m_creationDateHasBeenSet; }
  template <typename CreationDateT = Aws::Utils::DateTime>
  void SetCreationDate(CreationDateT&& value) {
    m_creationDateHasBeenSet = true;
    m_creationDate = std::forward<CreationDateT>(value);
  }
  template <typename CreationDateT = Aws::Utils::DateTime>
  CapacityTaskSummary& WithCreationDate(CreationDateT&& value) {
    SetCreationDate(std::forward<CreationDateT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The date that the specified capacity task successfully ran.</p>
   */
  inline const Aws::Utils::DateTime& GetCompletionDate() const { return m_completionDate; }
  inline bool CompletionDateHasBeenSet() const { return m_completionDateHasBeenSet; }
  template <typename CompletionDateT = Aws::Utils::DateTime>
  void SetCompletionDate(CompletionDateT&& value) {
    m_completionDateHasBeenSet = true;
    m_completionDate = std::forward<CompletionDateT>(value);
  }
  template <typename CompletionDateT = Aws::Utils::DateTime>
  CapacityTaskSummary& WithCompletionDate(CompletionDateT&& value) {
    SetCompletionDate(std::forward<CompletionDateT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The date that the specified capacity was last modified.</p>
   */
  inline const Aws::Utils::DateTime& GetLastModifiedDate() const { return m_lastModifiedDate; }
  inline bool LastModifiedDateHasBeenSet() const { return m_lastModifiedDateHasBeenSet; }
  template <typename LastModifiedDateT = Aws::Utils::DateTime>
  void SetLastModifiedDate(LastModifiedDateT&& value) {
    m_lastModifiedDateHasBeenSet = true;
    m_lastModifiedDate = std::forward<LastModifiedDateT>(value);
  }
  template <typename LastModifiedDateT = Aws::Utils::DateTime>
  CapacityTaskSummary& WithLastModifiedDate(LastModifiedDateT&& value) {
    SetLastModifiedDate(std::forward<LastModifiedDateT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_capacityTaskId;

  Aws::String m_outpostId;

  Aws::String m_orderId;

  Aws::String m_assetId;

  CapacityTaskStatus m_capacityTaskStatus{CapacityTaskStatus::NOT_SET};

  Aws::Utils::DateTime m_creationDate{};

  Aws::Utils::DateTime m_completionDate{};

  Aws::Utils::DateTime m_lastModifiedDate{};
  bool m_capacityTaskIdHasBeenSet = false;
  bool m_outpostIdHasBeenSet = false;
  bool m_orderIdHasBeenSet = false;
  bool m_assetIdHasBeenSet = false;
  bool m_capacityTaskStatusHasBeenSet = false;
  bool m_creationDateHasBeenSet = false;
  bool m_completionDateHasBeenSet = false;
  bool m_lastModifiedDateHasBeenSet = false;
};

}  // namespace Model
}  // namespace Outposts
}  // namespace Aws
