﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/qapps/QApps_EXPORTS.h>
#include <aws/qapps/model/PrincipalOutputUserTypeEnum.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace QApps {
namespace Model {

/**
 * <p>The principal for which the permission applies.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/PrincipalOutput">AWS
 * API Reference</a></p>
 */
class PrincipalOutput {
 public:
  AWS_QAPPS_API PrincipalOutput() = default;
  AWS_QAPPS_API PrincipalOutput(Aws::Utils::Json::JsonView jsonValue);
  AWS_QAPPS_API PrincipalOutput& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_QAPPS_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The unique identifier of the user.</p>
   */
  inline const Aws::String& GetUserId() const { return m_userId; }
  inline bool UserIdHasBeenSet() const { return m_userIdHasBeenSet; }
  template <typename UserIdT = Aws::String>
  void SetUserId(UserIdT&& value) {
    m_userIdHasBeenSet = true;
    m_userId = std::forward<UserIdT>(value);
  }
  template <typename UserIdT = Aws::String>
  PrincipalOutput& WithUserId(UserIdT&& value) {
    SetUserId(std::forward<UserIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The type of the user.</p>
   */
  inline PrincipalOutputUserTypeEnum GetUserType() const { return m_userType; }
  inline bool UserTypeHasBeenSet() const { return m_userTypeHasBeenSet; }
  inline void SetUserType(PrincipalOutputUserTypeEnum value) {
    m_userTypeHasBeenSet = true;
    m_userType = value;
  }
  inline PrincipalOutput& WithUserType(PrincipalOutputUserTypeEnum value) {
    SetUserType(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The email address associated with the user.</p>
   */
  inline const Aws::String& GetEmail() const { return m_email; }
  inline bool EmailHasBeenSet() const { return m_emailHasBeenSet; }
  template <typename EmailT = Aws::String>
  void SetEmail(EmailT&& value) {
    m_emailHasBeenSet = true;
    m_email = std::forward<EmailT>(value);
  }
  template <typename EmailT = Aws::String>
  PrincipalOutput& WithEmail(EmailT&& value) {
    SetEmail(std::forward<EmailT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_userId;

  PrincipalOutputUserTypeEnum m_userType{PrincipalOutputUserTypeEnum::NOT_SET};

  Aws::String m_email;
  bool m_userIdHasBeenSet = false;
  bool m_userTypeHasBeenSet = false;
  bool m_emailHasBeenSet = false;
};

}  // namespace Model
}  // namespace QApps
}  // namespace Aws
