﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/quicksight/QuickSightRequest.h>
#include <aws/quicksight/QuickSight_EXPORTS.h>
#include <aws/quicksight/model/ServiceType.h>

#include <utility>

namespace Aws {
namespace QuickSight {
namespace Model {

/**
 */
class DeleteIdentityPropagationConfigRequest : public QuickSightRequest {
 public:
  AWS_QUICKSIGHT_API DeleteIdentityPropagationConfigRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "DeleteIdentityPropagationConfig"; }

  AWS_QUICKSIGHT_API Aws::String SerializePayload() const override;

  ///@{
  /**
   * <p>The ID of the Amazon Web Services account that you want to delete an identity
   * propagation configuration from.</p>
   */
  inline const Aws::String& GetAwsAccountId() const { return m_awsAccountId; }
  inline bool AwsAccountIdHasBeenSet() const { return m_awsAccountIdHasBeenSet; }
  template <typename AwsAccountIdT = Aws::String>
  void SetAwsAccountId(AwsAccountIdT&& value) {
    m_awsAccountIdHasBeenSet = true;
    m_awsAccountId = std::forward<AwsAccountIdT>(value);
  }
  template <typename AwsAccountIdT = Aws::String>
  DeleteIdentityPropagationConfigRequest& WithAwsAccountId(AwsAccountIdT&& value) {
    SetAwsAccountId(std::forward<AwsAccountIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The name of the Amazon Web Services service that you want to delete the
   * associated access scopes and authorized targets from.</p>
   */
  inline ServiceType GetService() const { return m_service; }
  inline bool ServiceHasBeenSet() const { return m_serviceHasBeenSet; }
  inline void SetService(ServiceType value) {
    m_serviceHasBeenSet = true;
    m_service = value;
  }
  inline DeleteIdentityPropagationConfigRequest& WithService(ServiceType value) {
    SetService(value);
    return *this;
  }
  ///@}
 private:
  Aws::String m_awsAccountId;

  ServiceType m_service{ServiceType::NOT_SET};
  bool m_awsAccountIdHasBeenSet = false;
  bool m_serviceHasBeenSet = false;
};

}  // namespace Model
}  // namespace QuickSight
}  // namespace Aws
