﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/redshift/Redshift_EXPORTS.h>
#include <aws/redshift/model/ResponseMetadata.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Xml {
class XmlDocument;
}  // namespace Xml
}  // namespace Utils
namespace Redshift {
namespace Model {
class DeleteAuthenticationProfileResult {
 public:
  AWS_REDSHIFT_API DeleteAuthenticationProfileResult() = default;
  AWS_REDSHIFT_API DeleteAuthenticationProfileResult(const Aws::AmazonWebServiceResult<Aws::Utils::Xml::XmlDocument>& result);
  AWS_REDSHIFT_API DeleteAuthenticationProfileResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Xml::XmlDocument>& result);

  ///@{
  /**
   * <p>The name of the authentication profile that was deleted.</p>
   */
  inline const Aws::String& GetAuthenticationProfileName() const { return m_authenticationProfileName; }
  template <typename AuthenticationProfileNameT = Aws::String>
  void SetAuthenticationProfileName(AuthenticationProfileNameT&& value) {
    m_authenticationProfileNameHasBeenSet = true;
    m_authenticationProfileName = std::forward<AuthenticationProfileNameT>(value);
  }
  template <typename AuthenticationProfileNameT = Aws::String>
  DeleteAuthenticationProfileResult& WithAuthenticationProfileName(AuthenticationProfileNameT&& value) {
    SetAuthenticationProfileName(std::forward<AuthenticationProfileNameT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const ResponseMetadata& GetResponseMetadata() const { return m_responseMetadata; }
  template <typename ResponseMetadataT = ResponseMetadata>
  void SetResponseMetadata(ResponseMetadataT&& value) {
    m_responseMetadataHasBeenSet = true;
    m_responseMetadata = std::forward<ResponseMetadataT>(value);
  }
  template <typename ResponseMetadataT = ResponseMetadata>
  DeleteAuthenticationProfileResult& WithResponseMetadata(ResponseMetadataT&& value) {
    SetResponseMetadata(std::forward<ResponseMetadataT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_authenticationProfileName;

  ResponseMetadata m_responseMetadata;
  bool m_authenticationProfileNameHasBeenSet = false;
  bool m_responseMetadataHasBeenSet = false;
};

}  // namespace Model
}  // namespace Redshift
}  // namespace Aws
