﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/rekognition/Rekognition_EXPORTS.h>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace Rekognition {
namespace Model {

/**
 * <p> Provides statistics about a dataset. For more information, see
 * <a>DescribeDataset</a>. </p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/rekognition-2016-06-27/DatasetStats">AWS
 * API Reference</a></p>
 */
class DatasetStats {
 public:
  AWS_REKOGNITION_API DatasetStats() = default;
  AWS_REKOGNITION_API DatasetStats(Aws::Utils::Json::JsonView jsonValue);
  AWS_REKOGNITION_API DatasetStats& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_REKOGNITION_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p> The total number of images in the dataset that have labels. </p>
   */
  inline int GetLabeledEntries() const { return m_labeledEntries; }
  inline bool LabeledEntriesHasBeenSet() const { return m_labeledEntriesHasBeenSet; }
  inline void SetLabeledEntries(int value) {
    m_labeledEntriesHasBeenSet = true;
    m_labeledEntries = value;
  }
  inline DatasetStats& WithLabeledEntries(int value) {
    SetLabeledEntries(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p> The total number of images in the dataset. </p>
   */
  inline int GetTotalEntries() const { return m_totalEntries; }
  inline bool TotalEntriesHasBeenSet() const { return m_totalEntriesHasBeenSet; }
  inline void SetTotalEntries(int value) {
    m_totalEntriesHasBeenSet = true;
    m_totalEntries = value;
  }
  inline DatasetStats& WithTotalEntries(int value) {
    SetTotalEntries(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p> The total number of labels declared in the dataset. </p>
   */
  inline int GetTotalLabels() const { return m_totalLabels; }
  inline bool TotalLabelsHasBeenSet() const { return m_totalLabelsHasBeenSet; }
  inline void SetTotalLabels(int value) {
    m_totalLabelsHasBeenSet = true;
    m_totalLabels = value;
  }
  inline DatasetStats& WithTotalLabels(int value) {
    SetTotalLabels(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p> The total number of entries that contain at least one error. </p>
   */
  inline int GetErrorEntries() const { return m_errorEntries; }
  inline bool ErrorEntriesHasBeenSet() const { return m_errorEntriesHasBeenSet; }
  inline void SetErrorEntries(int value) {
    m_errorEntriesHasBeenSet = true;
    m_errorEntries = value;
  }
  inline DatasetStats& WithErrorEntries(int value) {
    SetErrorEntries(value);
    return *this;
  }
  ///@}
 private:
  int m_labeledEntries{0};

  int m_totalEntries{0};

  int m_totalLabels{0};

  int m_errorEntries{0};
  bool m_labeledEntriesHasBeenSet = false;
  bool m_totalEntriesHasBeenSet = false;
  bool m_totalLabelsHasBeenSet = false;
  bool m_errorEntriesHasBeenSet = false;
};

}  // namespace Model
}  // namespace Rekognition
}  // namespace Aws
