﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/sagemaker/SageMaker_EXPORTS.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace SageMaker {
namespace Model {

/**
 * <p>Metadata properties of the tracking entity, trial, or trial
 * component.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/MetadataProperties">AWS
 * API Reference</a></p>
 */
class MetadataProperties {
 public:
  AWS_SAGEMAKER_API MetadataProperties() = default;
  AWS_SAGEMAKER_API MetadataProperties(Aws::Utils::Json::JsonView jsonValue);
  AWS_SAGEMAKER_API MetadataProperties& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_SAGEMAKER_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The commit ID.</p>
   */
  inline const Aws::String& GetCommitId() const { return m_commitId; }
  inline bool CommitIdHasBeenSet() const { return m_commitIdHasBeenSet; }
  template <typename CommitIdT = Aws::String>
  void SetCommitId(CommitIdT&& value) {
    m_commitIdHasBeenSet = true;
    m_commitId = std::forward<CommitIdT>(value);
  }
  template <typename CommitIdT = Aws::String>
  MetadataProperties& WithCommitId(CommitIdT&& value) {
    SetCommitId(std::forward<CommitIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The repository.</p>
   */
  inline const Aws::String& GetRepository() const { return m_repository; }
  inline bool RepositoryHasBeenSet() const { return m_repositoryHasBeenSet; }
  template <typename RepositoryT = Aws::String>
  void SetRepository(RepositoryT&& value) {
    m_repositoryHasBeenSet = true;
    m_repository = std::forward<RepositoryT>(value);
  }
  template <typename RepositoryT = Aws::String>
  MetadataProperties& WithRepository(RepositoryT&& value) {
    SetRepository(std::forward<RepositoryT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The entity this entity was generated by.</p>
   */
  inline const Aws::String& GetGeneratedBy() const { return m_generatedBy; }
  inline bool GeneratedByHasBeenSet() const { return m_generatedByHasBeenSet; }
  template <typename GeneratedByT = Aws::String>
  void SetGeneratedBy(GeneratedByT&& value) {
    m_generatedByHasBeenSet = true;
    m_generatedBy = std::forward<GeneratedByT>(value);
  }
  template <typename GeneratedByT = Aws::String>
  MetadataProperties& WithGeneratedBy(GeneratedByT&& value) {
    SetGeneratedBy(std::forward<GeneratedByT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The project ID.</p>
   */
  inline const Aws::String& GetProjectId() const { return m_projectId; }
  inline bool ProjectIdHasBeenSet() const { return m_projectIdHasBeenSet; }
  template <typename ProjectIdT = Aws::String>
  void SetProjectId(ProjectIdT&& value) {
    m_projectIdHasBeenSet = true;
    m_projectId = std::forward<ProjectIdT>(value);
  }
  template <typename ProjectIdT = Aws::String>
  MetadataProperties& WithProjectId(ProjectIdT&& value) {
    SetProjectId(std::forward<ProjectIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_commitId;

  Aws::String m_repository;

  Aws::String m_generatedBy;

  Aws::String m_projectId;
  bool m_commitIdHasBeenSet = false;
  bool m_repositoryHasBeenSet = false;
  bool m_generatedByHasBeenSet = false;
  bool m_projectIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace SageMaker
}  // namespace Aws
