﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/serverlessrepo/ServerlessApplicationRepository_EXPORTS.h>
#include <aws/serverlessrepo/model/Status.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace ServerlessApplicationRepository {
namespace Model {
class GetCloudFormationTemplateResult {
 public:
  AWS_SERVERLESSAPPLICATIONREPOSITORY_API GetCloudFormationTemplateResult() = default;
  AWS_SERVERLESSAPPLICATIONREPOSITORY_API GetCloudFormationTemplateResult(
      const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_SERVERLESSAPPLICATIONREPOSITORY_API GetCloudFormationTemplateResult& operator=(
      const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The application Amazon Resource Name (ARN).</p>
   */
  inline const Aws::String& GetApplicationId() const { return m_applicationId; }
  template <typename ApplicationIdT = Aws::String>
  void SetApplicationId(ApplicationIdT&& value) {
    m_applicationIdHasBeenSet = true;
    m_applicationId = std::forward<ApplicationIdT>(value);
  }
  template <typename ApplicationIdT = Aws::String>
  GetCloudFormationTemplateResult& WithApplicationId(ApplicationIdT&& value) {
    SetApplicationId(std::forward<ApplicationIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The date and time this resource was created.</p>
   */
  inline const Aws::String& GetCreationTime() const { return m_creationTime; }
  template <typename CreationTimeT = Aws::String>
  void SetCreationTime(CreationTimeT&& value) {
    m_creationTimeHasBeenSet = true;
    m_creationTime = std::forward<CreationTimeT>(value);
  }
  template <typename CreationTimeT = Aws::String>
  GetCloudFormationTemplateResult& WithCreationTime(CreationTimeT&& value) {
    SetCreationTime(std::forward<CreationTimeT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The date and time this template expires. Templates
expire 1 hour after
   * creation.</p>
   */
  inline const Aws::String& GetExpirationTime() const { return m_expirationTime; }
  template <typename ExpirationTimeT = Aws::String>
  void SetExpirationTime(ExpirationTimeT&& value) {
    m_expirationTimeHasBeenSet = true;
    m_expirationTime = std::forward<ExpirationTimeT>(value);
  }
  template <typename ExpirationTimeT = Aws::String>
  GetCloudFormationTemplateResult& WithExpirationTime(ExpirationTimeT&& value) {
    SetExpirationTime(std::forward<ExpirationTimeT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The semantic version of the application:</p><p>
<a
   * href="https://semver.org/">https://semver.org/</a>
</p>
   */
  inline const Aws::String& GetSemanticVersion() const { return m_semanticVersion; }
  template <typename SemanticVersionT = Aws::String>
  void SetSemanticVersion(SemanticVersionT&& value) {
    m_semanticVersionHasBeenSet = true;
    m_semanticVersion = std::forward<SemanticVersionT>(value);
  }
  template <typename SemanticVersionT = Aws::String>
  GetCloudFormationTemplateResult& WithSemanticVersion(SemanticVersionT&& value) {
    SetSemanticVersion(std::forward<SemanticVersionT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Status of the template creation workflow.</p><p>Possible values: PREPARING |
   * ACTIVE | EXPIRED
</p>
   */
  inline Status GetStatus() const { return m_status; }
  inline void SetStatus(Status value) {
    m_statusHasBeenSet = true;
    m_status = value;
  }
  inline GetCloudFormationTemplateResult& WithStatus(Status value) {
    SetStatus(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The UUID returned by CreateCloudFormationTemplate.</p><p>Pattern:
   * [0-9a-fA-F]{8}\-[0-9a-fA-F]{4}\-[0-9a-fA-F]{4}\-[0-9a-fA-F]{4}\-[0-9a-fA-F]{12}</p>
   */
  inline const Aws::String& GetTemplateId() const { return m_templateId; }
  template <typename TemplateIdT = Aws::String>
  void SetTemplateId(TemplateIdT&& value) {
    m_templateIdHasBeenSet = true;
    m_templateId = std::forward<TemplateIdT>(value);
  }
  template <typename TemplateIdT = Aws::String>
  GetCloudFormationTemplateResult& WithTemplateId(TemplateIdT&& value) {
    SetTemplateId(std::forward<TemplateIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>A link to the template that can be used to deploy the application using
AWS
   * CloudFormation.</p>
   */
  inline const Aws::String& GetTemplateUrl() const { return m_templateUrl; }
  template <typename TemplateUrlT = Aws::String>
  void SetTemplateUrl(TemplateUrlT&& value) {
    m_templateUrlHasBeenSet = true;
    m_templateUrl = std::forward<TemplateUrlT>(value);
  }
  template <typename TemplateUrlT = Aws::String>
  GetCloudFormationTemplateResult& WithTemplateUrl(TemplateUrlT&& value) {
    SetTemplateUrl(std::forward<TemplateUrlT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  GetCloudFormationTemplateResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_applicationId;

  Aws::String m_creationTime;

  Aws::String m_expirationTime;

  Aws::String m_semanticVersion;

  Status m_status{Status::NOT_SET};

  Aws::String m_templateId;

  Aws::String m_templateUrl;

  Aws::String m_requestId;
  bool m_applicationIdHasBeenSet = false;
  bool m_creationTimeHasBeenSet = false;
  bool m_expirationTimeHasBeenSet = false;
  bool m_semanticVersionHasBeenSet = false;
  bool m_statusHasBeenSet = false;
  bool m_templateIdHasBeenSet = false;
  bool m_templateUrlHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace ServerlessApplicationRepository
}  // namespace Aws
