﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/servicecatalog/ServiceCatalogRequest.h>
#include <aws/servicecatalog/ServiceCatalog_EXPORTS.h>
#include <aws/servicecatalog/model/PrincipalType.h>

#include <utility>

namespace Aws {
namespace ServiceCatalog {
namespace Model {

/**
 */
class DisassociatePrincipalFromPortfolioRequest : public ServiceCatalogRequest {
 public:
  AWS_SERVICECATALOG_API DisassociatePrincipalFromPortfolioRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "DisassociatePrincipalFromPortfolio"; }

  AWS_SERVICECATALOG_API Aws::String SerializePayload() const override;

  AWS_SERVICECATALOG_API Aws::Http::HeaderValueCollection GetRequestSpecificHeaders() const override;

  ///@{
  /**
   * <p>The language code.</p> <ul> <li> <p> <code>jp</code> - Japanese</p> </li>
   * <li> <p> <code>zh</code> - Chinese</p> </li> </ul>
   */
  inline const Aws::String& GetAcceptLanguage() const { return m_acceptLanguage; }
  inline bool AcceptLanguageHasBeenSet() const { return m_acceptLanguageHasBeenSet; }
  template <typename AcceptLanguageT = Aws::String>
  void SetAcceptLanguage(AcceptLanguageT&& value) {
    m_acceptLanguageHasBeenSet = true;
    m_acceptLanguage = std::forward<AcceptLanguageT>(value);
  }
  template <typename AcceptLanguageT = Aws::String>
  DisassociatePrincipalFromPortfolioRequest& WithAcceptLanguage(AcceptLanguageT&& value) {
    SetAcceptLanguage(std::forward<AcceptLanguageT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The portfolio identifier.</p>
   */
  inline const Aws::String& GetPortfolioId() const { return m_portfolioId; }
  inline bool PortfolioIdHasBeenSet() const { return m_portfolioIdHasBeenSet; }
  template <typename PortfolioIdT = Aws::String>
  void SetPortfolioId(PortfolioIdT&& value) {
    m_portfolioIdHasBeenSet = true;
    m_portfolioId = std::forward<PortfolioIdT>(value);
  }
  template <typename PortfolioIdT = Aws::String>
  DisassociatePrincipalFromPortfolioRequest& WithPortfolioId(PortfolioIdT&& value) {
    SetPortfolioId(std::forward<PortfolioIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The ARN of the principal (user, role, or group). This field allows an ARN
   * with no <code>accountID</code> with or without wildcard characters if
   * <code>PrincipalType</code> is <code>IAM_PATTERN</code>.</p>
   */
  inline const Aws::String& GetPrincipalARN() const { return m_principalARN; }
  inline bool PrincipalARNHasBeenSet() const { return m_principalARNHasBeenSet; }
  template <typename PrincipalARNT = Aws::String>
  void SetPrincipalARN(PrincipalARNT&& value) {
    m_principalARNHasBeenSet = true;
    m_principalARN = std::forward<PrincipalARNT>(value);
  }
  template <typename PrincipalARNT = Aws::String>
  DisassociatePrincipalFromPortfolioRequest& WithPrincipalARN(PrincipalARNT&& value) {
    SetPrincipalARN(std::forward<PrincipalARNT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The supported value is <code>IAM</code> if you use a fully defined ARN, or
   * <code>IAM_PATTERN</code> if you specify an <code>IAM</code> ARN with no
   * AccountId, with or without wildcard characters. </p>
   */
  inline PrincipalType GetPrincipalType() const { return m_principalType; }
  inline bool PrincipalTypeHasBeenSet() const { return m_principalTypeHasBeenSet; }
  inline void SetPrincipalType(PrincipalType value) {
    m_principalTypeHasBeenSet = true;
    m_principalType = value;
  }
  inline DisassociatePrincipalFromPortfolioRequest& WithPrincipalType(PrincipalType value) {
    SetPrincipalType(value);
    return *this;
  }
  ///@}
 private:
  Aws::String m_acceptLanguage;

  Aws::String m_portfolioId;

  Aws::String m_principalARN;

  PrincipalType m_principalType{PrincipalType::NOT_SET};
  bool m_acceptLanguageHasBeenSet = false;
  bool m_portfolioIdHasBeenSet = false;
  bool m_principalARNHasBeenSet = false;
  bool m_principalTypeHasBeenSet = false;
};

}  // namespace Model
}  // namespace ServiceCatalog
}  // namespace Aws
