﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/wisdom/ConnectWisdomService_EXPORTS.h>
#include <aws/wisdom/model/FilterField.h>
#include <aws/wisdom/model/FilterOperator.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace ConnectWisdomService {
namespace Model {

/**
 * <p>A search filter.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/wisdom-2020-10-19/Filter">AWS API
 * Reference</a></p>
 */
class Filter {
 public:
  AWS_CONNECTWISDOMSERVICE_API Filter() = default;
  AWS_CONNECTWISDOMSERVICE_API Filter(Aws::Utils::Json::JsonView jsonValue);
  AWS_CONNECTWISDOMSERVICE_API Filter& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_CONNECTWISDOMSERVICE_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The field on which to filter.</p>
   */
  inline FilterField GetField() const { return m_field; }
  inline bool FieldHasBeenSet() const { return m_fieldHasBeenSet; }
  inline void SetField(FilterField value) {
    m_fieldHasBeenSet = true;
    m_field = value;
  }
  inline Filter& WithField(FilterField value) {
    SetField(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The operator to use for comparing the field’s value with the provided
   * value.</p>
   */
  inline FilterOperator GetOperator() const { return m_operator; }
  inline bool OperatorHasBeenSet() const { return m_operatorHasBeenSet; }
  inline void SetOperator(FilterOperator value) {
    m_operatorHasBeenSet = true;
    m_operator = value;
  }
  inline Filter& WithOperator(FilterOperator value) {
    SetOperator(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The desired field value on which to filter.</p>
   */
  inline const Aws::String& GetValue() const { return m_value; }
  inline bool ValueHasBeenSet() const { return m_valueHasBeenSet; }
  template <typename ValueT = Aws::String>
  void SetValue(ValueT&& value) {
    m_valueHasBeenSet = true;
    m_value = std::forward<ValueT>(value);
  }
  template <typename ValueT = Aws::String>
  Filter& WithValue(ValueT&& value) {
    SetValue(std::forward<ValueT>(value));
    return *this;
  }
  ///@}
 private:
  FilterField m_field{FilterField::NOT_SET};

  FilterOperator m_operator{FilterOperator::NOT_SET};

  Aws::String m_value;
  bool m_fieldHasBeenSet = false;
  bool m_operatorHasBeenSet = false;
  bool m_valueHasBeenSet = false;
};

}  // namespace Model
}  // namespace ConnectWisdomService
}  // namespace Aws
