﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/quicksight/QuickSight_EXPORTS.h>

namespace Aws {
namespace QuickSight {
namespace Model {
enum class ReferenceLinePatternType { NOT_SET, SOLID, DASHED, DOTTED };

namespace ReferenceLinePatternTypeMapper {
AWS_QUICKSIGHT_API ReferenceLinePatternType GetReferenceLinePatternTypeForName(const Aws::String& name);

AWS_QUICKSIGHT_API Aws::String GetNameForReferenceLinePatternType(ReferenceLinePatternType value);
}  // namespace ReferenceLinePatternTypeMapper
}  // namespace Model
}  // namespace QuickSight
}  // namespace Aws
