/*
 * Decompiled with CFR 0.152.
 */
package org.a11y.brlapi;

import java.util.Arrays;
import org.a11y.brlapi.Component;

public class BitMask
extends Component {
    private static final int BYTE_SIZE = 8;
    private final byte[] maskBytes;
    private final int maskSize;
    private int[] bitNumbers = null;

    public BitMask(byte[] byArray) {
        this.maskBytes = byArray;
        this.maskSize = this.maskBytes.length * 8;
    }

    public int getSize() {
        return this.maskSize;
    }

    public boolean isSet(int n) {
        int n2;
        if (n < 0) {
            return false;
        }
        if (n >= this.maskSize) {
            return false;
        }
        return (this.maskBytes[n /= 8] & (n2 = 1 << n % 8)) != 0;
    }

    private final int[] newBitNumbers() {
        int n = this.getSize();
        int[] nArray = new int[n];
        int n2 = 0;
        int n3 = 0;
        for (int n4 : this.maskBytes) {
            if ((n4 &= 0xFF) != 0) {
                int n5 = n3;
                while (true) {
                    if ((n4 & 1) != 0) {
                        nArray[n2++] = n5;
                    }
                    if ((n4 >>= 1) == 0) break;
                    ++n5;
                }
            }
            n3 += 8;
        }
        int[] nArray2 = new int[n2];
        System.arraycopy(nArray, 0, nArray2, 0, n2);
        return nArray2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int[] getBitNumbers() {
        BitMask bitMask = this;
        synchronized (bitMask) {
            if (this.bitNumbers == null) {
                this.bitNumbers = this.newBitNumbers();
            }
        }
        int n = this.bitNumbers.length;
        int[] nArray = new int[n];
        System.arraycopy(this.bitNumbers, 0, nArray, 0, n);
        return nArray;
    }

    public String toString() {
        return Arrays.toString(this.getBitNumbers());
    }
}

