/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.exec;

import java.net.Authenticator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPDataSourcePermission;
import org.jkiss.dbeaver.model.DBPErrorAssistant;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.connection.DBPConnectionType;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDAttributeBindingMeta;
import org.jkiss.dbeaver.model.data.DBDPseudoAttribute;
import org.jkiss.dbeaver.model.data.DBDPseudoAttributeType;
import org.jkiss.dbeaver.model.data.DBDPseudoReferrer;
import org.jkiss.dbeaver.model.data.DBDRowIdentifier;
import org.jkiss.dbeaver.model.edit.DBECommand;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.exec.DBCAttributeMetaData;
import org.jkiss.dbeaver.model.exec.DBCEntityMetaData;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCExecutionContextDefaults;
import org.jkiss.dbeaver.model.exec.DBCExecutionPurpose;
import org.jkiss.dbeaver.model.exec.DBCExecutionSource;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.dbeaver.model.exec.DBCTransactionManager;
import org.jkiss.dbeaver.model.impl.DBObjectNameCaseTransformer;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistActionComment;
import org.jkiss.dbeaver.model.messages.ModelMessages;
import org.jkiss.dbeaver.model.net.DBWForwarder;
import org.jkiss.dbeaver.model.net.DBWHandlerConfiguration;
import org.jkiss.dbeaver.model.net.DBWHandlerType;
import org.jkiss.dbeaver.model.net.DBWNetworkHandler;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.qm.QMUtils;
import org.jkiss.dbeaver.model.qm.meta.QMMConnectionInfo;
import org.jkiss.dbeaver.model.qm.meta.QMMStatementExecuteInfo;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableParametrized;
import org.jkiss.dbeaver.model.runtime.LocalCacheProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.sql.SQLQuery;
import org.jkiss.dbeaver.model.sql.SQLSelectItem;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.model.struct.DBSDataManipulator;
import org.jkiss.dbeaver.model.struct.DBSDataType;
import org.jkiss.dbeaver.model.struct.DBSDocumentConstraint;
import org.jkiss.dbeaver.model.struct.DBSDocumentContainer;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAssociation;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSEntityAttributeRef;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraint;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraintType;
import org.jkiss.dbeaver.model.struct.DBSEntityReferrer;
import org.jkiss.dbeaver.model.struct.DBSInstance;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.model.struct.DBSTypedObjectEx;
import org.jkiss.dbeaver.model.struct.rdb.DBSCatalog;
import org.jkiss.dbeaver.model.struct.rdb.DBSSchema;
import org.jkiss.dbeaver.model.struct.rdb.DBSTable;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableIndex;
import org.jkiss.dbeaver.model.virtual.DBVEntity;
import org.jkiss.dbeaver.model.virtual.DBVEntityConstraint;
import org.jkiss.dbeaver.model.virtual.DBVUtils;
import org.jkiss.dbeaver.runtime.net.GlobalProxyAuthenticator;
import org.jkiss.dbeaver.runtime.ui.DBPPlatformUI;
import org.jkiss.utils.CommonUtils;

public class DBExecUtils {
    public static final int DEFAULT_READ_FETCH_SIZE = 10000;
    private static final Log log = Log.getLog(DBExecUtils.class);
    private static final ThreadLocal<DBPDataSourceContainer> ACTIVE_CONTEXT = new ThreadLocal();
    private static final List<DBPDataSourceContainer> ACTIVE_CONTEXTS = new ArrayList<DBPDataSourceContainer>();
    public static final boolean BROWSE_LAZY_ASSOCIATIONS = false;
    private static final ThreadLocal<RecoveryState> recoveryStack = new ThreadLocal();
    private static volatile /* synthetic */ int[] $SWITCH_TABLE$org$jkiss$dbeaver$runtime$ui$DBPPlatformUI$UserResponse;

    public static DBPDataSourceContainer getCurrentThreadContext() {
        return ACTIVE_CONTEXT.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<DBPDataSourceContainer> getActiveContexts() {
        List<DBPDataSourceContainer> list = ACTIVE_CONTEXTS;
        synchronized (list) {
            return new ArrayList<DBPDataSourceContainer>(ACTIVE_CONTEXTS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void startContextInitiation(DBPDataSourceContainer context) {
        ACTIVE_CONTEXT.set(context);
        List<DBPDataSourceContainer> list = ACTIVE_CONTEXTS;
        synchronized (list) {
            ACTIVE_CONTEXTS.add(context);
        }
        boolean hasProxy = false;
        for (DBWHandlerConfiguration handler : context.getConnectionConfiguration().getHandlers()) {
            if (!handler.isEnabled() || handler.getType() != DBWHandlerType.PROXY) continue;
            hasProxy = true;
            break;
        }
        if (hasProxy) {
            Authenticator.setDefault(new GlobalProxyAuthenticator());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void finishContextInitiation(DBPDataSourceContainer context) {
        ACTIVE_CONTEXT.remove();
        List<DBPDataSourceContainer> list = ACTIVE_CONTEXTS;
        synchronized (list) {
            ACTIVE_CONTEXTS.remove(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DBPDataSourceContainer findConnectionContext(String host, int port, String path) {
        DBPDataSourceContainer curContext = DBExecUtils.getCurrentThreadContext();
        if (curContext != null) {
            return DBExecUtils.contextMatches(host, port, curContext) ? curContext : null;
        }
        List<DBPDataSourceContainer> list = ACTIVE_CONTEXTS;
        synchronized (list) {
            for (DBPDataSourceContainer ctx : ACTIVE_CONTEXTS) {
                if (!DBExecUtils.contextMatches(host, port, ctx)) continue;
                return ctx;
            }
        }
        return null;
    }

    private static boolean contextMatches(String host, int port, DBPDataSourceContainer ctx) {
        DBPConnectionConfiguration cfg = ctx.getConnectionConfiguration();
        if (CommonUtils.equalObjects((Object)cfg.getHostName(), (Object)host) && String.valueOf(port).equals(cfg.getHostPort())) {
            return true;
        }
        DBWNetworkHandler[] dBWNetworkHandlerArray = ctx.getActiveNetworkHandlers();
        int n = dBWNetworkHandlerArray.length;
        int n2 = 0;
        while (n2 < n) {
            DBWNetworkHandler networkHandler = dBWNetworkHandlerArray[n2];
            if (networkHandler instanceof DBWForwarder && ((DBWForwarder)((Object)networkHandler)).matchesParameters(host, port)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @NotNull
    public static DBPErrorAssistant.ErrorType discoverErrorType(@NotNull DBPDataSource dataSource, @NotNull Throwable error) {
        DBPErrorAssistant errorAssistant = DBUtils.getAdapter(DBPErrorAssistant.class, dataSource);
        if (errorAssistant != null) {
            return ((DBPErrorAssistant)((Object)dataSource)).discoverErrorType(error);
        }
        return DBPErrorAssistant.ErrorType.NORMAL;
    }

    /*
     * Exception decompiling
     */
    public static <T> boolean tryExecuteRecover(@NotNull T param, @NotNull DBPDataSource dataSource, @NotNull DBRRunnableParametrized<T> runnable) throws DBException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void setStatementFetchSize(DBCStatement dbStat, long firstRow, long maxRows, int fetchSize) {
        boolean useFetchSize;
        boolean bl = useFetchSize = fetchSize > 0 || dbStat.getSession().getDataSource().getContainer().getPreferenceStore().getBoolean("resultset.fetch.size");
        if (useFetchSize) {
            if (fetchSize <= 0) {
                fetchSize = 10000;
            }
            try {
                dbStat.setResultsFetchSize(firstRow < 0L || maxRows <= 0L ? fetchSize : (int)(firstRow + maxRows));
            }
            catch (Exception e) {
                log.warn(e);
            }
        }
    }

    public static void executeScript(DBRProgressMonitor monitor, DBCExecutionContext executionContext, String jobName, List<DBEPersistAction> persistActions) throws DBException {
        Throwable throwable = null;
        Object var5_6 = null;
        try (DBCSession session = executionContext.openSession(monitor, DBCExecutionPurpose.UTIL, jobName);){
            DBExecUtils.executeScript(session, persistActions.toArray(new DBEPersistAction[0]));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    /*
     * Exception decompiling
     */
    public static void executeScript(DBCSession session, DBEPersistAction[] persistActions) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void executePersistActions(DBCSession session, DBEPersistAction[] persistActions) throws DBException {
        DBRProgressMonitor monitor = session.getProgressMonitor();
        monitor.beginTask(session.getTaskTitle(), persistActions.length);
        try {
            DBEPersistAction[] dBEPersistActionArray = persistActions;
            int n = persistActions.length;
            int n2 = 0;
            while (n2 < n) {
                DBEPersistAction action = dBEPersistActionArray[n2];
                if (monitor.isCanceled()) {
                    break;
                }
                if (!CommonUtils.isEmpty((String)action.getTitle())) {
                    monitor.subTask(action.getTitle());
                }
                DBExecUtils.executePersistAction(session, action);
                ++n2;
            }
        }
        finally {
            monitor.done();
        }
    }

    public static void executePersistAction(DBCSession session, DBEPersistAction action) throws DBException {
        if (action instanceof SQLDatabasePersistActionComment) {
            return;
        }
        String script = action.getScript();
        if (script == null) {
            action.afterExecute(session, null);
        } else {
            try {
                Throwable throwable = null;
                Object var4_6 = null;
                try (DBCStatement dbStat = DBUtils.createStatement(session, script, false);){
                    action.beforeExecute(session);
                    dbStat.executeStatement();
                    if (action instanceof SQLDatabasePersistAction) {
                        ((SQLDatabasePersistAction)action).afterExecute(session, dbStat, null);
                    } else {
                        action.afterExecute(session, null);
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (DBCException e) {
                action.afterExecute(session, e);
                throw e;
            }
        }
    }

    public static boolean checkSmartAutoCommit(DBCSession session, String queryText) {
        DBCTransactionManager txnManager = DBUtils.getTransactionManager(session.getExecutionContext());
        if (txnManager != null) {
            block7: {
                block6: {
                    if (txnManager.isAutoCommit()) break block6;
                    return false;
                }
                SQLDialect sqlDialect = SQLUtils.getDialectFromDataSource(session.getDataSource());
                if (sqlDialect.isTransactionModifyingQuery(queryText)) break block7;
                return false;
            }
            try {
                if (txnManager.isAutoCommit()) {
                    txnManager.setAutoCommit(session.getProgressMonitor(), false);
                    return true;
                }
            }
            catch (DBCException e) {
                log.warn(e);
            }
        }
        return false;
    }

    public static void setExecutionContextDefaults(DBRProgressMonitor monitor, DBPDataSource dataSource, DBCExecutionContext executionContext, @Nullable String newInstanceName, @Nullable String curInstanceName, @Nullable String newObjectName) throws DBException {
        DBSObjectContainer rootContainer = DBUtils.getAdapter(DBSObjectContainer.class, dataSource);
        if (rootContainer == null) {
            return;
        }
        DBCExecutionContextDefaults contextDefaults = null;
        if (executionContext != null) {
            contextDefaults = executionContext.getContextDefaults();
        }
        if (contextDefaults != null && (contextDefaults.supportsSchemaChange() || contextDefaults.supportsCatalogChange())) {
            DBExecUtils.changeDefaultObject(monitor, rootContainer, contextDefaults, newInstanceName, curInstanceName, newObjectName);
        }
    }

    public static void changeDefaultObject(@NotNull DBRProgressMonitor monitor, @NotNull DBSObjectContainer rootContainer, @NotNull DBCExecutionContextDefaults contextDefaults, @Nullable String newCatalogName, @Nullable String curCatalogName, @Nullable String newObjectName) throws DBException {
        boolean changeCatalog;
        DBSObject newInstance;
        DBSObjectContainer newCatalog = null;
        DBSSchema newSchema = null;
        if (newCatalogName != null && (newInstance = rootContainer.getChild(monitor, newCatalogName)) instanceof DBSCatalog) {
            newCatalog = (DBSCatalog)newInstance;
        }
        if (newObjectName != null) {
            DBSObject newObject = newCatalog == null ? rootContainer.getChild(monitor, newObjectName) : newCatalog.getChild(monitor, newObjectName);
            if (newObject instanceof DBSSchema) {
                newSchema = (DBSSchema)newObject;
            } else if (newObject instanceof DBSCatalog) {
                newCatalog = (DBSCatalog)newObject;
            }
        }
        boolean bl = curCatalogName != null ? !CommonUtils.equalObjects((Object)curCatalogName, (Object)newCatalogName) : (changeCatalog = newCatalog != null);
        if (newCatalog != null && newSchema != null && changeCatalog) {
            contextDefaults.setDefaultCatalog(monitor, newCatalog, contextDefaults.supportsSchemaChange() ? newSchema : null);
        } else if (newSchema != null && contextDefaults.supportsSchemaChange()) {
            contextDefaults.setDefaultSchema(monitor, newSchema);
        } else if (newCatalog != null && changeCatalog) {
            contextDefaults.setDefaultCatalog(monitor, newCatalog, null);
        }
    }

    public static void recoverSmartCommit(final DBCExecutionContext executionContext) {
        DBCTransactionManager transactionManager;
        boolean isRecoverSmartCommitEnable;
        boolean isSmartCommitEnable;
        DBPDataSourceContainer container = executionContext.getDataSource().getContainer();
        DBPPreferenceStore preferenceStore = container.getPreferenceStore();
        DBPConnectionType connectionType = container.getConnectionConfiguration().getConnectionType();
        boolean bl = isSmartCommitEnable = preferenceStore.contains("transaction.smart.commit") ? preferenceStore.getBoolean("transaction.smart.commit") : connectionType.isSmartCommit();
        if (!isSmartCommitEnable) {
            return;
        }
        boolean bl2 = isRecoverSmartCommitEnable = preferenceStore.contains("transaction.smart.commit.recover") ? preferenceStore.getBoolean("transaction.smart.commit.recover") : connectionType.isSmartCommitRecover();
        if (isRecoverSmartCommitEnable && (transactionManager = DBUtils.getTransactionManager(executionContext)) != null) {
            new AbstractJob("Recover smart commit mode"){

                @Override
                protected IStatus run(DBRProgressMonitor monitor) {
                    if (!executionContext.isConnected()) {
                        return Status.OK_STATUS;
                    }
                    try {
                        try {
                            monitor.beginTask("Switch to auto-commit mode", 1);
                            if (!transactionManager.isAutoCommit()) {
                                transactionManager.setAutoCommit(monitor, true);
                            }
                        }
                        catch (DBCException e) {
                            log.debug("Error recovering smart commit mode: " + e.getMessage());
                            monitor.done();
                        }
                    }
                    finally {
                        monitor.done();
                    }
                    return Status.OK_STATUS;
                }
            }.schedule();
        }
    }

    /*
     * WARNING - void declaration
     */
    public static DBSEntityConstraint getBestIdentifier(@Nullable DBRProgressMonitor monitor, @NotNull DBSEntity table, DBDAttributeBinding[] bindings) throws DBException {
        void var5_17;
        if (table instanceof DBSDocumentContainer) {
            return new DBSDocumentConstraint((DBSDocumentContainer)table);
        }
        ArrayList<DBSEntityConstraint> identifiers = new ArrayList<DBSEntityConstraint>(2);
        if (!(table instanceof DBSTable) || !((DBSTable)table).isView()) {
            block18: {
                if (table instanceof DBSTable) {
                    try {
                        Collection<? extends DBSTableIndex> indexes = ((DBSTable)table).getIndexes(monitor);
                        if (CommonUtils.isEmpty(indexes)) break block18;
                        for (DBSTableIndex dBSTableIndex : indexes) {
                            if (!dBSTableIndex.isPrimary() || !DBUtils.isIdentifierIndex(monitor, dBSTableIndex)) continue;
                            identifiers.add(dBSTableIndex);
                            break;
                        }
                        for (DBSTableIndex dBSTableIndex : indexes) {
                            if (!DBUtils.isIdentifierIndex(monitor, dBSTableIndex) || identifiers.contains(dBSTableIndex)) continue;
                            identifiers.add(dBSTableIndex);
                            break;
                        }
                    }
                    catch (Exception e) {
                        log.debug("Error reading table indexes: " + e.getMessage());
                    }
                }
            }
            try {
                Collection<? extends DBSEntityConstraint> constraints = table.getConstraints(monitor);
                if (constraints != null) {
                    for (DBSEntityConstraint dBSEntityConstraint : constraints) {
                        if (!DBUtils.isIdentifierConstraint(monitor, dBSEntityConstraint)) continue;
                        identifiers.add(dBSEntityConstraint);
                    }
                }
            }
            catch (Exception e) {
                log.debug("Error reading table constraints: " + e.getMessage());
            }
        }
        if (!CommonUtils.isEmpty(identifiers)) {
            DBSEntityConstraint uniqueId = null;
            for (DBSEntityConstraint dBSEntityConstraint : identifiers) {
                if (dBSEntityConstraint instanceof DBSEntityReferrer) {
                    DBSEntityReferrer referrer = (DBSEntityReferrer)dBSEntityConstraint;
                    if (!DBExecUtils.isGoodReferrer(monitor, bindings, referrer)) continue;
                    if (referrer.getConstraintType() == DBSEntityConstraintType.PRIMARY_KEY) {
                        return referrer;
                    }
                    if (uniqueId != null || !referrer.getConstraintType().isUnique() && (!(referrer instanceof DBSTableIndex) || !((DBSTableIndex)referrer).isUnique())) continue;
                    uniqueId = referrer;
                    continue;
                }
                uniqueId = dBSEntityConstraint;
            }
            if (uniqueId != null) {
                return uniqueId;
            }
        }
        DBDAttributeBinding[] dBDAttributeBindingArray = bindings;
        int n = bindings.length;
        boolean bl = false;
        while (var5_17 < n) {
            DBDPseudoAttribute pseudoAttribute;
            DBDAttributeBinding column = dBDAttributeBindingArray[var5_17];
            DBDPseudoAttribute dBDPseudoAttribute = pseudoAttribute = column instanceof DBDAttributeBindingMeta ? ((DBDAttributeBindingMeta)column).getPseudoAttribute() : null;
            if (pseudoAttribute != null && pseudoAttribute.getType() == DBDPseudoAttributeType.ROWID) {
                return new DBDPseudoReferrer(table, column);
            }
            ++var5_17;
        }
        DBVEntity virtualEntity = DBVUtils.getVirtualEntity(table, true);
        return virtualEntity.getBestIdentifier();
    }

    private static boolean isGoodReferrer(DBRProgressMonitor monitor, DBDAttributeBinding[] bindings, DBSEntityReferrer referrer) throws DBException {
        if (referrer instanceof DBDPseudoReferrer) {
            return true;
        }
        List<? extends DBSEntityAttributeRef> references = referrer.getAttributeReferences(monitor);
        if (references == null || references.isEmpty()) {
            return referrer instanceof DBVEntityConstraint;
        }
        for (DBSEntityAttributeRef dBSEntityAttributeRef : references) {
            boolean refMatches = false;
            DBDAttributeBinding[] dBDAttributeBindingArray = bindings;
            int n = bindings.length;
            int n2 = 0;
            while (n2 < n) {
                DBDAttributeBinding binding = dBDAttributeBindingArray[n2];
                if (binding.matches(dBSEntityAttributeRef.getAttribute(), false)) {
                    refMatches = true;
                    break;
                }
                ++n2;
            }
            if (refMatches) continue;
            return false;
        }
        return true;
    }

    public static DBSEntityAssociation getAssociationByAttribute(DBDAttributeBinding attr) throws DBException {
        List<DBSEntityReferrer> referrers = attr.getReferrers();
        if (referrers != null) {
            for (DBSEntityReferrer referrer : referrers) {
                if (!(referrer instanceof DBSEntityAssociation)) continue;
                return (DBSEntityAssociation)((Object)referrer);
            }
        }
        throw new DBException("Association not found in attribute [" + attr.getName() + "]");
    }

    public static boolean equalAttributes(DBCAttributeMetaData attr1, DBCAttributeMetaData attr2) {
        return attr1 != null && attr2 != null && SQLUtils.compareAliases(attr1.getLabel(), attr2.getLabel()) && SQLUtils.compareAliases(attr1.getName(), attr2.getName()) && CommonUtils.equalObjects((Object)attr1.getEntityMetaData(), (Object)attr2.getEntityMetaData()) && attr1.getOrdinalPosition() == attr2.getOrdinalPosition() && attr1.isRequired() == attr2.isRequired() && attr1.getMaxLength() == attr2.getMaxLength() && CommonUtils.equalObjects((Object)attr1.getPrecision(), (Object)attr2.getPrecision()) && CommonUtils.equalObjects((Object)attr1.getScale(), (Object)attr2.getScale()) && attr1.getTypeID() == attr2.getTypeID() && CommonUtils.equalObjects((Object)attr1.getTypeName(), (Object)attr2.getTypeName());
    }

    public static double makeNumericValue(Object value) {
        if (value == null) {
            return 0.0;
        }
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        if (value instanceof Date) {
            return ((Date)value).getTime();
        }
        if (value instanceof String) {
            try {
                return Double.parseDouble((String)value);
            }
            catch (NumberFormatException numberFormatException) {
                return 0.0;
            }
        }
        return 0.0;
    }

    public static void bindAttributes(@NotNull DBCSession session, @Nullable DBSEntity sourceEntity, @Nullable DBCResultSet resultSet, @NotNull DBDAttributeBinding[] bindings, @Nullable List<Object[]> rows) throws DBException {
        DBRProgressMonitor monitor = session.getProgressMonitor();
        DBPDataSource dataSource = session.getDataSource();
        DBPDataSourceContainer container = dataSource.getContainer();
        DBRProgressMonitor mdMonitor = container.isExtraMetadataReadEnabled() ? monitor : new LocalCacheProgressMonitor(monitor);
        IdentityHashMap<DBCEntityMetaData, DBSEntity> entityBindingMap = new IdentityHashMap<DBCEntityMetaData, DBSEntity>();
        monitor.beginTask("Discover resultset metadata", 3);
        try {
            DBCStatement sourceStatement;
            SQLQuery sqlQuery = null;
            DBSEntity entity = null;
            int queryEntityMetaScore = -1;
            if (sourceEntity != null) {
                entity = sourceEntity;
            } else if (resultSet != null && (sourceStatement = resultSet.getSourceStatement()) != null && sourceStatement.getStatementSource() != null) {
                DBCExecutionSource executionSource = sourceStatement.getStatementSource();
                monitor.subTask("Discover owner entity");
                DBSDataContainer dataContainer = executionSource.getDataContainer();
                if (dataContainer instanceof DBSEntity) {
                    entity = (DBSEntity)((Object)dataContainer);
                }
                DBCEntityMetaData entityMeta = null;
                if (entity == null) {
                    Object sourceDescriptor = executionSource.getSourceDescriptor();
                    if (sourceDescriptor instanceof SQLQuery) {
                        sqlQuery = (SQLQuery)sourceDescriptor;
                        entityMeta = sqlQuery.getEntityMetadata(false);
                    }
                    if (entityMeta != null && (entity = DBUtils.getEntityFromMetaData(mdMonitor, session.getExecutionContext(), entityMeta)) != null) {
                        queryEntityMetaScore = entityMeta.getCompleteScore();
                        entityBindingMap.put(entityMeta, entity);
                    }
                }
            }
            boolean needsTableMetaForColumnResolution = dataSource.getInfo().needsTableMetaForColumnResolution();
            monitor.subTask("Discover attributes");
            DBDAttributeBinding[] dBDAttributeBindingArray = bindings;
            int n = bindings.length;
            int dataContainer = 0;
            while (dataContainer < n) {
                DBDAttributeBinding binding = dBDAttributeBindingArray[dataContainer];
                monitor.subTask("Discover attribute '" + binding.getName() + "'");
                DBCAttributeMetaData attrMeta = binding.getMetaAttribute();
                if (attrMeta != null) {
                    SQLSelectItem selectItem = sqlQuery == null ? null : sqlQuery.getSelectItem(attrMeta.getOrdinalPosition());
                    DBSEntity attrEntity = null;
                    if (sourceEntity == null) {
                        DBCEntityMetaData attrEntityMeta = attrMeta.getEntityMetaData();
                        if (attrEntityMeta == null && sqlQuery != null && selectItem != null && selectItem.isPlainColumn()) {
                            attrEntityMeta = selectItem.getEntityMetaData();
                        }
                        if (attrEntityMeta != null) {
                            attrEntity = (DBSEntity)entityBindingMap.get(attrEntityMeta);
                            if (attrEntity == null) {
                                if (entity != null && (queryEntityMetaScore > attrEntityMeta.getCompleteScore() || DBUtils.isView(entity))) {
                                    attrEntity = entity;
                                } else {
                                    attrEntity = DBUtils.getEntityFromMetaData(mdMonitor, session.getExecutionContext(), attrEntityMeta);
                                    if (attrEntity == null && !mdMonitor.isForceCacheUsage()) {
                                        log.debug("Table '" + DBUtils.getSimpleQualifiedName(attrEntityMeta.getCatalogName(), attrEntityMeta.getSchemaName(), attrEntityMeta.getEntityName()) + "' not found in metadata catalog");
                                    }
                                }
                            }
                            if (attrEntity != null) {
                                entityBindingMap.put(attrEntityMeta, attrEntity);
                            }
                        }
                    }
                    if (attrEntity == null) {
                        attrEntity = entity;
                    }
                    if (attrEntity != null && binding instanceof DBDAttributeBindingMeta) {
                        DBDPseudoAttribute pseudoAttribute;
                        String realColumnName;
                        int asteriskIndex;
                        DBDAttributeBindingMeta bindingMeta = (DBDAttributeBindingMeta)binding;
                        boolean updateColumnMeta = sourceEntity != null || bindingMeta.getMetaAttribute().getEntityMetaData() != null || !needsTableMetaForColumnResolution;
                        String columnName = attrMeta.getName();
                        if (sqlQuery != null && updateColumnMeta && CommonUtils.equalObjects((Object)columnName, (Object)attrMeta.getLabel()) && ((asteriskIndex = sqlQuery.getSelectItemAsteriskIndex()) < 0 || asteriskIndex > attrMeta.getOrdinalPosition()) && attrMeta.getOrdinalPosition() < sqlQuery.getSelectItemCount() && selectItem != null && selectItem.isPlainColumn() && !(realColumnName = selectItem.getName()).equalsIgnoreCase(columnName)) {
                            columnName = DBUtils.isQuotedIdentifier(dataSource, realColumnName) ? DBUtils.getUnQuotedIdentifier(dataSource, realColumnName) : DBObjectNameCaseTransformer.transformName(dataSource, realColumnName);
                        }
                        if ((pseudoAttribute = DBUtils.getPseudoAttribute(attrEntity, columnName)) != null) {
                            bindingMeta.setPseudoAttribute(pseudoAttribute);
                        }
                        DBSEntityAttribute tableColumn = null;
                        if (bindingMeta.getPseudoAttribute() != null) {
                            tableColumn = bindingMeta.getPseudoAttribute().createFakeAttribute(attrEntity, attrMeta);
                        } else if (columnName != null) {
                            if (sqlQuery == null) {
                                tableColumn = attrEntity.getAttribute(mdMonitor, columnName);
                            } else {
                                boolean isAllColumns;
                                boolean bl = isAllColumns = sqlQuery.getSelectItemAsteriskIndex() != -1;
                                if (isAllColumns || selectItem != null && (selectItem.isPlainColumn() || selectItem.getName().equals("*"))) {
                                    tableColumn = attrEntity.getAttribute(mdMonitor, columnName);
                                }
                            }
                        }
                        if (tableColumn != null) {
                            DBCAttributeMetaData metaAttr;
                            boolean updateColumnHandler = updateColumnMeta && rows != null && (sqlQuery == null || !DBDAttributeBindingMeta.haveEqualsTypes(tableColumn, attrMeta));
                            DBCAttributeMetaData dBCAttributeMetaData = metaAttr = resultSet != null ? resultSet.getMeta().getAttributes().get(attrMeta.getOrdinalPosition()) : null;
                            if (!updateColumnHandler && bindingMeta.getDataKind() != tableColumn.getDataKind() || resultSet != null && CommonUtils.isEmpty((String)metaAttr.getEntityName()) && !DBExecUtils.isSameDataTypes(tableColumn, metaAttr)) {
                                log.debug("Cannot bind attribute '" + bindingMeta.getName() + "'");
                            } else if (bindingMeta.setEntityAttribute(tableColumn, updateColumnHandler) && rows != null) {
                                try {
                                    int pos = attrMeta.getOrdinalPosition();
                                    for (Object[] row : rows) {
                                        row[pos] = binding.getValueHandler().getValueFromObject(session, tableColumn, row[pos], false, false);
                                    }
                                }
                                catch (DBCException e) {
                                    log.warn("Error resolving attribute '" + binding.getName() + "' values", e);
                                }
                            }
                        }
                    }
                }
                ++dataContainer;
            }
            monitor.worked(1);
            monitor.subTask("Detect unique identifiers");
            Map<DBSEntity, DBDRowIdentifier> locatorMap = DBExecUtils.bindUniqueIdentifiers(bindings, mdMonitor);
            monitor.worked(1);
            if (rows != null && !mdMonitor.isForceCacheUsage()) {
                monitor.subTask("Read results metadata");
                DBDAttributeBinding[] dBDAttributeBindingArray2 = bindings;
                int n2 = bindings.length;
                n = 0;
                while (n < n2) {
                    DBDAttributeBinding binding = dBDAttributeBindingArray2[n];
                    binding.lateBinding(session, rows);
                    ++n;
                }
            }
            monitor.subTask("Complete metadata load");
            for (DBDRowIdentifier rowIdentifier : locatorMap.values()) {
                rowIdentifier.reloadAttributes(mdMonitor, bindings);
            }
        }
        finally {
            monitor.done();
        }
    }

    @NotNull
    public static Map<DBSEntity, DBDRowIdentifier> bindUniqueIdentifiers(@NotNull DBDAttributeBinding[] bindings, @NotNull DBRProgressMonitor mdMonitor) throws DBException {
        IdentityHashMap<DBSEntity, DBDRowIdentifier> locatorMap = new IdentityHashMap<DBSEntity, DBDRowIdentifier>();
        DBDAttributeBinding[] dBDAttributeBindingArray = bindings;
        int n = bindings.length;
        int n2 = 0;
        while (n2 < n) {
            DBDAttributeBinding binding = dBDAttributeBindingArray[n2];
            if (binding instanceof DBDAttributeBindingMeta) {
                DBDAttributeBindingMeta bindingMeta = (DBDAttributeBindingMeta)binding;
                DBSEntityAttribute attr = binding.getEntityAttribute();
                if (attr == null) {
                    bindingMeta.setRowIdentifierStatus(ModelMessages.no_corresponding_table_column_text);
                } else {
                    DBSEntity attrEntity = attr.getParentObject();
                    if (attrEntity != null) {
                        DBDRowIdentifier rowIdentifier = (DBDRowIdentifier)locatorMap.get(attrEntity);
                        if (rowIdentifier == null) {
                            DBSEntityConstraint entityIdentifier = DBExecUtils.getBestIdentifier(mdMonitor, attrEntity, bindings);
                            if (entityIdentifier != null) {
                                rowIdentifier = new DBDRowIdentifier(attrEntity, entityIdentifier);
                                locatorMap.put(attrEntity, rowIdentifier);
                            } else {
                                bindingMeta.setRowIdentifierStatus(ModelMessages.cannot_determine_unique_row_identifier_text);
                            }
                        }
                        bindingMeta.setRowIdentifier(rowIdentifier);
                    }
                }
            }
            ++n2;
        }
        return locatorMap;
    }

    private static boolean isSameDataTypes(@NotNull DBSEntityAttribute tableColumn, @NotNull DBCAttributeMetaData resultSetAttributeMeta) {
        DBSDataType columnDataType;
        if (tableColumn instanceof DBSTypedObjectEx && (columnDataType = ((DBSTypedObjectEx)((Object)tableColumn)).getDataType()) != null) {
            return columnDataType.isStructurallyConsistentTypeWith(resultSetAttributeMeta);
        }
        return tableColumn.getDataKind().isComplex() == resultSetAttributeMeta.getDataKind().isComplex();
    }

    public static boolean isAttributeReadOnly(@Nullable DBDAttributeBinding attribute) {
        return DBExecUtils.isAttributeReadOnly(attribute, false);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isAttributeReadOnly(@Nullable DBDAttributeBinding attribute, boolean checkValidKey) {
        void dataContainer;
        DBSEntity dBSEntity;
        if (attribute == null || attribute.getMetaAttribute() == null || attribute.getMetaAttribute().isReadOnly()) {
            return true;
        }
        DBDRowIdentifier rowIdentifier = attribute.getRowIdentifier();
        if (rowIdentifier == null || !((dBSEntity = rowIdentifier.getEntity()) instanceof DBSDataManipulator)) {
            return true;
        }
        DBSDataManipulator dBSDataManipulator = (DBSDataManipulator)((Object)dBSEntity);
        if (checkValidKey && rowIdentifier.isIncomplete()) {
            return true;
        }
        return !dataContainer.isFeatureSupported("data.update");
    }

    public static String getAttributeReadOnlyStatus(@NotNull DBDAttributeBinding attribute) {
        return DBExecUtils.getAttributeReadOnlyStatus(attribute, true);
    }

    public static String getAttributeReadOnlyStatus(@NotNull DBDAttributeBinding attribute, boolean checkValidKey) {
        if (attribute == null || attribute.getMetaAttribute() == null) {
            return "Null meta attribute";
        }
        if (attribute.getMetaAttribute().isReadOnly()) {
            return "Attribute is read-only";
        }
        DBDRowIdentifier rowIdentifier = attribute.getRowIdentifier();
        if (rowIdentifier == null) {
            String status = attribute.getRowIdentifierStatus();
            return status != null ? status : "No row identifier found";
        }
        if (checkValidKey && rowIdentifier.isIncomplete()) {
            return "No valid row identifier found";
        }
        DBSEntity dataContainer = rowIdentifier.getEntity();
        if (!(dataContainer instanceof DBSDataManipulator)) {
            return "Underlying entity doesn't support data modification";
        }
        if (!((DBSDataManipulator)((Object)dataContainer)).isFeatureSupported("data.update")) {
            return "Underlying entity doesn't support data update";
        }
        return null;
    }

    public static boolean isResultSetReadOnly(@Nullable DBCExecutionContext executionContext) {
        return executionContext == null || !executionContext.isConnected() || !executionContext.getDataSource().getContainer().hasModifyPermission(DBPDataSourcePermission.PERMISSION_EDIT_DATA) || executionContext.getDataSource().getInfo().isReadOnlyData();
    }

    @Nullable
    public static String getResultSetReadOnlyStatus(@Nullable DBPDataSourceContainer container) {
        DBPDataSource dataSource;
        DBPDataSource dBPDataSource = dataSource = container == null ? null : container.getDataSource();
        if (dataSource == null || !container.isConnected()) {
            return "No connection to database";
        }
        if (container.isConnectionReadOnly()) {
            return "Connection is in read-only state";
        }
        if (dataSource.getInfo().isReadOnlyData()) {
            return "Read-only data container";
        }
        if (!container.hasModifyPermission(DBPDataSourcePermission.PERMISSION_EDIT_DATA)) {
            return "Data edit restricted";
        }
        return null;
    }

    public static List<DBEPersistAction> getActionsListFromCommandContext(@NotNull DBRProgressMonitor monitor, DBECommandContext commandContext, DBCExecutionContext executionContext, Map<String, Object> options, @Nullable List<DBEPersistAction> actions) throws DBException {
        if (actions == null) {
            actions = new ArrayList<DBEPersistAction>();
        }
        for (DBECommand<?> cmd : commandContext.getFinalCommands()) {
            DBEPersistAction[] persistActions = cmd.getPersistActions(monitor, executionContext, options);
            if (persistActions == null) continue;
            Collections.addAll(actions, persistActions);
        }
        return actions;
    }

    @Nullable
    public static DBSEntity detectSingleSourceTable(DBDAttributeBinding ... attributes) {
        DBSEntity sourceTable = null;
        DBDAttributeBinding[] dBDAttributeBindingArray = attributes;
        int n = attributes.length;
        int n2 = 0;
        while (n2 < n) {
            DBDRowIdentifier rowIdentifier;
            DBDAttributeBinding attribute = dBDAttributeBindingArray[n2];
            if (!attribute.isPseudoAttribute() && (rowIdentifier = attribute.getRowIdentifier()) != null) {
                if (sourceTable == null) {
                    sourceTable = rowIdentifier.getEntity();
                } else if (sourceTable != rowIdentifier.getEntity()) {
                    return null;
                }
            }
            ++n2;
        }
        return sourceTable;
    }

    public static boolean isExecutionInProgress(@NotNull DBPDataSource dataSource) {
        for (DBSInstance dBSInstance : dataSource.getAvailableInstances()) {
            DBCExecutionContext[] dBCExecutionContextArray = dBSInstance.getAllContexts();
            int n = dBCExecutionContextArray.length;
            int n2 = 0;
            while (n2 < n) {
                QMMStatementExecuteInfo lastExec;
                DBCExecutionContext context = dBCExecutionContextArray[n2];
                QMMConnectionInfo qmConnection = QMUtils.getCurrentConnection(context);
                if (qmConnection != null && (lastExec = qmConnection.getExecutionStack()) != null && !lastExec.isClosed()) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    static /* synthetic */ int[] $SWITCH_TABLE$org$jkiss$dbeaver$runtime$ui$DBPPlatformUI$UserResponse() {
        if ($SWITCH_TABLE$org$jkiss$dbeaver$runtime$ui$DBPPlatformUI$UserResponse != null) {
            return $SWITCH_TABLE$org$jkiss$dbeaver$runtime$ui$DBPPlatformUI$UserResponse;
        }
        int[] nArray = new int[DBPPlatformUI.UserResponse.values().length];
        try {
            nArray[DBPPlatformUI.UserResponse.CANCEL.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DBPPlatformUI.UserResponse.IGNORE.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DBPPlatformUI.UserResponse.IGNORE_ALL.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DBPPlatformUI.UserResponse.OK.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DBPPlatformUI.UserResponse.RETRY.ordinal()] = 6;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DBPPlatformUI.UserResponse.STOP.ordinal()] = 5;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$org$jkiss$dbeaver$runtime$ui$DBPPlatformUI$UserResponse = nArray;
        return nArray;
    }

    private static class RecoveryState {
        int recoveryDepth;
        boolean recoveryFailed;

        private RecoveryState() {
        }
    }
}

