/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.generator;

import java.util.Collection;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.generator.SQLGeneratorTable;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.utils.CommonUtils;

public class SQLGeneratorMerge
extends SQLGeneratorTable {
    @Override
    public void generateSQL(DBRProgressMonitor monitor, StringBuilder sql, DBSEntity object) throws DBException {
        boolean hasAttr = false;
        sql.append("MERGE INTO ").append(this.getEntityName(object)).append(" AS tgt").append(this.getLineSeparator());
        sql.append("USING SOURCE_TABLE AS src").append(this.getLineSeparator());
        Collection<? extends DBSEntityAttribute> keyAttributes = this.getKeyAttributes(monitor, object);
        if (!CommonUtils.isEmpty(keyAttributes)) {
            sql.append("ON (");
            for (DBSEntityAttribute dBSEntityAttribute : keyAttributes) {
                if (hasAttr) {
                    sql.append(" AND ");
                }
                sql.append("tgt.").append(DBUtils.getQuotedIdentifier((DBSObject)dBSEntityAttribute)).append("=src.").append(DBUtils.getQuotedIdentifier((DBSObject)dBSEntityAttribute));
                hasAttr = true;
            }
            sql.append(")\n");
        } else {
            sql.append("ON ('/* insert attributes equality here, e.g. tgt.ID = src.ID AND ... */')\n");
        }
        sql.append("WHEN MATCHED\nTHEN UPDATE SET").append(this.getLineSeparator());
        hasAttr = false;
        for (DBSAttributeBase dBSAttributeBase : this.getValueAttributes(monitor, object, keyAttributes)) {
            if (DBUtils.isPseudoAttribute((DBSAttributeBase)dBSAttributeBase) || DBUtils.isHiddenObject((Object)dBSAttributeBase) || dBSAttributeBase.isAutoGenerated()) continue;
            if (hasAttr) {
                sql.append(", ");
            }
            sql.append("tgt.").append(DBUtils.getQuotedIdentifier((DBPDataSource)object.getDataSource(), (String)dBSAttributeBase.getName())).append("=src.").append(DBUtils.getQuotedIdentifier((DBPDataSource)object.getDataSource(), (String)dBSAttributeBase.getName()));
            hasAttr = true;
        }
        sql.append(this.getLineSeparator()).append("WHEN NOT MATCHED").append(this.getLineSeparator()).append("THEN INSERT (");
        hasAttr = false;
        for (DBSEntityAttribute dBSEntityAttribute : this.getAllAttributes(monitor, object)) {
            if (DBUtils.isPseudoAttribute((DBSAttributeBase)dBSEntityAttribute) || DBUtils.isHiddenObject((Object)dBSEntityAttribute) || dBSEntityAttribute.isAutoGenerated()) continue;
            if (hasAttr) {
                sql.append(", ");
            }
            sql.append(DBUtils.getQuotedIdentifier((DBSObject)dBSEntityAttribute));
            hasAttr = true;
        }
        sql.append(")").append(this.getLineSeparator()).append("VALUES (");
        hasAttr = false;
        for (DBSEntityAttribute dBSEntityAttribute : this.getAllAttributes(monitor, object)) {
            if (DBUtils.isPseudoAttribute((DBSAttributeBase)dBSEntityAttribute) || DBUtils.isHiddenObject((Object)dBSEntityAttribute) || dBSEntityAttribute.isAutoGenerated()) continue;
            if (hasAttr) {
                sql.append(", ");
            }
            sql.append("src.").append(DBUtils.getQuotedIdentifier((DBSObject)dBSEntityAttribute));
            hasAttr = true;
        }
        sql.append(");\n");
    }
}

