/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.parser.rules;

import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.text.parser.TPCharacterScanner;
import org.jkiss.dbeaver.model.text.parser.TPToken;
import org.jkiss.dbeaver.model.text.parser.rules.MultiLineRule;

public class NestedMultiLineRule
extends MultiLineRule {
    private static final Log log = Log.getLog(NestedMultiLineRule.class);
    private int fNestingLevel;
    private boolean fRollback;

    public NestedMultiLineRule(String startSequence, String endSequence, TPToken token, char escapeCharacter, boolean breaksOnEOF) {
        super(startSequence, endSequence, token, escapeCharacter, breaksOnEOF);
    }

    @Override
    protected TPToken doEvaluate(TPCharacterScanner scanner, boolean resume) {
        this.fNestingLevel = 1;
        return super.doEvaluate(scanner, resume);
    }

    @Override
    protected boolean endSequenceDetected(TPCharacterScanner scanner) {
        int currentIndex = 0;
        int endSequenceIndex = 0;
        while (true) {
            int ch = scanner.read();
            if (this.fStartSequence.length > 0 && ch == this.fStartSequence[0]) {
                if (this.sequenceDetected(scanner, this.fStartSequence, this.fBreaksOnEOF)) {
                    ++this.fNestingLevel;
                }
            } else if (this.fEndSequence.length > 0 && ch == this.fEndSequence[0]) {
                if (this.sequenceDetected(scanner, this.fEndSequence, this.fBreaksOnEOF)) {
                    --this.fNestingLevel;
                    if (this.fNestingLevel > 0 && this.fRollback) {
                        endSequenceIndex = currentIndex;
                    }
                }
            } else if (ch == -1) {
                log.trace((Object)"Found unterminated start sequences after scanning");
                if (this.fRollback) {
                    while (currentIndex > endSequenceIndex) {
                        scanner.unread();
                        --currentIndex;
                    }
                }
                return true;
            }
            if (this.fNestingLevel <= 0) {
                return true;
            }
            ++currentIndex;
        }
    }

    public boolean isRollback() {
        return this.fRollback;
    }

    public void setRollback(boolean rollback) {
        this.fRollback = rollback;
    }
}

