/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tools.transfer.stream;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.fs.DBFUtils;
import org.jkiss.dbeaver.model.meta.DBSerializable;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableContext;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.task.DBTTask;
import org.jkiss.dbeaver.tools.transfer.IDataTransferConsumer;
import org.jkiss.dbeaver.tools.transfer.IDataTransferProcessor;
import org.jkiss.dbeaver.tools.transfer.IDataTransferProducer;
import org.jkiss.dbeaver.tools.transfer.registry.DataTransferNodeDescriptor;
import org.jkiss.dbeaver.tools.transfer.registry.DataTransferProcessorDescriptor;
import org.jkiss.dbeaver.tools.transfer.registry.DataTransferRegistry;
import org.jkiss.dbeaver.tools.transfer.serialize.DTObjectSerializer;
import org.jkiss.dbeaver.tools.transfer.serialize.SerializerContext;
import org.jkiss.dbeaver.tools.transfer.stream.IStreamDataImporter;
import org.jkiss.dbeaver.tools.transfer.stream.StreamDataImporterSite;
import org.jkiss.dbeaver.tools.transfer.stream.StreamEntityMapping;
import org.jkiss.dbeaver.tools.transfer.stream.StreamProducerSettings;
import org.jkiss.utils.CommonUtils;

@DBSerializable(value="streamTransferProducer")
public class StreamTransferProducer
implements IDataTransferProducer<StreamProducerSettings> {
    private static final Log log = Log.getLog(StreamTransferProducer.class);
    public static final String NODE_ID = "stream_producer";
    private final StreamEntityMapping entityMapping;
    private final DataTransferProcessorDescriptor defaultProcessor;

    public StreamTransferProducer() {
        this(null, null);
    }

    public StreamTransferProducer(@Nullable StreamEntityMapping entityMapping) {
        this(entityMapping, null);
    }

    public StreamTransferProducer(@Nullable StreamEntityMapping entityMapping, @Nullable DataTransferProcessorDescriptor defaultProcessor) {
        this.entityMapping = entityMapping;
        this.defaultProcessor = defaultProcessor;
    }

    public StreamEntityMapping getEntityMapping() {
        return this.entityMapping;
    }

    public StreamEntityMapping getDatabaseObject() {
        return this.entityMapping;
    }

    @Override
    @Nullable
    public DBPProject getProject() {
        DBPDataSourceContainer dsContainer = this.getDataSourceContainer();
        return dsContainer == null ? null : dsContainer.getProject();
    }

    @Override
    public DBPDataSourceContainer getDataSourceContainer() {
        return this.entityMapping == null ? null : this.entityMapping.getDataSource().getContainer();
    }

    @Override
    public String getObjectName() {
        return this.entityMapping == null ? null : this.entityMapping.getName();
    }

    @Override
    public String getObjectFullName(@NotNull DBRProgressMonitor monitor) throws IOException {
        Path inputFile = this.getInputFile();
        return inputFile == null ? "N/A" : DBFUtils.convertPathToString((Path)this.getInputFile());
    }

    @Override
    public DBPImage getObjectIcon() {
        if (this.defaultProcessor != null) {
            return this.defaultProcessor.getIcon();
        }
        return null;
    }

    @Override
    public String getObjectContainerName() {
        if (this.entityMapping == null) {
            return "";
        }
        Path inputFile = this.entityMapping.getInputFile();
        Path parent = inputFile.getParent();
        return parent == null ? inputFile.toAbsolutePath().toString() : parent.toAbsolutePath().toString();
    }

    @Override
    public DBPImage getObjectContainerIcon() {
        return DBIcon.TREE_FOLDER;
    }

    @Override
    public boolean isConfigurationComplete() {
        return this.entityMapping != null;
    }

    public Path getInputFile() {
        return this.entityMapping == null ? null : this.entityMapping.getInputFile();
    }

    @Override
    public void transferData(@NotNull DBRProgressMonitor monitor, @NotNull IDataTransferConsumer consumer, @Nullable IDataTransferProcessor processor, @NotNull StreamProducerSettings settings, @Nullable DBTTask task) throws DBException {
        DBSObject databaseObject = consumer.getDatabaseObject();
        boolean cfr_ignored_0 = databaseObject instanceof DBSEntity;
        if (processor == null) {
            throw new DBException("Stream data producer requires data processor");
        }
        Map<String, Object> processorProperties = settings.getProcessorProperties();
        StreamDataImporterSite site = new StreamDataImporterSite(settings, this.entityMapping, processorProperties);
        IStreamDataImporter importer = (IStreamDataImporter)processor;
        importer.init(site);
        try {
            try {
                Throwable throwable = null;
                Object var11_13 = null;
                try (InputStream is = Files.newInputStream(this.entityMapping.getInputFile(), new OpenOption[0]);){
                    importer.runImport(monitor, this.entityMapping.getDataSource(), is, consumer);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                if (e instanceof DBException) {
                    DBException dbe = (DBException)((Object)e);
                    throw dbe;
                }
                throw new DBException("IO error", (Throwable)e);
            }
        }
        finally {
            importer.dispose();
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof StreamTransferProducer) {
            return CommonUtils.equalObjects((Object)this.entityMapping, (Object)((StreamTransferProducer)obj).entityMapping);
        }
        return super.equals(obj);
    }

    public static class ObjectSerializer
    implements DTObjectSerializer<DBTTask, StreamTransferProducer> {
        @Override
        public void serializeObject(@NotNull DBRRunnableContext runnableContext, @NotNull DBTTask context, @NotNull StreamTransferProducer object, @NotNull Map<String, Object> state) throws DBException {
            StreamEntityMapping mapping = object.getEntityMapping();
            if (mapping == null) {
                throw new DBException("Task configuration incomplete: source file not specified");
            }
            state.put("file", DBFUtils.getUriFromPath((Path)mapping.getInputFile()));
            state.put("name", mapping.getEntityName());
            state.put("child", mapping.isChild());
            if (object.defaultProcessor != null) {
                state.put("node", object.defaultProcessor.getNode().getId());
                state.put("processor", object.defaultProcessor.getId());
            }
        }

        @Override
        public StreamTransferProducer deserializeObject(@NotNull DBRRunnableContext runnableContext, @NotNull SerializerContext serializeContext, @NotNull DBTTask objectContext, @NotNull Map<String, Object> state) throws DBException {
            String nodeId = CommonUtils.toString((Object)state.get("node"));
            String processorId = CommonUtils.toString((Object)state.get("processor"));
            DataTransferProcessorDescriptor processor = null;
            if (!CommonUtils.isEmpty((String)nodeId) && !CommonUtils.isEmpty((String)processorId)) {
                DataTransferNodeDescriptor nodeDesc = DataTransferRegistry.getInstance().getNodeById(nodeId);
                if (nodeDesc == null) {
                    log.warn((Object)("Stream producer node " + nodeId + " not found"));
                } else {
                    processor = nodeDesc.getProcessor(processorId);
                    if (processor == null) {
                        log.warn((Object)("Stream processor " + processorId + " not found"));
                    }
                }
            }
            return new StreamTransferProducer(new StreamEntityMapping(DBFUtils.resolvePathFromString((DBRRunnableContext)runnableContext, (DBPProject)objectContext.getProject(), (String)CommonUtils.toString((Object)state.get("file"))), CommonUtils.toString((Object)state.get("name")), CommonUtils.toBoolean((Object)state.get("child"))), processor);
        }
    }
}

