/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.internal.ui.palette.editparts;

import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ButtonModel;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.ImageFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.Toggle;
import org.eclipse.gef.internal.InternalImages;
import org.eclipse.gef.ui.palette.PaletteColorProvider;
import org.eclipse.gef.ui.palette.PaletteMessages;

public class PinFigure
extends Toggle {
    private static final Border TOOLTIP_BORDER = new MarginBorder(0, 2, 1, 0);
    private final PaletteColorProvider colorProvider;

    public PinFigure(PaletteColorProvider colorProvider) {
        super((IFigure)new ImageFigure(InternalImages.get("icons/unpinned.svg")));
        this.colorProvider = colorProvider;
        this.setRolloverEnabled(true);
        this.setRequestFocusEnabled(false);
        Label tooltip = new Label(PaletteMessages.TOOLTIP_PIN_FIGURE);
        tooltip.setBorder(TOOLTIP_BORDER);
        this.setToolTip((IFigure)tooltip);
        this.setOpaque(false);
        this.addChangeListener(e -> {
            if (e.getPropertyName().equals("selected")) {
                if (this.isSelected()) {
                    this.getImageFigure().setImage(InternalImages.get("icons/pinned.svg"));
                    this.getToolTip().setText(PaletteMessages.TOOLTIP_UNPIN_FIGURE);
                } else {
                    ((ImageFigure)this.getChildren().get(0)).setImage(InternalImages.get("icons/unpinned.svg"));
                    this.getToolTip().setText(PaletteMessages.TOOLTIP_PIN_FIGURE);
                }
            }
        });
    }

    public Label getToolTip() {
        return (Label)super.getToolTip();
    }

    protected void paintFigure(Graphics graphics) {
        super.paintFigure(graphics);
        ButtonModel model = this.getModel();
        if (this.isRolloverEnabled() && model.isMouseOver()) {
            graphics.setBackgroundColor(this.colorProvider.getHotspotColor());
            graphics.fillRoundRectangle(this.getClientArea().getCopy().shrink(1, 1), 3, 3);
        }
    }

    private ImageFigure getImageFigure() {
        return (ImageFigure)this.getChildren().get(0);
    }
}

