/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.altibase.ui.editors;

import java.util.HashMap;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbenchPart;
import org.jkiss.dbeaver.ext.altibase.model.AltibaseDataSource;
import org.jkiss.dbeaver.ext.altibase.model.session.AltibaseServerSession;
import org.jkiss.dbeaver.ext.altibase.model.session.AltibaseServerSessionManager;
import org.jkiss.dbeaver.ext.altibase.ui.internal.AltibaseUIMessages;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.admin.sessions.DBAServerSession;
import org.jkiss.dbeaver.model.admin.sessions.DBAServerSessionManager;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.dialogs.ConfirmationDialog;
import org.jkiss.dbeaver.ui.views.session.AbstractSessionEditor;
import org.jkiss.dbeaver.ui.views.session.SessionManagerViewer;

public class AltibaseSessionEditor
extends AbstractSessionEditor {
    private DisconnectSessionAction disconnectSessionAction;

    public void createEditorControl(Composite parent) {
        this.disconnectSessionAction = new DisconnectSessionAction();
        super.createEditorControl(parent);
    }

    protected SessionManagerViewer createSessionViewer(DBCExecutionContext executionContext, Composite parent) {
        return new SessionManagerViewer<AltibaseServerSession>((IWorkbenchPart)this, parent, (DBAServerSessionManager)new AltibaseServerSessionManager((AltibaseDataSource)executionContext.getDataSource())){

            protected void contributeToToolbar(DBAServerSessionManager sessionManager, IContributionManager contributionManager) {
                contributionManager.add((IAction)AltibaseSessionEditor.this.disconnectSessionAction);
                contributionManager.add((IContributionItem)new Separator());
            }

            protected void onSessionSelect(DBAServerSession session) {
                super.onSessionSelect(session);
                AltibaseSessionEditor.this.disconnectSessionAction.setEnabled(session != null);
            }
        };
    }

    private class DisconnectSessionAction
    extends Action {
        DisconnectSessionAction() {
            super(AltibaseUIMessages.editors_altibase_session_editor_action_disconnect_session, DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.SQL_DISCONNECT));
        }

        public void run() {
            List sessions = AltibaseSessionEditor.this.getSessionsViewer().getSelectedSessions();
            String action = AltibaseUIMessages.editors_altibase_session_editor_action_disconnect_session;
            ConfirmationDialog dialog = new ConfirmationDialog(AltibaseSessionEditor.this.getSite().getShell(), action, null, NLS.bind((String)AltibaseUIMessages.editors_altibase_session_editor_confirm_action, (Object)action.toLowerCase(), (Object)sessions), 5, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 0, null, false);
            if (dialog.open() == 2) {
                HashMap options = new HashMap();
                AltibaseSessionEditor.this.getSessionsViewer().alterSessions(sessions, options);
            }
            AltibaseSessionEditor.this.refreshPart((Object)AltibaseSessionEditor.this, true);
        }
    }
}

