/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.tools.fdw;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataSource;
import org.jkiss.dbeaver.ext.postgresql.tools.fdw.PostgreFDWConfigWizard;
import org.jkiss.dbeaver.model.DBPContextProvider;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.exec.DBExecUtils;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.ui.UIServiceSQL;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.ActiveWizardPage;
import org.jkiss.dbeaver.ui.dialogs.DialogUtils;
import org.jkiss.utils.IOUtils;

class PostgreFDWConfigWizardPageFinal
extends ActiveWizardPage<PostgreFDWConfigWizard> {
    private static final Log log = Log.getLog(PostgreFDWConfigWizardPageFinal.class);
    private boolean activated;
    private Object sqlPanel;
    private String scriptText;

    protected PostgreFDWConfigWizardPageFinal(PostgreFDWConfigWizard wizard) {
        super("Script");
        this.setTitle("Foreign wrappers mapping SQL script");
        this.setDescription("Preview script and perform install");
        this.setWizard((IWizard)wizard);
    }

    public boolean isPageComplete() {
        return this.activated && this.getErrorMessage() == null;
    }

    public void createControl(Composite parent) {
        Composite composite = UIUtils.createComposite((Composite)parent, (int)1);
        Composite settingsGroup = UIUtils.createTitledComposite((Composite)composite, (String)"Script", (int)1, (int)1808);
        Composite sqlPanelPH = new Composite(settingsGroup, 0);
        sqlPanelPH.setLayoutData((Object)new GridData(1808));
        sqlPanelPH.setLayout((Layout)new FillLayout());
        UIServiceSQL service = (UIServiceSQL)DBWorkbench.getService(UIServiceSQL.class);
        if (service != null) {
            try {
                this.sqlPanel = service.createSQLPanel((Object)UIUtils.getActiveWorkbenchWindow().getActivePage().getActivePart().getSite(), (Object)sqlPanelPH, (DBPContextProvider)this.getWizard(), "FDW Script", true, "");
            }
            catch (DBException e) {
                log.debug((Object)e);
                this.setErrorMessage(e.getMessage());
            }
        }
        final Composite buttonsPanel = UIUtils.createComposite((Composite)settingsGroup, (int)2);
        buttonsPanel.setLayoutData((Object)new GridData(768));
        UIUtils.createDialogButton((Composite)buttonsPanel, (String)"Copy", (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UIUtils.setClipboardContents((Display)buttonsPanel.getDisplay(), (Transfer)TextTransfer.getInstance(), (Object)PostgreFDWConfigWizardPageFinal.this.scriptText);
            }
        });
        UIUtils.createDialogButton((Composite)buttonsPanel, (String)"Save ...", (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                File saveFile = DialogUtils.selectFileForSave((Shell)buttonsPanel.getShell(), (String)"Save SQL script", (String[])new String[]{"*.sql", "*.txt", "*", "*.*"}, null);
                if (saveFile != null) {
                    try {
                        IOUtils.writeFileFromString((File)saveFile, (String)PostgreFDWConfigWizardPageFinal.this.scriptText);
                    }
                    catch (IOException e1) {
                        DBWorkbench.getPlatformUI().showError("Save scritp to file", "Error saving script to file " + saveFile.getAbsolutePath(), (Throwable)e1);
                    }
                }
            }
        });
        this.setControl((Control)composite);
    }

    public void activatePage() {
        if (!this.activated) {
            this.activated = true;
        }
        this.generateScript();
        super.activatePage();
    }

    private void generateScript() {
        StringBuilder script = new StringBuilder();
        try {
            PostgreDataSource dataSource = ((PostgreFDWConfigWizard)this.getWizard()).getDatabase().getDataSource();
            ((PostgreFDWConfigWizard)this.getWizard()).getRunnableContext().run(true, true, monitor -> {
                try {
                    DBExecUtils.tryExecuteRecover((Object)monitor, (DBPDataSource)dataSource, param -> {
                        monitor.beginTask("Generate FDW script", 2);
                        monitor.subTask("Read actions");
                        List<DBEPersistAction> actions = ((PostgreFDWConfigWizard)this.getWizard()).generateScript(monitor);
                        monitor.subTask("Generate script");
                        script.append(SQLUtils.generateScript((DBPDataSource)dataSource, (DBEPersistAction[])actions.toArray(new DBEPersistAction[0]), (boolean)false));
                        monitor.done();
                    });
                }
                catch (DBException e) {
                    throw new InvocationTargetException(e);
                }
            });
        }
        catch (InvocationTargetException e) {
            log.debug((Object)e.getTargetException());
            this.setErrorMessage(e.getTargetException().getMessage());
            return;
        }
        catch (InterruptedException interruptedException) {
            return;
        }
        this.setErrorMessage(null);
        this.scriptText = script.toString();
        UIServiceSQL service = (UIServiceSQL)DBWorkbench.getService(UIServiceSQL.class);
        if (service != null) {
            service.setSQLPanelText(this.sqlPanel, this.scriptText);
        }
    }
}

